/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WAVECANVAS_H
#define WAVECANVAS_H


#include <qcanvas.h>
#include <qpainter.h>
#include <qimage.h>
#include <qpicture.h>
#include <sndfile.h>
#include <qapplication.h>
#include <qeventloop.h>
#include <qmutex.h>
#include "soundmanager.h"
#include "defs.h"
#include "mymath.h"
/**
@author Predrag Viceic
\class WaveCanvas
\brief Implements the render of the wave file in amplitude domain and as spectrogram
*/
class WaveCanvas : public QCanvas
{
public:
    WaveCanvas(QWidget*);
    ~WaveCanvas();


    void setZoomRatio(long);
    void setSoundManager(SoundManager*);
    void setBgColor(int r, int g, int b);
    void hasRuler(bool);
    int getRulerHeight();
    void forceRepaint();
    void forceRepaint(long,long);
    void changeViewMode(int);
    void drawWave(long,long);
    void drawSpectrum(long,long);
    void setPixmapXOrigin(int);
    bool hasPixmap();
    void setVisibleWidth(int w);
    void emptyBuffers();

    /** \enum possible view modes */
    enum viewmodes {WAVE_VIEWMODE,SPECTRUM_VIEWMODE};
    int viewMode; /**< current view mode \sa WaveCanvas#viewmodes */

    struct maxAndMin{
        float max;
        float min;
        int hasValue;
    };

    struct spectrogramMax{
        float* max;
        int hasValue;
    };

public slots:
        void zapBuffers();
    void zapBuffers(long start, long end);


protected:
    void drawBackground ( QPainter & localpainter, const QRect & clip );
    void drawBackgroundImage (long,long);
    long zoomRatio; /**< current zoom ratio*/
    SoundManager* soundManager;
    QColor bgColor; /**< current wave background color*/
    QColor spectrumBgColor; /**< current spectrogram background color*/
    bool _hasRuler; /**< should this canvas draw a ruler?*/
    bool drawing;
    int pixmapXOrigin; /**< holds the first visible pixel x coord*/
    int visibleWidth;
private:
    long maxZoomRatio; /**< used for ruler coord system*/
    QImage* background;
    QPixmap* backgroundPix;
    bool hasPixmapV;
    maxAndMin* leftMaximaBuffer;
    maxAndMin* rightMaximaBuffer;
    long maxBufferNbValues;
    spectrogramMax* spectrogramMaxBuffer;
    long spectrogramMaxBufferNbValues;

};

#endif
