/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "drawallsoundwidget.h"

DrawAllSoundWidget::DrawAllSoundWidget(QWidget *parent, const char *name, SoundManager* sm)
 : DrawSoundWidgetAbstract(parent, name,sm)
{
    setHScrollBarMode(AlwaysOff);
    canvas->setBgColor(255,255,200);
    view=new SelectionRectangle(0,0,0,visibleWidth(),visibleHeight(),canvas,TRUE);
    view->setEndSamplePosition(soundManager->getFrames());
    view->setDrawHandles(FALSE);

    view->show();
    canvas->update();
    viewport()->setMouseTracking(TRUE);
    savedRelativeSamplePos=0;  //tracks mouse click inside view area
    dontChangeViewOnNextSignal=false;
}

DrawAllSoundWidget::~DrawAllSoundWidget()
{
}

void DrawAllSoundWidget::zoomChanged(){
    updateCanvas=true;
    updateViewWindow();
}

void DrawAllSoundWidget::resized(){
    updateViewWindow();
}

void DrawAllSoundWidget::fileLoaded()
{
    view->setStartSamplePosition(0);
    view->setEndSamplePosition(soundManager->getFrames());
    updateViewWindow();
}

void DrawAllSoundWidget::updateViewWindow(){
    if(soundManager->hasSound() && getZoomRatio()>=1){
        view->setX(view->getStartSamplePosition()/getZoomRatio());
        view->setY(0);
        int newWidth=(view->getEndSamplePosition()-view->getStartSamplePosition())/getZoomRatio();
        view->setSize(newWidth,contentsHeight());
    }
    canvas->update();
}




/*!
    \fn DrawAllSoundWidget::getViewWindow()
 */
SelectionRectangle* DrawAllSoundWidget::getViewWindow()
{
    return view;
}

void DrawAllSoundWidget::visibleAreaChanged(long start_sample, long end_sample){

    if(!dontChangeViewOnNextSignal){
        view->setStartSamplePosition(start_sample);
        view->setEndSamplePosition(end_sample);
        updateViewWindow();
    }else{
        dontChangeViewOnNextSignal=false;
    }
}


/*!
    \fn DrawAllSoundWidget::zoomAll()
 */
void DrawAllSoundWidget::zoomAll()
{
    cout<<"in "<<name()<<": zoomAll("<<")\n";
    zoomToSamplePos(0,soundManager->getFrames());
}


void DrawAllSoundWidget::contentsMouseMoveEvent( QMouseEvent * mouseEvent){
        QPoint pos=mouseEvent->pos();
        int pos_x=pos.x();
        pos_x=pos_x<contentsX()?contentsX():pos_x>contentsX()+visibleWidth()?contentsX()+visibleWidth():pos_x;
        long sample_pos=pos_x*getZoomRatio();
        sample_pos=sample_pos>soundManager->getFrames()?soundManager->getFrames():sample_pos;
        sample_pos=sample_pos<0?0:sample_pos;
        long sample_width=view->getEndSamplePosition()-view->getStartSamplePosition();
        long relativeSamplePosition=sample_pos-savedRelativeSamplePos;
        if(view->getResizing()){
                //resizing view to the right
                setCursor(QCursor(Qt::SizeHorCursor));
                view->setEndSamplePosition(sample_pos);
                //view->setSize(pos_x-view->x(),canvas->height());
                updateViewWindow();
        }else if(view->getLeftSideResizing()){
                //resizing view to the left
                setCursor(QCursor(Qt::SizeHorCursor));
                view->setStartSamplePosition(sample_pos);
                //view->setSize(view->width()+view->x()-pos_x,canvas->height());
                updateViewWindow();
        }else if(view->getMoving()){
            //moving view
            setCursor(QCursor(Qt::SizeAllCursor ));
            long start_sample_pos=relativeSamplePosition;
            long end_sample_pos=relativeSamplePosition+sample_width;
            if(start_sample_pos>=0 && end_sample_pos<=soundManager->getFrames()){
                view->setStartSamplePosition(checkSamplePosition(start_sample_pos));
                view->setEndSamplePosition(checkSamplePosition(end_sample_pos));
            }
            updateViewWindow();
            //emit(visibleAreaChangedS(view->getStartSamplePosition(),view->getEndSamplePosition()));
        }else if(((abs(pos_x-view->x())<5) ||
                        (abs(pos_x-(view->x()+abs(view->width())))<5))){
                        //adjusting view
            setCursor(QCursor(Qt::SizeHorCursor));
         }else if(pos_x>view->x()+10 && pos_x<view->x()+abs(view->width())-10){
             //moving view
            setCursor(QCursor(Qt::SizeAllCursor ));
         }
         else{
             setCursor(QCursor(Qt::ArrowCursor ));
         }
   }

  void DrawAllSoundWidget::contentsMousePressEvent( QMouseEvent * mouseEvent){
        QPoint pos=mouseEvent->pos();
        int pos_x=pos.x();
        long sample_pos=pos.x()*getZoomRatio();
        savedRelativeSamplePos=sample_pos-view->getStartSamplePosition();
        if (mouseEvent->button()==LeftButton){
                if(pos_x>view->x()+10 && pos_x<view->x()+abs(view->width())-10){
                     //moving selection
                     view->setMoving(true);
                 }else if(((abs(pos_x-view->x())<5) ||
                        (abs(pos_x-(view->x()+abs(view->width())))<5))){
                        //adjusting selection
                        if(abs(pos_x-view->x())<5){
                            view->setLeftSideResizing(true);
                        }else if(abs(pos_x-(view->x()+abs(view->width())))<5){
                            view->setResizing(true);
                        }
                 }
        }
 }

 void DrawAllSoundWidget::contentsMouseReleaseEvent( QMouseEvent * mouseEvent){
    if (mouseEvent->button()==LeftButton){
            QPoint pos=mouseEvent->pos();
            if(view->getResizing() || view->getLeftSideResizing()|| view->getMoving()){
                view->setResizing(FALSE);
                view->setLeftSideResizing(FALSE);
                view->setMoving(FALSE);
                dontChangeViewOnNextSignal=true;
                emit(visibleAreaChangedS(view->getStartSamplePosition(),view->getEndSamplePosition()));
            }
        }
    setCursor(QCursor(Qt::Qt::ArrowCursor ));
 }

 int DrawAllSoundWidget::minimumWidth () const{
     return 200;
 }

 QSize DrawAllSoundWidget::sizeHint () const{
     return QSize(600,80);
 }

/*!
    \fn DrawAllSoundWidget::cropped()
 */
void DrawAllSoundWidget::cropped()
{
    /*
    view->setStartSamplePosition(0);
    view->setEndSamplePosition(soundManager->getFrames());
    updateViewWindow();
    */
    zoomAll();
    //forceRepaint(0,soundManager->getFrames());
}
