/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "envelopeholder.h"

EnvelopeHolder::EnvelopeHolder(QWidget *parent, const char *name)
 : QScrollView(parent, name)
{
    setAcceptDrops(TRUE);
    frames=0;
    zoomRatio=1;
    setVScrollBarMode(AlwaysOff);
    setHScrollBarMode(AlwaysOff);
    enableClipper(TRUE);
}


EnvelopeHolder::~EnvelopeHolder()
{
}

void EnvelopeHolder::dragEnterEvent(QDragEnterEvent* event)
{
    event->accept(
            QTextDrag::canDecode(event));
}

void EnvelopeHolder::dropEvent(QDropEvent* event)
{
    QString text;

    if ( QTextDrag::decode(event, text) ) {
        setEnvelopeAt(event->pos(),text);
    }
}





/*!
    \fn EnvelopeHolder::setEnvelopeAt(QPoint pos,QString envData)
 */
void EnvelopeHolder::setEnvelopeAt(QPoint pos,QString envData)
{
    cout<<"dropped envelope: "<<envData<<endl;
    if(isHidden()) show();
    EnvelopeControllerWidget* w=new EnvelopeControllerWidget(viewport());
    w->setData(envData);
    w->setFixedHeight(50);
    w->setFixedWidth(280);
    envelopes.append(w);
    int x=contentsX()+pos.x();
    long sample_pos=x*zoomRatio;
    w->setStartFrame(sample_pos);
    addChild(w,x,contentsY());
    w->setInHolder(TRUE);
    w->show();
}

/*!
    \fn EnvelopeHolder::setZoomRatio(long)
 */
void EnvelopeHolder::setZoomRatio(long _zr)
{
    zoomRatio=_zr;
    resizeContents((int)((double)frames/(double)zoomRatio),visibleHeight());
    drawEnvelopes();
    repaint();
}

void EnvelopeHolder::setFrames(long _fr){
    frames=_fr;
}


/*!
    \fn EnvelopeHolder::drawEnvelopes()
 */
void EnvelopeHolder::drawEnvelopes()
{
    QPtrListIterator <EnvelopeControllerWidget> it( envelopes );
    EnvelopeControllerWidget *env;
    while ( (env = it.current()) != 0 ) {
        ++it;
        moveChild(env,env->getStartFrame()/zoomRatio,contentsY());
    }
}
