/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LADSPAEFFECTS_H
#define LADSPAEFFECTS_H

#include <qobject.h>
#include <qptrlist.h>
#include <iostream>
#include "ladspaeffect.h"
#include <qdir.h>
#include <qstringlist.h>
/**
@author Predrag Viceic
*/
class LADSPAEffects : public QObject
{
Q_OBJECT
public:
    LADSPAEffects(QObject *parent = 0, const char *name = 0);

    ~LADSPAEffects();
    void loadEffects(QString);
    QPtrList <LADSPAEffect>* getEffects();
    LADSPAEffect* getEffect(int);
    LADSPAEffect* getCurrent();
    void setCurrent(LADSPAEffect* eff);
    LADSPAEffect* currentEffect;

private:
    QPtrList <LADSPAEffect> availableLadspaEffects;

public slots:
    void setNbFrames(long);

};

#endif
