/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LADSPAPORT_H
#define LADSPAPORT_H

#include <qobject.h>
#include <qstring.h>
#include <ladspa.h>
#include <limits.h>
#include <float.h>
#include <iostream.h>
/**
@author Predrag Viceic
*/
class LADSPAPort : public QObject
{
Q_OBJECT
public:
    LADSPAPort(int,QString,LADSPA_PortDescriptor,LADSPA_PortRangeHint,QObject *parent = 0, const char *name = 0);

    ~LADSPAPort();
    bool isAudioInput();
    bool isAudioOutput();
    bool isControlInput();
    bool isControlOutput();
    void initInputControlPort();
    float getLowerBound();
    float getUpperBound();
    void setControlInputValue(float);
    int getPortNumber();
    float* getCPortValuePointer();
    QString getPortName();
    void setValuesOverTime(float*);
    void advanceValue();
    void startValue();
    void startValue(int);
    void setNbFrames(long);
    long getNbFrames();
    float* getVOTPointer(long);
    void initControlValues();
    bool areBoundsOk();
    int getConnectionMethod();
    int getConnectionMethodDouble();
    enum ConnectionMethod
    {CONNECTION_METHOD_LR,CONNECTION_METHOD_L,CONNECTION_METHOD_R,CONNECTION_METHOD_ZERO};
    void setConnectionMethodDouble(ConnectionMethod m);
    void setConnectionMethod(ConnectionMethod m);
    void initControlValues(QValueList<float> vals);
    QValueList<float> getPortControlValues();

private:
    LADSPA_PortDescriptor descriptor;
    LADSPA_PortRangeHint hint;
    QString portname;
    int portNumber;
    int count;

protected:
    float val;
    float* valuesOverTime;
    long nbFrames;
    int connectionMethod;
    int connectionMethodDouble;
    int nbValues;
public slots:
    void setConnectionMethod(const QString&);
    void setConnectionMethodDouble(const QString&);
};

#endif
