/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LOOPMARKER_H
#define LOOPMARKER_H

#include <qcanvas.h>
#include <qpainter.h>
#include <qpointarray.h>
#include "defs.h"

/**
@author Predrag Viceic
*/
class LoopMarker : public QCanvasPolygonalItem
{
public:
    enum MarkerOrientation {LEFT_MARKER,RIGHT_MARKER};
    int side;
    LoopMarker(QCanvas*,int);
    ~LoopMarker();
    void drawShape ( QPainter & p );
    QPointArray areaPoints() const;
    void setSamplePosition(long);
    long getSamplePosition();
    int rtti() const;
    void setMoving(bool);
    bool getMoving();
    void setSide(int);
    bool operator<(LoopMarker*);
    bool operator>(LoopMarker*);
    bool operator==(LoopMarker*);
private:
    long samplePos;
protected:
    bool moving;
};

#endif
