/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MIDIOUTPUT_H
#define MIDIOUTPUT_H

#include "defs.h"
#include <qobject.h>
#include <alsa/asoundlib.h>

#define TICKS_PER_QUARTER 120
#define SEQPOOL 1024


/**
@author Predrag Viceic
*/
class MidiOutput : public QObject
{
Q_OBJECT
public:
    MidiOutput(QObject *parent = 0, const char *name = 0);

    ~MidiOutput();
    void doLoop();

    float bpm;

private:
    int portid_in;
    snd_seq_t *seq_handle;
    snd_seq_tick_time_t tick;
    int clientid;
    int portid_out;
    int queue_id;
    snd_seq_tick_time_t get_tick();
    void setQueueTempo(float bpm);

public slots:
    void startQueue();
    void stopQueue();
    void continueQueue();
    void setTempo(float tempo);

};



#endif
