/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef POLYLINE_H
#define POLYLINE_H

#include <qcanvas.h>
#include "defs.h"
#include "sortablepoint.h"
#include "qpainter.h"
#include "mymath.h"

/**
@author Predrag Viceic
*/
class PolyLine : public QCanvasPolygon
{
public:
    PolyLine(QCanvas* canvas);
    int rtti() const;

    ~PolyLine();
    virtual void addPoint(QPoint p,long sample_pos,float value);
    virtual void removePoint(QPoint p);
    virtual void moveSelectedPoint(QPoint to, long sample_pos,float value);
    virtual QPointArray areaPoints () const;
    virtual void deselectAll();
    virtual int getYAtX(int x);
    virtual float getValueAtSample(long sample);
    virtual QRect boundingRect();
    virtual int count();
    virtual void clear();
    virtual void updateSize(QSize size);
    virtual int containsSameX(QPoint p);
    virtual QPointArray toPointArray();
    QValueList <SortablePoint> getSortablePoints();
    void setSortablePoints(QValueList<SortablePoint>);
    void setMinValue(float m);
    void setMaxValue(float m);
    int valToYPos(float val);
    void setZoomRatio(long zr);
    /*
    void setEndSample(long e);
    void setStartSample(long s);
    float getValueAtSample(long sample);
    void setEndValue(float ev);
    void setStartValue(float sv);
*/

protected:
    QValueList <SortablePoint> points;
    float maxValue;
    float minValue;
    long zoomRatio;
    virtual void drawShape ( QPainter & p );


};

#endif
