/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PROJECTMANAGER_H
#define PROJECTMANAGER_H

#include <qobject.h>
#include "qdom.h"
#include "effectframe.h"
#include "soundmanager.h"
#include "envelopedata.h"
#include "defs.h"
#include "ladspaeffect.h"
#include "ladspaport.h"
#include "polyline.h"
#include "splineline.h"
#include "qprocess.h"
#include "qdict.h"
#include "qmessagebox.h"
#include "loopmarker.h"


/**
@author Predrag Viceic
*/
class ProjectManager : public QObject
{
Q_OBJECT
public:
    ProjectManager(SoundManager* sm,EnvelopeData* ed,
                                    QObject *parent = 0, const char *name = 0);

    ~ProjectManager();
    void saveProject();
    void setFilename(QString fn);
    void setLockedBeatLines(QValueList<long> lbl);
    static QDomNode envelopeToXML(EnvelopeData* envData);
    static QDomNode lockedBLToXML(QValueList <long> lockedBL);
    QDomNode ladspaToXML(EffectFrame* ef);
    void setLadspa(EffectFrame* ef);
    void loadProject(QString filename);
    static void xmlToEnvelope(QDomNode xml, EnvelopeData* envData);
    void xmlToLADSPA(QDomNode xml);
    void xmlToLBL(QDomNode xml);
    QValueList <SortablePoint> xmlToPolylineData(QDomNode xml);
    QValueList<SplinePoint> xmlToSplineData(QDomNode xml);


    typedef QMap<long, QValueList <SortablePoint> > polylinesMapT;
    typedef QMap<long, QValueList <SplinePoint> > splinesMapT;

    polylinesMapT getPolylines();
    splinesMapT getSplines();
    void clearPolylinesSplines();
    void setLoopMarkers(LoopMarker* l, LoopMarker* r);
    static QDomNode loopMarkersToXML(LoopMarker* l, LoopMarker* r);
    void xmlToLoopMarkers(QDomNode xml,LoopMarker* l, LoopMarker* r);


protected:
    EffectFrame* effectFrame;
    SoundManager* soundManager;
    QValueList<long> lockedBeatLines;
    EnvelopeData* envelopeData;
    QString filename;
    polylinesMapT polylinesMap;
    splinesMapT splinesMap;
    LoopMarker* leftLoopMarker;
    LoopMarker* rightLoopMarker;
public slots:
    QStringList saveWaveBuffers();
signals:
    void loadFile(const QString& fname);
    void envelopeDataChanged();
    void addLadspa(int uid);
    void addLockedBeatlines(QValueList<long>);
    void setPolylineData(int, QValueList<SortablePoint>);
};

#endif
