!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRd0i0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2E*VRR0(5,23)
      V(2)=3.D0*V(1)
      V(3)=r1x2E*ZxZpE*VRR1(5,23)
      V(4)=-3.D0*V(3)
      V(5)=r1x2E*VRR0(5,24)
      V(6)=HfxZpE*VRR1(2,39)
      V(7)=r1x2E*ZxZpE*VRR1(5,24)
      V(8)=r1x2E*VRR0(5,27)
      V(9)=r1x2E*ZxZpE*VRR1(5,27)
      V(10)=r1x2E*VRR0(5,28)
      V(11)=2.D0*V(10)
      V(12)=HfxZpE*VRR1(2,44)
      V(13)=r1x2E*ZxZpE*VRR1(5,28)
      V(14)=-2.D0*V(13)
      V(15)=2.D0*V(8)
      V(16)=-2.D0*V(9)
      V(17)=r1x2E*VRR0(5,30)
      V(18)=3.D0*V(17)
      V(19)=r1x2E*ZxZpE*VRR1(5,30)
      V(20)=-3.D0*V(19)
      V(21)=r1x2E*VRR0(5,31)
      V(22)=2.D0*V(21)
      V(23)=HfxZpE*VRR1(2,48)
      V(24)=r1x2E*ZxZpE*VRR1(5,31)
      V(25)=-2.D0*V(24)
      V(26)=r1x2E*VRR0(5,32)
      V(27)=HfxZpE*VRR1(2,49)
      V(28)=r1x2E*ZxZpE*VRR1(5,32)
      V(29)=3.D0*V(26)
      V(30)=-3.D0*V(28)
      V(31)=r1x2E*VRR0(5,33)
      V(32)=HfxZpE*VRR1(2,51)
      V(33)=r1x2E*ZxZpE*VRR1(5,33)
      V(34)=r1x2E*VRR0(5,34)
      V(35)=r1x2E*ZxZpE*VRR1(5,34)
      V(36)=r1x2E*VRR0(6,23)
      V(37)=3.D0*V(36)
      V(38)=r1x2E*ZxZpE*VRR1(6,23)
      V(39)=-3.D0*V(38)
      V(40)=r1x2E*VRR0(6,24)
      V(41)=HfxZpE*VRR1(3,39)
      V(42)=r1x2E*ZxZpE*VRR1(6,24)
      V(43)=r1x2E*VRR0(6,27)
      V(44)=r1x2E*ZxZpE*VRR1(6,27)
      V(45)=r1x2E*VRR0(6,28)
      V(46)=2.D0*V(45)
      V(47)=HfxZpE*VRR1(3,44)
      V(48)=r1x2E*ZxZpE*VRR1(6,28)
      V(49)=-2.D0*V(48)
      V(50)=2.D0*V(43)
      V(51)=-2.D0*V(44)
      V(52)=r1x2E*VRR0(6,30)
      V(53)=3.D0*V(52)
      V(54)=r1x2E*ZxZpE*VRR1(6,30)
      V(55)=-3.D0*V(54)
      V(56)=r1x2E*VRR0(6,31)
      V(57)=2.D0*V(56)
      V(58)=HfxZpE*VRR1(3,48)
      V(59)=r1x2E*ZxZpE*VRR1(6,31)
      V(60)=-2.D0*V(59)
      V(61)=r1x2E*VRR0(6,32)
      V(62)=HfxZpE*VRR1(3,49)
      V(63)=r1x2E*ZxZpE*VRR1(6,32)
      V(64)=3.D0*V(61)
      V(65)=-3.D0*V(63)
      V(66)=r1x2E*VRR0(6,33)
      V(67)=HfxZpE*VRR1(3,51)
      V(68)=r1x2E*ZxZpE*VRR1(6,33)
      V(69)=r1x2E*VRR0(6,34)
      V(70)=HfxZpE*VRR1(2,53)
      V(71)=r1x2E*ZxZpE*VRR1(6,34)
      V(72)=r1x2E*VRR0(7,23)
      V(73)=3.D0*V(72)
      V(74)=r1x2E*ZxZpE*VRR1(7,23)
      V(75)=-3.D0*V(74)
      V(76)=r1x2E*VRR0(7,24)
      V(77)=r1x2E*ZxZpE*VRR1(7,24)
      V(78)=r1x2E*VRR0(7,27)
      V(79)=r1x2E*ZxZpE*VRR1(7,27)
      V(80)=r1x2E*VRR0(7,28)
      V(81)=2.D0*V(80)
      V(82)=r1x2E*ZxZpE*VRR1(7,28)
      V(83)=-2.D0*V(82)
      V(84)=2.D0*V(78)
      V(85)=-2.D0*V(79)
      V(86)=r1x2E*VRR0(7,30)
      V(87)=3.D0*V(86)
      V(88)=r1x2E*ZxZpE*VRR1(7,30)
      V(89)=-3.D0*V(88)
      V(90)=r1x2E*VRR0(7,31)
      V(91)=2.D0*V(90)
      V(92)=r1x2E*ZxZpE*VRR1(7,31)
      V(93)=-2.D0*V(92)
      V(94)=r1x2E*VRR0(7,32)
      V(95)=r1x2E*ZxZpE*VRR1(7,32)
      V(96)=3.D0*V(94)
      V(97)=-3.D0*V(95)
      V(98)=r1x2E*VRR0(7,33)
      V(99)=r1x2E*ZxZpE*VRR1(7,33)
      V(100)=r1x2E*VRR0(7,34)
      V(101)=HfxZpE*VRR1(3,53)
      V(102)=r1x2E*ZxZpE*VRR1(7,34)
      V(103)=r1x2E*VRR0(8,23)
      V(104)=3.D0*V(103)
      V(105)=r1x2E*ZxZpE*VRR1(8,23)
      V(106)=-3.D0*V(105)
      V(107)=r1x2E*VRR0(8,24)
      V(108)=HfxZpE*VRR1(4,39)
      V(109)=r1x2E*ZxZpE*VRR1(8,24)
      V(110)=r1x2E*VRR0(8,27)
      V(111)=r1x2E*ZxZpE*VRR1(8,27)
      V(112)=r1x2E*VRR0(8,28)
      V(113)=2.D0*V(112)
      V(114)=HfxZpE*VRR1(4,44)
      V(115)=r1x2E*ZxZpE*VRR1(8,28)
      V(116)=-2.D0*V(115)
      V(117)=2.D0*V(110)
      V(118)=-2.D0*V(111)
      V(119)=r1x2E*VRR0(8,30)
      V(120)=3.D0*V(119)
      V(121)=r1x2E*ZxZpE*VRR1(8,30)
      V(122)=-3.D0*V(121)
      V(123)=r1x2E*VRR0(8,31)
      V(124)=2.D0*V(123)
      V(125)=HfxZpE*VRR1(4,48)
      V(126)=r1x2E*ZxZpE*VRR1(8,31)
      V(127)=-2.D0*V(126)
      V(128)=r1x2E*VRR0(8,32)
      V(129)=HfxZpE*VRR1(4,49)
      V(130)=r1x2E*ZxZpE*VRR1(8,32)
      V(131)=3.D0*V(128)
      V(132)=-3.D0*V(130)
      V(133)=r1x2E*VRR0(8,33)
      V(134)=HfxZpE*VRR1(4,51)
      V(135)=r1x2E*ZxZpE*VRR1(8,33)
      V(136)=r1x2E*VRR0(8,34)
      V(137)=r1x2E*ZxZpE*VRR1(8,34)
      V(138)=r1x2E*VRR0(9,23)
      V(139)=3.D0*V(138)
      V(140)=r1x2E*ZxZpE*VRR1(9,23)
      V(141)=-3.D0*V(140)
      V(142)=r1x2E*VRR0(9,24)
      V(143)=r1x2E*ZxZpE*VRR1(9,24)
      V(144)=r1x2E*VRR0(9,27)
      V(145)=r1x2E*ZxZpE*VRR1(9,27)
      V(146)=r1x2E*VRR0(9,28)
      V(147)=2.D0*V(146)
      V(148)=r1x2E*ZxZpE*VRR1(9,28)
      V(149)=-2.D0*V(148)
      V(150)=2.D0*V(144)
      V(151)=-2.D0*V(145)
      V(152)=r1x2E*VRR0(9,30)
      V(153)=3.D0*V(152)
      V(154)=r1x2E*ZxZpE*VRR1(9,30)
      V(155)=-3.D0*V(154)
      V(156)=r1x2E*VRR0(9,31)
      V(157)=2.D0*V(156)
      V(158)=r1x2E*ZxZpE*VRR1(9,31)
      V(159)=-2.D0*V(158)
      V(160)=r1x2E*VRR0(9,32)
      V(161)=r1x2E*ZxZpE*VRR1(9,32)
      V(162)=3.D0*V(160)
      V(163)=-3.D0*V(161)
      V(164)=r1x2E*VRR0(9,33)
      V(165)=r1x2E*ZxZpE*VRR1(9,33)
      V(166)=r1x2E*VRR0(9,34)
      V(167)=HfxZpE*VRR1(4,53)
      V(168)=r1x2E*ZxZpE*VRR1(9,34)
      V(169)=r1x2E*VRR0(10,23)
      V(170)=3.D0*V(169)
      V(171)=r1x2E*ZxZpE*VRR1(10,23)
      V(172)=-3.D0*V(171)
      V(173)=r1x2E*VRR0(10,24)
      V(174)=r1x2E*ZxZpE*VRR1(10,24)
      V(175)=r1x2E*VRR0(10,27)
      V(176)=r1x2E*ZxZpE*VRR1(10,27)
      V(177)=r1x2E*VRR0(10,28)
      V(178)=2.D0*V(177)
      V(179)=r1x2E*ZxZpE*VRR1(10,28)
      V(180)=-2.D0*V(179)
      V(181)=2.D0*V(175)
      V(182)=-2.D0*V(176)
      V(183)=r1x2E*VRR0(10,30)
      V(184)=3.D0*V(183)
      V(185)=r1x2E*ZxZpE*VRR1(10,30)
      V(186)=-3.D0*V(185)
      V(187)=r1x2E*VRR0(10,31)
      V(188)=2.D0*V(187)
      V(189)=r1x2E*ZxZpE*VRR1(10,31)
      V(190)=-2.D0*V(189)
      V(191)=r1x2E*VRR0(10,32)
      V(192)=r1x2E*ZxZpE*VRR1(10,32)
      V(193)=3.D0*V(191)
      V(194)=-3.D0*V(192)
      V(195)=r1x2E*VRR0(10,33)
      V(196)=r1x2E*ZxZpE*VRR1(10,33)
      V(197)=r1x2E*VRR0(10,34)
      V(198)=r1x2E*ZxZpE*VRR1(10,34)
      VRR0(5,57)=5.D0*r1x2E*VRR0(5,21)+QCx*VRR0(5,36)+2.D0*HfxZpE*VRR1(2,36)-5.D0*r1x2E*ZxZpE*VRR1(5,21)+WQx*VRR1(5,36)
      VRR0(5,58)=4.D0*r1x2E*VRR0(5,22)+QCx*VRR0(5,37)+2.D0*HfxZpE*VRR1(2,37)-4.D0*r1x2E*ZxZpE*VRR1(5,22)+WQx*VRR1(5,37)
      VRR0(5,59)=V(2)+V(4)+QCx*VRR0(5,38)+2.D0*HfxZpE*VRR1(2,38)+WQx*VRR1(5,38)
      VRR0(5,60)=2.D0*V(5)+2.D0*V(6)-2.D0*V(7)+QCx*VRR0(5,39)+WQx*VRR1(5,39)
      VRR0(5,61)=V(2)+V(4)+QCy*VRR0(5,39)+WQy*VRR1(5,39)
      VRR0(5,62)=4.D0*V(5)-4.D0*V(7)+QCy*VRR0(5,40)+WQy*VRR1(5,40)
      VRR0(5,63)=5.D0*r1x2E*VRR0(5,25)+QCy*VRR0(5,41)-5.D0*r1x2E*ZxZpE*VRR1(5,25)+WQy*VRR1(5,41)
      VRR0(5,64)=4.D0*r1x2E*VRR0(5,26)+QCx*VRR0(5,42)+2.D0*HfxZpE*VRR1(2,42)-4.D0*r1x2E*ZxZpE*VRR1(5,26)+WQx*VRR1(5,42)
      VRR0(5,65)=3.D0*V(8)-3.D0*V(9)+QCx*VRR0(5,43)+2.D0*HfxZpE*VRR1(2,43)+WQx*VRR1(5,43)
      VRR0(5,66)=V(11)+2.D0*V(12)+V(14)+QCx*VRR0(5,44)+WQx*VRR1(5,44)
      VRR0(5,67)=V(15)+V(16)+QCy*VRR0(5,44)+WQy*VRR1(5,44)
      VRR0(5,68)=3.D0*V(10)-3.D0*V(13)+QCy*VRR0(5,45)+WQy*VRR1(5,45)
      VRR0(5,69)=4.D0*r1x2E*VRR0(5,29)+QCy*VRR0(5,46)-4.D0*r1x2E*ZxZpE*VRR1(5,29)+WQy*VRR1(5,46)
      VRR0(5,70)=V(18)+V(20)+QCx*VRR0(5,47)+2.D0*HfxZpE*VRR1(2,47)+WQx*VRR1(5,47)
      VRR0(5,71)=V(22)+2.D0*V(23)+V(25)+QCx*VRR0(5,48)+WQx*VRR1(5,48)
      VRR0(5,72)=V(26)+2.D0*V(27)-V(28)+QCx*VRR0(5,49)+WQx*VRR1(5,49)
      VRR0(5,73)=V(22)+V(25)+QCy*VRR0(5,49)+WQy*VRR1(5,49)
      VRR0(5,74)=V(29)+V(30)+QCy*VRR0(5,50)+WQy*VRR1(5,50)
      VRR0(5,75)=2.D0*V(31)+2.D0*V(32)-2.D0*V(33)+QCx*VRR0(5,51)+WQx*VRR1(5,51)
      VRR0(5,76)=V(15)+V(16)+QCz*VRR0(5,48)+WQz*VRR1(5,48)
      VRR0(5,77)=V(11)+V(14)+QCz*VRR0(5,49)+WQz*VRR1(5,49)
      VRR0(5,78)=2.D0*V(34)-2.D0*V(35)+QCy*VRR0(5,53)+WQy*VRR1(5,53)
      VRR0(5,79)=V(18)+V(20)+QCz*VRR0(5,51)+WQz*VRR1(5,51)
      VRR0(5,80)=3.D0*V(21)-3.D0*V(24)+QCz*VRR0(5,52)+WQz*VRR1(5,52)
      VRR0(5,81)=V(29)+V(30)+QCz*VRR0(5,53)+WQz*VRR1(5,53)
      VRR0(5,82)=4.D0*V(31)-4.D0*V(33)+QCz*VRR0(5,54)+WQz*VRR1(5,54)
      VRR0(5,83)=4.D0*V(34)-4.D0*V(35)+QCz*VRR0(5,55)+WQz*VRR1(5,55)
      VRR0(5,84)=5.D0*r1x2E*VRR0(5,35)+QCz*VRR0(5,56)-5.D0*r1x2E*ZxZpE*VRR1(5,35)+WQz*VRR1(5,56)
      VRR0(6,57)=5.D0*r1x2E*VRR0(6,21)+QCx*VRR0(6,36)+HfxZpE*VRR1(3,36)-5.D0*r1x2E*ZxZpE*VRR1(6,21)+WQx*VRR1(6,36)
      VRR0(6,58)=4.D0*r1x2E*VRR0(6,22)+QCx*VRR0(6,37)+HfxZpE*VRR1(3,37)-4.D0*r1x2E*ZxZpE*VRR1(6,22)+WQx*VRR1(6,37)
      VRR0(6,59)=V(37)+V(39)+QCx*VRR0(6,38)+HfxZpE*VRR1(3,38)+WQx*VRR1(6,38)
      VRR0(6,60)=2.D0*V(40)+V(41)-2.D0*V(42)+QCx*VRR0(6,39)+WQx*VRR1(6,39)
      VRR0(6,61)=V(6)+V(37)+V(39)+QCy*VRR0(6,39)+WQy*VRR1(6,39)
      VRR0(6,62)=4.D0*V(40)-4.D0*V(42)+QCy*VRR0(6,40)+HfxZpE*VRR1(2,40)+WQy*VRR1(6,40)
      VRR0(6,63)=5.D0*r1x2E*VRR0(6,25)+QCy*VRR0(6,41)+HfxZpE*VRR1(2,41)-5.D0*r1x2E*ZxZpE*VRR1(6,25)+WQy*VRR1(6,41)
      VRR0(6,64)=4.D0*r1x2E*VRR0(6,26)+QCx*VRR0(6,42)+HfxZpE*VRR1(3,42)-4.D0*r1x2E*ZxZpE*VRR1(6,26)+WQx*VRR1(6,42)
      VRR0(6,65)=3.D0*V(43)-3.D0*V(44)+QCx*VRR0(6,43)+HfxZpE*VRR1(3,43)+WQx*VRR1(6,43)
      VRR0(6,66)=V(46)+V(47)+V(49)+QCx*VRR0(6,44)+WQx*VRR1(6,44)
      VRR0(6,67)=V(12)+V(50)+V(51)+QCy*VRR0(6,44)+WQy*VRR1(6,44)
      VRR0(6,68)=3.D0*V(45)-3.D0*V(48)+QCy*VRR0(6,45)+HfxZpE*VRR1(2,45)+WQy*VRR1(6,45)
      VRR0(6,69)=4.D0*r1x2E*VRR0(6,29)+QCy*VRR0(6,46)+HfxZpE*VRR1(2,46)-4.D0*r1x2E*ZxZpE*VRR1(6,29)+WQy*VRR1(6,46)
      VRR0(6,70)=V(53)+V(55)+QCx*VRR0(6,47)+HfxZpE*VRR1(3,47)+WQx*VRR1(6,47)
      VRR0(6,71)=V(57)+V(58)+V(60)+QCx*VRR0(6,48)+WQx*VRR1(6,48)
      VRR0(6,72)=V(61)+V(62)-V(63)+QCx*VRR0(6,49)+WQx*VRR1(6,49)
      VRR0(6,73)=V(27)+V(57)+V(60)+QCy*VRR0(6,49)+WQy*VRR1(6,49)
      VRR0(6,74)=V(64)+V(65)+QCy*VRR0(6,50)+HfxZpE*VRR1(2,50)+WQy*VRR1(6,50)
      VRR0(6,75)=2.D0*V(66)+V(67)-2.D0*V(68)+QCx*VRR0(6,51)+WQx*VRR1(6,51)
      VRR0(6,76)=V(50)+V(51)+QCz*VRR0(6,48)+WQz*VRR1(6,48)
      VRR0(6,77)=V(46)+V(49)+QCz*VRR0(6,49)+WQz*VRR1(6,49)
      VRR0(6,78)=2.D0*V(69)+V(70)-2.D0*V(71)+QCy*VRR0(6,53)+WQy*VRR1(6,53)
      VRR0(6,79)=V(53)+V(55)+QCz*VRR0(6,51)+WQz*VRR1(6,51)
      VRR0(6,80)=3.D0*V(56)-3.D0*V(59)+QCz*VRR0(6,52)+WQz*VRR1(6,52)
      VRR0(6,81)=V(64)+V(65)+QCz*VRR0(6,53)+WQz*VRR1(6,53)
      VRR0(6,82)=4.D0*V(66)-4.D0*V(68)+QCz*VRR0(6,54)+WQz*VRR1(6,54)
      VRR0(6,83)=4.D0*V(69)-4.D0*V(71)+QCz*VRR0(6,55)+WQz*VRR1(6,55)
      VRR0(6,84)=5.D0*r1x2E*VRR0(6,35)+QCz*VRR0(6,56)-5.D0*r1x2E*ZxZpE*VRR1(6,35)+WQz*VRR1(6,56)
      VRR0(7,57)=5.D0*r1x2E*VRR0(7,21)+QCx*VRR0(7,36)-5.D0*r1x2E*ZxZpE*VRR1(7,21)+WQx*VRR1(7,36)
      VRR0(7,58)=4.D0*r1x2E*VRR0(7,22)+QCx*VRR0(7,37)-4.D0*r1x2E*ZxZpE*VRR1(7,22)+WQx*VRR1(7,37)
      VRR0(7,59)=V(73)+V(75)+QCx*VRR0(7,38)+WQx*VRR1(7,38)
      VRR0(7,60)=2.D0*V(76)-2.D0*V(77)+QCx*VRR0(7,39)+WQx*VRR1(7,39)
      VRR0(7,61)=2.D0*V(41)+V(73)+V(75)+QCy*VRR0(7,39)+WQy*VRR1(7,39)
      VRR0(7,62)=4.D0*V(76)-4.D0*V(77)+QCy*VRR0(7,40)+2.D0*HfxZpE*VRR1(3,40)+WQy*VRR1(7,40)
      VRR0(7,63)=5.D0*r1x2E*VRR0(7,25)+QCy*VRR0(7,41)+2.D0*HfxZpE*VRR1(3,41)-5.D0*r1x2E*ZxZpE*VRR1(7,25)+WQy*VRR1(7,41)
      VRR0(7,64)=4.D0*r1x2E*VRR0(7,26)+QCx*VRR0(7,42)-4.D0*r1x2E*ZxZpE*VRR1(7,26)+WQx*VRR1(7,42)
      VRR0(7,65)=3.D0*V(78)-3.D0*V(79)+QCx*VRR0(7,43)+WQx*VRR1(7,43)
      VRR0(7,66)=V(81)+V(83)+QCx*VRR0(7,44)+WQx*VRR1(7,44)
      VRR0(7,67)=2.D0*V(47)+V(84)+V(85)+QCy*VRR0(7,44)+WQy*VRR1(7,44)
      VRR0(7,68)=3.D0*V(80)-3.D0*V(82)+QCy*VRR0(7,45)+2.D0*HfxZpE*VRR1(3,45)+WQy*VRR1(7,45)
      VRR0(7,69)=4.D0*r1x2E*VRR0(7,29)+QCy*VRR0(7,46)+2.D0*HfxZpE*VRR1(3,46)-4.D0*r1x2E*ZxZpE*VRR1(7,29)+WQy*VRR1(7,46)
      VRR0(7,70)=V(87)+V(89)+QCx*VRR0(7,47)+WQx*VRR1(7,47)
      VRR0(7,71)=V(91)+V(93)+QCx*VRR0(7,48)+WQx*VRR1(7,48)
      VRR0(7,72)=V(94)-V(95)+QCx*VRR0(7,49)+WQx*VRR1(7,49)
      VRR0(7,73)=2.D0*V(62)+V(91)+V(93)+QCy*VRR0(7,49)+WQy*VRR1(7,49)
      VRR0(7,74)=V(96)+V(97)+QCy*VRR0(7,50)+2.D0*HfxZpE*VRR1(3,50)+WQy*VRR1(7,50)
      VRR0(7,75)=2.D0*V(98)-2.D0*V(99)+QCx*VRR0(7,51)+WQx*VRR1(7,51)
      VRR0(7,76)=V(84)+V(85)+QCz*VRR0(7,48)+WQz*VRR1(7,48)
      VRR0(7,77)=V(81)+V(83)+QCz*VRR0(7,49)+WQz*VRR1(7,49)
      VRR0(7,78)=2.D0*V(100)+2.D0*V(101)-2.D0*V(102)+QCy*VRR0(7,53)+WQy*VRR1(7,53)
      VRR0(7,79)=V(87)+V(89)+QCz*VRR0(7,51)+WQz*VRR1(7,51)
      VRR0(7,80)=3.D0*V(90)-3.D0*V(92)+QCz*VRR0(7,52)+WQz*VRR1(7,52)
      VRR0(7,81)=V(96)+V(97)+QCz*VRR0(7,53)+WQz*VRR1(7,53)
      VRR0(7,82)=4.D0*V(98)-4.D0*V(99)+QCz*VRR0(7,54)+WQz*VRR1(7,54)
      VRR0(7,83)=4.D0*V(100)-4.D0*V(102)+QCz*VRR0(7,55)+WQz*VRR1(7,55)
      VRR0(7,84)=5.D0*r1x2E*VRR0(7,35)+QCz*VRR0(7,56)-5.D0*r1x2E*ZxZpE*VRR1(7,35)+WQz*VRR1(7,56)
      VRR0(8,57)=5.D0*r1x2E*VRR0(8,21)+QCx*VRR0(8,36)+HfxZpE*VRR1(4,36)-5.D0*r1x2E*ZxZpE*VRR1(8,21)+WQx*VRR1(8,36)
      VRR0(8,58)=4.D0*r1x2E*VRR0(8,22)+QCx*VRR0(8,37)+HfxZpE*VRR1(4,37)-4.D0*r1x2E*ZxZpE*VRR1(8,22)+WQx*VRR1(8,37)
      VRR0(8,59)=V(104)+V(106)+QCx*VRR0(8,38)+HfxZpE*VRR1(4,38)+WQx*VRR1(8,38)
      VRR0(8,60)=2.D0*V(107)+V(108)-2.D0*V(109)+QCx*VRR0(8,39)+WQx*VRR1(8,39)
      VRR0(8,61)=V(104)+V(106)+QCy*VRR0(8,39)+WQy*VRR1(8,39)
      VRR0(8,62)=4.D0*V(107)-4.D0*V(109)+QCy*VRR0(8,40)+WQy*VRR1(8,40)
      VRR0(8,63)=5.D0*r1x2E*VRR0(8,25)+QCy*VRR0(8,41)-5.D0*r1x2E*ZxZpE*VRR1(8,25)+WQy*VRR1(8,41)
      VRR0(8,64)=4.D0*r1x2E*VRR0(8,26)+QCx*VRR0(8,42)+HfxZpE*VRR1(4,42)-4.D0*r1x2E*ZxZpE*VRR1(8,26)+WQx*VRR1(8,42)
      VRR0(8,65)=3.D0*V(110)-3.D0*V(111)+QCx*VRR0(8,43)+HfxZpE*VRR1(4,43)+WQx*VRR1(8,43)
      VRR0(8,66)=V(113)+V(114)+V(116)+QCx*VRR0(8,44)+WQx*VRR1(8,44)
      VRR0(8,67)=V(117)+V(118)+QCy*VRR0(8,44)+WQy*VRR1(8,44)
      VRR0(8,68)=3.D0*V(112)-3.D0*V(115)+QCy*VRR0(8,45)+WQy*VRR1(8,45)
      VRR0(8,69)=4.D0*r1x2E*VRR0(8,29)+QCy*VRR0(8,46)-4.D0*r1x2E*ZxZpE*VRR1(8,29)+WQy*VRR1(8,46)
      VRR0(8,70)=V(120)+V(122)+QCx*VRR0(8,47)+HfxZpE*VRR1(4,47)+WQx*VRR1(8,47)
      VRR0(8,71)=V(124)+V(125)+V(127)+QCx*VRR0(8,48)+WQx*VRR1(8,48)
      VRR0(8,72)=V(128)+V(129)-V(130)+QCx*VRR0(8,49)+WQx*VRR1(8,49)
      VRR0(8,73)=V(124)+V(127)+QCy*VRR0(8,49)+WQy*VRR1(8,49)
      VRR0(8,74)=V(131)+V(132)+QCy*VRR0(8,50)+WQy*VRR1(8,50)
      VRR0(8,75)=2.D0*V(133)+V(134)-2.D0*V(135)+QCx*VRR0(8,51)+WQx*VRR1(8,51)
      VRR0(8,76)=V(23)+V(117)+V(118)+QCz*VRR0(8,48)+WQz*VRR1(8,48)
      VRR0(8,77)=V(27)+V(113)+V(116)+QCz*VRR0(8,49)+WQz*VRR1(8,49)
      VRR0(8,78)=2.D0*V(136)-2.D0*V(137)+QCy*VRR0(8,53)+WQy*VRR1(8,53)
      VRR0(8,79)=V(32)+V(120)+V(122)+QCz*VRR0(8,51)+WQz*VRR1(8,51)
      VRR0(8,80)=3.D0*V(123)-3.D0*V(126)+QCz*VRR0(8,52)+HfxZpE*VRR1(2,52)+WQz*VRR1(8,52)
      VRR0(8,81)=V(70)+V(131)+V(132)+QCz*VRR0(8,53)+WQz*VRR1(8,53)
      VRR0(8,82)=4.D0*V(133)-4.D0*V(135)+QCz*VRR0(8,54)+HfxZpE*VRR1(2,54)+WQz*VRR1(8,54)
      VRR0(8,83)=4.D0*V(136)-4.D0*V(137)+QCz*VRR0(8,55)+HfxZpE*VRR1(2,55)+WQz*VRR1(8,55)
      VRR0(8,84)=5.D0*r1x2E*VRR0(8,35)+QCz*VRR0(8,56)+HfxZpE*VRR1(2,56)-5.D0*r1x2E*ZxZpE*VRR1(8,35)+WQz*VRR1(8,56)
      VRR0(9,57)=5.D0*r1x2E*VRR0(9,21)+QCx*VRR0(9,36)-5.D0*r1x2E*ZxZpE*VRR1(9,21)+WQx*VRR1(9,36)
      VRR0(9,58)=4.D0*r1x2E*VRR0(9,22)+QCx*VRR0(9,37)-4.D0*r1x2E*ZxZpE*VRR1(9,22)+WQx*VRR1(9,37)
      VRR0(9,59)=V(139)+V(141)+QCx*VRR0(9,38)+WQx*VRR1(9,38)
      VRR0(9,60)=2.D0*V(142)-2.D0*V(143)+QCx*VRR0(9,39)+WQx*VRR1(9,39)
      VRR0(9,61)=V(108)+V(139)+V(141)+QCy*VRR0(9,39)+WQy*VRR1(9,39)
      VRR0(9,62)=4.D0*V(142)-4.D0*V(143)+QCy*VRR0(9,40)+HfxZpE*VRR1(4,40)+WQy*VRR1(9,40)
      VRR0(9,63)=5.D0*r1x2E*VRR0(9,25)+QCy*VRR0(9,41)+HfxZpE*VRR1(4,41)-5.D0*r1x2E*ZxZpE*VRR1(9,25)+WQy*VRR1(9,41)
      VRR0(9,64)=4.D0*r1x2E*VRR0(9,26)+QCx*VRR0(9,42)-4.D0*r1x2E*ZxZpE*VRR1(9,26)+WQx*VRR1(9,42)
      VRR0(9,65)=3.D0*V(144)-3.D0*V(145)+QCx*VRR0(9,43)+WQx*VRR1(9,43)
      VRR0(9,66)=V(147)+V(149)+QCx*VRR0(9,44)+WQx*VRR1(9,44)
      VRR0(9,67)=V(114)+V(150)+V(151)+QCy*VRR0(9,44)+WQy*VRR1(9,44)
      VRR0(9,68)=3.D0*V(146)-3.D0*V(148)+QCy*VRR0(9,45)+HfxZpE*VRR1(4,45)+WQy*VRR1(9,45)
      VRR0(9,69)=4.D0*r1x2E*VRR0(9,29)+QCy*VRR0(9,46)+HfxZpE*VRR1(4,46)-4.D0*r1x2E*ZxZpE*VRR1(9,29)+WQy*VRR1(9,46)
      VRR0(9,70)=V(153)+V(155)+QCx*VRR0(9,47)+WQx*VRR1(9,47)
      VRR0(9,71)=V(157)+V(159)+QCx*VRR0(9,48)+WQx*VRR1(9,48)
      VRR0(9,72)=V(160)-V(161)+QCx*VRR0(9,49)+WQx*VRR1(9,49)
      VRR0(9,73)=V(129)+V(157)+V(159)+QCy*VRR0(9,49)+WQy*VRR1(9,49)
      VRR0(9,74)=V(162)+V(163)+QCy*VRR0(9,50)+HfxZpE*VRR1(4,50)+WQy*VRR1(9,50)
      VRR0(9,75)=2.D0*V(164)-2.D0*V(165)+QCx*VRR0(9,51)+WQx*VRR1(9,51)
      VRR0(9,76)=V(58)+V(150)+V(151)+QCz*VRR0(9,48)+WQz*VRR1(9,48)
      VRR0(9,77)=V(62)+V(147)+V(149)+QCz*VRR0(9,49)+WQz*VRR1(9,49)
      VRR0(9,78)=2.D0*V(166)+V(167)-2.D0*V(168)+QCy*VRR0(9,53)+WQy*VRR1(9,53)
      VRR0(9,79)=V(67)+V(153)+V(155)+QCz*VRR0(9,51)+WQz*VRR1(9,51)
      VRR0(9,80)=3.D0*V(156)-3.D0*V(158)+QCz*VRR0(9,52)+HfxZpE*VRR1(3,52)+WQz*VRR1(9,52)
      VRR0(9,81)=V(101)+V(162)+V(163)+QCz*VRR0(9,53)+WQz*VRR1(9,53)
      VRR0(9,82)=4.D0*V(164)-4.D0*V(165)+QCz*VRR0(9,54)+HfxZpE*VRR1(3,54)+WQz*VRR1(9,54)
      VRR0(9,83)=4.D0*V(166)-4.D0*V(168)+QCz*VRR0(9,55)+HfxZpE*VRR1(3,55)+WQz*VRR1(9,55)
      VRR0(9,84)=5.D0*r1x2E*VRR0(9,35)+QCz*VRR0(9,56)+HfxZpE*VRR1(3,56)-5.D0*r1x2E*ZxZpE*VRR1(9,35)+WQz*VRR1(9,56)
      VRR0(10,57)=5.D0*r1x2E*VRR0(10,21)+QCx*VRR0(10,36)-5.D0*r1x2E*ZxZpE*VRR1(10,21)+WQx*VRR1(10,36)
      VRR0(10,58)=4.D0*r1x2E*VRR0(10,22)+QCx*VRR0(10,37)-4.D0*r1x2E*ZxZpE*VRR1(10,22)+WQx*VRR1(10,37)
      VRR0(10,59)=V(170)+V(172)+QCx*VRR0(10,38)+WQx*VRR1(10,38)
      VRR0(10,60)=2.D0*V(173)-2.D0*V(174)+QCx*VRR0(10,39)+WQx*VRR1(10,39)
      VRR0(10,61)=V(170)+V(172)+QCy*VRR0(10,39)+WQy*VRR1(10,39)
      VRR0(10,62)=4.D0*V(173)-4.D0*V(174)+QCy*VRR0(10,40)+WQy*VRR1(10,40)
      VRR0(10,63)=5.D0*r1x2E*VRR0(10,25)+QCy*VRR0(10,41)-5.D0*r1x2E*ZxZpE*VRR1(10,25)+WQy*VRR1(10,41)
      VRR0(10,64)=4.D0*r1x2E*VRR0(10,26)+QCx*VRR0(10,42)-4.D0*r1x2E*ZxZpE*VRR1(10,26)+WQx*VRR1(10,42)
      VRR0(10,65)=3.D0*V(175)-3.D0*V(176)+QCx*VRR0(10,43)+WQx*VRR1(10,43)
      VRR0(10,66)=V(178)+V(180)+QCx*VRR0(10,44)+WQx*VRR1(10,44)
      VRR0(10,67)=V(181)+V(182)+QCy*VRR0(10,44)+WQy*VRR1(10,44)
      VRR0(10,68)=3.D0*V(177)-3.D0*V(179)+QCy*VRR0(10,45)+WQy*VRR1(10,45)
      VRR0(10,69)=4.D0*r1x2E*VRR0(10,29)+QCy*VRR0(10,46)-4.D0*r1x2E*ZxZpE*VRR1(10,29)+WQy*VRR1(10,46)
      VRR0(10,70)=V(184)+V(186)+QCx*VRR0(10,47)+WQx*VRR1(10,47)
      VRR0(10,71)=V(188)+V(190)+QCx*VRR0(10,48)+WQx*VRR1(10,48)
      VRR0(10,72)=V(191)-V(192)+QCx*VRR0(10,49)+WQx*VRR1(10,49)
      VRR0(10,73)=V(188)+V(190)+QCy*VRR0(10,49)+WQy*VRR1(10,49)
      VRR0(10,74)=V(193)+V(194)+QCy*VRR0(10,50)+WQy*VRR1(10,50)
      VRR0(10,75)=2.D0*V(195)-2.D0*V(196)+QCx*VRR0(10,51)+WQx*VRR1(10,51)
      VRR0(10,76)=2.D0*V(125)+V(181)+V(182)+QCz*VRR0(10,48)+WQz*VRR1(10,48)
      VRR0(10,77)=2.D0*V(129)+V(178)+V(180)+QCz*VRR0(10,49)+WQz*VRR1(10,49)
      VRR0(10,78)=2.D0*V(197)-2.D0*V(198)+QCy*VRR0(10,53)+WQy*VRR1(10,53)
      VRR0(10,79)=2.D0*V(134)+V(184)+V(186)+QCz*VRR0(10,51)+WQz*VRR1(10,51)
      VRR0(10,80)=3.D0*V(187)-3.D0*V(189)+QCz*VRR0(10,52)+2.D0*HfxZpE*VRR1(4,52)+WQz*VRR1(10,52)
      VRR0(10,81)=2.D0*V(167)+V(193)+V(194)+QCz*VRR0(10,53)+WQz*VRR1(10,53)
      VRR0(10,82)=4.D0*V(195)-4.D0*V(196)+QCz*VRR0(10,54)+2.D0*HfxZpE*VRR1(4,54)+WQz*VRR1(10,54)
      VRR0(10,83)=4.D0*V(197)-4.D0*V(198)+QCz*VRR0(10,55)+2.D0*HfxZpE*VRR1(4,55)+WQz*VRR1(10,55)
      VRR0(10,84)=5.D0*r1x2E*VRR0(10,35)+QCz*VRR0(10,56)+2.D0*HfxZpE*VRR1(4,56)-5.D0*r1x2E*ZxZpE*VRR1(10,35)+WQz*VRR1(10,56)
END SUBROUTINE VRRd0i0
SUBROUTINE MVRRd0i0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(5,57)=QCx*VS0(5,36)+WQx*VS1(5,36)-r1x2E*VR1(5,36)&
   +5D0*r1x2E*(VS0(5,21)-ZxZpE*VS1(5,21))&
   +2D0*HfxZpE*VS1(2,36)
VS0(5,58)=QCx*VS0(5,37)+WQx*VS1(5,37)-r1x2E*VR1(5,37)&
   +4D0*r1x2E*(VS0(5,22)-ZxZpE*VS1(5,22))&
   +2D0*HfxZpE*VS1(2,37)
VS0(5,59)=QCx*VS0(5,38)+WQx*VS1(5,38)-r1x2E*VR1(5,38)&
   +3D0*r1x2E*(VS0(5,23)-ZxZpE*VS1(5,23))&
   +2D0*HfxZpE*VS1(2,38)
VS0(5,60)=QCx*VS0(5,39)+WQx*VS1(5,39)-r1x2E*VR1(5,39)&
   +2D0*r1x2E*(VS0(5,24)-ZxZpE*VS1(5,24))&
   +2D0*HfxZpE*VS1(2,39)
VS0(5,61)=QCy*VS0(5,39)+WQy*VS1(5,39)&
   +3D0*r1x2E*(VS0(5,23)-ZxZpE*VS1(5,23))
VS0(5,62)=QCy*VS0(5,40)+WQy*VS1(5,40)&
   +4D0*r1x2E*(VS0(5,24)-ZxZpE*VS1(5,24))
VS0(5,63)=QCy*VS0(5,41)+WQy*VS1(5,41)&
   +5D0*r1x2E*(VS0(5,25)-ZxZpE*VS1(5,25))
VS0(5,64)=QCx*VS0(5,42)+WQx*VS1(5,42)-r1x2E*VR1(5,42)&
   +4D0*r1x2E*(VS0(5,26)-ZxZpE*VS1(5,26))&
   +2D0*HfxZpE*VS1(2,42)
VS0(5,65)=QCx*VS0(5,43)+WQx*VS1(5,43)-r1x2E*VR1(5,43)&
   +3D0*r1x2E*(VS0(5,27)-ZxZpE*VS1(5,27))&
   +2D0*HfxZpE*VS1(2,43)
VS0(5,66)=QCx*VS0(5,44)+WQx*VS1(5,44)-r1x2E*VR1(5,44)&
   +2D0*r1x2E*(VS0(5,28)-ZxZpE*VS1(5,28))&
   +2D0*HfxZpE*VS1(2,44)
VS0(5,67)=QCy*VS0(5,44)+WQy*VS1(5,44)&
   +2D0*r1x2E*(VS0(5,27)-ZxZpE*VS1(5,27))
VS0(5,68)=QCy*VS0(5,45)+WQy*VS1(5,45)&
   +3D0*r1x2E*(VS0(5,28)-ZxZpE*VS1(5,28))
VS0(5,69)=QCy*VS0(5,46)+WQy*VS1(5,46)&
   +4D0*r1x2E*(VS0(5,29)-ZxZpE*VS1(5,29))
VS0(5,70)=QCx*VS0(5,47)+WQx*VS1(5,47)-r1x2E*VR1(5,47)&
   +3D0*r1x2E*(VS0(5,30)-ZxZpE*VS1(5,30))&
   +2D0*HfxZpE*VS1(2,47)
VS0(5,71)=QCx*VS0(5,48)+WQx*VS1(5,48)-r1x2E*VR1(5,48)&
   +2D0*r1x2E*(VS0(5,31)-ZxZpE*VS1(5,31))&
   +2D0*HfxZpE*VS1(2,48)
VS0(5,72)=QCx*VS0(5,49)+WQx*VS1(5,49)-r1x2E*VR1(5,49)&
   +r1x2E*(VS0(5,32)-ZxZpE*VS1(5,32))&
   +2D0*HfxZpE*VS1(2,49)
VS0(5,73)=QCy*VS0(5,49)+WQy*VS1(5,49)&
   +2D0*r1x2E*(VS0(5,31)-ZxZpE*VS1(5,31))
VS0(5,74)=QCy*VS0(5,50)+WQy*VS1(5,50)&
   +3D0*r1x2E*(VS0(5,32)-ZxZpE*VS1(5,32))
VS0(5,75)=QCx*VS0(5,51)+WQx*VS1(5,51)-r1x2E*VR1(5,51)&
   +2D0*r1x2E*(VS0(5,33)-ZxZpE*VS1(5,33))&
   +2D0*HfxZpE*VS1(2,51)
VS0(5,76)=QCz*VS0(5,48)+WQz*VS1(5,48)&
   +2D0*r1x2E*(VS0(5,27)-ZxZpE*VS1(5,27))
VS0(5,77)=QCz*VS0(5,49)+WQz*VS1(5,49)&
   +2D0*r1x2E*(VS0(5,28)-ZxZpE*VS1(5,28))
VS0(5,78)=QCy*VS0(5,53)+WQy*VS1(5,53)&
   +2D0*r1x2E*(VS0(5,34)-ZxZpE*VS1(5,34))
VS0(5,79)=QCz*VS0(5,51)+WQz*VS1(5,51)&
   +3D0*r1x2E*(VS0(5,30)-ZxZpE*VS1(5,30))
VS0(5,80)=QCz*VS0(5,52)+WQz*VS1(5,52)&
   +3D0*r1x2E*(VS0(5,31)-ZxZpE*VS1(5,31))
VS0(5,81)=QCz*VS0(5,53)+WQz*VS1(5,53)&
   +3D0*r1x2E*(VS0(5,32)-ZxZpE*VS1(5,32))
VS0(5,82)=QCz*VS0(5,54)+WQz*VS1(5,54)&
   +4D0*r1x2E*(VS0(5,33)-ZxZpE*VS1(5,33))
VS0(5,83)=QCz*VS0(5,55)+WQz*VS1(5,55)&
   +4D0*r1x2E*(VS0(5,34)-ZxZpE*VS1(5,34))
VS0(5,84)=QCz*VS0(5,56)+WQz*VS1(5,56)&
   +5D0*r1x2E*(VS0(5,35)-ZxZpE*VS1(5,35))
VS0(6,57)=QCx*VS0(6,36)+WQx*VS1(6,36)-r1x2E*VR1(6,36)&
   +5D0*r1x2E*(VS0(6,21)-ZxZpE*VS1(6,21))&
   +HfxZpE*VS1(3,36)
VS0(6,58)=QCx*VS0(6,37)+WQx*VS1(6,37)-r1x2E*VR1(6,37)&
   +4D0*r1x2E*(VS0(6,22)-ZxZpE*VS1(6,22))&
   +HfxZpE*VS1(3,37)
VS0(6,59)=QCx*VS0(6,38)+WQx*VS1(6,38)-r1x2E*VR1(6,38)&
   +3D0*r1x2E*(VS0(6,23)-ZxZpE*VS1(6,23))&
   +HfxZpE*VS1(3,38)
VS0(6,60)=QCx*VS0(6,39)+WQx*VS1(6,39)-r1x2E*VR1(6,39)&
   +2D0*r1x2E*(VS0(6,24)-ZxZpE*VS1(6,24))&
   +HfxZpE*VS1(3,39)
VS0(6,61)=QCy*VS0(6,39)+WQy*VS1(6,39)&
   +3D0*r1x2E*(VS0(6,23)-ZxZpE*VS1(6,23))&
   +HfxZpE*VS1(2,39)
VS0(6,62)=QCy*VS0(6,40)+WQy*VS1(6,40)&
   +4D0*r1x2E*(VS0(6,24)-ZxZpE*VS1(6,24))&
   +HfxZpE*VS1(2,40)
VS0(6,63)=QCy*VS0(6,41)+WQy*VS1(6,41)&
   +5D0*r1x2E*(VS0(6,25)-ZxZpE*VS1(6,25))&
   +HfxZpE*VS1(2,41)
VS0(6,64)=QCx*VS0(6,42)+WQx*VS1(6,42)-r1x2E*VR1(6,42)&
   +4D0*r1x2E*(VS0(6,26)-ZxZpE*VS1(6,26))&
   +HfxZpE*VS1(3,42)
VS0(6,65)=QCx*VS0(6,43)+WQx*VS1(6,43)-r1x2E*VR1(6,43)&
   +3D0*r1x2E*(VS0(6,27)-ZxZpE*VS1(6,27))&
   +HfxZpE*VS1(3,43)
VS0(6,66)=QCx*VS0(6,44)+WQx*VS1(6,44)-r1x2E*VR1(6,44)&
   +2D0*r1x2E*(VS0(6,28)-ZxZpE*VS1(6,28))&
   +HfxZpE*VS1(3,44)
VS0(6,67)=QCy*VS0(6,44)+WQy*VS1(6,44)&
   +2D0*r1x2E*(VS0(6,27)-ZxZpE*VS1(6,27))&
   +HfxZpE*VS1(2,44)
VS0(6,68)=QCy*VS0(6,45)+WQy*VS1(6,45)&
   +3D0*r1x2E*(VS0(6,28)-ZxZpE*VS1(6,28))&
   +HfxZpE*VS1(2,45)
VS0(6,69)=QCy*VS0(6,46)+WQy*VS1(6,46)&
   +4D0*r1x2E*(VS0(6,29)-ZxZpE*VS1(6,29))&
   +HfxZpE*VS1(2,46)
VS0(6,70)=QCx*VS0(6,47)+WQx*VS1(6,47)-r1x2E*VR1(6,47)&
   +3D0*r1x2E*(VS0(6,30)-ZxZpE*VS1(6,30))&
   +HfxZpE*VS1(3,47)
VS0(6,71)=QCx*VS0(6,48)+WQx*VS1(6,48)-r1x2E*VR1(6,48)&
   +2D0*r1x2E*(VS0(6,31)-ZxZpE*VS1(6,31))&
   +HfxZpE*VS1(3,48)
VS0(6,72)=QCx*VS0(6,49)+WQx*VS1(6,49)-r1x2E*VR1(6,49)&
   +r1x2E*(VS0(6,32)-ZxZpE*VS1(6,32))&
   +HfxZpE*VS1(3,49)
VS0(6,73)=QCy*VS0(6,49)+WQy*VS1(6,49)&
   +2D0*r1x2E*(VS0(6,31)-ZxZpE*VS1(6,31))&
   +HfxZpE*VS1(2,49)
VS0(6,74)=QCy*VS0(6,50)+WQy*VS1(6,50)&
   +3D0*r1x2E*(VS0(6,32)-ZxZpE*VS1(6,32))&
   +HfxZpE*VS1(2,50)
VS0(6,75)=QCx*VS0(6,51)+WQx*VS1(6,51)-r1x2E*VR1(6,51)&
   +2D0*r1x2E*(VS0(6,33)-ZxZpE*VS1(6,33))&
   +HfxZpE*VS1(3,51)
VS0(6,76)=QCz*VS0(6,48)+WQz*VS1(6,48)&
   +2D0*r1x2E*(VS0(6,27)-ZxZpE*VS1(6,27))
VS0(6,77)=QCz*VS0(6,49)+WQz*VS1(6,49)&
   +2D0*r1x2E*(VS0(6,28)-ZxZpE*VS1(6,28))
VS0(6,78)=QCy*VS0(6,53)+WQy*VS1(6,53)&
   +2D0*r1x2E*(VS0(6,34)-ZxZpE*VS1(6,34))&
   +HfxZpE*VS1(2,53)
VS0(6,79)=QCz*VS0(6,51)+WQz*VS1(6,51)&
   +3D0*r1x2E*(VS0(6,30)-ZxZpE*VS1(6,30))
VS0(6,80)=QCz*VS0(6,52)+WQz*VS1(6,52)&
   +3D0*r1x2E*(VS0(6,31)-ZxZpE*VS1(6,31))
VS0(6,81)=QCz*VS0(6,53)+WQz*VS1(6,53)&
   +3D0*r1x2E*(VS0(6,32)-ZxZpE*VS1(6,32))
VS0(6,82)=QCz*VS0(6,54)+WQz*VS1(6,54)&
   +4D0*r1x2E*(VS0(6,33)-ZxZpE*VS1(6,33))
VS0(6,83)=QCz*VS0(6,55)+WQz*VS1(6,55)&
   +4D0*r1x2E*(VS0(6,34)-ZxZpE*VS1(6,34))
VS0(6,84)=QCz*VS0(6,56)+WQz*VS1(6,56)&
   +5D0*r1x2E*(VS0(6,35)-ZxZpE*VS1(6,35))
VS0(7,57)=QCx*VS0(7,36)+WQx*VS1(7,36)-r1x2E*VR1(7,36)&
   +5D0*r1x2E*(VS0(7,21)-ZxZpE*VS1(7,21))
VS0(7,58)=QCx*VS0(7,37)+WQx*VS1(7,37)-r1x2E*VR1(7,37)&
   +4D0*r1x2E*(VS0(7,22)-ZxZpE*VS1(7,22))
VS0(7,59)=QCx*VS0(7,38)+WQx*VS1(7,38)-r1x2E*VR1(7,38)&
   +3D0*r1x2E*(VS0(7,23)-ZxZpE*VS1(7,23))
VS0(7,60)=QCx*VS0(7,39)+WQx*VS1(7,39)-r1x2E*VR1(7,39)&
   +2D0*r1x2E*(VS0(7,24)-ZxZpE*VS1(7,24))
VS0(7,61)=QCy*VS0(7,39)+WQy*VS1(7,39)&
   +3D0*r1x2E*(VS0(7,23)-ZxZpE*VS1(7,23))&
   +2D0*HfxZpE*VS1(3,39)
VS0(7,62)=QCy*VS0(7,40)+WQy*VS1(7,40)&
   +4D0*r1x2E*(VS0(7,24)-ZxZpE*VS1(7,24))&
   +2D0*HfxZpE*VS1(3,40)
VS0(7,63)=QCy*VS0(7,41)+WQy*VS1(7,41)&
   +5D0*r1x2E*(VS0(7,25)-ZxZpE*VS1(7,25))&
   +2D0*HfxZpE*VS1(3,41)
VS0(7,64)=QCx*VS0(7,42)+WQx*VS1(7,42)-r1x2E*VR1(7,42)&
   +4D0*r1x2E*(VS0(7,26)-ZxZpE*VS1(7,26))
VS0(7,65)=QCx*VS0(7,43)+WQx*VS1(7,43)-r1x2E*VR1(7,43)&
   +3D0*r1x2E*(VS0(7,27)-ZxZpE*VS1(7,27))
VS0(7,66)=QCx*VS0(7,44)+WQx*VS1(7,44)-r1x2E*VR1(7,44)&
   +2D0*r1x2E*(VS0(7,28)-ZxZpE*VS1(7,28))
VS0(7,67)=QCy*VS0(7,44)+WQy*VS1(7,44)&
   +2D0*r1x2E*(VS0(7,27)-ZxZpE*VS1(7,27))&
   +2D0*HfxZpE*VS1(3,44)
VS0(7,68)=QCy*VS0(7,45)+WQy*VS1(7,45)&
   +3D0*r1x2E*(VS0(7,28)-ZxZpE*VS1(7,28))&
   +2D0*HfxZpE*VS1(3,45)
VS0(7,69)=QCy*VS0(7,46)+WQy*VS1(7,46)&
   +4D0*r1x2E*(VS0(7,29)-ZxZpE*VS1(7,29))&
   +2D0*HfxZpE*VS1(3,46)
VS0(7,70)=QCx*VS0(7,47)+WQx*VS1(7,47)-r1x2E*VR1(7,47)&
   +3D0*r1x2E*(VS0(7,30)-ZxZpE*VS1(7,30))
VS0(7,71)=QCx*VS0(7,48)+WQx*VS1(7,48)-r1x2E*VR1(7,48)&
   +2D0*r1x2E*(VS0(7,31)-ZxZpE*VS1(7,31))
VS0(7,72)=QCx*VS0(7,49)+WQx*VS1(7,49)-r1x2E*VR1(7,49)&
   +r1x2E*(VS0(7,32)-ZxZpE*VS1(7,32))
VS0(7,73)=QCy*VS0(7,49)+WQy*VS1(7,49)&
   +2D0*r1x2E*(VS0(7,31)-ZxZpE*VS1(7,31))&
   +2D0*HfxZpE*VS1(3,49)
VS0(7,74)=QCy*VS0(7,50)+WQy*VS1(7,50)&
   +3D0*r1x2E*(VS0(7,32)-ZxZpE*VS1(7,32))&
   +2D0*HfxZpE*VS1(3,50)
VS0(7,75)=QCx*VS0(7,51)+WQx*VS1(7,51)-r1x2E*VR1(7,51)&
   +2D0*r1x2E*(VS0(7,33)-ZxZpE*VS1(7,33))
VS0(7,76)=QCz*VS0(7,48)+WQz*VS1(7,48)&
   +2D0*r1x2E*(VS0(7,27)-ZxZpE*VS1(7,27))
VS0(7,77)=QCz*VS0(7,49)+WQz*VS1(7,49)&
   +2D0*r1x2E*(VS0(7,28)-ZxZpE*VS1(7,28))
VS0(7,78)=QCy*VS0(7,53)+WQy*VS1(7,53)&
   +2D0*r1x2E*(VS0(7,34)-ZxZpE*VS1(7,34))&
   +2D0*HfxZpE*VS1(3,53)
VS0(7,79)=QCz*VS0(7,51)+WQz*VS1(7,51)&
   +3D0*r1x2E*(VS0(7,30)-ZxZpE*VS1(7,30))
VS0(7,80)=QCz*VS0(7,52)+WQz*VS1(7,52)&
   +3D0*r1x2E*(VS0(7,31)-ZxZpE*VS1(7,31))
VS0(7,81)=QCz*VS0(7,53)+WQz*VS1(7,53)&
   +3D0*r1x2E*(VS0(7,32)-ZxZpE*VS1(7,32))
VS0(7,82)=QCz*VS0(7,54)+WQz*VS1(7,54)&
   +4D0*r1x2E*(VS0(7,33)-ZxZpE*VS1(7,33))
VS0(7,83)=QCz*VS0(7,55)+WQz*VS1(7,55)&
   +4D0*r1x2E*(VS0(7,34)-ZxZpE*VS1(7,34))
VS0(7,84)=QCz*VS0(7,56)+WQz*VS1(7,56)&
   +5D0*r1x2E*(VS0(7,35)-ZxZpE*VS1(7,35))
VS0(8,57)=QCx*VS0(8,36)+WQx*VS1(8,36)-r1x2E*VR1(8,36)&
   +5D0*r1x2E*(VS0(8,21)-ZxZpE*VS1(8,21))&
   +HfxZpE*VS1(4,36)
VS0(8,58)=QCx*VS0(8,37)+WQx*VS1(8,37)-r1x2E*VR1(8,37)&
   +4D0*r1x2E*(VS0(8,22)-ZxZpE*VS1(8,22))&
   +HfxZpE*VS1(4,37)
VS0(8,59)=QCx*VS0(8,38)+WQx*VS1(8,38)-r1x2E*VR1(8,38)&
   +3D0*r1x2E*(VS0(8,23)-ZxZpE*VS1(8,23))&
   +HfxZpE*VS1(4,38)
VS0(8,60)=QCx*VS0(8,39)+WQx*VS1(8,39)-r1x2E*VR1(8,39)&
   +2D0*r1x2E*(VS0(8,24)-ZxZpE*VS1(8,24))&
   +HfxZpE*VS1(4,39)
VS0(8,61)=QCy*VS0(8,39)+WQy*VS1(8,39)&
   +3D0*r1x2E*(VS0(8,23)-ZxZpE*VS1(8,23))
VS0(8,62)=QCy*VS0(8,40)+WQy*VS1(8,40)&
   +4D0*r1x2E*(VS0(8,24)-ZxZpE*VS1(8,24))
VS0(8,63)=QCy*VS0(8,41)+WQy*VS1(8,41)&
   +5D0*r1x2E*(VS0(8,25)-ZxZpE*VS1(8,25))
VS0(8,64)=QCx*VS0(8,42)+WQx*VS1(8,42)-r1x2E*VR1(8,42)&
   +4D0*r1x2E*(VS0(8,26)-ZxZpE*VS1(8,26))&
   +HfxZpE*VS1(4,42)
VS0(8,65)=QCx*VS0(8,43)+WQx*VS1(8,43)-r1x2E*VR1(8,43)&
   +3D0*r1x2E*(VS0(8,27)-ZxZpE*VS1(8,27))&
   +HfxZpE*VS1(4,43)
VS0(8,66)=QCx*VS0(8,44)+WQx*VS1(8,44)-r1x2E*VR1(8,44)&
   +2D0*r1x2E*(VS0(8,28)-ZxZpE*VS1(8,28))&
   +HfxZpE*VS1(4,44)
VS0(8,67)=QCy*VS0(8,44)+WQy*VS1(8,44)&
   +2D0*r1x2E*(VS0(8,27)-ZxZpE*VS1(8,27))
VS0(8,68)=QCy*VS0(8,45)+WQy*VS1(8,45)&
   +3D0*r1x2E*(VS0(8,28)-ZxZpE*VS1(8,28))
VS0(8,69)=QCy*VS0(8,46)+WQy*VS1(8,46)&
   +4D0*r1x2E*(VS0(8,29)-ZxZpE*VS1(8,29))
VS0(8,70)=QCx*VS0(8,47)+WQx*VS1(8,47)-r1x2E*VR1(8,47)&
   +3D0*r1x2E*(VS0(8,30)-ZxZpE*VS1(8,30))&
   +HfxZpE*VS1(4,47)
VS0(8,71)=QCx*VS0(8,48)+WQx*VS1(8,48)-r1x2E*VR1(8,48)&
   +2D0*r1x2E*(VS0(8,31)-ZxZpE*VS1(8,31))&
   +HfxZpE*VS1(4,48)
VS0(8,72)=QCx*VS0(8,49)+WQx*VS1(8,49)-r1x2E*VR1(8,49)&
   +r1x2E*(VS0(8,32)-ZxZpE*VS1(8,32))&
   +HfxZpE*VS1(4,49)
VS0(8,73)=QCy*VS0(8,49)+WQy*VS1(8,49)&
   +2D0*r1x2E*(VS0(8,31)-ZxZpE*VS1(8,31))
VS0(8,74)=QCy*VS0(8,50)+WQy*VS1(8,50)&
   +3D0*r1x2E*(VS0(8,32)-ZxZpE*VS1(8,32))
VS0(8,75)=QCx*VS0(8,51)+WQx*VS1(8,51)-r1x2E*VR1(8,51)&
   +2D0*r1x2E*(VS0(8,33)-ZxZpE*VS1(8,33))&
   +HfxZpE*VS1(4,51)
VS0(8,76)=QCz*VS0(8,48)+WQz*VS1(8,48)&
   +2D0*r1x2E*(VS0(8,27)-ZxZpE*VS1(8,27))&
   +HfxZpE*VS1(2,48)
VS0(8,77)=QCz*VS0(8,49)+WQz*VS1(8,49)&
   +2D0*r1x2E*(VS0(8,28)-ZxZpE*VS1(8,28))&
   +HfxZpE*VS1(2,49)
VS0(8,78)=QCy*VS0(8,53)+WQy*VS1(8,53)&
   +2D0*r1x2E*(VS0(8,34)-ZxZpE*VS1(8,34))
VS0(8,79)=QCz*VS0(8,51)+WQz*VS1(8,51)&
   +3D0*r1x2E*(VS0(8,30)-ZxZpE*VS1(8,30))&
   +HfxZpE*VS1(2,51)
VS0(8,80)=QCz*VS0(8,52)+WQz*VS1(8,52)&
   +3D0*r1x2E*(VS0(8,31)-ZxZpE*VS1(8,31))&
   +HfxZpE*VS1(2,52)
VS0(8,81)=QCz*VS0(8,53)+WQz*VS1(8,53)&
   +3D0*r1x2E*(VS0(8,32)-ZxZpE*VS1(8,32))&
   +HfxZpE*VS1(2,53)
VS0(8,82)=QCz*VS0(8,54)+WQz*VS1(8,54)&
   +4D0*r1x2E*(VS0(8,33)-ZxZpE*VS1(8,33))&
   +HfxZpE*VS1(2,54)
VS0(8,83)=QCz*VS0(8,55)+WQz*VS1(8,55)&
   +4D0*r1x2E*(VS0(8,34)-ZxZpE*VS1(8,34))&
   +HfxZpE*VS1(2,55)
VS0(8,84)=QCz*VS0(8,56)+WQz*VS1(8,56)&
   +5D0*r1x2E*(VS0(8,35)-ZxZpE*VS1(8,35))&
   +HfxZpE*VS1(2,56)
VS0(9,57)=QCx*VS0(9,36)+WQx*VS1(9,36)-r1x2E*VR1(9,36)&
   +5D0*r1x2E*(VS0(9,21)-ZxZpE*VS1(9,21))
VS0(9,58)=QCx*VS0(9,37)+WQx*VS1(9,37)-r1x2E*VR1(9,37)&
   +4D0*r1x2E*(VS0(9,22)-ZxZpE*VS1(9,22))
VS0(9,59)=QCx*VS0(9,38)+WQx*VS1(9,38)-r1x2E*VR1(9,38)&
   +3D0*r1x2E*(VS0(9,23)-ZxZpE*VS1(9,23))
VS0(9,60)=QCx*VS0(9,39)+WQx*VS1(9,39)-r1x2E*VR1(9,39)&
   +2D0*r1x2E*(VS0(9,24)-ZxZpE*VS1(9,24))
VS0(9,61)=QCy*VS0(9,39)+WQy*VS1(9,39)&
   +3D0*r1x2E*(VS0(9,23)-ZxZpE*VS1(9,23))&
   +HfxZpE*VS1(4,39)
VS0(9,62)=QCy*VS0(9,40)+WQy*VS1(9,40)&
   +4D0*r1x2E*(VS0(9,24)-ZxZpE*VS1(9,24))&
   +HfxZpE*VS1(4,40)
VS0(9,63)=QCy*VS0(9,41)+WQy*VS1(9,41)&
   +5D0*r1x2E*(VS0(9,25)-ZxZpE*VS1(9,25))&
   +HfxZpE*VS1(4,41)
VS0(9,64)=QCx*VS0(9,42)+WQx*VS1(9,42)-r1x2E*VR1(9,42)&
   +4D0*r1x2E*(VS0(9,26)-ZxZpE*VS1(9,26))
VS0(9,65)=QCx*VS0(9,43)+WQx*VS1(9,43)-r1x2E*VR1(9,43)&
   +3D0*r1x2E*(VS0(9,27)-ZxZpE*VS1(9,27))
VS0(9,66)=QCx*VS0(9,44)+WQx*VS1(9,44)-r1x2E*VR1(9,44)&
   +2D0*r1x2E*(VS0(9,28)-ZxZpE*VS1(9,28))
VS0(9,67)=QCy*VS0(9,44)+WQy*VS1(9,44)&
   +2D0*r1x2E*(VS0(9,27)-ZxZpE*VS1(9,27))&
   +HfxZpE*VS1(4,44)
VS0(9,68)=QCy*VS0(9,45)+WQy*VS1(9,45)&
   +3D0*r1x2E*(VS0(9,28)-ZxZpE*VS1(9,28))&
   +HfxZpE*VS1(4,45)
VS0(9,69)=QCy*VS0(9,46)+WQy*VS1(9,46)&
   +4D0*r1x2E*(VS0(9,29)-ZxZpE*VS1(9,29))&
   +HfxZpE*VS1(4,46)
VS0(9,70)=QCx*VS0(9,47)+WQx*VS1(9,47)-r1x2E*VR1(9,47)&
   +3D0*r1x2E*(VS0(9,30)-ZxZpE*VS1(9,30))
VS0(9,71)=QCx*VS0(9,48)+WQx*VS1(9,48)-r1x2E*VR1(9,48)&
   +2D0*r1x2E*(VS0(9,31)-ZxZpE*VS1(9,31))
VS0(9,72)=QCx*VS0(9,49)+WQx*VS1(9,49)-r1x2E*VR1(9,49)&
   +r1x2E*(VS0(9,32)-ZxZpE*VS1(9,32))
VS0(9,73)=QCy*VS0(9,49)+WQy*VS1(9,49)&
   +2D0*r1x2E*(VS0(9,31)-ZxZpE*VS1(9,31))&
   +HfxZpE*VS1(4,49)
VS0(9,74)=QCy*VS0(9,50)+WQy*VS1(9,50)&
   +3D0*r1x2E*(VS0(9,32)-ZxZpE*VS1(9,32))&
   +HfxZpE*VS1(4,50)
VS0(9,75)=QCx*VS0(9,51)+WQx*VS1(9,51)-r1x2E*VR1(9,51)&
   +2D0*r1x2E*(VS0(9,33)-ZxZpE*VS1(9,33))
VS0(9,76)=QCz*VS0(9,48)+WQz*VS1(9,48)&
   +2D0*r1x2E*(VS0(9,27)-ZxZpE*VS1(9,27))&
   +HfxZpE*VS1(3,48)
VS0(9,77)=QCz*VS0(9,49)+WQz*VS1(9,49)&
   +2D0*r1x2E*(VS0(9,28)-ZxZpE*VS1(9,28))&
   +HfxZpE*VS1(3,49)
VS0(9,78)=QCy*VS0(9,53)+WQy*VS1(9,53)&
   +2D0*r1x2E*(VS0(9,34)-ZxZpE*VS1(9,34))&
   +HfxZpE*VS1(4,53)
VS0(9,79)=QCz*VS0(9,51)+WQz*VS1(9,51)&
   +3D0*r1x2E*(VS0(9,30)-ZxZpE*VS1(9,30))&
   +HfxZpE*VS1(3,51)
VS0(9,80)=QCz*VS0(9,52)+WQz*VS1(9,52)&
   +3D0*r1x2E*(VS0(9,31)-ZxZpE*VS1(9,31))&
   +HfxZpE*VS1(3,52)
VS0(9,81)=QCz*VS0(9,53)+WQz*VS1(9,53)&
   +3D0*r1x2E*(VS0(9,32)-ZxZpE*VS1(9,32))&
   +HfxZpE*VS1(3,53)
VS0(9,82)=QCz*VS0(9,54)+WQz*VS1(9,54)&
   +4D0*r1x2E*(VS0(9,33)-ZxZpE*VS1(9,33))&
   +HfxZpE*VS1(3,54)
VS0(9,83)=QCz*VS0(9,55)+WQz*VS1(9,55)&
   +4D0*r1x2E*(VS0(9,34)-ZxZpE*VS1(9,34))&
   +HfxZpE*VS1(3,55)
VS0(9,84)=QCz*VS0(9,56)+WQz*VS1(9,56)&
   +5D0*r1x2E*(VS0(9,35)-ZxZpE*VS1(9,35))&
   +HfxZpE*VS1(3,56)
VS0(10,57)=QCx*VS0(10,36)+WQx*VS1(10,36)-r1x2E*VR1(10,36)&
   +5D0*r1x2E*(VS0(10,21)-ZxZpE*VS1(10,21))
VS0(10,58)=QCx*VS0(10,37)+WQx*VS1(10,37)-r1x2E*VR1(10,37)&
   +4D0*r1x2E*(VS0(10,22)-ZxZpE*VS1(10,22))
VS0(10,59)=QCx*VS0(10,38)+WQx*VS1(10,38)-r1x2E*VR1(10,38)&
   +3D0*r1x2E*(VS0(10,23)-ZxZpE*VS1(10,23))
VS0(10,60)=QCx*VS0(10,39)+WQx*VS1(10,39)-r1x2E*VR1(10,39)&
   +2D0*r1x2E*(VS0(10,24)-ZxZpE*VS1(10,24))
VS0(10,61)=QCy*VS0(10,39)+WQy*VS1(10,39)&
   +3D0*r1x2E*(VS0(10,23)-ZxZpE*VS1(10,23))
VS0(10,62)=QCy*VS0(10,40)+WQy*VS1(10,40)&
   +4D0*r1x2E*(VS0(10,24)-ZxZpE*VS1(10,24))
VS0(10,63)=QCy*VS0(10,41)+WQy*VS1(10,41)&
   +5D0*r1x2E*(VS0(10,25)-ZxZpE*VS1(10,25))
VS0(10,64)=QCx*VS0(10,42)+WQx*VS1(10,42)-r1x2E*VR1(10,42)&
   +4D0*r1x2E*(VS0(10,26)-ZxZpE*VS1(10,26))
VS0(10,65)=QCx*VS0(10,43)+WQx*VS1(10,43)-r1x2E*VR1(10,43)&
   +3D0*r1x2E*(VS0(10,27)-ZxZpE*VS1(10,27))
VS0(10,66)=QCx*VS0(10,44)+WQx*VS1(10,44)-r1x2E*VR1(10,44)&
   +2D0*r1x2E*(VS0(10,28)-ZxZpE*VS1(10,28))
VS0(10,67)=QCy*VS0(10,44)+WQy*VS1(10,44)&
   +2D0*r1x2E*(VS0(10,27)-ZxZpE*VS1(10,27))
VS0(10,68)=QCy*VS0(10,45)+WQy*VS1(10,45)&
   +3D0*r1x2E*(VS0(10,28)-ZxZpE*VS1(10,28))
VS0(10,69)=QCy*VS0(10,46)+WQy*VS1(10,46)&
   +4D0*r1x2E*(VS0(10,29)-ZxZpE*VS1(10,29))
VS0(10,70)=QCx*VS0(10,47)+WQx*VS1(10,47)-r1x2E*VR1(10,47)&
   +3D0*r1x2E*(VS0(10,30)-ZxZpE*VS1(10,30))
VS0(10,71)=QCx*VS0(10,48)+WQx*VS1(10,48)-r1x2E*VR1(10,48)&
   +2D0*r1x2E*(VS0(10,31)-ZxZpE*VS1(10,31))
VS0(10,72)=QCx*VS0(10,49)+WQx*VS1(10,49)-r1x2E*VR1(10,49)&
   +r1x2E*(VS0(10,32)-ZxZpE*VS1(10,32))
VS0(10,73)=QCy*VS0(10,49)+WQy*VS1(10,49)&
   +2D0*r1x2E*(VS0(10,31)-ZxZpE*VS1(10,31))
VS0(10,74)=QCy*VS0(10,50)+WQy*VS1(10,50)&
   +3D0*r1x2E*(VS0(10,32)-ZxZpE*VS1(10,32))
VS0(10,75)=QCx*VS0(10,51)+WQx*VS1(10,51)-r1x2E*VR1(10,51)&
   +2D0*r1x2E*(VS0(10,33)-ZxZpE*VS1(10,33))
VS0(10,76)=QCz*VS0(10,48)+WQz*VS1(10,48)&
   +2D0*r1x2E*(VS0(10,27)-ZxZpE*VS1(10,27))&
   +2D0*HfxZpE*VS1(4,48)
VS0(10,77)=QCz*VS0(10,49)+WQz*VS1(10,49)&
   +2D0*r1x2E*(VS0(10,28)-ZxZpE*VS1(10,28))&
   +2D0*HfxZpE*VS1(4,49)
VS0(10,78)=QCy*VS0(10,53)+WQy*VS1(10,53)&
   +2D0*r1x2E*(VS0(10,34)-ZxZpE*VS1(10,34))
VS0(10,79)=QCz*VS0(10,51)+WQz*VS1(10,51)&
   +3D0*r1x2E*(VS0(10,30)-ZxZpE*VS1(10,30))&
   +2D0*HfxZpE*VS1(4,51)
VS0(10,80)=QCz*VS0(10,52)+WQz*VS1(10,52)&
   +3D0*r1x2E*(VS0(10,31)-ZxZpE*VS1(10,31))&
   +2D0*HfxZpE*VS1(4,52)
VS0(10,81)=QCz*VS0(10,53)+WQz*VS1(10,53)&
   +3D0*r1x2E*(VS0(10,32)-ZxZpE*VS1(10,32))&
   +2D0*HfxZpE*VS1(4,53)
VS0(10,82)=QCz*VS0(10,54)+WQz*VS1(10,54)&
   +4D0*r1x2E*(VS0(10,33)-ZxZpE*VS1(10,33))&
   +2D0*HfxZpE*VS1(4,54)
VS0(10,83)=QCz*VS0(10,55)+WQz*VS1(10,55)&
   +4D0*r1x2E*(VS0(10,34)-ZxZpE*VS1(10,34))&
   +2D0*HfxZpE*VS1(4,55)
VS0(10,84)=QCz*VS0(10,56)+WQz*VS1(10,56)&
   +5D0*r1x2E*(VS0(10,35)-ZxZpE*VS1(10,35))&
   +2D0*HfxZpE*VS1(4,56)
CASE(2)
VS0(5,57)=QCx*VS0(5,36)+WQx*VS1(5,36)&
   +5D0*r1x2E*(VS0(5,21)-ZxZpE*VS1(5,21))&
   +2D0*HfxZpE*VS1(2,36)
VS0(5,58)=QCx*VS0(5,37)+WQx*VS1(5,37)&
   +4D0*r1x2E*(VS0(5,22)-ZxZpE*VS1(5,22))&
   +2D0*HfxZpE*VS1(2,37)
VS0(5,59)=QCx*VS0(5,38)+WQx*VS1(5,38)&
   +3D0*r1x2E*(VS0(5,23)-ZxZpE*VS1(5,23))&
   +2D0*HfxZpE*VS1(2,38)
VS0(5,60)=QCx*VS0(5,39)+WQx*VS1(5,39)&
   +2D0*r1x2E*(VS0(5,24)-ZxZpE*VS1(5,24))&
   +2D0*HfxZpE*VS1(2,39)
VS0(5,61)=QCy*VS0(5,39)+WQy*VS1(5,39)-r1x2E*VR1(5,39)&
   +3D0*r1x2E*(VS0(5,23)-ZxZpE*VS1(5,23))
VS0(5,62)=QCy*VS0(5,40)+WQy*VS1(5,40)-r1x2E*VR1(5,40)&
   +4D0*r1x2E*(VS0(5,24)-ZxZpE*VS1(5,24))
VS0(5,63)=QCy*VS0(5,41)+WQy*VS1(5,41)-r1x2E*VR1(5,41)&
   +5D0*r1x2E*(VS0(5,25)-ZxZpE*VS1(5,25))
VS0(5,64)=QCx*VS0(5,42)+WQx*VS1(5,42)&
   +4D0*r1x2E*(VS0(5,26)-ZxZpE*VS1(5,26))&
   +2D0*HfxZpE*VS1(2,42)
VS0(5,65)=QCx*VS0(5,43)+WQx*VS1(5,43)&
   +3D0*r1x2E*(VS0(5,27)-ZxZpE*VS1(5,27))&
   +2D0*HfxZpE*VS1(2,43)
VS0(5,66)=QCx*VS0(5,44)+WQx*VS1(5,44)&
   +2D0*r1x2E*(VS0(5,28)-ZxZpE*VS1(5,28))&
   +2D0*HfxZpE*VS1(2,44)
VS0(5,67)=QCy*VS0(5,44)+WQy*VS1(5,44)-r1x2E*VR1(5,44)&
   +2D0*r1x2E*(VS0(5,27)-ZxZpE*VS1(5,27))
VS0(5,68)=QCy*VS0(5,45)+WQy*VS1(5,45)-r1x2E*VR1(5,45)&
   +3D0*r1x2E*(VS0(5,28)-ZxZpE*VS1(5,28))
VS0(5,69)=QCy*VS0(5,46)+WQy*VS1(5,46)-r1x2E*VR1(5,46)&
   +4D0*r1x2E*(VS0(5,29)-ZxZpE*VS1(5,29))
VS0(5,70)=QCx*VS0(5,47)+WQx*VS1(5,47)&
   +3D0*r1x2E*(VS0(5,30)-ZxZpE*VS1(5,30))&
   +2D0*HfxZpE*VS1(2,47)
VS0(5,71)=QCx*VS0(5,48)+WQx*VS1(5,48)&
   +2D0*r1x2E*(VS0(5,31)-ZxZpE*VS1(5,31))&
   +2D0*HfxZpE*VS1(2,48)
VS0(5,72)=QCx*VS0(5,49)+WQx*VS1(5,49)&
   +r1x2E*(VS0(5,32)-ZxZpE*VS1(5,32))&
   +2D0*HfxZpE*VS1(2,49)
VS0(5,73)=QCy*VS0(5,49)+WQy*VS1(5,49)-r1x2E*VR1(5,49)&
   +2D0*r1x2E*(VS0(5,31)-ZxZpE*VS1(5,31))
VS0(5,74)=QCy*VS0(5,50)+WQy*VS1(5,50)-r1x2E*VR1(5,50)&
   +3D0*r1x2E*(VS0(5,32)-ZxZpE*VS1(5,32))
VS0(5,75)=QCx*VS0(5,51)+WQx*VS1(5,51)&
   +2D0*r1x2E*(VS0(5,33)-ZxZpE*VS1(5,33))&
   +2D0*HfxZpE*VS1(2,51)
VS0(5,76)=QCz*VS0(5,48)+WQz*VS1(5,48)&
   +2D0*r1x2E*(VS0(5,27)-ZxZpE*VS1(5,27))
VS0(5,77)=QCz*VS0(5,49)+WQz*VS1(5,49)&
   +2D0*r1x2E*(VS0(5,28)-ZxZpE*VS1(5,28))
VS0(5,78)=QCy*VS0(5,53)+WQy*VS1(5,53)-r1x2E*VR1(5,53)&
   +2D0*r1x2E*(VS0(5,34)-ZxZpE*VS1(5,34))
VS0(5,79)=QCz*VS0(5,51)+WQz*VS1(5,51)&
   +3D0*r1x2E*(VS0(5,30)-ZxZpE*VS1(5,30))
VS0(5,80)=QCz*VS0(5,52)+WQz*VS1(5,52)&
   +3D0*r1x2E*(VS0(5,31)-ZxZpE*VS1(5,31))
VS0(5,81)=QCz*VS0(5,53)+WQz*VS1(5,53)&
   +3D0*r1x2E*(VS0(5,32)-ZxZpE*VS1(5,32))
VS0(5,82)=QCz*VS0(5,54)+WQz*VS1(5,54)&
   +4D0*r1x2E*(VS0(5,33)-ZxZpE*VS1(5,33))
VS0(5,83)=QCz*VS0(5,55)+WQz*VS1(5,55)&
   +4D0*r1x2E*(VS0(5,34)-ZxZpE*VS1(5,34))
VS0(5,84)=QCz*VS0(5,56)+WQz*VS1(5,56)&
   +5D0*r1x2E*(VS0(5,35)-ZxZpE*VS1(5,35))
VS0(6,57)=QCx*VS0(6,36)+WQx*VS1(6,36)&
   +5D0*r1x2E*(VS0(6,21)-ZxZpE*VS1(6,21))&
   +HfxZpE*VS1(3,36)
VS0(6,58)=QCx*VS0(6,37)+WQx*VS1(6,37)&
   +4D0*r1x2E*(VS0(6,22)-ZxZpE*VS1(6,22))&
   +HfxZpE*VS1(3,37)
VS0(6,59)=QCx*VS0(6,38)+WQx*VS1(6,38)&
   +3D0*r1x2E*(VS0(6,23)-ZxZpE*VS1(6,23))&
   +HfxZpE*VS1(3,38)
VS0(6,60)=QCx*VS0(6,39)+WQx*VS1(6,39)&
   +2D0*r1x2E*(VS0(6,24)-ZxZpE*VS1(6,24))&
   +HfxZpE*VS1(3,39)
VS0(6,61)=QCy*VS0(6,39)+WQy*VS1(6,39)-r1x2E*VR1(6,39)&
   +3D0*r1x2E*(VS0(6,23)-ZxZpE*VS1(6,23))&
   +HfxZpE*VS1(2,39)
VS0(6,62)=QCy*VS0(6,40)+WQy*VS1(6,40)-r1x2E*VR1(6,40)&
   +4D0*r1x2E*(VS0(6,24)-ZxZpE*VS1(6,24))&
   +HfxZpE*VS1(2,40)
VS0(6,63)=QCy*VS0(6,41)+WQy*VS1(6,41)-r1x2E*VR1(6,41)&
   +5D0*r1x2E*(VS0(6,25)-ZxZpE*VS1(6,25))&
   +HfxZpE*VS1(2,41)
VS0(6,64)=QCx*VS0(6,42)+WQx*VS1(6,42)&
   +4D0*r1x2E*(VS0(6,26)-ZxZpE*VS1(6,26))&
   +HfxZpE*VS1(3,42)
VS0(6,65)=QCx*VS0(6,43)+WQx*VS1(6,43)&
   +3D0*r1x2E*(VS0(6,27)-ZxZpE*VS1(6,27))&
   +HfxZpE*VS1(3,43)
VS0(6,66)=QCx*VS0(6,44)+WQx*VS1(6,44)&
   +2D0*r1x2E*(VS0(6,28)-ZxZpE*VS1(6,28))&
   +HfxZpE*VS1(3,44)
VS0(6,67)=QCy*VS0(6,44)+WQy*VS1(6,44)-r1x2E*VR1(6,44)&
   +2D0*r1x2E*(VS0(6,27)-ZxZpE*VS1(6,27))&
   +HfxZpE*VS1(2,44)
VS0(6,68)=QCy*VS0(6,45)+WQy*VS1(6,45)-r1x2E*VR1(6,45)&
   +3D0*r1x2E*(VS0(6,28)-ZxZpE*VS1(6,28))&
   +HfxZpE*VS1(2,45)
VS0(6,69)=QCy*VS0(6,46)+WQy*VS1(6,46)-r1x2E*VR1(6,46)&
   +4D0*r1x2E*(VS0(6,29)-ZxZpE*VS1(6,29))&
   +HfxZpE*VS1(2,46)
VS0(6,70)=QCx*VS0(6,47)+WQx*VS1(6,47)&
   +3D0*r1x2E*(VS0(6,30)-ZxZpE*VS1(6,30))&
   +HfxZpE*VS1(3,47)
VS0(6,71)=QCx*VS0(6,48)+WQx*VS1(6,48)&
   +2D0*r1x2E*(VS0(6,31)-ZxZpE*VS1(6,31))&
   +HfxZpE*VS1(3,48)
VS0(6,72)=QCx*VS0(6,49)+WQx*VS1(6,49)&
   +r1x2E*(VS0(6,32)-ZxZpE*VS1(6,32))&
   +HfxZpE*VS1(3,49)
VS0(6,73)=QCy*VS0(6,49)+WQy*VS1(6,49)-r1x2E*VR1(6,49)&
   +2D0*r1x2E*(VS0(6,31)-ZxZpE*VS1(6,31))&
   +HfxZpE*VS1(2,49)
VS0(6,74)=QCy*VS0(6,50)+WQy*VS1(6,50)-r1x2E*VR1(6,50)&
   +3D0*r1x2E*(VS0(6,32)-ZxZpE*VS1(6,32))&
   +HfxZpE*VS1(2,50)
VS0(6,75)=QCx*VS0(6,51)+WQx*VS1(6,51)&
   +2D0*r1x2E*(VS0(6,33)-ZxZpE*VS1(6,33))&
   +HfxZpE*VS1(3,51)
VS0(6,76)=QCz*VS0(6,48)+WQz*VS1(6,48)&
   +2D0*r1x2E*(VS0(6,27)-ZxZpE*VS1(6,27))
VS0(6,77)=QCz*VS0(6,49)+WQz*VS1(6,49)&
   +2D0*r1x2E*(VS0(6,28)-ZxZpE*VS1(6,28))
VS0(6,78)=QCy*VS0(6,53)+WQy*VS1(6,53)-r1x2E*VR1(6,53)&
   +2D0*r1x2E*(VS0(6,34)-ZxZpE*VS1(6,34))&
   +HfxZpE*VS1(2,53)
VS0(6,79)=QCz*VS0(6,51)+WQz*VS1(6,51)&
   +3D0*r1x2E*(VS0(6,30)-ZxZpE*VS1(6,30))
VS0(6,80)=QCz*VS0(6,52)+WQz*VS1(6,52)&
   +3D0*r1x2E*(VS0(6,31)-ZxZpE*VS1(6,31))
VS0(6,81)=QCz*VS0(6,53)+WQz*VS1(6,53)&
   +3D0*r1x2E*(VS0(6,32)-ZxZpE*VS1(6,32))
VS0(6,82)=QCz*VS0(6,54)+WQz*VS1(6,54)&
   +4D0*r1x2E*(VS0(6,33)-ZxZpE*VS1(6,33))
VS0(6,83)=QCz*VS0(6,55)+WQz*VS1(6,55)&
   +4D0*r1x2E*(VS0(6,34)-ZxZpE*VS1(6,34))
VS0(6,84)=QCz*VS0(6,56)+WQz*VS1(6,56)&
   +5D0*r1x2E*(VS0(6,35)-ZxZpE*VS1(6,35))
VS0(7,57)=QCx*VS0(7,36)+WQx*VS1(7,36)&
   +5D0*r1x2E*(VS0(7,21)-ZxZpE*VS1(7,21))
VS0(7,58)=QCx*VS0(7,37)+WQx*VS1(7,37)&
   +4D0*r1x2E*(VS0(7,22)-ZxZpE*VS1(7,22))
VS0(7,59)=QCx*VS0(7,38)+WQx*VS1(7,38)&
   +3D0*r1x2E*(VS0(7,23)-ZxZpE*VS1(7,23))
VS0(7,60)=QCx*VS0(7,39)+WQx*VS1(7,39)&
   +2D0*r1x2E*(VS0(7,24)-ZxZpE*VS1(7,24))
VS0(7,61)=QCy*VS0(7,39)+WQy*VS1(7,39)-r1x2E*VR1(7,39)&
   +3D0*r1x2E*(VS0(7,23)-ZxZpE*VS1(7,23))&
   +2D0*HfxZpE*VS1(3,39)
VS0(7,62)=QCy*VS0(7,40)+WQy*VS1(7,40)-r1x2E*VR1(7,40)&
   +4D0*r1x2E*(VS0(7,24)-ZxZpE*VS1(7,24))&
   +2D0*HfxZpE*VS1(3,40)
VS0(7,63)=QCy*VS0(7,41)+WQy*VS1(7,41)-r1x2E*VR1(7,41)&
   +5D0*r1x2E*(VS0(7,25)-ZxZpE*VS1(7,25))&
   +2D0*HfxZpE*VS1(3,41)
VS0(7,64)=QCx*VS0(7,42)+WQx*VS1(7,42)&
   +4D0*r1x2E*(VS0(7,26)-ZxZpE*VS1(7,26))
VS0(7,65)=QCx*VS0(7,43)+WQx*VS1(7,43)&
   +3D0*r1x2E*(VS0(7,27)-ZxZpE*VS1(7,27))
VS0(7,66)=QCx*VS0(7,44)+WQx*VS1(7,44)&
   +2D0*r1x2E*(VS0(7,28)-ZxZpE*VS1(7,28))
VS0(7,67)=QCy*VS0(7,44)+WQy*VS1(7,44)-r1x2E*VR1(7,44)&
   +2D0*r1x2E*(VS0(7,27)-ZxZpE*VS1(7,27))&
   +2D0*HfxZpE*VS1(3,44)
VS0(7,68)=QCy*VS0(7,45)+WQy*VS1(7,45)-r1x2E*VR1(7,45)&
   +3D0*r1x2E*(VS0(7,28)-ZxZpE*VS1(7,28))&
   +2D0*HfxZpE*VS1(3,45)
VS0(7,69)=QCy*VS0(7,46)+WQy*VS1(7,46)-r1x2E*VR1(7,46)&
   +4D0*r1x2E*(VS0(7,29)-ZxZpE*VS1(7,29))&
   +2D0*HfxZpE*VS1(3,46)
VS0(7,70)=QCx*VS0(7,47)+WQx*VS1(7,47)&
   +3D0*r1x2E*(VS0(7,30)-ZxZpE*VS1(7,30))
VS0(7,71)=QCx*VS0(7,48)+WQx*VS1(7,48)&
   +2D0*r1x2E*(VS0(7,31)-ZxZpE*VS1(7,31))
VS0(7,72)=QCx*VS0(7,49)+WQx*VS1(7,49)&
   +r1x2E*(VS0(7,32)-ZxZpE*VS1(7,32))
VS0(7,73)=QCy*VS0(7,49)+WQy*VS1(7,49)-r1x2E*VR1(7,49)&
   +2D0*r1x2E*(VS0(7,31)-ZxZpE*VS1(7,31))&
   +2D0*HfxZpE*VS1(3,49)
VS0(7,74)=QCy*VS0(7,50)+WQy*VS1(7,50)-r1x2E*VR1(7,50)&
   +3D0*r1x2E*(VS0(7,32)-ZxZpE*VS1(7,32))&
   +2D0*HfxZpE*VS1(3,50)
VS0(7,75)=QCx*VS0(7,51)+WQx*VS1(7,51)&
   +2D0*r1x2E*(VS0(7,33)-ZxZpE*VS1(7,33))
VS0(7,76)=QCz*VS0(7,48)+WQz*VS1(7,48)&
   +2D0*r1x2E*(VS0(7,27)-ZxZpE*VS1(7,27))
VS0(7,77)=QCz*VS0(7,49)+WQz*VS1(7,49)&
   +2D0*r1x2E*(VS0(7,28)-ZxZpE*VS1(7,28))
VS0(7,78)=QCy*VS0(7,53)+WQy*VS1(7,53)-r1x2E*VR1(7,53)&
   +2D0*r1x2E*(VS0(7,34)-ZxZpE*VS1(7,34))&
   +2D0*HfxZpE*VS1(3,53)
VS0(7,79)=QCz*VS0(7,51)+WQz*VS1(7,51)&
   +3D0*r1x2E*(VS0(7,30)-ZxZpE*VS1(7,30))
VS0(7,80)=QCz*VS0(7,52)+WQz*VS1(7,52)&
   +3D0*r1x2E*(VS0(7,31)-ZxZpE*VS1(7,31))
VS0(7,81)=QCz*VS0(7,53)+WQz*VS1(7,53)&
   +3D0*r1x2E*(VS0(7,32)-ZxZpE*VS1(7,32))
VS0(7,82)=QCz*VS0(7,54)+WQz*VS1(7,54)&
   +4D0*r1x2E*(VS0(7,33)-ZxZpE*VS1(7,33))
VS0(7,83)=QCz*VS0(7,55)+WQz*VS1(7,55)&
   +4D0*r1x2E*(VS0(7,34)-ZxZpE*VS1(7,34))
VS0(7,84)=QCz*VS0(7,56)+WQz*VS1(7,56)&
   +5D0*r1x2E*(VS0(7,35)-ZxZpE*VS1(7,35))
VS0(8,57)=QCx*VS0(8,36)+WQx*VS1(8,36)&
   +5D0*r1x2E*(VS0(8,21)-ZxZpE*VS1(8,21))&
   +HfxZpE*VS1(4,36)
VS0(8,58)=QCx*VS0(8,37)+WQx*VS1(8,37)&
   +4D0*r1x2E*(VS0(8,22)-ZxZpE*VS1(8,22))&
   +HfxZpE*VS1(4,37)
VS0(8,59)=QCx*VS0(8,38)+WQx*VS1(8,38)&
   +3D0*r1x2E*(VS0(8,23)-ZxZpE*VS1(8,23))&
   +HfxZpE*VS1(4,38)
VS0(8,60)=QCx*VS0(8,39)+WQx*VS1(8,39)&
   +2D0*r1x2E*(VS0(8,24)-ZxZpE*VS1(8,24))&
   +HfxZpE*VS1(4,39)
VS0(8,61)=QCy*VS0(8,39)+WQy*VS1(8,39)-r1x2E*VR1(8,39)&
   +3D0*r1x2E*(VS0(8,23)-ZxZpE*VS1(8,23))
VS0(8,62)=QCy*VS0(8,40)+WQy*VS1(8,40)-r1x2E*VR1(8,40)&
   +4D0*r1x2E*(VS0(8,24)-ZxZpE*VS1(8,24))
VS0(8,63)=QCy*VS0(8,41)+WQy*VS1(8,41)-r1x2E*VR1(8,41)&
   +5D0*r1x2E*(VS0(8,25)-ZxZpE*VS1(8,25))
VS0(8,64)=QCx*VS0(8,42)+WQx*VS1(8,42)&
   +4D0*r1x2E*(VS0(8,26)-ZxZpE*VS1(8,26))&
   +HfxZpE*VS1(4,42)
VS0(8,65)=QCx*VS0(8,43)+WQx*VS1(8,43)&
   +3D0*r1x2E*(VS0(8,27)-ZxZpE*VS1(8,27))&
   +HfxZpE*VS1(4,43)
VS0(8,66)=QCx*VS0(8,44)+WQx*VS1(8,44)&
   +2D0*r1x2E*(VS0(8,28)-ZxZpE*VS1(8,28))&
   +HfxZpE*VS1(4,44)
VS0(8,67)=QCy*VS0(8,44)+WQy*VS1(8,44)-r1x2E*VR1(8,44)&
   +2D0*r1x2E*(VS0(8,27)-ZxZpE*VS1(8,27))
VS0(8,68)=QCy*VS0(8,45)+WQy*VS1(8,45)-r1x2E*VR1(8,45)&
   +3D0*r1x2E*(VS0(8,28)-ZxZpE*VS1(8,28))
VS0(8,69)=QCy*VS0(8,46)+WQy*VS1(8,46)-r1x2E*VR1(8,46)&
   +4D0*r1x2E*(VS0(8,29)-ZxZpE*VS1(8,29))
VS0(8,70)=QCx*VS0(8,47)+WQx*VS1(8,47)&
   +3D0*r1x2E*(VS0(8,30)-ZxZpE*VS1(8,30))&
   +HfxZpE*VS1(4,47)
VS0(8,71)=QCx*VS0(8,48)+WQx*VS1(8,48)&
   +2D0*r1x2E*(VS0(8,31)-ZxZpE*VS1(8,31))&
   +HfxZpE*VS1(4,48)
VS0(8,72)=QCx*VS0(8,49)+WQx*VS1(8,49)&
   +r1x2E*(VS0(8,32)-ZxZpE*VS1(8,32))&
   +HfxZpE*VS1(4,49)
VS0(8,73)=QCy*VS0(8,49)+WQy*VS1(8,49)-r1x2E*VR1(8,49)&
   +2D0*r1x2E*(VS0(8,31)-ZxZpE*VS1(8,31))
VS0(8,74)=QCy*VS0(8,50)+WQy*VS1(8,50)-r1x2E*VR1(8,50)&
   +3D0*r1x2E*(VS0(8,32)-ZxZpE*VS1(8,32))
VS0(8,75)=QCx*VS0(8,51)+WQx*VS1(8,51)&
   +2D0*r1x2E*(VS0(8,33)-ZxZpE*VS1(8,33))&
   +HfxZpE*VS1(4,51)
VS0(8,76)=QCz*VS0(8,48)+WQz*VS1(8,48)&
   +2D0*r1x2E*(VS0(8,27)-ZxZpE*VS1(8,27))&
   +HfxZpE*VS1(2,48)
VS0(8,77)=QCz*VS0(8,49)+WQz*VS1(8,49)&
   +2D0*r1x2E*(VS0(8,28)-ZxZpE*VS1(8,28))&
   +HfxZpE*VS1(2,49)
VS0(8,78)=QCy*VS0(8,53)+WQy*VS1(8,53)-r1x2E*VR1(8,53)&
   +2D0*r1x2E*(VS0(8,34)-ZxZpE*VS1(8,34))
VS0(8,79)=QCz*VS0(8,51)+WQz*VS1(8,51)&
   +3D0*r1x2E*(VS0(8,30)-ZxZpE*VS1(8,30))&
   +HfxZpE*VS1(2,51)
VS0(8,80)=QCz*VS0(8,52)+WQz*VS1(8,52)&
   +3D0*r1x2E*(VS0(8,31)-ZxZpE*VS1(8,31))&
   +HfxZpE*VS1(2,52)
VS0(8,81)=QCz*VS0(8,53)+WQz*VS1(8,53)&
   +3D0*r1x2E*(VS0(8,32)-ZxZpE*VS1(8,32))&
   +HfxZpE*VS1(2,53)
VS0(8,82)=QCz*VS0(8,54)+WQz*VS1(8,54)&
   +4D0*r1x2E*(VS0(8,33)-ZxZpE*VS1(8,33))&
   +HfxZpE*VS1(2,54)
VS0(8,83)=QCz*VS0(8,55)+WQz*VS1(8,55)&
   +4D0*r1x2E*(VS0(8,34)-ZxZpE*VS1(8,34))&
   +HfxZpE*VS1(2,55)
VS0(8,84)=QCz*VS0(8,56)+WQz*VS1(8,56)&
   +5D0*r1x2E*(VS0(8,35)-ZxZpE*VS1(8,35))&
   +HfxZpE*VS1(2,56)
VS0(9,57)=QCx*VS0(9,36)+WQx*VS1(9,36)&
   +5D0*r1x2E*(VS0(9,21)-ZxZpE*VS1(9,21))
VS0(9,58)=QCx*VS0(9,37)+WQx*VS1(9,37)&
   +4D0*r1x2E*(VS0(9,22)-ZxZpE*VS1(9,22))
VS0(9,59)=QCx*VS0(9,38)+WQx*VS1(9,38)&
   +3D0*r1x2E*(VS0(9,23)-ZxZpE*VS1(9,23))
VS0(9,60)=QCx*VS0(9,39)+WQx*VS1(9,39)&
   +2D0*r1x2E*(VS0(9,24)-ZxZpE*VS1(9,24))
VS0(9,61)=QCy*VS0(9,39)+WQy*VS1(9,39)-r1x2E*VR1(9,39)&
   +3D0*r1x2E*(VS0(9,23)-ZxZpE*VS1(9,23))&
   +HfxZpE*VS1(4,39)
VS0(9,62)=QCy*VS0(9,40)+WQy*VS1(9,40)-r1x2E*VR1(9,40)&
   +4D0*r1x2E*(VS0(9,24)-ZxZpE*VS1(9,24))&
   +HfxZpE*VS1(4,40)
VS0(9,63)=QCy*VS0(9,41)+WQy*VS1(9,41)-r1x2E*VR1(9,41)&
   +5D0*r1x2E*(VS0(9,25)-ZxZpE*VS1(9,25))&
   +HfxZpE*VS1(4,41)
VS0(9,64)=QCx*VS0(9,42)+WQx*VS1(9,42)&
   +4D0*r1x2E*(VS0(9,26)-ZxZpE*VS1(9,26))
VS0(9,65)=QCx*VS0(9,43)+WQx*VS1(9,43)&
   +3D0*r1x2E*(VS0(9,27)-ZxZpE*VS1(9,27))
VS0(9,66)=QCx*VS0(9,44)+WQx*VS1(9,44)&
   +2D0*r1x2E*(VS0(9,28)-ZxZpE*VS1(9,28))
VS0(9,67)=QCy*VS0(9,44)+WQy*VS1(9,44)-r1x2E*VR1(9,44)&
   +2D0*r1x2E*(VS0(9,27)-ZxZpE*VS1(9,27))&
   +HfxZpE*VS1(4,44)
VS0(9,68)=QCy*VS0(9,45)+WQy*VS1(9,45)-r1x2E*VR1(9,45)&
   +3D0*r1x2E*(VS0(9,28)-ZxZpE*VS1(9,28))&
   +HfxZpE*VS1(4,45)
VS0(9,69)=QCy*VS0(9,46)+WQy*VS1(9,46)-r1x2E*VR1(9,46)&
   +4D0*r1x2E*(VS0(9,29)-ZxZpE*VS1(9,29))&
   +HfxZpE*VS1(4,46)
VS0(9,70)=QCx*VS0(9,47)+WQx*VS1(9,47)&
   +3D0*r1x2E*(VS0(9,30)-ZxZpE*VS1(9,30))
VS0(9,71)=QCx*VS0(9,48)+WQx*VS1(9,48)&
   +2D0*r1x2E*(VS0(9,31)-ZxZpE*VS1(9,31))
VS0(9,72)=QCx*VS0(9,49)+WQx*VS1(9,49)&
   +r1x2E*(VS0(9,32)-ZxZpE*VS1(9,32))
VS0(9,73)=QCy*VS0(9,49)+WQy*VS1(9,49)-r1x2E*VR1(9,49)&
   +2D0*r1x2E*(VS0(9,31)-ZxZpE*VS1(9,31))&
   +HfxZpE*VS1(4,49)
VS0(9,74)=QCy*VS0(9,50)+WQy*VS1(9,50)-r1x2E*VR1(9,50)&
   +3D0*r1x2E*(VS0(9,32)-ZxZpE*VS1(9,32))&
   +HfxZpE*VS1(4,50)
VS0(9,75)=QCx*VS0(9,51)+WQx*VS1(9,51)&
   +2D0*r1x2E*(VS0(9,33)-ZxZpE*VS1(9,33))
VS0(9,76)=QCz*VS0(9,48)+WQz*VS1(9,48)&
   +2D0*r1x2E*(VS0(9,27)-ZxZpE*VS1(9,27))&
   +HfxZpE*VS1(3,48)
VS0(9,77)=QCz*VS0(9,49)+WQz*VS1(9,49)&
   +2D0*r1x2E*(VS0(9,28)-ZxZpE*VS1(9,28))&
   +HfxZpE*VS1(3,49)
VS0(9,78)=QCy*VS0(9,53)+WQy*VS1(9,53)-r1x2E*VR1(9,53)&
   +2D0*r1x2E*(VS0(9,34)-ZxZpE*VS1(9,34))&
   +HfxZpE*VS1(4,53)
VS0(9,79)=QCz*VS0(9,51)+WQz*VS1(9,51)&
   +3D0*r1x2E*(VS0(9,30)-ZxZpE*VS1(9,30))&
   +HfxZpE*VS1(3,51)
VS0(9,80)=QCz*VS0(9,52)+WQz*VS1(9,52)&
   +3D0*r1x2E*(VS0(9,31)-ZxZpE*VS1(9,31))&
   +HfxZpE*VS1(3,52)
VS0(9,81)=QCz*VS0(9,53)+WQz*VS1(9,53)&
   +3D0*r1x2E*(VS0(9,32)-ZxZpE*VS1(9,32))&
   +HfxZpE*VS1(3,53)
VS0(9,82)=QCz*VS0(9,54)+WQz*VS1(9,54)&
   +4D0*r1x2E*(VS0(9,33)-ZxZpE*VS1(9,33))&
   +HfxZpE*VS1(3,54)
VS0(9,83)=QCz*VS0(9,55)+WQz*VS1(9,55)&
   +4D0*r1x2E*(VS0(9,34)-ZxZpE*VS1(9,34))&
   +HfxZpE*VS1(3,55)
VS0(9,84)=QCz*VS0(9,56)+WQz*VS1(9,56)&
   +5D0*r1x2E*(VS0(9,35)-ZxZpE*VS1(9,35))&
   +HfxZpE*VS1(3,56)
VS0(10,57)=QCx*VS0(10,36)+WQx*VS1(10,36)&
   +5D0*r1x2E*(VS0(10,21)-ZxZpE*VS1(10,21))
VS0(10,58)=QCx*VS0(10,37)+WQx*VS1(10,37)&
   +4D0*r1x2E*(VS0(10,22)-ZxZpE*VS1(10,22))
VS0(10,59)=QCx*VS0(10,38)+WQx*VS1(10,38)&
   +3D0*r1x2E*(VS0(10,23)-ZxZpE*VS1(10,23))
VS0(10,60)=QCx*VS0(10,39)+WQx*VS1(10,39)&
   +2D0*r1x2E*(VS0(10,24)-ZxZpE*VS1(10,24))
VS0(10,61)=QCy*VS0(10,39)+WQy*VS1(10,39)-r1x2E*VR1(10,39)&
   +3D0*r1x2E*(VS0(10,23)-ZxZpE*VS1(10,23))
VS0(10,62)=QCy*VS0(10,40)+WQy*VS1(10,40)-r1x2E*VR1(10,40)&
   +4D0*r1x2E*(VS0(10,24)-ZxZpE*VS1(10,24))
VS0(10,63)=QCy*VS0(10,41)+WQy*VS1(10,41)-r1x2E*VR1(10,41)&
   +5D0*r1x2E*(VS0(10,25)-ZxZpE*VS1(10,25))
VS0(10,64)=QCx*VS0(10,42)+WQx*VS1(10,42)&
   +4D0*r1x2E*(VS0(10,26)-ZxZpE*VS1(10,26))
VS0(10,65)=QCx*VS0(10,43)+WQx*VS1(10,43)&
   +3D0*r1x2E*(VS0(10,27)-ZxZpE*VS1(10,27))
VS0(10,66)=QCx*VS0(10,44)+WQx*VS1(10,44)&
   +2D0*r1x2E*(VS0(10,28)-ZxZpE*VS1(10,28))
VS0(10,67)=QCy*VS0(10,44)+WQy*VS1(10,44)-r1x2E*VR1(10,44)&
   +2D0*r1x2E*(VS0(10,27)-ZxZpE*VS1(10,27))
VS0(10,68)=QCy*VS0(10,45)+WQy*VS1(10,45)-r1x2E*VR1(10,45)&
   +3D0*r1x2E*(VS0(10,28)-ZxZpE*VS1(10,28))
VS0(10,69)=QCy*VS0(10,46)+WQy*VS1(10,46)-r1x2E*VR1(10,46)&
   +4D0*r1x2E*(VS0(10,29)-ZxZpE*VS1(10,29))
VS0(10,70)=QCx*VS0(10,47)+WQx*VS1(10,47)&
   +3D0*r1x2E*(VS0(10,30)-ZxZpE*VS1(10,30))
VS0(10,71)=QCx*VS0(10,48)+WQx*VS1(10,48)&
   +2D0*r1x2E*(VS0(10,31)-ZxZpE*VS1(10,31))
VS0(10,72)=QCx*VS0(10,49)+WQx*VS1(10,49)&
   +r1x2E*(VS0(10,32)-ZxZpE*VS1(10,32))
VS0(10,73)=QCy*VS0(10,49)+WQy*VS1(10,49)-r1x2E*VR1(10,49)&
   +2D0*r1x2E*(VS0(10,31)-ZxZpE*VS1(10,31))
VS0(10,74)=QCy*VS0(10,50)+WQy*VS1(10,50)-r1x2E*VR1(10,50)&
   +3D0*r1x2E*(VS0(10,32)-ZxZpE*VS1(10,32))
VS0(10,75)=QCx*VS0(10,51)+WQx*VS1(10,51)&
   +2D0*r1x2E*(VS0(10,33)-ZxZpE*VS1(10,33))
VS0(10,76)=QCz*VS0(10,48)+WQz*VS1(10,48)&
   +2D0*r1x2E*(VS0(10,27)-ZxZpE*VS1(10,27))&
   +2D0*HfxZpE*VS1(4,48)
VS0(10,77)=QCz*VS0(10,49)+WQz*VS1(10,49)&
   +2D0*r1x2E*(VS0(10,28)-ZxZpE*VS1(10,28))&
   +2D0*HfxZpE*VS1(4,49)
VS0(10,78)=QCy*VS0(10,53)+WQy*VS1(10,53)-r1x2E*VR1(10,53)&
   +2D0*r1x2E*(VS0(10,34)-ZxZpE*VS1(10,34))
VS0(10,79)=QCz*VS0(10,51)+WQz*VS1(10,51)&
   +3D0*r1x2E*(VS0(10,30)-ZxZpE*VS1(10,30))&
   +2D0*HfxZpE*VS1(4,51)
VS0(10,80)=QCz*VS0(10,52)+WQz*VS1(10,52)&
   +3D0*r1x2E*(VS0(10,31)-ZxZpE*VS1(10,31))&
   +2D0*HfxZpE*VS1(4,52)
VS0(10,81)=QCz*VS0(10,53)+WQz*VS1(10,53)&
   +3D0*r1x2E*(VS0(10,32)-ZxZpE*VS1(10,32))&
   +2D0*HfxZpE*VS1(4,53)
VS0(10,82)=QCz*VS0(10,54)+WQz*VS1(10,54)&
   +4D0*r1x2E*(VS0(10,33)-ZxZpE*VS1(10,33))&
   +2D0*HfxZpE*VS1(4,54)
VS0(10,83)=QCz*VS0(10,55)+WQz*VS1(10,55)&
   +4D0*r1x2E*(VS0(10,34)-ZxZpE*VS1(10,34))&
   +2D0*HfxZpE*VS1(4,55)
VS0(10,84)=QCz*VS0(10,56)+WQz*VS1(10,56)&
   +5D0*r1x2E*(VS0(10,35)-ZxZpE*VS1(10,35))&
   +2D0*HfxZpE*VS1(4,56)
CASE(3)
VS0(5,57)=QCx*VS0(5,36)+WQx*VS1(5,36)&
   +5D0*r1x2E*(VS0(5,21)-ZxZpE*VS1(5,21))&
   +2D0*HfxZpE*VS1(2,36)
VS0(5,58)=QCx*VS0(5,37)+WQx*VS1(5,37)&
   +4D0*r1x2E*(VS0(5,22)-ZxZpE*VS1(5,22))&
   +2D0*HfxZpE*VS1(2,37)
VS0(5,59)=QCx*VS0(5,38)+WQx*VS1(5,38)&
   +3D0*r1x2E*(VS0(5,23)-ZxZpE*VS1(5,23))&
   +2D0*HfxZpE*VS1(2,38)
VS0(5,60)=QCx*VS0(5,39)+WQx*VS1(5,39)&
   +2D0*r1x2E*(VS0(5,24)-ZxZpE*VS1(5,24))&
   +2D0*HfxZpE*VS1(2,39)
VS0(5,61)=QCy*VS0(5,39)+WQy*VS1(5,39)&
   +3D0*r1x2E*(VS0(5,23)-ZxZpE*VS1(5,23))
VS0(5,62)=QCy*VS0(5,40)+WQy*VS1(5,40)&
   +4D0*r1x2E*(VS0(5,24)-ZxZpE*VS1(5,24))
VS0(5,63)=QCy*VS0(5,41)+WQy*VS1(5,41)&
   +5D0*r1x2E*(VS0(5,25)-ZxZpE*VS1(5,25))
VS0(5,64)=QCx*VS0(5,42)+WQx*VS1(5,42)&
   +4D0*r1x2E*(VS0(5,26)-ZxZpE*VS1(5,26))&
   +2D0*HfxZpE*VS1(2,42)
VS0(5,65)=QCx*VS0(5,43)+WQx*VS1(5,43)&
   +3D0*r1x2E*(VS0(5,27)-ZxZpE*VS1(5,27))&
   +2D0*HfxZpE*VS1(2,43)
VS0(5,66)=QCx*VS0(5,44)+WQx*VS1(5,44)&
   +2D0*r1x2E*(VS0(5,28)-ZxZpE*VS1(5,28))&
   +2D0*HfxZpE*VS1(2,44)
VS0(5,67)=QCy*VS0(5,44)+WQy*VS1(5,44)&
   +2D0*r1x2E*(VS0(5,27)-ZxZpE*VS1(5,27))
VS0(5,68)=QCy*VS0(5,45)+WQy*VS1(5,45)&
   +3D0*r1x2E*(VS0(5,28)-ZxZpE*VS1(5,28))
VS0(5,69)=QCy*VS0(5,46)+WQy*VS1(5,46)&
   +4D0*r1x2E*(VS0(5,29)-ZxZpE*VS1(5,29))
VS0(5,70)=QCx*VS0(5,47)+WQx*VS1(5,47)&
   +3D0*r1x2E*(VS0(5,30)-ZxZpE*VS1(5,30))&
   +2D0*HfxZpE*VS1(2,47)
VS0(5,71)=QCx*VS0(5,48)+WQx*VS1(5,48)&
   +2D0*r1x2E*(VS0(5,31)-ZxZpE*VS1(5,31))&
   +2D0*HfxZpE*VS1(2,48)
VS0(5,72)=QCx*VS0(5,49)+WQx*VS1(5,49)&
   +r1x2E*(VS0(5,32)-ZxZpE*VS1(5,32))&
   +2D0*HfxZpE*VS1(2,49)
VS0(5,73)=QCy*VS0(5,49)+WQy*VS1(5,49)&
   +2D0*r1x2E*(VS0(5,31)-ZxZpE*VS1(5,31))
VS0(5,74)=QCy*VS0(5,50)+WQy*VS1(5,50)&
   +3D0*r1x2E*(VS0(5,32)-ZxZpE*VS1(5,32))
VS0(5,75)=QCx*VS0(5,51)+WQx*VS1(5,51)&
   +2D0*r1x2E*(VS0(5,33)-ZxZpE*VS1(5,33))&
   +2D0*HfxZpE*VS1(2,51)
VS0(5,76)=QCz*VS0(5,48)+WQz*VS1(5,48)-r1x2E*VR1(5,48)&
   +2D0*r1x2E*(VS0(5,27)-ZxZpE*VS1(5,27))
VS0(5,77)=QCz*VS0(5,49)+WQz*VS1(5,49)-r1x2E*VR1(5,49)&
   +2D0*r1x2E*(VS0(5,28)-ZxZpE*VS1(5,28))
VS0(5,78)=QCy*VS0(5,53)+WQy*VS1(5,53)&
   +2D0*r1x2E*(VS0(5,34)-ZxZpE*VS1(5,34))
VS0(5,79)=QCz*VS0(5,51)+WQz*VS1(5,51)-r1x2E*VR1(5,51)&
   +3D0*r1x2E*(VS0(5,30)-ZxZpE*VS1(5,30))
VS0(5,80)=QCz*VS0(5,52)+WQz*VS1(5,52)-r1x2E*VR1(5,52)&
   +3D0*r1x2E*(VS0(5,31)-ZxZpE*VS1(5,31))
VS0(5,81)=QCz*VS0(5,53)+WQz*VS1(5,53)-r1x2E*VR1(5,53)&
   +3D0*r1x2E*(VS0(5,32)-ZxZpE*VS1(5,32))
VS0(5,82)=QCz*VS0(5,54)+WQz*VS1(5,54)-r1x2E*VR1(5,54)&
   +4D0*r1x2E*(VS0(5,33)-ZxZpE*VS1(5,33))
VS0(5,83)=QCz*VS0(5,55)+WQz*VS1(5,55)-r1x2E*VR1(5,55)&
   +4D0*r1x2E*(VS0(5,34)-ZxZpE*VS1(5,34))
VS0(5,84)=QCz*VS0(5,56)+WQz*VS1(5,56)-r1x2E*VR1(5,56)&
   +5D0*r1x2E*(VS0(5,35)-ZxZpE*VS1(5,35))
VS0(6,57)=QCx*VS0(6,36)+WQx*VS1(6,36)&
   +5D0*r1x2E*(VS0(6,21)-ZxZpE*VS1(6,21))&
   +HfxZpE*VS1(3,36)
VS0(6,58)=QCx*VS0(6,37)+WQx*VS1(6,37)&
   +4D0*r1x2E*(VS0(6,22)-ZxZpE*VS1(6,22))&
   +HfxZpE*VS1(3,37)
VS0(6,59)=QCx*VS0(6,38)+WQx*VS1(6,38)&
   +3D0*r1x2E*(VS0(6,23)-ZxZpE*VS1(6,23))&
   +HfxZpE*VS1(3,38)
VS0(6,60)=QCx*VS0(6,39)+WQx*VS1(6,39)&
   +2D0*r1x2E*(VS0(6,24)-ZxZpE*VS1(6,24))&
   +HfxZpE*VS1(3,39)
VS0(6,61)=QCy*VS0(6,39)+WQy*VS1(6,39)&
   +3D0*r1x2E*(VS0(6,23)-ZxZpE*VS1(6,23))&
   +HfxZpE*VS1(2,39)
VS0(6,62)=QCy*VS0(6,40)+WQy*VS1(6,40)&
   +4D0*r1x2E*(VS0(6,24)-ZxZpE*VS1(6,24))&
   +HfxZpE*VS1(2,40)
VS0(6,63)=QCy*VS0(6,41)+WQy*VS1(6,41)&
   +5D0*r1x2E*(VS0(6,25)-ZxZpE*VS1(6,25))&
   +HfxZpE*VS1(2,41)
VS0(6,64)=QCx*VS0(6,42)+WQx*VS1(6,42)&
   +4D0*r1x2E*(VS0(6,26)-ZxZpE*VS1(6,26))&
   +HfxZpE*VS1(3,42)
VS0(6,65)=QCx*VS0(6,43)+WQx*VS1(6,43)&
   +3D0*r1x2E*(VS0(6,27)-ZxZpE*VS1(6,27))&
   +HfxZpE*VS1(3,43)
VS0(6,66)=QCx*VS0(6,44)+WQx*VS1(6,44)&
   +2D0*r1x2E*(VS0(6,28)-ZxZpE*VS1(6,28))&
   +HfxZpE*VS1(3,44)
VS0(6,67)=QCy*VS0(6,44)+WQy*VS1(6,44)&
   +2D0*r1x2E*(VS0(6,27)-ZxZpE*VS1(6,27))&
   +HfxZpE*VS1(2,44)
VS0(6,68)=QCy*VS0(6,45)+WQy*VS1(6,45)&
   +3D0*r1x2E*(VS0(6,28)-ZxZpE*VS1(6,28))&
   +HfxZpE*VS1(2,45)
VS0(6,69)=QCy*VS0(6,46)+WQy*VS1(6,46)&
   +4D0*r1x2E*(VS0(6,29)-ZxZpE*VS1(6,29))&
   +HfxZpE*VS1(2,46)
VS0(6,70)=QCx*VS0(6,47)+WQx*VS1(6,47)&
   +3D0*r1x2E*(VS0(6,30)-ZxZpE*VS1(6,30))&
   +HfxZpE*VS1(3,47)
VS0(6,71)=QCx*VS0(6,48)+WQx*VS1(6,48)&
   +2D0*r1x2E*(VS0(6,31)-ZxZpE*VS1(6,31))&
   +HfxZpE*VS1(3,48)
VS0(6,72)=QCx*VS0(6,49)+WQx*VS1(6,49)&
   +r1x2E*(VS0(6,32)-ZxZpE*VS1(6,32))&
   +HfxZpE*VS1(3,49)
VS0(6,73)=QCy*VS0(6,49)+WQy*VS1(6,49)&
   +2D0*r1x2E*(VS0(6,31)-ZxZpE*VS1(6,31))&
   +HfxZpE*VS1(2,49)
VS0(6,74)=QCy*VS0(6,50)+WQy*VS1(6,50)&
   +3D0*r1x2E*(VS0(6,32)-ZxZpE*VS1(6,32))&
   +HfxZpE*VS1(2,50)
VS0(6,75)=QCx*VS0(6,51)+WQx*VS1(6,51)&
   +2D0*r1x2E*(VS0(6,33)-ZxZpE*VS1(6,33))&
   +HfxZpE*VS1(3,51)
VS0(6,76)=QCz*VS0(6,48)+WQz*VS1(6,48)-r1x2E*VR1(6,48)&
   +2D0*r1x2E*(VS0(6,27)-ZxZpE*VS1(6,27))
VS0(6,77)=QCz*VS0(6,49)+WQz*VS1(6,49)-r1x2E*VR1(6,49)&
   +2D0*r1x2E*(VS0(6,28)-ZxZpE*VS1(6,28))
VS0(6,78)=QCy*VS0(6,53)+WQy*VS1(6,53)&
   +2D0*r1x2E*(VS0(6,34)-ZxZpE*VS1(6,34))&
   +HfxZpE*VS1(2,53)
VS0(6,79)=QCz*VS0(6,51)+WQz*VS1(6,51)-r1x2E*VR1(6,51)&
   +3D0*r1x2E*(VS0(6,30)-ZxZpE*VS1(6,30))
VS0(6,80)=QCz*VS0(6,52)+WQz*VS1(6,52)-r1x2E*VR1(6,52)&
   +3D0*r1x2E*(VS0(6,31)-ZxZpE*VS1(6,31))
VS0(6,81)=QCz*VS0(6,53)+WQz*VS1(6,53)-r1x2E*VR1(6,53)&
   +3D0*r1x2E*(VS0(6,32)-ZxZpE*VS1(6,32))
VS0(6,82)=QCz*VS0(6,54)+WQz*VS1(6,54)-r1x2E*VR1(6,54)&
   +4D0*r1x2E*(VS0(6,33)-ZxZpE*VS1(6,33))
VS0(6,83)=QCz*VS0(6,55)+WQz*VS1(6,55)-r1x2E*VR1(6,55)&
   +4D0*r1x2E*(VS0(6,34)-ZxZpE*VS1(6,34))
VS0(6,84)=QCz*VS0(6,56)+WQz*VS1(6,56)-r1x2E*VR1(6,56)&
   +5D0*r1x2E*(VS0(6,35)-ZxZpE*VS1(6,35))
VS0(7,57)=QCx*VS0(7,36)+WQx*VS1(7,36)&
   +5D0*r1x2E*(VS0(7,21)-ZxZpE*VS1(7,21))
VS0(7,58)=QCx*VS0(7,37)+WQx*VS1(7,37)&
   +4D0*r1x2E*(VS0(7,22)-ZxZpE*VS1(7,22))
VS0(7,59)=QCx*VS0(7,38)+WQx*VS1(7,38)&
   +3D0*r1x2E*(VS0(7,23)-ZxZpE*VS1(7,23))
VS0(7,60)=QCx*VS0(7,39)+WQx*VS1(7,39)&
   +2D0*r1x2E*(VS0(7,24)-ZxZpE*VS1(7,24))
VS0(7,61)=QCy*VS0(7,39)+WQy*VS1(7,39)&
   +3D0*r1x2E*(VS0(7,23)-ZxZpE*VS1(7,23))&
   +2D0*HfxZpE*VS1(3,39)
VS0(7,62)=QCy*VS0(7,40)+WQy*VS1(7,40)&
   +4D0*r1x2E*(VS0(7,24)-ZxZpE*VS1(7,24))&
   +2D0*HfxZpE*VS1(3,40)
VS0(7,63)=QCy*VS0(7,41)+WQy*VS1(7,41)&
   +5D0*r1x2E*(VS0(7,25)-ZxZpE*VS1(7,25))&
   +2D0*HfxZpE*VS1(3,41)
VS0(7,64)=QCx*VS0(7,42)+WQx*VS1(7,42)&
   +4D0*r1x2E*(VS0(7,26)-ZxZpE*VS1(7,26))
VS0(7,65)=QCx*VS0(7,43)+WQx*VS1(7,43)&
   +3D0*r1x2E*(VS0(7,27)-ZxZpE*VS1(7,27))
VS0(7,66)=QCx*VS0(7,44)+WQx*VS1(7,44)&
   +2D0*r1x2E*(VS0(7,28)-ZxZpE*VS1(7,28))
VS0(7,67)=QCy*VS0(7,44)+WQy*VS1(7,44)&
   +2D0*r1x2E*(VS0(7,27)-ZxZpE*VS1(7,27))&
   +2D0*HfxZpE*VS1(3,44)
VS0(7,68)=QCy*VS0(7,45)+WQy*VS1(7,45)&
   +3D0*r1x2E*(VS0(7,28)-ZxZpE*VS1(7,28))&
   +2D0*HfxZpE*VS1(3,45)
VS0(7,69)=QCy*VS0(7,46)+WQy*VS1(7,46)&
   +4D0*r1x2E*(VS0(7,29)-ZxZpE*VS1(7,29))&
   +2D0*HfxZpE*VS1(3,46)
VS0(7,70)=QCx*VS0(7,47)+WQx*VS1(7,47)&
   +3D0*r1x2E*(VS0(7,30)-ZxZpE*VS1(7,30))
VS0(7,71)=QCx*VS0(7,48)+WQx*VS1(7,48)&
   +2D0*r1x2E*(VS0(7,31)-ZxZpE*VS1(7,31))
VS0(7,72)=QCx*VS0(7,49)+WQx*VS1(7,49)&
   +r1x2E*(VS0(7,32)-ZxZpE*VS1(7,32))
VS0(7,73)=QCy*VS0(7,49)+WQy*VS1(7,49)&
   +2D0*r1x2E*(VS0(7,31)-ZxZpE*VS1(7,31))&
   +2D0*HfxZpE*VS1(3,49)
VS0(7,74)=QCy*VS0(7,50)+WQy*VS1(7,50)&
   +3D0*r1x2E*(VS0(7,32)-ZxZpE*VS1(7,32))&
   +2D0*HfxZpE*VS1(3,50)
VS0(7,75)=QCx*VS0(7,51)+WQx*VS1(7,51)&
   +2D0*r1x2E*(VS0(7,33)-ZxZpE*VS1(7,33))
VS0(7,76)=QCz*VS0(7,48)+WQz*VS1(7,48)-r1x2E*VR1(7,48)&
   +2D0*r1x2E*(VS0(7,27)-ZxZpE*VS1(7,27))
VS0(7,77)=QCz*VS0(7,49)+WQz*VS1(7,49)-r1x2E*VR1(7,49)&
   +2D0*r1x2E*(VS0(7,28)-ZxZpE*VS1(7,28))
VS0(7,78)=QCy*VS0(7,53)+WQy*VS1(7,53)&
   +2D0*r1x2E*(VS0(7,34)-ZxZpE*VS1(7,34))&
   +2D0*HfxZpE*VS1(3,53)
VS0(7,79)=QCz*VS0(7,51)+WQz*VS1(7,51)-r1x2E*VR1(7,51)&
   +3D0*r1x2E*(VS0(7,30)-ZxZpE*VS1(7,30))
VS0(7,80)=QCz*VS0(7,52)+WQz*VS1(7,52)-r1x2E*VR1(7,52)&
   +3D0*r1x2E*(VS0(7,31)-ZxZpE*VS1(7,31))
VS0(7,81)=QCz*VS0(7,53)+WQz*VS1(7,53)-r1x2E*VR1(7,53)&
   +3D0*r1x2E*(VS0(7,32)-ZxZpE*VS1(7,32))
VS0(7,82)=QCz*VS0(7,54)+WQz*VS1(7,54)-r1x2E*VR1(7,54)&
   +4D0*r1x2E*(VS0(7,33)-ZxZpE*VS1(7,33))
VS0(7,83)=QCz*VS0(7,55)+WQz*VS1(7,55)-r1x2E*VR1(7,55)&
   +4D0*r1x2E*(VS0(7,34)-ZxZpE*VS1(7,34))
VS0(7,84)=QCz*VS0(7,56)+WQz*VS1(7,56)-r1x2E*VR1(7,56)&
   +5D0*r1x2E*(VS0(7,35)-ZxZpE*VS1(7,35))
VS0(8,57)=QCx*VS0(8,36)+WQx*VS1(8,36)&
   +5D0*r1x2E*(VS0(8,21)-ZxZpE*VS1(8,21))&
   +HfxZpE*VS1(4,36)
VS0(8,58)=QCx*VS0(8,37)+WQx*VS1(8,37)&
   +4D0*r1x2E*(VS0(8,22)-ZxZpE*VS1(8,22))&
   +HfxZpE*VS1(4,37)
VS0(8,59)=QCx*VS0(8,38)+WQx*VS1(8,38)&
   +3D0*r1x2E*(VS0(8,23)-ZxZpE*VS1(8,23))&
   +HfxZpE*VS1(4,38)
VS0(8,60)=QCx*VS0(8,39)+WQx*VS1(8,39)&
   +2D0*r1x2E*(VS0(8,24)-ZxZpE*VS1(8,24))&
   +HfxZpE*VS1(4,39)
VS0(8,61)=QCy*VS0(8,39)+WQy*VS1(8,39)&
   +3D0*r1x2E*(VS0(8,23)-ZxZpE*VS1(8,23))
VS0(8,62)=QCy*VS0(8,40)+WQy*VS1(8,40)&
   +4D0*r1x2E*(VS0(8,24)-ZxZpE*VS1(8,24))
VS0(8,63)=QCy*VS0(8,41)+WQy*VS1(8,41)&
   +5D0*r1x2E*(VS0(8,25)-ZxZpE*VS1(8,25))
VS0(8,64)=QCx*VS0(8,42)+WQx*VS1(8,42)&
   +4D0*r1x2E*(VS0(8,26)-ZxZpE*VS1(8,26))&
   +HfxZpE*VS1(4,42)
VS0(8,65)=QCx*VS0(8,43)+WQx*VS1(8,43)&
   +3D0*r1x2E*(VS0(8,27)-ZxZpE*VS1(8,27))&
   +HfxZpE*VS1(4,43)
VS0(8,66)=QCx*VS0(8,44)+WQx*VS1(8,44)&
   +2D0*r1x2E*(VS0(8,28)-ZxZpE*VS1(8,28))&
   +HfxZpE*VS1(4,44)
VS0(8,67)=QCy*VS0(8,44)+WQy*VS1(8,44)&
   +2D0*r1x2E*(VS0(8,27)-ZxZpE*VS1(8,27))
VS0(8,68)=QCy*VS0(8,45)+WQy*VS1(8,45)&
   +3D0*r1x2E*(VS0(8,28)-ZxZpE*VS1(8,28))
VS0(8,69)=QCy*VS0(8,46)+WQy*VS1(8,46)&
   +4D0*r1x2E*(VS0(8,29)-ZxZpE*VS1(8,29))
VS0(8,70)=QCx*VS0(8,47)+WQx*VS1(8,47)&
   +3D0*r1x2E*(VS0(8,30)-ZxZpE*VS1(8,30))&
   +HfxZpE*VS1(4,47)
VS0(8,71)=QCx*VS0(8,48)+WQx*VS1(8,48)&
   +2D0*r1x2E*(VS0(8,31)-ZxZpE*VS1(8,31))&
   +HfxZpE*VS1(4,48)
VS0(8,72)=QCx*VS0(8,49)+WQx*VS1(8,49)&
   +r1x2E*(VS0(8,32)-ZxZpE*VS1(8,32))&
   +HfxZpE*VS1(4,49)
VS0(8,73)=QCy*VS0(8,49)+WQy*VS1(8,49)&
   +2D0*r1x2E*(VS0(8,31)-ZxZpE*VS1(8,31))
VS0(8,74)=QCy*VS0(8,50)+WQy*VS1(8,50)&
   +3D0*r1x2E*(VS0(8,32)-ZxZpE*VS1(8,32))
VS0(8,75)=QCx*VS0(8,51)+WQx*VS1(8,51)&
   +2D0*r1x2E*(VS0(8,33)-ZxZpE*VS1(8,33))&
   +HfxZpE*VS1(4,51)
VS0(8,76)=QCz*VS0(8,48)+WQz*VS1(8,48)-r1x2E*VR1(8,48)&
   +2D0*r1x2E*(VS0(8,27)-ZxZpE*VS1(8,27))&
   +HfxZpE*VS1(2,48)
VS0(8,77)=QCz*VS0(8,49)+WQz*VS1(8,49)-r1x2E*VR1(8,49)&
   +2D0*r1x2E*(VS0(8,28)-ZxZpE*VS1(8,28))&
   +HfxZpE*VS1(2,49)
VS0(8,78)=QCy*VS0(8,53)+WQy*VS1(8,53)&
   +2D0*r1x2E*(VS0(8,34)-ZxZpE*VS1(8,34))
VS0(8,79)=QCz*VS0(8,51)+WQz*VS1(8,51)-r1x2E*VR1(8,51)&
   +3D0*r1x2E*(VS0(8,30)-ZxZpE*VS1(8,30))&
   +HfxZpE*VS1(2,51)
VS0(8,80)=QCz*VS0(8,52)+WQz*VS1(8,52)-r1x2E*VR1(8,52)&
   +3D0*r1x2E*(VS0(8,31)-ZxZpE*VS1(8,31))&
   +HfxZpE*VS1(2,52)
VS0(8,81)=QCz*VS0(8,53)+WQz*VS1(8,53)-r1x2E*VR1(8,53)&
   +3D0*r1x2E*(VS0(8,32)-ZxZpE*VS1(8,32))&
   +HfxZpE*VS1(2,53)
VS0(8,82)=QCz*VS0(8,54)+WQz*VS1(8,54)-r1x2E*VR1(8,54)&
   +4D0*r1x2E*(VS0(8,33)-ZxZpE*VS1(8,33))&
   +HfxZpE*VS1(2,54)
VS0(8,83)=QCz*VS0(8,55)+WQz*VS1(8,55)-r1x2E*VR1(8,55)&
   +4D0*r1x2E*(VS0(8,34)-ZxZpE*VS1(8,34))&
   +HfxZpE*VS1(2,55)
VS0(8,84)=QCz*VS0(8,56)+WQz*VS1(8,56)-r1x2E*VR1(8,56)&
   +5D0*r1x2E*(VS0(8,35)-ZxZpE*VS1(8,35))&
   +HfxZpE*VS1(2,56)
VS0(9,57)=QCx*VS0(9,36)+WQx*VS1(9,36)&
   +5D0*r1x2E*(VS0(9,21)-ZxZpE*VS1(9,21))
VS0(9,58)=QCx*VS0(9,37)+WQx*VS1(9,37)&
   +4D0*r1x2E*(VS0(9,22)-ZxZpE*VS1(9,22))
VS0(9,59)=QCx*VS0(9,38)+WQx*VS1(9,38)&
   +3D0*r1x2E*(VS0(9,23)-ZxZpE*VS1(9,23))
VS0(9,60)=QCx*VS0(9,39)+WQx*VS1(9,39)&
   +2D0*r1x2E*(VS0(9,24)-ZxZpE*VS1(9,24))
VS0(9,61)=QCy*VS0(9,39)+WQy*VS1(9,39)&
   +3D0*r1x2E*(VS0(9,23)-ZxZpE*VS1(9,23))&
   +HfxZpE*VS1(4,39)
VS0(9,62)=QCy*VS0(9,40)+WQy*VS1(9,40)&
   +4D0*r1x2E*(VS0(9,24)-ZxZpE*VS1(9,24))&
   +HfxZpE*VS1(4,40)
VS0(9,63)=QCy*VS0(9,41)+WQy*VS1(9,41)&
   +5D0*r1x2E*(VS0(9,25)-ZxZpE*VS1(9,25))&
   +HfxZpE*VS1(4,41)
VS0(9,64)=QCx*VS0(9,42)+WQx*VS1(9,42)&
   +4D0*r1x2E*(VS0(9,26)-ZxZpE*VS1(9,26))
VS0(9,65)=QCx*VS0(9,43)+WQx*VS1(9,43)&
   +3D0*r1x2E*(VS0(9,27)-ZxZpE*VS1(9,27))
VS0(9,66)=QCx*VS0(9,44)+WQx*VS1(9,44)&
   +2D0*r1x2E*(VS0(9,28)-ZxZpE*VS1(9,28))
VS0(9,67)=QCy*VS0(9,44)+WQy*VS1(9,44)&
   +2D0*r1x2E*(VS0(9,27)-ZxZpE*VS1(9,27))&
   +HfxZpE*VS1(4,44)
VS0(9,68)=QCy*VS0(9,45)+WQy*VS1(9,45)&
   +3D0*r1x2E*(VS0(9,28)-ZxZpE*VS1(9,28))&
   +HfxZpE*VS1(4,45)
VS0(9,69)=QCy*VS0(9,46)+WQy*VS1(9,46)&
   +4D0*r1x2E*(VS0(9,29)-ZxZpE*VS1(9,29))&
   +HfxZpE*VS1(4,46)
VS0(9,70)=QCx*VS0(9,47)+WQx*VS1(9,47)&
   +3D0*r1x2E*(VS0(9,30)-ZxZpE*VS1(9,30))
VS0(9,71)=QCx*VS0(9,48)+WQx*VS1(9,48)&
   +2D0*r1x2E*(VS0(9,31)-ZxZpE*VS1(9,31))
VS0(9,72)=QCx*VS0(9,49)+WQx*VS1(9,49)&
   +r1x2E*(VS0(9,32)-ZxZpE*VS1(9,32))
VS0(9,73)=QCy*VS0(9,49)+WQy*VS1(9,49)&
   +2D0*r1x2E*(VS0(9,31)-ZxZpE*VS1(9,31))&
   +HfxZpE*VS1(4,49)
VS0(9,74)=QCy*VS0(9,50)+WQy*VS1(9,50)&
   +3D0*r1x2E*(VS0(9,32)-ZxZpE*VS1(9,32))&
   +HfxZpE*VS1(4,50)
VS0(9,75)=QCx*VS0(9,51)+WQx*VS1(9,51)&
   +2D0*r1x2E*(VS0(9,33)-ZxZpE*VS1(9,33))
VS0(9,76)=QCz*VS0(9,48)+WQz*VS1(9,48)-r1x2E*VR1(9,48)&
   +2D0*r1x2E*(VS0(9,27)-ZxZpE*VS1(9,27))&
   +HfxZpE*VS1(3,48)
VS0(9,77)=QCz*VS0(9,49)+WQz*VS1(9,49)-r1x2E*VR1(9,49)&
   +2D0*r1x2E*(VS0(9,28)-ZxZpE*VS1(9,28))&
   +HfxZpE*VS1(3,49)
VS0(9,78)=QCy*VS0(9,53)+WQy*VS1(9,53)&
   +2D0*r1x2E*(VS0(9,34)-ZxZpE*VS1(9,34))&
   +HfxZpE*VS1(4,53)
VS0(9,79)=QCz*VS0(9,51)+WQz*VS1(9,51)-r1x2E*VR1(9,51)&
   +3D0*r1x2E*(VS0(9,30)-ZxZpE*VS1(9,30))&
   +HfxZpE*VS1(3,51)
VS0(9,80)=QCz*VS0(9,52)+WQz*VS1(9,52)-r1x2E*VR1(9,52)&
   +3D0*r1x2E*(VS0(9,31)-ZxZpE*VS1(9,31))&
   +HfxZpE*VS1(3,52)
VS0(9,81)=QCz*VS0(9,53)+WQz*VS1(9,53)-r1x2E*VR1(9,53)&
   +3D0*r1x2E*(VS0(9,32)-ZxZpE*VS1(9,32))&
   +HfxZpE*VS1(3,53)
VS0(9,82)=QCz*VS0(9,54)+WQz*VS1(9,54)-r1x2E*VR1(9,54)&
   +4D0*r1x2E*(VS0(9,33)-ZxZpE*VS1(9,33))&
   +HfxZpE*VS1(3,54)
VS0(9,83)=QCz*VS0(9,55)+WQz*VS1(9,55)-r1x2E*VR1(9,55)&
   +4D0*r1x2E*(VS0(9,34)-ZxZpE*VS1(9,34))&
   +HfxZpE*VS1(3,55)
VS0(9,84)=QCz*VS0(9,56)+WQz*VS1(9,56)-r1x2E*VR1(9,56)&
   +5D0*r1x2E*(VS0(9,35)-ZxZpE*VS1(9,35))&
   +HfxZpE*VS1(3,56)
VS0(10,57)=QCx*VS0(10,36)+WQx*VS1(10,36)&
   +5D0*r1x2E*(VS0(10,21)-ZxZpE*VS1(10,21))
VS0(10,58)=QCx*VS0(10,37)+WQx*VS1(10,37)&
   +4D0*r1x2E*(VS0(10,22)-ZxZpE*VS1(10,22))
VS0(10,59)=QCx*VS0(10,38)+WQx*VS1(10,38)&
   +3D0*r1x2E*(VS0(10,23)-ZxZpE*VS1(10,23))
VS0(10,60)=QCx*VS0(10,39)+WQx*VS1(10,39)&
   +2D0*r1x2E*(VS0(10,24)-ZxZpE*VS1(10,24))
VS0(10,61)=QCy*VS0(10,39)+WQy*VS1(10,39)&
   +3D0*r1x2E*(VS0(10,23)-ZxZpE*VS1(10,23))
VS0(10,62)=QCy*VS0(10,40)+WQy*VS1(10,40)&
   +4D0*r1x2E*(VS0(10,24)-ZxZpE*VS1(10,24))
VS0(10,63)=QCy*VS0(10,41)+WQy*VS1(10,41)&
   +5D0*r1x2E*(VS0(10,25)-ZxZpE*VS1(10,25))
VS0(10,64)=QCx*VS0(10,42)+WQx*VS1(10,42)&
   +4D0*r1x2E*(VS0(10,26)-ZxZpE*VS1(10,26))
VS0(10,65)=QCx*VS0(10,43)+WQx*VS1(10,43)&
   +3D0*r1x2E*(VS0(10,27)-ZxZpE*VS1(10,27))
VS0(10,66)=QCx*VS0(10,44)+WQx*VS1(10,44)&
   +2D0*r1x2E*(VS0(10,28)-ZxZpE*VS1(10,28))
VS0(10,67)=QCy*VS0(10,44)+WQy*VS1(10,44)&
   +2D0*r1x2E*(VS0(10,27)-ZxZpE*VS1(10,27))
VS0(10,68)=QCy*VS0(10,45)+WQy*VS1(10,45)&
   +3D0*r1x2E*(VS0(10,28)-ZxZpE*VS1(10,28))
VS0(10,69)=QCy*VS0(10,46)+WQy*VS1(10,46)&
   +4D0*r1x2E*(VS0(10,29)-ZxZpE*VS1(10,29))
VS0(10,70)=QCx*VS0(10,47)+WQx*VS1(10,47)&
   +3D0*r1x2E*(VS0(10,30)-ZxZpE*VS1(10,30))
VS0(10,71)=QCx*VS0(10,48)+WQx*VS1(10,48)&
   +2D0*r1x2E*(VS0(10,31)-ZxZpE*VS1(10,31))
VS0(10,72)=QCx*VS0(10,49)+WQx*VS1(10,49)&
   +r1x2E*(VS0(10,32)-ZxZpE*VS1(10,32))
VS0(10,73)=QCy*VS0(10,49)+WQy*VS1(10,49)&
   +2D0*r1x2E*(VS0(10,31)-ZxZpE*VS1(10,31))
VS0(10,74)=QCy*VS0(10,50)+WQy*VS1(10,50)&
   +3D0*r1x2E*(VS0(10,32)-ZxZpE*VS1(10,32))
VS0(10,75)=QCx*VS0(10,51)+WQx*VS1(10,51)&
   +2D0*r1x2E*(VS0(10,33)-ZxZpE*VS1(10,33))
VS0(10,76)=QCz*VS0(10,48)+WQz*VS1(10,48)-r1x2E*VR1(10,48)&
   +2D0*r1x2E*(VS0(10,27)-ZxZpE*VS1(10,27))&
   +2D0*HfxZpE*VS1(4,48)
VS0(10,77)=QCz*VS0(10,49)+WQz*VS1(10,49)-r1x2E*VR1(10,49)&
   +2D0*r1x2E*(VS0(10,28)-ZxZpE*VS1(10,28))&
   +2D0*HfxZpE*VS1(4,49)
VS0(10,78)=QCy*VS0(10,53)+WQy*VS1(10,53)&
   +2D0*r1x2E*(VS0(10,34)-ZxZpE*VS1(10,34))
VS0(10,79)=QCz*VS0(10,51)+WQz*VS1(10,51)-r1x2E*VR1(10,51)&
   +3D0*r1x2E*(VS0(10,30)-ZxZpE*VS1(10,30))&
   +2D0*HfxZpE*VS1(4,51)
VS0(10,80)=QCz*VS0(10,52)+WQz*VS1(10,52)-r1x2E*VR1(10,52)&
   +3D0*r1x2E*(VS0(10,31)-ZxZpE*VS1(10,31))&
   +2D0*HfxZpE*VS1(4,52)
VS0(10,81)=QCz*VS0(10,53)+WQz*VS1(10,53)-r1x2E*VR1(10,53)&
   +3D0*r1x2E*(VS0(10,32)-ZxZpE*VS1(10,32))&
   +2D0*HfxZpE*VS1(4,53)
VS0(10,82)=QCz*VS0(10,54)+WQz*VS1(10,54)-r1x2E*VR1(10,54)&
   +4D0*r1x2E*(VS0(10,33)-ZxZpE*VS1(10,33))&
   +2D0*HfxZpE*VS1(4,54)
VS0(10,83)=QCz*VS0(10,55)+WQz*VS1(10,55)-r1x2E*VR1(10,55)&
   +4D0*r1x2E*(VS0(10,34)-ZxZpE*VS1(10,34))&
   +2D0*HfxZpE*VS1(4,55)
VS0(10,84)=QCz*VS0(10,56)+WQz*VS1(10,56)-r1x2E*VR1(10,56)&
   +5D0*r1x2E*(VS0(10,35)-ZxZpE*VS1(10,35))&
   +2D0*HfxZpE*VS1(4,56)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRd0i0'
STOP
END SELECT
END SUBROUTINE MVRRd0i0
