!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRg0p0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(6,2)
      V(2)=2.D0*V(1)
      V(3)=ExZpE*r1x2Z*VRR1(6,2)
      V(4)=-2.D0*V(3)
      V(5)=r1x2Z*VRR0(6,3)
      V(6)=2.D0*V(5)
      V(7)=ExZpE*r1x2Z*VRR1(6,3)
      V(8)=-2.D0*V(7)
      V(9)=r1x2Z*VRR0(6,4)
      V(10)=2.D0*V(9)
      V(11)=ExZpE*r1x2Z*VRR1(6,4)
      V(12)=-2.D0*V(11)
      V(13)=r1x2Z*VRR0(7,2)
      V(14)=ExZpE*r1x2Z*VRR1(7,2)
      V(15)=HfxZpE*VRR1(13,1)
      V(16)=r1x2Z*VRR0(7,3)
      V(17)=ExZpE*r1x2Z*VRR1(7,3)
      V(18)=r1x2Z*VRR0(7,4)
      V(19)=ExZpE*r1x2Z*VRR1(7,4)
      V(20)=r1x2Z*VRR0(8,2)
      V(21)=2.D0*V(20)
      V(22)=ExZpE*r1x2Z*VRR1(8,2)
      V(23)=-2.D0*V(22)
      V(24)=r1x2Z*VRR0(8,3)
      V(25)=2.D0*V(24)
      V(26)=ExZpE*r1x2Z*VRR1(8,3)
      V(27)=-2.D0*V(26)
      V(28)=r1x2Z*VRR0(8,4)
      V(29)=2.D0*V(28)
      V(30)=ExZpE*r1x2Z*VRR1(8,4)
      V(31)=-2.D0*V(30)
      V(32)=r1x2Z*VRR0(9,2)
      V(33)=ExZpE*r1x2Z*VRR1(9,2)
      V(34)=HfxZpE*VRR1(16,1)
      V(35)=r1x2Z*VRR0(9,3)
      V(36)=ExZpE*r1x2Z*VRR1(9,3)
      V(37)=r1x2Z*VRR0(9,4)
      V(38)=ExZpE*r1x2Z*VRR1(9,4)
      V(39)=2.D0*V(32)
      V(40)=-2.D0*V(33)
      V(41)=2.D0*V(35)
      V(42)=-2.D0*V(36)
      V(43)=2.D0*V(37)
      V(44)=-2.D0*V(38)
      V(45)=r1x2Z*VRR0(10,2)
      V(46)=ExZpE*r1x2Z*VRR1(10,2)
      V(47)=-V(46)
      V(48)=HfxZpE*VRR1(18,1)
      V(49)=r1x2Z*VRR0(10,3)
      V(50)=ExZpE*r1x2Z*VRR1(10,3)
      V(51)=-V(50)
      V(52)=r1x2Z*VRR0(10,4)
      V(53)=ExZpE*r1x2Z*VRR1(10,4)
      V(54)=-V(53)
      V(55)=HfxZpE*VRR1(19,1)
      VRR0(21,2)=3.D0*r1x2Z*VRR0(5,2)+PAx*VRR0(11,2)-3.D0*ExZpE*r1x2Z*VRR1(5,2)+HfxZpE*VRR1(11,1)+WPx*VRR1(11,2)
      VRR0(21,3)=3.D0*r1x2Z*VRR0(5,3)+PAx*VRR0(11,3)-3.D0*ExZpE*r1x2Z*VRR1(5,3)+WPx*VRR1(11,3)
      VRR0(21,4)=3.D0*r1x2Z*VRR0(5,4)+PAx*VRR0(11,4)-3.D0*ExZpE*r1x2Z*VRR1(5,4)+WPx*VRR1(11,4)
      VRR0(22,2)=V(2)+V(4)+PAx*VRR0(12,2)+HfxZpE*VRR1(12,1)+WPx*VRR1(12,2)
      VRR0(22,3)=V(6)+V(8)+PAx*VRR0(12,3)+WPx*VRR1(12,3)
      VRR0(22,4)=V(10)+V(12)+PAx*VRR0(12,4)+WPx*VRR1(12,4)
      VRR0(23,2)=V(13)-V(14)+V(15)+PAx*VRR0(13,2)+WPx*VRR1(13,2)
      VRR0(23,3)=V(16)-V(17)+PAx*VRR0(13,3)+WPx*VRR1(13,3)
      VRR0(23,4)=V(18)-V(19)+PAx*VRR0(13,4)+WPx*VRR1(13,4)
      VRR0(24,2)=V(2)+V(4)+PAy*VRR0(13,2)+WPy*VRR1(13,2)
      VRR0(24,3)=V(6)+V(8)+V(15)+PAy*VRR0(13,3)+WPy*VRR1(13,3)
      VRR0(24,4)=V(10)+V(12)+PAy*VRR0(13,4)+WPy*VRR1(13,4)
      VRR0(25,2)=3.D0*V(13)-3.D0*V(14)+PAy*VRR0(14,2)+WPy*VRR1(14,2)
      VRR0(25,3)=3.D0*V(16)-3.D0*V(17)+PAy*VRR0(14,3)+HfxZpE*VRR1(14,1)+WPy*VRR1(14,3)
      VRR0(25,4)=3.D0*V(18)-3.D0*V(19)+PAy*VRR0(14,4)+WPy*VRR1(14,4)
      VRR0(26,2)=V(21)+V(23)+PAx*VRR0(15,2)+HfxZpE*VRR1(15,1)+WPx*VRR1(15,2)
      VRR0(26,3)=V(25)+V(27)+PAx*VRR0(15,3)+WPx*VRR1(15,3)
      VRR0(26,4)=V(29)+V(31)+PAx*VRR0(15,4)+WPx*VRR1(15,4)
      VRR0(27,2)=V(32)-V(33)+V(34)+PAx*VRR0(16,2)+WPx*VRR1(16,2)
      VRR0(27,3)=V(35)-V(36)+PAx*VRR0(16,3)+WPx*VRR1(16,3)
      VRR0(27,4)=V(37)-V(38)+PAx*VRR0(16,4)+WPx*VRR1(16,4)
      VRR0(28,2)=V(20)-V(22)+PAy*VRR0(16,2)+WPy*VRR1(16,2)
      VRR0(28,3)=V(24)-V(26)+V(34)+PAy*VRR0(16,3)+WPy*VRR1(16,3)
      VRR0(28,4)=V(28)-V(30)+PAy*VRR0(16,4)+WPy*VRR1(16,4)
      VRR0(29,2)=V(39)+V(40)+PAy*VRR0(17,2)+WPy*VRR1(17,2)
      VRR0(29,3)=V(41)+V(42)+PAy*VRR0(17,3)+HfxZpE*VRR1(17,1)+WPy*VRR1(17,3)
      VRR0(29,4)=V(43)+V(44)+PAy*VRR0(17,4)+WPy*VRR1(17,4)
      VRR0(30,2)=V(45)+V(47)+V(48)+PAx*VRR0(18,2)+WPx*VRR1(18,2)
      VRR0(30,3)=V(49)+V(51)+PAx*VRR0(18,3)+WPx*VRR1(18,3)
      VRR0(30,4)=V(52)+V(54)+PAx*VRR0(18,4)+WPx*VRR1(18,4)
      VRR0(31,2)=V(1)-V(3)+PAz*VRR0(16,2)+WPz*VRR1(16,2)
      VRR0(31,3)=V(5)-V(7)+PAz*VRR0(16,3)+WPz*VRR1(16,3)
      VRR0(31,4)=V(9)-V(11)+V(34)+PAz*VRR0(16,4)+WPz*VRR1(16,4)
      VRR0(32,2)=V(45)+V(47)+PAy*VRR0(19,2)+WPy*VRR1(19,2)
      VRR0(32,3)=V(49)+V(51)+V(55)+PAy*VRR0(19,3)+WPy*VRR1(19,3)
      VRR0(32,4)=V(52)+V(54)+PAy*VRR0(19,4)+WPy*VRR1(19,4)
      VRR0(33,2)=V(21)+V(23)+PAz*VRR0(18,2)+WPz*VRR1(18,2)
      VRR0(33,3)=V(25)+V(27)+PAz*VRR0(18,3)+WPz*VRR1(18,3)
      VRR0(33,4)=V(29)+V(31)+V(48)+PAz*VRR0(18,4)+WPz*VRR1(18,4)
      VRR0(34,2)=V(39)+V(40)+PAz*VRR0(19,2)+WPz*VRR1(19,2)
      VRR0(34,3)=V(41)+V(42)+PAz*VRR0(19,3)+WPz*VRR1(19,3)
      VRR0(34,4)=V(43)+V(44)+V(55)+PAz*VRR0(19,4)+WPz*VRR1(19,4)
      VRR0(35,2)=3.D0*V(45)-3.D0*V(46)+PAz*VRR0(20,2)+WPz*VRR1(20,2)
      VRR0(35,3)=3.D0*V(49)-3.D0*V(50)+PAz*VRR0(20,3)+WPz*VRR1(20,3)
      VRR0(35,4)=3.D0*V(52)-3.D0*V(53)+PAz*VRR0(20,4)+HfxZpE*VRR1(20,1)+WPz*VRR1(20,4)
END SUBROUTINE VRRg0p0
SUBROUTINE MVRRg0p0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(21,2)=PAx*VS0(11,2)+WPx*VS1(11,2)+r1x2Z*VR1(11,2)&
   +3D0*r1x2Z*(VS0(5,2)-ExZpE*VS1(5,2))&
   +HfxZpE*VS1(11,1)
VS0(21,3)=PAx*VS0(11,3)+WPx*VS1(11,3)+r1x2Z*VR1(11,3)&
   +3D0*r1x2Z*(VS0(5,3)-ExZpE*VS1(5,3))
VS0(21,4)=PAx*VS0(11,4)+WPx*VS1(11,4)+r1x2Z*VR1(11,4)&
   +3D0*r1x2Z*(VS0(5,4)-ExZpE*VS1(5,4))
VS0(22,2)=PAx*VS0(12,2)+WPx*VS1(12,2)+r1x2Z*VR1(12,2)&
   +2D0*r1x2Z*(VS0(6,2)-ExZpE*VS1(6,2))&
   +HfxZpE*VS1(12,1)
VS0(22,3)=PAx*VS0(12,3)+WPx*VS1(12,3)+r1x2Z*VR1(12,3)&
   +2D0*r1x2Z*(VS0(6,3)-ExZpE*VS1(6,3))
VS0(22,4)=PAx*VS0(12,4)+WPx*VS1(12,4)+r1x2Z*VR1(12,4)&
   +2D0*r1x2Z*(VS0(6,4)-ExZpE*VS1(6,4))
VS0(23,2)=PAx*VS0(13,2)+WPx*VS1(13,2)+r1x2Z*VR1(13,2)&
   +r1x2Z*(VS0(7,2)-ExZpE*VS1(7,2))&
   +HfxZpE*VS1(13,1)
VS0(23,3)=PAx*VS0(13,3)+WPx*VS1(13,3)+r1x2Z*VR1(13,3)&
   +r1x2Z*(VS0(7,3)-ExZpE*VS1(7,3))
VS0(23,4)=PAx*VS0(13,4)+WPx*VS1(13,4)+r1x2Z*VR1(13,4)&
   +r1x2Z*(VS0(7,4)-ExZpE*VS1(7,4))
VS0(24,2)=PAy*VS0(13,2)+WPy*VS1(13,2)&
   +2D0*r1x2Z*(VS0(6,2)-ExZpE*VS1(6,2))
VS0(24,3)=PAy*VS0(13,3)+WPy*VS1(13,3)&
   +2D0*r1x2Z*(VS0(6,3)-ExZpE*VS1(6,3))&
   +HfxZpE*VS1(13,1)
VS0(24,4)=PAy*VS0(13,4)+WPy*VS1(13,4)&
   +2D0*r1x2Z*(VS0(6,4)-ExZpE*VS1(6,4))
VS0(25,2)=PAy*VS0(14,2)+WPy*VS1(14,2)&
   +3D0*r1x2Z*(VS0(7,2)-ExZpE*VS1(7,2))
VS0(25,3)=PAy*VS0(14,3)+WPy*VS1(14,3)&
   +3D0*r1x2Z*(VS0(7,3)-ExZpE*VS1(7,3))&
   +HfxZpE*VS1(14,1)
VS0(25,4)=PAy*VS0(14,4)+WPy*VS1(14,4)&
   +3D0*r1x2Z*(VS0(7,4)-ExZpE*VS1(7,4))
VS0(26,2)=PAx*VS0(15,2)+WPx*VS1(15,2)+r1x2Z*VR1(15,2)&
   +2D0*r1x2Z*(VS0(8,2)-ExZpE*VS1(8,2))&
   +HfxZpE*VS1(15,1)
VS0(26,3)=PAx*VS0(15,3)+WPx*VS1(15,3)+r1x2Z*VR1(15,3)&
   +2D0*r1x2Z*(VS0(8,3)-ExZpE*VS1(8,3))
VS0(26,4)=PAx*VS0(15,4)+WPx*VS1(15,4)+r1x2Z*VR1(15,4)&
   +2D0*r1x2Z*(VS0(8,4)-ExZpE*VS1(8,4))
VS0(27,2)=PAx*VS0(16,2)+WPx*VS1(16,2)+r1x2Z*VR1(16,2)&
   +r1x2Z*(VS0(9,2)-ExZpE*VS1(9,2))&
   +HfxZpE*VS1(16,1)
VS0(27,3)=PAx*VS0(16,3)+WPx*VS1(16,3)+r1x2Z*VR1(16,3)&
   +r1x2Z*(VS0(9,3)-ExZpE*VS1(9,3))
VS0(27,4)=PAx*VS0(16,4)+WPx*VS1(16,4)+r1x2Z*VR1(16,4)&
   +r1x2Z*(VS0(9,4)-ExZpE*VS1(9,4))
VS0(28,2)=PAy*VS0(16,2)+WPy*VS1(16,2)&
   +r1x2Z*(VS0(8,2)-ExZpE*VS1(8,2))
VS0(28,3)=PAy*VS0(16,3)+WPy*VS1(16,3)&
   +r1x2Z*(VS0(8,3)-ExZpE*VS1(8,3))&
   +HfxZpE*VS1(16,1)
VS0(28,4)=PAy*VS0(16,4)+WPy*VS1(16,4)&
   +r1x2Z*(VS0(8,4)-ExZpE*VS1(8,4))
VS0(29,2)=PAy*VS0(17,2)+WPy*VS1(17,2)&
   +2D0*r1x2Z*(VS0(9,2)-ExZpE*VS1(9,2))
VS0(29,3)=PAy*VS0(17,3)+WPy*VS1(17,3)&
   +2D0*r1x2Z*(VS0(9,3)-ExZpE*VS1(9,3))&
   +HfxZpE*VS1(17,1)
VS0(29,4)=PAy*VS0(17,4)+WPy*VS1(17,4)&
   +2D0*r1x2Z*(VS0(9,4)-ExZpE*VS1(9,4))
VS0(30,2)=PAx*VS0(18,2)+WPx*VS1(18,2)+r1x2Z*VR1(18,2)&
   +r1x2Z*(VS0(10,2)-ExZpE*VS1(10,2))&
   +HfxZpE*VS1(18,1)
VS0(30,3)=PAx*VS0(18,3)+WPx*VS1(18,3)+r1x2Z*VR1(18,3)&
   +r1x2Z*(VS0(10,3)-ExZpE*VS1(10,3))
VS0(30,4)=PAx*VS0(18,4)+WPx*VS1(18,4)+r1x2Z*VR1(18,4)&
   +r1x2Z*(VS0(10,4)-ExZpE*VS1(10,4))
VS0(31,2)=PAz*VS0(16,2)+WPz*VS1(16,2)&
   +r1x2Z*(VS0(6,2)-ExZpE*VS1(6,2))
VS0(31,3)=PAz*VS0(16,3)+WPz*VS1(16,3)&
   +r1x2Z*(VS0(6,3)-ExZpE*VS1(6,3))
VS0(31,4)=PAz*VS0(16,4)+WPz*VS1(16,4)&
   +r1x2Z*(VS0(6,4)-ExZpE*VS1(6,4))&
   +HfxZpE*VS1(16,1)
VS0(32,2)=PAy*VS0(19,2)+WPy*VS1(19,2)&
   +r1x2Z*(VS0(10,2)-ExZpE*VS1(10,2))
VS0(32,3)=PAy*VS0(19,3)+WPy*VS1(19,3)&
   +r1x2Z*(VS0(10,3)-ExZpE*VS1(10,3))&
   +HfxZpE*VS1(19,1)
VS0(32,4)=PAy*VS0(19,4)+WPy*VS1(19,4)&
   +r1x2Z*(VS0(10,4)-ExZpE*VS1(10,4))
VS0(33,2)=PAz*VS0(18,2)+WPz*VS1(18,2)&
   +2D0*r1x2Z*(VS0(8,2)-ExZpE*VS1(8,2))
VS0(33,3)=PAz*VS0(18,3)+WPz*VS1(18,3)&
   +2D0*r1x2Z*(VS0(8,3)-ExZpE*VS1(8,3))
VS0(33,4)=PAz*VS0(18,4)+WPz*VS1(18,4)&
   +2D0*r1x2Z*(VS0(8,4)-ExZpE*VS1(8,4))&
   +HfxZpE*VS1(18,1)
VS0(34,2)=PAz*VS0(19,2)+WPz*VS1(19,2)&
   +2D0*r1x2Z*(VS0(9,2)-ExZpE*VS1(9,2))
VS0(34,3)=PAz*VS0(19,3)+WPz*VS1(19,3)&
   +2D0*r1x2Z*(VS0(9,3)-ExZpE*VS1(9,3))
VS0(34,4)=PAz*VS0(19,4)+WPz*VS1(19,4)&
   +2D0*r1x2Z*(VS0(9,4)-ExZpE*VS1(9,4))&
   +HfxZpE*VS1(19,1)
VS0(35,2)=PAz*VS0(20,2)+WPz*VS1(20,2)&
   +3D0*r1x2Z*(VS0(10,2)-ExZpE*VS1(10,2))
VS0(35,3)=PAz*VS0(20,3)+WPz*VS1(20,3)&
   +3D0*r1x2Z*(VS0(10,3)-ExZpE*VS1(10,3))
VS0(35,4)=PAz*VS0(20,4)+WPz*VS1(20,4)&
   +3D0*r1x2Z*(VS0(10,4)-ExZpE*VS1(10,4))&
   +HfxZpE*VS1(20,1)
CASE(2)
VS0(21,2)=PAx*VS0(11,2)+WPx*VS1(11,2)&
   +3D0*r1x2Z*(VS0(5,2)-ExZpE*VS1(5,2))&
   +HfxZpE*VS1(11,1)
VS0(21,3)=PAx*VS0(11,3)+WPx*VS1(11,3)&
   +3D0*r1x2Z*(VS0(5,3)-ExZpE*VS1(5,3))
VS0(21,4)=PAx*VS0(11,4)+WPx*VS1(11,4)&
   +3D0*r1x2Z*(VS0(5,4)-ExZpE*VS1(5,4))
VS0(22,2)=PAx*VS0(12,2)+WPx*VS1(12,2)&
   +2D0*r1x2Z*(VS0(6,2)-ExZpE*VS1(6,2))&
   +HfxZpE*VS1(12,1)
VS0(22,3)=PAx*VS0(12,3)+WPx*VS1(12,3)&
   +2D0*r1x2Z*(VS0(6,3)-ExZpE*VS1(6,3))
VS0(22,4)=PAx*VS0(12,4)+WPx*VS1(12,4)&
   +2D0*r1x2Z*(VS0(6,4)-ExZpE*VS1(6,4))
VS0(23,2)=PAx*VS0(13,2)+WPx*VS1(13,2)&
   +r1x2Z*(VS0(7,2)-ExZpE*VS1(7,2))&
   +HfxZpE*VS1(13,1)
VS0(23,3)=PAx*VS0(13,3)+WPx*VS1(13,3)&
   +r1x2Z*(VS0(7,3)-ExZpE*VS1(7,3))
VS0(23,4)=PAx*VS0(13,4)+WPx*VS1(13,4)&
   +r1x2Z*(VS0(7,4)-ExZpE*VS1(7,4))
VS0(24,2)=PAy*VS0(13,2)+WPy*VS1(13,2)+r1x2Z*VR1(13,2)&
   +2D0*r1x2Z*(VS0(6,2)-ExZpE*VS1(6,2))
VS0(24,3)=PAy*VS0(13,3)+WPy*VS1(13,3)+r1x2Z*VR1(13,3)&
   +2D0*r1x2Z*(VS0(6,3)-ExZpE*VS1(6,3))&
   +HfxZpE*VS1(13,1)
VS0(24,4)=PAy*VS0(13,4)+WPy*VS1(13,4)+r1x2Z*VR1(13,4)&
   +2D0*r1x2Z*(VS0(6,4)-ExZpE*VS1(6,4))
VS0(25,2)=PAy*VS0(14,2)+WPy*VS1(14,2)+r1x2Z*VR1(14,2)&
   +3D0*r1x2Z*(VS0(7,2)-ExZpE*VS1(7,2))
VS0(25,3)=PAy*VS0(14,3)+WPy*VS1(14,3)+r1x2Z*VR1(14,3)&
   +3D0*r1x2Z*(VS0(7,3)-ExZpE*VS1(7,3))&
   +HfxZpE*VS1(14,1)
VS0(25,4)=PAy*VS0(14,4)+WPy*VS1(14,4)+r1x2Z*VR1(14,4)&
   +3D0*r1x2Z*(VS0(7,4)-ExZpE*VS1(7,4))
VS0(26,2)=PAx*VS0(15,2)+WPx*VS1(15,2)&
   +2D0*r1x2Z*(VS0(8,2)-ExZpE*VS1(8,2))&
   +HfxZpE*VS1(15,1)
VS0(26,3)=PAx*VS0(15,3)+WPx*VS1(15,3)&
   +2D0*r1x2Z*(VS0(8,3)-ExZpE*VS1(8,3))
VS0(26,4)=PAx*VS0(15,4)+WPx*VS1(15,4)&
   +2D0*r1x2Z*(VS0(8,4)-ExZpE*VS1(8,4))
VS0(27,2)=PAx*VS0(16,2)+WPx*VS1(16,2)&
   +r1x2Z*(VS0(9,2)-ExZpE*VS1(9,2))&
   +HfxZpE*VS1(16,1)
VS0(27,3)=PAx*VS0(16,3)+WPx*VS1(16,3)&
   +r1x2Z*(VS0(9,3)-ExZpE*VS1(9,3))
VS0(27,4)=PAx*VS0(16,4)+WPx*VS1(16,4)&
   +r1x2Z*(VS0(9,4)-ExZpE*VS1(9,4))
VS0(28,2)=PAy*VS0(16,2)+WPy*VS1(16,2)+r1x2Z*VR1(16,2)&
   +r1x2Z*(VS0(8,2)-ExZpE*VS1(8,2))
VS0(28,3)=PAy*VS0(16,3)+WPy*VS1(16,3)+r1x2Z*VR1(16,3)&
   +r1x2Z*(VS0(8,3)-ExZpE*VS1(8,3))&
   +HfxZpE*VS1(16,1)
VS0(28,4)=PAy*VS0(16,4)+WPy*VS1(16,4)+r1x2Z*VR1(16,4)&
   +r1x2Z*(VS0(8,4)-ExZpE*VS1(8,4))
VS0(29,2)=PAy*VS0(17,2)+WPy*VS1(17,2)+r1x2Z*VR1(17,2)&
   +2D0*r1x2Z*(VS0(9,2)-ExZpE*VS1(9,2))
VS0(29,3)=PAy*VS0(17,3)+WPy*VS1(17,3)+r1x2Z*VR1(17,3)&
   +2D0*r1x2Z*(VS0(9,3)-ExZpE*VS1(9,3))&
   +HfxZpE*VS1(17,1)
VS0(29,4)=PAy*VS0(17,4)+WPy*VS1(17,4)+r1x2Z*VR1(17,4)&
   +2D0*r1x2Z*(VS0(9,4)-ExZpE*VS1(9,4))
VS0(30,2)=PAx*VS0(18,2)+WPx*VS1(18,2)&
   +r1x2Z*(VS0(10,2)-ExZpE*VS1(10,2))&
   +HfxZpE*VS1(18,1)
VS0(30,3)=PAx*VS0(18,3)+WPx*VS1(18,3)&
   +r1x2Z*(VS0(10,3)-ExZpE*VS1(10,3))
VS0(30,4)=PAx*VS0(18,4)+WPx*VS1(18,4)&
   +r1x2Z*(VS0(10,4)-ExZpE*VS1(10,4))
VS0(31,2)=PAz*VS0(16,2)+WPz*VS1(16,2)&
   +r1x2Z*(VS0(6,2)-ExZpE*VS1(6,2))
VS0(31,3)=PAz*VS0(16,3)+WPz*VS1(16,3)&
   +r1x2Z*(VS0(6,3)-ExZpE*VS1(6,3))
VS0(31,4)=PAz*VS0(16,4)+WPz*VS1(16,4)&
   +r1x2Z*(VS0(6,4)-ExZpE*VS1(6,4))&
   +HfxZpE*VS1(16,1)
VS0(32,2)=PAy*VS0(19,2)+WPy*VS1(19,2)+r1x2Z*VR1(19,2)&
   +r1x2Z*(VS0(10,2)-ExZpE*VS1(10,2))
VS0(32,3)=PAy*VS0(19,3)+WPy*VS1(19,3)+r1x2Z*VR1(19,3)&
   +r1x2Z*(VS0(10,3)-ExZpE*VS1(10,3))&
   +HfxZpE*VS1(19,1)
VS0(32,4)=PAy*VS0(19,4)+WPy*VS1(19,4)+r1x2Z*VR1(19,4)&
   +r1x2Z*(VS0(10,4)-ExZpE*VS1(10,4))
VS0(33,2)=PAz*VS0(18,2)+WPz*VS1(18,2)&
   +2D0*r1x2Z*(VS0(8,2)-ExZpE*VS1(8,2))
VS0(33,3)=PAz*VS0(18,3)+WPz*VS1(18,3)&
   +2D0*r1x2Z*(VS0(8,3)-ExZpE*VS1(8,3))
VS0(33,4)=PAz*VS0(18,4)+WPz*VS1(18,4)&
   +2D0*r1x2Z*(VS0(8,4)-ExZpE*VS1(8,4))&
   +HfxZpE*VS1(18,1)
VS0(34,2)=PAz*VS0(19,2)+WPz*VS1(19,2)&
   +2D0*r1x2Z*(VS0(9,2)-ExZpE*VS1(9,2))
VS0(34,3)=PAz*VS0(19,3)+WPz*VS1(19,3)&
   +2D0*r1x2Z*(VS0(9,3)-ExZpE*VS1(9,3))
VS0(34,4)=PAz*VS0(19,4)+WPz*VS1(19,4)&
   +2D0*r1x2Z*(VS0(9,4)-ExZpE*VS1(9,4))&
   +HfxZpE*VS1(19,1)
VS0(35,2)=PAz*VS0(20,2)+WPz*VS1(20,2)&
   +3D0*r1x2Z*(VS0(10,2)-ExZpE*VS1(10,2))
VS0(35,3)=PAz*VS0(20,3)+WPz*VS1(20,3)&
   +3D0*r1x2Z*(VS0(10,3)-ExZpE*VS1(10,3))
VS0(35,4)=PAz*VS0(20,4)+WPz*VS1(20,4)&
   +3D0*r1x2Z*(VS0(10,4)-ExZpE*VS1(10,4))&
   +HfxZpE*VS1(20,1)
CASE(3)
VS0(21,2)=PAx*VS0(11,2)+WPx*VS1(11,2)&
   +3D0*r1x2Z*(VS0(5,2)-ExZpE*VS1(5,2))&
   +HfxZpE*VS1(11,1)
VS0(21,3)=PAx*VS0(11,3)+WPx*VS1(11,3)&
   +3D0*r1x2Z*(VS0(5,3)-ExZpE*VS1(5,3))
VS0(21,4)=PAx*VS0(11,4)+WPx*VS1(11,4)&
   +3D0*r1x2Z*(VS0(5,4)-ExZpE*VS1(5,4))
VS0(22,2)=PAx*VS0(12,2)+WPx*VS1(12,2)&
   +2D0*r1x2Z*(VS0(6,2)-ExZpE*VS1(6,2))&
   +HfxZpE*VS1(12,1)
VS0(22,3)=PAx*VS0(12,3)+WPx*VS1(12,3)&
   +2D0*r1x2Z*(VS0(6,3)-ExZpE*VS1(6,3))
VS0(22,4)=PAx*VS0(12,4)+WPx*VS1(12,4)&
   +2D0*r1x2Z*(VS0(6,4)-ExZpE*VS1(6,4))
VS0(23,2)=PAx*VS0(13,2)+WPx*VS1(13,2)&
   +r1x2Z*(VS0(7,2)-ExZpE*VS1(7,2))&
   +HfxZpE*VS1(13,1)
VS0(23,3)=PAx*VS0(13,3)+WPx*VS1(13,3)&
   +r1x2Z*(VS0(7,3)-ExZpE*VS1(7,3))
VS0(23,4)=PAx*VS0(13,4)+WPx*VS1(13,4)&
   +r1x2Z*(VS0(7,4)-ExZpE*VS1(7,4))
VS0(24,2)=PAy*VS0(13,2)+WPy*VS1(13,2)&
   +2D0*r1x2Z*(VS0(6,2)-ExZpE*VS1(6,2))
VS0(24,3)=PAy*VS0(13,3)+WPy*VS1(13,3)&
   +2D0*r1x2Z*(VS0(6,3)-ExZpE*VS1(6,3))&
   +HfxZpE*VS1(13,1)
VS0(24,4)=PAy*VS0(13,4)+WPy*VS1(13,4)&
   +2D0*r1x2Z*(VS0(6,4)-ExZpE*VS1(6,4))
VS0(25,2)=PAy*VS0(14,2)+WPy*VS1(14,2)&
   +3D0*r1x2Z*(VS0(7,2)-ExZpE*VS1(7,2))
VS0(25,3)=PAy*VS0(14,3)+WPy*VS1(14,3)&
   +3D0*r1x2Z*(VS0(7,3)-ExZpE*VS1(7,3))&
   +HfxZpE*VS1(14,1)
VS0(25,4)=PAy*VS0(14,4)+WPy*VS1(14,4)&
   +3D0*r1x2Z*(VS0(7,4)-ExZpE*VS1(7,4))
VS0(26,2)=PAx*VS0(15,2)+WPx*VS1(15,2)&
   +2D0*r1x2Z*(VS0(8,2)-ExZpE*VS1(8,2))&
   +HfxZpE*VS1(15,1)
VS0(26,3)=PAx*VS0(15,3)+WPx*VS1(15,3)&
   +2D0*r1x2Z*(VS0(8,3)-ExZpE*VS1(8,3))
VS0(26,4)=PAx*VS0(15,4)+WPx*VS1(15,4)&
   +2D0*r1x2Z*(VS0(8,4)-ExZpE*VS1(8,4))
VS0(27,2)=PAx*VS0(16,2)+WPx*VS1(16,2)&
   +r1x2Z*(VS0(9,2)-ExZpE*VS1(9,2))&
   +HfxZpE*VS1(16,1)
VS0(27,3)=PAx*VS0(16,3)+WPx*VS1(16,3)&
   +r1x2Z*(VS0(9,3)-ExZpE*VS1(9,3))
VS0(27,4)=PAx*VS0(16,4)+WPx*VS1(16,4)&
   +r1x2Z*(VS0(9,4)-ExZpE*VS1(9,4))
VS0(28,2)=PAy*VS0(16,2)+WPy*VS1(16,2)&
   +r1x2Z*(VS0(8,2)-ExZpE*VS1(8,2))
VS0(28,3)=PAy*VS0(16,3)+WPy*VS1(16,3)&
   +r1x2Z*(VS0(8,3)-ExZpE*VS1(8,3))&
   +HfxZpE*VS1(16,1)
VS0(28,4)=PAy*VS0(16,4)+WPy*VS1(16,4)&
   +r1x2Z*(VS0(8,4)-ExZpE*VS1(8,4))
VS0(29,2)=PAy*VS0(17,2)+WPy*VS1(17,2)&
   +2D0*r1x2Z*(VS0(9,2)-ExZpE*VS1(9,2))
VS0(29,3)=PAy*VS0(17,3)+WPy*VS1(17,3)&
   +2D0*r1x2Z*(VS0(9,3)-ExZpE*VS1(9,3))&
   +HfxZpE*VS1(17,1)
VS0(29,4)=PAy*VS0(17,4)+WPy*VS1(17,4)&
   +2D0*r1x2Z*(VS0(9,4)-ExZpE*VS1(9,4))
VS0(30,2)=PAx*VS0(18,2)+WPx*VS1(18,2)&
   +r1x2Z*(VS0(10,2)-ExZpE*VS1(10,2))&
   +HfxZpE*VS1(18,1)
VS0(30,3)=PAx*VS0(18,3)+WPx*VS1(18,3)&
   +r1x2Z*(VS0(10,3)-ExZpE*VS1(10,3))
VS0(30,4)=PAx*VS0(18,4)+WPx*VS1(18,4)&
   +r1x2Z*(VS0(10,4)-ExZpE*VS1(10,4))
VS0(31,2)=PAz*VS0(16,2)+WPz*VS1(16,2)+r1x2Z*VR1(16,2)&
   +r1x2Z*(VS0(6,2)-ExZpE*VS1(6,2))
VS0(31,3)=PAz*VS0(16,3)+WPz*VS1(16,3)+r1x2Z*VR1(16,3)&
   +r1x2Z*(VS0(6,3)-ExZpE*VS1(6,3))
VS0(31,4)=PAz*VS0(16,4)+WPz*VS1(16,4)+r1x2Z*VR1(16,4)&
   +r1x2Z*(VS0(6,4)-ExZpE*VS1(6,4))&
   +HfxZpE*VS1(16,1)
VS0(32,2)=PAy*VS0(19,2)+WPy*VS1(19,2)&
   +r1x2Z*(VS0(10,2)-ExZpE*VS1(10,2))
VS0(32,3)=PAy*VS0(19,3)+WPy*VS1(19,3)&
   +r1x2Z*(VS0(10,3)-ExZpE*VS1(10,3))&
   +HfxZpE*VS1(19,1)
VS0(32,4)=PAy*VS0(19,4)+WPy*VS1(19,4)&
   +r1x2Z*(VS0(10,4)-ExZpE*VS1(10,4))
VS0(33,2)=PAz*VS0(18,2)+WPz*VS1(18,2)+r1x2Z*VR1(18,2)&
   +2D0*r1x2Z*(VS0(8,2)-ExZpE*VS1(8,2))
VS0(33,3)=PAz*VS0(18,3)+WPz*VS1(18,3)+r1x2Z*VR1(18,3)&
   +2D0*r1x2Z*(VS0(8,3)-ExZpE*VS1(8,3))
VS0(33,4)=PAz*VS0(18,4)+WPz*VS1(18,4)+r1x2Z*VR1(18,4)&
   +2D0*r1x2Z*(VS0(8,4)-ExZpE*VS1(8,4))&
   +HfxZpE*VS1(18,1)
VS0(34,2)=PAz*VS0(19,2)+WPz*VS1(19,2)+r1x2Z*VR1(19,2)&
   +2D0*r1x2Z*(VS0(9,2)-ExZpE*VS1(9,2))
VS0(34,3)=PAz*VS0(19,3)+WPz*VS1(19,3)+r1x2Z*VR1(19,3)&
   +2D0*r1x2Z*(VS0(9,3)-ExZpE*VS1(9,3))
VS0(34,4)=PAz*VS0(19,4)+WPz*VS1(19,4)+r1x2Z*VR1(19,4)&
   +2D0*r1x2Z*(VS0(9,4)-ExZpE*VS1(9,4))&
   +HfxZpE*VS1(19,1)
VS0(35,2)=PAz*VS0(20,2)+WPz*VS1(20,2)+r1x2Z*VR1(20,2)&
   +3D0*r1x2Z*(VS0(10,2)-ExZpE*VS1(10,2))
VS0(35,3)=PAz*VS0(20,3)+WPz*VS1(20,3)+r1x2Z*VR1(20,3)&
   +3D0*r1x2Z*(VS0(10,3)-ExZpE*VS1(10,3))
VS0(35,4)=PAz*VS0(20,4)+WPz*VS1(20,4)+r1x2Z*VR1(20,4)&
   +3D0*r1x2Z*(VS0(10,4)-ExZpE*VS1(10,4))&
   +HfxZpE*VS1(20,1)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRg0p0'
STOP
END SELECT
END SUBROUTINE MVRRg0p0
