C------------------------------------------------------------------------------
C    This code is part of the MondoSCF suite of programs for linear scaling
C    electronic structure theory and ab initio molecular dynamics.
C
C    Copyright (2004). The Regents of the University of California. This
C    material was produced under U.S. Government contract W-7405-ENG-36
C    for Los Alamos National Laboratory, which is operated by the University
C    of California for the U.S. Department of Energy. The U.S. Government has
C    rights to use, reproduce, and distribute this software.  NEITHER THE
C    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
C    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
C
C    This program is free software; you can redistribute it and/or modify
C    it under the terms of the GNU General Public License as published by the
C    Free Software Foundation; either version 2 of the License, or (at your
C    option) any later version. Accordingly, this program is distributed in
C    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
C    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
C    PURPOSE. See the GNU General Public License at www.gnu.org for details.
C
C    While you may do as you like with this software, the GNU license requires
C    that you clearly mark derivative software.  In addition, you are encouraged
C    to return derivative works to the MondoSCF group for review, and possible
C    disemination in future releases.
C------------------------------------------------------------------------------
c:C_PBEsubrstart

c    Generated: Wed Sep  3 12:41:37 GMT 2003

      subroutine uks_c_pbe
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     J.P. Perdew, K. Burke, and M. Ernzerhof
c     Generalized gradient approximation made simple
c     Phys. Rev. Lett. 77 (1996) 3865-3868
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = 1/rhob
      t3 = t2**(1.D0/3.D0)
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t17 = dlog(1.D0+0.3216395899738507D2/(0.1112037486309468D2*t6
     #+0.3844746237447211D1*t3+0.1644733775567609D1*t9
     #+0.2405871291288192D0*t11))
      t18 = (1.D0+0.1274696188700087D0*t3)*t17
      t20 = rhob**2
      t21 = rhob**(1.D0/3.D0)
      t23 = 1/t21/t20
      t26 = dexp(0.2000000587336264D1*t18)
      t27 = t26-1.D0
      t31 = 0.2162211495206379D0/t27*sigmabb*t23
      t33 = t27**2
      t35 = sigmabb**2
      t37 = t20**2
      t38 = t21**2
      t49 = dlog(1.D0+0.2162211495206379D0*sigmabb*t23*(1.D0+t31)/
     #(1.D0+t31+0.4675158550002605D-1/t33*t35/t38/t37))
      zk(i) = rhob*(-0.310907D-1*t18+0.1554534543482745D-1*t49)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = 1/rhoa
      t3 = t2**(1.D0/3.D0)
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t17 = dlog(1.D0+0.3216395899738507D2/(0.1112037486309468D2*t6
     #+0.3844746237447211D1*t3+0.1644733775567609D1*t9
     #+0.2405871291288192D0*t11))
      t18 = (1.D0+0.1274696188700087D0*t3)*t17
      t20 = rhoa**2
      t21 = rhoa**(1.D0/3.D0)
      t23 = 1/t21/t20
      t26 = dexp(0.2000000587336264D1*t18)
      t27 = t26-1.D0
      t31 = 0.2162211495206379D0/t27*sigmaaa*t23
      t33 = t27**2
      t35 = sigmaaa**2
      t37 = t20**2
      t38 = t21**2
      t49 = dlog(1.D0+0.2162211495206379D0*sigmaaa*t23*(1.D0+t31)/
     #(1.D0+t31+0.4675158550002605D-1/t33*t35/t38/t37))
      zk(i) = rhoa*(-0.310907D-1*t18+0.1554534543482745D-1*t49)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = 1/rho
      t5 = t4**(1.D0/3.D0)
      t8 = t4**(1.D0/6.D0)
      t11 = dsqrt(t4)
      t13 = t5**2
      t19 = dlog(1.D0+0.1608197949869254D2/(0.598255043577108D1*t8
     #+0.2225569421150687D1*t5+0.8004286349993634D0*t11
     #+0.1897004325747559D0*t13))
      t21 = 0.621814D-1*(1.D0+0.1325688999052018D0*t5)*t19
      t32 = dlog(1.D0+0.2960874997779344D2/(0.8157414703487641D1*t8
     #+0.2247591863577616D1*t5+0.4300972471276643D0*t11
     #+0.1911512595127338D0*t13))
      t35 = rhoa-1.D0*rhob
      t36 = t35*t4
      t37 = 1.D0+t36
      t38 = t37**(1.D0/3.D0)
      t41 = 1.D0-1.D0*t36
      t42 = t41**(1.D0/3.D0)
      t44 = t38*t37+t42*t41-2.D0
      t45 = t35**2
      t46 = t45**2
      t47 = rho**2
      t48 = t47**2
      t50 = t46/t48
      t55 = 0.37995525D-1*(1.D0+0.6901399211255825D-1*t5)*t32*t44*
     #(1.D0-1.D0*t50)
      t66 = dlog(1.D0+0.3216395899738507D2/(0.1112037486309468D2*t8
     #+0.3844746237447211D1*t5+0.1644733775567609D1*t11
     #+0.2405871291288192D0*t13))
      t72 = 0.1923661050931536D1*(-0.310907D-1*(1.D0
     #+0.1274696188700087D0*t5)*t66+t21)*t44*t50
      t73 = t38**2
      t75 = t42**2
      t77 = 0.5D0*t73+0.5D0*t75
      t78 = t77**2
      t79 = t78*t77
      t80 = 1/t78
      t82 = rho**(1.D0/3.D0)
      t84 = 1/t82/t47
      t89 = dexp(-0.3216396844291482D2*(-t21+t55+t72)/t79)
      t90 = t89-1.D0
      t95 = 0.1362107888567592D0/t90*sigma*t80*t84
      t98 = t90**2
      t100 = sigma**2
      t102 = t78**2
      t104 = t82**2
      t116 = dlog(1.D0+0.1362107888567592D0*sigma*t80*t84*(1.D0+t95)/
     #(1.D0+t95+0.1855337900098064D-1/t98*t100/t102/t104/t48))
      zk(i) = rho*(-t21+t55+t72+0.310906908696549D-1*t79*t116)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = 1/rhob
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1274696188700087D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.1112037486309468D2*t6+0.3844746237447211D1*t3
     #+0.1644733775567609D1*t9+0.2405871291288192D0*t11
      t16 = 1.D0+0.3216395899738507D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.310907D-1*t18
      t20 = rhob**2
      t21 = rhob**(1.D0/3.D0)
      t23 = 1/t21/t20
      t24 = sigmabb*t23
      t26 = dexp(0.2000000587336264D1*t18)
      t27 = t26-1.D0
      t28 = 1/t27
      t29 = t28*sigmabb
      t31 = 0.2162211495206379D0*t29*t23
      t32 = 1.D0+t31
      t33 = t27**2
      t34 = 1/t33
      t35 = sigmabb**2
      t36 = t34*t35
      t37 = t20**2
      t38 = t21**2
      t40 = 1/t38/t37
      t41 = t36*t40
      t43 = 1.D0+t31+0.4675158550002605D-1*t41
      t44 = 1/t43
      t45 = t32*t44
      t48 = 1.D0+0.2162211495206379D0*t24*t45
      t49 = dlog(t48)
      t50 = 0.1554534543482745D-1*t49
      zk(i) = rhob*(-t19+t50)
      vrhoa(i) = 0.D0
      t54 = 1/t21/t20/rhob
      t60 = 1/t38/t37/rhob
      t62 = t28*t44
      t65 = t43**2
      t67 = t32/t65
      t78 = 1/t48
      t82 = 1/t20
      t83 = 1/t11*t82
      t84 = t83*t17
      t86 = t13**2
      t89 = t6**2
      t90 = t89**2
      t105 = t5/t86*(-0.1853395810515781D1/t90/t6*t82
     #-0.128158207914907D1*t83-0.8223668877838045D0/t9*t82
     #-0.1603914194192128D0/t3*t82)/t16
      t109 = -0.8497977086918237D-1*t84-0.6432793688582964D2*t105
      t114 = t34*sigmabb
      vrhob(i) = -t19+t50+0.1554534543482745D-1*rhob*(
     #-0.5045160155481551D0*sigmabb*t54*t45-0.1090870328333941D0*t35
     #*t60*t62-0.2162211495206379D0*t24*t67*(-0.5045160155481551D0*t29
     #*t54-0.2181740656667882D0*t36*t60))*t78+rhob*
     #(0.1321039893133927D-2*t84+0.1D1*t105+0.1554534543482745D-1*(
     #-0.4675158550002605D-1*t41*t109*t26*t44-0.2162211495206379D0*t24
     #*t67*(-0.2162211495206379D0*t114*t23*t109*t26
     #-0.935031710000521D-1/t33/t27*t35*t40*t109*t26))*t78)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.1554534543482745D-1*rhob*(0.2162211495206379D0
     #*t23*t32*t44+0.4675158550002605D-1*sigmabb*t40*t62
     #-0.2162211495206379D0*t24*t67*(0.2162211495206379D0*t28*t23
     #+0.935031710000521D-1*t114*t40))*t78
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = 1/rhoa
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1274696188700087D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.1112037486309468D2*t6+0.3844746237447211D1*t3
     #+0.1644733775567609D1*t9+0.2405871291288192D0*t11
      t16 = 1.D0+0.3216395899738507D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.310907D-1*t18
      t20 = rhoa**2
      t21 = rhoa**(1.D0/3.D0)
      t23 = 1/t21/t20
      t24 = sigmaaa*t23
      t26 = dexp(0.2000000587336264D1*t18)
      t27 = t26-1.D0
      t28 = 1/t27
      t29 = t28*sigmaaa
      t31 = 0.2162211495206379D0*t29*t23
      t32 = 1.D0+t31
      t33 = t27**2
      t34 = 1/t33
      t35 = sigmaaa**2
      t36 = t34*t35
      t37 = t20**2
      t38 = t21**2
      t40 = 1/t38/t37
      t41 = t36*t40
      t43 = 1.D0+t31+0.4675158550002605D-1*t41
      t44 = 1/t43
      t45 = t32*t44
      t48 = 1.D0+0.2162211495206379D0*t24*t45
      t49 = dlog(t48)
      t50 = 0.1554534543482745D-1*t49
      zk(i) = rhoa*(-t19+t50)
      t54 = 1/t21/t20/rhoa
      t60 = 1/t38/t37/rhoa
      t62 = t28*t44
      t65 = t43**2
      t67 = t32/t65
      t78 = 1/t48
      t82 = 1/t20
      t83 = 1/t11*t82
      t84 = t83*t17
      t86 = t13**2
      t89 = t6**2
      t90 = t89**2
      t105 = t5/t86*(-0.1853395810515781D1/t90/t6*t82
     #-0.128158207914907D1*t83-0.8223668877838045D0/t9*t82
     #-0.1603914194192128D0/t3*t82)/t16
      t109 = -0.8497977086918237D-1*t84-0.6432793688582964D2*t105
      t114 = t34*sigmaaa
      vrhoa(i) = -t19+t50+0.1554534543482745D-1*rhoa*(
     #-0.5045160155481551D0*sigmaaa*t54*t45-0.1090870328333941D0*t35
     #*t60*t62-0.2162211495206379D0*t24*t67*(-0.5045160155481551D0*t29
     #*t54-0.2181740656667882D0*t36*t60))*t78+rhoa*
     #(0.1321039893133927D-2*t84+0.1D1*t105+0.1554534543482745D-1*(
     #-0.4675158550002605D-1*t41*t109*t26*t44-0.2162211495206379D0*t24
     #*t67*(-0.2162211495206379D0*t114*t23*t109*t26
     #-0.935031710000521D-1/t33/t27*t35*t40*t109*t26))*t78)
      vrhob(i) = 0.D0
      vsigmaaa(i) = 0.1554534543482745D-1*rhoa*(0.2162211495206379D0
     #*t23*t32*t44+0.4675158550002605D-1*sigmaaa*t40*t62
     #-0.2162211495206379D0*t24*t67*(0.2162211495206379D0*t28*t23
     #+0.935031710000521D-1*t114*t40))*t78
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = 1/rho
      t5 = t4**(1.D0/3.D0)
      t7 = 1.D0+0.1325688999052018D0*t5
      t8 = t4**(1.D0/6.D0)
      t11 = dsqrt(t4)
      t13 = t5**2
      t15 = 0.598255043577108D1*t8+0.2225569421150687D1*t5
     #+0.8004286349993634D0*t11+0.1897004325747559D0*t13
      t18 = 1.D0+0.1608197949869254D2/t15
      t19 = dlog(t18)
      t21 = 0.621814D-1*t7*t19
      t23 = 1.D0+0.6901399211255825D-1*t5
      t28 = 0.8157414703487641D1*t8+0.2247591863577616D1*t5
     #+0.4300972471276643D0*t11+0.1911512595127338D0*t13
      t31 = 1.D0+0.2960874997779344D2/t28
      t32 = dlog(t31)
      t33 = t23*t32
      t35 = rhoa-1.D0*rhob
      t36 = t35*t4
      t37 = 1.D0+t36
      t38 = t37**(1.D0/3.D0)
      t41 = 1.D0-1.D0*t36
      t42 = t41**(1.D0/3.D0)
      t44 = t38*t37+t42*t41-2.D0
      t45 = t35**2
      t46 = t45**2
      t47 = rho**2
      t48 = t47**2
      t49 = 1/t48
      t50 = t46*t49
      t52 = 1.D0-1.D0*t50
      t55 = 0.37995525D-1*t33*t44*t52
      t57 = 1.D0+0.1274696188700087D0*t5
      t62 = 0.1112037486309468D2*t8+0.3844746237447211D1*t5
     #+0.1644733775567609D1*t11+0.2405871291288192D0*t13
      t65 = 1.D0+0.3216395899738507D2/t62
      t66 = dlog(t65)
      t69 = -0.310907D-1*t57*t66+t21
      t70 = t69*t44
      t72 = 0.1923661050931536D1*t70*t50
      t73 = t38**2
      t75 = t42**2
      t77 = 0.5D0*t73+0.5D0*t75
      t78 = t77**2
      t79 = t78*t77
      t80 = 1/t78
      t81 = sigma*t80
      t82 = rho**(1.D0/3.D0)
      t84 = 1/t82/t47
      t85 = -t21+t55+t72
      t86 = 1/t79
      t89 = dexp(-0.3216396844291482D2*t85*t86)
      t90 = t89-1.D0
      t91 = 1/t90
      t92 = t91*sigma
      t93 = t80*t84
      t95 = 0.1362107888567592D0*t92*t93
      t96 = 1.D0+t95
      t98 = t90**2
      t99 = 1/t98
      t100 = sigma**2
      t101 = t99*t100
      t102 = t78**2
      t103 = 1/t102
      t104 = t82**2
      t106 = 1/t104/t48
      t107 = t103*t106
      t110 = 1.D0+t95+0.1855337900098064D-1*t101*t107
      t111 = 1/t110
      t115 = 1.D0+0.1362107888567592D0*t81*t84*t96*t111
      t116 = dlog(t115)
      t118 = 0.310906908696549D-1*t79*t116
      zk(i) = rho*(-t21+t55+t72+t118)
      t124 = 0.1333333333333333D1*t38*t4-0.1333333333333333D1*t42*t4
      t127 = 0.37995525D-1*t33*t124*t52
      t128 = t45*t35
      t131 = t33*t44*t128*t49
      t132 = 0.1519821D0*t131
      t135 = 0.1923661050931536D1*t69*t124*t50
      t137 = t70*t128*t49
      t138 = 0.7694644203726145D1*t137
      t139 = t78*t116
      t140 = 1/t38
      t143 = 1/t42
      t146 = 0.3333333333333333D0*t140*t4-0.3333333333333333D0*t143*t4
      t150 = sigma*t86*t84
      t151 = t96*t111
      t155 = t99*sigma
      t156 = t155*t80
      t160 = t85*t103
      t163 = -0.3216396844291482D2*(t127-t132+t135+t138)*t86
     #+0.9649190532874446D2*t160*t146
      t167 = 0.1362107888567592D0*t156*t84*t163*t89
      t168 = t86*t84
      t171 = 0.2724215777135184D0*t92*t168*t146
      t177 = t81*t84
      t178 = t110**2
      t180 = t96/t178
      t184 = 1/t98/t90*t100*t103
      t191 = 1/t102/t77*t106
      t201 = 1/t115
      t207 = 1/t47
      t208 = 1/t13*t207
      t209 = t208*t19
      t210 = 0.2747773264188438D-2*t209
      t211 = t15**2
      t214 = t8**2
      t215 = t214**2
      t218 = 1/t215/t8*t207
      t222 = 1/t11*t207
      t225 = 1/t5*t207
      t230 = t7/t211*(-0.99709173929518D0*t218-0.7418564737168958D0
     #*t208-0.4002143174996817D0*t222-0.1264669550498372D0*t225)/t18
      t231 = 0.1D1*t230
      t235 = 0.87407428755417D-3*t208*t32*t44*t52
      t236 = t28**2
      t249 = 0.1125D1*t23/t236*(-0.135956911724794D1*t218
     #-0.7491972878592054D0*t208-0.2150486235638321D0*t222
     #-0.1274341730084892D0*t225)/t31*t44*t52
      t256 = -0.1333333333333333D1*t38*t35*t207+0.1333333333333333D1
     #*t42*t35*t207
      t259 = 0.37995525D-1*t33*t256*t52
      t261 = t48*rho
      t262 = 1/t261
      t265 = 0.1519821D0*t33*t44*t46*t262
      t268 = t62**2
      t285 = 0.1923661050931536D1*(0.1321039893133927D-2*t208*t66
     #+0.1D1*t57/t268*(-0.1853395810515781D1*t218-0.128158207914907D1
     #*t208-0.8223668877838045D0*t222-0.1603914194192128D0*t225)/t65
     #-0.2747773264188438D-2*t209-0.1D1*t230)*t44*t50
      t288 = 0.1923661050931536D1*t69*t256*t50
      t291 = 0.7694644203726145D1*t70*t46*t262
      t298 = -0.3333333333333333D0*t140*t35*t207+0.3333333333333333D0
     #*t143*t35*t207
      t306 = 1/t82/t47/rho
      t316 = -0.3216396844291482D2*(t210+t231-t235-t249+t259+t265+t285
     #+t288-t291)*t86+0.9649190532874446D2*t160*t298
      t320 = 0.1362107888567592D0*t156*t84*t316*t89
      t323 = 0.2724215777135184D0*t92*t168*t298
      t326 = 0.3178251739991049D0*t92*t80*t306
      t352 = t210+t231-t235-t249+t259+t265+t285+t288-t291
     #+0.9327207260896469D-1*t139*t298+0.310906908696549D-1*t79*(
     #-0.2724215777135184D0*t150*t151*t298-0.3178251739991049D0*t81
     #*t306*t96*t111+0.1362107888567592D0*t81*t84*(-t320-t323-t326)
     #*t111-0.1362107888567592D0*t177*t180*(-t320-t323-t326
     #-0.3710675800196129D-1*t184*t106*t316*t89-0.7421351600392257D-1
     #*t101*t191*t298-0.8658243533790967D-1*t101*t103/t104/t261))*t201
      t353 = rho*t352
      vrhoa(i) = rho*(t127-t132+t135+t138+0.9327207260896469D-1*t139
     #*t146+0.310906908696549D-1*t79*(-0.2724215777135184D0*t150*t151
     #*t146+0.1362107888567592D0*t81*t84*(-t167-t171)*t111
     #-0.1362107888567592D0*t177*t180*(-t167-t171
     #-0.3710675800196129D-1*t184*t106*t163*t89-0.7421351600392257D-1
     #*t101*t191*t146))*t201)-t21+t55+t72+t118+t353
      t354 = -t124
      t357 = 0.37995525D-1*t33*t354*t52
      t358 = 0.1519821D0*t131
      t361 = 0.1923661050931536D1*t69*t354*t50
      t362 = 0.7694644203726145D1*t137
      t363 = -t146
      t374 = -0.3216396844291482D2*(t357+t358+t361-t362)*t86
     #+0.9649190532874446D2*t160*t363
      t378 = 0.1362107888567592D0*t156*t84*t374*t89
      t381 = 0.2724215777135184D0*t92*t168*t363
      vrhob(i) = rho*(t357+t358+t361-t362+0.9327207260896469D-1*t139
     #*t363+0.310906908696549D-1*t79*(-0.2724215777135184D0*t150*t151
     #*t363+0.1362107888567592D0*t81*t84*(-t378-t381)*t111
     #-0.1362107888567592D0*t177*t180*(-t378-t381
     #-0.3710675800196129D-1*t184*t106*t374*t89-0.7421351600392257D-1
     #*t101*t191*t363))*t201)-t21+t55+t72+t118+t353
      t423 = rho*t79*(0.1362107888567592D0*t93*t151
     #+0.1855337900098064D-1*sigma*t103*t106*t91*t111
     #-0.1362107888567592D0*t177*t180*(0.1362107888567592D0*t91*t80
     #*t84+0.3710675800196129D-1*t155*t107))*t201
      vsigmaaa(i) = 0.310906908696549D-1*t423
      vsigmaab(i) = 0.6218138173930979D-1*t423
      vsigmabb(i) = vsigmaaa(i)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = 1/rhob
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1274696188700087D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.1112037486309468D2*t6+0.3844746237447211D1*t3
     #+0.1644733775567609D1*t9+0.2405871291288192D0*t11
      t16 = 1.D0+0.3216395899738507D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.310907D-1*t18
      t20 = rhob**2
      t21 = rhob**(1.D0/3.D0)
      t23 = 1/t21/t20
      t24 = sigmabb*t23
      t26 = dexp(0.2000000587336264D1*t18)
      t27 = t26-1.D0
      t28 = 1/t27
      t29 = t28*sigmabb
      t31 = 0.2162211495206379D0*t29*t23
      t32 = 1.D0+t31
      t33 = t27**2
      t34 = 1/t33
      t35 = sigmabb**2
      t36 = t34*t35
      t37 = t20**2
      t38 = t21**2
      t40 = 1/t38/t37
      t41 = t36*t40
      t43 = 1.D0+t31+0.4675158550002605D-1*t41
      t44 = 1/t43
      t45 = t32*t44
      t48 = 1.D0+0.2162211495206379D0*t24*t45
      t49 = dlog(t48)
      t50 = 0.1554534543482745D-1*t49
      zk(i) = rhob*(-t19+t50)
      vrhoa(i) = 0.D0
      t52 = t20*rhob
      t54 = 1/t21/t52
      t55 = sigmabb*t54
      t60 = 1/t38/t37/rhob
      t61 = t35*t60
      t62 = t28*t44
      t65 = t43**2
      t66 = 1/t65
      t67 = t32*t66
      t70 = t36*t60
      t72 = -0.5045160155481551D0*t29*t54-0.2181740656667882D0*t70
      t73 = t67*t72
      t76 = -0.5045160155481551D0*t55*t45-0.1090870328333941D0*t61*t62
     #-0.2162211495206379D0*t24*t73
      t77 = rhob*t76
      t78 = 1/t48
      t81 = 1/t11
      t82 = 1/t20
      t83 = t81*t82
      t84 = t83*t17
      t86 = t13**2
      t87 = 1/t86
      t88 = t5*t87
      t89 = t6**2
      t90 = t89**2
      t91 = t90*t6
      t92 = 1/t91
      t96 = 1/t9
      t99 = 1/t3
      t102 = -0.1853395810515781D1*t92*t82-0.128158207914907D1*t83
     #-0.8223668877838045D0*t96*t82-0.1603914194192128D0*t99*t82
      t103 = 1/t16
      t105 = t88*t102*t103
      t109 = -0.8497977086918237D-1*t84-0.6432793688582964D2*t105
      t110 = t109*t26
      t111 = t110*t44
      t114 = t34*sigmabb
      t120 = 1/t33/t27
      t121 = t120*t35
      t126 = -0.2162211495206379D0*t114*t23*t109*t26
     #-0.935031710000521D-1*t121*t40*t109*t26
      t127 = t67*t126
      t130 = -0.4675158550002605D-1*t41*t111-0.2162211495206379D0*t24
     #*t127
      t131 = t130*t78
      vrhob(i) = -t19+t50+0.1554534543482745D-1*t77*t78+rhob*
     #(0.1321039893133927D-2*t84+0.1D1*t105+0.1554534543482745D-1*t131)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t135 = t23*t32
      t138 = sigmabb*t40
      t145 = 0.2162211495206379D0*t28*t23+0.935031710000521D-1*t114*t40
      t149 = 0.2162211495206379D0*t135*t44+0.4675158550002605D-1*t138
     #*t62-0.2162211495206379D0*t24*t67*t145
      vsigmabb(i) = 0.1554534543482745D-1*rhob*t149*t78
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t155 = 1/t21/t37
      t161 = 1/t38/t37/t20
      t167 = t28*t66
      t172 = 1/t65/t43
      t173 = t32*t172
      t174 = t72**2
      t190 = t76**2
      t192 = t48**2
      t193 = 1/t192
      t199 = t70*t111
      t204 = 0.4675158550002605D-1*t41*t110*t66*t72
      t206 = 0.5045160155481551D0*t55*t127
      t209 = 0.1090870328333941D0*t61*t167*t126
      t214 = 0.4324422990412758D0*t24*t32*t172*t126*t72
      t226 = 0.2162211495206379D0*t24*t67*(0.5045160155481551D0*t114
     #*t54*t109*t26+0.4363481313335765D0*t121*t60*t109*t26)
      t230 = t130*t193
      t244 = 1/t37
      t245 = 1/t11/t2*t244
      t246 = t245*t17
      t248 = 1/t52
      t249 = t81*t248
      t250 = t249*t17
      t254 = t83*t87*t102*t103
      t259 = t102**2
      t261 = t5/t86/t13*t259*t103
      t285 = t88*(-0.1544496508763151D1/t91/t2*t244
     #+0.3706791621031562D1*t92*t248-0.854388052766047D0*t245
     #+0.2563164158298141D1*t249-0.4111834438919023D0/t9/t2*t244
     #+0.1644733775567609D1*t96*t248-0.5346380647307093D-1/t3/t2*t244
     #+0.3207828388384256D0*t99*t248)*t103
      t287 = t86**2
      t290 = t16**2
      t293 = t5/t287*t259/t290
      t297 = t109**2
      t298 = t26**2
      t309 = -0.5665318057945491D-1*t246+0.1699595417383647D0*t250
     #+0.546657173168712D1*t254+0.1286558737716593D3*t261
     #-0.6432793688582964D2*t285-0.2069041124382199D4*t293
      t322 = t126**2
      t327 = t23*t297
      t338 = t33**2
      t341 = t40*t297
      t359 = t130**2
      s1 = 0.310906908696549D-1*t76*t78+0.1554534543482745D-1*rhob*
     #(0.1681720051827184D1*sigmabb*t155*t45+0.8726962626671529D0*t35
     #*t161*t62+0.100903203109631D1*t55*t73+0.2181740656667882D0*t61
     #*t167*t72+0.4324422990412758D0*t24*t173*t174
     #-0.2162211495206379D0*t24*t67*(0.1681720051827184D1*t29*t155
     #+0.1236319705445133D1*t36*t161))*t78-0.1554534543482745D-1*rhob
     #*t190*t193+0.2642079786267853D-2*t84+0.2D1*t105
      s2 = s1+0.310906908696549D-1*t131+rhob*(0.1554534543482745D-1*
     #(0.2181740656667882D0*t199+t204+t206+t209+t214-t226)*t78
     #-0.1554534543482745D-1*t230*t76)
      s3 = s2+0.1554534543482745D-1*rhob*(0.2181740656667882D0*t199
     #+t206+t209+t204+t214-t226)*t78
      v2rhob2(i) = s3-0.1554534543482745D-1*t77*t230+rhob*
     #(0.8806932620892844D-3*t246-0.2642079786267853D-2*t250
     #-0.8497974591333914D-1*t254-0.2D1*t261+0.1D1*t285
     #+0.3216395899738507D2*t293+0.1554534543482745D-1*
     #(0.935031710000521D-1*t35*t40*t120*t297*t298*t44
     #-0.4675158550002605D-1*t41*t309*t26*t44-0.4675158550002605D-1
     #*t41*t297*t26*t44+0.935031710000521D-1*t41*t110*t66*t126
     #+0.4324422990412758D0*t24*t173*t322-0.2162211495206379D0*t24*t67
     #*(0.4324422990412758D0*t120*sigmabb*t327*t298
     #-0.2162211495206379D0*t114*t23*t309*t26-0.2162211495206379D0
     #*t114*t327*t26+0.2805095130001563D0/t338*t35*t341*t298
     #-0.935031710000521D-1*t121*t40*t309*t26-0.935031710000521D-1
     #*t121*t341*t26))*t78-0.1554534543482745D-1*t359*t193)
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t373 = t145**2
      t387 = t149**2
      v2sigmabb2(i) = 0.1554534543482745D-1*rhob*(0.935031710000521D-1
     #*t40*t28*t44-0.4324422990412758D0*t135*t66*t145
     #-0.935031710000521D-1*t138*t167*t145+0.4324422990412758D0*t24
     #*t173*t373-0.2021736311745604D-1*sigmabb/t37/t52*t67*t34)*t78
     #-0.1554534543482745D-1*rhob*t387*t193
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = 1/rhoa
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1274696188700087D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.1112037486309468D2*t6+0.3844746237447211D1*t3
     #+0.1644733775567609D1*t9+0.2405871291288192D0*t11
      t16 = 1.D0+0.3216395899738507D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.310907D-1*t18
      t20 = rhoa**2
      t21 = rhoa**(1.D0/3.D0)
      t23 = 1/t21/t20
      t24 = sigmaaa*t23
      t26 = dexp(0.2000000587336264D1*t18)
      t27 = t26-1.D0
      t28 = 1/t27
      t29 = t28*sigmaaa
      t31 = 0.2162211495206379D0*t29*t23
      t32 = 1.D0+t31
      t33 = t27**2
      t34 = 1/t33
      t35 = sigmaaa**2
      t36 = t34*t35
      t37 = t20**2
      t38 = t21**2
      t40 = 1/t38/t37
      t41 = t36*t40
      t43 = 1.D0+t31+0.4675158550002605D-1*t41
      t44 = 1/t43
      t45 = t32*t44
      t48 = 1.D0+0.2162211495206379D0*t24*t45
      t49 = dlog(t48)
      t50 = 0.1554534543482745D-1*t49
      zk(i) = rhoa*(-t19+t50)
      t52 = t20*rhoa
      t54 = 1/t21/t52
      t55 = sigmaaa*t54
      t60 = 1/t38/t37/rhoa
      t61 = t35*t60
      t62 = t28*t44
      t65 = t43**2
      t66 = 1/t65
      t67 = t32*t66
      t70 = t36*t60
      t72 = -0.5045160155481551D0*t29*t54-0.2181740656667882D0*t70
      t73 = t67*t72
      t76 = -0.5045160155481551D0*t55*t45-0.1090870328333941D0*t61*t62
     #-0.2162211495206379D0*t24*t73
      t77 = rhoa*t76
      t78 = 1/t48
      t81 = 1/t11
      t82 = 1/t20
      t83 = t81*t82
      t84 = t83*t17
      t86 = t13**2
      t87 = 1/t86
      t88 = t5*t87
      t89 = t6**2
      t90 = t89**2
      t91 = t90*t6
      t92 = 1/t91
      t96 = 1/t9
      t99 = 1/t3
      t102 = -0.1853395810515781D1*t92*t82-0.128158207914907D1*t83
     #-0.8223668877838045D0*t96*t82-0.1603914194192128D0*t99*t82
      t103 = 1/t16
      t105 = t88*t102*t103
      t109 = -0.8497977086918237D-1*t84-0.6432793688582964D2*t105
      t110 = t109*t26
      t111 = t110*t44
      t114 = t34*sigmaaa
      t120 = 1/t33/t27
      t121 = t120*t35
      t126 = -0.2162211495206379D0*t114*t23*t109*t26
     #-0.935031710000521D-1*t121*t40*t109*t26
      t127 = t67*t126
      t130 = -0.4675158550002605D-1*t41*t111-0.2162211495206379D0*t24
     #*t127
      t131 = t130*t78
      vrhoa(i) = -t19+t50+0.1554534543482745D-1*t77*t78+rhoa*
     #(0.1321039893133927D-2*t84+0.1D1*t105+0.1554534543482745D-1*t131)
      vrhob(i) = 0.D0
      t135 = t23*t32
      t138 = sigmaaa*t40
      t145 = 0.2162211495206379D0*t28*t23+0.935031710000521D-1*t114*t40
      t149 = 0.2162211495206379D0*t135*t44+0.4675158550002605D-1*t138
     #*t62-0.2162211495206379D0*t24*t67*t145
      vsigmaaa(i) = 0.1554534543482745D-1*rhoa*t149*t78
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t155 = 1/t21/t37
      t161 = 1/t38/t37/t20
      t167 = t28*t66
      t172 = 1/t65/t43
      t173 = t32*t172
      t174 = t72**2
      t190 = t76**2
      t192 = t48**2
      t193 = 1/t192
      t199 = t70*t111
      t204 = 0.4675158550002605D-1*t41*t110*t66*t72
      t206 = 0.5045160155481551D0*t55*t127
      t209 = 0.1090870328333941D0*t61*t167*t126
      t214 = 0.4324422990412758D0*t24*t32*t172*t126*t72
      t226 = 0.2162211495206379D0*t24*t67*(0.5045160155481551D0*t114
     #*t54*t109*t26+0.4363481313335765D0*t121*t60*t109*t26)
      t230 = t130*t193
      t244 = 1/t37
      t245 = 1/t11/t2*t244
      t246 = t245*t17
      t248 = 1/t52
      t249 = t81*t248
      t250 = t249*t17
      t254 = t83*t87*t102*t103
      t259 = t102**2
      t261 = t5/t86/t13*t259*t103
      t285 = t88*(-0.1544496508763151D1/t91/t2*t244
     #+0.3706791621031562D1*t92*t248-0.854388052766047D0*t245
     #+0.2563164158298141D1*t249-0.4111834438919023D0/t9/t2*t244
     #+0.1644733775567609D1*t96*t248-0.5346380647307093D-1/t3/t2*t244
     #+0.3207828388384256D0*t99*t248)*t103
      t287 = t86**2
      t290 = t16**2
      t293 = t5/t287*t259/t290
      t297 = t109**2
      t298 = t26**2
      t309 = -0.5665318057945491D-1*t246+0.1699595417383647D0*t250
     #+0.546657173168712D1*t254+0.1286558737716593D3*t261
     #-0.6432793688582964D2*t285-0.2069041124382199D4*t293
      t322 = t126**2
      t327 = t23*t297
      t338 = t33**2
      t341 = t40*t297
      t359 = t130**2
      s1 = 0.310906908696549D-1*t76*t78+0.1554534543482745D-1*rhoa*
     #(0.1681720051827184D1*sigmaaa*t155*t45+0.8726962626671529D0*t35
     #*t161*t62+0.100903203109631D1*t55*t73+0.2181740656667882D0*t61
     #*t167*t72+0.4324422990412758D0*t24*t173*t174
     #-0.2162211495206379D0*t24*t67*(0.1681720051827184D1*t29*t155
     #+0.1236319705445133D1*t36*t161))*t78-0.1554534543482745D-1*rhoa
     #*t190*t193+0.2642079786267853D-2*t84+0.2D1*t105
      s2 = s1+0.310906908696549D-1*t131+rhoa*(0.1554534543482745D-1*
     #(0.2181740656667882D0*t199+t204+t206+t209+t214-t226)*t78
     #-0.1554534543482745D-1*t230*t76)
      s3 = s2+0.1554534543482745D-1*rhoa*(0.2181740656667882D0*t199
     #+t206+t209+t204+t214-t226)*t78
      v2rhoa2(i) = s3-0.1554534543482745D-1*t77*t230+rhoa*
     #(0.8806932620892844D-3*t246-0.2642079786267853D-2*t250
     #-0.8497974591333914D-1*t254-0.2D1*t261+0.1D1*t285
     #+0.3216395899738507D2*t293+0.1554534543482745D-1*
     #(0.935031710000521D-1*t35*t40*t120*t297*t298*t44
     #-0.4675158550002605D-1*t41*t309*t26*t44-0.4675158550002605D-1
     #*t41*t297*t26*t44+0.935031710000521D-1*t41*t110*t66*t126
     #+0.4324422990412758D0*t24*t173*t322-0.2162211495206379D0*t24*t67
     #*(0.4324422990412758D0*t120*sigmaaa*t327*t298
     #-0.2162211495206379D0*t114*t23*t309*t26-0.2162211495206379D0
     #*t114*t327*t26+0.2805095130001563D0/t338*t35*t341*t298
     #-0.935031710000521D-1*t121*t40*t309*t26-0.935031710000521D-1
     #*t121*t341*t26))*t78-0.1554534543482745D-1*t359*t193)
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t373 = t145**2
      t387 = t149**2
      v2sigmaaa2(i) = 0.1554534543482745D-1*rhoa*(0.935031710000521D-1
     #*t40*t28*t44-0.4324422990412758D0*t135*t66*t145
     #-0.935031710000521D-1*t138*t167*t145+0.4324422990412758D0*t24
     #*t173*t373-0.2021736311745604D-1*sigmaaa/t37/t52*t67*t34)*t78
     #-0.1554534543482745D-1*rhoa*t387*t193
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = 1/rho
      t5 = t4**(1.D0/3.D0)
      t7 = 1.D0+0.1325688999052018D0*t5
      t8 = t4**(1.D0/6.D0)
      t11 = dsqrt(t4)
      t13 = t5**2
      t15 = 0.598255043577108D1*t8+0.2225569421150687D1*t5
     #+0.8004286349993634D0*t11+0.1897004325747559D0*t13
      t18 = 1.D0+0.1608197949869254D2/t15
      t19 = dlog(t18)
      t21 = 0.621814D-1*t7*t19
      t23 = 1.D0+0.6901399211255825D-1*t5
      t28 = 0.8157414703487641D1*t8+0.2247591863577616D1*t5
     #+0.4300972471276643D0*t11+0.1911512595127338D0*t13
      t31 = 1.D0+0.2960874997779344D2/t28
      t32 = dlog(t31)
      t33 = t23*t32
      t35 = rhoa-1.D0*rhob
      t36 = t35*t4
      t37 = 1.D0+t36
      t38 = t37**(1.D0/3.D0)
      t39 = t38*t37
      t41 = 1.D0-1.D0*t36
      t42 = t41**(1.D0/3.D0)
      t43 = t42*t41
      t44 = t39+t43-2.D0
      t45 = t35**2
      t46 = t45**2
      t47 = rho**2
      t48 = t47**2
      t49 = 1/t48
      t50 = t46*t49
      t52 = 1.D0-1.D0*t50
      t53 = t44*t52
      t55 = 0.37995525D-1*t33*t53
      t57 = 1.D0+0.1274696188700087D0*t5
      t62 = 0.1112037486309468D2*t8+0.3844746237447211D1*t5
     #+0.1644733775567609D1*t11+0.2405871291288192D0*t13
      t65 = 1.D0+0.3216395899738507D2/t62
      t66 = dlog(t65)
      t69 = -0.310907D-1*t57*t66+t21
      t70 = t69*t44
      t72 = 0.1923661050931536D1*t70*t50
      t73 = t38**2
      t75 = t42**2
      t77 = 0.5D0*t73+0.5D0*t75
      t78 = t77**2
      t79 = t78*t77
      t80 = 1/t78
      t81 = sigma*t80
      t82 = rho**(1.D0/3.D0)
      t84 = 1/t82/t47
      t85 = -t21+t55+t72
      t86 = 1/t79
      t89 = dexp(-0.3216396844291482D2*t85*t86)
      t90 = t89-1.D0
      t91 = 1/t90
      t92 = t91*sigma
      t93 = t80*t84
      t95 = 0.1362107888567592D0*t92*t93
      t96 = 1.D0+t95
      t98 = t90**2
      t99 = 1/t98
      t100 = sigma**2
      t101 = t99*t100
      t102 = t78**2
      t103 = 1/t102
      t104 = t82**2
      t106 = 1/t104/t48
      t107 = t103*t106
      t110 = 1.D0+t95+0.1855337900098064D-1*t101*t107
      t111 = 1/t110
      t115 = 1.D0+0.1362107888567592D0*t81*t84*t96*t111
      t116 = dlog(t115)
      t118 = 0.310906908696549D-1*t79*t116
      zk(i) = rho*(-t21+t55+t72+t118)
      t124 = 0.1333333333333333D1*t38*t4-0.1333333333333333D1*t42*t4
      t126 = t33*t124*t52
      t127 = 0.37995525D-1*t126
      t128 = t45*t35
      t129 = t44*t128
      t131 = t33*t129*t49
      t132 = 0.1519821D0*t131
      t133 = t69*t124
      t134 = t133*t50
      t135 = 0.1923661050931536D1*t134
      t136 = t128*t49
      t137 = t70*t136
      t138 = 0.7694644203726145D1*t137
      t139 = t78*t116
      t140 = 1/t38
      t143 = 1/t42
      t146 = 0.3333333333333333D0*t140*t4-0.3333333333333333D0*t143*t4
      t147 = t139*t146
      t148 = 0.9327207260896469D-1*t147
      t149 = sigma*t86
      t150 = t149*t84
      t151 = t96*t111
      t152 = t151*t146
      t155 = t99*sigma
      t156 = t155*t80
      t157 = t127-t132+t135+t138
      t160 = t85*t103
      t163 = -0.3216396844291482D2*t157*t86+0.9649190532874446D2*t160
     #*t146
      t164 = t84*t163
      t165 = t164*t89
      t167 = 0.1362107888567592D0*t156*t165
      t168 = t86*t84
      t171 = 0.2724215777135184D0*t92*t168*t146
      t172 = -t167-t171
      t177 = t81*t84
      t178 = t110**2
      t179 = 1/t178
      t180 = t96*t179
      t182 = 1/t98/t90
      t183 = t182*t100
      t184 = t183*t103
      t185 = t106*t163
      t186 = t185*t89
      t190 = 1/t102/t77
      t191 = t190*t106
      t192 = t191*t146
      t195 = -t167-t171-0.3710675800196129D-1*t184*t186
     #-0.7421351600392257D-1*t101*t192
      t196 = t180*t195
      t199 = -0.2724215777135184D0*t150*t152+0.1362107888567592D0*t81
     #*t84*t172*t111-0.1362107888567592D0*t177*t196
      t200 = t79*t199
      t201 = 1/t115
      t202 = t200*t201
      t203 = 0.310906908696549D-1*t202
      t206 = 1/t13
      t207 = 1/t47
      t208 = t206*t207
      t209 = t208*t19
      t210 = 0.2747773264188438D-2*t209
      t211 = t15**2
      t212 = 1/t211
      t213 = t7*t212
      t214 = t8**2
      t215 = t214**2
      t216 = t215*t8
      t217 = 1/t216
      t218 = t217*t207
      t221 = 1/t11
      t222 = t221*t207
      t224 = 1/t5
      t225 = t224*t207
      t227 = -0.99709173929518D0*t218-0.7418564737168958D0*t208
     #-0.4002143174996817D0*t222-0.1264669550498372D0*t225
      t228 = 1/t18
      t230 = t213*t227*t228
      t231 = 0.1D1*t230
      t232 = t32*t44
      t233 = t232*t52
      t234 = t208*t233
      t235 = 0.87407428755417D-3*t234
      t236 = t28**2
      t237 = 1/t236
      t238 = t23*t237
      t243 = -0.135956911724794D1*t218-0.7491972878592054D0*t208
     #-0.2150486235638321D0*t222-0.1274341730084892D0*t225
      t244 = t238*t243
      t245 = 1/t31
      t246 = t245*t44
      t247 = t246*t52
      t248 = t244*t247
      t249 = 0.1125D1*t248
      t250 = t38*t35
      t253 = t42*t35
      t256 = -0.1333333333333333D1*t250*t207+0.1333333333333333D1*t253
     #*t207
      t258 = t33*t256*t52
      t259 = 0.37995525D-1*t258
      t260 = t44*t46
      t261 = t48*rho
      t262 = 1/t261
      t264 = t33*t260*t262
      t265 = 0.1519821D0*t264
      t268 = t62**2
      t269 = 1/t268
      t270 = t57*t269
      t275 = -0.1853395810515781D1*t218-0.128158207914907D1*t208
     #-0.8223668877838045D0*t222-0.1603914194192128D0*t225
      t276 = 1/t65
      t282 = 0.1321039893133927D-2*t208*t66+0.1D1*t270*t275*t276
     #-0.2747773264188438D-2*t209-0.1D1*t230
      t283 = t282*t44
      t284 = t283*t50
      t285 = 0.1923661050931536D1*t284
      t286 = t69*t256
      t287 = t286*t50
      t288 = 0.1923661050931536D1*t287
      t289 = t46*t262
      t290 = t70*t289
      t291 = 0.7694644203726145D1*t290
      t292 = t140*t35
      t295 = t143*t35
      t298 = -0.3333333333333333D0*t292*t207+0.3333333333333333D0*t295
     #*t207
      t299 = t139*t298
      t301 = t151*t298
      t304 = t47*rho
      t306 = 1/t82/t304
      t311 = t210+t231-t235-t249+t259+t265+t285+t288-t291
      t316 = -0.3216396844291482D2*t311*t86+0.9649190532874446D2*t160
     #*t298
      t317 = t84*t316
      t318 = t317*t89
      t320 = 0.1362107888567592D0*t156*t318
      t323 = 0.2724215777135184D0*t92*t168*t298
      t324 = t80*t306
      t326 = 0.3178251739991049D0*t92*t324
      t327 = -t320-t323-t326
      t332 = t106*t316
      t333 = t332*t89
      t336 = t191*t298
      t340 = 1/t104/t261
      t341 = t103*t340
      t344 = -t320-t323-t326-0.3710675800196129D-1*t184*t333
     #-0.7421351600392257D-1*t101*t336-0.8658243533790967D-1*t101*t341
      t345 = t180*t344
      t348 = -0.2724215777135184D0*t150*t301-0.3178251739991049D0*t81
     #*t306*t96*t111+0.1362107888567592D0*t81*t84*t327*t111
     #-0.1362107888567592D0*t177*t345
      t349 = t79*t348
      t350 = t349*t201
      t352 = t210+t231-t235-t249+t259+t265+t285+t288-t291
     #+0.9327207260896469D-1*t299+0.310906908696549D-1*t350
      t353 = rho*t352
      vrhoa(i) = rho*(t127-t132+t135+t138+t148+t203)-t21+t55+t72+t118
     #+t353
      t354 = -t124
      t356 = t33*t354*t52
      t357 = 0.37995525D-1*t356
      t358 = 0.1519821D0*t131
      t359 = t69*t354
      t360 = t359*t50
      t361 = 0.1923661050931536D1*t360
      t362 = 0.7694644203726145D1*t137
      t363 = -t146
      t364 = t139*t363
      t365 = 0.9327207260896469D-1*t364
      t366 = t151*t363
      t369 = t357+t358+t361-t362
      t374 = -0.3216396844291482D2*t369*t86+0.9649190532874446D2*t160
     #*t363
      t375 = t84*t374
      t376 = t375*t89
      t378 = 0.1362107888567592D0*t156*t376
      t381 = 0.2724215777135184D0*t92*t168*t363
      t382 = -t378-t381
      t387 = t106*t374
      t388 = t387*t89
      t391 = t191*t363
      t394 = -t378-t381-0.3710675800196129D-1*t184*t388
     #-0.7421351600392257D-1*t101*t391
      t395 = t180*t394
      t398 = -0.2724215777135184D0*t150*t366+0.1362107888567592D0*t81
     #*t84*t382*t111-0.1362107888567592D0*t177*t395
      t399 = t79*t398
      t400 = t399*t201
      t401 = 0.310906908696549D-1*t400
      vrhob(i) = rho*(t357+t358+t361-t362+t365+t401)-t21+t55+t72+t118
     #+t353
      t404 = rho*t79
      t407 = sigma*t103
      t412 = t91*t80
      t417 = 0.1362107888567592D0*t412*t84+0.3710675800196129D-1*t155
     #*t107
      t418 = t180*t417
      t421 = 0.1362107888567592D0*t93*t151+0.1855337900098064D-1*t407
     #*t106*t91*t111-0.1362107888567592D0*t177*t418
      t423 = t404*t421*t201
      vsigmaaa(i) = 0.310906908696549D-1*t423
      vsigmaab(i) = 0.6218138173930979D-1*t423
      vsigmabb(i) = vsigmaaa(i)
      t427 = 0.87407428755417D-3*t208*t32*t124*t52
      t428 = t48*t47
      t429 = 1/t428
      t432 = t206*t429*t232*t128
      t433 = 0.349629715021668D-2*t432
      t437 = 0.1125D1*t244*t245*t124*t52
      t439 = t244*t246*t136
      t440 = 0.45D1*t439
      t441 = 1/t73
      t443 = 1/t304
      t448 = 1/t75
      t454 = -0.4444444444444444D0*t441*t35*t443-0.1333333333333333D1
     #*t38*t207-0.4444444444444444D0*t448*t35*t443
     #+0.1333333333333333D1*t42*t207
      t457 = 0.37995525D-1*t33*t454*t52
      t460 = t33*t256*t128*t49
      t461 = 0.1519821D0*t460
      t465 = 0.1519821D0*t33*t124*t46*t262
      t467 = t33*t129*t262
      t468 = 0.6079284D0*t467
      t471 = 0.1923661050931536D1*t282*t124*t50
      t472 = t283*t136
      t473 = 0.7694644203726145D1*t472
      t476 = 0.1923661050931536D1*t69*t454*t50
      t477 = t286*t136
      t478 = 0.7694644203726145D1*t477
      t480 = 0.7694644203726145D1*t133*t289
      t482 = t70*t128*t262
      t483 = 0.3077857681490458D2*t482
      t484 = t77*t116
      t485 = t298*t146
      t487 = 0.1865441452179294D0*t484*t485
      t488 = t78*t199
      t489 = t201*t298
      t491 = 0.9327207260896469D-1*t488*t489
      t492 = 1/t39
      t498 = 1/t43
      t504 = 0.1111111111111111D0*t492*t35*t443-0.3333333333333333D0
     #*t140*t207+0.1111111111111111D0*t498*t35*t443
     #+0.3333333333333333D0*t143*t207
      t506 = 0.9327207260896469D-1*t139*t504
      t507 = t78*t348
      t508 = t201*t146
      t510 = 0.9327207260896469D-1*t507*t508
      t511 = t407*t84
      t514 = 0.8172647331405553D0*t511*t151*t485
      t515 = t172*t111
      t518 = 0.2724215777135184D0*t150*t515*t298
      t522 = 0.2724215777135184D0*t150*t180*t298*t195
      t525 = 0.2724215777135184D0*t150*t151*t504
      t526 = t149*t306
      t528 = 0.6356503479982097D0*t526*t152
      t532 = 0.3178251739991049D0*t81*t306*t172*t111
      t533 = t81*t306
      t535 = 0.3178251739991049D0*t533*t196
      t536 = t327*t111
      t539 = 0.2724215777135184D0*t150*t536*t146
      t540 = t182*sigma
      t541 = t540*t80
      t542 = t89**2
      t543 = t542*t163
      t546 = 0.2724215777135184D0*t541*t317*t543
      t547 = t155*t86
      t548 = t89*t146
      t551 = 0.2724215777135184D0*t547*t317*t548
      t552 = -t427+t433-t437+t440+t457-t461+t465+t468+t471+t473+t476
     #+t478-t480-t483
      t555 = t311*t103
      t557 = 0.9649190532874446D2*t555*t146
      t558 = t157*t103
      t560 = 0.9649190532874446D2*t558*t298
      t561 = t85*t190
      t563 = 0.3859676213149779D3*t561*t485
      t565 = 0.9649190532874446D2*t160*t504
      t566 = -0.3216396844291482D2*t552*t86+t557+t560-t563+t565
      t570 = 0.1362107888567592D0*t156*t84*t566*t89
      t571 = t163*t89
      t574 = 0.1362107888567592D0*t156*t317*t571
      t575 = t84*t298
      t578 = 0.2724215777135184D0*t547*t575*t571
      t579 = t92*t103
      t582 = 0.8172647331405553D0*t579*t575*t146
      t585 = 0.2724215777135184D0*t92*t168*t504
      t589 = 0.3178251739991049D0*t156*t306*t163*t89
      t590 = t86*t306
      t593 = 0.6356503479982097D0*t92*t590*t146
      t599 = t327*t179
      t602 = 0.1362107888567592D0*t177*t599*t195
      t606 = 0.2724215777135184D0*t150*t180*t344*t146
      t607 = t172*t179
      t610 = 0.1362107888567592D0*t177*t607*t344
      t613 = t96/t178/t110
      t617 = 0.2724215777135184D0*t177*t613*t344*t195
      t618 = t98**2
      t621 = 1/t618*t100*t103
      t624 = 0.1113202740058839D0*t621*t332*t543
      t625 = t183*t190
      t628 = 0.1484270320078451D0*t625*t332*t548
      t635 = 0.3710675800196129D-1*t184*t332*t571
      t636 = t106*t298
      t639 = 0.1484270320078451D0*t625*t636*t571
      t641 = 1/t102/t78
      t642 = t101*t641
      t645 = 0.3710675800196129D0*t642*t636*t146
      t648 = 0.7421351600392257D-1*t101*t191*t504
      t652 = 0.1731648706758193D0*t184*t340*t163*t89
      t653 = t190*t340
      t656 = 0.3463297413516387D0*t101*t653*t146
      t657 = t546+t551-t570-t574+t578+t582-t585+t589+t593+t624+t628
     #-0.3710675800196129D-1*t184*t106*t566*t89-t635+t639+t645-t648
     #+t652+t656
      t661 = t514-t518+t522-t525+t528-t532+t535-t539
     #+0.1362107888567592D0*t81*t84*(t546+t551-t570-t574+t578+t582
     #-t585+t589+t593)*t111-t602+t606-t610+t617-0.1362107888567592D0
     #*t177*t180*t657
      t665 = t115**2
      t666 = 1/t665
      t669 = 0.310906908696549D-1*t349*t666*t199
      t670 = -t427+t433-t437+t440+t457-t461+t465+t468+t471+t473+t476
     #+t478-t480-t483+t487+t491+t506+t510+0.310906908696549D-1*t79
     #*t661*t201-t669
      t671 = rho*t670
      t677 = 0.4444444444444444D0*t441*t207+0.4444444444444444D0*t448
     #*t207
      t680 = 0.37995525D-1*t33*t677*t52
      t683 = t33*t124*t128*t49
      t684 = 0.3039642D0*t683
      t687 = t33*t44*t45*t49
      t688 = 0.4559463D0*t687
      t691 = 0.1923661050931536D1*t69*t677*t50
      t692 = t133*t136
      t693 = 0.1538928840745229D2*t692
      t695 = t70*t45*t49
      t696 = 0.2308393261117844D2*t695
      t697 = t146**2
      t706 = -0.1111111111111111D0*t492*t207-0.1111111111111111D0*t498
     #*t207
      t708 = 0.9327207260896469D-1*t139*t706
      t721 = 0.2724215777135184D0*t150*t151*t706
      t722 = t163**2
      t723 = t84*t722
      t726 = 0.2724215777135184D0*t541*t723*t542
      t729 = 0.5448431554270369D0*t547*t164*t548
      t738 = 0.9649190532874446D2*t160*t706
      t739 = -0.3216396844291482D2*(t680-t684-t688+t691+t693+t696)*t86
     #+0.1929838106574889D3*t558*t146-0.3859676213149779D3*t561*t697
     #+t738
      t743 = 0.1362107888567592D0*t156*t84*t739*t89
      t746 = 0.1362107888567592D0*t156*t723*t89
      t747 = t103*t84
      t750 = 0.8172647331405553D0*t92*t747*t697
      t753 = 0.2724215777135184D0*t92*t168*t706
      t762 = t195**2
      t766 = t106*t722
      t780 = t641*t106
      t786 = 0.7421351600392257D-1*t101*t191*t706
      t787 = t726+t729-t743-t746+t750-t753+0.1113202740058839D0*t621
     #*t766*t542+0.2968540640156903D0*t625*t185*t548
     #-0.3710675800196129D-1*t184*t106*t739*t89-0.3710675800196129D-1
     #*t184*t766*t89+0.3710675800196129D0*t101*t780*t697-t786
      t795 = t199**2
      t799 = t680-t684-t688+t691+t693+t696+0.1865441452179294D0*t484
     #*t697+0.1865441452179294D0*t488*t508+t708+0.310906908696549D-1
     #*t79*(0.8172647331405553D0*t511*t151*t697-0.5448431554270369D0
     #*t150*t515*t146+0.5448431554270369D0*t150*t180*t146*t195-t721
     #+0.1362107888567592D0*t81*t84*(t726+t729-t743-t746+t750-t753)
     #*t111-0.2724215777135184D0*t177*t607*t195+0.2724215777135184D0
     #*t177*t613*t762-0.1362107888567592D0*t177*t180*t787)*t201
     #-0.310906908696549D-1*t79*t795*t666
      t801 = 0.45D1*t439
      t802 = -t427-t437+t457+t465+t433+t801-t461+t468+t471+t476-t480
     #+t473+t478-t483
      t805 = -0.3216396844291482D2*t802*t86+t560+t557-t563+t565
      t809 = 0.1362107888567592D0*t156*t84*t805*t89
      t819 = t546+t578+t589-t809-t574+t551+t582+t593-t585+t624+t639
     #+t652-0.3710675800196129D-1*t184*t106*t805*t89-t635+t628+t645
     #+t656-t648
      t823 = t514+t528-t539+t606-t525-t518-t532+0.1362107888567592D0
     #*t81*t84*(t546+t578+t589-t809-t574+t551+t582+t593-t585)*t111
     #-t610+t522+t535-t602+t617-0.1362107888567592D0*t177*t180*t819
      t827 = -t427-t437+t457+t465+t433+t801-t461+t468+t471+t476-t480
     #+t473+t478-t483+t487+t510+t506+t491+0.310906908696549D-1*t79
     #*t823*t201-t669
      t828 = rho*t827
      t829 = 0.5495546528376876D-2*t209
      t831 = 0.2D1*t230
      t836 = 0.1538928840745229D2*t290
      t837 = 0.1865441452179294D0*t299
      t838 = 0.3847322101863073D1*t287
      t839 = 0.7599105D-1*t258
      t840 = 0.174814857510834D-2*t234
      t841 = 0.225D1*t248
      t842 = 0.3039642D0*t264
      t843 = 0.3847322101863073D1*t284
      t844 = 0.6218138173930979D-1*t350
      t848 = 1/t13/t4*t49
      t849 = t848*t19
      t850 = 0.1831848842792292D-2*t849
      t851 = t348**2
      t858 = t227**2
      t860 = t7/t211/t15*t858*t228
      t861 = 0.2D1*t860
      t864 = 1/t216/t4*t49
      t866 = t217*t443
      t869 = t206*t443
      t873 = 1/t11/t4*t49
      t875 = t221*t443
      t879 = 1/t5/t4*t49
      t881 = t224*t443
      t885 = t213*(-0.8309097827459833D0*t864+0.199418347859036D1*t866
     #-0.4945709824779306D0*t848+0.1483712947433792D1*t869
     #-0.2001071587498409D0*t873+0.8004286349993634D0*t875
     #-0.4215565168327908D-1*t879+0.2529339100996745D0*t881)*t228
      t886 = 0.1D1*t885
      t887 = t211**2
      t890 = t18**2
      t893 = t7/t887*t858/t890
      t894 = 0.1608197949869254D2*t893
      t898 = 0.225D1*t244*t245*t256*t52
      t900 = 0.174814857510834D-2*t869*t233
      t901 = t236**2
      t904 = t243**2
      t906 = t31**2
      t911 = 0.3330984372501762D2*t23/t901*t904/t906*t44*t52
      t914 = 0.9D1*t244*t246*t289
      t917 = t208*t212*t227*t228
      t918 = 0.8837926660346786D-1*t917
      t919 = t869*t19
      t920 = 0.5495546528376876D-2*t919
      t923 = 0.7599105D0*t33*t260*t429
      t927 = 0.3039642D0*t33*t256*t46*t262
      t939 = t275**2
      t955 = t268**2
      t958 = t65**2
      t969 = 0.8806932620892844D-3*t848*t66-0.2642079786267853D-2*t869
     #*t66-0.8497974591333914D-1*t208*t269*t275*t276-0.2D1*t57/t268
     #/t62*t939*t276+0.1D1*t270*(-0.1544496508763151D1*t864
     #+0.3706791621031562D1*t866-0.854388052766047D0*t848
     #+0.2563164158298141D1*t869-0.4111834438919023D0*t873
     #+0.1644733775567609D1*t875-0.5346380647307093D-1*t879
     #+0.3207828388384256D0*t881)*t276+0.3216395899738507D2*t57/t955
     #*t939/t958-0.1831848842792292D-2*t849+0.5495546528376876D-2*t919
     #+0.8837926660346786D-1*t917+0.2D1*t860-0.1D1*t885
     #-0.1608197949869254D2*t893
      t972 = 0.1923661050931536D1*t969*t44*t50
      t983 = 0.4444444444444444D0*t441*t45*t49+0.2666666666666667D1
     #*t250*t443+0.4444444444444444D0*t448*t45*t49
     #-0.2666666666666667D1*t253*t443
      t986 = 0.37995525D-1*t33*t983*t52
      t987 = t850-0.310906908696549D-1*t79*t851*t666-t861+t886+t894
     #-t898+t900-t911-t914-t918-t920-t923+t927+t972+t986
      t989 = 0.1538928840745229D2*t286*t289
      t992 = 0.1923661050931536D1*t69*t983*t50
      t994 = 0.58271619170278D-3*t848*t233
      t1006 = 0.1125D1*t238*(-0.1132974264373283D1*t864
     #+0.271913823449588D1*t866-0.4994648585728036D0*t848
     #+0.1498394575718411D1*t869-0.1075243117819161D0*t873
     #+0.4300972471276643D0*t875-0.4247805766949639D-1*t879
     #+0.2548683460169784D0*t881)*t247
      t1008 = 1/t48/t304
      t1012 = 0.699259430043336D-2*t206*t1008*t232*t46
      t1017 = 0.5176049408441869D-1*t208*t237*t243*t245*t53
      t1023 = 0.225D1*t23/t236/t28*t904*t247
      t1024 = t298**2
      t1029 = 0.3847322101863073D1*t282*t256*t50
      t1031 = 0.1538928840745229D2*t283*t289
      t1034 = 0.3847322101863073D2*t70*t46*t429
      t1038 = 0.174814857510834D-2*t208*t32*t256*t52
      t1054 = 1/t82/t48
      t1073 = -0.1111111111111111D0*t492*t45*t49+0.6666666666666667D0
     #*t292*t443-0.1111111111111111D0*t498*t45*t49
     #-0.6666666666666667D0*t295*t443
      t1077 = t316**2
      t1078 = t84*t1077
      t1081 = 0.2724215777135184D0*t541*t1078*t542
      t1082 = t89*t298
      t1085 = 0.5448431554270369D0*t547*t317*t1082
      t1089 = 0.6356503479982097D0*t156*t306*t316*t89
      t1090 = t850-t861+t886+t894-t898+t900-t911-t914-t918-t920-t923
     #+t927
      t1091 = t972+t986-t989+t992-t994-t1006-t1012+t1017+t1023+t1029
     #-t1031+t1034-t1038
      t1101 = -0.3216396844291482D2*(t1090+t1091)*t86
     #+0.1929838106574889D3*t555*t298-0.3859676213149779D3*t561*t1024
     #+0.9649190532874446D2*t160*t1073
      t1105 = 0.1362107888567592D0*t156*t84*t1101*t89
      t1108 = 0.1362107888567592D0*t156*t1078*t89
      t1111 = 0.8172647331405553D0*t92*t747*t1024
      t1114 = 0.1271300695996419D1*t92*t590*t298
      t1117 = 0.2724215777135184D0*t92*t168*t1073
      t1120 = 0.1059417246663683D1*t92*t80*t1054
      t1129 = t344**2
      t1150 = t106*t1077
      t1165 = t1111+t1114-t1117+t1120+t1089+t1081+t1085-t1108-t1105
     #+0.3710675800196129D0*t101*t780*t1024+0.6926594827032773D0*t101
     #*t653*t298+0.3463297413516387D0*t184*t340*t316*t89
     #-0.7421351600392257D-1*t101*t191*t1073-0.3710675800196129D-1
     #*t184*t106*t1101*t89+0.1113202740058839D0*t621*t1150*t542
     #+0.4906338002481548D0*t101*t103/t104/t428+0.2968540640156903D0
     #*t625*t332*t1082-0.3710675800196129D-1*t184*t1150*t89
      t1169 = 0.8172647331405553D0*t511*t151*t1024
     #+0.1271300695996419D1*t526*t301-0.5448431554270369D0*t150*t536
     #*t298+0.5448431554270369D0*t150*t180*t298*t344
     #+0.6356503479982097D0*t533*t345+0.1059417246663683D1*t81*t1054
     #*t96*t111-0.6356503479982097D0*t81*t306*t327*t111
     #-0.2724215777135184D0*t150*t151*t1073+0.1362107888567592D0*t81
     #*t84*(t1081+t1085+t1089-t1105-t1108+t1111+t1114-t1117+t1120)
     #*t111-0.2724215777135184D0*t177*t599*t344+0.2724215777135184D0
     #*t177*t613*t1129-0.1362107888567592D0*t177*t180*t1165
      t1177 = -t989+t992-t994-t1006-t1012+t1017+t1023
     #+0.1865441452179294D0*t484*t1024+t1029-t1031+t1034-t1038
     #+0.310906908696549D-1*t79*t1169*t201+0.1865441452179294D0*t507
     #*t489+0.9327207260896469D-1*t139*t1073
      t1179 = rho*(t987+t1177)
      t1180 = -t836+t837+t838+t839-t840-t841+t842+t843+t844
     #+0.3847322101863073D1*t134+t1179
      v2rhoa2(i) = t671-0.3039642D0*t131+rho*t799+t828+t829
     #+0.6218138173930979D-1*t202+t831+0.1538928840745229D2*t137
     #+0.1865441452179294D0*t147+0.7599105D-1*t126+t1180
      t1184 = t33*t354*t128*t49
      t1185 = 0.3039642D0*t1184
      t1186 = t359*t136
      t1187 = 0.1538928840745229D2*t1186
      t1188 = t363**2
      t1191 = t78*t398
      t1192 = t201*t363
      t1198 = t382*t111
      t1206 = t374**2
      t1207 = t84*t1206
      t1210 = 0.2724215777135184D0*t541*t1207*t542
      t1211 = t89*t363
      t1214 = 0.5448431554270369D0*t547*t375*t1211
      t1218 = t369*t103
      t1223 = -0.3216396844291482D2*(t680+t1185-t688+t691-t1187+t696)
     #*t86+0.1929838106574889D3*t1218*t363-0.3859676213149779D3*t561
     #*t1188+t738
      t1227 = 0.1362107888567592D0*t156*t84*t1223*t89
      t1230 = 0.1362107888567592D0*t156*t1207*t89
      t1233 = 0.8172647331405553D0*t92*t747*t1188
      t1239 = t382*t179
      t1243 = t394**2
      t1247 = t106*t1206
      t1264 = t1210+t1214-t1227-t1230+t1233-t753+0.1113202740058839D0
     #*t621*t1247*t542+0.2968540640156903D0*t625*t387*t1211
     #-0.3710675800196129D-1*t184*t106*t1223*t89-0.3710675800196129D-1
     #*t184*t1247*t89+0.3710675800196129D0*t101*t780*t1188-t786
      t1272 = t398**2
      t1276 = t680+t1185-t688+t691-t1187+t696+0.1865441452179294D0
     #*t484*t1188+0.1865441452179294D0*t1191*t1192+t708
     #+0.310906908696549D-1*t79*(0.8172647331405553D0*t511*t151*t1188
     #-0.5448431554270369D0*t150*t1198*t363+0.5448431554270369D0*t150
     #*t180*t363*t394-t721+0.1362107888567592D0*t81*t84*(t1210+t1214
     #-t1227-t1230+t1233-t753)*t111-0.2724215777135184D0*t177*t1239
     #*t394+0.2724215777135184D0*t177*t613*t1243-0.1362107888567592D0
     #*t177*t180*t1264)*t201-0.310906908696549D-1*t79*t1272*t666
      t1285 = 0.87407428755417D-3*t208*t32*t354*t52
      t1286 = 0.349629715021668D-2*t432
      t1290 = 0.1125D1*t244*t245*t354*t52
      t1291 = 0.45D1*t439
      t1292 = -t454
      t1295 = 0.37995525D-1*t33*t1292*t52
      t1296 = 0.1519821D0*t460
      t1300 = 0.1519821D0*t33*t354*t46*t262
      t1301 = 0.6079284D0*t467
      t1304 = 0.1923661050931536D1*t282*t354*t50
      t1305 = 0.7694644203726145D1*t472
      t1308 = 0.1923661050931536D1*t69*t1292*t50
      t1309 = 0.7694644203726145D1*t477
      t1311 = 0.7694644203726145D1*t359*t289
      t1312 = 0.3077857681490458D2*t482
      t1313 = t298*t363
      t1318 = -t504
      t1347 = t542*t374
      t1350 = 0.2724215777135184D0*t541*t317*t1347
      t1353 = 0.2724215777135184D0*t547*t317*t1211
      t1354 = -t1285-t1286-t1290-t1291+t1295+t1296+t1300-t1301+t1304
     #-t1305+t1308-t1309-t1311+t1312
      t1365 = -0.3216396844291482D2*t1354*t86+0.9649190532874446D2
     #*t555*t363+0.9649190532874446D2*t1218*t298-0.3859676213149779D3
     #*t561*t1313+0.9649190532874446D2*t160*t1318
      t1369 = 0.1362107888567592D0*t156*t84*t1365*t89
      t1370 = t374*t89
      t1373 = 0.1362107888567592D0*t156*t317*t1370
      t1376 = 0.2724215777135184D0*t547*t575*t1370
      t1379 = 0.8172647331405553D0*t579*t575*t363
      t1382 = 0.2724215777135184D0*t92*t168*t1318
      t1386 = 0.3178251739991049D0*t156*t306*t374*t89
      t1389 = 0.6356503479982097D0*t92*t590*t363
      t1438 = t1350+t1353-t1369-t1373+t1376+t1379-t1382+t1386+t1389
     #+0.1113202740058839D0*t621*t332*t1347+0.1484270320078451D0*t625
     #*t332*t1211-0.3710675800196129D-1*t184*t106*t1365*t89
     #-0.3710675800196129D-1*t184*t332*t1370+0.1484270320078451D0*t625
     #*t636*t1370+0.3710675800196129D0*t642*t636*t363
     #-0.7421351600392257D-1*t101*t191*t1318+0.1731648706758193D0*t184
     #*t340*t374*t89+0.3463297413516387D0*t101*t653*t363
      t1442 = 0.8172647331405553D0*t511*t151*t1313
     #-0.2724215777135184D0*t150*t1198*t298+0.2724215777135184D0*t150
     #*t180*t298*t394-0.2724215777135184D0*t150*t151*t1318
     #+0.6356503479982097D0*t526*t366-0.3178251739991049D0*t81*t306
     #*t382*t111+0.3178251739991049D0*t533*t395-0.2724215777135184D0
     #*t150*t536*t363+0.1362107888567592D0*t81*t84*(t1350+t1353-t1369
     #-t1373+t1376+t1379-t1382+t1386+t1389)*t111-0.1362107888567592D0
     #*t177*t599*t394+0.2724215777135184D0*t150*t180*t344*t363
     #-0.1362107888567592D0*t177*t1239*t344+0.2724215777135184D0*t177
     #*t613*t344*t394-0.1362107888567592D0*t177*t180*t1438
      t1446 = t666*t398
      t1449 = -t1285-t1286-t1290-t1291+t1295+t1296+t1300-t1301+t1304
     #-t1305+t1308-t1309-t1311+t1312+0.1865441452179294D0*t484*t1313
     #+0.9327207260896469D-1*t1191*t489+0.9327207260896469D-1*t139
     #*t1318+0.9327207260896469D-1*t507*t1192+0.310906908696549D-1*t79
     #*t1442*t201-0.310906908696549D-1*t349*t1446
      t1450 = rho*t1449
      v2rhob2(i) = 0.3039642D0*t131+t829+rho*t1276+t831
     #-0.1538928840745229D2*t137-t836+t837+t838+t839-t840-t841+t842
     #+t843+t844+0.3847322101863073D1*t360+0.7599105D-1*t356+2*t1450
     #+t1179+0.6218138173930979D-1*t400+0.1865441452179294D0*t364
      t1455 = -t677
      t1458 = 0.37995525D-1*t33*t1455*t52
      t1459 = 0.1519821D0*t683
      t1460 = 0.1519821D0*t1184
      t1461 = 0.4559463D0*t687
      t1464 = 0.1923661050931536D1*t69*t1455*t50
      t1465 = 0.7694644203726145D1*t692
      t1466 = 0.7694644203726145D1*t1186
      t1467 = 0.2308393261117844D2*t695
      t1468 = t146*t363
      t1473 = -t706
      t1496 = 0.2724215777135184D0*t541*t164*t1347
      t1499 = 0.2724215777135184D0*t547*t164*t1211
      t1511 = -0.3216396844291482D2*(t1458+t1459-t1460+t1461+t1464
     #-t1465+t1466-t1467)*t86+0.9649190532874446D2*t558*t363
     #+0.9649190532874446D2*t1218*t146-0.3859676213149779D3*t561*t1468
     #+0.9649190532874446D2*t160*t1473
      t1515 = 0.1362107888567592D0*t156*t84*t1511*t89
      t1518 = 0.1362107888567592D0*t156*t164*t1370
      t1519 = t84*t146
      t1522 = 0.2724215777135184D0*t547*t1519*t1370
      t1525 = 0.8172647331405553D0*t579*t1519*t363
      t1528 = 0.2724215777135184D0*t92*t168*t1473
      t1561 = t106*t146
      t1571 = t1496+t1499-t1515-t1518+t1522+t1525-t1528
     #+0.1113202740058839D0*t621*t185*t1347+0.1484270320078451D0*t625
     #*t185*t1211-0.3710675800196129D-1*t184*t106*t1511*t89
     #-0.3710675800196129D-1*t184*t185*t1370+0.1484270320078451D0*t625
     #*t1561*t1370+0.3710675800196129D0*t642*t1561*t363
     #-0.7421351600392257D-1*t101*t191*t1473
      t1575 = 0.8172647331405553D0*t511*t151*t1468
     #-0.2724215777135184D0*t150*t1198*t146+0.2724215777135184D0*t150
     #*t180*t146*t394-0.2724215777135184D0*t150*t151*t1473
     #-0.2724215777135184D0*t150*t515*t363+0.1362107888567592D0*t81
     #*t84*(t1496+t1499-t1515-t1518+t1522+t1525-t1528)*t111
     #-0.1362107888567592D0*t177*t607*t394+0.2724215777135184D0*t150
     #*t180*t195*t363-0.1362107888567592D0*t177*t1239*t195
     #+0.2724215777135184D0*t177*t613*t195*t394-0.1362107888567592D0
     #*t177*t180*t1571
      t1581 = t1458+t1459-t1460+t1461+t1464-t1465+t1466-t1467
     #+0.1865441452179294D0*t484*t1468+0.9327207260896469D-1*t1191
     #*t508+0.9327207260896469D-1*t139*t1473+0.9327207260896469D-1
     #*t488*t1192+0.310906908696549D-1*t79*t1575*t201
     #-0.310906908696549D-1*t200*t1446
      t1584 = t829+0.5D0*t671-t840+t148-t841+rho*t1581+t842+t1179+t831
     #+t839+t843+0.5D0*t828
      t1586 = -t836+t838+t203+t844+t357+t361+t365+t401+0.1D1*t1450
     #+t127+t135+t837
      v2rhoab(i) = t1584+t1586
      t1587 = t78*t421
      t1593 = sigma*t190*t106
      t1594 = t91*t111
      t1604 = t99*t80
      t1606 = 0.1362107888567592D0*t1604*t165
      t1607 = t91*t86
      t1609 = 0.2724215777135184D0*t1607*t1519
      t1620 = t407*t106
      t1621 = t91*t179
      t1629 = t540*t103
      t1642 = t666*t421
      t1646 = rho*(0.9327207260896469D-1*t1587*t508
     #+0.310906908696549D-1*t79*(-0.2724215777135184D0*t168*t152
     #-0.3710675800196129D-1*t1593*t1594*t146+0.2724215777135184D0
     #*t150*t180*t146*t417+0.1362107888567592D0*t93*t515
     #+0.1362107888567592D0*t81*t84*(-t1606-t1609)*t111
     #-0.1362107888567592D0*t177*t607*t417-0.1362107888567592D0*t93
     #*t196-0.1855337900098064D-1*t1620*t1621*t195
     #+0.2724215777135184D0*t177*t613*t195*t417-0.1362107888567592D0
     #*t177*t180*(-t1606-t1609-0.7421351600392257D-1*t1629*t186
     #-0.1484270320078451D0*t155*t192))*t201-0.310906908696549D-1*t200
     #*t1642)
      t1648 = t79*t421*t201
      t1649 = 0.310906908696549D-1*t1648
      t1672 = 0.1362107888567592D0*t1604*t318
      t1674 = 0.2724215777135184D0*t1607*t575
      t1676 = 0.3178251739991049D0*t412*t306
      t1704 = -0.2724215777135184D0*t168*t301-0.3710675800196129D-1
     #*t1593*t1594*t298+0.2724215777135184D0*t150*t180*t298*t417
     #-0.3178251739991049D0*t324*t151-0.4329121766895483D-1*t407*t340
     #*t91*t111+0.3178251739991049D0*t533*t418+0.1362107888567592D0
     #*t93*t536+0.1362107888567592D0*t81*t84*(-t1672-t1674-t1676)*t111
     #-0.1362107888567592D0*t177*t599*t417-0.1362107888567592D0*t93
     #*t345-0.1855337900098064D-1*t1620*t1621*t344
     #+0.2724215777135184D0*t177*t613*t344*t417-0.1362107888567592D0
     #*t177*t180*(-t1672-t1674-t1676-0.7421351600392257D-1*t1629*t333
     #-0.1484270320078451D0*t155*t336-0.1731648706758193D0*t155*t341)
      t1711 = rho*(0.9327207260896469D-1*t1587*t489
     #+0.310906908696549D-1*t79*t1704*t201-0.310906908696549D-1*t349
     #*t1642)
      v2rhoasigmaaa(i) = t1646+t1649+t1711
      t1713 = 0.6218138173930979D-1*t1648
      t1714 = 2.D0*t1711
      v2rhoasigmaab(i) = 2.D0*t1646+t1713+t1714
      v2rhoasigmabb(i) = v2rhoasigmaaa(i)
      t1729 = 0.1362107888567592D0*t1604*t376
      t1732 = 0.2724215777135184D0*t1607*t84*t363
      t1765 = rho*(0.9327207260896469D-1*t1587*t1192
     #+0.310906908696549D-1*t79*(-0.2724215777135184D0*t168*t366
     #-0.3710675800196129D-1*t1593*t1594*t363+0.2724215777135184D0
     #*t150*t180*t363*t417+0.1362107888567592D0*t93*t1198
     #+0.1362107888567592D0*t81*t84*(-t1729-t1732)*t111
     #-0.1362107888567592D0*t177*t1239*t417-0.1362107888567592D0*t93
     #*t395-0.1855337900098064D-1*t1620*t1621*t394
     #+0.2724215777135184D0*t177*t613*t394*t417-0.1362107888567592D0
     #*t177*t180*(-t1729-t1732-0.7421351600392257D-1*t1629*t388
     #-0.1484270320078451D0*t155*t391))*t201-0.310906908696549D-1*t399
     #*t1642)
      v2rhobsigmaaa(i) = t1765+t1649+t1711
      v2rhobsigmaab(i) = 2.D0*t1765+t1713+t1714
      v2rhobsigmabb(i) = v2rhobsigmaaa(i)
      t1774 = t417**2
      t1785 = t404*(0.3710675800196129D-1*t107*t1594
     #-0.2724215777135184D0*t93*t418-0.3710675800196129D-1*t1620*t1621
     #*t417+0.2724215777135184D0*t177*t613*t1774-0.5054340779364009D-2
     #*sigma*t641*t1008*t180*t99)*t201
      t1787 = t421**2
      t1789 = t404*t1787*t666
      v2sigmaaa2(i) = 0.310906908696549D-1*t1785-0.310906908696549D-1
     #*t1789
      v2sigmaaaab(i) = 0.6218138173930979D-1*t1785
     #-0.6218138173930979D-1*t1789
      v2sigmaaabb(i) = v2sigmaaa2(i)
      v2sigmaab2(i) = 0.1243627634786196D0*t1785-0.1243627634786196D0
     #*t1789
      v2sigmaabbb(i) = v2sigmaaaab(i)
      v2sigmabb2(i) = v2sigmaaabb(i)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_c_pbe
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     J.P. Perdew, K. Burke, and M. Ernzerhof
c     Generalized gradient approximation made simple
c     Phys. Rev. Lett. 77 (1996) 3865-3868
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = 1/rho
      t3 = t2**(1.D0/3.D0)
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t17 = dlog(1.D0+0.1608197949869254D2/(0.598255043577108D1*t6
     #+0.2225569421150687D1*t3+0.8004286349993634D0*t9
     #+0.1897004325747559D0*t11))
      t18 = (1.D0+0.1325688999052018D0*t3)*t17
      t20 = rho**2
      t21 = rho**(1.D0/3.D0)
      t23 = 1/t21/t20
      t26 = dexp(0.2000000587336264D1*t18)
      t27 = t26-1.D0
      t31 = 0.1362107888567592D0/t27*sigma*t23
      t33 = t27**2
      t35 = sigma**2
      t37 = t20**2
      t38 = t21**2
      t49 = dlog(1.D0+0.1362107888567592D0*sigma*t23*(1.D0+t31)/(1.D0
     #+t31+0.1855337900098064D-1/t33*t35/t38/t37))
      zk(i) = rho*(-0.621814D-1*t18+0.310906908696549D-1*t49)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = 1/rho
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1325688999052018D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.598255043577108D1*t6+0.2225569421150687D1*t3
     #+0.8004286349993634D0*t9+0.1897004325747559D0*t11
      t16 = 1.D0+0.1608197949869254D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.621814D-1*t18
      t20 = rho**2
      t21 = rho**(1.D0/3.D0)
      t23 = 1/t21/t20
      t24 = sigma*t23
      t26 = dexp(0.2000000587336264D1*t18)
      t27 = t26-1.D0
      t28 = 1/t27
      t29 = t28*sigma
      t31 = 0.1362107888567592D0*t29*t23
      t32 = 1.D0+t31
      t33 = t27**2
      t34 = 1/t33
      t35 = sigma**2
      t36 = t34*t35
      t37 = t20**2
      t38 = t21**2
      t40 = 1/t38/t37
      t43 = 1.D0+t31+0.1855337900098064D-1*t36*t40
      t44 = 1/t43
      t45 = t32*t44
      t48 = 1.D0+0.1362107888567592D0*t24*t45
      t49 = dlog(t48)
      t50 = 0.310906908696549D-1*t49
      zk(i) = rho*(-t19+t50)
      t53 = 1/t20
      t54 = 1/t11*t53
      t56 = 0.2747773264188438D-2*t54*t17
      t57 = t13**2
      t60 = t6**2
      t61 = t60**2
      t77 = 0.1D1*t5/t57*(-0.99709173929518D0/t61/t6*t53
     #-0.7418564737168958D0*t54-0.4002143174996817D0/t9*t53
     #-0.1264669550498372D0/t3*t53)/t16
      t80 = 1/t21/t20/rho
      t84 = t34*sigma
      t85 = t56+t77
      t89 = 0.4381079514373337D1*t84*t23*t85*t26
      t91 = 0.3178251739991049D0*t29*t80
      t96 = t43**2
      t98 = t32/t96
      t116 = 1/t48
      vrhoa(i) = -t19+t50+rho*(t56+t77+0.310906908696549D-1*(
     #-0.3178251739991049D0*sigma*t80*t45+0.1362107888567592D0*t24*
     #(t89-t91)*t44-0.1362107888567592D0*t24*t98*(t89-t91
     #+0.119350059339396D1/t33/t27*t35*t40*t85*t26
     #-0.8658243533790967D-1*t36/t38/t37/rho))*t116)
      vsigmaaa(i) = 0.1243627634786196D0*rho*(0.1362107888567592D0*t23
     #*t32*t44+0.1855337900098064D-1*sigma*t40*t28*t44
     #-0.1362107888567592D0*t24*t98*(0.1362107888567592D0*t28*t23
     #+0.3710675800196129D-1*t84*t40))*t116
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = 1/rho
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1325688999052018D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.598255043577108D1*t6+0.2225569421150687D1*t3
     #+0.8004286349993634D0*t9+0.1897004325747559D0*t11
      t16 = 1.D0+0.1608197949869254D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.621814D-1*t18
      t20 = rho**2
      t21 = rho**(1.D0/3.D0)
      t23 = 1/t21/t20
      t24 = sigma*t23
      t26 = dexp(0.2000000587336264D1*t18)
      t27 = t26-1.D0
      t28 = 1/t27
      t29 = t28*sigma
      t31 = 0.1362107888567592D0*t29*t23
      t32 = 1.D0+t31
      t33 = t27**2
      t34 = 1/t33
      t35 = sigma**2
      t36 = t34*t35
      t37 = t20**2
      t38 = t21**2
      t40 = 1/t38/t37
      t43 = 1.D0+t31+0.1855337900098064D-1*t36*t40
      t44 = 1/t43
      t45 = t32*t44
      t48 = 1.D0+0.1362107888567592D0*t24*t45
      t49 = dlog(t48)
      t50 = 0.310906908696549D-1*t49
      zk(i) = rho*(-t19+t50)
      t52 = 1/t11
      t53 = 1/t20
      t54 = t52*t53
      t55 = t54*t17
      t56 = 0.2747773264188438D-2*t55
      t57 = t13**2
      t58 = 1/t57
      t59 = t5*t58
      t60 = t6**2
      t61 = t60**2
      t62 = t61*t6
      t63 = 1/t62
      t67 = 1/t9
      t70 = 1/t3
      t73 = -0.99709173929518D0*t63*t53-0.7418564737168958D0*t54
     #-0.4002143174996817D0*t67*t53-0.1264669550498372D0*t70*t53
      t74 = 1/t16
      t76 = t59*t73*t74
      t77 = 0.1D1*t76
      t78 = t20*rho
      t80 = 1/t21/t78
      t81 = sigma*t80
      t84 = t34*sigma
      t85 = t56+t77
      t89 = 0.4381079514373337D1*t84*t23*t85*t26
      t91 = 0.3178251739991049D0*t29*t80
      t92 = t89-t91
      t93 = t92*t44
      t96 = t43**2
      t97 = 1/t96
      t98 = t32*t97
      t100 = 1/t33/t27
      t101 = t100*t35
      t103 = t40*t85*t26
      t108 = 1/t38/t37/rho
      t111 = t89-t91+0.119350059339396D1*t101*t103
     #-0.8658243533790967D-1*t36*t108
      t112 = t98*t111
      t115 = -0.3178251739991049D0*t81*t45+0.1362107888567592D0*t24
     #*t93-0.1362107888567592D0*t24*t112
      t116 = 1/t48
      t117 = t115*t116
      vrhoa(i) = -t19+t50+rho*(t56+t77+0.310906908696549D-1*t117)
      t121 = t23*t32
      t124 = sigma*t40
      t125 = t28*t44
      t132 = 0.1362107888567592D0*t28*t23+0.3710675800196129D-1*t84*t40
      t133 = t98*t132
      t136 = 0.1362107888567592D0*t121*t44+0.1855337900098064D-1*t124
     #*t125-0.1362107888567592D0*t24*t133
      vsigmaaa(i) = 0.1243627634786196D0*rho*t136*t116
      t151 = dlog(1.D0+0.2960874997779344D2/(0.8157414703487641D1*t6
     #+0.2247591863577616D1*t3+0.4300972471276643D0*t9
     #+0.1911512595127338D0*t11))
      t153 = (1.D0+0.6901399211255825D-1*t3)*t151*t53
      t155 = t49*t53
      t158 = 1/t21/t37
      t160 = sigma*t158*t45
      t165 = -0.1086299437397317D1*t153+0.1333333724890842D1*t18*t53
      t169 = 0.1362107888567592D0*t84*t23*t165*t26
      t170 = t29*t158
      t171 = 0.6053812838078188D-1*t170
      t183 = t36/t38/t37/t20
      t197 = -t165
      t201 = 0.1362107888567592D0*t84*t23*t197*t26
      t202 = 0.6053812838078188D-1*t170
      t223 = 1/t37
      t226 = 1/t78
      t231 = 1/t11/t2*t223
      t233 = t52*t226
      t250 = 0.1D1*t59*(-0.8309097827459833D0/t62/t2*t223
     #+0.199418347859036D1*t63*t226-0.4945709824779306D0*t231
     #+0.1483712947433792D1*t233-0.2001071587498409D0/t9/t2*t223
     #+0.8004286349993634D0*t67*t226-0.4215565168327908D-1/t3/t2*t223
     #+0.2529339100996745D0*t70*t226)*t74
      t251 = t57**2
      t254 = t73**2
      t255 = t16**2
      t259 = 0.1608197949869254D2*t5/t251*t254/t255
      t261 = 0.1831848842792292D-2*t231*t17
      t265 = 0.8837926660346786D-1*t54*t58*t73*t74
      t271 = 0.2D1*t5/t57/t13*t254*t74
      t273 = 0.5495546528376876D-2*t233*t17
      t274 = t115**2
      t275 = t48**2
      t276 = 1/t275
      t282 = t92*t97
      t287 = 1/t96/t43
      t288 = t32*t287
      t289 = t111**2
      t293 = t250+t259+t261-t265-t271-t273
      t297 = 0.4381079514373337D1*t84*t23*t293*t26
      t298 = t85**2
      t299 = t23*t298
      t302 = 0.1409129032462046D3*t84*t299*t26
      t311 = t33**2
      t314 = t40*t298
      t315 = t26**2
      t325 = 0.2044503773374224D2*t84*t80*t85*t26
      t326 = t100*sigma
      t329 = 0.2818258064924092D3*t326*t299*t315
      t330 = 0.1059417246663683D1*t170
      s1 = 0.1099109305675375D-1*t55+0.4D1*t76+rho*(0.337738D-1*t153
     #-0.207271272464366D-1*t155+0.310906908696549D-1*
     #(0.6053812838078188D-1*t160+0.1362107888567592D0*t24*(-t169+t171
     #)*t44-0.1362107888567592D0*t24*t98*(-t169+t171
     #-0.3710675800196129D-1*t101*t40*t165*t26+0.1649189244531613D-1
     #*t183))*t116)
      s2 = s1+rho*(-0.337738D-1*t153+0.207271272464366D-1*t155
     #+0.310906908696549D-1*(-0.6053812838078188D-1*t160
     #+0.1362107888567592D0*t24*(-t201-t202)*t44-0.1362107888567592D0
     #*t24*t98*(-t201-t202-0.3710675800196129D-1*t101*t40*t197*t26
     #-0.1649189244531613D-1*t183))*t116)
      v2rhoa2(i) = s2+2.D0*rho*(t250+t259+t261-t265-t271-t273
     #-0.310906908696549D-1*t274*t276+0.310906908696549D-1*
     #(0.1059417246663683D1*t160-0.6356503479982097D0*t81*t93
     #-0.2724215777135184D0*t24*t282*t111+0.2724215777135184D0*t24
     #*t288*t289-0.1362107888567592D0*t24*t98*(t297-t302
     #-0.1113933887167696D2*t101*t108*t85*t26+0.119350059339396D1*t101
     #*t40*t293*t26+0.1151631462675703D3/t311*t35*t314*t315
     #-0.3838771542252344D2*t101*t314*t26-t325+t329+t330
     #+0.4906338002481548D0*t183)+0.6356503479982097D0*t81*t112
     #+0.1362107888567592D0*t24*(t329-t325+t297-t302+t330)*t44)*t116)
     #+0.1243627634786196D0*t117
      t365 = 0.4381079514373337D1*t34*t23*t85*t26
      t367 = 0.3178251739991049D0*t28*t80
      t378 = t28*t97
      v2rhoasigmaaa(i) = 0.1243627634786196D0*t136*t116+4.D0*rho*
     #(0.310906908696549D-1*(-0.3178251739991049D0*t80*t32*t44
     #-0.4329121766895483D-1*sigma*t108*t125+0.3178251739991049D0*t81
     #*t133+0.1362107888567592D0*t23*t92*t44+0.1362107888567592D0*t24*
     #(t365-t367)*t44-0.1362107888567592D0*t24*t282*t132
     #-0.1362107888567592D0*t121*t97*t111-0.1855337900098064D-1*t124
     #*t378*t111+0.2724215777135184D0*t24*t32*t287*t111*t132
     #-0.1362107888567592D0*t24*t98*(t365-t367+0.238700118678792D1
     #*t326*t103-0.1731648706758193D0*t84*t108))*t116
     #-0.310906908696549D-1*t115*t276*t136)
      t413 = t132**2
      t427 = t136**2
      v2sigmaaa2(i) = 0.4974510539144783D0*rho*(0.3710675800196129D-1
     #*t40*t28*t44-0.2724215777135184D0*t121*t97*t132
     #-0.3710675800196129D-1*t124*t378*t132+0.2724215777135184D0*t24
     #*t288*t413-0.5054340779364009D-2*sigma/t37/t78*t98*t34)*t116
     #-0.4974510539144783D0*rho*t427*t276
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:C_PBEsubrend
c:X_PBEsubrstart


c:X_PW91subrstart

c    Generated: Sun Oct 24 15:07:52 BST 2004

      subroutine uks_x_pw91
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     J.P. Perdew, J.A. Chevary, S.H. Vosko, K.A. Jackson,
c     M.R. Pederson, D.J. Singh, C. Fiolhais
c     Atoms, molecules, solids and surfaces:
c     Applications of the generalized gradient approximation
c     for exchange and correlation
c     Phys. Rev. B 46 (1992) 6671--6687
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = dsqrt(sigmabb)
      t6 = t4/t3
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhob**2
      t12 = t2**2
      t14 = 1/t12/t11
      t17 = dexp(-0.1645530784602056D1*sigmabb*t14)
      t25 = sigmabb**2
      t26 = t11**2
      zk(i) = -0.9305257363491D0*t3*(1.D0+t10+0.1645530784602056D-1*
     #(0.2743D0-0.1508D0*t17)*sigmabb*t14)/(1.D0+t10
     #+0.1083108625229223D-5*t25/t2/t26/rhob)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = dsqrt(sigmaaa)
      t6 = t4/t3
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhoa**2
      t12 = t2**2
      t14 = 1/t12/t11
      t17 = dexp(-0.1645530784602056D1*sigmaaa*t14)
      t25 = sigmaaa**2
      t26 = t11**2
      zk(i) = -0.9305257363491D0*t3*(1.D0+t10+0.1645530784602056D-1*
     #(0.2743D0-0.1508D0*t17)*sigmaaa*t14)/(1.D0+t10
     #+0.1083108625229223D-5*t25/t2/t26/rhoa)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = dsqrt(sigmaaa)
      t8 = t6/t5
      t10 = dlog(0.1000005877780776D1*t8+dsqrt(1+0.10000117555961D1*t8
     #**2))
      t12 = 0.2520026100493014D-1*t8*t10
      t13 = rhoa**2
      t14 = t4**2
      t16 = 1/t14/t13
      t19 = dexp(-0.1645530784602056D1*sigmaaa*t16)
      t27 = sigmaaa**2
      t28 = t13**2
      t38 = rhob**(1.D0/3.D0)
      t39 = t38*rhob
      t40 = dsqrt(sigmabb)
      t42 = t40/t39
      t44 = dlog(0.1000005877780776D1*t42+dsqrt(1+0.10000117555961D1
     #*t42**2))
      t46 = 0.2520026100493014D-1*t42*t44
      t47 = rhob**2
      t48 = t38**2
      t50 = 1/t48/t47
      t53 = dexp(-0.1645530784602056D1*sigmabb*t50)
      t61 = sigmabb**2
      t62 = t47**2
      zk(i) = -0.9305257363491D0*t5*(1.D0+t12+0.1645530784602056D-1*
     #(0.2743D0-0.1508D0*t19)*sigmaaa*t16)/(1.D0+t12
     #+0.1083108625229223D-5*t27/t4/t28/rhoa)-0.9305257363491D0*t39*
     #(1.D0+t46+0.1645530784602056D-1*(0.2743D0-0.1508D0*t53)*sigmabb
     #*t50)/(1.D0+t46+0.1083108625229223D-5*t61/t38/t62/rhob)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = dsqrt(sigmabb)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhob**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigmabb*t14
      t17 = dexp(-0.1645530784602056D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigmabb
      t23 = 1.D0+t10+0.1645530784602056D-1*t20*t14
      t24 = t3*t23
      t25 = sigmabb**2
      t26 = t11**2
      t29 = 1/t2/t26/rhob
      t32 = 1.D0+t10+0.1083108625229223D-5*t25*t29
      t33 = 1/t32
      zk(i) = -0.9305257363491D0*t24*t33
      vrhoa(i) = 0.D0
      t43 = 0.3360034800657352D-1*t4/t2/t11*t8
      t46 = 1/t12/t11/rhob
      t50 = dsqrt(1.D0+0.10000117555961D1*t15)
      t51 = 1/t50
      t53 = 0.3360054550205309D-1*sigmabb*t46*t51
      t57 = t25/t2/t26/t11
      t66 = t32**2
      t67 = 1/t66
      vrhob(i) = -0.12407009817988D1*t2*t23*t33-0.9305257363491D0*t3*(
     #-t43-t53-0.1088885204563779D-1*t57*t17-0.4388082092272149D-1*t20
     #*t46)*t33+0.9305257363491D0*t24*t67*(-t43-t53
     #-0.5776579334555855D-5*t57)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t76 = 0.1260013050246507D-1/t4*t5*t8
      t78 = 0.1260020456326991D-1*t14*t51
      vsigmabb(i) = -0.9305257363491D0*t3*(t76+t78
     #+0.408331951711417D-2*t29*t17*sigmabb+0.1645530784602056D-1*t19
     #*t14)*t33+0.9305257363491D0*t24*t67*(t76+t78
     #+0.2166217250458446D-5*sigmabb*t29)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = dsqrt(sigmaaa)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhoa**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigmaaa*t14
      t17 = dexp(-0.1645530784602056D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigmaaa
      t23 = 1.D0+t10+0.1645530784602056D-1*t20*t14
      t24 = t3*t23
      t25 = sigmaaa**2
      t26 = t11**2
      t29 = 1/t2/t26/rhoa
      t32 = 1.D0+t10+0.1083108625229223D-5*t25*t29
      t33 = 1/t32
      zk(i) = -0.9305257363491D0*t24*t33
      t43 = 0.3360034800657352D-1*t4/t2/t11*t8
      t46 = 1/t12/t11/rhoa
      t50 = dsqrt(1.D0+0.10000117555961D1*t15)
      t51 = 1/t50
      t53 = 0.3360054550205309D-1*sigmaaa*t46*t51
      t57 = t25/t2/t26/t11
      t66 = t32**2
      t67 = 1/t66
      vrhoa(i) = -0.12407009817988D1*t2*t23*t33-0.9305257363491D0*t3*(
     #-t43-t53-0.1088885204563779D-1*t57*t17-0.4388082092272149D-1*t20
     #*t46)*t33+0.9305257363491D0*t24*t67*(-t43-t53
     #-0.5776579334555855D-5*t57)
      vrhob(i) = 0.D0
      t76 = 0.1260013050246507D-1/t4*t5*t8
      t78 = 0.1260020456326991D-1*t14*t51
      vsigmaaa(i) = -0.9305257363491D0*t3*(t76+t78
     #+0.408331951711417D-2*t29*t17*sigmaaa+0.1645530784602056D-1*t19
     #*t14)*t33+0.9305257363491D0*t24*t67*(t76+t78
     #+0.2166217250458446D-5*sigmaaa*t29)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = dsqrt(sigmaaa)
      t7 = 1/t5
      t8 = t6*t7
      t10 = dlog(0.1000005877780776D1*t8+dsqrt(1+0.10000117555961D1*t8
     #**2))
      t12 = 0.2520026100493014D-1*t8*t10
      t13 = rhoa**2
      t14 = t4**2
      t16 = 1/t14/t13
      t17 = sigmaaa*t16
      t19 = dexp(-0.1645530784602056D1*t17)
      t21 = 0.2743D0-0.1508D0*t19
      t22 = t21*sigmaaa
      t25 = 1.D0+t12+0.1645530784602056D-1*t22*t16
      t26 = t5*t25
      t27 = sigmaaa**2
      t28 = t13**2
      t31 = 1/t4/t28/rhoa
      t34 = 1.D0+t12+0.1083108625229223D-5*t27*t31
      t35 = 1/t34
      t38 = rhob**(1.D0/3.D0)
      t39 = t38*rhob
      t40 = dsqrt(sigmabb)
      t41 = 1/t39
      t42 = t40*t41
      t44 = dlog(0.1000005877780776D1*t42+dsqrt(1+0.10000117555961D1
     #*t42**2))
      t46 = 0.2520026100493014D-1*t42*t44
      t47 = rhob**2
      t48 = t38**2
      t50 = 1/t48/t47
      t51 = sigmabb*t50
      t53 = dexp(-0.1645530784602056D1*t51)
      t55 = 0.2743D0-0.1508D0*t53
      t56 = t55*sigmabb
      t59 = 1.D0+t46+0.1645530784602056D-1*t56*t50
      t60 = t39*t59
      t61 = sigmabb**2
      t62 = t47**2
      t65 = 1/t38/t62/rhob
      t68 = 1.D0+t46+0.1083108625229223D-5*t61*t65
      t69 = 1/t68
      zk(i) = -0.9305257363491D0*t26*t35-0.9305257363491D0*t60*t69
      t79 = 0.3360034800657352D-1*t6/t4/t13*t10
      t82 = 1/t14/t13/rhoa
      t86 = dsqrt(1.D0+0.10000117555961D1*t17)
      t87 = 1/t86
      t89 = 0.3360054550205309D-1*sigmaaa*t82*t87
      t93 = t27/t4/t28/t13
      t102 = t34**2
      t103 = 1/t102
      vrhoa(i) = -0.12407009817988D1*t4*t25*t35-0.9305257363491D0*t5*(
     #-t79-t89-0.1088885204563779D-1*t93*t19-0.4388082092272149D-1*t22
     #*t82)*t35+0.9305257363491D0*t26*t103*(-t79-t89
     #-0.5776579334555855D-5*t93)
      t116 = 0.3360034800657352D-1*t40/t38/t47*t44
      t119 = 1/t48/t47/rhob
      t123 = dsqrt(1.D0+0.10000117555961D1*t51)
      t124 = 1/t123
      t126 = 0.3360054550205309D-1*sigmabb*t119*t124
      t130 = t61/t38/t62/t47
      t139 = t68**2
      t140 = 1/t139
      vrhob(i) = -0.12407009817988D1*t38*t59*t69-0.9305257363491D0*t39
     #*(-t116-t126-0.1088885204563779D-1*t130*t53
     #-0.4388082092272149D-1*t56*t119)*t69+0.9305257363491D0*t60*t140*
     #(-t116-t126-0.5776579334555855D-5*t130)
      t149 = 0.1260013050246507D-1/t6*t7*t10
      t151 = 0.1260020456326991D-1*t16*t87
      vsigmaaa(i) = -0.9305257363491D0*t5*(t149+t151
     #+0.408331951711417D-2*t31*t19*sigmaaa+0.1645530784602056D-1*t21
     #*t16)*t35+0.9305257363491D0*t26*t103*(t149+t151
     #+0.2166217250458446D-5*sigmaaa*t31)
      vsigmaab(i) = 0.D0
      t170 = 0.1260013050246507D-1/t40*t41*t44
      t172 = 0.1260020456326991D-1*t50*t124
      vsigmabb(i) = -0.9305257363491D0*t39*(t170+t172
     #+0.408331951711417D-2*t65*t53*sigmabb+0.1645530784602056D-1*t55
     #*t50)*t69+0.9305257363491D0*t60*t140*(t170+t172
     #+0.2166217250458446D-5*sigmabb*t65)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = dsqrt(sigmabb)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhob**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigmabb*t14
      t17 = dexp(-0.1645530784602056D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigmabb
      t23 = 1.D0+t10+0.1645530784602056D-1*t20*t14
      t24 = t3*t23
      t25 = sigmabb**2
      t26 = t11**2
      t29 = 1/t2/t26/rhob
      t32 = 1.D0+t10+0.1083108625229223D-5*t25*t29
      t33 = 1/t32
      zk(i) = -0.9305257363491D0*t24*t33
      vrhoa(i) = 0.D0
      t36 = t2*t23
      t43 = 0.3360034800657352D-1*t4/t2/t11*t8
      t44 = t11*rhob
      t46 = 1/t12/t44
      t49 = 1.D0+0.10000117555961D1*t15
      t50 = dsqrt(t49)
      t51 = 1/t50
      t53 = 0.3360054550205309D-1*sigmabb*t46*t51
      t57 = t25/t2/t26/t11
      t62 = -t43-t53-0.1088885204563779D-1*t57*t17
     #-0.4388082092272149D-1*t20*t46
      t63 = t3*t62
      t66 = t32**2
      t67 = 1/t66
      t69 = -t43-t53-0.5776579334555855D-5*t57
      t70 = t67*t69
      vrhob(i) = -0.12407009817988D1*t36*t33-0.9305257363491D0*t63*t33
     #+0.9305257363491D0*t24*t70
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t76 = 0.1260013050246507D-1/t4*t5*t8
      t78 = 0.1260020456326991D-1*t14*t51
      t79 = t29*t17
      t85 = t3*(t76+t78+0.408331951711417D-2*t79*sigmabb
     #+0.1645530784602056D-1*t19*t14)
      t90 = t76+t78+0.2166217250458446D-5*sigmabb*t29
      t91 = t67*t90
      vsigmabb(i) = -0.9305257363491D0*t85*t33+0.9305257363491D0*t24*t91
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t107 = 0.7840081201533821D-1*t4/t2/t44*t8
      t109 = 1/t12/t26
      t112 = 0.1680027275102654D0*sigmabb*t109*t51
      t116 = t25/t2/t26/t44
      t118 = 1/t50/t49
      t120 = 0.4480125399532632D-1*t116*t118
      t124 = t26**2
      t139 = 1/t66/t32
      t140 = t69**2
      v2rhob2(i) = -0.4135669939329333D0/t12*t23*t33
     #-0.24814019635976D1*t2*t62*t33+0.24814019635976D1*t36*t70
     #-0.9305257363491D0*t3*(t107+t112-t120+0.9799966841074009D-1*t116
     #*t17-0.4778117666686413D-1*t25*sigmabb/t124/t11*t17
     #+0.1608963433833121D0*t20*t109)*t33+0.18610514726982D1*t63*t70
     #-0.18610514726982D1*t24*t139*t140+0.9305257363491D0*t24*t67*
     #(t107+t112-t120+0.3658500245218708D-4*t116)
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t153 = 0.6300065251232535D-2/t4/sigmabb*t5*t8
      t157 = 0.6300102281634954D-2/sigmabb*t14*t51
      t159 = 0.6300176343092764D-2*t29*t118
      t171 = t90**2
      v2sigmabb2(i) = -0.9305257363491D0*t3*(-t153+t157-t159
     #-0.6719227968777768D-2/t124*t17*sigmabb+0.8166639034228341D-2
     #*t79)*t33+0.18610514726982D1*t85*t91-0.18610514726982D1*t24*t139
     #*t171+0.9305257363491D0*t24*t67*(-t153+t157-t159
     #+0.2166217250458446D-5*t29)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = dsqrt(sigmaaa)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhoa**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigmaaa*t14
      t17 = dexp(-0.1645530784602056D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigmaaa
      t23 = 1.D0+t10+0.1645530784602056D-1*t20*t14
      t24 = t3*t23
      t25 = sigmaaa**2
      t26 = t11**2
      t29 = 1/t2/t26/rhoa
      t32 = 1.D0+t10+0.1083108625229223D-5*t25*t29
      t33 = 1/t32
      zk(i) = -0.9305257363491D0*t24*t33
      t36 = t2*t23
      t43 = 0.3360034800657352D-1*t4/t2/t11*t8
      t44 = t11*rhoa
      t46 = 1/t12/t44
      t49 = 1.D0+0.10000117555961D1*t15
      t50 = dsqrt(t49)
      t51 = 1/t50
      t53 = 0.3360054550205309D-1*sigmaaa*t46*t51
      t57 = t25/t2/t26/t11
      t62 = -t43-t53-0.1088885204563779D-1*t57*t17
     #-0.4388082092272149D-1*t20*t46
      t63 = t3*t62
      t66 = t32**2
      t67 = 1/t66
      t69 = -t43-t53-0.5776579334555855D-5*t57
      t70 = t67*t69
      vrhoa(i) = -0.12407009817988D1*t36*t33-0.9305257363491D0*t63*t33
     #+0.9305257363491D0*t24*t70
      vrhob(i) = 0.D0
      t76 = 0.1260013050246507D-1/t4*t5*t8
      t78 = 0.1260020456326991D-1*t14*t51
      t79 = t29*t17
      t85 = t3*(t76+t78+0.408331951711417D-2*t79*sigmaaa
     #+0.1645530784602056D-1*t19*t14)
      t90 = t76+t78+0.2166217250458446D-5*sigmaaa*t29
      t91 = t67*t90
      vsigmaaa(i) = -0.9305257363491D0*t85*t33+0.9305257363491D0*t24*t91
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t107 = 0.7840081201533821D-1*t4/t2/t44*t8
      t109 = 1/t12/t26
      t112 = 0.1680027275102654D0*sigmaaa*t109*t51
      t116 = t25/t2/t26/t44
      t118 = 1/t50/t49
      t120 = 0.4480125399532632D-1*t116*t118
      t124 = t26**2
      t139 = 1/t66/t32
      t140 = t69**2
      v2rhoa2(i) = -0.4135669939329333D0/t12*t23*t33
     #-0.24814019635976D1*t2*t62*t33+0.24814019635976D1*t36*t70
     #-0.9305257363491D0*t3*(t107+t112-t120+0.9799966841074009D-1*t116
     #*t17-0.4778117666686413D-1*t25*sigmaaa/t124/t11*t17
     #+0.1608963433833121D0*t20*t109)*t33+0.18610514726982D1*t63*t70
     #-0.18610514726982D1*t24*t139*t140+0.9305257363491D0*t24*t67*
     #(t107+t112-t120+0.3658500245218708D-4*t116)
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t153 = 0.6300065251232535D-2/t4/sigmaaa*t5*t8
      t157 = 0.6300102281634954D-2/sigmaaa*t14*t51
      t159 = 0.6300176343092764D-2*t29*t118
      t171 = t90**2
      v2sigmaaa2(i) = -0.9305257363491D0*t3*(-t153+t157-t159
     #-0.6719227968777768D-2/t124*t17*sigmaaa+0.8166639034228341D-2
     #*t79)*t33+0.18610514726982D1*t85*t91-0.18610514726982D1*t24*t139
     #*t171+0.9305257363491D0*t24*t67*(-t153+t157-t159
     #+0.2166217250458446D-5*t29)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = dsqrt(sigmaaa)
      t7 = 1/t5
      t8 = t6*t7
      t10 = dlog(0.1000005877780776D1*t8+dsqrt(1+0.10000117555961D1*t8
     #**2))
      t12 = 0.2520026100493014D-1*t8*t10
      t13 = rhoa**2
      t14 = t4**2
      t16 = 1/t14/t13
      t17 = sigmaaa*t16
      t19 = dexp(-0.1645530784602056D1*t17)
      t21 = 0.2743D0-0.1508D0*t19
      t22 = t21*sigmaaa
      t25 = 1.D0+t12+0.1645530784602056D-1*t22*t16
      t26 = t5*t25
      t27 = sigmaaa**2
      t28 = t13**2
      t31 = 1/t4/t28/rhoa
      t34 = 1.D0+t12+0.1083108625229223D-5*t27*t31
      t35 = 1/t34
      t38 = rhob**(1.D0/3.D0)
      t39 = t38*rhob
      t40 = dsqrt(sigmabb)
      t41 = 1/t39
      t42 = t40*t41
      t44 = dlog(0.1000005877780776D1*t42+dsqrt(1+0.10000117555961D1
     #*t42**2))
      t46 = 0.2520026100493014D-1*t42*t44
      t47 = rhob**2
      t48 = t38**2
      t50 = 1/t48/t47
      t51 = sigmabb*t50
      t53 = dexp(-0.1645530784602056D1*t51)
      t55 = 0.2743D0-0.1508D0*t53
      t56 = t55*sigmabb
      t59 = 1.D0+t46+0.1645530784602056D-1*t56*t50
      t60 = t39*t59
      t61 = sigmabb**2
      t62 = t47**2
      t65 = 1/t38/t62/rhob
      t68 = 1.D0+t46+0.1083108625229223D-5*t61*t65
      t69 = 1/t68
      zk(i) = -0.9305257363491D0*t26*t35-0.9305257363491D0*t60*t69
      t72 = t4*t25
      t76 = 1/t4/t13
      t79 = 0.3360034800657352D-1*t6*t76*t10
      t80 = t13*rhoa
      t82 = 1/t14/t80
      t85 = 1.D0+0.10000117555961D1*t17
      t86 = dsqrt(t85)
      t87 = 1/t86
      t89 = 0.3360054550205309D-1*sigmaaa*t82*t87
      t92 = 1/t4/t28/t13
      t93 = t27*t92
      t98 = -t79-t89-0.1088885204563779D-1*t93*t19
     #-0.4388082092272149D-1*t22*t82
      t99 = t5*t98
      t102 = t34**2
      t103 = 1/t102
      t105 = -t79-t89-0.5776579334555855D-5*t93
      t106 = t103*t105
      vrhoa(i) = -0.12407009817988D1*t72*t35-0.9305257363491D0*t99*t35
     #+0.9305257363491D0*t26*t106
      t109 = t38*t59
      t113 = 1/t38/t47
      t116 = 0.3360034800657352D-1*t40*t113*t44
      t117 = t47*rhob
      t119 = 1/t48/t117
      t122 = 1.D0+0.10000117555961D1*t51
      t123 = dsqrt(t122)
      t124 = 1/t123
      t126 = 0.3360054550205309D-1*sigmabb*t119*t124
      t129 = 1/t38/t62/t47
      t130 = t61*t129
      t135 = -t116-t126-0.1088885204563779D-1*t130*t53
     #-0.4388082092272149D-1*t56*t119
      t136 = t39*t135
      t139 = t68**2
      t140 = 1/t139
      t142 = -t116-t126-0.5776579334555855D-5*t130
      t143 = t140*t142
      vrhob(i) = -0.12407009817988D1*t109*t69-0.9305257363491D0*t136
     #*t69+0.9305257363491D0*t60*t143
      t146 = 1/t6
      t149 = 0.1260013050246507D-1*t146*t7*t10
      t151 = 0.1260020456326991D-1*t16*t87
      t152 = t31*t19
      t157 = t149+t151+0.408331951711417D-2*t152*sigmaaa
     #+0.1645530784602056D-1*t21*t16
      t158 = t5*t157
      t163 = t149+t151+0.2166217250458446D-5*sigmaaa*t31
      t164 = t103*t163
      vsigmaaa(i) = -0.9305257363491D0*t158*t35+0.9305257363491D0*t26
     #*t164
      vsigmaab(i) = 0.D0
      t167 = 1/t40
      t170 = 0.1260013050246507D-1*t167*t41*t44
      t172 = 0.1260020456326991D-1*t50*t124
      t173 = t65*t53
      t178 = t170+t172+0.408331951711417D-2*t173*sigmabb
     #+0.1645530784602056D-1*t55*t50
      t179 = t39*t178
      t184 = t170+t172+0.2166217250458446D-5*sigmabb*t65
      t185 = t140*t184
      vsigmabb(i) = -0.9305257363491D0*t179*t69+0.9305257363491D0*t60
     #*t185
      t201 = 0.7840081201533821D-1*t6/t4/t80*t10
      t203 = 1/t14/t28
      t206 = 0.1680027275102654D0*sigmaaa*t203*t87
      t210 = t27/t4/t28/t80
      t212 = 1/t86/t85
      t214 = 0.4480125399532632D-1*t210*t212
      t218 = t28**2
      t233 = 1/t102/t34
      t234 = t105**2
      v2rhoa2(i) = -0.4135669939329333D0/t14*t25*t35
     #-0.24814019635976D1*t4*t98*t35+0.24814019635976D1*t72*t106
     #-0.9305257363491D0*t5*(t201+t206-t214+0.9799966841074009D-1*t210
     #*t19-0.4778117666686413D-1*t27*sigmaaa/t218/t13*t19
     #+0.1608963433833121D0*t22*t203)*t35+0.18610514726982D1*t99*t106
     #-0.18610514726982D1*t26*t233*t234+0.9305257363491D0*t26*t103*
     #(t201+t206-t214+0.3658500245218708D-4*t210)
      t256 = 0.7840081201533821D-1*t40/t38/t117*t44
      t258 = 1/t48/t62
      t261 = 0.1680027275102654D0*sigmabb*t258*t124
      t265 = t61/t38/t62/t117
      t267 = 1/t123/t122
      t269 = 0.4480125399532632D-1*t265*t267
      t273 = t62**2
      t288 = 1/t139/t68
      t289 = t142**2
      v2rhob2(i) = -0.4135669939329333D0/t48*t59*t69
     #-0.24814019635976D1*t38*t135*t69+0.24814019635976D1*t109*t143
     #-0.9305257363491D0*t39*(t256+t261-t269+0.9799966841074009D-1
     #*t265*t53-0.4778117666686413D-1*t61*sigmabb/t273/t47*t53
     #+0.1608963433833121D0*t56*t258)*t69+0.18610514726982D1*t136*t143
     #-0.18610514726982D1*t60*t288*t289+0.9305257363491D0*t60*t140*
     #(t256+t261-t269+0.3658500245218708D-4*t265)
      v2rhoab(i) = 0.D0
      t305 = 0.1680017400328676D-1*t146*t76*t10
      t307 = 0.5040081825307963D-1*t82*t87
      t308 = sigmaaa*t92
      t310 = 0.1680047024824737D-1*t308*t212
      v2rhoasigmaaa(i) = -0.12407009817988D1*t4*t157*t35
     #+0.12407009817988D1*t72*t164-0.9305257363491D0*t5*(-t305-t307
     #+t310-0.3266655613691336D-1*t92*t19*sigmaaa
     #+0.1791794125007405D-1*t27/t218/rhoa*t19-0.4388082092272149D-1
     #*t21*t82)*t35+0.9305257363491D0*t99*t164+0.9305257363491D0*t158
     #*t106-0.18610514726982D1*t26*t233*t105*t163+0.9305257363491D0
     #*t26*t103*(-t305-t307+t310-0.1155315866911171D-4*t308)
      v2rhoasigmaab(i) = 0.D0
      v2rhoasigmabb(i) = 0.D0
      v2rhobsigmaaa(i) = 0.D0
      v2rhobsigmaab(i) = 0.D0
      t345 = 0.1680017400328676D-1*t167*t113*t44
      t347 = 0.5040081825307963D-1*t119*t124
      t348 = sigmabb*t129
      t350 = 0.1680047024824737D-1*t348*t267
      v2rhobsigmabb(i) = -0.12407009817988D1*t38*t178*t69
     #+0.12407009817988D1*t109*t185-0.9305257363491D0*t39*(-t345-t347
     #+t350-0.3266655613691336D-1*t129*t53*sigmabb
     #+0.1791794125007405D-1*t61/t273/rhob*t53-0.4388082092272149D-1
     #*t55*t119)*t69+0.9305257363491D0*t136*t185+0.9305257363491D0
     #*t179*t143-0.18610514726982D1*t60*t288*t142*t184
     #+0.9305257363491D0*t60*t140*(-t345-t347+t350
     #-0.1155315866911171D-4*t348)
      t382 = 0.6300065251232535D-2/t6/sigmaaa*t7*t10
      t386 = 0.6300102281634954D-2/sigmaaa*t16*t87
      t388 = 0.6300176343092764D-2*t31*t212
      t400 = t163**2
      v2sigmaaa2(i) = -0.9305257363491D0*t5*(-t382+t386-t388
     #-0.6719227968777768D-2/t218*t19*sigmaaa+0.8166639034228341D-2
     #*t152)*t35+0.18610514726982D1*t158*t164-0.18610514726982D1*t26
     #*t233*t400+0.9305257363491D0*t26*t103*(-t382+t386-t388
     #+0.2166217250458446D-5*t31)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t413 = 0.6300065251232535D-2/t40/sigmabb*t41*t44
      t417 = 0.6300102281634954D-2/sigmabb*t50*t124
      t419 = 0.6300176343092764D-2*t65*t267
      t431 = t184**2
      v2sigmabb2(i) = -0.9305257363491D0*t39*(-t413+t417-t419
     #-0.6719227968777768D-2/t273*t53*sigmabb+0.8166639034228341D-2
     #*t173)*t69+0.18610514726982D1*t179*t185-0.18610514726982D1*t60
     #*t288*t431+0.9305257363491D0*t60*t140*(-t413+t417-t419
     #+0.2166217250458446D-5*t65)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_x_pw91
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     J.P. Perdew, J.A. Chevary, S.H. Vosko, K.A. Jackson,
c     M.R. Pederson, D.J. Singh, C. Fiolhais
c     Atoms, molecules, solids and surfaces:
c     Applications of the generalized gradient approximation
c     for exchange and correlation
c     Phys. Rev. B 46 (1992) 6671--6687
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(0.D0,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = dsqrt(sigma)
      t6 = t4/t3
      t8 = dlog(0.1259928455434599D1*t6+dsqrt(1+0.1587419712813814D1
     #*t6**2))
      t10 = 0.3175033930295641D-1*t6*t8
      t11 = rho**2
      t12 = t2**2
      t14 = 1/t12/t11
      t17 = dexp(-0.261211729852336D1*sigma*t14)
      t25 = sigma**2
      t26 = t11**2
      zk(i) = -0.7385587663820224D0*t3*(1.D0+t10+0.261211729852336D-1*
     #(0.2743D0-0.1508D0*t17)*sigma*t14)/(1.D0+t10
     #+0.272926271249799D-5*t25/t2/t26/rho)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(0.D0,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = dsqrt(sigma)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1259928455434599D1*t6+dsqrt(1+0.1587419712813814D1
     #*t6**2))
      t10 = 0.3175033930295641D-1*t6*t8
      t11 = rho**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigma*t14
      t17 = dexp(-0.261211729852336D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigma
      t23 = 1.D0+t10+0.261211729852336D-1*t20*t14
      t24 = t3*t23
      t25 = sigma**2
      t26 = t11**2
      t29 = 1/t2/t26/rho
      t32 = 1.D0+t10+0.272926271249799D-5*t25*t29
      t33 = 1/t32
      zk(i) = -0.7385587663820224D0*t24*t33
      t43 = 0.8466757147455043D-1*t4/t2/t11*t8
      t46 = 1/t12/t11/rho
      t50 = dsqrt(1.D0+0.1587419712813815D1*t15)
      t51 = 1/t50
      t53 = 0.1066750825533289D0*sigma*t46*t51
      t57 = t25/t2/t26/t11
      t66 = t32**2
      t67 = 1/t66
      vrhoa(i) = -0.9847450218426965D0*t2*t23*t33-0.3692793831910112D0
     #*t3*(-t43-t53-0.5487637560595959D-1*t57*t17-0.1393129225879125D0
     #*t20*t46)*t33+0.3692793831910112D0*t24*t67*(-t43-t53
     #-0.2911213559997856D-4*t57)
      t76 = 0.6350067860591282D-1/t4*t5*t8
      t78 = 0.8000631191499664D-1*t14*t51
      vsigmaaa(i) = -0.7385587663820224D0*t3*(t76+t78
     #+0.411572817044697D-1*t29*t17*sigma+0.1044846919409344D0*t19*t14
     #)*t33+0.7385587663820224D0*t24*t67*(t76+t78
     #+0.2183410169998392D-4*sigma*t29)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(0.D0,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = dsqrt(sigma)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1259928455434599D1*t6+dsqrt(1+0.1587419712813814D1
     #*t6**2))
      t10 = 0.3175033930295641D-1*t6*t8
      t11 = rho**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigma*t14
      t17 = dexp(-0.261211729852336D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigma
      t23 = 1.D0+t10+0.261211729852336D-1*t20*t14
      t24 = t3*t23
      t25 = sigma**2
      t26 = t11**2
      t29 = 1/t2/t26/rho
      t32 = 1.D0+t10+0.272926271249799D-5*t25*t29
      t33 = 1/t32
      zk(i) = -0.7385587663820224D0*t24*t33
      t36 = t2*t23
      t40 = 1/t2/t11
      t43 = 0.8466757147455043D-1*t4*t40*t8
      t44 = t11*rho
      t46 = 1/t12/t44
      t49 = 1.D0+0.1587419712813815D1*t15
      t50 = dsqrt(t49)
      t51 = 1/t50
      t53 = 0.1066750825533289D0*sigma*t46*t51
      t56 = 1/t2/t26/t11
      t57 = t25*t56
      t62 = -t43-t53-0.5487637560595959D-1*t57*t17
     #-0.1393129225879125D0*t20*t46
      t63 = t3*t62
      t66 = t32**2
      t67 = 1/t66
      t69 = -t43-t53-0.2911213559997856D-4*t57
      t70 = t67*t69
      vrhoa(i) = -0.9847450218426965D0*t36*t33-0.3692793831910112D0
     #*t63*t33+0.3692793831910112D0*t24*t70
      t73 = 1/t4
      t76 = 0.6350067860591282D-1*t73*t5*t8
      t78 = 0.8000631191499664D-1*t14*t51
      t79 = t29*t17
      t84 = t76+t78+0.411572817044697D-1*t79*sigma
     #+0.1044846919409344D0*t19*t14
      t85 = t3*t84
      t90 = t76+t78+0.2183410169998392D-4*sigma*t29
      t91 = t67*t90
      vsigmaaa(i) = -0.7385587663820224D0*t85*t33+0.7385587663820224D0
     #*t24*t91
      t107 = 0.395115333547902D0*t4/t2/t44*t8
      t109 = 1/t12/t26
      t112 = 0.1066750825533289D1*sigma*t109*t51
      t116 = t25/t2/t26/t44
      t118 = 1/t50/t49
      t120 = 0.4515683437631874D0*t116*t118
      t124 = t26**2
      t139 = 1/t66/t32
      t140 = t69**2
      v2rhoa2(i) = -0.6564966812284644D0/t12*t23*t33
     #-0.1969490043685393D1*t2*t62*t33+0.1969490043685393D1*t36*t70
     #-0.3692793831910112D0*t3*(t107+t112-t120+0.9877747609072727D0
     #*t116*t17-0.764498826669826D0*t25*sigma/t124/t11*t17
     #+0.1021628098978025D1*t20*t109)*t33+0.7385587663820224D0*t63*t70
     #-0.7385587663820224D0*t24*t139*t140+0.3692793831910112D0*t24*t67
     #*(t107+t112-t120+0.3687537175997285D-3*t116)
      t156 = 0.1693351429491009D0*t73*t40*t8
      t158 = 0.6400504953199731D0*t46*t51
      t159 = sigma*t56
      t161 = 0.3386762578223905D0*t159*t118
      v2rhoasigmaaa(i) = -0.9847450218426965D0*t2*t84*t33
     #+0.9847450218426965D0*t36*t91-0.3692793831910112D0*t3*(-t156
     #-t158+t161-0.6585165072715151D0*t56*t17*sigma
     #+0.5733741200023695D0*t25/t124/rho*t17-0.5572516903516501D0*t19
     #*t46)*t33+0.3692793831910112D0*t63*t91+0.3692793831910112D0*t85
     #*t70-0.7385587663820224D0*t24*t139*t69*t90+0.3692793831910112D0
     #*t24*t67*(-t156-t158+t161-0.2328970847998285D-3*t159)
      t193 = 0.1270013572118256D0/t4/sigma*t5*t8
      t197 = 0.1600126238299933D0/sigma*t14*t51
      t199 = 0.2540071933667929D0*t29*t118
      t211 = t90**2
      v2sigmaaa2(i) = -0.7385587663820224D0*t3*(-t193+t197-t199
     #-0.4300305900017772D0/t124*t17*sigma+0.3292582536357576D0*t79)
     #*t33+0.1477117532764045D1*t85*t91-0.1477117532764045D1*t24*t139
     #*t211+0.7385587663820224D0*t24*t67*(-t193+t197-t199
     #+0.8733640679993569D-4*t29)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end













c    Generated: Wed Sep  3 12:48:32 GMT 2003

      subroutine uks_x_pbe
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     J.P. Perdew, K. Burke, and M. Ernzerhof
c     Generalized gradient approximation made simple
c     Phys. Rev. Lett. 77 (1996) 3865-3868
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t4 = rhob**2
      t5 = t2**2
      zk(i) = -0.9305257363491D0*t2*rhob*(0.1804D1-0.804D0/(1.D0
     #+0.449276922095889D-2*sigmabb/t5/t4))
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t4 = rhoa**2
      t5 = t2**2
      zk(i) = -0.9305257363491D0*t2*rhoa*(0.1804D1-0.804D0/(1.D0
     #+0.449276922095889D-2*sigmaaa/t5/t4))
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t6 = rhoa**2
      t7 = t4**2
      t18 = rhob**(1.D0/3.D0)
      t20 = rhob**2
      t21 = t18**2
      zk(i) = -0.9305257363491D0*t4*rhoa*(0.1804D1-0.804D0/(1.D0
     #+0.449276922095889D-2*sigmaaa/t7/t6))-0.9305257363491D0*t18*rhob
     #*(0.1804D1-0.804D0/(1.D0+0.449276922095889D-2*sigmabb/t21/t20))
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t10 = 1.D0+0.449276922095889D-2*sigmabb/t5/t4
      t13 = 0.1804D1-0.804D0/t10
      zk(i) = -0.9305257363491D0*t3*t13
      vrhoa(i) = 0.D0
      t20 = t10**2
      t21 = 1/t20
      vrhob(i) = -0.12407009817988D1*t2*t13+0.8963286558970112D-2/t2
     #/t4*t21*sigmabb
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = -0.3361232459613792D-2/t3*t21
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t10 = 1.D0+0.449276922095889D-2*sigmaaa/t5/t4
      t13 = 0.1804D1-0.804D0/t10
      zk(i) = -0.9305257363491D0*t3*t13
      t20 = t10**2
      t21 = 1/t20
      vrhoa(i) = -0.12407009817988D1*t2*t13+0.8963286558970112D-2/t2
     #/t4*t21*sigmaaa
      vrhob(i) = 0.D0
      vsigmaaa(i) = -0.3361232459613792D-2/t3*t21
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t12 = 1.D0+0.449276922095889D-2*sigmaaa/t7/t6
      t15 = 0.1804D1-0.804D0/t12
      t18 = rhob**(1.D0/3.D0)
      t19 = t18*rhob
      t20 = rhob**2
      t21 = t18**2
      t26 = 1.D0+0.449276922095889D-2*sigmabb/t21/t20
      t29 = 0.1804D1-0.804D0/t26
      zk(i) = -0.9305257363491D0*t5*t15-0.9305257363491D0*t19*t29
      t36 = t12**2
      t37 = 1/t36
      vrhoa(i) = -0.12407009817988D1*t4*t15+0.8963286558970112D-2/t4
     #/t6*t37*sigmaaa
      t45 = t26**2
      t46 = 1/t45
      vrhob(i) = -0.12407009817988D1*t18*t29+0.8963286558970112D-2/t18
     #/t20*t46*sigmabb
      vsigmaaa(i) = -0.3361232459613792D-2/t5*t37
      vsigmaab(i) = 0.D0
      vsigmabb(i) = -0.3361232459613792D-2/t19*t46
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t10 = 1.D0+0.449276922095889D-2*sigmabb/t5/t4
      t13 = 0.1804D1-0.804D0/t10
      zk(i) = -0.9305257363491D0*t3*t13
      vrhoa(i) = 0.D0
      t20 = t10**2
      t21 = 1/t20
      vrhob(i) = -0.12407009817988D1*t2*t13+0.8963286558970112D-2/t2
     #/t4*t21*sigmabb
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = -0.3361232459613792D-2/t3*t21
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t37 = t4**2
      t41 = 1/t20/t10
      t43 = sigmabb**2
      v2rhob2(i) = -0.4135669939329333D0/t5*t13-0.8963286558970112D-2
     #/t2/t4/rhob*t21*sigmabb+0.2147732158441357D-3/t37/t4*t41*t43
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.3020248347808158D-4/t37*t41
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t10 = 1.D0+0.449276922095889D-2*sigmaaa/t5/t4
      t13 = 0.1804D1-0.804D0/t10
      zk(i) = -0.9305257363491D0*t3*t13
      t20 = t10**2
      t21 = 1/t20
      vrhoa(i) = -0.12407009817988D1*t2*t13+0.8963286558970112D-2/t2
     #/t4*t21*sigmaaa
      vrhob(i) = 0.D0
      vsigmaaa(i) = -0.3361232459613792D-2/t3*t21
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t37 = t4**2
      t41 = 1/t20/t10
      t43 = sigmaaa**2
      v2rhoa2(i) = -0.4135669939329333D0/t5*t13-0.8963286558970112D-2
     #/t2/t4/rhoa*t21*sigmaaa+0.2147732158441357D-3/t37/t4*t41*t43
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      v2sigmaaa2(i) = 0.3020248347808158D-4/t37*t41
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t12 = 1.D0+0.449276922095889D-2*sigmaaa/t7/t6
      t15 = 0.1804D1-0.804D0/t12
      t18 = rhob**(1.D0/3.D0)
      t19 = t18*rhob
      t20 = rhob**2
      t21 = t18**2
      t26 = 1.D0+0.449276922095889D-2*sigmabb/t21/t20
      t29 = 0.1804D1-0.804D0/t26
      zk(i) = -0.9305257363491D0*t5*t15-0.9305257363491D0*t19*t29
      t36 = t12**2
      t37 = 1/t36
      t38 = 1/t4/t6*t37
      vrhoa(i) = -0.12407009817988D1*t4*t15+0.8963286558970112D-2*t38
     #*sigmaaa
      t45 = t26**2
      t46 = 1/t45
      t47 = 1/t18/t20*t46
      vrhob(i) = -0.12407009817988D1*t18*t29+0.8963286558970112D-2*t47
     #*sigmabb
      vsigmaaa(i) = -0.3361232459613792D-2/t5*t37
      vsigmaab(i) = 0.D0
      vsigmabb(i) = -0.3361232459613792D-2/t19*t46
      t65 = t6**2
      t69 = 1/t36/t12
      t71 = sigmaaa**2
      v2rhoa2(i) = -0.4135669939329333D0/t7*t15-0.8963286558970112D-2
     #/t4/t6/rhoa*t37*sigmaaa+0.2147732158441357D-3/t65/t6*t69*t71
      t83 = t20**2
      t87 = 1/t45/t26
      t89 = sigmabb**2
      v2rhob2(i) = -0.4135669939329333D0/t21*t29-0.8963286558970112D-2
     #/t18/t20/rhob*t46*sigmabb+0.2147732158441357D-3/t83/t20*t87*t89
      v2rhoab(i) = 0.D0
      v2rhoasigmaaa(i) = 0.4481643279485056D-2*t38
     #-0.8053995594155087D-4/t65/rhoa*t69*sigmaaa
      v2rhoasigmaab(i) = 0.D0
      v2rhoasigmabb(i) = 0.D0
      v2rhobsigmaaa(i) = 0.D0
      v2rhobsigmaab(i) = 0.D0
      v2rhobsigmabb(i) = 0.4481643279485056D-2*t47
     #-0.8053995594155087D-4/t83/rhob*t87*sigmabb
      v2sigmaaa2(i) = 0.3020248347808158D-4/t65*t69
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.3020248347808158D-4/t83*t87
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_x_pbe
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     J.P. Perdew, K. Burke, and M. Ernzerhof
c     Generalized gradient approximation made simple
c     Phys. Rev. Lett. 77 (1996) 3865-3868
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t4 = rho**2
      t5 = t2**2
      zk(i) = -0.7385587663820224D0*t2*rho*(0.1804D1-0.804D0/(1.D0
     #+0.7131826587600489D-2*sigma/t5/t4))
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t10 = 1.D0+0.7131826587600489D-2*sigma/t5/t4
      t13 = 0.1804D1-0.804D0/t10
      zk(i) = -0.7385587663820224D0*t3*t13
      t20 = t10**2
      t21 = 1/t20
      vrhoa(i) = -0.9847450218426965D0*t2*t13+0.1129303341188623D-1/t2
     #/t4*t21*sigma
      vsigmaaa(i) = -0.1693955011782934D-1/t3*t21
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t10 = 1.D0+0.7131826587600489D-2*sigma/t5/t4
      t13 = 0.1804D1-0.804D0/t10
      zk(i) = -0.7385587663820224D0*t3*t13
      t20 = t10**2
      t21 = 1/t20
      t22 = 1/t2/t4*t21
      vrhoa(i) = -0.9847450218426965D0*t2*t13+0.1129303341188623D-1
     #*t22*sigma
      vsigmaaa(i) = -0.1693955011782934D-1/t3*t21
      t37 = t4**2
      t41 = 1/t20/t10
      t43 = sigma**2
      v2rhoa2(i) = -0.6564966812284644D0/t5*t13-0.2258606682377246D-1
     #/t2/t4/rho*t21*sigma+0.8590928633765426D-3/t37/t4*t41*t43
      v2rhoasigmaaa(i) = 0.2258606682377246D-1*t22
     #-0.644319647532407D-3/t37/rho*t41*sigma
      v2sigmaaa2(i) = 0.9664794712986105D-3/t37*t41
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:X_PBEsubrend
c:XC_HCTH407subrstart

c    Generated: Sat May  8 18:40:30 GMT 2004

      subroutine uks_xc_hcth407
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     A.D. Boese, N.C. Handy
c     A new parametriztion of exchange-correlation generalized gradient
c     approximation functionals
c     J. Chem. Phys. 114 (2001) 5497-5503.
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t4 = rhob**2
      t5 = t2**2
      t8 = sigmabb/t5/t4
      t10 = 1.D0+0.4D-2*t8
      t14 = sigmabb**2
      t15 = t4**2
      t19 = t14/t2/t15/rhob
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigmabb/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t49
     #+0.3844746237447211D1*t45+0.1644733775567609D1*t52
     #+0.2405871291288192D0*t54))
      t62 = 1.D0+0.2D0*t8
      t66 = t62**2
      t74 = t66**2
      zk(i) = -0.9305257363491D0*t2*rhob*(0.108184D1-0.2073356D-2*t8
     #/t10+0.5480992D-4*t19/t20-0.16825664D-6*t27/t20/t10+0.5858688D-9
     #*t36/t37)-0.3109D-1*rhob*(1.D0+0.1274696188700087D0*t45)*t60*
     #(0.118777D1-0.480584D0*t8/t62+0.2246964D0*t19/t66-0.7343384D-1
     #*t27/t66/t62+0.9996768D-2*t36/t74)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t4 = rhoa**2
      t5 = t2**2
      t8 = sigmaaa/t5/t4
      t10 = 1.D0+0.4D-2*t8
      t14 = sigmaaa**2
      t15 = t4**2
      t19 = t14/t2/t15/rhoa
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigmaaa/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t49
     #+0.3844746237447211D1*t45+0.1644733775567609D1*t52
     #+0.2405871291288192D0*t54))
      t62 = 1.D0+0.2D0*t8
      t66 = t62**2
      t74 = t66**2
      zk(i) = -0.9305257363491D0*t2*rhoa*(0.108184D1-0.2073356D-2*t8
     #/t10+0.5480992D-4*t19/t20-0.16825664D-6*t27/t20/t10+0.5858688D-9
     #*t36/t37)-0.3109D-1*rhoa*(1.D0+0.1274696188700087D0*t45)*t60*
     #(0.118777D1-0.480584D0*t8/t62+0.2246964D0*t19/t66-0.7343384D-1
     #*t27/t66/t62+0.9996768D-2*t36/t74)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t6 = rhoa**2
      t7 = t4**2
      t10 = sigmaaa/t7/t6
      t12 = 1.D0+0.4D-2*t10
      t16 = sigmaaa**2
      t17 = t6**2
      t21 = t16/t4/t17/rhoa
      t22 = t12**2
      t27 = t17**2
      t29 = t16*sigmaaa/t27
      t34 = t16**2
      t38 = t34/t7/t27/t6
      t39 = t22**2
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t50 = rhoa*(1.D0+0.1274696188700087D0*t47)
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t62 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t51
     #+0.3844746237447211D1*t47+0.1644733775567609D1*t54
     #+0.2405871291288192D0*t56))
      t64 = 1.D0+0.2D0*t10
      t68 = t64**2
      t76 = t68**2
      t84 = rhob**(1.D0/3.D0)
      t86 = rhob**2
      t87 = t84**2
      t90 = sigmabb/t87/t86
      t92 = 1.D0+0.4D-2*t90
      t96 = sigmabb**2
      t97 = t86**2
      t101 = t96/t84/t97/rhob
      t102 = t92**2
      t107 = t97**2
      t109 = t96*sigmabb/t107
      t114 = t96**2
      t118 = t114/t87/t107/t86
      t119 = t102**2
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t130 = rhob*(1.D0+0.1274696188700087D0*t127)
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t142 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t131
     #+0.3844746237447211D1*t127+0.1644733775567609D1*t134
     #+0.2405871291288192D0*t136))
      t144 = 1.D0+0.2D0*t90
      t148 = t144**2
      t156 = t148**2
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t180 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t169
     #+0.2225569421150687D1*t166+0.8004286349993634D0*t172
     #+0.1897004325747559D0*t174))
      t182 = 0.62182D-1*(1.D0+0.1325688999052018D0*t166)*t180
      t193 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t169
     #+0.2247591863577616D1*t166+0.4300972471276643D0*t172
     #+0.1911512595127338D0*t174))
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t211 = t207/t209
      t227 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t169
     #+0.3844746237447211D1*t166+0.1644733775567609D1*t172
     #+0.2405871291288192D0*t174))
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t250 = t243**2
      t251 = t246**2
      t260 = t250**2
      t261 = t251**2
      s1 = -0.9305257363491D0*t4*rhoa*(0.108184D1-0.2073356D-2*t10/t12
     #+0.5480992D-4*t21/t22-0.16825664D-6*t29/t22/t12+0.5858688D-9*t38
     #/t39)-0.3109D-1*t50*t62*(0.118777D1-0.480584D0*t10/t64
     #+0.2246964D0*t21/t68-0.7343384D-1*t29/t68/t64+0.9996768D-2*t38
     #/t76)
      s2 = s1-0.9305257363491D0*t84*rhob*(0.108184D1-0.2073356D-2*t90
     #/t92+0.5480992D-4*t101/t102-0.16825664D-6*t109/t102/t92
     #+0.5858688D-9*t118/t119)
      zk(i) = s2-0.3109D-1*t130*t142*(0.118777D1-0.480584D0*t90/t144
     #+0.2246964D0*t101/t148-0.7343384D-1*t109/t148/t144+0.9996768D-2
     #*t118/t156)+(t164*(-t182+0.3799574853701528D-1*(1.D0
     #+0.6901399211255825D-1*t166)*t193*t205*(1.D0-1.D0*t211)
     #+0.1923661050931536D1*(-0.3109D-1*(1.D0+0.1274696188700087D0
     #*t166)*t227+t182)*t205*t211)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142)*(0.589076D0+0.2654244D-1*t243/t246-0.6919848D-3*t250/t251
     #+0.91955736D-5*t250*t243/t251/t246-0.544387392D-7*t260/t261)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmabb*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmabb**2
      t15 = t4**2
      t16 = t15*rhob
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmabb
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.108184D1-0.2073356D-2*t8*t11+0.5480992D-4*t19*t21
     #-0.16825664D-6*t27*t29+0.5858688D-9*t36*t38
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhob*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.118777D1-0.480584D0*t8*t63+0.2246964D0*t19*t67
     #-0.7343384D-1*t27*t71+0.9996768D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      vrhoa(i) = 0.D0
      t84 = t4*rhob
      t87 = sigmabb/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhob
      t104 = t32/t5/t25/t84
      t111 = t32*sigmabb/t2/t25/t90
      t113 = 1/t37/t10
      t122 = 1/t54
      t126 = t56**2
      t129 = t49**2
      t130 = t129**2
      t133 = 1/t4
      t159 = 1/t74/t62
      vrhob(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*
     #(0.5528949333333333D-2*t87*t11-0.3144353706666667D-3*t93*t21
     #+0.2515331413333333D-5*t98*t29-0.1163347968D-7*t104*t38
     #+0.249970688D-10*t111*t113)-0.3109D-1*t47*t60*t78
     #+0.1321010150222857D-2*t44*t122*t79+0.1D1*t48/t126*(
     #-0.1853395810515781D1/t130/t49*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0/t52*t133-0.1603914194192128D0/t45
     #*t133)/t59*t78-0.3109D-1*t48*t60*(0.1281557333333333D1*t87*t63
     #-0.1454692266666667D1*t93*t67+0.82714688D0*t98*t71-0.224126336D0
     #*t104*t75+0.213264384D-1*t111*t159)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t168 = sigmabb*t18
      t171 = t14*t26
      t174 = t24*t35
      t180 = t32/t2/t25/t16
      vsigmabb(i) = -0.9305257363491D0*t3*(-0.2073356D-2*t7*t11
     #+0.117913264D-3*t168*t21-0.94324928D-6*t171*t29+0.436255488D-8
     #*t174*t38-0.93739008D-11*t180*t113)-0.3109D-1*t48*t60*(
     #-0.480584D0*t7*t63+0.5455096D0*t168*t67-0.31018008D0*t171*t71
     #+0.84047376D-1*t174*t75-0.79974144D-2*t180*t159)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmaaa*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmaaa**2
      t15 = t4**2
      t16 = t15*rhoa
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmaaa
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.108184D1-0.2073356D-2*t8*t11+0.5480992D-4*t19*t21
     #-0.16825664D-6*t27*t29+0.5858688D-9*t36*t38
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhoa*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.118777D1-0.480584D0*t8*t63+0.2246964D0*t19*t67
     #-0.7343384D-1*t27*t71+0.9996768D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      t84 = t4*rhoa
      t87 = sigmaaa/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhoa
      t104 = t32/t5/t25/t84
      t111 = t32*sigmaaa/t2/t25/t90
      t113 = 1/t37/t10
      t122 = 1/t54
      t126 = t56**2
      t129 = t49**2
      t130 = t129**2
      t133 = 1/t4
      t159 = 1/t74/t62
      vrhoa(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*
     #(0.5528949333333333D-2*t87*t11-0.3144353706666667D-3*t93*t21
     #+0.2515331413333333D-5*t98*t29-0.1163347968D-7*t104*t38
     #+0.249970688D-10*t111*t113)-0.3109D-1*t47*t60*t78
     #+0.1321010150222857D-2*t44*t122*t79+0.1D1*t48/t126*(
     #-0.1853395810515781D1/t130/t49*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0/t52*t133-0.1603914194192128D0/t45
     #*t133)/t59*t78-0.3109D-1*t48*t60*(0.1281557333333333D1*t87*t63
     #-0.1454692266666667D1*t93*t67+0.82714688D0*t98*t71-0.224126336D0
     #*t104*t75+0.213264384D-1*t111*t159)
      vrhob(i) = 0.D0
      t168 = sigmaaa*t18
      t171 = t14*t26
      t174 = t24*t35
      t180 = t32/t2/t25/t16
      vsigmaaa(i) = -0.9305257363491D0*t3*(-0.2073356D-2*t7*t11
     #+0.117913264D-3*t168*t21-0.94324928D-6*t171*t29+0.436255488D-8
     #*t174*t38-0.93739008D-11*t180*t113)-0.3109D-1*t48*t60*(
     #-0.480584D0*t7*t63+0.5455096D0*t168*t67-0.31018008D0*t171*t71
     #+0.84047376D-1*t174*t75-0.79974144D-2*t180*t159)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t9 = 1/t7/t6
      t10 = sigmaaa*t9
      t12 = 1.D0+0.4D-2*t10
      t13 = 1/t12
      t16 = sigmaaa**2
      t17 = t6**2
      t18 = t17*rhoa
      t20 = 1/t4/t18
      t21 = t16*t20
      t22 = t12**2
      t23 = 1/t22
      t26 = t16*sigmaaa
      t27 = t17**2
      t28 = 1/t27
      t29 = t26*t28
      t31 = 1/t22/t12
      t34 = t16**2
      t37 = 1/t7/t27/t6
      t38 = t34*t37
      t39 = t22**2
      t40 = 1/t39
      t43 = 0.108184D1-0.2073356D-2*t10*t13+0.5480992D-4*t21*t23
     #-0.16825664D-6*t29*t31+0.5858688D-9*t38*t40
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t49 = 1.D0+0.1274696188700087D0*t47
      t50 = rhoa*t49
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t58 = 0.1112037486309468D2*t51+0.3844746237447211D1*t47
     #+0.1644733775567609D1*t54+0.2405871291288192D0*t56
      t61 = 1.D0+0.321646831778707D2/t58
      t62 = dlog(t61)
      t64 = 1.D0+0.2D0*t10
      t65 = 1/t64
      t68 = t64**2
      t69 = 1/t68
      t73 = 1/t68/t64
      t76 = t68**2
      t77 = 1/t76
      t80 = 0.118777D1-0.480584D0*t10*t65+0.2246964D0*t21*t69
     #-0.7343384D-1*t29*t73+0.9996768D-2*t38*t77
      t81 = t62*t80
      t84 = rhob**(1.D0/3.D0)
      t85 = t84*rhob
      t86 = rhob**2
      t87 = t84**2
      t89 = 1/t87/t86
      t90 = sigmabb*t89
      t92 = 1.D0+0.4D-2*t90
      t93 = 1/t92
      t96 = sigmabb**2
      t97 = t86**2
      t98 = t97*rhob
      t100 = 1/t84/t98
      t101 = t96*t100
      t102 = t92**2
      t103 = 1/t102
      t106 = t96*sigmabb
      t107 = t97**2
      t108 = 1/t107
      t109 = t106*t108
      t111 = 1/t102/t92
      t114 = t96**2
      t117 = 1/t87/t107/t86
      t118 = t114*t117
      t119 = t102**2
      t120 = 1/t119
      t123 = 0.108184D1-0.2073356D-2*t90*t93+0.5480992D-4*t101*t103
     #-0.16825664D-6*t109*t111+0.5858688D-9*t118*t120
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t129 = 1.D0+0.1274696188700087D0*t127
      t130 = rhob*t129
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t138 = 0.1112037486309468D2*t131+0.3844746237447211D1*t127
     #+0.1644733775567609D1*t134+0.2405871291288192D0*t136
      t141 = 1.D0+0.321646831778707D2/t138
      t142 = dlog(t141)
      t144 = 1.D0+0.2D0*t90
      t145 = 1/t144
      t148 = t144**2
      t149 = 1/t148
      t153 = 1/t148/t144
      t156 = t148**2
      t157 = 1/t156
      t160 = 0.118777D1-0.480584D0*t90*t145+0.2246964D0*t101*t149
     #-0.7343384D-1*t109*t153+0.9996768D-2*t118*t157
      t161 = t142*t160
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t168 = 1.D0+0.1325688999052018D0*t166
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t176 = 0.598255043577108D1*t169+0.2225569421150687D1*t166
     #+0.8004286349993634D0*t172+0.1897004325747559D0*t174
      t179 = 1.D0+0.160818243221511D2/t176
      t180 = dlog(t179)
      t182 = 0.62182D-1*t168*t180
      t184 = 1.D0+0.6901399211255825D-1*t166
      t189 = 0.8157414703487641D1*t169+0.2247591863577616D1*t166
     #+0.4300972471276643D0*t172+0.1911512595127338D0*t174
      t192 = 1.D0+0.2960857464321668D2/t189
      t193 = dlog(t192)
      t194 = t184*t193
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t210 = 1/t209
      t211 = t207*t210
      t213 = 1.D0-1.D0*t211
      t216 = 0.3799574853701528D-1*t194*t205*t213
      t218 = 1.D0+0.1274696188700087D0*t166
      t223 = 0.1112037486309468D2*t169+0.3844746237447211D1*t166
     #+0.1644733775567609D1*t172+0.2405871291288192D0*t174
      t226 = 1.D0+0.321646831778707D2/t223
      t227 = dlog(t226)
      t230 = -0.3109D-1*t218*t227+t182
      t231 = t230*t205
      t233 = 0.1923661050931536D1*t231*t211
      t240 = t164*(-t182+t216+t233)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t247 = 1/t246
      t250 = t243**2
      t251 = t246**2
      t252 = 1/t251
      t255 = t250*t243
      t257 = 1/t251/t246
      t260 = t250**2
      t261 = t251**2
      t262 = 1/t261
      t265 = 0.589076D0+0.2654244D-1*t243*t247-0.6919848D-3*t250*t252
     #+0.91955736D-5*t255*t257-0.544387392D-7*t260*t262
      zk(i) = -0.9305257363491D0*t5*t43-0.3109D-1*t50*t81
     #-0.9305257363491D0*t85*t123-0.3109D-1*t130*t161+t240*t265
      t269 = t6*rhoa
      t272 = sigmaaa/t7/t269
      t275 = t17*t6
      t278 = t16/t4/t275
      t283 = t26/t27/rhoa
      t289 = t34/t7/t27/t269
      t296 = t34*sigmaaa/t4/t27/t275
      t298 = 1/t39/t12
      t304 = t49*t62
      t307 = 1/t56
      t308 = t46*t307
      t311 = t58**2
      t312 = 1/t311
      t314 = t51**2
      t315 = t314**2
      t318 = 1/t6
      t329 = -0.1853395810515781D1/t315/t51*t318-0.128158207914907D1
     #*t307*t318-0.8223668877838045D0/t54*t318-0.1603914194192128D0
     #/t47*t318
      t330 = 1/t61
      t344 = 1/t76/t64
      t352 = 1/t208
      t353 = 1/t174*t352
      t354 = t353*t180
      t355 = 0.2747799777968419D-2*t354
      t356 = t176**2
      t359 = t169**2
      t360 = t359**2
      t363 = 1/t360/t169*t352
      t367 = 1/t172*t352
      t370 = 1/t166*t352
      t375 = t168/t356*(-0.99709173929518D0*t363-0.7418564737168958D0
     #*t353-0.4002143174996817D0*t367-0.1264669550498372D0*t370)/t179
      t376 = 0.1D1*t375
      t380 = 0.8740794299481065D-3*t353*t193*t205*t213
      t381 = t189**2
      t394 = 0.1124999956683108D1*t184/t381*(-0.135956911724794D1*t363
     #-0.7491972878592054D0*t353-0.2150486235638321D0*t367
     #-0.1274341730084892D0*t370)/t192*t205*t213
      t395 = t196*t352
      t396 = 1.D0*t395
      t400 = 1.D0*t165
      t404 = 0.1333333333333333D1*t199*(t165-t396)
     #+0.1333333333333333D1*t203*(-t400+t395)
      t409 = t206*t196*t210
      t410 = 4.D0*t409
      t413 = t207/t209/t164
      t414 = 4.D0*t413
      t421 = t223**2
      t438 = 0.1923661050931536D1*(0.1321010150222857D-2*t353*t227
     #+0.1D1*t218/t421*(-0.1853395810515781D1*t363-0.128158207914907D1
     #*t353-0.8223668877838045D0*t367-0.1603914194192128D0*t370)/t226
     #-0.2747799777968419D-2*t354-0.1D1*t375)*t205*t211
      t442 = t231*t409
      t445 = 0.7694644203726145D1*t231*t413
      t459 = t243*t252
      t462 = t250*t257
      t465 = t255*t262
      t470 = t260/t261/t246
      s1 = -0.12407009817988D1*t4*t43-0.9305257363491D0*t5*
     #(0.5528949333333333D-2*t272*t13-0.3144353706666667D-3*t278*t23
     #+0.2515331413333333D-5*t283*t31-0.1163347968D-7*t289*t40
     #+0.249970688D-10*t296*t298)-0.3109D-1*t304*t80
     #+0.1321010150222857D-2*t308*t81
      vrhoa(i) = s1+0.1D1*t50*t312*t329*t330*t80-0.3109D-1*t50*t62*
     #(0.1281557333333333D1*t272*t65-0.1454692266666667D1*t278*t69
     #+0.82714688D0*t283*t73-0.224126336D0*t289*t77+0.213264384D-1
     #*t296*t344)+(-t182+t216+t233+t164*(t355+t376-t380-t394
     #+0.3799574853701528D-1*t194*t404*t213+0.3799574853701528D-1*t194
     #*t205*(-t410+t414)+t438+0.1923661050931536D1*t230*t404*t211
     #+0.7694644203726145D1*t442-t445)+0.3109D-1*t304
     #-0.1321010150222857D-2*t308*t62-0.1D1*t50*t312*t329*t330)*t265
     #+t240*(-0.3538992D-1*t272*t247+0.205763232D-2*t459*t272
     #-0.478540512D-4*t462*t272+0.5110337088D-6*t465*t272
     #-0.17420396544D-8*t470*t272)
      t477 = t86*rhob
      t480 = sigmabb/t87/t477
      t483 = t97*t86
      t486 = t96/t84/t483
      t491 = t106/t107/rhob
      t497 = t114/t87/t107/t477
      t504 = t114*sigmabb/t84/t107/t483
      t506 = 1/t119/t92
      t512 = t129*t142
      t515 = 1/t136
      t516 = t126*t515
      t519 = t138**2
      t520 = 1/t519
      t522 = t131**2
      t523 = t522**2
      t526 = 1/t86
      t537 = -0.1853395810515781D1/t523/t131*t526-0.128158207914907D1
     #*t515*t526-0.8223668877838045D0/t134*t526-0.1603914194192128D0
     #/t127*t526
      t538 = 1/t141
      t552 = 1/t156/t144
      t565 = 0.1333333333333333D1*t199*(-t400-t396)
     #+0.1333333333333333D1*t203*(t165+t395)
      s1 = -0.12407009817988D1*t84*t123-0.9305257363491D0*t85*
     #(0.5528949333333333D-2*t480*t93-0.3144353706666667D-3*t486*t103
     #+0.2515331413333333D-5*t491*t111-0.1163347968D-7*t497*t120
     #+0.249970688D-10*t504*t506)-0.3109D-1*t512*t160
     #+0.1321010150222857D-2*t516*t161
      vrhob(i) = s1+0.1D1*t130*t520*t537*t538*t160-0.3109D-1*t130*t142
     #*(0.1281557333333333D1*t480*t145-0.1454692266666667D1*t486*t149
     #+0.82714688D0*t491*t153-0.224126336D0*t497*t157+0.213264384D-1
     #*t504*t552)+(-t182+t216+t233+t164*(t355+t376-t380-t394
     #+0.3799574853701528D-1*t194*t565*t213+0.3799574853701528D-1*t194
     #*t205*(t410+t414)+t438+0.1923661050931536D1*t230*t565*t211
     #-0.7694644203726145D1*t442-t445)+0.3109D-1*t512
     #-0.1321010150222857D-2*t516*t142-0.1D1*t130*t520*t537*t538)*t265
     #+t240*(-0.3538992D-1*t480*t247+0.205763232D-2*t459*t480
     #-0.478540512D-4*t462*t480+0.5110337088D-6*t465*t480
     #-0.17420396544D-8*t470*t480)
      t602 = sigmaaa*t20
      t605 = t16*t28
      t608 = t26*t37
      t614 = t34/t4/t27/t18
      vsigmaaa(i) = -0.9305257363491D0*t5*(-0.2073356D-2*t9*t13
     #+0.117913264D-3*t602*t23-0.94324928D-6*t605*t31+0.436255488D-8
     #*t608*t40-0.93739008D-11*t614*t298)-0.3109D-1*t50*t62*(
     #-0.480584D0*t9*t65+0.5455096D0*t602*t69-0.31018008D0*t605*t73
     #+0.84047376D-1*t608*t77-0.79974144D-2*t614*t344)+t240*
     #(0.1327122D-1*t9*t247-0.77161212D-3*t459*t9+0.179452692D-4*t462
     #*t9-0.1916376408D-6*t465*t9+0.6532648704D-9*t470*t9)
      vsigmaab(i) = 0.D0
      t648 = sigmabb*t100
      t651 = t96*t108
      t654 = t106*t117
      t660 = t114/t84/t107/t98
      vsigmabb(i) = -0.9305257363491D0*t85*(-0.2073356D-2*t89*t93
     #+0.117913264D-3*t648*t103-0.94324928D-6*t651*t111+0.436255488D-8
     #*t654*t120-0.93739008D-11*t660*t506)-0.3109D-1*t130*t142*(
     #-0.480584D0*t89*t145+0.5455096D0*t648*t149-0.31018008D0*t651
     #*t153+0.84047376D-1*t654*t157-0.79974144D-2*t660*t552)+t240*
     #(0.1327122D-1*t89*t247-0.77161212D-3*t459*t89+0.179452692D-4
     #*t462*t89-0.1916376408D-6*t465*t89+0.6532648704D-9*t470*t89)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmabb*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmabb**2
      t15 = t4**2
      t16 = t15*rhob
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmabb
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.108184D1-0.2073356D-2*t8*t11+0.5480992D-4*t19*t21
     #-0.16825664D-6*t27*t29+0.5858688D-9*t36*t38
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhob*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.118777D1-0.480584D0*t8*t63+0.2246964D0*t19*t67
     #-0.7343384D-1*t27*t71+0.9996768D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      vrhoa(i) = 0.D0
      t84 = t4*rhob
      t87 = sigmabb/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhob
      t104 = t32/t5/t25/t84
      t107 = t32*sigmabb
      t111 = t107/t2/t25/t90
      t113 = 1/t37/t10
      t116 = 0.5528949333333333D-2*t87*t11-0.3144353706666667D-3*t93
     #*t21+0.2515331413333333D-5*t98*t29-0.1163347968D-7*t104*t38
     #+0.249970688D-10*t111*t113
      t119 = t47*t60
      t122 = 1/t54
      t123 = t44*t122
      t126 = t56**2
      t127 = 1/t126
      t128 = t48*t127
      t129 = t49**2
      t130 = t129**2
      t131 = t130*t49
      t132 = 1/t131
      t133 = 1/t4
      t138 = 1/t52
      t141 = 1/t45
      t144 = -0.1853395810515781D1*t132*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0*t138*t133-0.1603914194192128D0*t141
     #*t133
      t145 = 1/t59
      t146 = t144*t145
      t147 = t146*t78
      t159 = 1/t74/t62
      t162 = 0.1281557333333333D1*t87*t63-0.1454692266666667D1*t93*t67
     #+0.82714688D0*t98*t71-0.224126336D0*t104*t75+0.213264384D-1*t111
     #*t159
      t163 = t60*t162
      vrhob(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*t116
     #-0.3109D-1*t119*t78+0.1321010150222857D-2*t123*t79+0.1D1*t128
     #*t147-0.3109D-1*t48*t163
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t168 = sigmabb*t18
      t171 = t14*t26
      t174 = t24*t35
      t179 = 1/t2/t25/t16
      t180 = t32*t179
      vsigmabb(i) = -0.9305257363491D0*t3*(-0.2073356D-2*t7*t11
     #+0.117913264D-3*t168*t21-0.94324928D-6*t171*t29+0.436255488D-8
     #*t174*t38-0.93739008D-11*t180*t113)-0.3109D-1*t48*t60*(
     #-0.480584D0*t7*t63+0.5455096D0*t168*t67-0.31018008D0*t171*t71
     #+0.84047376D-1*t174*t75-0.79974144D-2*t180*t159)
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t207 = sigmabb/t5/t15
      t210 = t15*t84
      t213 = t14/t2/t210
      t217 = t24/t33
      t223 = t32/t5/t25/t15
      t229 = t107/t2/t25/t210
      t233 = t25**2
      t236 = t32*t14/t233/t4
      t238 = 1/t37/t20
      t249 = 1/t84
      t251 = 1/t54/t44
      t263 = t144**2
      t270 = 1/t15
      t296 = t126**2
      t299 = t59**2
      t319 = 1/t74/t66
      s1 = -0.4135669939329333D0/t5*t41-0.24814019635976D1*t2*t116
     #-0.9305257363491D0*t3*(-0.2027281422222222D-1*t207*t11
     #+0.2050399473777778D-2*t213*t21-0.2934593729422222D-4*t217*t29
     #+0.2162145348266667D-6*t223*t38-0.8546531191466667D-9*t229*t113
     #+0.1333177002666667D-11*t236*t238)+0.2D1*t47*t127*t147-0.6218D-1
     #*t119*t162+0.8806734334819047D-3*t249*t251*t79
      v2rhob2(i) = s1-0.8497974591333914D-1*t123*t127*t147
     #+0.2642020300445714D-2*t123*t163-0.2D1*t48/t126/t56*t263*t145
     #*t78+0.1D1*t128*(-0.1544496508763151D1/t131/t44*t270
     #+0.3706791621031562D1*t132*t249-0.854388052766047D0*t251*t270
     #+0.2563164158298141D1*t122*t249-0.4111834438919023D0/t52/t44
     #*t270+0.1644733775567609D1*t138*t249-0.5346380647307093D-1/t45
     #/t44*t270+0.3207828388384256D0*t141*t249)*t145*t78
     #+0.321646831778707D2*t48/t296*t263/t299*t78+0.2D1*t128*t146*t162
     #-0.3109D-1*t48*t60*(-0.4699043555555556D1*t207*t63
     #+0.9896548266666667D1*t213*t67-0.8995993671111111D1*t217*t71
     #+0.3938242261333333D1*t223*t75-0.7838151338666667D0*t229*t159
     #+0.568705024D-1*t236*t319)
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t328 = sigmabb*t26
      t331 = t14*t35
      t334 = t24*t179
      t338 = t32/t233
      v2sigmabb2(i) = -0.9305257363491D0*t3*(0.126206688D-3*t18*t21
     #-0.2829804672D-5*t328*t29+0.24406656D-7*t331*t38
     #-0.10729648128D-9*t334*t113+0.187478016D-12*t338*t238)-0.3109D-1
     #*t48*t60*(0.6416264D0*t18*t67-0.838564D0*t328*t71+0.438250176D0
     #*t331*t75-0.992275584D-1*t334*t159+0.79974144D-2*t338*t319)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmaaa*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmaaa**2
      t15 = t4**2
      t16 = t15*rhoa
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmaaa
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.108184D1-0.2073356D-2*t8*t11+0.5480992D-4*t19*t21
     #-0.16825664D-6*t27*t29+0.5858688D-9*t36*t38
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhoa*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.118777D1-0.480584D0*t8*t63+0.2246964D0*t19*t67
     #-0.7343384D-1*t27*t71+0.9996768D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      t84 = t4*rhoa
      t87 = sigmaaa/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhoa
      t104 = t32/t5/t25/t84
      t107 = t32*sigmaaa
      t111 = t107/t2/t25/t90
      t113 = 1/t37/t10
      t116 = 0.5528949333333333D-2*t87*t11-0.3144353706666667D-3*t93
     #*t21+0.2515331413333333D-5*t98*t29-0.1163347968D-7*t104*t38
     #+0.249970688D-10*t111*t113
      t119 = t47*t60
      t122 = 1/t54
      t123 = t44*t122
      t126 = t56**2
      t127 = 1/t126
      t128 = t48*t127
      t129 = t49**2
      t130 = t129**2
      t131 = t130*t49
      t132 = 1/t131
      t133 = 1/t4
      t138 = 1/t52
      t141 = 1/t45
      t144 = -0.1853395810515781D1*t132*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0*t138*t133-0.1603914194192128D0*t141
     #*t133
      t145 = 1/t59
      t146 = t144*t145
      t147 = t146*t78
      t159 = 1/t74/t62
      t162 = 0.1281557333333333D1*t87*t63-0.1454692266666667D1*t93*t67
     #+0.82714688D0*t98*t71-0.224126336D0*t104*t75+0.213264384D-1*t111
     #*t159
      t163 = t60*t162
      vrhoa(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*t116
     #-0.3109D-1*t119*t78+0.1321010150222857D-2*t123*t79+0.1D1*t128
     #*t147-0.3109D-1*t48*t163
      vrhob(i) = 0.D0
      t168 = sigmaaa*t18
      t171 = t14*t26
      t174 = t24*t35
      t179 = 1/t2/t25/t16
      t180 = t32*t179
      vsigmaaa(i) = -0.9305257363491D0*t3*(-0.2073356D-2*t7*t11
     #+0.117913264D-3*t168*t21-0.94324928D-6*t171*t29+0.436255488D-8
     #*t174*t38-0.93739008D-11*t180*t113)-0.3109D-1*t48*t60*(
     #-0.480584D0*t7*t63+0.5455096D0*t168*t67-0.31018008D0*t171*t71
     #+0.84047376D-1*t174*t75-0.79974144D-2*t180*t159)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t207 = sigmaaa/t5/t15
      t210 = t15*t84
      t213 = t14/t2/t210
      t217 = t24/t33
      t223 = t32/t5/t25/t15
      t229 = t107/t2/t25/t210
      t233 = t25**2
      t236 = t32*t14/t233/t4
      t238 = 1/t37/t20
      t249 = 1/t84
      t251 = 1/t54/t44
      t263 = t144**2
      t270 = 1/t15
      t296 = t126**2
      t299 = t59**2
      t319 = 1/t74/t66
      s1 = -0.4135669939329333D0/t5*t41-0.24814019635976D1*t2*t116
     #-0.9305257363491D0*t3*(-0.2027281422222222D-1*t207*t11
     #+0.2050399473777778D-2*t213*t21-0.2934593729422222D-4*t217*t29
     #+0.2162145348266667D-6*t223*t38-0.8546531191466667D-9*t229*t113
     #+0.1333177002666667D-11*t236*t238)+0.2D1*t47*t127*t147-0.6218D-1
     #*t119*t162+0.8806734334819047D-3*t249*t251*t79
      v2rhoa2(i) = s1-0.8497974591333914D-1*t123*t127*t147
     #+0.2642020300445714D-2*t123*t163-0.2D1*t48/t126/t56*t263*t145
     #*t78+0.1D1*t128*(-0.1544496508763151D1/t131/t44*t270
     #+0.3706791621031562D1*t132*t249-0.854388052766047D0*t251*t270
     #+0.2563164158298141D1*t122*t249-0.4111834438919023D0/t52/t44
     #*t270+0.1644733775567609D1*t138*t249-0.5346380647307093D-1/t45
     #/t44*t270+0.3207828388384256D0*t141*t249)*t145*t78
     #+0.321646831778707D2*t48/t296*t263/t299*t78+0.2D1*t128*t146*t162
     #-0.3109D-1*t48*t60*(-0.4699043555555556D1*t207*t63
     #+0.9896548266666667D1*t213*t67-0.8995993671111111D1*t217*t71
     #+0.3938242261333333D1*t223*t75-0.7838151338666667D0*t229*t159
     #+0.568705024D-1*t236*t319)
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t328 = sigmaaa*t26
      t331 = t14*t35
      t334 = t24*t179
      t338 = t32/t233
      v2sigmaaa2(i) = -0.9305257363491D0*t3*(0.126206688D-3*t18*t21
     #-0.2829804672D-5*t328*t29+0.24406656D-7*t331*t38
     #-0.10729648128D-9*t334*t113+0.187478016D-12*t338*t238)-0.3109D-1
     #*t48*t60*(0.6416264D0*t18*t67-0.838564D0*t328*t71+0.438250176D0
     #*t331*t75-0.992275584D-1*t334*t159+0.79974144D-2*t338*t319)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t9 = 1/t7/t6
      t10 = sigmaaa*t9
      t12 = 1.D0+0.4D-2*t10
      t13 = 1/t12
      t16 = sigmaaa**2
      t17 = t6**2
      t18 = t17*rhoa
      t20 = 1/t4/t18
      t21 = t16*t20
      t22 = t12**2
      t23 = 1/t22
      t26 = t16*sigmaaa
      t27 = t17**2
      t28 = 1/t27
      t29 = t26*t28
      t31 = 1/t22/t12
      t34 = t16**2
      t35 = t27*t6
      t37 = 1/t7/t35
      t38 = t34*t37
      t39 = t22**2
      t40 = 1/t39
      t43 = 0.108184D1-0.2073356D-2*t10*t13+0.5480992D-4*t21*t23
     #-0.16825664D-6*t29*t31+0.5858688D-9*t38*t40
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t49 = 1.D0+0.1274696188700087D0*t47
      t50 = rhoa*t49
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t58 = 0.1112037486309468D2*t51+0.3844746237447211D1*t47
     #+0.1644733775567609D1*t54+0.2405871291288192D0*t56
      t61 = 1.D0+0.321646831778707D2/t58
      t62 = dlog(t61)
      t64 = 1.D0+0.2D0*t10
      t65 = 1/t64
      t68 = t64**2
      t69 = 1/t68
      t73 = 1/t68/t64
      t76 = t68**2
      t77 = 1/t76
      t80 = 0.118777D1-0.480584D0*t10*t65+0.2246964D0*t21*t69
     #-0.7343384D-1*t29*t73+0.9996768D-2*t38*t77
      t81 = t62*t80
      t84 = rhob**(1.D0/3.D0)
      t85 = t84*rhob
      t86 = rhob**2
      t87 = t84**2
      t89 = 1/t87/t86
      t90 = sigmabb*t89
      t92 = 1.D0+0.4D-2*t90
      t93 = 1/t92
      t96 = sigmabb**2
      t97 = t86**2
      t98 = t97*rhob
      t100 = 1/t84/t98
      t101 = t96*t100
      t102 = t92**2
      t103 = 1/t102
      t106 = t96*sigmabb
      t107 = t97**2
      t108 = 1/t107
      t109 = t106*t108
      t111 = 1/t102/t92
      t114 = t96**2
      t115 = t107*t86
      t117 = 1/t87/t115
      t118 = t114*t117
      t119 = t102**2
      t120 = 1/t119
      t123 = 0.108184D1-0.2073356D-2*t90*t93+0.5480992D-4*t101*t103
     #-0.16825664D-6*t109*t111+0.5858688D-9*t118*t120
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t129 = 1.D0+0.1274696188700087D0*t127
      t130 = rhob*t129
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t138 = 0.1112037486309468D2*t131+0.3844746237447211D1*t127
     #+0.1644733775567609D1*t134+0.2405871291288192D0*t136
      t141 = 1.D0+0.321646831778707D2/t138
      t142 = dlog(t141)
      t144 = 1.D0+0.2D0*t90
      t145 = 1/t144
      t148 = t144**2
      t149 = 1/t148
      t153 = 1/t148/t144
      t156 = t148**2
      t157 = 1/t156
      t160 = 0.118777D1-0.480584D0*t90*t145+0.2246964D0*t101*t149
     #-0.7343384D-1*t109*t153+0.9996768D-2*t118*t157
      t161 = t142*t160
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t168 = 1.D0+0.1325688999052018D0*t166
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t176 = 0.598255043577108D1*t169+0.2225569421150687D1*t166
     #+0.8004286349993634D0*t172+0.1897004325747559D0*t174
      t179 = 1.D0+0.160818243221511D2/t176
      t180 = dlog(t179)
      t182 = 0.62182D-1*t168*t180
      t184 = 1.D0+0.6901399211255825D-1*t166
      t189 = 0.8157414703487641D1*t169+0.2247591863577616D1*t166
     #+0.4300972471276643D0*t172+0.1911512595127338D0*t174
      t192 = 1.D0+0.2960857464321668D2/t189
      t193 = dlog(t192)
      t194 = t184*t193
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t210 = 1/t209
      t211 = t207*t210
      t213 = 1.D0-1.D0*t211
      t214 = t205*t213
      t216 = 0.3799574853701528D-1*t194*t214
      t218 = 1.D0+0.1274696188700087D0*t166
      t223 = 0.1112037486309468D2*t169+0.3844746237447211D1*t166
     #+0.1644733775567609D1*t172+0.2405871291288192D0*t174
      t226 = 1.D0+0.321646831778707D2/t223
      t227 = dlog(t226)
      t230 = -0.3109D-1*t218*t227+t182
      t231 = t230*t205
      t233 = 0.1923661050931536D1*t231*t211
      t240 = t164*(-t182+t216+t233)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t247 = 1/t246
      t250 = t243**2
      t251 = t246**2
      t252 = 1/t251
      t255 = t250*t243
      t257 = 1/t251/t246
      t260 = t250**2
      t261 = t251**2
      t262 = 1/t261
      t265 = 0.589076D0+0.2654244D-1*t243*t247-0.6919848D-3*t250*t252
     #+0.91955736D-5*t255*t257-0.544387392D-7*t260*t262
      zk(i) = -0.9305257363491D0*t5*t43-0.3109D-1*t50*t81
     #-0.9305257363491D0*t85*t123-0.3109D-1*t130*t161+t240*t265
      t269 = t6*rhoa
      t271 = 1/t7/t269
      t272 = sigmaaa*t271
      t275 = t17*t6
      t277 = 1/t4/t275
      t278 = t16*t277
      t282 = 1/t27/rhoa
      t283 = t26*t282
      t288 = 1/t7/t27/t269
      t289 = t34*t288
      t292 = t34*sigmaaa
      t295 = 1/t4/t27/t275
      t296 = t292*t295
      t298 = 1/t39/t12
      t301 = 0.5528949333333333D-2*t272*t13-0.3144353706666667D-3*t278
     #*t23+0.2515331413333333D-5*t283*t31-0.1163347968D-7*t289*t40
     #+0.249970688D-10*t296*t298
      t304 = t49*t62
      t307 = 1/t56
      t308 = t46*t307
      t311 = t58**2
      t312 = 1/t311
      t313 = t50*t312
      t314 = t51**2
      t315 = t314**2
      t316 = t315*t51
      t317 = 1/t316
      t318 = 1/t6
      t323 = 1/t54
      t326 = 1/t47
      t329 = -0.1853395810515781D1*t317*t318-0.128158207914907D1*t307
     #*t318-0.8223668877838045D0*t323*t318-0.1603914194192128D0*t326
     #*t318
      t330 = 1/t61
      t331 = t329*t330
      t332 = t331*t80
      t344 = 1/t76/t64
      t347 = 0.1281557333333333D1*t272*t65-0.1454692266666667D1*t278
     #*t69+0.82714688D0*t283*t73-0.224126336D0*t289*t77+0.213264384D-1
     #*t296*t344
      t348 = t62*t347
      t351 = 1/t174
      t352 = 1/t208
      t353 = t351*t352
      t354 = t353*t180
      t355 = 0.2747799777968419D-2*t354
      t356 = t176**2
      t357 = 1/t356
      t358 = t168*t357
      t359 = t169**2
      t360 = t359**2
      t361 = t360*t169
      t362 = 1/t361
      t363 = t362*t352
      t366 = 1/t172
      t367 = t366*t352
      t369 = 1/t166
      t370 = t369*t352
      t372 = -0.99709173929518D0*t363-0.7418564737168958D0*t353
     #-0.4002143174996817D0*t367-0.1264669550498372D0*t370
      t373 = 1/t179
      t375 = t358*t372*t373
      t376 = 0.1D1*t375
      t377 = t193*t205
      t378 = t377*t213
      t379 = t353*t378
      t380 = 0.8740794299481065D-3*t379
      t381 = t189**2
      t382 = 1/t381
      t383 = t184*t382
      t388 = -0.135956911724794D1*t363-0.7491972878592054D0*t353
     #-0.2150486235638321D0*t367-0.1274341730084892D0*t370
      t389 = t383*t388
      t390 = 1/t192
      t391 = t390*t205
      t392 = t391*t213
      t393 = t389*t392
      t394 = 0.1124999956683108D1*t393
      t395 = t196*t352
      t396 = 1.D0*t395
      t397 = t165-t396
      t400 = 1.D0*t165
      t401 = -t400+t395
      t404 = 0.1333333333333333D1*t199*t397+0.1333333333333333D1*t203
     #*t401
      t406 = t194*t404*t213
      t407 = 0.3799574853701528D-1*t406
      t408 = t206*t196
      t409 = t408*t210
      t410 = 4.D0*t409
      t412 = 1/t209/t164
      t413 = t207*t412
      t414 = 4.D0*t413
      t415 = -t410+t414
      t417 = t194*t205*t415
      t418 = 0.3799574853701528D-1*t417
      t421 = t223**2
      t422 = 1/t421
      t423 = t218*t422
      t428 = -0.1853395810515781D1*t363-0.128158207914907D1*t353
     #-0.8223668877838045D0*t367-0.1603914194192128D0*t370
      t429 = 1/t226
      t435 = 0.1321010150222857D-2*t353*t227+0.1D1*t423*t428*t429
     #-0.2747799777968419D-2*t354-0.1D1*t375
      t436 = t435*t205
      t437 = t436*t211
      t438 = 0.1923661050931536D1*t437
      t439 = t230*t404
      t440 = t439*t211
      t441 = 0.1923661050931536D1*t440
      t442 = t231*t409
      t444 = t231*t413
      t445 = 0.7694644203726145D1*t444
      t452 = t312*t329*t330
      t455 = -t182+t216+t233+t164*(t355+t376-t380-t394+t407+t418+t438
     #+t441+0.7694644203726145D1*t442-t445)+0.3109D-1*t304
     #-0.1321010150222857D-2*t308*t62-0.1D1*t50*t452
      t459 = t243*t252
      t462 = t250*t257
      t465 = t255*t262
      t469 = 1/t261/t246
      t470 = t260*t469
      t473 = -0.3538992D-1*t272*t247+0.205763232D-2*t459*t272
     #-0.478540512D-4*t462*t272+0.5110337088D-6*t465*t272
     #-0.17420396544D-8*t470*t272
      vrhoa(i) = -0.12407009817988D1*t4*t43-0.9305257363491D0*t5*t301
     #-0.3109D-1*t304*t80+0.1321010150222857D-2*t308*t81+0.1D1*t313
     #*t332-0.3109D-1*t50*t348+t455*t265+t240*t473
      t477 = t86*rhob
      t479 = 1/t87/t477
      t480 = sigmabb*t479
      t483 = t97*t86
      t485 = 1/t84/t483
      t486 = t96*t485
      t490 = 1/t107/rhob
      t491 = t106*t490
      t496 = 1/t87/t107/t477
      t497 = t114*t496
      t500 = t114*sigmabb
      t503 = 1/t84/t107/t483
      t504 = t500*t503
      t506 = 1/t119/t92
      t509 = 0.5528949333333333D-2*t480*t93-0.3144353706666667D-3*t486
     #*t103+0.2515331413333333D-5*t491*t111-0.1163347968D-7*t497*t120
     #+0.249970688D-10*t504*t506
      t512 = t129*t142
      t515 = 1/t136
      t516 = t126*t515
      t519 = t138**2
      t520 = 1/t519
      t521 = t130*t520
      t522 = t131**2
      t523 = t522**2
      t524 = t523*t131
      t525 = 1/t524
      t526 = 1/t86
      t531 = 1/t134
      t534 = 1/t127
      t537 = -0.1853395810515781D1*t525*t526-0.128158207914907D1*t515
     #*t526-0.8223668877838045D0*t531*t526-0.1603914194192128D0*t534
     #*t526
      t538 = 1/t141
      t539 = t537*t538
      t540 = t539*t160
      t552 = 1/t156/t144
      t555 = 0.1281557333333333D1*t480*t145-0.1454692266666667D1*t486
     #*t149+0.82714688D0*t491*t153-0.224126336D0*t497*t157
     #+0.213264384D-1*t504*t552
      t556 = t142*t555
      t559 = -t400-t396
      t562 = t165+t395
      t565 = 0.1333333333333333D1*t199*t559+0.1333333333333333D1*t203
     #*t562
      t567 = t194*t565*t213
      t568 = 0.3799574853701528D-1*t567
      t569 = t410+t414
      t571 = t194*t205*t569
      t572 = 0.3799574853701528D-1*t571
      t573 = t230*t565
      t574 = t573*t211
      t575 = 0.1923661050931536D1*t574
      t583 = t520*t537*t538
      t586 = -t182+t216+t233+t164*(t355+t376-t380-t394+t568+t572+t438
     #+t575-0.7694644203726145D1*t442-t445)+0.3109D-1*t512
     #-0.1321010150222857D-2*t516*t142-0.1D1*t130*t583
      t598 = -0.3538992D-1*t480*t247+0.205763232D-2*t459*t480
     #-0.478540512D-4*t462*t480+0.5110337088D-6*t465*t480
     #-0.17420396544D-8*t470*t480
      vrhob(i) = -0.12407009817988D1*t84*t123-0.9305257363491D0*t85
     #*t509-0.3109D-1*t512*t160+0.1321010150222857D-2*t516*t161+0.1D1
     #*t521*t540-0.3109D-1*t130*t556+t586*t265+t240*t598
      t602 = sigmaaa*t20
      t605 = t16*t28
      t608 = t26*t37
      t613 = 1/t4/t27/t18
      t614 = t34*t613
      t617 = -0.2073356D-2*t9*t13+0.117913264D-3*t602*t23
     #-0.94324928D-6*t605*t31+0.436255488D-8*t608*t40-0.93739008D-11
     #*t614*t298
      t630 = -0.480584D0*t9*t65+0.5455096D0*t602*t69-0.31018008D0*t605
     #*t73+0.84047376D-1*t608*t77-0.79974144D-2*t614*t344
      t631 = t62*t630
      t644 = 0.1327122D-1*t9*t247-0.77161212D-3*t459*t9+0.179452692D-4
     #*t462*t9-0.1916376408D-6*t465*t9+0.6532648704D-9*t470*t9
      vsigmaaa(i) = -0.9305257363491D0*t5*t617-0.3109D-1*t50*t631+t240
     #*t644
      vsigmaab(i) = 0.D0
      t648 = sigmabb*t100
      t651 = t96*t108
      t654 = t106*t117
      t659 = 1/t84/t107/t98
      t660 = t114*t659
      t663 = -0.2073356D-2*t89*t93+0.117913264D-3*t648*t103
     #-0.94324928D-6*t651*t111+0.436255488D-8*t654*t120-0.93739008D-11
     #*t660*t506
      t676 = -0.480584D0*t89*t145+0.5455096D0*t648*t149-0.31018008D0
     #*t651*t153+0.84047376D-1*t654*t157-0.79974144D-2*t660*t552
      t677 = t142*t676
      t690 = 0.1327122D-1*t89*t247-0.77161212D-3*t459*t89
     #+0.179452692D-4*t462*t89-0.1916376408D-6*t465*t89
     #+0.6532648704D-9*t470*t89
      vsigmabb(i) = -0.9305257363491D0*t85*t663-0.3109D-1*t130*t677
     #+t240*t690
      t696 = sigmaaa/t7/t17
      t699 = t17*t269
      t702 = t16/t4/t699
      t705 = t243*t257
      t710 = t250*t262
      t715 = t255*t469
      t722 = t260/t261/t251
      t739 = t26/t35
      t745 = t34/t7/t27/t17
      t751 = t292/t4/t27/t699
      t755 = t27**2
      t758 = t34*t16/t755/t6
      t760 = 1/t39/t22
      t768 = t49*t312
      t774 = 1/t311/t58
      t776 = t329**2
      t781 = 1/t269
      t783 = 1/t56/t46
      t784 = t781*t783
      t792 = 1/t17
      t813 = -0.1544496508763151D1/t316/t46*t792+0.3706791621031562D1
     #*t317*t781-0.854388052766047D0*t783*t792+0.2563164158298141D1
     #*t307*t781-0.4111834438919023D0/t54/t46*t792
     #+0.1644733775567609D1*t323*t781-0.5346380647307093D-1/t47/t46
     #*t792+0.3207828388384256D0*t326*t781
      t821 = t311**2
      t822 = 1/t821
      t824 = t61**2
      t825 = 1/t824
      t841 = 1/t76/t68
      t848 = 0.2D1*t375
      t849 = 0.5495599555936838D-2*t354
      t851 = 0.1748158859896213D-2*t379
      t852 = 0.2249999913366216D1*t393
      t853 = 0.3847322101863073D1*t437
      t856 = 0.1538928840745229D2*t444
      t877 = 1/t208/t164
      t878 = t351*t877
      t879 = t878*t180
      t880 = 0.5495599555936838D-2*t879
      t883 = 1/t174/t165*t210
      t885 = 0.5827196199654043D-3*t883*t378
      t886 = t883*t180
      t887 = 0.1831866518645613D-2*t886
      t888 = t408*t412
      t889 = t231*t888
      t892 = t435*t404*t211
      t895 = t353*t377*t415
      t898 = 0.1748158859896213D-2*t878*t378
      t901 = t353*t193*t404*t213
      t903 = t199**2
      t904 = 1/t903
      t905 = t397**2
      t908 = 2.D0*t352
      t910 = 2.D0*t196*t877
      t911 = -t908+t910
      t914 = t203**2
      t915 = 1/t914
      t916 = t401**2
      t922 = 0.4444444444444444D0*t904*t905+0.1333333333333333D1*t199
     #*t911+0.4444444444444444D0*t915*t916-0.1333333333333333D1*t203
     #*t911
      t928 = t389*t390*t404*t213
      t932 = t353*t357*t372*t373
      t933 = 0.8837926660346786D-1*t932
      t935 = t389*t391*t415
      t937 = t381**2
      t940 = t388**2
      t942 = t192**2
      t947 = 0.3330964519106732D2*t184/t937*t940/t942*t205*t213
      t950 = 1/t361/t165*t210
      t952 = t362*t877
      t958 = 1/t172/t165*t210
      t960 = t366*t877
      t964 = 1/t166/t165*t210
      t966 = t369*t877
      t971 = 0.1124999956683108D1*t383*(-0.1132974264373283D1*t950
     #+0.271913823449588D1*t952-0.4994648585728036D0*t883
     #+0.1498394575718411D1*t878-0.1075243117819161D0*t958
     #+0.4300972471276643D0*t960-0.4247805766949639D-1*t964
     #+0.2548683460169784D0*t966)*t392
      t972 = -t880-t885+t887-0.6155715362980916D2*t889
     #+0.3847322101863073D1*t892-0.1748158859896213D-2*t895+t898
     #-0.1748158859896213D-2*t901+0.3799574853701528D-1*t194*t922*t213
     #-0.2249999913366216D1*t928-t933-0.2249999913366216D1*t935-t947
     #-t971
      t977 = 0.5176049209143758D-1*t353*t382*t388*t390*t214
      t983 = 0.2249999913366216D1*t184/t381/t189*t940*t392
      t987 = t372**2
      t989 = t168/t356/t176*t987*t373
      t990 = 0.2D1*t989
      t1001 = t358*(-0.8309097827459833D0*t950+0.199418347859036D1
     #*t952-0.4945709824779306D0*t883+0.1483712947433792D1*t878
     #-0.2001071587498409D0*t958+0.8004286349993634D0*t960
     #-0.4215565168327908D-1*t964+0.2529339100996745D0*t966)*t373
      t1002 = 0.1D1*t1001
      t1003 = t356**2
      t1006 = t179**2
      t1009 = t168/t1003*t987/t1006
      t1010 = 0.160818243221511D2*t1009
      t1022 = t428**2
      t1038 = t421**2
      t1041 = t226**2
      t1052 = 0.8806734334819047D-3*t883*t227-0.2642020300445714D-2
     #*t878*t227-0.8497974591333914D-1*t353*t422*t428*t429-0.2D1*t218
     #/t421/t223*t1022*t429+0.1D1*t423*(-0.1544496508763151D1*t950
     #+0.3706791621031562D1*t952-0.854388052766047D0*t883
     #+0.2563164158298141D1*t878-0.4111834438919023D0*t958
     #+0.1644733775567609D1*t960-0.5346380647307093D-1*t964
     #+0.3207828388384256D0*t966)*t429+0.321646831778707D2*t218/t1038
     #*t1022/t1041-0.1831866518645613D-2*t886+0.5495599555936838D-2
     #*t879+0.8837926660346786D-1*t932+0.2D1*t989-0.1D1*t1001
     #-0.160818243221511D2*t1009
      t1055 = 0.1923661050931536D1*t1052*t205*t211
      t1056 = t436*t409
      t1061 = t439*t409
      t1063 = t206*t210
      t1064 = 12.D0*t1063
      t1065 = 32.D0*t888
      t1068 = t207/t209/t208
      t1069 = 20.D0*t1068
      t1075 = 0.3847322101863073D2*t231*t1068
      t1076 = t439*t413
      t1078 = t231*t1063
      t1079 = 0.2308393261117844D2*t1078
      t1084 = 0.1538928840745229D2*t436*t413
      t1085 = t977+t983-t990+t1002+t1010+t1055+0.1538928840745229D2
     #*t1056+0.1923661050931536D1*t230*t922*t211+0.1538928840745229D2
     #*t1061+0.3799574853701528D-1*t194*t205*(-t1064+t1065-t1069)
     #+t1075-0.1538928840745229D2*t1076+t1079+0.7599149707403056D-1
     #*t194*t404*t415-t1084
      t1088 = t848+t849+0.7599149707403056D-1*t417-t851-t852+t853
     #+0.7599149707403056D-1*t406+0.1538928840745229D2*t442-t856
     #+0.3847322101863073D1*t440-0.2D1*t768*t331-0.321646831778707D2
     #*t50*t822*t776*t825-0.1D1*t50*t312*t813*t330
     #-0.8806734334819047D-3*t784*t62+0.8497974591333914D-1*t308*t452
     #+0.2D1*t50*t774*t776*t330+t164*(t972+t1085)
      s1 = 2.D0*t455*t473+t240*(0.12976304D0*t696*t247-0.302662912D-2
     #*t702*t252+0.16053292032D-3*t705*t702-0.754465184D-2*t459*t696
     #-0.3192632064D-5*t710*t702+0.1754648544D-3*t462*t696
     #+0.256439568384D-7*t715*t702-0.18737902656D-5*t465*t696
     #-0.69681586176D-10*t722*t702+0.63874787328D-8*t470*t696)
     #-0.4135669939329333D0/t7*t43-0.24814019635976D1*t4*t301
     #-0.9305257363491D0*t5*(-0.2027281422222222D-1*t696*t13
     #+0.2050399473777778D-2*t702*t23-0.2934593729422222D-4*t739*t31
     #+0.2162145348266667D-6*t745*t40-0.8546531191466667D-9*t751*t298
     #+0.1333177002666667D-11*t758*t760)-0.6218D-1*t304*t347+0.2D1
     #*t768*t332+0.2642020300445714D-2*t308*t348
      v2rhoa2(i) = s1-0.2D1*t50*t774*t776*t330*t80
     #+0.8806734334819047D-3*t784*t81-0.8497974591333914D-1*t308*t312
     #*t332+0.1D1*t313*t813*t330*t80+0.2D1*t313*t331*t347
     #+0.321646831778707D2*t50*t822*t776*t825*t80-0.3109D-1*t50*t62*(
     #-0.4699043555555556D1*t696*t65+0.9896548266666667D1*t702*t69
     #-0.8995993671111111D1*t739*t73+0.3938242261333333D1*t745*t77
     #-0.7838151338666667D0*t751*t344+0.568705024D-1*t758*t841)+t1088
     #*t265
      t1097 = sigmabb/t87/t97
      t1100 = t97*t477
      t1103 = t96/t84/t1100
      t1107 = t106/t115
      t1113 = t114/t87/t107/t97
      t1119 = t500/t84/t107/t1100
      t1123 = t107**2
      t1126 = t114*t96/t1123/t86
      t1128 = 1/t119/t102
      t1139 = t519**2
      t1140 = 1/t1139
      t1142 = t537**2
      t1143 = t141**2
      t1144 = 1/t1143
      t1154 = t559**2
      t1157 = t908+t910
      t1160 = t562**2
      t1166 = 0.4444444444444444D0*t904*t1154+0.1333333333333333D1
     #*t199*t1157+0.4444444444444444D0*t915*t1160-0.1333333333333333D1
     #*t203*t1157
      t1171 = t435*t565*t211
      t1173 = -t880-t885+t887+0.6155715362980916D2*t889+t898-t933-t947
     #-t971+t977+t983-t990+t1002+0.3799574853701528D-1*t194*t1166*t213
     #+0.3847322101863073D1*t1171
      t1184 = t573*t413
      t1186 = t573*t409
      t1189 = t389*t391*t569
      t1194 = t353*t193*t565*t213
      t1197 = t353*t377*t569
      t1201 = t389*t390*t565*t213
      t1203 = 0.7599149707403056D-1*t194*t565*t569
     #+0.1923661050931536D1*t230*t1166*t211+0.3799574853701528D-1*t194
     #*t205*(-t1064-t1065-t1069)-0.1538928840745229D2*t1184+t1010
     #+t1055-0.1538928840745229D2*t1186-0.2249999913366216D1*t1189
     #-0.1538928840745229D2*t1056-0.1748158859896213D-2*t1194
     #-0.1748158859896213D-2*t1197-0.2249999913366216D1*t1201+t1075
     #+t1079-t1084
      t1206 = t129*t520
      t1209 = 1/t477
      t1211 = 1/t136/t126
      t1212 = t1209*t1211
      t1218 = 1/t519/t138
      t1225 = 1/t97
      t1246 = -0.1544496508763151D1/t524/t126*t1225
     #+0.3706791621031562D1*t525*t1209-0.854388052766047D0*t1211*t1225
     #+0.2563164158298141D1*t515*t1209-0.4111834438919023D0/t134/t126
     #*t1225+0.1644733775567609D1*t531*t1209-0.5346380647307093D-1
     #/t127/t126*t1225+0.3207828388384256D0*t534*t1209
      t1255 = t848+t849-t851-t852+t853-0.1538928840745229D2*t442-t856
     #+0.7599149707403056D-1*t567+0.7599149707403056D-1*t571
     #+0.3847322101863073D1*t574+t164*(t1173+t1203)-0.2D1*t1206*t539
     #-0.8806734334819047D-3*t1212*t142+0.8497974591333914D-1*t516
     #*t583+0.2D1*t130*t1218*t1142*t538-0.1D1*t130*t520*t1246*t538
     #-0.321646831778707D2*t130*t1140*t1142*t1144
      t1272 = 1/t156/t148
      s1 = -0.4135669939329333D0/t87*t123-0.24814019635976D1*t84*t509
     #-0.9305257363491D0*t85*(-0.2027281422222222D-1*t1097*t93
     #+0.2050399473777778D-2*t1103*t103-0.2934593729422222D-4*t1107
     #*t111+0.2162145348266667D-6*t1113*t120-0.8546531191466667D-9
     #*t1119*t506+0.1333177002666667D-11*t1126*t1128)-0.6218D-1*t512
     #*t555+0.2D1*t521*t539*t555+0.321646831778707D2*t130*t1140*t1142
     #*t1144*t160+t1255*t265+0.2D1*t1206*t540
      s2 = s1+0.2642020300445714D-2*t516*t556-0.3109D-1*t130*t142*(
     #-0.4699043555555556D1*t1097*t145+0.9896548266666667D1*t1103*t149
     #-0.8995993671111111D1*t1107*t153+0.3938242261333333D1*t1113*t157
     #-0.7838151338666667D0*t1119*t552+0.568705024D-1*t1126*t1272)
     #+0.8806734334819047D-3*t1212*t161
      v2rhob2(i) = s2-0.8497974591333914D-1*t516*t520*t540-0.2D1*t130
     #*t1218*t1142*t538*t160+0.1D1*t521*t1246*t538*t160+2.D0*t586*t598
     #+t240*(0.12976304D0*t1097*t247-0.302662912D-2*t1103*t252
     #+0.16053292032D-3*t705*t1103-0.754465184D-2*t459*t1097
     #-0.3192632064D-5*t710*t1103+0.1754648544D-3*t462*t1097
     #+0.256439568384D-7*t715*t1103-0.18737902656D-5*t465*t1097
     #-0.69681586176D-10*t722*t1103+0.63874787328D-8*t470*t1097)
      t1323 = -t880-t885+t887+0.1923661050931536D1*t892
     #-0.8740794299481065D-3*t895+t898-0.8740794299481065D-3*t901
     #-0.1124999956683108D1*t928-t933-0.1124999956683108D1*t935-t947
     #-t971+t977+t983-t990+t1002+0.1923661050931536D1*t1171
      t1352 = 0.4444444444444444D0*t904*t397*t559+0.2666666666666667D1
     #*t199*t196*t877+0.4444444444444444D0*t915*t401*t562
     #-0.2666666666666667D1*t203*t196*t877
      t1362 = -0.7694644203726145D1*t1184+t1010+t1055
     #+0.7694644203726145D1*t1186-0.1124999956683108D1*t1189
     #+0.3799574853701528D-1*t194*t205*(t1064-t1069)
     #-0.7694644203726145D1*t1061-0.8740794299481065D-3*t1194
     #-0.8740794299481065D-3*t1197-0.1124999956683108D1*t1201
     #+0.3799574853701528D-1*t194*t404*t569+t1075-0.7694644203726145D1
     #*t1076-0.2308393261117844D2*t1078-t1084+0.3799574853701528D-1
     #*t194*t1352*t213+0.3799574853701528D-1*t194*t565*t415
     #+0.1923661050931536D1*t230*t1352*t211
      t1365 = t849+t848-t851-t852+t568+t572+t853+t575-t856+t407+t418
     #+t441+t164*(t1323+t1362)
      t1375 = t271*sigmabb*t479
      v2rhoab(i) = t1365*t265+t455*t598+t586*t473+t240*(
     #-0.302662912D-2*t272*t252*sigmabb*t479+0.16053292032D-3*t705
     #*sigmaaa*t1375-0.3192632064D-5*t710*sigmaaa*t1375
     #+0.256439568384D-7*t715*sigmaaa*t1375-0.69681586176D-10*t722
     #*sigmaaa*t1375)
      t1393 = sigmaaa*t277
      t1396 = t16*t282
      t1399 = t26*t288
      t1402 = t34*t295
      t1407 = t292/t755/rhoa
      s1 = -0.12407009817988D1*t4*t617-0.9305257363491D0*t5*
     #(0.5528949333333333D-2*t271*t13-0.6509865386666667D-3*t1393*t23
     #+0.1006147720533333D-4*t1396*t31-0.7671789568D-7*t1399*t40
     #+0.31112101888D-9*t1402*t298-0.499941376D-12*t1407*t760)
     #-0.3109D-1*t304*t630+0.1321010150222857D-2*t308*t631
      v2rhoasigmaaa(i) = s1+0.1D1*t313*t331*t630-0.3109D-1*t50*t62*
     #(0.1281557333333333D1*t271*t65-0.3165696D1*t1393*t69
     #+0.3063317546666667D1*t1396*t73-0.1392793472D1*t1399*t77
     #+0.2859332608D0*t1402*t344-0.213264384D-1*t1407*t841)+t455*t644
     #+t240*(-0.3538992D-1*t271*t247+0.113498592D-2*t1393*t252
     #-0.6019984512D-4*t705*t1393+0.205763232D-2*t459*t271
     #+0.1197237024D-5*t710*t1393-0.478540512D-4*t462*t271
     #-0.96164838144D-8*t715*t1393+0.5110337088D-6*t465*t271
     #+0.26130594816D-10*t722*t1393-0.17420396544D-8*t470*t271)
      v2rhoasigmaab(i) = 0.D0
      t1463 = t272*t89
      v2rhoasigmabb(i) = t455*t690+t240*(0.113498592D-2*t272*t252*t89
     #-0.6019984512D-4*t705*t1463+0.1197237024D-5*t710*t1463
     #-0.96164838144D-8*t715*t1463+0.26130594816D-10*t722*t1463)
      t1475 = t252*t9
      t1478 = t480*t9
      v2rhobsigmaaa(i) = t586*t644+t240*(0.113498592D-2*t480*t1475
     #-0.6019984512D-4*t705*t1478+0.1197237024D-5*t710*t1478
     #-0.96164838144D-8*t715*t1478+0.26130594816D-10*t722*t1478)
      v2rhobsigmaab(i) = 0.D0
      t1493 = sigmabb*t485
      t1496 = t96*t490
      t1499 = t106*t496
      t1502 = t114*t503
      t1507 = t500/t1123/rhob
      s1 = -0.12407009817988D1*t84*t663-0.9305257363491D0*t85*
     #(0.5528949333333333D-2*t479*t93-0.6509865386666667D-3*t1493*t103
     #+0.1006147720533333D-4*t1496*t111-0.7671789568D-7*t1499*t120
     #+0.31112101888D-9*t1502*t506-0.499941376D-12*t1507*t1128)
     #-0.3109D-1*t512*t676+0.1321010150222857D-2*t516*t677
      v2rhobsigmabb(i) = s1+0.1D1*t521*t539*t676-0.3109D-1*t130*t142*
     #(0.1281557333333333D1*t479*t145-0.3165696D1*t1493*t149
     #+0.3063317546666667D1*t1496*t153-0.1392793472D1*t1499*t157
     #+0.2859332608D0*t1502*t552-0.213264384D-1*t1507*t1272)+t586*t690
     #+t240*(-0.3538992D-1*t479*t247+0.113498592D-2*t1493*t252
     #-0.6019984512D-4*t705*t1493+0.205763232D-2*t459*t479
     #+0.1197237024D-5*t710*t1493-0.478540512D-4*t462*t479
     #-0.96164838144D-8*t715*t1493+0.5110337088D-6*t465*t479
     #+0.26130594816D-10*t722*t1493-0.17420396544D-8*t470*t479)
      t1561 = sigmaaa*t28
      t1564 = t16*t37
      t1567 = t26*t613
      t1571 = t34/t755
      v2sigmaaa2(i) = -0.9305257363491D0*t5*(0.126206688D-3*t20*t23
     #-0.2829804672D-5*t1561*t31+0.24406656D-7*t1564*t40
     #-0.10729648128D-9*t1567*t298+0.187478016D-12*t1571*t760)
     #-0.3109D-1*t50*t62*(0.6416264D0*t20*t69-0.838564D0*t1561*t73
     #+0.438250176D0*t1564*t77-0.992275584D-1*t1567*t344+0.79974144D-2
     #*t1571*t841)+t240*(-0.42561972D-3*t20*t252+0.2257494192D-4*t705
     #*t20-0.448963884D-6*t710*t20+0.36061814304D-8*t715*t20
     #-0.9798973056D-11*t722*t20)
      v2sigmaaaab(i) = 0.D0
      t1605 = t9*t89
      v2sigmaaabb(i) = t240*(-0.42561972D-3*t1475*t89+0.2257494192D-4
     #*t705*t1605-0.448963884D-6*t710*t1605+0.36061814304D-8*t715
     #*t1605-0.9798973056D-11*t722*t1605)
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t1617 = sigmabb*t108
      t1620 = t96*t117
      t1623 = t106*t659
      t1627 = t114/t1123
      v2sigmabb2(i) = -0.9305257363491D0*t85*(0.126206688D-3*t100*t103
     #-0.2829804672D-5*t1617*t111+0.24406656D-7*t1620*t120
     #-0.10729648128D-9*t1623*t506+0.187478016D-12*t1627*t1128)
     #-0.3109D-1*t130*t142*(0.6416264D0*t100*t149-0.838564D0*t1617
     #*t153+0.438250176D0*t1620*t157-0.992275584D-1*t1623*t552
     #+0.79974144D-2*t1627*t1272)+t240*(-0.42561972D-3*t100*t252
     #+0.2257494192D-4*t705*t100-0.448963884D-6*t710*t100
     #+0.36061814304D-8*t715*t100-0.9798973056D-11*t722*t100)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_xc_hcth407
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     A.D. Boese, N.C. Handy
c     A new parametriztion of exchange-correlation generalized gradient
c     approximation functionals
c     J. Chem. Phys. 114 (2001) 5497-5503.
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t4 = rho**2
      t5 = t2**2
      t8 = sigma/t5/t4
      t10 = 1.D0+0.6349604207872798D-2*t8
      t14 = sigma**2
      t15 = t4**2
      t19 = t14/t2/t15/rho
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigma/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t48 = rho*(1.D0+0.1606016560364007D0*t45)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1248219874679732D2*t49
     #+0.4844076716063854D1*t45+0.2326004811900819D1*t52
     #+0.3819082618690966D0*t54))
      t62 = 1.D0+0.3174802103936399D0*t8
      t66 = t62**2
      t74 = t66**2
      t93 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t49
     #+0.2225569421150687D1*t45+0.8004286349993634D0*t52
     #+0.1897004325747559D0*t54))
      t100 = 1.D0+0.9524406311809197D-2*t8
      t104 = t100**2
      t112 = t104**2
      zk(i) = -0.7385587663820224D0*t2*rho*(0.108184D1
     #-0.3291247495504578D-2*t8/t10+0.138112343902108D-3*t19/t20
     #-0.67302656D-6*t27/t20/t10+0.3720034997741387D-8*t36/t37)
     #-0.3109D-1*t48*t60*(0.118777D1-0.7628795471590852D0*t8/t62
     #+0.5661994483911968D0*t19/t66-0.29373536D0*t27/t66/t62
     #+0.6347552015792813D-1*t36/t74)+(-0.62182D-1*rho*(1.D0
     #+0.1325688999052018D0*t45)*t93+0.3109D-1*t48*t60)*(0.589076D0
     #+0.4213349717780282D-1*t8/t100-0.1743692431454588D-2*t19/t104
     #+0.367822944D-4*t27/t104/t100-0.3456644474956098D-6*t36/t112)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigma*t7
      t10 = 1.D0+0.6349604207872798D-2*t8
      t11 = 1/t10
      t14 = sigma**2
      t15 = t4**2
      t16 = t15*rho
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigma
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.108184D1-0.3291247495504578D-2*t8*t11
     #+0.138112343902108D-3*t19*t21-0.67302656D-6*t27*t29
     #+0.3720034997741387D-8*t36*t38
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1606016560364007D0*t45
      t48 = rho*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1248219874679732D2*t49+0.4844076716063854D1*t45
     #+0.2326004811900819D1*t52+0.3819082618690966D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.3174802103936399D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.118777D1-0.7628795471590852D0*t8*t63
     #+0.5661994483911968D0*t19*t67-0.29373536D0*t27*t71
     #+0.6347552015792813D-1*t36*t75
      t79 = t60*t78
      t83 = 1.D0+0.1325688999052018D0*t45
      t89 = 0.598255043577108D1*t49+0.2225569421150687D1*t45
     #+0.8004286349993634D0*t52+0.1897004325747559D0*t54
      t92 = 1.D0+0.160818243221511D2/t89
      t93 = dlog(t92)
      t98 = -0.62182D-1*rho*t83*t93+0.3109D-1*t48*t60
      t100 = 1.D0+0.9524406311809197D-2*t8
      t101 = 1/t100
      t104 = t100**2
      t105 = 1/t104
      t109 = 1/t104/t100
      t112 = t104**2
      t113 = 1/t112
      t116 = 0.589076D0+0.4213349717780282D-1*t8*t101
     #-0.1743692431454588D-2*t19*t105+0.367822944D-4*t27*t109
     #-0.3456644474956098D-6*t36*t113
      zk(i) = -0.7385587663820224D0*t3*t41-0.3109D-1*t48*t79+t98*t116
      t120 = t4*rho
      t123 = sigma/t5/t120
      t126 = t15*t4
      t129 = t14/t2/t126
      t134 = t24/t25/rho
      t140 = t32/t5/t25/t120
      t147 = t32*sigma/t2/t25/t126
      t149 = 1/t37/t10
      t155 = t47*t60
      t158 = 1/t54
      t159 = t44*t158
      t162 = t56**2
      t163 = 1/t162
      t165 = t49**2
      t166 = t165**2
      t169 = 1/t4
      t170 = 1/t166/t49*t169
      t172 = t158*t169
      t175 = 1/t52*t169
      t178 = 1/t45*t169
      t180 = -0.4160732915599108D1*t170-0.3229384477375903D1*t172
     #-0.2326004811900819D1*t175-0.5092110158254621D0*t178
      t181 = 1/t59
      t195 = 1/t74/t62
      t206 = t89**2
      t238 = 1/t112/t100
      s1 = -0.9847450218426965D0*t2*t41-0.3692793831910112D0*t3*
     #(0.1755331997602442D-1*t123*t11-0.1584654969337721D-2*t129*t21
     #+0.2012265130666667D-4*t134*t29-0.1477359830566614D-6*t140*t38
     #+0.503909330668646D-9*t147*t149)-0.3109D-1*t155*t78
     #+0.1664368495390566D-2*t159*t79
      vrhoa(i) = s1+0.5D0*t48*t163*t180*t181*t78-0.15545D-1*t48*t60*
     #(0.4068690918181788D1*t123*t63-0.7331189631570478D1*t129*t67
     #+0.661717504D1*t134*t71-0.2846227052321425D1*t140*t75
     #+0.4299140585511414D0*t147*t195)+(-0.62182D-1*t83*t93+rho*
     #(0.2747799777968419D-2*t172*t93+0.1D1*t83/t206*(
     #-0.99709173929518D0*t170-0.7418564737168958D0*t172
     #-0.4002143174996817D0*t175-0.1264669550498372D0*t178)/t92)
     #+0.3109D-1*t155-0.1664368495390566D-2*t159*t60-0.5D0*t48*t163
     #*t180*t181)*t116+t98*(-0.1123559924741408D0*t123*t101
     #+0.1036981709164809D-1*t129*t105-0.3828324096D-3*t134*t109
     #+0.6489723575522644D-5*t140*t113-0.351173188852824D-7*t147*t238)
      t245 = sigma*t18
      t248 = t14*t26
      t251 = t24*t35
      t257 = t32/t2/t25/t16
      vsigmaaa(i) = -0.7385587663820224D0*t3*(-0.1316498998201831D-1
     #*t7*t11+0.1188491227003291D-2*t245*t21-0.1509198848D-4*t248*t29
     #+0.110801987292496D-6*t251*t38-0.3779319980014845D-9*t257*t149)
     #-0.3109D-1*t48*t60*(-0.3051518188636341D1*t7*t63
     #+0.5498392223677858D1*t245*t67-0.496288128D1*t248*t71
     #+0.2134670289241069D1*t251*t75-0.3224355439133561D0*t257*t195)
     #+2.D0*t98*(0.8426699435560563D-1*t7*t101-0.7777362818736071D-2
     #*t245*t105+0.2871243072D-3*t248*t109-0.4867292681641983D-5*t251
     #*t113+0.263379891639618D-7*t257*t238)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigma*t7
      t10 = 1.D0+0.6349604207872798D-2*t8
      t11 = 1/t10
      t14 = sigma**2
      t15 = t4**2
      t16 = t15*rho
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigma
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.108184D1-0.3291247495504578D-2*t8*t11
     #+0.138112343902108D-3*t19*t21-0.67302656D-6*t27*t29
     #+0.3720034997741387D-8*t36*t38
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1606016560364007D0*t45
      t48 = rho*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1248219874679732D2*t49+0.4844076716063854D1*t45
     #+0.2326004811900819D1*t52+0.3819082618690966D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.3174802103936399D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.118777D1-0.7628795471590852D0*t8*t63
     #+0.5661994483911968D0*t19*t67-0.29373536D0*t27*t71
     #+0.6347552015792813D-1*t36*t75
      t79 = t60*t78
      t83 = 1.D0+0.1325688999052018D0*t45
      t89 = 0.598255043577108D1*t49+0.2225569421150687D1*t45
     #+0.8004286349993634D0*t52+0.1897004325747559D0*t54
      t92 = 1.D0+0.160818243221511D2/t89
      t93 = dlog(t92)
      t98 = -0.62182D-1*rho*t83*t93+0.3109D-1*t48*t60
      t100 = 1.D0+0.9524406311809197D-2*t8
      t101 = 1/t100
      t104 = t100**2
      t105 = 1/t104
      t109 = 1/t104/t100
      t112 = t104**2
      t113 = 1/t112
      t116 = 0.589076D0+0.4213349717780282D-1*t8*t101
     #-0.1743692431454588D-2*t19*t105+0.367822944D-4*t27*t109
     #-0.3456644474956098D-6*t36*t113
      zk(i) = -0.7385587663820224D0*t3*t41-0.3109D-1*t48*t79+t98*t116
      t120 = t4*rho
      t122 = 1/t5/t120
      t123 = sigma*t122
      t126 = t15*t4
      t128 = 1/t2/t126
      t129 = t14*t128
      t133 = 1/t25/rho
      t134 = t24*t133
      t139 = 1/t5/t25/t120
      t140 = t32*t139
      t143 = t32*sigma
      t146 = 1/t2/t25/t126
      t147 = t143*t146
      t149 = 1/t37/t10
      t152 = 0.1755331997602442D-1*t123*t11-0.1584654969337721D-2*t129
     #*t21+0.2012265130666667D-4*t134*t29-0.1477359830566614D-6*t140
     #*t38+0.503909330668646D-9*t147*t149
      t155 = t47*t60
      t158 = 1/t54
      t159 = t44*t158
      t162 = t56**2
      t163 = 1/t162
      t164 = t48*t163
      t165 = t49**2
      t166 = t165**2
      t167 = t166*t49
      t168 = 1/t167
      t169 = 1/t4
      t170 = t168*t169
      t172 = t158*t169
      t174 = 1/t52
      t175 = t174*t169
      t177 = 1/t45
      t178 = t177*t169
      t180 = -0.4160732915599108D1*t170-0.3229384477375903D1*t172
     #-0.2326004811900819D1*t175-0.5092110158254621D0*t178
      t181 = 1/t59
      t182 = t180*t181
      t183 = t182*t78
      t195 = 1/t74/t62
      t198 = 0.4068690918181788D1*t123*t63-0.7331189631570478D1*t129
     #*t67+0.661717504D1*t134*t71-0.2846227052321425D1*t140*t75
     #+0.4299140585511414D0*t147*t195
      t199 = t60*t198
      t204 = t172*t93
      t206 = t89**2
      t207 = 1/t206
      t208 = t83*t207
      t213 = -0.99709173929518D0*t170-0.7418564737168958D0*t172
     #-0.4002143174996817D0*t175-0.1264669550498372D0*t178
      t214 = 1/t92
      t216 = t208*t213*t214
      t224 = t163*t180*t181
      t227 = -0.62182D-1*t83*t93+rho*(0.2747799777968419D-2*t204+0.1D1
     #*t216)+0.3109D-1*t155-0.1664368495390566D-2*t159*t60-0.5D0*t48
     #*t224
      t230 = 0.1123559924741408D0*t123*t101
      t232 = 0.1036981709164809D-1*t129*t105
      t234 = 0.3828324096D-3*t134*t109
      t235 = t140*t113
      t238 = 1/t112/t100
      t240 = 0.351173188852824D-7*t147*t238
      t241 = -t230+t232-t234+0.6489723575522644D-5*t235-t240
      vrhoa(i) = -0.9847450218426965D0*t2*t41-0.3692793831910112D0*t3
     #*t152-0.3109D-1*t155*t78+0.1664368495390566D-2*t159*t79+0.5D0
     #*t164*t183-0.15545D-1*t48*t199+t227*t116+t98*t241
      t245 = sigma*t18
      t248 = t14*t26
      t251 = t24*t35
      t256 = 1/t2/t25/t16
      t257 = t32*t256
      t260 = -0.1316498998201831D-1*t7*t11+0.1188491227003291D-2*t245
     #*t21-0.1509198848D-4*t248*t29+0.110801987292496D-6*t251*t38
     #-0.3779319980014845D-9*t257*t149
      t273 = -0.3051518188636341D1*t7*t63+0.5498392223677858D1*t245
     #*t67-0.496288128D1*t248*t71+0.2134670289241069D1*t251*t75
     #-0.3224355439133561D0*t257*t195
      t274 = t60*t273
      t287 = 0.8426699435560563D-1*t7*t101-0.7777362818736071D-2*t245
     #*t105+0.2871243072D-3*t248*t109-0.4867292681641983D-5*t251*t113
     #+0.263379891639618D-7*t257*t238
      vsigmaaa(i) = -0.7385587663820224D0*t3*t260-0.3109D-1*t48*t274
     #+2.D0*t98*t287
      t294 = sigma/t5/t15
      t297 = t15*t120
      t300 = t14/t2/t297
      t301 = t300*t105
      t304 = t24/t33
      t305 = t304*t109
      t310 = t32/t5/t25/t15
      t311 = t310*t113
      t316 = t143/t2/t25/t297
      t317 = t316*t238
      t320 = t25**2
      t323 = t32*t14/t320/t4
      t325 = 1/t112/t104
      t327 = 0.4459621515264D-8*t323*t325
      t330 = t47*t163
      t346 = 1/t37/t20
      t357 = t162**2
      t358 = 1/t357
      t360 = t180**2
      t361 = t59**2
      t362 = 1/t361
      t381 = 1/t74/t66
      t390 = 1/t15
      t391 = 1/t167/t44*t390
      t393 = 1/t120
      t394 = t168*t393
      t397 = 1/t54/t44
      t398 = t397*t390
      t400 = t158*t393
      t404 = 1/t52/t44*t390
      t406 = t174*t393
      t410 = 1/t45/t44*t390
      t412 = t177*t393
      t414 = -0.6934554859331846D1*t391+0.1664293166239643D2*t394
     #-0.4305845969834537D1*t398+0.1291753790950361D2*t400
     #-0.2326004811900819D1*t404+0.9304019247603276D1*t406
     #-0.3394740105503081D0*t410+0.2036844063301848D1*t412
      t419 = t393*t397
      t426 = 1/t162/t56
      t452 = 0.5495599555936838D-2*t204
      t453 = 0.2D1*t216
      t457 = t213**2
      t460 = 0.2D1*t83/t206/t89*t457*t214
      t472 = 0.1D1*t208*(-0.8309097827459833D0*t391
     #+0.199418347859036D1*t394-0.4945709824779306D0*t398
     #+0.1483712947433792D1*t400-0.2001071587498409D0*t404
     #+0.8004286349993634D0*t406-0.4215565168327908D-1*t410
     #+0.2529339100996745D0*t412)*t214
      t473 = t206**2
      t476 = t92**2
      t480 = 0.160818243221511D2*t83/t473*t457/t476
      t482 = 0.1831866518645613D-2*t398*t93
      t484 = 0.5495599555936838D-2*t400*t93
      t495 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t49
     #+0.2247591863577616D1*t45+0.4300972471276643D0*t52
     #+0.1911512595127338D0*t54))
      t497 = (1.D0+0.6901399211255825D-1*t45)*t495*t169
      t502 = 0.8837926660346786D-1*t172*t207*t213*t214
      s1 = 3.D0*t227*t241+t98*(0.8239439448103662D0*t294*t101
     #-0.1065518352468551D0*t301+0.537596439552D-2*t305
     #-0.1286791061715555D-3*t311+0.1291426557904201D-5*t317-t327)
     #+0.2D1*t330*t183-0.6218D-1*t155*t198-0.3692793831910112D0*t3*(
     #-0.1287243464908457D0*t294*t11+0.2066673166164795D-1*t300*t21
     #-0.4695349967075556D-3*t304*t29+0.5491506880554649D-5*t310*t38
     #-0.3445745456547828D-7*t316*t149+0.8532332817066667D-10*t323
     #*t346)-0.6564966812284644D0/t5*t41-0.1969490043685393D1*t2*t152
     #+0.1608234158893535D2*t48*t358*t360*t362*t78+0.1D1*t164*t182*t198
      s2 = s1-0.15545D-1*t48*t60*(-0.2983706673333311D2*t294*t63
     #+0.9975095585979163D2*t300*t67-0.1439358987377778D3*t304*t71
     #+0.1000251185367385D3*t310*t75-0.31601445964313D2*t316*t195
     #+0.36397121536D1*t323*t381)+0.5D0*t164*t414*t181*t78
     #+0.2219157993854088D-2*t419*t79-0.1070677706909338D0*t159*t163
     #*t183
      v2rhoa2(i) = s2-0.1D1*t48*t426*t360*t181*t78
     #+0.3328736990781132D-2*t159*t199+(-0.2D1*t330*t182+0.1D1*t48
     #*t426*t360*t181-0.2219157993854088D-2*t419*t60
     #+0.1070677706909338D0*t159*t224-0.1608234158893535D2*t48*t358
     #*t360*t362-0.5D0*t48*t163*t414*t181+t452+t453+rho*(-t460+t472
     #+t480+t482-t484+0.3377399869956914D-1*t497-t502))*t116+(t452
     #+t453+rho*(-t460+t472+t480+t482-t484-0.3377399869956914D-1*t497
     #-t502))*t116+t227*(-t230+t232-t234+0.6489723575522644D-5*t235
     #-t240)+t98*(-0.3050650990810237D-1*t301+0.256852672512D-2*t305
     #-0.8108779995105606D-4*t311+0.1033899552745464D-5*t317-t327)
      t525 = sigma*t128
      t528 = t14*t133
      t531 = t24*t139
      t534 = t32*t146
      t539 = t143/t320/rho
      t572 = t525*t105
      t574 = t528*t109
      t576 = t531*t113
      t578 = t534*t238
      t581 = 0.3344716136448D-8*t539*t325
      s1 = -0.9847450218426965D0*t2*t260-0.3692793831910112D0*t3*
     #(0.7021327990409767D-1*t122*t11-0.1312306629222938D-1*t525*t21
     #+0.3219672705706667D-3*t528*t29-0.3897026185830995D-5*t531*t38
     #+0.2508722692810574D-7*t534*t149-0.63992496128D-10*t539*t346)
     #-0.3109D-1*t155*t273+0.1664368495390566D-2*t159*t274
      v2rhoasigmaaa(i) = s1+0.5D0*t164*t182*t273-0.15545D-1*t48*t60*
     #(0.1627476367272715D2*t122*t63-0.6381643244748801D2*t525*t67
     #+0.9802616149333333D2*t528*t71-0.7074949832407171D2*t531*t75
     #+0.2305621338540804D2*t534*t195-0.27297841152D1*t539*t381)+2.D0
     #*t227*t287+t98*(-0.4494239698965634D0*t122*t101
     #+0.6435915079766915D-1*t572-0.345772468224D-2*t574
     #+0.8677474426538262D-4*t576-0.9158939401002274D-6*t578+t581)+t98
     #*(0.2287988243107678D-1*t572-0.192639504384D-2*t574
     #+0.6081584996329205D-4*t576-0.7754246645590978D-6*t578+t581)
      t592 = sigma*t26
      t595 = t14*t35
      t598 = t24*t256
      t602 = t32/t320
      v2sigmaaa2(i) = -0.7385587663820224D0*t3*(0.508833481115887D-2
     #*t18*t21-0.181107499008D-3*t592*t29+0.2479561690203262D-5*t595
     #*t38-0.1730369220407337D-7*t598*t149+0.47994372096D-10*t602*t346
     #)-0.3109D-1*t48*t60*(0.2586875544090457D2*t18*t67-0.53668096D2
     #*t592*t71+0.4452344258608951D2*t595*t75-0.160024178634026D2*t598
     #*t195+0.20473380864D1*t602*t381)+4.D0*t98*(
     #-0.1715991182330758D-1*t18*t105+0.144479628288D-2*t592*t109
     #-0.4561188747246904D-4*t595*t113+0.5815684984193233D-6*t598*t238
     #-0.2508537102336D-8*t602*t325)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:XC_HCTH407subrend
c:XC_HCTH147subrstart

c    Generated: Sat May  8 19:27:08 GMT 2004

      subroutine uks_xc_hcth147
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     A.D. Boese, N.L. Doltsinis, N.C. Handy, M. Sprik
c     New generalized gradient approximation functionals
c     J. Chem. Phys. 112 (2000) 1670-1678.
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t4 = rhob**2
      t5 = t2**2
      t8 = sigmabb/t5/t4
      t10 = 1.D0+0.4D-2*t8
      t14 = sigmabb**2
      t15 = t4**2
      t19 = t14/t2/t15/rhob
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigmabb/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t49
     #+0.3844746237447211D1*t45+0.1644733775567609D1*t52
     #+0.2405871291288192D0*t54))
      t62 = 1.D0+0.2D0*t8
      t66 = t62**2
      t74 = t66**2
      zk(i) = -0.9305257363491D0*t2*rhob*(0.109025D1-0.3196776D-2*t8
     #/t10+0.8915392D-4*t19/t20-0.3755264D-6*t27/t20/t10+0.77963264D-9
     #*t36/t37)-0.3109D-1*rhob*(1.D0+0.1274696188700087D0*t45)*t60*
     #(0.562576D0+0.342872D-2*t8/t62-0.522544D-1*t19/t66+0.845976D-2
     #*t27/t66/t62+0.14166864D-2*t36/t74)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t4 = rhoa**2
      t5 = t2**2
      t8 = sigmaaa/t5/t4
      t10 = 1.D0+0.4D-2*t8
      t14 = sigmaaa**2
      t15 = t4**2
      t19 = t14/t2/t15/rhoa
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigmaaa/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t49
     #+0.3844746237447211D1*t45+0.1644733775567609D1*t52
     #+0.2405871291288192D0*t54))
      t62 = 1.D0+0.2D0*t8
      t66 = t62**2
      t74 = t66**2
      zk(i) = -0.9305257363491D0*t2*rhoa*(0.109025D1-0.3196776D-2*t8
     #/t10+0.8915392D-4*t19/t20-0.3755264D-6*t27/t20/t10+0.77963264D-9
     #*t36/t37)-0.3109D-1*rhoa*(1.D0+0.1274696188700087D0*t45)*t60*
     #(0.562576D0+0.342872D-2*t8/t62-0.522544D-1*t19/t66+0.845976D-2
     #*t27/t66/t62+0.14166864D-2*t36/t74)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t6 = rhoa**2
      t7 = t4**2
      t10 = sigmaaa/t7/t6
      t12 = 1.D0+0.4D-2*t10
      t16 = sigmaaa**2
      t17 = t6**2
      t21 = t16/t4/t17/rhoa
      t22 = t12**2
      t27 = t17**2
      t29 = t16*sigmaaa/t27
      t34 = t16**2
      t38 = t34/t7/t27/t6
      t39 = t22**2
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t50 = rhoa*(1.D0+0.1274696188700087D0*t47)
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t62 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t51
     #+0.3844746237447211D1*t47+0.1644733775567609D1*t54
     #+0.2405871291288192D0*t56))
      t64 = 1.D0+0.2D0*t10
      t68 = t64**2
      t76 = t68**2
      t84 = rhob**(1.D0/3.D0)
      t86 = rhob**2
      t87 = t84**2
      t90 = sigmabb/t87/t86
      t92 = 1.D0+0.4D-2*t90
      t96 = sigmabb**2
      t97 = t86**2
      t101 = t96/t84/t97/rhob
      t102 = t92**2
      t107 = t97**2
      t109 = t96*sigmabb/t107
      t114 = t96**2
      t118 = t114/t87/t107/t86
      t119 = t102**2
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t130 = rhob*(1.D0+0.1274696188700087D0*t127)
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t142 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t131
     #+0.3844746237447211D1*t127+0.1644733775567609D1*t134
     #+0.2405871291288192D0*t136))
      t144 = 1.D0+0.2D0*t90
      t148 = t144**2
      t156 = t148**2
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t180 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t169
     #+0.2225569421150687D1*t166+0.8004286349993634D0*t172
     #+0.1897004325747559D0*t174))
      t182 = 0.62182D-1*(1.D0+0.1325688999052018D0*t166)*t180
      t193 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t169
     #+0.2247591863577616D1*t166+0.4300972471276643D0*t172
     #+0.1911512595127338D0*t174))
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t211 = t207/t209
      t227 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t169
     #+0.3844746237447211D1*t166+0.1644733775567609D1*t172
     #+0.2405871291288192D0*t174))
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t250 = t243**2
      t251 = t246**2
      t260 = t250**2
      t261 = t251**2
      s1 = -0.9305257363491D0*t4*rhoa*(0.109025D1-0.3196776D-2*t10/t12
     #+0.8915392D-4*t21/t22-0.3755264D-6*t29/t22/t12+0.77963264D-9*t38
     #/t39)-0.3109D-1*t50*t62*(0.562576D0+0.342872D-2*t10/t64
     #-0.522544D-1*t21/t68+0.845976D-2*t29/t68/t64+0.14166864D-2*t38
     #/t76)
      s2 = s1-0.9305257363491D0*t84*rhob*(0.109025D1-0.3196776D-2*t90
     #/t92+0.8915392D-4*t101/t102-0.3755264D-6*t109/t102/t92
     #+0.77963264D-9*t118/t119)
      zk(i) = s2-0.3109D-1*t130*t142*(0.562576D0+0.342872D-2*t90/t144
     #-0.522544D-1*t101/t148+0.845976D-2*t109/t148/t144+0.14166864D-2
     #*t118/t156)+(t164*(-t182+0.3799574853701528D-1*(1.D0
     #+0.6901399211255825D-1*t166)*t193*t205*(1.D0-1.D0*t211)
     #+0.1923661050931536D1*(-0.3109D-1*(1.D0+0.1274696188700087D0
     #*t166)*t227+t182)*t205*t211)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142)*(0.542352D0+0.4208784D-1*t243/t246-0.10217592D-2*t250
     #/t251+0.75671064D-5*t250*t243/t251/t246-0.264752064D-7*t260/t261)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmabb*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmabb**2
      t15 = t4**2
      t16 = t15*rhob
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmabb
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109025D1-0.3196776D-2*t8*t11+0.8915392D-4*t19*t21
     #-0.3755264D-6*t27*t29+0.77963264D-9*t36*t38
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhob*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.562576D0+0.342872D-2*t8*t63-0.522544D-1*t19*t67
     #+0.845976D-2*t27*t71+0.14166864D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      vrhoa(i) = 0.D0
      t84 = t4*rhob
      t87 = sigmabb/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhob
      t104 = t32/t5/t25/t84
      t111 = t32*sigmabb/t2/t25/t90
      t113 = 1/t37/t10
      t122 = 1/t54
      t126 = t56**2
      t129 = t49**2
      t130 = t129**2
      t133 = 1/t4
      t159 = 1/t74/t62
      vrhob(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*
     #(0.8524736D-2*t87*t11-0.5095865173333333D-3*t93*t21
     #+0.4906161493333333D-5*t98*t29-0.2033292629333333D-7*t104*t38
     #+0.3326432597333333D-10*t111*t113)-0.3109D-1*t47*t60*t78
     #+0.1321010150222857D-2*t44*t122*t79+0.1D1*t48/t126*(
     #-0.1853395810515781D1/t130/t49*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0/t52*t133-0.1603914194192128D0/t45
     #*t133)/t59*t78-0.3109D-1*t48*t60*(-0.9143253333333333D-2*t87*t63
     #+0.280518784D0*t93*t67-0.1234161066666667D0*t98*t71
     #-0.15757056D-2*t104*t75+0.302226432D-2*t111*t159)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t168 = sigmabb*t18
      t171 = t14*t26
      t174 = t24*t35
      t180 = t32/t2/t25/t16
      vsigmabb(i) = -0.9305257363491D0*t3*(-0.3196776D-2*t7*t11
     #+0.191094944D-3*t168*t21-0.183981056D-5*t171*t29+0.762484736D-8
     #*t174*t38-0.1247412224D-10*t180*t113)-0.3109D-1*t48*t60*
     #(0.342872D-2*t7*t63-0.105194544D0*t168*t67+0.4628104D-1*t171*t71
     #+0.5908896D-3*t174*t75-0.113334912D-2*t180*t159)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmaaa*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmaaa**2
      t15 = t4**2
      t16 = t15*rhoa
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmaaa
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109025D1-0.3196776D-2*t8*t11+0.8915392D-4*t19*t21
     #-0.3755264D-6*t27*t29+0.77963264D-9*t36*t38
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhoa*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.562576D0+0.342872D-2*t8*t63-0.522544D-1*t19*t67
     #+0.845976D-2*t27*t71+0.14166864D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      t84 = t4*rhoa
      t87 = sigmaaa/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhoa
      t104 = t32/t5/t25/t84
      t111 = t32*sigmaaa/t2/t25/t90
      t113 = 1/t37/t10
      t122 = 1/t54
      t126 = t56**2
      t129 = t49**2
      t130 = t129**2
      t133 = 1/t4
      t159 = 1/t74/t62
      vrhoa(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*
     #(0.8524736D-2*t87*t11-0.5095865173333333D-3*t93*t21
     #+0.4906161493333333D-5*t98*t29-0.2033292629333333D-7*t104*t38
     #+0.3326432597333333D-10*t111*t113)-0.3109D-1*t47*t60*t78
     #+0.1321010150222857D-2*t44*t122*t79+0.1D1*t48/t126*(
     #-0.1853395810515781D1/t130/t49*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0/t52*t133-0.1603914194192128D0/t45
     #*t133)/t59*t78-0.3109D-1*t48*t60*(-0.9143253333333333D-2*t87*t63
     #+0.280518784D0*t93*t67-0.1234161066666667D0*t98*t71
     #-0.15757056D-2*t104*t75+0.302226432D-2*t111*t159)
      vrhob(i) = 0.D0
      t168 = sigmaaa*t18
      t171 = t14*t26
      t174 = t24*t35
      t180 = t32/t2/t25/t16
      vsigmaaa(i) = -0.9305257363491D0*t3*(-0.3196776D-2*t7*t11
     #+0.191094944D-3*t168*t21-0.183981056D-5*t171*t29+0.762484736D-8
     #*t174*t38-0.1247412224D-10*t180*t113)-0.3109D-1*t48*t60*
     #(0.342872D-2*t7*t63-0.105194544D0*t168*t67+0.4628104D-1*t171*t71
     #+0.5908896D-3*t174*t75-0.113334912D-2*t180*t159)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t9 = 1/t7/t6
      t10 = sigmaaa*t9
      t12 = 1.D0+0.4D-2*t10
      t13 = 1/t12
      t16 = sigmaaa**2
      t17 = t6**2
      t18 = t17*rhoa
      t20 = 1/t4/t18
      t21 = t16*t20
      t22 = t12**2
      t23 = 1/t22
      t26 = t16*sigmaaa
      t27 = t17**2
      t28 = 1/t27
      t29 = t26*t28
      t31 = 1/t22/t12
      t34 = t16**2
      t37 = 1/t7/t27/t6
      t38 = t34*t37
      t39 = t22**2
      t40 = 1/t39
      t43 = 0.109025D1-0.3196776D-2*t10*t13+0.8915392D-4*t21*t23
     #-0.3755264D-6*t29*t31+0.77963264D-9*t38*t40
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t49 = 1.D0+0.1274696188700087D0*t47
      t50 = rhoa*t49
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t58 = 0.1112037486309468D2*t51+0.3844746237447211D1*t47
     #+0.1644733775567609D1*t54+0.2405871291288192D0*t56
      t61 = 1.D0+0.321646831778707D2/t58
      t62 = dlog(t61)
      t64 = 1.D0+0.2D0*t10
      t65 = 1/t64
      t68 = t64**2
      t69 = 1/t68
      t73 = 1/t68/t64
      t76 = t68**2
      t77 = 1/t76
      t80 = 0.562576D0+0.342872D-2*t10*t65-0.522544D-1*t21*t69
     #+0.845976D-2*t29*t73+0.14166864D-2*t38*t77
      t81 = t62*t80
      t84 = rhob**(1.D0/3.D0)
      t85 = t84*rhob
      t86 = rhob**2
      t87 = t84**2
      t89 = 1/t87/t86
      t90 = sigmabb*t89
      t92 = 1.D0+0.4D-2*t90
      t93 = 1/t92
      t96 = sigmabb**2
      t97 = t86**2
      t98 = t97*rhob
      t100 = 1/t84/t98
      t101 = t96*t100
      t102 = t92**2
      t103 = 1/t102
      t106 = t96*sigmabb
      t107 = t97**2
      t108 = 1/t107
      t109 = t106*t108
      t111 = 1/t102/t92
      t114 = t96**2
      t117 = 1/t87/t107/t86
      t118 = t114*t117
      t119 = t102**2
      t120 = 1/t119
      t123 = 0.109025D1-0.3196776D-2*t90*t93+0.8915392D-4*t101*t103
     #-0.3755264D-6*t109*t111+0.77963264D-9*t118*t120
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t129 = 1.D0+0.1274696188700087D0*t127
      t130 = rhob*t129
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t138 = 0.1112037486309468D2*t131+0.3844746237447211D1*t127
     #+0.1644733775567609D1*t134+0.2405871291288192D0*t136
      t141 = 1.D0+0.321646831778707D2/t138
      t142 = dlog(t141)
      t144 = 1.D0+0.2D0*t90
      t145 = 1/t144
      t148 = t144**2
      t149 = 1/t148
      t153 = 1/t148/t144
      t156 = t148**2
      t157 = 1/t156
      t160 = 0.562576D0+0.342872D-2*t90*t145-0.522544D-1*t101*t149
     #+0.845976D-2*t109*t153+0.14166864D-2*t118*t157
      t161 = t142*t160
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t168 = 1.D0+0.1325688999052018D0*t166
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t176 = 0.598255043577108D1*t169+0.2225569421150687D1*t166
     #+0.8004286349993634D0*t172+0.1897004325747559D0*t174
      t179 = 1.D0+0.160818243221511D2/t176
      t180 = dlog(t179)
      t182 = 0.62182D-1*t168*t180
      t184 = 1.D0+0.6901399211255825D-1*t166
      t189 = 0.8157414703487641D1*t169+0.2247591863577616D1*t166
     #+0.4300972471276643D0*t172+0.1911512595127338D0*t174
      t192 = 1.D0+0.2960857464321668D2/t189
      t193 = dlog(t192)
      t194 = t184*t193
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t210 = 1/t209
      t211 = t207*t210
      t213 = 1.D0-1.D0*t211
      t216 = 0.3799574853701528D-1*t194*t205*t213
      t218 = 1.D0+0.1274696188700087D0*t166
      t223 = 0.1112037486309468D2*t169+0.3844746237447211D1*t166
     #+0.1644733775567609D1*t172+0.2405871291288192D0*t174
      t226 = 1.D0+0.321646831778707D2/t223
      t227 = dlog(t226)
      t230 = -0.3109D-1*t218*t227+t182
      t231 = t230*t205
      t233 = 0.1923661050931536D1*t231*t211
      t240 = t164*(-t182+t216+t233)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t247 = 1/t246
      t250 = t243**2
      t251 = t246**2
      t252 = 1/t251
      t255 = t250*t243
      t257 = 1/t251/t246
      t260 = t250**2
      t261 = t251**2
      t262 = 1/t261
      t265 = 0.542352D0+0.4208784D-1*t243*t247-0.10217592D-2*t250*t252
     #+0.75671064D-5*t255*t257-0.264752064D-7*t260*t262
      zk(i) = -0.9305257363491D0*t5*t43-0.3109D-1*t50*t81
     #-0.9305257363491D0*t85*t123-0.3109D-1*t130*t161+t240*t265
      t269 = t6*rhoa
      t272 = sigmaaa/t7/t269
      t275 = t17*t6
      t278 = t16/t4/t275
      t283 = t26/t27/rhoa
      t289 = t34/t7/t27/t269
      t296 = t34*sigmaaa/t4/t27/t275
      t298 = 1/t39/t12
      t304 = t49*t62
      t307 = 1/t56
      t308 = t46*t307
      t311 = t58**2
      t312 = 1/t311
      t314 = t51**2
      t315 = t314**2
      t318 = 1/t6
      t329 = -0.1853395810515781D1/t315/t51*t318-0.128158207914907D1
     #*t307*t318-0.8223668877838045D0/t54*t318-0.1603914194192128D0
     #/t47*t318
      t330 = 1/t61
      t344 = 1/t76/t64
      t352 = 1/t208
      t353 = 1/t174*t352
      t354 = t353*t180
      t355 = 0.2747799777968419D-2*t354
      t356 = t176**2
      t359 = t169**2
      t360 = t359**2
      t363 = 1/t360/t169*t352
      t367 = 1/t172*t352
      t370 = 1/t166*t352
      t375 = t168/t356*(-0.99709173929518D0*t363-0.7418564737168958D0
     #*t353-0.4002143174996817D0*t367-0.1264669550498372D0*t370)/t179
      t376 = 0.1D1*t375
      t380 = 0.8740794299481065D-3*t353*t193*t205*t213
      t381 = t189**2
      t394 = 0.1124999956683108D1*t184/t381*(-0.135956911724794D1*t363
     #-0.7491972878592054D0*t353-0.2150486235638321D0*t367
     #-0.1274341730084892D0*t370)/t192*t205*t213
      t395 = t196*t352
      t396 = 1.D0*t395
      t400 = 1.D0*t165
      t404 = 0.1333333333333333D1*t199*(t165-t396)
     #+0.1333333333333333D1*t203*(-t400+t395)
      t409 = t206*t196*t210
      t410 = 4.D0*t409
      t413 = t207/t209/t164
      t414 = 4.D0*t413
      t421 = t223**2
      t438 = 0.1923661050931536D1*(0.1321010150222857D-2*t353*t227
     #+0.1D1*t218/t421*(-0.1853395810515781D1*t363-0.128158207914907D1
     #*t353-0.8223668877838045D0*t367-0.1603914194192128D0*t370)/t226
     #-0.2747799777968419D-2*t354-0.1D1*t375)*t205*t211
      t442 = t231*t409
      t445 = 0.7694644203726145D1*t231*t413
      t459 = t243*t252
      t462 = t250*t257
      t465 = t255*t262
      t470 = t260/t261/t246
      s1 = -0.12407009817988D1*t4*t43-0.9305257363491D0*t5*
     #(0.8524736D-2*t272*t13-0.5095865173333333D-3*t278*t23
     #+0.4906161493333333D-5*t283*t31-0.2033292629333333D-7*t289*t40
     #+0.3326432597333333D-10*t296*t298)-0.3109D-1*t304*t80
     #+0.1321010150222857D-2*t308*t81
      vrhoa(i) = s1+0.1D1*t50*t312*t329*t330*t80-0.3109D-1*t50*t62*(
     #-0.9143253333333333D-2*t272*t65+0.280518784D0*t278*t69
     #-0.1234161066666667D0*t283*t73-0.15757056D-2*t289*t77
     #+0.302226432D-2*t296*t344)+(-t182+t216+t233+t164*(t355+t376-t380
     #-t394+0.3799574853701528D-1*t194*t404*t213+0.3799574853701528D-1
     #*t194*t205*(-t410+t414)+t438+0.1923661050931536D1*t230*t404*t211
     #+0.7694644203726145D1*t442-t445)+0.3109D-1*t304
     #-0.1321010150222857D-2*t308*t62-0.1D1*t50*t312*t329*t330)*t265
     #+t240*(-0.5611712D-1*t272*t247+0.306139392D-2*t459*t272
     #-0.466165728D-4*t462*t272+0.3228116544D-6*t465*t272
     #-0.8472066048D-9*t470*t272)
      t477 = t86*rhob
      t480 = sigmabb/t87/t477
      t483 = t97*t86
      t486 = t96/t84/t483
      t491 = t106/t107/rhob
      t497 = t114/t87/t107/t477
      t504 = t114*sigmabb/t84/t107/t483
      t506 = 1/t119/t92
      t512 = t129*t142
      t515 = 1/t136
      t516 = t126*t515
      t519 = t138**2
      t520 = 1/t519
      t522 = t131**2
      t523 = t522**2
      t526 = 1/t86
      t537 = -0.1853395810515781D1/t523/t131*t526-0.128158207914907D1
     #*t515*t526-0.8223668877838045D0/t134*t526-0.1603914194192128D0
     #/t127*t526
      t538 = 1/t141
      t552 = 1/t156/t144
      t565 = 0.1333333333333333D1*t199*(-t400-t396)
     #+0.1333333333333333D1*t203*(t165+t395)
      s1 = -0.12407009817988D1*t84*t123-0.9305257363491D0*t85*
     #(0.8524736D-2*t480*t93-0.5095865173333333D-3*t486*t103
     #+0.4906161493333333D-5*t491*t111-0.2033292629333333D-7*t497*t120
     #+0.3326432597333333D-10*t504*t506)-0.3109D-1*t512*t160
     #+0.1321010150222857D-2*t516*t161
      vrhob(i) = s1+0.1D1*t130*t520*t537*t538*t160-0.3109D-1*t130*t142
     #*(-0.9143253333333333D-2*t480*t145+0.280518784D0*t486*t149
     #-0.1234161066666667D0*t491*t153-0.15757056D-2*t497*t157
     #+0.302226432D-2*t504*t552)+(-t182+t216+t233+t164*(t355+t376-t380
     #-t394+0.3799574853701528D-1*t194*t565*t213+0.3799574853701528D-1
     #*t194*t205*(t410+t414)+t438+0.1923661050931536D1*t230*t565*t211
     #-0.7694644203726145D1*t442-t445)+0.3109D-1*t512
     #-0.1321010150222857D-2*t516*t142-0.1D1*t130*t520*t537*t538)*t265
     #+t240*(-0.5611712D-1*t480*t247+0.306139392D-2*t459*t480
     #-0.466165728D-4*t462*t480+0.3228116544D-6*t465*t480
     #-0.8472066048D-9*t470*t480)
      t602 = sigmaaa*t20
      t605 = t16*t28
      t608 = t26*t37
      t614 = t34/t4/t27/t18
      vsigmaaa(i) = -0.9305257363491D0*t5*(-0.3196776D-2*t9*t13
     #+0.191094944D-3*t602*t23-0.183981056D-5*t605*t31+0.762484736D-8
     #*t608*t40-0.1247412224D-10*t614*t298)-0.3109D-1*t50*t62*
     #(0.342872D-2*t9*t65-0.105194544D0*t602*t69+0.4628104D-1*t605*t73
     #+0.5908896D-3*t608*t77-0.113334912D-2*t614*t344)+t240*
     #(0.2104392D-1*t9*t247-0.114802272D-2*t459*t9+0.174812148D-4*t462
     #*t9-0.1210543704D-6*t465*t9+0.3177024768D-9*t470*t9)
      vsigmaab(i) = 0.D0
      t648 = sigmabb*t100
      t651 = t96*t108
      t654 = t106*t117
      t660 = t114/t84/t107/t98
      vsigmabb(i) = -0.9305257363491D0*t85*(-0.3196776D-2*t89*t93
     #+0.191094944D-3*t648*t103-0.183981056D-5*t651*t111
     #+0.762484736D-8*t654*t120-0.1247412224D-10*t660*t506)-0.3109D-1
     #*t130*t142*(0.342872D-2*t89*t145-0.105194544D0*t648*t149
     #+0.4628104D-1*t651*t153+0.5908896D-3*t654*t157-0.113334912D-2
     #*t660*t552)+t240*(0.2104392D-1*t89*t247-0.114802272D-2*t459*t89
     #+0.174812148D-4*t462*t89-0.1210543704D-6*t465*t89
     #+0.3177024768D-9*t470*t89)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmabb*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmabb**2
      t15 = t4**2
      t16 = t15*rhob
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmabb
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109025D1-0.3196776D-2*t8*t11+0.8915392D-4*t19*t21
     #-0.3755264D-6*t27*t29+0.77963264D-9*t36*t38
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhob*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.562576D0+0.342872D-2*t8*t63-0.522544D-1*t19*t67
     #+0.845976D-2*t27*t71+0.14166864D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      vrhoa(i) = 0.D0
      t84 = t4*rhob
      t87 = sigmabb/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhob
      t104 = t32/t5/t25/t84
      t107 = t32*sigmabb
      t111 = t107/t2/t25/t90
      t113 = 1/t37/t10
      t116 = 0.8524736D-2*t87*t11-0.5095865173333333D-3*t93*t21
     #+0.4906161493333333D-5*t98*t29-0.2033292629333333D-7*t104*t38
     #+0.3326432597333333D-10*t111*t113
      t119 = t47*t60
      t122 = 1/t54
      t123 = t44*t122
      t126 = t56**2
      t127 = 1/t126
      t128 = t48*t127
      t129 = t49**2
      t130 = t129**2
      t131 = t130*t49
      t132 = 1/t131
      t133 = 1/t4
      t138 = 1/t52
      t141 = 1/t45
      t144 = -0.1853395810515781D1*t132*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0*t138*t133-0.1603914194192128D0*t141
     #*t133
      t145 = 1/t59
      t146 = t144*t145
      t147 = t146*t78
      t159 = 1/t74/t62
      t162 = -0.9143253333333333D-2*t87*t63+0.280518784D0*t93*t67
     #-0.1234161066666667D0*t98*t71-0.15757056D-2*t104*t75
     #+0.302226432D-2*t111*t159
      t163 = t60*t162
      vrhob(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*t116
     #-0.3109D-1*t119*t78+0.1321010150222857D-2*t123*t79+0.1D1*t128
     #*t147-0.3109D-1*t48*t163
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t168 = sigmabb*t18
      t171 = t14*t26
      t174 = t24*t35
      t179 = 1/t2/t25/t16
      t180 = t32*t179
      vsigmabb(i) = -0.9305257363491D0*t3*(-0.3196776D-2*t7*t11
     #+0.191094944D-3*t168*t21-0.183981056D-5*t171*t29+0.762484736D-8
     #*t174*t38-0.1247412224D-10*t180*t113)-0.3109D-1*t48*t60*
     #(0.342872D-2*t7*t63-0.105194544D0*t168*t67+0.4628104D-1*t171*t71
     #+0.5908896D-3*t174*t75-0.113334912D-2*t180*t159)
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t207 = sigmabb/t5/t15
      t210 = t15*t84
      t213 = t14/t2/t210
      t217 = t24/t33
      t223 = t32/t5/t25/t15
      t229 = t107/t2/t25/t210
      t233 = t25**2
      t236 = t32*t14/t233/t4
      t238 = 1/t37/t20
      t249 = 1/t84
      t251 = 1/t54/t44
      t263 = t144**2
      t270 = 1/t15
      t296 = t126**2
      t299 = t59**2
      t319 = 1/t74/t66
      s1 = -0.4135669939329333D0/t5*t41-0.24814019635976D1*t2*t116
     #-0.9305257363491D0*t3*(-0.3125736533333333D-1*t207*t11
     #+0.3318311793777778D-2*t213*t21-0.5502663247644444D-4*t217*t29
     #+0.3942146412088889D-6*t223*t38-0.13443268608D-8*t229*t113
     #+0.1774097385244444D-11*t236*t238)+0.2D1*t47*t127*t147-0.6218D-1
     #*t119*t162+0.8806734334819047D-3*t249*t251*t79
      v2rhob2(i) = s1-0.8497974591333914D-1*t123*t127*t147
     #+0.2642020300445714D-2*t123*t163-0.2D1*t48/t126/t56*t263*t145
     #*t78+0.1D1*t128*(-0.1544496508763151D1/t131/t44*t270
     #+0.3706791621031562D1*t132*t249-0.854388052766047D0*t251*t270
     #+0.2563164158298141D1*t122*t249-0.4111834438919023D0/t52/t44
     #*t270+0.1644733775567609D1*t138*t249-0.5346380647307093D-1/t45
     #/t44*t270+0.3207828388384256D0*t141*t249)*t145*t78
     #+0.321646831778707D2*t48/t296*t263/t299*t78+0.2D1*t128*t146*t162
     #-0.3109D-1*t48*t60*(0.3352526222222222D-1*t207*t63
     #-0.1781495367111111D1*t213*t67+0.1409964996266667D1*t217*t71
     #-0.1790825386666667D0*t223*t75-0.466806272D-1*t229*t159
     #+0.805937152D-2*t236*t319)
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t328 = sigmabb*t26
      t331 = t14*t35
      t334 = t24*t179
      t338 = t32/t233
      v2sigmabb2(i) = -0.9305257363491D0*t3*(0.203882048D-3*t18*t21
     #-0.5208380672D-5*t328*t29+0.449522688D-7*t331*t38
     #-0.17189404672D-9*t334*t113+0.2494824448D-12*t338*t238)
     #-0.3109D-1*t48*t60*(-0.105880288D0*t18*t67+0.1346398976D0*t328
     #*t71-0.259959552D-1*t331*t75-0.500610816D-2*t334*t159
     #+0.113334912D-2*t338*t319)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmaaa*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmaaa**2
      t15 = t4**2
      t16 = t15*rhoa
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmaaa
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109025D1-0.3196776D-2*t8*t11+0.8915392D-4*t19*t21
     #-0.3755264D-6*t27*t29+0.77963264D-9*t36*t38
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhoa*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.562576D0+0.342872D-2*t8*t63-0.522544D-1*t19*t67
     #+0.845976D-2*t27*t71+0.14166864D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      t84 = t4*rhoa
      t87 = sigmaaa/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhoa
      t104 = t32/t5/t25/t84
      t107 = t32*sigmaaa
      t111 = t107/t2/t25/t90
      t113 = 1/t37/t10
      t116 = 0.8524736D-2*t87*t11-0.5095865173333333D-3*t93*t21
     #+0.4906161493333333D-5*t98*t29-0.2033292629333333D-7*t104*t38
     #+0.3326432597333333D-10*t111*t113
      t119 = t47*t60
      t122 = 1/t54
      t123 = t44*t122
      t126 = t56**2
      t127 = 1/t126
      t128 = t48*t127
      t129 = t49**2
      t130 = t129**2
      t131 = t130*t49
      t132 = 1/t131
      t133 = 1/t4
      t138 = 1/t52
      t141 = 1/t45
      t144 = -0.1853395810515781D1*t132*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0*t138*t133-0.1603914194192128D0*t141
     #*t133
      t145 = 1/t59
      t146 = t144*t145
      t147 = t146*t78
      t159 = 1/t74/t62
      t162 = -0.9143253333333333D-2*t87*t63+0.280518784D0*t93*t67
     #-0.1234161066666667D0*t98*t71-0.15757056D-2*t104*t75
     #+0.302226432D-2*t111*t159
      t163 = t60*t162
      vrhoa(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*t116
     #-0.3109D-1*t119*t78+0.1321010150222857D-2*t123*t79+0.1D1*t128
     #*t147-0.3109D-1*t48*t163
      vrhob(i) = 0.D0
      t168 = sigmaaa*t18
      t171 = t14*t26
      t174 = t24*t35
      t179 = 1/t2/t25/t16
      t180 = t32*t179
      vsigmaaa(i) = -0.9305257363491D0*t3*(-0.3196776D-2*t7*t11
     #+0.191094944D-3*t168*t21-0.183981056D-5*t171*t29+0.762484736D-8
     #*t174*t38-0.1247412224D-10*t180*t113)-0.3109D-1*t48*t60*
     #(0.342872D-2*t7*t63-0.105194544D0*t168*t67+0.4628104D-1*t171*t71
     #+0.5908896D-3*t174*t75-0.113334912D-2*t180*t159)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t207 = sigmaaa/t5/t15
      t210 = t15*t84
      t213 = t14/t2/t210
      t217 = t24/t33
      t223 = t32/t5/t25/t15
      t229 = t107/t2/t25/t210
      t233 = t25**2
      t236 = t32*t14/t233/t4
      t238 = 1/t37/t20
      t249 = 1/t84
      t251 = 1/t54/t44
      t263 = t144**2
      t270 = 1/t15
      t296 = t126**2
      t299 = t59**2
      t319 = 1/t74/t66
      s1 = -0.4135669939329333D0/t5*t41-0.24814019635976D1*t2*t116
     #-0.9305257363491D0*t3*(-0.3125736533333333D-1*t207*t11
     #+0.3318311793777778D-2*t213*t21-0.5502663247644444D-4*t217*t29
     #+0.3942146412088889D-6*t223*t38-0.13443268608D-8*t229*t113
     #+0.1774097385244444D-11*t236*t238)+0.2D1*t47*t127*t147-0.6218D-1
     #*t119*t162+0.8806734334819047D-3*t249*t251*t79
      v2rhoa2(i) = s1-0.8497974591333914D-1*t123*t127*t147
     #+0.2642020300445714D-2*t123*t163-0.2D1*t48/t126/t56*t263*t145
     #*t78+0.1D1*t128*(-0.1544496508763151D1/t131/t44*t270
     #+0.3706791621031562D1*t132*t249-0.854388052766047D0*t251*t270
     #+0.2563164158298141D1*t122*t249-0.4111834438919023D0/t52/t44
     #*t270+0.1644733775567609D1*t138*t249-0.5346380647307093D-1/t45
     #/t44*t270+0.3207828388384256D0*t141*t249)*t145*t78
     #+0.321646831778707D2*t48/t296*t263/t299*t78+0.2D1*t128*t146*t162
     #-0.3109D-1*t48*t60*(0.3352526222222222D-1*t207*t63
     #-0.1781495367111111D1*t213*t67+0.1409964996266667D1*t217*t71
     #-0.1790825386666667D0*t223*t75-0.466806272D-1*t229*t159
     #+0.805937152D-2*t236*t319)
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t328 = sigmaaa*t26
      t331 = t14*t35
      t334 = t24*t179
      t338 = t32/t233
      v2sigmaaa2(i) = -0.9305257363491D0*t3*(0.203882048D-3*t18*t21
     #-0.5208380672D-5*t328*t29+0.449522688D-7*t331*t38
     #-0.17189404672D-9*t334*t113+0.2494824448D-12*t338*t238)
     #-0.3109D-1*t48*t60*(-0.105880288D0*t18*t67+0.1346398976D0*t328
     #*t71-0.259959552D-1*t331*t75-0.500610816D-2*t334*t159
     #+0.113334912D-2*t338*t319)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t9 = 1/t7/t6
      t10 = sigmaaa*t9
      t12 = 1.D0+0.4D-2*t10
      t13 = 1/t12
      t16 = sigmaaa**2
      t17 = t6**2
      t18 = t17*rhoa
      t20 = 1/t4/t18
      t21 = t16*t20
      t22 = t12**2
      t23 = 1/t22
      t26 = t16*sigmaaa
      t27 = t17**2
      t28 = 1/t27
      t29 = t26*t28
      t31 = 1/t22/t12
      t34 = t16**2
      t35 = t27*t6
      t37 = 1/t7/t35
      t38 = t34*t37
      t39 = t22**2
      t40 = 1/t39
      t43 = 0.109025D1-0.3196776D-2*t10*t13+0.8915392D-4*t21*t23
     #-0.3755264D-6*t29*t31+0.77963264D-9*t38*t40
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t49 = 1.D0+0.1274696188700087D0*t47
      t50 = rhoa*t49
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t58 = 0.1112037486309468D2*t51+0.3844746237447211D1*t47
     #+0.1644733775567609D1*t54+0.2405871291288192D0*t56
      t61 = 1.D0+0.321646831778707D2/t58
      t62 = dlog(t61)
      t64 = 1.D0+0.2D0*t10
      t65 = 1/t64
      t68 = t64**2
      t69 = 1/t68
      t73 = 1/t68/t64
      t76 = t68**2
      t77 = 1/t76
      t80 = 0.562576D0+0.342872D-2*t10*t65-0.522544D-1*t21*t69
     #+0.845976D-2*t29*t73+0.14166864D-2*t38*t77
      t81 = t62*t80
      t84 = rhob**(1.D0/3.D0)
      t85 = t84*rhob
      t86 = rhob**2
      t87 = t84**2
      t89 = 1/t87/t86
      t90 = sigmabb*t89
      t92 = 1.D0+0.4D-2*t90
      t93 = 1/t92
      t96 = sigmabb**2
      t97 = t86**2
      t98 = t97*rhob
      t100 = 1/t84/t98
      t101 = t96*t100
      t102 = t92**2
      t103 = 1/t102
      t106 = t96*sigmabb
      t107 = t97**2
      t108 = 1/t107
      t109 = t106*t108
      t111 = 1/t102/t92
      t114 = t96**2
      t115 = t107*t86
      t117 = 1/t87/t115
      t118 = t114*t117
      t119 = t102**2
      t120 = 1/t119
      t123 = 0.109025D1-0.3196776D-2*t90*t93+0.8915392D-4*t101*t103
     #-0.3755264D-6*t109*t111+0.77963264D-9*t118*t120
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t129 = 1.D0+0.1274696188700087D0*t127
      t130 = rhob*t129
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t138 = 0.1112037486309468D2*t131+0.3844746237447211D1*t127
     #+0.1644733775567609D1*t134+0.2405871291288192D0*t136
      t141 = 1.D0+0.321646831778707D2/t138
      t142 = dlog(t141)
      t144 = 1.D0+0.2D0*t90
      t145 = 1/t144
      t148 = t144**2
      t149 = 1/t148
      t153 = 1/t148/t144
      t156 = t148**2
      t157 = 1/t156
      t160 = 0.562576D0+0.342872D-2*t90*t145-0.522544D-1*t101*t149
     #+0.845976D-2*t109*t153+0.14166864D-2*t118*t157
      t161 = t142*t160
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t168 = 1.D0+0.1325688999052018D0*t166
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t176 = 0.598255043577108D1*t169+0.2225569421150687D1*t166
     #+0.8004286349993634D0*t172+0.1897004325747559D0*t174
      t179 = 1.D0+0.160818243221511D2/t176
      t180 = dlog(t179)
      t182 = 0.62182D-1*t168*t180
      t184 = 1.D0+0.6901399211255825D-1*t166
      t189 = 0.8157414703487641D1*t169+0.2247591863577616D1*t166
     #+0.4300972471276643D0*t172+0.1911512595127338D0*t174
      t192 = 1.D0+0.2960857464321668D2/t189
      t193 = dlog(t192)
      t194 = t184*t193
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t210 = 1/t209
      t211 = t207*t210
      t213 = 1.D0-1.D0*t211
      t214 = t205*t213
      t216 = 0.3799574853701528D-1*t194*t214
      t218 = 1.D0+0.1274696188700087D0*t166
      t223 = 0.1112037486309468D2*t169+0.3844746237447211D1*t166
     #+0.1644733775567609D1*t172+0.2405871291288192D0*t174
      t226 = 1.D0+0.321646831778707D2/t223
      t227 = dlog(t226)
      t230 = -0.3109D-1*t218*t227+t182
      t231 = t230*t205
      t233 = 0.1923661050931536D1*t231*t211
      t240 = t164*(-t182+t216+t233)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t247 = 1/t246
      t250 = t243**2
      t251 = t246**2
      t252 = 1/t251
      t255 = t250*t243
      t257 = 1/t251/t246
      t260 = t250**2
      t261 = t251**2
      t262 = 1/t261
      t265 = 0.542352D0+0.4208784D-1*t243*t247-0.10217592D-2*t250*t252
     #+0.75671064D-5*t255*t257-0.264752064D-7*t260*t262
      zk(i) = -0.9305257363491D0*t5*t43-0.3109D-1*t50*t81
     #-0.9305257363491D0*t85*t123-0.3109D-1*t130*t161+t240*t265
      t269 = t6*rhoa
      t271 = 1/t7/t269
      t272 = sigmaaa*t271
      t275 = t17*t6
      t277 = 1/t4/t275
      t278 = t16*t277
      t282 = 1/t27/rhoa
      t283 = t26*t282
      t288 = 1/t7/t27/t269
      t289 = t34*t288
      t292 = t34*sigmaaa
      t295 = 1/t4/t27/t275
      t296 = t292*t295
      t298 = 1/t39/t12
      t301 = 0.8524736D-2*t272*t13-0.5095865173333333D-3*t278*t23
     #+0.4906161493333333D-5*t283*t31-0.2033292629333333D-7*t289*t40
     #+0.3326432597333333D-10*t296*t298
      t304 = t49*t62
      t307 = 1/t56
      t308 = t46*t307
      t311 = t58**2
      t312 = 1/t311
      t313 = t50*t312
      t314 = t51**2
      t315 = t314**2
      t316 = t315*t51
      t317 = 1/t316
      t318 = 1/t6
      t323 = 1/t54
      t326 = 1/t47
      t329 = -0.1853395810515781D1*t317*t318-0.128158207914907D1*t307
     #*t318-0.8223668877838045D0*t323*t318-0.1603914194192128D0*t326
     #*t318
      t330 = 1/t61
      t331 = t329*t330
      t332 = t331*t80
      t344 = 1/t76/t64
      t347 = -0.9143253333333333D-2*t272*t65+0.280518784D0*t278*t69
     #-0.1234161066666667D0*t283*t73-0.15757056D-2*t289*t77
     #+0.302226432D-2*t296*t344
      t348 = t62*t347
      t351 = 1/t174
      t352 = 1/t208
      t353 = t351*t352
      t354 = t353*t180
      t355 = 0.2747799777968419D-2*t354
      t356 = t176**2
      t357 = 1/t356
      t358 = t168*t357
      t359 = t169**2
      t360 = t359**2
      t361 = t360*t169
      t362 = 1/t361
      t363 = t362*t352
      t366 = 1/t172
      t367 = t366*t352
      t369 = 1/t166
      t370 = t369*t352
      t372 = -0.99709173929518D0*t363-0.7418564737168958D0*t353
     #-0.4002143174996817D0*t367-0.1264669550498372D0*t370
      t373 = 1/t179
      t375 = t358*t372*t373
      t376 = 0.1D1*t375
      t377 = t193*t205
      t378 = t377*t213
      t379 = t353*t378
      t380 = 0.8740794299481065D-3*t379
      t381 = t189**2
      t382 = 1/t381
      t383 = t184*t382
      t388 = -0.135956911724794D1*t363-0.7491972878592054D0*t353
     #-0.2150486235638321D0*t367-0.1274341730084892D0*t370
      t389 = t383*t388
      t390 = 1/t192
      t391 = t390*t205
      t392 = t391*t213
      t393 = t389*t392
      t394 = 0.1124999956683108D1*t393
      t395 = t196*t352
      t396 = 1.D0*t395
      t397 = t165-t396
      t400 = 1.D0*t165
      t401 = -t400+t395
      t404 = 0.1333333333333333D1*t199*t397+0.1333333333333333D1*t203
     #*t401
      t406 = t194*t404*t213
      t407 = 0.3799574853701528D-1*t406
      t408 = t206*t196
      t409 = t408*t210
      t410 = 4.D0*t409
      t412 = 1/t209/t164
      t413 = t207*t412
      t414 = 4.D0*t413
      t415 = -t410+t414
      t417 = t194*t205*t415
      t418 = 0.3799574853701528D-1*t417
      t421 = t223**2
      t422 = 1/t421
      t423 = t218*t422
      t428 = -0.1853395810515781D1*t363-0.128158207914907D1*t353
     #-0.8223668877838045D0*t367-0.1603914194192128D0*t370
      t429 = 1/t226
      t435 = 0.1321010150222857D-2*t353*t227+0.1D1*t423*t428*t429
     #-0.2747799777968419D-2*t354-0.1D1*t375
      t436 = t435*t205
      t437 = t436*t211
      t438 = 0.1923661050931536D1*t437
      t439 = t230*t404
      t440 = t439*t211
      t441 = 0.1923661050931536D1*t440
      t442 = t231*t409
      t444 = t231*t413
      t445 = 0.7694644203726145D1*t444
      t452 = t312*t329*t330
      t455 = -t182+t216+t233+t164*(t355+t376-t380-t394+t407+t418+t438
     #+t441+0.7694644203726145D1*t442-t445)+0.3109D-1*t304
     #-0.1321010150222857D-2*t308*t62-0.1D1*t50*t452
      t459 = t243*t252
      t462 = t250*t257
      t465 = t255*t262
      t469 = 1/t261/t246
      t470 = t260*t469
      t473 = -0.5611712D-1*t272*t247+0.306139392D-2*t459*t272
     #-0.466165728D-4*t462*t272+0.3228116544D-6*t465*t272
     #-0.8472066048D-9*t470*t272
      vrhoa(i) = -0.12407009817988D1*t4*t43-0.9305257363491D0*t5*t301
     #-0.3109D-1*t304*t80+0.1321010150222857D-2*t308*t81+0.1D1*t313
     #*t332-0.3109D-1*t50*t348+t455*t265+t240*t473
      t477 = t86*rhob
      t479 = 1/t87/t477
      t480 = sigmabb*t479
      t483 = t97*t86
      t485 = 1/t84/t483
      t486 = t96*t485
      t490 = 1/t107/rhob
      t491 = t106*t490
      t496 = 1/t87/t107/t477
      t497 = t114*t496
      t500 = t114*sigmabb
      t503 = 1/t84/t107/t483
      t504 = t500*t503
      t506 = 1/t119/t92
      t509 = 0.8524736D-2*t480*t93-0.5095865173333333D-3*t486*t103
     #+0.4906161493333333D-5*t491*t111-0.2033292629333333D-7*t497*t120
     #+0.3326432597333333D-10*t504*t506
      t512 = t129*t142
      t515 = 1/t136
      t516 = t126*t515
      t519 = t138**2
      t520 = 1/t519
      t521 = t130*t520
      t522 = t131**2
      t523 = t522**2
      t524 = t523*t131
      t525 = 1/t524
      t526 = 1/t86
      t531 = 1/t134
      t534 = 1/t127
      t537 = -0.1853395810515781D1*t525*t526-0.128158207914907D1*t515
     #*t526-0.8223668877838045D0*t531*t526-0.1603914194192128D0*t534
     #*t526
      t538 = 1/t141
      t539 = t537*t538
      t540 = t539*t160
      t552 = 1/t156/t144
      t555 = -0.9143253333333333D-2*t480*t145+0.280518784D0*t486*t149
     #-0.1234161066666667D0*t491*t153-0.15757056D-2*t497*t157
     #+0.302226432D-2*t504*t552
      t556 = t142*t555
      t559 = -t400-t396
      t562 = t165+t395
      t565 = 0.1333333333333333D1*t199*t559+0.1333333333333333D1*t203
     #*t562
      t567 = t194*t565*t213
      t568 = 0.3799574853701528D-1*t567
      t569 = t410+t414
      t571 = t194*t205*t569
      t572 = 0.3799574853701528D-1*t571
      t573 = t230*t565
      t574 = t573*t211
      t575 = 0.1923661050931536D1*t574
      t583 = t520*t537*t538
      t586 = -t182+t216+t233+t164*(t355+t376-t380-t394+t568+t572+t438
     #+t575-0.7694644203726145D1*t442-t445)+0.3109D-1*t512
     #-0.1321010150222857D-2*t516*t142-0.1D1*t130*t583
      t598 = -0.5611712D-1*t480*t247+0.306139392D-2*t459*t480
     #-0.466165728D-4*t462*t480+0.3228116544D-6*t465*t480
     #-0.8472066048D-9*t470*t480
      vrhob(i) = -0.12407009817988D1*t84*t123-0.9305257363491D0*t85
     #*t509-0.3109D-1*t512*t160+0.1321010150222857D-2*t516*t161+0.1D1
     #*t521*t540-0.3109D-1*t130*t556+t586*t265+t240*t598
      t602 = sigmaaa*t20
      t605 = t16*t28
      t608 = t26*t37
      t613 = 1/t4/t27/t18
      t614 = t34*t613
      t617 = -0.3196776D-2*t9*t13+0.191094944D-3*t602*t23
     #-0.183981056D-5*t605*t31+0.762484736D-8*t608*t40
     #-0.1247412224D-10*t614*t298
      t630 = 0.342872D-2*t9*t65-0.105194544D0*t602*t69+0.4628104D-1
     #*t605*t73+0.5908896D-3*t608*t77-0.113334912D-2*t614*t344
      t631 = t62*t630
      t644 = 0.2104392D-1*t9*t247-0.114802272D-2*t459*t9
     #+0.174812148D-4*t462*t9-0.1210543704D-6*t465*t9+0.3177024768D-9
     #*t470*t9
      vsigmaaa(i) = -0.9305257363491D0*t5*t617-0.3109D-1*t50*t631+t240
     #*t644
      vsigmaab(i) = 0.D0
      t648 = sigmabb*t100
      t651 = t96*t108
      t654 = t106*t117
      t659 = 1/t84/t107/t98
      t660 = t114*t659
      t663 = -0.3196776D-2*t89*t93+0.191094944D-3*t648*t103
     #-0.183981056D-5*t651*t111+0.762484736D-8*t654*t120
     #-0.1247412224D-10*t660*t506
      t676 = 0.342872D-2*t89*t145-0.105194544D0*t648*t149+0.4628104D-1
     #*t651*t153+0.5908896D-3*t654*t157-0.113334912D-2*t660*t552
      t677 = t142*t676
      t690 = 0.2104392D-1*t89*t247-0.114802272D-2*t459*t89
     #+0.174812148D-4*t462*t89-0.1210543704D-6*t465*t89
     #+0.3177024768D-9*t470*t89
      vsigmabb(i) = -0.9305257363491D0*t85*t663-0.3109D-1*t130*t677
     #+t240*t690
      t696 = sigmaaa/t7/t17
      t699 = t17*t269
      t702 = t16/t4/t699
      t705 = t243*t257
      t710 = t250*t262
      t715 = t255*t469
      t722 = t260/t261/t251
      t739 = t26/t35
      t745 = t34/t7/t27/t17
      t751 = t292/t4/t27/t699
      t755 = t27**2
      t758 = t34*t16/t755/t6
      t760 = 1/t39/t22
      t768 = t49*t312
      t771 = 1/t269
      t773 = 1/t56/t46
      t774 = t771*t773
      t780 = 1/t311/t58
      t782 = t329**2
      t792 = 1/t17
      t813 = -0.1544496508763151D1/t316/t46*t792+0.3706791621031562D1
     #*t317*t771-0.854388052766047D0*t773*t792+0.2563164158298141D1
     #*t307*t771-0.4111834438919023D0/t54/t46*t792
     #+0.1644733775567609D1*t323*t771-0.5346380647307093D-1/t47/t46
     #*t792+0.3207828388384256D0*t326*t771
      t821 = t311**2
      t822 = 1/t821
      t824 = t61**2
      t825 = 1/t824
      t841 = 1/t76/t68
      t848 = 0.2D1*t375
      t850 = 0.5495599555936838D-2*t354
      t852 = 0.1748158859896213D-2*t379
      t853 = 0.2249999913366216D1*t393
      t854 = 0.3847322101863073D1*t437
      t875 = 0.1538928840745229D2*t444
      t877 = 0.1538928840745229D2*t436*t413
      t880 = t207/t209/t208
      t882 = 0.3847322101863073D2*t231*t880
      t885 = 1/t174/t165*t210
      t889 = 1/t208/t164
      t890 = t351*t889
      t900 = t428**2
      t906 = 1/t361/t165*t210
      t908 = t362*t889
      t914 = 1/t172/t165*t210
      t916 = t366*t889
      t920 = 1/t166/t165*t210
      t922 = t369*t889
      t928 = t421**2
      t931 = t226**2
      t936 = t885*t180
      t938 = t890*t180
      t942 = t353*t357*t372*t373
      t947 = t372**2
      t949 = t168/t356/t176*t947*t373
      t961 = t358*(-0.8309097827459833D0*t906+0.199418347859036D1*t908
     #-0.4945709824779306D0*t885+0.1483712947433792D1*t890
     #-0.2001071587498409D0*t914+0.8004286349993634D0*t916
     #-0.4215565168327908D-1*t920+0.2529339100996745D0*t922)*t373
      t963 = t356**2
      t966 = t179**2
      t969 = t168/t963*t947/t966
      t971 = 0.8806734334819047D-3*t885*t227-0.2642020300445714D-2
     #*t890*t227-0.8497974591333914D-1*t353*t422*t428*t429-0.2D1*t218
     #/t421/t223*t900*t429+0.1D1*t423*(-0.1544496508763151D1*t906
     #+0.3706791621031562D1*t908-0.854388052766047D0*t885
     #+0.2563164158298141D1*t890-0.4111834438919023D0*t914
     #+0.1644733775567609D1*t916-0.5346380647307093D-1*t920
     #+0.3207828388384256D0*t922)*t429+0.321646831778707D2*t218/t928
     #*t900/t931-0.1831866518645613D-2*t936+0.5495599555936838D-2*t938
     #+0.8837926660346786D-1*t942+0.2D1*t949-0.1D1*t961
     #-0.160818243221511D2*t969
      t974 = 0.1923661050931536D1*t971*t205*t211
      t975 = t439*t409
      t977 = 0.1831866518645613D-2*t936
      t979 = t353*t377*t415
      t981 = 0.5495599555936838D-2*t938
      t984 = t353*t193*t404*t213
      t987 = 0.1748158859896213D-2*t890*t378
      t988 = t206*t210
      t989 = t231*t988
      t990 = 0.2308393261117844D2*t989
      t994 = t388**2
      t997 = 0.2249999913366216D1*t184/t381/t189*t994*t392
      t999 = t435*t404*t211
      t1008 = 0.5176049209143758D-1*t353*t382*t388*t390*t214
      t1009 = -t877+t882+t974+0.1538928840745229D2*t975+t977
     #-0.1748158859896213D-2*t979-t981-0.1748158859896213D-2*t984+t987
     #+t990+t997+0.3847322101863073D1*t999+0.7599149707403056D-1*t194
     #*t404*t415+t1008
      t1010 = t408*t412
      t1011 = t231*t1010
      t1014 = 0.5827196199654043D-3*t885*t378
      t1015 = t199**2
      t1016 = 1/t1015
      t1017 = t397**2
      t1020 = 2.D0*t352
      t1022 = 2.D0*t196*t889
      t1023 = -t1020+t1022
      t1026 = t203**2
      t1027 = 1/t1026
      t1028 = t401**2
      t1034 = 0.4444444444444444D0*t1016*t1017+0.1333333333333333D1
     #*t199*t1023+0.4444444444444444D0*t1027*t1028
     #-0.1333333333333333D1*t203*t1023
      t1038 = 12.D0*t988
      t1039 = 32.D0*t1010
      t1040 = 20.D0*t880
      t1048 = t439*t413
      t1050 = 0.2D1*t949
      t1052 = t389*t391*t415
      t1054 = t381**2
      t1058 = t192**2
      t1063 = 0.3330964519106732D2*t184/t1054*t994/t1058*t205*t213
      t1066 = t389*t390*t404*t213
      t1068 = 0.1D1*t961
      t1069 = 0.160818243221511D2*t969
      t1081 = 0.1124999956683108D1*t383*(-0.1132974264373283D1*t906
     #+0.271913823449588D1*t908-0.4994648585728036D0*t885
     #+0.1498394575718411D1*t890-0.1075243117819161D0*t914
     #+0.4300972471276643D0*t916-0.4247805766949639D-1*t920
     #+0.2548683460169784D0*t922)*t392
      t1082 = 0.8837926660346786D-1*t942
      t1083 = t436*t409
      t1085 = -0.6155715362980916D2*t1011-t1014+0.3799574853701528D-1
     #*t194*t1034*t213+0.3799574853701528D-1*t194*t205*(-t1038+t1039
     #-t1040)+0.1923661050931536D1*t230*t1034*t211
     #-0.1538928840745229D2*t1048-t1050-0.2249999913366216D1*t1052
     #-t1063-0.2249999913366216D1*t1066+t1068+t1069-t1081-t1082
     #+0.1538928840745229D2*t1083
      t1088 = t848+0.7599149707403056D-1*t406+t850
     #+0.7599149707403056D-1*t417-t852-t853+t854-0.2D1*t768*t331
     #-0.8806734334819047D-3*t774*t62+0.8497974591333914D-1*t308*t452
     #+0.2D1*t50*t780*t782*t330-0.321646831778707D2*t50*t822*t782*t825
     #-0.1D1*t50*t312*t813*t330+0.3847322101863073D1*t440
     #+0.1538928840745229D2*t442-t875+t164*(t1009+t1085)
      s1 = 2.D0*t455*t473+t240*(0.2057627733333333D0*t696*t247
     #-0.453079552D-2*t702*t252+0.17329316352D-3*t705*t702
     #-0.1122511104D-1*t459*t696-0.24100443648D-5*t710*t702
     #+0.1709274336D-3*t462*t696+0.148484081664D-7*t715*t702
     #-0.11836427328D-5*t465*t696-0.33888264192D-10*t722*t702
     #+0.31064242176D-8*t470*t696)-0.4135669939329333D0/t7*t43
     #-0.24814019635976D1*t4*t301-0.9305257363491D0*t5*(
     #-0.3125736533333333D-1*t696*t13+0.3318311793777778D-2*t702*t23
     #-0.5502663247644444D-4*t739*t31+0.3942146412088889D-6*t745*t40
     #-0.13443268608D-8*t751*t298+0.1774097385244444D-11*t758*t760)
     #-0.6218D-1*t304*t347+0.2D1*t768*t332+0.8806734334819047D-3*t774
     #*t81
      v2rhoa2(i) = s1+0.2642020300445714D-2*t308*t348-0.2D1*t50*t780
     #*t782*t330*t80-0.8497974591333914D-1*t308*t312*t332+0.1D1*t313
     #*t813*t330*t80+0.2D1*t313*t331*t347+0.321646831778707D2*t50*t822
     #*t782*t825*t80-0.3109D-1*t50*t62*(0.3352526222222222D-1*t696*t65
     #-0.1781495367111111D1*t702*t69+0.1409964996266667D1*t739*t73
     #-0.1790825386666667D0*t745*t77-0.466806272D-1*t751*t344
     #+0.805937152D-2*t758*t841)+t1088*t265
      t1095 = t129*t520
      t1100 = sigmabb/t87/t97
      t1103 = t97*t477
      t1106 = t96/t84/t1103
      t1110 = t106/t115
      t1116 = t114/t87/t107/t97
      t1122 = t500/t84/t107/t1103
      t1126 = t107**2
      t1129 = t114*t96/t1126/t86
      t1131 = 1/t119/t102
      t1150 = 1/t156/t148
      t1159 = 1/t97
      t1162 = 1/t477
      t1166 = 1/t136/t126
      t1183 = -0.1544496508763151D1/t524/t126*t1159
     #+0.3706791621031562D1*t525*t1162-0.854388052766047D0*t1166*t1159
     #+0.2563164158298141D1*t515*t1162-0.4111834438919023D0/t134/t126
     #*t1159+0.1644733775567609D1*t531*t1162-0.5346380647307093D-1
     #/t127/t126*t1159+0.3207828388384256D0*t534*t1162
      t1189 = 1/t519/t138
      t1191 = t537**2
      t1196 = t1162*t1166
      t1204 = t519**2
      t1205 = 1/t1204
      t1207 = t141**2
      t1208 = 1/t1207
      t1222 = t353*t377*t569
      t1224 = -t877+t882+t974+t977-t981+t987+t990+t997+t1008
     #+0.6155715362980916D2*t1011-t1014-t1050-t1063
     #-0.1748158859896213D-2*t1222
      t1227 = t353*t193*t565*t213
      t1229 = t559**2
      t1232 = t1020+t1022
      t1235 = t562**2
      t1241 = 0.4444444444444444D0*t1016*t1229+0.1333333333333333D1
     #*t199*t1232+0.4444444444444444D0*t1027*t1235
     #-0.1333333333333333D1*t203*t1232
      t1246 = t435*t565*t211
      t1250 = t389*t390*t565*t213
      t1256 = t389*t391*t569
      t1261 = t573*t413
      t1263 = t573*t409
      t1270 = -0.1748158859896213D-2*t1227+0.3799574853701528D-1*t194
     #*t1241*t213+0.3847322101863073D1*t1246+t1068
     #-0.2249999913366216D1*t1250+0.7599149707403056D-1*t194*t565*t569
     #-0.2249999913366216D1*t1256+t1069-t1081+0.1923661050931536D1
     #*t230*t1241*t211-0.1538928840745229D2*t1261-0.1538928840745229D2
     #*t1263+0.3799574853701528D-1*t194*t205*(-t1038-t1039-t1040)
     #-t1082-0.1538928840745229D2*t1083
      t1291 = t848+t850-t852-t853+t854-0.1538928840745229D2*t442-t875
     #+0.7599149707403056D-1*t571+0.7599149707403056D-1*t567
     #+0.3847322101863073D1*t574+t164*(t1224+t1270)-0.2D1*t1095*t539
     #-0.8806734334819047D-3*t1196*t142+0.8497974591333914D-1*t516
     #*t583+0.2D1*t130*t1189*t1191*t538-0.1D1*t130*t520*t1183*t538
     #-0.321646831778707D2*t130*t1205*t1191*t1208
      s1 = -0.4135669939329333D0/t87*t123-0.24814019635976D1*t84*t509
     #+0.2D1*t1095*t540-0.9305257363491D0*t85*(-0.3125736533333333D-1
     #*t1100*t93+0.3318311793777778D-2*t1106*t103
     #-0.5502663247644444D-4*t1110*t111+0.3942146412088889D-6*t1116
     #*t120-0.13443268608D-8*t1122*t506+0.1774097385244444D-11*t1129
     #*t1131)-0.6218D-1*t512*t555-0.3109D-1*t130*t142*
     #(0.3352526222222222D-1*t1100*t145-0.1781495367111111D1*t1106
     #*t149+0.1409964996266667D1*t1110*t153-0.1790825386666667D0*t1116
     #*t157-0.466806272D-1*t1122*t552+0.805937152D-2*t1129*t1150)
     #+0.1D1*t521*t1183*t538*t160-0.2D1*t130*t1189*t1191*t538*t160
      v2rhob2(i) = s1+0.8806734334819047D-3*t1196*t161
     #-0.8497974591333914D-1*t516*t520*t540+0.2642020300445714D-2*t516
     #*t556+0.321646831778707D2*t130*t1205*t1191*t1208*t160+0.2D1*t521
     #*t539*t555+t1291*t265+2.D0*t586*t598+t240*(0.2057627733333333D0
     #*t1100*t247-0.453079552D-2*t1106*t252+0.17329316352D-3*t705
     #*t1106-0.1122511104D-1*t459*t1100-0.24100443648D-5*t710*t1106
     #+0.1709274336D-3*t462*t1100+0.148484081664D-7*t715*t1106
     #-0.11836427328D-5*t465*t1100-0.33888264192D-10*t722*t1106
     #+0.31064242176D-8*t470*t1100)
      t1329 = 0.4444444444444444D0*t1016*t397*t559
     #+0.2666666666666667D1*t199*t196*t889+0.4444444444444444D0*t1027
     #*t401*t562-0.2666666666666667D1*t203*t196*t889
      t1339 = -t877+0.1923661050931536D1*t230*t1329*t211+t882+t974
     #-0.7694644203726145D1*t975+t977-0.8740794299481065D-3*t979-t981
     #-0.8740794299481065D-3*t984+t987-0.2308393261117844D2*t989+t997
     #+0.1923661050931536D1*t999+t1008-t1014-0.7694644203726145D1
     #*t1048-t1050
      t1362 = -0.1124999956683108D1*t1052-t1063-0.8740794299481065D-3
     #*t1222-0.8740794299481065D-3*t1227-0.1124999956683108D1*t1066
     #+0.1923661050931536D1*t1246+t1068-0.1124999956683108D1*t1250
     #-0.1124999956683108D1*t1256+t1069+0.3799574853701528D-1*t194
     #*t404*t569-t1081-0.7694644203726145D1*t1261+0.7694644203726145D1
     #*t1263-t1082+0.3799574853701528D-1*t194*t565*t415
     #+0.3799574853701528D-1*t194*t1329*t213+0.3799574853701528D-1
     #*t194*t205*(t1038-t1040)
      t1365 = t850+t848-t852-t853+t568+t572+t854+t575-t875+t407+t418
     #+t441+t164*(t1339+t1362)
      t1375 = t271*sigmabb*t479
      v2rhoab(i) = t1365*t265+t455*t598+t586*t473+t240*(
     #-0.453079552D-2*t272*t252*sigmabb*t479+0.17329316352D-3*t705
     #*sigmaaa*t1375-0.24100443648D-5*t710*sigmaaa*t1375
     #+0.148484081664D-7*t715*sigmaaa*t1375-0.33888264192D-10*t722
     #*sigmaaa*t1375)
      t1393 = sigmaaa*t277
      t1396 = t16*t282
      t1399 = t26*t288
      t1402 = t34*t295
      t1407 = t292/t755/rhoa
      s1 = -0.12407009817988D1*t4*t617-0.9305257363491D0*t5*
     #(0.8524736D-2*t271*t13-0.1053271978666667D-2*t1393*t23
     #+0.1879517661866667D-4*t1396*t31-0.1402056430933333D-6*t1399*t40
     #+0.49164845056D-9*t1402*t298-0.6652865194666667D-12*t1407*t760)
     #-0.3109D-1*t304*t630+0.1321010150222857D-2*t308*t631
      v2rhoasigmaaa(i) = s1+0.1D1*t313*t331*t630-0.3109D-1*t50*t62*(
     #-0.9143253333333333D-2*t271*t65+0.5628662186666667D0*t1393*t69
     #-0.4824558336D0*t1396*t73+0.677468416D-1*t1399*t77
     #+0.1637188608D-1*t1402*t344-0.302226432D-2*t1407*t841)+t455*t644
     #+t240*(-0.5611712D-1*t271*t247+0.169904832D-2*t1393*t252
     #-0.6498493632D-4*t705*t1393+0.306139392D-2*t459*t271
     #+0.9037666368D-6*t710*t1393-0.466165728D-4*t462*t271
     #-0.55681530624D-8*t715*t1393+0.3228116544D-6*t465*t271
     #+0.12708099072D-10*t722*t1393-0.8472066048D-9*t470*t271)
      v2rhoasigmaab(i) = 0.D0
      t1463 = t272*t89
      v2rhoasigmabb(i) = t455*t690+t240*(0.169904832D-2*t272*t252*t89
     #-0.6498493632D-4*t705*t1463+0.9037666368D-6*t710*t1463
     #-0.55681530624D-8*t715*t1463+0.12708099072D-10*t722*t1463)
      t1475 = t252*t9
      t1478 = t480*t9
      v2rhobsigmaaa(i) = t586*t644+t240*(0.169904832D-2*t480*t1475
     #-0.6498493632D-4*t705*t1478+0.9037666368D-6*t710*t1478
     #-0.55681530624D-8*t715*t1478+0.12708099072D-10*t722*t1478)
      v2rhobsigmaab(i) = 0.D0
      t1493 = sigmabb*t485
      t1496 = t96*t490
      t1499 = t106*t496
      t1502 = t114*t503
      t1507 = t500/t1126/rhob
      s1 = -0.12407009817988D1*t84*t663-0.9305257363491D0*t85*
     #(0.8524736D-2*t479*t93-0.1053271978666667D-2*t1493*t103
     #+0.1879517661866667D-4*t1496*t111-0.1402056430933333D-6*t1499
     #*t120+0.49164845056D-9*t1502*t506-0.6652865194666667D-12*t1507
     #*t1131)-0.3109D-1*t512*t676+0.1321010150222857D-2*t516*t677
      v2rhobsigmabb(i) = s1+0.1D1*t521*t539*t676-0.3109D-1*t130*t142*(
     #-0.9143253333333333D-2*t479*t145+0.5628662186666667D0*t1493*t149
     #-0.4824558336D0*t1496*t153+0.677468416D-1*t1499*t157
     #+0.1637188608D-1*t1502*t552-0.302226432D-2*t1507*t1150)+t586
     #*t690+t240*(-0.5611712D-1*t479*t247+0.169904832D-2*t1493*t252
     #-0.6498493632D-4*t705*t1493+0.306139392D-2*t459*t479
     #+0.9037666368D-6*t710*t1493-0.466165728D-4*t462*t479
     #-0.55681530624D-8*t715*t1493+0.3228116544D-6*t465*t479
     #+0.12708099072D-10*t722*t1493-0.8472066048D-9*t470*t479)
      t1561 = sigmaaa*t28
      t1564 = t16*t37
      t1567 = t26*t613
      t1571 = t34/t755
      v2sigmaaa2(i) = -0.9305257363491D0*t5*(0.203882048D-3*t20*t23
     #-0.5208380672D-5*t1561*t31+0.449522688D-7*t1564*t40
     #-0.17189404672D-9*t1567*t298+0.2494824448D-12*t1571*t760)
     #-0.3109D-1*t50*t62*(-0.105880288D0*t20*t69+0.1346398976D0*t1561
     #*t73-0.259959552D-1*t1564*t77-0.500610816D-2*t1567*t344
     #+0.113334912D-2*t1571*t841)+t240*(-0.63714312D-3*t20*t252
     #+0.2436935112D-4*t705*t20-0.3389124888D-6*t710*t20
     #+0.20880573984D-8*t715*t20-0.4765537152D-11*t722*t20)
      v2sigmaaaab(i) = 0.D0
      t1605 = t9*t89
      v2sigmaaabb(i) = t240*(-0.63714312D-3*t1475*t89+0.2436935112D-4
     #*t705*t1605-0.3389124888D-6*t710*t1605+0.20880573984D-8*t715
     #*t1605-0.4765537152D-11*t722*t1605)
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t1617 = sigmabb*t108
      t1620 = t96*t117
      t1623 = t106*t659
      t1627 = t114/t1126
      v2sigmabb2(i) = -0.9305257363491D0*t85*(0.203882048D-3*t100*t103
     #-0.5208380672D-5*t1617*t111+0.449522688D-7*t1620*t120
     #-0.17189404672D-9*t1623*t506+0.2494824448D-12*t1627*t1131)
     #-0.3109D-1*t130*t142*(-0.105880288D0*t100*t149+0.1346398976D0
     #*t1617*t153-0.259959552D-1*t1620*t157-0.500610816D-2*t1623*t552
     #+0.113334912D-2*t1627*t1150)+t240*(-0.63714312D-3*t100*t252
     #+0.2436935112D-4*t705*t100-0.3389124888D-6*t710*t100
     #+0.20880573984D-8*t715*t100-0.4765537152D-11*t722*t100)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_xc_hcth147
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     A.D. Boese, N.L. Doltsinis, N.C. Handy, M. Sprik
c     New generalized gradient approximation functionals
c     J. Chem. Phys. 112 (2000) 1670-1678.
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t4 = rho**2
      t5 = t2**2
      t8 = sigma/t5/t4
      t10 = 1.D0+0.6349604207872798D-2*t8
      t14 = sigma**2
      t15 = t4**2
      t19 = t14/t2/t15/rho
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigma/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t48 = rho*(1.D0+0.1606016560364007D0*t45)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1248219874679732D2*t49
     #+0.4844076716063854D1*t45+0.2326004811900819D1*t52
     #+0.3819082618690966D0*t54))
      t62 = 1.D0+0.3174802103936399D0*t8
      t66 = t62**2
      t74 = t66**2
      t93 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t49
     #+0.2225569421150687D1*t45+0.8004286349993634D0*t52
     #+0.1897004325747559D0*t54))
      t100 = 1.D0+0.9524406311809197D-2*t8
      t104 = t100**2
      t112 = t104**2
      zk(i) = -0.7385587663820224D0*t2*rho*(0.109025D1
     #-0.5074565585306693D-2*t8/t10+0.2246538009772871D-3*t19/t20
     #-0.15021056D-5*t27/t20/t10+0.4950358691538978D-8*t36/t37)
     #-0.3109D-1*t48*t60*(0.562576D0+0.5442753734904405D-2*t8/t62
     #-0.1316728370192533D0*t19/t66+0.3383904D-1*t27/t66/t62
     #+0.8995397926676166D-2*t36/t74)+(-0.62182D-1*rho*(1.D0
     #+0.1325688999052018D0*t45)*t93+0.3109D-1*t48*t60)*(0.542352D0
     #+0.6681028149106926D-1*t8/t100-0.2574671848007491D-2*t19/t104
     #+0.302684256D-4*t27/t104/t100-0.1681070819617408D-6*t36/t112)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigma*t7
      t10 = 1.D0+0.6349604207872798D-2*t8
      t11 = 1/t10
      t14 = sigma**2
      t15 = t4**2
      t16 = t15*rho
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigma
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109025D1-0.5074565585306693D-2*t8*t11
     #+0.2246538009772871D-3*t19*t21-0.15021056D-5*t27*t29
     #+0.4950358691538978D-8*t36*t38
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1606016560364007D0*t45
      t48 = rho*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1248219874679732D2*t49+0.4844076716063854D1*t45
     #+0.2326004811900819D1*t52+0.3819082618690966D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.3174802103936399D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.562576D0+0.5442753734904405D-2*t8*t63
     #-0.1316728370192533D0*t19*t67+0.3383904D-1*t27*t71
     #+0.8995397926676166D-2*t36*t75
      t79 = t60*t78
      t83 = 1.D0+0.1325688999052018D0*t45
      t89 = 0.598255043577108D1*t49+0.2225569421150687D1*t45
     #+0.8004286349993634D0*t52+0.1897004325747559D0*t54
      t92 = 1.D0+0.160818243221511D2/t89
      t93 = dlog(t92)
      t98 = -0.62182D-1*rho*t83*t93+0.3109D-1*t48*t60
      t100 = 1.D0+0.9524406311809197D-2*t8
      t101 = 1/t100
      t104 = t100**2
      t105 = 1/t104
      t109 = 1/t104/t100
      t112 = t104**2
      t113 = 1/t112
      t116 = 0.542352D0+0.6681028149106926D-1*t8*t101
     #-0.2574671848007491D-2*t19*t105+0.302684256D-4*t27*t109
     #-0.1681070819617408D-6*t36*t113
      zk(i) = -0.7385587663820224D0*t3*t41-0.3109D-1*t48*t79+t98*t116
      t120 = t4*rho
      t123 = sigma/t5/t120
      t126 = t15*t4
      t129 = t14/t2/t126
      t134 = t24/t25/rho
      t140 = t32/t5/t25/t120
      t147 = t32*sigma/t2/t25/t126
      t149 = 1/t37/t10
      t155 = t47*t60
      t158 = 1/t54
      t159 = t44*t158
      t162 = t56**2
      t163 = 1/t162
      t165 = t49**2
      t166 = t165**2
      t169 = 1/t4
      t170 = 1/t166/t49*t169
      t172 = t158*t169
      t175 = 1/t52*t169
      t178 = 1/t45*t169
      t180 = -0.4160732915599108D1*t170-0.3229384477375903D1*t172
     #-0.2326004811900819D1*t175-0.5092110158254621D0*t178
      t181 = 1/t59
      t195 = 1/t74/t62
      t206 = t89**2
      t238 = 1/t112/t100
      s1 = -0.9847450218426965D0*t2*t41-0.3692793831910112D0*t3*
     #(0.2706434978830236D-1*t123*t11-0.2568155119723541D-2*t129*t21
     #+0.3924929194666667D-4*t134*t29-0.2582120687010336D-6*t140*t38
     #+0.6705667920698789D-9*t147*t149)-0.3109D-1*t155*t78
     #+0.1664368495390566D-2*t159*t79
      vrhoa(i) = s1+0.5D0*t48*t163*t180*t181*t78-0.15545D-1*t48*t60*(
     #-0.2902801991949016D-1*t123*t63+0.1413726083410053D1*t129*t67
     #-0.9873288533333333D0*t134*t71-0.2001021381625746D-1*t140*t75
     #+0.6092503096182744D-1*t147*t195)+(-0.62182D-1*t83*t93+rho*
     #(0.2747799777968419D-2*t172*t93+0.1D1*t83/t206*(
     #-0.99709173929518D0*t170-0.7418564737168958D0*t172
     #-0.4002143174996817D0*t175-0.1264669550498372D0*t178)/t92)
     #+0.3109D-1*t155-0.1664368495390566D-2*t159*t60-0.5D0*t48*t163
     #*t180*t181)*t116+t98*(-0.1781607506428514D0*t123*t101
     #+0.1542845856731273D-1*t129*t105-0.3729325824D-3*t134*t109
     #+0.4099452478257239D-5*t140*t113-0.1707861495995979D-7*t147*t238)
      t245 = sigma*t18
      t248 = t14*t26
      t251 = t24*t35
      t257 = t32/t2/t25/t16
      vsigmaaa(i) = -0.7385587663820224D0*t3*(-0.2029826234122677D-1
     #*t7*t11+0.1926116339792656D-2*t245*t21-0.2943696896D-4*t248*t29
     #+0.1936590515257752D-6*t251*t38-0.5029250940524092D-9*t257*t149)
     #-0.3109D-1*t48*t60*(0.2177101493961762D-1*t7*t63
     #-0.1060294562557539D1*t245*t67+0.74049664D0*t248*t71
     #+0.150076603621931D-1*t251*t75-0.4569377322137058D-1*t257*t195)
     #+2.D0*t98*(0.1336205629821385D0*t7*t101-0.1157134392548454D-1
     #*t245*t105+0.2796994368D-3*t248*t109-0.3074589358692929D-5*t251
     #*t113+0.1280896121996984D-7*t257*t238)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigma*t7
      t10 = 1.D0+0.6349604207872798D-2*t8
      t11 = 1/t10
      t14 = sigma**2
      t15 = t4**2
      t16 = t15*rho
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigma
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109025D1-0.5074565585306693D-2*t8*t11
     #+0.2246538009772871D-3*t19*t21-0.15021056D-5*t27*t29
     #+0.4950358691538978D-8*t36*t38
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1606016560364007D0*t45
      t48 = rho*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1248219874679732D2*t49+0.4844076716063854D1*t45
     #+0.2326004811900819D1*t52+0.3819082618690966D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.3174802103936399D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.562576D0+0.5442753734904405D-2*t8*t63
     #-0.1316728370192533D0*t19*t67+0.3383904D-1*t27*t71
     #+0.8995397926676166D-2*t36*t75
      t79 = t60*t78
      t83 = 1.D0+0.1325688999052018D0*t45
      t89 = 0.598255043577108D1*t49+0.2225569421150687D1*t45
     #+0.8004286349993634D0*t52+0.1897004325747559D0*t54
      t92 = 1.D0+0.160818243221511D2/t89
      t93 = dlog(t92)
      t98 = -0.62182D-1*rho*t83*t93+0.3109D-1*t48*t60
      t100 = 1.D0+0.9524406311809197D-2*t8
      t101 = 1/t100
      t104 = t100**2
      t105 = 1/t104
      t109 = 1/t104/t100
      t112 = t104**2
      t113 = 1/t112
      t116 = 0.542352D0+0.6681028149106926D-1*t8*t101
     #-0.2574671848007491D-2*t19*t105+0.302684256D-4*t27*t109
     #-0.1681070819617408D-6*t36*t113
      zk(i) = -0.7385587663820224D0*t3*t41-0.3109D-1*t48*t79+t98*t116
      t120 = t4*rho
      t122 = 1/t5/t120
      t123 = sigma*t122
      t126 = t15*t4
      t128 = 1/t2/t126
      t129 = t14*t128
      t133 = 1/t25/rho
      t134 = t24*t133
      t139 = 1/t5/t25/t120
      t140 = t32*t139
      t143 = t32*sigma
      t146 = 1/t2/t25/t126
      t147 = t143*t146
      t149 = 1/t37/t10
      t152 = 0.2706434978830236D-1*t123*t11-0.2568155119723541D-2*t129
     #*t21+0.3924929194666667D-4*t134*t29-0.2582120687010336D-6*t140
     #*t38+0.6705667920698789D-9*t147*t149
      t155 = t47*t60
      t158 = 1/t54
      t159 = t44*t158
      t162 = t56**2
      t163 = 1/t162
      t164 = t48*t163
      t165 = t49**2
      t166 = t165**2
      t167 = t166*t49
      t168 = 1/t167
      t169 = 1/t4
      t170 = t168*t169
      t172 = t158*t169
      t174 = 1/t52
      t175 = t174*t169
      t177 = 1/t45
      t178 = t177*t169
      t180 = -0.4160732915599108D1*t170-0.3229384477375903D1*t172
     #-0.2326004811900819D1*t175-0.5092110158254621D0*t178
      t181 = 1/t59
      t182 = t180*t181
      t183 = t182*t78
      t195 = 1/t74/t62
      t198 = -0.2902801991949016D-1*t123*t63+0.1413726083410053D1*t129
     #*t67-0.9873288533333333D0*t134*t71-0.2001021381625746D-1*t140
     #*t75+0.6092503096182744D-1*t147*t195
      t199 = t60*t198
      t204 = t172*t93
      t206 = t89**2
      t207 = 1/t206
      t208 = t83*t207
      t213 = -0.99709173929518D0*t170-0.7418564737168958D0*t172
     #-0.4002143174996817D0*t175-0.1264669550498372D0*t178
      t214 = 1/t92
      t216 = t208*t213*t214
      t224 = t163*t180*t181
      t227 = -0.62182D-1*t83*t93+rho*(0.2747799777968419D-2*t204+0.1D1
     #*t216)+0.3109D-1*t155-0.1664368495390566D-2*t159*t60-0.5D0*t48
     #*t224
      t238 = 1/t112/t100
      t241 = -0.1781607506428514D0*t123*t101+0.1542845856731273D-1
     #*t129*t105-0.3729325824D-3*t134*t109+0.4099452478257239D-5*t140
     #*t113-0.1707861495995979D-7*t147*t238
      vrhoa(i) = -0.9847450218426965D0*t2*t41-0.3692793831910112D0*t3
     #*t152-0.3109D-1*t155*t78+0.1664368495390566D-2*t159*t79+0.5D0
     #*t164*t183-0.15545D-1*t48*t199+t227*t116+t98*t241
      t245 = sigma*t18
      t248 = t14*t26
      t251 = t24*t35
      t256 = 1/t2/t25/t16
      t257 = t32*t256
      t260 = -0.2029826234122677D-1*t7*t11+0.1926116339792656D-2*t245
     #*t21-0.2943696896D-4*t248*t29+0.1936590515257752D-6*t251*t38
     #-0.5029250940524092D-9*t257*t149
      t273 = 0.2177101493961762D-1*t7*t63-0.1060294562557539D1*t245
     #*t67+0.74049664D0*t248*t71+0.150076603621931D-1*t251*t75
     #-0.4569377322137058D-1*t257*t195
      t274 = t60*t273
      t287 = 0.1336205629821385D0*t7*t101-0.1157134392548454D-1*t245
     #*t105+0.2796994368D-3*t248*t109-0.3074589358692929D-5*t251*t113
     #+0.1280896121996984D-7*t257*t238
      vsigmaaa(i) = -0.7385587663820224D0*t3*t260-0.3109D-1*t48*t274
     #+2.D0*t98*t287
      t294 = sigma/t5/t15
      t297 = t15*t120
      t300 = t14/t2/t297
      t301 = t300*t105
      t304 = t24/t33
      t305 = t304*t109
      t310 = t32/t5/t25/t15
      t311 = t310*t113
      t316 = t143/t2/t25/t297
      t317 = t316*t238
      t320 = t25**2
      t323 = t32*t14/t320/t4
      t325 = 1/t112/t104
      t327 = 0.2168848908288D-8*t323*t325
      t337 = t47*t163
      t351 = 1/t37/t20
      t360 = t162**2
      t361 = 1/t360
      t363 = t180**2
      t364 = t59**2
      t365 = 1/t364
      t372 = 1/t15
      t373 = 1/t167/t44*t372
      t375 = 1/t120
      t376 = t168*t375
      t379 = 1/t54/t44
      t380 = t379*t372
      t382 = t158*t375
      t386 = 1/t52/t44*t372
      t388 = t174*t375
      t392 = 1/t45/t44*t372
      t394 = t177*t375
      t396 = -0.6934554859331846D1*t373+0.1664293166239643D2*t376
     #-0.4305845969834537D1*t380+0.1291753790950361D2*t382
     #-0.2326004811900819D1*t386+0.9304019247603276D1*t388
     #-0.3394740105503081D0*t392+0.2036844063301848D1*t394
      t402 = 1/t162/t56
      t408 = t375*t379
      t424 = 0.5495599555936838D-2*t204
      t425 = 0.2D1*t216
      t431 = t213**2
      t434 = 0.2D1*t83/t206/t89*t431*t214
      t446 = 0.1D1*t208*(-0.8309097827459833D0*t373
     #+0.199418347859036D1*t376-0.4945709824779306D0*t380
     #+0.1483712947433792D1*t382-0.2001071587498409D0*t386
     #+0.8004286349993634D0*t388-0.4215565168327908D-1*t392
     #+0.2529339100996745D0*t394)*t214
      t447 = t206**2
      t450 = t92**2
      t454 = 0.160818243221511D2*t83/t447*t431/t450
      t456 = 0.1831866518645613D-2*t380*t93
      t458 = 0.5495599555936838D-2*t382*t93
      t469 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t49
     #+0.2247591863577616D1*t45+0.4300972471276643D0*t52
     #+0.1911512595127338D0*t54))
      t471 = (1.D0+0.6901399211255825D-1*t45)*t469*t169
      t476 = 0.8837926660346786D-1*t172*t207*t213*t214
      t500 = 1/t74/t66
      s1 = 4.D0*t227*t241+t98*(0.130651217138091D1*t294*t101
     #-0.1588095866809658D0*t301+0.550752955392D-2*t305
     #-0.9127396286679657D-4*t311+0.723893480573944D-6*t317-t327)
     #-0.6564966812284644D0/t5*t41-0.1969490043685393D1*t2*t152
     #-0.6218D-1*t155*t198+0.2D1*t337*t183-0.3692793831910112D0*t3*(
     #-0.1984718984475507D0*t294*t11+0.334464870327603D-1*t300*t21
     #-0.8804261196231111D-3*t304*t29+0.100124277785001D-4*t310*t38
     #-0.5419986271555248D-7*t316*t149+0.1135422326556444D-9*t323*t351
     #)+0.1D1*t164*t182*t198+0.1608234158893535D2*t48*t361*t363*t365*t78
      s2 = s1+0.5D0*t164*t396*t181*t78-0.1D1*t48*t402*t363*t181*t78
     #+0.2219157993854088D-2*t408*t79-0.1070677706909338D0*t159*t163
     #*t183
      v2rhoa2(i) = s2+0.3328736990781132D-2*t159*t199+(-0.5D0*t48*t163
     #*t396*t181-0.1608234158893535D2*t48*t361*t363*t365+t424+t425
     #-0.2D1*t337*t182+rho*(-t434+t446+t454+t456-t458
     #+0.3377399869956914D-1*t471-t476)+0.1070677706909338D0*t159*t224
     #+0.1D1*t48*t402*t363*t181-0.2219157993854088D-2*t408*t60)*t116
     #-0.15545D-1*t48*t60*(0.2128721460762612D0*t294*t63
     #-0.1795634810650787D2*t300*t67+0.2255943994026667D2*t304*t71
     #-0.4548412964297639D1*t310*t75-0.1882044954610406D1*t316*t195
     #+0.51579977728D0*t323*t500)+(t424+t425+rho*(-t434+t446+t454+t456
     #-t458-0.3377399869956914D-1*t471-t476))*t116+t98*(
     #-0.456675571873391D-1*t301+0.277269061632D-2*t305
     #-0.6121131135957682D-4*t311+0.5986503042009055D-6*t317-t327)
      t522 = sigma*t128
      t525 = t14*t133
      t528 = t24*t139
      t531 = t32*t146
      t536 = t143/t320/rho
      t569 = t522*t105
      t571 = t525*t109
      t573 = t528*t113
      t575 = t531*t238
      t578 = 0.1626636681216D-8*t536*t325
      s1 = -0.9847450218426965D0*t2*t260-0.3692793831910112D0*t3*
     #(0.1082573991532094D0*t122*t11-0.2123263259498491D-1*t522*t21
     #+0.6014456517973333D-3*t525*t29-0.7122002730823528D-5*t528*t38
     #+0.3964404684855954D-7*t531*t149-0.8515667449173333D-10*t536
     #*t351)-0.3109D-1*t155*t273+0.1664368495390566D-2*t159*t274
      v2rhoasigmaaa(i) = s1+0.5D0*t164*t182*t273-0.15545D-1*t48*t60*(
     #-0.1161120796779606D0*t122*t63+0.1134667195476582D2*t522*t67
     #-0.154385866752D2*t525*t71+0.3441325043947615D1*t528*t75
     #+0.1320146169515063D1*t531*t195-0.38684983296D0*t536*t500)+2.D0
     #*t227*t287+t98*(-0.7126430025714055D0*t122*t101
     #+0.9596450215975523D-1*t569-0.357124829184D-2*t571
     #+0.6230629343271157D-4*t573-0.5173021879905183D-6*t575+t578)+t98
     #*(0.3425066789050433D-1*t569-0.207951796224D-2*t571
     #+0.4590848351968261D-4*t573-0.4489877281506791D-6*t575+t578)
      t589 = sigma*t26
      t592 = t14*t35
      t595 = t24*t256
      t599 = t32/t320
      v2sigmaaa2(i) = -0.7385587663820224D0*t3*(0.8220009087068062D-2
     #*t18*t21-0.333336363008D-3*t589*t29+0.4566865842014545D-5*t592
     #*t38-0.2772133476021002D-7*t595*t149+0.638675058688D-10*t599
     #*t351)-0.3109D-1*t48*t60*(-0.4268825715844209D1*t18*t67
     #+0.86169534464D1*t589*t71-0.2641024424409484D1*t592*t75
     #-0.8073345342508149D0*t595*t195+0.29013737472D0*t599*t500)+4.D0
     #*t98*(-0.2568800091787825D-1*t18*t105+0.155963847168D-2*t589
     #*t109-0.3443136263976196D-4*t592*t113+0.3367407961130093D-6*t595
     #*t238-0.1219977510912D-8*t599*t325)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:XC_HCTH147subrend
c:XC_HCTH120subrstart

c    Generated: Sat May  8 18:39:42 GMT 2004

      subroutine uks_xc_hcth120
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     A.D. Boese, N.L. Doltsinis, N.C. Handy, M. Sprik
c     New generalized gradient approximation functionals
c     J. Chem. Phys. 112 (2000) 1670-1678.
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t4 = rhob**2
      t5 = t2**2
      t8 = sigmabb/t5/t4
      t10 = 1.D0+0.4D-2*t8
      t14 = sigmabb**2
      t15 = t4**2
      t19 = t14/t2/t15/rhob
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigmabb/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t49
     #+0.3844746237447211D1*t45+0.1644733775567609D1*t52
     #+0.2405871291288192D0*t54))
      t62 = 1.D0+0.2D0*t8
      t66 = t62**2
      t74 = t66**2
      zk(i) = -0.9305257363491D0*t2*rhob*(0.109163D1-0.298886D-2*t8
     #/t10+0.8125328D-4*t19/t20-0.26287744D-6*t27/t20/t10
     #+0.29996288D-9*t36/t37)-0.3109D-1*rhob*(1.D0
     #+0.1274696188700087D0*t45)*t60*(0.489508D0-0.521398D-1*t8/t62
     #+0.1731668D-1*t19/t66-0.1593976D-1*t27/t66/t62+0.3976496D-2*t36
     #/t74)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t4 = rhoa**2
      t5 = t2**2
      t8 = sigmaaa/t5/t4
      t10 = 1.D0+0.4D-2*t8
      t14 = sigmaaa**2
      t15 = t4**2
      t19 = t14/t2/t15/rhoa
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigmaaa/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t49
     #+0.3844746237447211D1*t45+0.1644733775567609D1*t52
     #+0.2405871291288192D0*t54))
      t62 = 1.D0+0.2D0*t8
      t66 = t62**2
      t74 = t66**2
      zk(i) = -0.9305257363491D0*t2*rhoa*(0.109163D1-0.298886D-2*t8
     #/t10+0.8125328D-4*t19/t20-0.26287744D-6*t27/t20/t10
     #+0.29996288D-9*t36/t37)-0.3109D-1*rhoa*(1.D0
     #+0.1274696188700087D0*t45)*t60*(0.489508D0-0.521398D-1*t8/t62
     #+0.1731668D-1*t19/t66-0.1593976D-1*t27/t66/t62+0.3976496D-2*t36
     #/t74)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t6 = rhoa**2
      t7 = t4**2
      t10 = sigmaaa/t7/t6
      t12 = 1.D0+0.4D-2*t10
      t16 = sigmaaa**2
      t17 = t6**2
      t21 = t16/t4/t17/rhoa
      t22 = t12**2
      t27 = t17**2
      t29 = t16*sigmaaa/t27
      t34 = t16**2
      t38 = t34/t7/t27/t6
      t39 = t22**2
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t50 = rhoa*(1.D0+0.1274696188700087D0*t47)
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t62 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t51
     #+0.3844746237447211D1*t47+0.1644733775567609D1*t54
     #+0.2405871291288192D0*t56))
      t64 = 1.D0+0.2D0*t10
      t68 = t64**2
      t76 = t68**2
      t84 = rhob**(1.D0/3.D0)
      t86 = rhob**2
      t87 = t84**2
      t90 = sigmabb/t87/t86
      t92 = 1.D0+0.4D-2*t90
      t96 = sigmabb**2
      t97 = t86**2
      t101 = t96/t84/t97/rhob
      t102 = t92**2
      t107 = t97**2
      t109 = t96*sigmabb/t107
      t114 = t96**2
      t118 = t114/t87/t107/t86
      t119 = t102**2
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t130 = rhob*(1.D0+0.1274696188700087D0*t127)
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t142 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t131
     #+0.3844746237447211D1*t127+0.1644733775567609D1*t134
     #+0.2405871291288192D0*t136))
      t144 = 1.D0+0.2D0*t90
      t148 = t144**2
      t156 = t148**2
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t180 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t169
     #+0.2225569421150687D1*t166+0.8004286349993634D0*t172
     #+0.1897004325747559D0*t174))
      t182 = 0.62182D-1*(1.D0+0.1325688999052018D0*t166)*t180
      t193 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t169
     #+0.2247591863577616D1*t166+0.4300972471276643D0*t172
     #+0.1911512595127338D0*t174))
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t211 = t207/t209
      t227 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t169
     #+0.3844746237447211D1*t166+0.1644733775567609D1*t172
     #+0.2405871291288192D0*t174))
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t250 = t243**2
      t251 = t246**2
      t260 = t250**2
      t261 = t251**2
      s1 = -0.9305257363491D0*t4*rhoa*(0.109163D1-0.298886D-2*t10/t12
     #+0.8125328D-4*t21/t22-0.26287744D-6*t29/t22/t12+0.29996288D-9
     #*t38/t39)-0.3109D-1*t50*t62*(0.489508D0-0.521398D-1*t10/t64
     #+0.1731668D-1*t21/t68-0.1593976D-1*t29/t68/t64+0.3976496D-2*t38
     #/t76)
      s2 = s1-0.9305257363491D0*t84*rhob*(0.109163D1-0.298886D-2*t90
     #/t92+0.8125328D-4*t101/t102-0.26287744D-6*t109/t102/t92
     #+0.29996288D-9*t118/t119)
      zk(i) = s2-0.3109D-1*t130*t142*(0.489508D0-0.521398D-1*t90/t144
     #+0.1731668D-1*t101/t148-0.1593976D-1*t109/t148/t144+0.3976496D-2
     #*t118/t156)+(t164*(-t182+0.3799574853701528D-1*(1.D0
     #+0.6901399211255825D-1*t166)*t193*t205*(1.D0-1.D0*t211)
     #+0.1923661050931536D1*(-0.3109D-1*(1.D0+0.1274696188700087D0
     #*t166)*t227+t182)*t205*t211)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142)*(0.51473D0+0.4157892D-1*t243/t246-0.8894628D-3*t250/t251
     #+0.49917168D-5*t250*t243/t251/t246-0.146751264D-7*t260/t261)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmabb*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmabb**2
      t15 = t4**2
      t16 = t15*rhob
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmabb
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109163D1-0.298886D-2*t8*t11+0.8125328D-4*t19*t21
     #-0.26287744D-6*t27*t29+0.29996288D-9*t36*t38
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhob*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.489508D0-0.521398D-1*t8*t63+0.1731668D-1*t19*t67
     #-0.1593976D-1*t27*t71+0.3976496D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      vrhoa(i) = 0.D0
      t84 = t4*rhob
      t87 = sigmabb/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhob
      t104 = t32/t5/t25/t84
      t111 = t32*sigmabb/t2/t25/t90
      t113 = 1/t37/t10
      t122 = 1/t54
      t126 = t56**2
      t129 = t49**2
      t130 = t129**2
      t133 = 1/t4
      t159 = 1/t74/t62
      vrhob(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*
     #(0.7970293333333333D-2*t87*t11-0.465232D-3*t93*t21
     #+0.3836422826666667D-5*t98*t29-0.1161168213333333D-7*t104*t38
     #+0.1279841621333333D-10*t111*t113)-0.3109D-1*t47*t60*t78
     #+0.1321010150222857D-2*t44*t122*t79+0.1D1*t48/t126*(
     #-0.1853395810515781D1/t130/t49*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0/t52*t133-0.1603914194192128D0/t45
     #*t133)/t59*t78-0.3109D-1*t48*t60*(0.1390394666666667D0*t87*t63
     #-0.12016352D0*t93*t67+0.1459892053333333D0*t98*t71
     #-0.6791957333333333D-1*t104*t75+0.8483191466666667D-2*t111*t159)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t168 = sigmabb*t18
      t171 = t14*t26
      t174 = t24*t35
      t180 = t32/t2/t25/t16
      vsigmabb(i) = -0.9305257363491D0*t3*(-0.298886D-2*t7*t11
     #+0.174462D-3*t168*t21-0.143865856D-5*t171*t29+0.43543808D-8*t174
     #*t38-0.479940608D-11*t180*t113)-0.3109D-1*t48*t60*(-0.521398D-1
     #*t7*t63+0.4506132D-1*t168*t67-0.54745952D-1*t171*t71
     #+0.2546984D-1*t174*t75-0.31811968D-2*t180*t159)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmaaa*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmaaa**2
      t15 = t4**2
      t16 = t15*rhoa
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmaaa
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109163D1-0.298886D-2*t8*t11+0.8125328D-4*t19*t21
     #-0.26287744D-6*t27*t29+0.29996288D-9*t36*t38
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhoa*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.489508D0-0.521398D-1*t8*t63+0.1731668D-1*t19*t67
     #-0.1593976D-1*t27*t71+0.3976496D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      t84 = t4*rhoa
      t87 = sigmaaa/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhoa
      t104 = t32/t5/t25/t84
      t111 = t32*sigmaaa/t2/t25/t90
      t113 = 1/t37/t10
      t122 = 1/t54
      t126 = t56**2
      t129 = t49**2
      t130 = t129**2
      t133 = 1/t4
      t159 = 1/t74/t62
      vrhoa(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*
     #(0.7970293333333333D-2*t87*t11-0.465232D-3*t93*t21
     #+0.3836422826666667D-5*t98*t29-0.1161168213333333D-7*t104*t38
     #+0.1279841621333333D-10*t111*t113)-0.3109D-1*t47*t60*t78
     #+0.1321010150222857D-2*t44*t122*t79+0.1D1*t48/t126*(
     #-0.1853395810515781D1/t130/t49*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0/t52*t133-0.1603914194192128D0/t45
     #*t133)/t59*t78-0.3109D-1*t48*t60*(0.1390394666666667D0*t87*t63
     #-0.12016352D0*t93*t67+0.1459892053333333D0*t98*t71
     #-0.6791957333333333D-1*t104*t75+0.8483191466666667D-2*t111*t159)
      vrhob(i) = 0.D0
      t168 = sigmaaa*t18
      t171 = t14*t26
      t174 = t24*t35
      t180 = t32/t2/t25/t16
      vsigmaaa(i) = -0.9305257363491D0*t3*(-0.298886D-2*t7*t11
     #+0.174462D-3*t168*t21-0.143865856D-5*t171*t29+0.43543808D-8*t174
     #*t38-0.479940608D-11*t180*t113)-0.3109D-1*t48*t60*(-0.521398D-1
     #*t7*t63+0.4506132D-1*t168*t67-0.54745952D-1*t171*t71
     #+0.2546984D-1*t174*t75-0.31811968D-2*t180*t159)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t9 = 1/t7/t6
      t10 = sigmaaa*t9
      t12 = 1.D0+0.4D-2*t10
      t13 = 1/t12
      t16 = sigmaaa**2
      t17 = t6**2
      t18 = t17*rhoa
      t20 = 1/t4/t18
      t21 = t16*t20
      t22 = t12**2
      t23 = 1/t22
      t26 = t16*sigmaaa
      t27 = t17**2
      t28 = 1/t27
      t29 = t26*t28
      t31 = 1/t22/t12
      t34 = t16**2
      t37 = 1/t7/t27/t6
      t38 = t34*t37
      t39 = t22**2
      t40 = 1/t39
      t43 = 0.109163D1-0.298886D-2*t10*t13+0.8125328D-4*t21*t23
     #-0.26287744D-6*t29*t31+0.29996288D-9*t38*t40
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t49 = 1.D0+0.1274696188700087D0*t47
      t50 = rhoa*t49
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t58 = 0.1112037486309468D2*t51+0.3844746237447211D1*t47
     #+0.1644733775567609D1*t54+0.2405871291288192D0*t56
      t61 = 1.D0+0.321646831778707D2/t58
      t62 = dlog(t61)
      t64 = 1.D0+0.2D0*t10
      t65 = 1/t64
      t68 = t64**2
      t69 = 1/t68
      t73 = 1/t68/t64
      t76 = t68**2
      t77 = 1/t76
      t80 = 0.489508D0-0.521398D-1*t10*t65+0.1731668D-1*t21*t69
     #-0.1593976D-1*t29*t73+0.3976496D-2*t38*t77
      t81 = t62*t80
      t84 = rhob**(1.D0/3.D0)
      t85 = t84*rhob
      t86 = rhob**2
      t87 = t84**2
      t89 = 1/t87/t86
      t90 = sigmabb*t89
      t92 = 1.D0+0.4D-2*t90
      t93 = 1/t92
      t96 = sigmabb**2
      t97 = t86**2
      t98 = t97*rhob
      t100 = 1/t84/t98
      t101 = t96*t100
      t102 = t92**2
      t103 = 1/t102
      t106 = t96*sigmabb
      t107 = t97**2
      t108 = 1/t107
      t109 = t106*t108
      t111 = 1/t102/t92
      t114 = t96**2
      t117 = 1/t87/t107/t86
      t118 = t114*t117
      t119 = t102**2
      t120 = 1/t119
      t123 = 0.109163D1-0.298886D-2*t90*t93+0.8125328D-4*t101*t103
     #-0.26287744D-6*t109*t111+0.29996288D-9*t118*t120
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t129 = 1.D0+0.1274696188700087D0*t127
      t130 = rhob*t129
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t138 = 0.1112037486309468D2*t131+0.3844746237447211D1*t127
     #+0.1644733775567609D1*t134+0.2405871291288192D0*t136
      t141 = 1.D0+0.321646831778707D2/t138
      t142 = dlog(t141)
      t144 = 1.D0+0.2D0*t90
      t145 = 1/t144
      t148 = t144**2
      t149 = 1/t148
      t153 = 1/t148/t144
      t156 = t148**2
      t157 = 1/t156
      t160 = 0.489508D0-0.521398D-1*t90*t145+0.1731668D-1*t101*t149
     #-0.1593976D-1*t109*t153+0.3976496D-2*t118*t157
      t161 = t142*t160
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t168 = 1.D0+0.1325688999052018D0*t166
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t176 = 0.598255043577108D1*t169+0.2225569421150687D1*t166
     #+0.8004286349993634D0*t172+0.1897004325747559D0*t174
      t179 = 1.D0+0.160818243221511D2/t176
      t180 = dlog(t179)
      t182 = 0.62182D-1*t168*t180
      t184 = 1.D0+0.6901399211255825D-1*t166
      t189 = 0.8157414703487641D1*t169+0.2247591863577616D1*t166
     #+0.4300972471276643D0*t172+0.1911512595127338D0*t174
      t192 = 1.D0+0.2960857464321668D2/t189
      t193 = dlog(t192)
      t194 = t184*t193
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t210 = 1/t209
      t211 = t207*t210
      t213 = 1.D0-1.D0*t211
      t216 = 0.3799574853701528D-1*t194*t205*t213
      t218 = 1.D0+0.1274696188700087D0*t166
      t223 = 0.1112037486309468D2*t169+0.3844746237447211D1*t166
     #+0.1644733775567609D1*t172+0.2405871291288192D0*t174
      t226 = 1.D0+0.321646831778707D2/t223
      t227 = dlog(t226)
      t230 = -0.3109D-1*t218*t227+t182
      t231 = t230*t205
      t233 = 0.1923661050931536D1*t231*t211
      t240 = t164*(-t182+t216+t233)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t247 = 1/t246
      t250 = t243**2
      t251 = t246**2
      t252 = 1/t251
      t255 = t250*t243
      t257 = 1/t251/t246
      t260 = t250**2
      t261 = t251**2
      t262 = 1/t261
      t265 = 0.51473D0+0.4157892D-1*t243*t247-0.8894628D-3*t250*t252
     #+0.49917168D-5*t255*t257-0.146751264D-7*t260*t262
      zk(i) = -0.9305257363491D0*t5*t43-0.3109D-1*t50*t81
     #-0.9305257363491D0*t85*t123-0.3109D-1*t130*t161+t240*t265
      t269 = t6*rhoa
      t272 = sigmaaa/t7/t269
      t275 = t17*t6
      t278 = t16/t4/t275
      t283 = t26/t27/rhoa
      t289 = t34/t7/t27/t269
      t296 = t34*sigmaaa/t4/t27/t275
      t298 = 1/t39/t12
      t304 = t49*t62
      t307 = 1/t56
      t308 = t46*t307
      t311 = t58**2
      t312 = 1/t311
      t314 = t51**2
      t315 = t314**2
      t318 = 1/t6
      t329 = -0.1853395810515781D1/t315/t51*t318-0.128158207914907D1
     #*t307*t318-0.8223668877838045D0/t54*t318-0.1603914194192128D0
     #/t47*t318
      t330 = 1/t61
      t344 = 1/t76/t64
      t352 = 1/t208
      t353 = 1/t174*t352
      t354 = t353*t180
      t355 = 0.2747799777968419D-2*t354
      t356 = t176**2
      t359 = t169**2
      t360 = t359**2
      t363 = 1/t360/t169*t352
      t367 = 1/t172*t352
      t370 = 1/t166*t352
      t375 = t168/t356*(-0.99709173929518D0*t363-0.7418564737168958D0
     #*t353-0.4002143174996817D0*t367-0.1264669550498372D0*t370)/t179
      t376 = 0.1D1*t375
      t380 = 0.8740794299481065D-3*t353*t193*t205*t213
      t381 = t189**2
      t394 = 0.1124999956683108D1*t184/t381*(-0.135956911724794D1*t363
     #-0.7491972878592054D0*t353-0.2150486235638321D0*t367
     #-0.1274341730084892D0*t370)/t192*t205*t213
      t395 = t196*t352
      t396 = 1.D0*t395
      t400 = 1.D0*t165
      t404 = 0.1333333333333333D1*t199*(t165-t396)
     #+0.1333333333333333D1*t203*(-t400+t395)
      t409 = t206*t196*t210
      t410 = 4.D0*t409
      t413 = t207/t209/t164
      t414 = 4.D0*t413
      t421 = t223**2
      t438 = 0.1923661050931536D1*(0.1321010150222857D-2*t353*t227
     #+0.1D1*t218/t421*(-0.1853395810515781D1*t363-0.128158207914907D1
     #*t353-0.8223668877838045D0*t367-0.1603914194192128D0*t370)/t226
     #-0.2747799777968419D-2*t354-0.1D1*t375)*t205*t211
      t442 = t231*t409
      t445 = 0.7694644203726145D1*t231*t413
      t459 = t243*t252
      t462 = t250*t257
      t465 = t255*t262
      t470 = t260/t261/t246
      s1 = -0.12407009817988D1*t4*t43-0.9305257363491D0*t5*
     #(0.7970293333333333D-2*t272*t13-0.465232D-3*t278*t23
     #+0.3836422826666667D-5*t283*t31-0.1161168213333333D-7*t289*t40
     #+0.1279841621333333D-10*t296*t298)-0.3109D-1*t304*t80
     #+0.1321010150222857D-2*t308*t81
      vrhoa(i) = s1+0.1D1*t50*t312*t329*t330*t80-0.3109D-1*t50*t62*
     #(0.1390394666666667D0*t272*t65-0.12016352D0*t278*t69
     #+0.1459892053333333D0*t283*t73-0.6791957333333333D-1*t289*t77
     #+0.8483191466666667D-2*t296*t344)+(-t182+t216+t233+t164*(t355
     #+t376-t380-t394+0.3799574853701528D-1*t194*t404*t213
     #+0.3799574853701528D-1*t194*t205*(-t410+t414)+t438
     #+0.1923661050931536D1*t230*t404*t211+0.7694644203726145D1*t442
     #-t445)+0.3109D-1*t304-0.1321010150222857D-2*t308*t62-0.1D1*t50
     #*t312*t329*t330)*t265+t240*(-0.5543856D-1*t272*t247
     #+0.270453216D-2*t459*t272-0.34198272D-4*t462*t272+0.198068544D-6
     #*t465*t272-0.4696040448D-9*t470*t272)
      t477 = t86*rhob
      t480 = sigmabb/t87/t477
      t483 = t97*t86
      t486 = t96/t84/t483
      t491 = t106/t107/rhob
      t497 = t114/t87/t107/t477
      t504 = t114*sigmabb/t84/t107/t483
      t506 = 1/t119/t92
      t512 = t129*t142
      t515 = 1/t136
      t516 = t126*t515
      t519 = t138**2
      t520 = 1/t519
      t522 = t131**2
      t523 = t522**2
      t526 = 1/t86
      t537 = -0.1853395810515781D1/t523/t131*t526-0.128158207914907D1
     #*t515*t526-0.8223668877838045D0/t134*t526-0.1603914194192128D0
     #/t127*t526
      t538 = 1/t141
      t552 = 1/t156/t144
      t565 = 0.1333333333333333D1*t199*(-t400-t396)
     #+0.1333333333333333D1*t203*(t165+t395)
      s1 = -0.12407009817988D1*t84*t123-0.9305257363491D0*t85*
     #(0.7970293333333333D-2*t480*t93-0.465232D-3*t486*t103
     #+0.3836422826666667D-5*t491*t111-0.1161168213333333D-7*t497*t120
     #+0.1279841621333333D-10*t504*t506)-0.3109D-1*t512*t160
     #+0.1321010150222857D-2*t516*t161
      vrhob(i) = s1+0.1D1*t130*t520*t537*t538*t160-0.3109D-1*t130*t142
     #*(0.1390394666666667D0*t480*t145-0.12016352D0*t486*t149
     #+0.1459892053333333D0*t491*t153-0.6791957333333333D-1*t497*t157
     #+0.8483191466666667D-2*t504*t552)+(-t182+t216+t233+t164*(t355
     #+t376-t380-t394+0.3799574853701528D-1*t194*t565*t213
     #+0.3799574853701528D-1*t194*t205*(t410+t414)+t438
     #+0.1923661050931536D1*t230*t565*t211-0.7694644203726145D1*t442
     #-t445)+0.3109D-1*t512-0.1321010150222857D-2*t516*t142-0.1D1*t130
     #*t520*t537*t538)*t265+t240*(-0.5543856D-1*t480*t247
     #+0.270453216D-2*t459*t480-0.34198272D-4*t462*t480+0.198068544D-6
     #*t465*t480-0.4696040448D-9*t470*t480)
      t602 = sigmaaa*t20
      t605 = t16*t28
      t608 = t26*t37
      t614 = t34/t4/t27/t18
      vsigmaaa(i) = -0.9305257363491D0*t5*(-0.298886D-2*t9*t13
     #+0.174462D-3*t602*t23-0.143865856D-5*t605*t31+0.43543808D-8*t608
     #*t40-0.479940608D-11*t614*t298)-0.3109D-1*t50*t62*(-0.521398D-1
     #*t9*t65+0.4506132D-1*t602*t69-0.54745952D-1*t605*t73
     #+0.2546984D-1*t608*t77-0.31811968D-2*t614*t344)+t240*
     #(0.2078946D-1*t9*t247-0.101419956D-2*t459*t9+0.12824352D-4*t462
     #*t9-0.74275704D-7*t465*t9+0.1761015168D-9*t470*t9)
      vsigmaab(i) = 0.D0
      t648 = sigmabb*t100
      t651 = t96*t108
      t654 = t106*t117
      t660 = t114/t84/t107/t98
      vsigmabb(i) = -0.9305257363491D0*t85*(-0.298886D-2*t89*t93
     #+0.174462D-3*t648*t103-0.143865856D-5*t651*t111+0.43543808D-8
     #*t654*t120-0.479940608D-11*t660*t506)-0.3109D-1*t130*t142*(
     #-0.521398D-1*t89*t145+0.4506132D-1*t648*t149-0.54745952D-1*t651
     #*t153+0.2546984D-1*t654*t157-0.31811968D-2*t660*t552)+t240*
     #(0.2078946D-1*t89*t247-0.101419956D-2*t459*t89+0.12824352D-4
     #*t462*t89-0.74275704D-7*t465*t89+0.1761015168D-9*t470*t89)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmabb*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmabb**2
      t15 = t4**2
      t16 = t15*rhob
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmabb
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109163D1-0.298886D-2*t8*t11+0.8125328D-4*t19*t21
     #-0.26287744D-6*t27*t29+0.29996288D-9*t36*t38
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhob*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.489508D0-0.521398D-1*t8*t63+0.1731668D-1*t19*t67
     #-0.1593976D-1*t27*t71+0.3976496D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      vrhoa(i) = 0.D0
      t84 = t4*rhob
      t87 = sigmabb/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhob
      t104 = t32/t5/t25/t84
      t107 = t32*sigmabb
      t111 = t107/t2/t25/t90
      t113 = 1/t37/t10
      t116 = 0.7970293333333333D-2*t87*t11-0.465232D-3*t93*t21
     #+0.3836422826666667D-5*t98*t29-0.1161168213333333D-7*t104*t38
     #+0.1279841621333333D-10*t111*t113
      t119 = t47*t60
      t122 = 1/t54
      t123 = t44*t122
      t126 = t56**2
      t127 = 1/t126
      t128 = t48*t127
      t129 = t49**2
      t130 = t129**2
      t131 = t130*t49
      t132 = 1/t131
      t133 = 1/t4
      t138 = 1/t52
      t141 = 1/t45
      t144 = -0.1853395810515781D1*t132*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0*t138*t133-0.1603914194192128D0*t141
     #*t133
      t145 = 1/t59
      t146 = t144*t145
      t147 = t146*t78
      t159 = 1/t74/t62
      t162 = 0.1390394666666667D0*t87*t63-0.12016352D0*t93*t67
     #+0.1459892053333333D0*t98*t71-0.6791957333333333D-1*t104*t75
     #+0.8483191466666667D-2*t111*t159
      t163 = t60*t162
      vrhob(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*t116
     #-0.3109D-1*t119*t78+0.1321010150222857D-2*t123*t79+0.1D1*t128
     #*t147-0.3109D-1*t48*t163
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t168 = sigmabb*t18
      t171 = t14*t26
      t174 = t24*t35
      t179 = 1/t2/t25/t16
      t180 = t32*t179
      vsigmabb(i) = -0.9305257363491D0*t3*(-0.298886D-2*t7*t11
     #+0.174462D-3*t168*t21-0.143865856D-5*t171*t29+0.43543808D-8*t174
     #*t38-0.479940608D-11*t180*t113)-0.3109D-1*t48*t60*(-0.521398D-1
     #*t7*t63+0.4506132D-1*t168*t67-0.54745952D-1*t171*t71
     #+0.2546984D-1*t174*t75-0.31811968D-2*t180*t159)
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t207 = sigmabb/t5/t15
      t210 = t15*t84
      t213 = t14/t2/t210
      t217 = t24/t33
      t223 = t32/t5/t25/t15
      t229 = t107/t2/t25/t210
      t233 = t25**2
      t236 = t32*t14/t233/t4
      t238 = 1/t37/t20
      t249 = 1/t84
      t251 = 1/t54/t44
      t263 = t144**2
      t270 = 1/t15
      t296 = t126**2
      t299 = t59**2
      t319 = 1/t74/t66
      s1 = -0.4135669939329333D0/t5*t41-0.24814019635976D1*t2*t116
     #-0.9305257363491D0*t3*(-0.2922440888888889D-1*t207*t11
     #+0.3031485795555556D-2*t213*t21-0.4445275477333333D-4*t217*t29
     #+0.2582351553422222D-6*t223*t38-0.6788757367466667D-9*t229*t113
     #+0.6825821980444444D-12*t236*t238)+0.2D1*t47*t127*t147-0.6218D-1
     #*t119*t162+0.8806734334819047D-3*t249*t251*t79
      v2rhob2(i) = s1-0.8497974591333914D-1*t123*t127*t147
     #+0.2642020300445714D-2*t123*t163-0.2D1*t48/t126/t56*t263*t145
     #*t78+0.1D1*t128*(-0.1544496508763151D1/t131/t44*t270
     #+0.3706791621031562D1*t132*t249-0.854388052766047D0*t251*t270
     #+0.2563164158298141D1*t122*t249-0.4111834438919023D0/t52/t44
     #*t270+0.1644733775567609D1*t138*t249-0.5346380647307093D-1/t45
     #/t44*t270+0.3207828388384256D0*t141*t249)*t145*t78
     #+0.321646831778707D2*t48/t296*t263/t299*t78+0.2D1*t128*t146*t162
     #-0.3109D-1*t48*t60*(-0.5098113777777778D0*t207*t63
     #+0.8351900088888889D0*t213*t67-0.1442077269333333D1*t217*t71
     #+0.1025977750755556D1*t223*t75-0.2664875008D0*t229*t159
     #+0.2262184391111111D-1*t236*t319)
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t328 = sigmabb*t26
      t331 = t14*t35
      t334 = t24*t179
      t338 = t32/t233
      v2sigmabb2(i) = -0.9305257363491D0*t3*(0.18641744D-3*t18*t21
     #-0.427301312D-5*t328*t29+0.3032704512D-7*t331*t38
     #-0.8886771712D-10*t334*t113+0.959881216D-13*t338*t238)-0.3109D-1
     #*t48*t60*(0.5548928D-1*t18*t67-0.127516432D0*t328*t71
     #+0.1092570912D0*t331*t75-0.331006592D-1*t334*t159+0.31811968D-2
     #*t338*t319)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmaaa*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmaaa**2
      t15 = t4**2
      t16 = t15*rhoa
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmaaa
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109163D1-0.298886D-2*t8*t11+0.8125328D-4*t19*t21
     #-0.26287744D-6*t27*t29+0.29996288D-9*t36*t38
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhoa*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.489508D0-0.521398D-1*t8*t63+0.1731668D-1*t19*t67
     #-0.1593976D-1*t27*t71+0.3976496D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      t84 = t4*rhoa
      t87 = sigmaaa/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhoa
      t104 = t32/t5/t25/t84
      t107 = t32*sigmaaa
      t111 = t107/t2/t25/t90
      t113 = 1/t37/t10
      t116 = 0.7970293333333333D-2*t87*t11-0.465232D-3*t93*t21
     #+0.3836422826666667D-5*t98*t29-0.1161168213333333D-7*t104*t38
     #+0.1279841621333333D-10*t111*t113
      t119 = t47*t60
      t122 = 1/t54
      t123 = t44*t122
      t126 = t56**2
      t127 = 1/t126
      t128 = t48*t127
      t129 = t49**2
      t130 = t129**2
      t131 = t130*t49
      t132 = 1/t131
      t133 = 1/t4
      t138 = 1/t52
      t141 = 1/t45
      t144 = -0.1853395810515781D1*t132*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0*t138*t133-0.1603914194192128D0*t141
     #*t133
      t145 = 1/t59
      t146 = t144*t145
      t147 = t146*t78
      t159 = 1/t74/t62
      t162 = 0.1390394666666667D0*t87*t63-0.12016352D0*t93*t67
     #+0.1459892053333333D0*t98*t71-0.6791957333333333D-1*t104*t75
     #+0.8483191466666667D-2*t111*t159
      t163 = t60*t162
      vrhoa(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*t116
     #-0.3109D-1*t119*t78+0.1321010150222857D-2*t123*t79+0.1D1*t128
     #*t147-0.3109D-1*t48*t163
      vrhob(i) = 0.D0
      t168 = sigmaaa*t18
      t171 = t14*t26
      t174 = t24*t35
      t179 = 1/t2/t25/t16
      t180 = t32*t179
      vsigmaaa(i) = -0.9305257363491D0*t3*(-0.298886D-2*t7*t11
     #+0.174462D-3*t168*t21-0.143865856D-5*t171*t29+0.43543808D-8*t174
     #*t38-0.479940608D-11*t180*t113)-0.3109D-1*t48*t60*(-0.521398D-1
     #*t7*t63+0.4506132D-1*t168*t67-0.54745952D-1*t171*t71
     #+0.2546984D-1*t174*t75-0.31811968D-2*t180*t159)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t207 = sigmaaa/t5/t15
      t210 = t15*t84
      t213 = t14/t2/t210
      t217 = t24/t33
      t223 = t32/t5/t25/t15
      t229 = t107/t2/t25/t210
      t233 = t25**2
      t236 = t32*t14/t233/t4
      t238 = 1/t37/t20
      t249 = 1/t84
      t251 = 1/t54/t44
      t263 = t144**2
      t270 = 1/t15
      t296 = t126**2
      t299 = t59**2
      t319 = 1/t74/t66
      s1 = -0.4135669939329333D0/t5*t41-0.24814019635976D1*t2*t116
     #-0.9305257363491D0*t3*(-0.2922440888888889D-1*t207*t11
     #+0.3031485795555556D-2*t213*t21-0.4445275477333333D-4*t217*t29
     #+0.2582351553422222D-6*t223*t38-0.6788757367466667D-9*t229*t113
     #+0.6825821980444444D-12*t236*t238)+0.2D1*t47*t127*t147-0.6218D-1
     #*t119*t162+0.8806734334819047D-3*t249*t251*t79
      v2rhoa2(i) = s1-0.8497974591333914D-1*t123*t127*t147
     #+0.2642020300445714D-2*t123*t163-0.2D1*t48/t126/t56*t263*t145
     #*t78+0.1D1*t128*(-0.1544496508763151D1/t131/t44*t270
     #+0.3706791621031562D1*t132*t249-0.854388052766047D0*t251*t270
     #+0.2563164158298141D1*t122*t249-0.4111834438919023D0/t52/t44
     #*t270+0.1644733775567609D1*t138*t249-0.5346380647307093D-1/t45
     #/t44*t270+0.3207828388384256D0*t141*t249)*t145*t78
     #+0.321646831778707D2*t48/t296*t263/t299*t78+0.2D1*t128*t146*t162
     #-0.3109D-1*t48*t60*(-0.5098113777777778D0*t207*t63
     #+0.8351900088888889D0*t213*t67-0.1442077269333333D1*t217*t71
     #+0.1025977750755556D1*t223*t75-0.2664875008D0*t229*t159
     #+0.2262184391111111D-1*t236*t319)
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t328 = sigmaaa*t26
      t331 = t14*t35
      t334 = t24*t179
      t338 = t32/t233
      v2sigmaaa2(i) = -0.9305257363491D0*t3*(0.18641744D-3*t18*t21
     #-0.427301312D-5*t328*t29+0.3032704512D-7*t331*t38
     #-0.8886771712D-10*t334*t113+0.959881216D-13*t338*t238)-0.3109D-1
     #*t48*t60*(0.5548928D-1*t18*t67-0.127516432D0*t328*t71
     #+0.1092570912D0*t331*t75-0.331006592D-1*t334*t159+0.31811968D-2
     #*t338*t319)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t9 = 1/t7/t6
      t10 = sigmaaa*t9
      t12 = 1.D0+0.4D-2*t10
      t13 = 1/t12
      t16 = sigmaaa**2
      t17 = t6**2
      t18 = t17*rhoa
      t20 = 1/t4/t18
      t21 = t16*t20
      t22 = t12**2
      t23 = 1/t22
      t26 = t16*sigmaaa
      t27 = t17**2
      t28 = 1/t27
      t29 = t26*t28
      t31 = 1/t22/t12
      t34 = t16**2
      t35 = t27*t6
      t37 = 1/t7/t35
      t38 = t34*t37
      t39 = t22**2
      t40 = 1/t39
      t43 = 0.109163D1-0.298886D-2*t10*t13+0.8125328D-4*t21*t23
     #-0.26287744D-6*t29*t31+0.29996288D-9*t38*t40
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t49 = 1.D0+0.1274696188700087D0*t47
      t50 = rhoa*t49
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t58 = 0.1112037486309468D2*t51+0.3844746237447211D1*t47
     #+0.1644733775567609D1*t54+0.2405871291288192D0*t56
      t61 = 1.D0+0.321646831778707D2/t58
      t62 = dlog(t61)
      t64 = 1.D0+0.2D0*t10
      t65 = 1/t64
      t68 = t64**2
      t69 = 1/t68
      t73 = 1/t68/t64
      t76 = t68**2
      t77 = 1/t76
      t80 = 0.489508D0-0.521398D-1*t10*t65+0.1731668D-1*t21*t69
     #-0.1593976D-1*t29*t73+0.3976496D-2*t38*t77
      t81 = t62*t80
      t84 = rhob**(1.D0/3.D0)
      t85 = t84*rhob
      t86 = rhob**2
      t87 = t84**2
      t89 = 1/t87/t86
      t90 = sigmabb*t89
      t92 = 1.D0+0.4D-2*t90
      t93 = 1/t92
      t96 = sigmabb**2
      t97 = t86**2
      t98 = t97*rhob
      t100 = 1/t84/t98
      t101 = t96*t100
      t102 = t92**2
      t103 = 1/t102
      t106 = t96*sigmabb
      t107 = t97**2
      t108 = 1/t107
      t109 = t106*t108
      t111 = 1/t102/t92
      t114 = t96**2
      t115 = t107*t86
      t117 = 1/t87/t115
      t118 = t114*t117
      t119 = t102**2
      t120 = 1/t119
      t123 = 0.109163D1-0.298886D-2*t90*t93+0.8125328D-4*t101*t103
     #-0.26287744D-6*t109*t111+0.29996288D-9*t118*t120
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t129 = 1.D0+0.1274696188700087D0*t127
      t130 = rhob*t129
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t138 = 0.1112037486309468D2*t131+0.3844746237447211D1*t127
     #+0.1644733775567609D1*t134+0.2405871291288192D0*t136
      t141 = 1.D0+0.321646831778707D2/t138
      t142 = dlog(t141)
      t144 = 1.D0+0.2D0*t90
      t145 = 1/t144
      t148 = t144**2
      t149 = 1/t148
      t153 = 1/t148/t144
      t156 = t148**2
      t157 = 1/t156
      t160 = 0.489508D0-0.521398D-1*t90*t145+0.1731668D-1*t101*t149
     #-0.1593976D-1*t109*t153+0.3976496D-2*t118*t157
      t161 = t142*t160
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t168 = 1.D0+0.1325688999052018D0*t166
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t176 = 0.598255043577108D1*t169+0.2225569421150687D1*t166
     #+0.8004286349993634D0*t172+0.1897004325747559D0*t174
      t179 = 1.D0+0.160818243221511D2/t176
      t180 = dlog(t179)
      t182 = 0.62182D-1*t168*t180
      t184 = 1.D0+0.6901399211255825D-1*t166
      t189 = 0.8157414703487641D1*t169+0.2247591863577616D1*t166
     #+0.4300972471276643D0*t172+0.1911512595127338D0*t174
      t192 = 1.D0+0.2960857464321668D2/t189
      t193 = dlog(t192)
      t194 = t184*t193
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t210 = 1/t209
      t211 = t207*t210
      t213 = 1.D0-1.D0*t211
      t214 = t205*t213
      t216 = 0.3799574853701528D-1*t194*t214
      t218 = 1.D0+0.1274696188700087D0*t166
      t223 = 0.1112037486309468D2*t169+0.3844746237447211D1*t166
     #+0.1644733775567609D1*t172+0.2405871291288192D0*t174
      t226 = 1.D0+0.321646831778707D2/t223
      t227 = dlog(t226)
      t230 = -0.3109D-1*t218*t227+t182
      t231 = t230*t205
      t233 = 0.1923661050931536D1*t231*t211
      t240 = t164*(-t182+t216+t233)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t247 = 1/t246
      t250 = t243**2
      t251 = t246**2
      t252 = 1/t251
      t255 = t250*t243
      t257 = 1/t251/t246
      t260 = t250**2
      t261 = t251**2
      t262 = 1/t261
      t265 = 0.51473D0+0.4157892D-1*t243*t247-0.8894628D-3*t250*t252
     #+0.49917168D-5*t255*t257-0.146751264D-7*t260*t262
      zk(i) = -0.9305257363491D0*t5*t43-0.3109D-1*t50*t81
     #-0.9305257363491D0*t85*t123-0.3109D-1*t130*t161+t240*t265
      t269 = t6*rhoa
      t271 = 1/t7/t269
      t272 = sigmaaa*t271
      t275 = t17*t6
      t277 = 1/t4/t275
      t278 = t16*t277
      t282 = 1/t27/rhoa
      t283 = t26*t282
      t288 = 1/t7/t27/t269
      t289 = t34*t288
      t292 = t34*sigmaaa
      t295 = 1/t4/t27/t275
      t296 = t292*t295
      t298 = 1/t39/t12
      t301 = 0.7970293333333333D-2*t272*t13-0.465232D-3*t278*t23
     #+0.3836422826666667D-5*t283*t31-0.1161168213333333D-7*t289*t40
     #+0.1279841621333333D-10*t296*t298
      t304 = t49*t62
      t307 = 1/t56
      t308 = t46*t307
      t311 = t58**2
      t312 = 1/t311
      t313 = t50*t312
      t314 = t51**2
      t315 = t314**2
      t316 = t315*t51
      t317 = 1/t316
      t318 = 1/t6
      t323 = 1/t54
      t326 = 1/t47
      t329 = -0.1853395810515781D1*t317*t318-0.128158207914907D1*t307
     #*t318-0.8223668877838045D0*t323*t318-0.1603914194192128D0*t326
     #*t318
      t330 = 1/t61
      t331 = t329*t330
      t332 = t331*t80
      t344 = 1/t76/t64
      t347 = 0.1390394666666667D0*t272*t65-0.12016352D0*t278*t69
     #+0.1459892053333333D0*t283*t73-0.6791957333333333D-1*t289*t77
     #+0.8483191466666667D-2*t296*t344
      t348 = t62*t347
      t351 = 1/t174
      t352 = 1/t208
      t353 = t351*t352
      t354 = t353*t180
      t355 = 0.2747799777968419D-2*t354
      t356 = t176**2
      t357 = 1/t356
      t358 = t168*t357
      t359 = t169**2
      t360 = t359**2
      t361 = t360*t169
      t362 = 1/t361
      t363 = t362*t352
      t366 = 1/t172
      t367 = t366*t352
      t369 = 1/t166
      t370 = t369*t352
      t372 = -0.99709173929518D0*t363-0.7418564737168958D0*t353
     #-0.4002143174996817D0*t367-0.1264669550498372D0*t370
      t373 = 1/t179
      t375 = t358*t372*t373
      t376 = 0.1D1*t375
      t377 = t193*t205
      t378 = t377*t213
      t379 = t353*t378
      t380 = 0.8740794299481065D-3*t379
      t381 = t189**2
      t382 = 1/t381
      t383 = t184*t382
      t388 = -0.135956911724794D1*t363-0.7491972878592054D0*t353
     #-0.2150486235638321D0*t367-0.1274341730084892D0*t370
      t389 = t383*t388
      t390 = 1/t192
      t391 = t390*t205
      t392 = t391*t213
      t393 = t389*t392
      t394 = 0.1124999956683108D1*t393
      t395 = t196*t352
      t396 = 1.D0*t395
      t397 = t165-t396
      t400 = 1.D0*t165
      t401 = -t400+t395
      t404 = 0.1333333333333333D1*t199*t397+0.1333333333333333D1*t203
     #*t401
      t406 = t194*t404*t213
      t407 = 0.3799574853701528D-1*t406
      t408 = t206*t196
      t409 = t408*t210
      t410 = 4.D0*t409
      t412 = 1/t209/t164
      t413 = t207*t412
      t414 = 4.D0*t413
      t415 = -t410+t414
      t417 = t194*t205*t415
      t418 = 0.3799574853701528D-1*t417
      t421 = t223**2
      t422 = 1/t421
      t423 = t218*t422
      t428 = -0.1853395810515781D1*t363-0.128158207914907D1*t353
     #-0.8223668877838045D0*t367-0.1603914194192128D0*t370
      t429 = 1/t226
      t435 = 0.1321010150222857D-2*t353*t227+0.1D1*t423*t428*t429
     #-0.2747799777968419D-2*t354-0.1D1*t375
      t436 = t435*t205
      t437 = t436*t211
      t438 = 0.1923661050931536D1*t437
      t439 = t230*t404
      t440 = t439*t211
      t441 = 0.1923661050931536D1*t440
      t442 = t231*t409
      t444 = t231*t413
      t445 = 0.7694644203726145D1*t444
      t452 = t312*t329*t330
      t455 = -t182+t216+t233+t164*(t355+t376-t380-t394+t407+t418+t438
     #+t441+0.7694644203726145D1*t442-t445)+0.3109D-1*t304
     #-0.1321010150222857D-2*t308*t62-0.1D1*t50*t452
      t459 = t243*t252
      t462 = t250*t257
      t465 = t255*t262
      t469 = 1/t261/t246
      t470 = t260*t469
      t473 = -0.5543856D-1*t272*t247+0.270453216D-2*t459*t272
     #-0.34198272D-4*t462*t272+0.198068544D-6*t465*t272
     #-0.4696040448D-9*t470*t272
      vrhoa(i) = -0.12407009817988D1*t4*t43-0.9305257363491D0*t5*t301
     #-0.3109D-1*t304*t80+0.1321010150222857D-2*t308*t81+0.1D1*t313
     #*t332-0.3109D-1*t50*t348+t455*t265+t240*t473
      t477 = t86*rhob
      t479 = 1/t87/t477
      t480 = sigmabb*t479
      t483 = t97*t86
      t485 = 1/t84/t483
      t486 = t96*t485
      t490 = 1/t107/rhob
      t491 = t106*t490
      t496 = 1/t87/t107/t477
      t497 = t114*t496
      t500 = t114*sigmabb
      t503 = 1/t84/t107/t483
      t504 = t500*t503
      t506 = 1/t119/t92
      t509 = 0.7970293333333333D-2*t480*t93-0.465232D-3*t486*t103
     #+0.3836422826666667D-5*t491*t111-0.1161168213333333D-7*t497*t120
     #+0.1279841621333333D-10*t504*t506
      t512 = t129*t142
      t515 = 1/t136
      t516 = t126*t515
      t519 = t138**2
      t520 = 1/t519
      t521 = t130*t520
      t522 = t131**2
      t523 = t522**2
      t524 = t523*t131
      t525 = 1/t524
      t526 = 1/t86
      t531 = 1/t134
      t534 = 1/t127
      t537 = -0.1853395810515781D1*t525*t526-0.128158207914907D1*t515
     #*t526-0.8223668877838045D0*t531*t526-0.1603914194192128D0*t534
     #*t526
      t538 = 1/t141
      t539 = t537*t538
      t540 = t539*t160
      t552 = 1/t156/t144
      t555 = 0.1390394666666667D0*t480*t145-0.12016352D0*t486*t149
     #+0.1459892053333333D0*t491*t153-0.6791957333333333D-1*t497*t157
     #+0.8483191466666667D-2*t504*t552
      t556 = t142*t555
      t559 = -t400-t396
      t562 = t165+t395
      t565 = 0.1333333333333333D1*t199*t559+0.1333333333333333D1*t203
     #*t562
      t567 = t194*t565*t213
      t568 = 0.3799574853701528D-1*t567
      t569 = t410+t414
      t571 = t194*t205*t569
      t572 = 0.3799574853701528D-1*t571
      t573 = t230*t565
      t574 = t573*t211
      t575 = 0.1923661050931536D1*t574
      t583 = t520*t537*t538
      t586 = -t182+t216+t233+t164*(t355+t376-t380-t394+t568+t572+t438
     #+t575-0.7694644203726145D1*t442-t445)+0.3109D-1*t512
     #-0.1321010150222857D-2*t516*t142-0.1D1*t130*t583
      t598 = -0.5543856D-1*t480*t247+0.270453216D-2*t459*t480
     #-0.34198272D-4*t462*t480+0.198068544D-6*t465*t480
     #-0.4696040448D-9*t470*t480
      vrhob(i) = -0.12407009817988D1*t84*t123-0.9305257363491D0*t85
     #*t509-0.3109D-1*t512*t160+0.1321010150222857D-2*t516*t161+0.1D1
     #*t521*t540-0.3109D-1*t130*t556+t586*t265+t240*t598
      t602 = sigmaaa*t20
      t605 = t16*t28
      t608 = t26*t37
      t613 = 1/t4/t27/t18
      t614 = t34*t613
      t617 = -0.298886D-2*t9*t13+0.174462D-3*t602*t23-0.143865856D-5
     #*t605*t31+0.43543808D-8*t608*t40-0.479940608D-11*t614*t298
      t630 = -0.521398D-1*t9*t65+0.4506132D-1*t602*t69-0.54745952D-1
     #*t605*t73+0.2546984D-1*t608*t77-0.31811968D-2*t614*t344
      t631 = t62*t630
      t644 = 0.2078946D-1*t9*t247-0.101419956D-2*t459*t9+0.12824352D-4
     #*t462*t9-0.74275704D-7*t465*t9+0.1761015168D-9*t470*t9
      vsigmaaa(i) = -0.9305257363491D0*t5*t617-0.3109D-1*t50*t631+t240
     #*t644
      vsigmaab(i) = 0.D0
      t648 = sigmabb*t100
      t651 = t96*t108
      t654 = t106*t117
      t659 = 1/t84/t107/t98
      t660 = t114*t659
      t663 = -0.298886D-2*t89*t93+0.174462D-3*t648*t103-0.143865856D-5
     #*t651*t111+0.43543808D-8*t654*t120-0.479940608D-11*t660*t506
      t676 = -0.521398D-1*t89*t145+0.4506132D-1*t648*t149
     #-0.54745952D-1*t651*t153+0.2546984D-1*t654*t157-0.31811968D-2
     #*t660*t552
      t677 = t142*t676
      t690 = 0.2078946D-1*t89*t247-0.101419956D-2*t459*t89
     #+0.12824352D-4*t462*t89-0.74275704D-7*t465*t89+0.1761015168D-9
     #*t470*t89
      vsigmabb(i) = -0.9305257363491D0*t85*t663-0.3109D-1*t130*t677
     #+t240*t690
      t696 = sigmaaa/t7/t17
      t699 = t17*t269
      t702 = t16/t4/t699
      t705 = t243*t257
      t710 = t250*t262
      t715 = t255*t469
      t722 = t260/t261/t251
      t739 = t26/t35
      t745 = t34/t7/t27/t17
      t751 = t292/t4/t27/t699
      t755 = t27**2
      t758 = t34*t16/t755/t6
      t760 = 1/t39/t22
      t766 = t49*t312
      t774 = 1/t311/t58
      t776 = t329**2
      t784 = 1/t269
      t786 = 1/t56/t46
      t787 = t784*t786
      t792 = 1/t17
      t813 = -0.1544496508763151D1/t316/t46*t792+0.3706791621031562D1
     #*t317*t784-0.854388052766047D0*t786*t792+0.2563164158298141D1
     #*t307*t784-0.4111834438919023D0/t54/t46*t792
     #+0.1644733775567609D1*t323*t784-0.5346380647307093D-1/t47/t46
     #*t792+0.3207828388384256D0*t326*t784
      t821 = t311**2
      t822 = 1/t821
      t824 = t61**2
      t825 = 1/t824
      t841 = 1/t76/t68
      t848 = 0.2D1*t375
      t850 = 0.5495599555936838D-2*t354
      t852 = 0.1748158859896213D-2*t379
      t853 = 0.2249999913366216D1*t393
      t854 = 0.3847322101863073D1*t437
      t856 = 0.1538928840745229D2*t444
      t876 = t408*t412
      t877 = t231*t876
      t879 = t436*t409
      t883 = 1/t174/t165*t210
      t884 = t883*t180
      t885 = 0.1831866518645613D-2*t884
      t889 = t388**2
      t892 = 0.2249999913366216D1*t184/t381/t189*t889*t392
      t894 = 1/t208/t164
      t895 = t351*t894
      t896 = t895*t180
      t897 = 0.5495599555936838D-2*t896
      t898 = t439*t413
      t901 = 0.1538928840745229D2*t436*t413
      t902 = t206*t210
      t903 = t231*t902
      t904 = 0.2308393261117844D2*t903
      t905 = t199**2
      t906 = 1/t905
      t907 = t397**2
      t910 = 2.D0*t352
      t912 = 2.D0*t196*t894
      t913 = -t910+t912
      t916 = t203**2
      t917 = 1/t916
      t918 = t401**2
      t924 = 0.4444444444444444D0*t906*t907+0.1333333333333333D1*t199
     #*t913+0.4444444444444444D0*t917*t918-0.1333333333333333D1*t203
     #*t913
      t928 = 12.D0*t902
      t929 = 32.D0*t876
      t932 = t207/t209/t208
      t933 = 20.D0*t932
      t940 = t389*t390*t404*t213
      t943 = t389*t391*t415
      t945 = t381**2
      t949 = t192**2
      t954 = 0.3330964519106732D2*t184/t945*t889/t949*t205*t213
      t955 = t439*t409
      t957 = -0.6155715362980916D2*t877+0.1538928840745229D2*t879+t885
     #+t892-t897-0.1538928840745229D2*t898-t901+t904
     #+0.3799574853701528D-1*t194*t924*t213+0.3799574853701528D-1*t194
     #*t205*(-t928+t929-t933)-0.2249999913366216D1*t940
     #-0.2249999913366216D1*t943-t954+0.1538928840745229D2*t955
      t959 = t435*t404*t211
      t963 = 1/t361/t165*t210
      t965 = t362*t894
      t971 = 1/t172/t165*t210
      t973 = t366*t894
      t977 = 1/t166/t165*t210
      t979 = t369*t894
      t984 = 0.1124999956683108D1*t383*(-0.1132974264373283D1*t963
     #+0.271913823449588D1*t965-0.4994648585728036D0*t883
     #+0.1498394575718411D1*t895-0.1075243117819161D0*t971
     #+0.4300972471276643D0*t973-0.4247805766949639D-1*t977
     #+0.2548683460169784D0*t979)*t392
      t991 = t372**2
      t993 = t168/t356/t176*t991*t373
      t994 = 0.2D1*t993
      t1005 = t358*(-0.8309097827459833D0*t963+0.199418347859036D1
     #*t965-0.4945709824779306D0*t883+0.1483712947433792D1*t895
     #-0.2001071587498409D0*t971+0.8004286349993634D0*t973
     #-0.4215565168327908D-1*t977+0.2529339100996745D0*t979)*t373
      t1006 = 0.1D1*t1005
      t1009 = t353*t357*t372*t373
      t1010 = 0.8837926660346786D-1*t1009
      t1011 = t356**2
      t1014 = t179**2
      t1017 = t168/t1011*t991/t1014
      t1018 = 0.160818243221511D2*t1017
      t1030 = t428**2
      t1046 = t421**2
      t1049 = t226**2
      t1060 = 0.8806734334819047D-3*t883*t227-0.2642020300445714D-2
     #*t895*t227-0.8497974591333914D-1*t353*t422*t428*t429-0.2D1*t218
     #/t421/t223*t1030*t429+0.1D1*t423*(-0.1544496508763151D1*t963
     #+0.3706791621031562D1*t965-0.854388052766047D0*t883
     #+0.2563164158298141D1*t895-0.4111834438919023D0*t971
     #+0.1644733775567609D1*t973-0.5346380647307093D-1*t977
     #+0.3207828388384256D0*t979)*t429+0.321646831778707D2*t218/t1046
     #*t1030/t1049-0.1831866518645613D-2*t884+0.5495599555936838D-2
     #*t896+0.8837926660346786D-1*t1009+0.2D1*t993-0.1D1*t1005
     #-0.160818243221511D2*t1017
      t1063 = 0.1923661050931536D1*t1060*t205*t211
      t1065 = 0.3847322101863073D2*t231*t932
      t1068 = t353*t193*t404*t213
      t1071 = t353*t377*t415
      t1074 = 0.5827196199654043D-3*t883*t378
      t1082 = 0.5176049209143758D-1*t353*t382*t388*t390*t214
      t1084 = 0.1748158859896213D-2*t895*t378
      t1085 = 0.3847322101863073D1*t959-t984+0.7599149707403056D-1
     #*t194*t404*t415-t994+t1006-t1010+t1018+t1063+t1065
     #-0.1748158859896213D-2*t1068-0.1748158859896213D-2*t1071-t1074
     #+0.1923661050931536D1*t230*t924*t211+t1082+t1084
      t1088 = t848+0.7599149707403056D-1*t406+t850
     #+0.7599149707403056D-1*t417-t852-t853+t854+0.1538928840745229D2
     #*t442-t856+0.3847322101863073D1*t440-0.321646831778707D2*t50
     #*t822*t776*t825-0.1D1*t50*t312*t813*t330-0.8806734334819047D-3
     #*t787*t62+0.8497974591333914D-1*t308*t452+0.2D1*t50*t774*t776
     #*t330-0.2D1*t766*t331+t164*(t957+t1085)
      s1 = 2.D0*t455*t473+t240*(0.20327472D0*t696*t247-0.404955136D-2
     #*t702*t252+0.13446790656D-3*t705*t702-0.991661792D-2*t459*t696
     #-0.1613032704D-5*t710*t702+0.125393664D-3*t462*t696
     #+0.88427483136D-8*t715*t702-0.726251328D-6*t465*t696
     #-0.18784161792D-10*t722*t702+0.17218814976D-8*t470*t696)
     #-0.4135669939329333D0/t7*t43-0.24814019635976D1*t4*t301
     #-0.9305257363491D0*t5*(-0.2922440888888889D-1*t696*t13
     #+0.3031485795555556D-2*t702*t23-0.4445275477333333D-4*t739*t31
     #+0.2582351553422222D-6*t745*t40-0.6788757367466667D-9*t751*t298
     #+0.6825821980444444D-12*t758*t760)+0.2D1*t766*t332-0.6218D-1
     #*t304*t347+0.2642020300445714D-2*t308*t348
      v2rhoa2(i) = s1-0.2D1*t50*t774*t776*t330*t80
     #-0.8497974591333914D-1*t308*t312*t332+0.8806734334819047D-3*t787
     #*t81+0.1D1*t313*t813*t330*t80+0.2D1*t313*t331*t347
     #+0.321646831778707D2*t50*t822*t776*t825*t80-0.3109D-1*t50*t62*(
     #-0.5098113777777778D0*t696*t65+0.8351900088888889D0*t702*t69
     #-0.1442077269333333D1*t739*t73+0.1025977750755556D1*t745*t77
     #-0.2664875008D0*t751*t344+0.2262184391111111D-1*t758*t841)+t1088
     #*t265
      t1090 = t129*t520
      t1104 = sigmabb/t87/t97
      t1107 = t97*t477
      t1110 = t96/t84/t1107
      t1114 = t106/t115
      t1120 = t114/t87/t107/t97
      t1126 = t500/t84/t107/t1107
      t1130 = t107**2
      t1133 = t114*t96/t1130/t86
      t1135 = 1/t119/t102
      t1141 = 1/t477
      t1143 = 1/t136/t126
      t1144 = t1141*t1143
      t1151 = 1/t519/t138
      t1153 = t537**2
      t1169 = 1/t156/t148
      t1178 = 1/t97
      t1199 = -0.1544496508763151D1/t524/t126*t1178
     #+0.3706791621031562D1*t525*t1141-0.854388052766047D0*t1143*t1178
     #+0.2563164158298141D1*t515*t1141-0.4111834438919023D0/t134/t126
     #*t1178+0.1644733775567609D1*t531*t1141-0.5346380647307093D-1
     #/t127/t126*t1178+0.3207828388384256D0*t534*t1141
      t1207 = t519**2
      t1208 = 1/t1207
      t1210 = t141**2
      t1211 = 1/t1210
      t1222 = t559**2
      t1225 = t910+t912
      t1228 = t562**2
      t1234 = 0.4444444444444444D0*t906*t1222+0.1333333333333333D1
     #*t199*t1225+0.4444444444444444D0*t917*t1228-0.1333333333333333D1
     #*t203*t1225
      t1245 = 0.6155715362980916D2*t877-0.1538928840745229D2*t879+t885
     #+t892-t897-t901+t904-t954-t984-t994+t1006+0.3799574853701528D-1
     #*t194*t1234*t213+0.7599149707403056D-1*t194*t565*t569
     #+0.3799574853701528D-1*t194*t205*(-t928-t929-t933)
      t1247 = t353*t377*t569
      t1251 = t353*t193*t565*t213
      t1255 = t389*t390*t565*t213
      t1258 = t389*t391*t569
      t1261 = t435*t565*t211
      t1266 = t573*t413
      t1268 = t573*t409
      t1270 = -t1010-0.1748158859896213D-2*t1247+t1018
     #-0.1748158859896213D-2*t1251-0.2249999913366216D1*t1255
     #-0.2249999913366216D1*t1258+t1063+t1065+0.3847322101863073D1
     #*t1261+0.1923661050931536D1*t230*t1234*t211-0.1538928840745229D2
     #*t1266-0.1538928840745229D2*t1268-t1074+t1082+t1084
      t1291 = t848+t850-t852-t853+t854-0.1538928840745229D2*t442-t856
     #+0.3847322101863073D1*t574+0.7599149707403056D-1*t567
     #+0.7599149707403056D-1*t571+t164*(t1245+t1270)-0.2D1*t1090*t539
     #-0.8806734334819047D-3*t1144*t142+0.8497974591333914D-1*t516
     #*t583+0.2D1*t130*t1151*t1153*t538-0.1D1*t130*t520*t1199*t538
     #-0.321646831778707D2*t130*t1208*t1153*t1211
      s1 = 0.2D1*t1090*t540+0.2642020300445714D-2*t516*t556
     #-0.4135669939329333D0/t87*t123-0.24814019635976D1*t84*t509
     #-0.6218D-1*t512*t555-0.9305257363491D0*t85*(
     #-0.2922440888888889D-1*t1104*t93+0.3031485795555556D-2*t1110
     #*t103-0.4445275477333333D-4*t1114*t111+0.2582351553422222D-6
     #*t1120*t120-0.6788757367466667D-9*t1126*t506
     #+0.6825821980444444D-12*t1133*t1135)+0.8806734334819047D-3*t1144
     #*t161-0.8497974591333914D-1*t516*t520*t540
      s2 = s1-0.2D1*t130*t1151*t1153*t538*t160-0.3109D-1*t130*t142*(
     #-0.5098113777777778D0*t1104*t145+0.8351900088888889D0*t1110*t149
     #-0.1442077269333333D1*t1114*t153+0.1025977750755556D1*t1120*t157
     #-0.2664875008D0*t1126*t552+0.2262184391111111D-1*t1133*t1169)
     #+0.1D1*t521*t1199*t538*t160
      v2rhob2(i) = s2+0.2D1*t521*t539*t555+0.321646831778707D2*t130
     #*t1208*t1153*t1211*t160+t1291*t265+2.D0*t586*t598+t240*
     #(0.20327472D0*t1104*t247-0.404955136D-2*t1110*t252
     #+0.13446790656D-3*t705*t1110-0.991661792D-2*t459*t1104
     #-0.1613032704D-5*t710*t1110+0.125393664D-3*t462*t1104
     #+0.88427483136D-8*t715*t1110-0.726251328D-6*t465*t1104
     #-0.18784161792D-10*t722*t1110+0.17218814976D-8*t470*t1104)
      t1330 = 0.4444444444444444D0*t906*t397*t559+0.2666666666666667D1
     #*t199*t196*t894+0.4444444444444444D0*t917*t401*t562
     #-0.2666666666666667D1*t203*t196*t894
      t1346 = t885+t892-t897-0.7694644203726145D1*t898-t901
     #+0.3799574853701528D-1*t194*t1330*t213+0.3799574853701528D-1
     #*t194*t205*(t928-t933)-0.2308393261117844D2*t903
     #-0.1124999956683108D1*t940-0.1124999956683108D1*t943
     #+0.3799574853701528D-1*t194*t404*t569-t954-0.7694644203726145D1
     #*t955+0.1923661050931536D1*t959-t984-t994+t1006
      t1362 = -t1010-0.8740794299481065D-3*t1247+t1018
     #-0.8740794299481065D-3*t1251-0.1124999956683108D1*t1255
     #-0.1124999956683108D1*t1258+t1063+t1065+0.1923661050931536D1
     #*t1261-0.7694644203726145D1*t1266-0.8740794299481065D-3*t1068
     #-0.8740794299481065D-3*t1071+0.7694644203726145D1*t1268-t1074
     #+t1082+t1084+0.3799574853701528D-1*t194*t565*t415
     #+0.1923661050931536D1*t230*t1330*t211
      t1365 = t850+t848-t852-t853+t568+t572+t854+t575-t856+t407+t418
     #+t441+t164*(t1346+t1362)
      t1375 = t271*sigmabb*t479
      v2rhoab(i) = t1365*t265+t455*t598+t586*t473+t240*(
     #-0.404955136D-2*t272*t252*sigmabb*t479+0.13446790656D-3*t705
     #*sigmaaa*t1375-0.1613032704D-5*t710*sigmaaa*t1375
     #+0.88427483136D-8*t715*sigmaaa*t1375-0.18784161792D-10*t722
     #*sigmaaa*t1375)
      t1393 = sigmaaa*t277
      t1396 = t16*t282
      t1399 = t26*t288
      t1402 = t34*t295
      t1407 = t292/t755/rhoa
      s1 = -0.12407009817988D1*t4*t617-0.9305257363491D0*t5*
     #(0.7970293333333333D-2*t271*t13-0.9623451733333333D-3*t1393*t23
     #+0.1523112448D-4*t1396*t31-0.9248380245333333D-7*t1399*t40
     #+0.2497789952D-9*t1402*t298-0.2559683242666667D-12*t1407*t760)
     #-0.3109D-1*t304*t630+0.1321010150222857D-2*t308*t631
      v2rhoasigmaaa(i) = s1+0.1D1*t313*t331*t630-0.3109D-1*t50*t62*
     #(0.1390394666666667D0*t271*t65-0.2681349333333333D0*t1393*t69
     #+0.486033024D0*t1396*t73-0.3592718165333333D0*t1399*t77
     #+0.96751616D-1*t1402*t344-0.8483191466666667D-2*t1407*t841)+t455
     #*t644+t240*(-0.5543856D-1*t271*t247+0.151858176D-2*t1393*t252
     #-0.5042546496D-4*t705*t1393+0.270453216D-2*t459*t271
     #+0.604887264D-6*t710*t1393-0.34198272D-4*t462*t271
     #-0.33160306176D-8*t715*t1393+0.198068544D-6*t465*t271
     #+0.7044060672D-11*t722*t1393-0.4696040448D-9*t470*t271)
      v2rhoasigmaab(i) = 0.D0
      t1463 = t272*t89
      v2rhoasigmabb(i) = t455*t690+t240*(0.151858176D-2*t272*t252*t89
     #-0.5042546496D-4*t705*t1463+0.604887264D-6*t710*t1463
     #-0.33160306176D-8*t715*t1463+0.7044060672D-11*t722*t1463)
      t1475 = t252*t9
      t1478 = t480*t9
      v2rhobsigmaaa(i) = t586*t644+t240*(0.151858176D-2*t480*t1475
     #-0.5042546496D-4*t705*t1478+0.604887264D-6*t710*t1478
     #-0.33160306176D-8*t715*t1478+0.7044060672D-11*t722*t1478)
      v2rhobsigmaab(i) = 0.D0
      t1493 = sigmabb*t485
      t1496 = t96*t490
      t1499 = t106*t496
      t1502 = t114*t503
      t1507 = t500/t1130/rhob
      s1 = -0.12407009817988D1*t84*t663-0.9305257363491D0*t85*
     #(0.7970293333333333D-2*t479*t93-0.9623451733333333D-3*t1493*t103
     #+0.1523112448D-4*t1496*t111-0.9248380245333333D-7*t1499*t120
     #+0.2497789952D-9*t1502*t506-0.2559683242666667D-12*t1507*t1135)
     #-0.3109D-1*t512*t676+0.1321010150222857D-2*t516*t677
      v2rhobsigmabb(i) = s1+0.1D1*t521*t539*t676-0.3109D-1*t130*t142*
     #(0.1390394666666667D0*t479*t145-0.2681349333333333D0*t1493*t149
     #+0.486033024D0*t1496*t153-0.3592718165333333D0*t1499*t157
     #+0.96751616D-1*t1502*t552-0.8483191466666667D-2*t1507*t1169)
     #+t586*t690+t240*(-0.5543856D-1*t479*t247+0.151858176D-2*t1493
     #*t252-0.5042546496D-4*t705*t1493+0.270453216D-2*t459*t479
     #+0.604887264D-6*t710*t1493-0.34198272D-4*t462*t479
     #-0.33160306176D-8*t715*t1493+0.198068544D-6*t465*t479
     #+0.7044060672D-11*t722*t1493-0.4696040448D-9*t470*t479)
      t1561 = sigmaaa*t28
      t1564 = t16*t37
      t1567 = t26*t613
      t1571 = t34/t755
      v2sigmaaa2(i) = -0.9305257363491D0*t5*(0.18641744D-3*t20*t23
     #-0.427301312D-5*t1561*t31+0.3032704512D-7*t1564*t40
     #-0.8886771712D-10*t1567*t298+0.959881216D-13*t1571*t760)
     #-0.3109D-1*t50*t62*(0.5548928D-1*t20*t69-0.127516432D0*t1561*t73
     #+0.1092570912D0*t1564*t77-0.331006592D-1*t1567*t344
     #+0.31811968D-2*t1571*t841)+t240*(-0.56946816D-3*t20*t252
     #+0.1890954936D-4*t705*t20-0.226832724D-6*t710*t20
     #+0.12435114816D-8*t715*t20-0.2641522752D-11*t722*t20)
      v2sigmaaaab(i) = 0.D0
      t1605 = t9*t89
      v2sigmaaabb(i) = t240*(-0.56946816D-3*t1475*t89+0.1890954936D-4
     #*t705*t1605-0.226832724D-6*t710*t1605+0.12435114816D-8*t715
     #*t1605-0.2641522752D-11*t722*t1605)
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t1617 = sigmabb*t108
      t1620 = t96*t117
      t1623 = t106*t659
      t1627 = t114/t1130
      v2sigmabb2(i) = -0.9305257363491D0*t85*(0.18641744D-3*t100*t103
     #-0.427301312D-5*t1617*t111+0.3032704512D-7*t1620*t120
     #-0.8886771712D-10*t1623*t506+0.959881216D-13*t1627*t1135)
     #-0.3109D-1*t130*t142*(0.5548928D-1*t100*t149-0.127516432D0*t1617
     #*t153+0.1092570912D0*t1620*t157-0.331006592D-1*t1623*t552
     #+0.31811968D-2*t1627*t1169)+t240*(-0.56946816D-3*t100*t252
     #+0.1890954936D-4*t705*t100-0.226832724D-6*t710*t100
     #+0.12435114816D-8*t715*t100-0.2641522752D-11*t722*t100)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_xc_hcth120
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     A.D. Boese, N.L. Doltsinis, N.C. Handy, M. Sprik
c     New generalized gradient approximation functionals
c     J. Chem. Phys. 112 (2000) 1670-1678.
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t4 = rho**2
      t5 = t2**2
      t8 = sigma/t5/t4
      t10 = 1.D0+0.6349604207872798D-2*t8
      t14 = sigma**2
      t15 = t4**2
      t19 = t14/t2/t15/rho
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigma/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t48 = rho*(1.D0+0.1606016560364007D0*t45)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1248219874679732D2*t49
     #+0.4844076716063854D1*t45+0.2326004811900819D1*t52
     #+0.3819082618690966D0*t54))
      t62 = 1.D0+0.3174802103936399D0*t8
      t66 = t62**2
      t74 = t66**2
      t93 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t49
     #+0.2225569421150687D1*t45+0.8004286349993634D0*t52
     #+0.1897004325747559D0*t54))
      t100 = 1.D0+0.9524406311809197D-2*t8
      t104 = t100**2
      t112 = t104**2
      zk(i) = -0.7385587663820224D0*t2*rho*(0.109163D1
     #-0.4744519508185673D-2*t8/t10+0.2047454356900042D-3*t19/t20
     #-0.105150976D-5*t27/t20/t10+0.1904645565053643D-8*t36/t37)
     #-0.3109D-1*t48*t60*(0.489508D0-0.8276677336941153D-1*t8/t62
     #+0.436352992925871D-1*t19/t66-0.6375904D-1*t27/t66/t62
     #+0.2524917573418935D-1*t36/t74)+(-0.62182D-1*rho*(1.D0
     #+0.1325688999052018D0*t45)*t93+0.3109D-1*t48*t60)*(0.51473D0
     #+0.6600242134770161D-1*t8/t100-0.2241305809636867D-2*t19/t104
     #+0.199668672D-4*t27/t104/t100-0.9318124434050518D-7*t36/t112)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigma*t7
      t10 = 1.D0+0.6349604207872798D-2*t8
      t11 = 1/t10
      t14 = sigma**2
      t15 = t4**2
      t16 = t15*rho
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigma
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109163D1-0.4744519508185673D-2*t8*t11
     #+0.2047454356900042D-3*t19*t21-0.105150976D-5*t27*t29
     #+0.1904645565053643D-8*t36*t38
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1606016560364007D0*t45
      t48 = rho*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1248219874679732D2*t49+0.4844076716063854D1*t45
     #+0.2326004811900819D1*t52+0.3819082618690966D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.3174802103936399D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.489508D0-0.8276677336941153D-1*t8*t63
     #+0.436352992925871D-1*t19*t67-0.6375904D-1*t27*t71
     #+0.2524917573418935D-1*t36*t75
      t79 = t60*t78
      t83 = 1.D0+0.1325688999052018D0*t45
      t89 = 0.598255043577108D1*t49+0.2225569421150687D1*t45
     #+0.8004286349993634D0*t52+0.1897004325747559D0*t54
      t92 = 1.D0+0.160818243221511D2/t89
      t93 = dlog(t92)
      t98 = -0.62182D-1*rho*t83*t93+0.3109D-1*t48*t60
      t100 = 1.D0+0.9524406311809197D-2*t8
      t101 = 1/t100
      t104 = t100**2
      t105 = 1/t104
      t109 = 1/t104/t100
      t112 = t104**2
      t113 = 1/t112
      t116 = 0.51473D0+0.6600242134770161D-1*t8*t101
     #-0.2241305809636867D-2*t19*t105+0.199668672D-4*t27*t109
     #-0.9318124434050518D-7*t36*t113
      zk(i) = -0.7385587663820224D0*t3*t41-0.3109D-1*t48*t79+t98*t116
      t120 = t4*rho
      t123 = sigma/t5/t120
      t126 = t15*t4
      t129 = t14/t2/t126
      t134 = t24/t25/rho
      t140 = t32/t5/t25/t120
      t147 = t32*sigma/t2/t25/t126
      t149 = 1/t37/t10
      t155 = t47*t60
      t158 = 1/t54
      t159 = t44*t158
      t162 = t56**2
      t163 = 1/t162
      t165 = t49**2
      t166 = t165**2
      t169 = 1/t4
      t170 = 1/t166/t49*t169
      t172 = t158*t169
      t175 = 1/t52*t169
      t178 = 1/t45*t169
      t180 = -0.4160732915599108D1*t170-0.3229384477375903D1*t172
     #-0.2326004811900819D1*t175-0.5092110158254621D0*t178
      t181 = 1/t59
      t195 = 1/t74/t62
      t206 = t89**2
      t238 = 1/t112/t100
      s1 = -0.9847450218426965D0*t2*t41-0.3692793831910112D0*t3*
     #(0.2530410404365692D-1*t123*t11-0.2344622359538767D-2*t129*t21
     #+0.3069138261333333D-4*t134*t29-0.1474591714685894D-6*t140*t38
     #+0.257999903879912D-9*t147*t149)-0.3109D-1*t155*t78
     #+0.1664368495390566D-2*t159*t79
      vrhoa(i) = s1+0.5D0*t48*t163*t180*t181*t78-0.15545D-1*t48*t60*
     #(0.4414227913035281D0*t123*t63-0.6055861931098544D0*t129*t67
     #+0.1167913642666667D1*t134*t71-0.8625248172685168D0*t140*t75
     #+0.1710104239862703D0*t147*t195)+(-0.62182D-1*t83*t93+rho*
     #(0.2747799777968419D-2*t172*t93+0.1D1*t83/t206*(
     #-0.99709173929518D0*t170-0.7418564737168958D0*t172
     #-0.4002143174996817D0*t175-0.1264669550498372D0*t178)/t92)
     #+0.3109D-1*t155-0.1664368495390566D-2*t159*t60-0.5D0*t48*t163
     #*t180*t181)*t116+t98*(-0.1760064569272043D0*t123*t101
     #+0.136299879940066D-1*t129*t105-0.273586176D-3*t134*t109
     #+0.2515313720859277D-5*t140*t113-0.9466624338548721D-8*t147*t238)
      t245 = sigma*t18
      t248 = t14*t26
      t251 = t24*t35
      t257 = t32/t2/t25/t16
      vsigmaaa(i) = -0.7385587663820224D0*t3*(-0.1897807803274269D-1
     #*t7*t11+0.1758466769654075D-2*t245*t21-0.2301853696D-4*t248*t29
     #+0.1105943786014421D-6*t251*t38-0.193499927909934D-9*t257*t149)
     #-0.3109D-1*t48*t60*(-0.3310670934776461D0*t7*t63
     #+0.4541896448323908D0*t245*t67-0.875935232D0*t248*t71
     #+0.6468936129513876D0*t251*t75-0.1282578179897027D0*t257*t195)
     #+2.D0*t98*(0.1320048426954032D0*t7*t101-0.1022249099550495D-1
     #*t245*t105+0.205189632D-3*t248*t109-0.1886485290644458D-5*t251
     #*t113+0.7099968253911541D-8*t257*t238)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigma*t7
      t10 = 1.D0+0.6349604207872798D-2*t8
      t11 = 1/t10
      t14 = sigma**2
      t15 = t4**2
      t16 = t15*rho
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigma
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.109163D1-0.4744519508185673D-2*t8*t11
     #+0.2047454356900042D-3*t19*t21-0.105150976D-5*t27*t29
     #+0.1904645565053643D-8*t36*t38
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1606016560364007D0*t45
      t48 = rho*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1248219874679732D2*t49+0.4844076716063854D1*t45
     #+0.2326004811900819D1*t52+0.3819082618690966D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.3174802103936399D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.489508D0-0.8276677336941153D-1*t8*t63
     #+0.436352992925871D-1*t19*t67-0.6375904D-1*t27*t71
     #+0.2524917573418935D-1*t36*t75
      t79 = t60*t78
      t83 = 1.D0+0.1325688999052018D0*t45
      t89 = 0.598255043577108D1*t49+0.2225569421150687D1*t45
     #+0.8004286349993634D0*t52+0.1897004325747559D0*t54
      t92 = 1.D0+0.160818243221511D2/t89
      t93 = dlog(t92)
      t98 = -0.62182D-1*rho*t83*t93+0.3109D-1*t48*t60
      t100 = 1.D0+0.9524406311809197D-2*t8
      t101 = 1/t100
      t104 = t100**2
      t105 = 1/t104
      t109 = 1/t104/t100
      t112 = t104**2
      t113 = 1/t112
      t116 = 0.51473D0+0.6600242134770161D-1*t8*t101
     #-0.2241305809636867D-2*t19*t105+0.199668672D-4*t27*t109
     #-0.9318124434050518D-7*t36*t113
      zk(i) = -0.7385587663820224D0*t3*t41-0.3109D-1*t48*t79+t98*t116
      t120 = t4*rho
      t122 = 1/t5/t120
      t123 = sigma*t122
      t126 = t15*t4
      t128 = 1/t2/t126
      t129 = t14*t128
      t133 = 1/t25/rho
      t134 = t24*t133
      t139 = 1/t5/t25/t120
      t140 = t32*t139
      t143 = t32*sigma
      t146 = 1/t2/t25/t126
      t147 = t143*t146
      t149 = 1/t37/t10
      t152 = 0.2530410404365692D-1*t123*t11-0.2344622359538767D-2*t129
     #*t21+0.3069138261333333D-4*t134*t29-0.1474591714685894D-6*t140
     #*t38+0.257999903879912D-9*t147*t149
      t155 = t47*t60
      t158 = 1/t54
      t159 = t44*t158
      t162 = t56**2
      t163 = 1/t162
      t164 = t48*t163
      t165 = t49**2
      t166 = t165**2
      t167 = t166*t49
      t168 = 1/t167
      t169 = 1/t4
      t170 = t168*t169
      t172 = t158*t169
      t174 = 1/t52
      t175 = t174*t169
      t177 = 1/t45
      t178 = t177*t169
      t180 = -0.4160732915599108D1*t170-0.3229384477375903D1*t172
     #-0.2326004811900819D1*t175-0.5092110158254621D0*t178
      t181 = 1/t59
      t182 = t180*t181
      t183 = t182*t78
      t195 = 1/t74/t62
      t198 = 0.4414227913035281D0*t123*t63-0.6055861931098544D0*t129
     #*t67+0.1167913642666667D1*t134*t71-0.8625248172685168D0*t140*t75
     #+0.1710104239862703D0*t147*t195
      t199 = t60*t198
      t204 = t172*t93
      t206 = t89**2
      t207 = 1/t206
      t208 = t83*t207
      t213 = -0.99709173929518D0*t170-0.7418564737168958D0*t172
     #-0.4002143174996817D0*t175-0.1264669550498372D0*t178
      t214 = 1/t92
      t216 = t208*t213*t214
      t224 = t163*t180*t181
      t227 = -0.62182D-1*t83*t93+rho*(0.2747799777968419D-2*t204+0.1D1
     #*t216)+0.3109D-1*t155-0.1664368495390566D-2*t159*t60-0.5D0*t48
     #*t224
      t238 = 1/t112/t100
      t241 = -0.1760064569272043D0*t123*t101+0.136299879940066D-1*t129
     #*t105-0.273586176D-3*t134*t109+0.2515313720859277D-5*t140*t113
     #-0.9466624338548721D-8*t147*t238
      vrhoa(i) = -0.9847450218426965D0*t2*t41-0.3692793831910112D0*t3
     #*t152-0.3109D-1*t155*t78+0.1664368495390566D-2*t159*t79+0.5D0
     #*t164*t183-0.15545D-1*t48*t199+t227*t116+t98*t241
      t245 = sigma*t18
      t248 = t14*t26
      t251 = t24*t35
      t256 = 1/t2/t25/t16
      t257 = t32*t256
      t260 = -0.1897807803274269D-1*t7*t11+0.1758466769654075D-2*t245
     #*t21-0.2301853696D-4*t248*t29+0.1105943786014421D-6*t251*t38
     #-0.193499927909934D-9*t257*t149
      t273 = -0.3310670934776461D0*t7*t63+0.4541896448323908D0*t245
     #*t67-0.875935232D0*t248*t71+0.6468936129513876D0*t251*t75
     #-0.1282578179897027D0*t257*t195
      t274 = t60*t273
      t287 = 0.1320048426954032D0*t7*t101-0.1022249099550495D-1*t245
     #*t105+0.205189632D-3*t248*t109-0.1886485290644458D-5*t251*t113
     #+0.7099968253911541D-8*t257*t238
      vsigmaaa(i) = -0.7385587663820224D0*t3*t260-0.3109D-1*t48*t274
     #+2.D0*t98*t287
      t294 = sigma/t5/t15
      t297 = t15*t120
      t300 = t14/t2/t297
      t301 = t300*t105
      t304 = t24/t33
      t305 = t304*t109
      t310 = t32/t5/t25/t15
      t311 = t310*t113
      t316 = t143/t2/t25/t297
      t317 = t316*t238
      t320 = t25**2
      t323 = t32*t14/t320/t4
      t325 = 1/t112/t104
      t327 = 0.1202186354688D-8*t323*t325
      t334 = t47*t163
      t348 = 1/t37/t20
      t361 = 1/t15
      t362 = 1/t167/t44*t361
      t364 = 1/t120
      t365 = t168*t364
      t368 = 1/t54/t44
      t369 = t368*t361
      t371 = t158*t364
      t375 = 1/t52/t44*t361
      t377 = t174*t364
      t381 = 1/t45/t44*t361
      t383 = t177*t364
      t385 = -0.6934554859331846D1*t362+0.1664293166239643D2*t365
     #-0.4305845969834537D1*t369+0.1291753790950361D2*t371
     #-0.2326004811900819D1*t375+0.9304019247603276D1*t377
     #-0.3394740105503081D0*t381+0.2036844063301848D1*t383
      t390 = t364*t368
      t397 = 1/t162/t56
      t399 = t180**2
      t416 = t162**2
      t417 = 1/t416
      t419 = t59**2
      t420 = 1/t419
      t424 = 0.2D1*t216
      t425 = 0.5495599555936838D-2*t204
      t427 = 0.1831866518645613D-2*t369*t93
      t429 = 0.5495599555936838D-2*t371*t93
      t440 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t49
     #+0.2247591863577616D1*t45+0.4300972471276643D0*t52
     #+0.1911512595127338D0*t54))
      t442 = (1.D0+0.6901399211255825D-1*t45)*t440*t169
      t447 = t213**2
      t450 = 0.2D1*t83/t206/t89*t447*t214
      t462 = 0.1D1*t208*(-0.8309097827459833D0*t362
     #+0.199418347859036D1*t365-0.4945709824779306D0*t369
     #+0.1483712947433792D1*t371-0.2001071587498409D0*t375
     #+0.8004286349993634D0*t377-0.4215565168327908D-1*t381
     #+0.2529339100996745D0*t383)*t214
      t463 = t206**2
      t466 = t92**2
      t470 = 0.160818243221511D2*t83/t463*t447/t466
      t474 = 0.8837926660346786D-1*t172*t207*t213*t214
      t492 = 1/t74/t66
      s1 = 4.D0*t227*t241+t98*(0.1290714017466165D1*t294*t101
     #-0.140770165298137D0*t301+0.415778512896D-2*t305
     #-0.5941411093198738D-4*t311+0.4259391834712889D-6*t317-t327)
     #+0.3328736990781132D-2*t159*t199-0.6218D-1*t155*t198+0.2D1*t334
     #*t183-0.3692793831910112D0*t3*(-0.1855634296534841D0*t294*t11
     #+0.30555462130222D-1*t300*t21-0.7112440763733333D-3*t304*t29
     #+0.6558764115926639D-5*t310*t38-0.2737055459168051D-7*t316*t149
     #+0.4368526067484444D-10*t323*t348)-0.6564966812284644D0/t5*t41
     #-0.1969490043685393D1*t2*t152+0.5D0*t164*t385*t181*t78
      s2 = s1+0.2219157993854088D-2*t390*t79-0.1070677706909338D0*t159
     #*t163*t183-0.1D1*t48*t397*t399*t181*t78+(-0.2219157993854088D-2
     #*t390*t60+0.1070677706909338D0*t159*t224-0.5D0*t48*t163*t385
     #*t181+0.1D1*t48*t397*t399*t181-0.1608234158893535D2*t48*t417
     #*t399*t420+t424+t425+rho*(t427-t429+0.3377399869956914D-1*t442
     #-t450+t462+t470-t474)-0.2D1*t334*t182)*t116
      v2rhoa2(i) = s2-0.15545D-1*t48*t60*(-0.3237100469559206D1*t294
     #*t63+0.8418187782887979D1*t300*t67-0.2307323630933333D2*t304*t71
     #+0.2605821057352538D2*t310*t75-0.107441027773375D2*t316*t195
     #+0.1447798010311111D1*t323*t492)+0.1608234158893535D2*t48*t417
     #*t399*t420*t78+0.1D1*t164*t182*t198+(t425+t424+rho*(t427-t429
     #-0.3377399869956914D-1*t442-t450+t462+t470-t474))*t116+t98*(
     #-0.4081692000875529D-1*t301+0.215148650496D-2*t305
     #-0.4096847697901935D-4*t311+0.356517271655265D-6*t317-t327)
      t522 = sigma*t128
      t525 = t14*t133
      t528 = t24*t139
      t531 = t32*t146
      t536 = t143/t320/rho
      t569 = t522*t105
      t571 = t525*t109
      t573 = t528*t113
      t575 = t531*t238
      t578 = 0.901639766016D-9*t536*t325
      s1 = -0.9847450218426965D0*t2*t260-0.3692793831910112D0*t3*
     #(0.1012164161746277D0*t122*t11-0.1939966305835835D-1*t522*t21
     #+0.48739598336D-3*t525*t29-0.4697884329742095D-5*t528*t38
     #+0.2014091608794051D-7*t531*t149-0.3276394550613333D-10*t536
     #*t348)-0.3109D-1*t155*t273+0.1664368495390566D-2*t159*t274
      v2rhoasigmaaa(i) = s1+0.5D0*t164*t182*t273-0.15545D-1*t48*t60*
     #(0.1765691165214113D1*t122*t63-0.5405261547501203D1*t522*t67
     #+0.15553056768D2*t525*t71-0.1824987070424126D2*t528*t75
     #+0.7801561447023719D1*t531*t195-0.1085848507733333D1*t536*t492)
     #+2.D0*t227*t287+t98*(-0.7040258277088172D0*t122*t101
     #+0.8513264198259285D-1*t569-0.270795958272D-2*t571
     #+0.4078761261770162D-4*t573-0.3052544510956436D-6*t575+t578)+t98
     #*(0.3061269000656647D-1*t569-0.161361487872D-2*t571
     #+0.3072635773426451D-4*t573-0.2673879537414487D-6*t575+t578)
      t589 = sigma*t26
      t592 = t14*t35
      t595 = t24*t256
      t599 = t32/t320
      v2sigmaaa2(i) = -0.7385587663820224D0*t3*(0.7515880215152465D-2
     #*t18*t21-0.27347283968D-3*t589*t29+0.3081035732900803D-5*t592
     #*t38-0.1433168735431565D-7*t595*t149+0.245729591296D-10*t599
     #*t348)-0.3109D-1*t48*t60*(0.2237187581296339D1*t18*t67
     #-0.8161051648D1*t589*t71+0.1109982857637539D2*t592*t75
     #-0.5338139813308978D1*t595*t195+0.8143863808D0*t599*t492)+4.D0
     #*t98*(-0.2295951750492485D-1*t18*t105+0.121021115904D-2*t589
     #*t109-0.2304476830069838D-4*t592*t113+0.2005409653060866D-6*t595
     #*t238-0.676229824512D-9*t599*t325)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:XC_HCTH120subrend
c:XC_HCTHsubrstart

c    Generated: Fri Feb 14 10:46:20 GMT 2003

      subroutine uks_xc_hcth
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     F.A. Hamprecht, A.J. Cohen, D.J. Tozer, and N.C. Handy
c     Development and assessment of new exchange-correlation functionals
c     J. Chem. Phys. 109 (1998) 6264-6271
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t4 = rhob**2
      t5 = t2**2
      t8 = sigmabb/t5/t4
      t10 = 1.D0+0.4D-2*t8
      t14 = sigmabb**2
      t15 = t4**2
      t19 = t14/t2/t15/rhob
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigmabb/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t49
     #+0.3844746237447211D1*t45+0.1644733775567609D1*t52
     #+0.2405871291288192D0*t54))
      t62 = 1.D0+0.2D0*t8
      t66 = t62**2
      t74 = t66**2
      zk(i) = -0.9305257363491D0*t2*rhob*(0.10932D1-0.2976224D-2*t8
     #/t10+0.895872D-4*t19/t20-0.43427136D-6*t27/t20/t10
     #+0.115035392D-8*t36/t37)-0.3109D-1*rhob*(1.D0
     #+0.1274696188700087D0*t45)*t60*(0.222601D0-0.677244D-2*t8/t62
     #-0.50068D-3*t19/t66-0.6419968D-2*t27/t66/t62+0.2486336D-2*t36/t74)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t4 = rhoa**2
      t5 = t2**2
      t8 = sigmaaa/t5/t4
      t10 = 1.D0+0.4D-2*t8
      t14 = sigmaaa**2
      t15 = t4**2
      t19 = t14/t2/t15/rhoa
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigmaaa/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t49
     #+0.3844746237447211D1*t45+0.1644733775567609D1*t52
     #+0.2405871291288192D0*t54))
      t62 = 1.D0+0.2D0*t8
      t66 = t62**2
      t74 = t66**2
      zk(i) = -0.9305257363491D0*t2*rhoa*(0.10932D1-0.2976224D-2*t8
     #/t10+0.895872D-4*t19/t20-0.43427136D-6*t27/t20/t10
     #+0.115035392D-8*t36/t37)-0.3109D-1*rhoa*(1.D0
     #+0.1274696188700087D0*t45)*t60*(0.222601D0-0.677244D-2*t8/t62
     #-0.50068D-3*t19/t66-0.6419968D-2*t27/t66/t62+0.2486336D-2*t36/t74)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t6 = rhoa**2
      t7 = t4**2
      t10 = sigmaaa/t7/t6
      t12 = 1.D0+0.4D-2*t10
      t16 = sigmaaa**2
      t17 = t6**2
      t21 = t16/t4/t17/rhoa
      t22 = t12**2
      t27 = t17**2
      t29 = t16*sigmaaa/t27
      t34 = t16**2
      t38 = t34/t7/t27/t6
      t39 = t22**2
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t50 = rhoa*(1.D0+0.1274696188700087D0*t47)
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t62 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t51
     #+0.3844746237447211D1*t47+0.1644733775567609D1*t54
     #+0.2405871291288192D0*t56))
      t64 = 1.D0+0.2D0*t10
      t68 = t64**2
      t76 = t68**2
      t84 = rhob**(1.D0/3.D0)
      t86 = rhob**2
      t87 = t84**2
      t90 = sigmabb/t87/t86
      t92 = 1.D0+0.4D-2*t90
      t96 = sigmabb**2
      t97 = t86**2
      t101 = t96/t84/t97/rhob
      t102 = t92**2
      t107 = t97**2
      t109 = t96*sigmabb/t107
      t114 = t96**2
      t118 = t114/t87/t107/t86
      t119 = t102**2
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t130 = rhob*(1.D0+0.1274696188700087D0*t127)
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t142 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t131
     #+0.3844746237447211D1*t127+0.1644733775567609D1*t134
     #+0.2405871291288192D0*t136))
      t144 = 1.D0+0.2D0*t90
      t148 = t144**2
      t156 = t148**2
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t180 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t169
     #+0.2225569421150687D1*t166+0.8004286349993634D0*t172
     #+0.1897004325747559D0*t174))
      t182 = 0.62182D-1*(1.D0+0.1325688999052018D0*t166)*t180
      t193 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t169
     #+0.2247591863577616D1*t166+0.4300972471276643D0*t172
     #+0.1911512595127338D0*t174))
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t211 = t207/t209
      t227 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t169
     #+0.3844746237447211D1*t166+0.1644733775567609D1*t172
     #+0.2405871291288192D0*t174))
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t250 = t243**2
      t251 = t246**2
      t260 = t250**2
      t261 = t251**2
      s1 = -0.9305257363491D0*t4*rhoa*(0.10932D1-0.2976224D-2*t10/t12
     #+0.895872D-4*t21/t22-0.43427136D-6*t29/t22/t12+0.115035392D-8
     #*t38/t39)-0.3109D-1*t50*t62*(0.222601D0-0.677244D-2*t10/t64
     #-0.50068D-3*t21/t68-0.6419968D-2*t29/t68/t64+0.2486336D-2*t38/t76)
      zk(i) = s1-0.9305257363491D0*t84*rhob*(0.10932D1-0.2976224D-2
     #*t90/t92+0.895872D-4*t101/t102-0.43427136D-6*t109/t102/t92
     #+0.115035392D-8*t118/t119)-0.3109D-1*t130*t142*(0.222601D0
     #-0.677244D-2*t90/t144-0.50068D-3*t101/t148-0.6419968D-2*t109
     #/t148/t144+0.2486336D-2*t118/t156)+(t164*(-t182
     #+0.3799574853701528D-1*(1.D0+0.6901399211255825D-1*t166)*t193
     #*t205*(1.D0-1.D0*t211)+0.1923661050931536D1*(-0.3109D-1*(1.D0
     #+0.1274696188700087D0*t166)*t227+t182)*t205*t211)+0.3109D-1*t50
     #*t62+0.3109D-1*t130*t142)*(0.729974D0+0.2011722D-1*t243/t246
     #-0.415548D-3*t250/t251+0.174649824D-5*t250*t243/t251/t246
     #-0.580422672D-8*t260/t261)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmabb*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmabb**2
      t15 = t4**2
      t16 = t15*rhob
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmabb
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.10932D1-0.2976224D-2*t8*t11+0.895872D-4*t19*t21
     #-0.43427136D-6*t27*t29+0.115035392D-8*t36*t38
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhob*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.222601D0-0.677244D-2*t8*t63-0.50068D-3*t19*t67
     #-0.6419968D-2*t27*t71+0.2486336D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      vrhoa(i) = 0.D0
      t84 = t4*rhob
      t87 = sigmabb/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhob
      t104 = t32/t5/t25/t84
      t111 = t32*sigmabb/t2/t25/t90
      t113 = 1/t37/t10
      t122 = 1/t54
      t126 = t56**2
      t129 = t49**2
      t130 = t129**2
      t133 = 1/t4
      t159 = 1/t74/t62
      vrhob(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*
     #(0.7936597333333333D-2*t87*t11-0.5095447893333333D-3*t93*t21
     #+0.538536448D-5*t98*t29-0.2616712533333333D-7*t104*t38
     #+0.4908176725333333D-10*t111*t113)-0.3109D-1*t47*t60*t78
     #+0.1321010150222857D-2*t44*t122*t79+0.1D1*t48/t126*(
     #-0.1853395810515781D1/t130/t49*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0/t52*t133-0.1603914194192128D0/t45
     #*t133)/t59*t78-0.3109D-1*t48*t60*(0.1805984D-1*t87*t63
     #-0.9416746666666667D-3*t93*t67+0.5082568533333333D-1*t98*t71
     #-0.3679286613333333D-1*t104*t75+0.5304183466666667D-2*t111*t159)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t168 = sigmabb*t18
      t171 = t14*t26
      t174 = t24*t35
      t180 = t32/t2/t25/t16
      vsigmabb(i) = -0.9305257363491D0*t3*(-0.2976224D-2*t7*t11
     #+0.191079296D-3*t168*t21-0.201951168D-5*t171*t29+0.9812672D-8
     #*t174*t38-0.1840566272D-10*t180*t113)-0.3109D-1*t48*t60*(
     #-0.677244D-2*t7*t63+0.353128D-3*t168*t67-0.19059632D-1*t171*t71
     #+0.137973248D-1*t174*t75-0.19890688D-2*t180*t159)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmaaa*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmaaa**2
      t15 = t4**2
      t16 = t15*rhoa
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmaaa
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.10932D1-0.2976224D-2*t8*t11+0.895872D-4*t19*t21
     #-0.43427136D-6*t27*t29+0.115035392D-8*t36*t38
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhoa*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.222601D0-0.677244D-2*t8*t63-0.50068D-3*t19*t67
     #-0.6419968D-2*t27*t71+0.2486336D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      t84 = t4*rhoa
      t87 = sigmaaa/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhoa
      t104 = t32/t5/t25/t84
      t111 = t32*sigmaaa/t2/t25/t90
      t113 = 1/t37/t10
      t122 = 1/t54
      t126 = t56**2
      t129 = t49**2
      t130 = t129**2
      t133 = 1/t4
      t159 = 1/t74/t62
      vrhoa(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*
     #(0.7936597333333333D-2*t87*t11-0.5095447893333333D-3*t93*t21
     #+0.538536448D-5*t98*t29-0.2616712533333333D-7*t104*t38
     #+0.4908176725333333D-10*t111*t113)-0.3109D-1*t47*t60*t78
     #+0.1321010150222857D-2*t44*t122*t79+0.1D1*t48/t126*(
     #-0.1853395810515781D1/t130/t49*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0/t52*t133-0.1603914194192128D0/t45
     #*t133)/t59*t78-0.3109D-1*t48*t60*(0.1805984D-1*t87*t63
     #-0.9416746666666667D-3*t93*t67+0.5082568533333333D-1*t98*t71
     #-0.3679286613333333D-1*t104*t75+0.5304183466666667D-2*t111*t159)
      vrhob(i) = 0.D0
      t168 = sigmaaa*t18
      t171 = t14*t26
      t174 = t24*t35
      t180 = t32/t2/t25/t16
      vsigmaaa(i) = -0.9305257363491D0*t3*(-0.2976224D-2*t7*t11
     #+0.191079296D-3*t168*t21-0.201951168D-5*t171*t29+0.9812672D-8
     #*t174*t38-0.1840566272D-10*t180*t113)-0.3109D-1*t48*t60*(
     #-0.677244D-2*t7*t63+0.353128D-3*t168*t67-0.19059632D-1*t171*t71
     #+0.137973248D-1*t174*t75-0.19890688D-2*t180*t159)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t9 = 1/t7/t6
      t10 = sigmaaa*t9
      t12 = 1.D0+0.4D-2*t10
      t13 = 1/t12
      t16 = sigmaaa**2
      t17 = t6**2
      t18 = t17*rhoa
      t20 = 1/t4/t18
      t21 = t16*t20
      t22 = t12**2
      t23 = 1/t22
      t26 = t16*sigmaaa
      t27 = t17**2
      t28 = 1/t27
      t29 = t26*t28
      t31 = 1/t22/t12
      t34 = t16**2
      t37 = 1/t7/t27/t6
      t38 = t34*t37
      t39 = t22**2
      t40 = 1/t39
      t43 = 0.10932D1-0.2976224D-2*t10*t13+0.895872D-4*t21*t23
     #-0.43427136D-6*t29*t31+0.115035392D-8*t38*t40
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t49 = 1.D0+0.1274696188700087D0*t47
      t50 = rhoa*t49
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t58 = 0.1112037486309468D2*t51+0.3844746237447211D1*t47
     #+0.1644733775567609D1*t54+0.2405871291288192D0*t56
      t61 = 1.D0+0.321646831778707D2/t58
      t62 = dlog(t61)
      t64 = 1.D0+0.2D0*t10
      t65 = 1/t64
      t68 = t64**2
      t69 = 1/t68
      t73 = 1/t68/t64
      t76 = t68**2
      t77 = 1/t76
      t80 = 0.222601D0-0.677244D-2*t10*t65-0.50068D-3*t21*t69
     #-0.6419968D-2*t29*t73+0.2486336D-2*t38*t77
      t81 = t62*t80
      t84 = rhob**(1.D0/3.D0)
      t85 = t84*rhob
      t86 = rhob**2
      t87 = t84**2
      t89 = 1/t87/t86
      t90 = sigmabb*t89
      t92 = 1.D0+0.4D-2*t90
      t93 = 1/t92
      t96 = sigmabb**2
      t97 = t86**2
      t98 = t97*rhob
      t100 = 1/t84/t98
      t101 = t96*t100
      t102 = t92**2
      t103 = 1/t102
      t106 = t96*sigmabb
      t107 = t97**2
      t108 = 1/t107
      t109 = t106*t108
      t111 = 1/t102/t92
      t114 = t96**2
      t117 = 1/t87/t107/t86
      t118 = t114*t117
      t119 = t102**2
      t120 = 1/t119
      t123 = 0.10932D1-0.2976224D-2*t90*t93+0.895872D-4*t101*t103
     #-0.43427136D-6*t109*t111+0.115035392D-8*t118*t120
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t129 = 1.D0+0.1274696188700087D0*t127
      t130 = rhob*t129
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t138 = 0.1112037486309468D2*t131+0.3844746237447211D1*t127
     #+0.1644733775567609D1*t134+0.2405871291288192D0*t136
      t141 = 1.D0+0.321646831778707D2/t138
      t142 = dlog(t141)
      t144 = 1.D0+0.2D0*t90
      t145 = 1/t144
      t148 = t144**2
      t149 = 1/t148
      t153 = 1/t148/t144
      t156 = t148**2
      t157 = 1/t156
      t160 = 0.222601D0-0.677244D-2*t90*t145-0.50068D-3*t101*t149
     #-0.6419968D-2*t109*t153+0.2486336D-2*t118*t157
      t161 = t142*t160
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t168 = 1.D0+0.1325688999052018D0*t166
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t176 = 0.598255043577108D1*t169+0.2225569421150687D1*t166
     #+0.8004286349993634D0*t172+0.1897004325747559D0*t174
      t179 = 1.D0+0.160818243221511D2/t176
      t180 = dlog(t179)
      t182 = 0.62182D-1*t168*t180
      t184 = 1.D0+0.6901399211255825D-1*t166
      t189 = 0.8157414703487641D1*t169+0.2247591863577616D1*t166
     #+0.4300972471276643D0*t172+0.1911512595127338D0*t174
      t192 = 1.D0+0.2960857464321668D2/t189
      t193 = dlog(t192)
      t194 = t184*t193
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t210 = 1/t209
      t211 = t207*t210
      t213 = 1.D0-1.D0*t211
      t216 = 0.3799574853701528D-1*t194*t205*t213
      t218 = 1.D0+0.1274696188700087D0*t166
      t223 = 0.1112037486309468D2*t169+0.3844746237447211D1*t166
     #+0.1644733775567609D1*t172+0.2405871291288192D0*t174
      t226 = 1.D0+0.321646831778707D2/t223
      t227 = dlog(t226)
      t230 = -0.3109D-1*t218*t227+t182
      t231 = t230*t205
      t233 = 0.1923661050931536D1*t231*t211
      t240 = t164*(-t182+t216+t233)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t247 = 1/t246
      t250 = t243**2
      t251 = t246**2
      t252 = 1/t251
      t255 = t250*t243
      t257 = 1/t251/t246
      t260 = t250**2
      t261 = t251**2
      t262 = 1/t261
      t265 = 0.729974D0+0.2011722D-1*t243*t247-0.415548D-3*t250*t252
     #+0.174649824D-5*t255*t257-0.580422672D-8*t260*t262
      zk(i) = -0.9305257363491D0*t5*t43-0.3109D-1*t50*t81
     #-0.9305257363491D0*t85*t123-0.3109D-1*t130*t161+t240*t265
      t269 = t6*rhoa
      t272 = sigmaaa/t7/t269
      t275 = t17*t6
      t278 = t16/t4/t275
      t283 = t26/t27/rhoa
      t289 = t34/t7/t27/t269
      t296 = t34*sigmaaa/t4/t27/t275
      t298 = 1/t39/t12
      t304 = t49*t62
      t307 = 1/t56
      t308 = t46*t307
      t311 = t58**2
      t312 = 1/t311
      t314 = t51**2
      t315 = t314**2
      t318 = 1/t6
      t329 = -0.1853395810515781D1/t315/t51*t318-0.128158207914907D1
     #*t307*t318-0.8223668877838045D0/t54*t318-0.1603914194192128D0
     #/t47*t318
      t330 = 1/t61
      t344 = 1/t76/t64
      t352 = 1/t208
      t353 = 1/t174*t352
      t354 = t353*t180
      t355 = 0.2747799777968419D-2*t354
      t356 = t176**2
      t359 = t169**2
      t360 = t359**2
      t363 = 1/t360/t169*t352
      t367 = 1/t172*t352
      t370 = 1/t166*t352
      t375 = t168/t356*(-0.99709173929518D0*t363-0.7418564737168958D0
     #*t353-0.4002143174996817D0*t367-0.1264669550498372D0*t370)/t179
      t376 = 0.1D1*t375
      t380 = 0.8740794299481065D-3*t353*t193*t205*t213
      t381 = t189**2
      t394 = 0.1124999956683108D1*t184/t381*(-0.135956911724794D1*t363
     #-0.7491972878592054D0*t353-0.2150486235638321D0*t367
     #-0.1274341730084892D0*t370)/t192*t205*t213
      t395 = t196*t352
      t396 = 1.D0*t395
      t400 = 1.D0*t165
      t404 = 0.1333333333333333D1*t199*(t165-t396)
     #+0.1333333333333333D1*t203*(-t400+t395)
      t409 = t206*t196*t210
      t410 = 4.D0*t409
      t413 = t207/t209/t164
      t414 = 4.D0*t413
      t421 = t223**2
      t438 = 0.1923661050931536D1*(0.1321010150222857D-2*t353*t227
     #+0.1D1*t218/t421*(-0.1853395810515781D1*t363-0.128158207914907D1
     #*t353-0.8223668877838045D0*t367-0.1603914194192128D0*t370)/t226
     #-0.2747799777968419D-2*t354-0.1D1*t375)*t205*t211
      t442 = t231*t409
      t445 = 0.7694644203726145D1*t231*t413
      t459 = t243*t252
      t462 = t250*t257
      t465 = t255*t262
      t470 = t260/t261/t246
      s1 = -0.12407009817988D1*t4*t43-0.9305257363491D0*t5*
     #(0.7936597333333333D-2*t272*t13-0.5095447893333333D-3*t278*t23
     #+0.538536448D-5*t283*t31-0.2616712533333333D-7*t289*t40
     #+0.4908176725333333D-10*t296*t298)-0.3109D-1*t304*t80
     #+0.1321010150222857D-2*t308*t81
      vrhoa(i) = s1+0.1D1*t50*t312*t329*t330*t80-0.3109D-1*t50*t62*
     #(0.1805984D-1*t272*t65-0.9416746666666667D-3*t278*t69
     #+0.5082568533333333D-1*t283*t73-0.3679286613333333D-1*t289*t77
     #+0.5304183466666667D-2*t296*t344)+(-t182+t216+t233+t164*(t355
     #+t376-t380-t394+0.3799574853701528D-1*t194*t404*t213
     #+0.3799574853701528D-1*t194*t205*(-t410+t414)+t438
     #+0.1923661050931536D1*t230*t404*t211+0.7694644203726145D1*t442
     #-t445)+0.3109D-1*t304-0.1321010150222857D-2*t308*t62-0.1D1*t50
     #*t312*t329*t330)*t265+t240*(-0.2682296D-1*t272*t247
     #+0.126906576D-2*t459*t272-0.1363476096D-4*t462*t272
     #+0.728718336D-7*t465*t272-0.18573525504D-9*t470*t272)
      t477 = t86*rhob
      t480 = sigmabb/t87/t477
      t483 = t97*t86
      t486 = t96/t84/t483
      t491 = t106/t107/rhob
      t497 = t114/t87/t107/t477
      t504 = t114*sigmabb/t84/t107/t483
      t506 = 1/t119/t92
      t512 = t129*t142
      t515 = 1/t136
      t516 = t126*t515
      t519 = t138**2
      t520 = 1/t519
      t522 = t131**2
      t523 = t522**2
      t526 = 1/t86
      t537 = -0.1853395810515781D1/t523/t131*t526-0.128158207914907D1
     #*t515*t526-0.8223668877838045D0/t134*t526-0.1603914194192128D0
     #/t127*t526
      t538 = 1/t141
      t552 = 1/t156/t144
      t565 = 0.1333333333333333D1*t199*(-t400-t396)
     #+0.1333333333333333D1*t203*(t165+t395)
      s1 = -0.12407009817988D1*t84*t123-0.9305257363491D0*t85*
     #(0.7936597333333333D-2*t480*t93-0.5095447893333333D-3*t486*t103
     #+0.538536448D-5*t491*t111-0.2616712533333333D-7*t497*t120
     #+0.4908176725333333D-10*t504*t506)-0.3109D-1*t512*t160
     #+0.1321010150222857D-2*t516*t161
      vrhob(i) = s1+0.1D1*t130*t520*t537*t538*t160-0.3109D-1*t130*t142
     #*(0.1805984D-1*t480*t145-0.9416746666666667D-3*t486*t149
     #+0.5082568533333333D-1*t491*t153-0.3679286613333333D-1*t497*t157
     #+0.5304183466666667D-2*t504*t552)+(-t182+t216+t233+t164*(t355
     #+t376-t380-t394+0.3799574853701528D-1*t194*t565*t213
     #+0.3799574853701528D-1*t194*t205*(t410+t414)+t438
     #+0.1923661050931536D1*t230*t565*t211-0.7694644203726145D1*t442
     #-t445)+0.3109D-1*t512-0.1321010150222857D-2*t516*t142-0.1D1*t130
     #*t520*t537*t538)*t265+t240*(-0.2682296D-1*t480*t247
     #+0.126906576D-2*t459*t480-0.1363476096D-4*t462*t480
     #+0.728718336D-7*t465*t480-0.18573525504D-9*t470*t480)
      t602 = sigmaaa*t20
      t605 = t16*t28
      t608 = t26*t37
      t614 = t34/t4/t27/t18
      vsigmaaa(i) = -0.9305257363491D0*t5*(-0.2976224D-2*t9*t13
     #+0.191079296D-3*t602*t23-0.201951168D-5*t605*t31+0.9812672D-8
     #*t608*t40-0.1840566272D-10*t614*t298)-0.3109D-1*t50*t62*(
     #-0.677244D-2*t9*t65+0.353128D-3*t602*t69-0.19059632D-1*t605*t73
     #+0.137973248D-1*t608*t77-0.19890688D-2*t614*t344)+t240*
     #(0.1005861D-1*t9*t247-0.47589966D-3*t459*t9+0.511303536D-5*t462
     #*t9-0.273269376D-7*t465*t9+0.6965072064D-10*t470*t9)
      vsigmaab(i) = 0.D0
      t648 = sigmabb*t100
      t651 = t96*t108
      t654 = t106*t117
      t660 = t114/t84/t107/t98
      vsigmabb(i) = -0.9305257363491D0*t85*(-0.2976224D-2*t89*t93
     #+0.191079296D-3*t648*t103-0.201951168D-5*t651*t111+0.9812672D-8
     #*t654*t120-0.1840566272D-10*t660*t506)-0.3109D-1*t130*t142*(
     #-0.677244D-2*t89*t145+0.353128D-3*t648*t149-0.19059632D-1*t651
     #*t153+0.137973248D-1*t654*t157-0.19890688D-2*t660*t552)+t240*
     #(0.1005861D-1*t89*t247-0.47589966D-3*t459*t89+0.511303536D-5
     #*t462*t89-0.273269376D-7*t465*t89+0.6965072064D-10*t470*t89)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = rhob**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmabb*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmabb**2
      t15 = t4**2
      t16 = t15*rhob
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmabb
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.10932D1-0.2976224D-2*t8*t11+0.895872D-4*t19*t21
     #-0.43427136D-6*t27*t29+0.115035392D-8*t36*t38
      t44 = 1/rhob
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhob*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.222601D0-0.677244D-2*t8*t63-0.50068D-3*t19*t67
     #-0.6419968D-2*t27*t71+0.2486336D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      vrhoa(i) = 0.D0
      t84 = t4*rhob
      t87 = sigmabb/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhob
      t104 = t32/t5/t25/t84
      t107 = t32*sigmabb
      t111 = t107/t2/t25/t90
      t113 = 1/t37/t10
      t116 = 0.7936597333333333D-2*t87*t11-0.5095447893333333D-3*t93
     #*t21+0.538536448D-5*t98*t29-0.2616712533333333D-7*t104*t38
     #+0.4908176725333333D-10*t111*t113
      t119 = t47*t60
      t122 = 1/t54
      t123 = t44*t122
      t126 = t56**2
      t127 = 1/t126
      t128 = t48*t127
      t129 = t49**2
      t130 = t129**2
      t131 = t130*t49
      t132 = 1/t131
      t133 = 1/t4
      t138 = 1/t52
      t141 = 1/t45
      t144 = -0.1853395810515781D1*t132*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0*t138*t133-0.1603914194192128D0*t141
     #*t133
      t145 = 1/t59
      t146 = t144*t145
      t147 = t146*t78
      t159 = 1/t74/t62
      t162 = 0.1805984D-1*t87*t63-0.9416746666666667D-3*t93*t67
     #+0.5082568533333333D-1*t98*t71-0.3679286613333333D-1*t104*t75
     #+0.5304183466666667D-2*t111*t159
      t163 = t60*t162
      vrhob(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*t116
     #-0.3109D-1*t119*t78+0.1321010150222857D-2*t123*t79+0.1D1*t128
     #*t147-0.3109D-1*t48*t163
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t168 = sigmabb*t18
      t171 = t14*t26
      t174 = t24*t35
      t179 = 1/t2/t25/t16
      t180 = t32*t179
      vsigmabb(i) = -0.9305257363491D0*t3*(-0.2976224D-2*t7*t11
     #+0.191079296D-3*t168*t21-0.201951168D-5*t171*t29+0.9812672D-8
     #*t174*t38-0.1840566272D-10*t180*t113)-0.3109D-1*t48*t60*(
     #-0.677244D-2*t7*t63+0.353128D-3*t168*t67-0.19059632D-1*t171*t71
     #+0.137973248D-1*t174*t75-0.19890688D-2*t180*t159)
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t207 = sigmabb/t5/t15
      t210 = t15*t84
      t213 = t14/t2/t210
      t217 = t24/t33
      t223 = t32/t5/t25/t15
      t229 = t107/t2/t25/t210
      t233 = t25**2
      t236 = t32*t14/t233/t4
      t238 = 1/t37/t20
      t249 = 1/t84
      t251 = 1/t54/t44
      t263 = t144**2
      t270 = 1/t15
      t296 = t126**2
      t299 = t59**2
      t319 = 1/t74/t66
      s1 = -0.4135669939329333D0/t5*t41-0.24814019635976D1*t2*t116
     #-0.9305257363491D0*t3*(-0.2910085688888889D-1*t207*t11
     #+0.3311774037333333D-2*t213*t21-0.5933856915911111D-4*t217*t29
     #+0.4776147922488889D-6*t223*t38-0.1819969344853333D-8*t229*t113
     #+0.2617694253511111D-11*t236*t238)+0.2D1*t47*t127*t147-0.6218D-1
     #*t119*t162+0.8806734334819047D-3*t249*t251*t79
      v2rhob2(i) = s1-0.8497974591333914D-1*t123*t127*t147
     #+0.2642020300445714D-2*t123*t163-0.2D1*t48/t126/t56*t263*t145
     #*t78+0.1D1*t128*(-0.1544496508763151D1/t131/t44*t270
     #+0.3706791621031562D1*t132*t249-0.854388052766047D0*t251*t270
     #+0.2563164158298141D1*t122*t249-0.4111834438919023D0/t52/t44
     #*t270+0.1644733775567609D1*t138*t249-0.5346380647307093D-1/t45
     #/t44*t270+0.3207828388384256D0*t141*t249)*t145*t78
     #+0.321646831778707D2*t48/t296*t263/t299*t78+0.2D1*t128*t146*t162
     #-0.3109D-1*t48*t60*(-0.6621941333333333D-1*t207*t63
     #+0.1559585422222222D-1*t213*t67-0.4584356209777778D0*t217*t71
     #+0.5105712014222222D0*t223*t75-0.15451807744D0*t229*t159
     #+0.1414448924444444D-1*t236*t319)
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t328 = sigmabb*t26
      t331 = t14*t35
      t334 = t24*t179
      t338 = t32/t233
      v2sigmabb2(i) = -0.9305257363491D0*t3*(0.202984192D-3*t18*t21
     #-0.5567657728D-5*t328*t29+0.5367215616D-7*t331*t38
     #-0.23062540288D-9*t334*t113+0.3681132544D-12*t338*t238)
     #-0.3109D-1*t48*t60*(0.1707616D-2*t18*t67-0.382605152D-1*t328*t71
     #+0.528277536D-1*t331*t75-0.1899413504D-1*t334*t159+0.19890688D-2
     #*t338*t319)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = rhoa**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigmaaa*t7
      t10 = 1.D0+0.4D-2*t8
      t11 = 1/t10
      t14 = sigmaaa**2
      t15 = t4**2
      t16 = t15*rhoa
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigmaaa
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.10932D1-0.2976224D-2*t8*t11+0.895872D-4*t19*t21
     #-0.43427136D-6*t27*t29+0.115035392D-8*t36*t38
      t44 = 1/rhoa
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1274696188700087D0*t45
      t48 = rhoa*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1112037486309468D2*t49+0.3844746237447211D1*t45
     #+0.1644733775567609D1*t52+0.2405871291288192D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.2D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.222601D0-0.677244D-2*t8*t63-0.50068D-3*t19*t67
     #-0.6419968D-2*t27*t71+0.2486336D-2*t36*t75
      t79 = t60*t78
      zk(i) = -0.9305257363491D0*t3*t41-0.3109D-1*t48*t79
      t84 = t4*rhoa
      t87 = sigmaaa/t5/t84
      t90 = t15*t4
      t93 = t14/t2/t90
      t98 = t24/t25/rhoa
      t104 = t32/t5/t25/t84
      t107 = t32*sigmaaa
      t111 = t107/t2/t25/t90
      t113 = 1/t37/t10
      t116 = 0.7936597333333333D-2*t87*t11-0.5095447893333333D-3*t93
     #*t21+0.538536448D-5*t98*t29-0.2616712533333333D-7*t104*t38
     #+0.4908176725333333D-10*t111*t113
      t119 = t47*t60
      t122 = 1/t54
      t123 = t44*t122
      t126 = t56**2
      t127 = 1/t126
      t128 = t48*t127
      t129 = t49**2
      t130 = t129**2
      t131 = t130*t49
      t132 = 1/t131
      t133 = 1/t4
      t138 = 1/t52
      t141 = 1/t45
      t144 = -0.1853395810515781D1*t132*t133-0.128158207914907D1*t122
     #*t133-0.8223668877838045D0*t138*t133-0.1603914194192128D0*t141
     #*t133
      t145 = 1/t59
      t146 = t144*t145
      t147 = t146*t78
      t159 = 1/t74/t62
      t162 = 0.1805984D-1*t87*t63-0.9416746666666667D-3*t93*t67
     #+0.5082568533333333D-1*t98*t71-0.3679286613333333D-1*t104*t75
     #+0.5304183466666667D-2*t111*t159
      t163 = t60*t162
      vrhoa(i) = -0.12407009817988D1*t2*t41-0.9305257363491D0*t3*t116
     #-0.3109D-1*t119*t78+0.1321010150222857D-2*t123*t79+0.1D1*t128
     #*t147-0.3109D-1*t48*t163
      vrhob(i) = 0.D0
      t168 = sigmaaa*t18
      t171 = t14*t26
      t174 = t24*t35
      t179 = 1/t2/t25/t16
      t180 = t32*t179
      vsigmaaa(i) = -0.9305257363491D0*t3*(-0.2976224D-2*t7*t11
     #+0.191079296D-3*t168*t21-0.201951168D-5*t171*t29+0.9812672D-8
     #*t174*t38-0.1840566272D-10*t180*t113)-0.3109D-1*t48*t60*(
     #-0.677244D-2*t7*t63+0.353128D-3*t168*t67-0.19059632D-1*t171*t71
     #+0.137973248D-1*t174*t75-0.19890688D-2*t180*t159)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t207 = sigmaaa/t5/t15
      t210 = t15*t84
      t213 = t14/t2/t210
      t217 = t24/t33
      t223 = t32/t5/t25/t15
      t229 = t107/t2/t25/t210
      t233 = t25**2
      t236 = t32*t14/t233/t4
      t238 = 1/t37/t20
      t249 = 1/t84
      t251 = 1/t54/t44
      t263 = t144**2
      t270 = 1/t15
      t296 = t126**2
      t299 = t59**2
      t319 = 1/t74/t66
      s1 = -0.4135669939329333D0/t5*t41-0.24814019635976D1*t2*t116
     #-0.9305257363491D0*t3*(-0.2910085688888889D-1*t207*t11
     #+0.3311774037333333D-2*t213*t21-0.5933856915911111D-4*t217*t29
     #+0.4776147922488889D-6*t223*t38-0.1819969344853333D-8*t229*t113
     #+0.2617694253511111D-11*t236*t238)+0.2D1*t47*t127*t147-0.6218D-1
     #*t119*t162+0.8806734334819047D-3*t249*t251*t79
      v2rhoa2(i) = s1-0.8497974591333914D-1*t123*t127*t147
     #+0.2642020300445714D-2*t123*t163-0.2D1*t48/t126/t56*t263*t145
     #*t78+0.1D1*t128*(-0.1544496508763151D1/t131/t44*t270
     #+0.3706791621031562D1*t132*t249-0.854388052766047D0*t251*t270
     #+0.2563164158298141D1*t122*t249-0.4111834438919023D0/t52/t44
     #*t270+0.1644733775567609D1*t138*t249-0.5346380647307093D-1/t45
     #/t44*t270+0.3207828388384256D0*t141*t249)*t145*t78
     #+0.321646831778707D2*t48/t296*t263/t299*t78+0.2D1*t128*t146*t162
     #-0.3109D-1*t48*t60*(-0.6621941333333333D-1*t207*t63
     #+0.1559585422222222D-1*t213*t67-0.4584356209777778D0*t217*t71
     #+0.5105712014222222D0*t223*t75-0.15451807744D0*t229*t159
     #+0.1414448924444444D-1*t236*t319)
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t328 = sigmaaa*t26
      t331 = t14*t35
      t334 = t24*t179
      t338 = t32/t233
      v2sigmaaa2(i) = -0.9305257363491D0*t3*(0.202984192D-3*t18*t21
     #-0.5567657728D-5*t328*t29+0.5367215616D-7*t331*t38
     #-0.23062540288D-9*t334*t113+0.3681132544D-12*t338*t238)
     #-0.3109D-1*t48*t60*(0.1707616D-2*t18*t67-0.382605152D-1*t328*t71
     #+0.528277536D-1*t331*t75-0.1899413504D-1*t334*t159+0.19890688D-2
     #*t338*t319)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = rhoa**2
      t7 = t4**2
      t9 = 1/t7/t6
      t10 = sigmaaa*t9
      t12 = 1.D0+0.4D-2*t10
      t13 = 1/t12
      t16 = sigmaaa**2
      t17 = t6**2
      t18 = t17*rhoa
      t20 = 1/t4/t18
      t21 = t16*t20
      t22 = t12**2
      t23 = 1/t22
      t26 = t16*sigmaaa
      t27 = t17**2
      t28 = 1/t27
      t29 = t26*t28
      t31 = 1/t22/t12
      t34 = t16**2
      t35 = t27*t6
      t37 = 1/t7/t35
      t38 = t34*t37
      t39 = t22**2
      t40 = 1/t39
      t43 = 0.10932D1-0.2976224D-2*t10*t13+0.895872D-4*t21*t23
     #-0.43427136D-6*t29*t31+0.115035392D-8*t38*t40
      t46 = 1/rhoa
      t47 = t46**(1.D0/3.D0)
      t49 = 1.D0+0.1274696188700087D0*t47
      t50 = rhoa*t49
      t51 = t46**(1.D0/6.D0)
      t54 = dsqrt(t46)
      t56 = t47**2
      t58 = 0.1112037486309468D2*t51+0.3844746237447211D1*t47
     #+0.1644733775567609D1*t54+0.2405871291288192D0*t56
      t61 = 1.D0+0.321646831778707D2/t58
      t62 = dlog(t61)
      t64 = 1.D0+0.2D0*t10
      t65 = 1/t64
      t68 = t64**2
      t69 = 1/t68
      t73 = 1/t68/t64
      t76 = t68**2
      t77 = 1/t76
      t80 = 0.222601D0-0.677244D-2*t10*t65-0.50068D-3*t21*t69
     #-0.6419968D-2*t29*t73+0.2486336D-2*t38*t77
      t81 = t62*t80
      t84 = rhob**(1.D0/3.D0)
      t85 = t84*rhob
      t86 = rhob**2
      t87 = t84**2
      t89 = 1/t87/t86
      t90 = sigmabb*t89
      t92 = 1.D0+0.4D-2*t90
      t93 = 1/t92
      t96 = sigmabb**2
      t97 = t86**2
      t98 = t97*rhob
      t100 = 1/t84/t98
      t101 = t96*t100
      t102 = t92**2
      t103 = 1/t102
      t106 = t96*sigmabb
      t107 = t97**2
      t108 = 1/t107
      t109 = t106*t108
      t111 = 1/t102/t92
      t114 = t96**2
      t115 = t107*t86
      t117 = 1/t87/t115
      t118 = t114*t117
      t119 = t102**2
      t120 = 1/t119
      t123 = 0.10932D1-0.2976224D-2*t90*t93+0.895872D-4*t101*t103
     #-0.43427136D-6*t109*t111+0.115035392D-8*t118*t120
      t126 = 1/rhob
      t127 = t126**(1.D0/3.D0)
      t129 = 1.D0+0.1274696188700087D0*t127
      t130 = rhob*t129
      t131 = t126**(1.D0/6.D0)
      t134 = dsqrt(t126)
      t136 = t127**2
      t138 = 0.1112037486309468D2*t131+0.3844746237447211D1*t127
     #+0.1644733775567609D1*t134+0.2405871291288192D0*t136
      t141 = 1.D0+0.321646831778707D2/t138
      t142 = dlog(t141)
      t144 = 1.D0+0.2D0*t90
      t145 = 1/t144
      t148 = t144**2
      t149 = 1/t148
      t153 = 1/t148/t144
      t156 = t148**2
      t157 = 1/t156
      t160 = 0.222601D0-0.677244D-2*t90*t145-0.50068D-3*t101*t149
     #-0.6419968D-2*t109*t153+0.2486336D-2*t118*t157
      t161 = t142*t160
      t164 = rhoa+rhob
      t165 = 1/t164
      t166 = t165**(1.D0/3.D0)
      t168 = 1.D0+0.1325688999052018D0*t166
      t169 = t165**(1.D0/6.D0)
      t172 = dsqrt(t165)
      t174 = t166**2
      t176 = 0.598255043577108D1*t169+0.2225569421150687D1*t166
     #+0.8004286349993634D0*t172+0.1897004325747559D0*t174
      t179 = 1.D0+0.160818243221511D2/t176
      t180 = dlog(t179)
      t182 = 0.62182D-1*t168*t180
      t184 = 1.D0+0.6901399211255825D-1*t166
      t189 = 0.8157414703487641D1*t169+0.2247591863577616D1*t166
     #+0.4300972471276643D0*t172+0.1911512595127338D0*t174
      t192 = 1.D0+0.2960857464321668D2/t189
      t193 = dlog(t192)
      t194 = t184*t193
      t196 = rhoa-1.D0*rhob
      t197 = t196*t165
      t198 = 1.D0+t197
      t199 = t198**(1.D0/3.D0)
      t202 = 1.D0-1.D0*t197
      t203 = t202**(1.D0/3.D0)
      t205 = t199*t198+t203*t202-2.D0
      t206 = t196**2
      t207 = t206**2
      t208 = t164**2
      t209 = t208**2
      t210 = 1/t209
      t211 = t207*t210
      t213 = 1.D0-1.D0*t211
      t214 = t205*t213
      t216 = 0.3799574853701528D-1*t194*t214
      t218 = 1.D0+0.1274696188700087D0*t166
      t223 = 0.1112037486309468D2*t169+0.3844746237447211D1*t166
     #+0.1644733775567609D1*t172+0.2405871291288192D0*t174
      t226 = 1.D0+0.321646831778707D2/t223
      t227 = dlog(t226)
      t230 = -0.3109D-1*t218*t227+t182
      t231 = t230*t205
      t233 = 0.1923661050931536D1*t231*t211
      t240 = t164*(-t182+t216+t233)+0.3109D-1*t50*t62+0.3109D-1*t130
     #*t142
      t243 = 0.5D0*t10+0.5D0*t90
      t246 = 1.D0+0.3D-2*t10+0.3D-2*t90
      t247 = 1/t246
      t250 = t243**2
      t251 = t246**2
      t252 = 1/t251
      t255 = t250*t243
      t257 = 1/t251/t246
      t260 = t250**2
      t261 = t251**2
      t262 = 1/t261
      t265 = 0.729974D0+0.2011722D-1*t243*t247-0.415548D-3*t250*t252
     #+0.174649824D-5*t255*t257-0.580422672D-8*t260*t262
      zk(i) = -0.9305257363491D0*t5*t43-0.3109D-1*t50*t81
     #-0.9305257363491D0*t85*t123-0.3109D-1*t130*t161+t240*t265
      t269 = t6*rhoa
      t271 = 1/t7/t269
      t272 = sigmaaa*t271
      t275 = t17*t6
      t277 = 1/t4/t275
      t278 = t16*t277
      t282 = 1/t27/rhoa
      t283 = t26*t282
      t288 = 1/t7/t27/t269
      t289 = t34*t288
      t292 = t34*sigmaaa
      t295 = 1/t4/t27/t275
      t296 = t292*t295
      t298 = 1/t39/t12
      t301 = 0.7936597333333333D-2*t272*t13-0.5095447893333333D-3*t278
     #*t23+0.538536448D-5*t283*t31-0.2616712533333333D-7*t289*t40
     #+0.4908176725333333D-10*t296*t298
      t304 = t49*t62
      t307 = 1/t56
      t308 = t46*t307
      t311 = t58**2
      t312 = 1/t311
      t313 = t50*t312
      t314 = t51**2
      t315 = t314**2
      t316 = t315*t51
      t317 = 1/t316
      t318 = 1/t6
      t323 = 1/t54
      t326 = 1/t47
      t329 = -0.1853395810515781D1*t317*t318-0.128158207914907D1*t307
     #*t318-0.8223668877838045D0*t323*t318-0.1603914194192128D0*t326
     #*t318
      t330 = 1/t61
      t331 = t329*t330
      t332 = t331*t80
      t344 = 1/t76/t64
      t347 = 0.1805984D-1*t272*t65-0.9416746666666667D-3*t278*t69
     #+0.5082568533333333D-1*t283*t73-0.3679286613333333D-1*t289*t77
     #+0.5304183466666667D-2*t296*t344
      t348 = t62*t347
      t351 = 1/t174
      t352 = 1/t208
      t353 = t351*t352
      t354 = t353*t180
      t355 = 0.2747799777968419D-2*t354
      t356 = t176**2
      t357 = 1/t356
      t358 = t168*t357
      t359 = t169**2
      t360 = t359**2
      t361 = t360*t169
      t362 = 1/t361
      t363 = t362*t352
      t366 = 1/t172
      t367 = t366*t352
      t369 = 1/t166
      t370 = t369*t352
      t372 = -0.99709173929518D0*t363-0.7418564737168958D0*t353
     #-0.4002143174996817D0*t367-0.1264669550498372D0*t370
      t373 = 1/t179
      t375 = t358*t372*t373
      t376 = 0.1D1*t375
      t377 = t193*t205
      t378 = t377*t213
      t379 = t353*t378
      t380 = 0.8740794299481065D-3*t379
      t381 = t189**2
      t382 = 1/t381
      t383 = t184*t382
      t388 = -0.135956911724794D1*t363-0.7491972878592054D0*t353
     #-0.2150486235638321D0*t367-0.1274341730084892D0*t370
      t389 = t383*t388
      t390 = 1/t192
      t391 = t390*t205
      t392 = t391*t213
      t393 = t389*t392
      t394 = 0.1124999956683108D1*t393
      t395 = t196*t352
      t396 = 1.D0*t395
      t397 = t165-t396
      t400 = 1.D0*t165
      t401 = -t400+t395
      t404 = 0.1333333333333333D1*t199*t397+0.1333333333333333D1*t203
     #*t401
      t406 = t194*t404*t213
      t407 = 0.3799574853701528D-1*t406
      t408 = t206*t196
      t409 = t408*t210
      t410 = 4.D0*t409
      t412 = 1/t209/t164
      t413 = t207*t412
      t414 = 4.D0*t413
      t415 = -t410+t414
      t417 = t194*t205*t415
      t418 = 0.3799574853701528D-1*t417
      t421 = t223**2
      t422 = 1/t421
      t423 = t218*t422
      t428 = -0.1853395810515781D1*t363-0.128158207914907D1*t353
     #-0.8223668877838045D0*t367-0.1603914194192128D0*t370
      t429 = 1/t226
      t435 = 0.1321010150222857D-2*t353*t227+0.1D1*t423*t428*t429
     #-0.2747799777968419D-2*t354-0.1D1*t375
      t436 = t435*t205
      t437 = t436*t211
      t438 = 0.1923661050931536D1*t437
      t439 = t230*t404
      t440 = t439*t211
      t441 = 0.1923661050931536D1*t440
      t442 = t231*t409
      t444 = t231*t413
      t445 = 0.7694644203726145D1*t444
      t452 = t312*t329*t330
      t455 = -t182+t216+t233+t164*(t355+t376-t380-t394+t407+t418+t438
     #+t441+0.7694644203726145D1*t442-t445)+0.3109D-1*t304
     #-0.1321010150222857D-2*t308*t62-0.1D1*t50*t452
      t459 = t243*t252
      t462 = t250*t257
      t465 = t255*t262
      t469 = 1/t261/t246
      t470 = t260*t469
      t473 = -0.2682296D-1*t272*t247+0.126906576D-2*t459*t272
     #-0.1363476096D-4*t462*t272+0.728718336D-7*t465*t272
     #-0.18573525504D-9*t470*t272
      vrhoa(i) = -0.12407009817988D1*t4*t43-0.9305257363491D0*t5*t301
     #-0.3109D-1*t304*t80+0.1321010150222857D-2*t308*t81+0.1D1*t313
     #*t332-0.3109D-1*t50*t348+t455*t265+t240*t473
      t477 = t86*rhob
      t479 = 1/t87/t477
      t480 = sigmabb*t479
      t483 = t97*t86
      t485 = 1/t84/t483
      t486 = t96*t485
      t490 = 1/t107/rhob
      t491 = t106*t490
      t496 = 1/t87/t107/t477
      t497 = t114*t496
      t500 = t114*sigmabb
      t503 = 1/t84/t107/t483
      t504 = t500*t503
      t506 = 1/t119/t92
      t509 = 0.7936597333333333D-2*t480*t93-0.5095447893333333D-3*t486
     #*t103+0.538536448D-5*t491*t111-0.2616712533333333D-7*t497*t120
     #+0.4908176725333333D-10*t504*t506
      t512 = t129*t142
      t515 = 1/t136
      t516 = t126*t515
      t519 = t138**2
      t520 = 1/t519
      t521 = t130*t520
      t522 = t131**2
      t523 = t522**2
      t524 = t523*t131
      t525 = 1/t524
      t526 = 1/t86
      t531 = 1/t134
      t534 = 1/t127
      t537 = -0.1853395810515781D1*t525*t526-0.128158207914907D1*t515
     #*t526-0.8223668877838045D0*t531*t526-0.1603914194192128D0*t534
     #*t526
      t538 = 1/t141
      t539 = t537*t538
      t540 = t539*t160
      t552 = 1/t156/t144
      t555 = 0.1805984D-1*t480*t145-0.9416746666666667D-3*t486*t149
     #+0.5082568533333333D-1*t491*t153-0.3679286613333333D-1*t497*t157
     #+0.5304183466666667D-2*t504*t552
      t556 = t142*t555
      t559 = -t400-t396
      t562 = t165+t395
      t565 = 0.1333333333333333D1*t199*t559+0.1333333333333333D1*t203
     #*t562
      t567 = t194*t565*t213
      t568 = 0.3799574853701528D-1*t567
      t569 = t410+t414
      t571 = t194*t205*t569
      t572 = 0.3799574853701528D-1*t571
      t573 = t230*t565
      t574 = t573*t211
      t575 = 0.1923661050931536D1*t574
      t583 = t520*t537*t538
      t586 = -t182+t216+t233+t164*(t355+t376-t380-t394+t568+t572+t438
     #+t575-0.7694644203726145D1*t442-t445)+0.3109D-1*t512
     #-0.1321010150222857D-2*t516*t142-0.1D1*t130*t583
      t598 = -0.2682296D-1*t480*t247+0.126906576D-2*t459*t480
     #-0.1363476096D-4*t462*t480+0.728718336D-7*t465*t480
     #-0.18573525504D-9*t470*t480
      vrhob(i) = -0.12407009817988D1*t84*t123-0.9305257363491D0*t85
     #*t509-0.3109D-1*t512*t160+0.1321010150222857D-2*t516*t161+0.1D1
     #*t521*t540-0.3109D-1*t130*t556+t586*t265+t240*t598
      t602 = sigmaaa*t20
      t605 = t16*t28
      t608 = t26*t37
      t613 = 1/t4/t27/t18
      t614 = t34*t613
      t617 = -0.2976224D-2*t9*t13+0.191079296D-3*t602*t23
     #-0.201951168D-5*t605*t31+0.9812672D-8*t608*t40-0.1840566272D-10
     #*t614*t298
      t630 = -0.677244D-2*t9*t65+0.353128D-3*t602*t69-0.19059632D-1
     #*t605*t73+0.137973248D-1*t608*t77-0.19890688D-2*t614*t344
      t631 = t62*t630
      t644 = 0.1005861D-1*t9*t247-0.47589966D-3*t459*t9+0.511303536D-5
     #*t462*t9-0.273269376D-7*t465*t9+0.6965072064D-10*t470*t9
      vsigmaaa(i) = -0.9305257363491D0*t5*t617-0.3109D-1*t50*t631+t240
     #*t644
      vsigmaab(i) = 0.D0
      t648 = sigmabb*t100
      t651 = t96*t108
      t654 = t106*t117
      t659 = 1/t84/t107/t98
      t660 = t114*t659
      t663 = -0.2976224D-2*t89*t93+0.191079296D-3*t648*t103
     #-0.201951168D-5*t651*t111+0.9812672D-8*t654*t120
     #-0.1840566272D-10*t660*t506
      t676 = -0.677244D-2*t89*t145+0.353128D-3*t648*t149-0.19059632D-1
     #*t651*t153+0.137973248D-1*t654*t157-0.19890688D-2*t660*t552
      t677 = t142*t676
      t690 = 0.1005861D-1*t89*t247-0.47589966D-3*t459*t89
     #+0.511303536D-5*t462*t89-0.273269376D-7*t465*t89
     #+0.6965072064D-10*t470*t89
      vsigmabb(i) = -0.9305257363491D0*t85*t663-0.3109D-1*t130*t677
     #+t240*t690
      t694 = sigmaaa/t7/t17
      t697 = t17*t269
      t700 = t16/t4/t697
      t704 = t26/t35
      t710 = t34/t7/t27/t17
      t716 = t292/t4/t27/t697
      t720 = t27**2
      t723 = t34*t16/t720/t6
      t725 = 1/t39/t22
      t736 = 0.2D1*t375
      t739 = 0.1538928840745229D2*t444
      t740 = 0.3847322101863073D1*t437
      t741 = 0.1748158859896213D-2*t379
      t742 = 0.2249999913366216D1*t393
      t744 = 0.5495599555936838D-2*t354
      t751 = 1/t361/t165*t210
      t754 = 1/t208/t164
      t755 = t362*t754
      t759 = 1/t174/t165*t210
      t761 = t351*t754
      t765 = 1/t172/t165*t210
      t767 = t366*t754
      t771 = 1/t166/t165*t210
      t773 = t369*t754
      t777 = t358*(-0.8309097827459833D0*t751+0.199418347859036D1*t755
     #-0.4945709824779306D0*t759+0.1483712947433792D1*t761
     #-0.2001071587498409D0*t765+0.8004286349993634D0*t767
     #-0.4215565168327908D-1*t771+0.2529339100996745D0*t773)*t373
      t778 = 0.1D1*t777
      t782 = t372**2
      t784 = t168/t356/t176*t782*t373
      t785 = 0.2D1*t784
      t787 = 0.1748158859896213D-2*t761*t378
      t788 = t759*t180
      t789 = 0.1831866518645613D-2*t788
      t790 = t761*t180
      t791 = 0.5495599555936838D-2*t790
      t794 = t353*t357*t372*t373
      t795 = 0.8837926660346786D-1*t794
      t796 = t356**2
      t799 = t179**2
      t802 = t168/t796*t782/t799
      t803 = 0.160818243221511D2*t802
      t815 = t428**2
      t831 = t421**2
      t834 = t226**2
      t845 = 0.8806734334819047D-3*t759*t227-0.2642020300445714D-2
     #*t761*t227-0.8497974591333914D-1*t353*t422*t428*t429-0.2D1*t218
     #/t421/t223*t815*t429+0.1D1*t423*(-0.1544496508763151D1*t751
     #+0.3706791621031562D1*t755-0.854388052766047D0*t759
     #+0.2563164158298141D1*t761-0.4111834438919023D0*t765
     #+0.1644733775567609D1*t767-0.5346380647307093D-1*t771
     #+0.3207828388384256D0*t773)*t429+0.321646831778707D2*t218/t831
     #*t815/t834-0.1831866518645613D-2*t788+0.5495599555936838D-2*t790
     #+0.8837926660346786D-1*t794+0.2D1*t784-0.1D1*t777
     #-0.160818243221511D2*t802
      t848 = 0.1923661050931536D1*t845*t205*t211
      t849 = t199**2
      t850 = 1/t849
      t851 = t397**2
      t854 = 2.D0*t352
      t856 = 2.D0*t196*t754
      t857 = -t854+t856
      t860 = t203**2
      t861 = 1/t860
      t862 = t401**2
      t868 = 0.4444444444444444D0*t850*t851+0.1333333333333333D1*t199
     #*t857+0.4444444444444444D0*t861*t862-0.1333333333333333D1*t203
     #*t857
      t872 = t381**2
      t875 = t388**2
      t877 = t192**2
      t882 = 0.3330964519106732D2*t184/t872*t875/t877*t205*t213
      t884 = t389*t391*t415
      t888 = t389*t390*t404*t213
      t895 = 0.2249999913366216D1*t184/t381/t189*t875*t392
      t896 = 0.7599149707403056D-1*t194*t404*t415+t778-t785+t787+t789
     #-t791-t795+t803+t848+0.3799574853701528D-1*t194*t868*t213-t882
     #-0.2249999913366216D1*t884-0.2249999913366216D1*t888+t895
      t908 = 0.1124999956683108D1*t383*(-0.1132974264373283D1*t751
     #+0.271913823449588D1*t755-0.4994648585728036D0*t759
     #+0.1498394575718411D1*t761-0.1075243117819161D0*t765
     #+0.4300972471276643D0*t767-0.4247805766949639D-1*t771
     #+0.2548683460169784D0*t773)*t392
      t910 = 0.5827196199654043D-3*t759*t378
      t913 = t353*t193*t404*t213
      t916 = t353*t377*t415
      t922 = 0.5176049209143758D-1*t353*t382*t388*t390*t214
      t923 = t436*t409
      t926 = 0.1538928840745229D2*t436*t413
      t928 = t435*t404*t211
      t930 = t206*t210
      t931 = t231*t930
      t932 = 0.2308393261117844D2*t931
      t933 = t408*t412
      t934 = t231*t933
      t936 = 12.D0*t930
      t937 = 32.D0*t933
      t940 = t207/t209/t208
      t941 = 20.D0*t940
      t946 = t439*t413
      t948 = t439*t409
      t954 = 0.3847322101863073D2*t231*t940
      t955 = -t908-t910-0.1748158859896213D-2*t913
     #-0.1748158859896213D-2*t916+t922+0.1538928840745229D2*t923-t926
     #+0.3847322101863073D1*t928+t932-0.6155715362980916D2*t934
     #+0.3799574853701528D-1*t194*t205*(-t936+t937-t941)
     #-0.1538928840745229D2*t946+0.1538928840745229D2*t948
     #+0.1923661050931536D1*t230*t868*t211+t954
      t960 = 1/t17
      t963 = 1/t269
      t967 = 1/t56/t46
      t984 = -0.1544496508763151D1/t316/t46*t960+0.3706791621031562D1
     #*t317*t963-0.854388052766047D0*t967*t960+0.2563164158298141D1
     #*t307*t963-0.4111834438919023D0/t54/t46*t960
     #+0.1644733775567609D1*t323*t963-0.5346380647307093D-1/t47/t46
     #*t960+0.3207828388384256D0*t326*t963
      t990 = 1/t311/t58
      t991 = t329**2
      t996 = t963*t967
      t1001 = t49*t312
      t1004 = t311**2
      t1005 = 1/t1004
      t1007 = t61**2
      t1008 = 1/t1007
      t1012 = t736+0.3847322101863073D1*t440+0.1538928840745229D2*t442
     #-t739+t740-t741-t742+0.7599149707403056D-1*t406+t744
     #+0.7599149707403056D-1*t417+t164*(t896+t955)-0.1D1*t50*t312*t984
     #*t330+0.2D1*t50*t990*t991*t330-0.8806734334819047D-3*t996*t62
     #+0.8497974591333914D-1*t308*t452-0.2D1*t1001*t331
     #-0.321646831778707D2*t50*t1005*t991*t1008
      t1031 = 1/t76/t68
      t1066 = t243*t257
      t1071 = t250*t262
      t1076 = t255*t469
      t1083 = t260/t261/t251
      s1 = -0.9305257363491D0*t5*(-0.2910085688888889D-1*t694*t13
     #+0.3311774037333333D-2*t700*t23-0.5933856915911111D-4*t704*t31
     #+0.4776147922488889D-6*t710*t40-0.1819969344853333D-8*t716*t298
     #+0.2617694253511111D-11*t723*t725)-0.4135669939329333D0/t7*t43
     #-0.24814019635976D1*t4*t301+t1012*t265+0.2642020300445714D-2
     #*t308*t348+0.2D1*t1001*t332-0.6218D-1*t304*t347-0.3109D-1*t50
     #*t62*(-0.6621941333333333D-1*t694*t65+0.1559585422222222D-1*t700
     #*t69-0.4584356209777778D0*t704*t73+0.5105712014222222D0*t710*t77
     #-0.15451807744D0*t716*t344+0.1414448924444444D-1*t723*t1031)
      v2rhoa2(i) = s1+0.1D1*t313*t984*t330*t80-0.2D1*t50*t990*t991
     #*t330*t80-0.8497974591333914D-1*t308*t312*t332
     #+0.8806734334819047D-3*t996*t81+0.321646831778707D2*t50*t1005
     #*t991*t1008*t80+0.2D1*t313*t331*t347+2.D0*t455*t473+t240*
     #(0.9835085333333333D-1*t694*t247-0.190667136D-2*t700*t252
     #+0.5666441472D-4*t1066*t700-0.465324112D-2*t459*t694
     #-0.61872159744D-6*t1071*t700+0.4999412352D-4*t462*t694
     #+0.332248670208D-8*t1076*t700-0.2671967232D-6*t465*t694
     #-0.74294102016D-11*t1083*t700+0.68102926848D-9*t470*t694)
      t1092 = sigmabb/t87/t97
      t1095 = t97*t477
      t1098 = t96/t84/t1095
      t1102 = t106/t115
      t1108 = t114/t87/t107/t97
      t1114 = t500/t84/t107/t1095
      t1118 = t107**2
      t1121 = t114*t96/t1118/t86
      t1123 = 1/t119/t102
      t1134 = t519**2
      t1135 = 1/t1134
      t1137 = t537**2
      t1138 = t141**2
      t1139 = 1/t1138
      t1146 = 1/t97
      t1149 = 1/t477
      t1153 = 1/t136/t126
      t1170 = -0.1544496508763151D1/t524/t126*t1146
     #+0.3706791621031562D1*t525*t1149-0.854388052766047D0*t1153*t1146
     #+0.2563164158298141D1*t515*t1149-0.4111834438919023D0/t134/t126
     #*t1146+0.1644733775567609D1*t531*t1149-0.5346380647307093D-1
     #/t127/t126*t1146+0.3207828388384256D0*t534*t1149
      t1176 = 1/t519/t138
      t1184 = t1149*t1153
      t1190 = t129*t520
      t1206 = t559**2
      t1209 = t854+t856
      t1212 = t562**2
      t1218 = 0.4444444444444444D0*t850*t1206+0.1333333333333333D1
     #*t199*t1209+0.4444444444444444D0*t861*t1212-0.1333333333333333D1
     #*t203*t1209
      t1227 = t353*t193*t565*t213
      t1230 = t353*t377*t569
      t1232 = t573*t409
      t1234 = t573*t413
      t1240 = t435*t565*t211
      t1242 = 0.3799574853701528D-1*t194*t205*(-t936-t937-t941)
     #+0.3799574853701528D-1*t194*t1218*t213+0.7599149707403056D-1
     #*t194*t565*t569-0.1748158859896213D-2*t1227
     #-0.1748158859896213D-2*t1230-0.1538928840745229D2*t1232
     #-0.1538928840745229D2*t1234+0.1923661050931536D1*t230*t1218*t211
     #+0.3847322101863073D1*t1240+t778-t785+t787+t789-t791
      t1245 = t389*t390*t565*t213
      t1248 = t389*t391*t569
      t1252 = -t795+t803+t848-0.2249999913366216D1*t1245-t882+t895
     #-t908-t910-0.2249999913366216D1*t1248+t922-0.1538928840745229D2
     #*t923-t926+t932+0.6155715362980916D2*t934+t954
      t1273 = t736-0.1538928840745229D2*t442-t739+t740-t741-t742+t744
     #+0.3847322101863073D1*t574+0.7599149707403056D-1*t571
     #+0.7599149707403056D-1*t567+t164*(t1242+t1252)-0.2D1*t1190*t539
     #-0.321646831778707D2*t130*t1135*t1137*t1139-0.1D1*t130*t520
     #*t1170*t538+0.2D1*t130*t1176*t1137*t538-0.8806734334819047D-3
     #*t1184*t142+0.8497974591333914D-1*t516*t583
      t1286 = 1/t156/t148
      s1 = -0.9305257363491D0*t85*(-0.2910085688888889D-1*t1092*t93
     #+0.3311774037333333D-2*t1098*t103-0.5933856915911111D-4*t1102
     #*t111+0.4776147922488889D-6*t1108*t120-0.1819969344853333D-8
     #*t1114*t506+0.2617694253511111D-11*t1121*t1123)
     #-0.4135669939329333D0/t87*t123-0.24814019635976D1*t84*t509
     #+0.321646831778707D2*t130*t1135*t1137*t1139*t160+0.1D1*t521
     #*t1170*t538*t160-0.2D1*t130*t1176*t1137*t538*t160
     #+0.2642020300445714D-2*t516*t556+0.8806734334819047D-3*t1184*t161
      v2rhob2(i) = s1-0.8497974591333914D-1*t516*t520*t540+0.2D1*t1190
     #*t540+0.2D1*t521*t539*t555-0.6218D-1*t512*t555+t1273*t265
     #-0.3109D-1*t130*t142*(-0.6621941333333333D-1*t1092*t145
     #+0.1559585422222222D-1*t1098*t149-0.4584356209777778D0*t1102
     #*t153+0.5105712014222222D0*t1108*t157-0.15451807744D0*t1114*t552
     #+0.1414448924444444D-1*t1121*t1286)+t240*(0.9835085333333333D-1
     #*t1092*t247-0.190667136D-2*t1098*t252+0.5666441472D-4*t1066
     #*t1098-0.465324112D-2*t459*t1092-0.61872159744D-6*t1071*t1098
     #+0.4999412352D-4*t462*t1092+0.332248670208D-8*t1076*t1098
     #-0.2671967232D-6*t465*t1092-0.74294102016D-11*t1083*t1098
     #+0.68102926848D-9*t470*t1092)+2.D0*t586*t598
      t1325 = -0.8740794299481065D-3*t1227-0.8740794299481065D-3*t1230
     #+0.7694644203726145D1*t1232-0.7694644203726145D1*t1234
     #+0.1923661050931536D1*t1240+t778-t785+t787+t789-t791-t795+t803
     #+t848-0.1124999956683108D1*t1245-t882-0.1124999956683108D1*t884
     #-0.1124999956683108D1*t888
      t1355 = 0.4444444444444444D0*t850*t397*t559+0.2666666666666667D1
     #*t199*t196*t754+0.4444444444444444D0*t861*t401*t562
     #-0.2666666666666667D1*t203*t196*t754
      t1362 = t895-t908-t910-0.1124999956683108D1*t1248
     #-0.8740794299481065D-3*t913-0.8740794299481065D-3*t916+t922-t926
     #+0.1923661050931536D1*t928-0.2308393261117844D2*t931
     #-0.7694644203726145D1*t946-0.7694644203726145D1*t948+t954
     #+0.3799574853701528D-1*t194*t404*t569+0.3799574853701528D-1*t194
     #*t205*(t936-t941)+0.3799574853701528D-1*t194*t565*t415
     #+0.3799574853701528D-1*t194*t1355*t213+0.1923661050931536D1*t230
     #*t1355*t211
      t1365 = t744+t736-t741-t742+t568+t572+t740+t575-t739+t407+t418
     #+t441+t164*(t1325+t1362)
      t1378 = t271*sigmabb*t479
      v2rhoab(i) = 0.1D1*t1365*t265+0.1D1*t455*t598+0.1D1*t586*t473
     #+0.1D1*t240*(-0.190667136D-2*t272*t252*sigmabb*t479
     #+0.5666441472D-4*t1066*sigmaaa*t1378-0.61872159744D-6*t1071
     #*sigmaaa*t1378+0.332248670208D-8*t1076*sigmaaa*t1378
     #-0.74294102016D-11*t1083*sigmaaa*t1378)
      t1397 = sigmaaa*t277
      t1400 = t16*t282
      t1403 = t26*t288
      t1406 = t34*t295
      t1411 = t292/t720/rhoa
      s1 = -0.12407009817988D1*t4*t617-0.9305257363491D0*t5*
     #(0.7936597333333333D-2*t271*t13-0.1050835968D-2*t1397*t23
     #+0.2023245175466667D-4*t1400*t31-0.1692928750933333D-6*t1403*t40
     #+0.6640828416D-9*t1406*t298-0.9816353450666667D-12*t1411*t725)
     #-0.3109D-1*t304*t630+0.1321010150222857D-2*t308*t631
      v2rhoasigmaaa(i) = s1+0.1D1*t313*t331*t630-0.3109D-1*t50*t62*
     #(0.1805984D-1*t271*t65-0.5495317333333333D-2*t1397*t69
     #+0.1528537258666667D0*t1400*t73-0.1776668757333333D0*t1403*t77
     #+0.5595521024D-1*t1406*t344-0.5304183466666667D-2*t1411*t1031)
     #+t455*t644+t240*(-0.2682296D-1*t271*t247+0.71500176D-3*t1397
     #*t252-0.2124915552D-4*t1066*t1397+0.126906576D-2*t459*t271
     #+0.23202059904D-6*t1071*t1397-0.1363476096D-4*t462*t271
     #-0.124593251328D-8*t1076*t1397+0.728718336D-7*t465*t271
     #+0.27860288256D-11*t1083*t1397-0.18573525504D-9*t470*t271)
      v2rhoasigmaab(i) = 0.D0
      t1467 = t272*t89
      v2rhoasigmabb(i) = t455*t690+t240*(0.71500176D-3*t272*t252*t89
     #-0.2124915552D-4*t1066*t1467+0.23202059904D-6*t1071*t1467
     #-0.124593251328D-8*t1076*t1467+0.27860288256D-11*t1083*t1467)
      t1479 = t252*t9
      t1482 = t480*t9
      v2rhobsigmaaa(i) = t586*t644+t240*(0.71500176D-3*t480*t1479
     #-0.2124915552D-4*t1066*t1482+0.23202059904D-6*t1071*t1482
     #-0.124593251328D-8*t1076*t1482+0.27860288256D-11*t1083*t1482)
      v2rhobsigmaab(i) = 0.D0
      t1497 = sigmabb*t485
      t1500 = t96*t490
      t1503 = t106*t496
      t1506 = t114*t503
      t1511 = t500/t1118/rhob
      s1 = -0.12407009817988D1*t84*t663-0.9305257363491D0*t85*
     #(0.7936597333333333D-2*t479*t93-0.1050835968D-2*t1497*t103
     #+0.2023245175466667D-4*t1500*t111-0.1692928750933333D-6*t1503
     #*t120+0.6640828416D-9*t1506*t506-0.9816353450666667D-12*t1511
     #*t1123)-0.3109D-1*t512*t676+0.1321010150222857D-2*t516*t677
      v2rhobsigmabb(i) = s1+0.1D1*t521*t539*t676-0.3109D-1*t130*t142*
     #(0.1805984D-1*t479*t145-0.5495317333333333D-2*t1497*t149
     #+0.1528537258666667D0*t1500*t153-0.1776668757333333D0*t1503*t157
     #+0.5595521024D-1*t1506*t552-0.5304183466666667D-2*t1511*t1286)
     #+t586*t690+t240*(-0.2682296D-1*t479*t247+0.71500176D-3*t1497
     #*t252-0.2124915552D-4*t1066*t1497+0.126906576D-2*t459*t479
     #+0.23202059904D-6*t1071*t1497-0.1363476096D-4*t462*t479
     #-0.124593251328D-8*t1076*t1497+0.728718336D-7*t465*t479
     #+0.27860288256D-11*t1083*t1497-0.18573525504D-9*t470*t479)
      t1565 = sigmaaa*t28
      t1568 = t16*t37
      t1571 = t26*t613
      t1575 = t34/t720
      v2sigmaaa2(i) = -0.9305257363491D0*t5*(0.202984192D-3*t20*t23
     #-0.5567657728D-5*t1565*t31+0.5367215616D-7*t1568*t40
     #-0.23062540288D-9*t1571*t298+0.3681132544D-12*t1575*t725)
     #-0.3109D-1*t50*t62*(0.1707616D-2*t20*t69-0.382605152D-1*t1565
     #*t73+0.528277536D-1*t1568*t77-0.1899413504D-1*t1571*t344
     #+0.19890688D-2*t1575*t1031)+t240*(-0.26812566D-3*t20*t252
     #+0.796843332D-5*t1066*t20-0.8700772464D-7*t1071*t20
     #+0.46722469248D-9*t1076*t20-0.10447608096D-11*t1083*t20)
      v2sigmaaaab(i) = 0.D0
      t1609 = t9*t89
      v2sigmaaabb(i) = t240*(-0.26812566D-3*t1479*t89+0.796843332D-5
     #*t1066*t1609-0.8700772464D-7*t1071*t1609+0.46722469248D-9*t1076
     #*t1609-0.10447608096D-11*t1083*t1609)
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t1621 = sigmabb*t108
      t1624 = t96*t117
      t1627 = t106*t659
      t1631 = t114/t1118
      v2sigmabb2(i) = -0.9305257363491D0*t85*(0.202984192D-3*t100*t103
     #-0.5567657728D-5*t1621*t111+0.5367215616D-7*t1624*t120
     #-0.23062540288D-9*t1627*t506+0.3681132544D-12*t1631*t1123)
     #-0.3109D-1*t130*t142*(0.1707616D-2*t100*t149-0.382605152D-1
     #*t1621*t153+0.528277536D-1*t1624*t157-0.1899413504D-1*t1627*t552
     #+0.19890688D-2*t1631*t1286)+t240*(-0.26812566D-3*t100*t252
     #+0.796843332D-5*t1066*t100-0.8700772464D-7*t1071*t100
     #+0.46722469248D-9*t1076*t100-0.10447608096D-11*t1083*t100)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_xc_hcth
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     F.A. Hamprecht, A.J. Cohen, D.J. Tozer, and N.C. Handy
c     Development and assessment of new exchange-correlation functionals
c     J. Chem. Phys. 109 (1998) 6264-6271
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t4 = rho**2
      t5 = t2**2
      t8 = sigma/t5/t4
      t10 = 1.D0+0.6349604207872798D-2*t8
      t14 = sigma**2
      t15 = t4**2
      t19 = t14/t2/t15/rho
      t20 = t10**2
      t25 = t15**2
      t27 = t14*sigma/t25
      t32 = t14**2
      t36 = t32/t5/t25/t4
      t37 = t20**2
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t48 = rho*(1.D0+0.1606016560364007D0*t45)
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t60 = dlog(1.D0+0.321646831778707D2/(0.1248219874679732D2*t49
     #+0.4844076716063854D1*t45+0.2326004811900819D1*t52
     #+0.3819082618690966D0*t54))
      t62 = 1.D0+0.3174802103936399D0*t8
      t66 = t62**2
      t74 = t66**2
      t93 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t49
     #+0.2225569421150687D1*t45+0.8004286349993634D0*t52
     #+0.1897004325747559D0*t54))
      t100 = 1.D0+0.9524406311809197D-2*t8
      t104 = t100**2
      t112 = t104**2
      zk(i) = -0.7385587663820224D0*t2*rho*(0.10932D1
     #-0.4724461108493003D-2*t8/t10+0.225745598162284D-3*t19/t20
     #-0.173708544D-5*t27/t20/t10+0.7304292090974968D-8*t36/t37)
     #-0.3109D-1*t48*t60*(0.222601D0-0.1075057838039151D-1*t8/t62
     #-0.126163454252273D-2*t19/t66-0.25679872D-1*t27/t66/t62
     #+0.1578724952778562D-1*t36/t74)+(-0.62182D-1*rho*(1.D0
     #+0.1325688999052018D0*t45)*t93+0.3109D-1*t48*t60)*(0.729974D0
     #+0.319340961906757D-1*t8/t100-0.104711534488343D-2*t19/t104
     #+0.698599296D-5*t27/t104/t100-0.3685454240475973D-7*t36/t112)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigma*t7
      t10 = 1.D0+0.6349604207872798D-2*t8
      t11 = 1/t10
      t14 = sigma**2
      t15 = t4**2
      t16 = t15*rho
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigma
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t35 = 1/t5/t25/t4
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.10932D1-0.4724461108493003D-2*t8*t11
     #+0.225745598162284D-3*t19*t21-0.173708544D-5*t27*t29
     #+0.7304292090974968D-8*t36*t38
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1606016560364007D0*t45
      t48 = rho*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1248219874679732D2*t49+0.4844076716063854D1*t45
     #+0.2326004811900819D1*t52+0.3819082618690966D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.3174802103936399D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.222601D0-0.1075057838039151D-1*t8*t63
     #-0.126163454252273D-2*t19*t67-0.25679872D-1*t27*t71
     #+0.1578724952778562D-1*t36*t75
      t79 = t60*t78
      t83 = 1.D0+0.1325688999052018D0*t45
      t89 = 0.598255043577108D1*t49+0.2225569421150687D1*t45
     #+0.8004286349993634D0*t52+0.1897004325747559D0*t54
      t92 = 1.D0+0.160818243221511D2/t89
      t93 = dlog(t92)
      t98 = -0.62182D-1*rho*t83*t93+0.3109D-1*t48*t60
      t100 = 1.D0+0.9524406311809197D-2*t8
      t101 = 1/t100
      t104 = t100**2
      t105 = 1/t104
      t109 = 1/t104/t100
      t112 = t104**2
      t113 = 1/t112
      t116 = 0.729974D0+0.319340961906757D-1*t8*t101
     #-0.104711534488343D-2*t19*t105+0.698599296D-5*t27*t109
     #-0.3685454240475973D-7*t36*t113
      zk(i) = -0.7385587663820224D0*t3*t41-0.3109D-1*t48*t79+t98*t116
      t120 = t4*rho
      t123 = sigma/t5/t120
      t126 = t15*t4
      t129 = t14/t2/t126
      t134 = t24/t25/rho
      t140 = t32/t5/t25/t120
      t147 = t32*sigma/t2/t25/t126
      t149 = 1/t37/t10
      t155 = t47*t60
      t158 = 1/t54
      t159 = t44*t158
      t162 = t56**2
      t163 = 1/t162
      t165 = t49**2
      t166 = t165**2
      t169 = 1/t4
      t170 = 1/t166/t49*t169
      t172 = t158*t169
      t175 = 1/t52*t169
      t178 = 1/t45*t169
      t180 = -0.4160732915599108D1*t170-0.3229384477375903D1*t172
     #-0.2326004811900819D1*t175-0.5092110158254621D0*t178
      t181 = 1/t59
      t195 = 1/t74/t62
      t206 = t89**2
      t238 = 1/t112/t100
      s1 = -0.9847450218426965D0*t2*t41-0.3692793831910112D0*t3*
     #(0.2519712591196268D-1*t123*t11-0.2567944823781261D-2*t129*t21
     #+0.4308291584D-4*t134*t29-0.3323017782489364D-6*t140*t38
     #+0.9894264276562486D-9*t147*t149)-0.3109D-1*t155*t78
     #+0.1664368495390566D-2*t159*t79
      vrhoa(i) = s1+0.5D0*t48*t163*t180*t181*t78-0.15545D-1*t48*t60*
     #(0.5733641802875474D-1*t123*t63-0.4745742938744286D-2*t129*t67
     #+0.4066054826666667D0*t134*t71-0.4672402752398278D0*t140*t75
     #+0.1069256384345231D0*t147*t195)+(-0.62182D-1*t83*t93+rho*
     #(0.2747799777968419D-2*t172*t93+0.1D1*t83/t206*(
     #-0.99709173929518D0*t170-0.7418564737168958D0*t172
     #-0.4002143174996817D0*t175-0.1264669550498372D0*t178)/t92)
     #+0.3109D-1*t155-0.1664368495390566D-2*t159*t60-0.5D0*t48*t163
     #*t180*t181)*t116+t98*(-0.8515758984180187D-1*t123*t101
     #+0.6395690658899341D-2*t129*t105-0.10907808768D-3*t134*t109
     #+0.9254146025239327D-6*t140*t113-0.3744188120519821D-8*t147*t238)
      t245 = sigma*t18
      t248 = t14*t26
      t251 = t24*t35
      t257 = t32/t2/t25/t16
      vsigmaaa(i) = -0.7385587663820224D0*t3*(-0.1889784443397201D-1
     #*t7*t11+0.1925958617835946D-2*t245*t21-0.3231218688D-4*t248*t29
     #+0.2492263336867023D-6*t251*t38-0.7420698207421865D-9*t257*t149)
     #-0.3109D-1*t48*t60*(-0.4300231352156605D-1*t7*t63
     #+0.3559307204058214D-2*t245*t67-0.304954112D0*t248*t71
     #+0.3504302064298708D0*t251*t75-0.8019422882589234D-1*t257*t195)
     #+2.D0*t98*(0.638681923813514D-1*t7*t101-0.4796767994174505D-2
     #*t245*t105+0.8180856576D-4*t248*t109-0.6940609518929495D-6*t251
     #*t113+0.2808141090389866D-8*t257*t238)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = rho**2
      t5 = t2**2
      t7 = 1/t5/t4
      t8 = sigma*t7
      t10 = 1.D0+0.6349604207872798D-2*t8
      t11 = 1/t10
      t14 = sigma**2
      t15 = t4**2
      t16 = t15*rho
      t18 = 1/t2/t16
      t19 = t14*t18
      t20 = t10**2
      t21 = 1/t20
      t24 = t14*sigma
      t25 = t15**2
      t26 = 1/t25
      t27 = t24*t26
      t29 = 1/t20/t10
      t32 = t14**2
      t33 = t25*t4
      t35 = 1/t5/t33
      t36 = t32*t35
      t37 = t20**2
      t38 = 1/t37
      t41 = 0.10932D1-0.4724461108493003D-2*t8*t11
     #+0.225745598162284D-3*t19*t21-0.173708544D-5*t27*t29
     #+0.7304292090974968D-8*t36*t38
      t44 = 1/rho
      t45 = t44**(1.D0/3.D0)
      t47 = 1.D0+0.1606016560364007D0*t45
      t48 = rho*t47
      t49 = t44**(1.D0/6.D0)
      t52 = dsqrt(t44)
      t54 = t45**2
      t56 = 0.1248219874679732D2*t49+0.4844076716063854D1*t45
     #+0.2326004811900819D1*t52+0.3819082618690966D0*t54
      t59 = 1.D0+0.321646831778707D2/t56
      t60 = dlog(t59)
      t62 = 1.D0+0.3174802103936399D0*t8
      t63 = 1/t62
      t66 = t62**2
      t67 = 1/t66
      t71 = 1/t66/t62
      t74 = t66**2
      t75 = 1/t74
      t78 = 0.222601D0-0.1075057838039151D-1*t8*t63
     #-0.126163454252273D-2*t19*t67-0.25679872D-1*t27*t71
     #+0.1578724952778562D-1*t36*t75
      t79 = t60*t78
      t83 = 1.D0+0.1325688999052018D0*t45
      t89 = 0.598255043577108D1*t49+0.2225569421150687D1*t45
     #+0.8004286349993634D0*t52+0.1897004325747559D0*t54
      t92 = 1.D0+0.160818243221511D2/t89
      t93 = dlog(t92)
      t98 = -0.62182D-1*rho*t83*t93+0.3109D-1*t48*t60
      t100 = 1.D0+0.9524406311809197D-2*t8
      t101 = 1/t100
      t104 = t100**2
      t105 = 1/t104
      t109 = 1/t104/t100
      t112 = t104**2
      t113 = 1/t112
      t116 = 0.729974D0+0.319340961906757D-1*t8*t101
     #-0.104711534488343D-2*t19*t105+0.698599296D-5*t27*t109
     #-0.3685454240475973D-7*t36*t113
      zk(i) = -0.7385587663820224D0*t3*t41-0.3109D-1*t48*t79+t98*t116
      t120 = t4*rho
      t122 = 1/t5/t120
      t123 = sigma*t122
      t126 = t15*t4
      t128 = 1/t2/t126
      t129 = t14*t128
      t133 = 1/t25/rho
      t134 = t24*t133
      t139 = 1/t5/t25/t120
      t140 = t32*t139
      t143 = t32*sigma
      t146 = 1/t2/t25/t126
      t147 = t143*t146
      t149 = 1/t37/t10
      t152 = 0.2519712591196268D-1*t123*t11-0.2567944823781261D-2*t129
     #*t21+0.4308291584D-4*t134*t29-0.3323017782489364D-6*t140*t38
     #+0.9894264276562486D-9*t147*t149
      t155 = t47*t60
      t158 = 1/t54
      t159 = t44*t158
      t162 = t56**2
      t163 = 1/t162
      t164 = t48*t163
      t165 = t49**2
      t166 = t165**2
      t167 = t166*t49
      t168 = 1/t167
      t169 = 1/t4
      t170 = t168*t169
      t172 = t158*t169
      t174 = 1/t52
      t175 = t174*t169
      t177 = 1/t45
      t178 = t177*t169
      t180 = -0.4160732915599108D1*t170-0.3229384477375903D1*t172
     #-0.2326004811900819D1*t175-0.5092110158254621D0*t178
      t181 = 1/t59
      t182 = t180*t181
      t183 = t182*t78
      t195 = 1/t74/t62
      t198 = 0.5733641802875474D-1*t123*t63-0.4745742938744286D-2*t129
     #*t67+0.4066054826666667D0*t134*t71-0.4672402752398278D0*t140*t75
     #+0.1069256384345231D0*t147*t195
      t199 = t60*t198
      t204 = t172*t93
      t206 = t89**2
      t207 = 1/t206
      t208 = t83*t207
      t213 = -0.99709173929518D0*t170-0.7418564737168958D0*t172
     #-0.4002143174996817D0*t175-0.1264669550498372D0*t178
      t214 = 1/t92
      t216 = t208*t213*t214
      t224 = t163*t180*t181
      t227 = -0.62182D-1*t83*t93+rho*(0.2747799777968419D-2*t204+0.1D1
     #*t216)+0.3109D-1*t155-0.1664368495390566D-2*t159*t60-0.5D0*t48
     #*t224
      t230 = 0.8515758984180187D-1*t123*t101
      t232 = 0.6395690658899341D-2*t129*t105
      t234 = 0.10907808768D-3*t134*t109
      t235 = t140*t113
      t238 = 1/t112/t100
      t240 = 0.3744188120519821D-8*t147*t238
      t241 = -t230+t232-t234+0.9254146025239327D-6*t235-t240
      vrhoa(i) = -0.9847450218426965D0*t2*t41-0.3692793831910112D0*t3
     #*t152-0.3109D-1*t155*t78+0.1664368495390566D-2*t159*t79+0.5D0
     #*t164*t183-0.15545D-1*t48*t199+t227*t116+t98*t241
      t245 = sigma*t18
      t248 = t14*t26
      t251 = t24*t35
      t256 = 1/t2/t25/t16
      t257 = t32*t256
      t260 = -0.1889784443397201D-1*t7*t11+0.1925958617835946D-2*t245
     #*t21-0.3231218688D-4*t248*t29+0.2492263336867023D-6*t251*t38
     #-0.7420698207421865D-9*t257*t149
      t273 = -0.4300231352156605D-1*t7*t63+0.3559307204058214D-2*t245
     #*t67-0.304954112D0*t248*t71+0.3504302064298708D0*t251*t75
     #-0.8019422882589234D-1*t257*t195
      t274 = t60*t273
      t287 = 0.638681923813514D-1*t7*t101-0.4796767994174505D-2*t245
     #*t105+0.8180856576D-4*t248*t109-0.6940609518929495D-6*t251*t113
     #+0.2808141090389866D-8*t257*t238
      vsigmaaa(i) = -0.7385587663820224D0*t3*t260-0.3109D-1*t48*t274
     #+2.D0*t98*t287
      t292 = sigma/t5/t15
      t295 = t15*t120
      t298 = t14/t2/t295
      t299 = t298*t105
      t302 = t24/t33
      t303 = t302*t109
      t308 = t32/t5/t25/t15
      t309 = t308*t113
      t314 = t143/t2/t25/t295
      t315 = t314*t238
      t318 = t25**2
      t321 = t32*t14/t318/t4
      t323 = 1/t112/t104
      t325 = 0.4754822529024D-9*t321*t323
      t348 = 1/t37/t20
      t356 = t47*t163
      t370 = 1/t74/t66
      t377 = t162**2
      t378 = 1/t377
      t380 = t180**2
      t381 = t59**2
      t382 = 1/t381
      t389 = 1/t15
      t390 = 1/t167/t44*t389
      t392 = 1/t120
      t393 = t168*t392
      t396 = 1/t54/t44
      t397 = t396*t389
      t399 = t158*t392
      t403 = 1/t52/t44*t389
      t405 = t174*t392
      t409 = 1/t45/t44*t389
      t411 = t177*t392
      t413 = -0.6934554859331846D1*t390+0.1664293166239643D2*t393
     #-0.4305845969834537D1*t397+0.1291753790950361D2*t399
     #-0.2326004811900819D1*t403+0.9304019247603276D1*t405
     #-0.3394740105503081D0*t409+0.2036844063301848D1*t411
      t423 = 0.1831866518645613D-2*t397*t93
      t425 = 0.5495599555936838D-2*t399*t93
      t429 = 0.8837926660346786D-1*t172*t207*t213*t214
      t433 = t213**2
      t436 = 0.2D1*t83/t206/t89*t433*t214
      t448 = 0.1D1*t208*(-0.8309097827459833D0*t390
     #+0.199418347859036D1*t393-0.4945709824779306D0*t397
     #+0.1483712947433792D1*t399-0.2001071587498409D0*t403
     #+0.8004286349993634D0*t405-0.4215565168327908D-1*t409
     #+0.2529339100996745D0*t411)*t214
      t449 = t206**2
      t452 = t92**2
      t456 = 0.160818243221511D2*t83/t449*t433/t452
      t467 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t49
     #+0.2247591863577616D1*t45+0.4300972471276643D0*t52
     #+0.1911512595127338D0*t54))
      t469 = (1.D0+0.6901399211255825D-1*t45)*t467*t169
      t473 = 0.2D1*t216
      t474 = 0.5495599555936838D-2*t204
      t477 = t392*t396
      t481 = 1/t162/t56
      s1 = t98*(0.6244889921732137D0*t292*t101-0.6611977455216065D-1
     #*t299+0.170653661184D-2*t303-0.2250092278626939D-4*t309
     #+0.1614116494367631D-6*t315-t325)+3.D0*t227*t241
     #+0.3328736990781132D-2*t159*t199-0.6564966812284644D0/t5*t41
     #-0.1969490043685393D1*t2*t152-0.3692793831910112D0*t3*(
     #-0.184778923354393D0*t292*t11+0.3338059057705277D-1*t298*t21
     #-0.9494171065457778D-3*t302*t29+0.1213065957842335D-4*t308*t38
     #-0.7337656600781108D-7*t314*t149+0.1675324322247111D-9*t321*t348
     #)-0.6218D-1*t155*t198+0.2D1*t356*t183-0.15545D-1*t48*t60*(
     #-0.4204670655442014D0*t292*t63+0.1571963602053569D0*t298*t67
     #-0.7334969935644444D1*t302*t71+0.1296770019587685D2*t308*t75
     #-0.6229778507390148D1*t314*t195+0.9052473116444444D0*t321*t370)
      s2 = s1+0.1608234158893535D2*t48*t378*t380*t382*t78+(-0.5D0*t48
     #*t163*t413*t181-0.1608234158893535D2*t48*t378*t380*t382+rho*
     #(t423-t425-t429-t436+t448+t456+0.3377399869956914D-1*t469)+t473
     #+t474-0.2D1*t356*t182-0.2219157993854088D-2*t477*t60+0.1D1*t48
     #*t481*t380*t181+0.1070677706909338D0*t159*t224)*t116+0.1D1*t164
     #*t182*t198+0.2219157993854088D-2*t477*t79
      v2rhoa2(i) = s2-0.1070677706909338D0*t159*t163*t183-0.1D1*t48
     #*t481*t380*t181*t78+0.5D0*t164*t413*t181*t78+(t474+t473+rho*
     #(t423-t425-t429-t436+t448+t456-0.3377399869956914D-1*t469))*t116
     #+t227*(-t230+t232-t234+0.9254146025239327D-6*t235-t240)+t98*(
     #-0.1921804305356549D-1*t299+0.90663063552D-3*t303
     #-0.1571454903442721D-4*t309+0.1339542698862844D-6*t315-t325)
      t525 = sigma*t128
      t528 = t14*t133
      t531 = t24*t139
      t534 = t32*t146
      t539 = t143/t318/rho
      t572 = t525*t105
      t574 = t528*t109
      t576 = t531*t113
      t578 = t534*t238
      t581 = 0.3566116896768D-9*t539*t323
      s1 = -0.9847450218426965D0*t2*t260-0.3692793831910112D0*t3*
     #(0.1007885036478507D0*t122*t11-0.2118352569711769D-1*t525*t21
     #+0.6474384561493333D-3*t528*t29-0.8599542016444107D-5*t531*t38
     #+0.5354828486437394D-7*t534*t149-0.1256493241685333D-9*t539*t348
     #)-0.3109D-1*t155*t273+0.1664368495390566D-2*t159*t274
      v2rhoasigmaaa(i) = s1+0.5D0*t164*t182*t273-0.15545D-1*t48*t60*
     #(0.2293456721150189D0*t122*t63-0.1107786557459012D0*t525*t67
     #+0.4891319227733333D1*t528*t71-0.9024914734047895D1*t531*t75
     #+0.4511945422890826D1*t534*t195-0.6789354837333333D0*t539*t370)
     #+2.D0*t227*t287+t98*(-0.3406303593672075D0*t122*t101
     #+0.3999629492577148D-1*t572-0.111628532736D-2*t574
     #+0.1548757018591614D-4*t576-0.1154424548967926D-6*t578+t581)+t98
     #*(0.1441353229017411D-1*t572-0.67997297664D-3*t574
     #+0.1178591177582041D-4*t576-0.1004657024147133D-6*t578+t581)
      t592 = sigma*t26
      t595 = t14*t35
      t598 = t24*t256
      t602 = t32/t318
      v2sigmaaa2(i) = -0.7385587663820224D0*t3*(0.818380980149448D-2
     #*t18*t21-0.356330094592D-3*t592*t29+0.5452751177586271D-5*t595
     #*t38-0.3719293436531171D-7*t598*t149+0.942369931264D-10*t602
     #*t348)-0.3109D-1*t48*t60*(0.6884676299319308D-1*t18*t67
     #-0.24486729728D1*t592*t71+0.5366965224816438D1*t595*t75
     #-0.306318215186455D1*t598*t195+0.5092016128D0*t602*t370)+4.D0
     #*t98*(-0.1081014921763059D-1*t18*t105+0.50997973248D-3*t592*t109
     #-0.8839433831865308D-5*t595*t113+0.7534927681103499D-7*t598*t238
     #-0.2674587672576D-9*t602*t323)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


c:C_LYPsubrstart

c    Generated: Wed Mar 10 10:16:01 GMT 2004

      subroutine uks_c_lyp
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     C. Lee, W. Yang, and R.G. Parr
c     Development of the Colle-Salvetti correlation-energy formula into
c     a functional of the electron density
c     Phys. Rev. B37 (1988) 785-789
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmabb
      zk(i) = 0.D0
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigma = sigmaaa
      zk(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rho**(1.D0/3.D0)
      t5 = 1/t4
      t8 = 1/(1.D0+0.349D0*t5)
      t10 = 1/rho
      t11 = rhob*t10
      t14 = 0.2533D0*t5
      t15 = dexp(-t14)
      t17 = rho**2
      t19 = t4**2
      t23 = rhoa**2
      t24 = rhoa**(1.D0/3.D0)
      t25 = t24**2
      t28 = rhob**2
      t29 = rhob**(1.D0/3.D0)
      t30 = t29**2
      t34 = t5*t8
      t56 = 0.6666666666666667D0*t17
      zk(i) = -0.19672D0*t8*rhoa*t11-0.649176D-2*t15*t8/t19/t17/rho*
     #(rhoa*rhob*(0.3646239897876478D2*t25*t23+0.3646239897876478D2
     #*t30*t28+(0.2611111111111111D1-0.9850555555555556D-1*t5
     #-0.1357222222222222D0*t34)*sigma-1.D0*(0.25D1
     #-0.1407222222222222D-1*t5-0.1938888888888889D-1*t34)*(sigmaaa
     #+sigmabb)-0.1111111111111111D0*(t14+0.349D0*t34-11.D0)*(rhoa*t10
     #*sigmaaa+t11*sigmabb))-0.6666666666666667D0*t17*sigma+(t56-1.D0
     #*t23)*sigmabb+(t56-1.D0*t28)*sigmaaa)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmabb
      zk(i) = 0.D0
      vrhoa(i) = 0.D0
      vrhob(i) = 0.D0
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigma = sigmaaa
      zk(i) = 0.D0
      vrhoa(i) = 0.D0
      vrhob(i) = 0.D0
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rho**(1.D0/3.D0)
      t5 = 1/t4
      t7 = 1.D0+0.349D0*t5
      t8 = 1/t7
      t9 = t8*rhoa
      t10 = 1/rho
      t11 = rhob*t10
      t14 = 0.2533D0*t5
      t15 = dexp(-t14)
      t16 = t15*t8
      t17 = rho**2
      t19 = t4**2
      t21 = 1/t19/t17/rho
      t22 = rhoa*rhob
      t23 = rhoa**2
      t24 = rhoa**(1.D0/3.D0)
      t25 = t24**2
      t28 = rhob**2
      t29 = rhob**(1.D0/3.D0)
      t30 = t29**2
      t34 = t5*t8
      t36 = 0.2611111111111111D1-0.9850555555555556D-1*t5
     #-0.1357222222222222D0*t34
      t41 = sigmaaa+sigmabb
      t45 = t14+0.349D0*t34-11.D0
      t49 = rhoa*t10*sigmaaa+t11*sigmabb
      t52 = 0.3646239897876478D2*t25*t23+0.3646239897876478D2*t30*t28
     #+t36*sigma-1.D0*(0.25D1-0.1407222222222222D-1*t5
     #-0.1938888888888889D-1*t34)*t41-0.1111111111111111D0*t45*t49
      t56 = 0.6666666666666667D0*t17
      t57 = 1.D0*t23
      t60 = 1.D0*t28
      t63 = t22*t52-0.6666666666666667D0*t17*sigma+(t56-t57)*sigmabb+
     #(t56-t60)*sigmaaa
      zk(i) = -0.19672D0*t9*t11-0.649176D-2*t16*t21*t63
      t73 = t45*t10
      t84 = t7**2
      t85 = 1/t84
      t91 = 0.2288509333333333D-1*t85*rhoa*rhob/t4/t17
      t92 = 1/t17
      t93 = rhob*t92
      t95 = 0.19672D0*t9*t93
      t96 = t17**2
      t98 = 1/t96/rho
      t102 = 0.548120936D-3*t98*t15*t8*t63
      t106 = 0.75520808D-3*t15*t85*t98*t63
      t111 = 0.2380312D-1*t16/t19/t96*t63
      t113 = 1/t4/rho
      t115 = t113*t8
      t119 = 1/t19/rho*t85
      t154 = 0.649176D-2*t16*t21*(t22*((0.3283518518518519D-1*t113
     #+0.4524074074074074D-1*t115-0.1578901851851852D-1*t119)*sigma
     #-1.D0*(0.4690740740740741D-2*t113+0.6462962962962963D-2*t115
     #-0.2255574074074074D-2*t119)*t41-0.1111111111111111D0*(
     #-0.8443333333333333D-1*t113-0.1163333333333333D0*t115
     #+0.4060033333333333D-1*t119)*t49-0.1111111111111111D0*t45*(-1.D0
     #*rhoa*t92*sigmaaa-1.D0*t93*sigmabb))-0.1333333333333333D1*rho
     #*sigma+0.1333333333333333D1*rho*sigmabb+0.1333333333333333D1*rho
     #*sigmaaa)
      vrhoa(i) = -0.19672D0*t8*rhob*t10-0.649176D-2*t16*t21*(rhob*t52
     #+t22*(0.9723306394337274D2*t25*rhoa-0.1111111111111111D0*t73
     #*sigmaaa)-2.D0*rhoa*sigmabb)-t91+t95-t102-t106+t111-t154
      vrhob(i) = -0.19672D0*t9*t10-0.649176D-2*t16*t21*(rhoa*t52+t22*
     #(0.9723306394337274D2*t30*rhob-0.1111111111111111D0*t73*sigmabb)
     #-2.D0*rhob*sigmaaa)-t91+t95-t102-t106+t111-t154
      t170 = 0.1407222222222222D-1*t5
      t171 = 0.1938888888888889D-1*t34
      t185 = t16*t21*(t22*t36-0.6666666666666667D0*t17)
      t186 = 0.649176D-2*t185
      vsigmaaa(i) = -0.649176D-2*t16*t21*(t22*(-0.25D1+t170+t171
     #-0.1111111111111111D0*t45*rhoa*t10)+t56-t60)-t186
      vsigmaab(i) = -0.1298352D-1*t185
      vsigmabb(i) = -0.649176D-2*t16*t21*(t22*(-0.25D1+t170+t171
     #-0.1111111111111111D0*t45*rhob*t10)+t56-t57)-t186
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmabb
      zk(i) = 0.D0
      vrhoa(i) = 0.D0
      vrhob(i) = 0.D0
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      v2rhob2(i) = 0.D0
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigma = sigmaaa
      zk(i) = 0.D0
      vrhoa(i) = 0.D0
      vrhob(i) = 0.D0
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      v2rhoa2(i) = 0.D0
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(0.D0,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(0.D0,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rho**(1.D0/3.D0)
      t5 = 1/t4
      t7 = 1.D0+0.349D0*t5
      t8 = 1/t7
      t9 = t8*rhoa
      t10 = 1/rho
      t11 = rhob*t10
      t14 = 0.2533D0*t5
      t15 = dexp(-t14)
      t16 = t15*t8
      t17 = rho**2
      t18 = t17*rho
      t19 = t4**2
      t21 = 1/t19/t18
      t22 = rhoa*rhob
      t23 = rhoa**2
      t24 = rhoa**(1.D0/3.D0)
      t25 = t24**2
      t27 = 0.3646239897876478D2*t25*t23
      t28 = rhob**2
      t29 = rhob**(1.D0/3.D0)
      t30 = t29**2
      t32 = 0.3646239897876478D2*t30*t28
      t34 = t5*t8
      t36 = 0.2611111111111111D1-0.9850555555555556D-1*t5
     #-0.1357222222222222D0*t34
      t37 = t36*sigma
      t41 = sigmaaa+sigmabb
      t43 = 1.D0*(0.25D1-0.1407222222222222D-1*t5
     #-0.1938888888888889D-1*t34)*t41
      t45 = t14+0.349D0*t34-11.D0
      t49 = rhoa*t10*sigmaaa+t11*sigmabb
      t51 = 0.1111111111111111D0*t45*t49
      t52 = t27+t32+t37-t43-t51
      t56 = 0.6666666666666667D0*t17
      t57 = 1.D0*t23
      t60 = 1.D0*t28
      t63 = t22*t52-0.6666666666666667D0*t17*sigma+(t56-t57)*sigmabb+
     #(t56-t60)*sigmaaa
      zk(i) = -0.19672D0*t9*t11-0.649176D-2*t16*t21*t63
      t67 = t8*rhob
      t71 = t25*rhoa
      t73 = t45*t10
      t76 = 0.9723306394337274D2*t71-0.1111111111111111D0*t73*sigmaaa
      t80 = rhob*t52+t22*t76-2.D0*rhoa*sigmabb
      t84 = t7**2
      t85 = 1/t84
      t86 = t85*rhoa
      t88 = 1/t4/t17
      t91 = 0.2288509333333333D-1*t86*rhob*t88
      t92 = 1/t17
      t93 = rhob*t92
      t95 = 0.19672D0*t9*t93
      t96 = t17**2
      t97 = t96*rho
      t98 = 1/t97
      t99 = t98*t15
      t100 = t8*t63
      t102 = 0.548120936D-3*t99*t100
      t103 = t15*t85
      t106 = 0.75520808D-3*t103*t98*t63
      t108 = 1/t19/t96
      t111 = 0.2380312D-1*t16*t108*t63
      t113 = 1/t4/rho
      t115 = t113*t8
      t119 = 1/t19/rho*t85
      t121 = 0.3283518518518519D-1*t113+0.4524074074074074D-1*t115
     #-0.1578901851851852D-1*t119
      t132 = -0.8443333333333333D-1*t113-0.1163333333333333D0*t115
     #+0.4060033333333333D-1*t119
      t140 = -1.D0*rhoa*t92*sigmaaa-1.D0*t93*sigmabb
      t143 = t121*sigma-1.D0*(0.4690740740740741D-2*t113
     #+0.6462962962962963D-2*t115-0.2255574074074074D-2*t119)*t41
     #-0.1111111111111111D0*t132*t49-0.1111111111111111D0*t45*t140
      t151 = t22*t143-0.1333333333333333D1*rho*sigma
     #+0.1333333333333333D1*rho*sigmabb+0.1333333333333333D1*rho*sigmaaa
      t154 = 0.649176D-2*t16*t21*t151
      vrhoa(i) = -0.19672D0*t67*t10-0.649176D-2*t16*t21*t80-t91+t95
     #-t102-t106+t111-t154
      t158 = t30*rhob
      t162 = 0.9723306394337274D2*t158-0.1111111111111111D0*t73*sigmabb
      t166 = rhoa*t52+t22*t162-2.D0*rhob*sigmaaa
      vrhob(i) = -0.19672D0*t9*t10-0.649176D-2*t16*t21*t166-t91+t95
     #-t102-t106+t111-t154
      t170 = 0.1407222222222222D-1*t5
      t171 = 0.1938888888888889D-1*t34
      t172 = t45*rhoa
      t175 = -0.25D1+t170+t171-0.1111111111111111D0*t172*t10
      t177 = t22*t175+t56-t60
      t183 = t22*t36-0.6666666666666667D0*t17
      t185 = t16*t21*t183
      t186 = 0.649176D-2*t185
      vsigmaaa(i) = -0.649176D-2*t16*t21*t177-t186
      vsigmaab(i) = -0.1298352D-1*t185
      t188 = t45*rhob
      t191 = -0.25D1+t170+t171-0.1111111111111111D0*t188*t10
      t193 = t22*t191+t56-t57
      vsigmabb(i) = -0.649176D-2*t16*t21*t193-t186
      t198 = t85*rhob*t88
      t200 = t67*t92
      t203 = t99*t8*t80
      t206 = t103*t98*t80
      t209 = t16*t108*t80
      t212 = t132*t10
      t215 = t45*t92
      t222 = t16*t21*(rhob*t143+t22*(-0.1111111111111111D0*t212
     #*sigmaaa+0.1111111111111111D0*t215*sigmaaa))
      t237 = 0.1110812266666667D0*t16/t19/t97*t63
      t239 = t88*t8
      t243 = 1/t19/t17*t85
      t245 = 1/t18
      t247 = 1/t84/t7
      t248 = t245*t247
      t271 = rhob*t245
      t285 = 0.649176D-2*t16*t21*(t22*((-0.4378024691358025D-1*t88
     #-0.6032098765432099D-1*t239+0.3157803703703704D-1*t243
     #-0.3673578308641975D-2*t248)*sigma-1.D0*(-0.6254320987654321D-2
     #*t88-0.8617283950617284D-2*t239+0.4511148148148148D-2*t243
     #-0.5247969012345679D-3*t248)*t41-0.1111111111111111D0*
     #(0.1125777777777778D0*t88+0.1551111111111111D0*t239
     #-0.8120066666666667D-1*t243+0.9446344222222222D-2*t248)*t49
     #-0.2222222222222222D0*t132*t140-0.1111111111111111D0*t45*(2.D0
     #*rhoa*t245*sigmaaa+2.D0*t271*sigmabb))-0.1333333333333333D1
     #*sigma+0.1333333333333333D1*sigmabb+0.1333333333333333D1*sigmaaa)
      t286 = t96*t17
      t287 = 1/t286
      t290 = 0.6545136693333333D-2*t103*t287*t63
      t293 = 0.4750381445333333D-2*t287*t15*t100
      t298 = 0.7628364444444444D-1*t86*rhob/t4/t18
      t300 = rhob*t21
      t302 = 0.5324598382222222D-2*t247*rhoa*t300
      t305 = 0.1096241872D-2*t99*t8*t151
      t307 = 1/t4/t286
      t308 = t307*t15
      t310 = 0.4627967769626667D-4*t308*t100
      t313 = 0.1275294711093333D-3*t308*t85*t63
      t316 = 0.151041616D-2*t103*t98*t151
      t320 = 0.1757117466133333D-3*t15*t247*t307*t63
      t323 = 0.4760624D-1*t16*t108*t151
      t325 = 0.39344D0*t9*t271
      v2rhoa2(i) = -0.4577018666666667D-1*t198+0.39344D0*t200
     #-0.1096241872D-2*t203-0.151041616D-2*t206+0.4760624D-1*t209
     #-0.1298352D-1*t222-0.649176D-2*t16*t21*(2.D0*rhob*t76
     #+0.1620551065722879D3*t71*rhob-2.D0*sigmabb)-t237-t285+t290+t293
     #+t298-t302-t305-t310-t313-t316-t320+t323-t325
      t335 = t86*t88
      t337 = t9*t92
      t340 = t99*t8*t166
      t343 = t103*t98*t166
      t346 = t16*t108*t166
      t357 = t16*t21*(rhoa*t143+t22*(-0.1111111111111111D0*t212
     #*sigmabb+0.1111111111111111D0*t215*sigmabb))
      v2rhob2(i) = -t237-t285+t290+t293+t298-t302-t305-t310-t313-t316
     #-t320+t323-0.649176D-2*t16*t21*(2.D0*rhoa*t162
     #+0.1620551065722879D3*rhoa*t158-2.D0*sigmaaa)
     #-0.4577018666666667D-1*t335+0.39344D0*t337-0.1096241872D-2*t340
     #-0.151041616D-2*t343+0.4760624D-1*t346-0.1298352D-1*t357-t325
      t377 = 0.19672D0*t337-0.2288509333333333D-1*t335-0.548120936D-3
     #*t340-0.75520808D-3*t343+0.2380312D-1*t346-0.19672D0*t8*t10
     #-0.649176D-2*t16*t21*(t27+t32+t37-t43-t51+rhob*t162+rhoa*t76)
     #-0.649176D-2*t357-0.548120936D-3*t203-0.75520808D-3*t206
     #+0.2380312D-1*t209-0.649176D-2*t222-t237
      t380 = -t285+t290+t293+t298-t302-t305-t310-t313-t316-t320+t323
     #-t325-0.2288509333333333D-1*t198+0.19672D0*t200
      v2rhoab(i) = t377+t380
      t383 = 0.1111111111111111D0*t22*t73
      t390 = 0.548120936D-3*t99*t8*t177
      t393 = 0.75520808D-3*t103*t98*t177
      t396 = 0.2380312D-1*t16*t108*t177
      t397 = 0.4690740740740741D-2*t113
      t398 = 0.6462962962962963D-2*t115
      t399 = 0.2255574074074074D-2*t119
      t407 = 0.1333333333333333D1*rho
      t411 = 0.649176D-2*t16*t21*(t22*(-t397-t398+t399
     #-0.1111111111111111D0*t132*rhoa*t10+0.1111111111111111D0*t172
     #*t92)+t407)
      t413 = t16*t300*t36
      t414 = 0.649176D-2*t413
      t416 = t99*t8*t183
      t417 = 0.548120936D-3*t416
      t419 = t103*t98*t183
      t420 = 0.75520808D-3*t419
      t422 = t16*t108*t183
      t423 = 0.2380312D-1*t422
      t428 = t16*t21*(t22*t121-0.1333333333333333D1*rho)
      t429 = 0.649176D-2*t428
      v2rhoasigmaaa(i) = -0.649176D-2*t16*t21*(rhob*t175-t383)-t390
     #-t393+t396-t411-t414-t417-t420+t423-t429
      t431 = 0.1096241872D-2*t416
      t432 = 0.151041616D-2*t419
      t433 = 0.4760624D-1*t422
      t434 = 0.1298352D-1*t428
      v2rhoasigmaab(i) = -0.1298352D-1*t413-t431-t432+t433-t434
      t443 = 0.548120936D-3*t99*t8*t193
      t446 = 0.75520808D-3*t103*t98*t193
      t449 = 0.2380312D-1*t16*t108*t193
      t460 = 0.649176D-2*t16*t21*(t22*(-t397-t398+t399
     #-0.1111111111111111D0*t132*rhob*t10+0.1111111111111111D0*t188
     #*t92)+t407)
      v2rhoasigmabb(i) = -0.649176D-2*t16*t21*(rhob*t191-2.D0*rhoa)
     #-t443-t446+t449-t460-t414-t417-t420+t423-t429
      t469 = t16*t21*rhoa*t36
      t470 = 0.649176D-2*t469
      v2rhobsigmaaa(i) = -0.649176D-2*t16*t21*(rhoa*t175-2.D0*rhob)
     #-t390-t393+t396-t411-t470-t417-t420+t423-t429
      v2rhobsigmaab(i) = -0.1298352D-1*t469-t431-t432+t433-t434
      v2rhobsigmabb(i) = -0.649176D-2*t16*t21*(rhoa*t191-t383)-t443
     #-t446+t449-t460-t470-t417-t420+t423-t429
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end




      subroutine rks_c_lyp
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     C. Lee, W. Yang, and R.G. Parr
c     Development of the Colle-Salvetti correlation-energy formula into
c     a functional of the electron density
c     Phys. Rev. B37 (1988) 785-789
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(0.D0,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = 1/t2
      t6 = 1/(1.D0+0.349D0*t3)
      t9 = 0.2533D0*t3
      t10 = dexp(-t9)
      t12 = rho**2
      t14 = t2**2
      t20 = t3*t6
      zk(i) = -0.4918D-1*t6*rho-0.649176D-2*t10*t6/t14/t12/rho*(0.25D0
     #*t12*(0.1148493600075277D2*t14*t12+(0.2611111111111111D1
     #-0.9850555555555556D-1*t3-0.1357222222222222D0*t20)*sigma-0.5D0*
     #(0.25D1-0.1407222222222222D-1*t3-0.1938888888888889D-1*t20)
     #*sigma-0.2777777777777778D-1*(t9+0.349D0*t20-11.D0)*sigma)
     #-0.4583333333333333D0*t12*sigma)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(0.D0,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = 1/t2
      t5 = 1.D0+0.349D0*t3
      t6 = 1/t5
      t9 = 0.2533D0*t3
      t10 = dexp(-t9)
      t11 = t10*t6
      t12 = rho**2
      t14 = t2**2
      t16 = 1/t14/t12/rho
      t20 = t3*t6
      t22 = 0.2611111111111111D1-0.9850555555555556D-1*t3
     #-0.1357222222222222D0*t20
      t30 = t9+0.349D0*t20-11.D0
      t33 = 0.1148493600075277D2*t14*t12+t22*sigma-0.5D0*(0.25D1
     #-0.1407222222222222D-1*t3-0.1938888888888889D-1*t20)*sigma
     #-0.2777777777777778D-1*t30*sigma
      t38 = 0.25D0*t12*t33-0.4583333333333333D0*t12*sigma
      zk(i) = -0.4918D-1*t6*rho-0.649176D-2*t11*t16*t38
      t45 = t14*rho
      t49 = t30/rho*sigma
      t54 = rho*sigma
      t60 = t5**2
      t61 = 1/t60
      t64 = t12**2
      t66 = 1/t64/rho
      t81 = 1/t2/rho
      t83 = t81*t6
      t85 = 1/t45
      t86 = t85*t61
      vrhoa(i) = -0.4918D-1*t6-0.649176D-2*t11*t16*(0.5D0*rho*t33
     #+0.25D0*t12*(0.3062649600200738D2*t45-0.2777777777777778D-1*t49)
     #-0.25D0*t54)-0.5721273333333333D-2*t61*t3-0.548120936D-3*t66*t10
     #*t6*t38-0.75520808D-3*t10*t61*t66*t38+0.2380312D-1*t11/t14/t64
     #*t38-0.649176D-2*t11*t16*(0.25D0*t12*((0.3283518518518519D-1*t81
     #+0.4524074074074074D-1*t83-0.1578901851851852D-1*t86)*sigma
     #-0.5D0*(0.4690740740740741D-2*t81+0.6462962962962963D-2*t83
     #-0.2255574074074074D-2*t86)*sigma-0.2777777777777778D-1*(
     #-0.8443333333333333D-1*t81-0.1163333333333333D0*t83
     #+0.4060033333333333D-1*t86)*sigma+0.2777777777777778D-1*t49)
     #-0.6666666666666667D0*t54)
      vsigmaaa(i) = 0.7213066666666667D-3*t11*t85-0.2596704D-1*t11*t16
     #*(0.25D0*t12*t22-0.6666666666666667D0*t12)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(0.D0,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = 1/t2
      t5 = 1.D0+0.349D0*t3
      t6 = 1/t5
      t9 = 0.2533D0*t3
      t10 = dexp(-t9)
      t11 = t10*t6
      t12 = rho**2
      t13 = t12*rho
      t14 = t2**2
      t16 = 1/t14/t13
      t17 = t14*t12
      t18 = 0.1148493600075277D2*t17
      t20 = t3*t6
      t22 = 0.2611111111111111D1-0.9850555555555556D-1*t3
     #-0.1357222222222222D0*t20
      t23 = t22*sigma
      t28 = 0.5D0*(0.25D1-0.1407222222222222D-1*t3
     #-0.1938888888888889D-1*t20)*sigma
      t30 = t9+0.349D0*t20-11.D0
      t32 = 0.2777777777777778D-1*t30*sigma
      t33 = t18+t23-t28-t32
      t38 = 0.25D0*t12*t33-0.4583333333333333D0*t12*sigma
      zk(i) = -0.4918D-1*t6*rho-0.649176D-2*t11*t16*t38
      t45 = t14*rho
      t47 = 1/rho
      t48 = t30*t47
      t49 = t48*sigma
      t51 = 0.3062649600200738D2*t45-0.2777777777777778D-1*t49
      t54 = rho*sigma
      t56 = 0.5D0*rho*t33+0.25D0*t12*t51-0.25D0*t54
      t60 = t5**2
      t61 = 1/t60
      t64 = t12**2
      t65 = t64*rho
      t66 = 1/t65
      t67 = t66*t10
      t68 = t6*t38
      t71 = t10*t61
      t76 = 1/t14/t64
      t81 = 1/t2/rho
      t83 = t81*t6
      t85 = 1/t45
      t86 = t85*t61
      t88 = 0.3283518518518519D-1*t81+0.4524074074074074D-1*t83
     #-0.1578901851851852D-1*t86
      t99 = -0.8443333333333333D-1*t81-0.1163333333333333D0*t83
     #+0.4060033333333333D-1*t86
      t103 = t88*sigma-0.5D0*(0.4690740740740741D-2*t81
     #+0.6462962962962963D-2*t83-0.2255574074074074D-2*t86)*sigma
     #-0.2777777777777778D-1*t99*sigma+0.2777777777777778D-1*t49
      t107 = 0.25D0*t12*t103-0.6666666666666667D0*t54
      vrhoa(i) = -0.4918D-1*t6-0.649176D-2*t11*t16*t56
     #-0.5721273333333333D-2*t61*t3-0.548120936D-3*t67*t68
     #-0.75520808D-3*t71*t66*t38+0.2380312D-1*t11*t76*t38-0.649176D-2
     #*t11*t16*t107
      t116 = 0.25D0*t12*t22-0.6666666666666667D0*t12
      vsigmaaa(i) = 0.7213066666666667D-3*t11*t85-0.2596704D-1*t11*t16
     #*t116
      t121 = 1/t60/t5
      t126 = t64*t12
      t127 = 1/t126
      t137 = t99*t47*sigma
      t141 = t30/t12*sigma
      t150 = rho*t51
      t165 = 1/t2/t126
      t166 = t165*t10
      t188 = 1/t2/t12
      t190 = t188*t6
      t192 = 1/t17
      t193 = t192*t61
      t195 = 1/t13
      t196 = t195*t121
      s1 = -0.2662299191111111D-2*t121*t85-0.7628364444444444D-2*t61
     #*t81+0.9500762890666667D-2*t127*t10*t68+0.9521248D-1*t11*t76*t56
     #-0.2596704D-1*t11*t16*(0.5D0*rho*t103+0.25D0*t12*(
     #-0.2777777777777778D-1*t137+0.2777777777777778D-1*t141))
     #-0.649176D-2*t11*t16*(t18+t23-t28-t32+t150)+0.9521248D-1*t11*t76
     #*t107-0.2192483744D-2*t67*t6*t56-0.302083232D-2*t71*t66*t56
      s2 = s1-0.2550589422186667D-3*t166*t61*t38-0.302083232D-2*t71
     #*t66*t107-0.3514234932266667D-3*t10*t121*t165*t38
     #-0.2192483744D-2*t67*t6*t107
      v2rhoa2(i) = s2-0.9255935539253333D-4*t166*t68
     #-0.2221624533333333D0*t11/t14/t65*t38-0.1298352D-1*t11*t16*
     #(0.25D0*t12*((-0.4378024691358025D-1*t188-0.6032098765432099D-1
     #*t190+0.3157803703703704D-1*t193-0.3673578308641975D-2*t196)
     #*sigma-0.5D0*(-0.6254320987654321D-2*t188-0.8617283950617284D-2
     #*t190+0.4511148148148148D-2*t193-0.5247969012345679D-3*t196)
     #*sigma-0.2777777777777778D-1*(0.1125777777777778D0*t188
     #+0.1551111111111111D0*t190-0.8120066666666667D-1*t193
     #+0.9446344222222222D-2*t196)*sigma+0.5555555555555556D-1*t137
     #-0.5555555555555556D-1*t141)-0.6666666666666667D0*sigma)
     #-0.649176D-2*t11*t16*(0.1D1*t150+0.2552208000167282D2*t17-0.5D0
     #*sigma)+0.1309027338666667D-1*t71*t127*t38
      v2rhoasigmaaa(i) = -0.649176D-2*t11*t16*(-0.9444444444444444D0
     #*rho-0.2777777777777778D-1*rho*t30)+0.6090232622222222D-4*t195
     #*t10*t6+0.8391200888888889D-4*t71*t195+0.9978075555555556D-2*t11
     #*t192-0.1298352D-1*t11*t16*(0.25D0*t12*(-0.3D-22*t83+0.1D-22*t86
     #+0.5555555555555556D-1*t48)+0.1333333333333333D1*rho)
     #-0.1298352D-1*t11*t192*t22-0.2192483744D-2*t67*t6*t116
     #-0.302083232D-2*t71*t66*t116+0.9521248D-1*t11*t76*t116
     #-0.2596704D-1*t11*t16*(0.25D0*t12*t88-0.1333333333333333D1*rho)
      v2sigmaaa2(i) = 0.D0
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


c:XC_HCTHsubrend
c:C_PW91subrstart
c    Generated: Mon Oct 25 08:33:33 BST 2004

      subroutine uks_c_pw91
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     J.P. Perdew, J.A. Chevary, S.H. Vosko, K.A. Jackson,
c     M.R. Pederson, D.J. Singh, C. Fiolhais
c     Atoms, molecules, solids and surfaces:
c     Applications of the generalized gradient approximation
c     for exchange and correlation
c     Phys. Rev. B 46 (1992) 6671--6687
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = 1/rhob
      t3 = t2**(1.D0/3.D0)
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t17 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t6
     #+0.3844746237447211D1*t3+0.1644733775567609D1*t9
     #+0.2405871291288192D0*t11))
      t18 = (1.D0+0.1274696188700087D0*t3)*t17
      t20 = rhob**2
      t21 = rhob**(1.D0/3.D0)
      t23 = 1/t21/t20
      t27 = dexp(0.2513789108010112D1*t18)
      t28 = t27-1.D0
      t29 = 1/t28
      t30 = sigmabb**2
      t32 = t20**2
      t33 = t21**2
      t35 = 1/t33/t32
      t42 = t28**2
      t52 = dlog(1.D0+0.2697586091519874D1*(0.1007494971260294D0
     #*sigmabb*t23+0.2738174287780083D-1*t29*t30*t35)/(1.D0
     #+0.2717804421747983D0*t29*sigmabb*t23+0.7386460874872889D-1/t42
     #*t30*t35))
      t70 = dexp(-0.1645530784602056D1/t33/t20*sigmabb)
      zk(i) = rhob*(-0.3109D-1*t18+0.1236778371778789D-1*t52
     #+0.7937005259840997D0*(0.1D-2*(0.2568D1+0.1443307452126544D2*t3
     #+0.2843543831490386D-2*t11)/(1.D0+0.5411317332115466D1*t3
     #+0.1816419932959077D0*t11+0.1763993811759022D-1*t2)
     #-0.1853571428571429D-2)*sigmabb*t23*t70)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = 1/rhoa
      t3 = t2**(1.D0/3.D0)
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t17 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t6
     #+0.3844746237447211D1*t3+0.1644733775567609D1*t9
     #+0.2405871291288192D0*t11))
      t18 = (1.D0+0.1274696188700087D0*t3)*t17
      t20 = rhoa**2
      t21 = rhoa**(1.D0/3.D0)
      t23 = 1/t21/t20
      t27 = dexp(0.2513789108010112D1*t18)
      t28 = t27-1.D0
      t29 = 1/t28
      t30 = sigmaaa**2
      t32 = t20**2
      t33 = t21**2
      t35 = 1/t33/t32
      t42 = t28**2
      t52 = dlog(1.D0+0.2697586091519874D1*(0.1007494971260294D0
     #*sigmaaa*t23+0.2738174287780083D-1*t29*t30*t35)/(1.D0
     #+0.2717804421747983D0*t29*sigmaaa*t23+0.7386460874872889D-1/t42
     #*t30*t35))
      t70 = dexp(-0.1645530784602056D1/t33/t20*sigmaaa)
      zk(i) = rhoa*(-0.3109D-1*t18+0.1236778371778789D-1*t52
     #+0.7937005259840997D0*(0.1D-2*(0.2568D1+0.1443307452126544D2*t3
     #+0.2843543831490386D-2*t11)/(1.D0+0.5411317332115466D1*t3
     #+0.1816419932959077D0*t11+0.1763993811759022D-1*t2)
     #-0.1853571428571429D-2)*sigmaaa*t23*t70)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = 1/rho
      t5 = t4**(1.D0/3.D0)
      t8 = t4**(1.D0/6.D0)
      t11 = dsqrt(t4)
      t13 = t5**2
      t19 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t8
     #+0.2225569421150687D1*t5+0.8004286349993634D0*t11
     #+0.1897004325747559D0*t13))
      t21 = 0.62182D-1*(1.D0+0.1325688999052018D0*t5)*t19
      t32 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t8
     #+0.2247591863577616D1*t5+0.4300972471276643D0*t11
     #+0.1911512595127338D0*t13))
      t35 = rhoa-1.D0*rhob
      t36 = t35*t4
      t37 = 1.D0+t36
      t38 = t37**(1.D0/3.D0)
      t41 = 1.D0-1.D0*t36
      t42 = t41**(1.D0/3.D0)
      t44 = t38*t37+t42*t41-2.D0
      t45 = t35**2
      t46 = t45**2
      t47 = rho**2
      t48 = t47**2
      t50 = t46/t48
      t55 = 0.3799575D-1*(1.D0+0.6901399211255825D-1*t5)*t32*t44*(1.D0
     #-1.D0*t50)
      t66 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t8
     #+0.3844746237447211D1*t5+0.1644733775567609D1*t11
     #+0.2405871291288192D0*t13))
      t72 = 0.1923661050931536D1*(-0.3109D-1*(1.D0
     #+0.1274696188700087D0*t5)*t66+t21)*t44*t50
      t73 = t38**2
      t75 = t42**2
      t77 = 0.5D0*t73+0.5D0*t75
      t78 = t77**2
      t79 = t78*t77
      t80 = 1/t78
      t82 = rho**(1.D0/3.D0)
      t84 = 1/t82/t47
      t91 = dexp(-0.4042761511756372D2*(-t21+t55+t72)/t79)
      t92 = t91-1.D0
      t93 = 1/t92
      t94 = sigma**2
      t96 = t78**2
      t98 = t82**2
      t101 = 1/t96/t98/t48
      t109 = t92**2
      t119 = dlog(1.D0+0.2697586091519874D1*(0.634682060977037D-1
     #*sigma*t80*t84+0.1086645186223595D-1*t93*t94*t101)/(1.D0
     #+0.1712109500228824D0*t93*sigma*t80*t84+0.2931318940773793D-1
     #/t109*t94*t101))
      t140 = dexp(-0.261211729852336D1*t78/t98/t47*sigma)
      zk(i) = rho*(-t21+t55+t72+0.2473556743557577D-1*t79*t119+0.1D1*
     #(0.1D-2*(0.2568D1+0.1443307452126544D2*t5+0.2843543831490386D-2
     #*t13)/(1.D0+0.5411317332115466D1*t5+0.1816419932959077D0*t13
     #+0.1763993811759022D-1*t4)-0.1853571428571429D-2)*t77*sigma*t84
     #*t140)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = 1/rhob
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1274696188700087D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.1112037486309468D2*t6+0.3844746237447211D1*t3
     #+0.1644733775567609D1*t9+0.2405871291288192D0*t11
      t16 = 1.D0+0.321646831778707D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.3109D-1*t18
      t20 = rhob**2
      t21 = rhob**(1.D0/3.D0)
      t23 = 1/t21/t20
      t27 = dexp(0.2513789108010112D1*t18)
      t28 = t27-1.D0
      t29 = 1/t28
      t30 = sigmabb**2
      t31 = t29*t30
      t32 = t20**2
      t33 = t21**2
      t35 = 1/t33/t32
      t38 = 0.1007494971260294D0*sigmabb*t23+0.2738174287780083D-1*t31
     #*t35
      t39 = t29*sigmabb
      t42 = t28**2
      t43 = 1/t42
      t44 = t43*t30
      t47 = 1.D0+0.2717804421747983D0*t39*t23+0.7386460874872889D-1
     #*t44*t35
      t48 = 1/t47
      t51 = 1.D0+0.2697586091519874D1*t38*t48
      t52 = dlog(t51)
      t53 = 0.1236778371778789D-1*t52
      t56 = 0.2568D1+0.1443307452126544D2*t3+0.2843543831490386D-2*t11
      t60 = 1.D0+0.5411317332115466D1*t3+0.1816419932959077D0*t11
     #+0.1763993811759022D-1*t2
      t61 = 1/t60
      t64 = 0.1D-2*t56*t61-0.1853571428571429D-2
      t65 = t64*sigmabb
      t70 = dexp(-0.1645530784602056D1/t33/t20*sigmabb)
      t71 = t23*t70
      t73 = 0.7937005259840997D0*t65*t71
      zk(i) = rhob*(-t19+t53+t73)
      vrhoa(i) = 0.D0
      t76 = 1/t20
      t77 = 1/t11*t76
      t79 = 0.1321010150222857D-2*t77*t17
      t80 = t13**2
      t83 = t6**2
      t84 = t83**2
      t94 = 1/t3*t76
      t100 = 0.1D1*t5/t80*(-0.1853395810515781D1/t84/t6*t76
     #-0.128158207914907D1*t77-0.8223668877838045D0/t9*t76
     #-0.1603914194192128D0*t94)/t16
      t103 = 1/t21/t20/rhob
      t106 = t79+t100
      t108 = t35*t106*t27
      t111 = t32*rhob
      t113 = 1/t33/t111
      t119 = t47**2
      t121 = t38/t119
      t122 = t43*sigmabb
      t140 = 1/t51
      t148 = t60**2
      vrhob(i) = -t19+t53+t73+rhob*(t79+t100+0.1236778371778789D-1*
     #(0.2697586091519874D1*(-0.2350821599607352D0*sigmabb*t103
     #+0.2213957124623647D1*t44*t108-0.1277814667630705D0*t31*t113)
     #*t48-0.2697586091519874D1*t121*(0.2197487022544806D2*t122*t23
     #*t106*t27-0.6341543650745294D0*t39*t103+0.1194467989321217D2/t42
     #/t28*t30*t108-0.3447015074940681D0*t44*t113))*t140
     #+0.7937005259840997D0*(0.1D-2*(-0.4811024840421814D1*t77
     #-0.1895695887660258D-2*t94)*t61-0.1D-2*t56/t148*(
     #-0.1803772444038489D1*t77-0.1210946621972718D0*t94
     #-0.1763993811759022D-1*t76))*sigmabb*t71-0.1851967893962899D1
     #*t65*t103*t70+0.3482823064697813D1*t64*t30/t32/t20*t70)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = rhob*(0.1236778371778789D-1*(0.2697586091519874D1*
     #(0.1007494971260294D0*t23+0.5476348575560166D-1*t39*t35)*t48
     #-0.2697586091519874D1*t121*(0.2717804421747983D0*t29*t23
     #+0.1477292174974578D0*t122*t35))*t140+0.7937005259840997D0*t64
     #*t23*t70-0.130605864926168D1*t65/t111*t70)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = 1/rhoa
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1274696188700087D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.1112037486309468D2*t6+0.3844746237447211D1*t3
     #+0.1644733775567609D1*t9+0.2405871291288192D0*t11
      t16 = 1.D0+0.321646831778707D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.3109D-1*t18
      t20 = rhoa**2
      t21 = rhoa**(1.D0/3.D0)
      t23 = 1/t21/t20
      t27 = dexp(0.2513789108010112D1*t18)
      t28 = t27-1.D0
      t29 = 1/t28
      t30 = sigmaaa**2
      t31 = t29*t30
      t32 = t20**2
      t33 = t21**2
      t35 = 1/t33/t32
      t38 = 0.1007494971260294D0*sigmaaa*t23+0.2738174287780083D-1*t31
     #*t35
      t39 = t29*sigmaaa
      t42 = t28**2
      t43 = 1/t42
      t44 = t43*t30
      t47 = 1.D0+0.2717804421747983D0*t39*t23+0.7386460874872889D-1
     #*t44*t35
      t48 = 1/t47
      t51 = 1.D0+0.2697586091519874D1*t38*t48
      t52 = dlog(t51)
      t53 = 0.1236778371778789D-1*t52
      t56 = 0.2568D1+0.1443307452126544D2*t3+0.2843543831490386D-2*t11
      t60 = 1.D0+0.5411317332115466D1*t3+0.1816419932959077D0*t11
     #+0.1763993811759022D-1*t2
      t61 = 1/t60
      t64 = 0.1D-2*t56*t61-0.1853571428571429D-2
      t65 = t64*sigmaaa
      t70 = dexp(-0.1645530784602056D1/t33/t20*sigmaaa)
      t71 = t23*t70
      t73 = 0.7937005259840997D0*t65*t71
      zk(i) = rhoa*(-t19+t53+t73)
      t76 = 1/t20
      t77 = 1/t11*t76
      t79 = 0.1321010150222857D-2*t77*t17
      t80 = t13**2
      t83 = t6**2
      t84 = t83**2
      t94 = 1/t3*t76
      t100 = 0.1D1*t5/t80*(-0.1853395810515781D1/t84/t6*t76
     #-0.128158207914907D1*t77-0.8223668877838045D0/t9*t76
     #-0.1603914194192128D0*t94)/t16
      t103 = 1/t21/t20/rhoa
      t106 = t79+t100
      t108 = t35*t106*t27
      t111 = t32*rhoa
      t113 = 1/t33/t111
      t119 = t47**2
      t121 = t38/t119
      t122 = t43*sigmaaa
      t140 = 1/t51
      t148 = t60**2
      vrhoa(i) = -t19+t53+t73+rhoa*(t79+t100+0.1236778371778789D-1*
     #(0.2697586091519874D1*(-0.2350821599607352D0*sigmaaa*t103
     #+0.2213957124623647D1*t44*t108-0.1277814667630705D0*t31*t113)
     #*t48-0.2697586091519874D1*t121*(0.2197487022544806D2*t122*t23
     #*t106*t27-0.6341543650745294D0*t39*t103+0.1194467989321217D2/t42
     #/t28*t30*t108-0.3447015074940681D0*t44*t113))*t140
     #+0.7937005259840997D0*(0.1D-2*(-0.4811024840421814D1*t77
     #-0.1895695887660258D-2*t94)*t61-0.1D-2*t56/t148*(
     #-0.1803772444038489D1*t77-0.1210946621972718D0*t94
     #-0.1763993811759022D-1*t76))*sigmaaa*t71-0.1851967893962899D1
     #*t65*t103*t70+0.3482823064697813D1*t64*t30/t32/t20*t70)
      vrhob(i) = 0.D0
      vsigmaaa(i) = rhoa*(0.1236778371778789D-1*(0.2697586091519874D1*
     #(0.1007494971260294D0*t23+0.5476348575560166D-1*t39*t35)*t48
     #-0.2697586091519874D1*t121*(0.2717804421747983D0*t29*t23
     #+0.1477292174974578D0*t122*t35))*t140+0.7937005259840997D0*t64
     #*t23*t70-0.130605864926168D1*t65/t111*t70)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = 1/rho
      t5 = t4**(1.D0/3.D0)
      t7 = 1.D0+0.1325688999052018D0*t5
      t8 = t4**(1.D0/6.D0)
      t11 = dsqrt(t4)
      t13 = t5**2
      t15 = 0.598255043577108D1*t8+0.2225569421150687D1*t5
     #+0.8004286349993634D0*t11+0.1897004325747559D0*t13
      t18 = 1.D0+0.160818243221511D2/t15
      t19 = dlog(t18)
      t21 = 0.62182D-1*t7*t19
      t23 = 1.D0+0.6901399211255825D-1*t5
      t28 = 0.8157414703487641D1*t8+0.2247591863577616D1*t5
     #+0.4300972471276643D0*t11+0.1911512595127338D0*t13
      t31 = 1.D0+0.2960857464321668D2/t28
      t32 = dlog(t31)
      t33 = t23*t32
      t35 = rhoa-1.D0*rhob
      t36 = t35*t4
      t37 = 1.D0+t36
      t38 = t37**(1.D0/3.D0)
      t41 = 1.D0-1.D0*t36
      t42 = t41**(1.D0/3.D0)
      t44 = t38*t37+t42*t41-2.D0
      t45 = t35**2
      t46 = t45**2
      t47 = rho**2
      t48 = t47**2
      t49 = 1/t48
      t50 = t46*t49
      t52 = 1.D0-1.D0*t50
      t55 = 0.3799575D-1*t33*t44*t52
      t57 = 1.D0+0.1274696188700087D0*t5
      t62 = 0.1112037486309468D2*t8+0.3844746237447211D1*t5
     #+0.1644733775567609D1*t11+0.2405871291288192D0*t13
      t65 = 1.D0+0.321646831778707D2/t62
      t66 = dlog(t65)
      t69 = -0.3109D-1*t57*t66+t21
      t70 = t69*t44
      t72 = 0.1923661050931536D1*t70*t50
      t73 = t38**2
      t75 = t42**2
      t77 = 0.5D0*t73+0.5D0*t75
      t78 = t77**2
      t79 = t78*t77
      t80 = 1/t78
      t81 = sigma*t80
      t82 = rho**(1.D0/3.D0)
      t84 = 1/t82/t47
      t87 = -t21+t55+t72
      t88 = 1/t79
      t91 = dexp(-0.4042761511756372D2*t87*t88)
      t92 = t91-1.D0
      t93 = 1/t92
      t94 = sigma**2
      t95 = t93*t94
      t96 = t78**2
      t97 = 1/t96
      t98 = t82**2
      t100 = 1/t98/t48
      t101 = t97*t100
      t104 = 0.634682060977037D-1*t81*t84+0.1086645186223595D-1*t95*t101
      t105 = t93*sigma
      t106 = t80*t84
      t109 = t92**2
      t110 = 1/t109
      t111 = t110*t94
      t114 = 1.D0+0.1712109500228824D0*t105*t106+0.2931318940773793D-1
     #*t111*t101
      t115 = 1/t114
      t118 = 1.D0+0.2697586091519874D1*t104*t115
      t119 = dlog(t118)
      t121 = 0.2473556743557577D-1*t79*t119
      t124 = 0.2568D1+0.1443307452126544D2*t5+0.2843543831490386D-2*t13
      t128 = 1.D0+0.5411317332115466D1*t5+0.1816419932959077D0*t13
     #+0.1763993811759022D-1*t4
      t129 = 1/t128
      t132 = 0.1D-2*t124*t129-0.1853571428571429D-2
      t133 = t132*t77
      t136 = 1/t98/t47
      t140 = dexp(-0.261211729852336D1*t78*t136*sigma)
      t141 = sigma*t84*t140
      t143 = 0.1D1*t133*t141
      zk(i) = rho*(-t21+t55+t72+t121+t143)
      t149 = 0.1333333333333333D1*t38*t4-0.1333333333333333D1*t42*t4
      t152 = 0.3799575D-1*t33*t149*t52
      t153 = t45*t35
      t156 = t33*t44*t153*t49
      t157 = 0.151983D0*t156
      t160 = 0.1923661050931536D1*t69*t149*t50
      t162 = t70*t153*t49
      t163 = 0.7694644203726145D1*t162
      t164 = t78*t119
      t165 = 1/t38
      t168 = 1/t42
      t171 = 0.3333333333333333D0*t165*t4-0.3333333333333333D0*t168*t4
      t174 = sigma*t88
      t178 = t111*t97
      t182 = t87*t97
      t185 = -0.4042761511756372D2*(t152-t157+t160+t163)*t88
     #+0.1212828453526912D3*t182*t171
      t187 = t100*t185*t91
      t192 = 1/t96/t77*t100
      t193 = t192*t171
      t199 = t114**2
      t201 = t104/t199
      t202 = t110*sigma
      t203 = t202*t80
      t208 = t88*t84
      t215 = 1/t109/t92*t94*t97
      t225 = 1/t118
      t232 = t132*t78*t94
      t233 = t48*rho
      t234 = 1/t233
      t242 = 1/t47
      t243 = 1/t13*t242
      t244 = t243*t19
      t245 = 0.2747799777968419D-2*t244
      t246 = t15**2
      t249 = t8**2
      t250 = t249**2
      t253 = 1/t250/t8*t242
      t257 = 1/t11*t242
      t260 = 1/t5*t242
      t265 = t7/t246*(-0.99709173929518D0*t253-0.7418564737168958D0
     #*t243-0.4002143174996817D0*t257-0.1264669550498372D0*t260)/t18
      t266 = 0.1D1*t265
      t270 = 0.8740794636035784D-3*t243*t32*t44*t52
      t271 = t28**2
      t284 = 0.1125D1*t23/t271*(-0.135956911724794D1*t253
     #-0.7491972878592054D0*t243-0.2150486235638321D0*t257
     #-0.1274341730084892D0*t260)/t31*t44*t52
      t291 = -0.1333333333333333D1*t38*t35*t242+0.1333333333333333D1
     #*t42*t35*t242
      t294 = 0.3799575D-1*t33*t291*t52
      t298 = 0.151983D0*t33*t44*t46*t234
      t301 = t62**2
      t318 = 0.1923661050931536D1*(0.1321010150222857D-2*t243*t66
     #+0.1D1*t57/t301*(-0.1853395810515781D1*t253-0.128158207914907D1
     #*t243-0.8223668877838045D0*t257-0.1603914194192128D0*t260)/t65
     #-0.2747799777968419D-2*t244-0.1D1*t265)*t44*t50
      t321 = 0.1923661050931536D1*t69*t291*t50
      t324 = 0.7694644203726145D1*t70*t46*t234
      t331 = -0.3333333333333333D0*t165*t35*t242+0.3333333333333333D0
     #*t168*t35*t242
      t337 = t47*rho
      t339 = 1/t82/t337
      t347 = -0.4042761511756372D2*(t245+t266-t270-t284+t294+t298+t318
     #+t321-t324)*t88+0.1212828453526912D3*t182*t331
      t349 = t100*t347*t91
      t352 = t192*t331
      t357 = t97/t98/t233
      t391 = t128**2
      s1 = t245+t266-t270-t284+t294+t298+t318
      s2 = s1+t321-t324+0.7420670230672731D-1*t164*t331
      s3 = s2+0.2473556743557577D-1*t79*(0.2697586091519874D1*(
     #-0.1269364121954074D0*t174*t84*t331-0.148092480894642D0*t81*t339
     #-0.1086645186223595D-1*t178*t349-0.4346580744894379D-1*t95*t352
     #-0.5071010869043442D-1*t95*t357)*t115-0.2697586091519874D1*t201*
     #(-0.1712109500228824D0*t203*t84*t347*t91-0.3424219000457648D0
     #*t105*t208*t331-0.3994922167200589D0*t105*t80*t339
     #-0.5862637881547585D-1*t215*t349-0.1172527576309517D0*t111*t352
     #-0.136794883902777D0*t111*t357))*t225+0.1D1*(0.1D-2*(
     #-0.4811024840421814D1*t243-0.1895695887660258D-2*t260)*t129
     #-0.1D-2*t124/t391*(-0.1803772444038489D1*t243
     #-0.1210946621972718D0*t260-0.1763993811759022D-1*t242))*t77*t141
      t426 = s3+0.1D1*t132*t331*t141-0.2333333333333333D1*t133*sigma
     #*t339*t140+0.1D1*t133*sigma*t84*(-0.522423459704672D1*t77*t136
     #*sigma*t331+0.6965646129395627D1*t78/t98/t337*sigma)*t140
      t427 = rho*t426
      vrhoa(i) = rho*(t152-t157+t160+t163+0.7420670230672731D-1*t164
     #*t171+0.2473556743557577D-1*t79*(0.2697586091519874D1*(
     #-0.1269364121954074D0*t174*t84*t171-0.1086645186223595D-1*t178
     #*t187-0.4346580744894379D-1*t95*t193)*t115-0.2697586091519874D1
     #*t201*(-0.1712109500228824D0*t203*t84*t185*t91
     #-0.3424219000457648D0*t105*t208*t171-0.5862637881547585D-1*t215
     #*t187-0.1172527576309517D0*t111*t193))*t225+0.1D1*t132*t171*t141
     #-0.522423459704672D1*t232*t234*t171*t140)-t21+t55+t72+t121+t143
     #+t427
      t428 = -t149
      t431 = 0.3799575D-1*t33*t428*t52
      t432 = 0.151983D0*t156
      t435 = 0.1923661050931536D1*t69*t428*t50
      t436 = 0.7694644203726145D1*t162
      t437 = -t171
      t448 = -0.4042761511756372D2*(t431+t432+t435-t436)*t88
     #+0.1212828453526912D3*t182*t437
      t450 = t100*t448*t91
      t453 = t192*t437
      vrhob(i) = rho*(t431+t432+t435-t436+0.7420670230672731D-1*t164
     #*t437+0.2473556743557577D-1*t79*(0.2697586091519874D1*(
     #-0.1269364121954074D0*t174*t84*t437-0.1086645186223595D-1*t178
     #*t450-0.4346580744894379D-1*t95*t453)*t115-0.2697586091519874D1
     #*t201*(-0.1712109500228824D0*t203*t84*t448*t91
     #-0.3424219000457648D0*t105*t208*t437-0.5862637881547585D-1*t215
     #*t450-0.1172527576309517D0*t111*t453))*t225+0.1D1*t132*t437*t141
     #-0.522423459704672D1*t232*t234*t437*t140)-t21+t55+t72+t121+t143
     #+t427
      vsigmaaa(i) = rho*(0.2473556743557577D-1*t79*
     #(0.2697586091519874D1*(0.634682060977037D-1*t106
     #+0.2173290372447189D-1*t105*t101)*t115-0.2697586091519874D1*t201
     #*(0.1712109500228824D0*t93*t80*t84+0.5862637881547585D-1*t202
     #*t101))*t225+0.1D1*t133*t84*t140-0.261211729852336D1*t132*t79
     #*sigma*t234*t140)
      vsigmaab(i) = 2.D0*vsigmaaa(i)
      vsigmabb(i) = vsigmaaa(i)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = 1/rhob
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1274696188700087D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.1112037486309468D2*t6+0.3844746237447211D1*t3
     #+0.1644733775567609D1*t9+0.2405871291288192D0*t11
      t16 = 1.D0+0.321646831778707D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.3109D-1*t18
      t20 = rhob**2
      t21 = rhob**(1.D0/3.D0)
      t23 = 1/t21/t20
      t27 = dexp(0.2513789108010112D1*t18)
      t28 = t27-1.D0
      t29 = 1/t28
      t30 = sigmabb**2
      t31 = t29*t30
      t32 = t20**2
      t33 = t21**2
      t35 = 1/t33/t32
      t38 = 0.1007494971260294D0*sigmabb*t23+0.2738174287780083D-1*t31
     #*t35
      t39 = t29*sigmabb
      t42 = t28**2
      t43 = 1/t42
      t44 = t43*t30
      t47 = 1.D0+0.2717804421747983D0*t39*t23+0.7386460874872889D-1
     #*t44*t35
      t48 = 1/t47
      t51 = 1.D0+0.2697586091519874D1*t38*t48
      t52 = dlog(t51)
      t53 = 0.1236778371778789D-1*t52
      t56 = 0.2568D1+0.1443307452126544D2*t3+0.2843543831490386D-2*t11
      t60 = 1.D0+0.5411317332115466D1*t3+0.1816419932959077D0*t11
     #+0.1763993811759022D-1*t2
      t61 = 1/t60
      t64 = 0.1D-2*t56*t61-0.1853571428571429D-2
      t65 = t64*sigmabb
      t70 = dexp(-0.1645530784602056D1/t33/t20*sigmabb)
      t71 = t23*t70
      t73 = 0.7937005259840997D0*t65*t71
      zk(i) = rhob*(-t19+t53+t73)
      vrhoa(i) = 0.D0
      t75 = 1/t11
      t76 = 1/t20
      t77 = t75*t76
      t78 = t77*t17
      t79 = 0.1321010150222857D-2*t78
      t80 = t13**2
      t81 = 1/t80
      t82 = t5*t81
      t83 = t6**2
      t84 = t83**2
      t85 = t84*t6
      t86 = 1/t85
      t90 = 1/t9
      t93 = 1/t3
      t94 = t93*t76
      t96 = -0.1853395810515781D1*t86*t76-0.128158207914907D1*t77
     #-0.8223668877838045D0*t90*t76-0.1603914194192128D0*t94
      t97 = 1/t16
      t99 = t82*t96*t97
      t100 = 0.1D1*t99
      t101 = t20*rhob
      t103 = 1/t21/t101
      t106 = t79+t100
      t108 = t35*t106*t27
      t111 = t32*rhob
      t113 = 1/t33/t111
      t116 = -0.2350821599607352D0*sigmabb*t103+0.2213957124623647D1
     #*t44*t108-0.1277814667630705D0*t31*t113
      t119 = t47**2
      t120 = 1/t119
      t121 = t38*t120
      t122 = t43*sigmabb
      t130 = 1/t42/t28
      t131 = t130*t30
      t136 = 0.2197487022544806D2*t122*t23*t106*t27
     #-0.6341543650745294D0*t39*t103+0.1194467989321217D2*t131*t108
     #-0.3447015074940681D0*t44*t113
      t139 = 0.2697586091519874D1*t116*t48-0.2697586091519874D1*t121
     #*t136
      t140 = 1/t51
      t141 = t139*t140
      t145 = -0.4811024840421814D1*t77-0.1895695887660258D-2*t94
      t148 = t60**2
      t149 = 1/t148
      t150 = t56*t149
      t154 = -0.1803772444038489D1*t77-0.1210946621972718D0*t94
     #-0.1763993811759022D-1*t76
      t157 = 0.1D-2*t145*t61-0.1D-2*t150*t154
      t158 = t157*sigmabb
      t159 = t158*t71
      t161 = t103*t70
      t162 = t65*t161
      t164 = t64*t30
      t165 = t32*t20
      t167 = 1/t165*t70
      t168 = t164*t167
      vrhob(i) = -t19+t53+t73+rhob*(t79+t100+0.1236778371778789D-1
     #*t141+0.7937005259840997D0*t159-0.1851967893962899D1*t162
     #+0.3482823064697813D1*t168)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t175 = 0.1007494971260294D0*t23+0.5476348575560166D-1*t39*t35
      t182 = 0.2717804421747983D0*t29*t23+0.1477292174974578D0*t122*t35
      t185 = 0.2697586091519874D1*t175*t48-0.2697586091519874D1*t121
     #*t182
      t191 = 1/t111
      vsigmabb(i) = rhob*(0.1236778371778789D-1*t185*t140
     #+0.7937005259840997D0*t64*t23*t70-0.130605864926168D1*t65*t191
     #*t70)
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t204 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t6
     #+0.2225569421150687D1*t3+0.8004286349993634D0*t9
     #+0.1897004325747559D0*t11))
      t214 = 1/t21/t32
      t217 = t106**2
      t218 = t35*t217
      t220 = dexp(0.5027578216020225D1*t18)
      t221 = t218*t220
      t225 = t113*t106*t27
      t228 = 1/t101
      t229 = t75*t228
      t231 = 0.1D-22*t229*t204
      t234 = 1/t32
      t235 = 1/t11/t2*t234
      t237 = 0.8806734334819047D-3*t235*t17
      t239 = 0.2642020300445714D-2*t229*t17
      t243 = 0.8497974591333914D-1*t77*t81*t96*t97
      t247 = t96**2
      t250 = 0.2D1*t5/t80/t13*t247*t97
      t267 = 1/t3/t2*t234
      t269 = t93*t228
      t274 = 0.1D1*t82*(-0.1544496508763151D1/t85/t2*t234
     #+0.3706791621031562D1*t86*t228-0.854388052766047D0*t235
     #+0.2563164158298141D1*t229-0.4111834438919023D0/t9/t2*t234
     #+0.1644733775567609D1*t90*t228-0.5346380647307093D-1*t267
     #+0.3207828388384256D0*t269)*t97
      t275 = t80**2
      t278 = t16**2
      t282 = 0.321646831778707D2*t5/t275*t247/t278
      t283 = -t231+t237-t239-t243-t250+t274+t282
      t285 = t35*t283*t27
      t288 = t218*t27
      t292 = 1/t33/t165
      t303 = t38/t119/t47
      t304 = t136**2
      t308 = t23*t217
      t325 = t42**2
      t344 = t139**2
      t345 = t51**2
      t346 = 1/t345
      t362 = t154**2
      t379 = t32**2
      t386 = t32*t101
      s3 = 0.1236778371778789D-1*(0.2697586091519874D1*
     #(0.7836071998691172D0*sigmabb*t214+0.3580200260842915D3*t131
     #*t221-0.2066359982982071D2*t44*t225+0.2213957124623647D1*t44
     #*t285-0.1790100130421458D3*t44*t288+0.7240949783240664D0*t31
     #*t292)*t48-0.5395172183039748D1*t116*t120*t136
     #+0.5395172183039748D1*t303*t304-0.2697586091519874D1*t121*
     #(0.35535663829313D4*t130*sigmabb*t308*t220-0.1025493943854243D3
     #*t122*t103*t106*t27+0.2197487022544806D2*t122*t23*t283*t27
     #-0.177678319146565D4*t122*t308*t27+0.2113847883581765D1*t39*t214
     #+0.2897369528551702D4/t325*t30*t221-0.1114836790033136D3*t131
     #*t225+0.1194467989321217D2*t131*t285-0.9657898428505673D3*t131
     #*t288+0.1953308542466386D1*t44*t292))*t140
      s4 = -0.1236778371778789D-1*t344*t346+0.7937005259840997D0*
     #(0.1D-2*(-0.3207349893614542D1*t235+0.9622049680843627D1*t229
     #-0.6318986292200858D-3*t267+0.3791391775320515D-2*t269)*t61
     #-0.2D-2*t145*t149*t154+0.2D-2*t56/t148/t60*t362-0.1D-2*t150*(
     #-0.1202514962692326D1*t235+0.3607544888076978D1*t229
     #-0.4036488739909061D-1*t267+0.2421893243945437D0*t269
     #+0.3527987623518044D-1*t228))*sigmabb*t71
      s2 = s3+s4
      s1 = s2+0.1528291352075288D2*t64*t30*sigmabb/t33/t379/rhob*t70
     #-0.2902352553914844D2*t164/t386*t70+0.6173226313209665D1*t65
     #*t214*t70-0.3703935787925799D1*t158*t161
      t399 = s1+0.6965646129395627D1*t157*t30*t167-t231-t250+t274+t282
     #+t237-t239-t243
      v2rhob2(i) = -0.1D-22*t77*t204+0.2642020300445714D-2*t78+0.2D1
     #*t99+0.2473556743557577D-1*t141+0.1587401051968199D1*t159
     #-0.3703935787925799D1*t162+0.6965646129395627D1*t168+rhob*t399
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t407 = t182**2
      t416 = t185**2
      v2sigmabb2(i) = rhob*(0.1236778371778789D-1*
     #(0.1477292174974578D0*t29*t35*t48-0.5395172183039748D1*t175*t120
     #*t182+0.5395172183039748D1*t303*t407-0.3985122824322565D0*t121
     #*t43*t35)*t140-0.1236778371778789D-1*t416*t346
     #-0.261211729852336D1*t64*t191*t70+0.2149159713855873D1*t65/t33
     #/t386*t70)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = 1/rhoa
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1274696188700087D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.1112037486309468D2*t6+0.3844746237447211D1*t3
     #+0.1644733775567609D1*t9+0.2405871291288192D0*t11
      t16 = 1.D0+0.321646831778707D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.3109D-1*t18
      t20 = rhoa**2
      t21 = rhoa**(1.D0/3.D0)
      t23 = 1/t21/t20
      t27 = dexp(0.2513789108010112D1*t18)
      t28 = t27-1.D0
      t29 = 1/t28
      t30 = sigmaaa**2
      t31 = t29*t30
      t32 = t20**2
      t33 = t21**2
      t35 = 1/t33/t32
      t38 = 0.1007494971260294D0*sigmaaa*t23+0.2738174287780083D-1*t31
     #*t35
      t39 = t29*sigmaaa
      t42 = t28**2
      t43 = 1/t42
      t44 = t43*t30
      t47 = 1.D0+0.2717804421747983D0*t39*t23+0.7386460874872889D-1
     #*t44*t35
      t48 = 1/t47
      t51 = 1.D0+0.2697586091519874D1*t38*t48
      t52 = dlog(t51)
      t53 = 0.1236778371778789D-1*t52
      t56 = 0.2568D1+0.1443307452126544D2*t3+0.2843543831490386D-2*t11
      t60 = 1.D0+0.5411317332115466D1*t3+0.1816419932959077D0*t11
     #+0.1763993811759022D-1*t2
      t61 = 1/t60
      t64 = 0.1D-2*t56*t61-0.1853571428571429D-2
      t65 = t64*sigmaaa
      t70 = dexp(-0.1645530784602056D1/t33/t20*sigmaaa)
      t71 = t23*t70
      t73 = 0.7937005259840997D0*t65*t71
      zk(i) = rhoa*(-t19+t53+t73)
      t75 = 1/t11
      t76 = 1/t20
      t77 = t75*t76
      t78 = t77*t17
      t79 = 0.1321010150222857D-2*t78
      t80 = t13**2
      t81 = 1/t80
      t82 = t5*t81
      t83 = t6**2
      t84 = t83**2
      t85 = t84*t6
      t86 = 1/t85
      t90 = 1/t9
      t93 = 1/t3
      t94 = t93*t76
      t96 = -0.1853395810515781D1*t86*t76-0.128158207914907D1*t77
     #-0.8223668877838045D0*t90*t76-0.1603914194192128D0*t94
      t97 = 1/t16
      t99 = t82*t96*t97
      t100 = 0.1D1*t99
      t101 = t20*rhoa
      t103 = 1/t21/t101
      t106 = t79+t100
      t108 = t35*t106*t27
      t111 = t32*rhoa
      t113 = 1/t33/t111
      t116 = -0.2350821599607352D0*sigmaaa*t103+0.2213957124623647D1
     #*t44*t108-0.1277814667630705D0*t31*t113
      t119 = t47**2
      t120 = 1/t119
      t121 = t38*t120
      t122 = t43*sigmaaa
      t130 = 1/t42/t28
      t131 = t130*t30
      t136 = 0.2197487022544806D2*t122*t23*t106*t27
     #-0.6341543650745294D0*t39*t103+0.1194467989321217D2*t131*t108
     #-0.3447015074940681D0*t44*t113
      t139 = 0.2697586091519874D1*t116*t48-0.2697586091519874D1*t121
     #*t136
      t140 = 1/t51
      t141 = t139*t140
      t145 = -0.4811024840421814D1*t77-0.1895695887660258D-2*t94
      t148 = t60**2
      t149 = 1/t148
      t150 = t56*t149
      t154 = -0.1803772444038489D1*t77-0.1210946621972718D0*t94
     #-0.1763993811759022D-1*t76
      t157 = 0.1D-2*t145*t61-0.1D-2*t150*t154
      t158 = t157*sigmaaa
      t159 = t158*t71
      t161 = t103*t70
      t162 = t65*t161
      t164 = t64*t30
      t165 = t32*t20
      t167 = 1/t165*t70
      t168 = t164*t167
      vrhoa(i) = -t19+t53+t73+rhoa*(t79+t100+0.1236778371778789D-1
     #*t141+0.7937005259840997D0*t159-0.1851967893962899D1*t162
     #+0.3482823064697813D1*t168)
      vrhob(i) = 0.D0
      t175 = 0.1007494971260294D0*t23+0.5476348575560166D-1*t39*t35
      t182 = 0.2717804421747983D0*t29*t23+0.1477292174974578D0*t122*t35
      t185 = 0.2697586091519874D1*t175*t48-0.2697586091519874D1*t121
     #*t182
      t191 = 1/t111
      vsigmaaa(i) = rhoa*(0.1236778371778789D-1*t185*t140
     #+0.7937005259840997D0*t64*t23*t70-0.130605864926168D1*t65*t191
     #*t70)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t204 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t6
     #+0.2225569421150687D1*t3+0.8004286349993634D0*t9
     #+0.1897004325747559D0*t11))
      t214 = 1/t21/t32
      t217 = t106**2
      t218 = t35*t217
      t220 = dexp(0.5027578216020225D1*t18)
      t221 = t218*t220
      t225 = t113*t106*t27
      t228 = 1/t101
      t229 = t75*t228
      t231 = 0.1D-22*t229*t204
      t234 = 1/t32
      t235 = 1/t11/t2*t234
      t237 = 0.8806734334819047D-3*t235*t17
      t239 = 0.2642020300445714D-2*t229*t17
      t243 = 0.8497974591333914D-1*t77*t81*t96*t97
      t247 = t96**2
      t250 = 0.2D1*t5/t80/t13*t247*t97
      t267 = 1/t3/t2*t234
      t269 = t93*t228
      t274 = 0.1D1*t82*(-0.1544496508763151D1/t85/t2*t234
     #+0.3706791621031562D1*t86*t228-0.854388052766047D0*t235
     #+0.2563164158298141D1*t229-0.4111834438919023D0/t9/t2*t234
     #+0.1644733775567609D1*t90*t228-0.5346380647307093D-1*t267
     #+0.3207828388384256D0*t269)*t97
      t275 = t80**2
      t278 = t16**2
      t282 = 0.321646831778707D2*t5/t275*t247/t278
      t283 = -t231+t237-t239-t243-t250+t274+t282
      t285 = t35*t283*t27
      t288 = t218*t27
      t292 = 1/t33/t165
      t303 = t38/t119/t47
      t304 = t136**2
      t308 = t23*t217
      t325 = t42**2
      t344 = t139**2
      t345 = t51**2
      t346 = 1/t345
      t362 = t154**2
      t379 = t32**2
      t386 = t32*t101
      s3 = 0.1236778371778789D-1*(0.2697586091519874D1*
     #(0.7836071998691172D0*sigmaaa*t214+0.3580200260842915D3*t131
     #*t221-0.2066359982982071D2*t44*t225+0.2213957124623647D1*t44
     #*t285-0.1790100130421458D3*t44*t288+0.7240949783240664D0*t31
     #*t292)*t48-0.5395172183039748D1*t116*t120*t136
     #+0.5395172183039748D1*t303*t304-0.2697586091519874D1*t121*
     #(0.35535663829313D4*t130*sigmaaa*t308*t220-0.1025493943854243D3
     #*t122*t103*t106*t27+0.2197487022544806D2*t122*t23*t283*t27
     #-0.177678319146565D4*t122*t308*t27+0.2113847883581765D1*t39*t214
     #+0.2897369528551702D4/t325*t30*t221-0.1114836790033136D3*t131
     #*t225+0.1194467989321217D2*t131*t285-0.9657898428505673D3*t131
     #*t288+0.1953308542466386D1*t44*t292))*t140
      s4 = -0.1236778371778789D-1*t344*t346+0.7937005259840997D0*
     #(0.1D-2*(-0.3207349893614542D1*t235+0.9622049680843627D1*t229
     #-0.6318986292200858D-3*t267+0.3791391775320515D-2*t269)*t61
     #-0.2D-2*t145*t149*t154+0.2D-2*t56/t148/t60*t362-0.1D-2*t150*(
     #-0.1202514962692326D1*t235+0.3607544888076978D1*t229
     #-0.4036488739909061D-1*t267+0.2421893243945437D0*t269
     #+0.3527987623518044D-1*t228))*sigmaaa*t71
      s2 = s3+s4
      s1 = s2+0.1528291352075288D2*t64*t30*sigmaaa/t33/t379/rhoa*t70
     #-0.2902352553914844D2*t164/t386*t70+0.6173226313209665D1*t65
     #*t214*t70-0.3703935787925799D1*t158*t161
      t399 = s1+0.6965646129395627D1*t157*t30*t167-t231-t250+t274+t282
     #+t237-t239-t243
      v2rhoa2(i) = -0.1D-22*t77*t204+0.2642020300445714D-2*t78+0.2D1
     #*t99+0.2473556743557577D-1*t141+0.1587401051968199D1*t159
     #-0.3703935787925799D1*t162+0.6965646129395627D1*t168+rhoa*t399
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t407 = t182**2
      t416 = t185**2
      v2sigmaaa2(i) = rhoa*(0.1236778371778789D-1*
     #(0.1477292174974578D0*t29*t35*t48-0.5395172183039748D1*t175*t120
     #*t182+0.5395172183039748D1*t303*t407-0.3985122824322565D0*t121
     #*t43*t35)*t140-0.1236778371778789D-1*t416*t346
     #-0.261211729852336D1*t64*t191*t70+0.2149159713855873D1*t65/t33
     #/t386*t70)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = 1/rho
      t5 = t4**(1.D0/3.D0)
      t7 = 1.D0+0.1325688999052018D0*t5
      t8 = t4**(1.D0/6.D0)
      t11 = dsqrt(t4)
      t13 = t5**2
      t15 = 0.598255043577108D1*t8+0.2225569421150687D1*t5
     #+0.8004286349993634D0*t11+0.1897004325747559D0*t13
      t18 = 1.D0+0.160818243221511D2/t15
      t19 = dlog(t18)
      t21 = 0.62182D-1*t7*t19
      t23 = 1.D0+0.6901399211255825D-1*t5
      t28 = 0.8157414703487641D1*t8+0.2247591863577616D1*t5
     #+0.4300972471276643D0*t11+0.1911512595127338D0*t13
      t31 = 1.D0+0.2960857464321668D2/t28
      t32 = dlog(t31)
      t33 = t23*t32
      t35 = rhoa-1.D0*rhob
      t36 = t35*t4
      t37 = 1.D0+t36
      t38 = t37**(1.D0/3.D0)
      t39 = t38*t37
      t41 = 1.D0-1.D0*t36
      t42 = t41**(1.D0/3.D0)
      t43 = t42*t41
      t44 = t39+t43-2.D0
      t45 = t35**2
      t46 = t45**2
      t47 = rho**2
      t48 = t47**2
      t49 = 1/t48
      t50 = t46*t49
      t52 = 1.D0-1.D0*t50
      t53 = t44*t52
      t55 = 0.3799575D-1*t33*t53
      t57 = 1.D0+0.1274696188700087D0*t5
      t62 = 0.1112037486309468D2*t8+0.3844746237447211D1*t5
     #+0.1644733775567609D1*t11+0.2405871291288192D0*t13
      t65 = 1.D0+0.321646831778707D2/t62
      t66 = dlog(t65)
      t69 = -0.3109D-1*t57*t66+t21
      t70 = t69*t44
      t72 = 0.1923661050931536D1*t70*t50
      t73 = t38**2
      t75 = t42**2
      t77 = 0.5D0*t73+0.5D0*t75
      t78 = t77**2
      t79 = t78*t77
      t80 = 1/t78
      t81 = sigma*t80
      t82 = rho**(1.D0/3.D0)
      t84 = 1/t82/t47
      t87 = -t21+t55+t72
      t88 = 1/t79
      t89 = t87*t88
      t91 = dexp(-0.4042761511756372D2*t89)
      t92 = t91-1.D0
      t93 = 1/t92
      t94 = sigma**2
      t95 = t93*t94
      t96 = t78**2
      t97 = 1/t96
      t98 = t82**2
      t100 = 1/t98/t48
      t101 = t97*t100
      t104 = 0.634682060977037D-1*t81*t84+0.1086645186223595D-1*t95*t101
      t105 = t93*sigma
      t106 = t80*t84
      t109 = t92**2
      t110 = 1/t109
      t111 = t110*t94
      t114 = 1.D0+0.1712109500228824D0*t105*t106+0.2931318940773793D-1
     #*t111*t101
      t115 = 1/t114
      t118 = 1.D0+0.2697586091519874D1*t104*t115
      t119 = dlog(t118)
      t121 = 0.2473556743557577D-1*t79*t119
      t124 = 0.2568D1+0.1443307452126544D2*t5+0.2843543831490386D-2*t13
      t128 = 1.D0+0.5411317332115466D1*t5+0.1816419932959077D0*t13
     #+0.1763993811759022D-1*t4
      t129 = 1/t128
      t132 = 0.1D-2*t124*t129-0.1853571428571429D-2
      t133 = t132*t77
      t136 = 1/t98/t47
      t140 = dexp(-0.261211729852336D1*t78*t136*sigma)
      t141 = sigma*t84*t140
      t143 = 0.1D1*t133*t141
      zk(i) = rho*(-t21+t55+t72+t121+t143)
      t149 = 0.1333333333333333D1*t38*t4-0.1333333333333333D1*t42*t4
      t151 = t33*t149*t52
      t152 = 0.3799575D-1*t151
      t153 = t45*t35
      t154 = t44*t153
      t156 = t33*t154*t49
      t157 = 0.151983D0*t156
      t158 = t69*t149
      t159 = t158*t50
      t160 = 0.1923661050931536D1*t159
      t161 = t153*t49
      t162 = t70*t161
      t163 = 0.7694644203726145D1*t162
      t164 = t78*t119
      t165 = 1/t38
      t168 = 1/t42
      t171 = 0.3333333333333333D0*t165*t4-0.3333333333333333D0*t168*t4
      t172 = t164*t171
      t173 = 0.7420670230672731D-1*t172
      t174 = sigma*t88
      t175 = t84*t171
      t178 = t111*t97
      t179 = t152-t157+t160+t163
      t182 = t87*t97
      t185 = -0.4042761511756372D2*t179*t88+0.1212828453526912D3*t182
     #*t171
      t186 = t100*t185
      t187 = t186*t91
      t190 = t96*t77
      t191 = 1/t190
      t192 = t191*t100
      t193 = t192*t171
      t196 = -0.1269364121954074D0*t174*t175-0.1086645186223595D-1
     #*t178*t187-0.4346580744894379D-1*t95*t193
      t199 = t114**2
      t200 = 1/t199
      t201 = t104*t200
      t202 = t110*sigma
      t203 = t202*t80
      t204 = t84*t185
      t205 = t204*t91
      t208 = t88*t84
      t209 = t208*t171
      t213 = 1/t109/t92
      t214 = t213*t94
      t215 = t214*t97
      t220 = -0.1712109500228824D0*t203*t205-0.3424219000457648D0*t105
     #*t209-0.5862637881547585D-1*t215*t187-0.1172527576309517D0*t111
     #*t193
      t223 = 0.2697586091519874D1*t196*t115-0.2697586091519874D1*t201
     #*t220
      t224 = t79*t223
      t225 = 1/t118
      t226 = t224*t225
      t227 = 0.2473556743557577D-1*t226
      t228 = t132*t171
      t229 = t228*t141
      t230 = 0.1D1*t229
      t232 = t132*t78*t94
      t233 = t48*rho
      t234 = 1/t233
      t236 = t234*t171*t140
      t237 = t232*t236
      t238 = 0.522423459704672D1*t237
      t241 = 1/t13
      t242 = 1/t47
      t243 = t241*t242
      t244 = t243*t19
      t245 = 0.2747799777968419D-2*t244
      t246 = t15**2
      t247 = 1/t246
      t248 = t7*t247
      t249 = t8**2
      t250 = t249**2
      t251 = t250*t8
      t252 = 1/t251
      t253 = t252*t242
      t256 = 1/t11
      t257 = t256*t242
      t259 = 1/t5
      t260 = t259*t242
      t262 = -0.99709173929518D0*t253-0.7418564737168958D0*t243
     #-0.4002143174996817D0*t257-0.1264669550498372D0*t260
      t263 = 1/t18
      t265 = t248*t262*t263
      t266 = 0.1D1*t265
      t267 = t32*t44
      t268 = t267*t52
      t269 = t243*t268
      t270 = 0.8740794636035784D-3*t269
      t271 = t28**2
      t272 = 1/t271
      t273 = t23*t272
      t278 = -0.135956911724794D1*t253-0.7491972878592054D0*t243
     #-0.2150486235638321D0*t257-0.1274341730084892D0*t260
      t279 = t273*t278
      t280 = 1/t31
      t281 = t280*t44
      t282 = t281*t52
      t283 = t279*t282
      t284 = 0.1125D1*t283
      t285 = t38*t35
      t288 = t42*t35
      t291 = -0.1333333333333333D1*t285*t242+0.1333333333333333D1*t288
     #*t242
      t293 = t33*t291*t52
      t294 = 0.3799575D-1*t293
      t295 = t44*t46
      t297 = t33*t295*t234
      t298 = 0.151983D0*t297
      t301 = t62**2
      t302 = 1/t301
      t303 = t57*t302
      t308 = -0.1853395810515781D1*t253-0.128158207914907D1*t243
     #-0.8223668877838045D0*t257-0.1603914194192128D0*t260
      t309 = 1/t65
      t315 = 0.1321010150222857D-2*t243*t66+0.1D1*t303*t308*t309
     #-0.2747799777968419D-2*t244-0.1D1*t265
      t316 = t315*t44
      t317 = t316*t50
      t318 = 0.1923661050931536D1*t317
      t319 = t69*t291
      t320 = t319*t50
      t321 = 0.1923661050931536D1*t320
      t322 = t46*t234
      t323 = t70*t322
      t324 = 0.7694644203726145D1*t323
      t325 = t165*t35
      t328 = t168*t35
      t331 = -0.3333333333333333D0*t325*t242+0.3333333333333333D0*t328
     #*t242
      t332 = t164*t331
      t334 = t84*t331
      t337 = t47*rho
      t339 = 1/t82/t337
      t342 = t245+t266-t270-t284+t294+t298+t318+t321-t324
      t347 = -0.4042761511756372D2*t342*t88+0.1212828453526912D3*t182
     #*t331
      t348 = t100*t347
      t349 = t348*t91
      t352 = t192*t331
      t356 = 1/t98/t233
      t357 = t97*t356
      t360 = -0.1269364121954074D0*t174*t334-0.148092480894642D0*t81
     #*t339-0.1086645186223595D-1*t178*t349-0.4346580744894379D-1*t95
     #*t352-0.5071010869043442D-1*t95*t357
      t363 = t84*t347
      t364 = t363*t91
      t367 = t208*t331
      t370 = t80*t339
      t379 = -0.1712109500228824D0*t203*t364-0.3424219000457648D0*t105
     #*t367-0.3994922167200589D0*t105*t370-0.5862637881547585D-1*t215
     #*t349-0.1172527576309517D0*t111*t352-0.136794883902777D0*t111*t357
      t382 = 0.2697586091519874D1*t360*t115-0.2697586091519874D1*t201
     #*t379
      t383 = t79*t382
      t384 = t383*t225
      t388 = -0.4811024840421814D1*t243-0.1895695887660258D-2*t260
      t391 = t128**2
      t392 = 1/t391
      t393 = t124*t392
      t397 = -0.1803772444038489D1*t243-0.1210946621972718D0*t260
     #-0.1763993811759022D-1*t242
      t400 = 0.1D-2*t388*t129-0.1D-2*t393*t397
      t401 = t400*t77
      t402 = t401*t141
      t404 = t132*t331
      t405 = t404*t141
      t408 = sigma*t339*t140
      t409 = t133*t408
      t411 = t133*sigma
      t412 = t77*t136
      t413 = sigma*t331
      t417 = 1/t98/t337
      t418 = t78*t417
      t421 = -0.522423459704672D1*t412*t413+0.6965646129395627D1*t418
     #*sigma
      t423 = t84*t421*t140
      t424 = t411*t423
      t426 = t245+t266-t270-t284+t294+t298+t318+t321-t324
     #+0.7420670230672731D-1*t332+0.2473556743557577D-1*t384+0.1D1
     #*t402+0.1D1*t405-0.2333333333333333D1*t409+0.1D1*t424
      t427 = rho*t426
      vrhoa(i) = rho*(t152-t157+t160+t163+t173+t227+t230-t238)-t21+t55
     #+t72+t121+t143+t427
      t428 = -t149
      t430 = t33*t428*t52
      t431 = 0.3799575D-1*t430
      t432 = 0.151983D0*t156
      t433 = t69*t428
      t434 = t433*t50
      t435 = 0.1923661050931536D1*t434
      t436 = 0.7694644203726145D1*t162
      t437 = -t171
      t438 = t164*t437
      t439 = 0.7420670230672731D-1*t438
      t440 = t84*t437
      t443 = t431+t432+t435-t436
      t448 = -0.4042761511756372D2*t443*t88+0.1212828453526912D3*t182
     #*t437
      t449 = t100*t448
      t450 = t449*t91
      t453 = t192*t437
      t456 = -0.1269364121954074D0*t174*t440-0.1086645186223595D-1
     #*t178*t450-0.4346580744894379D-1*t95*t453
      t459 = t84*t448
      t460 = t459*t91
      t463 = t208*t437
      t470 = -0.1712109500228824D0*t203*t460-0.3424219000457648D0*t105
     #*t463-0.5862637881547585D-1*t215*t450-0.1172527576309517D0*t111
     #*t453
      t473 = 0.2697586091519874D1*t456*t115-0.2697586091519874D1*t201
     #*t470
      t474 = t79*t473
      t475 = t474*t225
      t476 = 0.2473556743557577D-1*t475
      t477 = t132*t437
      t478 = t477*t141
      t479 = 0.1D1*t478
      t481 = t234*t437*t140
      t482 = t232*t481
      t483 = 0.522423459704672D1*t482
      vrhob(i) = rho*(t431+t432+t435-t436+t439+t476+t479-t483)-t21+t55
     #+t72+t121+t143+t427
      t489 = 0.634682060977037D-1*t106+0.2173290372447189D-1*t105*t101
      t492 = t93*t80
      t497 = 0.1712109500228824D0*t492*t84+0.5862637881547585D-1*t202
     #*t101
      t500 = 0.2697586091519874D1*t489*t115-0.2697586091519874D1*t201
     #*t497
      t502 = t79*t500*t225
      t503 = 0.2473556743557577D-1*t502
      t504 = t84*t140
      t505 = t133*t504
      t506 = 0.1D1*t505
      t507 = t132*t79
      t509 = sigma*t234*t140
      t510 = t507*t509
      t511 = 0.261211729852336D1*t510
      vsigmaaa(i) = rho*(t503+t506-t511)
      vsigmaab(i) = 2.D0*vsigmaaa(i)
      vsigmabb(i) = vsigmaaa(i)
      t519 = 0.5495599555936838D-2*t244
      t520 = 0.2D1*t265
      t521 = 0.759915D-1*t293
      t522 = 0.3847322101863073D1*t317
      t523 = 0.3847322101863073D1*t320
      t524 = 0.1538928840745229D2*t323
      t526 = 0.759915D-1*t151+0.3847322101863073D1*t159
     #+0.1538928840745229D2*t162+0.1484134046134546D0*t172-0.303966D0
     #*t156+0.4947113487115154D-1*t226+t519+t520+t521+t522+t523-t524
     #+0.2D1*t229
      t528 = 0.1748158927207157D-2*t269
      t529 = 0.225D1*t283
      t530 = 0.1484134046134546D0*t332
      t531 = 0.303966D0*t297
      t532 = 0.4947113487115154D-1*t384
      t533 = 0.2D1*t402
      t534 = 0.2D1*t405
      t537 = 1/t13/t4*t49
      t539 = 1/t337
      t540 = t241*t539
      t544 = 1/t5/t4*t49
      t546 = t259*t539
      t557 = t397**2
      t577 = t421**2
      t583 = 1/t82/t48
      t590 = t331**2
      t594 = t77*t417
      t597 = 1/t39
      t603 = 1/t43
      t609 = -0.1111111111111111D0*t597*t45*t49+0.6666666666666667D0
     #*t325*t539-0.1111111111111111D0*t603*t45*t49
     #-0.6666666666666667D0*t328*t539
      t621 = t404*sigma
      t627 = t111*t191
      t628 = t91*t331
      t629 = t348*t628
      t633 = t356*t347*t91
      t636 = t537*t19
      t637 = 0.1831866518645613D-2*t636
      t638 = t540*t19
      t639 = 0.5495599555936838D-2*t638
      t642 = 0.9D1*t279*t281*t322
      t646 = 0.1748158927207157D-2*t243*t32*t291*t52
      t648 = 0.5827196424023856D-3*t537*t268
      t651 = t243*t247*t262*t263
      t652 = 0.8837926660346786D-1*t651
      t656 = t262**2
      t658 = t7/t246/t15*t656*t263
      t659 = 0.2D1*t658
      t662 = 1/t251/t4*t49
      t664 = t252*t539
      t670 = 1/t11/t4*t49
      t672 = t256*t539
      t678 = t248*(-0.8309097827459833D0*t662+0.199418347859036D1*t664
     #-0.4945709824779306D0*t537+0.1483712947433792D1*t540
     #-0.2001071587498409D0*t670+0.8004286349993634D0*t672
     #-0.4215565168327908D-1*t544+0.2529339100996745D0*t546)*t263
      t679 = 0.1D1*t678
      t680 = t246**2
      t683 = t18**2
      t686 = t7/t680*t656/t683
      t687 = 0.160818243221511D2*t686
      t699 = t308**2
      t715 = t301**2
      t718 = t65**2
      t729 = 0.8806734334819047D-3*t537*t66-0.2642020300445714D-2*t540
     #*t66-0.8497974591333914D-1*t243*t302*t308*t309-0.2D1*t57/t301
     #/t62*t699*t309+0.1D1*t303*(-0.1544496508763151D1*t662
     #+0.3706791621031562D1*t664-0.854388052766047D0*t537
     #+0.2563164158298141D1*t540-0.4111834438919023D0*t670
     #+0.1644733775567609D1*t672-0.5346380647307093D-1*t544
     #+0.3207828388384256D0*t546)*t309+0.321646831778707D2*t57/t715
     #*t699/t718-0.1831866518645613D-2*t636+0.5495599555936838D-2*t638
     #+0.8837926660346786D-1*t651+0.2D1*t658-0.1D1*t678
     #-0.160818243221511D2*t686
      t732 = 0.1923661050931536D1*t729*t44*t50
      t733 = 1/t73
      t739 = 1/t75
      t745 = 0.4444444444444444D0*t733*t45*t49+0.2666666666666667D1
     #*t285*t539+0.4444444444444444D0*t739*t45*t49
     #-0.2666666666666667D1*t288*t539
      t748 = 0.1923661050931536D1*t69*t745*t50
      t749 = t48*t47
      t750 = 1/t749
      t753 = 0.3847322101863073D2*t70*t46*t750
      t754 = t637-t639-t642-t646-t648-t652-t659+t679+t687+t732+t748+t753
      t757 = 0.3799575D-1*t33*t745*t52
      t759 = 0.1538928840745229D2*t319*t322
      t761 = 0.1538928840745229D2*t316*t322
      t764 = 0.3847322101863073D1*t315*t291*t50
      t765 = t271**2
      t768 = t278**2
      t770 = t31**2
      t775 = 0.3330964647361876D2*t23/t765*t768/t770*t44*t52
      t779 = 0.303966D0*t33*t291*t46*t234
      t785 = 0.225D1*t23/t271/t28*t768*t282
      t787 = 0.1748158927207157D-2*t540*t268
      t788 = t48*t337
      t793 = 0.6992635708828627D-2*t241/t788*t267*t46
      t798 = 0.5176049408441869D-1*t243*t272*t278*t280*t53
      t802 = 0.225D1*t279*t280*t291*t52
      t814 = 0.1125D1*t273*(-0.1132974264373283D1*t662
     #+0.271913823449588D1*t664-0.4994648585728036D0*t537
     #+0.1498394575718411D1*t540-0.1075243117819161D0*t670
     #+0.4300972471276643D0*t672-0.4247805766949639D-1*t544
     #+0.2548683460169784D0*t546)*t282
      t817 = 0.759915D0*t33*t295*t750
      t818 = t757-t759-t761+t764-t775+t779+t785+t787-t793+t798-t802
     #-t814-t817
      t822 = t342*t97
      t825 = t87*t191
      t830 = -0.4042761511756372D2*(t754+t818)*t88
     #+0.2425656907053823D3*t822*t331-0.4851313814107647D3*t825*t590
     #+0.1212828453526912D3*t182*t609
      t832 = t100*t830*t91
      t835 = sigma*t97
      t847 = t347**2
      t848 = t100*t847
      t850 = dexp(-0.8085523023512745D2*t89)
      t851 = t848*t850
      t854 = t848*t91
      t859 = t97/t98/t749
      t863 = 1/t96/t78
      t864 = t863*t100
      t865 = t864*t590
      t868 = t191*t356
      t869 = t868*t331
      t872 = t192*t609
      t875 = 0.8693161489788758D-1*t627*t629+0.1014202173808688D0*t178
     #*t633-0.1086645186223595D-1*t178*t832+0.3808092365862222D0*t835
     #*t84*t590+0.5923699235785679D0*t174*t339*t331
     #-0.1269364121954074D0*t174*t84*t609+0.4936416029821399D0*t81
     #*t583+0.2173290372447189D-1*t215*t851-0.1086645186223595D-1*t178
     #*t854+0.2873572825791284D0*t95*t859+0.2173290372447189D0*t95
     #*t865+0.4056808695234754D0*t95*t869-0.4346580744894379D-1*t95*t872
      t878 = t360*t200
      t883 = t104/t199/t114
      t884 = t379**2
      t891 = t202*t88
      t903 = t97*t84
      t907 = t88*t339
      t914 = t213*sigma
      t915 = t914*t80
      t916 = t84*t847
      t926 = t109**2
      t929 = 1/t926*t94*t97
      t932 = t214*t191
      t945 = 0.547179535611108D0*t215*t633+0.5862637881547585D0*t111
     #*t865+0.6848438000915295D0*t891*t363*t628-0.1712109500228824D0
     #*t203*t84*t830*t91+0.7989844334401178D0*t203*t339*t347*t91
     #+0.1027265700137294D1*t105*t903*t590+0.1597968866880236D1*t105
     #*t907*t331-0.3424219000457648D0*t105*t208*t609
     #+0.3424219000457648D0*t915*t916*t850+0.1331640722400196D1*t105
     #*t80*t583-0.1712109500228824D0*t203*t916*t91
     #+0.1758791364464276D0*t929*t851+0.4690110305238068D0*t932*t629
     #-0.5862637881547585D-1*t215*t854+0.7751710087824029D0*t111*t859
     #-0.5862637881547585D-1*t215*t832+0.1094359071222216D1*t111*t869
     #-0.1172527576309517D0*t111*t872
      t952 = t77*t119
      s2 = 0.1D1*(0.1D-2*(-0.3207349893614542D1*t537
     #+0.9622049680843627D1*t540-0.6318986292200858D-3*t544
     #+0.3791391775320515D-2*t546)*t129-0.2D-2*t388*t392*t397+0.2D-2
     #*t124/t391/t128*t557-0.1D-2*t393*(-0.1202514962692326D1*t537
     #+0.3607544888076978D1*t540-0.4036488739909061D-1*t544
     #+0.2421893243945437D0*t546+0.3527987623518044D-1*t539))*t77*t141
     #-0.4666666666666667D1*t401*t408+0.2D1*t400*t331*t141+0.1D1*t411
     #*t84*t577*t140+0.7777777777777778D1*t133*sigma*t583*t140
      s1 = s2-0.4666666666666667D1*t404*t408+0.1D1*t411*t84*(
     #-0.522423459704672D1*t590*t136*sigma+0.2786258451758251D2*t594
     #*t413-0.522423459704672D1*t412*sigma*t609-0.2554070247445063D2
     #*t78*t100*sigma)*t140+0.2D1*t621*t423+0.1D1*t132*t609*t141
     #+0.2473556743557577D-1*t79*(0.2697586091519874D1*t875*t115
     #-0.5395172183039748D1*t878*t379+0.5395172183039748D1*t883*t884
     #-0.2697586091519874D1*t201*t945)*t225
      t955 = s1+0.1484134046134546D0*t952*t590+t637-t639-t642-t646
     #-t648-t652-t659+t679+t687
      t956 = t382**2
      t958 = t118**2
      t959 = 1/t958
      t963 = t78*t382
      t964 = t225*t331
      t976 = t785+t787-t793+t798-t802-t814+0.1484134046134546D0*t963
     #*t964-t817-0.4666666666666667D1*t411*t339*t421*t140
     #+0.7420670230672731D-1*t164*t609+0.2D1*t401*sigma*t423
      t979 = rho*(t955+t732+t748+t753+t757-t759-t761+t764-t775
     #-0.2473556743557577D-1*t79*t956*t959+t779+t976)
      t980 = 0.4666666666666667D1*t409
      t981 = 0.2D1*t424
      t982 = t78*t223
      t985 = t331*t171
      t998 = -0.4444444444444444D0*t733*t35*t539-0.1333333333333333D1
     #*t38*t242-0.4444444444444444D0*t739*t35*t539
     #+0.1333333333333333D1*t42*t242
      t1001 = 0.3799575D-1*t33*t998*t52
      t1003 = 0.7694644203726145D1*t158*t322
      t1014 = 0.1111111111111111D0*t597*t35*t539-0.3333333333333333D0
     #*t165*t242+0.1111111111111111D0*t603*t35*t539
     #+0.3333333333333333D0*t168*t242
      t1020 = 0.8740794636035784D-3*t243*t32*t149*t52
      t1024 = 0.1125D1*t279*t280*t149*t52
      t1026 = t33*t154*t234
      t1027 = 0.607932D0*t1026
      t1030 = t33*t291*t153*t49
      t1031 = 0.151983D0*t1030
      t1034 = t241*t750*t267*t153
      t1035 = 0.3496317854414314D-2*t1034
      t1038 = 0.1923661050931536D1*t315*t149*t50
      t1041 = 0.1923661050931536D1*t69*t998*t50
      t1042 = t316*t161
      t1043 = 0.7694644203726145D1*t1042
      t1044 = t319*t161
      t1045 = 0.7694644203726145D1*t1044
      t1046 = 0.7420670230672731D-1*t982*t964+0.1484134046134546D0
     #*t952*t985+t1001-t1003+0.7420670230672731D-1*t164*t1014-t1020
     #-t1024+t1027-t1031+t1035+t1038+t1041+t1043+t1045
      t1048 = t70*t153*t234
      t1049 = 0.3077857681490458D2*t1048
      t1053 = 0.151983D0*t33*t149*t46*t234
      t1055 = 0.2333333333333333D1*t228*t408
      t1056 = t334*t171
      t1058 = 0.3808092365862222D0*t835*t1056
      t1061 = 0.1269364121954074D0*t174*t84*t1014
      t1064 = 0.296184961789284D0*t174*t339*t171
      t1065 = t850*t185
      t1066 = t348*t1065
      t1068 = 0.2173290372447189D-1*t215*t1066
      t1069 = t91*t171
      t1070 = t348*t1069
      t1072 = 0.4346580744894379D-1*t627*t1070
      t1074 = t279*t281*t161
      t1075 = 0.45D1*t1074
      t1076 = -t1020+t1035-t1024+t1075+t1001-t1031+t1053+t1027+t1038
     #+t1043+t1041+t1045-t1003-t1049
      t1080 = 0.1212828453526912D3*t822*t171
      t1081 = t179*t97
      t1083 = 0.1212828453526912D3*t1081*t331
      t1085 = 0.4851313814107647D3*t825*t985
      t1087 = 0.1212828453526912D3*t182*t1014
      t1088 = -0.4042761511756372D2*t1076*t88+t1080+t1083-t1085+t1087
      t1090 = t100*t1088*t91
      t1093 = t185*t91
      t1094 = t348*t1093
      t1096 = 0.1086645186223595D-1*t178*t1094
      t1097 = t100*t331
      t1098 = t1097*t1093
      t1100 = 0.4346580744894379D-1*t627*t1098
      t1101 = t95*t863
      t1102 = t1097*t171
      t1104 = 0.2173290372447189D0*t1101*t1102
      t1105 = t192*t1014
      t1107 = 0.4346580744894379D-1*t95*t1105
      t1109 = t356*t185*t91
      t1111 = 0.5071010869043442D-1*t178*t1109
      t1112 = t868*t171
      t1114 = 0.2028404347617377D0*t95*t1112
      t1115 = t1058-t1061+t1064+t1068+t1072-0.1086645186223595D-1*t178
     #*t1090-t1096+t1100+t1104-t1107+t1111+t1114
      t1119 = 0.2697586091519874D1*t878*t220
      t1120 = t196*t200
      t1122 = 0.2697586091519874D1*t1120*t379
      t1125 = 0.5395172183039748D1*t883*t379*t220
      t1128 = 0.3424219000457648D0*t915*t363*t1065
      t1131 = 0.3424219000457648D0*t891*t363*t1069
      t1138 = 0.1712109500228824D0*t203*t363*t1093
      t1141 = 0.3424219000457648D0*t891*t334*t1093
      t1142 = t105*t97
      t1144 = 0.1027265700137294D1*t1142*t1056
      t1147 = 0.3424219000457648D0*t105*t208*t1014
      t1151 = 0.3994922167200589D0*t203*t339*t185*t91
      t1154 = 0.7989844334401178D0*t105*t907*t171
      t1156 = 0.1758791364464276D0*t929*t1066
      t1158 = 0.2345055152619034D0*t932*t1070
      t1162 = 0.5862637881547585D-1*t215*t1094
      t1164 = 0.2345055152619034D0*t932*t1098
      t1165 = t111*t863
      t1167 = 0.5862637881547585D0*t1165*t1102
      t1169 = 0.1172527576309517D0*t111*t1105
      t1171 = 0.273589767805554D0*t215*t1109
      t1173 = 0.547179535611108D0*t111*t1112
      t1174 = t1128+t1131-0.1712109500228824D0*t203*t84*t1088*t91
     #-t1138+t1141+t1144-t1147+t1151+t1154+t1156+t1158
     #-0.5862637881547585D-1*t215*t1090-t1162+t1164+t1167-t1169+t1171
     #+t1173
      t1183 = 0.2473556743557577D-1*t383*t959*t223
      t1200 = 0.1D1*t400*t171*t141
      t1202 = t400*t78*t94
      t1204 = 0.522423459704672D1*t1202*t236
      t1207 = 0.1D1*t132*t1014*t141
      t1208 = t404*t94
      t1209 = t234*t77
      t1210 = t171*t140
      t1212 = t1208*t1209*t1210
      t1214 = t234*t421
      t1217 = 0.522423459704672D1*t232*t1214*t1210
      t1220 = t232*t750*t171*t140
      t1222 = t225*t171
      t1224 = 0.7420670230672731D-1*t963*t1222
      t1225 = t228*sigma
      t1227 = 0.1D1*t1225*t423
      t1228 = -t1049+t1053-t1055+0.2473556743557577D-1*t79*
     #(0.2697586091519874D1*t1115*t115-t1119-t1122+t1125
     #-0.2697586091519874D1*t201*t1174)*t225-t1183+t1075+0.1D1*t411
     #*t84*(-0.522423459704672D1*t171*t136*t413-0.522423459704672D1
     #*t412*sigma*t1014+0.1393129225879125D2*t594*sigma*t171)*t140
     #+t1200-t1204+t1207-0.522423459704672D1*t1212-t1217
     #+0.1218988072644235D2*t1220+t1224+t1227
      t1230 = rho*(t1046+t1228)
      t1235 = 0.45D1*t1074
      t1238 = -t1020-t1024+t1001+t1053+t1035+t1235-t1031+t1027+t1038
     #+t1041-t1003+t1043+t1045-t1049
      t1241 = -0.4042761511756372D2*t1238*t88+t1083+t1080-t1085+t1087
      t1243 = t100*t1241*t91
      t1246 = t1058+t1064-t1061+t1068+t1100+t1111
     #-0.1086645186223595D-1*t178*t1243-t1096+t1072+t1104+t1114-t1107
      t1255 = t1128+t1141+t1151-0.1712109500228824D0*t203*t84*t1241
     #*t91-t1138+t1131+t1144+t1154-t1147+t1156+t1164+t1171
     #-0.5862637881547585D-1*t215*t1243-t1162+t1158+t1167+t1173-t1169
      t1262 = -t1049+t1053-0.522423459704672D1*t232*t234*t1014*t140
     #-t1055-t1183+t1235+t1200-t1204+t1207-0.1044846919409344D2*t1212
     #-t1217+0.261211729852336D2*t1220+0.2473556743557577D-1*t79*
     #(0.2697586091519874D1*t1246*t115-t1122-t1119+t1125
     #-0.2697586091519874D1*t201*t1255)*t225+t1224+t1227
      t1264 = rho*(t1046+t1262)
      t1269 = 0.4444444444444444D0*t733*t242+0.4444444444444444D0*t739
     #*t242
      t1272 = 0.3799575D-1*t33*t1269*t52
      t1275 = t33*t149*t153*t49
      t1276 = 0.303966D0*t1275
      t1279 = t33*t44*t45*t49
      t1280 = 0.455949D0*t1279
      t1283 = 0.1923661050931536D1*t69*t1269*t50
      t1284 = t158*t161
      t1285 = 0.1538928840745229D2*t1284
      t1287 = t70*t45*t49
      t1288 = 0.2308393261117844D2*t1287
      t1289 = t171**2
      t1298 = -0.1111111111111111D0*t597*t242-0.1111111111111111D0
     #*t603*t242
      t1300 = 0.7420670230672731D-1*t164*t1298
      t1306 = 0.1269364121954074D0*t174*t84*t1298
      t1307 = t185**2
      t1308 = t100*t1307
      t1309 = t1308*t850
      t1312 = t186*t1069
      t1323 = 0.1212828453526912D3*t182*t1298
      t1324 = -0.4042761511756372D2*(t1272-t1276-t1280+t1283+t1285
     #+t1288)*t88+0.2425656907053823D3*t1081*t171-0.4851313814107647D3
     #*t825*t1289+t1323
      t1326 = t100*t1324*t91
      t1329 = t1308*t91
      t1332 = t864*t1289
      t1335 = t192*t1298
      t1337 = 0.4346580744894379D-1*t95*t1335
      t1343 = t220**2
      t1346 = t84*t1307
      t1365 = 0.3424219000457648D0*t105*t208*t1298
      t1377 = 0.1172527576309517D0*t111*t1335
      t1378 = 0.3424219000457648D0*t915*t1346*t850
     #+0.6848438000915295D0*t891*t204*t1069-0.1712109500228824D0*t203
     #*t84*t1324*t91-0.1712109500228824D0*t203*t1346*t91
     #+0.1027265700137294D1*t105*t903*t1289-t1365+0.1758791364464276D0
     #*t929*t1309+0.4690110305238068D0*t932*t1312
     #-0.5862637881547585D-1*t215*t1326-0.5862637881547585D-1*t215
     #*t1329+0.5862637881547585D0*t111*t1332-t1377
      t1385 = t223**2
      t1391 = 0.1D1*t132*t1298*t141
      t1394 = t1209*t140
      t1400 = 0.522423459704672D1*t232*t234*t1298*t140
      t1402 = t507*t94*sigma
      t1404 = 1/t98/t788
      t1409 = t1272-t1276-t1280+t1283+t1285+t1288+0.1484134046134546D0
     #*t952*t1289+0.1484134046134546D0*t982*t1222+t1300
     #+0.2473556743557577D-1*t79*(0.2697586091519874D1*
     #(0.3808092365862222D0*t835*t84*t1289-t1306+0.2173290372447189D-1
     #*t215*t1309+0.8693161489788758D-1*t627*t1312
     #-0.1086645186223595D-1*t178*t1326-0.1086645186223595D-1*t178
     #*t1329+0.2173290372447189D0*t95*t1332-t1337)*t115
     #-0.5395172183039748D1*t1120*t220+0.5395172183039748D1*t883*t1343
     #-0.2697586091519874D1*t201*t1378)*t225-0.2473556743557577D-1*t79
     #*t1385*t959+t1391-0.1567270379114016D2*t132*t1289*t94*t1394
     #-t1400+0.272926271249799D2*t1402*t1404*t1289*t140
      t1411 = -0.1044846919409344D2*t237-t528-t529+t530+t531+t532+t533
     #+t534+t979-t980+t981+t1230+t1264+rho*t1409
      v2rhoa2(i) = t526+t1411
      t1414 = -0.1538928840745229D2*t162+0.303966D0*t156+t519+t520
     #+t521+t522+t523-t524-t528-t529+t530+t531+t532
      t1418 = t78*t473
      t1421 = t331*t437
      t1424 = -t1014
      t1427 = 0.607932D0*t1026
      t1428 = 0.151983D0*t1030
      t1429 = 0.3496317854414314D-2*t1034
      t1430 = 0.7694644203726145D1*t1042
      t1431 = 0.7694644203726145D1*t1044
      t1432 = 0.3077857681490458D2*t1048
      t1433 = t334*t437
      t1442 = t850*t448
      t1443 = t348*t1442
      t1446 = t448*t91
      t1447 = t1097*t1446
      t1451 = t356*t448*t91
      t1457 = 0.8740794636035784D-3*t243*t32*t428*t52
      t1461 = 0.1125D1*t279*t280*t428*t52
      t1462 = -t998
      t1465 = 0.3799575D-1*t33*t1462*t52
      t1469 = 0.151983D0*t33*t428*t46*t234
      t1470 = 0.45D1*t1074
      t1473 = 0.1923661050931536D1*t315*t428*t50
      t1476 = 0.1923661050931536D1*t69*t1462*t50
      t1478 = 0.7694644203726145D1*t433*t322
      t1479 = -t1457-t1461+t1465+t1469-t1429-t1470+t1428-t1427+t1473
     #+t1476-t1478-t1430-t1431+t1432
      t1482 = t443*t97
      t1491 = -0.4042761511756372D2*t1479*t88+0.1212828453526912D3
     #*t1482*t331+0.1212828453526912D3*t822*t437-0.4851313814107647D3
     #*t825*t1421+0.1212828453526912D3*t182*t1424
      t1493 = t100*t1491*t91
      t1496 = t348*t1446
      t1499 = t91*t437
      t1500 = t348*t1499
      t1503 = t1097*t437
      t1506 = t868*t437
      t1509 = t192*t1424
      t1512 = 0.3808092365862222D0*t835*t1433+0.296184961789284D0*t174
     #*t339*t437-0.1269364121954074D0*t174*t84*t1424
     #+0.2173290372447189D-1*t215*t1443+0.4346580744894379D-1*t627
     #*t1447+0.5071010869043442D-1*t178*t1451-0.1086645186223595D-1
     #*t178*t1493-0.1086645186223595D-1*t178*t1496
     #+0.4346580744894379D-1*t627*t1500+0.2173290372447189D0*t1101
     #*t1503+0.2028404347617377D0*t95*t1506-0.4346580744894379D-1*t95
     #*t1509
      t1515 = t456*t200
      t1569 = 0.3424219000457648D0*t915*t363*t1442
     #+0.3424219000457648D0*t891*t334*t1446+0.3994922167200589D0*t203
     #*t339*t448*t91-0.1712109500228824D0*t203*t84*t1491*t91
     #-0.1712109500228824D0*t203*t363*t1446+0.3424219000457648D0*t891
     #*t363*t1499+0.1027265700137294D1*t1142*t1433
     #+0.7989844334401178D0*t105*t907*t437-0.3424219000457648D0*t105
     #*t208*t1424+0.1758791364464276D0*t929*t1443+0.2345055152619034D0
     #*t932*t1447+0.273589767805554D0*t215*t1451-0.5862637881547585D-1
     #*t215*t1493-0.5862637881547585D-1*t215*t1496
     #+0.2345055152619034D0*t932*t1500+0.5862637881547585D0*t1165
     #*t1503+0.547179535611108D0*t111*t1506-0.1172527576309517D0*t111
     #*t1509
      t1576 = t959*t473
      t1585 = 0.7420670230672731D-1*t1418*t964+0.1484134046134546D0
     #*t952*t1421+0.7420670230672731D-1*t164*t1424-t1427+t1428-t1429
     #-t1430-t1431+t1432+0.2473556743557577D-1*t79*
     #(0.2697586091519874D1*t1512*t115-0.2697586091519874D1*t1515*t379
     #-0.2697586091519874D1*t878*t470+0.5395172183039748D1*t883*t379
     #*t470-0.2697586091519874D1*t201*t1569)*t225
     #-0.2473556743557577D-1*t383*t1576-t1470+0.1D1*t132*t1424*t141
     #+0.1D1*t400*t437*t141
      t1587 = 0.522423459704672D1*t1202*t481
      t1588 = t437*t140
      t1589 = t1209*t1588
      t1590 = t1208*t1589
      t1594 = 0.522423459704672D1*t232*t1214*t1588
      t1596 = 0.2333333333333333D1*t477*t408
      t1597 = t225*t437
      t1599 = 0.7420670230672731D-1*t963*t1597
      t1606 = t232*t750*t437*t140
      t1608 = t477*sigma
      t1610 = 0.1D1*t1608*t423
      t1611 = -t1587-0.1044846919409344D2*t1590-t1594-t1596+t1599
     #+t1465+t1473+t1476-t1478-0.522423459704672D1*t232*t234*t1424
     #*t140-t1457+0.261211729852336D2*t1606-t1461+t1469+t1610
      t1613 = rho*(t1585+t1611)
      t1632 = -t1587-0.522423459704672D1*t1590-t1594-t1596+t1599+t1465
     #+t1473+t1476-t1478-t1457+0.1218988072644235D2*t1606-t1461+t1469
     #+t1610+0.1D1*t411*t84*(-0.522423459704672D1*t437*t136*t413
     #-0.522423459704672D1*t412*sigma*t1424+0.1393129225879125D2*t594
     #*sigma*t437)*t140
      t1634 = rho*(t1585+t1632)
      t1638 = t33*t428*t153*t49
      t1639 = 0.303966D0*t1638
      t1640 = t433*t161
      t1641 = 0.1538928840745229D2*t1640
      t1642 = t437**2
      t1650 = t448**2
      t1651 = t100*t1650
      t1652 = t1651*t850
      t1655 = t449*t1499
      t1665 = -0.4042761511756372D2*(t1272+t1639-t1280+t1283-t1641
     #+t1288)*t88+0.2425656907053823D3*t1482*t437-0.4851313814107647D3
     #*t825*t1642+t1323
      t1667 = t100*t1665*t91
      t1670 = t1651*t91
      t1673 = t864*t1642
      t1681 = t470**2
      t1684 = t84*t1650
      t1711 = 0.3424219000457648D0*t915*t1684*t850
     #+0.6848438000915295D0*t891*t459*t1499-0.1712109500228824D0*t203
     #*t84*t1665*t91-0.1712109500228824D0*t203*t1684*t91
     #+0.1027265700137294D1*t105*t903*t1642-t1365+0.1758791364464276D0
     #*t929*t1652+0.4690110305238068D0*t932*t1655
     #-0.5862637881547585D-1*t215*t1667-0.5862637881547585D-1*t215
     #*t1670+0.5862637881547585D0*t111*t1673-t1377
      t1718 = t473**2
      t1730 = t1272+t1639-t1280+t1283-t1641+t1288+0.1484134046134546D0
     #*t952*t1642+0.1484134046134546D0*t1418*t1597+t1300
     #+0.2473556743557577D-1*t79*(0.2697586091519874D1*
     #(0.3808092365862222D0*t835*t84*t1642-t1306+0.2173290372447189D-1
     #*t215*t1652+0.8693161489788758D-1*t627*t1655
     #-0.1086645186223595D-1*t178*t1667-0.1086645186223595D-1*t178
     #*t1670+0.2173290372447189D0*t95*t1673-t1337)*t115
     #-0.5395172183039748D1*t1515*t470+0.5395172183039748D1*t883*t1681
     #-0.2697586091519874D1*t201*t1711)*t225-0.2473556743557577D-1*t79
     #*t1718*t959+t1391-0.1567270379114016D2*t132*t1642*t94*t1394
     #-t1400+0.272926271249799D2*t1402*t1404*t1642*t140
      t1732 = 0.759915D-1*t430+0.3847322101863073D1*t434+t533+t534
     #+0.1484134046134546D0*t438+t979-t980+t981+t1613
     #+0.4947113487115154D-1*t475+0.2D1*t478+t1634
     #-0.1044846919409344D2*t482+rho*t1730
      v2rhob2(i) = t1414+t1732
      t1733 = t152+t160+t173+t227+t519+t520+t521+t522+t523-t524+t230
     #-t238-t528-t529+t530+t531
      t1738 = -t1269
      t1741 = 0.3799575D-1*t33*t1738*t52
      t1742 = 0.151983D0*t1275
      t1743 = 0.151983D0*t1638
      t1744 = 0.455949D0*t1279
      t1747 = 0.1923661050931536D1*t69*t1738*t50
      t1748 = 0.7694644203726145D1*t1284
      t1749 = 0.7694644203726145D1*t1640
      t1750 = 0.2308393261117844D2*t1287
      t1751 = t171*t437
      t1756 = -t1298
      t1761 = t175*t437
      t1767 = t186*t1442
      t1770 = t186*t1499
      t1784 = -0.4042761511756372D2*(t1741+t1742-t1743+t1744+t1747
     #-t1748+t1749-t1750)*t88+0.1212828453526912D3*t1081*t437
     #+0.1212828453526912D3*t1482*t171-0.4851313814107647D3*t825*t1751
     #+0.1212828453526912D3*t182*t1756
      t1786 = t100*t1784*t91
      t1789 = t186*t1446
      t1792 = t100*t171
      t1793 = t1792*t1446
      t1796 = t1792*t437
      t1799 = t192*t1756
      t1847 = 0.3424219000457648D0*t915*t204*t1442
     #+0.3424219000457648D0*t891*t204*t1499-0.1712109500228824D0*t203
     #*t84*t1784*t91-0.1712109500228824D0*t203*t204*t1446
     #+0.3424219000457648D0*t891*t175*t1446+0.1027265700137294D1*t1142
     #*t1761-0.3424219000457648D0*t105*t208*t1756+0.1758791364464276D0
     #*t929*t1767+0.2345055152619034D0*t932*t1770
     #-0.5862637881547585D-1*t215*t1786-0.5862637881547585D-1*t215
     #*t1789+0.2345055152619034D0*t932*t1793+0.5862637881547585D0
     #*t1165*t1796-0.1172527576309517D0*t111*t1799
      t1866 = t1404*t171
      s1 = t1741+t1742-t1743+t1744+t1747-t1748+t1749-t1750
     #+0.1484134046134546D0*t952*t1751
      s2 = s1+0.7420670230672731D-1*t1418*t1222+0.7420670230672731D-1
     #*t164*t1756+0.7420670230672731D-1*t982*t1597
     #+0.2473556743557577D-1*t79*(0.2697586091519874D1*
     #(0.3808092365862222D0*t835*t1761-0.1269364121954074D0*t174*t84
     #*t1756+0.2173290372447189D-1*t215*t1767+0.4346580744894379D-1
     #*t627*t1770-0.1086645186223595D-1*t178*t1786
     #-0.1086645186223595D-1*t178*t1789+0.4346580744894379D-1*t627
     #*t1793+0.2173290372447189D0*t1101*t1796-0.4346580744894379D-1
     #*t95*t1799)*t115-0.2697586091519874D1*t1120*t470
     #-0.2697586091519874D1*t1515*t220+0.5395172183039748D1*t883*t220
     #*t470-0.2697586091519874D1*t201*t1847)*t225
      t1870 = s2-0.2473556743557577D-1*t224*t1576+0.1D1*t132*t1756
     #*t141-0.1567270379114016D2*t228*t94*t1589-0.522423459704672D1
     #*t232*t234*t1756*t140+0.272926271249799D2*t1402*t1866*t1588
      t1872 = t532+t431+t435+t533+t534+t439+t979-t980+t981+0.5D0*t1613
     #+t476+0.5D0*t1230+t479+0.5D0*t1634-t483+0.5D0*t1264+rho*t1870
      v2rhoab(i) = t1733+t1872
      t1873 = t78*t500
      t1877 = t202*t97
      t1887 = t489*t200
      t1893 = t110*t80
      t1896 = t93*t88
      t1899 = t914*t97
      t1911 = t959*t500
      t1917 = t234*t78*t140
      t1921 = t132*t96*t94
      t1926 = rho*(0.7420670230672731D-1*t1873*t1222
     #+0.2473556743557577D-1*t79*(0.2697586091519874D1*(
     #-0.1269364121954074D0*t209-0.2173290372447189D-1*t1877*t187
     #-0.8693161489788758D-1*t105*t193)*t115-0.2697586091519874D1
     #*t1120*t497-0.2697586091519874D1*t1887*t220+0.5395172183039748D1
     #*t883*t220*t497-0.2697586091519874D1*t201*(-0.1712109500228824D0
     #*t1893*t205-0.3424219000457648D0*t1896*t175-0.1172527576309517D0
     #*t1899*t187-0.2345055152619034D0*t202*t193))*t225
     #-0.2473556743557577D-1*t224*t1911+0.1D1*t228*t504
     #-0.130605864926168D2*t1225*t1917+0.1364631356248995D2*t1921
     #*t1866*t140)
      s1 = 0.7420670230672731D-1*t1873*t964+0.2473556743557577D-1*t79*
     #(0.2697586091519874D1*(-0.1269364121954074D0*t367
     #-0.148092480894642D0*t370-0.2173290372447189D-1*t1877*t349
     #-0.8693161489788758D-1*t105*t352-0.1014202173808688D0*t105*t357)
     #*t115-0.2697586091519874D1*t878*t497-0.2697586091519874D1*t1887
     #*t379+0.5395172183039748D1*t883*t379*t497-0.2697586091519874D1
     #*t201*(-0.1712109500228824D0*t1893*t364-0.3424219000457648D0
     #*t1896*t334-0.3994922167200589D0*t492*t339-0.1172527576309517D0
     #*t1899*t349-0.2345055152619034D0*t202*t352-0.273589767805554D0
     #*t202*t357))*t225-0.2473556743557577D-1*t383*t1911+0.1D1*t401
     #*t504-0.261211729852336D1*t400*t79*t509+0.1D1*t404*t504
      t1998 = s1-0.261211729852336D1*t621*t1917-0.2333333333333333D1
     #*t133*t339*t140+0.6094940363221173D1*t507*sigma*t750*t140+0.1D1
     #*t133*t423+0.1D1*t411*t84*(-0.522423459704672D1*t412*t331
     #+0.6965646129395627D1*t418)*t140-0.261211729852336D1*t507*sigma
     #*t1214*t140
      t1999 = rho*t1998
      v2rhoasigmaaa(i) = t1926+t503+t506-t511+t1999
      t2001 = 0.4947113487115154D-1*t502
      t2002 = 0.2D1*t505
      t2003 = 0.522423459704672D1*t510
      t2004 = 2.D0*t1999
      v2rhoasigmaab(i) = 2.D0*t1926+t2001+t2002-t2003+t2004
      v2rhoasigmabb(i) = v2rhoasigmaaa(i)
      t2048 = rho*(0.7420670230672731D-1*t1873*t1597
     #+0.2473556743557577D-1*t79*(0.2697586091519874D1*(
     #-0.1269364121954074D0*t463-0.2173290372447189D-1*t1877*t450
     #-0.8693161489788758D-1*t105*t453)*t115-0.2697586091519874D1
     #*t1515*t497-0.2697586091519874D1*t1887*t470+0.5395172183039748D1
     #*t883*t470*t497-0.2697586091519874D1*t201*(-0.1712109500228824D0
     #*t1893*t460-0.3424219000457648D0*t1896*t440-0.1172527576309517D0
     #*t1899*t450-0.2345055152619034D0*t202*t453))*t225
     #-0.2473556743557577D-1*t474*t1911+0.1D1*t477*t504
     #-0.130605864926168D2*t1608*t1917+0.1364631356248995D2*t1921
     #*t1404*t437*t140)
      v2rhobsigmaaa(i) = t2048+t503+t506-t511+t1999
      v2rhobsigmaab(i) = 2.D0*t2048+t2001+t2002-t2003+t2004
      v2rhobsigmabb(i) = v2rhobsigmaaa(i)
      t2056 = t497**2
      t2067 = t500**2
      v2sigmaaa2(i) = rho*(0.2473556743557577D-1*t79*
     #(0.5862637881547585D-1*t93*t97*t100*t115-0.5395172183039748D1
     #*t1887*t497+0.5395172183039748D1*t883*t2056-0.1581497040888031D0
     #*t201*t110*t97*t100)*t225-0.2473556743557577D-1*t79*t2067*t959
     #-0.522423459704672D1*t507*t234*t140+0.6823156781244976D1*t132
     #*t190*sigma*t1404*t140)
      v2sigmaaaab(i) = 2.D0*v2sigmaaa2(i)
      v2sigmaaabb(i) = v2sigmaaa2(i)
      v2sigmaab2(i) = 4.D0*v2sigmaaabb(i)
      v2sigmaabbb(i) = v2sigmaaaab(i)
      v2sigmabb2(i) = v2sigmaaabb(i)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_c_pw91
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     J.P. Perdew, J.A. Chevary, S.H. Vosko, K.A. Jackson,
c     M.R. Pederson, D.J. Singh, C. Fiolhais
c     Atoms, molecules, solids and surfaces:
c     Applications of the generalized gradient approximation
c     for exchange and correlation
c     Phys. Rev. B 46 (1992) 6671--6687
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = 1/rho
      t3 = t2**(1.D0/3.D0)
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t17 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t6
     #+0.2225569421150687D1*t3+0.8004286349993634D0*t9
     #+0.1897004325747559D0*t11))
      t18 = (1.D0+0.1325688999052018D0*t3)*t17
      t20 = rho**2
      t21 = rho**(1.D0/3.D0)
      t23 = 1/t21/t20
      t27 = dexp(0.2513869963240348D1*t18)
      t28 = t27-1.D0
      t29 = 1/t28
      t30 = sigma**2
      t32 = t20**2
      t33 = t21**2
      t35 = 1/t33/t32
      t42 = t28**2
      t52 = dlog(1.D0+0.2697586091519874D1*(0.634682060977037D-1*sigma
     #*t23+0.1086645186223595D-1*t29*t30*t35)/(1.D0
     #+0.1712109500228824D0*t29*sigma*t23+0.2931318940773793D-1/t42
     #*t30*t35))
      t70 = dexp(-0.261211729852336D1/t33/t20*sigma)
      zk(i) = rho*(-0.62182D-1*t18+0.2473556743557577D-1*t52+0.1D1*
     #(0.1D-2*(0.2568D1+0.1443307452126544D2*t3+0.2843543831490386D-2
     #*t11)/(1.D0+0.5411317332115466D1*t3+0.1816419932959077D0*t11
     #+0.1763993811759022D-1*t2)-0.1853571428571429D-2)*sigma*t23*t70)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = 1/rho
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1325688999052018D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.598255043577108D1*t6+0.2225569421150687D1*t3
     #+0.8004286349993634D0*t9+0.1897004325747559D0*t11
      t16 = 1.D0+0.160818243221511D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.62182D-1*t18
      t20 = rho**2
      t21 = rho**(1.D0/3.D0)
      t23 = 1/t21/t20
      t27 = dexp(0.2513869963240348D1*t18)
      t28 = t27-1.D0
      t29 = 1/t28
      t30 = sigma**2
      t31 = t29*t30
      t32 = t20**2
      t33 = t21**2
      t35 = 1/t33/t32
      t38 = 0.634682060977037D-1*sigma*t23+0.1086645186223595D-1*t31*t35
      t39 = t29*sigma
      t42 = t28**2
      t43 = 1/t42
      t44 = t43*t30
      t47 = 1.D0+0.1712109500228824D0*t39*t23+0.2931318940773793D-1
     #*t44*t35
      t48 = 1/t47
      t51 = 1.D0+0.2697586091519874D1*t38*t48
      t52 = dlog(t51)
      t53 = 0.2473556743557577D-1*t52
      t56 = 0.2568D1+0.1443307452126544D2*t3+0.2843543831490386D-2*t11
      t60 = 1.D0+0.5411317332115466D1*t3+0.1816419932959077D0*t11
     #+0.1763993811759022D-1*t2
      t61 = 1/t60
      t64 = 0.1D-2*t56*t61-0.1853571428571429D-2
      t65 = t64*sigma
      t70 = dexp(-0.261211729852336D1/t33/t20*sigma)
      t71 = t23*t70
      t73 = 0.1D1*t65*t71
      zk(i) = rho*(-t19+t53+t73)
      t76 = 1/t20
      t77 = 1/t11*t76
      t78 = t77*t17
      t80 = t13**2
      t83 = t6**2
      t84 = t83**2
      t94 = 1/t3*t76
      t99 = t5/t80*(-0.99709173929518D0/t84/t6*t76
     #-0.7418564737168958D0*t77-0.4002143174996817D0/t9*t76
     #-0.1264669550498372D0*t94)/t16
      t103 = 1/t21/t20/rho
      t108 = -0.1110869918438343D0*t78-0.4042761511756372D2*t99
      t110 = t35*t108*t27
      t113 = t32*rho
      t115 = 1/t33/t113
      t121 = t47**2
      t123 = t38/t121
      t124 = t43*sigma
      t142 = 1/t51
      t150 = t60**2
      vrhoa(i) = -t19+t53+t73+rho*(0.2747799777968419D-2*t78+0.1D1*t99
     #+0.2473556743557577D-1*(0.2697586091519874D1*(
     #-0.148092480894642D0*sigma*t103-0.1086645186223595D-1*t44*t110
     #-0.5071010869043442D-1*t31*t115)*t48-0.2697586091519874D1*t123*(
     #-0.1712109500228824D0*t124*t23*t108*t27-0.3994922167200589D0*t39
     #*t103-0.5862637881547585D-1/t42/t28*t30*t110-0.136794883902777D0
     #*t44*t115))*t142+0.1D1*(0.1D-2*(-0.4811024840421814D1*t77
     #-0.1895695887660258D-2*t94)*t61-0.1D-2*t56/t150*(
     #-0.1803772444038489D1*t77-0.1210946621972718D0*t94
     #-0.1763993811759022D-1*t76))*sigma*t71-0.2333333333333333D1*t65
     #*t103*t70+0.6965646129395627D1*t64*t30/t32/t20*t70)
      vsigmaaa(i) = 4.D0*rho*(0.2473556743557577D-1*
     #(0.2697586091519874D1*(0.634682060977037D-1*t23
     #+0.2173290372447189D-1*t39*t35)*t48-0.2697586091519874D1*t123*
     #(0.1712109500228824D0*t29*t23+0.5862637881547585D-1*t124*t35))
     #*t142+0.1D1*t64*t23*t70-0.261211729852336D1*t65/t113*t70)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = 1/rho
      t3 = t2**(1.D0/3.D0)
      t5 = 1.D0+0.1325688999052018D0*t3
      t6 = t2**(1.D0/6.D0)
      t9 = dsqrt(t2)
      t11 = t3**2
      t13 = 0.598255043577108D1*t6+0.2225569421150687D1*t3
     #+0.8004286349993634D0*t9+0.1897004325747559D0*t11
      t16 = 1.D0+0.160818243221511D2/t13
      t17 = dlog(t16)
      t18 = t5*t17
      t19 = 0.62182D-1*t18
      t20 = rho**2
      t21 = rho**(1.D0/3.D0)
      t23 = 1/t21/t20
      t27 = dexp(0.2513869963240348D1*t18)
      t28 = t27-1.D0
      t29 = 1/t28
      t30 = sigma**2
      t31 = t29*t30
      t32 = t20**2
      t33 = t21**2
      t35 = 1/t33/t32
      t38 = 0.634682060977037D-1*sigma*t23+0.1086645186223595D-1*t31*t35
      t39 = t29*sigma
      t42 = t28**2
      t43 = 1/t42
      t44 = t43*t30
      t47 = 1.D0+0.1712109500228824D0*t39*t23+0.2931318940773793D-1
     #*t44*t35
      t48 = 1/t47
      t51 = 1.D0+0.2697586091519874D1*t38*t48
      t52 = dlog(t51)
      t53 = 0.2473556743557577D-1*t52
      t56 = 0.2568D1+0.1443307452126544D2*t3+0.2843543831490386D-2*t11
      t60 = 1.D0+0.5411317332115466D1*t3+0.1816419932959077D0*t11
     #+0.1763993811759022D-1*t2
      t61 = 1/t60
      t64 = 0.1D-2*t56*t61-0.1853571428571429D-2
      t65 = t64*sigma
      t70 = dexp(-0.261211729852336D1/t33/t20*sigma)
      t71 = t23*t70
      t73 = 0.1D1*t65*t71
      zk(i) = rho*(-t19+t53+t73)
      t75 = 1/t11
      t76 = 1/t20
      t77 = t75*t76
      t78 = t77*t17
      t80 = t13**2
      t81 = 1/t80
      t82 = t5*t81
      t83 = t6**2
      t84 = t83**2
      t85 = t84*t6
      t86 = 1/t85
      t90 = 1/t9
      t93 = 1/t3
      t94 = t93*t76
      t96 = -0.99709173929518D0*t86*t76-0.7418564737168958D0*t77
     #-0.4002143174996817D0*t90*t76-0.1264669550498372D0*t94
      t97 = 1/t16
      t99 = t82*t96*t97
      t101 = t20*rho
      t103 = 1/t21/t101
      t108 = -0.1110869918438343D0*t78-0.4042761511756372D2*t99
      t110 = t35*t108*t27
      t113 = t32*rho
      t115 = 1/t33/t113
      t118 = -0.148092480894642D0*sigma*t103-0.1086645186223595D-1*t44
     #*t110-0.5071010869043442D-1*t31*t115
      t121 = t47**2
      t122 = 1/t121
      t123 = t38*t122
      t124 = t43*sigma
      t132 = 1/t42/t28
      t133 = t132*t30
      t138 = -0.1712109500228824D0*t124*t23*t108*t27
     #-0.3994922167200589D0*t39*t103-0.5862637881547585D-1*t133*t110
     #-0.136794883902777D0*t44*t115
      t141 = 0.2697586091519874D1*t118*t48-0.2697586091519874D1*t123
     #*t138
      t142 = 1/t51
      t143 = t141*t142
      t147 = -0.4811024840421814D1*t77-0.1895695887660258D-2*t94
      t150 = t60**2
      t151 = 1/t150
      t152 = t56*t151
      t156 = -0.1803772444038489D1*t77-0.1210946621972718D0*t94
     #-0.1763993811759022D-1*t76
      t159 = 0.1D-2*t147*t61-0.1D-2*t152*t156
      t160 = t159*sigma
      t161 = t160*t71
      t163 = t103*t70
      t164 = t65*t163
      t166 = t64*t30
      t167 = t32*t20
      t169 = 1/t167*t70
      t170 = t166*t169
      vrhoa(i) = -t19+t53+t73+rho*(0.2747799777968419D-2*t78+0.1D1*t99
     #+0.2473556743557577D-1*t143+0.1D1*t161-0.2333333333333333D1*t164
     #+0.6965646129395627D1*t170)
      t177 = 0.634682060977037D-1*t23+0.2173290372447189D-1*t39*t35
      t184 = 0.1712109500228824D0*t29*t23+0.5862637881547585D-1*t124*t35
      t187 = 0.2697586091519874D1*t177*t48-0.2697586091519874D1*t123
     #*t184
      t188 = t187*t142
      t191 = t64*t23*t70
      t193 = 1/t113
      t194 = t193*t70
      t195 = t65*t194
      vsigmaaa(i) = 4.D0*rho*(0.2473556743557577D-1*t188+0.1D1*t191
     #-0.261211729852336D1*t195)
      t215 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t6
     #+0.2247591863577616D1*t3+0.4300972471276643D0*t9
     #+0.1911512595127338D0*t11))
      t217 = (1.D0+0.6901399211255825D-1*t3)*t215*t76
      t219 = t52*t76
      t222 = 1/t21/t32
      t223 = sigma*t222
      t228 = 0.1365402272980597D1*t217-0.1675913308826898D1*t18*t76
      t230 = t35*t228*t27
      t234 = 1/t33/t167
      t235 = t31*t234
      t244 = t39*t222
      t248 = t44*t234
      t258 = t64*t222*sigma*t70
      t260 = t32*t101
      t263 = t166/t260*t70
      t270 = -t228
      t272 = t35*t270*t27
      t299 = 1/t32
      t300 = 1/t11/t2*t299
      t301 = t300*t17
      t303 = 1/t101
      t304 = t75*t303
      t305 = t304*t17
      t310 = t96**2
      t312 = t5/t80/t13*t310*t97
      t316 = t77*t81*t96*t97
      t334 = 1/t3/t2*t299
      t336 = t93*t303
      t340 = t82*(-0.8309097827459833D0/t85/t2*t299
     #+0.199418347859036D1*t86*t303-0.4945709824779306D0*t300
     #+0.1483712947433792D1*t304-0.2001071587498409D0/t9/t2*t299
     #+0.8004286349993634D0*t90*t303-0.4215565168327908D-1*t334
     #+0.2529339100996745D0*t336)*t97
      t342 = t80**2
      t345 = t16**2
      t348 = t5/t342*t310/t345
      t357 = t32**2
      t364 = t141**2
      t365 = t51**2
      t366 = 1/t365
      t371 = t115*t108*t27
      t380 = -0.740579945625562D-1*t301+0.2221739836876686D0*t305
     #+0.8085523023512745D2*t312+0.3572962974617552D1*t316
     #-0.4042761511756372D2*t340-0.6501498040842D3*t348
      t382 = t35*t380*t27
      t385 = t108**2
      t386 = t35*t385
      t388 = dexp(0.5027739926480695D1*t18)
      t389 = t386*t388
      t392 = t386*t27
      t399 = t118*t122
      t404 = t38/t121/t47
      t405 = t138**2
      t418 = t132*sigma
      t419 = t23*t385
      t429 = t42**2
      t456 = t156**2
      s1 = 0.1831866518645613D-2*t301-0.5495599555936838D-2*t305-0.2D1
     #*t312-0.8837926660346786D-1*t316+0.1D1*t340+0.160818243221511D2
     #*t348-0.5804705107829689D2*t263
      s2 = s1+0.7777777777777778D1*t258+0.1393129225879125D2*t159*t30
     #*t169+0.4852022599996427D2*t64*t30*sigma/t33/t357/rho*t70
      s3 = s2-0.2473556743557577D-1*t364*t366
      s4 = s3+0.2473556743557577D-1*(0.2697586091519874D1*
     #(0.4936416029821399D0*t223+0.1014202173808688D0*t44*t371
     #-0.1086645186223595D-1*t44*t382+0.2173290372447189D-1*t133*t389
     #-0.1086645186223595D-1*t44*t392+0.2873572825791284D0*t235)*t48
     #-0.5395172183039748D1*t399*t138+0.5395172183039748D1*t404*t405
     #-0.2697586091519874D1*t123*(0.7989844334401178D0*t124*t103*t108
     #*t27-0.1712109500228824D0*t124*t23*t380*t27
     #-0.5862637881547585D-1*t133*t382+0.3424219000457648D0*t418*t419
     #*t388-0.1712109500228824D0*t124*t419*t27+0.1331640722400196D1
     #*t244+0.547179535611108D0*t133*t371+0.1758791364464276D0/t429
     #*t30*t389+0.7751710087824029D0*t248-0.5862637881547585D-1*t133
     #*t392))*t142
      t473 = s4+0.1D1*(0.1D-2*(-0.3207349893614542D1*t300
     #+0.9622049680843627D1*t304-0.6318986292200858D-3*t334
     #+0.3791391775320515D-2*t336)*t61-0.2D-2*t147*t151*t156+0.2D-2
     #*t56/t150/t60*t456-0.1D-2*t152*(-0.1202514962692326D1*t300
     #+0.3607544888076978D1*t304-0.4036488739909061D-1*t334
     #+0.2421893243945437D0*t336+0.3527987623518044D-1*t303))*sigma
     #*t71-0.4666666666666667D1*t160*t163
      s1 = 0.1099119911187368D-1*t78+0.4D1*t99-0.9333333333333333D1
     #*t164+0.2786258451758251D2*t170
      s2 = s1+0.9894226974230308D-1*t143+0.4D1*t161
      s3 = s2+rho*(-0.33774D-1*t217+0.1649037829038385D-1*t219
     #+0.2473556743557577D-1*(0.2697586091519874D1*(
     #-0.2820809159897942D-1*t223-0.1086645186223595D-1*t44*t230
     #-0.9659068321987509D-2*t235)*t48-0.2697586091519874D1*t123*(
     #-0.1712109500228824D0*t124*t23*t228*t27-0.760937555657255D-1
     #*t244-0.5862637881547585D-1*t133*t230-0.2605616836243371D-1*t248
     #))*t142+0.2222222222222222D0*t258-0.1160941021565938D1*t263)
      v2rhoa2(i) = s3+rho*(0.33774D-1*t217-0.1649037829038385D-1*t219
     #+0.2473556743557577D-1*(0.2697586091519874D1*
     #(0.2820809159897942D-1*t223-0.1086645186223595D-1*t44*t272
     #+0.9659068321987509D-2*t235)*t48-0.2697586091519874D1*t123*(
     #-0.1712109500228824D0*t124*t23*t270*t27+0.760937555657255D-1
     #*t244-0.5862637881547585D-1*t133*t272+0.2605616836243371D-1*t248
     #))*t142-0.2222222222222222D0*t258+0.1160941021565938D1*t263)
     #+2.D0*rho*t473
      t489 = t177*t122
      v2rhoasigmaaa(i) = 0.9894226974230308D-1*t188+0.4D1*t191
     #-0.1044846919409344D2*t195+4.D0*rho*(0.2473556743557577D-1*
     #(0.2697586091519874D1*(-0.148092480894642D0*t103
     #-0.2173290372447189D-1*t124*t110-0.1014202173808688D0*t39*t115)
     #*t48-0.2697586091519874D1*t399*t184-0.2697586091519874D1*t489
     #*t138+0.5395172183039748D1*t404*t138*t184-0.2697586091519874D1
     #*t123*(-0.1712109500228824D0*t43*t23*t108*t27
     #-0.3994922167200589D0*t29*t103-0.1172527576309517D0*t418*t110
     #-0.273589767805554D0*t124*t115))*t142-0.2473556743557577D-1*t141
     #*t366*t187+0.1D1*t159*t23*t70-0.261211729852336D1*t160*t194
     #-0.2333333333333333D1*t64*t103*t70+0.2002623262201243D2*t65*t169
     #-0.181950847499866D2*t166/t33/t357*t70)
      t537 = t184**2
      t546 = t187**2
      v2sigmaaa2(i) = 16.D0*rho*(0.2473556743557577D-1*
     #(0.5862637881547585D-1*t29*t35*t48-0.5395172183039748D1*t489
     #*t184+0.5395172183039748D1*t404*t537-0.1581497040888031D0*t123
     #*t43*t35)*t142-0.2473556743557577D-1*t546*t366
     #-0.522423459704672D1*t64*t193*t70+0.6823156781244976D1*t65/t33
     #/t260*t70)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:C_PW91subrend
c:X_B88subrstart

c    Generated: Wed Jan 29 09:08:35 GMT 2003

      subroutine uks_x_b88
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     A.D. Becke
c     Density-functional exchange-energy approximation with correct
c     asymptotic behaviour
c     Phys. Rev. A38 (1988) 3098-3100
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t5 = 1/t3
      t7 = dsqrt(sigmabb)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      zk(i) = -0.9305257363491D0*t3-0.42D-2*t5*sigmabb/(1.D0+0.252D-1
     #*t8*t9)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t5 = 1/t3
      t7 = dsqrt(sigmaaa)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      zk(i) = -0.9305257363491D0*t3-0.42D-2*t5*sigmaaa/(1.D0+0.252D-1
     #*t8*t9)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t7 = 1/t5
      t9 = dsqrt(sigmaaa)
      t10 = t9*t7
      t11 = dlog(t10+dsqrt(1+t10**2))
      t18 = rhob**(1.D0/3.D0)
      t19 = t18*rhob
      t21 = 1/t19
      t23 = dsqrt(sigmabb)
      t24 = t23*t21
      t25 = dlog(t24+dsqrt(1+t24**2))
      zk(i) = -0.9305257363491D0*t5-0.42D-2*t7*sigmaaa/(1.D0+0.252D-1
     #*t10*t11)-0.9305257363491D0*t19-0.42D-2*t21*sigmabb/(1.D0
     #+0.252D-1*t24*t25)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t5 = 1/t3
      t6 = t5*sigmabb
      t7 = dsqrt(sigmabb)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t12 = 1.D0+0.252D-1*t8*t9
      t13 = 1/t12
      zk(i) = -0.9305257363491D0*t3-0.42D-2*t6*t13
      vrhoa(i) = 0.D0
      t17 = rhob**2
      t19 = 1/t2/t17
      t23 = t12**2
      t24 = 1/t23
      t29 = t2**2
      t34 = 1/t29/t17
      t37 = dsqrt(1.D0+sigmabb*t34)
      t38 = 1/t37
      vrhob(i) = -0.12407009817988D1*t2+0.56D-2*t19*sigmabb*t13
     #+0.42D-2*t6*t24*(-0.336D-1*t7*t19*t9-0.336D-1*sigmabb/t29/t17
     #/rhob*t38)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = -0.42D-2*t5*t13+0.42D-2*t6*t24*(0.126D-1/t7*t5*t9
     #+0.126D-1*t34*t38)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t5 = 1/t3
      t6 = t5*sigmaaa
      t7 = dsqrt(sigmaaa)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t12 = 1.D0+0.252D-1*t8*t9
      t13 = 1/t12
      zk(i) = -0.9305257363491D0*t3-0.42D-2*t6*t13
      t17 = rhoa**2
      t19 = 1/t2/t17
      t23 = t12**2
      t24 = 1/t23
      t29 = t2**2
      t34 = 1/t29/t17
      t37 = dsqrt(1.D0+sigmaaa*t34)
      t38 = 1/t37
      vrhoa(i) = -0.12407009817988D1*t2+0.56D-2*t19*sigmaaa*t13
     #+0.42D-2*t6*t24*(-0.336D-1*t7*t19*t9-0.336D-1*sigmaaa/t29/t17
     #/rhoa*t38)
      vrhob(i) = 0.D0
      vsigmaaa(i) = -0.42D-2*t5*t13+0.42D-2*t6*t24*(0.126D-1/t7*t5*t9
     #+0.126D-1*t34*t38)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t7 = 1/t5
      t8 = t7*sigmaaa
      t9 = dsqrt(sigmaaa)
      t10 = t9*t7
      t11 = dlog(t10+dsqrt(1+t10**2))
      t14 = 1.D0+0.252D-1*t10*t11
      t15 = 1/t14
      t18 = rhob**(1.D0/3.D0)
      t19 = t18*rhob
      t21 = 1/t19
      t22 = t21*sigmabb
      t23 = dsqrt(sigmabb)
      t24 = t23*t21
      t25 = dlog(t24+dsqrt(1+t24**2))
      t28 = 1.D0+0.252D-1*t24*t25
      t29 = 1/t28
      zk(i) = -0.9305257363491D0*t5-0.42D-2*t8*t15-0.9305257363491D0
     #*t19-0.42D-2*t22*t29
      t33 = rhoa**2
      t35 = 1/t4/t33
      t39 = t14**2
      t40 = 1/t39
      t45 = t4**2
      t50 = 1/t45/t33
      t53 = dsqrt(1.D0+sigmaaa*t50)
      t54 = 1/t53
      vrhoa(i) = -0.12407009817988D1*t4+0.56D-2*t35*sigmaaa*t15
     #+0.42D-2*t8*t40*(-0.336D-1*t9*t35*t11-0.336D-1*sigmaaa/t45/t33
     #/rhoa*t54)
      t62 = rhob**2
      t64 = 1/t18/t62
      t68 = t28**2
      t69 = 1/t68
      t74 = t18**2
      t79 = 1/t74/t62
      t82 = dsqrt(1.D0+sigmabb*t79)
      t83 = 1/t82
      vrhob(i) = -0.12407009817988D1*t18+0.56D-2*t64*sigmabb*t29
     #+0.42D-2*t22*t69*(-0.336D-1*t23*t64*t25-0.336D-1*sigmabb/t74/t62
     #/rhob*t83)
      vsigmaaa(i) = -0.42D-2*t7*t15+0.42D-2*t8*t40*(0.126D-1/t9*t7*t11
     #+0.126D-1*t50*t54)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = -0.42D-2*t21*t29+0.42D-2*t22*t69*(0.126D-1/t23*t21
     #*t25+0.126D-1*t79*t83)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t5 = 1/t3
      t6 = t5*sigmabb
      t7 = dsqrt(sigmabb)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t12 = 1.D0+0.252D-1*t8*t9
      t13 = 1/t12
      zk(i) = -0.9305257363491D0*t3-0.42D-2*t6*t13
      vrhoa(i) = 0.D0
      t17 = rhob**2
      t19 = 1/t2/t17
      t20 = t19*sigmabb
      t23 = t12**2
      t24 = 1/t23
      t28 = t17*rhob
      t29 = t2**2
      t34 = 1/t29/t17
      t36 = 1.D0+sigmabb*t34
      t37 = dsqrt(t36)
      t38 = 1/t37
      t41 = -0.336D-1*t7*t19*t9-0.336D-1*sigmabb/t29/t28*t38
      t42 = t24*t41
      vrhob(i) = -0.12407009817988D1*t2+0.56D-2*t20*t13+0.42D-2*t6*t42
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t53 = 0.126D-1/t7*t5*t9+0.126D-1*t34*t38
      vsigmabb(i) = -0.42D-2*t5*t13+0.42D-2*t6*t24*t53
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t60 = 1/t2/t28
      t67 = 1/t23/t12
      t68 = t41**2
      t75 = t17**2
      t81 = sigmabb**2
      t87 = 1/t37/t36
      v2rhob2(i) = -0.4135669939329333D0/t29-0.1306666666666667D-1*t60
     #*sigmabb*t13-0.112D-1*t20*t42-0.84D-2*t6*t67*t68+0.42D-2*t6*t24*
     #(0.784D-1*t7*t60*t9+0.168D0*sigmabb/t29/t75*t38-0.448D-1*t81/t2
     #/t75/t28*t87)
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t97 = t53**2
      v2sigmabb2(i) = 0.84D-2*t5*t24*t53-0.84D-2*t6*t67*t97+0.42D-2*t6
     #*t24*(-0.63D-2/t7/sigmabb*t5*t9+0.63D-2/sigmabb*t34*t38-0.63D-2
     #/t2/t75/rhob*t87)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t5 = 1/t3
      t6 = t5*sigmaaa
      t7 = dsqrt(sigmaaa)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t12 = 1.D0+0.252D-1*t8*t9
      t13 = 1/t12
      zk(i) = -0.9305257363491D0*t3-0.42D-2*t6*t13
      t17 = rhoa**2
      t19 = 1/t2/t17
      t20 = t19*sigmaaa
      t23 = t12**2
      t24 = 1/t23
      t28 = t17*rhoa
      t29 = t2**2
      t34 = 1/t29/t17
      t36 = 1.D0+sigmaaa*t34
      t37 = dsqrt(t36)
      t38 = 1/t37
      t41 = -0.336D-1*t7*t19*t9-0.336D-1*sigmaaa/t29/t28*t38
      t42 = t24*t41
      vrhoa(i) = -0.12407009817988D1*t2+0.56D-2*t20*t13+0.42D-2*t6*t42
      vrhob(i) = 0.D0
      t53 = 0.126D-1/t7*t5*t9+0.126D-1*t34*t38
      vsigmaaa(i) = -0.42D-2*t5*t13+0.42D-2*t6*t24*t53
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t60 = 1/t2/t28
      t67 = 1/t23/t12
      t68 = t41**2
      t75 = t17**2
      t81 = sigmaaa**2
      t87 = 1/t37/t36
      v2rhoa2(i) = -0.4135669939329333D0/t29-0.1306666666666667D-1*t60
     #*sigmaaa*t13-0.112D-1*t20*t42-0.84D-2*t6*t67*t68+0.42D-2*t6*t24*
     #(0.784D-1*t7*t60*t9+0.168D0*sigmaaa/t29/t75*t38-0.448D-1*t81/t2
     #/t75/t28*t87)
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t97 = t53**2
      v2sigmaaa2(i) = 0.84D-2*t5*t24*t53-0.84D-2*t6*t67*t97+0.42D-2*t6
     #*t24*(-0.63D-2/t7/sigmaaa*t5*t9+0.63D-2/sigmaaa*t34*t38-0.63D-2
     #/t2/t75/rhoa*t87)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t7 = 1/t5
      t8 = t7*sigmaaa
      t9 = dsqrt(sigmaaa)
      t10 = t9*t7
      t11 = dlog(t10+dsqrt(1+t10**2))
      t14 = 1.D0+0.252D-1*t10*t11
      t15 = 1/t14
      t18 = rhob**(1.D0/3.D0)
      t19 = t18*rhob
      t21 = 1/t19
      t22 = t21*sigmabb
      t23 = dsqrt(sigmabb)
      t24 = t23*t21
      t25 = dlog(t24+dsqrt(1+t24**2))
      t28 = 1.D0+0.252D-1*t24*t25
      t29 = 1/t28
      zk(i) = -0.9305257363491D0*t5-0.42D-2*t8*t15-0.9305257363491D0
     #*t19-0.42D-2*t22*t29
      t33 = rhoa**2
      t35 = 1/t4/t33
      t36 = t35*sigmaaa
      t39 = t14**2
      t40 = 1/t39
      t44 = t33*rhoa
      t45 = t4**2
      t47 = 1/t45/t44
      t50 = 1/t45/t33
      t52 = 1.D0+sigmaaa*t50
      t53 = dsqrt(t52)
      t54 = 1/t53
      t57 = -0.336D-1*t9*t35*t11-0.336D-1*sigmaaa*t47*t54
      t58 = t40*t57
      vrhoa(i) = -0.12407009817988D1*t4+0.56D-2*t36*t15+0.42D-2*t8*t58
      t62 = rhob**2
      t64 = 1/t18/t62
      t65 = t64*sigmabb
      t68 = t28**2
      t69 = 1/t68
      t73 = t62*rhob
      t74 = t18**2
      t76 = 1/t74/t73
      t79 = 1/t74/t62
      t81 = 1.D0+sigmabb*t79
      t82 = dsqrt(t81)
      t83 = 1/t82
      t86 = -0.336D-1*t23*t64*t25-0.336D-1*sigmabb*t76*t83
      t87 = t69*t86
      vrhob(i) = -0.12407009817988D1*t18+0.56D-2*t65*t29+0.42D-2*t22*t87
      t92 = 1/t9
      t98 = 0.126D-1*t92*t7*t11+0.126D-1*t50*t54
      t99 = t40*t98
      vsigmaaa(i) = -0.42D-2*t7*t15+0.42D-2*t8*t99
      vsigmaab(i) = 0.D0
      t104 = 1/t23
      t110 = 0.126D-1*t104*t21*t25+0.126D-1*t79*t83
      t111 = t69*t110
      vsigmabb(i) = -0.42D-2*t21*t29+0.42D-2*t22*t111
      t117 = 1/t4/t44
      t124 = 1/t39/t14
      t125 = t57**2
      t132 = t33**2
      t138 = sigmaaa**2
      t144 = 1/t53/t52
      v2rhoa2(i) = -0.4135669939329333D0/t45-0.1306666666666667D-1
     #*t117*sigmaaa*t15-0.112D-1*t36*t58-0.84D-2*t8*t124*t125+0.42D-2
     #*t8*t40*(0.784D-1*t9*t117*t11+0.168D0*sigmaaa/t45/t132*t54
     #-0.448D-1*t138/t4/t132/t44*t144)
      t154 = 1/t18/t73
      t161 = 1/t68/t28
      t162 = t86**2
      t169 = t62**2
      t175 = sigmabb**2
      t181 = 1/t82/t81
      v2rhob2(i) = -0.4135669939329333D0/t74-0.1306666666666667D-1
     #*t154*sigmabb*t29-0.112D-1*t65*t87-0.84D-2*t22*t161*t162+0.42D-2
     #*t22*t69*(0.784D-1*t23*t154*t25+0.168D0*sigmabb/t74/t169*t83
     #-0.448D-1*t175/t18/t169/t73*t181)
      v2rhoab(i) = 0.D0
      t192 = t7*t40
      v2rhoasigmaaa(i) = 0.56D-2*t35*t15-0.56D-2*t36*t99+0.42D-2*t192
     #*t57-0.84D-2*t8*t124*t57*t98+0.42D-2*t8*t40*(-0.168D-1*t92*t35
     #*t11-0.504D-1*t47*t54+0.168D-1*sigmaaa/t4/t132/t33*t144)
      v2rhoasigmaab(i) = 0.D0
      v2rhoasigmabb(i) = 0.D0
      v2rhobsigmaaa(i) = 0.D0
      v2rhobsigmaab(i) = 0.D0
      t218 = t21*t69
      v2rhobsigmabb(i) = 0.56D-2*t64*t29-0.56D-2*t65*t111+0.42D-2*t218
     #*t86-0.84D-2*t22*t161*t86*t110+0.42D-2*t22*t69*(-0.168D-1*t104
     #*t64*t25-0.504D-1*t76*t83+0.168D-1*sigmabb/t18/t169/t62*t181)
      t242 = t98**2
      v2sigmaaa2(i) = 0.84D-2*t192*t98-0.84D-2*t8*t124*t242+0.42D-2*t8
     #*t40*(-0.63D-2/t9/sigmaaa*t7*t11+0.63D-2/sigmaaa*t50*t54-0.63D-2
     #/t4/t132/rhoa*t144)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t266 = t110**2
      v2sigmabb2(i) = 0.84D-2*t218*t110-0.84D-2*t22*t161*t266+0.42D-2
     #*t22*t69*(-0.63D-2/t23/sigmabb*t21*t25+0.63D-2/sigmabb*t79*t83
     #-0.63D-2/t18/t169/rhob*t181)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_x_b88
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     A.D. Becke
c     Density-functional exchange-energy approximation with correct
c     asymptotic behaviour
c     Phys. Rev. A38 (1988) 3098-3100
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t5 = 1/t3
      t7 = dsqrt(sigma)
      t8 = t7*t5
      t10 = dlog(0.1259921049894873D1*t8+dsqrt(1+0.1587401051968199D1
     #*t8**2))
      zk(i) = -0.7385587663820224D0*t3-0.5291668409558467D-2*t5*sigma/
     #(1.D0+0.317500104573508D-1*t8*t10)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t5 = 1/t3
      t6 = t5*sigma
      t7 = dsqrt(sigma)
      t8 = t7*t5
      t10 = dlog(0.1259921049894873D1*t8+dsqrt(1+0.1587401051968199D1
     #*t8**2))
      t13 = 1.D0+0.317500104573508D-1*t8*t10
      t14 = 1/t13
      zk(i) = -0.7385587663820224D0*t3-0.5291668409558467D-2*t6*t14
      t18 = rho**2
      t20 = 1/t2/t18
      t24 = t13**2
      t25 = 1/t24
      t30 = t2**2
      t35 = 1/t30/t18
      t39 = dsqrt(1.D0+0.1587401051968199D1*sigma*t35)
      t40 = 1/t39
      vrhoa(i) = -0.9847450218426965D0*t2+0.705555787941129D-2*t20
     #*sigma*t14+0.2645834204779234D-2*t6*t25*(-0.8466669455293548D-1
     #*t7*t20*t10-0.106673350692263D0*sigma/t30/t18/rho*t40)
      vsigmaaa(i) = -0.2116667363823387D-1*t5*t14
     #+0.5291668409558467D-2*t6*t25*(0.6350002091470161D-1/t7*t5*t10
     #+0.8000501301919725D-1*t35*t40)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t5 = 1/t3
      t6 = t5*sigma
      t7 = dsqrt(sigma)
      t8 = t7*t5
      t10 = dlog(0.1259921049894873D1*t8+dsqrt(1+0.1587401051968199D1
     #*t8**2))
      t13 = 1.D0+0.317500104573508D-1*t8*t10
      t14 = 1/t13
      zk(i) = -0.7385587663820224D0*t3-0.5291668409558467D-2*t6*t14
      t18 = rho**2
      t20 = 1/t2/t18
      t21 = t20*sigma
      t24 = t13**2
      t25 = 1/t24
      t29 = t18*rho
      t30 = t2**2
      t32 = 1/t30/t29
      t35 = 1/t30/t18
      t38 = 1.D0+0.1587401051968199D1*sigma*t35
      t39 = dsqrt(t38)
      t40 = 1/t39
      t43 = -0.8466669455293548D-1*t7*t20*t10-0.106673350692263D0
     #*sigma*t32*t40
      t44 = t25*t43
      vrhoa(i) = -0.9847450218426965D0*t2+0.705555787941129D-2*t21*t14
     #+0.2645834204779234D-2*t6*t44
      t49 = 1/t7
      t55 = 0.6350002091470161D-1*t49*t5*t10+0.8000501301919725D-1*t35
     #*t40
      t56 = t25*t55
      vsigmaaa(i) = -0.2116667363823387D-1*t5*t14
     #+0.5291668409558467D-2*t6*t56
      t62 = 1/t2/t29
      t69 = 1/t24/t13
      t70 = t43**2
      t77 = t18**2
      t83 = sigma**2
      t89 = 1/t39/t38
      v2rhoa2(i) = -0.6564966812284644D0/t30-0.3292593677058602D-1*t62
     #*sigma*t14-0.1411111575882258D-1*t21*t44-0.5291668409558467D-2
     #*t6*t69*t70+0.2645834204779234D-2*t6*t25*(0.3951112412470322D0
     #*t7*t62*t10+0.106673350692263D1*sigma/t30/t77*t40
     #-0.4515557042823225D0*t83/t2/t77/t29*t89)
      t100 = t5*t25
      v2rhoasigmaaa(i) = 0.2822223151764516D-1*t20*t14
     #-0.705555787941129D-2*t21*t56+0.1058333681911693D-1*t100*t43
     #-0.5291668409558467D-2*t6*t69*t43*t55+0.2645834204779234D-2*t6
     #*t25*(-0.169333389105871D0*t49*t20*t10-0.640040104153578D0*t32
     #*t40+0.3386667782117419D0*sigma/t2/t77/t18*t89)
      t124 = t55**2
      v2sigmaaa2(i) = 0.4233334727646774D-1*t100*t55
     #-0.1058333681911693D-1*t6*t69*t124+0.5291668409558467D-2*t6*t25*
     #(-0.1270000418294032D0/t7/sigma*t5*t10+0.1600100260383945D0
     #/sigma*t35*t40-0.2540000836588064D0/t2/t77/rho*t89)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:X_B88subrend
c:X_LDAsubrstart

c    Generated: Wed Jan 29 09:08:46 GMT 2003

      subroutine uks_x_lda
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     P.A.M. Dirac
c     Proceedings of the Cambridge Philosophical Society, 26 (1930) 376
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      t1 = rhob**(1.D0/3.D0)
      zk(i) = -0.9305257363491D0*t1*rhob
      elseif(rhob.lt.tol) then
      rho = rhoa
      t1 = rhoa**(1.D0/3.D0)
      zk(i) = -0.9305257363491D0*t1*rhoa
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      t1 = rhoa**(1.D0/3.D0)
      t4 = rhob**(1.D0/3.D0)
      zk(i) = -0.9305257363491D0*t1*rhoa-0.9305257363491D0*t4*rhob
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      t1 = rhob**(1.D0/3.D0)
      zk(i) = -0.9305257363491D0*t1*rhob
      vrhoa(i) = 0.D0
      vrhob(i) = -0.12407009817988D1*t1
      elseif(rhob.lt.tol) then
      rho = rhoa
      t1 = rhoa**(1.D0/3.D0)
      zk(i) = -0.9305257363491D0*t1*rhoa
      vrhoa(i) = -0.12407009817988D1*t1
      vrhob(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      t1 = rhoa**(1.D0/3.D0)
      t4 = rhob**(1.D0/3.D0)
      zk(i) = -0.9305257363491D0*t1*rhoa-0.9305257363491D0*t4*rhob
      vrhoa(i) = -0.12407009817988D1*t1
      vrhob(i) = -0.12407009817988D1*t4
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      t1 = rhob**(1.D0/3.D0)
      zk(i) = -0.9305257363491D0*t1*rhob
      vrhoa(i) = 0.D0
      vrhob(i) = -0.12407009817988D1*t1
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t5 = t1**2
      v2rhob2(i) = -0.4135669939329333D0/t5
      elseif(rhob.lt.tol) then
      rho = rhoa
      t1 = rhoa**(1.D0/3.D0)
      zk(i) = -0.9305257363491D0*t1*rhoa
      vrhoa(i) = -0.12407009817988D1*t1
      vrhob(i) = 0.D0
      t5 = t1**2
      v2rhoa2(i) = -0.4135669939329333D0/t5
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      t1 = rhoa**(1.D0/3.D0)
      t4 = rhob**(1.D0/3.D0)
      zk(i) = -0.9305257363491D0*t1*rhoa-0.9305257363491D0*t4*rhob
      vrhoa(i) = -0.12407009817988D1*t1
      vrhob(i) = -0.12407009817988D1*t4
      t9 = t1**2
      v2rhoa2(i) = -0.4135669939329333D0/t9
      t12 = t4**2
      v2rhob2(i) = -0.4135669939329333D0/t12
      v2rhoab(i) = 0.D0
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_x_lda
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     P.A.M. Dirac
c     Proceedings of the Cambridge Philosophical Society, 26 (1930) 376
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      t1 = rho**(1.D0/3.D0)
      zk(i) = -0.7385587663820224D0*t1*rho
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      t1 = rho**(1.D0/3.D0)
      zk(i) = -0.7385587663820224D0*t1*rho
      vrhoa(i) = -0.9847450218426965D0*t1
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      t1 = rho**(1.D0/3.D0)
      zk(i) = -0.7385587663820224D0*t1*rho
      vrhoa(i) = -0.9847450218426965D0*t1
      t5 = t1**2
      v2rhoa2(i) = -0.6564966812284644D0/t5
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:X_LDAsubrend
c:XC_PW91subrstart

c    Generated: Mon Oct 25 09:31:43 BST 2004

      subroutine uks_xc_pw91
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     J.P. Perdew, J.A. Chevary, S.H. Vosko, K.A. Jackson,
c     M.R. Pederson, D.J. Singh, C. Fiolhais
c     Atoms, molecules, solids and surfaces:
c     Applications of the generalized gradient approximation
c     for exchange and correlation
c     Phys. Rev. B 46 (1992) 6671--6687
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = dsqrt(sigmabb)
      t6 = t4/t3
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhob**2
      t12 = t2**2
      t14 = 1/t12/t11
      t17 = dexp(-0.1645530784602056D1*sigmabb*t14)
      t25 = sigmabb**2
      t26 = t11**2
      t36 = 1/rhob
      t37 = t36**(1.D0/3.D0)
      t40 = t36**(1.D0/6.D0)
      t43 = dsqrt(t36)
      t45 = t37**2
      t51 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t40
     #+0.3844746237447211D1*t37+0.1644733775567609D1*t43
     #+0.2405871291288192D0*t45))
      t52 = (1.D0+0.1274696188700087D0*t37)*t51
      t55 = 1/t2/t11
      t59 = dexp(0.2513789108010112D1*t52)
      t60 = t59-1.D0
      t61 = 1/t60
      t64 = 1/t12/t26
      t71 = t60**2
      t81 = dlog(1.D0+0.2697586091519874D1*(0.1007494971260294D0
     #*sigmabb*t55+0.2738174287780083D-1*t61*t25*t64)/(1.D0
     #+0.2717804421747983D0*t61*sigmabb*t55+0.7386460874872889D-1/t71
     #*t25*t64))
      zk(i) = -0.9305257363491D0*t3*(1.D0+t10+0.1645530784602056D-1*
     #(0.2743D0-0.1508D0*t17)*sigmabb*t14)/(1.D0+t10
     #+0.1083108625229223D-5*t25/t2/t26/rhob)+rhob*(-0.3109D-1*t52
     #+0.1236778371778789D-1*t81+0.7937005259840997D0*(0.1D-2*
     #(0.2568D1+0.1443307452126544D2*t37+0.2843543831490386D-2*t45)/
     #(1.D0+0.5411317332115466D1*t37+0.1816419932959077D0*t45
     #+0.1763993811759022D-1*t36)-0.1853571428571429D-2)*sigmabb*t55
     #*t17)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = dsqrt(sigmaaa)
      t6 = t4/t3
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhoa**2
      t12 = t2**2
      t14 = 1/t12/t11
      t17 = dexp(-0.1645530784602056D1*sigmaaa*t14)
      t25 = sigmaaa**2
      t26 = t11**2
      t36 = 1/rhoa
      t37 = t36**(1.D0/3.D0)
      t40 = t36**(1.D0/6.D0)
      t43 = dsqrt(t36)
      t45 = t37**2
      t51 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t40
     #+0.3844746237447211D1*t37+0.1644733775567609D1*t43
     #+0.2405871291288192D0*t45))
      t52 = (1.D0+0.1274696188700087D0*t37)*t51
      t55 = 1/t2/t11
      t59 = dexp(0.2513789108010112D1*t52)
      t60 = t59-1.D0
      t61 = 1/t60
      t64 = 1/t12/t26
      t71 = t60**2
      t81 = dlog(1.D0+0.2697586091519874D1*(0.1007494971260294D0
     #*sigmaaa*t55+0.2738174287780083D-1*t61*t25*t64)/(1.D0
     #+0.2717804421747983D0*t61*sigmaaa*t55+0.7386460874872889D-1/t71
     #*t25*t64))
      zk(i) = -0.9305257363491D0*t3*(1.D0+t10+0.1645530784602056D-1*
     #(0.2743D0-0.1508D0*t17)*sigmaaa*t14)/(1.D0+t10
     #+0.1083108625229223D-5*t25/t2/t26/rhoa)+rhoa*(-0.3109D-1*t52
     #+0.1236778371778789D-1*t81+0.7937005259840997D0*(0.1D-2*
     #(0.2568D1+0.1443307452126544D2*t37+0.2843543831490386D-2*t45)/
     #(1.D0+0.5411317332115466D1*t37+0.1816419932959077D0*t45
     #+0.1763993811759022D-1*t36)-0.1853571428571429D-2)*sigmaaa*t55
     #*t17)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = dsqrt(sigmaaa)
      t8 = t6/t5
      t10 = dlog(0.1000005877780776D1*t8+dsqrt(1+0.10000117555961D1*t8
     #**2))
      t12 = 0.2520026100493014D-1*t8*t10
      t13 = rhoa**2
      t14 = t4**2
      t16 = 1/t14/t13
      t19 = dexp(-0.1645530784602056D1*sigmaaa*t16)
      t27 = sigmaaa**2
      t28 = t13**2
      t38 = rhob**(1.D0/3.D0)
      t39 = t38*rhob
      t40 = dsqrt(sigmabb)
      t42 = t40/t39
      t44 = dlog(0.1000005877780776D1*t42+dsqrt(1+0.10000117555961D1
     #*t42**2))
      t46 = 0.2520026100493014D-1*t42*t44
      t47 = rhob**2
      t48 = t38**2
      t50 = 1/t48/t47
      t53 = dexp(-0.1645530784602056D1*sigmabb*t50)
      t61 = sigmabb**2
      t62 = t47**2
      t72 = 1/rho
      t73 = t72**(1.D0/3.D0)
      t76 = t72**(1.D0/6.D0)
      t79 = dsqrt(t72)
      t81 = t73**2
      t87 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t76
     #+0.2225569421150687D1*t73+0.8004286349993634D0*t79
     #+0.1897004325747559D0*t81))
      t89 = 0.62182D-1*(1.D0+0.1325688999052018D0*t73)*t87
      t100 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t76
     #+0.2247591863577616D1*t73+0.4300972471276643D0*t79
     #+0.1911512595127338D0*t81))
      t103 = rhoa-1.D0*rhob
      t104 = t103*t72
      t105 = 1.D0+t104
      t106 = t105**(1.D0/3.D0)
      t109 = 1.D0-1.D0*t104
      t110 = t109**(1.D0/3.D0)
      t112 = t106*t105+t110*t109-2.D0
      t113 = t103**2
      t114 = t113**2
      t115 = rho**2
      t116 = t115**2
      t118 = t114/t116
      t123 = 0.3799575D-1*(1.D0+0.6901399211255825D-1*t73)*t100*t112*
     #(1.D0-1.D0*t118)
      t134 = dlog(1.D0+0.321646831778707D2/(0.1112037486309468D2*t76
     #+0.3844746237447211D1*t73+0.1644733775567609D1*t79
     #+0.2405871291288192D0*t81))
      t140 = 0.1923661050931536D1*(-0.3109D-1*(1.D0
     #+0.1274696188700087D0*t73)*t134+t89)*t112*t118
      t141 = t106**2
      t143 = t110**2
      t145 = 0.5D0*t141+0.5D0*t143
      t146 = t145**2
      t147 = t146*t145
      t148 = 1/t146
      t150 = rho**(1.D0/3.D0)
      t152 = 1/t150/t115
      t159 = dexp(-0.4042761511756372D2*(-t89+t123+t140)/t147)
      t160 = t159-1.D0
      t161 = 1/t160
      t162 = sigma**2
      t164 = t146**2
      t166 = t150**2
      t169 = 1/t164/t166/t116
      t177 = t160**2
      t187 = dlog(1.D0+0.2697586091519874D1*(0.634682060977037D-1
     #*sigma*t148*t152+0.1086645186223595D-1*t161*t162*t169)/(1.D0
     #+0.1712109500228824D0*t161*sigma*t148*t152+0.2931318940773793D-1
     #/t177*t162*t169))
      t208 = dexp(-0.261211729852336D1*t146/t166/t115*sigma)
      zk(i) = -0.9305257363491D0*t5*(1.D0+t12+0.1645530784602056D-1*
     #(0.2743D0-0.1508D0*t19)*sigmaaa*t16)/(1.D0+t12
     #+0.1083108625229223D-5*t27/t4/t28/rhoa)-0.9305257363491D0*t39*
     #(1.D0+t46+0.1645530784602056D-1*(0.2743D0-0.1508D0*t53)*sigmabb
     #*t50)/(1.D0+t46+0.1083108625229223D-5*t61/t38/t62/rhob)+rho*(
     #-t89+t123+t140+0.2473556743557577D-1*t147*t187+0.1D1*(0.1D-2*
     #(0.2568D1+0.1443307452126544D2*t73+0.2843543831490386D-2*t81)/
     #(1.D0+0.5411317332115466D1*t73+0.1816419932959077D0*t81
     #+0.1763993811759022D-1*t72)-0.1853571428571429D-2)*t145*sigma
     #*t152*t208)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = dsqrt(sigmabb)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhob**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigmabb*t14
      t17 = dexp(-0.1645530784602056D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigmabb
      t23 = 1.D0+t10+0.1645530784602056D-1*t20*t14
      t24 = t3*t23
      t25 = sigmabb**2
      t26 = t11**2
      t27 = t26*rhob
      t29 = 1/t2/t27
      t32 = 1.D0+t10+0.1083108625229223D-5*t25*t29
      t33 = 1/t32
      t36 = 1/rhob
      t37 = t36**(1.D0/3.D0)
      t39 = 1.D0+0.1274696188700087D0*t37
      t40 = t36**(1.D0/6.D0)
      t43 = dsqrt(t36)
      t45 = t37**2
      t47 = 0.1112037486309468D2*t40+0.3844746237447211D1*t37
     #+0.1644733775567609D1*t43+0.2405871291288192D0*t45
      t50 = 1.D0+0.321646831778707D2/t47
      t51 = dlog(t50)
      t52 = t39*t51
      t53 = 0.3109D-1*t52
      t55 = 1/t2/t11
      t59 = dexp(0.2513789108010112D1*t52)
      t60 = t59-1.D0
      t61 = 1/t60
      t62 = t61*t25
      t64 = 1/t12/t26
      t67 = 0.1007494971260294D0*sigmabb*t55+0.2738174287780083D-1*t62
     #*t64
      t68 = t61*sigmabb
      t71 = t60**2
      t72 = 1/t71
      t73 = t72*t25
      t76 = 1.D0+0.2717804421747983D0*t68*t55+0.7386460874872889D-1
     #*t73*t64
      t77 = 1/t76
      t80 = 1.D0+0.2697586091519874D1*t67*t77
      t81 = dlog(t80)
      t82 = 0.1236778371778789D-1*t81
      t85 = 0.2568D1+0.1443307452126544D2*t37+0.2843543831490386D-2*t45
      t89 = 1.D0+0.5411317332115466D1*t37+0.1816419932959077D0*t45
     #+0.1763993811759022D-1*t36
      t90 = 1/t89
      t93 = 0.1D-2*t85*t90-0.1853571428571429D-2
      t94 = t93*sigmabb
      t95 = t55*t17
      t97 = 0.7937005259840997D0*t94*t95
      zk(i) = -0.9305257363491D0*t24*t33+rhob*(-t53+t82+t97)
      vrhoa(i) = 0.D0
      t105 = 0.3360034800657352D-1*t4*t55*t8
      t106 = t11*rhob
      t108 = 1/t12/t106
      t112 = dsqrt(1.D0+0.10000117555961D1*t15)
      t113 = 1/t112
      t115 = 0.3360054550205309D-1*sigmabb*t108*t113
      t116 = t26*t11
      t119 = t25/t2/t116
      t128 = t32**2
      t129 = 1/t128
      t136 = 1/t11
      t137 = 1/t45*t136
      t139 = 0.1321010150222857D-2*t137*t51
      t140 = t47**2
      t143 = t40**2
      t144 = t143**2
      t154 = 1/t37*t136
      t160 = 0.1D1*t39/t140*(-0.1853395810515781D1/t144/t40*t136
     #-0.128158207914907D1*t137-0.8223668877838045D0/t43*t136
     #-0.1603914194192128D0*t154)/t50
      t162 = 1/t2/t106
      t165 = t139+t160
      t167 = t64*t165*t59
      t171 = 1/t12/t27
      t177 = t76**2
      t179 = t67/t177
      t180 = t72*sigmabb
      t198 = 1/t80
      t206 = t89**2
      s1 = -0.12407009817988D1*t2*t23*t33-0.9305257363491D0*t3*(-t105
     #-t115-0.1088885204563779D-1*t119*t17-0.4388082092272149D-1*t20
     #*t108)*t33+0.9305257363491D0*t24*t129*(-t105-t115
     #-0.5776579334555855D-5*t119)
      vrhob(i) = s1-t53+t82+t97+rhob*(t139+t160+0.1236778371778789D-1*
     #(0.2697586091519874D1*(-0.2350821599607352D0*sigmabb*t162
     #+0.2213957124623647D1*t73*t167-0.1277814667630705D0*t62*t171)
     #*t77-0.2697586091519874D1*t179*(0.2197487022544806D2*t180*t55
     #*t165*t59-0.6341543650745294D0*t68*t162+0.1194467989321217D2/t71
     #/t60*t25*t167-0.3447015074940681D0*t73*t171))*t198
     #+0.7937005259840997D0*(0.1D-2*(-0.4811024840421814D1*t137
     #-0.1895695887660258D-2*t154)*t90-0.1D-2*t85/t206*(
     #-0.1803772444038489D1*t137-0.1210946621972718D0*t154
     #-0.1763993811759022D-1*t136))*sigmabb*t95-0.1851967893962899D1
     #*t94*t162*t17+0.3482823064697813D1*t93*t25/t116*t17)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t232 = 0.1260013050246507D-1/t4*t5*t8
      t234 = 0.1260020456326991D-1*t14*t113
      vsigmabb(i) = -0.9305257363491D0*t3*(t232+t234
     #+0.408331951711417D-2*t29*t17*sigmabb+0.1645530784602056D-1*t19
     #*t14)*t33+0.9305257363491D0*t24*t129*(t232+t234
     #+0.2166217250458446D-5*sigmabb*t29)+rhob*(0.1236778371778789D-1*
     #(0.2697586091519874D1*(0.1007494971260294D0*t55
     #+0.5476348575560166D-1*t68*t64)*t77-0.2697586091519874D1*t179*
     #(0.2717804421747983D0*t61*t55+0.1477292174974578D0*t180*t64))
     #*t198+0.7937005259840997D0*t93*t55*t17-0.130605864926168D1*t94
     #/t27*t17)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = dsqrt(sigmaaa)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhoa**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigmaaa*t14
      t17 = dexp(-0.1645530784602056D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigmaaa
      t23 = 1.D0+t10+0.1645530784602056D-1*t20*t14
      t24 = t3*t23
      t25 = sigmaaa**2
      t26 = t11**2
      t27 = t26*rhoa
      t29 = 1/t2/t27
      t32 = 1.D0+t10+0.1083108625229223D-5*t25*t29
      t33 = 1/t32
      t36 = 1/rhoa
      t37 = t36**(1.D0/3.D0)
      t39 = 1.D0+0.1274696188700087D0*t37
      t40 = t36**(1.D0/6.D0)
      t43 = dsqrt(t36)
      t45 = t37**2
      t47 = 0.1112037486309468D2*t40+0.3844746237447211D1*t37
     #+0.1644733775567609D1*t43+0.2405871291288192D0*t45
      t50 = 1.D0+0.321646831778707D2/t47
      t51 = dlog(t50)
      t52 = t39*t51
      t53 = 0.3109D-1*t52
      t55 = 1/t2/t11
      t59 = dexp(0.2513789108010112D1*t52)
      t60 = t59-1.D0
      t61 = 1/t60
      t62 = t61*t25
      t64 = 1/t12/t26
      t67 = 0.1007494971260294D0*sigmaaa*t55+0.2738174287780083D-1*t62
     #*t64
      t68 = t61*sigmaaa
      t71 = t60**2
      t72 = 1/t71
      t73 = t72*t25
      t76 = 1.D0+0.2717804421747983D0*t68*t55+0.7386460874872889D-1
     #*t73*t64
      t77 = 1/t76
      t80 = 1.D0+0.2697586091519874D1*t67*t77
      t81 = dlog(t80)
      t82 = 0.1236778371778789D-1*t81
      t85 = 0.2568D1+0.1443307452126544D2*t37+0.2843543831490386D-2*t45
      t89 = 1.D0+0.5411317332115466D1*t37+0.1816419932959077D0*t45
     #+0.1763993811759022D-1*t36
      t90 = 1/t89
      t93 = 0.1D-2*t85*t90-0.1853571428571429D-2
      t94 = t93*sigmaaa
      t95 = t55*t17
      t97 = 0.7937005259840997D0*t94*t95
      zk(i) = -0.9305257363491D0*t24*t33+rhoa*(-t53+t82+t97)
      t105 = 0.3360034800657352D-1*t4*t55*t8
      t106 = t11*rhoa
      t108 = 1/t12/t106
      t112 = dsqrt(1.D0+0.10000117555961D1*t15)
      t113 = 1/t112
      t115 = 0.3360054550205309D-1*sigmaaa*t108*t113
      t116 = t26*t11
      t119 = t25/t2/t116
      t128 = t32**2
      t129 = 1/t128
      t136 = 1/t11
      t137 = 1/t45*t136
      t139 = 0.1321010150222857D-2*t137*t51
      t140 = t47**2
      t143 = t40**2
      t144 = t143**2
      t154 = 1/t37*t136
      t160 = 0.1D1*t39/t140*(-0.1853395810515781D1/t144/t40*t136
     #-0.128158207914907D1*t137-0.8223668877838045D0/t43*t136
     #-0.1603914194192128D0*t154)/t50
      t162 = 1/t2/t106
      t165 = t139+t160
      t167 = t64*t165*t59
      t171 = 1/t12/t27
      t177 = t76**2
      t179 = t67/t177
      t180 = t72*sigmaaa
      t198 = 1/t80
      t206 = t89**2
      s1 = -0.12407009817988D1*t2*t23*t33-0.9305257363491D0*t3*(-t105
     #-t115-0.1088885204563779D-1*t119*t17-0.4388082092272149D-1*t20
     #*t108)*t33+0.9305257363491D0*t24*t129*(-t105-t115
     #-0.5776579334555855D-5*t119)
      vrhoa(i) = s1-t53+t82+t97+rhoa*(t139+t160+0.1236778371778789D-1*
     #(0.2697586091519874D1*(-0.2350821599607352D0*sigmaaa*t162
     #+0.2213957124623647D1*t73*t167-0.1277814667630705D0*t62*t171)
     #*t77-0.2697586091519874D1*t179*(0.2197487022544806D2*t180*t55
     #*t165*t59-0.6341543650745294D0*t68*t162+0.1194467989321217D2/t71
     #/t60*t25*t167-0.3447015074940681D0*t73*t171))*t198
     #+0.7937005259840997D0*(0.1D-2*(-0.4811024840421814D1*t137
     #-0.1895695887660258D-2*t154)*t90-0.1D-2*t85/t206*(
     #-0.1803772444038489D1*t137-0.1210946621972718D0*t154
     #-0.1763993811759022D-1*t136))*sigmaaa*t95-0.1851967893962899D1
     #*t94*t162*t17+0.3482823064697813D1*t93*t25/t116*t17)
      vrhob(i) = 0.D0
      t232 = 0.1260013050246507D-1/t4*t5*t8
      t234 = 0.1260020456326991D-1*t14*t113
      vsigmaaa(i) = -0.9305257363491D0*t3*(t232+t234
     #+0.408331951711417D-2*t29*t17*sigmaaa+0.1645530784602056D-1*t19
     #*t14)*t33+0.9305257363491D0*t24*t129*(t232+t234
     #+0.2166217250458446D-5*sigmaaa*t29)+rhoa*(0.1236778371778789D-1*
     #(0.2697586091519874D1*(0.1007494971260294D0*t55
     #+0.5476348575560166D-1*t68*t64)*t77-0.2697586091519874D1*t179*
     #(0.2717804421747983D0*t61*t55+0.1477292174974578D0*t180*t64))
     #*t198+0.7937005259840997D0*t93*t55*t17-0.130605864926168D1*t94
     #/t27*t17)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = dsqrt(sigmaaa)
      t7 = 1/t5
      t8 = t6*t7
      t10 = dlog(0.1000005877780776D1*t8+dsqrt(1+0.10000117555961D1*t8
     #**2))
      t12 = 0.2520026100493014D-1*t8*t10
      t13 = rhoa**2
      t14 = t4**2
      t16 = 1/t14/t13
      t17 = sigmaaa*t16
      t19 = dexp(-0.1645530784602056D1*t17)
      t21 = 0.2743D0-0.1508D0*t19
      t22 = t21*sigmaaa
      t25 = 1.D0+t12+0.1645530784602056D-1*t22*t16
      t26 = t5*t25
      t27 = sigmaaa**2
      t28 = t13**2
      t31 = 1/t4/t28/rhoa
      t34 = 1.D0+t12+0.1083108625229223D-5*t27*t31
      t35 = 1/t34
      t38 = rhob**(1.D0/3.D0)
      t39 = t38*rhob
      t40 = dsqrt(sigmabb)
      t41 = 1/t39
      t42 = t40*t41
      t44 = dlog(0.1000005877780776D1*t42+dsqrt(1+0.10000117555961D1
     #*t42**2))
      t46 = 0.2520026100493014D-1*t42*t44
      t47 = rhob**2
      t48 = t38**2
      t50 = 1/t48/t47
      t51 = sigmabb*t50
      t53 = dexp(-0.1645530784602056D1*t51)
      t55 = 0.2743D0-0.1508D0*t53
      t56 = t55*sigmabb
      t59 = 1.D0+t46+0.1645530784602056D-1*t56*t50
      t60 = t39*t59
      t61 = sigmabb**2
      t62 = t47**2
      t65 = 1/t38/t62/rhob
      t68 = 1.D0+t46+0.1083108625229223D-5*t61*t65
      t69 = 1/t68
      t72 = 1/rho
      t73 = t72**(1.D0/3.D0)
      t75 = 1.D0+0.1325688999052018D0*t73
      t76 = t72**(1.D0/6.D0)
      t79 = dsqrt(t72)
      t81 = t73**2
      t83 = 0.598255043577108D1*t76+0.2225569421150687D1*t73
     #+0.8004286349993634D0*t79+0.1897004325747559D0*t81
      t86 = 1.D0+0.160818243221511D2/t83
      t87 = dlog(t86)
      t89 = 0.62182D-1*t75*t87
      t91 = 1.D0+0.6901399211255825D-1*t73
      t96 = 0.8157414703487641D1*t76+0.2247591863577616D1*t73
     #+0.4300972471276643D0*t79+0.1911512595127338D0*t81
      t99 = 1.D0+0.2960857464321668D2/t96
      t100 = dlog(t99)
      t101 = t91*t100
      t103 = rhoa-1.D0*rhob
      t104 = t103*t72
      t105 = 1.D0+t104
      t106 = t105**(1.D0/3.D0)
      t109 = 1.D0-1.D0*t104
      t110 = t109**(1.D0/3.D0)
      t112 = t106*t105+t110*t109-2.D0
      t113 = t103**2
      t114 = t113**2
      t115 = rho**2
      t116 = t115**2
      t117 = 1/t116
      t118 = t114*t117
      t120 = 1.D0-1.D0*t118
      t123 = 0.3799575D-1*t101*t112*t120
      t125 = 1.D0+0.1274696188700087D0*t73
      t130 = 0.1112037486309468D2*t76+0.3844746237447211D1*t73
     #+0.1644733775567609D1*t79+0.2405871291288192D0*t81
      t133 = 1.D0+0.321646831778707D2/t130
      t134 = dlog(t133)
      t137 = -0.3109D-1*t125*t134+t89
      t138 = t137*t112
      t140 = 0.1923661050931536D1*t138*t118
      t141 = t106**2
      t143 = t110**2
      t145 = 0.5D0*t141+0.5D0*t143
      t146 = t145**2
      t147 = t146*t145
      t148 = 1/t146
      t149 = sigma*t148
      t150 = rho**(1.D0/3.D0)
      t152 = 1/t150/t115
      t155 = -t89+t123+t140
      t156 = 1/t147
      t159 = dexp(-0.4042761511756372D2*t155*t156)
      t160 = t159-1.D0
      t161 = 1/t160
      t162 = sigma**2
      t163 = t161*t162
      t164 = t146**2
      t165 = 1/t164
      t166 = t150**2
      t168 = 1/t166/t116
      t169 = t165*t168
      t172 = 0.634682060977037D-1*t149*t152+0.1086645186223595D-1*t163
     #*t169
      t173 = t161*sigma
      t174 = t148*t152
      t177 = t160**2
      t178 = 1/t177
      t179 = t178*t162
      t182 = 1.D0+0.1712109500228824D0*t173*t174+0.2931318940773793D-1
     #*t179*t169
      t183 = 1/t182
      t186 = 1.D0+0.2697586091519874D1*t172*t183
      t187 = dlog(t186)
      t189 = 0.2473556743557577D-1*t147*t187
      t192 = 0.2568D1+0.1443307452126544D2*t73+0.2843543831490386D-2*t81
      t196 = 1.D0+0.5411317332115466D1*t73+0.1816419932959077D0*t81
     #+0.1763993811759022D-1*t72
      t197 = 1/t196
      t200 = 0.1D-2*t192*t197-0.1853571428571429D-2
      t201 = t200*t145
      t204 = 1/t166/t115
      t208 = dexp(-0.261211729852336D1*t146*t204*sigma)
      t209 = sigma*t152*t208
      t211 = 0.1D1*t201*t209
      zk(i) = -0.9305257363491D0*t26*t35-0.9305257363491D0*t60*t69+rho
     #*(-t89+t123+t140+t189+t211)
      t221 = 0.3360034800657352D-1*t6/t4/t13*t10
      t224 = 1/t14/t13/rhoa
      t228 = dsqrt(1.D0+0.10000117555961D1*t17)
      t229 = 1/t228
      t231 = 0.3360054550205309D-1*sigmaaa*t224*t229
      t235 = t27/t4/t28/t13
      t244 = t34**2
      t245 = 1/t244
      t255 = 0.1333333333333333D1*t106*t72-0.1333333333333333D1*t110*t72
      t258 = 0.3799575D-1*t101*t255*t120
      t259 = t113*t103
      t262 = t101*t112*t259*t117
      t263 = 0.151983D0*t262
      t266 = 0.1923661050931536D1*t137*t255*t118
      t268 = t138*t259*t117
      t269 = 0.7694644203726145D1*t268
      t270 = t146*t187
      t271 = 1/t106
      t274 = 1/t110
      t277 = 0.3333333333333333D0*t271*t72-0.3333333333333333D0*t274*t72
      t280 = sigma*t156
      t284 = t179*t165
      t288 = t155*t165
      t291 = -0.4042761511756372D2*(t258-t263+t266+t269)*t156
     #+0.1212828453526912D3*t288*t277
      t293 = t168*t291*t159
      t298 = 1/t164/t145*t168
      t299 = t298*t277
      t305 = t182**2
      t307 = t172/t305
      t308 = t178*sigma
      t309 = t308*t148
      t314 = t156*t152
      t321 = 1/t177/t160*t162*t165
      t331 = 1/t186
      t338 = t200*t146*t162
      t339 = t116*rho
      t340 = 1/t339
      t348 = 1/t115
      t349 = 1/t81*t348
      t350 = t349*t87
      t351 = 0.2747799777968419D-2*t350
      t352 = t83**2
      t355 = t76**2
      t356 = t355**2
      t359 = 1/t356/t76*t348
      t363 = 1/t79*t348
      t366 = 1/t73*t348
      t371 = t75/t352*(-0.99709173929518D0*t359-0.7418564737168958D0
     #*t349-0.4002143174996817D0*t363-0.1264669550498372D0*t366)/t86
      t372 = 0.1D1*t371
      t376 = 0.8740794636035784D-3*t349*t100*t112*t120
      t377 = t96**2
      t390 = 0.1125D1*t91/t377*(-0.135956911724794D1*t359
     #-0.7491972878592054D0*t349-0.2150486235638321D0*t363
     #-0.1274341730084892D0*t366)/t99*t112*t120
      t397 = -0.1333333333333333D1*t106*t103*t348+0.1333333333333333D1
     #*t110*t103*t348
      t400 = 0.3799575D-1*t101*t397*t120
      t404 = 0.151983D0*t101*t112*t114*t340
      t407 = t130**2
      t424 = 0.1923661050931536D1*(0.1321010150222857D-2*t349*t134
     #+0.1D1*t125/t407*(-0.1853395810515781D1*t359-0.128158207914907D1
     #*t349-0.8223668877838045D0*t363-0.1603914194192128D0*t366)/t133
     #-0.2747799777968419D-2*t350-0.1D1*t371)*t112*t118
      t427 = 0.1923661050931536D1*t137*t397*t118
      t430 = 0.7694644203726145D1*t138*t114*t340
      t437 = -0.3333333333333333D0*t271*t103*t348+0.3333333333333333D0
     #*t274*t103*t348
      t443 = t115*rho
      t445 = 1/t150/t443
      t453 = -0.4042761511756372D2*(t351+t372-t376-t390+t400+t404+t424
     #+t427-t430)*t156+0.1212828453526912D3*t288*t437
      t455 = t168*t453*t159
      t458 = t298*t437
      t463 = t165/t166/t339
      t497 = t196**2
      s1 = t351+t372-t376-t390+t400+t404+t424
      s2 = s1+t427-t430+0.7420670230672731D-1*t270*t437
      s3 = s2+0.2473556743557577D-1*t147*(0.2697586091519874D1*(
     #-0.1269364121954074D0*t280*t152*t437-0.148092480894642D0*t149
     #*t445-0.1086645186223595D-1*t284*t455-0.4346580744894379D-1*t163
     #*t458-0.5071010869043442D-1*t163*t463)*t183-0.2697586091519874D1
     #*t307*(-0.1712109500228824D0*t309*t152*t453*t159
     #-0.3424219000457648D0*t173*t314*t437-0.3994922167200589D0*t173
     #*t148*t445-0.5862637881547585D-1*t321*t455-0.1172527576309517D0
     #*t179*t458-0.136794883902777D0*t179*t463))*t331+0.1D1*(0.1D-2*(
     #-0.4811024840421814D1*t349-0.1895695887660258D-2*t366)*t197
     #-0.1D-2*t192/t497*(-0.1803772444038489D1*t349
     #-0.1210946621972718D0*t366-0.1763993811759022D-1*t348))*t145*t209
      t532 = s3+0.1D1*t200*t437*t209-0.2333333333333333D1*t201*sigma
     #*t445*t208+0.1D1*t201*sigma*t152*(-0.522423459704672D1*t145*t204
     #*sigma*t437+0.6965646129395627D1*t146/t166/t443*sigma)*t208
      t533 = rho*t532
      vrhoa(i) = -0.12407009817988D1*t4*t25*t35-0.9305257363491D0*t5*(
     #-t221-t231-0.1088885204563779D-1*t235*t19-0.4388082092272149D-1
     #*t22*t224)*t35+0.9305257363491D0*t26*t245*(-t221-t231
     #-0.5776579334555855D-5*t235)+rho*(t258-t263+t266+t269
     #+0.7420670230672731D-1*t270*t277+0.2473556743557577D-1*t147*
     #(0.2697586091519874D1*(-0.1269364121954074D0*t280*t152*t277
     #-0.1086645186223595D-1*t284*t293-0.4346580744894379D-1*t163*t299
     #)*t183-0.2697586091519874D1*t307*(-0.1712109500228824D0*t309
     #*t152*t291*t159-0.3424219000457648D0*t173*t314*t277
     #-0.5862637881547585D-1*t321*t293-0.1172527576309517D0*t179*t299)
     #)*t331+0.1D1*t200*t277*t209-0.522423459704672D1*t338*t340*t277
     #*t208)-t89+t123+t140+t189+t211+t533
      t541 = 0.3360034800657352D-1*t40/t38/t47*t44
      t544 = 1/t48/t47/rhob
      t548 = dsqrt(1.D0+0.10000117555961D1*t51)
      t549 = 1/t548
      t551 = 0.3360054550205309D-1*sigmabb*t544*t549
      t555 = t61/t38/t62/t47
      t564 = t68**2
      t565 = 1/t564
      t571 = -t255
      t574 = 0.3799575D-1*t101*t571*t120
      t575 = 0.151983D0*t262
      t578 = 0.1923661050931536D1*t137*t571*t118
      t579 = 0.7694644203726145D1*t268
      t580 = -t277
      t591 = -0.4042761511756372D2*(t574+t575+t578-t579)*t156
     #+0.1212828453526912D3*t288*t580
      t593 = t168*t591*t159
      t596 = t298*t580
      vrhob(i) = -0.12407009817988D1*t38*t59*t69-0.9305257363491D0*t39
     #*(-t541-t551-0.1088885204563779D-1*t555*t53
     #-0.4388082092272149D-1*t56*t544)*t69+0.9305257363491D0*t60*t565*
     #(-t541-t551-0.5776579334555855D-5*t555)+rho*(t574+t575+t578-t579
     #+0.7420670230672731D-1*t270*t580+0.2473556743557577D-1*t147*
     #(0.2697586091519874D1*(-0.1269364121954074D0*t280*t152*t580
     #-0.1086645186223595D-1*t284*t593-0.4346580744894379D-1*t163*t596
     #)*t183-0.2697586091519874D1*t307*(-0.1712109500228824D0*t309
     #*t152*t591*t159-0.3424219000457648D0*t173*t314*t580
     #-0.5862637881547585D-1*t321*t593-0.1172527576309517D0*t179*t596)
     #)*t331+0.1D1*t200*t580*t209-0.522423459704672D1*t338*t340*t580
     #*t208)-t89+t123+t140+t189+t211+t533
      t632 = 0.1260013050246507D-1/t6*t7*t10
      t634 = 0.1260020456326991D-1*t16*t229
      t677 = rho*(0.2473556743557577D-1*t147*(0.2697586091519874D1*
     #(0.634682060977037D-1*t174+0.2173290372447189D-1*t173*t169)*t183
     #-0.2697586091519874D1*t307*(0.1712109500228824D0*t161*t148*t152
     #+0.5862637881547585D-1*t308*t169))*t331+0.1D1*t201*t152*t208
     #-0.261211729852336D1*t200*t147*sigma*t340*t208)
      vsigmaaa(i) = -0.9305257363491D0*t5*(t632+t634
     #+0.408331951711417D-2*t31*t19*sigmaaa+0.1645530784602056D-1*t21
     #*t16)*t35+0.9305257363491D0*t26*t245*(t632+t634
     #+0.2166217250458446D-5*sigmaaa*t31)+t677
      vsigmaab(i) = 2.D0*t677
      t681 = 0.1260013050246507D-1/t40*t41*t44
      t683 = 0.1260020456326991D-1*t50*t549
      vsigmabb(i) = -0.9305257363491D0*t39*(t681+t683
     #+0.408331951711417D-2*t65*t53*sigmabb+0.1645530784602056D-1*t55
     #*t50)*t69+0.9305257363491D0*t60*t565*(t681+t683
     #+0.2166217250458446D-5*sigmabb*t65)+t677
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t4 = dsqrt(sigmabb)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhob**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigmabb*t14
      t17 = dexp(-0.1645530784602056D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigmabb
      t23 = 1.D0+t10+0.1645530784602056D-1*t20*t14
      t24 = t3*t23
      t25 = sigmabb**2
      t26 = t11**2
      t27 = t26*rhob
      t29 = 1/t2/t27
      t32 = 1.D0+t10+0.1083108625229223D-5*t25*t29
      t33 = 1/t32
      t36 = 1/rhob
      t37 = t36**(1.D0/3.D0)
      t39 = 1.D0+0.1274696188700087D0*t37
      t40 = t36**(1.D0/6.D0)
      t43 = dsqrt(t36)
      t45 = t37**2
      t47 = 0.1112037486309468D2*t40+0.3844746237447211D1*t37
     #+0.1644733775567609D1*t43+0.2405871291288192D0*t45
      t50 = 1.D0+0.321646831778707D2/t47
      t51 = dlog(t50)
      t52 = t39*t51
      t53 = 0.3109D-1*t52
      t55 = 1/t2/t11
      t59 = dexp(0.2513789108010112D1*t52)
      t60 = t59-1.D0
      t61 = 1/t60
      t62 = t61*t25
      t64 = 1/t12/t26
      t67 = 0.1007494971260294D0*sigmabb*t55+0.2738174287780083D-1*t62
     #*t64
      t68 = t61*sigmabb
      t71 = t60**2
      t72 = 1/t71
      t73 = t72*t25
      t76 = 1.D0+0.2717804421747983D0*t68*t55+0.7386460874872889D-1
     #*t73*t64
      t77 = 1/t76
      t80 = 1.D0+0.2697586091519874D1*t67*t77
      t81 = dlog(t80)
      t82 = 0.1236778371778789D-1*t81
      t85 = 0.2568D1+0.1443307452126544D2*t37+0.2843543831490386D-2*t45
      t89 = 1.D0+0.5411317332115466D1*t37+0.1816419932959077D0*t45
     #+0.1763993811759022D-1*t36
      t90 = 1/t89
      t93 = 0.1D-2*t85*t90-0.1853571428571429D-2
      t94 = t93*sigmabb
      t95 = t55*t17
      t97 = 0.7937005259840997D0*t94*t95
      zk(i) = -0.9305257363491D0*t24*t33+rhob*(-t53+t82+t97)
      vrhoa(i) = 0.D0
      t100 = t2*t23
      t105 = 0.3360034800657352D-1*t4*t55*t8
      t106 = t11*rhob
      t108 = 1/t12/t106
      t111 = 1.D0+0.10000117555961D1*t15
      t112 = dsqrt(t111)
      t113 = 1/t112
      t115 = 0.3360054550205309D-1*sigmabb*t108*t113
      t116 = t26*t11
      t119 = t25/t2/t116
      t124 = -t105-t115-0.1088885204563779D-1*t119*t17
     #-0.4388082092272149D-1*t20*t108
      t125 = t3*t124
      t128 = t32**2
      t129 = 1/t128
      t131 = -t105-t115-0.5776579334555855D-5*t119
      t132 = t129*t131
      t135 = 1/t45
      t136 = 1/t11
      t137 = t135*t136
      t138 = t137*t51
      t139 = 0.1321010150222857D-2*t138
      t140 = t47**2
      t141 = 1/t140
      t142 = t39*t141
      t143 = t40**2
      t144 = t143**2
      t145 = t144*t40
      t146 = 1/t145
      t150 = 1/t43
      t153 = 1/t37
      t154 = t153*t136
      t156 = -0.1853395810515781D1*t146*t136-0.128158207914907D1*t137
     #-0.8223668877838045D0*t150*t136-0.1603914194192128D0*t154
      t157 = 1/t50
      t159 = t142*t156*t157
      t160 = 0.1D1*t159
      t162 = 1/t2/t106
      t165 = t139+t160
      t167 = t64*t165*t59
      t171 = 1/t12/t27
      t174 = -0.2350821599607352D0*sigmabb*t162+0.2213957124623647D1
     #*t73*t167-0.1277814667630705D0*t62*t171
      t177 = t76**2
      t178 = 1/t177
      t179 = t67*t178
      t180 = t72*sigmabb
      t188 = 1/t71/t60
      t189 = t188*t25
      t194 = 0.2197487022544806D2*t180*t55*t165*t59
     #-0.6341543650745294D0*t68*t162+0.1194467989321217D2*t189*t167
     #-0.3447015074940681D0*t73*t171
      t197 = 0.2697586091519874D1*t174*t77-0.2697586091519874D1*t179
     #*t194
      t198 = 1/t80
      t199 = t197*t198
      t203 = -0.4811024840421814D1*t137-0.1895695887660258D-2*t154
      t206 = t89**2
      t207 = 1/t206
      t208 = t85*t207
      t212 = -0.1803772444038489D1*t137-0.1210946621972718D0*t154
     #-0.1763993811759022D-1*t136
      t215 = 0.1D-2*t203*t90-0.1D-2*t208*t212
      t216 = t215*sigmabb
      t217 = t216*t95
      t219 = t162*t17
      t220 = t94*t219
      t222 = t93*t25
      t224 = 1/t116*t17
      t225 = t222*t224
      vrhob(i) = -0.12407009817988D1*t100*t33-0.9305257363491D0*t125
     #*t33+0.9305257363491D0*t24*t132-t53+t82+t97+rhob*(t139+t160
     #+0.1236778371778789D-1*t199+0.7937005259840997D0*t217
     #-0.1851967893962899D1*t220+0.3482823064697813D1*t225)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t232 = 0.1260013050246507D-1/t4*t5*t8
      t234 = 0.1260020456326991D-1*t14*t113
      t235 = t29*t17
      t241 = t3*(t232+t234+0.408331951711417D-2*t235*sigmabb
     #+0.1645530784602056D-1*t19*t14)
      t246 = t232+t234+0.2166217250458446D-5*sigmabb*t29
      t247 = t129*t246
      t253 = 0.1007494971260294D0*t55+0.5476348575560166D-1*t68*t64
      t260 = 0.2717804421747983D0*t61*t55+0.1477292174974578D0*t180*t64
      t263 = 0.2697586091519874D1*t253*t77-0.2697586091519874D1*t179
     #*t260
      t269 = 1/t27
      vsigmabb(i) = -0.9305257363491D0*t241*t33+0.9305257363491D0*t24
     #*t247+rhob*(0.1236778371778789D-1*t263*t198+0.7937005259840997D0
     #*t93*t55*t17-0.130605864926168D1*t94*t269*t17)
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t286 = 0.7840081201533821D-1*t4*t162*t8
      t289 = 0.1680027275102654D0*sigmabb*t64*t113
      t290 = t26*t106
      t293 = t25/t2/t290
      t295 = 1/t112/t111
      t297 = 0.4480125399532632D-1*t293*t295
      t300 = t25*sigmabb
      t301 = t26**2
      t316 = 1/t128/t32
      t317 = t131**2
      t334 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t40
     #+0.2225569421150687D1*t37+0.8004286349993634D0*t43
     #+0.1897004325747559D0*t45))
      t346 = t156**2
      t349 = 0.2D1*t39/t140/t47*t346*t157
      t350 = 1/t106
      t351 = t135*t350
      t353 = 0.1D-22*t351*t334
      t356 = 1/t26
      t357 = 1/t45/t36*t356
      t359 = 0.8806734334819047D-3*t357*t51
      t361 = 0.2642020300445714D-2*t351*t51
      t365 = 0.8497974591333914D-1*t137*t141*t156*t157
      t382 = 1/t37/t36*t356
      t384 = t153*t350
      t389 = 0.1D1*t142*(-0.1544496508763151D1/t145/t36*t356
     #+0.3706791621031562D1*t146*t350-0.854388052766047D0*t357
     #+0.2563164158298141D1*t351-0.4111834438919023D0/t43/t36*t356
     #+0.1644733775567609D1*t150*t350-0.5346380647307093D-1*t382
     #+0.3207828388384256D0*t384)*t157
      t390 = t140**2
      t393 = t50**2
      t397 = 0.321646831778707D2*t39/t390*t346/t393
      t411 = t212**2
      t427 = 1/t2/t26
      t430 = t165**2
      t431 = t64*t430
      t433 = dexp(0.5027578216020225D1*t52)
      t434 = t431*t433
      t438 = t171*t165*t59
      t441 = -t353+t359-t361-t365-t349+t389+t397
      t443 = t64*t441*t59
      t446 = t431*t59
      t450 = 1/t12/t116
      t461 = t67/t177/t76
      t462 = t194**2
      t466 = t55*t430
      t483 = t71**2
      t506 = t197**2
      t507 = t80**2
      t508 = 1/t507
      s1 = -t353+t359-t361-t365-t349+t389+t397
      s3 = s1+0.7937005259840997D0*(0.1D-2*(-0.3207349893614542D1*t357
     #+0.9622049680843627D1*t351-0.6318986292200858D-3*t382
     #+0.3791391775320515D-2*t384)*t90-0.2D-2*t203*t207*t212+0.2D-2
     #*t85/t206/t89*t411-0.1D-2*t208*(-0.1202514962692326D1*t357
     #+0.3607544888076978D1*t351-0.4036488739909061D-1*t382
     #+0.2421893243945437D0*t384+0.3527987623518044D-1*t350))*sigmabb
     #*t95
      s2 = s3+0.1236778371778789D-1*(0.2697586091519874D1*
     #(0.7836071998691172D0*sigmabb*t427+0.3580200260842915D3*t189
     #*t434-0.2066359982982071D2*t73*t438+0.2213957124623647D1*t73
     #*t443-0.1790100130421458D3*t73*t446+0.7240949783240664D0*t62
     #*t450)*t77-0.5395172183039748D1*t174*t178*t194
     #+0.5395172183039748D1*t461*t462-0.2697586091519874D1*t179*
     #(0.35535663829313D4*t188*sigmabb*t466*t433-0.1025493943854243D3
     #*t180*t162*t165*t59+0.2197487022544806D2*t180*t55*t441*t59
     #-0.177678319146565D4*t180*t466*t59+0.2113847883581765D1*t68*t427
     #+0.2897369528551702D4/t483*t25*t434-0.1114836790033136D3*t189
     #*t438+0.1194467989321217D2*t189*t443-0.9657898428505673D3*t189
     #*t446+0.1953308542466386D1*t73*t450))*t198-0.2902352553914844D2
     #*t222/t290*t17
      t526 = s2-0.1236778371778789D-1*t506*t508-0.3703935787925799D1
     #*t216*t219+0.6965646129395627D1*t215*t25*t224
     #+0.6173226313209665D1*t94*t427*t17+0.1528291352075288D2*t93*t300
     #/t12/t301/rhob*t17
      v2rhob2(i) = -0.4135669939329333D0/t12*t23*t33
     #-0.24814019635976D1*t2*t124*t33+0.24814019635976D1*t100*t132
     #-0.9305257363491D0*t3*(t286+t289-t297+0.9799966841074009D-1*t293
     #*t17-0.4778117666686413D-1*t300/t301/t11*t17
     #+0.1608963433833121D0*t20*t64)*t33+0.18610514726982D1*t125*t132
     #-0.18610514726982D1*t24*t316*t317+0.9305257363491D0*t24*t129*
     #(t286+t289-t297+0.3658500245218708D-4*t293)-0.1D-22*t137*t334
     #+0.2642020300445714D-2*t138+0.2D1*t159+0.2473556743557577D-1
     #*t199+0.1587401051968199D1*t217-0.3703935787925799D1*t220
     #+0.6965646129395627D1*t225+rhob*t526
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t532 = 0.6300065251232535D-2/t4/sigmabb*t5*t8
      t536 = 0.6300102281634954D-2/sigmabb*t14*t113
      t538 = 0.6300176343092764D-2*t29*t295
      t550 = t246**2
      t565 = t260**2
      t574 = t263**2
      v2sigmabb2(i) = -0.9305257363491D0*t3*(-t532+t536-t538
     #-0.6719227968777768D-2/t301*t17*sigmabb+0.8166639034228341D-2
     #*t235)*t33+0.18610514726982D1*t241*t247-0.18610514726982D1*t24
     #*t316*t550+0.9305257363491D0*t24*t129*(-t532+t536-t538
     #+0.2166217250458446D-5*t29)+rhob*(0.1236778371778789D-1*
     #(0.1477292174974578D0*t61*t64*t77-0.5395172183039748D1*t253*t178
     #*t260+0.5395172183039748D1*t461*t565-0.3985122824322565D0*t179
     #*t72*t64)*t198-0.1236778371778789D-1*t574*t508
     #-0.261211729852336D1*t93*t269*t17+0.2149159713855873D1*t94/t12
     #/t290*t17)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t4 = dsqrt(sigmaaa)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1000005877780776D1*t6+dsqrt(1+0.10000117555961D1*t6*
     #*2))
      t10 = 0.2520026100493014D-1*t6*t8
      t11 = rhoa**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = sigmaaa*t14
      t17 = dexp(-0.1645530784602056D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigmaaa
      t23 = 1.D0+t10+0.1645530784602056D-1*t20*t14
      t24 = t3*t23
      t25 = sigmaaa**2
      t26 = t11**2
      t27 = t26*rhoa
      t29 = 1/t2/t27
      t32 = 1.D0+t10+0.1083108625229223D-5*t25*t29
      t33 = 1/t32
      t36 = 1/rhoa
      t37 = t36**(1.D0/3.D0)
      t39 = 1.D0+0.1274696188700087D0*t37
      t40 = t36**(1.D0/6.D0)
      t43 = dsqrt(t36)
      t45 = t37**2
      t47 = 0.1112037486309468D2*t40+0.3844746237447211D1*t37
     #+0.1644733775567609D1*t43+0.2405871291288192D0*t45
      t50 = 1.D0+0.321646831778707D2/t47
      t51 = dlog(t50)
      t52 = t39*t51
      t53 = 0.3109D-1*t52
      t55 = 1/t2/t11
      t59 = dexp(0.2513789108010112D1*t52)
      t60 = t59-1.D0
      t61 = 1/t60
      t62 = t61*t25
      t64 = 1/t12/t26
      t67 = 0.1007494971260294D0*sigmaaa*t55+0.2738174287780083D-1*t62
     #*t64
      t68 = t61*sigmaaa
      t71 = t60**2
      t72 = 1/t71
      t73 = t72*t25
      t76 = 1.D0+0.2717804421747983D0*t68*t55+0.7386460874872889D-1
     #*t73*t64
      t77 = 1/t76
      t80 = 1.D0+0.2697586091519874D1*t67*t77
      t81 = dlog(t80)
      t82 = 0.1236778371778789D-1*t81
      t85 = 0.2568D1+0.1443307452126544D2*t37+0.2843543831490386D-2*t45
      t89 = 1.D0+0.5411317332115466D1*t37+0.1816419932959077D0*t45
     #+0.1763993811759022D-1*t36
      t90 = 1/t89
      t93 = 0.1D-2*t85*t90-0.1853571428571429D-2
      t94 = t93*sigmaaa
      t95 = t55*t17
      t97 = 0.7937005259840997D0*t94*t95
      zk(i) = -0.9305257363491D0*t24*t33+rhoa*(-t53+t82+t97)
      t100 = t2*t23
      t105 = 0.3360034800657352D-1*t4*t55*t8
      t106 = t11*rhoa
      t108 = 1/t12/t106
      t111 = 1.D0+0.10000117555961D1*t15
      t112 = dsqrt(t111)
      t113 = 1/t112
      t115 = 0.3360054550205309D-1*sigmaaa*t108*t113
      t116 = t26*t11
      t119 = t25/t2/t116
      t124 = -t105-t115-0.1088885204563779D-1*t119*t17
     #-0.4388082092272149D-1*t20*t108
      t125 = t3*t124
      t128 = t32**2
      t129 = 1/t128
      t131 = -t105-t115-0.5776579334555855D-5*t119
      t132 = t129*t131
      t135 = 1/t45
      t136 = 1/t11
      t137 = t135*t136
      t138 = t137*t51
      t139 = 0.1321010150222857D-2*t138
      t140 = t47**2
      t141 = 1/t140
      t142 = t39*t141
      t143 = t40**2
      t144 = t143**2
      t145 = t144*t40
      t146 = 1/t145
      t150 = 1/t43
      t153 = 1/t37
      t154 = t153*t136
      t156 = -0.1853395810515781D1*t146*t136-0.128158207914907D1*t137
     #-0.8223668877838045D0*t150*t136-0.1603914194192128D0*t154
      t157 = 1/t50
      t159 = t142*t156*t157
      t160 = 0.1D1*t159
      t162 = 1/t2/t106
      t165 = t139+t160
      t167 = t64*t165*t59
      t171 = 1/t12/t27
      t174 = -0.2350821599607352D0*sigmaaa*t162+0.2213957124623647D1
     #*t73*t167-0.1277814667630705D0*t62*t171
      t177 = t76**2
      t178 = 1/t177
      t179 = t67*t178
      t180 = t72*sigmaaa
      t188 = 1/t71/t60
      t189 = t188*t25
      t194 = 0.2197487022544806D2*t180*t55*t165*t59
     #-0.6341543650745294D0*t68*t162+0.1194467989321217D2*t189*t167
     #-0.3447015074940681D0*t73*t171
      t197 = 0.2697586091519874D1*t174*t77-0.2697586091519874D1*t179
     #*t194
      t198 = 1/t80
      t199 = t197*t198
      t203 = -0.4811024840421814D1*t137-0.1895695887660258D-2*t154
      t206 = t89**2
      t207 = 1/t206
      t208 = t85*t207
      t212 = -0.1803772444038489D1*t137-0.1210946621972718D0*t154
     #-0.1763993811759022D-1*t136
      t215 = 0.1D-2*t203*t90-0.1D-2*t208*t212
      t216 = t215*sigmaaa
      t217 = t216*t95
      t219 = t162*t17
      t220 = t94*t219
      t222 = t93*t25
      t224 = 1/t116*t17
      t225 = t222*t224
      vrhoa(i) = -0.12407009817988D1*t100*t33-0.9305257363491D0*t125
     #*t33+0.9305257363491D0*t24*t132-t53+t82+t97+rhoa*(t139+t160
     #+0.1236778371778789D-1*t199+0.7937005259840997D0*t217
     #-0.1851967893962899D1*t220+0.3482823064697813D1*t225)
      vrhob(i) = 0.D0
      t232 = 0.1260013050246507D-1/t4*t5*t8
      t234 = 0.1260020456326991D-1*t14*t113
      t235 = t29*t17
      t241 = t3*(t232+t234+0.408331951711417D-2*t235*sigmaaa
     #+0.1645530784602056D-1*t19*t14)
      t246 = t232+t234+0.2166217250458446D-5*sigmaaa*t29
      t247 = t129*t246
      t253 = 0.1007494971260294D0*t55+0.5476348575560166D-1*t68*t64
      t260 = 0.2717804421747983D0*t61*t55+0.1477292174974578D0*t180*t64
      t263 = 0.2697586091519874D1*t253*t77-0.2697586091519874D1*t179
     #*t260
      t269 = 1/t27
      vsigmaaa(i) = -0.9305257363491D0*t241*t33+0.9305257363491D0*t24
     #*t247+rhoa*(0.1236778371778789D-1*t263*t198+0.7937005259840997D0
     #*t93*t55*t17-0.130605864926168D1*t94*t269*t17)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t286 = 0.7840081201533821D-1*t4*t162*t8
      t289 = 0.1680027275102654D0*sigmaaa*t64*t113
      t290 = t26*t106
      t293 = t25/t2/t290
      t295 = 1/t112/t111
      t297 = 0.4480125399532632D-1*t293*t295
      t300 = t25*sigmaaa
      t301 = t26**2
      t316 = 1/t128/t32
      t317 = t131**2
      t334 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t40
     #+0.2225569421150687D1*t37+0.8004286349993634D0*t43
     #+0.1897004325747559D0*t45))
      t346 = t156**2
      t349 = 0.2D1*t39/t140/t47*t346*t157
      t350 = 1/t106
      t351 = t135*t350
      t353 = 0.1D-22*t351*t334
      t356 = 1/t26
      t357 = 1/t45/t36*t356
      t359 = 0.8806734334819047D-3*t357*t51
      t361 = 0.2642020300445714D-2*t351*t51
      t365 = 0.8497974591333914D-1*t137*t141*t156*t157
      t382 = 1/t37/t36*t356
      t384 = t153*t350
      t389 = 0.1D1*t142*(-0.1544496508763151D1/t145/t36*t356
     #+0.3706791621031562D1*t146*t350-0.854388052766047D0*t357
     #+0.2563164158298141D1*t351-0.4111834438919023D0/t43/t36*t356
     #+0.1644733775567609D1*t150*t350-0.5346380647307093D-1*t382
     #+0.3207828388384256D0*t384)*t157
      t390 = t140**2
      t393 = t50**2
      t397 = 0.321646831778707D2*t39/t390*t346/t393
      t411 = t212**2
      t427 = 1/t2/t26
      t430 = t165**2
      t431 = t64*t430
      t433 = dexp(0.5027578216020225D1*t52)
      t434 = t431*t433
      t438 = t171*t165*t59
      t441 = -t353+t359-t361-t365-t349+t389+t397
      t443 = t64*t441*t59
      t446 = t431*t59
      t450 = 1/t12/t116
      t461 = t67/t177/t76
      t462 = t194**2
      t466 = t55*t430
      t483 = t71**2
      t506 = t197**2
      t507 = t80**2
      t508 = 1/t507
      s1 = -t353+t359-t361-t365-t349+t389+t397
      s3 = s1+0.7937005259840997D0*(0.1D-2*(-0.3207349893614542D1*t357
     #+0.9622049680843627D1*t351-0.6318986292200858D-3*t382
     #+0.3791391775320515D-2*t384)*t90-0.2D-2*t203*t207*t212+0.2D-2
     #*t85/t206/t89*t411-0.1D-2*t208*(-0.1202514962692326D1*t357
     #+0.3607544888076978D1*t351-0.4036488739909061D-1*t382
     #+0.2421893243945437D0*t384+0.3527987623518044D-1*t350))*sigmaaa
     #*t95
      s2 = s3+0.1236778371778789D-1*(0.2697586091519874D1*
     #(0.7836071998691172D0*sigmaaa*t427+0.3580200260842915D3*t189
     #*t434-0.2066359982982071D2*t73*t438+0.2213957124623647D1*t73
     #*t443-0.1790100130421458D3*t73*t446+0.7240949783240664D0*t62
     #*t450)*t77-0.5395172183039748D1*t174*t178*t194
     #+0.5395172183039748D1*t461*t462-0.2697586091519874D1*t179*
     #(0.35535663829313D4*t188*sigmaaa*t466*t433-0.1025493943854243D3
     #*t180*t162*t165*t59+0.2197487022544806D2*t180*t55*t441*t59
     #-0.177678319146565D4*t180*t466*t59+0.2113847883581765D1*t68*t427
     #+0.2897369528551702D4/t483*t25*t434-0.1114836790033136D3*t189
     #*t438+0.1194467989321217D2*t189*t443-0.9657898428505673D3*t189
     #*t446+0.1953308542466386D1*t73*t450))*t198-0.2902352553914844D2
     #*t222/t290*t17
      t526 = s2-0.1236778371778789D-1*t506*t508-0.3703935787925799D1
     #*t216*t219+0.6965646129395627D1*t215*t25*t224
     #+0.6173226313209665D1*t94*t427*t17+0.1528291352075288D2*t93*t300
     #/t12/t301/rhoa*t17
      v2rhoa2(i) = -0.4135669939329333D0/t12*t23*t33
     #-0.24814019635976D1*t2*t124*t33+0.24814019635976D1*t100*t132
     #-0.9305257363491D0*t3*(t286+t289-t297+0.9799966841074009D-1*t293
     #*t17-0.4778117666686413D-1*t300/t301/t11*t17
     #+0.1608963433833121D0*t20*t64)*t33+0.18610514726982D1*t125*t132
     #-0.18610514726982D1*t24*t316*t317+0.9305257363491D0*t24*t129*
     #(t286+t289-t297+0.3658500245218708D-4*t293)-0.1D-22*t137*t334
     #+0.2642020300445714D-2*t138+0.2D1*t159+0.2473556743557577D-1
     #*t199+0.1587401051968199D1*t217-0.3703935787925799D1*t220
     #+0.6965646129395627D1*t225+rhoa*t526
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t532 = 0.6300065251232535D-2/t4/sigmaaa*t5*t8
      t536 = 0.6300102281634954D-2/sigmaaa*t14*t113
      t538 = 0.6300176343092764D-2*t29*t295
      t550 = t246**2
      t565 = t260**2
      t574 = t263**2
      v2sigmaaa2(i) = -0.9305257363491D0*t3*(-t532+t536-t538
     #-0.6719227968777768D-2/t301*t17*sigmaaa+0.8166639034228341D-2
     #*t235)*t33+0.18610514726982D1*t241*t247-0.18610514726982D1*t24
     #*t316*t550+0.9305257363491D0*t24*t129*(-t532+t536-t538
     #+0.2166217250458446D-5*t29)+rhoa*(0.1236778371778789D-1*
     #(0.1477292174974578D0*t61*t64*t77-0.5395172183039748D1*t253*t178
     #*t260+0.5395172183039748D1*t461*t565-0.3985122824322565D0*t179
     #*t72*t64)*t198-0.1236778371778789D-1*t574*t508
     #-0.261211729852336D1*t93*t269*t17+0.2149159713855873D1*t94/t12
     #/t290*t17)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t6 = dsqrt(sigmaaa)
      t7 = 1/t5
      t8 = t6*t7
      t10 = dlog(0.1000005877780776D1*t8+dsqrt(1+0.10000117555961D1*t8
     #**2))
      t12 = 0.2520026100493014D-1*t8*t10
      t13 = rhoa**2
      t14 = t4**2
      t16 = 1/t14/t13
      t17 = sigmaaa*t16
      t19 = dexp(-0.1645530784602056D1*t17)
      t21 = 0.2743D0-0.1508D0*t19
      t22 = t21*sigmaaa
      t25 = 1.D0+t12+0.1645530784602056D-1*t22*t16
      t26 = t5*t25
      t27 = sigmaaa**2
      t28 = t13**2
      t31 = 1/t4/t28/rhoa
      t34 = 1.D0+t12+0.1083108625229223D-5*t27*t31
      t35 = 1/t34
      t38 = rhob**(1.D0/3.D0)
      t39 = t38*rhob
      t40 = dsqrt(sigmabb)
      t41 = 1/t39
      t42 = t40*t41
      t44 = dlog(0.1000005877780776D1*t42+dsqrt(1+0.10000117555961D1
     #*t42**2))
      t46 = 0.2520026100493014D-1*t42*t44
      t47 = rhob**2
      t48 = t38**2
      t50 = 1/t48/t47
      t51 = sigmabb*t50
      t53 = dexp(-0.1645530784602056D1*t51)
      t55 = 0.2743D0-0.1508D0*t53
      t56 = t55*sigmabb
      t59 = 1.D0+t46+0.1645530784602056D-1*t56*t50
      t60 = t39*t59
      t61 = sigmabb**2
      t62 = t47**2
      t65 = 1/t38/t62/rhob
      t68 = 1.D0+t46+0.1083108625229223D-5*t61*t65
      t69 = 1/t68
      t72 = 1/rho
      t73 = t72**(1.D0/3.D0)
      t75 = 1.D0+0.1325688999052018D0*t73
      t76 = t72**(1.D0/6.D0)
      t79 = dsqrt(t72)
      t81 = t73**2
      t83 = 0.598255043577108D1*t76+0.2225569421150687D1*t73
     #+0.8004286349993634D0*t79+0.1897004325747559D0*t81
      t86 = 1.D0+0.160818243221511D2/t83
      t87 = dlog(t86)
      t89 = 0.62182D-1*t75*t87
      t91 = 1.D0+0.6901399211255825D-1*t73
      t96 = 0.8157414703487641D1*t76+0.2247591863577616D1*t73
     #+0.4300972471276643D0*t79+0.1911512595127338D0*t81
      t99 = 1.D0+0.2960857464321668D2/t96
      t100 = dlog(t99)
      t101 = t91*t100
      t103 = rhoa-1.D0*rhob
      t104 = t103*t72
      t105 = 1.D0+t104
      t106 = t105**(1.D0/3.D0)
      t107 = t106*t105
      t109 = 1.D0-1.D0*t104
      t110 = t109**(1.D0/3.D0)
      t111 = t110*t109
      t112 = t107+t111-2.D0
      t113 = t103**2
      t114 = t113**2
      t115 = rho**2
      t116 = t115**2
      t117 = 1/t116
      t118 = t114*t117
      t120 = 1.D0-1.D0*t118
      t121 = t112*t120
      t123 = 0.3799575D-1*t101*t121
      t125 = 1.D0+0.1274696188700087D0*t73
      t130 = 0.1112037486309468D2*t76+0.3844746237447211D1*t73
     #+0.1644733775567609D1*t79+0.2405871291288192D0*t81
      t133 = 1.D0+0.321646831778707D2/t130
      t134 = dlog(t133)
      t137 = -0.3109D-1*t125*t134+t89
      t138 = t137*t112
      t140 = 0.1923661050931536D1*t138*t118
      t141 = t106**2
      t143 = t110**2
      t145 = 0.5D0*t141+0.5D0*t143
      t146 = t145**2
      t147 = t146*t145
      t148 = 1/t146
      t149 = sigma*t148
      t150 = rho**(1.D0/3.D0)
      t152 = 1/t150/t115
      t155 = -t89+t123+t140
      t156 = 1/t147
      t157 = t155*t156
      t159 = dexp(-0.4042761511756372D2*t157)
      t160 = t159-1.D0
      t161 = 1/t160
      t162 = sigma**2
      t163 = t161*t162
      t164 = t146**2
      t165 = 1/t164
      t166 = t150**2
      t168 = 1/t166/t116
      t169 = t165*t168
      t172 = 0.634682060977037D-1*t149*t152+0.1086645186223595D-1*t163
     #*t169
      t173 = t161*sigma
      t174 = t148*t152
      t177 = t160**2
      t178 = 1/t177
      t179 = t178*t162
      t182 = 1.D0+0.1712109500228824D0*t173*t174+0.2931318940773793D-1
     #*t179*t169
      t183 = 1/t182
      t186 = 1.D0+0.2697586091519874D1*t172*t183
      t187 = dlog(t186)
      t189 = 0.2473556743557577D-1*t147*t187
      t192 = 0.2568D1+0.1443307452126544D2*t73+0.2843543831490386D-2*t81
      t196 = 1.D0+0.5411317332115466D1*t73+0.1816419932959077D0*t81
     #+0.1763993811759022D-1*t72
      t197 = 1/t196
      t200 = 0.1D-2*t192*t197-0.1853571428571429D-2
      t201 = t200*t145
      t204 = 1/t166/t115
      t208 = dexp(-0.261211729852336D1*t146*t204*sigma)
      t209 = sigma*t152*t208
      t211 = 0.1D1*t201*t209
      zk(i) = -0.9305257363491D0*t26*t35-0.9305257363491D0*t60*t69+rho
     #*(-t89+t123+t140+t189+t211)
      t214 = t4*t25
      t218 = 1/t4/t13
      t221 = 0.3360034800657352D-1*t6*t218*t10
      t222 = t13*rhoa
      t224 = 1/t14/t222
      t227 = 1.D0+0.10000117555961D1*t17
      t228 = dsqrt(t227)
      t229 = 1/t228
      t231 = 0.3360054550205309D-1*sigmaaa*t224*t229
      t234 = 1/t4/t28/t13
      t235 = t27*t234
      t240 = -t221-t231-0.1088885204563779D-1*t235*t19
     #-0.4388082092272149D-1*t22*t224
      t241 = t5*t240
      t244 = t34**2
      t245 = 1/t244
      t247 = -t221-t231-0.5776579334555855D-5*t235
      t248 = t245*t247
      t255 = 0.1333333333333333D1*t106*t72-0.1333333333333333D1*t110*t72
      t257 = t101*t255*t120
      t258 = 0.3799575D-1*t257
      t259 = t113*t103
      t260 = t112*t259
      t262 = t101*t260*t117
      t263 = 0.151983D0*t262
      t264 = t137*t255
      t265 = t264*t118
      t266 = 0.1923661050931536D1*t265
      t267 = t259*t117
      t268 = t138*t267
      t269 = 0.7694644203726145D1*t268
      t270 = t146*t187
      t271 = 1/t106
      t274 = 1/t110
      t277 = 0.3333333333333333D0*t271*t72-0.3333333333333333D0*t274*t72
      t278 = t270*t277
      t279 = 0.7420670230672731D-1*t278
      t280 = sigma*t156
      t281 = t152*t277
      t284 = t179*t165
      t285 = t258-t263+t266+t269
      t288 = t155*t165
      t291 = -0.4042761511756372D2*t285*t156+0.1212828453526912D3*t288
     #*t277
      t292 = t168*t291
      t293 = t292*t159
      t296 = t164*t145
      t297 = 1/t296
      t298 = t297*t168
      t299 = t298*t277
      t302 = -0.1269364121954074D0*t280*t281-0.1086645186223595D-1
     #*t284*t293-0.4346580744894379D-1*t163*t299
      t305 = t182**2
      t306 = 1/t305
      t307 = t172*t306
      t308 = t178*sigma
      t309 = t308*t148
      t310 = t152*t291
      t311 = t310*t159
      t314 = t156*t152
      t315 = t314*t277
      t319 = 1/t177/t160
      t320 = t319*t162
      t321 = t320*t165
      t326 = -0.1712109500228824D0*t309*t311-0.3424219000457648D0*t173
     #*t315-0.5862637881547585D-1*t321*t293-0.1172527576309517D0*t179
     #*t299
      t329 = 0.2697586091519874D1*t302*t183-0.2697586091519874D1*t307
     #*t326
      t330 = t147*t329
      t331 = 1/t186
      t332 = t330*t331
      t333 = 0.2473556743557577D-1*t332
      t334 = t200*t277
      t335 = t334*t209
      t336 = 0.1D1*t335
      t338 = t200*t146*t162
      t339 = t116*rho
      t340 = 1/t339
      t342 = t340*t277*t208
      t343 = t338*t342
      t344 = 0.522423459704672D1*t343
      t347 = 1/t81
      t348 = 1/t115
      t349 = t347*t348
      t350 = t349*t87
      t351 = 0.2747799777968419D-2*t350
      t352 = t83**2
      t353 = 1/t352
      t354 = t75*t353
      t355 = t76**2
      t356 = t355**2
      t357 = t356*t76
      t358 = 1/t357
      t359 = t358*t348
      t362 = 1/t79
      t363 = t362*t348
      t365 = 1/t73
      t366 = t365*t348
      t368 = -0.99709173929518D0*t359-0.7418564737168958D0*t349
     #-0.4002143174996817D0*t363-0.1264669550498372D0*t366
      t369 = 1/t86
      t371 = t354*t368*t369
      t372 = 0.1D1*t371
      t373 = t100*t112
      t374 = t373*t120
      t375 = t349*t374
      t376 = 0.8740794636035784D-3*t375
      t377 = t96**2
      t378 = 1/t377
      t379 = t91*t378
      t384 = -0.135956911724794D1*t359-0.7491972878592054D0*t349
     #-0.2150486235638321D0*t363-0.1274341730084892D0*t366
      t385 = t379*t384
      t386 = 1/t99
      t387 = t386*t112
      t388 = t387*t120
      t389 = t385*t388
      t390 = 0.1125D1*t389
      t391 = t106*t103
      t394 = t110*t103
      t397 = -0.1333333333333333D1*t391*t348+0.1333333333333333D1*t394
     #*t348
      t399 = t101*t397*t120
      t400 = 0.3799575D-1*t399
      t401 = t112*t114
      t403 = t101*t401*t340
      t404 = 0.151983D0*t403
      t407 = t130**2
      t408 = 1/t407
      t409 = t125*t408
      t414 = -0.1853395810515781D1*t359-0.128158207914907D1*t349
     #-0.8223668877838045D0*t363-0.1603914194192128D0*t366
      t415 = 1/t133
      t421 = 0.1321010150222857D-2*t349*t134+0.1D1*t409*t414*t415
     #-0.2747799777968419D-2*t350-0.1D1*t371
      t422 = t421*t112
      t423 = t422*t118
      t424 = 0.1923661050931536D1*t423
      t425 = t137*t397
      t426 = t425*t118
      t427 = 0.1923661050931536D1*t426
      t428 = t114*t340
      t429 = t138*t428
      t430 = 0.7694644203726145D1*t429
      t431 = t271*t103
      t434 = t274*t103
      t437 = -0.3333333333333333D0*t431*t348+0.3333333333333333D0*t434
     #*t348
      t438 = t270*t437
      t440 = t152*t437
      t443 = t115*rho
      t445 = 1/t150/t443
      t448 = t351+t372-t376-t390+t400+t404+t424+t427-t430
      t453 = -0.4042761511756372D2*t448*t156+0.1212828453526912D3*t288
     #*t437
      t454 = t168*t453
      t455 = t454*t159
      t458 = t298*t437
      t462 = 1/t166/t339
      t463 = t165*t462
      t466 = -0.1269364121954074D0*t280*t440-0.148092480894642D0*t149
     #*t445-0.1086645186223595D-1*t284*t455-0.4346580744894379D-1*t163
     #*t458-0.5071010869043442D-1*t163*t463
      t469 = t152*t453
      t470 = t469*t159
      t473 = t314*t437
      t476 = t148*t445
      t485 = -0.1712109500228824D0*t309*t470-0.3424219000457648D0*t173
     #*t473-0.3994922167200589D0*t173*t476-0.5862637881547585D-1*t321
     #*t455-0.1172527576309517D0*t179*t458-0.136794883902777D0*t179*t463
      t488 = 0.2697586091519874D1*t466*t183-0.2697586091519874D1*t307
     #*t485
      t489 = t147*t488
      t490 = t489*t331
      t494 = -0.4811024840421814D1*t349-0.1895695887660258D-2*t366
      t497 = t196**2
      t498 = 1/t497
      t499 = t192*t498
      t503 = -0.1803772444038489D1*t349-0.1210946621972718D0*t366
     #-0.1763993811759022D-1*t348
      t506 = 0.1D-2*t494*t197-0.1D-2*t499*t503
      t507 = t506*t145
      t508 = t507*t209
      t510 = t200*t437
      t511 = t510*t209
      t514 = sigma*t445*t208
      t515 = t201*t514
      t517 = t201*sigma
      t518 = t145*t204
      t519 = sigma*t437
      t523 = 1/t166/t443
      t524 = t146*t523
      t527 = -0.522423459704672D1*t518*t519+0.6965646129395627D1*t524
     #*sigma
      t529 = t152*t527*t208
      t530 = t517*t529
      t532 = t351+t372-t376-t390+t400+t404+t424+t427-t430
     #+0.7420670230672731D-1*t438+0.2473556743557577D-1*t490+0.1D1
     #*t508+0.1D1*t511-0.2333333333333333D1*t515+0.1D1*t530
      t533 = rho*t532
      vrhoa(i) = -0.12407009817988D1*t214*t35-0.9305257363491D0*t241
     #*t35+0.9305257363491D0*t26*t248+rho*(t258-t263+t266+t269+t279
     #+t333+t336-t344)-t89+t123+t140+t189+t211+t533
      t534 = t38*t59
      t538 = 1/t38/t47
      t541 = 0.3360034800657352D-1*t40*t538*t44
      t542 = t47*rhob
      t544 = 1/t48/t542
      t547 = 1.D0+0.10000117555961D1*t51
      t548 = dsqrt(t547)
      t549 = 1/t548
      t551 = 0.3360054550205309D-1*sigmabb*t544*t549
      t554 = 1/t38/t62/t47
      t555 = t61*t554
      t560 = -t541-t551-0.1088885204563779D-1*t555*t53
     #-0.4388082092272149D-1*t56*t544
      t561 = t39*t560
      t564 = t68**2
      t565 = 1/t564
      t567 = -t541-t551-0.5776579334555855D-5*t555
      t568 = t565*t567
      t571 = -t255
      t573 = t101*t571*t120
      t574 = 0.3799575D-1*t573
      t575 = 0.151983D0*t262
      t576 = t137*t571
      t577 = t576*t118
      t578 = 0.1923661050931536D1*t577
      t579 = 0.7694644203726145D1*t268
      t580 = -t277
      t581 = t270*t580
      t582 = 0.7420670230672731D-1*t581
      t583 = t152*t580
      t586 = t574+t575+t578-t579
      t591 = -0.4042761511756372D2*t586*t156+0.1212828453526912D3*t288
     #*t580
      t592 = t168*t591
      t593 = t592*t159
      t596 = t298*t580
      t599 = -0.1269364121954074D0*t280*t583-0.1086645186223595D-1
     #*t284*t593-0.4346580744894379D-1*t163*t596
      t602 = t152*t591
      t603 = t602*t159
      t606 = t314*t580
      t613 = -0.1712109500228824D0*t309*t603-0.3424219000457648D0*t173
     #*t606-0.5862637881547585D-1*t321*t593-0.1172527576309517D0*t179
     #*t596
      t616 = 0.2697586091519874D1*t599*t183-0.2697586091519874D1*t307
     #*t613
      t617 = t147*t616
      t618 = t617*t331
      t619 = 0.2473556743557577D-1*t618
      t620 = t200*t580
      t621 = t620*t209
      t622 = 0.1D1*t621
      t624 = t340*t580*t208
      t625 = t338*t624
      t626 = 0.522423459704672D1*t625
      vrhob(i) = -0.12407009817988D1*t534*t69-0.9305257363491D0*t561
     #*t69+0.9305257363491D0*t60*t568+rho*(t574+t575+t578-t579+t582
     #+t619+t622-t626)-t89+t123+t140+t189+t211+t533
      t629 = 1/t6
      t632 = 0.1260013050246507D-1*t629*t7*t10
      t634 = 0.1260020456326991D-1*t16*t229
      t635 = t31*t19
      t640 = t632+t634+0.408331951711417D-2*t635*sigmaaa
     #+0.1645530784602056D-1*t21*t16
      t641 = t5*t640
      t646 = t632+t634+0.2166217250458446D-5*sigmaaa*t31
      t647 = t245*t646
      t653 = 0.634682060977037D-1*t174+0.2173290372447189D-1*t173*t169
      t656 = t161*t148
      t661 = 0.1712109500228824D0*t656*t152+0.5862637881547585D-1*t308
     #*t169
      t664 = 0.2697586091519874D1*t653*t183-0.2697586091519874D1*t307
     #*t661
      t666 = t147*t664*t331
      t667 = 0.2473556743557577D-1*t666
      t668 = t152*t208
      t669 = t201*t668
      t670 = 0.1D1*t669
      t671 = t200*t147
      t673 = sigma*t340*t208
      t674 = t671*t673
      t675 = 0.261211729852336D1*t674
      t677 = rho*(t667+t670-t675)
      vsigmaaa(i) = -0.9305257363491D0*t641*t35+0.9305257363491D0*t26
     #*t647+t677
      vsigmaab(i) = 2.D0*t677
      t678 = 1/t40
      t681 = 0.1260013050246507D-1*t678*t41*t44
      t683 = 0.1260020456326991D-1*t50*t549
      t684 = t65*t53
      t689 = t681+t683+0.408331951711417D-2*t684*sigmabb
     #+0.1645530784602056D-1*t55*t50
      t690 = t39*t689
      t695 = t681+t683+0.2166217250458446D-5*sigmabb*t65
      t696 = t565*t695
      vsigmabb(i) = -0.9305257363491D0*t690*t69+0.9305257363491D0*t60
     #*t696+t677
      t705 = 0.2D1*t371
      t706 = 0.759915D-1*t399
      t707 = 0.3847322101863073D1*t423
      t708 = 0.3847322101863073D1*t426
      t709 = 0.1538928840745229D2*t429
      t711 = 0.5495599555936838D-2*t350
      t712 = 0.1484134046134546D0*t438
      t714 = 0.303966D0*t403
      t715 = 0.1748158927207157D-2*t375
      t716 = 0.759915D-1*t257+0.3847322101863073D1*t265
     #+0.1538928840745229D2*t268+0.1484134046134546D0*t278
     #+0.4947113487115154D-1*t332-0.303966D0*t262+t705+t706+t707+t708
     #-t709+0.2D1*t335+t711+t712-0.1044846919409344D2*t343+t714-t715
      t717 = 0.225D1*t389
      t718 = t334*sigma
      t720 = 0.1D1*t718*t529
      t721 = 1/t107
      t723 = 1/t443
      t728 = 1/t111
      t734 = 0.1111111111111111D0*t721*t103*t723-0.3333333333333333D0
     #*t271*t348+0.1111111111111111D0*t728*t103*t723
     #+0.3333333333333333D0*t274*t348
      t736 = 0.7420670230672731D-1*t270*t734
      t737 = t116*t115
      t738 = 1/t737
      t741 = t338*t738*t277*t208
      t743 = sigma*t165
      t744 = t440*t277
      t746 = 0.3808092365862222D0*t743*t744
      t749 = 0.296184961789284D0*t280*t445*t277
      t752 = 0.1269364121954074D0*t280*t152*t734
      t754 = dexp(-0.8085523023512745D2*t157)
      t755 = t754*t291
      t756 = t454*t755
      t758 = 0.2173290372447189D-1*t321*t756
      t759 = t179*t297
      t760 = t168*t437
      t761 = t291*t159
      t762 = t760*t761
      t764 = 0.4346580744894379D-1*t759*t762
      t766 = t462*t291*t159
      t768 = 0.5071010869043442D-1*t284*t766
      t772 = 0.8740794636035784D-3*t349*t100*t255*t120
      t776 = 0.1125D1*t385*t386*t255*t120
      t777 = 1/t141
      t783 = 1/t143
      t789 = -0.4444444444444444D0*t777*t103*t723-0.1333333333333333D1
     #*t106*t348-0.4444444444444444D0*t783*t103*t723
     #+0.1333333333333333D1*t110*t348
      t792 = 0.3799575D-1*t101*t789*t120
      t796 = 0.151983D0*t101*t255*t114*t340
      t799 = t347*t738*t373*t259
      t800 = 0.3496317854414314D-2*t799
      t802 = t385*t387*t267
      t803 = 0.45D1*t802
      t806 = t101*t397*t259*t117
      t807 = 0.151983D0*t806
      t809 = t101*t260*t340
      t810 = 0.607932D0*t809
      t813 = 0.1923661050931536D1*t421*t255*t118
      t816 = 0.1923661050931536D1*t137*t789*t118
      t818 = 0.7694644203726145D1*t264*t428
      t819 = t422*t267
      t820 = 0.7694644203726145D1*t819
      t821 = t425*t267
      t822 = 0.7694644203726145D1*t821
      t824 = t138*t259*t340
      t825 = 0.3077857681490458D2*t824
      t826 = -t772-t776+t792+t796+t800+t803-t807+t810+t813+t816-t818
     #+t820+t822-t825
      t829 = t285*t165
      t831 = 0.1212828453526912D3*t829*t437
      t832 = t448*t165
      t834 = 0.1212828453526912D3*t832*t277
      t835 = t155*t297
      t836 = t437*t277
      t838 = 0.4851313814107647D3*t835*t836
      t840 = 0.1212828453526912D3*t288*t734
      t841 = -0.4042761511756372D2*t826*t156+t831+t834-t838+t840
      t843 = t168*t841*t159
      t846 = t454*t761
      t848 = 0.1086645186223595D-1*t284*t846
      t849 = t159*t277
      t850 = t454*t849
      t852 = 0.4346580744894379D-1*t759*t850
      t854 = 1/t164/t146
      t855 = t163*t854
      t856 = t760*t277
      t858 = 0.2173290372447189D0*t855*t856
      t859 = t297*t462
      t860 = t859*t277
      t862 = 0.2028404347617377D0*t163*t860
      t863 = t298*t734
      t865 = 0.4346580744894379D-1*t163*t863
      t866 = t746+t749-t752+t758+t764+t768-0.1086645186223595D-1*t284
     #*t843-t848+t852+t858+t862-t865
      t869 = t302*t306
      t871 = 0.2697586091519874D1*t869*t485
      t872 = t466*t306
      t874 = 0.2697586091519874D1*t872*t326
      t877 = t172/t305/t182
      t880 = 0.5395172183039748D1*t877*t485*t326
      t881 = t319*sigma
      t882 = t881*t148
      t885 = 0.3424219000457648D0*t882*t469*t755
      t886 = t308*t156
      t889 = 0.3424219000457648D0*t886*t440*t761
      t893 = 0.3994922167200589D0*t309*t445*t291*t159
      t900 = 0.1712109500228824D0*t309*t469*t761
      t903 = 0.3424219000457648D0*t886*t469*t849
      t904 = t173*t165
      t906 = 0.1027265700137294D1*t904*t744
      t907 = t156*t445
      t910 = 0.7989844334401178D0*t173*t907*t277
      t913 = 0.3424219000457648D0*t173*t314*t734
      t914 = t177**2
      t917 = 1/t914*t162*t165
      t919 = 0.1758791364464276D0*t917*t756
      t920 = t320*t297
      t922 = 0.2345055152619034D0*t920*t762
      t924 = 0.273589767805554D0*t321*t766
      t928 = 0.5862637881547585D-1*t321*t846
      t930 = 0.2345055152619034D0*t920*t850
      t931 = t179*t854
      t933 = 0.5862637881547585D0*t931*t856
      t935 = 0.547179535611108D0*t179*t860
      t937 = 0.1172527576309517D0*t179*t863
      t938 = t885+t889+t893-0.1712109500228824D0*t309*t152*t841*t159
     #-t900+t903+t906+t910-t913+t919+t922+t924-0.5862637881547585D-1
     #*t321*t843-t928+t930+t933+t935-t937
      t949 = t186**2
      t950 = 1/t949
      t953 = 0.2473556743557577D-1*t489*t950*t329
      t954 = t510*t162
      t955 = t340*t145
      t956 = t277*t208
      t958 = t954*t955*t956
      t961 = t506*t146*t162
      t963 = 0.522423459704672D1*t961*t342
      t964 = t146*t329
      t965 = t331*t437
      t967 = 0.7420670230672731D-1*t964*t965
      t970 = 0.1D1*t200*t734*t209
      t971 = t146*t488
      t972 = t331*t277
      t974 = 0.7420670230672731D-1*t971*t972
      t975 = t720+t736+0.261211729852336D2*t741+0.2473556743557577D-1
     #*t147*(0.2697586091519874D1*t866*t183-t871-t874+t880
     #-0.2697586091519874D1*t307*t938)*t331-0.522423459704672D1*t338
     #*t340*t734*t208-t953-0.1044846919409344D2*t958-t963+t967+t970
     #+t974+t792+t820+t813
      t976 = t145*t187
      t978 = 0.1484134046134546D0*t976*t836
      t981 = 0.1D1*t506*t277*t209
      t982 = t340*t527
      t985 = 0.522423459704672D1*t338*t982*t956
      t987 = 0.2333333333333333D1*t334*t514
      t988 = t816+t822-t818-t825+t978+t803+t800-t776-t772+t796-t807
     #+t810+t981-t985-t987
      t990 = rho*(t975+t988)
      t991 = 0.4947113487115154D-1*t490
      t993 = 0.45D1*t802
      t994 = -t772+t800-t776+t993+t792-t807+t796+t810+t813+t820+t816
     #+t822-t818-t825
      t997 = -0.4042761511756372D2*t994*t156+t834+t831-t838+t840
      t999 = t168*t997*t159
      t1002 = t746-t752+t749+t758+t852-0.1086645186223595D-1*t284*t999
     #-t848+t764+t858-t865+t768+t862
      t1011 = t885+t903-0.1712109500228824D0*t309*t152*t997*t159-t900
     #+t889+t906-t913+t893+t910+t919+t930-0.5862637881547585D-1*t321
     #*t999-t928+t922+t933-t937+t924+t935
      t1019 = t720+t736+0.1218988072644235D2*t741
     #+0.2473556743557577D-1*t147*(0.2697586091519874D1*t1002*t183
     #-t874-t871+t880-0.2697586091519874D1*t307*t1011)*t331-t953
     #-0.522423459704672D1*t958-t963+t967+t970+t974+t792+t820+t813+t816
      t1026 = t145*t523
      t1035 = t822-t818-t825+t978+t993+t800-t776-t772+t796-t807+t810
     #+t981+0.1D1*t517*t152*(-0.522423459704672D1*t277*t204*t519
     #-0.522423459704672D1*t518*sigma*t734+0.1393129225879125D2*t1026
     #*sigma*t277)*t208-t985-t987
      t1037 = rho*(t1019+t1035)
      t1038 = 0.2D1*t508
      t1039 = 0.2D1*t511
      t1040 = 0.4666666666666667D1*t515
      t1041 = 0.2D1*t530
      t1052 = -0.1111111111111111D0*t721*t113*t117
     #+0.6666666666666667D0*t431*t723-0.1111111111111111D0*t728*t113
     #*t117-0.6666666666666667D0*t434*t723
      t1055 = 0.1D1*t200*t1052*t209
      t1058 = 1/t81/t72*t117
      t1059 = t1058*t87
      t1060 = 0.1831866518645613D-2*t1059
      t1063 = 0.3847322101863073D1*t421*t397*t118
      t1064 = t352**2
      t1067 = t368**2
      t1068 = t86**2
      t1071 = t75/t1064*t1067/t1068
      t1072 = 0.160818243221511D2*t1071
      t1073 = t347*t723
      t1074 = t1073*t87
      t1075 = 0.5495599555936838D-2*t1074
      t1079 = t384**2
      t1082 = 0.225D1*t91/t377/t96*t1079*t388
      t1093 = 0.4444444444444444D0*t777*t113*t117+0.2666666666666667D1
     #*t391*t723+0.4444444444444444D0*t783*t113*t117
     #-0.2666666666666667D1*t394*t723
      t1096 = 0.1923661050931536D1*t137*t1093*t118
      t1098 = 0.1538928840745229D2*t425*t428
      t1110 = t414**2
      t1116 = 1/t357/t72*t117
      t1118 = t358*t723
      t1124 = 1/t79/t72*t117
      t1126 = t362*t723
      t1130 = 1/t73/t72*t117
      t1132 = t365*t723
      t1138 = t407**2
      t1141 = t133**2
      t1150 = t349*t353*t368*t369
      t1156 = t75/t352/t83*t1067*t369
      t1168 = t354*(-0.8309097827459833D0*t1116+0.199418347859036D1
     #*t1118-0.4945709824779306D0*t1058+0.1483712947433792D1*t1073
     #-0.2001071587498409D0*t1124+0.8004286349993634D0*t1126
     #-0.4215565168327908D-1*t1130+0.2529339100996745D0*t1132)*t369
      t1171 = 0.8806734334819047D-3*t1058*t134-0.2642020300445714D-2
     #*t1073*t134-0.8497974591333914D-1*t349*t408*t414*t415-0.2D1*t125
     #/t407/t130*t1110*t415+0.1D1*t409*(-0.1544496508763151D1*t1116
     #+0.3706791621031562D1*t1118-0.854388052766047D0*t1058
     #+0.2563164158298141D1*t1073-0.4111834438919023D0*t1124
     #+0.1644733775567609D1*t1126-0.5346380647307093D-1*t1130
     #+0.3207828388384256D0*t1132)*t415+0.321646831778707D2*t125/t1138
     #*t1110/t1141-0.1831866518645613D-2*t1059+0.5495599555936838D-2
     #*t1074+0.8837926660346786D-1*t1150+0.2D1*t1156-0.1D1*t1168
     #-0.160818243221511D2*t1071
      t1174 = 0.1923661050931536D1*t1171*t112*t118
      t1177 = 0.3799575D-1*t101*t1093*t120
      t1179 = 0.1538928840745229D2*t422*t428
      t1180 = t159*t437
      t1181 = t454*t1180
      t1183 = 0.8693161489788758D-1*t759*t1181
      t1185 = t462*t453*t159
      t1187 = 0.1014202173808688D0*t284*t1185
      t1191 = 0.225D1*t385*t386*t397*t120
      t1194 = 0.9D1*t385*t387*t428
      t1195 = t1060+t1063+t1072-t1075+t1082+t1096-t1098+t1174+t1177
     #-t1179-t1191-t1194
      t1196 = 0.2D1*t1156
      t1200 = 0.303966D0*t101*t397*t114*t340
      t1212 = 0.1125D1*t379*(-0.1132974264373283D1*t1116
     #+0.271913823449588D1*t1118-0.4994648585728036D0*t1058
     #+0.1498394575718411D1*t1073-0.1075243117819161D0*t1124
     #+0.4300972471276643D0*t1126-0.4247805766949639D-1*t1130
     #+0.2548683460169784D0*t1132)*t388
      t1213 = 0.8837926660346786D-1*t1150
      t1216 = 0.3847322101863073D2*t138*t114*t738
      t1217 = t116*t443
      t1222 = 0.6992635708828627D-2*t347/t1217*t373*t114
      t1223 = t377**2
      t1227 = t99**2
      t1232 = 0.3330964647361876D2*t91/t1223*t1079/t1227*t112*t120
      t1234 = 0.5827196424023856D-3*t1058*t374
      t1238 = 0.1748158927207157D-2*t349*t100*t397*t120
      t1240 = 0.1748158927207157D-2*t1073*t374
      t1245 = 0.5176049408441869D-1*t349*t378*t384*t386*t121
      t1248 = 0.759915D0*t101*t401*t738
      t1249 = 0.1D1*t1168
      t1250 = -t1196+t1200-t1212-t1213+t1216-t1222-t1232-t1234-t1238
     #+t1240+t1245-t1248+t1249
      t1256 = t437**2
      t1261 = -0.4042761511756372D2*(t1195+t1250)*t156
     #+0.2425656907053823D3*t832*t437-0.4851313814107647D3*t835*t1256
     #+0.1212828453526912D3*t288*t1052
      t1263 = t168*t1261*t159
      t1265 = 0.1086645186223595D-1*t284*t1263
      t1268 = 0.3808092365862222D0*t743*t152*t1256
      t1271 = 0.5923699235785679D0*t280*t445*t437
      t1274 = 0.1269364121954074D0*t280*t152*t1052
      t1276 = 1/t150/t116
      t1278 = 0.4936416029821399D0*t149*t1276
      t1279 = t453**2
      t1280 = t168*t1279
      t1281 = t1280*t754
      t1283 = 0.2173290372447189D-1*t321*t1281
      t1284 = t1280*t159
      t1286 = 0.1086645186223595D-1*t284*t1284
      t1289 = t165/t166/t737
      t1290 = t163*t1289
      t1292 = t854*t168
      t1293 = t1292*t1256
      t1295 = 0.2173290372447189D0*t163*t1293
      t1296 = t859*t437
      t1298 = 0.4056808695234754D0*t163*t1296
      t1299 = t298*t1052
      t1301 = 0.4346580744894379D-1*t163*t1299
      t1302 = t1183+t1187-t1265+t1268+t1271-t1274+t1278+t1283-t1286
     #+0.2873572825791284D0*t1290+t1295+t1298-t1301
      t1306 = 0.5395172183039748D1*t872*t485
      t1307 = t485**2
      t1309 = 0.5395172183039748D1*t877*t1307
      t1329 = t165*t152
      t1337 = t152*t1279
      t1359 = 0.5862637881547585D0*t179*t1293-0.1712109500228824D0
     #*t309*t152*t1261*t159+0.6848438000915295D0*t886*t469*t1180
     #+0.1597968866880236D1*t173*t907*t437-0.3424219000457648D0*t173
     #*t314*t1052+0.7989844334401178D0*t309*t445*t453*t159
     #+0.1027265700137294D1*t173*t1329*t1256-0.5862637881547585D-1
     #*t321*t1284+0.7751710087824029D0*t179*t1289+0.3424219000457648D0
     #*t882*t1337*t754-0.1712109500228824D0*t309*t1337*t159
     #+0.1331640722400196D1*t173*t148*t1276+0.1094359071222216D1*t179
     #*t1296+0.4690110305238068D0*t920*t1181+0.547179535611108D0*t321
     #*t1185-0.1172527576309517D0*t179*t1299-0.5862637881547585D-1
     #*t321*t1263+0.1758791364464276D0*t917*t1281
      t1361 = 0.2697586091519874D1*t307*t1359
      t1368 = 0.2D1*t507*sigma*t529
      t1369 = t488**2
      t1372 = 0.2473556743557577D-1*t147*t1369*t950
      t1374 = 0.7420670230672731D-1*t270*t1052
      t1375 = t1055+t1060+t1063+t1072-t1075+t1082+t1096-t1098+t1174
     #+t1177-t1179+0.2473556743557577D-1*t147*(0.2697586091519874D1
     #*t1302*t183-t1306+t1309-t1361)*t331-t1191+t1368-t1194-t1196
     #+t1200-t1372+t1374-t1212
      t1377 = 0.4666666666666667D1*t510*t514
      t1381 = 0.4666666666666667D1*t517*t445*t527*t208
      t1385 = 0.7777777777777778D1*t201*sigma*t1276*t208
      t1386 = t510*sigma
      t1388 = 0.2D1*t1386*t529
      t1390 = 0.4666666666666667D1*t507*t514
      t1393 = 0.2D1*t506*t437*t209
      t1394 = t527**2
      t1398 = 0.1D1*t517*t152*t1394*t208
      t1412 = t503**2
      t1426 = 0.1D1*(0.1D-2*(-0.3207349893614542D1*t1058
     #+0.9622049680843627D1*t1073-0.6318986292200858D-3*t1130
     #+0.3791391775320515D-2*t1132)*t197-0.2D-2*t494*t498*t503+0.2D-2
     #*t192/t497/t196*t1412-0.1D-2*t499*(-0.1202514962692326D1*t1058
     #+0.3607544888076978D1*t1073-0.4036488739909061D-1*t1130
     #+0.2421893243945437D0*t1132+0.3527987623518044D-1*t723))*t145*t209
      t1442 = 0.1D1*t517*t152*(-0.522423459704672D1*t1256*t204*sigma
     #+0.2786258451758251D2*t1026*t519-0.522423459704672D1*t518*sigma
     #*t1052-0.2554070247445063D2*t146*t168*sigma)*t208
      t1448 = t1216-t1222-t1232-t1234-t1238+t1240+t1245
     #+0.1484134046134546D0*t971*t965-t1248+t1249+0.1484134046134546D0
     #*t976*t1256
      t1451 = rho*(t1375-t1377-t1381-t1213+t1385+t1388-t1390+t1393
     #+t1398+t1426+t1442+t1448)
      t1463 = 0.7840081201533821D-1*t6/t4/t222*t10
      t1465 = 1/t14/t28
      t1468 = 0.1680027275102654D0*sigmaaa*t1465*t229
      t1472 = t27/t4/t28/t222
      t1474 = 1/t228/t227
      t1476 = 0.4480125399532632D-1*t1472*t1474
      t1480 = t28**2
      t1502 = 1/t244/t34
      t1503 = t247**2
      t1511 = 0.4444444444444444D0*t777*t348+0.4444444444444444D0*t783
     #*t348
      t1514 = 0.3799575D-1*t101*t1511*t120
      t1517 = t101*t255*t259*t117
      t1518 = 0.303966D0*t1517
      t1521 = t101*t112*t113*t117
      t1522 = 0.455949D0*t1521
      t1525 = 0.1923661050931536D1*t137*t1511*t118
      t1526 = t264*t267
      t1527 = 0.1538928840745229D2*t1526
      t1529 = t138*t113*t117
      t1530 = 0.2308393261117844D2*t1529
      t1531 = t277**2
      t1540 = -0.1111111111111111D0*t721*t348-0.1111111111111111D0
     #*t728*t348
      t1542 = 0.7420670230672731D-1*t270*t1540
      t1548 = 0.1269364121954074D0*t280*t152*t1540
      t1549 = t291**2
      t1550 = t168*t1549
      t1551 = t1550*t754
      t1554 = t292*t849
      t1565 = 0.1212828453526912D3*t288*t1540
      t1566 = -0.4042761511756372D2*(t1514-t1518-t1522+t1525+t1527
     #+t1530)*t156+0.2425656907053823D3*t829*t277-0.4851313814107647D3
     #*t835*t1531+t1565
      t1568 = t168*t1566*t159
      t1571 = t1550*t159
      t1574 = t1292*t1531
      t1577 = t298*t1540
      t1579 = 0.4346580744894379D-1*t163*t1577
      t1585 = t326**2
      t1588 = t152*t1549
      t1607 = 0.3424219000457648D0*t173*t314*t1540
      t1619 = 0.1172527576309517D0*t179*t1577
      t1620 = 0.3424219000457648D0*t882*t1588*t754
     #+0.6848438000915295D0*t886*t310*t849-0.1712109500228824D0*t309
     #*t152*t1566*t159-0.1712109500228824D0*t309*t1588*t159
     #+0.1027265700137294D1*t173*t1329*t1531-t1607
     #+0.1758791364464276D0*t917*t1551+0.4690110305238068D0*t920*t1554
     #-0.5862637881547585D-1*t321*t1568-0.5862637881547585D-1*t321
     #*t1571+0.5862637881547585D0*t179*t1574-t1619
      t1627 = t329**2
      t1633 = 0.1D1*t200*t1540*t209
      t1636 = t955*t208
      t1642 = 0.522423459704672D1*t338*t340*t1540*t208
      t1644 = t671*t162*sigma
      t1646 = 1/t166/t1217
      t1651 = t1514-t1518-t1522+t1525+t1527+t1530+0.1484134046134546D0
     #*t976*t1531+0.1484134046134546D0*t964*t972+t1542
     #+0.2473556743557577D-1*t147*(0.2697586091519874D1*
     #(0.3808092365862222D0*t743*t152*t1531-t1548
     #+0.2173290372447189D-1*t321*t1551+0.8693161489788758D-1*t759
     #*t1554-0.1086645186223595D-1*t284*t1568-0.1086645186223595D-1
     #*t284*t1571+0.2173290372447189D0*t163*t1574-t1579)*t183
     #-0.5395172183039748D1*t869*t326+0.5395172183039748D1*t877*t1585
     #-0.2697586091519874D1*t307*t1620)*t331-0.2473556743557577D-1
     #*t147*t1627*t950+t1633-0.1567270379114016D2*t200*t1531*t162
     #*t1636-t1642+0.272926271249799D2*t1644*t1646*t1531*t208
      t1653 = -t717+t990+t991+t1037+t1038+t1039-t1040+t1041+t1451
     #-0.4135669939329333D0/t14*t25*t35-0.24814019635976D1*t4*t240*t35
     #-0.9305257363491D0*t5*(t1463+t1468-t1476+0.9799966841074009D-1
     #*t1472*t19-0.4778117666686413D-1*t27*sigmaaa/t1480/t13*t19
     #+0.1608963433833121D0*t22*t1465)*t35+0.18610514726982D1*t241
     #*t248+0.24814019635976D1*t214*t248+0.9305257363491D0*t26*t245*
     #(t1463+t1468-t1476+0.3658500245218708D-4*t1472)
     #-0.18610514726982D1*t26*t1502*t1503+rho*t1651
      v2rhoa2(i) = t716+t1653
      t1656 = t950*t616
      t1658 = 0.2473556743557577D-1*t489*t1656
      t1661 = 0.1923661050931536D1*t421*t571*t118
      t1662 = -t789
      t1665 = 0.1923661050931536D1*t137*t1662*t118
      t1667 = 0.7694644203726145D1*t576*t428
      t1668 = t146*t616
      t1670 = 0.7420670230672731D-1*t1668*t965
      t1674 = 0.151983D0*t101*t571*t114*t340
      t1675 = -t734
      t1677 = 0.7420670230672731D-1*t270*t1675
      t1680 = 0.1D1*t506*t580*t209
      t1682 = 0.522423459704672D1*t961*t624
      t1683 = t437*t580
      t1685 = 0.1484134046134546D0*t976*t1683
      t1688 = 0.1D1*t200*t1675*t209
      t1695 = t338*t738*t580*t208
      t1698 = 0.2333333333333333D1*t620*t514
      t1699 = -t1658+t1661+t1665-t1667+t1670+t1674+t1677+t1680-t1682
     #+t1685+t1688-0.522423459704672D1*t338*t340*t1675*t208
     #+0.261211729852336D2*t1695-t1698
      t1700 = t580*t208
      t1701 = t955*t1700
      t1702 = t954*t1701
      t1704 = t620*sigma
      t1706 = 0.1D1*t1704*t529
      t1709 = 0.522423459704672D1*t338*t982*t1700
      t1710 = t331*t580
      t1712 = 0.7420670230672731D-1*t971*t1710
      t1715 = 0.3799575D-1*t101*t1662*t120
      t1716 = t440*t580
      t1725 = t754*t591
      t1726 = t454*t1725
      t1729 = t591*t159
      t1730 = t760*t1729
      t1734 = t462*t591*t159
      t1740 = 0.8740794636035784D-3*t349*t100*t571*t120
      t1744 = 0.1125D1*t385*t386*t571*t120
      t1745 = 0.3496317854414314D-2*t799
      t1746 = 0.45D1*t802
      t1747 = 0.151983D0*t806
      t1748 = 0.607932D0*t809
      t1749 = 0.7694644203726145D1*t819
      t1750 = 0.7694644203726145D1*t821
      t1751 = 0.3077857681490458D2*t824
      t1752 = -t1740-t1744+t1715+t1674-t1745-t1746+t1747-t1748+t1661
     #+t1665-t1667-t1749-t1750+t1751
      t1755 = t586*t165
      t1764 = -0.4042761511756372D2*t1752*t156+0.1212828453526912D3
     #*t1755*t437+0.1212828453526912D3*t832*t580-0.4851313814107647D3
     #*t835*t1683+0.1212828453526912D3*t288*t1675
      t1766 = t168*t1764*t159
      t1769 = t454*t1729
      t1772 = t159*t580
      t1773 = t454*t1772
      t1776 = t760*t580
      t1779 = t859*t580
      t1782 = t298*t1675
      t1785 = 0.3808092365862222D0*t743*t1716+0.296184961789284D0*t280
     #*t445*t580-0.1269364121954074D0*t280*t152*t1675
     #+0.2173290372447189D-1*t321*t1726+0.4346580744894379D-1*t759
     #*t1730+0.5071010869043442D-1*t284*t1734-0.1086645186223595D-1
     #*t284*t1766-0.1086645186223595D-1*t284*t1769
     #+0.4346580744894379D-1*t759*t1773+0.2173290372447189D0*t855
     #*t1776+0.2028404347617377D0*t163*t1779-0.4346580744894379D-1
     #*t163*t1782
      t1788 = t599*t306
      t1842 = 0.3424219000457648D0*t882*t469*t1725
     #+0.3424219000457648D0*t886*t440*t1729+0.3994922167200589D0*t309
     #*t445*t591*t159-0.1712109500228824D0*t309*t152*t1764*t159
     #-0.1712109500228824D0*t309*t469*t1729+0.3424219000457648D0*t886
     #*t469*t1772+0.1027265700137294D1*t904*t1716+0.7989844334401178D0
     #*t173*t907*t580-0.3424219000457648D0*t173*t314*t1675
     #+0.1758791364464276D0*t917*t1726+0.2345055152619034D0*t920*t1730
     #+0.273589767805554D0*t321*t1734-0.5862637881547585D-1*t321*t1766
     #-0.5862637881547585D-1*t321*t1769+0.2345055152619034D0*t920
     #*t1773+0.5862637881547585D0*t931*t1776+0.547179535611108D0*t179
     #*t1779-0.1172527576309517D0*t179*t1782
      t1848 = 0.2473556743557577D-1*t147*(0.2697586091519874D1*t1785
     #*t183-0.2697586091519874D1*t1788*t485-0.2697586091519874D1*t872
     #*t613+0.5395172183039748D1*t877*t485*t613-0.2697586091519874D1
     #*t307*t1842)*t331
      t1849 = -0.1044846919409344D2*t1702+t1706-t1709+t1712+t1715
     #+t1848-t1744-t1740-t1749-t1750+t1751-t1746-t1745+t1747-t1748
      t1851 = rho*(t1699+t1849)
      t1854 = t101*t571*t259*t117
      t1855 = 0.303966D0*t1854
      t1856 = t576*t267
      t1857 = 0.1538928840745229D2*t1856
      t1858 = t580**2
      t1866 = t591**2
      t1867 = t168*t1866
      t1868 = t1867*t754
      t1871 = t592*t1772
      t1881 = -0.4042761511756372D2*(t1514+t1855-t1522+t1525-t1857
     #+t1530)*t156+0.2425656907053823D3*t1755*t580
     #-0.4851313814107647D3*t835*t1858+t1565
      t1883 = t168*t1881*t159
      t1886 = t1867*t159
      t1889 = t1292*t1858
      t1897 = t613**2
      t1900 = t152*t1866
      t1927 = 0.3424219000457648D0*t882*t1900*t754
     #+0.6848438000915295D0*t886*t602*t1772-0.1712109500228824D0*t309
     #*t152*t1881*t159-0.1712109500228824D0*t309*t1900*t159
     #+0.1027265700137294D1*t173*t1329*t1858-t1607
     #+0.1758791364464276D0*t917*t1868+0.4690110305238068D0*t920*t1871
     #-0.5862637881547585D-1*t321*t1883-0.5862637881547585D-1*t321
     #*t1886+0.5862637881547585D0*t179*t1889-t1619
      t1934 = t616**2
      t1946 = t1514+t1855-t1522+t1525-t1857+t1530+0.1484134046134546D0
     #*t976*t1858+0.1484134046134546D0*t1668*t1710+t1542
     #+0.2473556743557577D-1*t147*(0.2697586091519874D1*
     #(0.3808092365862222D0*t743*t152*t1858-t1548
     #+0.2173290372447189D-1*t321*t1868+0.8693161489788758D-1*t759
     #*t1871-0.1086645186223595D-1*t284*t1883-0.1086645186223595D-1
     #*t284*t1886+0.2173290372447189D0*t163*t1889-t1579)*t183
     #-0.5395172183039748D1*t1788*t613+0.5395172183039748D1*t877*t1897
     #-0.2697586091519874D1*t307*t1927)*t331-0.2473556743557577D-1
     #*t147*t1934*t950+t1633-0.1567270379114016D2*t200*t1858*t162
     #*t1636-t1642+0.272926271249799D2*t1644*t1646*t1858*t208
      t1951 = 1/t564/t68
      t1952 = t567**2
      t1960 = 0.7840081201533821D-1*t40/t38/t542*t44
      t1962 = 1/t48/t62
      t1965 = 0.1680027275102654D0*sigmabb*t1962*t549
      t1969 = t61/t38/t62/t542
      t1971 = 1/t548/t547
      t1973 = 0.4480125399532632D-1*t1969*t1971
      t1979 = -0.1538928840745229D2*t268+0.303966D0*t262+t705+t706
     #+t707+t708-t709+t711+t712+t1851+t714-t715-t717+rho*t1946
     #+0.24814019635976D1*t534*t568-0.18610514726982D1*t60*t1951*t1952
     #+0.9305257363491D0*t60*t565*(t1960+t1965-t1973
     #+0.3658500245218708D-4*t1969)
      t1999 = -t1658+t1661+t1665-t1667+t1670+t1674+t1677+t1680-t1682
     #+t1685+t1688+0.1D1*t517*t152*(-0.522423459704672D1*t580*t204
     #*t519-0.522423459704672D1*t518*sigma*t1675+0.1393129225879125D2
     #*t1026*sigma*t580)*t208+0.1218988072644235D2*t1695-t1698
      t2001 = -0.522423459704672D1*t1702+t1706+t1848-t1709+t1712+t1715
     #-t1744-t1740-t1749-t1750+t1751-t1746-t1745+t1747-t1748
      t2003 = rho*(t1999+t2001)
      t2012 = t62**2
      t2030 = 0.18610514726982D1*t561*t568+0.759915D-1*t573
     #+0.3847322101863073D1*t577+t2003+t991+0.1484134046134546D0*t581
     #+t1038+t1039-t1040+t1041+0.4947113487115154D-1*t618
     #-0.24814019635976D1*t38*t560*t69-0.9305257363491D0*t39*(t1960
     #+t1965-t1973+0.9799966841074009D-1*t1969*t53
     #-0.4778117666686413D-1*t61*sigmabb/t2012/t47*t53
     #+0.1608963433833121D0*t56*t1962)*t69-0.4135669939329333D0/t48
     #*t59*t69+0.2D1*t621-0.1044846919409344D2*t625+t1451
      v2rhob2(i) = t1979+t2030
      t2032 = t258+t266+t279+t333+t705+t706+t707+t708-t709+t336+t711
     #+t712-t344+0.5D0*t1851+t714-t715
      t2034 = -t1511
      t2037 = 0.3799575D-1*t101*t2034*t120
      t2038 = 0.151983D0*t1517
      t2039 = 0.151983D0*t1854
      t2040 = 0.455949D0*t1521
      t2043 = 0.1923661050931536D1*t137*t2034*t118
      t2044 = 0.7694644203726145D1*t1526
      t2045 = 0.7694644203726145D1*t1856
      t2046 = 0.2308393261117844D2*t1529
      t2047 = t277*t580
      t2052 = -t1540
      t2057 = t281*t580
      t2063 = t292*t1725
      t2066 = t292*t1772
      t2080 = -0.4042761511756372D2*(t2037+t2038-t2039+t2040+t2043
     #-t2044+t2045-t2046)*t156+0.1212828453526912D3*t829*t580
     #+0.1212828453526912D3*t1755*t277-0.4851313814107647D3*t835*t2047
     #+0.1212828453526912D3*t288*t2052
      t2082 = t168*t2080*t159
      t2085 = t292*t1729
      t2088 = t168*t277
      t2089 = t2088*t1729
      t2092 = t2088*t580
      t2095 = t298*t2052
      t2143 = 0.3424219000457648D0*t882*t310*t1725
     #+0.3424219000457648D0*t886*t310*t1772-0.1712109500228824D0*t309
     #*t152*t2080*t159-0.1712109500228824D0*t309*t310*t1729
     #+0.3424219000457648D0*t886*t281*t1729+0.1027265700137294D1*t904
     #*t2057-0.3424219000457648D0*t173*t314*t2052+0.1758791364464276D0
     #*t917*t2063+0.2345055152619034D0*t920*t2066
     #-0.5862637881547585D-1*t321*t2082-0.5862637881547585D-1*t321
     #*t2085+0.2345055152619034D0*t920*t2089+0.5862637881547585D0*t931
     #*t2092-0.1172527576309517D0*t179*t2095
      t2162 = t1646*t277
      s1 = t2037+t2038-t2039+t2040+t2043-t2044+t2045-t2046
     #+0.1484134046134546D0*t976*t2047
      s2 = s1+0.7420670230672731D-1*t1668*t972+0.7420670230672731D-1
     #*t270*t2052+0.7420670230672731D-1*t964*t1710
     #+0.2473556743557577D-1*t147*(0.2697586091519874D1*
     #(0.3808092365862222D0*t743*t2057-0.1269364121954074D0*t280*t152
     #*t2052+0.2173290372447189D-1*t321*t2063+0.4346580744894379D-1
     #*t759*t2066-0.1086645186223595D-1*t284*t2082
     #-0.1086645186223595D-1*t284*t2085+0.4346580744894379D-1*t759
     #*t2089+0.2173290372447189D0*t855*t2092-0.4346580744894379D-1
     #*t163*t2095)*t183-0.2697586091519874D1*t869*t613
     #-0.2697586091519874D1*t1788*t326+0.5395172183039748D1*t877*t326
     #*t613-0.2697586091519874D1*t307*t2143)*t331
      t2166 = s2-0.2473556743557577D-1*t330*t1656+0.1D1*t200*t2052
     #*t209-0.1567270379114016D2*t334*t162*t1701-0.522423459704672D1
     #*t338*t340*t2052*t208+0.272926271249799D2*t1644*t2162*t1700
      t2170 = t1055+t1060+t1063+t1072-t1075+t1082+t1096-t1098+t1174
     #+t1177-t1179-t1191+t1368-t1194-t1196+t1200-t1372+t1374-t1212-t1377
      t2172 = t1278+t1183+t1187-t1265+t1268+t1271-t1274+t1283+t1295
     #+t1298-t1301-t1286+0.2873572825791284D0*t1290
      t2183 = -t717+0.5D0*t990+rho*t2166+t574+t578+0.5D0*t2003+t991
     #+t582+0.5D0*t1037+t1038+t1039-t1040+t1041+t619+t622-t626+rho*
     #(t2170-t1381-t1213+t1385+t1388-t1390+0.2473556743557577D-1*t147*
     #(0.2697586091519874D1*t2172*t183-t1306+t1309-t1361)*t331+t1393
     #+t1398+t1426+t1442+t1448)
      v2rhoab(i) = t2032+t2183
      t2191 = 0.1680017400328676D-1*t629*t218*t10
      t2193 = 0.5040081825307963D-1*t224*t229
      t2194 = sigmaaa*t234
      t2196 = 0.1680047024824737D-1*t2194*t1474
      t2224 = t146*t664
      t2228 = t308*t165
      t2238 = t653*t306
      t2244 = t178*t148
      t2247 = t161*t156
      t2250 = t881*t165
      t2262 = t950*t664
      t2268 = t340*t146*t208
      t2272 = t200*t164*t162
      t2277 = rho*(0.7420670230672731D-1*t2224*t972
     #+0.2473556743557577D-1*t147*(0.2697586091519874D1*(
     #-0.1269364121954074D0*t315-0.2173290372447189D-1*t2228*t293
     #-0.8693161489788758D-1*t173*t299)*t183-0.2697586091519874D1*t869
     #*t661-0.2697586091519874D1*t2238*t326+0.5395172183039748D1*t877
     #*t326*t661-0.2697586091519874D1*t307*(-0.1712109500228824D0
     #*t2244*t311-0.3424219000457648D0*t2247*t281-0.1172527576309517D0
     #*t2250*t293-0.2345055152619034D0*t308*t299))*t331
     #-0.2473556743557577D-1*t330*t2262+0.1D1*t334*t668
     #-0.130605864926168D2*t718*t2268+0.1364631356248995D2*t2272*t2162
     #*t208)
      s1 = 0.7420670230672731D-1*t2224*t965+0.2473556743557577D-1*t147
     #*(0.2697586091519874D1*(-0.1269364121954074D0*t473
     #-0.148092480894642D0*t476-0.2173290372447189D-1*t2228*t455
     #-0.8693161489788758D-1*t173*t458-0.1014202173808688D0*t173*t463)
     #*t183-0.2697586091519874D1*t872*t661-0.2697586091519874D1*t2238
     #*t485+0.5395172183039748D1*t877*t485*t661-0.2697586091519874D1
     #*t307*(-0.1712109500228824D0*t2244*t470-0.3424219000457648D0
     #*t2247*t440-0.3994922167200589D0*t656*t445-0.1172527576309517D0
     #*t2250*t455-0.2345055152619034D0*t308*t458-0.273589767805554D0
     #*t308*t463))*t331-0.2473556743557577D-1*t489*t2262+0.1D1*t507
     #*t668-0.261211729852336D1*t506*t147*t673+0.1D1*t510*t668
      t2349 = s1-0.261211729852336D1*t1386*t2268-0.2333333333333333D1
     #*t201*t445*t208+0.6094940363221173D1*t671*sigma*t738*t208+0.1D1
     #*t201*t529+0.1D1*t517*t152*(-0.522423459704672D1*t518*t437
     #+0.6965646129395627D1*t524)*t208-0.261211729852336D1*t671*sigma
     #*t982*t208
      t2350 = rho*t2349
      v2rhoasigmaaa(i) = -0.12407009817988D1*t4*t640*t35
     #+0.12407009817988D1*t214*t647-0.9305257363491D0*t5*(-t2191-t2193
     #+t2196-0.3266655613691336D-1*t234*t19*sigmaaa
     #+0.1791794125007405D-1*t27/t1480/rhoa*t19-0.4388082092272149D-1
     #*t21*t224)*t35+0.9305257363491D0*t241*t647+0.9305257363491D0
     #*t641*t248-0.18610514726982D1*t26*t1502*t247*t646
     #+0.9305257363491D0*t26*t245*(-t2191-t2193+t2196
     #-0.1155315866911171D-4*t2194)+t2277+t667+t670-t675+t2350
      t2352 = 0.4947113487115154D-1*t666
      t2353 = 0.2D1*t669
      t2354 = 0.522423459704672D1*t674
      t2355 = 2.D0*t2350
      v2rhoasigmaab(i) = 2.D0*t2277+t2352+t2353-t2354+t2355
      v2rhoasigmabb(i) = t2277+t667+t670-t675+t2350
      t2399 = rho*(0.7420670230672731D-1*t2224*t1710
     #+0.2473556743557577D-1*t147*(0.2697586091519874D1*(
     #-0.1269364121954074D0*t606-0.2173290372447189D-1*t2228*t593
     #-0.8693161489788758D-1*t173*t596)*t183-0.2697586091519874D1
     #*t1788*t661-0.2697586091519874D1*t2238*t613+0.5395172183039748D1
     #*t877*t613*t661-0.2697586091519874D1*t307*(-0.1712109500228824D0
     #*t2244*t603-0.3424219000457648D0*t2247*t583-0.1172527576309517D0
     #*t2250*t593-0.2345055152619034D0*t308*t596))*t331
     #-0.2473556743557577D-1*t617*t2262+0.1D1*t620*t668
     #-0.130605864926168D2*t1704*t2268+0.1364631356248995D2*t2272
     #*t1646*t580*t208)
      v2rhobsigmaaa(i) = t2399+t667+t670-t675+t2350
      v2rhobsigmaab(i) = 2.D0*t2399+t2352+t2353-t2354+t2355
      t2408 = 0.1680017400328676D-1*t678*t538*t44
      t2410 = 0.5040081825307963D-1*t544*t549
      t2411 = sigmabb*t554
      t2413 = 0.1680047024824737D-1*t2411*t1971
      v2rhobsigmabb(i) = -0.12407009817988D1*t38*t689*t69
     #+0.12407009817988D1*t534*t696-0.9305257363491D0*t39*(-t2408
     #-t2410+t2413-0.3266655613691336D-1*t554*t53*sigmabb
     #+0.1791794125007405D-1*t61/t2012/rhob*t53-0.4388082092272149D-1
     #*t55*t544)*t69+0.9305257363491D0*t561*t696+0.9305257363491D0
     #*t690*t568-0.18610514726982D1*t60*t1951*t567*t695
     #+0.9305257363491D0*t60*t565*(-t2408-t2410+t2413
     #-0.1155315866911171D-4*t2411)+t2399+t667+t670-t675+t2350
      t2445 = 0.6300065251232535D-2/t6/sigmaaa*t7*t10
      t2449 = 0.6300102281634954D-2/sigmaaa*t16*t229
      t2451 = 0.6300176343092764D-2*t31*t1474
      t2463 = t646**2
      t2478 = t661**2
      t2489 = t664**2
      t2502 = rho*(0.2473556743557577D-1*t147*(0.5862637881547585D-1
     #*t161*t165*t168*t183-0.5395172183039748D1*t2238*t661
     #+0.5395172183039748D1*t877*t2478-0.1581497040888031D0*t307*t178
     #*t165*t168)*t331-0.2473556743557577D-1*t147*t2489*t950
     #-0.522423459704672D1*t671*t340*t208+0.6823156781244976D1*t200
     #*t296*sigma*t1646*t208)
      v2sigmaaa2(i) = -0.9305257363491D0*t5*(-t2445+t2449-t2451
     #-0.6719227968777768D-2/t1480*t19*sigmaaa+0.8166639034228341D-2
     #*t635)*t35+0.18610514726982D1*t641*t647-0.18610514726982D1*t26
     #*t1502*t2463+0.9305257363491D0*t26*t245*(-t2445+t2449-t2451
     #+0.2166217250458446D-5*t31)+t2502
      v2sigmaaaab(i) = 2.D0*t2502
      v2sigmaaabb(i) = t2502
      v2sigmaab2(i) = 4.D0*v2sigmaaabb(i)
      v2sigmaabbb(i) = v2sigmaaaab(i)
      t2507 = 0.6300065251232535D-2/t40/sigmabb*t41*t44
      t2511 = 0.6300102281634954D-2/sigmabb*t50*t549
      t2513 = 0.6300176343092764D-2*t65*t1971
      t2525 = t695**2
      v2sigmabb2(i) = -0.9305257363491D0*t39*(-t2507+t2511-t2513
     #-0.6719227968777768D-2/t2012*t53*sigmabb+0.8166639034228341D-2
     #*t684)*t69+0.18610514726982D1*t690*t696-0.18610514726982D1*t60
     #*t1951*t2525+0.9305257363491D0*t60*t565*(-t2507+t2511-t2513
     #+0.2166217250458446D-5*t65)+v2sigmaaabb(i)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_xc_pw91
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     J.P. Perdew, J.A. Chevary, S.H. Vosko, K.A. Jackson,
c     M.R. Pederson, D.J. Singh, C. Fiolhais
c     Atoms, molecules, solids and surfaces:
c     Applications of the generalized gradient approximation
c     for exchange and correlation
c     Phys. Rev. B 46 (1992) 6671--6687
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = dsqrt(sigma)
      t6 = t4/t3
      t8 = dlog(0.1259928455434599D1*t6+dsqrt(1+0.1587419712813814D1
     #*t6**2))
      t10 = 0.3175033930295641D-1*t6*t8
      t11 = rho**2
      t12 = t2**2
      t14 = 1/t12/t11
      t17 = dexp(-0.261211729852336D1*t14*sigma)
      t25 = sigma**2
      t26 = t11**2
      t36 = 1/rho
      t37 = t36**(1.D0/3.D0)
      t40 = t36**(1.D0/6.D0)
      t43 = dsqrt(t36)
      t45 = t37**2
      t51 = dlog(1.D0+0.160818243221511D2/(0.598255043577108D1*t40
     #+0.2225569421150687D1*t37+0.8004286349993634D0*t43
     #+0.1897004325747559D0*t45))
      t52 = (1.D0+0.1325688999052018D0*t37)*t51
      t55 = 1/t2/t11
      t59 = dexp(0.2513869963240348D1*t52)
      t60 = t59-1.D0
      t61 = 1/t60
      t64 = 1/t12/t26
      t71 = t60**2
      t81 = dlog(1.D0+0.2697586091519874D1*(0.634682060977037D-1*sigma
     #*t55+0.1086645186223595D-1*t61*t25*t64)/(1.D0
     #+0.1712109500228824D0*t61*sigma*t55+0.2931318940773793D-1/t71
     #*t25*t64))
      zk(i) = -0.7385587663820224D0*t3*(1.D0+t10+0.261211729852336D-1*
     #(0.2743D0-0.1508D0*t17)*sigma*t14)/(1.D0+t10
     #+0.272926271249799D-5*t25/t2/t26/rho)+rho*(-0.62182D-1*t52
     #+0.2473556743557577D-1*t81+0.1D1*(0.1D-2*(0.2568D1
     #+0.1443307452126544D2*t37+0.2843543831490386D-2*t45)/(1.D0
     #+0.5411317332115466D1*t37+0.1816419932959077D0*t45
     #+0.1763993811759022D-1*t36)-0.1853571428571429D-2)*sigma*t55*t17)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = dsqrt(sigma)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1259928455434599D1*t6+dsqrt(1+0.1587419712813814D1
     #*t6**2))
      t10 = 0.3175033930295641D-1*t6*t8
      t11 = rho**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = t14*sigma
      t17 = dexp(-0.261211729852336D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigma
      t23 = 1.D0+t10+0.261211729852336D-1*t20*t14
      t24 = t3*t23
      t25 = sigma**2
      t26 = t11**2
      t27 = t26*rho
      t29 = 1/t2/t27
      t32 = 1.D0+t10+0.272926271249799D-5*t25*t29
      t33 = 1/t32
      t36 = 1/rho
      t37 = t36**(1.D0/3.D0)
      t39 = 1.D0+0.1325688999052018D0*t37
      t40 = t36**(1.D0/6.D0)
      t43 = dsqrt(t36)
      t45 = t37**2
      t47 = 0.598255043577108D1*t40+0.2225569421150687D1*t37
     #+0.8004286349993634D0*t43+0.1897004325747559D0*t45
      t50 = 1.D0+0.160818243221511D2/t47
      t51 = dlog(t50)
      t52 = t39*t51
      t53 = 0.62182D-1*t52
      t55 = 1/t2/t11
      t59 = dexp(0.2513869963240348D1*t52)
      t60 = t59-1.D0
      t61 = 1/t60
      t62 = t61*t25
      t64 = 1/t12/t26
      t67 = 0.634682060977037D-1*sigma*t55+0.1086645186223595D-1*t62*t64
      t68 = t61*sigma
      t71 = t60**2
      t72 = 1/t71
      t73 = t72*t25
      t76 = 1.D0+0.1712109500228824D0*t68*t55+0.2931318940773793D-1
     #*t73*t64
      t77 = 1/t76
      t80 = 1.D0+0.2697586091519874D1*t67*t77
      t81 = dlog(t80)
      t82 = 0.2473556743557577D-1*t81
      t85 = 0.2568D1+0.1443307452126544D2*t37+0.2843543831490386D-2*t45
      t89 = 1.D0+0.5411317332115466D1*t37+0.1816419932959077D0*t45
     #+0.1763993811759022D-1*t36
      t90 = 1/t89
      t93 = 0.1D-2*t85*t90-0.1853571428571429D-2
      t94 = t93*sigma
      t95 = t55*t17
      t97 = 0.1D1*t94*t95
      zk(i) = -0.7385587663820224D0*t24*t33+rho*(-t53+t82+t97)
      t105 = 0.8466757147455043D-1*t4*t55*t8
      t106 = t11*rho
      t108 = 1/t12/t106
      t112 = dsqrt(1.D0+0.1587419712813815D1*t15)
      t113 = 1/t112
      t115 = 0.1066750825533289D0*sigma*t108*t113
      t116 = t26*t11
      t119 = t25/t2/t116
      t128 = t32**2
      t129 = 1/t128
      t136 = 1/t11
      t137 = 1/t45*t136
      t138 = t137*t51
      t140 = t47**2
      t143 = t40**2
      t144 = t143**2
      t154 = 1/t37*t136
      t159 = t39/t140*(-0.99709173929518D0/t144/t40*t136
     #-0.7418564737168958D0*t137-0.4002143174996817D0/t43*t136
     #-0.1264669550498372D0*t154)/t50
      t162 = 1/t2/t106
      t167 = -0.1110869918438343D0*t138-0.4042761511756372D2*t159
      t169 = t64*t167*t59
      t173 = 1/t12/t27
      t179 = t76**2
      t181 = t67/t179
      t182 = t72*sigma
      t200 = 1/t80
      t208 = t89**2
      s1 = -0.9847450218426965D0*t2*t23*t33-0.3692793831910112D0*t3*(
     #-t105-t115-0.5487637560595959D-1*t119*t17-0.1393129225879125D0
     #*t20*t108)*t33+0.3692793831910112D0*t24*t129*(-t105-t115
     #-0.2911213559997856D-4*t119)
      vrhoa(i) = s1-t53+t82+t97+rho*(0.2747799777968419D-2*t138+0.1D1
     #*t159+0.2473556743557577D-1*(0.2697586091519874D1*(
     #-0.148092480894642D0*sigma*t162-0.1086645186223595D-1*t73*t169
     #-0.5071010869043442D-1*t62*t173)*t77-0.2697586091519874D1*t181*(
     #-0.1712109500228824D0*t182*t55*t167*t59-0.3994922167200589D0*t68
     #*t162-0.5862637881547585D-1/t71/t60*t25*t169-0.136794883902777D0
     #*t73*t173))*t200+0.1D1*(0.1D-2*(-0.4811024840421814D1*t137
     #-0.1895695887660258D-2*t154)*t90-0.1D-2*t85/t208*(
     #-0.1803772444038489D1*t137-0.1210946621972718D0*t154
     #-0.1763993811759022D-1*t136))*sigma*t95-0.2333333333333333D1*t94
     #*t162*t17+0.6965646129395627D1*t93*t25/t116*t17)
      t234 = 0.6350067860591282D-1/t4*t5*t8
      t236 = 0.8000631191499664D-1*t14*t113
      vsigmaaa(i) = -0.7385587663820224D0*t3*(t234+t236
     #+0.411572817044697D-1*t29*t17*sigma+0.1044846919409344D0*t19*t14
     #)*t33+0.7385587663820224D0*t24*t129*(t234+t236
     #+0.2183410169998392D-4*sigma*t29)+4.D0*rho*
     #(0.2473556743557577D-1*(0.2697586091519874D1*
     #(0.634682060977037D-1*t55+0.2173290372447189D-1*t68*t64)*t77
     #-0.2697586091519874D1*t181*(0.1712109500228824D0*t61*t55
     #+0.5862637881547585D-1*t182*t64))*t200+0.1D1*t93*t55*t17
     #-0.261211729852336D1*t94/t27*t17)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t4 = dsqrt(sigma)
      t5 = 1/t3
      t6 = t4*t5
      t8 = dlog(0.1259928455434599D1*t6+dsqrt(1+0.1587419712813814D1
     #*t6**2))
      t10 = 0.3175033930295641D-1*t6*t8
      t11 = rho**2
      t12 = t2**2
      t14 = 1/t12/t11
      t15 = t14*sigma
      t17 = dexp(-0.261211729852336D1*t15)
      t19 = 0.2743D0-0.1508D0*t17
      t20 = t19*sigma
      t23 = 1.D0+t10+0.261211729852336D-1*t20*t14
      t24 = t3*t23
      t25 = sigma**2
      t26 = t11**2
      t27 = t26*rho
      t29 = 1/t2/t27
      t32 = 1.D0+t10+0.272926271249799D-5*t25*t29
      t33 = 1/t32
      t36 = 1/rho
      t37 = t36**(1.D0/3.D0)
      t39 = 1.D0+0.1325688999052018D0*t37
      t40 = t36**(1.D0/6.D0)
      t43 = dsqrt(t36)
      t45 = t37**2
      t47 = 0.598255043577108D1*t40+0.2225569421150687D1*t37
     #+0.8004286349993634D0*t43+0.1897004325747559D0*t45
      t50 = 1.D0+0.160818243221511D2/t47
      t51 = dlog(t50)
      t52 = t39*t51
      t53 = 0.62182D-1*t52
      t55 = 1/t2/t11
      t59 = dexp(0.2513869963240348D1*t52)
      t60 = t59-1.D0
      t61 = 1/t60
      t62 = t61*t25
      t64 = 1/t12/t26
      t67 = 0.634682060977037D-1*sigma*t55+0.1086645186223595D-1*t62*t64
      t68 = t61*sigma
      t71 = t60**2
      t72 = 1/t71
      t73 = t72*t25
      t76 = 1.D0+0.1712109500228824D0*t68*t55+0.2931318940773793D-1
     #*t73*t64
      t77 = 1/t76
      t80 = 1.D0+0.2697586091519874D1*t67*t77
      t81 = dlog(t80)
      t82 = 0.2473556743557577D-1*t81
      t85 = 0.2568D1+0.1443307452126544D2*t37+0.2843543831490386D-2*t45
      t89 = 1.D0+0.5411317332115466D1*t37+0.1816419932959077D0*t45
     #+0.1763993811759022D-1*t36
      t90 = 1/t89
      t93 = 0.1D-2*t85*t90-0.1853571428571429D-2
      t94 = t93*sigma
      t95 = t55*t17
      t97 = 0.1D1*t94*t95
      zk(i) = -0.7385587663820224D0*t24*t33+rho*(-t53+t82+t97)
      t100 = t2*t23
      t105 = 0.8466757147455043D-1*t4*t55*t8
      t106 = t11*rho
      t108 = 1/t12/t106
      t111 = 1.D0+0.1587419712813815D1*t15
      t112 = dsqrt(t111)
      t113 = 1/t112
      t115 = 0.1066750825533289D0*sigma*t108*t113
      t116 = t26*t11
      t118 = 1/t2/t116
      t119 = t25*t118
      t124 = -t105-t115-0.5487637560595959D-1*t119*t17
     #-0.1393129225879125D0*t20*t108
      t125 = t3*t124
      t128 = t32**2
      t129 = 1/t128
      t131 = -t105-t115-0.2911213559997856D-4*t119
      t132 = t129*t131
      t135 = 1/t45
      t136 = 1/t11
      t137 = t135*t136
      t138 = t137*t51
      t140 = t47**2
      t141 = 1/t140
      t142 = t39*t141
      t143 = t40**2
      t144 = t143**2
      t145 = t144*t40
      t146 = 1/t145
      t150 = 1/t43
      t153 = 1/t37
      t154 = t153*t136
      t156 = -0.99709173929518D0*t146*t136-0.7418564737168958D0*t137
     #-0.4002143174996817D0*t150*t136-0.1264669550498372D0*t154
      t157 = 1/t50
      t159 = t142*t156*t157
      t162 = 1/t2/t106
      t167 = -0.1110869918438343D0*t138-0.4042761511756372D2*t159
      t169 = t64*t167*t59
      t173 = 1/t12/t27
      t176 = -0.148092480894642D0*sigma*t162-0.1086645186223595D-1*t73
     #*t169-0.5071010869043442D-1*t62*t173
      t179 = t76**2
      t180 = 1/t179
      t181 = t67*t180
      t182 = t72*sigma
      t190 = 1/t71/t60
      t191 = t190*t25
      t196 = -0.1712109500228824D0*t182*t55*t167*t59
     #-0.3994922167200589D0*t68*t162-0.5862637881547585D-1*t191*t169
     #-0.136794883902777D0*t73*t173
      t199 = 0.2697586091519874D1*t176*t77-0.2697586091519874D1*t181
     #*t196
      t200 = 1/t80
      t201 = t199*t200
      t205 = -0.4811024840421814D1*t137-0.1895695887660258D-2*t154
      t208 = t89**2
      t209 = 1/t208
      t210 = t85*t209
      t214 = -0.1803772444038489D1*t137-0.1210946621972718D0*t154
     #-0.1763993811759022D-1*t136
      t217 = 0.1D-2*t205*t90-0.1D-2*t210*t214
      t218 = t217*sigma
      t219 = t218*t95
      t221 = t162*t17
      t222 = t94*t221
      t224 = t93*t25
      t226 = 1/t116*t17
      t227 = t224*t226
      vrhoa(i) = -0.9847450218426965D0*t100*t33-0.3692793831910112D0
     #*t125*t33+0.3692793831910112D0*t24*t132-t53+t82+t97+rho*
     #(0.2747799777968419D-2*t138+0.1D1*t159+0.2473556743557577D-1
     #*t201+0.1D1*t219-0.2333333333333333D1*t222+0.6965646129395627D1
     #*t227)
      t231 = 1/t4
      t234 = 0.6350067860591282D-1*t231*t5*t8
      t236 = 0.8000631191499664D-1*t14*t113
      t237 = t29*t17
      t242 = t234+t236+0.411572817044697D-1*t237*sigma
     #+0.1044846919409344D0*t19*t14
      t243 = t3*t242
      t248 = t234+t236+0.2183410169998392D-4*sigma*t29
      t249 = t129*t248
      t255 = 0.634682060977037D-1*t55+0.2173290372447189D-1*t68*t64
      t262 = 0.1712109500228824D0*t61*t55+0.5862637881547585D-1*t182*t64
      t265 = 0.2697586091519874D1*t255*t77-0.2697586091519874D1*t181
     #*t262
      t266 = t265*t200
      t269 = t93*t55*t17
      t271 = 1/t27
      t272 = t271*t17
      t273 = t94*t272
      vsigmaaa(i) = -0.7385587663820224D0*t243*t33
     #+0.7385587663820224D0*t24*t249+4.D0*rho*(0.2473556743557577D-1
     #*t266+0.1D1*t269-0.261211729852336D1*t273)
      t284 = t26*t106
      t287 = t224/t284*t17
      t290 = 1/t2/t26
      t293 = t93*t290*sigma*t17
      t297 = 1/t26
      t298 = 1/t45/t36*t297
      t300 = 1/t106
      t301 = t135*t300
      t305 = 1/t37/t36*t297
      t307 = t153*t300
      t318 = t214**2
      t333 = t199**2
      t334 = t80**2
      t335 = 1/t334
      t356 = t142*(-0.8309097827459833D0/t145/t36*t297
     #+0.199418347859036D1*t146*t300-0.4945709824779306D0*t298
     #+0.1483712947433792D1*t301-0.2001071587498409D0/t43/t36*t297
     #+0.8004286349993634D0*t150*t300-0.4215565168327908D-1*t305
     #+0.2529339100996745D0*t307)*t157
      t358 = t140**2
      t361 = t156**2
      t362 = t50**2
      t365 = t39/t358*t361/t362
      t367 = t301*t51
      t371 = t137*t141*t156*t157
      t373 = t298*t51
      t379 = t39/t140/t47*t361*t157
      t386 = t25*sigma
      t388 = t26**2
      t389 = t388*rho
      t395 = sigma*t290
      t398 = t173*t167*t59
      t407 = -0.4042761511756372D2*t356-0.6501498040842D3*t365
     #+0.2221739836876686D0*t367+0.3572962974617552D1*t371
     #-0.740579945625562D-1*t373+0.8085523023512745D2*t379
      t409 = t64*t407*t59
      t412 = t167**2
      t413 = t64*t412
      t415 = dexp(0.5027739926480695D1*t52)
      t416 = t413*t415
      t419 = t413*t59
      t423 = 1/t12/t116
      t424 = t62*t423
      t429 = t176*t180
      t434 = t67/t179/t76
      t435 = t196**2
      t448 = t71**2
      t453 = t190*sigma
      t454 = t55*t412
      t461 = t68*t290
      t463 = t73*t423
      s1 = -0.5804705107829689D2*t287+0.7777777777777778D1*t293+0.1D1*
     #(0.1D-2*(-0.3207349893614542D1*t298+0.9622049680843627D1*t301
     #-0.6318986292200858D-3*t305+0.3791391775320515D-2*t307)*t90
     #-0.2D-2*t205*t209*t214+0.2D-2*t85/t208/t89*t318-0.1D-2*t210*(
     #-0.1202514962692326D1*t298+0.3607544888076978D1*t301
     #-0.4036488739909061D-1*t305+0.2421893243945437D0*t307
     #+0.3527987623518044D-1*t300))*sigma*t95-0.2473556743557577D-1
     #*t333*t335+0.1D1*t356+0.160818243221511D2*t365
     #-0.5495599555936838D-2*t367
      s2 = s1-0.8837926660346786D-1*t371+0.1831866518645613D-2*t373
     #-0.2D1*t379
      s3 = s2+0.1393129225879125D2*t217*t25*t226
      t475 = s3-0.4666666666666667D1*t218*t221+0.4852022599996427D2
     #*t93*t386/t12/t389*t17+0.2473556743557577D-1*
     #(0.2697586091519874D1*(0.4936416029821399D0*t395
     #+0.1014202173808688D0*t73*t398-0.1086645186223595D-1*t73*t409
     #+0.2173290372447189D-1*t191*t416-0.1086645186223595D-1*t73*t419
     #+0.2873572825791284D0*t424)*t77-0.5395172183039748D1*t429*t196
     #+0.5395172183039748D1*t434*t435-0.2697586091519874D1*t181*
     #(0.547179535611108D0*t191*t398-0.1712109500228824D0*t182*t55
     #*t407*t59+0.7989844334401178D0*t182*t162*t167*t59
     #+0.1758791364464276D0/t448*t25*t416+0.3424219000457648D0*t453
     #*t454*t415-0.1712109500228824D0*t182*t454*t59
     #+0.1331640722400196D1*t461+0.7751710087824029D0*t463
     #-0.5862637881547585D-1*t191*t409-0.5862637881547585D-1*t191*t419
     #))*t200
      t488 = dlog(1.D0+0.2960857464321668D2/(0.8157414703487641D1*t40
     #+0.2247591863577616D1*t37+0.4300972471276643D0*t43
     #+0.1911512595127338D0*t45))
      t490 = (1.D0+0.6901399211255825D-1*t37)*t488*t136
      t492 = t81*t136
      t498 = -0.1365402272980597D1*t490+0.1675913308826898D1*t52*t136
      t500 = t64*t498*t59
      t528 = 1/t128/t32
      t529 = t131**2
      t535 = 0.395115333547902D0*t4*t162*t8
      t538 = 0.1066750825533289D1*sigma*t64*t113
      t541 = t25/t2/t284
      t543 = 1/t112/t111
      t545 = 0.4515683437631874D0*t541*t543
      t572 = -t498
      t574 = t64*t572*t59
      s1 = 0.4D1*t159+0.1099119911187368D-1*t138-0.6564966812284644D0
     #/t12*t23*t33+2.D0*rho*t475+rho*(0.33774D-1*t490
     #-0.1649037829038385D-1*t492+0.2473556743557577D-1*
     #(0.2697586091519874D1*(0.2820809159897942D-1*t395
     #-0.1086645186223595D-1*t73*t500+0.9659068321987509D-2*t424)*t77
     #-0.2697586091519874D1*t181*(-0.1712109500228824D0*t182*t55*t498
     #*t59+0.760937555657255D-1*t461-0.5862637881547585D-1*t191*t500
     #+0.2605616836243371D-1*t463))*t200-0.2222222222222222D0*t293
     #+0.1160941021565938D1*t287)+0.7385587663820224D0*t125*t132
     #-0.7385587663820224D0*t24*t528*t529+0.3692793831910112D0*t24
     #*t129*(t535+t538-t545+0.3687537175997285D-3*t541)
      v2rhoa2(i) = s1-0.3692793831910112D0*t3*(t535+t538-t545
     #+0.9877747609072727D0*t541*t17-0.764498826669826D0*t386/t388/t11
     #*t17+0.1021628098978025D1*t20*t64)*t33-0.1969490043685393D1*t2
     #*t124*t33+0.1969490043685393D1*t100*t132+rho*(-0.33774D-1*t490
     #+0.1649037829038385D-1*t492+0.2473556743557577D-1*
     #(0.2697586091519874D1*(-0.2820809159897942D-1*t395
     #-0.1086645186223595D-1*t73*t574-0.9659068321987509D-2*t424)*t77
     #-0.2697586091519874D1*t181*(-0.1712109500228824D0*t182*t55*t572
     #*t59-0.760937555657255D-1*t461-0.5862637881547585D-1*t191*t574
     #-0.2605616836243371D-1*t463))*t200+0.2222222222222222D0*t293
     #-0.1160941021565938D1*t287)+0.9894226974230308D-1*t201+0.4D1
     #*t219-0.9333333333333333D1*t222+0.2786258451758251D2*t227
      t610 = 0.1693351429491009D0*t231*t55*t8
      t612 = 0.6400504953199731D0*t108*t113
      t613 = sigma*t118
      t615 = 0.3386762578223905D0*t613*t543
      t655 = t255*t180
      s1 = -0.9847450218426965D0*t2*t242*t33+0.9847450218426965D0*t100
     #*t249-0.3692793831910112D0*t3*(-t610-t612+t615
     #-0.6585165072715151D0*t118*t17*sigma+0.5733741200023695D0*t25
     #/t389*t17-0.5572516903516501D0*t19*t108)*t33
     #+0.3692793831910112D0*t125*t249+0.3692793831910112D0*t243*t132
      s2 = s1-0.7385587663820224D0*t24*t528*t131*t248
     #+0.3692793831910112D0*t24*t129*(-t610-t612+t615
     #-0.2328970847998285D-3*t613)
      v2rhoasigmaaa(i) = s2+0.9894226974230308D-1*t266+0.4D1*t269
     #-0.1044846919409344D2*t273+4.D0*rho*(0.2473556743557577D-1*
     #(0.2697586091519874D1*(-0.148092480894642D0*t162
     #-0.2173290372447189D-1*t182*t169-0.1014202173808688D0*t68*t173)
     #*t77-0.2697586091519874D1*t429*t262-0.2697586091519874D1*t655
     #*t196+0.5395172183039748D1*t434*t196*t262-0.2697586091519874D1
     #*t181*(-0.1712109500228824D0*t72*t55*t167*t59
     #-0.3994922167200589D0*t61*t162-0.1172527576309517D0*t453*t169
     #-0.273589767805554D0*t182*t173))*t200-0.2473556743557577D-1*t199
     #*t335*t265+0.1D1*t217*t55*t17-0.261211729852336D1*t218*t272
     #-0.2333333333333333D1*t93*t162*t17+0.2002623262201243D2*t94*t226
     #-0.181950847499866D2*t224/t12/t388*t17)
      t702 = 0.1270013572118256D0/t4/sigma*t5*t8
      t706 = 0.1600126238299933D0/sigma*t14*t113
      t708 = 0.2540071933667929D0*t29*t543
      t720 = t248**2
      t734 = t262**2
      t743 = t265**2
      v2sigmaaa2(i) = -0.7385587663820224D0*t3*(-t702+t706-t708
     #-0.4300305900017772D0/t388*t17*sigma+0.3292582536357576D0*t237)
     #*t33+0.1477117532764045D1*t243*t249-0.1477117532764045D1*t24
     #*t528*t720+0.7385587663820224D0*t24*t129*(-t702+t706-t708
     #+0.8733640679993569D-4*t29)+16.D0*rho*(0.2473556743557577D-1*
     #(0.5862637881547585D-1*t61*t64*t77-0.5395172183039748D1*t655
     #*t262+0.5395172183039748D1*t434*t734-0.1581497040888031D0*t181
     #*t72*t64)*t200-0.2473556743557577D-1*t743*t335
     #-0.522423459704672D1*t93*t271*t17+0.6823156781244976D1*t94/t12
     #/t284*t17)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:XC_PW91subrend
c:XC_B3LYPsubrstart

c    Generated: Thu Feb 13 08:52:41 GMT 2003

      subroutine uks_xc_b3lyp
     & (ideriv,npt,rhoa1,rhob1,sigmaaa1,sigmabb1,sigmaab1,
     &  zk,vrhoa,vrhob,vsigmaaa,vsigmabb,vsigmaab,
     &  v2rhoa2,v2rhob2,v2rhoab,
     &  v2rhoasigmaaa,v2rhoasigmaab,v2rhoasigmabb,
     &  v2rhobsigmabb,v2rhobsigmaab,v2rhobsigmaaa,
     &  v2sigmaaa2,v2sigmaaaab,v2sigmaaabb,
     &  v2sigmaab2,v2sigmaabbb,v2sigmabb2)
c
c     P.J. Stephens, F.J. Devlin, C.F. Chabalowski, M.J. Frisch
c     Ab initio calculation of vibrational absorption and circular
c     dichroism spectra using density functional force fields
c     J. Phys. Chem. 98 (1994) 11623-11627
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt),rhob1(npt)
      real*8 sigmaaa1(npt),sigmabb1(npt),sigmaab1(npt)
      real*8 zk(npt),vrhoa(npt),vrhob(npt)
      real*8 vsigmaaa(npt),vsigmabb(npt),vsigmaab(npt)
      real*8 v2rhoa2(npt),v2rhob2(npt),v2rhoab(npt)
      real*8 v2rhoasigmaaa(npt),v2rhoasigmaab(npt)
      real*8 v2rhoasigmabb(npt),v2rhobsigmabb(npt)
      real*8 v2rhobsigmaab(npt),v2rhobsigmaaa(npt)
      real*8 v2sigmaaa2(npt),v2sigmaaaab(npt),v2sigmaaabb(npt)
      real*8 v2sigmaab2(npt),v2sigmaabbb(npt),v2sigmabb2(npt)
      parameter(tol=1.0d-20)

      if (ideriv.eq.0) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t5 = 1/t3
      t7 = dsqrt(sigmabb)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t16 = 1/rhob
      t17 = t16**(1.D0/3.D0)
      t19 = t16**(1.D0/6.D0)
      t22 = 1/(0.6203504908994D0*t17+0.1584942278842832D2*t19
     #+0.101578D3)
      t25 = dlog(0.6203504908994D0*t17*t22)
      t31 = datan(0.1171685277708993D1/(0.1575246635799487D1*t19
     #+0.201231D2))
      t35 = (0.7876233178997433D0*t19+0.743294D0)**2
      t37 = dlog(t35*t22)
      zk(i) = -0.74442058907928D0*t3-0.3024D-2*t5*sigmabb/(1.D0
     #+0.252D-1*t8*t9)+0.19D0*rhob*(0.1554535D-1*t25
     #+0.6188180297906063D0*t31+0.2667310007273315D-2*t37)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t5 = 1/t3
      t7 = dsqrt(sigmaaa)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t16 = 1/rhoa
      t17 = t16**(1.D0/3.D0)
      t19 = t16**(1.D0/6.D0)
      t22 = 1/(0.6203504908994D0*t17+0.1584942278842832D2*t19
     #+0.101578D3)
      t25 = dlog(0.6203504908994D0*t17*t22)
      t31 = datan(0.1171685277708993D1/(0.1575246635799487D1*t19
     #+0.201231D2))
      t35 = (0.7876233178997433D0*t19+0.743294D0)**2
      t37 = dlog(t35*t22)
      zk(i) = -0.74442058907928D0*t3-0.3024D-2*t5*sigmaaa/(1.D0
     #+0.252D-1*t8*t9)+0.19D0*rhoa*(0.1554535D-1*t25
     #+0.6188180297906063D0*t31+0.2667310007273315D-2*t37)
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t7 = 1/t5
      t9 = dsqrt(sigmaaa)
      t10 = t9*t7
      t11 = dlog(t10+dsqrt(1+t10**2))
      t18 = rhob**(1.D0/3.D0)
      t19 = t18*rhob
      t21 = 1/t19
      t23 = dsqrt(sigmabb)
      t24 = t23*t21
      t25 = dlog(t24+dsqrt(1+t24**2))
      t32 = rho**(1.D0/3.D0)
      t33 = 1/t32
      t36 = 1/(1.D0+0.349D0*t33)
      t38 = 1/rho
      t39 = rhob*t38
      t42 = 0.2533D0*t33
      t43 = dexp(-t42)
      t45 = rho**2
      t47 = t32**2
      t51 = rhoa**2
      t52 = t4**2
      t55 = rhob**2
      t56 = t18**2
      t60 = t33*t36
      t82 = 0.6666666666666667D0*t45
      t93 = t38**(1.D0/3.D0)
      t94 = 0.6203504908994D0*t93
      t95 = t38**(1.D0/6.D0)
      t98 = 1/(t94+0.1029581201158544D2*t95+0.427198D2)
      t101 = dlog(0.6203504908994D0*t93*t98)
      t103 = 0.1575246635799487D1*t95
      t107 = datan(0.448998886412873D-1/(t103+0.13072D2))
      t109 = 0.7876233178997433D0*t95
      t111 = (t109+0.409286D0)**2
      t113 = dlog(t111*t98)
      t117 = 1/(t94+0.1584942278842832D2*t95+0.101578D3)
      t120 = dlog(0.6203504908994D0*t93*t117)
      t125 = datan(0.1171685277708993D1/(t103+0.201231D2))
      t128 = (t109+0.743294D0)**2
      t130 = dlog(t128*t117)
      t138 = (rhoa-1.D0*rhob)*t38
      t139 = 1.D0+t138
      t140 = t139**(1.D0/3.D0)
      t143 = 1.D0-1.D0*t138
      t144 = t143**(1.D0/3.D0)
      s1 = -0.74442058907928D0*t5-0.3024D-2*t7*sigmaaa/(1.D0+0.252D-1
     #*t10*t11)-0.74442058907928D0*t19
      s2 = s1-0.3024D-2*t21*sigmabb/(1.D0+0.252D-1*t24*t25)
      zk(i) = s2-0.1593432D0*t36*rhoa*t39-0.52583256D-2*t43*t36/t47
     #/t45/rho*(rhoa*rhob*(0.3646239897876478D2*t52*t51
     #+0.3646239897876478D2*t56*t55+(0.2611111111111111D1
     #-0.9850555555555556D-1*t33-0.1357222222222222D0*t60)*sigma-1.D0*
     #(0.25D1-0.1407222222222222D-1*t33-0.1938888888888889D-1*t60)*
     #(sigmaaa+sigmabb)-0.1111111111111111D0*(t42+0.349D0*t60-11.D0)*
     #(rhoa*t38*sigmaaa+t39*sigmabb))-0.6666666666666667D0*t45*sigma+
     #(t82-1.D0*t51)*sigmabb+(t82-1.D0*t55)*sigmaaa)+0.19D0*rho*
     #(0.310907D-1*t101+0.205219729378375D2*t107+0.4431373767749538D-2
     #*t113+0.1923661050931536D1*(0.1554535D-1*t120
     #+0.6188180297906063D0*t125+0.2667310007273315D-2*t130
     #-0.310907D-1*t101-0.205219729378375D2*t107-0.4431373767749538D-2
     #*t113)*(t140*t139+t144*t143-2.D0))
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t5 = 1/t3
      t6 = t5*sigmabb
      t7 = dsqrt(sigmabb)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t12 = 1.D0+0.252D-1*t8*t9
      t13 = 1/t12
      t16 = 1/rhob
      t17 = t16**(1.D0/3.D0)
      t19 = t16**(1.D0/6.D0)
      t21 = 0.6203504908994D0*t17+0.1584942278842832D2*t19+0.101578D3
      t22 = 1/t21
      t25 = dlog(0.6203504908994D0*t17*t22)
      t28 = 0.1575246635799487D1*t19+0.201231D2
      t31 = datan(0.1171685277708993D1/t28)
      t34 = 0.7876233178997433D0*t19+0.743294D0
      t35 = t34**2
      t37 = dlog(t35*t22)
      zk(i) = -0.74442058907928D0*t3-0.3024D-2*t6*t13+0.19D0*rhob*
     #(0.1554535D-1*t25+0.6188180297906063D0*t31+0.2667310007273315D-2
     #*t37)
      vrhoa(i) = 0.D0
      t43 = rhob**2
      t45 = 1/t2/t43
      t49 = t12**2
      t50 = 1/t49
      t55 = t2**2
      t60 = 1/t55/t43
      t63 = dsqrt(1.D0+sigmabb*t60)
      t64 = 1/t63
      t74 = t17**2
      t75 = 1/t74
      t77 = 1/t43
      t80 = t21**2
      t81 = 1/t80
      t85 = t19**2
      t86 = t85**2
      t88 = 1/t86/t19
      t89 = t88*t77
      t91 = -0.2067834969664667D0*t75*t77-0.2641570464738054D1*t89
      t99 = t28**2
      t100 = 1/t99
      vrhob(i) = -0.99256078543904D0*t2+0.4032D-2*t45*sigmabb*t13
     #+0.3024D-2*t6*t50*(-0.336D-1*t7*t45*t9-0.336D-1*sigmabb/t55/t43
     #/rhob*t64)+0.29536165D-2*t25+0.1175754256602152D0*t31
     #+0.5067889013819299D-3*t37+0.19D0*rhob*(0.2505897912236993D-1*(
     #-0.2067834969664667D0*t75*t22*t77-0.6203504908994D0*t17*t81*t91)
     #/t17*t21+0.1903580477513215D0*t100*t88*t77/(1.D0+0.137284639D1
     #*t100)+0.2667310007273315D-2*(-0.2625411059665811D0*t34*t22*t89
     #-1.D0*t35*t81*t91)/t35*t21)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      vsigmabb(i) = -0.3024D-2*t5*t13+0.3024D-2*t6*t50*(0.126D-1/t7*t5
     #*t9+0.126D-1*t60*t64)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t5 = 1/t3
      t6 = t5*sigmaaa
      t7 = dsqrt(sigmaaa)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t12 = 1.D0+0.252D-1*t8*t9
      t13 = 1/t12
      t16 = 1/rhoa
      t17 = t16**(1.D0/3.D0)
      t19 = t16**(1.D0/6.D0)
      t21 = 0.6203504908994D0*t17+0.1584942278842832D2*t19+0.101578D3
      t22 = 1/t21
      t25 = dlog(0.6203504908994D0*t17*t22)
      t28 = 0.1575246635799487D1*t19+0.201231D2
      t31 = datan(0.1171685277708993D1/t28)
      t34 = 0.7876233178997433D0*t19+0.743294D0
      t35 = t34**2
      t37 = dlog(t35*t22)
      zk(i) = -0.74442058907928D0*t3-0.3024D-2*t6*t13+0.19D0*rhoa*
     #(0.1554535D-1*t25+0.6188180297906063D0*t31+0.2667310007273315D-2
     #*t37)
      t43 = rhoa**2
      t45 = 1/t2/t43
      t49 = t12**2
      t50 = 1/t49
      t55 = t2**2
      t60 = 1/t55/t43
      t63 = dsqrt(1.D0+sigmaaa*t60)
      t64 = 1/t63
      t74 = t17**2
      t75 = 1/t74
      t77 = 1/t43
      t80 = t21**2
      t81 = 1/t80
      t85 = t19**2
      t86 = t85**2
      t88 = 1/t86/t19
      t89 = t88*t77
      t91 = -0.2067834969664667D0*t75*t77-0.2641570464738054D1*t89
      t99 = t28**2
      t100 = 1/t99
      vrhoa(i) = -0.99256078543904D0*t2+0.4032D-2*t45*sigmaaa*t13
     #+0.3024D-2*t6*t50*(-0.336D-1*t7*t45*t9-0.336D-1*sigmaaa/t55/t43
     #/rhoa*t64)+0.29536165D-2*t25+0.1175754256602152D0*t31
     #+0.5067889013819299D-3*t37+0.19D0*rhoa*(0.2505897912236993D-1*(
     #-0.2067834969664667D0*t75*t22*t77-0.6203504908994D0*t17*t81*t91)
     #/t17*t21+0.1903580477513215D0*t100*t88*t77/(1.D0+0.137284639D1
     #*t100)+0.2667310007273315D-2*(-0.2625411059665811D0*t34*t22*t89
     #-1.D0*t35*t81*t91)/t35*t21)
      vrhob(i) = 0.D0
      vsigmaaa(i) = -0.3024D-2*t5*t13+0.3024D-2*t6*t50*(0.126D-1/t7*t5
     #*t9+0.126D-1*t60*t64)
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t7 = 1/t5
      t8 = t7*sigmaaa
      t9 = dsqrt(sigmaaa)
      t10 = t9*t7
      t11 = dlog(t10+dsqrt(1+t10**2))
      t14 = 1.D0+0.252D-1*t10*t11
      t15 = 1/t14
      t18 = rhob**(1.D0/3.D0)
      t19 = t18*rhob
      t21 = 1/t19
      t22 = t21*sigmabb
      t23 = dsqrt(sigmabb)
      t24 = t23*t21
      t25 = dlog(t24+dsqrt(1+t24**2))
      t28 = 1.D0+0.252D-1*t24*t25
      t29 = 1/t28
      t32 = rho**(1.D0/3.D0)
      t33 = 1/t32
      t35 = 1.D0+0.349D0*t33
      t36 = 1/t35
      t37 = t36*rhoa
      t38 = 1/rho
      t39 = rhob*t38
      t42 = 0.2533D0*t33
      t43 = dexp(-t42)
      t44 = t43*t36
      t45 = rho**2
      t47 = t32**2
      t49 = 1/t47/t45/rho
      t50 = rhoa*rhob
      t51 = rhoa**2
      t52 = t4**2
      t53 = t52*t51
      t55 = rhob**2
      t56 = t18**2
      t57 = t56*t55
      t60 = t33*t36
      t62 = 0.2611111111111111D1-0.9850555555555556D-1*t33
     #-0.1357222222222222D0*t60
      t67 = sigmaaa+sigmabb
      t71 = t42+0.349D0*t60-11.D0
      t75 = rhoa*t38*sigmaaa+t39*sigmabb
      t78 = 0.3646239897876478D2*t53+0.3646239897876478D2*t57+t62
     #*sigma-1.D0*(0.25D1-0.1407222222222222D-1*t33
     #-0.1938888888888889D-1*t60)*t67-0.1111111111111111D0*t71*t75
      t82 = 0.6666666666666667D0*t45
      t83 = 1.D0*t51
      t86 = 1.D0*t55
      t89 = t50*t78-0.6666666666666667D0*t45*sigma+(t82-t83)*sigmabb+
     #(t82-t86)*sigmaaa
      t93 = t38**(1.D0/3.D0)
      t94 = 0.6203504908994D0*t93
      t95 = t38**(1.D0/6.D0)
      t97 = t94+0.1029581201158544D2*t95+0.427198D2
      t98 = 1/t97
      t101 = dlog(0.6203504908994D0*t93*t98)
      t103 = 0.1575246635799487D1*t95
      t104 = t103+0.13072D2
      t107 = datan(0.448998886412873D-1/t104)
      t109 = 0.7876233178997433D0*t95
      t110 = t109+0.409286D0
      t111 = t110**2
      t113 = dlog(t111*t98)
      t116 = t94+0.1584942278842832D2*t95+0.101578D3
      t117 = 1/t116
      t120 = dlog(0.6203504908994D0*t93*t117)
      t122 = t103+0.201231D2
      t125 = datan(0.1171685277708993D1/t122)
      t127 = t109+0.743294D0
      t128 = t127**2
      t130 = dlog(t128*t117)
      t135 = 0.1554535D-1*t120+0.6188180297906063D0*t125
     #+0.2667310007273315D-2*t130-0.310907D-1*t101-0.205219729378375D2
     #*t107-0.4431373767749538D-2*t113
      t137 = rhoa-1.D0*rhob
      t138 = t137*t38
      t139 = 1.D0+t138
      t140 = t139**(1.D0/3.D0)
      t143 = 1.D0-1.D0*t138
      t144 = t143**(1.D0/3.D0)
      t146 = t140*t139+t144*t143-2.D0
      t147 = t135*t146
      zk(i) = -0.74442058907928D0*t5-0.3024D-2*t8*t15
     #-0.74442058907928D0*t19-0.3024D-2*t22*t29-0.1593432D0*t37*t39
     #-0.52583256D-2*t44*t49*t89+0.19D0*rho*(0.310907D-1*t101
     #+0.205219729378375D2*t107+0.4431373767749538D-2*t113
     #+0.1923661050931536D1*t147)
      t154 = 1/t4/t51
      t158 = t14**2
      t159 = 1/t158
      t167 = 1/t53
      t170 = dsqrt(1.D0+sigmaaa*t167)
      t171 = 1/t170
      t184 = t71*t38
      t195 = rho*t135
      t200 = 0.1333333333333333D1*t140*t38-0.1333333333333333D1*t144*t38
      t203 = t35**2
      t204 = 1/t203
      t210 = 0.185369256D-1*t204*rhoa*rhob/t32/t45
      t211 = 1/t45
      t212 = rhob*t211
      t214 = 0.1593432D0*t37*t212
      t215 = t45**2
      t217 = 1/t215/rho
      t221 = 0.44397795816D-3*t217*t43*t36*t89
      t225 = 0.6117185448D-3*t43*t204*t217*t89
      t230 = 0.192805272D-1*t44/t47/t215*t89
      t232 = 1/t32/rho
      t234 = t232*t36
      t238 = 1/t47/rho*t204
      t273 = 0.52583256D-2*t44*t49*(t50*((0.3283518518518519D-1*t232
     #+0.4524074074074074D-1*t234-0.1578901851851852D-1*t238)*sigma
     #-1.D0*(0.4690740740740741D-2*t232+0.6462962962962963D-2*t234
     #-0.2255574074074074D-2*t238)*t67-0.1111111111111111D0*(
     #-0.8443333333333333D-1*t232-0.1163333333333333D0*t234
     #+0.4060033333333333D-1*t238)*t75-0.1111111111111111D0*t71*(-1.D0
     #*rhoa*t211*sigmaaa-1.D0*t212*sigmabb))-0.1333333333333333D1*rho
     #*sigma+0.1333333333333333D1*rho*sigmabb+0.1333333333333333D1*rho
     #*sigmaaa)
      t274 = 0.5907233D-2*t101
      t275 = 0.3899174858189126D1*t107
      t276 = 0.8419610158724123D-3*t113
      t277 = 0.3654955996769919D0*t147
      t278 = t93**2
      t279 = 1/t278
      t283 = t97**2
      t284 = 1/t283
      t287 = 0.2067834969664667D0*t279*t211
      t288 = t95**2
      t289 = t288**2
      t291 = 1/t289/t95
      t292 = t291*t211
      t294 = -t287-0.1715968668597574D1*t292
      t298 = 1/t93
      t300 = (-0.2067834969664667D0*t279*t98*t211-0.6203504908994D0
     #*t93*t284*t294)*t298*t97
      t302 = t104**2
      t303 = 1/t302
      t309 = t303*t291*t211/(1.D0+0.2016D-2*t303)
      t320 = (-0.2625411059665811D0*t110*t98*t292-1.D0*t111*t284*t294)
     #/t111*t97
      t325 = t116**2
      t326 = 1/t325
      t329 = -t287-0.2641570464738054D1*t292
      t336 = t122**2
      t337 = 1/t336
      t373 = 0.19D0*rho*(0.5011795824473985D-1*t300
     #+0.2419143800947354D0*t309+0.4431373767749538D-2*t320
     #+0.1923661050931536D1*(0.2505897912236993D-1*(
     #-0.2067834969664667D0*t279*t117*t211-0.6203504908994D0*t93*t326
     #*t329)*t298*t116+0.1903580477513215D0*t337*t291*t211/(1.D0
     #+0.137284639D1*t337)+0.2667310007273315D-2*(
     #-0.2625411059665811D0*t127*t117*t292-1.D0*t128*t326*t329)/t128
     #*t116-0.5011795824473985D-1*t300-0.2419143800947354D0*t309
     #-0.4431373767749538D-2*t320)*t146+0.1923661050931536D1*t135*(
     #-0.1333333333333333D1*t140*t137*t211+0.1333333333333333D1*t144
     #*t137*t211))
      vrhoa(i) = -0.99256078543904D0*t4+0.4032D-2*t154*sigmaaa*t15
     #+0.3024D-2*t8*t159*(-0.336D-1*t9*t154*t11-0.336D-1*sigmaaa/t52
     #/t51/rhoa*t171)-0.1593432D0*t36*rhob*t38-0.52583256D-2*t44*t49*
     #(rhob*t78+t50*(0.9723306394337274D2*t52*rhoa
     #-0.1111111111111111D0*t184*sigmaaa)-2.D0*rhoa*sigmabb)
     #+0.3654955996769919D0*t195*t200-t210+t214-t221-t225+t230-t273
     #+t274+t275+t276+t277+t373
      t376 = 1/t18/t55
      t380 = t28**2
      t381 = 1/t380
      t389 = 1/t57
      t392 = dsqrt(1.D0+sigmabb*t389)
      t393 = 1/t392
      vrhob(i) = -0.99256078543904D0*t18+0.4032D-2*t376*sigmabb*t29
     #+0.3024D-2*t22*t381*(-0.336D-1*t23*t376*t25-0.336D-1*sigmabb/t56
     #/t55/rhob*t393)-0.1593432D0*t37*t38-0.52583256D-2*t44*t49*(rhoa
     #*t78+t50*(0.9723306394337274D2*t56*rhob-0.1111111111111111D0
     #*t184*sigmabb)-2.D0*rhob*sigmaaa)-0.3654955996769919D0*t195*t200
     #-t210+t214-t221-t225+t230-t273+t274+t275+t276+t277+t373
      t430 = 0.1407222222222222D-1*t33
      t431 = 0.1938888888888889D-1*t60
      t445 = t44*t49*(t50*t62-0.6666666666666667D0*t45)
      t446 = 0.52583256D-2*t445
      vsigmaaa(i) = -0.3024D-2*t7*t15+0.3024D-2*t8*t159*(0.126D-1/t9
     #*t7*t11+0.126D-1*t167*t171)-0.52583256D-2*t44*t49*(t50*(-0.25D1
     #+t430+t431-0.1111111111111111D0*t71*rhoa*t38)+t82-t86)-t446
      vsigmaab(i) = -0.105166512D-1*t445
      vsigmabb(i) = -0.3024D-2*t21*t29+0.3024D-2*t22*t381*(0.126D-1
     #/t23*t21*t25+0.126D-1*t389*t393)-0.52583256D-2*t44*t49*(t50*(
     #-0.25D1+t430+t431-0.1111111111111111D0*t71*rhob*t38)+t82-t83)-t446
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rhoa = dmax1(0.D0,rhoa1(i))
      rhob = dmax1(0.D0,rhob1(i))
      rho = rhoa+rhob
      if(rho.gt.tol) then
      if(rhoa.lt.tol) then
      rho = rhob
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmabb
      t2 = rhob**(1.D0/3.D0)
      t3 = t2*rhob
      t5 = 1/t3
      t6 = t5*sigmabb
      t7 = dsqrt(sigmabb)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t12 = 1.D0+0.252D-1*t8*t9
      t13 = 1/t12
      t16 = 1/rhob
      t17 = t16**(1.D0/3.D0)
      t19 = t16**(1.D0/6.D0)
      t21 = 0.6203504908994D0*t17+0.1584942278842832D2*t19+0.101578D3
      t22 = 1/t21
      t25 = dlog(0.6203504908994D0*t17*t22)
      t28 = 0.1575246635799487D1*t19+0.201231D2
      t31 = datan(0.1171685277708993D1/t28)
      t34 = 0.7876233178997433D0*t19+0.743294D0
      t35 = t34**2
      t37 = dlog(t35*t22)
      zk(i) = -0.74442058907928D0*t3-0.3024D-2*t6*t13+0.19D0*rhob*
     #(0.1554535D-1*t25+0.6188180297906063D0*t31+0.2667310007273315D-2
     #*t37)
      vrhoa(i) = 0.D0
      t43 = rhob**2
      t45 = 1/t2/t43
      t46 = t45*sigmabb
      t49 = t12**2
      t50 = 1/t49
      t54 = t43*rhob
      t55 = t2**2
      t60 = 1/t55/t43
      t62 = 1.D0+sigmabb*t60
      t63 = dsqrt(t62)
      t64 = 1/t63
      t67 = -0.336D-1*t7*t45*t9-0.336D-1*sigmabb/t55/t54*t64
      t68 = t50*t67
      t74 = t17**2
      t75 = 1/t74
      t76 = t75*t22
      t77 = 1/t43
      t80 = t21**2
      t81 = 1/t80
      t82 = t17*t81
      t85 = t19**2
      t86 = t85**2
      t87 = t86*t19
      t88 = 1/t87
      t89 = t88*t77
      t91 = -0.2067834969664667D0*t75*t77-0.2641570464738054D1*t89
      t94 = -0.2067834969664667D0*t76*t77-0.6203504908994D0*t82*t91
      t95 = 1/t17
      t96 = t94*t95
      t97 = t96*t21
      t99 = t28**2
      t100 = 1/t99
      t101 = t100*t88
      t103 = 1.D0+0.137284639D1*t100
      t104 = 1/t103
      t106 = t101*t77*t104
      t108 = t34*t22
      t111 = t35*t81
      t114 = -0.2625411059665811D0*t108*t89-1.D0*t111*t91
      t115 = 1/t35
      t116 = t114*t115
      t117 = t116*t21
      vrhob(i) = -0.99256078543904D0*t2+0.4032D-2*t46*t13+0.3024D-2*t6
     #*t68+0.29536165D-2*t25+0.1175754256602152D0*t31
     #+0.5067889013819299D-3*t37+0.19D0*rhob*(0.2505897912236993D-1
     #*t97+0.1903580477513215D0*t106+0.2667310007273315D-2*t117)
      vsigmaaa(i) = 0.D0
      vsigmaab(i) = 0.D0
      t130 = 0.126D-1/t7*t5*t9+0.126D-1*t60*t64
      vsigmabb(i) = -0.3024D-2*t5*t13+0.3024D-2*t6*t50*t130
      v2rhoa2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t137 = 1/t2/t54
      t144 = 1/t49/t12
      t145 = t67**2
      t152 = t43**2
      t158 = sigmabb**2
      t164 = 1/t63/t62
      t175 = 1/t74/t16
      t177 = 1/t152
      t178 = t175*t22*t177
      t184 = 1/t54
      t188 = 1/t80/t21
      t190 = t91**2
      t198 = 1/t87/t16
      t199 = t198*t177
      t201 = t88*t184
      t203 = -0.1378556646443111D0*t175*t177+0.4135669939329333D0*t75
     #*t184-0.2201308720615045D1*t199+0.5283140929476108D1*t201
      t221 = t177*t104
      t230 = t99**2
      t234 = t103**2
      s1 = -0.3308535951463467D0/t55-0.9408D-2*t137*sigmabb*t13
     #-0.8064D-2*t46*t68-0.6048D-2*t6*t144*t145
      s2 = s1+0.3024D-2*t6*t50*(0.784D-1*t7*t137*t9+0.168D0*sigmabb
     #/t55/t152*t64-0.448D-1*t158/t2/t152/t54*t164)
     #+0.9522412066500572D-2*t97
      s3 = s2+0.7233605814550218D-1*t106
      s4 = s3
      s5 = 0.101357780276386D-2*t117+0.19D0*rhob*
     #(0.2505897912236993D-1*(-0.1378556646443111D0*t178
     #+0.4135669939329333D0*t75*t81*t77*t91+0.4135669939329333D0*t76
     #*t184+0.12407009817988D1*t17*t188*t190-0.6203504908994D0*t82
     #*t203)*t95*t21+0.8352993040789975D-2*t94/t17/t16*t21*t77
     #+0.2505897912236993D-1*t96*t91+0.9995362477254242D-1/t99/t28
     #*t175*t221+0.1586317064594346D0*t100*t198*t221
     #-0.3807160955026431D0*t101*t184*t104-0.1372209729363994D0/t230
     #/t28*t175*t177/t234+0.2667310007273315D-2*(0.3446391616107778D-1
     #*t178+0.5250822119331622D0*t34*t81*t89*t91-0.2187842549721509D0
     #*t108*t199+0.5250822119331622D0*t108*t201+2.D0*t35*t188*t190
     #-1.D0*t111*t203)*t115*t21+0.7002785192652656D-3*t114/t35/t34*t21
     #*t88*t77+0.2667310007273315D-2*t116*t91)
      v2rhob2(i) = s4+s5
      v2sigmaaa2(i) = 0.D0
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t272 = t130**2
      v2sigmabb2(i) = 0.6048D-2*t5*t50*t130-0.6048D-2*t6*t144*t272
     #+0.3024D-2*t6*t50*(-0.63D-2/t7/sigmabb*t5*t9+0.63D-2/sigmabb*t60
     #*t64-0.63D-2/t2/t152/rhob*t164)
      elseif(rhob.lt.tol) then
      rho = rhoa
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigma = sigmaaa
      t2 = rhoa**(1.D0/3.D0)
      t3 = t2*rhoa
      t5 = 1/t3
      t6 = t5*sigmaaa
      t7 = dsqrt(sigmaaa)
      t8 = t7*t5
      t9 = dlog(t8+dsqrt(1+t8**2))
      t12 = 1.D0+0.252D-1*t8*t9
      t13 = 1/t12
      t16 = 1/rhoa
      t17 = t16**(1.D0/3.D0)
      t19 = t16**(1.D0/6.D0)
      t21 = 0.6203504908994D0*t17+0.1584942278842832D2*t19+0.101578D3
      t22 = 1/t21
      t25 = dlog(0.6203504908994D0*t17*t22)
      t28 = 0.1575246635799487D1*t19+0.201231D2
      t31 = datan(0.1171685277708993D1/t28)
      t34 = 0.7876233178997433D0*t19+0.743294D0
      t35 = t34**2
      t37 = dlog(t35*t22)
      zk(i) = -0.74442058907928D0*t3-0.3024D-2*t6*t13+0.19D0*rhoa*
     #(0.1554535D-1*t25+0.6188180297906063D0*t31+0.2667310007273315D-2
     #*t37)
      t43 = rhoa**2
      t45 = 1/t2/t43
      t46 = t45*sigmaaa
      t49 = t12**2
      t50 = 1/t49
      t54 = t43*rhoa
      t55 = t2**2
      t60 = 1/t55/t43
      t62 = 1.D0+sigmaaa*t60
      t63 = dsqrt(t62)
      t64 = 1/t63
      t67 = -0.336D-1*t7*t45*t9-0.336D-1*sigmaaa/t55/t54*t64
      t68 = t50*t67
      t74 = t17**2
      t75 = 1/t74
      t76 = t75*t22
      t77 = 1/t43
      t80 = t21**2
      t81 = 1/t80
      t82 = t17*t81
      t85 = t19**2
      t86 = t85**2
      t87 = t86*t19
      t88 = 1/t87
      t89 = t88*t77
      t91 = -0.2067834969664667D0*t75*t77-0.2641570464738054D1*t89
      t94 = -0.2067834969664667D0*t76*t77-0.6203504908994D0*t82*t91
      t95 = 1/t17
      t96 = t94*t95
      t97 = t96*t21
      t99 = t28**2
      t100 = 1/t99
      t101 = t100*t88
      t103 = 1.D0+0.137284639D1*t100
      t104 = 1/t103
      t106 = t101*t77*t104
      t108 = t34*t22
      t111 = t35*t81
      t114 = -0.2625411059665811D0*t108*t89-1.D0*t111*t91
      t115 = 1/t35
      t116 = t114*t115
      t117 = t116*t21
      vrhoa(i) = -0.99256078543904D0*t2+0.4032D-2*t46*t13+0.3024D-2*t6
     #*t68+0.29536165D-2*t25+0.1175754256602152D0*t31
     #+0.5067889013819299D-3*t37+0.19D0*rhoa*(0.2505897912236993D-1
     #*t97+0.1903580477513215D0*t106+0.2667310007273315D-2*t117)
      vrhob(i) = 0.D0
      t130 = 0.126D-1/t7*t5*t9+0.126D-1*t60*t64
      vsigmaaa(i) = -0.3024D-2*t5*t13+0.3024D-2*t6*t50*t130
      vsigmaab(i) = 0.D0
      vsigmabb(i) = 0.D0
      t137 = 1/t2/t54
      t144 = 1/t49/t12
      t145 = t67**2
      t152 = t43**2
      t158 = sigmaaa**2
      t164 = 1/t63/t62
      t175 = 1/t74/t16
      t177 = 1/t152
      t178 = t175*t22*t177
      t184 = 1/t54
      t188 = 1/t80/t21
      t190 = t91**2
      t198 = 1/t87/t16
      t199 = t198*t177
      t201 = t88*t184
      t203 = -0.1378556646443111D0*t175*t177+0.4135669939329333D0*t75
     #*t184-0.2201308720615045D1*t199+0.5283140929476108D1*t201
      t221 = t177*t104
      t230 = t99**2
      t234 = t103**2
      s1 = -0.3308535951463467D0/t55-0.9408D-2*t137*sigmaaa*t13
     #-0.8064D-2*t46*t68-0.6048D-2*t6*t144*t145
      s2 = s1+0.3024D-2*t6*t50*(0.784D-1*t7*t137*t9+0.168D0*sigmaaa
     #/t55/t152*t64-0.448D-1*t158/t2/t152/t54*t164)
     #+0.9522412066500572D-2*t97
      s3 = s2+0.7233605814550218D-1*t106
      s4 = s3
      s5 = 0.101357780276386D-2*t117+0.19D0*rhoa*
     #(0.2505897912236993D-1*(-0.1378556646443111D0*t178
     #+0.4135669939329333D0*t75*t81*t77*t91+0.4135669939329333D0*t76
     #*t184+0.12407009817988D1*t17*t188*t190-0.6203504908994D0*t82
     #*t203)*t95*t21+0.8352993040789975D-2*t94/t17/t16*t21*t77
     #+0.2505897912236993D-1*t96*t91+0.9995362477254242D-1/t99/t28
     #*t175*t221+0.1586317064594346D0*t100*t198*t221
     #-0.3807160955026431D0*t101*t184*t104-0.1372209729363994D0/t230
     #/t28*t175*t177/t234+0.2667310007273315D-2*(0.3446391616107778D-1
     #*t178+0.5250822119331622D0*t34*t81*t89*t91-0.2187842549721509D0
     #*t108*t199+0.5250822119331622D0*t108*t201+2.D0*t35*t188*t190
     #-1.D0*t111*t203)*t115*t21+0.7002785192652656D-3*t114/t35/t34*t21
     #*t88*t77+0.2667310007273315D-2*t116*t91)
      v2rhoa2(i) = s4+s5
      v2rhob2(i) = 0.D0
      v2rhoab(i) = 0.D0
      t272 = t130**2
      v2sigmaaa2(i) = 0.6048D-2*t5*t50*t130-0.6048D-2*t6*t144*t272
     #+0.3024D-2*t6*t50*(-0.63D-2/t7/sigmaaa*t5*t9+0.63D-2/sigmaaa*t60
     #*t64-0.63D-2/t2/t152/rhoa*t164)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      v2sigmabb2(i) = 0.D0
      else ! (.not.(rhoa.lt.tol).and..not.(rhob.lt.tol))
      sigmaaa = dmax1(tol,sigmaaa1(i))
      sigmaab = sigmaab1(i)
      sigmabb = dmax1(tol,sigmabb1(i))
      sigma = sigmaaa+sigmabb+2.D0*sigmaab
      t4 = rhoa**(1.D0/3.D0)
      t5 = t4*rhoa
      t7 = 1/t5
      t8 = t7*sigmaaa
      t9 = dsqrt(sigmaaa)
      t10 = t9*t7
      t11 = dlog(t10+dsqrt(1+t10**2))
      t14 = 1.D0+0.252D-1*t10*t11
      t15 = 1/t14
      t18 = rhob**(1.D0/3.D0)
      t19 = t18*rhob
      t21 = 1/t19
      t22 = t21*sigmabb
      t23 = dsqrt(sigmabb)
      t24 = t23*t21
      t25 = dlog(t24+dsqrt(1+t24**2))
      t28 = 1.D0+0.252D-1*t24*t25
      t29 = 1/t28
      t32 = rho**(1.D0/3.D0)
      t33 = 1/t32
      t35 = 1.D0+0.349D0*t33
      t36 = 1/t35
      t37 = t36*rhoa
      t38 = 1/rho
      t39 = rhob*t38
      t42 = 0.2533D0*t33
      t43 = dexp(-t42)
      t44 = t43*t36
      t45 = rho**2
      t46 = t45*rho
      t47 = t32**2
      t49 = 1/t47/t46
      t50 = rhoa*rhob
      t51 = rhoa**2
      t52 = t4**2
      t53 = t52*t51
      t54 = 0.3646239897876478D2*t53
      t55 = rhob**2
      t56 = t18**2
      t57 = t56*t55
      t58 = 0.3646239897876478D2*t57
      t60 = t33*t36
      t62 = 0.2611111111111111D1-0.9850555555555556D-1*t33
     #-0.1357222222222222D0*t60
      t63 = t62*sigma
      t67 = sigmaaa+sigmabb
      t69 = 1.D0*(0.25D1-0.1407222222222222D-1*t33
     #-0.1938888888888889D-1*t60)*t67
      t71 = t42+0.349D0*t60-11.D0
      t75 = rhoa*t38*sigmaaa+t39*sigmabb
      t77 = 0.1111111111111111D0*t71*t75
      t78 = t54+t58+t63-t69-t77
      t82 = 0.6666666666666667D0*t45
      t83 = 1.D0*t51
      t86 = 1.D0*t55
      t89 = t50*t78-0.6666666666666667D0*t45*sigma+(t82-t83)*sigmabb+
     #(t82-t86)*sigmaaa
      t93 = t38**(1.D0/3.D0)
      t94 = 0.6203504908994D0*t93
      t95 = t38**(1.D0/6.D0)
      t97 = t94+0.1029581201158544D2*t95+0.427198D2
      t98 = 1/t97
      t101 = dlog(0.6203504908994D0*t93*t98)
      t103 = 0.1575246635799487D1*t95
      t104 = t103+0.13072D2
      t107 = datan(0.448998886412873D-1/t104)
      t109 = 0.7876233178997433D0*t95
      t110 = t109+0.409286D0
      t111 = t110**2
      t113 = dlog(t111*t98)
      t116 = t94+0.1584942278842832D2*t95+0.101578D3
      t117 = 1/t116
      t120 = dlog(0.6203504908994D0*t93*t117)
      t122 = t103+0.201231D2
      t125 = datan(0.1171685277708993D1/t122)
      t127 = t109+0.743294D0
      t128 = t127**2
      t130 = dlog(t128*t117)
      t135 = 0.1554535D-1*t120+0.6188180297906063D0*t125
     #+0.2667310007273315D-2*t130-0.310907D-1*t101-0.205219729378375D2
     #*t107-0.4431373767749538D-2*t113
      t137 = rhoa-1.D0*rhob
      t138 = t137*t38
      t139 = 1.D0+t138
      t140 = t139**(1.D0/3.D0)
      t143 = 1.D0-1.D0*t138
      t144 = t143**(1.D0/3.D0)
      t146 = t140*t139+t144*t143-2.D0
      t147 = t135*t146
      zk(i) = -0.74442058907928D0*t5-0.3024D-2*t8*t15
     #-0.74442058907928D0*t19-0.3024D-2*t22*t29-0.1593432D0*t37*t39
     #-0.52583256D-2*t44*t49*t89+0.19D0*rho*(0.310907D-1*t101
     #+0.205219729378375D2*t107+0.4431373767749538D-2*t113
     #+0.1923661050931536D1*t147)
      t154 = 1/t4/t51
      t155 = t154*sigmaaa
      t158 = t14**2
      t159 = 1/t158
      t163 = t51*rhoa
      t165 = 1/t52/t163
      t167 = 1/t53
      t169 = 1.D0+sigmaaa*t167
      t170 = dsqrt(t169)
      t171 = 1/t170
      t174 = -0.336D-1*t9*t154*t11-0.336D-1*sigmaaa*t165*t171
      t175 = t159*t174
      t178 = t36*rhob
      t182 = t52*rhoa
      t184 = t71*t38
      t187 = 0.9723306394337274D2*t182-0.1111111111111111D0*t184*sigmaaa
      t191 = rhob*t78+t50*t187-2.D0*rhoa*sigmabb
      t195 = rho*t135
      t200 = 0.1333333333333333D1*t140*t38-0.1333333333333333D1*t144*t38
      t203 = t35**2
      t204 = 1/t203
      t205 = t204*rhoa
      t207 = 1/t32/t45
      t210 = 0.185369256D-1*t205*rhob*t207
      t211 = 1/t45
      t212 = rhob*t211
      t214 = 0.1593432D0*t37*t212
      t215 = t45**2
      t216 = t215*rho
      t217 = 1/t216
      t218 = t217*t43
      t219 = t36*t89
      t221 = 0.44397795816D-3*t218*t219
      t222 = t43*t204
      t225 = 0.6117185448D-3*t222*t217*t89
      t227 = 1/t47/t215
      t230 = 0.192805272D-1*t44*t227*t89
      t232 = 1/t32/rho
      t234 = t232*t36
      t238 = 1/t47/rho*t204
      t240 = 0.3283518518518519D-1*t232+0.4524074074074074D-1*t234
     #-0.1578901851851852D-1*t238
      t251 = -0.8443333333333333D-1*t232-0.1163333333333333D0*t234
     #+0.4060033333333333D-1*t238
      t259 = -1.D0*rhoa*t211*sigmaaa-1.D0*t212*sigmabb
      t262 = t240*sigma-1.D0*(0.4690740740740741D-2*t232
     #+0.6462962962962963D-2*t234-0.2255574074074074D-2*t238)*t67
     #-0.1111111111111111D0*t251*t75-0.1111111111111111D0*t71*t259
      t270 = t50*t262-0.1333333333333333D1*rho*sigma
     #+0.1333333333333333D1*rho*sigmabb+0.1333333333333333D1*rho*sigmaaa
      t273 = 0.52583256D-2*t44*t49*t270
      t274 = 0.5907233D-2*t101
      t275 = 0.3899174858189126D1*t107
      t276 = 0.8419610158724123D-3*t113
      t277 = 0.3654955996769919D0*t147
      t278 = t93**2
      t279 = 1/t278
      t280 = t279*t98
      t283 = t97**2
      t284 = 1/t283
      t285 = t93*t284
      t287 = 0.2067834969664667D0*t279*t211
      t288 = t95**2
      t289 = t288**2
      t290 = t289*t95
      t291 = 1/t290
      t292 = t291*t211
      t294 = -t287-0.1715968668597574D1*t292
      t297 = -0.2067834969664667D0*t280*t211-0.6203504908994D0*t285*t294
      t298 = 1/t93
      t299 = t297*t298
      t300 = t299*t97
      t302 = t104**2
      t303 = 1/t302
      t304 = t303*t291
      t306 = 1.D0+0.2016D-2*t303
      t307 = 1/t306
      t309 = t304*t211*t307
      t311 = t110*t98
      t314 = t111*t284
      t317 = -0.2625411059665811D0*t311*t292-1.D0*t314*t294
      t318 = 1/t111
      t319 = t317*t318
      t320 = t319*t97
      t322 = t279*t117
      t325 = t116**2
      t326 = 1/t325
      t327 = t93*t326
      t329 = -t287-0.2641570464738054D1*t292
      t332 = -0.2067834969664667D0*t322*t211-0.6203504908994D0*t327*t329
      t333 = t332*t298
      t336 = t122**2
      t337 = 1/t336
      t338 = t337*t291
      t340 = 1.D0+0.137284639D1*t337
      t341 = 1/t340
      t345 = t127*t117
      t348 = t128*t326
      t351 = -0.2625411059665811D0*t345*t292-1.D0*t348*t329
      t352 = 1/t128
      t353 = t351*t352
      t359 = 0.2505897912236993D-1*t333*t116+0.1903580477513215D0*t338
     #*t211*t341+0.2667310007273315D-2*t353*t116-0.5011795824473985D-1
     #*t300-0.2419143800947354D0*t309-0.4431373767749538D-2*t320
      t360 = t359*t146
      t362 = t140*t137
      t365 = t144*t137
      t368 = -0.1333333333333333D1*t362*t211+0.1333333333333333D1*t365
     #*t211
      t369 = t135*t368
      t373 = 0.19D0*rho*(0.5011795824473985D-1*t300
     #+0.2419143800947354D0*t309+0.4431373767749538D-2*t320
     #+0.1923661050931536D1*t360+0.1923661050931536D1*t369)
      vrhoa(i) = -0.99256078543904D0*t4+0.4032D-2*t155*t15+0.3024D-2
     #*t8*t175-0.1593432D0*t178*t38-0.52583256D-2*t44*t49*t191
     #+0.3654955996769919D0*t195*t200-t210+t214-t221-t225+t230-t273
     #+t274+t275+t276+t277+t373
      t376 = 1/t18/t55
      t377 = t376*sigmabb
      t380 = t28**2
      t381 = 1/t380
      t385 = t55*rhob
      t387 = 1/t56/t385
      t389 = 1/t57
      t391 = 1.D0+sigmabb*t389
      t392 = dsqrt(t391)
      t393 = 1/t392
      t396 = -0.336D-1*t23*t376*t25-0.336D-1*sigmabb*t387*t393
      t397 = t381*t396
      t403 = t56*rhob
      t407 = 0.9723306394337274D2*t403-0.1111111111111111D0*t184*sigmabb
      t411 = rhoa*t78+t50*t407-2.D0*rhob*sigmaaa
      t415 = -t200
      vrhob(i) = -0.99256078543904D0*t18+0.4032D-2*t377*t29+0.3024D-2
     #*t22*t397-0.1593432D0*t37*t38-0.52583256D-2*t44*t49*t411
     #+0.3654955996769919D0*t195*t415-t210+t214-t221-t225+t230-t273
     #+t274+t275+t276+t277+t373
      t420 = 1/t9
      t426 = 0.126D-1*t420*t7*t11+0.126D-1*t167*t171
      t427 = t159*t426
      t430 = 0.1407222222222222D-1*t33
      t431 = 0.1938888888888889D-1*t60
      t432 = t71*rhoa
      t435 = -0.25D1+t430+t431-0.1111111111111111D0*t432*t38
      t437 = t50*t435+t82-t86
      t443 = t50*t62-0.6666666666666667D0*t45
      t445 = t44*t49*t443
      t446 = 0.52583256D-2*t445
      vsigmaaa(i) = -0.3024D-2*t7*t15+0.3024D-2*t8*t427-0.52583256D-2
     #*t44*t49*t437-t446
      vsigmaab(i) = -0.105166512D-1*t445
      t450 = 1/t23
      t456 = 0.126D-1*t450*t21*t25+0.126D-1*t389*t393
      t457 = t381*t456
      t460 = t71*rhob
      t463 = -0.25D1+t430+t431-0.1111111111111111D0*t460*t38
      t465 = t50*t463+t82-t83
      vsigmabb(i) = -0.3024D-2*t21*t29+0.3024D-2*t22*t457
     #-0.52583256D-2*t44*t49*t465-t446
      t469 = 0.9192746443599945D-1*t309
      t470 = 0.1904482413300114D-1*t300
      t471 = 0.1683922031744825D-2*t320
      t472 = 0.7309911993539838D0*t360
      t473 = 0.7309911993539838D0*t369
      t478 = 0.899757936D-1*t44/t47/t216*t89
      t483 = 0.61789752D-1*t205*rhob/t32/t46
      t484 = t215*t45
      t485 = 1/t484
      t488 = 0.53015607216D-2*t222*t485*t89
      t490 = 1/t32/t484
      t491 = t490*t43
      t494 = 0.10329887159856D-3*t491*t204*t89
      t497 = 0.385610544D-1*t44*t227*t270
      t500 = 0.12234370896D-2*t222*t217*t270
      t501 = 1/t46
      t502 = rhob*t501
      t503 = t37*t502
      t504 = 0.3186864D0*t503
      t506 = t207*t36
      t510 = 1/t47/t45*t204
      t513 = 1/t203/t35
      t514 = t501*t513
      t549 = t44*t49*(t50*((-0.4378024691358025D-1*t207
     #-0.6032098765432099D-1*t506+0.3157803703703704D-1*t510
     #-0.3673578308641975D-2*t514)*sigma-1.D0*(-0.6254320987654321D-2
     #*t207-0.8617283950617284D-2*t506+0.4511148148148148D-2*t510
     #-0.5247969012345679D-3*t514)*t67-0.1111111111111111D0*
     #(0.1125777777777778D0*t207+0.1551111111111111D0*t506
     #-0.8120066666666667D-1*t510+0.9446344222222222D-2*t514)*t75
     #-0.2222222222222222D0*t251*t259-0.1111111111111111D0*t71*(2.D0
     #*rhoa*t501*sigmaaa+2.D0*t502*sigmabb))-0.1333333333333333D1
     #*sigma+0.1333333333333333D1*sigmabb+0.1333333333333333D1*sigmaaa)
      t550 = 0.52583256D-2*t549
      t553 = 0.88795591632D-3*t218*t36*t270
      t555 = 0.37486538933976D-4*t491*t219
      t559 = 1/t158/t14
      t560 = t174**2
      t565 = 1/t4/t163
      t569 = t51**2
      t575 = sigmaaa**2
      t581 = 1/t170/t169
      t588 = t469+t470+t471+t472+t473-t478+t483+t488-t494+t497-t500
     #-t504-t550-t553-t555-0.8064D-2*t155*t175-0.6048D-2*t8*t559*t560
     #+0.3024D-2*t8*t159*(0.784D-1*t9*t565*t11+0.168D0*sigmaaa/t52
     #/t569*t171-0.448D-1*t575/t4/t569/t163*t581)
      t589 = rho*t359
      t590 = t589*t200
      t593 = 1/t278/t38
      t595 = 1/t215
      t596 = t593*t98*t595
      t605 = 1/t283/t97
      t607 = t294**2
      t611 = 0.1378556646443111D0*t593*t595
      t613 = 0.4135669939329333D0*t279*t501
      t615 = 1/t290/t38
      t616 = t615*t595
      t618 = t291*t501
      t620 = -t611+t613-0.1429973890497978D1*t616+0.3431937337195148D1
     #*t618
      t625 = (-0.1378556646443111D0*t596+0.4135669939329333D0*t279
     #*t284*t211*t294+0.4135669939329333D0*t280*t501
     #+0.12407009817988D1*t93*t605*t607-0.6203504908994D0*t285*t620)
     #*t298*t97
      t628 = 1/t93/t38
      t631 = t297*t628*t97*t211
      t633 = t299*t294
      t638 = t595*t307
      t639 = 1/t302/t104*t593*t638
      t642 = t303*t615*t638
      t645 = t304*t501*t307
      t647 = t302**2
      t651 = t306**2
      t654 = 1/t647/t104*t593*t595/t651
      t672 = (0.3446391616107778D-1*t596+0.5250822119331622D0*t110
     #*t284*t292*t294-0.2187842549721509D0*t311*t616
     #+0.5250822119331622D0*t311*t618+2.D0*t111*t605*t607-1.D0*t314
     #*t620)*t318*t97
      t679 = t317/t111/t110*t97*t291*t211
      t681 = t319*t294
      t684 = t593*t117*t595
      t693 = 1/t325/t116
      t695 = t329**2
      t700 = -t611+t613-0.2201308720615045D1*t616+0.5283140929476108D1
     #*t618
      t716 = t595*t341
      t725 = t336**2
      t729 = t340**2
      s1 = 0.2505897912236993D-1*(-0.1378556646443111D0*t684
     #+0.4135669939329333D0*t279*t326*t211*t329+0.4135669939329333D0
     #*t322*t501+0.12407009817988D1*t93*t693*t695-0.6203504908994D0
     #*t327*t700)*t298*t116+0.8352993040789975D-2*t332*t628*t116*t211
     #+0.2505897912236993D-1*t333*t329+0.9995362477254242D-1/t336/t122
     #*t593*t716+0.1586317064594346D0*t337*t615*t716
     #-0.3807160955026431D0*t338*t501*t341-0.1372209729363994D0/t725
     #/t122*t593*t595/t729+0.2667310007273315D-2*
     #(0.3446391616107778D-1*t684+0.5250822119331622D0*t127*t326*t292
     #*t329-0.2187842549721509D0*t345*t616+0.5250822119331622D0*t345
     #*t618+2.D0*t128*t693*t695-1.D0*t348*t700)*t352*t116
     #+0.7002785192652656D-3*t351/t128/t127*t116*t291*t211
     #+0.2667310007273315D-2*t353*t329
      t771 = s1-0.5011795824473985D-1*t625-0.1670598608157995D-1*t631
     #-0.5011795824473985D-1*t633-0.1270249377985834D0*t639
     #-0.2015953167456128D0*t642+0.4838287601894708D0*t645
     #+0.2560822746019441D-3*t654-0.4431373767749538D-2*t672
     #-0.1163417769936259D-2*t679-0.4431373767749538D-2*t681
      t776 = t140**2
      t777 = 1/t776
      t778 = t137**2
      t784 = t144**2
      t785 = 1/t784
      t794 = 0.5011795824473985D-1*t625+0.1670598608157995D-1*t631
     #+0.5011795824473985D-1*t633+0.1270249377985834D0*t639
     #+0.2015953167456128D0*t642-0.4838287601894708D0*t645
     #-0.2560822746019441D-3*t654+0.4431373767749538D-2*t672
     #+0.1163417769936259D-2*t679+0.4431373767749538D-2*t681
     #+0.1923661050931536D1*t771*t146+0.3847322101863073D1*t359*t368
     #+0.1923661050931536D1*t135*(0.4444444444444444D0*t777*t778*t595
     #+0.2666666666666667D1*t362*t501+0.4444444444444444D0*t785*t778
     #*t595-0.2666666666666667D1*t365*t501)
      t795 = rho*t794
      t796 = 0.19D0*t795
      t814 = -0.4444444444444444D0*t777*t137*t501-0.1333333333333333D1
     #*t140*t211-0.4444444444444444D0*t785*t137*t501
     #+0.1333333333333333D1*t144*t211
      t818 = rho*(0.1923661050931536D1*t359*t200+0.1923661050931536D1
     #*t135*t814)
      t823 = 0.1423265147568D-3*t43*t513*t490*t89
      t835 = 0.384780897072D-2*t485*t43*t219
      t837 = t218*t36*t191
      t840 = t222*t217*t191
      t843 = t44*t227*t191
      t846 = t251*t38
      t849 = t71*t211
      t856 = t44*t49*(rhob*t262+t50*(-0.1111111111111111D0*t846
     #*sigmaaa+0.1111111111111111D0*t849*sigmaaa))
      t859 = rhob*t49
      t861 = 0.43129246896D-2*t513*rhoa*t859
      t862 = t135*t200
      t868 = 0.4444444444444444D0*t777*t211+0.4444444444444444D0*t785
     #*t211
      t870 = 0.3654955996769919D0*t195*t868
      t872 = t204*rhob*t207
      t874 = t178*t211
      t876 = t195*t814
      t878 = 0.3654955996769919D0*t590+t796-0.9408D-2*t565*sigmaaa*t15
     #-0.3308535951463467D0/t52+0.19D0*t818-t823-0.52583256D-2*t44*t49
     #*(2.D0*rhob*t187+0.1620551065722879D3*t182*rhob-2.D0*sigmabb)
     #+t835-0.88795591632D-3*t837-0.12234370896D-2*t840+0.385610544D-1
     #*t843-0.105166512D-1*t856-t861+0.7309911993539838D0*t862+t870
     #-0.370738512D-1*t872+0.3186864D0*t874+0.3654955996769919D0*t876
      v2rhoa2(i) = t588+t878
      t879 = t135*t415
      t884 = 1/t380/t28
      t885 = t396**2
      t890 = 1/t18/t385
      t894 = t55**2
      t900 = sigmabb**2
      t906 = 1/t392/t391
      t923 = t218*t36*t411
      t926 = t222*t217*t411
      t929 = t44*t227*t411
      t940 = t44*t49*(rhoa*t262+t50*(-0.1111111111111111D0*t846
     #*sigmabb+0.1111111111111111D0*t849*sigmabb))
      t942 = t469+t470+t471+t472+t473+0.7309911993539838D0*t879
     #-0.8064D-2*t377*t397-0.6048D-2*t22*t884*t885+0.3024D-2*t22*t381*
     #(0.784D-1*t23*t890*t25+0.168D0*sigmabb/t56/t894*t393-0.448D-1
     #*t900/t18/t894/t385*t906)-0.52583256D-2*t44*t49*(2.D0*rhoa*t407
     #+0.1620551065722879D3*rhoa*t403-2.D0*sigmaaa)-0.88795591632D-3
     #*t923-0.12234370896D-2*t926+0.385610544D-1*t929-0.105166512D-1
     #*t940-t478+t483+t488-t494
      t950 = -t814
      t954 = rho*(0.1923661050931536D1*t359*t415+0.1923661050931536D1
     #*t135*t950)
      t956 = t205*t207
      t958 = t37*t211
      t960 = t195*t950
      t962 = t589*t415
      t964 = t497-t500-t504-t550-t553-t555-0.9408D-2*t890*sigmabb*t29
     #-0.3308535951463467D0/t56+0.19D0*t954-0.370738512D-1*t956
     #+0.3186864D0*t958+0.3654955996769919D0*t960+0.3654955996769919D0
     #*t962+t796-t823+t835-t861+t870
      v2rhob2(i) = t942+t964
      t974 = -t478+t483+t488-t494+t497-t500-0.3186864D0*t503
     #-0.52583256D-2*t549-t553-t555+0.182747799838496D0*t590
      t1003 = -0.6117185448D-3*t840+0.192805272D-1*t843-0.52583256D-2
     #*t856-t861+0.3654955996769919D0*t862-0.185369256D-1*t872
     #+0.1593432D0*t874+0.182747799838496D0*t876-0.52583256D-2*t44*t49
     #*(t54+t58+t63-t69-t77+rhob*t407+rhoa*t187)-0.1593432D0*t36*t38
     #-0.3654955996769919D0*t195*t868
      v2rhoab(i) = t469+t470+t471+t472+t473+0.3654955996769919D0*t879
     #-0.44397795816D-3*t923-0.6117185448D-3*t926+0.192805272D-1*t929
     #-0.52583256D-2*t940+t974+0.95D-1*t954-0.185369256D-1*t956
     #+0.1593432D0*t958+0.182747799838496D0*t960+0.182747799838496D0
     #*t962+0.19D0*t795+0.95D-1*t818-t823+t835-0.44397795816D-3*t837
     #+t1003
      t1009 = t7*t159
      t1033 = 0.1111111111111111D0*t50*t184
      t1040 = 0.44397795816D-3*t218*t36*t437
      t1043 = 0.6117185448D-3*t222*t217*t437
      t1046 = 0.192805272D-1*t44*t227*t437
      t1047 = 0.4690740740740741D-2*t232
      t1048 = 0.6462962962962963D-2*t234
      t1049 = 0.2255574074074074D-2*t238
      t1057 = 0.1333333333333333D1*rho
      t1061 = 0.52583256D-2*t44*t49*(t50*(-t1047-t1048+t1049
     #-0.1111111111111111D0*t251*rhoa*t38+0.1111111111111111D0*t432
     #*t211)+t1057)
      t1063 = t44*t859*t62
      t1064 = 0.52583256D-2*t1063
      t1066 = t218*t36*t443
      t1067 = 0.44397795816D-3*t1066
      t1069 = t222*t217*t443
      t1070 = 0.6117185448D-3*t1069
      t1072 = t44*t227*t443
      t1073 = 0.192805272D-1*t1072
      t1078 = t44*t49*(t50*t240-0.1333333333333333D1*rho)
      t1079 = 0.52583256D-2*t1078
      v2rhoasigmaaa(i) = 0.4032D-2*t154*t15-0.4032D-2*t155*t427
     #+0.3024D-2*t1009*t174-0.6048D-2*t8*t559*t174*t426+0.3024D-2*t8
     #*t159*(-0.168D-1*t420*t154*t11-0.504D-1*t165*t171+0.168D-1
     #*sigmaaa/t4/t569/t51*t581)-0.52583256D-2*t44*t49*(rhob*t435
     #-t1033)-t1040-t1043+t1046-t1061-t1064-t1067-t1070+t1073-t1079
      t1081 = 0.88795591632D-3*t1066
      t1082 = 0.12234370896D-2*t1069
      t1083 = 0.385610544D-1*t1072
      t1084 = 0.105166512D-1*t1078
      v2rhoasigmaab(i) = -0.105166512D-1*t1063-t1081-t1082+t1083-t1084
      t1093 = 0.44397795816D-3*t218*t36*t465
      t1096 = 0.6117185448D-3*t222*t217*t465
      t1099 = 0.192805272D-1*t44*t227*t465
      t1110 = 0.52583256D-2*t44*t49*(t50*(-t1047-t1048+t1049
     #-0.1111111111111111D0*t251*rhob*t38+0.1111111111111111D0*t460
     #*t211)+t1057)
      v2rhoasigmabb(i) = -0.52583256D-2*t44*t49*(rhob*t463-2.D0*rhoa)
     #-t1093-t1096+t1099-t1110-t1064-t1067-t1070+t1073-t1079
      t1119 = t44*t49*rhoa*t62
      t1120 = 0.52583256D-2*t1119
      v2rhobsigmaaa(i) = -0.52583256D-2*t44*t49*(rhoa*t435-2.D0*rhob)
     #-t1040-t1043+t1046-t1061-t1120-t1067-t1070+t1073-t1079
      v2rhobsigmaab(i) = -0.105166512D-1*t1119-t1081-t1082+t1083-t1084
      t1126 = t21*t381
      v2rhobsigmabb(i) = 0.4032D-2*t376*t29-0.4032D-2*t377*t457
     #+0.3024D-2*t1126*t396-0.6048D-2*t22*t884*t396*t456+0.3024D-2*t22
     #*t381*(-0.168D-1*t450*t376*t25-0.504D-1*t387*t393+0.168D-1
     #*sigmabb/t18/t894/t55*t906)-0.52583256D-2*t44*t49*(rhoa*t463
     #-t1033)-t1093-t1096+t1099-t1110-t1120-t1067-t1070+t1073-t1079
      t1155 = t426**2
      v2sigmaaa2(i) = 0.6048D-2*t1009*t426-0.6048D-2*t8*t559*t1155
     #+0.3024D-2*t8*t159*(-0.63D-2/t9/sigmaaa*t7*t11+0.63D-2/sigmaaa
     #*t167*t171-0.63D-2/t4/t569/rhoa*t581)
      v2sigmaaaab(i) = 0.D0
      v2sigmaaabb(i) = 0.D0
      v2sigmaab2(i) = 0.D0
      v2sigmaabbb(i) = 0.D0
      t1179 = t456**2
      v2sigmabb2(i) = 0.6048D-2*t1126*t456-0.6048D-2*t22*t884*t1179
     #+0.3024D-2*t22*t381*(-0.63D-2/t23/sigmabb*t21*t25+0.63D-2
     #/sigmabb*t389*t393-0.63D-2/t18/t894/rhob*t906)
      endif ! rhoa,rhob
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vrhob(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      v2rhob2(i) = 0.0d0
      v2rhoab(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      vsigmaab(i) = 0.0d0
      vsigmabb(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2rhoasigmaab(i) = 0.0d0
      v2rhoasigmabb(i) = 0.0d0
      v2rhobsigmaaa(i) = 0.0d0
      v2rhobsigmaab(i) = 0.0d0
      v2rhobsigmabb(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      v2sigmaab2(i) = 0.0d0
      v2sigmabb2(i) = 0.0d0
      v2sigmaaaab(i) = 0.0d0
      v2sigmaaabb(i) = 0.0d0
      v2sigmaabbb(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end


      subroutine rks_xc_b3lyp
     & (ideriv,npt,rhoa1,sigmaaa1,
     &  zk,vrhoa,vsigmaaa,
     &  v2rhoa2,v2rhoasigmaaa,v2sigmaaa2)
c
c     P.J. Stephens, F.J. Devlin, C.F. Chabalowski, M.J. Frisch
c     Ab initio calculation of vibrational absorption and circular
c     dichroism spectra using density functional force fields
c     J. Phys. Chem. 98 (1994) 11623-11627
c
c
c     CITATION:
c
c     Functionals were obtained from the Density Functional Repository
c     as developed and distributed by the Quantum Chemistry Group,
c     CCLRC Daresbury Laboratory, Daresbury, Cheshire, WA4 4AD
c     United Kingdom. Contact Huub van Dam (h.j.j.vandam@dl.ac.uk) or
c     Paul Sherwood for further information.
c
c     COPYRIGHT:
c
c     Users may incorporate the source code into software packages and
c     redistribute the source code provided the source code is not
c     changed in anyway and is properly cited in any documentation or
c     publication related to its use.
c
c     ACKNOWLEDGEMENT:
c
c     The source code was generated using Maple 8 through a modified
c     version of the dfauto script published in:
c
c        R. Strange, F.R. Manby, P.J. Knowles
c        Automatic code generation in density functional theory
c        Comp. Phys. Comm. 136 (2001) 310-318.
c
      implicit real*8 (a-h,o-z)
      integer ideriv,npt,i
      real*8 rhoa1(npt)
      real*8 sigmaaa1(npt)
      real*8 zk(npt),vrhoa(npt),vsigmaaa(npt)
      real*8 v2rhoa2(npt),v2rhoasigmaaa(npt),v2sigmaaa2(npt)
      parameter(tol=1.0d-20)

      if(ideriv.eq.0) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t5 = 1/t3
      t7 = dsqrt(sigma)
      t8 = t7*t5
      t10 = dlog(0.1259921049894873D1*t8+dsqrt(1+0.1587401051968199D1
     #*t8**2))
      t17 = 1/t2
      t20 = 1/(1.D0+0.349D0*t17)
      t23 = 0.2533D0*t17
      t24 = dexp(-t23)
      t26 = rho**2
      t28 = t2**2
      t34 = t17*t20
      t56 = 1/rho
      t57 = t56**(1.D0/3.D0)
      t59 = t56**(1.D0/6.D0)
      t62 = 1/(0.6203504908994D0*t57+0.1029581201158544D2*t59
     #+0.427198D2)
      t65 = dlog(0.6203504908994D0*t57*t62)
      t71 = datan(0.448998886412873D-1/(0.1575246635799487D1*t59
     #+0.13072D2))
      t75 = (0.7876233178997433D0*t59+0.409286D0)**2
      t77 = dlog(t75*t62)
      zk(i) = -0.5908470131056179D0*t3-0.3810001254882096D-2*t5*sigma/
     #(1.D0+0.317500104573508D-1*t8*t10)-0.398358D-1*t20*rho
     #-0.52583256D-2*t24*t20/t28/t26/rho*(0.25D0*t26*
     #(0.1148493600075277D2*t28*t26+(0.2611111111111111D1
     #-0.9850555555555556D-1*t17-0.1357222222222222D0*t34)*sigma-0.5D0
     #*(0.25D1-0.1407222222222222D-1*t17-0.1938888888888889D-1*t34)
     #*sigma-0.2777777777777778D-1*(t23+0.349D0*t34-11.D0)*sigma)
     #-0.4583333333333333D0*t26*sigma)+0.19D0*rho*(0.310907D-1*t65
     #+0.205219729378375D2*t71+0.4431373767749538D-2*t77)
      else ! rho
      zk(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.1) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t5 = 1/t3
      t6 = t5*sigma
      t7 = dsqrt(sigma)
      t8 = t7*t5
      t10 = dlog(0.1259921049894873D1*t8+dsqrt(1+0.1587401051968199D1
     #*t8**2))
      t13 = 1.D0+0.317500104573508D-1*t8*t10
      t14 = 1/t13
      t17 = 1/t2
      t19 = 1.D0+0.349D0*t17
      t20 = 1/t19
      t23 = 0.2533D0*t17
      t24 = dexp(-t23)
      t25 = t24*t20
      t26 = rho**2
      t28 = t2**2
      t30 = 1/t28/t26/rho
      t31 = t28*t26
      t34 = t17*t20
      t36 = 0.2611111111111111D1-0.9850555555555556D-1*t17
     #-0.1357222222222222D0*t34
      t44 = t23+0.349D0*t34-11.D0
      t47 = 0.1148493600075277D2*t31+t36*sigma-0.5D0*(0.25D1
     #-0.1407222222222222D-1*t17-0.1938888888888889D-1*t34)*sigma
     #-0.2777777777777778D-1*t44*sigma
      t52 = 0.25D0*t26*t47-0.4583333333333333D0*t26*sigma
      t56 = 1/rho
      t57 = t56**(1.D0/3.D0)
      t59 = t56**(1.D0/6.D0)
      t61 = 0.6203504908994D0*t57+0.1029581201158544D2*t59+0.427198D2
      t62 = 1/t61
      t65 = dlog(0.6203504908994D0*t57*t62)
      t68 = 0.1575246635799487D1*t59+0.13072D2
      t71 = datan(0.448998886412873D-1/t68)
      t74 = 0.7876233178997433D0*t59+0.409286D0
      t75 = t74**2
      t77 = dlog(t75*t62)
      zk(i) = -0.5908470131056179D0*t3-0.3810001254882096D-2*t6*t14
     #-0.398358D-1*t20*rho-0.52583256D-2*t25*t30*t52+0.19D0*rho*
     #(0.310907D-1*t65+0.205219729378375D2*t71+0.4431373767749538D-2
     #*t77)
      t84 = 1/t2/t26
      t88 = t13**2
      t89 = 1/t88
      t94 = 1/t31
      t98 = dsqrt(1.D0+0.1587401051968199D1*sigma*t94)
      t99 = 1/t98
      t109 = t28*rho
      t112 = t44*t56*sigma
      t117 = rho*sigma
      t123 = t19**2
      t124 = 1/t123
      t127 = t26**2
      t129 = 1/t127/rho
      t144 = t5*t20
      t146 = 1/t109
      t147 = t146*t124
      t175 = t57**2
      t176 = 1/t175
      t178 = 1/t26
      t181 = t61**2
      t182 = 1/t181
      t186 = t59**2
      t187 = t186**2
      t189 = 1/t187/t59
      t190 = t189*t178
      t192 = -0.2067834969664667D0*t176*t178-0.1715968668597574D1*t190
      t200 = t68**2
      t201 = 1/t200
      s1 = -0.7877960174741572D0*t2+0.5080001673176129D-2*t84*sigma
     #*t14+0.1905000627441048D-2*t6*t89*(-0.8466669455293548D-1*t7*t84
     #*t10-0.106673350692263D0*sigma*t30*t99)-0.398358D-1*t20
     #-0.52583256D-2*t25*t30*(0.5D0*rho*t47+0.25D0*t26*
     #(0.3062649600200738D2*t109-0.2777777777777778D-1*t112)-0.25D0
     #*t117)-0.46342314D-2*t124*t17-0.44397795816D-3*t129*t24*t20*t52
      s2 = s1-0.6117185448D-3*t24*t124*t129*t52+0.192805272D-1*t25/t28
     #/t127*t52-0.52583256D-2*t25*t30*(0.25D0*t26*(
     #(0.3283518518518519D-1*t5+0.4524074074074074D-1*t144
     #-0.1578901851851852D-1*t147)*sigma-0.5D0*(0.4690740740740741D-2
     #*t5+0.6462962962962963D-2*t144-0.2255574074074074D-2*t147)*sigma
     #-0.2777777777777778D-1*(-0.8443333333333333D-1*t5
     #-0.1163333333333333D0*t144+0.4060033333333333D-1*t147)*sigma
     #+0.2777777777777778D-1*t112)-0.6666666666666667D0*t117)
      vrhoa(i) = s2+0.5907233D-2*t65+0.3899174858189126D1*t71
     #+0.8419610158724123D-3*t77+0.19D0*rho*(0.5011795824473985D-1*(
     #-0.2067834969664667D0*t176*t62*t178-0.6203504908994D0*t57*t182
     #*t192)/t57*t61+0.2419143800947354D0*t201*t189*t178/(1.D0
     #+0.2016D-2*t201)+0.4431373767749538D-2*(-0.2625411059665811D0
     #*t74*t62*t190-1.D0*t75*t182*t192)/t75*t61)
      vsigmaaa(i) = -0.1524000501952839D-1*t5*t14
     #+0.3810001254882096D-2*t6*t89*(0.6350002091470161D-1/t7*t5*t10
     #+0.8000501301919725D-1*t94*t99)+0.5842584D-3*t25*t146
     #-0.210333024D-1*t25*t30*(0.25D0*t26*t36-0.6666666666666667D0*t26)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      endif ! rho
      enddo

      else if(ideriv.eq.2) then

      do i=1,npt
      rho = dmax1(0.D0,rhoa1(i))
      if(rho.gt.tol) then
      sigma = dmax1(tol,sigmaaa1(i))
      t2 = rho**(1.D0/3.D0)
      t3 = t2*rho
      t5 = 1/t3
      t6 = t5*sigma
      t7 = dsqrt(sigma)
      t8 = t7*t5
      t10 = dlog(0.1259921049894873D1*t8+dsqrt(1+0.1587401051968199D1
     #*t8**2))
      t13 = 1.D0+0.317500104573508D-1*t8*t10
      t14 = 1/t13
      t17 = 1/t2
      t19 = 1.D0+0.349D0*t17
      t20 = 1/t19
      t23 = 0.2533D0*t17
      t24 = dexp(-t23)
      t25 = t24*t20
      t26 = rho**2
      t27 = t26*rho
      t28 = t2**2
      t30 = 1/t28/t27
      t31 = t28*t26
      t32 = 0.1148493600075277D2*t31
      t34 = t17*t20
      t36 = 0.2611111111111111D1-0.9850555555555556D-1*t17
     #-0.1357222222222222D0*t34
      t37 = t36*sigma
      t42 = 0.5D0*(0.25D1-0.1407222222222222D-1*t17
     #-0.1938888888888889D-1*t34)*sigma
      t44 = t23+0.349D0*t34-11.D0
      t46 = 0.2777777777777778D-1*t44*sigma
      t47 = t32+t37-t42-t46
      t52 = 0.25D0*t26*t47-0.4583333333333333D0*t26*sigma
      t56 = 1/rho
      t57 = t56**(1.D0/3.D0)
      t59 = t56**(1.D0/6.D0)
      t61 = 0.6203504908994D0*t57+0.1029581201158544D2*t59+0.427198D2
      t62 = 1/t61
      t65 = dlog(0.6203504908994D0*t57*t62)
      t68 = 0.1575246635799487D1*t59+0.13072D2
      t71 = datan(0.448998886412873D-1/t68)
      t74 = 0.7876233178997433D0*t59+0.409286D0
      t75 = t74**2
      t77 = dlog(t75*t62)
      zk(i) = -0.5908470131056179D0*t3-0.3810001254882096D-2*t6*t14
     #-0.398358D-1*t20*rho-0.52583256D-2*t25*t30*t52+0.19D0*rho*
     #(0.310907D-1*t65+0.205219729378375D2*t71+0.4431373767749538D-2
     #*t77)
      t84 = 1/t2/t26
      t85 = t84*sigma
      t88 = t13**2
      t89 = 1/t88
      t94 = 1/t31
      t97 = 1.D0+0.1587401051968199D1*sigma*t94
      t98 = dsqrt(t97)
      t99 = 1/t98
      t102 = -0.8466669455293548D-1*t7*t84*t10-0.106673350692263D0
     #*sigma*t30*t99
      t103 = t89*t102
      t109 = t28*rho
      t111 = t44*t56
      t112 = t111*sigma
      t114 = 0.3062649600200738D2*t109-0.2777777777777778D-1*t112
      t117 = rho*sigma
      t119 = 0.5D0*rho*t47+0.25D0*t26*t114-0.25D0*t117
      t123 = t19**2
      t124 = 1/t123
      t127 = t26**2
      t128 = t127*rho
      t129 = 1/t128
      t130 = t129*t24
      t131 = t20*t52
      t134 = t24*t124
      t139 = 1/t28/t127
      t144 = t5*t20
      t146 = 1/t109
      t147 = t146*t124
      t149 = 0.3283518518518519D-1*t5+0.4524074074074074D-1*t144
     #-0.1578901851851852D-1*t147
      t160 = -0.8443333333333333D-1*t5-0.1163333333333333D0*t144
     #+0.4060033333333333D-1*t147
      t164 = t149*sigma-0.5D0*(0.4690740740740741D-2*t5
     #+0.6462962962962963D-2*t144-0.2255574074074074D-2*t147)*sigma
     #-0.2777777777777778D-1*t160*sigma+0.2777777777777778D-1*t112
      t168 = 0.25D0*t26*t164-0.6666666666666667D0*t117
      t175 = t57**2
      t176 = 1/t175
      t177 = t176*t62
      t178 = 1/t26
      t181 = t61**2
      t182 = 1/t181
      t183 = t57*t182
      t186 = t59**2
      t187 = t186**2
      t188 = t187*t59
      t189 = 1/t188
      t190 = t189*t178
      t192 = -0.2067834969664667D0*t176*t178-0.1715968668597574D1*t190
      t195 = -0.2067834969664667D0*t177*t178-0.6203504908994D0*t183*t192
      t196 = 1/t57
      t197 = t195*t196
      t198 = t197*t61
      t200 = t68**2
      t201 = 1/t200
      t202 = t201*t189
      t204 = 1.D0+0.2016D-2*t201
      t205 = 1/t204
      t207 = t202*t178*t205
      t209 = t74*t62
      t212 = t75*t182
      t215 = -0.2625411059665811D0*t209*t190-1.D0*t212*t192
      t216 = 1/t75
      t217 = t215*t216
      t218 = t217*t61
      vrhoa(i) = -0.7877960174741572D0*t2+0.5080001673176129D-2*t85
     #*t14+0.1905000627441048D-2*t6*t103-0.398358D-1*t20-0.52583256D-2
     #*t25*t30*t119-0.46342314D-2*t124*t17-0.44397795816D-3*t130*t131
     #-0.6117185448D-3*t134*t129*t52+0.192805272D-1*t25*t139*t52
     #-0.52583256D-2*t25*t30*t168+0.5907233D-2*t65
     #+0.3899174858189126D1*t71+0.8419610158724123D-3*t77+0.19D0*rho*
     #(0.5011795824473985D-1*t198+0.2419143800947354D0*t207
     #+0.4431373767749538D-2*t218)
      t225 = 1/t7
      t231 = 0.6350002091470161D-1*t225*t5*t10+0.8000501301919725D-1
     #*t94*t99
      t232 = t89*t231
      t240 = 0.25D0*t26*t36-0.6666666666666667D0*t26
      vsigmaaa(i) = -0.1524000501952839D-1*t5*t14
     #+0.3810001254882096D-2*t6*t232+0.5842584D-3*t25*t146
     #-0.210333024D-1*t25*t30*t240
      t254 = 1/t2/t27
      t258 = rho*t114
      t269 = 1/t123/t19
      t271 = t127*t26
      t273 = 1/t2/t271
      t277 = 1/t271
      t287 = t84*t20
      t289 = t94*t124
      t291 = 1/t27
      t292 = t291*t269
      t311 = t160*t56*sigma
      t314 = t44*t178*sigma
      s1 = -0.177591183264D-2*t130*t20*t119-0.24468741792D-2*t134*t129
     #*t119+0.771221088D-1*t25*t139*t119-0.2370667447482193D-1*t254
     #*sigma*t14-0.52583256D-2*t25*t30*(t258+0.2552208000167282D2*t31
     #-0.5D0*sigma)+0.771221088D-1*t25*t139*t168
      s2 = s1-0.2846530295136D-3*t24*t269*t273*t52+0.106031214432D-1
     #*t134*t277*t52-0.1799515872D0*t25/t28/t128*t52
      t342 = s2-0.105166512D-1*t25*t30*(0.25D0*t26*((
     #-0.4378024691358025D-1*t84-0.6032098765432099D-1*t287
     #+0.3157803703703704D-1*t289-0.3673578308641975D-2*t292)*sigma
     #-0.5D0*(-0.6254320987654321D-2*t84-0.8617283950617284D-2*t287
     #+0.4511148148148148D-2*t289-0.5247969012345679D-3*t292)*sigma
     #-0.2777777777777778D-1*(0.1125777777777778D0*t84
     #+0.1551111111111111D0*t287-0.8120066666666667D-1*t289
     #+0.9446344222222222D-2*t292)*sigma+0.5555555555555556D-1*t311
     #-0.5555555555555556D-1*t314)-0.6666666666666667D0*sigma)
     #+0.769561794144D-2*t277*t24*t131-0.52583256D-2*t25*t30*(t32+t37
     #-t42-t46+t258)-0.210333024D-1*t25*t30*(0.5D0*rho*t164+0.25D0*t26
     #*(-0.2777777777777778D-1*t311+0.2777777777777778D-1*t314))
      t346 = t273*t24
      t363 = sigma**2
      t369 = 1/t98/t97
      t377 = 1/t88/t13
      t378 = t102**2
      t392 = 1/t175/t56
      t394 = 1/t127
      t395 = t392*t62*t394
      t404 = 1/t181/t61
      t406 = t192**2
      t414 = 1/t188/t56
      t415 = t414*t394
      t417 = t189*t291
      t419 = -0.1378556646443111D0*t392*t394+0.4135669939329333D0*t176
     #*t291-0.1429973890497978D1*t415+0.3431937337195148D1*t417
      t437 = t394*t205
      t446 = t200**2
      t450 = t204**2
      s1 = -0.177591183264D-2*t130*t20*t168-0.74973077867952D-4*t346
     #*t131-0.20659774319712D-3*t346*t124*t52+0.1838549288719989D0
     #*t207+0.3808964826600229D-1*t198+0.3367844063489649D-2*t218
     #-0.1016000334635226D-1*t85*t103
      s2 = s1+0.1905000627441048D-2*t6*t89*(0.3951112412470322D0*t7
     #*t254*t10+0.106673350692263D1*sigma*t139*t99
     #-0.4515557042823225D0*t363/t2/t127/t27*t369)
     #-0.3810001254882096D-2*t6*t377*t378-0.24468741792D-2*t134*t129
     #*t168
      s3 = s2-0.5251973449827715D0/t28
      s4 = s3-0.61789752D-2*t124*t5
      s5 = s4
      s7 = -0.21564623448D-2*t269*t146
      s8 = 0.38D0*rho*(0.5011795824473985D-1*(-0.1378556646443111D0
     #*t395+0.4135669939329333D0*t176*t182*t178*t192
     #+0.4135669939329333D0*t177*t291+0.12407009817988D1*t57*t404*t406
     #-0.6203504908994D0*t183*t419)*t196*t61+0.1670598608157995D-1
     #*t195/t57/t56*t61*t178+0.5011795824473985D-1*t197*t192
     #+0.1270249377985834D0/t200/t68*t392*t437+0.2015953167456128D0
     #*t201*t414*t437-0.4838287601894708D0*t202*t291*t205
     #-0.2560822746019441D-3/t446/t68*t392*t394/t450
     #+0.4431373767749538D-2*(0.3446391616107778D-1*t395
     #+0.5250822119331622D0*t74*t182*t190*t192-0.2187842549721509D0
     #*t209*t415+0.5250822119331622D0*t209*t417+2.D0*t75*t404*t406
     #-1.D0*t212*t419)*t216*t61+0.1163417769936259D-2*t215/t75/t74*t61
     #*t189*t178+0.4431373767749538D-2*t217*t192)
      s6 = s7+s8
      t485 = s5+s6
      v2rhoa2(i) = t342+t485
      t490 = t5*t89
      s1 = 0.2032000669270451D-1*t84*t14-0.5080001673176129D-2*t85
     #*t232+0.7620002509764193D-2*t490*t102-0.3810001254882096D-2*t6
     #*t377*t102*t231+0.1905000627441048D-2*t6*t89*(
     #-0.169333389105871D0*t225*t84*t10-0.640040104153578D0*t30*t99
     #+0.3386667782117419D0*sigma*t273*t369)-0.52583256D-2*t25*t30*(
     #-0.9444444444444444D0*rho-0.2777777777777778D-1*rho*t44)
     #+0.4933088424D-4*t291*t24*t20
      v2rhoasigmaaa(i) = s1+0.679687272D-4*t134*t291+0.80822412D-2*t25
     #*t94-0.105166512D-1*t25*t30*(0.25D0*t26*(-0.3D-22*t144
     #+0.5555555555555556D-1*t111)+0.1333333333333333D1*rho)
     #-0.105166512D-1*t25*t94*t36-0.177591183264D-2*t130*t20*t240
     #-0.24468741792D-2*t134*t129*t240+0.771221088D-1*t25*t139*t240
     #-0.210333024D-1*t25*t30*(0.25D0*t26*t149-0.1333333333333333D1*rho)
      t554 = t231**2
      v2sigmaaa2(i) = 0.3048001003905677D-1*t490*t231
     #-0.7620002509764193D-2*t6*t377*t554+0.3810001254882096D-2*t6*t89
     #*(-0.1270000418294032D0/t7/sigma*t5*t10+0.1600100260383945D0
     #/sigma*t94*t99-0.2540000836588064D0/t2/t128*t369)
      else ! rho
      zk(i) = 0.0d0
      vrhoa(i) = 0.0d0
      v2rhoa2(i) = 0.0d0
      vsigmaaa(i) = 0.0d0
      v2rhoasigmaaa(i) = 0.0d0
      v2sigmaaa2(i) = 0.0d0
      endif ! rho
      enddo

      endif ! ideriv
      return
      end

c:XC_B3LYPsubrend
