!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
! ----------------------------------------------------------
! COMPUTES THE INTEGRAL CLASS (f f|s s)
! ----------------------------------------------------------
SUBROUTINE dIntB10100101(PrmBufB,LBra,PrmBufK,LKet,ACInfo,BDInfo, &
 OA,LDA,OB,LDB,OC,LDC,OD,LDD,GOA,GOB,GOC,GOD,NINT,PBC,GRADIENTS,STRESS)
       USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      USE ShellPairStruct
      USE GammaF7
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER        :: LBra,LKet,NINT,CDOffSet
      REAL(DOUBLE)   :: PrmBufB(10,LBra),PrmBufK(10,LKet)
      TYPE(SmallAtomInfo) :: ACInfo,BDInfo
      TYPE(PBCInfo) :: PBC
      REAL(DOUBLE)  :: GRADIENTS(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9)
      REAL(DOUBLE)  :: Ax,Ay,Az,Bx,By,Bz,Cx,Cy,Cz
      REAL(DOUBLE)  :: Dx,Dy,Dz,Qx,Qy,Qz,Px,Py,Pz
      REAL(DOUBLE)  :: PQx,PQy,PQz,FPQx,FPQy,FPQz
      REAL(DOUBLE)  :: Zeta,Eta,Omega,Up,Uq,Upq
      REAL(DOUBLE)  :: T,ET,TwoT,InvT,SqInvT
      REAL(DOUBLE)  :: Alpha,Beta,Gamma
      REAL(DOUBLE), DIMENSION(120) :: HRRTmp
      REAL(DOUBLE), DIMENSION(84,1,1) :: HRR
      REAL(DOUBLE), DIMENSION(120,1,1) :: HRRA,HRRB
      REAL(DOUBLE), DIMENSION(84,4,1) :: HRRC
      REAL(DOUBLE)  :: VRR(120,4,0:7)
      REAL(DOUBLE)  :: VRRS(84,1,0:6,3)
      REAL(DOUBLE)  :: HRRS(84,1,1,9)
      REAL(DOUBLE)  :: TOm,PQJ(3),FP(9)
      INTEGER       :: OffSet,OA,LDA,GOA,OB,LDB,GOB,OC,LDC,GOC,OD,LDD,GOD,I,J,K,L,IJ
      EXTERNAL InitDbl
      CALL InitDbl(84*1,HRR(1,1,1))
      CALL InitDbl(120*1,HRRA(1,1,1))
      CALL InitDbl(120*1,HRRB(1,1,1))
      CALL InitDbl(84*4,HRRC(1,1,1))
      CALL InitDbl(9*1*84*1,HRRS(1,1,1,1))
      Ax=ACInfo%Atm1X
      Ay=ACInfo%Atm1Y
      Az=ACInfo%Atm1Z
      Bx=ACInfo%Atm2X
      By=ACInfo%Atm2Y
      Bz=ACInfo%Atm2Z
      Cx=BDInfo%Atm1X
      Cy=BDInfo%Atm1Y
      Cz=BDInfo%Atm1Z
      Dx=BDInfo%Atm2X
      Dy=BDInfo%Atm2Y
      Dz=BDInfo%Atm2Z
      ABx=Ax-Bx
      ABy=Ay-By
      ABz=Az-Bz
      CDx=Cx-Dx
      CDy=Cy-Dy
      CDz=Cz-Dz
      !
      !This will feel better above!
      FP(1)=PBC%InvBoxSh%D(1,1)*(Ax-Dx)+PBC%InvBoxSh%D(1,2)*(Ay-Dy)+PBC%InvBoxSh%D(1,3)*(Az-Dz)
      FP(2)=                            PBC%InvBoxSh%D(2,2)*(Ay-Dy)+PBC%InvBoxSh%D(2,3)*(Az-Dz)
      FP(3)=                                                        PBC%InvBoxSh%D(3,3)*(Az-Dz)
      FP(4)=PBC%InvBoxSh%D(1,1)*(Cx-Dx)+PBC%InvBoxSh%D(1,2)*(Cy-Dy)+PBC%InvBoxSh%D(1,3)*(Cz-Dz)
      FP(5)=                            PBC%InvBoxSh%D(2,2)*(Cy-Dy)+PBC%InvBoxSh%D(2,3)*(Cz-Dz)
      FP(6)=                                                        PBC%InvBoxSh%D(3,3)*(Cz-Dz)
      FP(7)=PBC%InvBoxSh%D(1,1)*(Bx-Dx)+PBC%InvBoxSh%D(1,2)*(By-Dy)+PBC%InvBoxSh%D(1,3)*(Bz-Dz)
      FP(8)=                            PBC%InvBoxSh%D(2,2)*(By-Dy)+PBC%InvBoxSh%D(2,3)*(Bz-Dz)
      FP(9)=                                                        PBC%InvBoxSh%D(3,3)*(Bz-Dz)
      !
      DO J=1,LKet ! K^2 VRR |N0) loop
         Eta=PrmBufK(1,J)
         Qx=PrmBufK(2,J)
         Qy=PrmBufK(3,J)
         Qz=PrmBufK(4,J)
         Uq=PrmBufK(5,J)
         Gamma =PrmBufK(9,J)
         QCx=Qx-Cx
         QCy=Qy-Cy
         QCz=Qz-Cz
         DO K=1,LBra ! K^2 VRR (M0| loop
            Zeta=PrmBufB(1,K)
            Px=PrmBufB(2,K)
            Py=PrmBufB(3,K)
            Pz=PrmBufB(4,K)
            Up=PrmBufB(5,K)
            Alpha =PrmBufB(9,K)
            Beta  =PrmBufB(10,K)
            r1xZpE=One/(Zeta+Eta)
            Upq=SQRT(r1xZpE)*Up*Uq
            HfxZpE=Half/(Zeta+Eta)
            r1x2E=Half/Eta
            r1x2Z=Half/Zeta
            ExZpE=Eta*r1xZpE
            ZxZpE=Zeta*r1xZpE
            Omega=Eta*Zeta*r1xZpE
            PAx=Px-Ax
            PAy=Py-Ay
            PAz=Pz-Az
            PQx=Px-Qx
            PQy=Py-Qy
            PQz=Pz-Qz
            ! Begin Minimum Image Convention
            FPQx = PQx*PBC%InvBoxSh%D(1,1)+PQy*PBC%InvBoxSh%D(1,2)+PQz*PBC%InvBoxSh%D(1,3)
            FPQy = PQy*PBC%InvBoxSh%D(2,2)+PQz*PBC%InvBoxSh%D(2,3)
            FPQz = PQz*PBC%InvBoxSh%D(3,3)
            TOm=2.0d0*Omega
            IF(PBC%AutoW%I(1)==1) THEN
              PQJ(1)=ANINT(FPQx-SIGN(1D-15,FPQx));FPQx=FPQx-PQJ(1)
              PQJ(1)=PQJ(1)*TOm
            ELSE
              PQJ(1)=0.0D0
            ENDIF
            IF(PBC%AutoW%I(2)==1) THEN
              PQJ(2)=ANINT(FPQy-SIGN(1D-15,FPQy));FPQy=FPQy-PQJ(2)
              PQJ(2)=PQJ(2)*TOm
            ELSE
              PQJ(2)=0.0D0
            ENDIF
            IF(PBC%AutoW%I(3)==1) THEN
              PQJ(3)=ANINT(FPQz-SIGN(1D-15,FPQz));FPQz=FPQz-PQJ(3)
              PQJ(3)=PQJ(3)*TOm
            ELSE
              PQJ(3)=0.0D0
            ENDIF
            PQx=FPQx*PBC%BoxShape%D(1,1)+FPQy*PBC%BoxShape%D(1,2)+FPQz*PBC%BoxShape%D(1,3)
            PQy=FPQy*PBC%BoxShape%D(2,2)+FPQz*PBC%BoxShape%D(2,3)
            PQz=FPQz*PBC%BoxShape%D(3,3)
            ! End MIC
            WPx = -Eta*PQx*r1xZpE
            WPy = -Eta*PQy*r1xZpE
            WPz = -Eta*PQz*r1xZpE
            WQx = Zeta*PQx*r1xZpE
            WQy = Zeta*PQy*r1xZpE
            WQz = Zeta*PQz*r1xZpE
            T=Omega*(PQx*PQx+PQy*PQy+PQz*PQz)
            IF(T<Gamma_Switch)THEN
              L=AINT(T*Gamma_Grid)
              ET=EXP(-T)
              TwoT=Two*T
              W7=(F7_0(L)+T*(F7_1(L)+T*(F7_2(L)+T*(F7_3(L)+T*F7_4(L)))))
              W6=+7.692307692307693D-02*(TwoT*W7+ET)
              W5=+9.090909090909090D-02*(TwoT*W6+ET)
              W4=+1.111111111111111D-01*(TwoT*W5+ET)
              W3=+1.428571428571428D-01*(TwoT*W4+ET)
              W2=+2.000000000000000D-01*(TwoT*W3+ET)
              W1=+3.333333333333333D-01*(TwoT*W2+ET)
              W0=TwoT*W1+ET
              VRR(1,1,0)=Upq*W0
              VRR(1,1,1)=Upq*W1
              VRR(1,1,2)=Upq*W2
              VRR(1,1,3)=Upq*W3
              VRR(1,1,4)=Upq*W4
              VRR(1,1,5)=Upq*W5
              VRR(1,1,6)=Upq*W6
              VRR(1,1,7)=Upq*W7
            ELSE
              InvT=One/T
              SqInvT=DSQRT(InvT)
              VRR(1,1,0)=+8.862269254527580D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,1)=+4.431134627263790D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,2)=+6.646701940895685D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,3)=+1.661675485223921D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,4)=+5.815864198283724D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,5)=+2.617138889227676D+01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,6)=+1.439426389075222D+02*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,7)=+9.356271528988940D+02*Upq*SqInvT
            ENDIF
            ! Generating (p0|s0)^(6)
            VRR(2,1,6)=PAx*VRR(1,1,6)+WPx*VRR(1,1,7)
            VRR(3,1,6)=PAy*VRR(1,1,6)+WPy*VRR(1,1,7)
            VRR(4,1,6)=PAz*VRR(1,1,6)+WPz*VRR(1,1,7)
            ! Generating (p0|s0)^(5)
            VRR(2,1,5)=PAx*VRR(1,1,5)+WPx*VRR(1,1,6)
            VRR(3,1,5)=PAy*VRR(1,1,5)+WPy*VRR(1,1,6)
            VRR(4,1,5)=PAz*VRR(1,1,5)+WPz*VRR(1,1,6)
            ! Generating (p0|s0)^(4)
            VRR(2,1,4)=PAx*VRR(1,1,4)+WPx*VRR(1,1,5)
            VRR(3,1,4)=PAy*VRR(1,1,4)+WPy*VRR(1,1,5)
            VRR(4,1,4)=PAz*VRR(1,1,4)+WPz*VRR(1,1,5)
            ! Generating (p0|s0)^(3)
            VRR(2,1,3)=PAx*VRR(1,1,3)+WPx*VRR(1,1,4)
            VRR(3,1,3)=PAy*VRR(1,1,3)+WPy*VRR(1,1,4)
            VRR(4,1,3)=PAz*VRR(1,1,3)+WPz*VRR(1,1,4)
            ! Generating (p0|s0)^(2)
            VRR(2,1,2)=PAx*VRR(1,1,2)+WPx*VRR(1,1,3)
            VRR(3,1,2)=PAy*VRR(1,1,2)+WPy*VRR(1,1,3)
            VRR(4,1,2)=PAz*VRR(1,1,2)+WPz*VRR(1,1,3)
            ! Generating (p0|s0)^(1)
            VRR(2,1,1)=PAx*VRR(1,1,1)+WPx*VRR(1,1,2)
            VRR(3,1,1)=PAy*VRR(1,1,1)+WPy*VRR(1,1,2)
            VRR(4,1,1)=PAz*VRR(1,1,1)+WPz*VRR(1,1,2)
            ! Generating (p0|s0)^(0)
            VRR(2,1,0)=PAx*VRR(1,1,0)+WPx*VRR(1,1,1)
            VRR(3,1,0)=PAy*VRR(1,1,0)+WPy*VRR(1,1,1)
            VRR(4,1,0)=PAz*VRR(1,1,0)+WPz*VRR(1,1,1)
            ! Generating (d0|s0)^(5)
            VRR(5,1,5)=PAx*VRR(2,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPx*VRR(2,1,6)
            VRR(6,1,5)=PAx*VRR(3,1,5)+WPx*VRR(3,1,6)
            VRR(7,1,5)=PAy*VRR(3,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPy*VRR(3,1,6)
            VRR(8,1,5)=PAx*VRR(4,1,5)+WPx*VRR(4,1,6)
            VRR(9,1,5)=PAy*VRR(4,1,5)+WPy*VRR(4,1,6)
            VRR(10,1,5)=PAz*VRR(4,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPz*VRR(4,1,6)
            ! Generating (d0|s0)^(4)
            VRR(5,1,4)=PAx*VRR(2,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPx*VRR(2,1,5)
            VRR(6,1,4)=PAx*VRR(3,1,4)+WPx*VRR(3,1,5)
            VRR(7,1,4)=PAy*VRR(3,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPy*VRR(3,1,5)
            VRR(8,1,4)=PAx*VRR(4,1,4)+WPx*VRR(4,1,5)
            VRR(9,1,4)=PAy*VRR(4,1,4)+WPy*VRR(4,1,5)
            VRR(10,1,4)=PAz*VRR(4,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPz*VRR(4,1,5)
            ! Generating (d0|s0)^(3)
            VRR(5,1,3)=PAx*VRR(2,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPx*VRR(2,1,4)
            VRR(6,1,3)=PAx*VRR(3,1,3)+WPx*VRR(3,1,4)
            VRR(7,1,3)=PAy*VRR(3,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPy*VRR(3,1,4)
            VRR(8,1,3)=PAx*VRR(4,1,3)+WPx*VRR(4,1,4)
            VRR(9,1,3)=PAy*VRR(4,1,3)+WPy*VRR(4,1,4)
            VRR(10,1,3)=PAz*VRR(4,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPz*VRR(4,1,4)
            ! Generating (d0|s0)^(2)
            VRR(5,1,2)=PAx*VRR(2,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPx*VRR(2,1,3)
            VRR(6,1,2)=PAx*VRR(3,1,2)+WPx*VRR(3,1,3)
            VRR(7,1,2)=PAy*VRR(3,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPy*VRR(3,1,3)
            VRR(8,1,2)=PAx*VRR(4,1,2)+WPx*VRR(4,1,3)
            VRR(9,1,2)=PAy*VRR(4,1,2)+WPy*VRR(4,1,3)
            VRR(10,1,2)=PAz*VRR(4,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPz*VRR(4,1,3)
            ! Generating (d0|s0)^(1)
            VRR(5,1,1)=PAx*VRR(2,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPx*VRR(2,1,2)
            VRR(6,1,1)=PAx*VRR(3,1,1)+WPx*VRR(3,1,2)
            VRR(7,1,1)=PAy*VRR(3,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPy*VRR(3,1,2)
            VRR(8,1,1)=PAx*VRR(4,1,1)+WPx*VRR(4,1,2)
            VRR(9,1,1)=PAy*VRR(4,1,1)+WPy*VRR(4,1,2)
            VRR(10,1,1)=PAz*VRR(4,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPz*VRR(4,1,2)
            ! Generating (d0|s0)^(0)
            VRR(5,1,0)=PAx*VRR(2,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPx*VRR(2,1,1)
            VRR(6,1,0)=PAx*VRR(3,1,0)+WPx*VRR(3,1,1)
            VRR(7,1,0)=PAy*VRR(3,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPy*VRR(3,1,1)
            VRR(8,1,0)=PAx*VRR(4,1,0)+WPx*VRR(4,1,1)
            VRR(9,1,0)=PAy*VRR(4,1,0)+WPy*VRR(4,1,1)
            VRR(10,1,0)=PAz*VRR(4,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPz*VRR(4,1,1)
            ! Generating (f0|s0)^(4)
            CALL VRRf0s0(120,4,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|s0)^(3)
            CALL VRRf0s0(120,4,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|s0)^(2)
            CALL VRRf0s0(120,4,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|s0)^(1)
            CALL VRRf0s0(120,4,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|s0)^(0)
            CALL VRRf0s0(120,4,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|s0)^(3)
            CALL VRRg0s0(120,4,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|s0)^(2)
            CALL VRRg0s0(120,4,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|s0)^(1)
            CALL VRRg0s0(120,4,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|s0)^(0)
            CALL VRRg0s0(120,4,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|s0)^(2)
            CALL VRRh0s0(120,4,VRR(1,1,2),VRR(1,1,3))
            ! Generating (h0|s0)^(1)
            CALL VRRh0s0(120,4,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|s0)^(0)
            CALL VRRh0s0(120,4,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|s0)^(1)
            CALL VRRi0s0(120,4,VRR(1,1,1),VRR(1,1,2))
            ! Generating (i0|s0)^(0)
            CALL VRRi0s0(120,4,VRR(1,1,0),VRR(1,1,1))
            ! Generating (j0|s0)^(0)
            CALL VRRj0s0(120,4,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|p0)^(6)
            VRR(1,2,6)=QCx*VRR(1,1,6)+WQx*VRR(1,1,7)
            VRR(1,3,6)=QCy*VRR(1,1,6)+WQy*VRR(1,1,7)
            VRR(1,4,6)=QCz*VRR(1,1,6)+WQz*VRR(1,1,7)
            ! Generating (s0|p0)^(5)
            VRR(1,2,5)=QCx*VRR(1,1,5)+WQx*VRR(1,1,6)
            VRR(1,3,5)=QCy*VRR(1,1,5)+WQy*VRR(1,1,6)
            VRR(1,4,5)=QCz*VRR(1,1,5)+WQz*VRR(1,1,6)
            ! Generating (s0|p0)^(4)
            VRR(1,2,4)=QCx*VRR(1,1,4)+WQx*VRR(1,1,5)
            VRR(1,3,4)=QCy*VRR(1,1,4)+WQy*VRR(1,1,5)
            VRR(1,4,4)=QCz*VRR(1,1,4)+WQz*VRR(1,1,5)
            ! Generating (s0|p0)^(3)
            VRR(1,2,3)=QCx*VRR(1,1,3)+WQx*VRR(1,1,4)
            VRR(1,3,3)=QCy*VRR(1,1,3)+WQy*VRR(1,1,4)
            VRR(1,4,3)=QCz*VRR(1,1,3)+WQz*VRR(1,1,4)
            ! Generating (s0|p0)^(2)
            VRR(1,2,2)=QCx*VRR(1,1,2)+WQx*VRR(1,1,3)
            VRR(1,3,2)=QCy*VRR(1,1,2)+WQy*VRR(1,1,3)
            VRR(1,4,2)=QCz*VRR(1,1,2)+WQz*VRR(1,1,3)
            ! Generating (s0|p0)^(1)
            VRR(1,2,1)=QCx*VRR(1,1,1)+WQx*VRR(1,1,2)
            VRR(1,3,1)=QCy*VRR(1,1,1)+WQy*VRR(1,1,2)
            VRR(1,4,1)=QCz*VRR(1,1,1)+WQz*VRR(1,1,2)
            ! Generating (s0|p0)^(0)
            VRR(1,2,0)=QCx*VRR(1,1,0)+WQx*VRR(1,1,1)
            VRR(1,3,0)=QCy*VRR(1,1,0)+WQy*VRR(1,1,1)
            VRR(1,4,0)=QCz*VRR(1,1,0)+WQz*VRR(1,1,1)
            ! Generating (p0|p0)^(5)
            VRR(2,2,5)=QCx*VRR(2,1,5)+HfxZpE*VRR(1,1,6)+WQx*VRR(2,1,6)
            VRR(2,3,5)=QCy*VRR(2,1,5)+WQy*VRR(2,1,6)
            VRR(2,4,5)=QCz*VRR(2,1,5)+WQz*VRR(2,1,6)
            VRR(3,2,5)=QCx*VRR(3,1,5)+WQx*VRR(3,1,6)
            VRR(3,3,5)=QCy*VRR(3,1,5)+HfxZpE*VRR(1,1,6)+WQy*VRR(3,1,6)
            VRR(3,4,5)=QCz*VRR(3,1,5)+WQz*VRR(3,1,6)
            VRR(4,2,5)=QCx*VRR(4,1,5)+WQx*VRR(4,1,6)
            VRR(4,3,5)=QCy*VRR(4,1,5)+WQy*VRR(4,1,6)
            VRR(4,4,5)=QCz*VRR(4,1,5)+HfxZpE*VRR(1,1,6)+WQz*VRR(4,1,6)
            ! Generating (p0|p0)^(4)
            VRR(2,2,4)=QCx*VRR(2,1,4)+HfxZpE*VRR(1,1,5)+WQx*VRR(2,1,5)
            VRR(2,3,4)=QCy*VRR(2,1,4)+WQy*VRR(2,1,5)
            VRR(2,4,4)=QCz*VRR(2,1,4)+WQz*VRR(2,1,5)
            VRR(3,2,4)=QCx*VRR(3,1,4)+WQx*VRR(3,1,5)
            VRR(3,3,4)=QCy*VRR(3,1,4)+HfxZpE*VRR(1,1,5)+WQy*VRR(3,1,5)
            VRR(3,4,4)=QCz*VRR(3,1,4)+WQz*VRR(3,1,5)
            VRR(4,2,4)=QCx*VRR(4,1,4)+WQx*VRR(4,1,5)
            VRR(4,3,4)=QCy*VRR(4,1,4)+WQy*VRR(4,1,5)
            VRR(4,4,4)=QCz*VRR(4,1,4)+HfxZpE*VRR(1,1,5)+WQz*VRR(4,1,5)
            ! Generating (p0|p0)^(3)
            VRR(2,2,3)=QCx*VRR(2,1,3)+HfxZpE*VRR(1,1,4)+WQx*VRR(2,1,4)
            VRR(2,3,3)=QCy*VRR(2,1,3)+WQy*VRR(2,1,4)
            VRR(2,4,3)=QCz*VRR(2,1,3)+WQz*VRR(2,1,4)
            VRR(3,2,3)=QCx*VRR(3,1,3)+WQx*VRR(3,1,4)
            VRR(3,3,3)=QCy*VRR(3,1,3)+HfxZpE*VRR(1,1,4)+WQy*VRR(3,1,4)
            VRR(3,4,3)=QCz*VRR(3,1,3)+WQz*VRR(3,1,4)
            VRR(4,2,3)=QCx*VRR(4,1,3)+WQx*VRR(4,1,4)
            VRR(4,3,3)=QCy*VRR(4,1,3)+WQy*VRR(4,1,4)
            VRR(4,4,3)=QCz*VRR(4,1,3)+HfxZpE*VRR(1,1,4)+WQz*VRR(4,1,4)
            ! Generating (p0|p0)^(2)
            VRR(2,2,2)=QCx*VRR(2,1,2)+HfxZpE*VRR(1,1,3)+WQx*VRR(2,1,3)
            VRR(2,3,2)=QCy*VRR(2,1,2)+WQy*VRR(2,1,3)
            VRR(2,4,2)=QCz*VRR(2,1,2)+WQz*VRR(2,1,3)
            VRR(3,2,2)=QCx*VRR(3,1,2)+WQx*VRR(3,1,3)
            VRR(3,3,2)=QCy*VRR(3,1,2)+HfxZpE*VRR(1,1,3)+WQy*VRR(3,1,3)
            VRR(3,4,2)=QCz*VRR(3,1,2)+WQz*VRR(3,1,3)
            VRR(4,2,2)=QCx*VRR(4,1,2)+WQx*VRR(4,1,3)
            VRR(4,3,2)=QCy*VRR(4,1,2)+WQy*VRR(4,1,3)
            VRR(4,4,2)=QCz*VRR(4,1,2)+HfxZpE*VRR(1,1,3)+WQz*VRR(4,1,3)
            ! Generating (p0|p0)^(1)
            VRR(2,2,1)=QCx*VRR(2,1,1)+HfxZpE*VRR(1,1,2)+WQx*VRR(2,1,2)
            VRR(2,3,1)=QCy*VRR(2,1,1)+WQy*VRR(2,1,2)
            VRR(2,4,1)=QCz*VRR(2,1,1)+WQz*VRR(2,1,2)
            VRR(3,2,1)=QCx*VRR(3,1,1)+WQx*VRR(3,1,2)
            VRR(3,3,1)=QCy*VRR(3,1,1)+HfxZpE*VRR(1,1,2)+WQy*VRR(3,1,2)
            VRR(3,4,1)=QCz*VRR(3,1,1)+WQz*VRR(3,1,2)
            VRR(4,2,1)=QCx*VRR(4,1,1)+WQx*VRR(4,1,2)
            VRR(4,3,1)=QCy*VRR(4,1,1)+WQy*VRR(4,1,2)
            VRR(4,4,1)=QCz*VRR(4,1,1)+HfxZpE*VRR(1,1,2)+WQz*VRR(4,1,2)
            ! Generating (p0|p0)^(0)
            VRR(2,2,0)=QCx*VRR(2,1,0)+HfxZpE*VRR(1,1,1)+WQx*VRR(2,1,1)
            VRR(2,3,0)=QCy*VRR(2,1,0)+WQy*VRR(2,1,1)
            VRR(2,4,0)=QCz*VRR(2,1,0)+WQz*VRR(2,1,1)
            VRR(3,2,0)=QCx*VRR(3,1,0)+WQx*VRR(3,1,1)
            VRR(3,3,0)=QCy*VRR(3,1,0)+HfxZpE*VRR(1,1,1)+WQy*VRR(3,1,1)
            VRR(3,4,0)=QCz*VRR(3,1,0)+WQz*VRR(3,1,1)
            VRR(4,2,0)=QCx*VRR(4,1,0)+WQx*VRR(4,1,1)
            VRR(4,3,0)=QCy*VRR(4,1,0)+WQy*VRR(4,1,1)
            VRR(4,4,0)=QCz*VRR(4,1,0)+HfxZpE*VRR(1,1,1)+WQz*VRR(4,1,1)
            ! Generating (d0|p0)^(4)
            CALL VRRd0p0(120,4,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|p0)^(3)
            CALL VRRd0p0(120,4,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|p0)^(2)
            CALL VRRd0p0(120,4,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|p0)^(1)
            CALL VRRd0p0(120,4,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|p0)^(0)
            CALL VRRd0p0(120,4,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|p0)^(3)
            CALL VRRf0p0(120,4,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|p0)^(2)
            CALL VRRf0p0(120,4,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|p0)^(1)
            CALL VRRf0p0(120,4,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|p0)^(0)
            CALL VRRf0p0(120,4,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|p0)^(2)
            CALL VRRg0p0(120,4,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|p0)^(1)
            CALL VRRg0p0(120,4,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|p0)^(0)
            CALL VRRg0p0(120,4,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|p0)^(1)
            CALL VRRh0p0(120,4,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|p0)^(0)
            CALL VRRh0p0(120,4,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|p0)^(0)
            CALL VRRi0p0(120,4,VRR(1,1,0),VRR(1,1,1))
            !MAY BE BETTER TO PUT WHAT FOLLOWS IN A DO LOOP!
            IF(PBC%AutoW%I(1).EQ.1) THEN
            VRRS(1,1,0,1)=PQx*VRR(1,1,1)
            VRRS(1,1,1,1)=PQx*VRR(1,1,2)
            VRRS(1,1,2,1)=PQx*VRR(1,1,3)
            VRRS(1,1,3,1)=PQx*VRR(1,1,4)
            VRRS(1,1,4,1)=PQx*VRR(1,1,5)
            VRRS(1,1,5,1)=PQx*VRR(1,1,6)
            VRRS(1,1,6,1)=PQx*VRR(1,1,7)
            ! MIC-VRR: Generating [p0|s0]^(5)
            VRRS(2,1,5,1)=PAx*VRRS(1,1,5,1)+WPx*VRRS(1,1,6,1)+r1x2Z*VRR(1,1,6)
            VRRS(3,1,5,1)=PAy*VRRS(1,1,5,1)+WPy*VRRS(1,1,6,1)
            VRRS(4,1,5,1)=PAz*VRRS(1,1,5,1)+WPz*VRRS(1,1,6,1)
            ! MIC-VRR: Generating [p0|s0]^(4)
            VRRS(2,1,4,1)=PAx*VRRS(1,1,4,1)+WPx*VRRS(1,1,5,1)+r1x2Z*VRR(1,1,5)
            VRRS(3,1,4,1)=PAy*VRRS(1,1,4,1)+WPy*VRRS(1,1,5,1)
            VRRS(4,1,4,1)=PAz*VRRS(1,1,4,1)+WPz*VRRS(1,1,5,1)
            ! MIC-VRR: Generating [p0|s0]^(3)
            VRRS(2,1,3,1)=PAx*VRRS(1,1,3,1)+WPx*VRRS(1,1,4,1)+r1x2Z*VRR(1,1,4)
            VRRS(3,1,3,1)=PAy*VRRS(1,1,3,1)+WPy*VRRS(1,1,4,1)
            VRRS(4,1,3,1)=PAz*VRRS(1,1,3,1)+WPz*VRRS(1,1,4,1)
            ! MIC-VRR: Generating [p0|s0]^(2)
            VRRS(2,1,2,1)=PAx*VRRS(1,1,2,1)+WPx*VRRS(1,1,3,1)+r1x2Z*VRR(1,1,3)
            VRRS(3,1,2,1)=PAy*VRRS(1,1,2,1)+WPy*VRRS(1,1,3,1)
            VRRS(4,1,2,1)=PAz*VRRS(1,1,2,1)+WPz*VRRS(1,1,3,1)
            ! MIC-VRR: Generating [p0|s0]^(1)
            VRRS(2,1,1,1)=PAx*VRRS(1,1,1,1)+WPx*VRRS(1,1,2,1)+r1x2Z*VRR(1,1,2)
            VRRS(3,1,1,1)=PAy*VRRS(1,1,1,1)+WPy*VRRS(1,1,2,1)
            VRRS(4,1,1,1)=PAz*VRRS(1,1,1,1)+WPz*VRRS(1,1,2,1)
            ! MIC-VRR: Generating [p0|s0]^(0)
            VRRS(2,1,0,1)=PAx*VRRS(1,1,0,1)+WPx*VRRS(1,1,1,1)+r1x2Z*VRR(1,1,1)
            VRRS(3,1,0,1)=PAy*VRRS(1,1,0,1)+WPy*VRRS(1,1,1,1)
            VRRS(4,1,0,1)=PAz*VRRS(1,1,0,1)+WPz*VRRS(1,1,1,1)
            ! MIC-VRR: Generating [d0|s0]^(4)
            VRRS( 5,1,4,1)=PAx*VRRS(2,1,4,1)+r1x2Z*(VRRS(1,1,4,1)-ExZpE*VRRS(1,1,5,1))+WPx*VRRS(2,1,5,1)+r1x2Z*VRR(2,1,5)
            VRRS( 6,1,4,1)=PAx*VRRS(3,1,4,1)+WPx*VRRS(3,1,5,1)+r1x2Z*VRR(3,1,5)
            VRRS( 7,1,4,1)=PAy*VRRS(3,1,4,1)+r1x2Z*(VRRS(1,1,4,1)-ExZpE*VRRS(1,1,5,1))+WPy*VRRS(3,1,5,1)
            VRRS( 8,1,4,1)=PAx*VRRS(4,1,4,1)+WPx*VRRS(4,1,5,1)+r1x2Z*VRR(4,1,5)
            VRRS( 9,1,4,1)=PAy*VRRS(4,1,4,1)+WPy*VRRS(4,1,5,1)
            VRRS(10,1,4,1)=PAz*VRRS(4,1,4,1)+r1x2Z*(VRRS(1,1,4,1)-ExZpE*VRRS(1,1,5,1))+WPz*VRRS(4,1,5,1)
            ! MIC-VRR: Generating [d0|s0]^(3)
            VRRS( 5,1,3,1)=PAx*VRRS(2,1,3,1)+r1x2Z*(VRRS(1,1,3,1)-ExZpE*VRRS(1,1,4,1))+WPx*VRRS(2,1,4,1)+r1x2Z*VRR(2,1,4)
            VRRS( 6,1,3,1)=PAx*VRRS(3,1,3,1)+WPx*VRRS(3,1,4,1)+r1x2Z*VRR(3,1,4)
            VRRS( 7,1,3,1)=PAy*VRRS(3,1,3,1)+r1x2Z*(VRRS(1,1,3,1)-ExZpE*VRRS(1,1,4,1))+WPy*VRRS(3,1,4,1)
            VRRS( 8,1,3,1)=PAx*VRRS(4,1,3,1)+WPx*VRRS(4,1,4,1)+r1x2Z*VRR(4,1,4)
            VRRS( 9,1,3,1)=PAy*VRRS(4,1,3,1)+WPy*VRRS(4,1,4,1)
            VRRS(10,1,3,1)=PAz*VRRS(4,1,3,1)+r1x2Z*(VRRS(1,1,3,1)-ExZpE*VRRS(1,1,4,1))+WPz*VRRS(4,1,4,1)
            ! MIC-VRR: Generating [d0|s0]^(2)
            VRRS( 5,1,2,1)=PAx*VRRS(2,1,2,1)+r1x2Z*(VRRS(1,1,2,1)-ExZpE*VRRS(1,1,3,1))+WPx*VRRS(2,1,3,1)+r1x2Z*VRR(2,1,3)
            VRRS( 6,1,2,1)=PAx*VRRS(3,1,2,1)+WPx*VRRS(3,1,3,1)+r1x2Z*VRR(3,1,3)
            VRRS( 7,1,2,1)=PAy*VRRS(3,1,2,1)+r1x2Z*(VRRS(1,1,2,1)-ExZpE*VRRS(1,1,3,1))+WPy*VRRS(3,1,3,1)
            VRRS( 8,1,2,1)=PAx*VRRS(4,1,2,1)+WPx*VRRS(4,1,3,1)+r1x2Z*VRR(4,1,3)
            VRRS( 9,1,2,1)=PAy*VRRS(4,1,2,1)+WPy*VRRS(4,1,3,1)
            VRRS(10,1,2,1)=PAz*VRRS(4,1,2,1)+r1x2Z*(VRRS(1,1,2,1)-ExZpE*VRRS(1,1,3,1))+WPz*VRRS(4,1,3,1)
            ! MIC-VRR: Generating [d0|s0]^(1)
            VRRS( 5,1,1,1)=PAx*VRRS(2,1,1,1)+r1x2Z*(VRRS(1,1,1,1)-ExZpE*VRRS(1,1,2,1))+WPx*VRRS(2,1,2,1)+r1x2Z*VRR(2,1,2)
            VRRS( 6,1,1,1)=PAx*VRRS(3,1,1,1)+WPx*VRRS(3,1,2,1)+r1x2Z*VRR(3,1,2)
            VRRS( 7,1,1,1)=PAy*VRRS(3,1,1,1)+r1x2Z*(VRRS(1,1,1,1)-ExZpE*VRRS(1,1,2,1))+WPy*VRRS(3,1,2,1)
            VRRS( 8,1,1,1)=PAx*VRRS(4,1,1,1)+WPx*VRRS(4,1,2,1)+r1x2Z*VRR(4,1,2)
            VRRS( 9,1,1,1)=PAy*VRRS(4,1,1,1)+WPy*VRRS(4,1,2,1)
            VRRS(10,1,1,1)=PAz*VRRS(4,1,1,1)+r1x2Z*(VRRS(1,1,1,1)-ExZpE*VRRS(1,1,2,1))+WPz*VRRS(4,1,2,1)
            ! MIC-VRR: Generating [d0|s0]^(0)
            VRRS( 5,1,0,1)=PAx*VRRS(2,1,0,1)+r1x2Z*(VRRS(1,1,0,1)-ExZpE*VRRS(1,1,1,1))+WPx*VRRS(2,1,1,1)+r1x2Z*VRR(2,1,1)
            VRRS( 6,1,0,1)=PAx*VRRS(3,1,0,1)+WPx*VRRS(3,1,1,1)+r1x2Z*VRR(3,1,1)
            VRRS( 7,1,0,1)=PAy*VRRS(3,1,0,1)+r1x2Z*(VRRS(1,1,0,1)-ExZpE*VRRS(1,1,1,1))+WPy*VRRS(3,1,1,1)
            VRRS( 8,1,0,1)=PAx*VRRS(4,1,0,1)+WPx*VRRS(4,1,1,1)+r1x2Z*VRR(4,1,1)
            VRRS( 9,1,0,1)=PAy*VRRS(4,1,0,1)+WPy*VRRS(4,1,1,1)
            VRRS(10,1,0,1)=PAz*VRRS(4,1,0,1)+r1x2Z*(VRRS(1,1,0,1)-ExZpE*VRRS(1,1,1,1))+WPz*VRRS(4,1,1,1)
            ! MIC-VRR: Generating [f0|s0]^(3)
            CALL MVRRf0s0(1,84,1,VRRS(1,1,3,1),VRRS(1,1,4,1),120,4,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|s0]^(2)
            CALL MVRRf0s0(1,84,1,VRRS(1,1,2,1),VRRS(1,1,3,1),120,4,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|s0]^(1)
            CALL MVRRf0s0(1,84,1,VRRS(1,1,1,1),VRRS(1,1,2,1),120,4,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|s0]^(0)
            CALL MVRRf0s0(1,84,1,VRRS(1,1,0,1),VRRS(1,1,1,1),120,4,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|s0]^(2)
            CALL MVRRg0s0(1,84,1,VRRS(1,1,2,1),VRRS(1,1,3,1),120,4,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|s0]^(1)
            CALL MVRRg0s0(1,84,1,VRRS(1,1,1,1),VRRS(1,1,2,1),120,4,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|s0]^(0)
            CALL MVRRg0s0(1,84,1,VRRS(1,1,0,1),VRRS(1,1,1,1),120,4,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|s0]^(1)
            CALL MVRRh0s0(1,84,1,VRRS(1,1,1,1),VRRS(1,1,2,1),120,4,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|s0]^(0)
            CALL MVRRh0s0(1,84,1,VRRS(1,1,0,1),VRRS(1,1,1,1),120,4,VRR(1,1,1))
            ! MIC-VRR: Generating [i0|s0]^(0)
            CALL MVRRi0s0(1,84,1,VRRS(1,1,0,1),VRRS(1,1,1,1),120,4,VRR(1,1,1))
            ENDIF
            IF(PBC%AutoW%I(2).EQ.1) THEN
            VRRS(1,1,0,2)=PQy*VRR(1,1,1)
            VRRS(1,1,1,2)=PQy*VRR(1,1,2)
            VRRS(1,1,2,2)=PQy*VRR(1,1,3)
            VRRS(1,1,3,2)=PQy*VRR(1,1,4)
            VRRS(1,1,4,2)=PQy*VRR(1,1,5)
            VRRS(1,1,5,2)=PQy*VRR(1,1,6)
            VRRS(1,1,6,2)=PQy*VRR(1,1,7)
            ! MIC-VRR: Generating [p0|s0]^(5)
            VRRS(2,1,5,2)=PAx*VRRS(1,1,5,2)+WPx*VRRS(1,1,6,2)
            VRRS(3,1,5,2)=PAy*VRRS(1,1,5,2)+WPy*VRRS(1,1,6,2)+r1x2Z*VRR(1,1,6)
            VRRS(4,1,5,2)=PAz*VRRS(1,1,5,2)+WPz*VRRS(1,1,6,2)
            ! MIC-VRR: Generating [p0|s0]^(4)
            VRRS(2,1,4,2)=PAx*VRRS(1,1,4,2)+WPx*VRRS(1,1,5,2)
            VRRS(3,1,4,2)=PAy*VRRS(1,1,4,2)+WPy*VRRS(1,1,5,2)+r1x2Z*VRR(1,1,5)
            VRRS(4,1,4,2)=PAz*VRRS(1,1,4,2)+WPz*VRRS(1,1,5,2)
            ! MIC-VRR: Generating [p0|s0]^(3)
            VRRS(2,1,3,2)=PAx*VRRS(1,1,3,2)+WPx*VRRS(1,1,4,2)
            VRRS(3,1,3,2)=PAy*VRRS(1,1,3,2)+WPy*VRRS(1,1,4,2)+r1x2Z*VRR(1,1,4)
            VRRS(4,1,3,2)=PAz*VRRS(1,1,3,2)+WPz*VRRS(1,1,4,2)
            ! MIC-VRR: Generating [p0|s0]^(2)
            VRRS(2,1,2,2)=PAx*VRRS(1,1,2,2)+WPx*VRRS(1,1,3,2)
            VRRS(3,1,2,2)=PAy*VRRS(1,1,2,2)+WPy*VRRS(1,1,3,2)+r1x2Z*VRR(1,1,3)
            VRRS(4,1,2,2)=PAz*VRRS(1,1,2,2)+WPz*VRRS(1,1,3,2)
            ! MIC-VRR: Generating [p0|s0]^(1)
            VRRS(2,1,1,2)=PAx*VRRS(1,1,1,2)+WPx*VRRS(1,1,2,2)
            VRRS(3,1,1,2)=PAy*VRRS(1,1,1,2)+WPy*VRRS(1,1,2,2)+r1x2Z*VRR(1,1,2)
            VRRS(4,1,1,2)=PAz*VRRS(1,1,1,2)+WPz*VRRS(1,1,2,2)
            ! MIC-VRR: Generating [p0|s0]^(0)
            VRRS(2,1,0,2)=PAx*VRRS(1,1,0,2)+WPx*VRRS(1,1,1,2)
            VRRS(3,1,0,2)=PAy*VRRS(1,1,0,2)+WPy*VRRS(1,1,1,2)+r1x2Z*VRR(1,1,1)
            VRRS(4,1,0,2)=PAz*VRRS(1,1,0,2)+WPz*VRRS(1,1,1,2)
            ! MIC-VRR: Generating [d0|s0]^(4)
            VRRS( 5,1,4,2)=PAx*VRRS(2,1,4,2)+r1x2Z*(VRRS(1,1,4,2)-ExZpE*VRRS(1,1,5,2))+WPx*VRRS(2,1,5,2)
            VRRS( 6,1,4,2)=PAx*VRRS(3,1,4,2)+WPx*VRRS(3,1,5,2)
            VRRS( 7,1,4,2)=PAy*VRRS(3,1,4,2)+r1x2Z*(VRRS(1,1,4,2)-ExZpE*VRRS(1,1,5,2))+WPy*VRRS(3,1,5,2)+r1x2Z*VRR(3,1,5)
            VRRS( 8,1,4,2)=PAx*VRRS(4,1,4,2)+WPx*VRRS(4,1,5,2)
            VRRS( 9,1,4,2)=PAy*VRRS(4,1,4,2)+WPy*VRRS(4,1,5,2)+r1x2Z*VRR(4,1,5)
            VRRS(10,1,4,2)=PAz*VRRS(4,1,4,2)+r1x2Z*(VRRS(1,1,4,2)-ExZpE*VRRS(1,1,5,2))+WPz*VRRS(4,1,5,2)
            ! MIC-VRR: Generating [d0|s0]^(3)
            VRRS( 5,1,3,2)=PAx*VRRS(2,1,3,2)+r1x2Z*(VRRS(1,1,3,2)-ExZpE*VRRS(1,1,4,2))+WPx*VRRS(2,1,4,2)
            VRRS( 6,1,3,2)=PAx*VRRS(3,1,3,2)+WPx*VRRS(3,1,4,2)
            VRRS( 7,1,3,2)=PAy*VRRS(3,1,3,2)+r1x2Z*(VRRS(1,1,3,2)-ExZpE*VRRS(1,1,4,2))+WPy*VRRS(3,1,4,2)+r1x2Z*VRR(3,1,4)
            VRRS( 8,1,3,2)=PAx*VRRS(4,1,3,2)+WPx*VRRS(4,1,4,2)
            VRRS( 9,1,3,2)=PAy*VRRS(4,1,3,2)+WPy*VRRS(4,1,4,2)+r1x2Z*VRR(4,1,4)
            VRRS(10,1,3,2)=PAz*VRRS(4,1,3,2)+r1x2Z*(VRRS(1,1,3,2)-ExZpE*VRRS(1,1,4,2))+WPz*VRRS(4,1,4,2)
            ! MIC-VRR: Generating [d0|s0]^(2)
            VRRS( 5,1,2,2)=PAx*VRRS(2,1,2,2)+r1x2Z*(VRRS(1,1,2,2)-ExZpE*VRRS(1,1,3,2))+WPx*VRRS(2,1,3,2)
            VRRS( 6,1,2,2)=PAx*VRRS(3,1,2,2)+WPx*VRRS(3,1,3,2)
            VRRS( 7,1,2,2)=PAy*VRRS(3,1,2,2)+r1x2Z*(VRRS(1,1,2,2)-ExZpE*VRRS(1,1,3,2))+WPy*VRRS(3,1,3,2)+r1x2Z*VRR(3,1,3)
            VRRS( 8,1,2,2)=PAx*VRRS(4,1,2,2)+WPx*VRRS(4,1,3,2)
            VRRS( 9,1,2,2)=PAy*VRRS(4,1,2,2)+WPy*VRRS(4,1,3,2)+r1x2Z*VRR(4,1,3)
            VRRS(10,1,2,2)=PAz*VRRS(4,1,2,2)+r1x2Z*(VRRS(1,1,2,2)-ExZpE*VRRS(1,1,3,2))+WPz*VRRS(4,1,3,2)
            ! MIC-VRR: Generating [d0|s0]^(1)
            VRRS( 5,1,1,2)=PAx*VRRS(2,1,1,2)+r1x2Z*(VRRS(1,1,1,2)-ExZpE*VRRS(1,1,2,2))+WPx*VRRS(2,1,2,2)
            VRRS( 6,1,1,2)=PAx*VRRS(3,1,1,2)+WPx*VRRS(3,1,2,2)
            VRRS( 7,1,1,2)=PAy*VRRS(3,1,1,2)+r1x2Z*(VRRS(1,1,1,2)-ExZpE*VRRS(1,1,2,2))+WPy*VRRS(3,1,2,2)+r1x2Z*VRR(3,1,2)
            VRRS( 8,1,1,2)=PAx*VRRS(4,1,1,2)+WPx*VRRS(4,1,2,2)
            VRRS( 9,1,1,2)=PAy*VRRS(4,1,1,2)+WPy*VRRS(4,1,2,2)+r1x2Z*VRR(4,1,2)
            VRRS(10,1,1,2)=PAz*VRRS(4,1,1,2)+r1x2Z*(VRRS(1,1,1,2)-ExZpE*VRRS(1,1,2,2))+WPz*VRRS(4,1,2,2)
            ! MIC-VRR: Generating [d0|s0]^(0)
            VRRS( 5,1,0,2)=PAx*VRRS(2,1,0,2)+r1x2Z*(VRRS(1,1,0,2)-ExZpE*VRRS(1,1,1,2))+WPx*VRRS(2,1,1,2)
            VRRS( 6,1,0,2)=PAx*VRRS(3,1,0,2)+WPx*VRRS(3,1,1,2)
            VRRS( 7,1,0,2)=PAy*VRRS(3,1,0,2)+r1x2Z*(VRRS(1,1,0,2)-ExZpE*VRRS(1,1,1,2))+WPy*VRRS(3,1,1,2)+r1x2Z*VRR(3,1,1)
            VRRS( 8,1,0,2)=PAx*VRRS(4,1,0,2)+WPx*VRRS(4,1,1,2)
            VRRS( 9,1,0,2)=PAy*VRRS(4,1,0,2)+WPy*VRRS(4,1,1,2)+r1x2Z*VRR(4,1,1)
            VRRS(10,1,0,2)=PAz*VRRS(4,1,0,2)+r1x2Z*(VRRS(1,1,0,2)-ExZpE*VRRS(1,1,1,2))+WPz*VRRS(4,1,1,2)
            ! MIC-VRR: Generating [f0|s0]^(3)
            CALL MVRRf0s0(2,84,1,VRRS(1,1,3,2),VRRS(1,1,4,2),120,4,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|s0]^(2)
            CALL MVRRf0s0(2,84,1,VRRS(1,1,2,2),VRRS(1,1,3,2),120,4,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|s0]^(1)
            CALL MVRRf0s0(2,84,1,VRRS(1,1,1,2),VRRS(1,1,2,2),120,4,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|s0]^(0)
            CALL MVRRf0s0(2,84,1,VRRS(1,1,0,2),VRRS(1,1,1,2),120,4,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|s0]^(2)
            CALL MVRRg0s0(2,84,1,VRRS(1,1,2,2),VRRS(1,1,3,2),120,4,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|s0]^(1)
            CALL MVRRg0s0(2,84,1,VRRS(1,1,1,2),VRRS(1,1,2,2),120,4,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|s0]^(0)
            CALL MVRRg0s0(2,84,1,VRRS(1,1,0,2),VRRS(1,1,1,2),120,4,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|s0]^(1)
            CALL MVRRh0s0(2,84,1,VRRS(1,1,1,2),VRRS(1,1,2,2),120,4,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|s0]^(0)
            CALL MVRRh0s0(2,84,1,VRRS(1,1,0,2),VRRS(1,1,1,2),120,4,VRR(1,1,1))
            ! MIC-VRR: Generating [i0|s0]^(0)
            CALL MVRRi0s0(2,84,1,VRRS(1,1,0,2),VRRS(1,1,1,2),120,4,VRR(1,1,1))
            ENDIF
            IF(PBC%AutoW%I(3).EQ.1) THEN
            VRRS(1,1,0,3)=PQz*VRR(1,1,1)
            VRRS(1,1,1,3)=PQz*VRR(1,1,2)
            VRRS(1,1,2,3)=PQz*VRR(1,1,3)
            VRRS(1,1,3,3)=PQz*VRR(1,1,4)
            VRRS(1,1,4,3)=PQz*VRR(1,1,5)
            VRRS(1,1,5,3)=PQz*VRR(1,1,6)
            VRRS(1,1,6,3)=PQz*VRR(1,1,7)
            ! MIC-VRR: Generating [p0|s0]^(5)
            VRRS(2,1,5,3)=PAx*VRRS(1,1,5,3)+WPx*VRRS(1,1,6,3)
            VRRS(3,1,5,3)=PAy*VRRS(1,1,5,3)+WPy*VRRS(1,1,6,3)
            VRRS(4,1,5,3)=PAz*VRRS(1,1,5,3)+WPz*VRRS(1,1,6,3)+r1x2Z*VRR(1,1,6)
            ! MIC-VRR: Generating [p0|s0]^(4)
            VRRS(2,1,4,3)=PAx*VRRS(1,1,4,3)+WPx*VRRS(1,1,5,3)
            VRRS(3,1,4,3)=PAy*VRRS(1,1,4,3)+WPy*VRRS(1,1,5,3)
            VRRS(4,1,4,3)=PAz*VRRS(1,1,4,3)+WPz*VRRS(1,1,5,3)+r1x2Z*VRR(1,1,5)
            ! MIC-VRR: Generating [p0|s0]^(3)
            VRRS(2,1,3,3)=PAx*VRRS(1,1,3,3)+WPx*VRRS(1,1,4,3)
            VRRS(3,1,3,3)=PAy*VRRS(1,1,3,3)+WPy*VRRS(1,1,4,3)
            VRRS(4,1,3,3)=PAz*VRRS(1,1,3,3)+WPz*VRRS(1,1,4,3)+r1x2Z*VRR(1,1,4)
            ! MIC-VRR: Generating [p0|s0]^(2)
            VRRS(2,1,2,3)=PAx*VRRS(1,1,2,3)+WPx*VRRS(1,1,3,3)
            VRRS(3,1,2,3)=PAy*VRRS(1,1,2,3)+WPy*VRRS(1,1,3,3)
            VRRS(4,1,2,3)=PAz*VRRS(1,1,2,3)+WPz*VRRS(1,1,3,3)+r1x2Z*VRR(1,1,3)
            ! MIC-VRR: Generating [p0|s0]^(1)
            VRRS(2,1,1,3)=PAx*VRRS(1,1,1,3)+WPx*VRRS(1,1,2,3)
            VRRS(3,1,1,3)=PAy*VRRS(1,1,1,3)+WPy*VRRS(1,1,2,3)
            VRRS(4,1,1,3)=PAz*VRRS(1,1,1,3)+WPz*VRRS(1,1,2,3)+r1x2Z*VRR(1,1,2)
            ! MIC-VRR: Generating [p0|s0]^(0)
            VRRS(2,1,0,3)=PAx*VRRS(1,1,0,3)+WPx*VRRS(1,1,1,3)
            VRRS(3,1,0,3)=PAy*VRRS(1,1,0,3)+WPy*VRRS(1,1,1,3)
            VRRS(4,1,0,3)=PAz*VRRS(1,1,0,3)+WPz*VRRS(1,1,1,3)+r1x2Z*VRR(1,1,1)
            ! MIC-VRR: Generating [d0|s0]^(4)
            VRRS( 5,1,4,3)=PAx*VRRS(2,1,4,3)+r1x2Z*(VRRS(1,1,4,3)-ExZpE*VRRS(1,1,5,3))+WPx*VRRS(2,1,5,3)
            VRRS( 6,1,4,3)=PAx*VRRS(3,1,4,3)+WPx*VRRS(3,1,5,3)
            VRRS( 7,1,4,3)=PAy*VRRS(3,1,4,3)+r1x2Z*(VRRS(1,1,4,3)-ExZpE*VRRS(1,1,5,3))+WPy*VRRS(3,1,5,3)
            VRRS( 8,1,4,3)=PAx*VRRS(4,1,4,3)+WPx*VRRS(4,1,5,3)
            VRRS( 9,1,4,3)=PAy*VRRS(4,1,4,3)+WPy*VRRS(4,1,5,3)
            VRRS(10,1,4,3)=PAz*VRRS(4,1,4,3)+r1x2Z*(VRRS(1,1,4,3)-ExZpE*VRRS(1,1,5,3))+WPz*VRRS(4,1,5,3)+r1x2Z*VRR(4,1,5)
            ! MIC-VRR: Generating [d0|s0]^(3)
            VRRS( 5,1,3,3)=PAx*VRRS(2,1,3,3)+r1x2Z*(VRRS(1,1,3,3)-ExZpE*VRRS(1,1,4,3))+WPx*VRRS(2,1,4,3)
            VRRS( 6,1,3,3)=PAx*VRRS(3,1,3,3)+WPx*VRRS(3,1,4,3)
            VRRS( 7,1,3,3)=PAy*VRRS(3,1,3,3)+r1x2Z*(VRRS(1,1,3,3)-ExZpE*VRRS(1,1,4,3))+WPy*VRRS(3,1,4,3)
            VRRS( 8,1,3,3)=PAx*VRRS(4,1,3,3)+WPx*VRRS(4,1,4,3)
            VRRS( 9,1,3,3)=PAy*VRRS(4,1,3,3)+WPy*VRRS(4,1,4,3)
            VRRS(10,1,3,3)=PAz*VRRS(4,1,3,3)+r1x2Z*(VRRS(1,1,3,3)-ExZpE*VRRS(1,1,4,3))+WPz*VRRS(4,1,4,3)+r1x2Z*VRR(4,1,4)
            ! MIC-VRR: Generating [d0|s0]^(2)
            VRRS( 5,1,2,3)=PAx*VRRS(2,1,2,3)+r1x2Z*(VRRS(1,1,2,3)-ExZpE*VRRS(1,1,3,3))+WPx*VRRS(2,1,3,3)
            VRRS( 6,1,2,3)=PAx*VRRS(3,1,2,3)+WPx*VRRS(3,1,3,3)
            VRRS( 7,1,2,3)=PAy*VRRS(3,1,2,3)+r1x2Z*(VRRS(1,1,2,3)-ExZpE*VRRS(1,1,3,3))+WPy*VRRS(3,1,3,3)
            VRRS( 8,1,2,3)=PAx*VRRS(4,1,2,3)+WPx*VRRS(4,1,3,3)
            VRRS( 9,1,2,3)=PAy*VRRS(4,1,2,3)+WPy*VRRS(4,1,3,3)
            VRRS(10,1,2,3)=PAz*VRRS(4,1,2,3)+r1x2Z*(VRRS(1,1,2,3)-ExZpE*VRRS(1,1,3,3))+WPz*VRRS(4,1,3,3)+r1x2Z*VRR(4,1,3)
            ! MIC-VRR: Generating [d0|s0]^(1)
            VRRS( 5,1,1,3)=PAx*VRRS(2,1,1,3)+r1x2Z*(VRRS(1,1,1,3)-ExZpE*VRRS(1,1,2,3))+WPx*VRRS(2,1,2,3)
            VRRS( 6,1,1,3)=PAx*VRRS(3,1,1,3)+WPx*VRRS(3,1,2,3)
            VRRS( 7,1,1,3)=PAy*VRRS(3,1,1,3)+r1x2Z*(VRRS(1,1,1,3)-ExZpE*VRRS(1,1,2,3))+WPy*VRRS(3,1,2,3)
            VRRS( 8,1,1,3)=PAx*VRRS(4,1,1,3)+WPx*VRRS(4,1,2,3)
            VRRS( 9,1,1,3)=PAy*VRRS(4,1,1,3)+WPy*VRRS(4,1,2,3)
            VRRS(10,1,1,3)=PAz*VRRS(4,1,1,3)+r1x2Z*(VRRS(1,1,1,3)-ExZpE*VRRS(1,1,2,3))+WPz*VRRS(4,1,2,3)+r1x2Z*VRR(4,1,2)
            ! MIC-VRR: Generating [d0|s0]^(0)
            VRRS( 5,1,0,3)=PAx*VRRS(2,1,0,3)+r1x2Z*(VRRS(1,1,0,3)-ExZpE*VRRS(1,1,1,3))+WPx*VRRS(2,1,1,3)
            VRRS( 6,1,0,3)=PAx*VRRS(3,1,0,3)+WPx*VRRS(3,1,1,3)
            VRRS( 7,1,0,3)=PAy*VRRS(3,1,0,3)+r1x2Z*(VRRS(1,1,0,3)-ExZpE*VRRS(1,1,1,3))+WPy*VRRS(3,1,1,3)
            VRRS( 8,1,0,3)=PAx*VRRS(4,1,0,3)+WPx*VRRS(4,1,1,3)
            VRRS( 9,1,0,3)=PAy*VRRS(4,1,0,3)+WPy*VRRS(4,1,1,3)
            VRRS(10,1,0,3)=PAz*VRRS(4,1,0,3)+r1x2Z*(VRRS(1,1,0,3)-ExZpE*VRRS(1,1,1,3))+WPz*VRRS(4,1,1,3)+r1x2Z*VRR(4,1,1)
            ! MIC-VRR: Generating [f0|s0]^(3)
            CALL MVRRf0s0(3,84,1,VRRS(1,1,3,3),VRRS(1,1,4,3),120,4,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|s0]^(2)
            CALL MVRRf0s0(3,84,1,VRRS(1,1,2,3),VRRS(1,1,3,3),120,4,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|s0]^(1)
            CALL MVRRf0s0(3,84,1,VRRS(1,1,1,3),VRRS(1,1,2,3),120,4,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|s0]^(0)
            CALL MVRRf0s0(3,84,1,VRRS(1,1,0,3),VRRS(1,1,1,3),120,4,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|s0]^(2)
            CALL MVRRg0s0(3,84,1,VRRS(1,1,2,3),VRRS(1,1,3,3),120,4,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|s0]^(1)
            CALL MVRRg0s0(3,84,1,VRRS(1,1,1,3),VRRS(1,1,2,3),120,4,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|s0]^(0)
            CALL MVRRg0s0(3,84,1,VRRS(1,1,0,3),VRRS(1,1,1,3),120,4,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|s0]^(1)
            CALL MVRRh0s0(3,84,1,VRRS(1,1,1,3),VRRS(1,1,2,3),120,4,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|s0]^(0)
            CALL MVRRh0s0(3,84,1,VRRS(1,1,0,3),VRRS(1,1,1,3),120,4,VRR(1,1,1))
            ! MIC-VRR: Generating [i0|s0]^(0)
            CALL MVRRi0s0(3,84,1,VRRS(1,1,0,3),VRRS(1,1,1,3),120,4,VRR(1,1,1))
            ENDIF
            ! Contracting ...
            CALL CNTRCTG101011(VRR,HRR,Alpha,HRRA,Beta,HRRB,Gamma,HRRC, &
                       VRRS,HRRS(1,1,1,1),PQJ(1),PBC%AutoW%I(1))
         ENDDO ! (M0| loop
      ENDDO ! |N0) loop
      ! Dont need to generate (i,0|s,s)
      ! Dont need to generate (j,0|s,s)^a
      ! Dont need to generate (j,0|s,s)^b
      ! Dont need to generate (i,0|p,s)^c
      ! Stress: No need to generate [f,0|s,s]
      DO L=1,1

         !K = 1
         CDOffSet=(OC+1-1)*LDC+(OD+L-1)*LDD
         ! Generating (f',f|1,L)  and (f,f'|1,L)
         CALL BraHRR1010ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,1,L),&
                      HRRA(1,1,L),HRRB(1,1,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,f|1_x,L)  and (f,f|1,L_x)
         CALL BraHRR1010cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRC(1,2,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,f|1_y,L)  and (f,f|1,L_y)
         CALL BraHRR1010cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRC(1,3,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,f|1_z,L)  and (f,f|1,L_z)
         CALL BraHRR1010cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRC(1,4,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
      ENDDO
      ! Stress: Generating (f,f|s,s)^(1)
      DO J=1,3
      DO I=1,3
      IJ=3*(J-1)+I
        DO L=1,1
          DO K=1,1
            CDOffSet=(OC+K-1)*LDC+(OD+L-1)*LDD
            CALL BraHRR1010(OA,OB,LDA,LDB,CDOffSet,HRRS(1,K,L,IJ),STRESS(1,IJ))
          ENDDO
        ENDDO
      ENDDO
      ENDDO
   END SUBROUTINE dIntB10100101
    SUBROUTINE CNTRCTG101011(VRR,HRR,Alpha,HRRA,Beta,HRRB,Gamma,HRRC,VRRS,HRRS,PQJ,IW)
      USE DerivedTypes
      USE VScratchB
      IMPLICIT NONE
      INTEGER :: K
      REAL(DOUBLE)  :: Alpha,Beta,Gamma
      REAL(DOUBLE), DIMENSION(84,1,1) :: HRR
      REAL(DOUBLE), DIMENSION(120,1,1) :: HRRA,HRRB
      REAL(DOUBLE), DIMENSION(84,4,1) :: HRRC
      REAL(DOUBLE)  :: VRR(120,4,0:7)
      REAL(DOUBLE)  :: VRRS(84,1,0:6,3)
      REAL(DOUBLE)  :: HRRS(84,1,1,9),PQJ(3)
      INTEGER :: IJ,J,I,IW(3)
      HRR(1,1,1)=HRR(1,1,1)+VRR(1,1,0)
      HRRA(1,1,1)=HRRA(1,1,1)+Alpha*VRR(1,1,0)
      HRRB(1,1,1)=HRRB(1,1,1)+Beta*VRR(1,1,0)
      HRRC(1,1,1)=HRRC(1,1,1)+Gamma*VRR(1,1,0)
      HRRC(1,2,1)=HRRC(1,2,1)+Gamma*VRR(1,2,0)
      HRRC(1,3,1)=HRRC(1,3,1)+Gamma*VRR(1,3,0)
      HRRC(1,4,1)=HRRC(1,4,1)+Gamma*VRR(1,4,0)
      HRR(2,1,1)=HRR(2,1,1)+VRR(2,1,0)
      HRRA(2,1,1)=HRRA(2,1,1)+Alpha*VRR(2,1,0)
      HRRB(2,1,1)=HRRB(2,1,1)+Beta*VRR(2,1,0)
      HRRC(2,1,1)=HRRC(2,1,1)+Gamma*VRR(2,1,0)
      HRRC(2,2,1)=HRRC(2,2,1)+Gamma*VRR(2,2,0)
      HRRC(2,3,1)=HRRC(2,3,1)+Gamma*VRR(2,3,0)
      HRRC(2,4,1)=HRRC(2,4,1)+Gamma*VRR(2,4,0)
      HRR(3,1,1)=HRR(3,1,1)+VRR(3,1,0)
      HRRA(3,1,1)=HRRA(3,1,1)+Alpha*VRR(3,1,0)
      HRRB(3,1,1)=HRRB(3,1,1)+Beta*VRR(3,1,0)
      HRRC(3,1,1)=HRRC(3,1,1)+Gamma*VRR(3,1,0)
      HRRC(3,2,1)=HRRC(3,2,1)+Gamma*VRR(3,2,0)
      HRRC(3,3,1)=HRRC(3,3,1)+Gamma*VRR(3,3,0)
      HRRC(3,4,1)=HRRC(3,4,1)+Gamma*VRR(3,4,0)
      HRR(4,1,1)=HRR(4,1,1)+VRR(4,1,0)
      HRRA(4,1,1)=HRRA(4,1,1)+Alpha*VRR(4,1,0)
      HRRB(4,1,1)=HRRB(4,1,1)+Beta*VRR(4,1,0)
      HRRC(4,1,1)=HRRC(4,1,1)+Gamma*VRR(4,1,0)
      HRRC(4,2,1)=HRRC(4,2,1)+Gamma*VRR(4,2,0)
      HRRC(4,3,1)=HRRC(4,3,1)+Gamma*VRR(4,3,0)
      HRRC(4,4,1)=HRRC(4,4,1)+Gamma*VRR(4,4,0)
      HRR(5,1,1)=HRR(5,1,1)+VRR(5,1,0)
      HRRA(5,1,1)=HRRA(5,1,1)+Alpha*VRR(5,1,0)
      HRRB(5,1,1)=HRRB(5,1,1)+Beta*VRR(5,1,0)
      HRRC(5,1,1)=HRRC(5,1,1)+Gamma*VRR(5,1,0)
      HRRC(5,2,1)=HRRC(5,2,1)+Gamma*VRR(5,2,0)
      HRRC(5,3,1)=HRRC(5,3,1)+Gamma*VRR(5,3,0)
      HRRC(5,4,1)=HRRC(5,4,1)+Gamma*VRR(5,4,0)
      HRR(6,1,1)=HRR(6,1,1)+VRR(6,1,0)
      HRRA(6,1,1)=HRRA(6,1,1)+Alpha*VRR(6,1,0)
      HRRB(6,1,1)=HRRB(6,1,1)+Beta*VRR(6,1,0)
      HRRC(6,1,1)=HRRC(6,1,1)+Gamma*VRR(6,1,0)
      HRRC(6,2,1)=HRRC(6,2,1)+Gamma*VRR(6,2,0)
      HRRC(6,3,1)=HRRC(6,3,1)+Gamma*VRR(6,3,0)
      HRRC(6,4,1)=HRRC(6,4,1)+Gamma*VRR(6,4,0)
      HRR(7,1,1)=HRR(7,1,1)+VRR(7,1,0)
      HRRA(7,1,1)=HRRA(7,1,1)+Alpha*VRR(7,1,0)
      HRRB(7,1,1)=HRRB(7,1,1)+Beta*VRR(7,1,0)
      HRRC(7,1,1)=HRRC(7,1,1)+Gamma*VRR(7,1,0)
      HRRC(7,2,1)=HRRC(7,2,1)+Gamma*VRR(7,2,0)
      HRRC(7,3,1)=HRRC(7,3,1)+Gamma*VRR(7,3,0)
      HRRC(7,4,1)=HRRC(7,4,1)+Gamma*VRR(7,4,0)
      HRR(8,1,1)=HRR(8,1,1)+VRR(8,1,0)
      HRRA(8,1,1)=HRRA(8,1,1)+Alpha*VRR(8,1,0)
      HRRB(8,1,1)=HRRB(8,1,1)+Beta*VRR(8,1,0)
      HRRC(8,1,1)=HRRC(8,1,1)+Gamma*VRR(8,1,0)
      HRRC(8,2,1)=HRRC(8,2,1)+Gamma*VRR(8,2,0)
      HRRC(8,3,1)=HRRC(8,3,1)+Gamma*VRR(8,3,0)
      HRRC(8,4,1)=HRRC(8,4,1)+Gamma*VRR(8,4,0)
      HRR(9,1,1)=HRR(9,1,1)+VRR(9,1,0)
      HRRA(9,1,1)=HRRA(9,1,1)+Alpha*VRR(9,1,0)
      HRRB(9,1,1)=HRRB(9,1,1)+Beta*VRR(9,1,0)
      HRRC(9,1,1)=HRRC(9,1,1)+Gamma*VRR(9,1,0)
      HRRC(9,2,1)=HRRC(9,2,1)+Gamma*VRR(9,2,0)
      HRRC(9,3,1)=HRRC(9,3,1)+Gamma*VRR(9,3,0)
      HRRC(9,4,1)=HRRC(9,4,1)+Gamma*VRR(9,4,0)
      HRR(10,1,1)=HRR(10,1,1)+VRR(10,1,0)
      HRRA(10,1,1)=HRRA(10,1,1)+Alpha*VRR(10,1,0)
      HRRB(10,1,1)=HRRB(10,1,1)+Beta*VRR(10,1,0)
      HRRC(10,1,1)=HRRC(10,1,1)+Gamma*VRR(10,1,0)
      HRRC(10,2,1)=HRRC(10,2,1)+Gamma*VRR(10,2,0)
      HRRC(10,3,1)=HRRC(10,3,1)+Gamma*VRR(10,3,0)
      HRRC(10,4,1)=HRRC(10,4,1)+Gamma*VRR(10,4,0)
      HRR(11,1,1)=HRR(11,1,1)+VRR(11,1,0)
      HRRA(11,1,1)=HRRA(11,1,1)+Alpha*VRR(11,1,0)
      HRRB(11,1,1)=HRRB(11,1,1)+Beta*VRR(11,1,0)
      HRRC(11,1,1)=HRRC(11,1,1)+Gamma*VRR(11,1,0)
      HRRC(11,2,1)=HRRC(11,2,1)+Gamma*VRR(11,2,0)
      HRRC(11,3,1)=HRRC(11,3,1)+Gamma*VRR(11,3,0)
      HRRC(11,4,1)=HRRC(11,4,1)+Gamma*VRR(11,4,0)
      HRR(12,1,1)=HRR(12,1,1)+VRR(12,1,0)
      HRRA(12,1,1)=HRRA(12,1,1)+Alpha*VRR(12,1,0)
      HRRB(12,1,1)=HRRB(12,1,1)+Beta*VRR(12,1,0)
      HRRC(12,1,1)=HRRC(12,1,1)+Gamma*VRR(12,1,0)
      HRRC(12,2,1)=HRRC(12,2,1)+Gamma*VRR(12,2,0)
      HRRC(12,3,1)=HRRC(12,3,1)+Gamma*VRR(12,3,0)
      HRRC(12,4,1)=HRRC(12,4,1)+Gamma*VRR(12,4,0)
      HRR(13,1,1)=HRR(13,1,1)+VRR(13,1,0)
      HRRA(13,1,1)=HRRA(13,1,1)+Alpha*VRR(13,1,0)
      HRRB(13,1,1)=HRRB(13,1,1)+Beta*VRR(13,1,0)
      HRRC(13,1,1)=HRRC(13,1,1)+Gamma*VRR(13,1,0)
      HRRC(13,2,1)=HRRC(13,2,1)+Gamma*VRR(13,2,0)
      HRRC(13,3,1)=HRRC(13,3,1)+Gamma*VRR(13,3,0)
      HRRC(13,4,1)=HRRC(13,4,1)+Gamma*VRR(13,4,0)
      HRR(14,1,1)=HRR(14,1,1)+VRR(14,1,0)
      HRRA(14,1,1)=HRRA(14,1,1)+Alpha*VRR(14,1,0)
      HRRB(14,1,1)=HRRB(14,1,1)+Beta*VRR(14,1,0)
      HRRC(14,1,1)=HRRC(14,1,1)+Gamma*VRR(14,1,0)
      HRRC(14,2,1)=HRRC(14,2,1)+Gamma*VRR(14,2,0)
      HRRC(14,3,1)=HRRC(14,3,1)+Gamma*VRR(14,3,0)
      HRRC(14,4,1)=HRRC(14,4,1)+Gamma*VRR(14,4,0)
      HRR(15,1,1)=HRR(15,1,1)+VRR(15,1,0)
      HRRA(15,1,1)=HRRA(15,1,1)+Alpha*VRR(15,1,0)
      HRRB(15,1,1)=HRRB(15,1,1)+Beta*VRR(15,1,0)
      HRRC(15,1,1)=HRRC(15,1,1)+Gamma*VRR(15,1,0)
      HRRC(15,2,1)=HRRC(15,2,1)+Gamma*VRR(15,2,0)
      HRRC(15,3,1)=HRRC(15,3,1)+Gamma*VRR(15,3,0)
      HRRC(15,4,1)=HRRC(15,4,1)+Gamma*VRR(15,4,0)
      HRR(16,1,1)=HRR(16,1,1)+VRR(16,1,0)
      HRRA(16,1,1)=HRRA(16,1,1)+Alpha*VRR(16,1,0)
      HRRB(16,1,1)=HRRB(16,1,1)+Beta*VRR(16,1,0)
      HRRC(16,1,1)=HRRC(16,1,1)+Gamma*VRR(16,1,0)
      HRRC(16,2,1)=HRRC(16,2,1)+Gamma*VRR(16,2,0)
      HRRC(16,3,1)=HRRC(16,3,1)+Gamma*VRR(16,3,0)
      HRRC(16,4,1)=HRRC(16,4,1)+Gamma*VRR(16,4,0)
      HRR(17,1,1)=HRR(17,1,1)+VRR(17,1,0)
      HRRA(17,1,1)=HRRA(17,1,1)+Alpha*VRR(17,1,0)
      HRRB(17,1,1)=HRRB(17,1,1)+Beta*VRR(17,1,0)
      HRRC(17,1,1)=HRRC(17,1,1)+Gamma*VRR(17,1,0)
      HRRC(17,2,1)=HRRC(17,2,1)+Gamma*VRR(17,2,0)
      HRRC(17,3,1)=HRRC(17,3,1)+Gamma*VRR(17,3,0)
      HRRC(17,4,1)=HRRC(17,4,1)+Gamma*VRR(17,4,0)
      HRR(18,1,1)=HRR(18,1,1)+VRR(18,1,0)
      HRRA(18,1,1)=HRRA(18,1,1)+Alpha*VRR(18,1,0)
      HRRB(18,1,1)=HRRB(18,1,1)+Beta*VRR(18,1,0)
      HRRC(18,1,1)=HRRC(18,1,1)+Gamma*VRR(18,1,0)
      HRRC(18,2,1)=HRRC(18,2,1)+Gamma*VRR(18,2,0)
      HRRC(18,3,1)=HRRC(18,3,1)+Gamma*VRR(18,3,0)
      HRRC(18,4,1)=HRRC(18,4,1)+Gamma*VRR(18,4,0)
      HRR(19,1,1)=HRR(19,1,1)+VRR(19,1,0)
      HRRA(19,1,1)=HRRA(19,1,1)+Alpha*VRR(19,1,0)
      HRRB(19,1,1)=HRRB(19,1,1)+Beta*VRR(19,1,0)
      HRRC(19,1,1)=HRRC(19,1,1)+Gamma*VRR(19,1,0)
      HRRC(19,2,1)=HRRC(19,2,1)+Gamma*VRR(19,2,0)
      HRRC(19,3,1)=HRRC(19,3,1)+Gamma*VRR(19,3,0)
      HRRC(19,4,1)=HRRC(19,4,1)+Gamma*VRR(19,4,0)
      HRR(20,1,1)=HRR(20,1,1)+VRR(20,1,0)
      HRRA(20,1,1)=HRRA(20,1,1)+Alpha*VRR(20,1,0)
      HRRB(20,1,1)=HRRB(20,1,1)+Beta*VRR(20,1,0)
      HRRC(20,1,1)=HRRC(20,1,1)+Gamma*VRR(20,1,0)
      HRRC(20,2,1)=HRRC(20,2,1)+Gamma*VRR(20,2,0)
      HRRC(20,3,1)=HRRC(20,3,1)+Gamma*VRR(20,3,0)
      HRRC(20,4,1)=HRRC(20,4,1)+Gamma*VRR(20,4,0)
      HRR(21,1,1)=HRR(21,1,1)+VRR(21,1,0)
      HRRA(21,1,1)=HRRA(21,1,1)+Alpha*VRR(21,1,0)
      HRRB(21,1,1)=HRRB(21,1,1)+Beta*VRR(21,1,0)
      HRRC(21,1,1)=HRRC(21,1,1)+Gamma*VRR(21,1,0)
      HRRC(21,2,1)=HRRC(21,2,1)+Gamma*VRR(21,2,0)
      HRRC(21,3,1)=HRRC(21,3,1)+Gamma*VRR(21,3,0)
      HRRC(21,4,1)=HRRC(21,4,1)+Gamma*VRR(21,4,0)
      HRR(22,1,1)=HRR(22,1,1)+VRR(22,1,0)
      HRRA(22,1,1)=HRRA(22,1,1)+Alpha*VRR(22,1,0)
      HRRB(22,1,1)=HRRB(22,1,1)+Beta*VRR(22,1,0)
      HRRC(22,1,1)=HRRC(22,1,1)+Gamma*VRR(22,1,0)
      HRRC(22,2,1)=HRRC(22,2,1)+Gamma*VRR(22,2,0)
      HRRC(22,3,1)=HRRC(22,3,1)+Gamma*VRR(22,3,0)
      HRRC(22,4,1)=HRRC(22,4,1)+Gamma*VRR(22,4,0)
      HRR(23,1,1)=HRR(23,1,1)+VRR(23,1,0)
      HRRA(23,1,1)=HRRA(23,1,1)+Alpha*VRR(23,1,0)
      HRRB(23,1,1)=HRRB(23,1,1)+Beta*VRR(23,1,0)
      HRRC(23,1,1)=HRRC(23,1,1)+Gamma*VRR(23,1,0)
      HRRC(23,2,1)=HRRC(23,2,1)+Gamma*VRR(23,2,0)
      HRRC(23,3,1)=HRRC(23,3,1)+Gamma*VRR(23,3,0)
      HRRC(23,4,1)=HRRC(23,4,1)+Gamma*VRR(23,4,0)
      HRR(24,1,1)=HRR(24,1,1)+VRR(24,1,0)
      HRRA(24,1,1)=HRRA(24,1,1)+Alpha*VRR(24,1,0)
      HRRB(24,1,1)=HRRB(24,1,1)+Beta*VRR(24,1,0)
      HRRC(24,1,1)=HRRC(24,1,1)+Gamma*VRR(24,1,0)
      HRRC(24,2,1)=HRRC(24,2,1)+Gamma*VRR(24,2,0)
      HRRC(24,3,1)=HRRC(24,3,1)+Gamma*VRR(24,3,0)
      HRRC(24,4,1)=HRRC(24,4,1)+Gamma*VRR(24,4,0)
      HRR(25,1,1)=HRR(25,1,1)+VRR(25,1,0)
      HRRA(25,1,1)=HRRA(25,1,1)+Alpha*VRR(25,1,0)
      HRRB(25,1,1)=HRRB(25,1,1)+Beta*VRR(25,1,0)
      HRRC(25,1,1)=HRRC(25,1,1)+Gamma*VRR(25,1,0)
      HRRC(25,2,1)=HRRC(25,2,1)+Gamma*VRR(25,2,0)
      HRRC(25,3,1)=HRRC(25,3,1)+Gamma*VRR(25,3,0)
      HRRC(25,4,1)=HRRC(25,4,1)+Gamma*VRR(25,4,0)
      HRR(26,1,1)=HRR(26,1,1)+VRR(26,1,0)
      HRRA(26,1,1)=HRRA(26,1,1)+Alpha*VRR(26,1,0)
      HRRB(26,1,1)=HRRB(26,1,1)+Beta*VRR(26,1,0)
      HRRC(26,1,1)=HRRC(26,1,1)+Gamma*VRR(26,1,0)
      HRRC(26,2,1)=HRRC(26,2,1)+Gamma*VRR(26,2,0)
      HRRC(26,3,1)=HRRC(26,3,1)+Gamma*VRR(26,3,0)
      HRRC(26,4,1)=HRRC(26,4,1)+Gamma*VRR(26,4,0)
      HRR(27,1,1)=HRR(27,1,1)+VRR(27,1,0)
      HRRA(27,1,1)=HRRA(27,1,1)+Alpha*VRR(27,1,0)
      HRRB(27,1,1)=HRRB(27,1,1)+Beta*VRR(27,1,0)
      HRRC(27,1,1)=HRRC(27,1,1)+Gamma*VRR(27,1,0)
      HRRC(27,2,1)=HRRC(27,2,1)+Gamma*VRR(27,2,0)
      HRRC(27,3,1)=HRRC(27,3,1)+Gamma*VRR(27,3,0)
      HRRC(27,4,1)=HRRC(27,4,1)+Gamma*VRR(27,4,0)
      HRR(28,1,1)=HRR(28,1,1)+VRR(28,1,0)
      HRRA(28,1,1)=HRRA(28,1,1)+Alpha*VRR(28,1,0)
      HRRB(28,1,1)=HRRB(28,1,1)+Beta*VRR(28,1,0)
      HRRC(28,1,1)=HRRC(28,1,1)+Gamma*VRR(28,1,0)
      HRRC(28,2,1)=HRRC(28,2,1)+Gamma*VRR(28,2,0)
      HRRC(28,3,1)=HRRC(28,3,1)+Gamma*VRR(28,3,0)
      HRRC(28,4,1)=HRRC(28,4,1)+Gamma*VRR(28,4,0)
      HRR(29,1,1)=HRR(29,1,1)+VRR(29,1,0)
      HRRA(29,1,1)=HRRA(29,1,1)+Alpha*VRR(29,1,0)
      HRRB(29,1,1)=HRRB(29,1,1)+Beta*VRR(29,1,0)
      HRRC(29,1,1)=HRRC(29,1,1)+Gamma*VRR(29,1,0)
      HRRC(29,2,1)=HRRC(29,2,1)+Gamma*VRR(29,2,0)
      HRRC(29,3,1)=HRRC(29,3,1)+Gamma*VRR(29,3,0)
      HRRC(29,4,1)=HRRC(29,4,1)+Gamma*VRR(29,4,0)
      HRR(30,1,1)=HRR(30,1,1)+VRR(30,1,0)
      HRRA(30,1,1)=HRRA(30,1,1)+Alpha*VRR(30,1,0)
      HRRB(30,1,1)=HRRB(30,1,1)+Beta*VRR(30,1,0)
      HRRC(30,1,1)=HRRC(30,1,1)+Gamma*VRR(30,1,0)
      HRRC(30,2,1)=HRRC(30,2,1)+Gamma*VRR(30,2,0)
      HRRC(30,3,1)=HRRC(30,3,1)+Gamma*VRR(30,3,0)
      HRRC(30,4,1)=HRRC(30,4,1)+Gamma*VRR(30,4,0)
      HRR(31,1,1)=HRR(31,1,1)+VRR(31,1,0)
      HRRA(31,1,1)=HRRA(31,1,1)+Alpha*VRR(31,1,0)
      HRRB(31,1,1)=HRRB(31,1,1)+Beta*VRR(31,1,0)
      HRRC(31,1,1)=HRRC(31,1,1)+Gamma*VRR(31,1,0)
      HRRC(31,2,1)=HRRC(31,2,1)+Gamma*VRR(31,2,0)
      HRRC(31,3,1)=HRRC(31,3,1)+Gamma*VRR(31,3,0)
      HRRC(31,4,1)=HRRC(31,4,1)+Gamma*VRR(31,4,0)
      HRR(32,1,1)=HRR(32,1,1)+VRR(32,1,0)
      HRRA(32,1,1)=HRRA(32,1,1)+Alpha*VRR(32,1,0)
      HRRB(32,1,1)=HRRB(32,1,1)+Beta*VRR(32,1,0)
      HRRC(32,1,1)=HRRC(32,1,1)+Gamma*VRR(32,1,0)
      HRRC(32,2,1)=HRRC(32,2,1)+Gamma*VRR(32,2,0)
      HRRC(32,3,1)=HRRC(32,3,1)+Gamma*VRR(32,3,0)
      HRRC(32,4,1)=HRRC(32,4,1)+Gamma*VRR(32,4,0)
      HRR(33,1,1)=HRR(33,1,1)+VRR(33,1,0)
      HRRA(33,1,1)=HRRA(33,1,1)+Alpha*VRR(33,1,0)
      HRRB(33,1,1)=HRRB(33,1,1)+Beta*VRR(33,1,0)
      HRRC(33,1,1)=HRRC(33,1,1)+Gamma*VRR(33,1,0)
      HRRC(33,2,1)=HRRC(33,2,1)+Gamma*VRR(33,2,0)
      HRRC(33,3,1)=HRRC(33,3,1)+Gamma*VRR(33,3,0)
      HRRC(33,4,1)=HRRC(33,4,1)+Gamma*VRR(33,4,0)
      HRR(34,1,1)=HRR(34,1,1)+VRR(34,1,0)
      HRRA(34,1,1)=HRRA(34,1,1)+Alpha*VRR(34,1,0)
      HRRB(34,1,1)=HRRB(34,1,1)+Beta*VRR(34,1,0)
      HRRC(34,1,1)=HRRC(34,1,1)+Gamma*VRR(34,1,0)
      HRRC(34,2,1)=HRRC(34,2,1)+Gamma*VRR(34,2,0)
      HRRC(34,3,1)=HRRC(34,3,1)+Gamma*VRR(34,3,0)
      HRRC(34,4,1)=HRRC(34,4,1)+Gamma*VRR(34,4,0)
      HRR(35,1,1)=HRR(35,1,1)+VRR(35,1,0)
      HRRA(35,1,1)=HRRA(35,1,1)+Alpha*VRR(35,1,0)
      HRRB(35,1,1)=HRRB(35,1,1)+Beta*VRR(35,1,0)
      HRRC(35,1,1)=HRRC(35,1,1)+Gamma*VRR(35,1,0)
      HRRC(35,2,1)=HRRC(35,2,1)+Gamma*VRR(35,2,0)
      HRRC(35,3,1)=HRRC(35,3,1)+Gamma*VRR(35,3,0)
      HRRC(35,4,1)=HRRC(35,4,1)+Gamma*VRR(35,4,0)
      HRR(36,1,1)=HRR(36,1,1)+VRR(36,1,0)
      HRRA(36,1,1)=HRRA(36,1,1)+Alpha*VRR(36,1,0)
      HRRB(36,1,1)=HRRB(36,1,1)+Beta*VRR(36,1,0)
      HRRC(36,1,1)=HRRC(36,1,1)+Gamma*VRR(36,1,0)
      HRRC(36,2,1)=HRRC(36,2,1)+Gamma*VRR(36,2,0)
      HRRC(36,3,1)=HRRC(36,3,1)+Gamma*VRR(36,3,0)
      HRRC(36,4,1)=HRRC(36,4,1)+Gamma*VRR(36,4,0)
      HRR(37,1,1)=HRR(37,1,1)+VRR(37,1,0)
      HRRA(37,1,1)=HRRA(37,1,1)+Alpha*VRR(37,1,0)
      HRRB(37,1,1)=HRRB(37,1,1)+Beta*VRR(37,1,0)
      HRRC(37,1,1)=HRRC(37,1,1)+Gamma*VRR(37,1,0)
      HRRC(37,2,1)=HRRC(37,2,1)+Gamma*VRR(37,2,0)
      HRRC(37,3,1)=HRRC(37,3,1)+Gamma*VRR(37,3,0)
      HRRC(37,4,1)=HRRC(37,4,1)+Gamma*VRR(37,4,0)
      HRR(38,1,1)=HRR(38,1,1)+VRR(38,1,0)
      HRRA(38,1,1)=HRRA(38,1,1)+Alpha*VRR(38,1,0)
      HRRB(38,1,1)=HRRB(38,1,1)+Beta*VRR(38,1,0)
      HRRC(38,1,1)=HRRC(38,1,1)+Gamma*VRR(38,1,0)
      HRRC(38,2,1)=HRRC(38,2,1)+Gamma*VRR(38,2,0)
      HRRC(38,3,1)=HRRC(38,3,1)+Gamma*VRR(38,3,0)
      HRRC(38,4,1)=HRRC(38,4,1)+Gamma*VRR(38,4,0)
      HRR(39,1,1)=HRR(39,1,1)+VRR(39,1,0)
      HRRA(39,1,1)=HRRA(39,1,1)+Alpha*VRR(39,1,0)
      HRRB(39,1,1)=HRRB(39,1,1)+Beta*VRR(39,1,0)
      HRRC(39,1,1)=HRRC(39,1,1)+Gamma*VRR(39,1,0)
      HRRC(39,2,1)=HRRC(39,2,1)+Gamma*VRR(39,2,0)
      HRRC(39,3,1)=HRRC(39,3,1)+Gamma*VRR(39,3,0)
      HRRC(39,4,1)=HRRC(39,4,1)+Gamma*VRR(39,4,0)
      HRR(40,1,1)=HRR(40,1,1)+VRR(40,1,0)
      HRRA(40,1,1)=HRRA(40,1,1)+Alpha*VRR(40,1,0)
      HRRB(40,1,1)=HRRB(40,1,1)+Beta*VRR(40,1,0)
      HRRC(40,1,1)=HRRC(40,1,1)+Gamma*VRR(40,1,0)
      HRRC(40,2,1)=HRRC(40,2,1)+Gamma*VRR(40,2,0)
      HRRC(40,3,1)=HRRC(40,3,1)+Gamma*VRR(40,3,0)
      HRRC(40,4,1)=HRRC(40,4,1)+Gamma*VRR(40,4,0)
      HRR(41,1,1)=HRR(41,1,1)+VRR(41,1,0)
      HRRA(41,1,1)=HRRA(41,1,1)+Alpha*VRR(41,1,0)
      HRRB(41,1,1)=HRRB(41,1,1)+Beta*VRR(41,1,0)
      HRRC(41,1,1)=HRRC(41,1,1)+Gamma*VRR(41,1,0)
      HRRC(41,2,1)=HRRC(41,2,1)+Gamma*VRR(41,2,0)
      HRRC(41,3,1)=HRRC(41,3,1)+Gamma*VRR(41,3,0)
      HRRC(41,4,1)=HRRC(41,4,1)+Gamma*VRR(41,4,0)
      HRR(42,1,1)=HRR(42,1,1)+VRR(42,1,0)
      HRRA(42,1,1)=HRRA(42,1,1)+Alpha*VRR(42,1,0)
      HRRB(42,1,1)=HRRB(42,1,1)+Beta*VRR(42,1,0)
      HRRC(42,1,1)=HRRC(42,1,1)+Gamma*VRR(42,1,0)
      HRRC(42,2,1)=HRRC(42,2,1)+Gamma*VRR(42,2,0)
      HRRC(42,3,1)=HRRC(42,3,1)+Gamma*VRR(42,3,0)
      HRRC(42,4,1)=HRRC(42,4,1)+Gamma*VRR(42,4,0)
      HRR(43,1,1)=HRR(43,1,1)+VRR(43,1,0)
      HRRA(43,1,1)=HRRA(43,1,1)+Alpha*VRR(43,1,0)
      HRRB(43,1,1)=HRRB(43,1,1)+Beta*VRR(43,1,0)
      HRRC(43,1,1)=HRRC(43,1,1)+Gamma*VRR(43,1,0)
      HRRC(43,2,1)=HRRC(43,2,1)+Gamma*VRR(43,2,0)
      HRRC(43,3,1)=HRRC(43,3,1)+Gamma*VRR(43,3,0)
      HRRC(43,4,1)=HRRC(43,4,1)+Gamma*VRR(43,4,0)
      HRR(44,1,1)=HRR(44,1,1)+VRR(44,1,0)
      HRRA(44,1,1)=HRRA(44,1,1)+Alpha*VRR(44,1,0)
      HRRB(44,1,1)=HRRB(44,1,1)+Beta*VRR(44,1,0)
      HRRC(44,1,1)=HRRC(44,1,1)+Gamma*VRR(44,1,0)
      HRRC(44,2,1)=HRRC(44,2,1)+Gamma*VRR(44,2,0)
      HRRC(44,3,1)=HRRC(44,3,1)+Gamma*VRR(44,3,0)
      HRRC(44,4,1)=HRRC(44,4,1)+Gamma*VRR(44,4,0)
      HRR(45,1,1)=HRR(45,1,1)+VRR(45,1,0)
      HRRA(45,1,1)=HRRA(45,1,1)+Alpha*VRR(45,1,0)
      HRRB(45,1,1)=HRRB(45,1,1)+Beta*VRR(45,1,0)
      HRRC(45,1,1)=HRRC(45,1,1)+Gamma*VRR(45,1,0)
      HRRC(45,2,1)=HRRC(45,2,1)+Gamma*VRR(45,2,0)
      HRRC(45,3,1)=HRRC(45,3,1)+Gamma*VRR(45,3,0)
      HRRC(45,4,1)=HRRC(45,4,1)+Gamma*VRR(45,4,0)
      HRR(46,1,1)=HRR(46,1,1)+VRR(46,1,0)
      HRRA(46,1,1)=HRRA(46,1,1)+Alpha*VRR(46,1,0)
      HRRB(46,1,1)=HRRB(46,1,1)+Beta*VRR(46,1,0)
      HRRC(46,1,1)=HRRC(46,1,1)+Gamma*VRR(46,1,0)
      HRRC(46,2,1)=HRRC(46,2,1)+Gamma*VRR(46,2,0)
      HRRC(46,3,1)=HRRC(46,3,1)+Gamma*VRR(46,3,0)
      HRRC(46,4,1)=HRRC(46,4,1)+Gamma*VRR(46,4,0)
      HRR(47,1,1)=HRR(47,1,1)+VRR(47,1,0)
      HRRA(47,1,1)=HRRA(47,1,1)+Alpha*VRR(47,1,0)
      HRRB(47,1,1)=HRRB(47,1,1)+Beta*VRR(47,1,0)
      HRRC(47,1,1)=HRRC(47,1,1)+Gamma*VRR(47,1,0)
      HRRC(47,2,1)=HRRC(47,2,1)+Gamma*VRR(47,2,0)
      HRRC(47,3,1)=HRRC(47,3,1)+Gamma*VRR(47,3,0)
      HRRC(47,4,1)=HRRC(47,4,1)+Gamma*VRR(47,4,0)
      HRR(48,1,1)=HRR(48,1,1)+VRR(48,1,0)
      HRRA(48,1,1)=HRRA(48,1,1)+Alpha*VRR(48,1,0)
      HRRB(48,1,1)=HRRB(48,1,1)+Beta*VRR(48,1,0)
      HRRC(48,1,1)=HRRC(48,1,1)+Gamma*VRR(48,1,0)
      HRRC(48,2,1)=HRRC(48,2,1)+Gamma*VRR(48,2,0)
      HRRC(48,3,1)=HRRC(48,3,1)+Gamma*VRR(48,3,0)
      HRRC(48,4,1)=HRRC(48,4,1)+Gamma*VRR(48,4,0)
      HRR(49,1,1)=HRR(49,1,1)+VRR(49,1,0)
      HRRA(49,1,1)=HRRA(49,1,1)+Alpha*VRR(49,1,0)
      HRRB(49,1,1)=HRRB(49,1,1)+Beta*VRR(49,1,0)
      HRRC(49,1,1)=HRRC(49,1,1)+Gamma*VRR(49,1,0)
      HRRC(49,2,1)=HRRC(49,2,1)+Gamma*VRR(49,2,0)
      HRRC(49,3,1)=HRRC(49,3,1)+Gamma*VRR(49,3,0)
      HRRC(49,4,1)=HRRC(49,4,1)+Gamma*VRR(49,4,0)
      HRR(50,1,1)=HRR(50,1,1)+VRR(50,1,0)
      HRRA(50,1,1)=HRRA(50,1,1)+Alpha*VRR(50,1,0)
      HRRB(50,1,1)=HRRB(50,1,1)+Beta*VRR(50,1,0)
      HRRC(50,1,1)=HRRC(50,1,1)+Gamma*VRR(50,1,0)
      HRRC(50,2,1)=HRRC(50,2,1)+Gamma*VRR(50,2,0)
      HRRC(50,3,1)=HRRC(50,3,1)+Gamma*VRR(50,3,0)
      HRRC(50,4,1)=HRRC(50,4,1)+Gamma*VRR(50,4,0)
      HRR(51,1,1)=HRR(51,1,1)+VRR(51,1,0)
      HRRA(51,1,1)=HRRA(51,1,1)+Alpha*VRR(51,1,0)
      HRRB(51,1,1)=HRRB(51,1,1)+Beta*VRR(51,1,0)
      HRRC(51,1,1)=HRRC(51,1,1)+Gamma*VRR(51,1,0)
      HRRC(51,2,1)=HRRC(51,2,1)+Gamma*VRR(51,2,0)
      HRRC(51,3,1)=HRRC(51,3,1)+Gamma*VRR(51,3,0)
      HRRC(51,4,1)=HRRC(51,4,1)+Gamma*VRR(51,4,0)
      HRR(52,1,1)=HRR(52,1,1)+VRR(52,1,0)
      HRRA(52,1,1)=HRRA(52,1,1)+Alpha*VRR(52,1,0)
      HRRB(52,1,1)=HRRB(52,1,1)+Beta*VRR(52,1,0)
      HRRC(52,1,1)=HRRC(52,1,1)+Gamma*VRR(52,1,0)
      HRRC(52,2,1)=HRRC(52,2,1)+Gamma*VRR(52,2,0)
      HRRC(52,3,1)=HRRC(52,3,1)+Gamma*VRR(52,3,0)
      HRRC(52,4,1)=HRRC(52,4,1)+Gamma*VRR(52,4,0)
      HRR(53,1,1)=HRR(53,1,1)+VRR(53,1,0)
      HRRA(53,1,1)=HRRA(53,1,1)+Alpha*VRR(53,1,0)
      HRRB(53,1,1)=HRRB(53,1,1)+Beta*VRR(53,1,0)
      HRRC(53,1,1)=HRRC(53,1,1)+Gamma*VRR(53,1,0)
      HRRC(53,2,1)=HRRC(53,2,1)+Gamma*VRR(53,2,0)
      HRRC(53,3,1)=HRRC(53,3,1)+Gamma*VRR(53,3,0)
      HRRC(53,4,1)=HRRC(53,4,1)+Gamma*VRR(53,4,0)
      HRR(54,1,1)=HRR(54,1,1)+VRR(54,1,0)
      HRRA(54,1,1)=HRRA(54,1,1)+Alpha*VRR(54,1,0)
      HRRB(54,1,1)=HRRB(54,1,1)+Beta*VRR(54,1,0)
      HRRC(54,1,1)=HRRC(54,1,1)+Gamma*VRR(54,1,0)
      HRRC(54,2,1)=HRRC(54,2,1)+Gamma*VRR(54,2,0)
      HRRC(54,3,1)=HRRC(54,3,1)+Gamma*VRR(54,3,0)
      HRRC(54,4,1)=HRRC(54,4,1)+Gamma*VRR(54,4,0)
      HRR(55,1,1)=HRR(55,1,1)+VRR(55,1,0)
      HRRA(55,1,1)=HRRA(55,1,1)+Alpha*VRR(55,1,0)
      HRRB(55,1,1)=HRRB(55,1,1)+Beta*VRR(55,1,0)
      HRRC(55,1,1)=HRRC(55,1,1)+Gamma*VRR(55,1,0)
      HRRC(55,2,1)=HRRC(55,2,1)+Gamma*VRR(55,2,0)
      HRRC(55,3,1)=HRRC(55,3,1)+Gamma*VRR(55,3,0)
      HRRC(55,4,1)=HRRC(55,4,1)+Gamma*VRR(55,4,0)
      HRR(56,1,1)=HRR(56,1,1)+VRR(56,1,0)
      HRRA(56,1,1)=HRRA(56,1,1)+Alpha*VRR(56,1,0)
      HRRB(56,1,1)=HRRB(56,1,1)+Beta*VRR(56,1,0)
      HRRC(56,1,1)=HRRC(56,1,1)+Gamma*VRR(56,1,0)
      HRRC(56,2,1)=HRRC(56,2,1)+Gamma*VRR(56,2,0)
      HRRC(56,3,1)=HRRC(56,3,1)+Gamma*VRR(56,3,0)
      HRRC(56,4,1)=HRRC(56,4,1)+Gamma*VRR(56,4,0)
      HRR(57,1,1)=HRR(57,1,1)+VRR(57,1,0)
      HRRA(57,1,1)=HRRA(57,1,1)+Alpha*VRR(57,1,0)
      HRRB(57,1,1)=HRRB(57,1,1)+Beta*VRR(57,1,0)
      HRRC(57,1,1)=HRRC(57,1,1)+Gamma*VRR(57,1,0)
      HRRC(57,2,1)=HRRC(57,2,1)+Gamma*VRR(57,2,0)
      HRRC(57,3,1)=HRRC(57,3,1)+Gamma*VRR(57,3,0)
      HRRC(57,4,1)=HRRC(57,4,1)+Gamma*VRR(57,4,0)
      HRR(58,1,1)=HRR(58,1,1)+VRR(58,1,0)
      HRRA(58,1,1)=HRRA(58,1,1)+Alpha*VRR(58,1,0)
      HRRB(58,1,1)=HRRB(58,1,1)+Beta*VRR(58,1,0)
      HRRC(58,1,1)=HRRC(58,1,1)+Gamma*VRR(58,1,0)
      HRRC(58,2,1)=HRRC(58,2,1)+Gamma*VRR(58,2,0)
      HRRC(58,3,1)=HRRC(58,3,1)+Gamma*VRR(58,3,0)
      HRRC(58,4,1)=HRRC(58,4,1)+Gamma*VRR(58,4,0)
      HRR(59,1,1)=HRR(59,1,1)+VRR(59,1,0)
      HRRA(59,1,1)=HRRA(59,1,1)+Alpha*VRR(59,1,0)
      HRRB(59,1,1)=HRRB(59,1,1)+Beta*VRR(59,1,0)
      HRRC(59,1,1)=HRRC(59,1,1)+Gamma*VRR(59,1,0)
      HRRC(59,2,1)=HRRC(59,2,1)+Gamma*VRR(59,2,0)
      HRRC(59,3,1)=HRRC(59,3,1)+Gamma*VRR(59,3,0)
      HRRC(59,4,1)=HRRC(59,4,1)+Gamma*VRR(59,4,0)
      HRR(60,1,1)=HRR(60,1,1)+VRR(60,1,0)
      HRRA(60,1,1)=HRRA(60,1,1)+Alpha*VRR(60,1,0)
      HRRB(60,1,1)=HRRB(60,1,1)+Beta*VRR(60,1,0)
      HRRC(60,1,1)=HRRC(60,1,1)+Gamma*VRR(60,1,0)
      HRRC(60,2,1)=HRRC(60,2,1)+Gamma*VRR(60,2,0)
      HRRC(60,3,1)=HRRC(60,3,1)+Gamma*VRR(60,3,0)
      HRRC(60,4,1)=HRRC(60,4,1)+Gamma*VRR(60,4,0)
      HRR(61,1,1)=HRR(61,1,1)+VRR(61,1,0)
      HRRA(61,1,1)=HRRA(61,1,1)+Alpha*VRR(61,1,0)
      HRRB(61,1,1)=HRRB(61,1,1)+Beta*VRR(61,1,0)
      HRRC(61,1,1)=HRRC(61,1,1)+Gamma*VRR(61,1,0)
      HRRC(61,2,1)=HRRC(61,2,1)+Gamma*VRR(61,2,0)
      HRRC(61,3,1)=HRRC(61,3,1)+Gamma*VRR(61,3,0)
      HRRC(61,4,1)=HRRC(61,4,1)+Gamma*VRR(61,4,0)
      HRR(62,1,1)=HRR(62,1,1)+VRR(62,1,0)
      HRRA(62,1,1)=HRRA(62,1,1)+Alpha*VRR(62,1,0)
      HRRB(62,1,1)=HRRB(62,1,1)+Beta*VRR(62,1,0)
      HRRC(62,1,1)=HRRC(62,1,1)+Gamma*VRR(62,1,0)
      HRRC(62,2,1)=HRRC(62,2,1)+Gamma*VRR(62,2,0)
      HRRC(62,3,1)=HRRC(62,3,1)+Gamma*VRR(62,3,0)
      HRRC(62,4,1)=HRRC(62,4,1)+Gamma*VRR(62,4,0)
      HRR(63,1,1)=HRR(63,1,1)+VRR(63,1,0)
      HRRA(63,1,1)=HRRA(63,1,1)+Alpha*VRR(63,1,0)
      HRRB(63,1,1)=HRRB(63,1,1)+Beta*VRR(63,1,0)
      HRRC(63,1,1)=HRRC(63,1,1)+Gamma*VRR(63,1,0)
      HRRC(63,2,1)=HRRC(63,2,1)+Gamma*VRR(63,2,0)
      HRRC(63,3,1)=HRRC(63,3,1)+Gamma*VRR(63,3,0)
      HRRC(63,4,1)=HRRC(63,4,1)+Gamma*VRR(63,4,0)
      HRR(64,1,1)=HRR(64,1,1)+VRR(64,1,0)
      HRRA(64,1,1)=HRRA(64,1,1)+Alpha*VRR(64,1,0)
      HRRB(64,1,1)=HRRB(64,1,1)+Beta*VRR(64,1,0)
      HRRC(64,1,1)=HRRC(64,1,1)+Gamma*VRR(64,1,0)
      HRRC(64,2,1)=HRRC(64,2,1)+Gamma*VRR(64,2,0)
      HRRC(64,3,1)=HRRC(64,3,1)+Gamma*VRR(64,3,0)
      HRRC(64,4,1)=HRRC(64,4,1)+Gamma*VRR(64,4,0)
      HRR(65,1,1)=HRR(65,1,1)+VRR(65,1,0)
      HRRA(65,1,1)=HRRA(65,1,1)+Alpha*VRR(65,1,0)
      HRRB(65,1,1)=HRRB(65,1,1)+Beta*VRR(65,1,0)
      HRRC(65,1,1)=HRRC(65,1,1)+Gamma*VRR(65,1,0)
      HRRC(65,2,1)=HRRC(65,2,1)+Gamma*VRR(65,2,0)
      HRRC(65,3,1)=HRRC(65,3,1)+Gamma*VRR(65,3,0)
      HRRC(65,4,1)=HRRC(65,4,1)+Gamma*VRR(65,4,0)
      HRR(66,1,1)=HRR(66,1,1)+VRR(66,1,0)
      HRRA(66,1,1)=HRRA(66,1,1)+Alpha*VRR(66,1,0)
      HRRB(66,1,1)=HRRB(66,1,1)+Beta*VRR(66,1,0)
      HRRC(66,1,1)=HRRC(66,1,1)+Gamma*VRR(66,1,0)
      HRRC(66,2,1)=HRRC(66,2,1)+Gamma*VRR(66,2,0)
      HRRC(66,3,1)=HRRC(66,3,1)+Gamma*VRR(66,3,0)
      HRRC(66,4,1)=HRRC(66,4,1)+Gamma*VRR(66,4,0)
      HRR(67,1,1)=HRR(67,1,1)+VRR(67,1,0)
      HRRA(67,1,1)=HRRA(67,1,1)+Alpha*VRR(67,1,0)
      HRRB(67,1,1)=HRRB(67,1,1)+Beta*VRR(67,1,0)
      HRRC(67,1,1)=HRRC(67,1,1)+Gamma*VRR(67,1,0)
      HRRC(67,2,1)=HRRC(67,2,1)+Gamma*VRR(67,2,0)
      HRRC(67,3,1)=HRRC(67,3,1)+Gamma*VRR(67,3,0)
      HRRC(67,4,1)=HRRC(67,4,1)+Gamma*VRR(67,4,0)
      HRR(68,1,1)=HRR(68,1,1)+VRR(68,1,0)
      HRRA(68,1,1)=HRRA(68,1,1)+Alpha*VRR(68,1,0)
      HRRB(68,1,1)=HRRB(68,1,1)+Beta*VRR(68,1,0)
      HRRC(68,1,1)=HRRC(68,1,1)+Gamma*VRR(68,1,0)
      HRRC(68,2,1)=HRRC(68,2,1)+Gamma*VRR(68,2,0)
      HRRC(68,3,1)=HRRC(68,3,1)+Gamma*VRR(68,3,0)
      HRRC(68,4,1)=HRRC(68,4,1)+Gamma*VRR(68,4,0)
      HRR(69,1,1)=HRR(69,1,1)+VRR(69,1,0)
      HRRA(69,1,1)=HRRA(69,1,1)+Alpha*VRR(69,1,0)
      HRRB(69,1,1)=HRRB(69,1,1)+Beta*VRR(69,1,0)
      HRRC(69,1,1)=HRRC(69,1,1)+Gamma*VRR(69,1,0)
      HRRC(69,2,1)=HRRC(69,2,1)+Gamma*VRR(69,2,0)
      HRRC(69,3,1)=HRRC(69,3,1)+Gamma*VRR(69,3,0)
      HRRC(69,4,1)=HRRC(69,4,1)+Gamma*VRR(69,4,0)
      HRR(70,1,1)=HRR(70,1,1)+VRR(70,1,0)
      HRRA(70,1,1)=HRRA(70,1,1)+Alpha*VRR(70,1,0)
      HRRB(70,1,1)=HRRB(70,1,1)+Beta*VRR(70,1,0)
      HRRC(70,1,1)=HRRC(70,1,1)+Gamma*VRR(70,1,0)
      HRRC(70,2,1)=HRRC(70,2,1)+Gamma*VRR(70,2,0)
      HRRC(70,3,1)=HRRC(70,3,1)+Gamma*VRR(70,3,0)
      HRRC(70,4,1)=HRRC(70,4,1)+Gamma*VRR(70,4,0)
      HRR(71,1,1)=HRR(71,1,1)+VRR(71,1,0)
      HRRA(71,1,1)=HRRA(71,1,1)+Alpha*VRR(71,1,0)
      HRRB(71,1,1)=HRRB(71,1,1)+Beta*VRR(71,1,0)
      HRRC(71,1,1)=HRRC(71,1,1)+Gamma*VRR(71,1,0)
      HRRC(71,2,1)=HRRC(71,2,1)+Gamma*VRR(71,2,0)
      HRRC(71,3,1)=HRRC(71,3,1)+Gamma*VRR(71,3,0)
      HRRC(71,4,1)=HRRC(71,4,1)+Gamma*VRR(71,4,0)
      HRR(72,1,1)=HRR(72,1,1)+VRR(72,1,0)
      HRRA(72,1,1)=HRRA(72,1,1)+Alpha*VRR(72,1,0)
      HRRB(72,1,1)=HRRB(72,1,1)+Beta*VRR(72,1,0)
      HRRC(72,1,1)=HRRC(72,1,1)+Gamma*VRR(72,1,0)
      HRRC(72,2,1)=HRRC(72,2,1)+Gamma*VRR(72,2,0)
      HRRC(72,3,1)=HRRC(72,3,1)+Gamma*VRR(72,3,0)
      HRRC(72,4,1)=HRRC(72,4,1)+Gamma*VRR(72,4,0)
      HRR(73,1,1)=HRR(73,1,1)+VRR(73,1,0)
      HRRA(73,1,1)=HRRA(73,1,1)+Alpha*VRR(73,1,0)
      HRRB(73,1,1)=HRRB(73,1,1)+Beta*VRR(73,1,0)
      HRRC(73,1,1)=HRRC(73,1,1)+Gamma*VRR(73,1,0)
      HRRC(73,2,1)=HRRC(73,2,1)+Gamma*VRR(73,2,0)
      HRRC(73,3,1)=HRRC(73,3,1)+Gamma*VRR(73,3,0)
      HRRC(73,4,1)=HRRC(73,4,1)+Gamma*VRR(73,4,0)
      HRR(74,1,1)=HRR(74,1,1)+VRR(74,1,0)
      HRRA(74,1,1)=HRRA(74,1,1)+Alpha*VRR(74,1,0)
      HRRB(74,1,1)=HRRB(74,1,1)+Beta*VRR(74,1,0)
      HRRC(74,1,1)=HRRC(74,1,1)+Gamma*VRR(74,1,0)
      HRRC(74,2,1)=HRRC(74,2,1)+Gamma*VRR(74,2,0)
      HRRC(74,3,1)=HRRC(74,3,1)+Gamma*VRR(74,3,0)
      HRRC(74,4,1)=HRRC(74,4,1)+Gamma*VRR(74,4,0)
      HRR(75,1,1)=HRR(75,1,1)+VRR(75,1,0)
      HRRA(75,1,1)=HRRA(75,1,1)+Alpha*VRR(75,1,0)
      HRRB(75,1,1)=HRRB(75,1,1)+Beta*VRR(75,1,0)
      HRRC(75,1,1)=HRRC(75,1,1)+Gamma*VRR(75,1,0)
      HRRC(75,2,1)=HRRC(75,2,1)+Gamma*VRR(75,2,0)
      HRRC(75,3,1)=HRRC(75,3,1)+Gamma*VRR(75,3,0)
      HRRC(75,4,1)=HRRC(75,4,1)+Gamma*VRR(75,4,0)
      HRR(76,1,1)=HRR(76,1,1)+VRR(76,1,0)
      HRRA(76,1,1)=HRRA(76,1,1)+Alpha*VRR(76,1,0)
      HRRB(76,1,1)=HRRB(76,1,1)+Beta*VRR(76,1,0)
      HRRC(76,1,1)=HRRC(76,1,1)+Gamma*VRR(76,1,0)
      HRRC(76,2,1)=HRRC(76,2,1)+Gamma*VRR(76,2,0)
      HRRC(76,3,1)=HRRC(76,3,1)+Gamma*VRR(76,3,0)
      HRRC(76,4,1)=HRRC(76,4,1)+Gamma*VRR(76,4,0)
      HRR(77,1,1)=HRR(77,1,1)+VRR(77,1,0)
      HRRA(77,1,1)=HRRA(77,1,1)+Alpha*VRR(77,1,0)
      HRRB(77,1,1)=HRRB(77,1,1)+Beta*VRR(77,1,0)
      HRRC(77,1,1)=HRRC(77,1,1)+Gamma*VRR(77,1,0)
      HRRC(77,2,1)=HRRC(77,2,1)+Gamma*VRR(77,2,0)
      HRRC(77,3,1)=HRRC(77,3,1)+Gamma*VRR(77,3,0)
      HRRC(77,4,1)=HRRC(77,4,1)+Gamma*VRR(77,4,0)
      HRR(78,1,1)=HRR(78,1,1)+VRR(78,1,0)
      HRRA(78,1,1)=HRRA(78,1,1)+Alpha*VRR(78,1,0)
      HRRB(78,1,1)=HRRB(78,1,1)+Beta*VRR(78,1,0)
      HRRC(78,1,1)=HRRC(78,1,1)+Gamma*VRR(78,1,0)
      HRRC(78,2,1)=HRRC(78,2,1)+Gamma*VRR(78,2,0)
      HRRC(78,3,1)=HRRC(78,3,1)+Gamma*VRR(78,3,0)
      HRRC(78,4,1)=HRRC(78,4,1)+Gamma*VRR(78,4,0)
      HRR(79,1,1)=HRR(79,1,1)+VRR(79,1,0)
      HRRA(79,1,1)=HRRA(79,1,1)+Alpha*VRR(79,1,0)
      HRRB(79,1,1)=HRRB(79,1,1)+Beta*VRR(79,1,0)
      HRRC(79,1,1)=HRRC(79,1,1)+Gamma*VRR(79,1,0)
      HRRC(79,2,1)=HRRC(79,2,1)+Gamma*VRR(79,2,0)
      HRRC(79,3,1)=HRRC(79,3,1)+Gamma*VRR(79,3,0)
      HRRC(79,4,1)=HRRC(79,4,1)+Gamma*VRR(79,4,0)
      HRR(80,1,1)=HRR(80,1,1)+VRR(80,1,0)
      HRRA(80,1,1)=HRRA(80,1,1)+Alpha*VRR(80,1,0)
      HRRB(80,1,1)=HRRB(80,1,1)+Beta*VRR(80,1,0)
      HRRC(80,1,1)=HRRC(80,1,1)+Gamma*VRR(80,1,0)
      HRRC(80,2,1)=HRRC(80,2,1)+Gamma*VRR(80,2,0)
      HRRC(80,3,1)=HRRC(80,3,1)+Gamma*VRR(80,3,0)
      HRRC(80,4,1)=HRRC(80,4,1)+Gamma*VRR(80,4,0)
      HRR(81,1,1)=HRR(81,1,1)+VRR(81,1,0)
      HRRA(81,1,1)=HRRA(81,1,1)+Alpha*VRR(81,1,0)
      HRRB(81,1,1)=HRRB(81,1,1)+Beta*VRR(81,1,0)
      HRRC(81,1,1)=HRRC(81,1,1)+Gamma*VRR(81,1,0)
      HRRC(81,2,1)=HRRC(81,2,1)+Gamma*VRR(81,2,0)
      HRRC(81,3,1)=HRRC(81,3,1)+Gamma*VRR(81,3,0)
      HRRC(81,4,1)=HRRC(81,4,1)+Gamma*VRR(81,4,0)
      HRR(82,1,1)=HRR(82,1,1)+VRR(82,1,0)
      HRRA(82,1,1)=HRRA(82,1,1)+Alpha*VRR(82,1,0)
      HRRB(82,1,1)=HRRB(82,1,1)+Beta*VRR(82,1,0)
      HRRC(82,1,1)=HRRC(82,1,1)+Gamma*VRR(82,1,0)
      HRRC(82,2,1)=HRRC(82,2,1)+Gamma*VRR(82,2,0)
      HRRC(82,3,1)=HRRC(82,3,1)+Gamma*VRR(82,3,0)
      HRRC(82,4,1)=HRRC(82,4,1)+Gamma*VRR(82,4,0)
      HRR(83,1,1)=HRR(83,1,1)+VRR(83,1,0)
      HRRA(83,1,1)=HRRA(83,1,1)+Alpha*VRR(83,1,0)
      HRRB(83,1,1)=HRRB(83,1,1)+Beta*VRR(83,1,0)
      HRRC(83,1,1)=HRRC(83,1,1)+Gamma*VRR(83,1,0)
      HRRC(83,2,1)=HRRC(83,2,1)+Gamma*VRR(83,2,0)
      HRRC(83,3,1)=HRRC(83,3,1)+Gamma*VRR(83,3,0)
      HRRC(83,4,1)=HRRC(83,4,1)+Gamma*VRR(83,4,0)
      HRR(84,1,1)=HRR(84,1,1)+VRR(84,1,0)
      HRRA(84,1,1)=HRRA(84,1,1)+Alpha*VRR(84,1,0)
      HRRB(84,1,1)=HRRB(84,1,1)+Beta*VRR(84,1,0)
      HRRC(84,1,1)=HRRC(84,1,1)+Gamma*VRR(84,1,0)
      HRRC(84,2,1)=HRRC(84,2,1)+Gamma*VRR(84,2,0)
      HRRC(84,3,1)=HRRC(84,3,1)+Gamma*VRR(84,3,0)
      HRRC(84,4,1)=HRRC(84,4,1)+Gamma*VRR(84,4,0)
      HRRA(85,1,1)=HRRA(85,1,1)+Alpha*VRR(85,1,0)
      HRRB(85,1,1)=HRRB(85,1,1)+Beta*VRR(85,1,0)
      HRRA(86,1,1)=HRRA(86,1,1)+Alpha*VRR(86,1,0)
      HRRB(86,1,1)=HRRB(86,1,1)+Beta*VRR(86,1,0)
      HRRA(87,1,1)=HRRA(87,1,1)+Alpha*VRR(87,1,0)
      HRRB(87,1,1)=HRRB(87,1,1)+Beta*VRR(87,1,0)
      HRRA(88,1,1)=HRRA(88,1,1)+Alpha*VRR(88,1,0)
      HRRB(88,1,1)=HRRB(88,1,1)+Beta*VRR(88,1,0)
      HRRA(89,1,1)=HRRA(89,1,1)+Alpha*VRR(89,1,0)
      HRRB(89,1,1)=HRRB(89,1,1)+Beta*VRR(89,1,0)
      HRRA(90,1,1)=HRRA(90,1,1)+Alpha*VRR(90,1,0)
      HRRB(90,1,1)=HRRB(90,1,1)+Beta*VRR(90,1,0)
      HRRA(91,1,1)=HRRA(91,1,1)+Alpha*VRR(91,1,0)
      HRRB(91,1,1)=HRRB(91,1,1)+Beta*VRR(91,1,0)
      HRRA(92,1,1)=HRRA(92,1,1)+Alpha*VRR(92,1,0)
      HRRB(92,1,1)=HRRB(92,1,1)+Beta*VRR(92,1,0)
      HRRA(93,1,1)=HRRA(93,1,1)+Alpha*VRR(93,1,0)
      HRRB(93,1,1)=HRRB(93,1,1)+Beta*VRR(93,1,0)
      HRRA(94,1,1)=HRRA(94,1,1)+Alpha*VRR(94,1,0)
      HRRB(94,1,1)=HRRB(94,1,1)+Beta*VRR(94,1,0)
      HRRA(95,1,1)=HRRA(95,1,1)+Alpha*VRR(95,1,0)
      HRRB(95,1,1)=HRRB(95,1,1)+Beta*VRR(95,1,0)
      HRRA(96,1,1)=HRRA(96,1,1)+Alpha*VRR(96,1,0)
      HRRB(96,1,1)=HRRB(96,1,1)+Beta*VRR(96,1,0)
      HRRA(97,1,1)=HRRA(97,1,1)+Alpha*VRR(97,1,0)
      HRRB(97,1,1)=HRRB(97,1,1)+Beta*VRR(97,1,0)
      HRRA(98,1,1)=HRRA(98,1,1)+Alpha*VRR(98,1,0)
      HRRB(98,1,1)=HRRB(98,1,1)+Beta*VRR(98,1,0)
      HRRA(99,1,1)=HRRA(99,1,1)+Alpha*VRR(99,1,0)
      HRRB(99,1,1)=HRRB(99,1,1)+Beta*VRR(99,1,0)
      HRRA(100,1,1)=HRRA(100,1,1)+Alpha*VRR(100,1,0)
      HRRB(100,1,1)=HRRB(100,1,1)+Beta*VRR(100,1,0)
      HRRA(101,1,1)=HRRA(101,1,1)+Alpha*VRR(101,1,0)
      HRRB(101,1,1)=HRRB(101,1,1)+Beta*VRR(101,1,0)
      HRRA(102,1,1)=HRRA(102,1,1)+Alpha*VRR(102,1,0)
      HRRB(102,1,1)=HRRB(102,1,1)+Beta*VRR(102,1,0)
      HRRA(103,1,1)=HRRA(103,1,1)+Alpha*VRR(103,1,0)
      HRRB(103,1,1)=HRRB(103,1,1)+Beta*VRR(103,1,0)
      HRRA(104,1,1)=HRRA(104,1,1)+Alpha*VRR(104,1,0)
      HRRB(104,1,1)=HRRB(104,1,1)+Beta*VRR(104,1,0)
      HRRA(105,1,1)=HRRA(105,1,1)+Alpha*VRR(105,1,0)
      HRRB(105,1,1)=HRRB(105,1,1)+Beta*VRR(105,1,0)
      HRRA(106,1,1)=HRRA(106,1,1)+Alpha*VRR(106,1,0)
      HRRB(106,1,1)=HRRB(106,1,1)+Beta*VRR(106,1,0)
      HRRA(107,1,1)=HRRA(107,1,1)+Alpha*VRR(107,1,0)
      HRRB(107,1,1)=HRRB(107,1,1)+Beta*VRR(107,1,0)
      HRRA(108,1,1)=HRRA(108,1,1)+Alpha*VRR(108,1,0)
      HRRB(108,1,1)=HRRB(108,1,1)+Beta*VRR(108,1,0)
      HRRA(109,1,1)=HRRA(109,1,1)+Alpha*VRR(109,1,0)
      HRRB(109,1,1)=HRRB(109,1,1)+Beta*VRR(109,1,0)
      HRRA(110,1,1)=HRRA(110,1,1)+Alpha*VRR(110,1,0)
      HRRB(110,1,1)=HRRB(110,1,1)+Beta*VRR(110,1,0)
      HRRA(111,1,1)=HRRA(111,1,1)+Alpha*VRR(111,1,0)
      HRRB(111,1,1)=HRRB(111,1,1)+Beta*VRR(111,1,0)
      HRRA(112,1,1)=HRRA(112,1,1)+Alpha*VRR(112,1,0)
      HRRB(112,1,1)=HRRB(112,1,1)+Beta*VRR(112,1,0)
      HRRA(113,1,1)=HRRA(113,1,1)+Alpha*VRR(113,1,0)
      HRRB(113,1,1)=HRRB(113,1,1)+Beta*VRR(113,1,0)
      HRRA(114,1,1)=HRRA(114,1,1)+Alpha*VRR(114,1,0)
      HRRB(114,1,1)=HRRB(114,1,1)+Beta*VRR(114,1,0)
      HRRA(115,1,1)=HRRA(115,1,1)+Alpha*VRR(115,1,0)
      HRRB(115,1,1)=HRRB(115,1,1)+Beta*VRR(115,1,0)
      HRRA(116,1,1)=HRRA(116,1,1)+Alpha*VRR(116,1,0)
      HRRB(116,1,1)=HRRB(116,1,1)+Beta*VRR(116,1,0)
      HRRA(117,1,1)=HRRA(117,1,1)+Alpha*VRR(117,1,0)
      HRRB(117,1,1)=HRRB(117,1,1)+Beta*VRR(117,1,0)
      HRRA(118,1,1)=HRRA(118,1,1)+Alpha*VRR(118,1,0)
      HRRB(118,1,1)=HRRB(118,1,1)+Beta*VRR(118,1,0)
      HRRA(119,1,1)=HRRA(119,1,1)+Alpha*VRR(119,1,0)
      HRRB(119,1,1)=HRRB(119,1,1)+Beta*VRR(119,1,0)
      HRRA(120,1,1)=HRRA(120,1,1)+Alpha*VRR(120,1,0)
      HRRB(120,1,1)=HRRB(120,1,1)+Beta*VRR(120,1,0)
      IJ=1
      DO J=1,3
      IF(IW(J).EQ.1) THEN
        IF(IW(1).EQ.1) THEN
        HRRS(1,1,1,IJ)=HRRS(1,1,1,IJ)+PQJ(J)*VRRS(1,1,0,1)
        HRRS(2,1,1,IJ)=HRRS(2,1,1,IJ)+PQJ(J)*VRRS(2,1,0,1)
        HRRS(3,1,1,IJ)=HRRS(3,1,1,IJ)+PQJ(J)*VRRS(3,1,0,1)
        HRRS(4,1,1,IJ)=HRRS(4,1,1,IJ)+PQJ(J)*VRRS(4,1,0,1)
        HRRS(5,1,1,IJ)=HRRS(5,1,1,IJ)+PQJ(J)*VRRS(5,1,0,1)
        HRRS(6,1,1,IJ)=HRRS(6,1,1,IJ)+PQJ(J)*VRRS(6,1,0,1)
        HRRS(7,1,1,IJ)=HRRS(7,1,1,IJ)+PQJ(J)*VRRS(7,1,0,1)
        HRRS(8,1,1,IJ)=HRRS(8,1,1,IJ)+PQJ(J)*VRRS(8,1,0,1)
        HRRS(9,1,1,IJ)=HRRS(9,1,1,IJ)+PQJ(J)*VRRS(9,1,0,1)
        HRRS(10,1,1,IJ)=HRRS(10,1,1,IJ)+PQJ(J)*VRRS(10,1,0,1)
        HRRS(11,1,1,IJ)=HRRS(11,1,1,IJ)+PQJ(J)*VRRS(11,1,0,1)
        HRRS(12,1,1,IJ)=HRRS(12,1,1,IJ)+PQJ(J)*VRRS(12,1,0,1)
        HRRS(13,1,1,IJ)=HRRS(13,1,1,IJ)+PQJ(J)*VRRS(13,1,0,1)
        HRRS(14,1,1,IJ)=HRRS(14,1,1,IJ)+PQJ(J)*VRRS(14,1,0,1)
        HRRS(15,1,1,IJ)=HRRS(15,1,1,IJ)+PQJ(J)*VRRS(15,1,0,1)
        HRRS(16,1,1,IJ)=HRRS(16,1,1,IJ)+PQJ(J)*VRRS(16,1,0,1)
        HRRS(17,1,1,IJ)=HRRS(17,1,1,IJ)+PQJ(J)*VRRS(17,1,0,1)
        HRRS(18,1,1,IJ)=HRRS(18,1,1,IJ)+PQJ(J)*VRRS(18,1,0,1)
        HRRS(19,1,1,IJ)=HRRS(19,1,1,IJ)+PQJ(J)*VRRS(19,1,0,1)
        HRRS(20,1,1,IJ)=HRRS(20,1,1,IJ)+PQJ(J)*VRRS(20,1,0,1)
        HRRS(21,1,1,IJ)=HRRS(21,1,1,IJ)+PQJ(J)*VRRS(21,1,0,1)
        HRRS(22,1,1,IJ)=HRRS(22,1,1,IJ)+PQJ(J)*VRRS(22,1,0,1)
        HRRS(23,1,1,IJ)=HRRS(23,1,1,IJ)+PQJ(J)*VRRS(23,1,0,1)
        HRRS(24,1,1,IJ)=HRRS(24,1,1,IJ)+PQJ(J)*VRRS(24,1,0,1)
        HRRS(25,1,1,IJ)=HRRS(25,1,1,IJ)+PQJ(J)*VRRS(25,1,0,1)
        HRRS(26,1,1,IJ)=HRRS(26,1,1,IJ)+PQJ(J)*VRRS(26,1,0,1)
        HRRS(27,1,1,IJ)=HRRS(27,1,1,IJ)+PQJ(J)*VRRS(27,1,0,1)
        HRRS(28,1,1,IJ)=HRRS(28,1,1,IJ)+PQJ(J)*VRRS(28,1,0,1)
        HRRS(29,1,1,IJ)=HRRS(29,1,1,IJ)+PQJ(J)*VRRS(29,1,0,1)
        HRRS(30,1,1,IJ)=HRRS(30,1,1,IJ)+PQJ(J)*VRRS(30,1,0,1)
        HRRS(31,1,1,IJ)=HRRS(31,1,1,IJ)+PQJ(J)*VRRS(31,1,0,1)
        HRRS(32,1,1,IJ)=HRRS(32,1,1,IJ)+PQJ(J)*VRRS(32,1,0,1)
        HRRS(33,1,1,IJ)=HRRS(33,1,1,IJ)+PQJ(J)*VRRS(33,1,0,1)
        HRRS(34,1,1,IJ)=HRRS(34,1,1,IJ)+PQJ(J)*VRRS(34,1,0,1)
        HRRS(35,1,1,IJ)=HRRS(35,1,1,IJ)+PQJ(J)*VRRS(35,1,0,1)
        HRRS(36,1,1,IJ)=HRRS(36,1,1,IJ)+PQJ(J)*VRRS(36,1,0,1)
        HRRS(37,1,1,IJ)=HRRS(37,1,1,IJ)+PQJ(J)*VRRS(37,1,0,1)
        HRRS(38,1,1,IJ)=HRRS(38,1,1,IJ)+PQJ(J)*VRRS(38,1,0,1)
        HRRS(39,1,1,IJ)=HRRS(39,1,1,IJ)+PQJ(J)*VRRS(39,1,0,1)
        HRRS(40,1,1,IJ)=HRRS(40,1,1,IJ)+PQJ(J)*VRRS(40,1,0,1)
        HRRS(41,1,1,IJ)=HRRS(41,1,1,IJ)+PQJ(J)*VRRS(41,1,0,1)
        HRRS(42,1,1,IJ)=HRRS(42,1,1,IJ)+PQJ(J)*VRRS(42,1,0,1)
        HRRS(43,1,1,IJ)=HRRS(43,1,1,IJ)+PQJ(J)*VRRS(43,1,0,1)
        HRRS(44,1,1,IJ)=HRRS(44,1,1,IJ)+PQJ(J)*VRRS(44,1,0,1)
        HRRS(45,1,1,IJ)=HRRS(45,1,1,IJ)+PQJ(J)*VRRS(45,1,0,1)
        HRRS(46,1,1,IJ)=HRRS(46,1,1,IJ)+PQJ(J)*VRRS(46,1,0,1)
        HRRS(47,1,1,IJ)=HRRS(47,1,1,IJ)+PQJ(J)*VRRS(47,1,0,1)
        HRRS(48,1,1,IJ)=HRRS(48,1,1,IJ)+PQJ(J)*VRRS(48,1,0,1)
        HRRS(49,1,1,IJ)=HRRS(49,1,1,IJ)+PQJ(J)*VRRS(49,1,0,1)
        HRRS(50,1,1,IJ)=HRRS(50,1,1,IJ)+PQJ(J)*VRRS(50,1,0,1)
        HRRS(51,1,1,IJ)=HRRS(51,1,1,IJ)+PQJ(J)*VRRS(51,1,0,1)
        HRRS(52,1,1,IJ)=HRRS(52,1,1,IJ)+PQJ(J)*VRRS(52,1,0,1)
        HRRS(53,1,1,IJ)=HRRS(53,1,1,IJ)+PQJ(J)*VRRS(53,1,0,1)
        HRRS(54,1,1,IJ)=HRRS(54,1,1,IJ)+PQJ(J)*VRRS(54,1,0,1)
        HRRS(55,1,1,IJ)=HRRS(55,1,1,IJ)+PQJ(J)*VRRS(55,1,0,1)
        HRRS(56,1,1,IJ)=HRRS(56,1,1,IJ)+PQJ(J)*VRRS(56,1,0,1)
        HRRS(57,1,1,IJ)=HRRS(57,1,1,IJ)+PQJ(J)*VRRS(57,1,0,1)
        HRRS(58,1,1,IJ)=HRRS(58,1,1,IJ)+PQJ(J)*VRRS(58,1,0,1)
        HRRS(59,1,1,IJ)=HRRS(59,1,1,IJ)+PQJ(J)*VRRS(59,1,0,1)
        HRRS(60,1,1,IJ)=HRRS(60,1,1,IJ)+PQJ(J)*VRRS(60,1,0,1)
        HRRS(61,1,1,IJ)=HRRS(61,1,1,IJ)+PQJ(J)*VRRS(61,1,0,1)
        HRRS(62,1,1,IJ)=HRRS(62,1,1,IJ)+PQJ(J)*VRRS(62,1,0,1)
        HRRS(63,1,1,IJ)=HRRS(63,1,1,IJ)+PQJ(J)*VRRS(63,1,0,1)
        HRRS(64,1,1,IJ)=HRRS(64,1,1,IJ)+PQJ(J)*VRRS(64,1,0,1)
        HRRS(65,1,1,IJ)=HRRS(65,1,1,IJ)+PQJ(J)*VRRS(65,1,0,1)
        HRRS(66,1,1,IJ)=HRRS(66,1,1,IJ)+PQJ(J)*VRRS(66,1,0,1)
        HRRS(67,1,1,IJ)=HRRS(67,1,1,IJ)+PQJ(J)*VRRS(67,1,0,1)
        HRRS(68,1,1,IJ)=HRRS(68,1,1,IJ)+PQJ(J)*VRRS(68,1,0,1)
        HRRS(69,1,1,IJ)=HRRS(69,1,1,IJ)+PQJ(J)*VRRS(69,1,0,1)
        HRRS(70,1,1,IJ)=HRRS(70,1,1,IJ)+PQJ(J)*VRRS(70,1,0,1)
        HRRS(71,1,1,IJ)=HRRS(71,1,1,IJ)+PQJ(J)*VRRS(71,1,0,1)
        HRRS(72,1,1,IJ)=HRRS(72,1,1,IJ)+PQJ(J)*VRRS(72,1,0,1)
        HRRS(73,1,1,IJ)=HRRS(73,1,1,IJ)+PQJ(J)*VRRS(73,1,0,1)
        HRRS(74,1,1,IJ)=HRRS(74,1,1,IJ)+PQJ(J)*VRRS(74,1,0,1)
        HRRS(75,1,1,IJ)=HRRS(75,1,1,IJ)+PQJ(J)*VRRS(75,1,0,1)
        HRRS(76,1,1,IJ)=HRRS(76,1,1,IJ)+PQJ(J)*VRRS(76,1,0,1)
        HRRS(77,1,1,IJ)=HRRS(77,1,1,IJ)+PQJ(J)*VRRS(77,1,0,1)
        HRRS(78,1,1,IJ)=HRRS(78,1,1,IJ)+PQJ(J)*VRRS(78,1,0,1)
        HRRS(79,1,1,IJ)=HRRS(79,1,1,IJ)+PQJ(J)*VRRS(79,1,0,1)
        HRRS(80,1,1,IJ)=HRRS(80,1,1,IJ)+PQJ(J)*VRRS(80,1,0,1)
        HRRS(81,1,1,IJ)=HRRS(81,1,1,IJ)+PQJ(J)*VRRS(81,1,0,1)
        HRRS(82,1,1,IJ)=HRRS(82,1,1,IJ)+PQJ(J)*VRRS(82,1,0,1)
        HRRS(83,1,1,IJ)=HRRS(83,1,1,IJ)+PQJ(J)*VRRS(83,1,0,1)
        HRRS(84,1,1,IJ)=HRRS(84,1,1,IJ)+PQJ(J)*VRRS(84,1,0,1)
        ENDIF
        IJ=IJ+1
        IF(IW(2).EQ.1) THEN
        HRRS(1,1,1,IJ)=HRRS(1,1,1,IJ)+PQJ(J)*VRRS(1,1,0,2)
        HRRS(2,1,1,IJ)=HRRS(2,1,1,IJ)+PQJ(J)*VRRS(2,1,0,2)
        HRRS(3,1,1,IJ)=HRRS(3,1,1,IJ)+PQJ(J)*VRRS(3,1,0,2)
        HRRS(4,1,1,IJ)=HRRS(4,1,1,IJ)+PQJ(J)*VRRS(4,1,0,2)
        HRRS(5,1,1,IJ)=HRRS(5,1,1,IJ)+PQJ(J)*VRRS(5,1,0,2)
        HRRS(6,1,1,IJ)=HRRS(6,1,1,IJ)+PQJ(J)*VRRS(6,1,0,2)
        HRRS(7,1,1,IJ)=HRRS(7,1,1,IJ)+PQJ(J)*VRRS(7,1,0,2)
        HRRS(8,1,1,IJ)=HRRS(8,1,1,IJ)+PQJ(J)*VRRS(8,1,0,2)
        HRRS(9,1,1,IJ)=HRRS(9,1,1,IJ)+PQJ(J)*VRRS(9,1,0,2)
        HRRS(10,1,1,IJ)=HRRS(10,1,1,IJ)+PQJ(J)*VRRS(10,1,0,2)
        HRRS(11,1,1,IJ)=HRRS(11,1,1,IJ)+PQJ(J)*VRRS(11,1,0,2)
        HRRS(12,1,1,IJ)=HRRS(12,1,1,IJ)+PQJ(J)*VRRS(12,1,0,2)
        HRRS(13,1,1,IJ)=HRRS(13,1,1,IJ)+PQJ(J)*VRRS(13,1,0,2)
        HRRS(14,1,1,IJ)=HRRS(14,1,1,IJ)+PQJ(J)*VRRS(14,1,0,2)
        HRRS(15,1,1,IJ)=HRRS(15,1,1,IJ)+PQJ(J)*VRRS(15,1,0,2)
        HRRS(16,1,1,IJ)=HRRS(16,1,1,IJ)+PQJ(J)*VRRS(16,1,0,2)
        HRRS(17,1,1,IJ)=HRRS(17,1,1,IJ)+PQJ(J)*VRRS(17,1,0,2)
        HRRS(18,1,1,IJ)=HRRS(18,1,1,IJ)+PQJ(J)*VRRS(18,1,0,2)
        HRRS(19,1,1,IJ)=HRRS(19,1,1,IJ)+PQJ(J)*VRRS(19,1,0,2)
        HRRS(20,1,1,IJ)=HRRS(20,1,1,IJ)+PQJ(J)*VRRS(20,1,0,2)
        HRRS(21,1,1,IJ)=HRRS(21,1,1,IJ)+PQJ(J)*VRRS(21,1,0,2)
        HRRS(22,1,1,IJ)=HRRS(22,1,1,IJ)+PQJ(J)*VRRS(22,1,0,2)
        HRRS(23,1,1,IJ)=HRRS(23,1,1,IJ)+PQJ(J)*VRRS(23,1,0,2)
        HRRS(24,1,1,IJ)=HRRS(24,1,1,IJ)+PQJ(J)*VRRS(24,1,0,2)
        HRRS(25,1,1,IJ)=HRRS(25,1,1,IJ)+PQJ(J)*VRRS(25,1,0,2)
        HRRS(26,1,1,IJ)=HRRS(26,1,1,IJ)+PQJ(J)*VRRS(26,1,0,2)
        HRRS(27,1,1,IJ)=HRRS(27,1,1,IJ)+PQJ(J)*VRRS(27,1,0,2)
        HRRS(28,1,1,IJ)=HRRS(28,1,1,IJ)+PQJ(J)*VRRS(28,1,0,2)
        HRRS(29,1,1,IJ)=HRRS(29,1,1,IJ)+PQJ(J)*VRRS(29,1,0,2)
        HRRS(30,1,1,IJ)=HRRS(30,1,1,IJ)+PQJ(J)*VRRS(30,1,0,2)
        HRRS(31,1,1,IJ)=HRRS(31,1,1,IJ)+PQJ(J)*VRRS(31,1,0,2)
        HRRS(32,1,1,IJ)=HRRS(32,1,1,IJ)+PQJ(J)*VRRS(32,1,0,2)
        HRRS(33,1,1,IJ)=HRRS(33,1,1,IJ)+PQJ(J)*VRRS(33,1,0,2)
        HRRS(34,1,1,IJ)=HRRS(34,1,1,IJ)+PQJ(J)*VRRS(34,1,0,2)
        HRRS(35,1,1,IJ)=HRRS(35,1,1,IJ)+PQJ(J)*VRRS(35,1,0,2)
        HRRS(36,1,1,IJ)=HRRS(36,1,1,IJ)+PQJ(J)*VRRS(36,1,0,2)
        HRRS(37,1,1,IJ)=HRRS(37,1,1,IJ)+PQJ(J)*VRRS(37,1,0,2)
        HRRS(38,1,1,IJ)=HRRS(38,1,1,IJ)+PQJ(J)*VRRS(38,1,0,2)
        HRRS(39,1,1,IJ)=HRRS(39,1,1,IJ)+PQJ(J)*VRRS(39,1,0,2)
        HRRS(40,1,1,IJ)=HRRS(40,1,1,IJ)+PQJ(J)*VRRS(40,1,0,2)
        HRRS(41,1,1,IJ)=HRRS(41,1,1,IJ)+PQJ(J)*VRRS(41,1,0,2)
        HRRS(42,1,1,IJ)=HRRS(42,1,1,IJ)+PQJ(J)*VRRS(42,1,0,2)
        HRRS(43,1,1,IJ)=HRRS(43,1,1,IJ)+PQJ(J)*VRRS(43,1,0,2)
        HRRS(44,1,1,IJ)=HRRS(44,1,1,IJ)+PQJ(J)*VRRS(44,1,0,2)
        HRRS(45,1,1,IJ)=HRRS(45,1,1,IJ)+PQJ(J)*VRRS(45,1,0,2)
        HRRS(46,1,1,IJ)=HRRS(46,1,1,IJ)+PQJ(J)*VRRS(46,1,0,2)
        HRRS(47,1,1,IJ)=HRRS(47,1,1,IJ)+PQJ(J)*VRRS(47,1,0,2)
        HRRS(48,1,1,IJ)=HRRS(48,1,1,IJ)+PQJ(J)*VRRS(48,1,0,2)
        HRRS(49,1,1,IJ)=HRRS(49,1,1,IJ)+PQJ(J)*VRRS(49,1,0,2)
        HRRS(50,1,1,IJ)=HRRS(50,1,1,IJ)+PQJ(J)*VRRS(50,1,0,2)
        HRRS(51,1,1,IJ)=HRRS(51,1,1,IJ)+PQJ(J)*VRRS(51,1,0,2)
        HRRS(52,1,1,IJ)=HRRS(52,1,1,IJ)+PQJ(J)*VRRS(52,1,0,2)
        HRRS(53,1,1,IJ)=HRRS(53,1,1,IJ)+PQJ(J)*VRRS(53,1,0,2)
        HRRS(54,1,1,IJ)=HRRS(54,1,1,IJ)+PQJ(J)*VRRS(54,1,0,2)
        HRRS(55,1,1,IJ)=HRRS(55,1,1,IJ)+PQJ(J)*VRRS(55,1,0,2)
        HRRS(56,1,1,IJ)=HRRS(56,1,1,IJ)+PQJ(J)*VRRS(56,1,0,2)
        HRRS(57,1,1,IJ)=HRRS(57,1,1,IJ)+PQJ(J)*VRRS(57,1,0,2)
        HRRS(58,1,1,IJ)=HRRS(58,1,1,IJ)+PQJ(J)*VRRS(58,1,0,2)
        HRRS(59,1,1,IJ)=HRRS(59,1,1,IJ)+PQJ(J)*VRRS(59,1,0,2)
        HRRS(60,1,1,IJ)=HRRS(60,1,1,IJ)+PQJ(J)*VRRS(60,1,0,2)
        HRRS(61,1,1,IJ)=HRRS(61,1,1,IJ)+PQJ(J)*VRRS(61,1,0,2)
        HRRS(62,1,1,IJ)=HRRS(62,1,1,IJ)+PQJ(J)*VRRS(62,1,0,2)
        HRRS(63,1,1,IJ)=HRRS(63,1,1,IJ)+PQJ(J)*VRRS(63,1,0,2)
        HRRS(64,1,1,IJ)=HRRS(64,1,1,IJ)+PQJ(J)*VRRS(64,1,0,2)
        HRRS(65,1,1,IJ)=HRRS(65,1,1,IJ)+PQJ(J)*VRRS(65,1,0,2)
        HRRS(66,1,1,IJ)=HRRS(66,1,1,IJ)+PQJ(J)*VRRS(66,1,0,2)
        HRRS(67,1,1,IJ)=HRRS(67,1,1,IJ)+PQJ(J)*VRRS(67,1,0,2)
        HRRS(68,1,1,IJ)=HRRS(68,1,1,IJ)+PQJ(J)*VRRS(68,1,0,2)
        HRRS(69,1,1,IJ)=HRRS(69,1,1,IJ)+PQJ(J)*VRRS(69,1,0,2)
        HRRS(70,1,1,IJ)=HRRS(70,1,1,IJ)+PQJ(J)*VRRS(70,1,0,2)
        HRRS(71,1,1,IJ)=HRRS(71,1,1,IJ)+PQJ(J)*VRRS(71,1,0,2)
        HRRS(72,1,1,IJ)=HRRS(72,1,1,IJ)+PQJ(J)*VRRS(72,1,0,2)
        HRRS(73,1,1,IJ)=HRRS(73,1,1,IJ)+PQJ(J)*VRRS(73,1,0,2)
        HRRS(74,1,1,IJ)=HRRS(74,1,1,IJ)+PQJ(J)*VRRS(74,1,0,2)
        HRRS(75,1,1,IJ)=HRRS(75,1,1,IJ)+PQJ(J)*VRRS(75,1,0,2)
        HRRS(76,1,1,IJ)=HRRS(76,1,1,IJ)+PQJ(J)*VRRS(76,1,0,2)
        HRRS(77,1,1,IJ)=HRRS(77,1,1,IJ)+PQJ(J)*VRRS(77,1,0,2)
        HRRS(78,1,1,IJ)=HRRS(78,1,1,IJ)+PQJ(J)*VRRS(78,1,0,2)
        HRRS(79,1,1,IJ)=HRRS(79,1,1,IJ)+PQJ(J)*VRRS(79,1,0,2)
        HRRS(80,1,1,IJ)=HRRS(80,1,1,IJ)+PQJ(J)*VRRS(80,1,0,2)
        HRRS(81,1,1,IJ)=HRRS(81,1,1,IJ)+PQJ(J)*VRRS(81,1,0,2)
        HRRS(82,1,1,IJ)=HRRS(82,1,1,IJ)+PQJ(J)*VRRS(82,1,0,2)
        HRRS(83,1,1,IJ)=HRRS(83,1,1,IJ)+PQJ(J)*VRRS(83,1,0,2)
        HRRS(84,1,1,IJ)=HRRS(84,1,1,IJ)+PQJ(J)*VRRS(84,1,0,2)
        ENDIF
        IJ=IJ+1
        IF(IW(3).EQ.1) THEN
        HRRS(1,1,1,IJ)=HRRS(1,1,1,IJ)+PQJ(J)*VRRS(1,1,0,3)
        HRRS(2,1,1,IJ)=HRRS(2,1,1,IJ)+PQJ(J)*VRRS(2,1,0,3)
        HRRS(3,1,1,IJ)=HRRS(3,1,1,IJ)+PQJ(J)*VRRS(3,1,0,3)
        HRRS(4,1,1,IJ)=HRRS(4,1,1,IJ)+PQJ(J)*VRRS(4,1,0,3)
        HRRS(5,1,1,IJ)=HRRS(5,1,1,IJ)+PQJ(J)*VRRS(5,1,0,3)
        HRRS(6,1,1,IJ)=HRRS(6,1,1,IJ)+PQJ(J)*VRRS(6,1,0,3)
        HRRS(7,1,1,IJ)=HRRS(7,1,1,IJ)+PQJ(J)*VRRS(7,1,0,3)
        HRRS(8,1,1,IJ)=HRRS(8,1,1,IJ)+PQJ(J)*VRRS(8,1,0,3)
        HRRS(9,1,1,IJ)=HRRS(9,1,1,IJ)+PQJ(J)*VRRS(9,1,0,3)
        HRRS(10,1,1,IJ)=HRRS(10,1,1,IJ)+PQJ(J)*VRRS(10,1,0,3)
        HRRS(11,1,1,IJ)=HRRS(11,1,1,IJ)+PQJ(J)*VRRS(11,1,0,3)
        HRRS(12,1,1,IJ)=HRRS(12,1,1,IJ)+PQJ(J)*VRRS(12,1,0,3)
        HRRS(13,1,1,IJ)=HRRS(13,1,1,IJ)+PQJ(J)*VRRS(13,1,0,3)
        HRRS(14,1,1,IJ)=HRRS(14,1,1,IJ)+PQJ(J)*VRRS(14,1,0,3)
        HRRS(15,1,1,IJ)=HRRS(15,1,1,IJ)+PQJ(J)*VRRS(15,1,0,3)
        HRRS(16,1,1,IJ)=HRRS(16,1,1,IJ)+PQJ(J)*VRRS(16,1,0,3)
        HRRS(17,1,1,IJ)=HRRS(17,1,1,IJ)+PQJ(J)*VRRS(17,1,0,3)
        HRRS(18,1,1,IJ)=HRRS(18,1,1,IJ)+PQJ(J)*VRRS(18,1,0,3)
        HRRS(19,1,1,IJ)=HRRS(19,1,1,IJ)+PQJ(J)*VRRS(19,1,0,3)
        HRRS(20,1,1,IJ)=HRRS(20,1,1,IJ)+PQJ(J)*VRRS(20,1,0,3)
        HRRS(21,1,1,IJ)=HRRS(21,1,1,IJ)+PQJ(J)*VRRS(21,1,0,3)
        HRRS(22,1,1,IJ)=HRRS(22,1,1,IJ)+PQJ(J)*VRRS(22,1,0,3)
        HRRS(23,1,1,IJ)=HRRS(23,1,1,IJ)+PQJ(J)*VRRS(23,1,0,3)
        HRRS(24,1,1,IJ)=HRRS(24,1,1,IJ)+PQJ(J)*VRRS(24,1,0,3)
        HRRS(25,1,1,IJ)=HRRS(25,1,1,IJ)+PQJ(J)*VRRS(25,1,0,3)
        HRRS(26,1,1,IJ)=HRRS(26,1,1,IJ)+PQJ(J)*VRRS(26,1,0,3)
        HRRS(27,1,1,IJ)=HRRS(27,1,1,IJ)+PQJ(J)*VRRS(27,1,0,3)
        HRRS(28,1,1,IJ)=HRRS(28,1,1,IJ)+PQJ(J)*VRRS(28,1,0,3)
        HRRS(29,1,1,IJ)=HRRS(29,1,1,IJ)+PQJ(J)*VRRS(29,1,0,3)
        HRRS(30,1,1,IJ)=HRRS(30,1,1,IJ)+PQJ(J)*VRRS(30,1,0,3)
        HRRS(31,1,1,IJ)=HRRS(31,1,1,IJ)+PQJ(J)*VRRS(31,1,0,3)
        HRRS(32,1,1,IJ)=HRRS(32,1,1,IJ)+PQJ(J)*VRRS(32,1,0,3)
        HRRS(33,1,1,IJ)=HRRS(33,1,1,IJ)+PQJ(J)*VRRS(33,1,0,3)
        HRRS(34,1,1,IJ)=HRRS(34,1,1,IJ)+PQJ(J)*VRRS(34,1,0,3)
        HRRS(35,1,1,IJ)=HRRS(35,1,1,IJ)+PQJ(J)*VRRS(35,1,0,3)
        HRRS(36,1,1,IJ)=HRRS(36,1,1,IJ)+PQJ(J)*VRRS(36,1,0,3)
        HRRS(37,1,1,IJ)=HRRS(37,1,1,IJ)+PQJ(J)*VRRS(37,1,0,3)
        HRRS(38,1,1,IJ)=HRRS(38,1,1,IJ)+PQJ(J)*VRRS(38,1,0,3)
        HRRS(39,1,1,IJ)=HRRS(39,1,1,IJ)+PQJ(J)*VRRS(39,1,0,3)
        HRRS(40,1,1,IJ)=HRRS(40,1,1,IJ)+PQJ(J)*VRRS(40,1,0,3)
        HRRS(41,1,1,IJ)=HRRS(41,1,1,IJ)+PQJ(J)*VRRS(41,1,0,3)
        HRRS(42,1,1,IJ)=HRRS(42,1,1,IJ)+PQJ(J)*VRRS(42,1,0,3)
        HRRS(43,1,1,IJ)=HRRS(43,1,1,IJ)+PQJ(J)*VRRS(43,1,0,3)
        HRRS(44,1,1,IJ)=HRRS(44,1,1,IJ)+PQJ(J)*VRRS(44,1,0,3)
        HRRS(45,1,1,IJ)=HRRS(45,1,1,IJ)+PQJ(J)*VRRS(45,1,0,3)
        HRRS(46,1,1,IJ)=HRRS(46,1,1,IJ)+PQJ(J)*VRRS(46,1,0,3)
        HRRS(47,1,1,IJ)=HRRS(47,1,1,IJ)+PQJ(J)*VRRS(47,1,0,3)
        HRRS(48,1,1,IJ)=HRRS(48,1,1,IJ)+PQJ(J)*VRRS(48,1,0,3)
        HRRS(49,1,1,IJ)=HRRS(49,1,1,IJ)+PQJ(J)*VRRS(49,1,0,3)
        HRRS(50,1,1,IJ)=HRRS(50,1,1,IJ)+PQJ(J)*VRRS(50,1,0,3)
        HRRS(51,1,1,IJ)=HRRS(51,1,1,IJ)+PQJ(J)*VRRS(51,1,0,3)
        HRRS(52,1,1,IJ)=HRRS(52,1,1,IJ)+PQJ(J)*VRRS(52,1,0,3)
        HRRS(53,1,1,IJ)=HRRS(53,1,1,IJ)+PQJ(J)*VRRS(53,1,0,3)
        HRRS(54,1,1,IJ)=HRRS(54,1,1,IJ)+PQJ(J)*VRRS(54,1,0,3)
        HRRS(55,1,1,IJ)=HRRS(55,1,1,IJ)+PQJ(J)*VRRS(55,1,0,3)
        HRRS(56,1,1,IJ)=HRRS(56,1,1,IJ)+PQJ(J)*VRRS(56,1,0,3)
        HRRS(57,1,1,IJ)=HRRS(57,1,1,IJ)+PQJ(J)*VRRS(57,1,0,3)
        HRRS(58,1,1,IJ)=HRRS(58,1,1,IJ)+PQJ(J)*VRRS(58,1,0,3)
        HRRS(59,1,1,IJ)=HRRS(59,1,1,IJ)+PQJ(J)*VRRS(59,1,0,3)
        HRRS(60,1,1,IJ)=HRRS(60,1,1,IJ)+PQJ(J)*VRRS(60,1,0,3)
        HRRS(61,1,1,IJ)=HRRS(61,1,1,IJ)+PQJ(J)*VRRS(61,1,0,3)
        HRRS(62,1,1,IJ)=HRRS(62,1,1,IJ)+PQJ(J)*VRRS(62,1,0,3)
        HRRS(63,1,1,IJ)=HRRS(63,1,1,IJ)+PQJ(J)*VRRS(63,1,0,3)
        HRRS(64,1,1,IJ)=HRRS(64,1,1,IJ)+PQJ(J)*VRRS(64,1,0,3)
        HRRS(65,1,1,IJ)=HRRS(65,1,1,IJ)+PQJ(J)*VRRS(65,1,0,3)
        HRRS(66,1,1,IJ)=HRRS(66,1,1,IJ)+PQJ(J)*VRRS(66,1,0,3)
        HRRS(67,1,1,IJ)=HRRS(67,1,1,IJ)+PQJ(J)*VRRS(67,1,0,3)
        HRRS(68,1,1,IJ)=HRRS(68,1,1,IJ)+PQJ(J)*VRRS(68,1,0,3)
        HRRS(69,1,1,IJ)=HRRS(69,1,1,IJ)+PQJ(J)*VRRS(69,1,0,3)
        HRRS(70,1,1,IJ)=HRRS(70,1,1,IJ)+PQJ(J)*VRRS(70,1,0,3)
        HRRS(71,1,1,IJ)=HRRS(71,1,1,IJ)+PQJ(J)*VRRS(71,1,0,3)
        HRRS(72,1,1,IJ)=HRRS(72,1,1,IJ)+PQJ(J)*VRRS(72,1,0,3)
        HRRS(73,1,1,IJ)=HRRS(73,1,1,IJ)+PQJ(J)*VRRS(73,1,0,3)
        HRRS(74,1,1,IJ)=HRRS(74,1,1,IJ)+PQJ(J)*VRRS(74,1,0,3)
        HRRS(75,1,1,IJ)=HRRS(75,1,1,IJ)+PQJ(J)*VRRS(75,1,0,3)
        HRRS(76,1,1,IJ)=HRRS(76,1,1,IJ)+PQJ(J)*VRRS(76,1,0,3)
        HRRS(77,1,1,IJ)=HRRS(77,1,1,IJ)+PQJ(J)*VRRS(77,1,0,3)
        HRRS(78,1,1,IJ)=HRRS(78,1,1,IJ)+PQJ(J)*VRRS(78,1,0,3)
        HRRS(79,1,1,IJ)=HRRS(79,1,1,IJ)+PQJ(J)*VRRS(79,1,0,3)
        HRRS(80,1,1,IJ)=HRRS(80,1,1,IJ)+PQJ(J)*VRRS(80,1,0,3)
        HRRS(81,1,1,IJ)=HRRS(81,1,1,IJ)+PQJ(J)*VRRS(81,1,0,3)
        HRRS(82,1,1,IJ)=HRRS(82,1,1,IJ)+PQJ(J)*VRRS(82,1,0,3)
        HRRS(83,1,1,IJ)=HRRS(83,1,1,IJ)+PQJ(J)*VRRS(83,1,0,3)
        HRRS(84,1,1,IJ)=HRRS(84,1,1,IJ)+PQJ(J)*VRRS(84,1,0,3)
        ENDIF
        IJ=IJ+1
      ELSE
        IJ=IJ+3
      ENDIF
      ENDDO !J
    END SUBROUTINE CNTRCTG101011
