!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRg0g0(LB,LK,VRR0,VRR1)

      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(11,13)
      V(2)=HfxZpE*VRR1(11,14)
      V(3)=HfxZpE*VRR1(11,17)
      V(4)=HfxZpE*VRR1(11,18)
      V(5)=HfxZpE*VRR1(11,19)
      V(6)=HfxZpE*VRR1(11,20)
      V(7)=r1x2E*VRR0(22,6)
      V(8)=2.D0*V(7)
      V(9)=r1x2E*ZxZpE*VRR1(22,6)
      V(10)=-2.D0*V(9)
      V(11)=r1x2Z*VRR0(6,23)
      V(12)=2.D0*V(11)
      V(13)=ExZpE*r1x2Z*VRR1(6,23)
      V(14)=-2.D0*V(13)
      V(15)=HfxZpE*VRR1(12,13)
      V(16)=2.D0*V(15)
      V(17)=r1x2E*VRR0(22,8)
      V(18)=2.D0*V(17)
      V(19)=r1x2E*ZxZpE*VRR1(22,8)
      V(20)=-2.D0*V(19)
      V(21)=r1x2Z*VRR0(6,27)
      V(22)=2.D0*V(21)
      V(23)=ExZpE*r1x2Z*VRR1(6,27)
      V(24)=-2.D0*V(23)
      V(25)=HfxZpE*VRR1(12,16)
      V(26)=2.D0*V(25)
      V(27)=r1x2Z*VRR0(6,28)
      V(28)=2.D0*V(27)
      V(29)=ExZpE*r1x2Z*VRR1(6,28)
      V(30)=-2.D0*V(29)
      V(31)=HfxZpE*VRR1(12,17)
      V(32)=r1x2E*VRR0(22,9)
      V(33)=2.D0*V(32)
      V(34)=r1x2E*ZxZpE*VRR1(22,9)
      V(35)=-2.D0*V(34)
      V(36)=r1x2Z*VRR0(6,30)
      V(37)=2.D0*V(36)
      V(38)=ExZpE*r1x2Z*VRR1(6,30)
      V(39)=-2.D0*V(38)
      V(40)=HfxZpE*VRR1(12,18)
      V(41)=r1x2Z*VRR0(6,31)
      V(42)=2.D0*V(41)
      V(43)=ExZpE*r1x2Z*VRR1(6,31)
      V(44)=-2.D0*V(43)
      V(45)=HfxZpE*VRR1(12,19)
      V(46)=r1x2Z*VRR0(6,32)
      V(47)=2.D0*V(46)
      V(48)=ExZpE*r1x2Z*VRR1(6,32)
      V(49)=-2.D0*V(48)
      V(50)=r1x2E*VRR0(23,6)
      V(51)=2.D0*V(50)
      V(52)=HfxZpE*VRR1(13,12)
      V(53)=2.D0*V(52)
      V(54)=r1x2E*ZxZpE*VRR1(23,6)
      V(55)=-2.D0*V(54)
      V(56)=r1x2E*VRR0(23,7)
      V(57)=HfxZpE*VRR1(13,13)
      V(58)=r1x2E*ZxZpE*VRR1(23,7)
      V(59)=r1x2E*VRR0(23,8)
      V(60)=2.D0*V(59)
      V(61)=HfxZpE*VRR1(13,15)
      V(62)=r1x2E*ZxZpE*VRR1(23,8)
      V(63)=-2.D0*V(62)
      V(64)=r1x2E*VRR0(23,9)
      V(65)=HfxZpE*VRR1(13,16)
      V(66)=2.D0*V(65)
      V(67)=r1x2E*ZxZpE*VRR1(23,9)
      V(68)=2.D0*V(64)
      V(69)=-2.D0*V(67)
      V(70)=r1x2E*VRR0(23,10)
      V(71)=HfxZpE*VRR1(13,18)
      V(72)=r1x2E*ZxZpE*VRR1(23,10)
      V(73)=-V(72)
      V(74)=HfxZpE*VRR1(14,11)
      V(75)=r1x2E*VRR0(24,6)
      V(76)=2.D0*V(75)
      V(77)=HfxZpE*VRR1(14,12)
      V(78)=r1x2E*ZxZpE*VRR1(24,6)
      V(79)=-2.D0*V(78)
      V(80)=r1x2E*VRR0(24,8)
      V(81)=2.D0*V(80)
      V(82)=HfxZpE*VRR1(14,15)
      V(83)=r1x2E*ZxZpE*VRR1(24,8)
      V(84)=-2.D0*V(83)
      V(85)=r1x2E*VRR0(24,9)
      V(86)=2.D0*V(85)
      V(87)=r1x2E*ZxZpE*VRR1(24,9)
      V(88)=-2.D0*V(87)
      V(89)=HfxZpE*VRR1(13,19)
      V(90)=HfxZpE*VRR1(14,18)
      V(91)=HfxZpE*VRR1(14,19)
      V(92)=HfxZpE*VRR1(14,20)
      V(93)=r1x2E*VRR0(26,6)
      V(94)=2.D0*V(93)
      V(95)=r1x2E*ZxZpE*VRR1(26,6)
      V(96)=-2.D0*V(95)
      V(97)=r1x2Z*VRR0(8,23)
      V(98)=2.D0*V(97)
      V(99)=ExZpE*r1x2Z*VRR1(8,23)
      V(100)=-2.D0*V(99)
      V(101)=HfxZpE*VRR1(15,13)
      V(102)=r1x2E*VRR0(26,8)
      V(103)=2.D0*V(102)
      V(104)=r1x2E*ZxZpE*VRR1(26,8)
      V(105)=-2.D0*V(104)
      V(106)=r1x2Z*VRR0(8,27)
      V(107)=2.D0*V(106)
      V(108)=ExZpE*r1x2Z*VRR1(8,27)
      V(109)=-2.D0*V(108)
      V(110)=HfxZpE*VRR1(15,16)
      V(111)=2.D0*V(110)
      V(112)=r1x2Z*VRR0(8,28)
      V(113)=2.D0*V(112)
      V(114)=ExZpE*r1x2Z*VRR1(8,28)
      V(115)=-2.D0*V(114)
      V(116)=HfxZpE*VRR1(15,17)
      V(117)=r1x2E*VRR0(26,9)
      V(118)=2.D0*V(117)
      V(119)=r1x2E*ZxZpE*VRR1(26,9)
      V(120)=-2.D0*V(119)
      V(121)=r1x2Z*VRR0(8,30)
      V(122)=2.D0*V(121)
      V(123)=ExZpE*r1x2Z*VRR1(8,30)
      V(124)=-2.D0*V(123)
      V(125)=HfxZpE*VRR1(15,18)
      V(126)=2.D0*V(125)
      V(127)=r1x2Z*VRR0(8,31)
      V(128)=2.D0*V(127)
      V(129)=ExZpE*r1x2Z*VRR1(8,31)
      V(130)=-2.D0*V(129)
      V(131)=HfxZpE*VRR1(15,19)
      V(132)=r1x2Z*VRR0(8,32)
      V(133)=2.D0*V(132)
      V(134)=ExZpE*r1x2Z*VRR1(8,32)
      V(135)=-2.D0*V(134)
      V(136)=r1x2E*VRR0(27,6)
      V(137)=2.D0*V(136)
      V(138)=r1x2E*ZxZpE*VRR1(27,6)
      V(139)=-2.D0*V(138)
      V(140)=r1x2E*VRR0(27,7)
      V(141)=HfxZpE*VRR1(16,13)
      V(142)=2.D0*V(141)
      V(143)=r1x2E*ZxZpE*VRR1(27,7)
      V(144)=r1x2E*VRR0(27,8)
      V(145)=2.D0*V(144)
      V(146)=r1x2E*ZxZpE*VRR1(27,8)
      V(147)=-2.D0*V(146)
      V(148)=r1x2E*VRR0(27,9)
      V(149)=HfxZpE*VRR1(16,16)
      V(150)=2.D0*V(149)
      V(151)=r1x2E*ZxZpE*VRR1(27,9)
      V(152)=2.D0*V(148)
      V(153)=-2.D0*V(151)
      V(154)=r1x2E*VRR0(27,10)
      V(155)=HfxZpE*VRR1(16,18)
      V(156)=2.D0*V(155)
      V(157)=r1x2E*ZxZpE*VRR1(27,10)
      V(158)=-V(157)
      V(159)=r1x2E*VRR0(28,6)
      V(160)=2.D0*V(159)
      V(161)=HfxZpE*VRR1(17,12)
      V(162)=r1x2E*ZxZpE*VRR1(28,6)
      V(163)=-2.D0*V(162)
      V(164)=r1x2E*VRR0(28,7)
      V(165)=HfxZpE*VRR1(17,13)
      V(166)=r1x2E*ZxZpE*VRR1(28,7)
      V(167)=r1x2E*VRR0(28,8)
      V(168)=2.D0*V(167)
      V(169)=HfxZpE*VRR1(17,15)
      V(170)=r1x2E*ZxZpE*VRR1(28,8)
      V(171)=-2.D0*V(170)
      V(172)=r1x2E*VRR0(28,9)
      V(173)=HfxZpE*VRR1(17,16)
      V(174)=r1x2E*ZxZpE*VRR1(28,9)
      V(175)=2.D0*V(172)
      V(176)=-2.D0*V(174)
      V(177)=r1x2E*VRR0(28,10)
      V(178)=HfxZpE*VRR1(17,18)
      V(179)=r1x2E*ZxZpE*VRR1(28,10)
      V(180)=-V(179)
      V(181)=HfxZpE*VRR1(16,19)
      V(182)=2.D0*V(181)
      V(183)=r1x2E*VRR0(29,6)
      V(184)=2.D0*V(183)
      V(185)=r1x2E*ZxZpE*VRR1(29,6)
      V(186)=-2.D0*V(185)
      V(187)=r1x2Z*VRR0(9,23)
      V(188)=2.D0*V(187)
      V(189)=ExZpE*r1x2Z*VRR1(9,23)
      V(190)=-2.D0*V(189)
      V(191)=r1x2E*VRR0(29,8)
      V(192)=2.D0*V(191)
      V(193)=r1x2E*ZxZpE*VRR1(29,8)
      V(194)=-2.D0*V(193)
      V(195)=r1x2Z*VRR0(9,27)
      V(196)=2.D0*V(195)
      V(197)=ExZpE*r1x2Z*VRR1(9,27)
      V(198)=-2.D0*V(197)
      V(199)=r1x2Z*VRR0(9,28)
      V(200)=2.D0*V(199)
      V(201)=ExZpE*r1x2Z*VRR1(9,28)
      V(202)=-2.D0*V(201)
      V(203)=2.D0*V(173)
      V(204)=r1x2E*VRR0(29,9)
      V(205)=2.D0*V(204)
      V(206)=r1x2E*ZxZpE*VRR1(29,9)
      V(207)=-2.D0*V(206)
      V(208)=r1x2Z*VRR0(9,30)
      V(209)=2.D0*V(208)
      V(210)=ExZpE*r1x2Z*VRR1(9,30)
      V(211)=-2.D0*V(210)
      V(212)=r1x2Z*VRR0(9,31)
      V(213)=2.D0*V(212)
      V(214)=ExZpE*r1x2Z*VRR1(9,31)
      V(215)=-2.D0*V(214)
      V(216)=r1x2Z*VRR0(9,32)
      V(217)=2.D0*V(216)
      V(218)=ExZpE*r1x2Z*VRR1(9,32)
      V(219)=-2.D0*V(218)
      V(220)=HfxZpE*VRR1(17,19)
      V(221)=2.D0*V(220)
      V(222)=r1x2E*VRR0(30,6)
      V(223)=2.D0*V(222)
      V(224)=HfxZpE*VRR1(18,12)
      V(225)=r1x2E*ZxZpE*VRR1(30,6)
      V(226)=-2.D0*V(225)
      V(227)=r1x2E*VRR0(30,7)
      V(228)=HfxZpE*VRR1(18,13)
      V(229)=r1x2E*ZxZpE*VRR1(30,7)
      V(230)=r1x2E*VRR0(30,8)
      V(231)=2.D0*V(230)
      V(232)=HfxZpE*VRR1(18,15)
      V(233)=2.D0*V(232)
      V(234)=r1x2E*ZxZpE*VRR1(30,8)
      V(235)=-2.D0*V(234)
      V(236)=r1x2E*VRR0(30,9)
      V(237)=HfxZpE*VRR1(18,16)
      V(238)=2.D0*V(237)
      V(239)=r1x2E*ZxZpE*VRR1(30,9)
      V(240)=2.D0*V(236)
      V(241)=-2.D0*V(239)
      V(242)=r1x2E*VRR0(30,10)
      V(243)=HfxZpE*VRR1(18,18)
      V(244)=r1x2E*ZxZpE*VRR1(30,10)
      V(245)=-V(244)
      V(246)=r1x2E*VRR0(31,6)
      V(247)=2.D0*V(246)
      V(248)=HfxZpE*VRR1(19,12)
      V(249)=r1x2E*ZxZpE*VRR1(31,6)
      V(250)=-2.D0*V(249)
      V(251)=r1x2E*VRR0(31,7)
      V(252)=HfxZpE*VRR1(19,13)
      V(253)=r1x2E*ZxZpE*VRR1(31,7)
      V(254)=r1x2E*VRR0(31,8)
      V(255)=2.D0*V(254)
      V(256)=HfxZpE*VRR1(19,15)
      V(257)=r1x2E*ZxZpE*VRR1(31,8)
      V(258)=-2.D0*V(257)
      V(259)=r1x2E*VRR0(31,9)
      V(260)=HfxZpE*VRR1(19,16)
      V(261)=r1x2E*ZxZpE*VRR1(31,9)
      V(262)=2.D0*V(259)
      V(263)=HfxZpE*VRR1(18,17)
      V(264)=-2.D0*V(261)
      V(265)=r1x2E*VRR0(31,10)
      V(266)=HfxZpE*VRR1(19,18)
      V(267)=r1x2E*ZxZpE*VRR1(31,10)
      V(268)=-V(267)
      V(269)=HfxZpE*VRR1(18,19)
      V(270)=r1x2E*VRR0(32,6)
      V(271)=2.D0*V(270)
      V(272)=r1x2E*ZxZpE*VRR1(32,6)
      V(273)=-2.D0*V(272)
      V(274)=r1x2E*VRR0(32,7)
      V(275)=r1x2E*ZxZpE*VRR1(32,7)
      V(276)=r1x2E*VRR0(32,8)
      V(277)=2.D0*V(276)
      V(278)=r1x2E*ZxZpE*VRR1(32,8)
      V(279)=-2.D0*V(278)
      V(280)=r1x2E*VRR0(32,9)
      V(281)=r1x2E*ZxZpE*VRR1(32,9)
      V(282)=2.D0*V(260)
      V(283)=2.D0*V(280)
      V(284)=HfxZpE*VRR1(19,17)
      V(285)=2.D0*V(284)
      V(286)=-2.D0*V(281)
      V(287)=r1x2E*VRR0(32,10)
      V(288)=r1x2E*ZxZpE*VRR1(32,10)
      V(289)=-V(288)
      V(290)=HfxZpE*VRR1(19,19)
      V(291)=HfxZpE*VRR1(20,11)
      V(292)=r1x2E*VRR0(33,6)
      V(293)=2.D0*V(292)
      V(294)=HfxZpE*VRR1(20,12)
      V(295)=r1x2E*ZxZpE*VRR1(33,6)
      V(296)=-2.D0*V(295)
      V(297)=r1x2E*VRR0(33,8)
      V(298)=2.D0*V(297)
      V(299)=HfxZpE*VRR1(20,15)
      V(300)=r1x2E*ZxZpE*VRR1(33,8)
      V(301)=-2.D0*V(300)
      V(302)=r1x2E*VRR0(33,9)
      V(303)=2.D0*V(302)
      V(304)=r1x2E*ZxZpE*VRR1(33,9)
      V(305)=-2.D0*V(304)
      V(306)=r1x2E*VRR0(34,6)
      V(307)=2.D0*V(306)
      V(308)=r1x2E*ZxZpE*VRR1(34,6)
      V(309)=-2.D0*V(308)
      V(310)=HfxZpE*VRR1(20,13)
      V(311)=HfxZpE*VRR1(20,14)
      V(312)=r1x2E*VRR0(34,8)
      V(313)=2.D0*V(312)
      V(314)=r1x2E*ZxZpE*VRR1(34,8)
      V(315)=-2.D0*V(314)
      V(316)=r1x2E*VRR0(34,9)
      V(317)=2.D0*V(316)
      V(318)=HfxZpE*VRR1(20,17)
      V(319)=r1x2E*ZxZpE*VRR1(34,9)
      V(320)=-2.D0*V(319)
      VRR0(21,21)=3.D0*r1x2E*VRR0(21,5)+QCx*VRR0(21,11)+4.D0*HfxZpE*VRR1(11,11)-3.D0*r1x2E*ZxZpE*VRR1(21,5)+WQx*VRR1(21,11)
      VRR0(21,22)=3.D0*r1x2Z*VRR0(5,22)+PAx*VRR0(11,22)-3.D0*ExZpE*r1x2Z*VRR1(5,22)+3.D0*HfxZpE*VRR1(11,12)+WPx*VRR1(11,22)
      VRR0(21,23)=2.D0*V(1)+3.D0*r1x2Z*VRR0(5,23)+PAx*VRR0(11,23)-3.D0*ExZpE*r1x2Z*VRR1(5,23)+WPx*VRR1(11,23)
      VRR0(21,24)=V(2)+3.D0*r1x2Z*VRR0(5,24)+PAx*VRR0(11,24)-3.D0*ExZpE*r1x2Z*VRR1(5,24)+WPx*VRR1(11,24)
      VRR0(21,25)=3.D0*r1x2E*VRR0(21,7)+QCy*VRR0(21,14)-3.D0*r1x2E*ZxZpE*VRR1(21,7)+WQy*VRR1(21,14)
      VRR0(21,26)=3.D0*r1x2Z*VRR0(5,26)+PAx*VRR0(11,26)-3.D0*ExZpE*r1x2Z*VRR1(5,26)+3.D0*HfxZpE*VRR1(11,15)+WPx*VRR1(11,26)
      VRR0(21,27)=3.D0*r1x2Z*VRR0(5,27)+PAx*VRR0(11,27)-3.D0*ExZpE*r1x2Z*VRR1(5,27)+2.D0*HfxZpE*VRR1(11,16)+WPx*VRR1(11,27)
      VRR0(21,28)=V(3)+3.D0*r1x2Z*VRR0(5,28)+PAx*VRR0(11,28)-3.D0*ExZpE*r1x2Z*VRR1(5,28)+WPx*VRR1(11,28)
      VRR0(21,29)=3.D0*r1x2Z*VRR0(5,29)+PAx*VRR0(11,29)-3.D0*ExZpE*r1x2Z*VRR1(5,29)+WPx*VRR1(11,29)
      VRR0(21,30)=2.D0*V(4)+3.D0*r1x2Z*VRR0(5,30)+PAx*VRR0(11,30)-3.D0*ExZpE*r1x2Z*VRR1(5,30)+WPx*VRR1(11,30)
      VRR0(21,31)=V(5)+3.D0*r1x2Z*VRR0(5,31)+PAx*VRR0(11,31)-3.D0*ExZpE*r1x2Z*VRR1(5,31)+WPx*VRR1(11,31)
      VRR0(21,32)=3.D0*r1x2Z*VRR0(5,32)+PAx*VRR0(11,32)-3.D0*ExZpE*r1x2Z*VRR1(5,32)+WPx*VRR1(11,32)
      VRR0(21,33)=V(6)+3.D0*r1x2Z*VRR0(5,33)+PAx*VRR0(11,33)-3.D0*ExZpE*r1x2Z*VRR1(5,33)+WPx*VRR1(11,33)
      VRR0(21,34)=3.D0*r1x2Z*VRR0(5,34)+PAx*VRR0(11,34)-3.D0*ExZpE*r1x2Z*VRR1(5,34)+WPx*VRR1(11,34)
      VRR0(21,35)=3.D0*r1x2E*VRR0(21,10)+QCz*VRR0(21,20)-3.D0*r1x2E*ZxZpE*VRR1(21,10)+WQz*VRR1(21,20)
      VRR0(22,21)=3.D0*r1x2E*VRR0(22,5)+QCx*VRR0(22,11)+3.D0*HfxZpE*VRR1(12,11)-3.D0*r1x2E*ZxZpE*VRR1(22,5)+WQx*VRR1(22,11)
      VRR0(22,22)=V(8)+V(10)+QCx*VRR0(22,12)+3.D0*HfxZpE*VRR1(12,12)+WQx*VRR1(22,12)
      VRR0(22,23)=V(12)+V(14)+V(16)+PAx*VRR0(12,23)+WPx*VRR1(12,23)
      VRR0(22,24)=V(1)+V(8)+V(10)+QCy*VRR0(22,13)+WQy*VRR1(22,13)
      VRR0(22,25)=V(2)+3.D0*r1x2E*VRR0(22,7)+QCy*VRR0(22,14)-3.D0*r1x2E*ZxZpE*VRR1(22,7)+WQy*VRR1(22,14)
      VRR0(22,26)=V(18)+V(20)+QCx*VRR0(22,15)+3.D0*HfxZpE*VRR1(12,15)+WQx*VRR1(22,15)
      VRR0(22,27)=V(22)+V(24)+V(26)+PAx*VRR0(12,27)+WPx*VRR1(12,27)
      VRR0(22,28)=V(28)+V(30)+V(31)+PAx*VRR0(12,28)+WPx*VRR1(12,28)
      VRR0(22,29)=V(3)+V(33)+V(35)+QCy*VRR0(22,17)+WQy*VRR1(22,17)
      VRR0(22,30)=V(37)+V(39)+2.D0*V(40)+PAx*VRR0(12,30)+WPx*VRR1(12,30)
      VRR0(22,31)=V(42)+V(44)+V(45)+PAx*VRR0(12,31)+WPx*VRR1(12,31)
      VRR0(22,32)=V(47)+V(49)+PAx*VRR0(12,32)+WPx*VRR1(12,32)
      VRR0(22,33)=V(18)+V(20)+QCz*VRR0(22,18)+WQz*VRR1(22,18)
      VRR0(22,34)=V(33)+V(35)+QCz*VRR0(22,19)+WQz*VRR1(22,19)
      VRR0(22,35)=3.D0*r1x2E*VRR0(22,10)+QCz*VRR0(22,20)-3.D0*r1x2E*ZxZpE*VRR1(22,10)+WQz*VRR1(22,20)
      VRR0(23,21)=3.D0*r1x2E*VRR0(23,5)+QCx*VRR0(23,11)+2.D0*HfxZpE*VRR1(13,11)-3.D0*r1x2E*ZxZpE*VRR1(23,5)+WQx*VRR1(23,11)
      VRR0(23,22)=V(51)+V(53)+V(55)+QCx*VRR0(23,12)+WQx*VRR1(23,12)
      VRR0(23,23)=V(56)+2.D0*V(57)-V(58)+QCx*VRR0(23,13)+WQx*VRR1(23,13)
      VRR0(23,24)=V(16)+V(51)+V(55)+QCy*VRR0(23,13)+WQy*VRR1(23,13)
      VRR0(23,25)=3.D0*V(56)-3.D0*V(58)+QCy*VRR0(23,14)+2.D0*HfxZpE*VRR1(12,14)+WQy*VRR1(23,14)
      VRR0(23,26)=V(60)+2.D0*V(61)+V(63)+QCx*VRR0(23,15)+WQx*VRR1(23,15)
      VRR0(23,27)=V(64)+V(66)-V(67)+QCx*VRR0(23,16)+WQx*VRR1(23,16)
      VRR0(23,28)=V(26)+V(59)-V(62)+QCy*VRR0(23,16)+WQy*VRR1(23,16)
      VRR0(23,29)=2.D0*V(31)+V(68)+V(69)+QCy*VRR0(23,17)+WQy*VRR1(23,17)
      VRR0(23,30)=V(70)+2.D0*V(71)+V(73)+QCx*VRR0(23,18)+WQx*VRR1(23,18)
      VRR0(23,31)=V(50)-V(54)+QCz*VRR0(23,16)+WQz*VRR1(23,16)
      VRR0(23,32)=2.D0*V(45)+V(70)+V(73)+QCy*VRR0(23,19)+WQy*VRR1(23,19)
      VRR0(23,33)=V(60)+V(63)+QCz*VRR0(23,18)+WQz*VRR1(23,18)
      VRR0(23,34)=V(68)+V(69)+QCz*VRR0(23,19)+WQz*VRR1(23,19)
      VRR0(23,35)=3.D0*V(70)-3.D0*V(72)+QCz*VRR0(23,20)+WQz*VRR1(23,20)
      VRR0(24,21)=V(74)+3.D0*r1x2E*VRR0(24,5)+QCx*VRR0(24,11)-3.D0*r1x2E*ZxZpE*VRR1(24,5)+WQx*VRR1(24,11)
      VRR0(24,22)=V(76)+V(77)+V(79)+QCx*VRR0(24,12)+WQx*VRR1(24,12)
      VRR0(24,23)=V(12)+V(14)+V(53)+PAy*VRR0(13,23)+WPy*VRR1(13,23)
      VRR0(24,24)=3.D0*V(57)+V(76)+V(79)+QCy*VRR0(24,13)+WQy*VRR1(24,13)
      VRR0(24,25)=3.D0*r1x2E*VRR0(24,7)+QCy*VRR0(24,14)+3.D0*HfxZpE*VRR1(13,14)-3.D0*r1x2E*ZxZpE*VRR1(24,7)+WQy*VRR1(24,14)
      VRR0(24,26)=V(81)+V(82)+V(84)+QCx*VRR0(24,15)+WQx*VRR1(24,15)
      VRR0(24,27)=V(22)+V(24)+V(61)+PAy*VRR0(13,27)+WPy*VRR1(13,27)
      VRR0(24,28)=V(28)+V(30)+V(66)+PAy*VRR0(13,28)+WPy*VRR1(13,28)
      VRR0(24,29)=V(86)+V(88)+QCy*VRR0(24,17)+3.D0*HfxZpE*VRR1(13,17)+WQy*VRR1(24,17)
      VRR0(24,30)=V(37)+V(39)+PAy*VRR0(13,30)+WPy*VRR1(13,30)
      VRR0(24,31)=V(42)+V(44)+V(71)+PAy*VRR0(13,31)+WPy*VRR1(13,31)
      VRR0(24,32)=V(47)+V(49)+2.D0*V(89)+PAy*VRR0(13,32)+WPy*VRR1(13,32)
      VRR0(24,33)=V(81)+V(84)+QCz*VRR0(24,18)+WQz*VRR1(24,18)
      VRR0(24,34)=V(86)+V(88)+QCz*VRR0(24,19)+WQz*VRR1(24,19)
      VRR0(24,35)=3.D0*r1x2E*VRR0(24,10)+QCz*VRR0(24,20)-3.D0*r1x2E*ZxZpE*VRR1(24,10)+WQz*VRR1(24,20)
      VRR0(25,21)=3.D0*r1x2E*VRR0(25,5)+QCx*VRR0(25,11)-3.D0*r1x2E*ZxZpE*VRR1(25,5)+WQx*VRR1(25,11)
      VRR0(25,22)=V(74)+3.D0*r1x2Z*VRR0(7,22)+PAy*VRR0(14,22)-3.D0*ExZpE*r1x2Z*VRR1(7,22)+WPy*VRR1(14,22)
      VRR0(25,23)=2.D0*V(77)+3.D0*r1x2Z*VRR0(7,23)+PAy*VRR0(14,23)-3.D0*ExZpE*r1x2Z*VRR1(7,23)+WPy*VRR1(14,23)
      VRR0(25,24)=3.D0*r1x2Z*VRR0(7,24)+PAy*VRR0(14,24)-3.D0*ExZpE*r1x2Z*VRR1(7,24)+3.D0*HfxZpE*VRR1(14,13)+WPy*VRR1(14,24)
      VRR0(25,25)=3.D0*r1x2E*VRR0(25,7)+QCy*VRR0(25,14)+4.D0*HfxZpE*VRR1(14,14)-3.D0*r1x2E*ZxZpE*VRR1(25,7)+WQy*VRR1(25,14)
      VRR0(25,26)=3.D0*r1x2Z*VRR0(7,26)+PAy*VRR0(14,26)-3.D0*ExZpE*r1x2Z*VRR1(7,26)+WPy*VRR1(14,26)
      VRR0(25,27)=V(82)+3.D0*r1x2Z*VRR0(7,27)+PAy*VRR0(14,27)-3.D0*ExZpE*r1x2Z*VRR1(7,27)+WPy*VRR1(14,27)
      VRR0(25,28)=3.D0*r1x2Z*VRR0(7,28)+PAy*VRR0(14,28)-3.D0*ExZpE*r1x2Z*VRR1(7,28)+2.D0*HfxZpE*VRR1(14,16)+WPy*VRR1(14,28)
      VRR0(25,29)=3.D0*r1x2Z*VRR0(7,29)+PAy*VRR0(14,29)-3.D0*ExZpE*r1x2Z*VRR1(7,29)+3.D0*HfxZpE*VRR1(14,17)+WPy*VRR1(14,29)
      VRR0(25,30)=3.D0*r1x2Z*VRR0(7,30)+PAy*VRR0(14,30)-3.D0*ExZpE*r1x2Z*VRR1(7,30)+WPy*VRR1(14,30)
      VRR0(25,31)=V(90)+3.D0*r1x2Z*VRR0(7,31)+PAy*VRR0(14,31)-3.D0*ExZpE*r1x2Z*VRR1(7,31)+WPy*VRR1(14,31)
      VRR0(25,32)=2.D0*V(91)+3.D0*r1x2Z*VRR0(7,32)+PAy*VRR0(14,32)-3.D0*ExZpE*r1x2Z*VRR1(7,32)+WPy*VRR1(14,32)
      VRR0(25,33)=3.D0*r1x2Z*VRR0(7,33)+PAy*VRR0(14,33)-3.D0*ExZpE*r1x2Z*VRR1(7,33)+WPy*VRR1(14,33)
      VRR0(25,34)=V(92)+3.D0*r1x2Z*VRR0(7,34)+PAy*VRR0(14,34)-3.D0*ExZpE*r1x2Z*VRR1(7,34)+WPy*VRR1(14,34)
      VRR0(25,35)=3.D0*r1x2E*VRR0(25,10)+QCz*VRR0(25,20)-3.D0*r1x2E*ZxZpE*VRR1(25,10)+WQz*VRR1(25,20)
      VRR0(26,21)=3.D0*r1x2E*VRR0(26,5)+QCx*VRR0(26,11)+3.D0*HfxZpE*VRR1(15,11)-3.D0*r1x2E*ZxZpE*VRR1(26,5)+WQx*VRR1(26,11)
      VRR0(26,22)=V(94)+V(96)+QCx*VRR0(26,12)+3.D0*HfxZpE*VRR1(15,12)+WQx*VRR1(26,12)
      VRR0(26,23)=V(98)+V(100)+2.D0*V(101)+PAx*VRR0(15,23)+WPx*VRR1(15,23)
      VRR0(26,24)=V(94)+V(96)+QCy*VRR0(26,13)+WQy*VRR1(26,13)
      VRR0(26,25)=3.D0*r1x2E*VRR0(26,7)+QCy*VRR0(26,14)-3.D0*r1x2E*ZxZpE*VRR1(26,7)+WQy*VRR1(26,14)
      VRR0(26,26)=V(103)+V(105)+QCx*VRR0(26,15)+3.D0*HfxZpE*VRR1(15,15)+WQx*VRR1(26,15)
      VRR0(26,27)=V(107)+V(109)+V(111)+PAx*VRR0(15,27)+WPx*VRR1(15,27)
      VRR0(26,28)=V(113)+V(115)+V(116)+PAx*VRR0(15,28)+WPx*VRR1(15,28)
      VRR0(26,29)=V(118)+V(120)+QCy*VRR0(26,17)+WQy*VRR1(26,17)
      VRR0(26,30)=V(122)+V(124)+V(126)+PAx*VRR0(15,30)+WPx*VRR1(15,30)
      VRR0(26,31)=V(128)+V(130)+V(131)+PAx*VRR0(15,31)+WPx*VRR1(15,31)
      VRR0(26,32)=V(133)+V(135)+PAx*VRR0(15,32)+WPx*VRR1(15,32)
      VRR0(26,33)=V(4)+V(103)+V(105)+QCz*VRR0(26,18)+WQz*VRR1(26,18)
      VRR0(26,34)=V(5)+V(118)+V(120)+QCz*VRR0(26,19)+WQz*VRR1(26,19)
      VRR0(26,35)=V(6)+3.D0*r1x2E*VRR0(26,10)+QCz*VRR0(26,20)-3.D0*r1x2E*ZxZpE*VRR1(26,10)+WQz*VRR1(26,20)
      VRR0(27,21)=3.D0*r1x2E*VRR0(27,5)+QCx*VRR0(27,11)+2.D0*HfxZpE*VRR1(16,11)-3.D0*r1x2E*ZxZpE*VRR1(27,5)+WQx*VRR1(27,11)
      VRR0(27,22)=V(137)+V(139)+QCx*VRR0(27,12)+2.D0*HfxZpE*VRR1(16,12)+WQx*VRR1(27,12)
      VRR0(27,23)=V(140)+V(142)-V(143)+QCx*VRR0(27,13)+WQx*VRR1(27,13)
      VRR0(27,24)=V(101)+V(137)+V(139)+QCy*VRR0(27,13)+WQy*VRR1(27,13)
      VRR0(27,25)=3.D0*V(140)-3.D0*V(143)+QCy*VRR0(27,14)+HfxZpE*VRR1(15,14)+WQy*VRR1(27,14)
      VRR0(27,26)=V(145)+V(147)+QCx*VRR0(27,15)+2.D0*HfxZpE*VRR1(16,15)+WQx*VRR1(27,15)
      VRR0(27,27)=V(148)+V(150)-V(151)+QCx*VRR0(27,16)+WQx*VRR1(27,16)
      VRR0(27,28)=V(110)+V(144)-V(146)+QCy*VRR0(27,16)+WQy*VRR1(27,16)
      VRR0(27,29)=V(116)+V(152)+V(153)+QCy*VRR0(27,17)+WQy*VRR1(27,17)
      VRR0(27,30)=V(154)+V(156)+V(158)+QCx*VRR0(27,18)+WQx*VRR1(27,18)
      VRR0(27,31)=V(25)+V(136)-V(138)+QCz*VRR0(27,16)+WQz*VRR1(27,16)
      VRR0(27,32)=V(131)+V(154)+V(158)+QCy*VRR0(27,19)+WQy*VRR1(27,19)
      VRR0(27,33)=V(40)+V(145)+V(147)+QCz*VRR0(27,18)+WQz*VRR1(27,18)
      VRR0(27,34)=V(45)+V(152)+V(153)+QCz*VRR0(27,19)+WQz*VRR1(27,19)
      VRR0(27,35)=3.D0*V(154)-3.D0*V(157)+QCz*VRR0(27,20)+HfxZpE*VRR1(12,20)+WQz*VRR1(27,20)
      VRR0(28,21)=3.D0*r1x2E*VRR0(28,5)+QCx*VRR0(28,11)+HfxZpE*VRR1(17,11)-3.D0*r1x2E*ZxZpE*VRR1(28,5)+WQx*VRR1(28,11)
      VRR0(28,22)=V(160)+V(161)+V(163)+QCx*VRR0(28,12)+WQx*VRR1(28,12)
      VRR0(28,23)=V(164)+V(165)-V(166)+QCx*VRR0(28,13)+WQx*VRR1(28,13)
      VRR0(28,24)=V(142)+V(160)+V(163)+QCy*VRR0(28,13)+WQy*VRR1(28,13)
      VRR0(28,25)=3.D0*V(164)-3.D0*V(166)+QCy*VRR0(28,14)+2.D0*HfxZpE*VRR1(16,14)+WQy*VRR1(28,14)
      VRR0(28,26)=V(168)+V(169)+V(171)+QCx*VRR0(28,15)+WQx*VRR1(28,15)
      VRR0(28,27)=V(172)+V(173)-V(174)+QCx*VRR0(28,16)+WQx*VRR1(28,16)
      VRR0(28,28)=V(150)+V(167)-V(170)+QCy*VRR0(28,16)+WQy*VRR1(28,16)
      VRR0(28,29)=V(175)+V(176)+QCy*VRR0(28,17)+2.D0*HfxZpE*VRR1(16,17)+WQy*VRR1(28,17)
      VRR0(28,30)=V(177)+V(178)+V(180)+QCx*VRR0(28,18)+WQx*VRR1(28,18)
      VRR0(28,31)=V(65)+V(159)-V(162)+QCz*VRR0(28,16)+WQz*VRR1(28,16)
      VRR0(28,32)=V(177)+V(180)+V(182)+QCy*VRR0(28,19)+WQy*VRR1(28,19)
      VRR0(28,33)=V(71)+V(168)+V(171)+QCz*VRR0(28,18)+WQz*VRR1(28,18)
      VRR0(28,34)=V(89)+V(175)+V(176)+QCz*VRR0(28,19)+WQz*VRR1(28,19)
      VRR0(28,35)=3.D0*V(177)-3.D0*V(179)+QCz*VRR0(28,20)+HfxZpE*VRR1(13,20)+WQz*VRR1(28,20)
      VRR0(29,21)=3.D0*r1x2E*VRR0(29,5)+QCx*VRR0(29,11)-3.D0*r1x2E*ZxZpE*VRR1(29,5)+WQx*VRR1(29,11)
      VRR0(29,22)=V(184)+V(186)+QCx*VRR0(29,12)+WQx*VRR1(29,12)
      VRR0(29,23)=2.D0*V(161)+V(188)+V(190)+PAy*VRR0(17,23)+WPy*VRR1(17,23)
      VRR0(29,24)=3.D0*V(165)+V(184)+V(186)+QCy*VRR0(29,13)+WQy*VRR1(29,13)
      VRR0(29,25)=3.D0*r1x2E*VRR0(29,7)+QCy*VRR0(29,14)+3.D0*HfxZpE*VRR1(17,14)-3.D0*r1x2E*ZxZpE*VRR1(29,7)+WQy*VRR1(29,14)
      VRR0(29,26)=V(192)+V(194)+QCx*VRR0(29,15)+WQx*VRR1(29,15)
      VRR0(29,27)=V(169)+V(196)+V(198)+PAy*VRR0(17,27)+WPy*VRR1(17,27)
      VRR0(29,28)=V(200)+V(202)+V(203)+PAy*VRR0(17,28)+WPy*VRR1(17,28)
      VRR0(29,29)=V(205)+V(207)+QCy*VRR0(29,17)+3.D0*HfxZpE*VRR1(17,17)+WQy*VRR1(29,17)
      VRR0(29,30)=V(209)+V(211)+PAy*VRR0(17,30)+WPy*VRR1(17,30)
      VRR0(29,31)=V(178)+V(213)+V(215)+PAy*VRR0(17,31)+WPy*VRR1(17,31)
      VRR0(29,32)=V(217)+V(219)+V(221)+PAy*VRR0(17,32)+WPy*VRR1(17,32)
      VRR0(29,33)=V(90)+V(192)+V(194)+QCz*VRR0(29,18)+WQz*VRR1(29,18)
      VRR0(29,34)=V(91)+V(205)+V(207)+QCz*VRR0(29,19)+WQz*VRR1(29,19)
      VRR0(29,35)=V(92)+3.D0*r1x2E*VRR0(29,10)+QCz*VRR0(29,20)-3.D0*r1x2E*ZxZpE*VRR1(29,10)+WQz*VRR1(29,20)
      VRR0(30,21)=3.D0*r1x2E*VRR0(30,5)+QCx*VRR0(30,11)+2.D0*HfxZpE*VRR1(18,11)-3.D0*r1x2E*ZxZpE*VRR1(30,5)+WQx*VRR1(30,11)
      VRR0(30,22)=V(223)+2.D0*V(224)+V(226)+QCx*VRR0(30,12)+WQx*VRR1(30,12)
      VRR0(30,23)=V(227)+2.D0*V(228)-V(229)+QCx*VRR0(30,13)+WQx*VRR1(30,13)
      VRR0(30,24)=V(223)+V(226)+QCy*VRR0(30,13)+WQy*VRR1(30,13)
      VRR0(30,25)=3.D0*V(227)-3.D0*V(229)+QCy*VRR0(30,14)+WQy*VRR1(30,14)
      VRR0(30,26)=V(231)+V(233)+V(235)+QCx*VRR0(30,15)+WQx*VRR1(30,15)
      VRR0(30,27)=V(236)+V(238)-V(239)+QCx*VRR0(30,16)+WQx*VRR1(30,16)
      VRR0(30,28)=V(230)-V(234)+QCy*VRR0(30,16)+WQy*VRR1(30,16)
      VRR0(30,29)=V(240)+V(241)+QCy*VRR0(30,17)+WQy*VRR1(30,17)
      VRR0(30,30)=V(242)+2.D0*V(243)+V(245)+QCx*VRR0(30,18)+WQx*VRR1(30,18)
      VRR0(30,31)=V(111)+V(222)-V(225)+QCz*VRR0(30,16)+WQz*VRR1(30,16)
      VRR0(30,32)=V(242)+V(245)+QCy*VRR0(30,19)+WQy*VRR1(30,19)
      VRR0(30,33)=V(126)+V(231)+V(235)+QCz*VRR0(30,18)+WQz*VRR1(30,18)
      VRR0(30,34)=2.D0*V(131)+V(240)+V(241)+QCz*VRR0(30,19)+WQz*VRR1(30,19)
      VRR0(30,35)=3.D0*V(242)-3.D0*V(244)+QCz*VRR0(30,20)+2.D0*HfxZpE*VRR1(15,20)+WQz*VRR1(30,20)
      VRR0(31,21)=3.D0*r1x2E*VRR0(31,5)+QCx*VRR0(31,11)+HfxZpE*VRR1(19,11)-3.D0*r1x2E*ZxZpE*VRR1(31,5)+WQx*VRR1(31,11)
      VRR0(31,22)=V(247)+V(248)+V(250)+QCx*VRR0(31,12)+WQx*VRR1(31,12)
      VRR0(31,23)=V(251)+V(252)-V(253)+QCx*VRR0(31,13)+WQx*VRR1(31,13)
      VRR0(31,24)=V(228)+V(247)+V(250)+QCy*VRR0(31,13)+WQy*VRR1(31,13)
      VRR0(31,25)=3.D0*V(251)-3.D0*V(253)+QCy*VRR0(31,14)+HfxZpE*VRR1(18,14)+WQy*VRR1(31,14)
      VRR0(31,26)=V(255)+V(256)+V(258)+QCx*VRR0(31,15)+WQx*VRR1(31,15)
      VRR0(31,27)=V(259)+V(260)-V(261)+QCx*VRR0(31,16)+WQx*VRR1(31,16)
      VRR0(31,28)=V(237)+V(254)-V(257)+QCy*VRR0(31,16)+WQy*VRR1(31,16)
      VRR0(31,29)=V(262)+V(263)+V(264)+QCy*VRR0(31,17)+WQy*VRR1(31,17)
      VRR0(31,30)=V(265)+V(266)+V(268)+QCx*VRR0(31,18)+WQx*VRR1(31,18)
      VRR0(31,31)=V(150)+V(246)-V(249)+QCz*VRR0(31,16)+WQz*VRR1(31,16)
      VRR0(31,32)=V(265)+V(268)+V(269)+QCy*VRR0(31,19)+WQy*VRR1(31,19)
      VRR0(31,33)=V(156)+V(255)+V(258)+QCz*VRR0(31,18)+WQz*VRR1(31,18)
      VRR0(31,34)=V(182)+V(262)+V(264)+QCz*VRR0(31,19)+WQz*VRR1(31,19)
      VRR0(31,35)=3.D0*V(265)-3.D0*V(267)+QCz*VRR0(31,20)+2.D0*HfxZpE*VRR1(16,20)+WQz*VRR1(31,20)
      VRR0(32,21)=3.D0*r1x2E*VRR0(32,5)+QCx*VRR0(32,11)-3.D0*r1x2E*ZxZpE*VRR1(32,5)+WQx*VRR1(32,11)
      VRR0(32,22)=V(271)+V(273)+QCx*VRR0(32,12)+WQx*VRR1(32,12)
      VRR0(32,23)=V(274)-V(275)+QCx*VRR0(32,13)+WQx*VRR1(32,13)
      VRR0(32,24)=2.D0*V(252)+V(271)+V(273)+QCy*VRR0(32,13)+WQy*VRR1(32,13)
      VRR0(32,25)=3.D0*V(274)-3.D0*V(275)+QCy*VRR0(32,14)+2.D0*HfxZpE*VRR1(19,14)+WQy*VRR1(32,14)
      VRR0(32,26)=V(277)+V(279)+QCx*VRR0(32,15)+WQx*VRR1(32,15)
      VRR0(32,27)=V(280)-V(281)+QCx*VRR0(32,16)+WQx*VRR1(32,16)
      VRR0(32,28)=V(276)-V(278)+V(282)+QCy*VRR0(32,16)+WQy*VRR1(32,16)
      VRR0(32,29)=V(283)+V(285)+V(286)+QCy*VRR0(32,17)+WQy*VRR1(32,17)
      VRR0(32,30)=V(287)+V(289)+QCx*VRR0(32,18)+WQx*VRR1(32,18)
      VRR0(32,31)=V(203)+V(270)-V(272)+QCz*VRR0(32,16)+WQz*VRR1(32,16)
      VRR0(32,32)=V(287)+V(289)+2.D0*V(290)+QCy*VRR0(32,19)+WQy*VRR1(32,19)
      VRR0(32,33)=2.D0*V(178)+V(277)+V(279)+QCz*VRR0(32,18)+WQz*VRR1(32,18)
      VRR0(32,34)=V(221)+V(283)+V(286)+QCz*VRR0(32,19)+WQz*VRR1(32,19)
      VRR0(32,35)=3.D0*V(287)-3.D0*V(288)+QCz*VRR0(32,20)+2.D0*HfxZpE*VRR1(17,20)+WQz*VRR1(32,20)
      VRR0(33,21)=V(291)+3.D0*r1x2E*VRR0(33,5)+QCx*VRR0(33,11)-3.D0*r1x2E*ZxZpE*VRR1(33,5)+WQx*VRR1(33,11)
      VRR0(33,22)=V(293)+V(294)+V(296)+QCx*VRR0(33,12)+WQx*VRR1(33,12)
      VRR0(33,23)=V(98)+V(100)+PAz*VRR0(18,23)+WPz*VRR1(18,23)
      VRR0(33,24)=V(293)+V(296)+QCy*VRR0(33,13)+WQy*VRR1(33,13)
      VRR0(33,25)=3.D0*r1x2E*VRR0(33,7)+QCy*VRR0(33,14)-3.D0*r1x2E*ZxZpE*VRR1(33,7)+WQy*VRR1(33,14)
      VRR0(33,26)=V(298)+V(299)+V(301)+QCx*VRR0(33,15)+WQx*VRR1(33,15)
      VRR0(33,27)=V(107)+V(109)+V(224)+PAz*VRR0(18,27)+WPz*VRR1(18,27)
      VRR0(33,28)=V(113)+V(115)+V(228)+PAz*VRR0(18,28)+WPz*VRR1(18,28)
      VRR0(33,29)=V(303)+V(305)+QCy*VRR0(33,17)+WQy*VRR1(33,17)
      VRR0(33,30)=V(122)+V(124)+V(233)+PAz*VRR0(18,30)+WPz*VRR1(18,30)
      VRR0(33,31)=V(128)+V(130)+V(238)+PAz*VRR0(18,31)+WPz*VRR1(18,31)
      VRR0(33,32)=V(133)+V(135)+2.D0*V(263)+PAz*VRR0(18,32)+WPz*VRR1(18,32)
      VRR0(33,33)=3.D0*V(243)+V(298)+V(301)+QCz*VRR0(33,18)+WQz*VRR1(33,18)
      VRR0(33,34)=3.D0*V(269)+V(303)+V(305)+QCz*VRR0(33,19)+WQz*VRR1(33,19)
      VRR0(33,35)=3.D0*r1x2E*VRR0(33,10)+QCz*VRR0(33,20)+3.D0*HfxZpE*VRR1(18,20)-3.D0*r1x2E*ZxZpE*VRR1(33,10)+WQz*VRR1(33,20)
      VRR0(34,21)=3.D0*r1x2E*VRR0(34,5)+QCx*VRR0(34,11)-3.D0*r1x2E*ZxZpE*VRR1(34,5)+WQx*VRR1(34,11)
      VRR0(34,22)=V(307)+V(309)+QCx*VRR0(34,12)+WQx*VRR1(34,12)
      VRR0(34,23)=V(188)+V(190)+PAz*VRR0(19,23)+WPz*VRR1(19,23)
      VRR0(34,24)=V(307)+V(309)+V(310)+QCy*VRR0(34,13)+WQy*VRR1(34,13)
      VRR0(34,25)=V(311)+3.D0*r1x2E*VRR0(34,7)+QCy*VRR0(34,14)-3.D0*r1x2E*ZxZpE*VRR1(34,7)+WQy*VRR1(34,14)
      VRR0(34,26)=V(313)+V(315)+QCx*VRR0(34,15)+WQx*VRR1(34,15)
      VRR0(34,27)=V(196)+V(198)+V(248)+PAz*VRR0(19,27)+WPz*VRR1(19,27)
      VRR0(34,28)=V(200)+V(202)+V(252)+PAz*VRR0(19,28)+WPz*VRR1(19,28)
      VRR0(34,29)=V(317)+V(318)+V(320)+QCy*VRR0(34,17)+WQy*VRR1(34,17)
      VRR0(34,30)=V(209)+V(211)+2.D0*V(256)+PAz*VRR0(19,30)+WPz*VRR1(19,30)
      VRR0(34,31)=V(213)+V(215)+V(282)+PAz*VRR0(19,31)+WPz*VRR1(19,31)
      VRR0(34,32)=V(217)+V(219)+V(285)+PAz*VRR0(19,32)+WPz*VRR1(19,32)
      VRR0(34,33)=3.D0*V(266)+V(313)+V(315)+QCz*VRR0(34,18)+WQz*VRR1(34,18)
      VRR0(34,34)=3.D0*V(290)+V(317)+V(320)+QCz*VRR0(34,19)+WQz*VRR1(34,19)
      VRR0(34,35)=3.D0*r1x2E*VRR0(34,10)+QCz*VRR0(34,20)+3.D0*HfxZpE*VRR1(19,20)-3.D0*r1x2E*ZxZpE*VRR1(34,10)+WQz*VRR1(34,20)
      VRR0(35,21)=3.D0*r1x2E*VRR0(35,5)+QCx*VRR0(35,11)-3.D0*r1x2E*ZxZpE*VRR1(35,5)+WQx*VRR1(35,11)
      VRR0(35,22)=3.D0*r1x2Z*VRR0(10,22)+PAz*VRR0(20,22)-3.D0*ExZpE*r1x2Z*VRR1(10,22)+WPz*VRR1(20,22)
      VRR0(35,23)=3.D0*r1x2Z*VRR0(10,23)+PAz*VRR0(20,23)-3.D0*ExZpE*r1x2Z*VRR1(10,23)+WPz*VRR1(20,23)
      VRR0(35,24)=3.D0*r1x2Z*VRR0(10,24)+PAz*VRR0(20,24)-3.D0*ExZpE*r1x2Z*VRR1(10,24)+WPz*VRR1(20,24)
      VRR0(35,25)=3.D0*r1x2E*VRR0(35,7)+QCy*VRR0(35,14)-3.D0*r1x2E*ZxZpE*VRR1(35,7)+WQy*VRR1(35,14)
      VRR0(35,26)=V(291)+3.D0*r1x2Z*VRR0(10,26)+PAz*VRR0(20,26)-3.D0*ExZpE*r1x2Z*VRR1(10,26)+WPz*VRR1(20,26)
      VRR0(35,27)=V(294)+3.D0*r1x2Z*VRR0(10,27)+PAz*VRR0(20,27)-3.D0*ExZpE*r1x2Z*VRR1(10,27)+WPz*VRR1(20,27)
      VRR0(35,28)=V(310)+3.D0*r1x2Z*VRR0(10,28)+PAz*VRR0(20,28)-3.D0*ExZpE*r1x2Z*VRR1(10,28)+WPz*VRR1(20,28)
      VRR0(35,29)=V(311)+3.D0*r1x2Z*VRR0(10,29)+PAz*VRR0(20,29)-3.D0*ExZpE*r1x2Z*VRR1(10,29)+WPz*VRR1(20,29)
      VRR0(35,30)=2.D0*V(299)+3.D0*r1x2Z*VRR0(10,30)+PAz*VRR0(20,30)-3.D0*ExZpE*r1x2Z*VRR1(10,30)+WPz*VRR1(20,30)
      VRR0(35,31)=3.D0*r1x2Z*VRR0(10,31)+PAz*VRR0(20,31)-3.D0*ExZpE*r1x2Z*VRR1(10,31)+2.D0*HfxZpE*VRR1(20,16)+WPz*VRR1(20,31)
      VRR0(35,32)=2.D0*V(318)+3.D0*r1x2Z*VRR0(10,32)+PAz*VRR0(20,32)-3.D0*ExZpE*r1x2Z*VRR1(10,32)+WPz*VRR1(20,32)
      VRR0(35,33)=3.D0*r1x2Z*VRR0(10,33)+PAz*VRR0(20,33)-3.D0*ExZpE*r1x2Z*VRR1(10,33)+3.D0*HfxZpE*VRR1(20,18)+WPz*VRR1(20,33)
      VRR0(35,34)=3.D0*r1x2Z*VRR0(10,34)+PAz*VRR0(20,34)-3.D0*ExZpE*r1x2Z*VRR1(10,34)+3.D0*HfxZpE*VRR1(20,19)+WPz*VRR1(20,34)
      VRR0(35,35)=3.D0*r1x2E*VRR0(35,10)+QCz*VRR0(35,20)+4.D0*HfxZpE*VRR1(20,20)-3.D0*r1x2E*ZxZpE*VRR1(35,10)+WQz*VRR1(35,20)
END SUBROUTINE VRRg0g0
SUBROUTINE MVRRg0g0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(21,21)=QCx*VS0(21,11)+WQx*VS1(21,11)-r1x2E*VR1(21,11)&
   +3D0*r1x2E*(VS0(21,5)-ZxZpE*VS1(21,5))&
   +4D0*HfxZpE*VS1(11,11)
VS0(21,22)=QCx*VS0(21,12)+WQx*VS1(21,12)-r1x2E*VR1(21,12)&
   +2D0*r1x2E*(VS0(21,6)-ZxZpE*VS1(21,6))&
   +4D0*HfxZpE*VS1(11,12)
VS0(21,23)=QCx*VS0(21,13)+WQx*VS1(21,13)-r1x2E*VR1(21,13)&
   +r1x2E*(VS0(21,7)-ZxZpE*VS1(21,7))&
   +4D0*HfxZpE*VS1(11,13)
VS0(21,24)=QCy*VS0(21,13)+WQy*VS1(21,13)&
   +2D0*r1x2E*(VS0(21,6)-ZxZpE*VS1(21,6))
VS0(21,25)=QCy*VS0(21,14)+WQy*VS1(21,14)&
   +3D0*r1x2E*(VS0(21,7)-ZxZpE*VS1(21,7))
VS0(21,26)=QCx*VS0(21,15)+WQx*VS1(21,15)-r1x2E*VR1(21,15)&
   +2D0*r1x2E*(VS0(21,8)-ZxZpE*VS1(21,8))&
   +4D0*HfxZpE*VS1(11,15)
VS0(21,27)=QCx*VS0(21,16)+WQx*VS1(21,16)-r1x2E*VR1(21,16)&
   +r1x2E*(VS0(21,9)-ZxZpE*VS1(21,9))&
   +4D0*HfxZpE*VS1(11,16)
VS0(21,28)=QCy*VS0(21,16)+WQy*VS1(21,16)&
   +r1x2E*(VS0(21,8)-ZxZpE*VS1(21,8))
VS0(21,29)=QCy*VS0(21,17)+WQy*VS1(21,17)&
   +2D0*r1x2E*(VS0(21,9)-ZxZpE*VS1(21,9))
VS0(21,30)=QCx*VS0(21,18)+WQx*VS1(21,18)-r1x2E*VR1(21,18)&
   +r1x2E*(VS0(21,10)-ZxZpE*VS1(21,10))&
   +4D0*HfxZpE*VS1(11,18)
VS0(21,31)=QCz*VS0(21,16)+WQz*VS1(21,16)&
   +r1x2E*(VS0(21,6)-ZxZpE*VS1(21,6))
VS0(21,32)=QCy*VS0(21,19)+WQy*VS1(21,19)&
   +r1x2E*(VS0(21,10)-ZxZpE*VS1(21,10))
VS0(21,33)=QCz*VS0(21,18)+WQz*VS1(21,18)&
   +2D0*r1x2E*(VS0(21,8)-ZxZpE*VS1(21,8))
VS0(21,34)=QCz*VS0(21,19)+WQz*VS1(21,19)&
   +2D0*r1x2E*(VS0(21,9)-ZxZpE*VS1(21,9))
VS0(21,35)=QCz*VS0(21,20)+WQz*VS1(21,20)&
   +3D0*r1x2E*(VS0(21,10)-ZxZpE*VS1(21,10))
VS0(22,21)=QCx*VS0(22,11)+WQx*VS1(22,11)-r1x2E*VR1(22,11)&
   +3D0*r1x2E*(VS0(22,5)-ZxZpE*VS1(22,5))&
   +3D0*HfxZpE*VS1(12,11)
VS0(22,22)=QCx*VS0(22,12)+WQx*VS1(22,12)-r1x2E*VR1(22,12)&
   +2D0*r1x2E*(VS0(22,6)-ZxZpE*VS1(22,6))&
   +3D0*HfxZpE*VS1(12,12)
VS0(22,23)=QCx*VS0(22,13)+WQx*VS1(22,13)-r1x2E*VR1(22,13)&
   +r1x2E*(VS0(22,7)-ZxZpE*VS1(22,7))&
   +3D0*HfxZpE*VS1(12,13)
VS0(22,24)=QCy*VS0(22,13)+WQy*VS1(22,13)&
   +2D0*r1x2E*(VS0(22,6)-ZxZpE*VS1(22,6))&
   +HfxZpE*VS1(11,13)
VS0(22,25)=QCy*VS0(22,14)+WQy*VS1(22,14)&
   +3D0*r1x2E*(VS0(22,7)-ZxZpE*VS1(22,7))&
   +HfxZpE*VS1(11,14)
VS0(22,26)=QCx*VS0(22,15)+WQx*VS1(22,15)-r1x2E*VR1(22,15)&
   +2D0*r1x2E*(VS0(22,8)-ZxZpE*VS1(22,8))&
   +3D0*HfxZpE*VS1(12,15)
VS0(22,27)=QCx*VS0(22,16)+WQx*VS1(22,16)-r1x2E*VR1(22,16)&
   +r1x2E*(VS0(22,9)-ZxZpE*VS1(22,9))&
   +3D0*HfxZpE*VS1(12,16)
VS0(22,28)=QCy*VS0(22,16)+WQy*VS1(22,16)&
   +r1x2E*(VS0(22,8)-ZxZpE*VS1(22,8))&
   +HfxZpE*VS1(11,16)
VS0(22,29)=QCy*VS0(22,17)+WQy*VS1(22,17)&
   +2D0*r1x2E*(VS0(22,9)-ZxZpE*VS1(22,9))&
   +HfxZpE*VS1(11,17)
VS0(22,30)=QCx*VS0(22,18)+WQx*VS1(22,18)-r1x2E*VR1(22,18)&
   +r1x2E*(VS0(22,10)-ZxZpE*VS1(22,10))&
   +3D0*HfxZpE*VS1(12,18)
VS0(22,31)=QCz*VS0(22,16)+WQz*VS1(22,16)&
   +r1x2E*(VS0(22,6)-ZxZpE*VS1(22,6))
VS0(22,32)=QCy*VS0(22,19)+WQy*VS1(22,19)&
   +r1x2E*(VS0(22,10)-ZxZpE*VS1(22,10))&
   +HfxZpE*VS1(11,19)
VS0(22,33)=QCz*VS0(22,18)+WQz*VS1(22,18)&
   +2D0*r1x2E*(VS0(22,8)-ZxZpE*VS1(22,8))
VS0(22,34)=QCz*VS0(22,19)+WQz*VS1(22,19)&
   +2D0*r1x2E*(VS0(22,9)-ZxZpE*VS1(22,9))
VS0(22,35)=QCz*VS0(22,20)+WQz*VS1(22,20)&
   +3D0*r1x2E*(VS0(22,10)-ZxZpE*VS1(22,10))
VS0(23,21)=QCx*VS0(23,11)+WQx*VS1(23,11)-r1x2E*VR1(23,11)&
   +3D0*r1x2E*(VS0(23,5)-ZxZpE*VS1(23,5))&
   +2D0*HfxZpE*VS1(13,11)
VS0(23,22)=QCx*VS0(23,12)+WQx*VS1(23,12)-r1x2E*VR1(23,12)&
   +2D0*r1x2E*(VS0(23,6)-ZxZpE*VS1(23,6))&
   +2D0*HfxZpE*VS1(13,12)
VS0(23,23)=QCx*VS0(23,13)+WQx*VS1(23,13)-r1x2E*VR1(23,13)&
   +r1x2E*(VS0(23,7)-ZxZpE*VS1(23,7))&
   +2D0*HfxZpE*VS1(13,13)
VS0(23,24)=QCy*VS0(23,13)+WQy*VS1(23,13)&
   +2D0*r1x2E*(VS0(23,6)-ZxZpE*VS1(23,6))&
   +2D0*HfxZpE*VS1(12,13)
VS0(23,25)=QCy*VS0(23,14)+WQy*VS1(23,14)&
   +3D0*r1x2E*(VS0(23,7)-ZxZpE*VS1(23,7))&
   +2D0*HfxZpE*VS1(12,14)
VS0(23,26)=QCx*VS0(23,15)+WQx*VS1(23,15)-r1x2E*VR1(23,15)&
   +2D0*r1x2E*(VS0(23,8)-ZxZpE*VS1(23,8))&
   +2D0*HfxZpE*VS1(13,15)
VS0(23,27)=QCx*VS0(23,16)+WQx*VS1(23,16)-r1x2E*VR1(23,16)&
   +r1x2E*(VS0(23,9)-ZxZpE*VS1(23,9))&
   +2D0*HfxZpE*VS1(13,16)
VS0(23,28)=QCy*VS0(23,16)+WQy*VS1(23,16)&
   +r1x2E*(VS0(23,8)-ZxZpE*VS1(23,8))&
   +2D0*HfxZpE*VS1(12,16)
VS0(23,29)=QCy*VS0(23,17)+WQy*VS1(23,17)&
   +2D0*r1x2E*(VS0(23,9)-ZxZpE*VS1(23,9))&
   +2D0*HfxZpE*VS1(12,17)
VS0(23,30)=QCx*VS0(23,18)+WQx*VS1(23,18)-r1x2E*VR1(23,18)&
   +r1x2E*(VS0(23,10)-ZxZpE*VS1(23,10))&
   +2D0*HfxZpE*VS1(13,18)
VS0(23,31)=QCz*VS0(23,16)+WQz*VS1(23,16)&
   +r1x2E*(VS0(23,6)-ZxZpE*VS1(23,6))
VS0(23,32)=QCy*VS0(23,19)+WQy*VS1(23,19)&
   +r1x2E*(VS0(23,10)-ZxZpE*VS1(23,10))&
   +2D0*HfxZpE*VS1(12,19)
VS0(23,33)=QCz*VS0(23,18)+WQz*VS1(23,18)&
   +2D0*r1x2E*(VS0(23,8)-ZxZpE*VS1(23,8))
VS0(23,34)=QCz*VS0(23,19)+WQz*VS1(23,19)&
   +2D0*r1x2E*(VS0(23,9)-ZxZpE*VS1(23,9))
VS0(23,35)=QCz*VS0(23,20)+WQz*VS1(23,20)&
   +3D0*r1x2E*(VS0(23,10)-ZxZpE*VS1(23,10))
VS0(24,21)=QCx*VS0(24,11)+WQx*VS1(24,11)-r1x2E*VR1(24,11)&
   +3D0*r1x2E*(VS0(24,5)-ZxZpE*VS1(24,5))&
   +HfxZpE*VS1(14,11)
VS0(24,22)=QCx*VS0(24,12)+WQx*VS1(24,12)-r1x2E*VR1(24,12)&
   +2D0*r1x2E*(VS0(24,6)-ZxZpE*VS1(24,6))&
   +HfxZpE*VS1(14,12)
VS0(24,23)=QCx*VS0(24,13)+WQx*VS1(24,13)-r1x2E*VR1(24,13)&
   +r1x2E*(VS0(24,7)-ZxZpE*VS1(24,7))&
   +HfxZpE*VS1(14,13)
VS0(24,24)=QCy*VS0(24,13)+WQy*VS1(24,13)&
   +2D0*r1x2E*(VS0(24,6)-ZxZpE*VS1(24,6))&
   +3D0*HfxZpE*VS1(13,13)
VS0(24,25)=QCy*VS0(24,14)+WQy*VS1(24,14)&
   +3D0*r1x2E*(VS0(24,7)-ZxZpE*VS1(24,7))&
   +3D0*HfxZpE*VS1(13,14)
VS0(24,26)=QCx*VS0(24,15)+WQx*VS1(24,15)-r1x2E*VR1(24,15)&
   +2D0*r1x2E*(VS0(24,8)-ZxZpE*VS1(24,8))&
   +HfxZpE*VS1(14,15)
VS0(24,27)=QCx*VS0(24,16)+WQx*VS1(24,16)-r1x2E*VR1(24,16)&
   +r1x2E*(VS0(24,9)-ZxZpE*VS1(24,9))&
   +HfxZpE*VS1(14,16)
VS0(24,28)=QCy*VS0(24,16)+WQy*VS1(24,16)&
   +r1x2E*(VS0(24,8)-ZxZpE*VS1(24,8))&
   +3D0*HfxZpE*VS1(13,16)
VS0(24,29)=QCy*VS0(24,17)+WQy*VS1(24,17)&
   +2D0*r1x2E*(VS0(24,9)-ZxZpE*VS1(24,9))&
   +3D0*HfxZpE*VS1(13,17)
VS0(24,30)=QCx*VS0(24,18)+WQx*VS1(24,18)-r1x2E*VR1(24,18)&
   +r1x2E*(VS0(24,10)-ZxZpE*VS1(24,10))&
   +HfxZpE*VS1(14,18)
VS0(24,31)=QCz*VS0(24,16)+WQz*VS1(24,16)&
   +r1x2E*(VS0(24,6)-ZxZpE*VS1(24,6))
VS0(24,32)=QCy*VS0(24,19)+WQy*VS1(24,19)&
   +r1x2E*(VS0(24,10)-ZxZpE*VS1(24,10))&
   +3D0*HfxZpE*VS1(13,19)
VS0(24,33)=QCz*VS0(24,18)+WQz*VS1(24,18)&
   +2D0*r1x2E*(VS0(24,8)-ZxZpE*VS1(24,8))
VS0(24,34)=QCz*VS0(24,19)+WQz*VS1(24,19)&
   +2D0*r1x2E*(VS0(24,9)-ZxZpE*VS1(24,9))
VS0(24,35)=QCz*VS0(24,20)+WQz*VS1(24,20)&
   +3D0*r1x2E*(VS0(24,10)-ZxZpE*VS1(24,10))
VS0(25,21)=QCx*VS0(25,11)+WQx*VS1(25,11)-r1x2E*VR1(25,11)&
   +3D0*r1x2E*(VS0(25,5)-ZxZpE*VS1(25,5))
VS0(25,22)=QCx*VS0(25,12)+WQx*VS1(25,12)-r1x2E*VR1(25,12)&
   +2D0*r1x2E*(VS0(25,6)-ZxZpE*VS1(25,6))
VS0(25,23)=QCx*VS0(25,13)+WQx*VS1(25,13)-r1x2E*VR1(25,13)&
   +r1x2E*(VS0(25,7)-ZxZpE*VS1(25,7))
VS0(25,24)=QCy*VS0(25,13)+WQy*VS1(25,13)&
   +2D0*r1x2E*(VS0(25,6)-ZxZpE*VS1(25,6))&
   +4D0*HfxZpE*VS1(14,13)
VS0(25,25)=QCy*VS0(25,14)+WQy*VS1(25,14)&
   +3D0*r1x2E*(VS0(25,7)-ZxZpE*VS1(25,7))&
   +4D0*HfxZpE*VS1(14,14)
VS0(25,26)=QCx*VS0(25,15)+WQx*VS1(25,15)-r1x2E*VR1(25,15)&
   +2D0*r1x2E*(VS0(25,8)-ZxZpE*VS1(25,8))
VS0(25,27)=QCx*VS0(25,16)+WQx*VS1(25,16)-r1x2E*VR1(25,16)&
   +r1x2E*(VS0(25,9)-ZxZpE*VS1(25,9))
VS0(25,28)=QCy*VS0(25,16)+WQy*VS1(25,16)&
   +r1x2E*(VS0(25,8)-ZxZpE*VS1(25,8))&
   +4D0*HfxZpE*VS1(14,16)
VS0(25,29)=QCy*VS0(25,17)+WQy*VS1(25,17)&
   +2D0*r1x2E*(VS0(25,9)-ZxZpE*VS1(25,9))&
   +4D0*HfxZpE*VS1(14,17)
VS0(25,30)=QCx*VS0(25,18)+WQx*VS1(25,18)-r1x2E*VR1(25,18)&
   +r1x2E*(VS0(25,10)-ZxZpE*VS1(25,10))
VS0(25,31)=QCz*VS0(25,16)+WQz*VS1(25,16)&
   +r1x2E*(VS0(25,6)-ZxZpE*VS1(25,6))
VS0(25,32)=QCy*VS0(25,19)+WQy*VS1(25,19)&
   +r1x2E*(VS0(25,10)-ZxZpE*VS1(25,10))&
   +4D0*HfxZpE*VS1(14,19)
VS0(25,33)=QCz*VS0(25,18)+WQz*VS1(25,18)&
   +2D0*r1x2E*(VS0(25,8)-ZxZpE*VS1(25,8))
VS0(25,34)=QCz*VS0(25,19)+WQz*VS1(25,19)&
   +2D0*r1x2E*(VS0(25,9)-ZxZpE*VS1(25,9))
VS0(25,35)=QCz*VS0(25,20)+WQz*VS1(25,20)&
   +3D0*r1x2E*(VS0(25,10)-ZxZpE*VS1(25,10))
VS0(26,21)=QCx*VS0(26,11)+WQx*VS1(26,11)-r1x2E*VR1(26,11)&
   +3D0*r1x2E*(VS0(26,5)-ZxZpE*VS1(26,5))&
   +3D0*HfxZpE*VS1(15,11)
VS0(26,22)=QCx*VS0(26,12)+WQx*VS1(26,12)-r1x2E*VR1(26,12)&
   +2D0*r1x2E*(VS0(26,6)-ZxZpE*VS1(26,6))&
   +3D0*HfxZpE*VS1(15,12)
VS0(26,23)=QCx*VS0(26,13)+WQx*VS1(26,13)-r1x2E*VR1(26,13)&
   +r1x2E*(VS0(26,7)-ZxZpE*VS1(26,7))&
   +3D0*HfxZpE*VS1(15,13)
VS0(26,24)=QCy*VS0(26,13)+WQy*VS1(26,13)&
   +2D0*r1x2E*(VS0(26,6)-ZxZpE*VS1(26,6))
VS0(26,25)=QCy*VS0(26,14)+WQy*VS1(26,14)&
   +3D0*r1x2E*(VS0(26,7)-ZxZpE*VS1(26,7))
VS0(26,26)=QCx*VS0(26,15)+WQx*VS1(26,15)-r1x2E*VR1(26,15)&
   +2D0*r1x2E*(VS0(26,8)-ZxZpE*VS1(26,8))&
   +3D0*HfxZpE*VS1(15,15)
VS0(26,27)=QCx*VS0(26,16)+WQx*VS1(26,16)-r1x2E*VR1(26,16)&
   +r1x2E*(VS0(26,9)-ZxZpE*VS1(26,9))&
   +3D0*HfxZpE*VS1(15,16)
VS0(26,28)=QCy*VS0(26,16)+WQy*VS1(26,16)&
   +r1x2E*(VS0(26,8)-ZxZpE*VS1(26,8))
VS0(26,29)=QCy*VS0(26,17)+WQy*VS1(26,17)&
   +2D0*r1x2E*(VS0(26,9)-ZxZpE*VS1(26,9))
VS0(26,30)=QCx*VS0(26,18)+WQx*VS1(26,18)-r1x2E*VR1(26,18)&
   +r1x2E*(VS0(26,10)-ZxZpE*VS1(26,10))&
   +3D0*HfxZpE*VS1(15,18)
VS0(26,31)=QCz*VS0(26,16)+WQz*VS1(26,16)&
   +r1x2E*(VS0(26,6)-ZxZpE*VS1(26,6))&
   +HfxZpE*VS1(11,16)
VS0(26,32)=QCy*VS0(26,19)+WQy*VS1(26,19)&
   +r1x2E*(VS0(26,10)-ZxZpE*VS1(26,10))
VS0(26,33)=QCz*VS0(26,18)+WQz*VS1(26,18)&
   +2D0*r1x2E*(VS0(26,8)-ZxZpE*VS1(26,8))&
   +HfxZpE*VS1(11,18)
VS0(26,34)=QCz*VS0(26,19)+WQz*VS1(26,19)&
   +2D0*r1x2E*(VS0(26,9)-ZxZpE*VS1(26,9))&
   +HfxZpE*VS1(11,19)
VS0(26,35)=QCz*VS0(26,20)+WQz*VS1(26,20)&
   +3D0*r1x2E*(VS0(26,10)-ZxZpE*VS1(26,10))&
   +HfxZpE*VS1(11,20)
VS0(27,21)=QCx*VS0(27,11)+WQx*VS1(27,11)-r1x2E*VR1(27,11)&
   +3D0*r1x2E*(VS0(27,5)-ZxZpE*VS1(27,5))&
   +2D0*HfxZpE*VS1(16,11)
VS0(27,22)=QCx*VS0(27,12)+WQx*VS1(27,12)-r1x2E*VR1(27,12)&
   +2D0*r1x2E*(VS0(27,6)-ZxZpE*VS1(27,6))&
   +2D0*HfxZpE*VS1(16,12)
VS0(27,23)=QCx*VS0(27,13)+WQx*VS1(27,13)-r1x2E*VR1(27,13)&
   +r1x2E*(VS0(27,7)-ZxZpE*VS1(27,7))&
   +2D0*HfxZpE*VS1(16,13)
VS0(27,24)=QCy*VS0(27,13)+WQy*VS1(27,13)&
   +2D0*r1x2E*(VS0(27,6)-ZxZpE*VS1(27,6))&
   +HfxZpE*VS1(15,13)
VS0(27,25)=QCy*VS0(27,14)+WQy*VS1(27,14)&
   +3D0*r1x2E*(VS0(27,7)-ZxZpE*VS1(27,7))&
   +HfxZpE*VS1(15,14)
VS0(27,26)=QCx*VS0(27,15)+WQx*VS1(27,15)-r1x2E*VR1(27,15)&
   +2D0*r1x2E*(VS0(27,8)-ZxZpE*VS1(27,8))&
   +2D0*HfxZpE*VS1(16,15)
VS0(27,27)=QCx*VS0(27,16)+WQx*VS1(27,16)-r1x2E*VR1(27,16)&
   +r1x2E*(VS0(27,9)-ZxZpE*VS1(27,9))&
   +2D0*HfxZpE*VS1(16,16)
VS0(27,28)=QCy*VS0(27,16)+WQy*VS1(27,16)&
   +r1x2E*(VS0(27,8)-ZxZpE*VS1(27,8))&
   +HfxZpE*VS1(15,16)
VS0(27,29)=QCy*VS0(27,17)+WQy*VS1(27,17)&
   +2D0*r1x2E*(VS0(27,9)-ZxZpE*VS1(27,9))&
   +HfxZpE*VS1(15,17)
VS0(27,30)=QCx*VS0(27,18)+WQx*VS1(27,18)-r1x2E*VR1(27,18)&
   +r1x2E*(VS0(27,10)-ZxZpE*VS1(27,10))&
   +2D0*HfxZpE*VS1(16,18)
VS0(27,31)=QCz*VS0(27,16)+WQz*VS1(27,16)&
   +r1x2E*(VS0(27,6)-ZxZpE*VS1(27,6))&
   +HfxZpE*VS1(12,16)
VS0(27,32)=QCy*VS0(27,19)+WQy*VS1(27,19)&
   +r1x2E*(VS0(27,10)-ZxZpE*VS1(27,10))&
   +HfxZpE*VS1(15,19)
VS0(27,33)=QCz*VS0(27,18)+WQz*VS1(27,18)&
   +2D0*r1x2E*(VS0(27,8)-ZxZpE*VS1(27,8))&
   +HfxZpE*VS1(12,18)
VS0(27,34)=QCz*VS0(27,19)+WQz*VS1(27,19)&
   +2D0*r1x2E*(VS0(27,9)-ZxZpE*VS1(27,9))&
   +HfxZpE*VS1(12,19)
VS0(27,35)=QCz*VS0(27,20)+WQz*VS1(27,20)&
   +3D0*r1x2E*(VS0(27,10)-ZxZpE*VS1(27,10))&
   +HfxZpE*VS1(12,20)
VS0(28,21)=QCx*VS0(28,11)+WQx*VS1(28,11)-r1x2E*VR1(28,11)&
   +3D0*r1x2E*(VS0(28,5)-ZxZpE*VS1(28,5))&
   +HfxZpE*VS1(17,11)
VS0(28,22)=QCx*VS0(28,12)+WQx*VS1(28,12)-r1x2E*VR1(28,12)&
   +2D0*r1x2E*(VS0(28,6)-ZxZpE*VS1(28,6))&
   +HfxZpE*VS1(17,12)
VS0(28,23)=QCx*VS0(28,13)+WQx*VS1(28,13)-r1x2E*VR1(28,13)&
   +r1x2E*(VS0(28,7)-ZxZpE*VS1(28,7))&
   +HfxZpE*VS1(17,13)
VS0(28,24)=QCy*VS0(28,13)+WQy*VS1(28,13)&
   +2D0*r1x2E*(VS0(28,6)-ZxZpE*VS1(28,6))&
   +2D0*HfxZpE*VS1(16,13)
VS0(28,25)=QCy*VS0(28,14)+WQy*VS1(28,14)&
   +3D0*r1x2E*(VS0(28,7)-ZxZpE*VS1(28,7))&
   +2D0*HfxZpE*VS1(16,14)
VS0(28,26)=QCx*VS0(28,15)+WQx*VS1(28,15)-r1x2E*VR1(28,15)&
   +2D0*r1x2E*(VS0(28,8)-ZxZpE*VS1(28,8))&
   +HfxZpE*VS1(17,15)
VS0(28,27)=QCx*VS0(28,16)+WQx*VS1(28,16)-r1x2E*VR1(28,16)&
   +r1x2E*(VS0(28,9)-ZxZpE*VS1(28,9))&
   +HfxZpE*VS1(17,16)
VS0(28,28)=QCy*VS0(28,16)+WQy*VS1(28,16)&
   +r1x2E*(VS0(28,8)-ZxZpE*VS1(28,8))&
   +2D0*HfxZpE*VS1(16,16)
VS0(28,29)=QCy*VS0(28,17)+WQy*VS1(28,17)&
   +2D0*r1x2E*(VS0(28,9)-ZxZpE*VS1(28,9))&
   +2D0*HfxZpE*VS1(16,17)
VS0(28,30)=QCx*VS0(28,18)+WQx*VS1(28,18)-r1x2E*VR1(28,18)&
   +r1x2E*(VS0(28,10)-ZxZpE*VS1(28,10))&
   +HfxZpE*VS1(17,18)
VS0(28,31)=QCz*VS0(28,16)+WQz*VS1(28,16)&
   +r1x2E*(VS0(28,6)-ZxZpE*VS1(28,6))&
   +HfxZpE*VS1(13,16)
VS0(28,32)=QCy*VS0(28,19)+WQy*VS1(28,19)&
   +r1x2E*(VS0(28,10)-ZxZpE*VS1(28,10))&
   +2D0*HfxZpE*VS1(16,19)
VS0(28,33)=QCz*VS0(28,18)+WQz*VS1(28,18)&
   +2D0*r1x2E*(VS0(28,8)-ZxZpE*VS1(28,8))&
   +HfxZpE*VS1(13,18)
VS0(28,34)=QCz*VS0(28,19)+WQz*VS1(28,19)&
   +2D0*r1x2E*(VS0(28,9)-ZxZpE*VS1(28,9))&
   +HfxZpE*VS1(13,19)
VS0(28,35)=QCz*VS0(28,20)+WQz*VS1(28,20)&
   +3D0*r1x2E*(VS0(28,10)-ZxZpE*VS1(28,10))&
   +HfxZpE*VS1(13,20)
VS0(29,21)=QCx*VS0(29,11)+WQx*VS1(29,11)-r1x2E*VR1(29,11)&
   +3D0*r1x2E*(VS0(29,5)-ZxZpE*VS1(29,5))
VS0(29,22)=QCx*VS0(29,12)+WQx*VS1(29,12)-r1x2E*VR1(29,12)&
   +2D0*r1x2E*(VS0(29,6)-ZxZpE*VS1(29,6))
VS0(29,23)=QCx*VS0(29,13)+WQx*VS1(29,13)-r1x2E*VR1(29,13)&
   +r1x2E*(VS0(29,7)-ZxZpE*VS1(29,7))
VS0(29,24)=QCy*VS0(29,13)+WQy*VS1(29,13)&
   +2D0*r1x2E*(VS0(29,6)-ZxZpE*VS1(29,6))&
   +3D0*HfxZpE*VS1(17,13)
VS0(29,25)=QCy*VS0(29,14)+WQy*VS1(29,14)&
   +3D0*r1x2E*(VS0(29,7)-ZxZpE*VS1(29,7))&
   +3D0*HfxZpE*VS1(17,14)
VS0(29,26)=QCx*VS0(29,15)+WQx*VS1(29,15)-r1x2E*VR1(29,15)&
   +2D0*r1x2E*(VS0(29,8)-ZxZpE*VS1(29,8))
VS0(29,27)=QCx*VS0(29,16)+WQx*VS1(29,16)-r1x2E*VR1(29,16)&
   +r1x2E*(VS0(29,9)-ZxZpE*VS1(29,9))
VS0(29,28)=QCy*VS0(29,16)+WQy*VS1(29,16)&
   +r1x2E*(VS0(29,8)-ZxZpE*VS1(29,8))&
   +3D0*HfxZpE*VS1(17,16)
VS0(29,29)=QCy*VS0(29,17)+WQy*VS1(29,17)&
   +2D0*r1x2E*(VS0(29,9)-ZxZpE*VS1(29,9))&
   +3D0*HfxZpE*VS1(17,17)
VS0(29,30)=QCx*VS0(29,18)+WQx*VS1(29,18)-r1x2E*VR1(29,18)&
   +r1x2E*(VS0(29,10)-ZxZpE*VS1(29,10))
VS0(29,31)=QCz*VS0(29,16)+WQz*VS1(29,16)&
   +r1x2E*(VS0(29,6)-ZxZpE*VS1(29,6))&
   +HfxZpE*VS1(14,16)
VS0(29,32)=QCy*VS0(29,19)+WQy*VS1(29,19)&
   +r1x2E*(VS0(29,10)-ZxZpE*VS1(29,10))&
   +3D0*HfxZpE*VS1(17,19)
VS0(29,33)=QCz*VS0(29,18)+WQz*VS1(29,18)&
   +2D0*r1x2E*(VS0(29,8)-ZxZpE*VS1(29,8))&
   +HfxZpE*VS1(14,18)
VS0(29,34)=QCz*VS0(29,19)+WQz*VS1(29,19)&
   +2D0*r1x2E*(VS0(29,9)-ZxZpE*VS1(29,9))&
   +HfxZpE*VS1(14,19)
VS0(29,35)=QCz*VS0(29,20)+WQz*VS1(29,20)&
   +3D0*r1x2E*(VS0(29,10)-ZxZpE*VS1(29,10))&
   +HfxZpE*VS1(14,20)
VS0(30,21)=QCx*VS0(30,11)+WQx*VS1(30,11)-r1x2E*VR1(30,11)&
   +3D0*r1x2E*(VS0(30,5)-ZxZpE*VS1(30,5))&
   +2D0*HfxZpE*VS1(18,11)
VS0(30,22)=QCx*VS0(30,12)+WQx*VS1(30,12)-r1x2E*VR1(30,12)&
   +2D0*r1x2E*(VS0(30,6)-ZxZpE*VS1(30,6))&
   +2D0*HfxZpE*VS1(18,12)
VS0(30,23)=QCx*VS0(30,13)+WQx*VS1(30,13)-r1x2E*VR1(30,13)&
   +r1x2E*(VS0(30,7)-ZxZpE*VS1(30,7))&
   +2D0*HfxZpE*VS1(18,13)
VS0(30,24)=QCy*VS0(30,13)+WQy*VS1(30,13)&
   +2D0*r1x2E*(VS0(30,6)-ZxZpE*VS1(30,6))
VS0(30,25)=QCy*VS0(30,14)+WQy*VS1(30,14)&
   +3D0*r1x2E*(VS0(30,7)-ZxZpE*VS1(30,7))
VS0(30,26)=QCx*VS0(30,15)+WQx*VS1(30,15)-r1x2E*VR1(30,15)&
   +2D0*r1x2E*(VS0(30,8)-ZxZpE*VS1(30,8))&
   +2D0*HfxZpE*VS1(18,15)
VS0(30,27)=QCx*VS0(30,16)+WQx*VS1(30,16)-r1x2E*VR1(30,16)&
   +r1x2E*(VS0(30,9)-ZxZpE*VS1(30,9))&
   +2D0*HfxZpE*VS1(18,16)
VS0(30,28)=QCy*VS0(30,16)+WQy*VS1(30,16)&
   +r1x2E*(VS0(30,8)-ZxZpE*VS1(30,8))
VS0(30,29)=QCy*VS0(30,17)+WQy*VS1(30,17)&
   +2D0*r1x2E*(VS0(30,9)-ZxZpE*VS1(30,9))
VS0(30,30)=QCx*VS0(30,18)+WQx*VS1(30,18)-r1x2E*VR1(30,18)&
   +r1x2E*(VS0(30,10)-ZxZpE*VS1(30,10))&
   +2D0*HfxZpE*VS1(18,18)
VS0(30,31)=QCz*VS0(30,16)+WQz*VS1(30,16)&
   +r1x2E*(VS0(30,6)-ZxZpE*VS1(30,6))&
   +2D0*HfxZpE*VS1(15,16)
VS0(30,32)=QCy*VS0(30,19)+WQy*VS1(30,19)&
   +r1x2E*(VS0(30,10)-ZxZpE*VS1(30,10))
VS0(30,33)=QCz*VS0(30,18)+WQz*VS1(30,18)&
   +2D0*r1x2E*(VS0(30,8)-ZxZpE*VS1(30,8))&
   +2D0*HfxZpE*VS1(15,18)
VS0(30,34)=QCz*VS0(30,19)+WQz*VS1(30,19)&
   +2D0*r1x2E*(VS0(30,9)-ZxZpE*VS1(30,9))&
   +2D0*HfxZpE*VS1(15,19)
VS0(30,35)=QCz*VS0(30,20)+WQz*VS1(30,20)&
   +3D0*r1x2E*(VS0(30,10)-ZxZpE*VS1(30,10))&
   +2D0*HfxZpE*VS1(15,20)
VS0(31,21)=QCx*VS0(31,11)+WQx*VS1(31,11)-r1x2E*VR1(31,11)&
   +3D0*r1x2E*(VS0(31,5)-ZxZpE*VS1(31,5))&
   +HfxZpE*VS1(19,11)
VS0(31,22)=QCx*VS0(31,12)+WQx*VS1(31,12)-r1x2E*VR1(31,12)&
   +2D0*r1x2E*(VS0(31,6)-ZxZpE*VS1(31,6))&
   +HfxZpE*VS1(19,12)
VS0(31,23)=QCx*VS0(31,13)+WQx*VS1(31,13)-r1x2E*VR1(31,13)&
   +r1x2E*(VS0(31,7)-ZxZpE*VS1(31,7))&
   +HfxZpE*VS1(19,13)
VS0(31,24)=QCy*VS0(31,13)+WQy*VS1(31,13)&
   +2D0*r1x2E*(VS0(31,6)-ZxZpE*VS1(31,6))&
   +HfxZpE*VS1(18,13)
VS0(31,25)=QCy*VS0(31,14)+WQy*VS1(31,14)&
   +3D0*r1x2E*(VS0(31,7)-ZxZpE*VS1(31,7))&
   +HfxZpE*VS1(18,14)
VS0(31,26)=QCx*VS0(31,15)+WQx*VS1(31,15)-r1x2E*VR1(31,15)&
   +2D0*r1x2E*(VS0(31,8)-ZxZpE*VS1(31,8))&
   +HfxZpE*VS1(19,15)
VS0(31,27)=QCx*VS0(31,16)+WQx*VS1(31,16)-r1x2E*VR1(31,16)&
   +r1x2E*(VS0(31,9)-ZxZpE*VS1(31,9))&
   +HfxZpE*VS1(19,16)
VS0(31,28)=QCy*VS0(31,16)+WQy*VS1(31,16)&
   +r1x2E*(VS0(31,8)-ZxZpE*VS1(31,8))&
   +HfxZpE*VS1(18,16)
VS0(31,29)=QCy*VS0(31,17)+WQy*VS1(31,17)&
   +2D0*r1x2E*(VS0(31,9)-ZxZpE*VS1(31,9))&
   +HfxZpE*VS1(18,17)
VS0(31,30)=QCx*VS0(31,18)+WQx*VS1(31,18)-r1x2E*VR1(31,18)&
   +r1x2E*(VS0(31,10)-ZxZpE*VS1(31,10))&
   +HfxZpE*VS1(19,18)
VS0(31,31)=QCz*VS0(31,16)+WQz*VS1(31,16)&
   +r1x2E*(VS0(31,6)-ZxZpE*VS1(31,6))&
   +2D0*HfxZpE*VS1(16,16)
VS0(31,32)=QCy*VS0(31,19)+WQy*VS1(31,19)&
   +r1x2E*(VS0(31,10)-ZxZpE*VS1(31,10))&
   +HfxZpE*VS1(18,19)
VS0(31,33)=QCz*VS0(31,18)+WQz*VS1(31,18)&
   +2D0*r1x2E*(VS0(31,8)-ZxZpE*VS1(31,8))&
   +2D0*HfxZpE*VS1(16,18)
VS0(31,34)=QCz*VS0(31,19)+WQz*VS1(31,19)&
   +2D0*r1x2E*(VS0(31,9)-ZxZpE*VS1(31,9))&
   +2D0*HfxZpE*VS1(16,19)
VS0(31,35)=QCz*VS0(31,20)+WQz*VS1(31,20)&
   +3D0*r1x2E*(VS0(31,10)-ZxZpE*VS1(31,10))&
   +2D0*HfxZpE*VS1(16,20)
VS0(32,21)=QCx*VS0(32,11)+WQx*VS1(32,11)-r1x2E*VR1(32,11)&
   +3D0*r1x2E*(VS0(32,5)-ZxZpE*VS1(32,5))
VS0(32,22)=QCx*VS0(32,12)+WQx*VS1(32,12)-r1x2E*VR1(32,12)&
   +2D0*r1x2E*(VS0(32,6)-ZxZpE*VS1(32,6))
VS0(32,23)=QCx*VS0(32,13)+WQx*VS1(32,13)-r1x2E*VR1(32,13)&
   +r1x2E*(VS0(32,7)-ZxZpE*VS1(32,7))
VS0(32,24)=QCy*VS0(32,13)+WQy*VS1(32,13)&
   +2D0*r1x2E*(VS0(32,6)-ZxZpE*VS1(32,6))&
   +2D0*HfxZpE*VS1(19,13)
VS0(32,25)=QCy*VS0(32,14)+WQy*VS1(32,14)&
   +3D0*r1x2E*(VS0(32,7)-ZxZpE*VS1(32,7))&
   +2D0*HfxZpE*VS1(19,14)
VS0(32,26)=QCx*VS0(32,15)+WQx*VS1(32,15)-r1x2E*VR1(32,15)&
   +2D0*r1x2E*(VS0(32,8)-ZxZpE*VS1(32,8))
VS0(32,27)=QCx*VS0(32,16)+WQx*VS1(32,16)-r1x2E*VR1(32,16)&
   +r1x2E*(VS0(32,9)-ZxZpE*VS1(32,9))
VS0(32,28)=QCy*VS0(32,16)+WQy*VS1(32,16)&
   +r1x2E*(VS0(32,8)-ZxZpE*VS1(32,8))&
   +2D0*HfxZpE*VS1(19,16)
VS0(32,29)=QCy*VS0(32,17)+WQy*VS1(32,17)&
   +2D0*r1x2E*(VS0(32,9)-ZxZpE*VS1(32,9))&
   +2D0*HfxZpE*VS1(19,17)
VS0(32,30)=QCx*VS0(32,18)+WQx*VS1(32,18)-r1x2E*VR1(32,18)&
   +r1x2E*(VS0(32,10)-ZxZpE*VS1(32,10))
VS0(32,31)=QCz*VS0(32,16)+WQz*VS1(32,16)&
   +r1x2E*(VS0(32,6)-ZxZpE*VS1(32,6))&
   +2D0*HfxZpE*VS1(17,16)
VS0(32,32)=QCy*VS0(32,19)+WQy*VS1(32,19)&
   +r1x2E*(VS0(32,10)-ZxZpE*VS1(32,10))&
   +2D0*HfxZpE*VS1(19,19)
VS0(32,33)=QCz*VS0(32,18)+WQz*VS1(32,18)&
   +2D0*r1x2E*(VS0(32,8)-ZxZpE*VS1(32,8))&
   +2D0*HfxZpE*VS1(17,18)
VS0(32,34)=QCz*VS0(32,19)+WQz*VS1(32,19)&
   +2D0*r1x2E*(VS0(32,9)-ZxZpE*VS1(32,9))&
   +2D0*HfxZpE*VS1(17,19)
VS0(32,35)=QCz*VS0(32,20)+WQz*VS1(32,20)&
   +3D0*r1x2E*(VS0(32,10)-ZxZpE*VS1(32,10))&
   +2D0*HfxZpE*VS1(17,20)
VS0(33,21)=QCx*VS0(33,11)+WQx*VS1(33,11)-r1x2E*VR1(33,11)&
   +3D0*r1x2E*(VS0(33,5)-ZxZpE*VS1(33,5))&
   +HfxZpE*VS1(20,11)
VS0(33,22)=QCx*VS0(33,12)+WQx*VS1(33,12)-r1x2E*VR1(33,12)&
   +2D0*r1x2E*(VS0(33,6)-ZxZpE*VS1(33,6))&
   +HfxZpE*VS1(20,12)
VS0(33,23)=QCx*VS0(33,13)+WQx*VS1(33,13)-r1x2E*VR1(33,13)&
   +r1x2E*(VS0(33,7)-ZxZpE*VS1(33,7))&
   +HfxZpE*VS1(20,13)
VS0(33,24)=QCy*VS0(33,13)+WQy*VS1(33,13)&
   +2D0*r1x2E*(VS0(33,6)-ZxZpE*VS1(33,6))
VS0(33,25)=QCy*VS0(33,14)+WQy*VS1(33,14)&
   +3D0*r1x2E*(VS0(33,7)-ZxZpE*VS1(33,7))
VS0(33,26)=QCx*VS0(33,15)+WQx*VS1(33,15)-r1x2E*VR1(33,15)&
   +2D0*r1x2E*(VS0(33,8)-ZxZpE*VS1(33,8))&
   +HfxZpE*VS1(20,15)
VS0(33,27)=QCx*VS0(33,16)+WQx*VS1(33,16)-r1x2E*VR1(33,16)&
   +r1x2E*(VS0(33,9)-ZxZpE*VS1(33,9))&
   +HfxZpE*VS1(20,16)
VS0(33,28)=QCy*VS0(33,16)+WQy*VS1(33,16)&
   +r1x2E*(VS0(33,8)-ZxZpE*VS1(33,8))
VS0(33,29)=QCy*VS0(33,17)+WQy*VS1(33,17)&
   +2D0*r1x2E*(VS0(33,9)-ZxZpE*VS1(33,9))
VS0(33,30)=QCx*VS0(33,18)+WQx*VS1(33,18)-r1x2E*VR1(33,18)&
   +r1x2E*(VS0(33,10)-ZxZpE*VS1(33,10))&
   +HfxZpE*VS1(20,18)
VS0(33,31)=QCz*VS0(33,16)+WQz*VS1(33,16)&
   +r1x2E*(VS0(33,6)-ZxZpE*VS1(33,6))&
   +3D0*HfxZpE*VS1(18,16)
VS0(33,32)=QCy*VS0(33,19)+WQy*VS1(33,19)&
   +r1x2E*(VS0(33,10)-ZxZpE*VS1(33,10))
VS0(33,33)=QCz*VS0(33,18)+WQz*VS1(33,18)&
   +2D0*r1x2E*(VS0(33,8)-ZxZpE*VS1(33,8))&
   +3D0*HfxZpE*VS1(18,18)
VS0(33,34)=QCz*VS0(33,19)+WQz*VS1(33,19)&
   +2D0*r1x2E*(VS0(33,9)-ZxZpE*VS1(33,9))&
   +3D0*HfxZpE*VS1(18,19)
VS0(33,35)=QCz*VS0(33,20)+WQz*VS1(33,20)&
   +3D0*r1x2E*(VS0(33,10)-ZxZpE*VS1(33,10))&
   +3D0*HfxZpE*VS1(18,20)
VS0(34,21)=QCx*VS0(34,11)+WQx*VS1(34,11)-r1x2E*VR1(34,11)&
   +3D0*r1x2E*(VS0(34,5)-ZxZpE*VS1(34,5))
VS0(34,22)=QCx*VS0(34,12)+WQx*VS1(34,12)-r1x2E*VR1(34,12)&
   +2D0*r1x2E*(VS0(34,6)-ZxZpE*VS1(34,6))
VS0(34,23)=QCx*VS0(34,13)+WQx*VS1(34,13)-r1x2E*VR1(34,13)&
   +r1x2E*(VS0(34,7)-ZxZpE*VS1(34,7))
VS0(34,24)=QCy*VS0(34,13)+WQy*VS1(34,13)&
   +2D0*r1x2E*(VS0(34,6)-ZxZpE*VS1(34,6))&
   +HfxZpE*VS1(20,13)
VS0(34,25)=QCy*VS0(34,14)+WQy*VS1(34,14)&
   +3D0*r1x2E*(VS0(34,7)-ZxZpE*VS1(34,7))&
   +HfxZpE*VS1(20,14)
VS0(34,26)=QCx*VS0(34,15)+WQx*VS1(34,15)-r1x2E*VR1(34,15)&
   +2D0*r1x2E*(VS0(34,8)-ZxZpE*VS1(34,8))
VS0(34,27)=QCx*VS0(34,16)+WQx*VS1(34,16)-r1x2E*VR1(34,16)&
   +r1x2E*(VS0(34,9)-ZxZpE*VS1(34,9))
VS0(34,28)=QCy*VS0(34,16)+WQy*VS1(34,16)&
   +r1x2E*(VS0(34,8)-ZxZpE*VS1(34,8))&
   +HfxZpE*VS1(20,16)
VS0(34,29)=QCy*VS0(34,17)+WQy*VS1(34,17)&
   +2D0*r1x2E*(VS0(34,9)-ZxZpE*VS1(34,9))&
   +HfxZpE*VS1(20,17)
VS0(34,30)=QCx*VS0(34,18)+WQx*VS1(34,18)-r1x2E*VR1(34,18)&
   +r1x2E*(VS0(34,10)-ZxZpE*VS1(34,10))
VS0(34,31)=QCz*VS0(34,16)+WQz*VS1(34,16)&
   +r1x2E*(VS0(34,6)-ZxZpE*VS1(34,6))&
   +3D0*HfxZpE*VS1(19,16)
VS0(34,32)=QCy*VS0(34,19)+WQy*VS1(34,19)&
   +r1x2E*(VS0(34,10)-ZxZpE*VS1(34,10))&
   +HfxZpE*VS1(20,19)
VS0(34,33)=QCz*VS0(34,18)+WQz*VS1(34,18)&
   +2D0*r1x2E*(VS0(34,8)-ZxZpE*VS1(34,8))&
   +3D0*HfxZpE*VS1(19,18)
VS0(34,34)=QCz*VS0(34,19)+WQz*VS1(34,19)&
   +2D0*r1x2E*(VS0(34,9)-ZxZpE*VS1(34,9))&
   +3D0*HfxZpE*VS1(19,19)
VS0(34,35)=QCz*VS0(34,20)+WQz*VS1(34,20)&
   +3D0*r1x2E*(VS0(34,10)-ZxZpE*VS1(34,10))&
   +3D0*HfxZpE*VS1(19,20)
VS0(35,21)=QCx*VS0(35,11)+WQx*VS1(35,11)-r1x2E*VR1(35,11)&
   +3D0*r1x2E*(VS0(35,5)-ZxZpE*VS1(35,5))
VS0(35,22)=QCx*VS0(35,12)+WQx*VS1(35,12)-r1x2E*VR1(35,12)&
   +2D0*r1x2E*(VS0(35,6)-ZxZpE*VS1(35,6))
VS0(35,23)=QCx*VS0(35,13)+WQx*VS1(35,13)-r1x2E*VR1(35,13)&
   +r1x2E*(VS0(35,7)-ZxZpE*VS1(35,7))
VS0(35,24)=QCy*VS0(35,13)+WQy*VS1(35,13)&
   +2D0*r1x2E*(VS0(35,6)-ZxZpE*VS1(35,6))
VS0(35,25)=QCy*VS0(35,14)+WQy*VS1(35,14)&
   +3D0*r1x2E*(VS0(35,7)-ZxZpE*VS1(35,7))
VS0(35,26)=QCx*VS0(35,15)+WQx*VS1(35,15)-r1x2E*VR1(35,15)&
   +2D0*r1x2E*(VS0(35,8)-ZxZpE*VS1(35,8))
VS0(35,27)=QCx*VS0(35,16)+WQx*VS1(35,16)-r1x2E*VR1(35,16)&
   +r1x2E*(VS0(35,9)-ZxZpE*VS1(35,9))
VS0(35,28)=QCy*VS0(35,16)+WQy*VS1(35,16)&
   +r1x2E*(VS0(35,8)-ZxZpE*VS1(35,8))
VS0(35,29)=QCy*VS0(35,17)+WQy*VS1(35,17)&
   +2D0*r1x2E*(VS0(35,9)-ZxZpE*VS1(35,9))
VS0(35,30)=QCx*VS0(35,18)+WQx*VS1(35,18)-r1x2E*VR1(35,18)&
   +r1x2E*(VS0(35,10)-ZxZpE*VS1(35,10))
VS0(35,31)=QCz*VS0(35,16)+WQz*VS1(35,16)&
   +r1x2E*(VS0(35,6)-ZxZpE*VS1(35,6))&
   +4D0*HfxZpE*VS1(20,16)
VS0(35,32)=QCy*VS0(35,19)+WQy*VS1(35,19)&
   +r1x2E*(VS0(35,10)-ZxZpE*VS1(35,10))
VS0(35,33)=QCz*VS0(35,18)+WQz*VS1(35,18)&
   +2D0*r1x2E*(VS0(35,8)-ZxZpE*VS1(35,8))&
   +4D0*HfxZpE*VS1(20,18)
VS0(35,34)=QCz*VS0(35,19)+WQz*VS1(35,19)&
   +2D0*r1x2E*(VS0(35,9)-ZxZpE*VS1(35,9))&
   +4D0*HfxZpE*VS1(20,19)
VS0(35,35)=QCz*VS0(35,20)+WQz*VS1(35,20)&
   +3D0*r1x2E*(VS0(35,10)-ZxZpE*VS1(35,10))&
   +4D0*HfxZpE*VS1(20,20)
CASE(2)
VS0(21,21)=QCx*VS0(21,11)+WQx*VS1(21,11)&
   +3D0*r1x2E*(VS0(21,5)-ZxZpE*VS1(21,5))&
   +4D0*HfxZpE*VS1(11,11)
VS0(21,22)=QCx*VS0(21,12)+WQx*VS1(21,12)&
   +2D0*r1x2E*(VS0(21,6)-ZxZpE*VS1(21,6))&
   +4D0*HfxZpE*VS1(11,12)
VS0(21,23)=QCx*VS0(21,13)+WQx*VS1(21,13)&
   +r1x2E*(VS0(21,7)-ZxZpE*VS1(21,7))&
   +4D0*HfxZpE*VS1(11,13)
VS0(21,24)=QCy*VS0(21,13)+WQy*VS1(21,13)-r1x2E*VR1(21,13)&
   +2D0*r1x2E*(VS0(21,6)-ZxZpE*VS1(21,6))
VS0(21,25)=QCy*VS0(21,14)+WQy*VS1(21,14)-r1x2E*VR1(21,14)&
   +3D0*r1x2E*(VS0(21,7)-ZxZpE*VS1(21,7))
VS0(21,26)=QCx*VS0(21,15)+WQx*VS1(21,15)&
   +2D0*r1x2E*(VS0(21,8)-ZxZpE*VS1(21,8))&
   +4D0*HfxZpE*VS1(11,15)
VS0(21,27)=QCx*VS0(21,16)+WQx*VS1(21,16)&
   +r1x2E*(VS0(21,9)-ZxZpE*VS1(21,9))&
   +4D0*HfxZpE*VS1(11,16)
VS0(21,28)=QCy*VS0(21,16)+WQy*VS1(21,16)-r1x2E*VR1(21,16)&
   +r1x2E*(VS0(21,8)-ZxZpE*VS1(21,8))
VS0(21,29)=QCy*VS0(21,17)+WQy*VS1(21,17)-r1x2E*VR1(21,17)&
   +2D0*r1x2E*(VS0(21,9)-ZxZpE*VS1(21,9))
VS0(21,30)=QCx*VS0(21,18)+WQx*VS1(21,18)&
   +r1x2E*(VS0(21,10)-ZxZpE*VS1(21,10))&
   +4D0*HfxZpE*VS1(11,18)
VS0(21,31)=QCz*VS0(21,16)+WQz*VS1(21,16)&
   +r1x2E*(VS0(21,6)-ZxZpE*VS1(21,6))
VS0(21,32)=QCy*VS0(21,19)+WQy*VS1(21,19)-r1x2E*VR1(21,19)&
   +r1x2E*(VS0(21,10)-ZxZpE*VS1(21,10))
VS0(21,33)=QCz*VS0(21,18)+WQz*VS1(21,18)&
   +2D0*r1x2E*(VS0(21,8)-ZxZpE*VS1(21,8))
VS0(21,34)=QCz*VS0(21,19)+WQz*VS1(21,19)&
   +2D0*r1x2E*(VS0(21,9)-ZxZpE*VS1(21,9))
VS0(21,35)=QCz*VS0(21,20)+WQz*VS1(21,20)&
   +3D0*r1x2E*(VS0(21,10)-ZxZpE*VS1(21,10))
VS0(22,21)=QCx*VS0(22,11)+WQx*VS1(22,11)&
   +3D0*r1x2E*(VS0(22,5)-ZxZpE*VS1(22,5))&
   +3D0*HfxZpE*VS1(12,11)
VS0(22,22)=QCx*VS0(22,12)+WQx*VS1(22,12)&
   +2D0*r1x2E*(VS0(22,6)-ZxZpE*VS1(22,6))&
   +3D0*HfxZpE*VS1(12,12)
VS0(22,23)=QCx*VS0(22,13)+WQx*VS1(22,13)&
   +r1x2E*(VS0(22,7)-ZxZpE*VS1(22,7))&
   +3D0*HfxZpE*VS1(12,13)
VS0(22,24)=QCy*VS0(22,13)+WQy*VS1(22,13)-r1x2E*VR1(22,13)&
   +2D0*r1x2E*(VS0(22,6)-ZxZpE*VS1(22,6))&
   +HfxZpE*VS1(11,13)
VS0(22,25)=QCy*VS0(22,14)+WQy*VS1(22,14)-r1x2E*VR1(22,14)&
   +3D0*r1x2E*(VS0(22,7)-ZxZpE*VS1(22,7))&
   +HfxZpE*VS1(11,14)
VS0(22,26)=QCx*VS0(22,15)+WQx*VS1(22,15)&
   +2D0*r1x2E*(VS0(22,8)-ZxZpE*VS1(22,8))&
   +3D0*HfxZpE*VS1(12,15)
VS0(22,27)=QCx*VS0(22,16)+WQx*VS1(22,16)&
   +r1x2E*(VS0(22,9)-ZxZpE*VS1(22,9))&
   +3D0*HfxZpE*VS1(12,16)
VS0(22,28)=QCy*VS0(22,16)+WQy*VS1(22,16)-r1x2E*VR1(22,16)&
   +r1x2E*(VS0(22,8)-ZxZpE*VS1(22,8))&
   +HfxZpE*VS1(11,16)
VS0(22,29)=QCy*VS0(22,17)+WQy*VS1(22,17)-r1x2E*VR1(22,17)&
   +2D0*r1x2E*(VS0(22,9)-ZxZpE*VS1(22,9))&
   +HfxZpE*VS1(11,17)
VS0(22,30)=QCx*VS0(22,18)+WQx*VS1(22,18)&
   +r1x2E*(VS0(22,10)-ZxZpE*VS1(22,10))&
   +3D0*HfxZpE*VS1(12,18)
VS0(22,31)=QCz*VS0(22,16)+WQz*VS1(22,16)&
   +r1x2E*(VS0(22,6)-ZxZpE*VS1(22,6))
VS0(22,32)=QCy*VS0(22,19)+WQy*VS1(22,19)-r1x2E*VR1(22,19)&
   +r1x2E*(VS0(22,10)-ZxZpE*VS1(22,10))&
   +HfxZpE*VS1(11,19)
VS0(22,33)=QCz*VS0(22,18)+WQz*VS1(22,18)&
   +2D0*r1x2E*(VS0(22,8)-ZxZpE*VS1(22,8))
VS0(22,34)=QCz*VS0(22,19)+WQz*VS1(22,19)&
   +2D0*r1x2E*(VS0(22,9)-ZxZpE*VS1(22,9))
VS0(22,35)=QCz*VS0(22,20)+WQz*VS1(22,20)&
   +3D0*r1x2E*(VS0(22,10)-ZxZpE*VS1(22,10))
VS0(23,21)=QCx*VS0(23,11)+WQx*VS1(23,11)&
   +3D0*r1x2E*(VS0(23,5)-ZxZpE*VS1(23,5))&
   +2D0*HfxZpE*VS1(13,11)
VS0(23,22)=QCx*VS0(23,12)+WQx*VS1(23,12)&
   +2D0*r1x2E*(VS0(23,6)-ZxZpE*VS1(23,6))&
   +2D0*HfxZpE*VS1(13,12)
VS0(23,23)=QCx*VS0(23,13)+WQx*VS1(23,13)&
   +r1x2E*(VS0(23,7)-ZxZpE*VS1(23,7))&
   +2D0*HfxZpE*VS1(13,13)
VS0(23,24)=QCy*VS0(23,13)+WQy*VS1(23,13)-r1x2E*VR1(23,13)&
   +2D0*r1x2E*(VS0(23,6)-ZxZpE*VS1(23,6))&
   +2D0*HfxZpE*VS1(12,13)
VS0(23,25)=QCy*VS0(23,14)+WQy*VS1(23,14)-r1x2E*VR1(23,14)&
   +3D0*r1x2E*(VS0(23,7)-ZxZpE*VS1(23,7))&
   +2D0*HfxZpE*VS1(12,14)
VS0(23,26)=QCx*VS0(23,15)+WQx*VS1(23,15)&
   +2D0*r1x2E*(VS0(23,8)-ZxZpE*VS1(23,8))&
   +2D0*HfxZpE*VS1(13,15)
VS0(23,27)=QCx*VS0(23,16)+WQx*VS1(23,16)&
   +r1x2E*(VS0(23,9)-ZxZpE*VS1(23,9))&
   +2D0*HfxZpE*VS1(13,16)
VS0(23,28)=QCy*VS0(23,16)+WQy*VS1(23,16)-r1x2E*VR1(23,16)&
   +r1x2E*(VS0(23,8)-ZxZpE*VS1(23,8))&
   +2D0*HfxZpE*VS1(12,16)
VS0(23,29)=QCy*VS0(23,17)+WQy*VS1(23,17)-r1x2E*VR1(23,17)&
   +2D0*r1x2E*(VS0(23,9)-ZxZpE*VS1(23,9))&
   +2D0*HfxZpE*VS1(12,17)
VS0(23,30)=QCx*VS0(23,18)+WQx*VS1(23,18)&
   +r1x2E*(VS0(23,10)-ZxZpE*VS1(23,10))&
   +2D0*HfxZpE*VS1(13,18)
VS0(23,31)=QCz*VS0(23,16)+WQz*VS1(23,16)&
   +r1x2E*(VS0(23,6)-ZxZpE*VS1(23,6))
VS0(23,32)=QCy*VS0(23,19)+WQy*VS1(23,19)-r1x2E*VR1(23,19)&
   +r1x2E*(VS0(23,10)-ZxZpE*VS1(23,10))&
   +2D0*HfxZpE*VS1(12,19)
VS0(23,33)=QCz*VS0(23,18)+WQz*VS1(23,18)&
   +2D0*r1x2E*(VS0(23,8)-ZxZpE*VS1(23,8))
VS0(23,34)=QCz*VS0(23,19)+WQz*VS1(23,19)&
   +2D0*r1x2E*(VS0(23,9)-ZxZpE*VS1(23,9))
VS0(23,35)=QCz*VS0(23,20)+WQz*VS1(23,20)&
   +3D0*r1x2E*(VS0(23,10)-ZxZpE*VS1(23,10))
VS0(24,21)=QCx*VS0(24,11)+WQx*VS1(24,11)&
   +3D0*r1x2E*(VS0(24,5)-ZxZpE*VS1(24,5))&
   +HfxZpE*VS1(14,11)
VS0(24,22)=QCx*VS0(24,12)+WQx*VS1(24,12)&
   +2D0*r1x2E*(VS0(24,6)-ZxZpE*VS1(24,6))&
   +HfxZpE*VS1(14,12)
VS0(24,23)=QCx*VS0(24,13)+WQx*VS1(24,13)&
   +r1x2E*(VS0(24,7)-ZxZpE*VS1(24,7))&
   +HfxZpE*VS1(14,13)
VS0(24,24)=QCy*VS0(24,13)+WQy*VS1(24,13)-r1x2E*VR1(24,13)&
   +2D0*r1x2E*(VS0(24,6)-ZxZpE*VS1(24,6))&
   +3D0*HfxZpE*VS1(13,13)
VS0(24,25)=QCy*VS0(24,14)+WQy*VS1(24,14)-r1x2E*VR1(24,14)&
   +3D0*r1x2E*(VS0(24,7)-ZxZpE*VS1(24,7))&
   +3D0*HfxZpE*VS1(13,14)
VS0(24,26)=QCx*VS0(24,15)+WQx*VS1(24,15)&
   +2D0*r1x2E*(VS0(24,8)-ZxZpE*VS1(24,8))&
   +HfxZpE*VS1(14,15)
VS0(24,27)=QCx*VS0(24,16)+WQx*VS1(24,16)&
   +r1x2E*(VS0(24,9)-ZxZpE*VS1(24,9))&
   +HfxZpE*VS1(14,16)
VS0(24,28)=QCy*VS0(24,16)+WQy*VS1(24,16)-r1x2E*VR1(24,16)&
   +r1x2E*(VS0(24,8)-ZxZpE*VS1(24,8))&
   +3D0*HfxZpE*VS1(13,16)
VS0(24,29)=QCy*VS0(24,17)+WQy*VS1(24,17)-r1x2E*VR1(24,17)&
   +2D0*r1x2E*(VS0(24,9)-ZxZpE*VS1(24,9))&
   +3D0*HfxZpE*VS1(13,17)
VS0(24,30)=QCx*VS0(24,18)+WQx*VS1(24,18)&
   +r1x2E*(VS0(24,10)-ZxZpE*VS1(24,10))&
   +HfxZpE*VS1(14,18)
VS0(24,31)=QCz*VS0(24,16)+WQz*VS1(24,16)&
   +r1x2E*(VS0(24,6)-ZxZpE*VS1(24,6))
VS0(24,32)=QCy*VS0(24,19)+WQy*VS1(24,19)-r1x2E*VR1(24,19)&
   +r1x2E*(VS0(24,10)-ZxZpE*VS1(24,10))&
   +3D0*HfxZpE*VS1(13,19)
VS0(24,33)=QCz*VS0(24,18)+WQz*VS1(24,18)&
   +2D0*r1x2E*(VS0(24,8)-ZxZpE*VS1(24,8))
VS0(24,34)=QCz*VS0(24,19)+WQz*VS1(24,19)&
   +2D0*r1x2E*(VS0(24,9)-ZxZpE*VS1(24,9))
VS0(24,35)=QCz*VS0(24,20)+WQz*VS1(24,20)&
   +3D0*r1x2E*(VS0(24,10)-ZxZpE*VS1(24,10))
VS0(25,21)=QCx*VS0(25,11)+WQx*VS1(25,11)&
   +3D0*r1x2E*(VS0(25,5)-ZxZpE*VS1(25,5))
VS0(25,22)=QCx*VS0(25,12)+WQx*VS1(25,12)&
   +2D0*r1x2E*(VS0(25,6)-ZxZpE*VS1(25,6))
VS0(25,23)=QCx*VS0(25,13)+WQx*VS1(25,13)&
   +r1x2E*(VS0(25,7)-ZxZpE*VS1(25,7))
VS0(25,24)=QCy*VS0(25,13)+WQy*VS1(25,13)-r1x2E*VR1(25,13)&
   +2D0*r1x2E*(VS0(25,6)-ZxZpE*VS1(25,6))&
   +4D0*HfxZpE*VS1(14,13)
VS0(25,25)=QCy*VS0(25,14)+WQy*VS1(25,14)-r1x2E*VR1(25,14)&
   +3D0*r1x2E*(VS0(25,7)-ZxZpE*VS1(25,7))&
   +4D0*HfxZpE*VS1(14,14)
VS0(25,26)=QCx*VS0(25,15)+WQx*VS1(25,15)&
   +2D0*r1x2E*(VS0(25,8)-ZxZpE*VS1(25,8))
VS0(25,27)=QCx*VS0(25,16)+WQx*VS1(25,16)&
   +r1x2E*(VS0(25,9)-ZxZpE*VS1(25,9))
VS0(25,28)=QCy*VS0(25,16)+WQy*VS1(25,16)-r1x2E*VR1(25,16)&
   +r1x2E*(VS0(25,8)-ZxZpE*VS1(25,8))&
   +4D0*HfxZpE*VS1(14,16)
VS0(25,29)=QCy*VS0(25,17)+WQy*VS1(25,17)-r1x2E*VR1(25,17)&
   +2D0*r1x2E*(VS0(25,9)-ZxZpE*VS1(25,9))&
   +4D0*HfxZpE*VS1(14,17)
VS0(25,30)=QCx*VS0(25,18)+WQx*VS1(25,18)&
   +r1x2E*(VS0(25,10)-ZxZpE*VS1(25,10))
VS0(25,31)=QCz*VS0(25,16)+WQz*VS1(25,16)&
   +r1x2E*(VS0(25,6)-ZxZpE*VS1(25,6))
VS0(25,32)=QCy*VS0(25,19)+WQy*VS1(25,19)-r1x2E*VR1(25,19)&
   +r1x2E*(VS0(25,10)-ZxZpE*VS1(25,10))&
   +4D0*HfxZpE*VS1(14,19)
VS0(25,33)=QCz*VS0(25,18)+WQz*VS1(25,18)&
   +2D0*r1x2E*(VS0(25,8)-ZxZpE*VS1(25,8))
VS0(25,34)=QCz*VS0(25,19)+WQz*VS1(25,19)&
   +2D0*r1x2E*(VS0(25,9)-ZxZpE*VS1(25,9))
VS0(25,35)=QCz*VS0(25,20)+WQz*VS1(25,20)&
   +3D0*r1x2E*(VS0(25,10)-ZxZpE*VS1(25,10))
VS0(26,21)=QCx*VS0(26,11)+WQx*VS1(26,11)&
   +3D0*r1x2E*(VS0(26,5)-ZxZpE*VS1(26,5))&
   +3D0*HfxZpE*VS1(15,11)
VS0(26,22)=QCx*VS0(26,12)+WQx*VS1(26,12)&
   +2D0*r1x2E*(VS0(26,6)-ZxZpE*VS1(26,6))&
   +3D0*HfxZpE*VS1(15,12)
VS0(26,23)=QCx*VS0(26,13)+WQx*VS1(26,13)&
   +r1x2E*(VS0(26,7)-ZxZpE*VS1(26,7))&
   +3D0*HfxZpE*VS1(15,13)
VS0(26,24)=QCy*VS0(26,13)+WQy*VS1(26,13)-r1x2E*VR1(26,13)&
   +2D0*r1x2E*(VS0(26,6)-ZxZpE*VS1(26,6))
VS0(26,25)=QCy*VS0(26,14)+WQy*VS1(26,14)-r1x2E*VR1(26,14)&
   +3D0*r1x2E*(VS0(26,7)-ZxZpE*VS1(26,7))
VS0(26,26)=QCx*VS0(26,15)+WQx*VS1(26,15)&
   +2D0*r1x2E*(VS0(26,8)-ZxZpE*VS1(26,8))&
   +3D0*HfxZpE*VS1(15,15)
VS0(26,27)=QCx*VS0(26,16)+WQx*VS1(26,16)&
   +r1x2E*(VS0(26,9)-ZxZpE*VS1(26,9))&
   +3D0*HfxZpE*VS1(15,16)
VS0(26,28)=QCy*VS0(26,16)+WQy*VS1(26,16)-r1x2E*VR1(26,16)&
   +r1x2E*(VS0(26,8)-ZxZpE*VS1(26,8))
VS0(26,29)=QCy*VS0(26,17)+WQy*VS1(26,17)-r1x2E*VR1(26,17)&
   +2D0*r1x2E*(VS0(26,9)-ZxZpE*VS1(26,9))
VS0(26,30)=QCx*VS0(26,18)+WQx*VS1(26,18)&
   +r1x2E*(VS0(26,10)-ZxZpE*VS1(26,10))&
   +3D0*HfxZpE*VS1(15,18)
VS0(26,31)=QCz*VS0(26,16)+WQz*VS1(26,16)&
   +r1x2E*(VS0(26,6)-ZxZpE*VS1(26,6))&
   +HfxZpE*VS1(11,16)
VS0(26,32)=QCy*VS0(26,19)+WQy*VS1(26,19)-r1x2E*VR1(26,19)&
   +r1x2E*(VS0(26,10)-ZxZpE*VS1(26,10))
VS0(26,33)=QCz*VS0(26,18)+WQz*VS1(26,18)&
   +2D0*r1x2E*(VS0(26,8)-ZxZpE*VS1(26,8))&
   +HfxZpE*VS1(11,18)
VS0(26,34)=QCz*VS0(26,19)+WQz*VS1(26,19)&
   +2D0*r1x2E*(VS0(26,9)-ZxZpE*VS1(26,9))&
   +HfxZpE*VS1(11,19)
VS0(26,35)=QCz*VS0(26,20)+WQz*VS1(26,20)&
   +3D0*r1x2E*(VS0(26,10)-ZxZpE*VS1(26,10))&
   +HfxZpE*VS1(11,20)
VS0(27,21)=QCx*VS0(27,11)+WQx*VS1(27,11)&
   +3D0*r1x2E*(VS0(27,5)-ZxZpE*VS1(27,5))&
   +2D0*HfxZpE*VS1(16,11)
VS0(27,22)=QCx*VS0(27,12)+WQx*VS1(27,12)&
   +2D0*r1x2E*(VS0(27,6)-ZxZpE*VS1(27,6))&
   +2D0*HfxZpE*VS1(16,12)
VS0(27,23)=QCx*VS0(27,13)+WQx*VS1(27,13)&
   +r1x2E*(VS0(27,7)-ZxZpE*VS1(27,7))&
   +2D0*HfxZpE*VS1(16,13)
VS0(27,24)=QCy*VS0(27,13)+WQy*VS1(27,13)-r1x2E*VR1(27,13)&
   +2D0*r1x2E*(VS0(27,6)-ZxZpE*VS1(27,6))&
   +HfxZpE*VS1(15,13)
VS0(27,25)=QCy*VS0(27,14)+WQy*VS1(27,14)-r1x2E*VR1(27,14)&
   +3D0*r1x2E*(VS0(27,7)-ZxZpE*VS1(27,7))&
   +HfxZpE*VS1(15,14)
VS0(27,26)=QCx*VS0(27,15)+WQx*VS1(27,15)&
   +2D0*r1x2E*(VS0(27,8)-ZxZpE*VS1(27,8))&
   +2D0*HfxZpE*VS1(16,15)
VS0(27,27)=QCx*VS0(27,16)+WQx*VS1(27,16)&
   +r1x2E*(VS0(27,9)-ZxZpE*VS1(27,9))&
   +2D0*HfxZpE*VS1(16,16)
VS0(27,28)=QCy*VS0(27,16)+WQy*VS1(27,16)-r1x2E*VR1(27,16)&
   +r1x2E*(VS0(27,8)-ZxZpE*VS1(27,8))&
   +HfxZpE*VS1(15,16)
VS0(27,29)=QCy*VS0(27,17)+WQy*VS1(27,17)-r1x2E*VR1(27,17)&
   +2D0*r1x2E*(VS0(27,9)-ZxZpE*VS1(27,9))&
   +HfxZpE*VS1(15,17)
VS0(27,30)=QCx*VS0(27,18)+WQx*VS1(27,18)&
   +r1x2E*(VS0(27,10)-ZxZpE*VS1(27,10))&
   +2D0*HfxZpE*VS1(16,18)
VS0(27,31)=QCz*VS0(27,16)+WQz*VS1(27,16)&
   +r1x2E*(VS0(27,6)-ZxZpE*VS1(27,6))&
   +HfxZpE*VS1(12,16)
VS0(27,32)=QCy*VS0(27,19)+WQy*VS1(27,19)-r1x2E*VR1(27,19)&
   +r1x2E*(VS0(27,10)-ZxZpE*VS1(27,10))&
   +HfxZpE*VS1(15,19)
VS0(27,33)=QCz*VS0(27,18)+WQz*VS1(27,18)&
   +2D0*r1x2E*(VS0(27,8)-ZxZpE*VS1(27,8))&
   +HfxZpE*VS1(12,18)
VS0(27,34)=QCz*VS0(27,19)+WQz*VS1(27,19)&
   +2D0*r1x2E*(VS0(27,9)-ZxZpE*VS1(27,9))&
   +HfxZpE*VS1(12,19)
VS0(27,35)=QCz*VS0(27,20)+WQz*VS1(27,20)&
   +3D0*r1x2E*(VS0(27,10)-ZxZpE*VS1(27,10))&
   +HfxZpE*VS1(12,20)
VS0(28,21)=QCx*VS0(28,11)+WQx*VS1(28,11)&
   +3D0*r1x2E*(VS0(28,5)-ZxZpE*VS1(28,5))&
   +HfxZpE*VS1(17,11)
VS0(28,22)=QCx*VS0(28,12)+WQx*VS1(28,12)&
   +2D0*r1x2E*(VS0(28,6)-ZxZpE*VS1(28,6))&
   +HfxZpE*VS1(17,12)
VS0(28,23)=QCx*VS0(28,13)+WQx*VS1(28,13)&
   +r1x2E*(VS0(28,7)-ZxZpE*VS1(28,7))&
   +HfxZpE*VS1(17,13)
VS0(28,24)=QCy*VS0(28,13)+WQy*VS1(28,13)-r1x2E*VR1(28,13)&
   +2D0*r1x2E*(VS0(28,6)-ZxZpE*VS1(28,6))&
   +2D0*HfxZpE*VS1(16,13)
VS0(28,25)=QCy*VS0(28,14)+WQy*VS1(28,14)-r1x2E*VR1(28,14)&
   +3D0*r1x2E*(VS0(28,7)-ZxZpE*VS1(28,7))&
   +2D0*HfxZpE*VS1(16,14)
VS0(28,26)=QCx*VS0(28,15)+WQx*VS1(28,15)&
   +2D0*r1x2E*(VS0(28,8)-ZxZpE*VS1(28,8))&
   +HfxZpE*VS1(17,15)
VS0(28,27)=QCx*VS0(28,16)+WQx*VS1(28,16)&
   +r1x2E*(VS0(28,9)-ZxZpE*VS1(28,9))&
   +HfxZpE*VS1(17,16)
VS0(28,28)=QCy*VS0(28,16)+WQy*VS1(28,16)-r1x2E*VR1(28,16)&
   +r1x2E*(VS0(28,8)-ZxZpE*VS1(28,8))&
   +2D0*HfxZpE*VS1(16,16)
VS0(28,29)=QCy*VS0(28,17)+WQy*VS1(28,17)-r1x2E*VR1(28,17)&
   +2D0*r1x2E*(VS0(28,9)-ZxZpE*VS1(28,9))&
   +2D0*HfxZpE*VS1(16,17)
VS0(28,30)=QCx*VS0(28,18)+WQx*VS1(28,18)&
   +r1x2E*(VS0(28,10)-ZxZpE*VS1(28,10))&
   +HfxZpE*VS1(17,18)
VS0(28,31)=QCz*VS0(28,16)+WQz*VS1(28,16)&
   +r1x2E*(VS0(28,6)-ZxZpE*VS1(28,6))&
   +HfxZpE*VS1(13,16)
VS0(28,32)=QCy*VS0(28,19)+WQy*VS1(28,19)-r1x2E*VR1(28,19)&
   +r1x2E*(VS0(28,10)-ZxZpE*VS1(28,10))&
   +2D0*HfxZpE*VS1(16,19)
VS0(28,33)=QCz*VS0(28,18)+WQz*VS1(28,18)&
   +2D0*r1x2E*(VS0(28,8)-ZxZpE*VS1(28,8))&
   +HfxZpE*VS1(13,18)
VS0(28,34)=QCz*VS0(28,19)+WQz*VS1(28,19)&
   +2D0*r1x2E*(VS0(28,9)-ZxZpE*VS1(28,9))&
   +HfxZpE*VS1(13,19)
VS0(28,35)=QCz*VS0(28,20)+WQz*VS1(28,20)&
   +3D0*r1x2E*(VS0(28,10)-ZxZpE*VS1(28,10))&
   +HfxZpE*VS1(13,20)
VS0(29,21)=QCx*VS0(29,11)+WQx*VS1(29,11)&
   +3D0*r1x2E*(VS0(29,5)-ZxZpE*VS1(29,5))
VS0(29,22)=QCx*VS0(29,12)+WQx*VS1(29,12)&
   +2D0*r1x2E*(VS0(29,6)-ZxZpE*VS1(29,6))
VS0(29,23)=QCx*VS0(29,13)+WQx*VS1(29,13)&
   +r1x2E*(VS0(29,7)-ZxZpE*VS1(29,7))
VS0(29,24)=QCy*VS0(29,13)+WQy*VS1(29,13)-r1x2E*VR1(29,13)&
   +2D0*r1x2E*(VS0(29,6)-ZxZpE*VS1(29,6))&
   +3D0*HfxZpE*VS1(17,13)
VS0(29,25)=QCy*VS0(29,14)+WQy*VS1(29,14)-r1x2E*VR1(29,14)&
   +3D0*r1x2E*(VS0(29,7)-ZxZpE*VS1(29,7))&
   +3D0*HfxZpE*VS1(17,14)
VS0(29,26)=QCx*VS0(29,15)+WQx*VS1(29,15)&
   +2D0*r1x2E*(VS0(29,8)-ZxZpE*VS1(29,8))
VS0(29,27)=QCx*VS0(29,16)+WQx*VS1(29,16)&
   +r1x2E*(VS0(29,9)-ZxZpE*VS1(29,9))
VS0(29,28)=QCy*VS0(29,16)+WQy*VS1(29,16)-r1x2E*VR1(29,16)&
   +r1x2E*(VS0(29,8)-ZxZpE*VS1(29,8))&
   +3D0*HfxZpE*VS1(17,16)
VS0(29,29)=QCy*VS0(29,17)+WQy*VS1(29,17)-r1x2E*VR1(29,17)&
   +2D0*r1x2E*(VS0(29,9)-ZxZpE*VS1(29,9))&
   +3D0*HfxZpE*VS1(17,17)
VS0(29,30)=QCx*VS0(29,18)+WQx*VS1(29,18)&
   +r1x2E*(VS0(29,10)-ZxZpE*VS1(29,10))
VS0(29,31)=QCz*VS0(29,16)+WQz*VS1(29,16)&
   +r1x2E*(VS0(29,6)-ZxZpE*VS1(29,6))&
   +HfxZpE*VS1(14,16)
VS0(29,32)=QCy*VS0(29,19)+WQy*VS1(29,19)-r1x2E*VR1(29,19)&
   +r1x2E*(VS0(29,10)-ZxZpE*VS1(29,10))&
   +3D0*HfxZpE*VS1(17,19)
VS0(29,33)=QCz*VS0(29,18)+WQz*VS1(29,18)&
   +2D0*r1x2E*(VS0(29,8)-ZxZpE*VS1(29,8))&
   +HfxZpE*VS1(14,18)
VS0(29,34)=QCz*VS0(29,19)+WQz*VS1(29,19)&
   +2D0*r1x2E*(VS0(29,9)-ZxZpE*VS1(29,9))&
   +HfxZpE*VS1(14,19)
VS0(29,35)=QCz*VS0(29,20)+WQz*VS1(29,20)&
   +3D0*r1x2E*(VS0(29,10)-ZxZpE*VS1(29,10))&
   +HfxZpE*VS1(14,20)
VS0(30,21)=QCx*VS0(30,11)+WQx*VS1(30,11)&
   +3D0*r1x2E*(VS0(30,5)-ZxZpE*VS1(30,5))&
   +2D0*HfxZpE*VS1(18,11)
VS0(30,22)=QCx*VS0(30,12)+WQx*VS1(30,12)&
   +2D0*r1x2E*(VS0(30,6)-ZxZpE*VS1(30,6))&
   +2D0*HfxZpE*VS1(18,12)
VS0(30,23)=QCx*VS0(30,13)+WQx*VS1(30,13)&
   +r1x2E*(VS0(30,7)-ZxZpE*VS1(30,7))&
   +2D0*HfxZpE*VS1(18,13)
VS0(30,24)=QCy*VS0(30,13)+WQy*VS1(30,13)-r1x2E*VR1(30,13)&
   +2D0*r1x2E*(VS0(30,6)-ZxZpE*VS1(30,6))
VS0(30,25)=QCy*VS0(30,14)+WQy*VS1(30,14)-r1x2E*VR1(30,14)&
   +3D0*r1x2E*(VS0(30,7)-ZxZpE*VS1(30,7))
VS0(30,26)=QCx*VS0(30,15)+WQx*VS1(30,15)&
   +2D0*r1x2E*(VS0(30,8)-ZxZpE*VS1(30,8))&
   +2D0*HfxZpE*VS1(18,15)
VS0(30,27)=QCx*VS0(30,16)+WQx*VS1(30,16)&
   +r1x2E*(VS0(30,9)-ZxZpE*VS1(30,9))&
   +2D0*HfxZpE*VS1(18,16)
VS0(30,28)=QCy*VS0(30,16)+WQy*VS1(30,16)-r1x2E*VR1(30,16)&
   +r1x2E*(VS0(30,8)-ZxZpE*VS1(30,8))
VS0(30,29)=QCy*VS0(30,17)+WQy*VS1(30,17)-r1x2E*VR1(30,17)&
   +2D0*r1x2E*(VS0(30,9)-ZxZpE*VS1(30,9))
VS0(30,30)=QCx*VS0(30,18)+WQx*VS1(30,18)&
   +r1x2E*(VS0(30,10)-ZxZpE*VS1(30,10))&
   +2D0*HfxZpE*VS1(18,18)
VS0(30,31)=QCz*VS0(30,16)+WQz*VS1(30,16)&
   +r1x2E*(VS0(30,6)-ZxZpE*VS1(30,6))&
   +2D0*HfxZpE*VS1(15,16)
VS0(30,32)=QCy*VS0(30,19)+WQy*VS1(30,19)-r1x2E*VR1(30,19)&
   +r1x2E*(VS0(30,10)-ZxZpE*VS1(30,10))
VS0(30,33)=QCz*VS0(30,18)+WQz*VS1(30,18)&
   +2D0*r1x2E*(VS0(30,8)-ZxZpE*VS1(30,8))&
   +2D0*HfxZpE*VS1(15,18)
VS0(30,34)=QCz*VS0(30,19)+WQz*VS1(30,19)&
   +2D0*r1x2E*(VS0(30,9)-ZxZpE*VS1(30,9))&
   +2D0*HfxZpE*VS1(15,19)
VS0(30,35)=QCz*VS0(30,20)+WQz*VS1(30,20)&
   +3D0*r1x2E*(VS0(30,10)-ZxZpE*VS1(30,10))&
   +2D0*HfxZpE*VS1(15,20)
VS0(31,21)=QCx*VS0(31,11)+WQx*VS1(31,11)&
   +3D0*r1x2E*(VS0(31,5)-ZxZpE*VS1(31,5))&
   +HfxZpE*VS1(19,11)
VS0(31,22)=QCx*VS0(31,12)+WQx*VS1(31,12)&
   +2D0*r1x2E*(VS0(31,6)-ZxZpE*VS1(31,6))&
   +HfxZpE*VS1(19,12)
VS0(31,23)=QCx*VS0(31,13)+WQx*VS1(31,13)&
   +r1x2E*(VS0(31,7)-ZxZpE*VS1(31,7))&
   +HfxZpE*VS1(19,13)
VS0(31,24)=QCy*VS0(31,13)+WQy*VS1(31,13)-r1x2E*VR1(31,13)&
   +2D0*r1x2E*(VS0(31,6)-ZxZpE*VS1(31,6))&
   +HfxZpE*VS1(18,13)
VS0(31,25)=QCy*VS0(31,14)+WQy*VS1(31,14)-r1x2E*VR1(31,14)&
   +3D0*r1x2E*(VS0(31,7)-ZxZpE*VS1(31,7))&
   +HfxZpE*VS1(18,14)
VS0(31,26)=QCx*VS0(31,15)+WQx*VS1(31,15)&
   +2D0*r1x2E*(VS0(31,8)-ZxZpE*VS1(31,8))&
   +HfxZpE*VS1(19,15)
VS0(31,27)=QCx*VS0(31,16)+WQx*VS1(31,16)&
   +r1x2E*(VS0(31,9)-ZxZpE*VS1(31,9))&
   +HfxZpE*VS1(19,16)
VS0(31,28)=QCy*VS0(31,16)+WQy*VS1(31,16)-r1x2E*VR1(31,16)&
   +r1x2E*(VS0(31,8)-ZxZpE*VS1(31,8))&
   +HfxZpE*VS1(18,16)
VS0(31,29)=QCy*VS0(31,17)+WQy*VS1(31,17)-r1x2E*VR1(31,17)&
   +2D0*r1x2E*(VS0(31,9)-ZxZpE*VS1(31,9))&
   +HfxZpE*VS1(18,17)
VS0(31,30)=QCx*VS0(31,18)+WQx*VS1(31,18)&
   +r1x2E*(VS0(31,10)-ZxZpE*VS1(31,10))&
   +HfxZpE*VS1(19,18)
VS0(31,31)=QCz*VS0(31,16)+WQz*VS1(31,16)&
   +r1x2E*(VS0(31,6)-ZxZpE*VS1(31,6))&
   +2D0*HfxZpE*VS1(16,16)
VS0(31,32)=QCy*VS0(31,19)+WQy*VS1(31,19)-r1x2E*VR1(31,19)&
   +r1x2E*(VS0(31,10)-ZxZpE*VS1(31,10))&
   +HfxZpE*VS1(18,19)
VS0(31,33)=QCz*VS0(31,18)+WQz*VS1(31,18)&
   +2D0*r1x2E*(VS0(31,8)-ZxZpE*VS1(31,8))&
   +2D0*HfxZpE*VS1(16,18)
VS0(31,34)=QCz*VS0(31,19)+WQz*VS1(31,19)&
   +2D0*r1x2E*(VS0(31,9)-ZxZpE*VS1(31,9))&
   +2D0*HfxZpE*VS1(16,19)
VS0(31,35)=QCz*VS0(31,20)+WQz*VS1(31,20)&
   +3D0*r1x2E*(VS0(31,10)-ZxZpE*VS1(31,10))&
   +2D0*HfxZpE*VS1(16,20)
VS0(32,21)=QCx*VS0(32,11)+WQx*VS1(32,11)&
   +3D0*r1x2E*(VS0(32,5)-ZxZpE*VS1(32,5))
VS0(32,22)=QCx*VS0(32,12)+WQx*VS1(32,12)&
   +2D0*r1x2E*(VS0(32,6)-ZxZpE*VS1(32,6))
VS0(32,23)=QCx*VS0(32,13)+WQx*VS1(32,13)&
   +r1x2E*(VS0(32,7)-ZxZpE*VS1(32,7))
VS0(32,24)=QCy*VS0(32,13)+WQy*VS1(32,13)-r1x2E*VR1(32,13)&
   +2D0*r1x2E*(VS0(32,6)-ZxZpE*VS1(32,6))&
   +2D0*HfxZpE*VS1(19,13)
VS0(32,25)=QCy*VS0(32,14)+WQy*VS1(32,14)-r1x2E*VR1(32,14)&
   +3D0*r1x2E*(VS0(32,7)-ZxZpE*VS1(32,7))&
   +2D0*HfxZpE*VS1(19,14)
VS0(32,26)=QCx*VS0(32,15)+WQx*VS1(32,15)&
   +2D0*r1x2E*(VS0(32,8)-ZxZpE*VS1(32,8))
VS0(32,27)=QCx*VS0(32,16)+WQx*VS1(32,16)&
   +r1x2E*(VS0(32,9)-ZxZpE*VS1(32,9))
VS0(32,28)=QCy*VS0(32,16)+WQy*VS1(32,16)-r1x2E*VR1(32,16)&
   +r1x2E*(VS0(32,8)-ZxZpE*VS1(32,8))&
   +2D0*HfxZpE*VS1(19,16)
VS0(32,29)=QCy*VS0(32,17)+WQy*VS1(32,17)-r1x2E*VR1(32,17)&
   +2D0*r1x2E*(VS0(32,9)-ZxZpE*VS1(32,9))&
   +2D0*HfxZpE*VS1(19,17)
VS0(32,30)=QCx*VS0(32,18)+WQx*VS1(32,18)&
   +r1x2E*(VS0(32,10)-ZxZpE*VS1(32,10))
VS0(32,31)=QCz*VS0(32,16)+WQz*VS1(32,16)&
   +r1x2E*(VS0(32,6)-ZxZpE*VS1(32,6))&
   +2D0*HfxZpE*VS1(17,16)
VS0(32,32)=QCy*VS0(32,19)+WQy*VS1(32,19)-r1x2E*VR1(32,19)&
   +r1x2E*(VS0(32,10)-ZxZpE*VS1(32,10))&
   +2D0*HfxZpE*VS1(19,19)
VS0(32,33)=QCz*VS0(32,18)+WQz*VS1(32,18)&
   +2D0*r1x2E*(VS0(32,8)-ZxZpE*VS1(32,8))&
   +2D0*HfxZpE*VS1(17,18)
VS0(32,34)=QCz*VS0(32,19)+WQz*VS1(32,19)&
   +2D0*r1x2E*(VS0(32,9)-ZxZpE*VS1(32,9))&
   +2D0*HfxZpE*VS1(17,19)
VS0(32,35)=QCz*VS0(32,20)+WQz*VS1(32,20)&
   +3D0*r1x2E*(VS0(32,10)-ZxZpE*VS1(32,10))&
   +2D0*HfxZpE*VS1(17,20)
VS0(33,21)=QCx*VS0(33,11)+WQx*VS1(33,11)&
   +3D0*r1x2E*(VS0(33,5)-ZxZpE*VS1(33,5))&
   +HfxZpE*VS1(20,11)
VS0(33,22)=QCx*VS0(33,12)+WQx*VS1(33,12)&
   +2D0*r1x2E*(VS0(33,6)-ZxZpE*VS1(33,6))&
   +HfxZpE*VS1(20,12)
VS0(33,23)=QCx*VS0(33,13)+WQx*VS1(33,13)&
   +r1x2E*(VS0(33,7)-ZxZpE*VS1(33,7))&
   +HfxZpE*VS1(20,13)
VS0(33,24)=QCy*VS0(33,13)+WQy*VS1(33,13)-r1x2E*VR1(33,13)&
   +2D0*r1x2E*(VS0(33,6)-ZxZpE*VS1(33,6))
VS0(33,25)=QCy*VS0(33,14)+WQy*VS1(33,14)-r1x2E*VR1(33,14)&
   +3D0*r1x2E*(VS0(33,7)-ZxZpE*VS1(33,7))
VS0(33,26)=QCx*VS0(33,15)+WQx*VS1(33,15)&
   +2D0*r1x2E*(VS0(33,8)-ZxZpE*VS1(33,8))&
   +HfxZpE*VS1(20,15)
VS0(33,27)=QCx*VS0(33,16)+WQx*VS1(33,16)&
   +r1x2E*(VS0(33,9)-ZxZpE*VS1(33,9))&
   +HfxZpE*VS1(20,16)
VS0(33,28)=QCy*VS0(33,16)+WQy*VS1(33,16)-r1x2E*VR1(33,16)&
   +r1x2E*(VS0(33,8)-ZxZpE*VS1(33,8))
VS0(33,29)=QCy*VS0(33,17)+WQy*VS1(33,17)-r1x2E*VR1(33,17)&
   +2D0*r1x2E*(VS0(33,9)-ZxZpE*VS1(33,9))
VS0(33,30)=QCx*VS0(33,18)+WQx*VS1(33,18)&
   +r1x2E*(VS0(33,10)-ZxZpE*VS1(33,10))&
   +HfxZpE*VS1(20,18)
VS0(33,31)=QCz*VS0(33,16)+WQz*VS1(33,16)&
   +r1x2E*(VS0(33,6)-ZxZpE*VS1(33,6))&
   +3D0*HfxZpE*VS1(18,16)
VS0(33,32)=QCy*VS0(33,19)+WQy*VS1(33,19)-r1x2E*VR1(33,19)&
   +r1x2E*(VS0(33,10)-ZxZpE*VS1(33,10))
VS0(33,33)=QCz*VS0(33,18)+WQz*VS1(33,18)&
   +2D0*r1x2E*(VS0(33,8)-ZxZpE*VS1(33,8))&
   +3D0*HfxZpE*VS1(18,18)
VS0(33,34)=QCz*VS0(33,19)+WQz*VS1(33,19)&
   +2D0*r1x2E*(VS0(33,9)-ZxZpE*VS1(33,9))&
   +3D0*HfxZpE*VS1(18,19)
VS0(33,35)=QCz*VS0(33,20)+WQz*VS1(33,20)&
   +3D0*r1x2E*(VS0(33,10)-ZxZpE*VS1(33,10))&
   +3D0*HfxZpE*VS1(18,20)
VS0(34,21)=QCx*VS0(34,11)+WQx*VS1(34,11)&
   +3D0*r1x2E*(VS0(34,5)-ZxZpE*VS1(34,5))
VS0(34,22)=QCx*VS0(34,12)+WQx*VS1(34,12)&
   +2D0*r1x2E*(VS0(34,6)-ZxZpE*VS1(34,6))
VS0(34,23)=QCx*VS0(34,13)+WQx*VS1(34,13)&
   +r1x2E*(VS0(34,7)-ZxZpE*VS1(34,7))
VS0(34,24)=QCy*VS0(34,13)+WQy*VS1(34,13)-r1x2E*VR1(34,13)&
   +2D0*r1x2E*(VS0(34,6)-ZxZpE*VS1(34,6))&
   +HfxZpE*VS1(20,13)
VS0(34,25)=QCy*VS0(34,14)+WQy*VS1(34,14)-r1x2E*VR1(34,14)&
   +3D0*r1x2E*(VS0(34,7)-ZxZpE*VS1(34,7))&
   +HfxZpE*VS1(20,14)
VS0(34,26)=QCx*VS0(34,15)+WQx*VS1(34,15)&
   +2D0*r1x2E*(VS0(34,8)-ZxZpE*VS1(34,8))
VS0(34,27)=QCx*VS0(34,16)+WQx*VS1(34,16)&
   +r1x2E*(VS0(34,9)-ZxZpE*VS1(34,9))
VS0(34,28)=QCy*VS0(34,16)+WQy*VS1(34,16)-r1x2E*VR1(34,16)&
   +r1x2E*(VS0(34,8)-ZxZpE*VS1(34,8))&
   +HfxZpE*VS1(20,16)
VS0(34,29)=QCy*VS0(34,17)+WQy*VS1(34,17)-r1x2E*VR1(34,17)&
   +2D0*r1x2E*(VS0(34,9)-ZxZpE*VS1(34,9))&
   +HfxZpE*VS1(20,17)
VS0(34,30)=QCx*VS0(34,18)+WQx*VS1(34,18)&
   +r1x2E*(VS0(34,10)-ZxZpE*VS1(34,10))
VS0(34,31)=QCz*VS0(34,16)+WQz*VS1(34,16)&
   +r1x2E*(VS0(34,6)-ZxZpE*VS1(34,6))&
   +3D0*HfxZpE*VS1(19,16)
VS0(34,32)=QCy*VS0(34,19)+WQy*VS1(34,19)-r1x2E*VR1(34,19)&
   +r1x2E*(VS0(34,10)-ZxZpE*VS1(34,10))&
   +HfxZpE*VS1(20,19)
VS0(34,33)=QCz*VS0(34,18)+WQz*VS1(34,18)&
   +2D0*r1x2E*(VS0(34,8)-ZxZpE*VS1(34,8))&
   +3D0*HfxZpE*VS1(19,18)
VS0(34,34)=QCz*VS0(34,19)+WQz*VS1(34,19)&
   +2D0*r1x2E*(VS0(34,9)-ZxZpE*VS1(34,9))&
   +3D0*HfxZpE*VS1(19,19)
VS0(34,35)=QCz*VS0(34,20)+WQz*VS1(34,20)&
   +3D0*r1x2E*(VS0(34,10)-ZxZpE*VS1(34,10))&
   +3D0*HfxZpE*VS1(19,20)
VS0(35,21)=QCx*VS0(35,11)+WQx*VS1(35,11)&
   +3D0*r1x2E*(VS0(35,5)-ZxZpE*VS1(35,5))
VS0(35,22)=QCx*VS0(35,12)+WQx*VS1(35,12)&
   +2D0*r1x2E*(VS0(35,6)-ZxZpE*VS1(35,6))
VS0(35,23)=QCx*VS0(35,13)+WQx*VS1(35,13)&
   +r1x2E*(VS0(35,7)-ZxZpE*VS1(35,7))
VS0(35,24)=QCy*VS0(35,13)+WQy*VS1(35,13)-r1x2E*VR1(35,13)&
   +2D0*r1x2E*(VS0(35,6)-ZxZpE*VS1(35,6))
VS0(35,25)=QCy*VS0(35,14)+WQy*VS1(35,14)-r1x2E*VR1(35,14)&
   +3D0*r1x2E*(VS0(35,7)-ZxZpE*VS1(35,7))
VS0(35,26)=QCx*VS0(35,15)+WQx*VS1(35,15)&
   +2D0*r1x2E*(VS0(35,8)-ZxZpE*VS1(35,8))
VS0(35,27)=QCx*VS0(35,16)+WQx*VS1(35,16)&
   +r1x2E*(VS0(35,9)-ZxZpE*VS1(35,9))
VS0(35,28)=QCy*VS0(35,16)+WQy*VS1(35,16)-r1x2E*VR1(35,16)&
   +r1x2E*(VS0(35,8)-ZxZpE*VS1(35,8))
VS0(35,29)=QCy*VS0(35,17)+WQy*VS1(35,17)-r1x2E*VR1(35,17)&
   +2D0*r1x2E*(VS0(35,9)-ZxZpE*VS1(35,9))
VS0(35,30)=QCx*VS0(35,18)+WQx*VS1(35,18)&
   +r1x2E*(VS0(35,10)-ZxZpE*VS1(35,10))
VS0(35,31)=QCz*VS0(35,16)+WQz*VS1(35,16)&
   +r1x2E*(VS0(35,6)-ZxZpE*VS1(35,6))&
   +4D0*HfxZpE*VS1(20,16)
VS0(35,32)=QCy*VS0(35,19)+WQy*VS1(35,19)-r1x2E*VR1(35,19)&
   +r1x2E*(VS0(35,10)-ZxZpE*VS1(35,10))
VS0(35,33)=QCz*VS0(35,18)+WQz*VS1(35,18)&
   +2D0*r1x2E*(VS0(35,8)-ZxZpE*VS1(35,8))&
   +4D0*HfxZpE*VS1(20,18)
VS0(35,34)=QCz*VS0(35,19)+WQz*VS1(35,19)&
   +2D0*r1x2E*(VS0(35,9)-ZxZpE*VS1(35,9))&
   +4D0*HfxZpE*VS1(20,19)
VS0(35,35)=QCz*VS0(35,20)+WQz*VS1(35,20)&
   +3D0*r1x2E*(VS0(35,10)-ZxZpE*VS1(35,10))&
   +4D0*HfxZpE*VS1(20,20)
CASE(3)
VS0(21,21)=QCx*VS0(21,11)+WQx*VS1(21,11)&
   +3D0*r1x2E*(VS0(21,5)-ZxZpE*VS1(21,5))&
   +4D0*HfxZpE*VS1(11,11)
VS0(21,22)=QCx*VS0(21,12)+WQx*VS1(21,12)&
   +2D0*r1x2E*(VS0(21,6)-ZxZpE*VS1(21,6))&
   +4D0*HfxZpE*VS1(11,12)
VS0(21,23)=QCx*VS0(21,13)+WQx*VS1(21,13)&
   +r1x2E*(VS0(21,7)-ZxZpE*VS1(21,7))&
   +4D0*HfxZpE*VS1(11,13)
VS0(21,24)=QCy*VS0(21,13)+WQy*VS1(21,13)&
   +2D0*r1x2E*(VS0(21,6)-ZxZpE*VS1(21,6))
VS0(21,25)=QCy*VS0(21,14)+WQy*VS1(21,14)&
   +3D0*r1x2E*(VS0(21,7)-ZxZpE*VS1(21,7))
VS0(21,26)=QCx*VS0(21,15)+WQx*VS1(21,15)&
   +2D0*r1x2E*(VS0(21,8)-ZxZpE*VS1(21,8))&
   +4D0*HfxZpE*VS1(11,15)
VS0(21,27)=QCx*VS0(21,16)+WQx*VS1(21,16)&
   +r1x2E*(VS0(21,9)-ZxZpE*VS1(21,9))&
   +4D0*HfxZpE*VS1(11,16)
VS0(21,28)=QCy*VS0(21,16)+WQy*VS1(21,16)&
   +r1x2E*(VS0(21,8)-ZxZpE*VS1(21,8))
VS0(21,29)=QCy*VS0(21,17)+WQy*VS1(21,17)&
   +2D0*r1x2E*(VS0(21,9)-ZxZpE*VS1(21,9))
VS0(21,30)=QCx*VS0(21,18)+WQx*VS1(21,18)&
   +r1x2E*(VS0(21,10)-ZxZpE*VS1(21,10))&
   +4D0*HfxZpE*VS1(11,18)
VS0(21,31)=QCz*VS0(21,16)+WQz*VS1(21,16)-r1x2E*VR1(21,16)&
   +r1x2E*(VS0(21,6)-ZxZpE*VS1(21,6))
VS0(21,32)=QCy*VS0(21,19)+WQy*VS1(21,19)&
   +r1x2E*(VS0(21,10)-ZxZpE*VS1(21,10))
VS0(21,33)=QCz*VS0(21,18)+WQz*VS1(21,18)-r1x2E*VR1(21,18)&
   +2D0*r1x2E*(VS0(21,8)-ZxZpE*VS1(21,8))
VS0(21,34)=QCz*VS0(21,19)+WQz*VS1(21,19)-r1x2E*VR1(21,19)&
   +2D0*r1x2E*(VS0(21,9)-ZxZpE*VS1(21,9))
VS0(21,35)=QCz*VS0(21,20)+WQz*VS1(21,20)-r1x2E*VR1(21,20)&
   +3D0*r1x2E*(VS0(21,10)-ZxZpE*VS1(21,10))
VS0(22,21)=QCx*VS0(22,11)+WQx*VS1(22,11)&
   +3D0*r1x2E*(VS0(22,5)-ZxZpE*VS1(22,5))&
   +3D0*HfxZpE*VS1(12,11)
VS0(22,22)=QCx*VS0(22,12)+WQx*VS1(22,12)&
   +2D0*r1x2E*(VS0(22,6)-ZxZpE*VS1(22,6))&
   +3D0*HfxZpE*VS1(12,12)
VS0(22,23)=QCx*VS0(22,13)+WQx*VS1(22,13)&
   +r1x2E*(VS0(22,7)-ZxZpE*VS1(22,7))&
   +3D0*HfxZpE*VS1(12,13)
VS0(22,24)=QCy*VS0(22,13)+WQy*VS1(22,13)&
   +2D0*r1x2E*(VS0(22,6)-ZxZpE*VS1(22,6))&
   +HfxZpE*VS1(11,13)
VS0(22,25)=QCy*VS0(22,14)+WQy*VS1(22,14)&
   +3D0*r1x2E*(VS0(22,7)-ZxZpE*VS1(22,7))&
   +HfxZpE*VS1(11,14)
VS0(22,26)=QCx*VS0(22,15)+WQx*VS1(22,15)&
   +2D0*r1x2E*(VS0(22,8)-ZxZpE*VS1(22,8))&
   +3D0*HfxZpE*VS1(12,15)
VS0(22,27)=QCx*VS0(22,16)+WQx*VS1(22,16)&
   +r1x2E*(VS0(22,9)-ZxZpE*VS1(22,9))&
   +3D0*HfxZpE*VS1(12,16)
VS0(22,28)=QCy*VS0(22,16)+WQy*VS1(22,16)&
   +r1x2E*(VS0(22,8)-ZxZpE*VS1(22,8))&
   +HfxZpE*VS1(11,16)
VS0(22,29)=QCy*VS0(22,17)+WQy*VS1(22,17)&
   +2D0*r1x2E*(VS0(22,9)-ZxZpE*VS1(22,9))&
   +HfxZpE*VS1(11,17)
VS0(22,30)=QCx*VS0(22,18)+WQx*VS1(22,18)&
   +r1x2E*(VS0(22,10)-ZxZpE*VS1(22,10))&
   +3D0*HfxZpE*VS1(12,18)
VS0(22,31)=QCz*VS0(22,16)+WQz*VS1(22,16)-r1x2E*VR1(22,16)&
   +r1x2E*(VS0(22,6)-ZxZpE*VS1(22,6))
VS0(22,32)=QCy*VS0(22,19)+WQy*VS1(22,19)&
   +r1x2E*(VS0(22,10)-ZxZpE*VS1(22,10))&
   +HfxZpE*VS1(11,19)
VS0(22,33)=QCz*VS0(22,18)+WQz*VS1(22,18)-r1x2E*VR1(22,18)&
   +2D0*r1x2E*(VS0(22,8)-ZxZpE*VS1(22,8))
VS0(22,34)=QCz*VS0(22,19)+WQz*VS1(22,19)-r1x2E*VR1(22,19)&
   +2D0*r1x2E*(VS0(22,9)-ZxZpE*VS1(22,9))
VS0(22,35)=QCz*VS0(22,20)+WQz*VS1(22,20)-r1x2E*VR1(22,20)&
   +3D0*r1x2E*(VS0(22,10)-ZxZpE*VS1(22,10))
VS0(23,21)=QCx*VS0(23,11)+WQx*VS1(23,11)&
   +3D0*r1x2E*(VS0(23,5)-ZxZpE*VS1(23,5))&
   +2D0*HfxZpE*VS1(13,11)
VS0(23,22)=QCx*VS0(23,12)+WQx*VS1(23,12)&
   +2D0*r1x2E*(VS0(23,6)-ZxZpE*VS1(23,6))&
   +2D0*HfxZpE*VS1(13,12)
VS0(23,23)=QCx*VS0(23,13)+WQx*VS1(23,13)&
   +r1x2E*(VS0(23,7)-ZxZpE*VS1(23,7))&
   +2D0*HfxZpE*VS1(13,13)
VS0(23,24)=QCy*VS0(23,13)+WQy*VS1(23,13)&
   +2D0*r1x2E*(VS0(23,6)-ZxZpE*VS1(23,6))&
   +2D0*HfxZpE*VS1(12,13)
VS0(23,25)=QCy*VS0(23,14)+WQy*VS1(23,14)&
   +3D0*r1x2E*(VS0(23,7)-ZxZpE*VS1(23,7))&
   +2D0*HfxZpE*VS1(12,14)
VS0(23,26)=QCx*VS0(23,15)+WQx*VS1(23,15)&
   +2D0*r1x2E*(VS0(23,8)-ZxZpE*VS1(23,8))&
   +2D0*HfxZpE*VS1(13,15)
VS0(23,27)=QCx*VS0(23,16)+WQx*VS1(23,16)&
   +r1x2E*(VS0(23,9)-ZxZpE*VS1(23,9))&
   +2D0*HfxZpE*VS1(13,16)
VS0(23,28)=QCy*VS0(23,16)+WQy*VS1(23,16)&
   +r1x2E*(VS0(23,8)-ZxZpE*VS1(23,8))&
   +2D0*HfxZpE*VS1(12,16)
VS0(23,29)=QCy*VS0(23,17)+WQy*VS1(23,17)&
   +2D0*r1x2E*(VS0(23,9)-ZxZpE*VS1(23,9))&
   +2D0*HfxZpE*VS1(12,17)
VS0(23,30)=QCx*VS0(23,18)+WQx*VS1(23,18)&
   +r1x2E*(VS0(23,10)-ZxZpE*VS1(23,10))&
   +2D0*HfxZpE*VS1(13,18)
VS0(23,31)=QCz*VS0(23,16)+WQz*VS1(23,16)-r1x2E*VR1(23,16)&
   +r1x2E*(VS0(23,6)-ZxZpE*VS1(23,6))
VS0(23,32)=QCy*VS0(23,19)+WQy*VS1(23,19)&
   +r1x2E*(VS0(23,10)-ZxZpE*VS1(23,10))&
   +2D0*HfxZpE*VS1(12,19)
VS0(23,33)=QCz*VS0(23,18)+WQz*VS1(23,18)-r1x2E*VR1(23,18)&
   +2D0*r1x2E*(VS0(23,8)-ZxZpE*VS1(23,8))
VS0(23,34)=QCz*VS0(23,19)+WQz*VS1(23,19)-r1x2E*VR1(23,19)&
   +2D0*r1x2E*(VS0(23,9)-ZxZpE*VS1(23,9))
VS0(23,35)=QCz*VS0(23,20)+WQz*VS1(23,20)-r1x2E*VR1(23,20)&
   +3D0*r1x2E*(VS0(23,10)-ZxZpE*VS1(23,10))
VS0(24,21)=QCx*VS0(24,11)+WQx*VS1(24,11)&
   +3D0*r1x2E*(VS0(24,5)-ZxZpE*VS1(24,5))&
   +HfxZpE*VS1(14,11)
VS0(24,22)=QCx*VS0(24,12)+WQx*VS1(24,12)&
   +2D0*r1x2E*(VS0(24,6)-ZxZpE*VS1(24,6))&
   +HfxZpE*VS1(14,12)
VS0(24,23)=QCx*VS0(24,13)+WQx*VS1(24,13)&
   +r1x2E*(VS0(24,7)-ZxZpE*VS1(24,7))&
   +HfxZpE*VS1(14,13)
VS0(24,24)=QCy*VS0(24,13)+WQy*VS1(24,13)&
   +2D0*r1x2E*(VS0(24,6)-ZxZpE*VS1(24,6))&
   +3D0*HfxZpE*VS1(13,13)
VS0(24,25)=QCy*VS0(24,14)+WQy*VS1(24,14)&
   +3D0*r1x2E*(VS0(24,7)-ZxZpE*VS1(24,7))&
   +3D0*HfxZpE*VS1(13,14)
VS0(24,26)=QCx*VS0(24,15)+WQx*VS1(24,15)&
   +2D0*r1x2E*(VS0(24,8)-ZxZpE*VS1(24,8))&
   +HfxZpE*VS1(14,15)
VS0(24,27)=QCx*VS0(24,16)+WQx*VS1(24,16)&
   +r1x2E*(VS0(24,9)-ZxZpE*VS1(24,9))&
   +HfxZpE*VS1(14,16)
VS0(24,28)=QCy*VS0(24,16)+WQy*VS1(24,16)&
   +r1x2E*(VS0(24,8)-ZxZpE*VS1(24,8))&
   +3D0*HfxZpE*VS1(13,16)
VS0(24,29)=QCy*VS0(24,17)+WQy*VS1(24,17)&
   +2D0*r1x2E*(VS0(24,9)-ZxZpE*VS1(24,9))&
   +3D0*HfxZpE*VS1(13,17)
VS0(24,30)=QCx*VS0(24,18)+WQx*VS1(24,18)&
   +r1x2E*(VS0(24,10)-ZxZpE*VS1(24,10))&
   +HfxZpE*VS1(14,18)
VS0(24,31)=QCz*VS0(24,16)+WQz*VS1(24,16)-r1x2E*VR1(24,16)&
   +r1x2E*(VS0(24,6)-ZxZpE*VS1(24,6))
VS0(24,32)=QCy*VS0(24,19)+WQy*VS1(24,19)&
   +r1x2E*(VS0(24,10)-ZxZpE*VS1(24,10))&
   +3D0*HfxZpE*VS1(13,19)
VS0(24,33)=QCz*VS0(24,18)+WQz*VS1(24,18)-r1x2E*VR1(24,18)&
   +2D0*r1x2E*(VS0(24,8)-ZxZpE*VS1(24,8))
VS0(24,34)=QCz*VS0(24,19)+WQz*VS1(24,19)-r1x2E*VR1(24,19)&
   +2D0*r1x2E*(VS0(24,9)-ZxZpE*VS1(24,9))
VS0(24,35)=QCz*VS0(24,20)+WQz*VS1(24,20)-r1x2E*VR1(24,20)&
   +3D0*r1x2E*(VS0(24,10)-ZxZpE*VS1(24,10))
VS0(25,21)=QCx*VS0(25,11)+WQx*VS1(25,11)&
   +3D0*r1x2E*(VS0(25,5)-ZxZpE*VS1(25,5))
VS0(25,22)=QCx*VS0(25,12)+WQx*VS1(25,12)&
   +2D0*r1x2E*(VS0(25,6)-ZxZpE*VS1(25,6))
VS0(25,23)=QCx*VS0(25,13)+WQx*VS1(25,13)&
   +r1x2E*(VS0(25,7)-ZxZpE*VS1(25,7))
VS0(25,24)=QCy*VS0(25,13)+WQy*VS1(25,13)&
   +2D0*r1x2E*(VS0(25,6)-ZxZpE*VS1(25,6))&
   +4D0*HfxZpE*VS1(14,13)
VS0(25,25)=QCy*VS0(25,14)+WQy*VS1(25,14)&
   +3D0*r1x2E*(VS0(25,7)-ZxZpE*VS1(25,7))&
   +4D0*HfxZpE*VS1(14,14)
VS0(25,26)=QCx*VS0(25,15)+WQx*VS1(25,15)&
   +2D0*r1x2E*(VS0(25,8)-ZxZpE*VS1(25,8))
VS0(25,27)=QCx*VS0(25,16)+WQx*VS1(25,16)&
   +r1x2E*(VS0(25,9)-ZxZpE*VS1(25,9))
VS0(25,28)=QCy*VS0(25,16)+WQy*VS1(25,16)&
   +r1x2E*(VS0(25,8)-ZxZpE*VS1(25,8))&
   +4D0*HfxZpE*VS1(14,16)
VS0(25,29)=QCy*VS0(25,17)+WQy*VS1(25,17)&
   +2D0*r1x2E*(VS0(25,9)-ZxZpE*VS1(25,9))&
   +4D0*HfxZpE*VS1(14,17)
VS0(25,30)=QCx*VS0(25,18)+WQx*VS1(25,18)&
   +r1x2E*(VS0(25,10)-ZxZpE*VS1(25,10))
VS0(25,31)=QCz*VS0(25,16)+WQz*VS1(25,16)-r1x2E*VR1(25,16)&
   +r1x2E*(VS0(25,6)-ZxZpE*VS1(25,6))
VS0(25,32)=QCy*VS0(25,19)+WQy*VS1(25,19)&
   +r1x2E*(VS0(25,10)-ZxZpE*VS1(25,10))&
   +4D0*HfxZpE*VS1(14,19)
VS0(25,33)=QCz*VS0(25,18)+WQz*VS1(25,18)-r1x2E*VR1(25,18)&
   +2D0*r1x2E*(VS0(25,8)-ZxZpE*VS1(25,8))
VS0(25,34)=QCz*VS0(25,19)+WQz*VS1(25,19)-r1x2E*VR1(25,19)&
   +2D0*r1x2E*(VS0(25,9)-ZxZpE*VS1(25,9))
VS0(25,35)=QCz*VS0(25,20)+WQz*VS1(25,20)-r1x2E*VR1(25,20)&
   +3D0*r1x2E*(VS0(25,10)-ZxZpE*VS1(25,10))
VS0(26,21)=QCx*VS0(26,11)+WQx*VS1(26,11)&
   +3D0*r1x2E*(VS0(26,5)-ZxZpE*VS1(26,5))&
   +3D0*HfxZpE*VS1(15,11)
VS0(26,22)=QCx*VS0(26,12)+WQx*VS1(26,12)&
   +2D0*r1x2E*(VS0(26,6)-ZxZpE*VS1(26,6))&
   +3D0*HfxZpE*VS1(15,12)
VS0(26,23)=QCx*VS0(26,13)+WQx*VS1(26,13)&
   +r1x2E*(VS0(26,7)-ZxZpE*VS1(26,7))&
   +3D0*HfxZpE*VS1(15,13)
VS0(26,24)=QCy*VS0(26,13)+WQy*VS1(26,13)&
   +2D0*r1x2E*(VS0(26,6)-ZxZpE*VS1(26,6))
VS0(26,25)=QCy*VS0(26,14)+WQy*VS1(26,14)&
   +3D0*r1x2E*(VS0(26,7)-ZxZpE*VS1(26,7))
VS0(26,26)=QCx*VS0(26,15)+WQx*VS1(26,15)&
   +2D0*r1x2E*(VS0(26,8)-ZxZpE*VS1(26,8))&
   +3D0*HfxZpE*VS1(15,15)
VS0(26,27)=QCx*VS0(26,16)+WQx*VS1(26,16)&
   +r1x2E*(VS0(26,9)-ZxZpE*VS1(26,9))&
   +3D0*HfxZpE*VS1(15,16)
VS0(26,28)=QCy*VS0(26,16)+WQy*VS1(26,16)&
   +r1x2E*(VS0(26,8)-ZxZpE*VS1(26,8))
VS0(26,29)=QCy*VS0(26,17)+WQy*VS1(26,17)&
   +2D0*r1x2E*(VS0(26,9)-ZxZpE*VS1(26,9))
VS0(26,30)=QCx*VS0(26,18)+WQx*VS1(26,18)&
   +r1x2E*(VS0(26,10)-ZxZpE*VS1(26,10))&
   +3D0*HfxZpE*VS1(15,18)
VS0(26,31)=QCz*VS0(26,16)+WQz*VS1(26,16)-r1x2E*VR1(26,16)&
   +r1x2E*(VS0(26,6)-ZxZpE*VS1(26,6))&
   +HfxZpE*VS1(11,16)
VS0(26,32)=QCy*VS0(26,19)+WQy*VS1(26,19)&
   +r1x2E*(VS0(26,10)-ZxZpE*VS1(26,10))
VS0(26,33)=QCz*VS0(26,18)+WQz*VS1(26,18)-r1x2E*VR1(26,18)&
   +2D0*r1x2E*(VS0(26,8)-ZxZpE*VS1(26,8))&
   +HfxZpE*VS1(11,18)
VS0(26,34)=QCz*VS0(26,19)+WQz*VS1(26,19)-r1x2E*VR1(26,19)&
   +2D0*r1x2E*(VS0(26,9)-ZxZpE*VS1(26,9))&
   +HfxZpE*VS1(11,19)
VS0(26,35)=QCz*VS0(26,20)+WQz*VS1(26,20)-r1x2E*VR1(26,20)&
   +3D0*r1x2E*(VS0(26,10)-ZxZpE*VS1(26,10))&
   +HfxZpE*VS1(11,20)
VS0(27,21)=QCx*VS0(27,11)+WQx*VS1(27,11)&
   +3D0*r1x2E*(VS0(27,5)-ZxZpE*VS1(27,5))&
   +2D0*HfxZpE*VS1(16,11)
VS0(27,22)=QCx*VS0(27,12)+WQx*VS1(27,12)&
   +2D0*r1x2E*(VS0(27,6)-ZxZpE*VS1(27,6))&
   +2D0*HfxZpE*VS1(16,12)
VS0(27,23)=QCx*VS0(27,13)+WQx*VS1(27,13)&
   +r1x2E*(VS0(27,7)-ZxZpE*VS1(27,7))&
   +2D0*HfxZpE*VS1(16,13)
VS0(27,24)=QCy*VS0(27,13)+WQy*VS1(27,13)&
   +2D0*r1x2E*(VS0(27,6)-ZxZpE*VS1(27,6))&
   +HfxZpE*VS1(15,13)
VS0(27,25)=QCy*VS0(27,14)+WQy*VS1(27,14)&
   +3D0*r1x2E*(VS0(27,7)-ZxZpE*VS1(27,7))&
   +HfxZpE*VS1(15,14)
VS0(27,26)=QCx*VS0(27,15)+WQx*VS1(27,15)&
   +2D0*r1x2E*(VS0(27,8)-ZxZpE*VS1(27,8))&
   +2D0*HfxZpE*VS1(16,15)
VS0(27,27)=QCx*VS0(27,16)+WQx*VS1(27,16)&
   +r1x2E*(VS0(27,9)-ZxZpE*VS1(27,9))&
   +2D0*HfxZpE*VS1(16,16)
VS0(27,28)=QCy*VS0(27,16)+WQy*VS1(27,16)&
   +r1x2E*(VS0(27,8)-ZxZpE*VS1(27,8))&
   +HfxZpE*VS1(15,16)
VS0(27,29)=QCy*VS0(27,17)+WQy*VS1(27,17)&
   +2D0*r1x2E*(VS0(27,9)-ZxZpE*VS1(27,9))&
   +HfxZpE*VS1(15,17)
VS0(27,30)=QCx*VS0(27,18)+WQx*VS1(27,18)&
   +r1x2E*(VS0(27,10)-ZxZpE*VS1(27,10))&
   +2D0*HfxZpE*VS1(16,18)
VS0(27,31)=QCz*VS0(27,16)+WQz*VS1(27,16)-r1x2E*VR1(27,16)&
   +r1x2E*(VS0(27,6)-ZxZpE*VS1(27,6))&
   +HfxZpE*VS1(12,16)
VS0(27,32)=QCy*VS0(27,19)+WQy*VS1(27,19)&
   +r1x2E*(VS0(27,10)-ZxZpE*VS1(27,10))&
   +HfxZpE*VS1(15,19)
VS0(27,33)=QCz*VS0(27,18)+WQz*VS1(27,18)-r1x2E*VR1(27,18)&
   +2D0*r1x2E*(VS0(27,8)-ZxZpE*VS1(27,8))&
   +HfxZpE*VS1(12,18)
VS0(27,34)=QCz*VS0(27,19)+WQz*VS1(27,19)-r1x2E*VR1(27,19)&
   +2D0*r1x2E*(VS0(27,9)-ZxZpE*VS1(27,9))&
   +HfxZpE*VS1(12,19)
VS0(27,35)=QCz*VS0(27,20)+WQz*VS1(27,20)-r1x2E*VR1(27,20)&
   +3D0*r1x2E*(VS0(27,10)-ZxZpE*VS1(27,10))&
   +HfxZpE*VS1(12,20)
VS0(28,21)=QCx*VS0(28,11)+WQx*VS1(28,11)&
   +3D0*r1x2E*(VS0(28,5)-ZxZpE*VS1(28,5))&
   +HfxZpE*VS1(17,11)
VS0(28,22)=QCx*VS0(28,12)+WQx*VS1(28,12)&
   +2D0*r1x2E*(VS0(28,6)-ZxZpE*VS1(28,6))&
   +HfxZpE*VS1(17,12)
VS0(28,23)=QCx*VS0(28,13)+WQx*VS1(28,13)&
   +r1x2E*(VS0(28,7)-ZxZpE*VS1(28,7))&
   +HfxZpE*VS1(17,13)
VS0(28,24)=QCy*VS0(28,13)+WQy*VS1(28,13)&
   +2D0*r1x2E*(VS0(28,6)-ZxZpE*VS1(28,6))&
   +2D0*HfxZpE*VS1(16,13)
VS0(28,25)=QCy*VS0(28,14)+WQy*VS1(28,14)&
   +3D0*r1x2E*(VS0(28,7)-ZxZpE*VS1(28,7))&
   +2D0*HfxZpE*VS1(16,14)
VS0(28,26)=QCx*VS0(28,15)+WQx*VS1(28,15)&
   +2D0*r1x2E*(VS0(28,8)-ZxZpE*VS1(28,8))&
   +HfxZpE*VS1(17,15)
VS0(28,27)=QCx*VS0(28,16)+WQx*VS1(28,16)&
   +r1x2E*(VS0(28,9)-ZxZpE*VS1(28,9))&
   +HfxZpE*VS1(17,16)
VS0(28,28)=QCy*VS0(28,16)+WQy*VS1(28,16)&
   +r1x2E*(VS0(28,8)-ZxZpE*VS1(28,8))&
   +2D0*HfxZpE*VS1(16,16)
VS0(28,29)=QCy*VS0(28,17)+WQy*VS1(28,17)&
   +2D0*r1x2E*(VS0(28,9)-ZxZpE*VS1(28,9))&
   +2D0*HfxZpE*VS1(16,17)
VS0(28,30)=QCx*VS0(28,18)+WQx*VS1(28,18)&
   +r1x2E*(VS0(28,10)-ZxZpE*VS1(28,10))&
   +HfxZpE*VS1(17,18)
VS0(28,31)=QCz*VS0(28,16)+WQz*VS1(28,16)-r1x2E*VR1(28,16)&
   +r1x2E*(VS0(28,6)-ZxZpE*VS1(28,6))&
   +HfxZpE*VS1(13,16)
VS0(28,32)=QCy*VS0(28,19)+WQy*VS1(28,19)&
   +r1x2E*(VS0(28,10)-ZxZpE*VS1(28,10))&
   +2D0*HfxZpE*VS1(16,19)
VS0(28,33)=QCz*VS0(28,18)+WQz*VS1(28,18)-r1x2E*VR1(28,18)&
   +2D0*r1x2E*(VS0(28,8)-ZxZpE*VS1(28,8))&
   +HfxZpE*VS1(13,18)
VS0(28,34)=QCz*VS0(28,19)+WQz*VS1(28,19)-r1x2E*VR1(28,19)&
   +2D0*r1x2E*(VS0(28,9)-ZxZpE*VS1(28,9))&
   +HfxZpE*VS1(13,19)
VS0(28,35)=QCz*VS0(28,20)+WQz*VS1(28,20)-r1x2E*VR1(28,20)&
   +3D0*r1x2E*(VS0(28,10)-ZxZpE*VS1(28,10))&
   +HfxZpE*VS1(13,20)
VS0(29,21)=QCx*VS0(29,11)+WQx*VS1(29,11)&
   +3D0*r1x2E*(VS0(29,5)-ZxZpE*VS1(29,5))
VS0(29,22)=QCx*VS0(29,12)+WQx*VS1(29,12)&
   +2D0*r1x2E*(VS0(29,6)-ZxZpE*VS1(29,6))
VS0(29,23)=QCx*VS0(29,13)+WQx*VS1(29,13)&
   +r1x2E*(VS0(29,7)-ZxZpE*VS1(29,7))
VS0(29,24)=QCy*VS0(29,13)+WQy*VS1(29,13)&
   +2D0*r1x2E*(VS0(29,6)-ZxZpE*VS1(29,6))&
   +3D0*HfxZpE*VS1(17,13)
VS0(29,25)=QCy*VS0(29,14)+WQy*VS1(29,14)&
   +3D0*r1x2E*(VS0(29,7)-ZxZpE*VS1(29,7))&
   +3D0*HfxZpE*VS1(17,14)
VS0(29,26)=QCx*VS0(29,15)+WQx*VS1(29,15)&
   +2D0*r1x2E*(VS0(29,8)-ZxZpE*VS1(29,8))
VS0(29,27)=QCx*VS0(29,16)+WQx*VS1(29,16)&
   +r1x2E*(VS0(29,9)-ZxZpE*VS1(29,9))
VS0(29,28)=QCy*VS0(29,16)+WQy*VS1(29,16)&
   +r1x2E*(VS0(29,8)-ZxZpE*VS1(29,8))&
   +3D0*HfxZpE*VS1(17,16)
VS0(29,29)=QCy*VS0(29,17)+WQy*VS1(29,17)&
   +2D0*r1x2E*(VS0(29,9)-ZxZpE*VS1(29,9))&
   +3D0*HfxZpE*VS1(17,17)
VS0(29,30)=QCx*VS0(29,18)+WQx*VS1(29,18)&
   +r1x2E*(VS0(29,10)-ZxZpE*VS1(29,10))
VS0(29,31)=QCz*VS0(29,16)+WQz*VS1(29,16)-r1x2E*VR1(29,16)&
   +r1x2E*(VS0(29,6)-ZxZpE*VS1(29,6))&
   +HfxZpE*VS1(14,16)
VS0(29,32)=QCy*VS0(29,19)+WQy*VS1(29,19)&
   +r1x2E*(VS0(29,10)-ZxZpE*VS1(29,10))&
   +3D0*HfxZpE*VS1(17,19)
VS0(29,33)=QCz*VS0(29,18)+WQz*VS1(29,18)-r1x2E*VR1(29,18)&
   +2D0*r1x2E*(VS0(29,8)-ZxZpE*VS1(29,8))&
   +HfxZpE*VS1(14,18)
VS0(29,34)=QCz*VS0(29,19)+WQz*VS1(29,19)-r1x2E*VR1(29,19)&
   +2D0*r1x2E*(VS0(29,9)-ZxZpE*VS1(29,9))&
   +HfxZpE*VS1(14,19)
VS0(29,35)=QCz*VS0(29,20)+WQz*VS1(29,20)-r1x2E*VR1(29,20)&
   +3D0*r1x2E*(VS0(29,10)-ZxZpE*VS1(29,10))&
   +HfxZpE*VS1(14,20)
VS0(30,21)=QCx*VS0(30,11)+WQx*VS1(30,11)&
   +3D0*r1x2E*(VS0(30,5)-ZxZpE*VS1(30,5))&
   +2D0*HfxZpE*VS1(18,11)
VS0(30,22)=QCx*VS0(30,12)+WQx*VS1(30,12)&
   +2D0*r1x2E*(VS0(30,6)-ZxZpE*VS1(30,6))&
   +2D0*HfxZpE*VS1(18,12)
VS0(30,23)=QCx*VS0(30,13)+WQx*VS1(30,13)&
   +r1x2E*(VS0(30,7)-ZxZpE*VS1(30,7))&
   +2D0*HfxZpE*VS1(18,13)
VS0(30,24)=QCy*VS0(30,13)+WQy*VS1(30,13)&
   +2D0*r1x2E*(VS0(30,6)-ZxZpE*VS1(30,6))
VS0(30,25)=QCy*VS0(30,14)+WQy*VS1(30,14)&
   +3D0*r1x2E*(VS0(30,7)-ZxZpE*VS1(30,7))
VS0(30,26)=QCx*VS0(30,15)+WQx*VS1(30,15)&
   +2D0*r1x2E*(VS0(30,8)-ZxZpE*VS1(30,8))&
   +2D0*HfxZpE*VS1(18,15)
VS0(30,27)=QCx*VS0(30,16)+WQx*VS1(30,16)&
   +r1x2E*(VS0(30,9)-ZxZpE*VS1(30,9))&
   +2D0*HfxZpE*VS1(18,16)
VS0(30,28)=QCy*VS0(30,16)+WQy*VS1(30,16)&
   +r1x2E*(VS0(30,8)-ZxZpE*VS1(30,8))
VS0(30,29)=QCy*VS0(30,17)+WQy*VS1(30,17)&
   +2D0*r1x2E*(VS0(30,9)-ZxZpE*VS1(30,9))
VS0(30,30)=QCx*VS0(30,18)+WQx*VS1(30,18)&
   +r1x2E*(VS0(30,10)-ZxZpE*VS1(30,10))&
   +2D0*HfxZpE*VS1(18,18)
VS0(30,31)=QCz*VS0(30,16)+WQz*VS1(30,16)-r1x2E*VR1(30,16)&
   +r1x2E*(VS0(30,6)-ZxZpE*VS1(30,6))&
   +2D0*HfxZpE*VS1(15,16)
VS0(30,32)=QCy*VS0(30,19)+WQy*VS1(30,19)&
   +r1x2E*(VS0(30,10)-ZxZpE*VS1(30,10))
VS0(30,33)=QCz*VS0(30,18)+WQz*VS1(30,18)-r1x2E*VR1(30,18)&
   +2D0*r1x2E*(VS0(30,8)-ZxZpE*VS1(30,8))&
   +2D0*HfxZpE*VS1(15,18)
VS0(30,34)=QCz*VS0(30,19)+WQz*VS1(30,19)-r1x2E*VR1(30,19)&
   +2D0*r1x2E*(VS0(30,9)-ZxZpE*VS1(30,9))&
   +2D0*HfxZpE*VS1(15,19)
VS0(30,35)=QCz*VS0(30,20)+WQz*VS1(30,20)-r1x2E*VR1(30,20)&
   +3D0*r1x2E*(VS0(30,10)-ZxZpE*VS1(30,10))&
   +2D0*HfxZpE*VS1(15,20)
VS0(31,21)=QCx*VS0(31,11)+WQx*VS1(31,11)&
   +3D0*r1x2E*(VS0(31,5)-ZxZpE*VS1(31,5))&
   +HfxZpE*VS1(19,11)
VS0(31,22)=QCx*VS0(31,12)+WQx*VS1(31,12)&
   +2D0*r1x2E*(VS0(31,6)-ZxZpE*VS1(31,6))&
   +HfxZpE*VS1(19,12)
VS0(31,23)=QCx*VS0(31,13)+WQx*VS1(31,13)&
   +r1x2E*(VS0(31,7)-ZxZpE*VS1(31,7))&
   +HfxZpE*VS1(19,13)
VS0(31,24)=QCy*VS0(31,13)+WQy*VS1(31,13)&
   +2D0*r1x2E*(VS0(31,6)-ZxZpE*VS1(31,6))&
   +HfxZpE*VS1(18,13)
VS0(31,25)=QCy*VS0(31,14)+WQy*VS1(31,14)&
   +3D0*r1x2E*(VS0(31,7)-ZxZpE*VS1(31,7))&
   +HfxZpE*VS1(18,14)
VS0(31,26)=QCx*VS0(31,15)+WQx*VS1(31,15)&
   +2D0*r1x2E*(VS0(31,8)-ZxZpE*VS1(31,8))&
   +HfxZpE*VS1(19,15)
VS0(31,27)=QCx*VS0(31,16)+WQx*VS1(31,16)&
   +r1x2E*(VS0(31,9)-ZxZpE*VS1(31,9))&
   +HfxZpE*VS1(19,16)
VS0(31,28)=QCy*VS0(31,16)+WQy*VS1(31,16)&
   +r1x2E*(VS0(31,8)-ZxZpE*VS1(31,8))&
   +HfxZpE*VS1(18,16)
VS0(31,29)=QCy*VS0(31,17)+WQy*VS1(31,17)&
   +2D0*r1x2E*(VS0(31,9)-ZxZpE*VS1(31,9))&
   +HfxZpE*VS1(18,17)
VS0(31,30)=QCx*VS0(31,18)+WQx*VS1(31,18)&
   +r1x2E*(VS0(31,10)-ZxZpE*VS1(31,10))&
   +HfxZpE*VS1(19,18)
VS0(31,31)=QCz*VS0(31,16)+WQz*VS1(31,16)-r1x2E*VR1(31,16)&
   +r1x2E*(VS0(31,6)-ZxZpE*VS1(31,6))&
   +2D0*HfxZpE*VS1(16,16)
VS0(31,32)=QCy*VS0(31,19)+WQy*VS1(31,19)&
   +r1x2E*(VS0(31,10)-ZxZpE*VS1(31,10))&
   +HfxZpE*VS1(18,19)
VS0(31,33)=QCz*VS0(31,18)+WQz*VS1(31,18)-r1x2E*VR1(31,18)&
   +2D0*r1x2E*(VS0(31,8)-ZxZpE*VS1(31,8))&
   +2D0*HfxZpE*VS1(16,18)
VS0(31,34)=QCz*VS0(31,19)+WQz*VS1(31,19)-r1x2E*VR1(31,19)&
   +2D0*r1x2E*(VS0(31,9)-ZxZpE*VS1(31,9))&
   +2D0*HfxZpE*VS1(16,19)
VS0(31,35)=QCz*VS0(31,20)+WQz*VS1(31,20)-r1x2E*VR1(31,20)&
   +3D0*r1x2E*(VS0(31,10)-ZxZpE*VS1(31,10))&
   +2D0*HfxZpE*VS1(16,20)
VS0(32,21)=QCx*VS0(32,11)+WQx*VS1(32,11)&
   +3D0*r1x2E*(VS0(32,5)-ZxZpE*VS1(32,5))
VS0(32,22)=QCx*VS0(32,12)+WQx*VS1(32,12)&
   +2D0*r1x2E*(VS0(32,6)-ZxZpE*VS1(32,6))
VS0(32,23)=QCx*VS0(32,13)+WQx*VS1(32,13)&
   +r1x2E*(VS0(32,7)-ZxZpE*VS1(32,7))
VS0(32,24)=QCy*VS0(32,13)+WQy*VS1(32,13)&
   +2D0*r1x2E*(VS0(32,6)-ZxZpE*VS1(32,6))&
   +2D0*HfxZpE*VS1(19,13)
VS0(32,25)=QCy*VS0(32,14)+WQy*VS1(32,14)&
   +3D0*r1x2E*(VS0(32,7)-ZxZpE*VS1(32,7))&
   +2D0*HfxZpE*VS1(19,14)
VS0(32,26)=QCx*VS0(32,15)+WQx*VS1(32,15)&
   +2D0*r1x2E*(VS0(32,8)-ZxZpE*VS1(32,8))
VS0(32,27)=QCx*VS0(32,16)+WQx*VS1(32,16)&
   +r1x2E*(VS0(32,9)-ZxZpE*VS1(32,9))
VS0(32,28)=QCy*VS0(32,16)+WQy*VS1(32,16)&
   +r1x2E*(VS0(32,8)-ZxZpE*VS1(32,8))&
   +2D0*HfxZpE*VS1(19,16)
VS0(32,29)=QCy*VS0(32,17)+WQy*VS1(32,17)&
   +2D0*r1x2E*(VS0(32,9)-ZxZpE*VS1(32,9))&
   +2D0*HfxZpE*VS1(19,17)
VS0(32,30)=QCx*VS0(32,18)+WQx*VS1(32,18)&
   +r1x2E*(VS0(32,10)-ZxZpE*VS1(32,10))
VS0(32,31)=QCz*VS0(32,16)+WQz*VS1(32,16)-r1x2E*VR1(32,16)&
   +r1x2E*(VS0(32,6)-ZxZpE*VS1(32,6))&
   +2D0*HfxZpE*VS1(17,16)
VS0(32,32)=QCy*VS0(32,19)+WQy*VS1(32,19)&
   +r1x2E*(VS0(32,10)-ZxZpE*VS1(32,10))&
   +2D0*HfxZpE*VS1(19,19)
VS0(32,33)=QCz*VS0(32,18)+WQz*VS1(32,18)-r1x2E*VR1(32,18)&
   +2D0*r1x2E*(VS0(32,8)-ZxZpE*VS1(32,8))&
   +2D0*HfxZpE*VS1(17,18)
VS0(32,34)=QCz*VS0(32,19)+WQz*VS1(32,19)-r1x2E*VR1(32,19)&
   +2D0*r1x2E*(VS0(32,9)-ZxZpE*VS1(32,9))&
   +2D0*HfxZpE*VS1(17,19)
VS0(32,35)=QCz*VS0(32,20)+WQz*VS1(32,20)-r1x2E*VR1(32,20)&
   +3D0*r1x2E*(VS0(32,10)-ZxZpE*VS1(32,10))&
   +2D0*HfxZpE*VS1(17,20)
VS0(33,21)=QCx*VS0(33,11)+WQx*VS1(33,11)&
   +3D0*r1x2E*(VS0(33,5)-ZxZpE*VS1(33,5))&
   +HfxZpE*VS1(20,11)
VS0(33,22)=QCx*VS0(33,12)+WQx*VS1(33,12)&
   +2D0*r1x2E*(VS0(33,6)-ZxZpE*VS1(33,6))&
   +HfxZpE*VS1(20,12)
VS0(33,23)=QCx*VS0(33,13)+WQx*VS1(33,13)&
   +r1x2E*(VS0(33,7)-ZxZpE*VS1(33,7))&
   +HfxZpE*VS1(20,13)
VS0(33,24)=QCy*VS0(33,13)+WQy*VS1(33,13)&
   +2D0*r1x2E*(VS0(33,6)-ZxZpE*VS1(33,6))
VS0(33,25)=QCy*VS0(33,14)+WQy*VS1(33,14)&
   +3D0*r1x2E*(VS0(33,7)-ZxZpE*VS1(33,7))
VS0(33,26)=QCx*VS0(33,15)+WQx*VS1(33,15)&
   +2D0*r1x2E*(VS0(33,8)-ZxZpE*VS1(33,8))&
   +HfxZpE*VS1(20,15)
VS0(33,27)=QCx*VS0(33,16)+WQx*VS1(33,16)&
   +r1x2E*(VS0(33,9)-ZxZpE*VS1(33,9))&
   +HfxZpE*VS1(20,16)
VS0(33,28)=QCy*VS0(33,16)+WQy*VS1(33,16)&
   +r1x2E*(VS0(33,8)-ZxZpE*VS1(33,8))
VS0(33,29)=QCy*VS0(33,17)+WQy*VS1(33,17)&
   +2D0*r1x2E*(VS0(33,9)-ZxZpE*VS1(33,9))
VS0(33,30)=QCx*VS0(33,18)+WQx*VS1(33,18)&
   +r1x2E*(VS0(33,10)-ZxZpE*VS1(33,10))&
   +HfxZpE*VS1(20,18)
VS0(33,31)=QCz*VS0(33,16)+WQz*VS1(33,16)-r1x2E*VR1(33,16)&
   +r1x2E*(VS0(33,6)-ZxZpE*VS1(33,6))&
   +3D0*HfxZpE*VS1(18,16)
VS0(33,32)=QCy*VS0(33,19)+WQy*VS1(33,19)&
   +r1x2E*(VS0(33,10)-ZxZpE*VS1(33,10))
VS0(33,33)=QCz*VS0(33,18)+WQz*VS1(33,18)-r1x2E*VR1(33,18)&
   +2D0*r1x2E*(VS0(33,8)-ZxZpE*VS1(33,8))&
   +3D0*HfxZpE*VS1(18,18)
VS0(33,34)=QCz*VS0(33,19)+WQz*VS1(33,19)-r1x2E*VR1(33,19)&
   +2D0*r1x2E*(VS0(33,9)-ZxZpE*VS1(33,9))&
   +3D0*HfxZpE*VS1(18,19)
VS0(33,35)=QCz*VS0(33,20)+WQz*VS1(33,20)-r1x2E*VR1(33,20)&
   +3D0*r1x2E*(VS0(33,10)-ZxZpE*VS1(33,10))&
   +3D0*HfxZpE*VS1(18,20)
VS0(34,21)=QCx*VS0(34,11)+WQx*VS1(34,11)&
   +3D0*r1x2E*(VS0(34,5)-ZxZpE*VS1(34,5))
VS0(34,22)=QCx*VS0(34,12)+WQx*VS1(34,12)&
   +2D0*r1x2E*(VS0(34,6)-ZxZpE*VS1(34,6))
VS0(34,23)=QCx*VS0(34,13)+WQx*VS1(34,13)&
   +r1x2E*(VS0(34,7)-ZxZpE*VS1(34,7))
VS0(34,24)=QCy*VS0(34,13)+WQy*VS1(34,13)&
   +2D0*r1x2E*(VS0(34,6)-ZxZpE*VS1(34,6))&
   +HfxZpE*VS1(20,13)
VS0(34,25)=QCy*VS0(34,14)+WQy*VS1(34,14)&
   +3D0*r1x2E*(VS0(34,7)-ZxZpE*VS1(34,7))&
   +HfxZpE*VS1(20,14)
VS0(34,26)=QCx*VS0(34,15)+WQx*VS1(34,15)&
   +2D0*r1x2E*(VS0(34,8)-ZxZpE*VS1(34,8))
VS0(34,27)=QCx*VS0(34,16)+WQx*VS1(34,16)&
   +r1x2E*(VS0(34,9)-ZxZpE*VS1(34,9))
VS0(34,28)=QCy*VS0(34,16)+WQy*VS1(34,16)&
   +r1x2E*(VS0(34,8)-ZxZpE*VS1(34,8))&
   +HfxZpE*VS1(20,16)
VS0(34,29)=QCy*VS0(34,17)+WQy*VS1(34,17)&
   +2D0*r1x2E*(VS0(34,9)-ZxZpE*VS1(34,9))&
   +HfxZpE*VS1(20,17)
VS0(34,30)=QCx*VS0(34,18)+WQx*VS1(34,18)&
   +r1x2E*(VS0(34,10)-ZxZpE*VS1(34,10))
VS0(34,31)=QCz*VS0(34,16)+WQz*VS1(34,16)-r1x2E*VR1(34,16)&
   +r1x2E*(VS0(34,6)-ZxZpE*VS1(34,6))&
   +3D0*HfxZpE*VS1(19,16)
VS0(34,32)=QCy*VS0(34,19)+WQy*VS1(34,19)&
   +r1x2E*(VS0(34,10)-ZxZpE*VS1(34,10))&
   +HfxZpE*VS1(20,19)
VS0(34,33)=QCz*VS0(34,18)+WQz*VS1(34,18)-r1x2E*VR1(34,18)&
   +2D0*r1x2E*(VS0(34,8)-ZxZpE*VS1(34,8))&
   +3D0*HfxZpE*VS1(19,18)
VS0(34,34)=QCz*VS0(34,19)+WQz*VS1(34,19)-r1x2E*VR1(34,19)&
   +2D0*r1x2E*(VS0(34,9)-ZxZpE*VS1(34,9))&
   +3D0*HfxZpE*VS1(19,19)
VS0(34,35)=QCz*VS0(34,20)+WQz*VS1(34,20)-r1x2E*VR1(34,20)&
   +3D0*r1x2E*(VS0(34,10)-ZxZpE*VS1(34,10))&
   +3D0*HfxZpE*VS1(19,20)
VS0(35,21)=QCx*VS0(35,11)+WQx*VS1(35,11)&
   +3D0*r1x2E*(VS0(35,5)-ZxZpE*VS1(35,5))
VS0(35,22)=QCx*VS0(35,12)+WQx*VS1(35,12)&
   +2D0*r1x2E*(VS0(35,6)-ZxZpE*VS1(35,6))
VS0(35,23)=QCx*VS0(35,13)+WQx*VS1(35,13)&
   +r1x2E*(VS0(35,7)-ZxZpE*VS1(35,7))
VS0(35,24)=QCy*VS0(35,13)+WQy*VS1(35,13)&
   +2D0*r1x2E*(VS0(35,6)-ZxZpE*VS1(35,6))
VS0(35,25)=QCy*VS0(35,14)+WQy*VS1(35,14)&
   +3D0*r1x2E*(VS0(35,7)-ZxZpE*VS1(35,7))
VS0(35,26)=QCx*VS0(35,15)+WQx*VS1(35,15)&
   +2D0*r1x2E*(VS0(35,8)-ZxZpE*VS1(35,8))
VS0(35,27)=QCx*VS0(35,16)+WQx*VS1(35,16)&
   +r1x2E*(VS0(35,9)-ZxZpE*VS1(35,9))
VS0(35,28)=QCy*VS0(35,16)+WQy*VS1(35,16)&
   +r1x2E*(VS0(35,8)-ZxZpE*VS1(35,8))
VS0(35,29)=QCy*VS0(35,17)+WQy*VS1(35,17)&
   +2D0*r1x2E*(VS0(35,9)-ZxZpE*VS1(35,9))
VS0(35,30)=QCx*VS0(35,18)+WQx*VS1(35,18)&
   +r1x2E*(VS0(35,10)-ZxZpE*VS1(35,10))
VS0(35,31)=QCz*VS0(35,16)+WQz*VS1(35,16)-r1x2E*VR1(35,16)&
   +r1x2E*(VS0(35,6)-ZxZpE*VS1(35,6))&
   +4D0*HfxZpE*VS1(20,16)
VS0(35,32)=QCy*VS0(35,19)+WQy*VS1(35,19)&
   +r1x2E*(VS0(35,10)-ZxZpE*VS1(35,10))
VS0(35,33)=QCz*VS0(35,18)+WQz*VS1(35,18)-r1x2E*VR1(35,18)&
   +2D0*r1x2E*(VS0(35,8)-ZxZpE*VS1(35,8))&
   +4D0*HfxZpE*VS1(20,18)
VS0(35,34)=QCz*VS0(35,19)+WQz*VS1(35,19)-r1x2E*VR1(35,19)&
   +2D0*r1x2E*(VS0(35,9)-ZxZpE*VS1(35,9))&
   +4D0*HfxZpE*VS1(20,19)
VS0(35,35)=QCz*VS0(35,20)+WQz*VS1(35,20)-r1x2E*VR1(35,20)&
   +3D0*r1x2E*(VS0(35,10)-ZxZpE*VS1(35,10))&
   +4D0*HfxZpE*VS1(20,20)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRg0g0'
STOP
END SELECT
END SUBROUTINE MVRRg0g0
