!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
    SUBROUTINE BraHRR610ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR,HRRA,HRRB,GRADIENT,FP,STRESS)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT NONE
      INTEGER       :: NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,OffSet
      REAL(DOUBLE)  :: HRR(*),HRRA(*),HRRB(*)
      REAL(DOUBLE)  :: GRADIENT(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9),FP(9),DUM
      OffSet=(OA+0)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(5_x,11|
      DUM=-2.D0*HRR(21)+&
                         ABx*(-6.D0*HRR(11)+&
                         ABx*(-6.D0*HRR(5)+&
                         ABx*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         3.D0*HRRA(21))+&
                         3.D0*HRRA(36))+&
                         HRRA(57)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,11_x|
      DUM=-3.D0*HRR(21)+&
                         ABx*(-6.D0*HRR(11)+&
                         ABx*(-3.D0*HRR(5)+&
                         ABx*(ABx*HRRB(5)+&
                         4.D0*HRRB(11))+&
                         6.D0*HRRB(21))+&
                         4.D0*HRRB(36))+&
                         HRRB(57)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,11|
      DUM=ABx*(ABx*(ABx*HRRA(12)+&
                         3.D0*HRRA(22))+&
                         3.D0*HRRA(37))+&
                         HRRA(58)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,11_y|
      DUM=ABy*HRRB(36)+&
                         ABx*(3.D0*ABy*HRRB(21)+&
                         ABx*(3.D0*ABy*HRRB(11)+&
                         ABx*(ABy*HRRB(5)+&
                         HRRB(12))+&
                         3.D0*HRRB(22))+&
                         3.D0*HRRB(37))+&
                         HRRB(58)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,11|
      DUM=ABx*(ABx*(ABx*HRRA(15)+&
                         3.D0*HRRA(26))+&
                         3.D0*HRRA(42))+&
                         HRRA(64)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,11_z|
      DUM=ABz*HRRB(36)+&
                         ABx*(3.D0*ABz*HRRB(21)+&
                         ABx*(3.D0*ABz*HRRB(11)+&
                         ABx*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(42))+&
                         HRRB(64)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(6_x,11|
      DUM=-HRR(22)+&
                         ABx*(-3.D0*HRR(12)+&
                         ABx*(-3.D0*HRR(6)+&
                         ABx*(-HRR(3)+&
                         HRRA(12))+&
                         3.D0*HRRA(22))+&
                         3.D0*HRRA(37))+&
                         HRRA(58)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,11_x|
      DUM=-3.D0*HRR(22)+&
                         ABx*(-6.D0*HRR(12)+&
                         ABx*(-3.D0*HRR(6)+&
                         ABx*(ABx*HRRB(6)+&
                         4.D0*HRRB(12))+&
                         6.D0*HRRB(22))+&
                         4.D0*HRRB(37))+&
                         HRRB(58)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,11|
      DUM=-HRR(21)+&
                         ABx*(-3.D0*HRR(11)+&
                         ABx*(-3.D0*HRR(5)+&
                         ABx*(-HRR(2)+&
                         HRRA(13))+&
                         3.D0*HRRA(23))+&
                         3.D0*HRRA(38))+&
                         HRRA(59)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,11_y|
      DUM=ABy*HRRB(37)+&
                         ABx*(3.D0*ABy*HRRB(22)+&
                         ABx*(3.D0*ABy*HRRB(12)+&
                         ABx*(ABy*HRRB(6)+&
                         HRRB(13))+&
                         3.D0*HRRB(23))+&
                         3.D0*HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,11|
      DUM=ABx*(ABx*(ABx*HRRA(16)+&
                         3.D0*HRRA(27))+&
                         3.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,11_z|
      DUM=ABz*HRRB(37)+&
                         ABx*(3.D0*ABz*HRRB(22)+&
                         ABx*(3.D0*ABz*HRRB(12)+&
                         ABx*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(7_x,11|
      DUM=ABx*(ABx*(ABx*HRRA(13)+&
                         3.D0*HRRA(23))+&
                         3.D0*HRRA(38))+&
                         HRRA(59)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,11_x|
      DUM=-3.D0*HRR(23)+&
                         ABx*(-6.D0*HRR(13)+&
                         ABx*(-3.D0*HRR(7)+&
                         ABx*(ABx*HRRB(7)+&
                         4.D0*HRRB(13))+&
                         6.D0*HRRB(23))+&
                         4.D0*HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,11|
      DUM=-2.D0*HRR(22)+&
                         ABx*(-6.D0*HRR(12)+&
                         ABx*(-6.D0*HRR(6)+&
                         ABx*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         3.D0*HRRA(24))+&
                         3.D0*HRRA(39))+&
                         HRRA(60)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,11_y|
      DUM=ABy*HRRB(38)+&
                         ABx*(3.D0*ABy*HRRB(23)+&
                         ABx*(3.D0*ABy*HRRB(13)+&
                         ABx*(ABy*HRRB(7)+&
                         HRRB(14))+&
                         3.D0*HRRB(24))+&
                         3.D0*HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,11|
      DUM=ABx*(ABx*(ABx*HRRA(17)+&
                         3.D0*HRRA(28))+&
                         3.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,11_z|
      DUM=ABz*HRRB(38)+&
                         ABx*(3.D0*ABz*HRRB(23)+&
                         ABx*(3.D0*ABz*HRRB(13)+&
                         ABx*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(8_x,11|
      DUM=-HRR(26)+&
                         ABx*(-3.D0*HRR(15)+&
                         ABx*(-3.D0*HRR(8)+&
                         ABx*(-HRR(4)+&
                         HRRA(15))+&
                         3.D0*HRRA(26))+&
                         3.D0*HRRA(42))+&
                         HRRA(64)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,11_x|
      DUM=-3.D0*HRR(26)+&
                         ABx*(-6.D0*HRR(15)+&
                         ABx*(-3.D0*HRR(8)+&
                         ABx*(ABx*HRRB(8)+&
                         4.D0*HRRB(15))+&
                         6.D0*HRRB(26))+&
                         4.D0*HRRB(42))+&
                         HRRB(64)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,11|
      DUM=ABx*(ABx*(ABx*HRRA(16)+&
                         3.D0*HRRA(27))+&
                         3.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,11_y|
      DUM=ABy*HRRB(42)+&
                         ABx*(3.D0*ABy*HRRB(26)+&
                         ABx*(3.D0*ABy*HRRB(15)+&
                         ABx*(ABy*HRRB(8)+&
                         HRRB(16))+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,11|
      DUM=-HRR(21)+&
                         ABx*(-3.D0*HRR(11)+&
                         ABx*(-3.D0*HRR(5)+&
                         ABx*(-HRR(2)+&
                         HRRA(18))+&
                         3.D0*HRRA(30))+&
                         3.D0*HRRA(47))+&
                         HRRA(70)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,11_z|
      DUM=ABz*HRRB(42)+&
                         ABx*(3.D0*ABz*HRRB(26)+&
                         ABx*(3.D0*ABz*HRRB(15)+&
                         ABx*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(9_x,11|
      DUM=ABx*(ABx*(ABx*HRRA(16)+&
                         3.D0*HRRA(27))+&
                         3.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,11_x|
      DUM=-3.D0*HRR(27)+&
                         ABx*(-6.D0*HRR(16)+&
                         ABx*(-3.D0*HRR(9)+&
                         ABx*(ABx*HRRB(9)+&
                         4.D0*HRRB(16))+&
                         6.D0*HRRB(27))+&
                         4.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,11|
      DUM=-HRR(26)+&
                         ABx*(-3.D0*HRR(15)+&
                         ABx*(-3.D0*HRR(8)+&
                         ABx*(-HRR(4)+&
                         HRRA(17))+&
                         3.D0*HRRA(28))+&
                         3.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,11_y|
      DUM=ABy*HRRB(43)+&
                         ABx*(3.D0*ABy*HRRB(27)+&
                         ABx*(3.D0*ABy*HRRB(16)+&
                         ABx*(ABy*HRRB(9)+&
                         HRRB(17))+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,11|
      DUM=-HRR(22)+&
                         ABx*(-3.D0*HRR(12)+&
                         ABx*(-3.D0*HRR(6)+&
                         ABx*(-HRR(3)+&
                         HRRA(19))+&
                         3.D0*HRRA(31))+&
                         3.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,11_z|
      DUM=ABz*HRRB(43)+&
                         ABx*(3.D0*ABz*HRRB(27)+&
                         ABx*(3.D0*ABz*HRRB(16)+&
                         ABx*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(10_x,11|
      DUM=ABx*(ABx*(ABx*HRRA(18)+&
                         3.D0*HRRA(30))+&
                         3.D0*HRRA(47))+&
                         HRRA(70)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,11_x|
      DUM=-3.D0*HRR(30)+&
                         ABx*(-6.D0*HRR(18)+&
                         ABx*(-3.D0*HRR(10)+&
                         ABx*(ABx*HRRB(10)+&
                         4.D0*HRRB(18))+&
                         6.D0*HRRB(30))+&
                         4.D0*HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,11|
      DUM=ABx*(ABx*(ABx*HRRA(19)+&
                         3.D0*HRRA(31))+&
                         3.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,11_y|
      DUM=ABy*HRRB(47)+&
                         ABx*(3.D0*ABy*HRRB(30)+&
                         ABx*(3.D0*ABy*HRRB(18)+&
                         ABx*(ABy*HRRB(10)+&
                         HRRB(19))+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,11|
      DUM=-2.D0*HRR(26)+&
                         ABx*(-6.D0*HRR(15)+&
                         ABx*(-6.D0*HRR(8)+&
                         ABx*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         3.D0*HRRA(33))+&
                         3.D0*HRRA(51))+&
                         HRRA(75)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,11_z|
      DUM=ABz*HRRB(47)+&
                         ABx*(3.D0*ABz*HRRB(30)+&
                         ABx*(3.D0*ABz*HRRB(18)+&
                         ABx*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(5_x,12|
      DUM=-2.D0*HRR(22)+&
                         ABy*(-2.D0*HRR(11)+&
                         HRRA(36))+&
                         ABx*(-4.D0*HRR(12)+&
                         ABy*(-4.D0*HRR(5)+&
                         2.D0*HRRA(21))+&
                         ABx*(-2.D0*HRR(6)+&
                         ABy*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         HRRA(22))+&
                         2.D0*HRRA(37))+&
                         HRRA(58)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,12_x|
      DUM=-2.D0*HRR(22)+&
                         ABy*(-2.D0*HRR(11)+&
                         HRRB(36))+&
                         ABx*(-2.D0*HRR(12)+&
                         ABy*(-2.D0*HRR(5)+&
                         3.D0*HRRB(21))+&
                         ABx*(3.D0*ABy*HRRB(11)+&
                         ABx*(ABy*HRRB(5)+&
                         HRRB(12))+&
                         3.D0*HRRB(22))+&
                         3.D0*HRRB(37))+&
                         HRRB(58)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,12|
      DUM=ABy*HRRA(37)+&
                         ABx*(2.D0*ABy*HRRA(22)+&
                         ABx*(ABy*HRRA(12)+&
                         HRRA(23))+&
                         2.D0*HRRA(38))+&
                         HRRA(59)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,12_y|
      DUM=-HRR(21)+&
                         ABy*(ABy*HRRB(21)+&
                         2.D0*HRRB(37))+&
                         ABx*(-2.D0*HRR(11)+&
                         ABy*(2.D0*ABy*HRRB(11)+&
                         4.D0*HRRB(22))+&
                         ABx*(-HRR(5)+&
                         ABy*(ABy*HRRB(5)+&
                         2.D0*HRRB(12))+&
                         HRRB(23))+&
                         2.D0*HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,12|
      DUM=ABy*HRRA(42)+&
                         ABx*(2.D0*ABy*HRRA(26)+&
                         ABx*(ABy*HRRA(15)+&
                         HRRA(27))+&
                         2.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,12_z|
      DUM=ABz*HRRB(37)+&
                         ABy*(ABz*HRRB(21)+&
                         HRRB(42))+&
                         ABx*(2.D0*ABz*HRRB(22)+&
                         ABy*(2.D0*ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         ABx*(ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         HRRB(27))+&
                         2.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(6_x,12|
      DUM=-HRR(23)+&
                         ABy*(-HRR(12)+&
                         HRRA(37))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         2.D0*HRRA(22))+&
                         ABx*(-HRR(7)+&
                         ABy*(-HRR(3)+&
                         HRRA(12))+&
                         HRRA(23))+&
                         2.D0*HRRA(38))+&
                         HRRA(59)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,12_x|
      DUM=-2.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         HRRB(37))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         3.D0*HRRB(22))+&
                         ABx*(3.D0*ABy*HRRB(12)+&
                         ABx*(ABy*HRRB(6)+&
                         HRRB(13))+&
                         3.D0*HRRB(23))+&
                         3.D0*HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,12|
      DUM=-HRR(22)+&
                         ABy*(-HRR(11)+&
                         HRRA(38))+&
                         ABx*(-2.D0*HRR(12)+&
                         ABy*(-2.D0*HRR(5)+&
                         2.D0*HRRA(23))+&
                         ABx*(-HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRA(13))+&
                         HRRA(24))+&
                         2.D0*HRRA(39))+&
                         HRRA(60)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,12_y|
      DUM=-HRR(22)+&
                         ABy*(ABy*HRRB(22)+&
                         2.D0*HRRB(38))+&
                         ABx*(-2.D0*HRR(12)+&
                         ABy*(2.D0*ABy*HRRB(12)+&
                         4.D0*HRRB(23))+&
                         ABx*(-HRR(6)+&
                         ABy*(ABy*HRRB(6)+&
                         2.D0*HRRB(13))+&
                         HRRB(24))+&
                         2.D0*HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,12|
      DUM=ABy*HRRA(43)+&
                         ABx*(2.D0*ABy*HRRA(27)+&
                         ABx*(ABy*HRRA(16)+&
                         HRRA(28))+&
                         2.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,12_z|
      DUM=ABz*HRRB(38)+&
                         ABy*(ABz*HRRB(22)+&
                         HRRB(43))+&
                         ABx*(2.D0*ABz*HRRB(23)+&
                         ABy*(2.D0*ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABx*(ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         HRRB(28))+&
                         2.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(7_x,12|
      DUM=ABy*HRRA(38)+&
                         ABx*(2.D0*ABy*HRRA(23)+&
                         ABx*(ABy*HRRA(13)+&
                         HRRA(24))+&
                         2.D0*HRRA(39))+&
                         HRRA(60)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,12_x|
      DUM=-2.D0*HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         HRRB(38))+&
                         ABx*(-2.D0*HRR(14)+&
                         ABy*(-2.D0*HRR(7)+&
                         3.D0*HRRB(23))+&
                         ABx*(3.D0*ABy*HRRB(13)+&
                         ABx*(ABy*HRRB(7)+&
                         HRRB(14))+&
                         3.D0*HRRB(24))+&
                         3.D0*HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,12|
      DUM=-2.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         HRRA(39))+&
                         ABx*(-4.D0*HRR(13)+&
                         ABy*(-4.D0*HRR(6)+&
                         2.D0*HRRA(24))+&
                         ABx*(-2.D0*HRR(7)+&
                         ABy*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         HRRA(25))+&
                         2.D0*HRRA(40))+&
                         HRRA(61)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,12_y|
      DUM=-HRR(23)+&
                         ABy*(ABy*HRRB(23)+&
                         2.D0*HRRB(39))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(2.D0*ABy*HRRB(13)+&
                         4.D0*HRRB(24))+&
                         ABx*(-HRR(7)+&
                         ABy*(ABy*HRRB(7)+&
                         2.D0*HRRB(14))+&
                         HRRB(25))+&
                         2.D0*HRRB(40))+&
                         HRRB(61)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,12|
      DUM=ABy*HRRA(44)+&
                         ABx*(2.D0*ABy*HRRA(28)+&
                         ABx*(ABy*HRRA(17)+&
                         HRRA(29))+&
                         2.D0*HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,12_z|
      DUM=ABz*HRRB(39)+&
                         ABy*(ABz*HRRB(23)+&
                         HRRB(44))+&
                         ABx*(2.D0*ABz*HRRB(24)+&
                         ABy*(2.D0*ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABx*(ABz*HRRB(14)+&
                         ABy*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         HRRB(29))+&
                         2.D0*HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(8_x,12|
      DUM=-HRR(27)+&
                         ABy*(-HRR(15)+&
                         HRRA(42))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         2.D0*HRRA(26))+&
                         ABx*(-HRR(9)+&
                         ABy*(-HRR(4)+&
                         HRRA(15))+&
                         HRRA(27))+&
                         2.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,12_x|
      DUM=-2.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         HRRB(42))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         3.D0*HRRB(26))+&
                         ABx*(3.D0*ABy*HRRB(15)+&
                         ABx*(ABy*HRRB(8)+&
                         HRRB(16))+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,12|
      DUM=ABy*HRRA(43)+&
                         ABx*(2.D0*ABy*HRRA(27)+&
                         ABx*(ABy*HRRA(16)+&
                         HRRA(28))+&
                         2.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,12_y|
      DUM=-HRR(26)+&
                         ABy*(ABy*HRRB(26)+&
                         2.D0*HRRB(43))+&
                         ABx*(-2.D0*HRR(15)+&
                         ABy*(2.D0*ABy*HRRB(15)+&
                         4.D0*HRRB(27))+&
                         ABx*(-HRR(8)+&
                         ABy*(ABy*HRRB(8)+&
                         2.D0*HRRB(16))+&
                         HRRB(28))+&
                         2.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,12|
      DUM=-HRR(22)+&
                         ABy*(-HRR(11)+&
                         HRRA(47))+&
                         ABx*(-2.D0*HRR(12)+&
                         ABy*(-2.D0*HRR(5)+&
                         2.D0*HRRA(30))+&
                         ABx*(-HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRA(18))+&
                         HRRA(31))+&
                         2.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,12_z|
      DUM=ABz*HRRB(43)+&
                         ABy*(ABz*HRRB(26)+&
                         HRRB(47))+&
                         ABx*(2.D0*ABz*HRRB(27)+&
                         ABy*(2.D0*ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         ABx*(ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         HRRB(31))+&
                         2.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(9_x,12|
      DUM=ABy*HRRA(43)+&
                         ABx*(2.D0*ABy*HRRA(27)+&
                         ABx*(ABy*HRRA(16)+&
                         HRRA(28))+&
                         2.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,12_x|
      DUM=-2.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         HRRB(43))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         3.D0*HRRB(27))+&
                         ABx*(3.D0*ABy*HRRB(16)+&
                         ABx*(ABy*HRRB(9)+&
                         HRRB(17))+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,12|
      DUM=-HRR(27)+&
                         ABy*(-HRR(15)+&
                         HRRA(44))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         2.D0*HRRA(28))+&
                         ABx*(-HRR(9)+&
                         ABy*(-HRR(4)+&
                         HRRA(17))+&
                         HRRA(29))+&
                         2.D0*HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,12_y|
      DUM=-HRR(27)+&
                         ABy*(ABy*HRRB(27)+&
                         2.D0*HRRB(44))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABy*(2.D0*ABy*HRRB(16)+&
                         4.D0*HRRB(28))+&
                         ABx*(-HRR(9)+&
                         ABy*(ABy*HRRB(9)+&
                         2.D0*HRRB(17))+&
                         HRRB(29))+&
                         2.D0*HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,12|
      DUM=-HRR(23)+&
                         ABy*(-HRR(12)+&
                         HRRA(48))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         2.D0*HRRA(31))+&
                         ABx*(-HRR(7)+&
                         ABy*(-HRR(3)+&
                         HRRA(19))+&
                         HRRA(32))+&
                         2.D0*HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,12_z|
      DUM=ABz*HRRB(44)+&
                         ABy*(ABz*HRRB(27)+&
                         HRRB(48))+&
                         ABx*(2.D0*ABz*HRRB(28)+&
                         ABy*(2.D0*ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         ABx*(ABz*HRRB(17)+&
                         ABy*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(10_x,12|
      DUM=ABy*HRRA(47)+&
                         ABx*(2.D0*ABy*HRRA(30)+&
                         ABx*(ABy*HRRA(18)+&
                         HRRA(31))+&
                         2.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,12_x|
      DUM=-2.D0*HRR(31)+&
                         ABy*(-2.D0*HRR(18)+&
                         HRRB(47))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABy*(-2.D0*HRR(10)+&
                         3.D0*HRRB(30))+&
                         ABx*(3.D0*ABy*HRRB(18)+&
                         ABx*(ABy*HRRB(10)+&
                         HRRB(19))+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,12|
      DUM=ABy*HRRA(48)+&
                         ABx*(2.D0*ABy*HRRA(31)+&
                         ABx*(ABy*HRRA(19)+&
                         HRRA(32))+&
                         2.D0*HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,12_y|
      DUM=-HRR(30)+&
                         ABy*(ABy*HRRB(30)+&
                         2.D0*HRRB(48))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABy*(2.D0*ABy*HRRB(18)+&
                         4.D0*HRRB(31))+&
                         ABx*(-HRR(10)+&
                         ABy*(ABy*HRRB(10)+&
                         2.D0*HRRB(19))+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,12|
      DUM=-2.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         HRRA(51))+&
                         ABx*(-4.D0*HRR(16)+&
                         ABy*(-4.D0*HRR(8)+&
                         2.D0*HRRA(33))+&
                         ABx*(-2.D0*HRR(9)+&
                         ABy*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         HRRA(34))+&
                         2.D0*HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,12_z|
      DUM=ABz*HRRB(48)+&
                         ABy*(ABz*HRRB(30)+&
                         HRRB(51))+&
                         ABx*(2.D0*ABz*HRRB(31)+&
                         ABy*(2.D0*ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         ABx*(ABz*HRRB(19)+&
                         ABy*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         HRRB(34))+&
                         2.D0*HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(5_x,13|
      DUM=-2.D0*HRR(23)+&
                         ABy*(-4.D0*HRR(12)+&
                         ABy*(-2.D0*HRR(5)+&
                         HRRA(21))+&
                         2.D0*HRRA(37))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(-4.D0*HRR(6)+&
                         ABy*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         2.D0*HRRA(22))+&
                         HRRA(38))+&
                         HRRA(59)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,13_x|
      DUM=-HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRB(21))+&
                         2.D0*HRRB(37))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(11)+&
                         4.D0*HRRB(22))+&
                         ABx*(ABy*(ABy*HRRB(5)+&
                         2.D0*HRRB(12))+&
                         HRRB(23))+&
                         2.D0*HRRB(38))+&
                         HRRB(59)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,13|
      DUM=ABy*(ABy*HRRA(22)+&
                         2.D0*HRRA(38))+&
                         ABx*(ABy*(ABy*HRRA(12)+&
                         2.D0*HRRA(23))+&
                         HRRA(39))+&
                         HRRA(60)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,13_y|
      DUM=-2.D0*HRR(22)+&
                         ABy*(-2.D0*HRR(11)+&
                         ABy*(ABy*HRRB(11)+&
                         3.D0*HRRB(22))+&
                         3.D0*HRRB(38))+&
                         ABx*(-2.D0*HRR(12)+&
                         ABy*(-2.D0*HRR(5)+&
                         ABy*(ABy*HRRB(5)+&
                         3.D0*HRRB(12))+&
                         3.D0*HRRB(23))+&
                         HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,13|
      DUM=ABy*(ABy*HRRA(26)+&
                         2.D0*HRRA(43))+&
                         ABx*(ABy*(ABy*HRRA(15)+&
                         2.D0*HRRA(27))+&
                         HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,13_z|
      DUM=ABz*HRRB(38)+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(43))+&
                         ABx*(ABz*HRRB(23)+&
                         ABy*(2.D0*ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         2.D0*HRRB(27))+&
                         HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(6_x,13|
      DUM=-HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         ABy*(-HRR(6)+&
                         HRRA(22))+&
                         2.D0*HRRA(38))+&
                         ABx*(-HRR(14)+&
                         ABy*(-2.D0*HRR(7)+&
                         ABy*(-HRR(3)+&
                         HRRA(12))+&
                         2.D0*HRRA(23))+&
                         HRRA(39))+&
                         HRRA(60)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,13_x|
      DUM=-HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         ABy*(-HRR(6)+&
                         HRRB(22))+&
                         2.D0*HRRB(38))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(12)+&
                         4.D0*HRRB(23))+&
                         ABx*(ABy*(ABy*HRRB(6)+&
                         2.D0*HRRB(13))+&
                         HRRB(24))+&
                         2.D0*HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,13|
      DUM=-HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(23))+&
                         2.D0*HRRA(39))+&
                         ABx*(-HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRA(13))+&
                         2.D0*HRRA(24))+&
                         HRRA(40))+&
                         HRRA(61)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,13_y|
      DUM=-2.D0*HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(ABy*HRRB(12)+&
                         3.D0*HRRB(23))+&
                         3.D0*HRRB(39))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         ABy*(ABy*HRRB(6)+&
                         3.D0*HRRB(13))+&
                         3.D0*HRRB(24))+&
                         HRRB(40))+&
                         HRRB(61)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,13|
      DUM=ABy*(ABy*HRRA(27)+&
                         2.D0*HRRA(44))+&
                         ABx*(ABy*(ABy*HRRA(16)+&
                         2.D0*HRRA(28))+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,13_z|
      DUM=ABz*HRRB(39)+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(44))+&
                         ABx*(ABz*HRRB(24)+&
                         ABy*(2.D0*ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         2.D0*HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(7_x,13|
      DUM=ABy*(ABy*HRRA(23)+&
                         2.D0*HRRA(39))+&
                         ABx*(ABy*(ABy*HRRA(13)+&
                         2.D0*HRRA(24))+&
                         HRRA(40))+&
                         HRRA(61)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,13_x|
      DUM=-HRR(25)+&
                         ABy*(-2.D0*HRR(14)+&
                         ABy*(-HRR(7)+&
                         HRRB(23))+&
                         2.D0*HRRB(39))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(13)+&
                         4.D0*HRRB(24))+&
                         ABx*(ABy*(ABy*HRRB(7)+&
                         2.D0*HRRB(14))+&
                         HRRB(25))+&
                         2.D0*HRRB(40))+&
                         HRRB(61)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,13|
      DUM=-2.D0*HRR(24)+&
                         ABy*(-4.D0*HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         2.D0*HRRA(40))+&
                         ABx*(-2.D0*HRR(14)+&
                         ABy*(-4.D0*HRR(7)+&
                         ABy*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         2.D0*HRRA(25))+&
                         HRRA(41))+&
                         HRRA(62)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,13_y|
      DUM=-2.D0*HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         ABy*(ABy*HRRB(13)+&
                         3.D0*HRRB(24))+&
                         3.D0*HRRB(40))+&
                         ABx*(-2.D0*HRR(14)+&
                         ABy*(-2.D0*HRR(7)+&
                         ABy*(ABy*HRRB(7)+&
                         3.D0*HRRB(14))+&
                         3.D0*HRRB(25))+&
                         HRRB(41))+&
                         HRRB(62)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,13|
      DUM=ABy*(ABy*HRRA(28)+&
                         2.D0*HRRA(45))+&
                         ABx*(ABy*(ABy*HRRA(17)+&
                         2.D0*HRRA(29))+&
                         HRRA(46))+&
                         HRRA(68)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,13_z|
      DUM=ABz*HRRB(40)+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(45))+&
                         ABx*(ABz*HRRB(25)+&
                         ABy*(2.D0*ABz*HRRB(14)+&
                         ABy*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         2.D0*HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(8_x,13|
      DUM=-HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         ABy*(-HRR(8)+&
                         HRRA(26))+&
                         2.D0*HRRA(43))+&
                         ABx*(-HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         ABy*(-HRR(4)+&
                         HRRA(15))+&
                         2.D0*HRRA(27))+&
                         HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,13_x|
      DUM=-HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         ABy*(-HRR(8)+&
                         HRRB(26))+&
                         2.D0*HRRB(43))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(15)+&
                         4.D0*HRRB(27))+&
                         ABx*(ABy*(ABy*HRRB(8)+&
                         2.D0*HRRB(16))+&
                         HRRB(28))+&
                         2.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,13|
      DUM=ABy*(ABy*HRRA(27)+&
                         2.D0*HRRA(44))+&
                         ABx*(ABy*(ABy*HRRA(16)+&
                         2.D0*HRRA(28))+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,13_y|
      DUM=-2.D0*HRR(27)+&
                         ABy*(-2.D0*HRR(15)+&
                         ABy*(ABy*HRRB(15)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(44))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         ABy*(ABy*HRRB(8)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,13|
      DUM=-HRR(23)+&
                         ABy*(-2.D0*HRR(12)+&
                         ABy*(-HRR(5)+&
                         HRRA(30))+&
                         2.D0*HRRA(48))+&
                         ABx*(-HRR(13)+&
                         ABy*(-2.D0*HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRA(18))+&
                         2.D0*HRRA(31))+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,13_z|
      DUM=ABz*HRRB(44)+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         ABx*(ABz*HRRB(28)+&
                         ABy*(2.D0*ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         2.D0*HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(9_x,13|
      DUM=ABy*(ABy*HRRA(27)+&
                         2.D0*HRRA(44))+&
                         ABx*(ABy*(ABy*HRRA(16)+&
                         2.D0*HRRA(28))+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,13_x|
      DUM=-HRR(29)+&
                         ABy*(-2.D0*HRR(17)+&
                         ABy*(-HRR(9)+&
                         HRRB(27))+&
                         2.D0*HRRB(44))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(16)+&
                         4.D0*HRRB(28))+&
                         ABx*(ABy*(ABy*HRRB(9)+&
                         2.D0*HRRB(17))+&
                         HRRB(29))+&
                         2.D0*HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,13|
      DUM=-HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         ABy*(-HRR(8)+&
                         HRRA(28))+&
                         2.D0*HRRA(45))+&
                         ABx*(-HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         ABy*(-HRR(4)+&
                         HRRA(17))+&
                         2.D0*HRRA(29))+&
                         HRRA(46))+&
                         HRRA(68)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,13_y|
      DUM=-2.D0*HRR(28)+&
                         ABy*(-2.D0*HRR(16)+&
                         ABy*(ABy*HRRB(16)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(45))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABy*(-2.D0*HRR(9)+&
                         ABy*(ABy*HRRB(9)+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,13|
      DUM=-HRR(24)+&
                         ABy*(-2.D0*HRR(13)+&
                         ABy*(-HRR(6)+&
                         HRRA(31))+&
                         2.D0*HRRA(49))+&
                         ABx*(-HRR(14)+&
                         ABy*(-2.D0*HRR(7)+&
                         ABy*(-HRR(3)+&
                         HRRA(19))+&
                         2.D0*HRRA(32))+&
                         HRRA(50))+&
                         HRRA(73)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,13_z|
      DUM=ABz*HRRB(45)+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         ABx*(ABz*HRRB(29)+&
                         ABy*(2.D0*ABz*HRRB(17)+&
                         ABy*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         2.D0*HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(10_x,13|
      DUM=ABy*(ABy*HRRA(30)+&
                         2.D0*HRRA(48))+&
                         ABx*(ABy*(ABy*HRRA(18)+&
                         2.D0*HRRA(31))+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,13_x|
      DUM=-HRR(32)+&
                         ABy*(-2.D0*HRR(19)+&
                         ABy*(-HRR(10)+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         ABx*(ABy*(2.D0*ABy*HRRB(18)+&
                         4.D0*HRRB(31))+&
                         ABx*(ABy*(ABy*HRRB(10)+&
                         2.D0*HRRB(19))+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,13|
      DUM=ABy*(ABy*HRRA(31)+&
                         2.D0*HRRA(49))+&
                         ABx*(ABy*(ABy*HRRA(19)+&
                         2.D0*HRRA(32))+&
                         HRRA(50))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,13_y|
      DUM=-2.D0*HRR(31)+&
                         ABy*(-2.D0*HRR(18)+&
                         ABy*(ABy*HRRB(18)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(49))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABy*(-2.D0*HRR(10)+&
                         ABy*(ABy*HRRB(10)+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,13|
      DUM=-2.D0*HRR(28)+&
                         ABy*(-4.D0*HRR(16)+&
                         ABy*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         2.D0*HRRA(52))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABy*(-4.D0*HRR(9)+&
                         ABy*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         2.D0*HRRA(34))+&
                         HRRA(53))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,13_z|
      DUM=ABz*HRRB(49)+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         ABx*(ABz*HRRB(32)+&
                         ABy*(2.D0*ABz*HRRB(19)+&
                         ABy*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         2.D0*HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(5_x,14|
      DUM=-2.D0*HRR(24)+&
                         ABy*(-6.D0*HRR(13)+&
                         ABy*(-6.D0*HRR(6)+&
                         ABy*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         3.D0*HRRA(22))+&
                         3.D0*HRRA(38))+&
                         HRRA(60)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(11)+&
                         3.D0*HRRB(22))+&
                         3.D0*HRRB(38))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(5)+&
                         3.D0*HRRB(12))+&
                         3.D0*HRRB(23))+&
                         HRRB(39))+&
                         HRRB(60)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,14|
      DUM=ABy*(ABy*(ABy*HRRA(12)+&
                         3.D0*HRRA(23))+&
                         3.D0*HRRA(39))+&
                         HRRA(61)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,14_y|
      DUM=-3.D0*HRR(23)+&
                         ABy*(-6.D0*HRR(12)+&
                         ABy*(-3.D0*HRR(5)+&
                         ABy*(ABy*HRRB(5)+&
                         4.D0*HRRB(12))+&
                         6.D0*HRRB(23))+&
                         4.D0*HRRB(39))+&
                         HRRB(61)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,14|
      DUM=ABy*(ABy*(ABy*HRRA(15)+&
                         3.D0*HRRA(27))+&
                         3.D0*HRRA(44))+&
                         HRRA(67)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,14_z|
      DUM=ABz*HRRB(39)+&
                         ABy*(3.D0*ABz*HRRB(23)+&
                         ABy*(3.D0*ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(44))+&
                         HRRB(67)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(6_x,14|
      DUM=-HRR(25)+&
                         ABy*(-3.D0*HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         ABy*(-HRR(3)+&
                         HRRA(12))+&
                         3.D0*HRRA(23))+&
                         3.D0*HRRA(39))+&
                         HRRA(61)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(12)+&
                         3.D0*HRRB(23))+&
                         3.D0*HRRB(39))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(6)+&
                         3.D0*HRRB(13))+&
                         3.D0*HRRB(24))+&
                         HRRB(40))+&
                         HRRB(61)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,14|
      DUM=-HRR(24)+&
                         ABy*(-3.D0*HRR(13)+&
                         ABy*(-3.D0*HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRA(13))+&
                         3.D0*HRRA(24))+&
                         3.D0*HRRA(40))+&
                         HRRA(62)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,14_y|
      DUM=-3.D0*HRR(24)+&
                         ABy*(-6.D0*HRR(13)+&
                         ABy*(-3.D0*HRR(6)+&
                         ABy*(ABy*HRRB(6)+&
                         4.D0*HRRB(13))+&
                         6.D0*HRRB(24))+&
                         4.D0*HRRB(40))+&
                         HRRB(62)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,14|
      DUM=ABy*(ABy*(ABy*HRRA(16)+&
                         3.D0*HRRA(28))+&
                         3.D0*HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,14_z|
      DUM=ABz*HRRB(40)+&
                         ABy*(3.D0*ABz*HRRB(24)+&
                         ABy*(3.D0*ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(45))+&
                         HRRB(68)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(7_x,14|
      DUM=ABy*(ABy*(ABy*HRRA(13)+&
                         3.D0*HRRA(24))+&
                         3.D0*HRRA(40))+&
                         HRRA(62)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(13)+&
                         3.D0*HRRB(24))+&
                         3.D0*HRRB(40))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(7)+&
                         3.D0*HRRB(14))+&
                         3.D0*HRRB(25))+&
                         HRRB(41))+&
                         HRRB(62)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,14|
      DUM=-2.D0*HRR(25)+&
                         ABy*(-6.D0*HRR(14)+&
                         ABy*(-6.D0*HRR(7)+&
                         ABy*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         3.D0*HRRA(25))+&
                         3.D0*HRRA(41))+&
                         HRRA(63)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,14_y|
      DUM=-3.D0*HRR(25)+&
                         ABy*(-6.D0*HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         ABy*(ABy*HRRB(7)+&
                         4.D0*HRRB(14))+&
                         6.D0*HRRB(25))+&
                         4.D0*HRRB(41))+&
                         HRRB(63)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,14|
      DUM=ABy*(ABy*(ABy*HRRA(17)+&
                         3.D0*HRRA(29))+&
                         3.D0*HRRA(46))+&
                         HRRA(69)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,14_z|
      DUM=ABz*HRRB(41)+&
                         ABy*(3.D0*ABz*HRRB(25)+&
                         ABy*(3.D0*ABz*HRRB(14)+&
                         ABy*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(46))+&
                         HRRB(69)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(8_x,14|
      DUM=-HRR(29)+&
                         ABy*(-3.D0*HRR(17)+&
                         ABy*(-3.D0*HRR(9)+&
                         ABy*(-HRR(4)+&
                         HRRA(15))+&
                         3.D0*HRRA(27))+&
                         3.D0*HRRA(44))+&
                         HRRA(67)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(15)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(44))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(8)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,14|
      DUM=ABy*(ABy*(ABy*HRRA(16)+&
                         3.D0*HRRA(28))+&
                         3.D0*HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,14_y|
      DUM=-3.D0*HRR(28)+&
                         ABy*(-6.D0*HRR(16)+&
                         ABy*(-3.D0*HRR(8)+&
                         ABy*(ABy*HRRB(8)+&
                         4.D0*HRRB(16))+&
                         6.D0*HRRB(28))+&
                         4.D0*HRRB(45))+&
                         HRRB(68)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,14|
      DUM=-HRR(24)+&
                         ABy*(-3.D0*HRR(13)+&
                         ABy*(-3.D0*HRR(6)+&
                         ABy*(-HRR(2)+&
                         HRRA(18))+&
                         3.D0*HRRA(31))+&
                         3.D0*HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,14_z|
      DUM=ABz*HRRB(45)+&
                         ABy*(3.D0*ABz*HRRB(28)+&
                         ABy*(3.D0*ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(49))+&
                         HRRB(73)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(9_x,14|
      DUM=ABy*(ABy*(ABy*HRRA(16)+&
                         3.D0*HRRA(28))+&
                         3.D0*HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(16)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(45))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(9)+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,14|
      DUM=-HRR(29)+&
                         ABy*(-3.D0*HRR(17)+&
                         ABy*(-3.D0*HRR(9)+&
                         ABy*(-HRR(4)+&
                         HRRA(17))+&
                         3.D0*HRRA(29))+&
                         3.D0*HRRA(46))+&
                         HRRA(69)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,14_y|
      DUM=-3.D0*HRR(29)+&
                         ABy*(-6.D0*HRR(17)+&
                         ABy*(-3.D0*HRR(9)+&
                         ABy*(ABy*HRRB(9)+&
                         4.D0*HRRB(17))+&
                         6.D0*HRRB(29))+&
                         4.D0*HRRB(46))+&
                         HRRB(69)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,14|
      DUM=-HRR(25)+&
                         ABy*(-3.D0*HRR(14)+&
                         ABy*(-3.D0*HRR(7)+&
                         ABy*(-HRR(3)+&
                         HRRA(19))+&
                         3.D0*HRRA(32))+&
                         3.D0*HRRA(50))+&
                         HRRA(74)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,14_z|
      DUM=ABz*HRRB(46)+&
                         ABy*(3.D0*ABz*HRRB(29)+&
                         ABy*(3.D0*ABz*HRRB(17)+&
                         ABy*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(10_x,14|
      DUM=ABy*(ABy*(ABy*HRRA(18)+&
                         3.D0*HRRA(31))+&
                         3.D0*HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,14_x|
      DUM=ABy*(ABy*(ABy*HRRB(18)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(49))+&
                         ABx*(ABy*(ABy*(ABy*HRRB(10)+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,14|
      DUM=ABy*(ABy*(ABy*HRRA(19)+&
                         3.D0*HRRA(32))+&
                         3.D0*HRRA(50))+&
                         HRRA(74)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,14_y|
      DUM=-3.D0*HRR(32)+&
                         ABy*(-6.D0*HRR(19)+&
                         ABy*(-3.D0*HRR(10)+&
                         ABy*(ABy*HRRB(10)+&
                         4.D0*HRRB(19))+&
                         6.D0*HRRB(32))+&
                         4.D0*HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,14|
      DUM=-2.D0*HRR(29)+&
                         ABy*(-6.D0*HRR(17)+&
                         ABy*(-6.D0*HRR(9)+&
                         ABy*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         3.D0*HRRA(34))+&
                         3.D0*HRRA(53))+&
                         HRRA(78)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,14_z|
      DUM=ABz*HRRB(50)+&
                         ABy*(3.D0*ABz*HRRB(32)+&
                         ABy*(3.D0*ABz*HRRB(19)+&
                         ABy*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(5_x,15|
      DUM=-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         HRRA(36))+&
                         ABx*(-4.D0*HRR(15)+&
                         ABz*(-4.D0*HRR(5)+&
                         2.D0*HRRA(21))+&
                         ABx*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         HRRA(26))+&
                         2.D0*HRRA(42))+&
                         HRRA(64)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,15_x|
      DUM=-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         HRRB(36))+&
                         ABx*(-2.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         3.D0*HRRB(21))+&
                         ABx*(3.D0*ABz*HRRB(11)+&
                         ABx*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(42))+&
                         HRRB(64)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,15|
      DUM=ABz*HRRA(37)+&
                         ABx*(2.D0*ABz*HRRA(22)+&
                         ABx*(ABz*HRRA(12)+&
                         HRRA(27))+&
                         2.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,15_y|
      DUM=ABz*HRRB(37)+&
                         ABy*(ABz*HRRB(21)+&
                         HRRB(42))+&
                         ABx*(2.D0*ABz*HRRB(22)+&
                         ABy*(2.D0*ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         ABx*(ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         HRRB(27))+&
                         2.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,15|
      DUM=ABz*HRRA(42)+&
                         ABx*(2.D0*ABz*HRRA(26)+&
                         ABx*(ABz*HRRA(15)+&
                         HRRA(30))+&
                         2.D0*HRRA(47))+&
                         HRRA(70)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,15_z|
      DUM=-HRR(21)+&
                         ABz*(ABz*HRRB(21)+&
                         2.D0*HRRB(42))+&
                         ABx*(-2.D0*HRR(11)+&
                         ABz*(2.D0*ABz*HRRB(11)+&
                         4.D0*HRRB(26))+&
                         ABx*(-HRR(5)+&
                         ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         2.D0*HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(6_x,15|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(37))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         2.D0*HRRA(22))+&
                         ABx*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(12))+&
                         HRRA(27))+&
                         2.D0*HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,15_x|
      DUM=-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRB(37))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         3.D0*HRRB(22))+&
                         ABx*(3.D0*ABz*HRRB(12)+&
                         ABx*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,15|
      DUM=-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRA(38))+&
                         ABx*(-2.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         2.D0*HRRA(23))+&
                         ABx*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(13))+&
                         HRRA(28))+&
                         2.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,15_y|
      DUM=ABz*HRRB(38)+&
                         ABy*(ABz*HRRB(22)+&
                         HRRB(43))+&
                         ABx*(2.D0*ABz*HRRB(23)+&
                         ABy*(2.D0*ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABx*(ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         HRRB(28))+&
                         2.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,15|
      DUM=ABz*HRRA(43)+&
                         ABx*(2.D0*ABz*HRRA(27)+&
                         ABx*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         2.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,15_z|
      DUM=-HRR(22)+&
                         ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABx*(-2.D0*HRR(12)+&
                         ABz*(2.D0*ABz*HRRB(12)+&
                         4.D0*HRRB(27))+&
                         ABx*(-HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         2.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(7_x,15|
      DUM=ABz*HRRA(38)+&
                         ABx*(2.D0*ABz*HRRA(23)+&
                         ABx*(ABz*HRRA(13)+&
                         HRRA(28))+&
                         2.D0*HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,15_x|
      DUM=-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRB(38))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         3.D0*HRRB(23))+&
                         ABx*(3.D0*ABz*HRRB(13)+&
                         ABx*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,15|
      DUM=-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRA(39))+&
                         ABx*(-4.D0*HRR(16)+&
                         ABz*(-4.D0*HRR(6)+&
                         2.D0*HRRA(24))+&
                         ABx*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         HRRA(29))+&
                         2.D0*HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,15_y|
      DUM=ABz*HRRB(39)+&
                         ABy*(ABz*HRRB(23)+&
                         HRRB(44))+&
                         ABx*(2.D0*ABz*HRRB(24)+&
                         ABy*(2.D0*ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABx*(ABz*HRRB(14)+&
                         ABy*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         HRRB(29))+&
                         2.D0*HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,15|
      DUM=ABz*HRRA(44)+&
                         ABx*(2.D0*ABz*HRRA(28)+&
                         ABx*(ABz*HRRA(17)+&
                         HRRA(32))+&
                         2.D0*HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,15_z|
      DUM=-HRR(23)+&
                         ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABx*(-2.D0*HRR(13)+&
                         ABz*(2.D0*ABz*HRRB(13)+&
                         4.D0*HRRB(28))+&
                         ABx*(-HRR(7)+&
                         ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(8_x,15|
      DUM=-HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRA(42))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         2.D0*HRRA(26))+&
                         ABx*(-HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(15))+&
                         HRRA(30))+&
                         2.D0*HRRA(47))+&
                         HRRA(70)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,15_x|
      DUM=-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         HRRB(42))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         3.D0*HRRB(26))+&
                         ABx*(3.D0*ABz*HRRB(15)+&
                         ABx*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,15|
      DUM=ABz*HRRA(43)+&
                         ABx*(2.D0*ABz*HRRA(27)+&
                         ABx*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         2.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,15_y|
      DUM=ABz*HRRB(43)+&
                         ABy*(ABz*HRRB(26)+&
                         HRRB(47))+&
                         ABx*(2.D0*ABz*HRRB(27)+&
                         ABy*(2.D0*ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         ABx*(ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         HRRB(31))+&
                         2.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,15|
      DUM=-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRA(47))+&
                         ABx*(-2.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         2.D0*HRRA(30))+&
                         ABx*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(18))+&
                         HRRA(33))+&
                         2.D0*HRRA(51))+&
                         HRRA(75)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,15_z|
      DUM=-HRR(26)+&
                         ABz*(ABz*HRRB(26)+&
                         2.D0*HRRB(47))+&
                         ABx*(-2.D0*HRR(15)+&
                         ABz*(2.D0*ABz*HRRB(15)+&
                         4.D0*HRRB(30))+&
                         ABx*(-HRR(8)+&
                         ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         2.D0*HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(9_x,15|
      DUM=ABz*HRRA(43)+&
                         ABx*(2.D0*ABz*HRRA(27)+&
                         ABx*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         2.D0*HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,15_x|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRB(43))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         3.D0*HRRB(27))+&
                         ABx*(3.D0*ABz*HRRB(16)+&
                         ABx*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,15|
      DUM=-HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRA(44))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         2.D0*HRRA(28))+&
                         ABx*(-HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(17))+&
                         HRRA(32))+&
                         2.D0*HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,15_y|
      DUM=ABz*HRRB(44)+&
                         ABy*(ABz*HRRB(27)+&
                         HRRB(48))+&
                         ABx*(2.D0*ABz*HRRB(28)+&
                         ABy*(2.D0*ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         ABx*(ABz*HRRB(17)+&
                         ABy*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,15|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(48))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         2.D0*HRRA(31))+&
                         ABx*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(19))+&
                         HRRA(34))+&
                         2.D0*HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,15_z|
      DUM=-HRR(27)+&
                         ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(2.D0*ABz*HRRB(16)+&
                         4.D0*HRRB(31))+&
                         ABx*(-HRR(9)+&
                         ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         HRRB(34))+&
                         2.D0*HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(10_x,15|
      DUM=ABz*HRRA(47)+&
                         ABx*(2.D0*ABz*HRRA(30)+&
                         ABx*(ABz*HRRA(18)+&
                         HRRA(33))+&
                         2.D0*HRRA(51))+&
                         HRRA(75)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,15_x|
      DUM=-2.D0*HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         HRRB(47))+&
                         ABx*(-2.D0*HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         3.D0*HRRB(30))+&
                         ABx*(3.D0*ABz*HRRB(18)+&
                         ABx*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,15|
      DUM=ABz*HRRA(48)+&
                         ABx*(2.D0*ABz*HRRA(31)+&
                         ABx*(ABz*HRRA(19)+&
                         HRRA(34))+&
                         2.D0*HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,15_y|
      DUM=ABz*HRRB(48)+&
                         ABy*(ABz*HRRB(30)+&
                         HRRB(51))+&
                         ABx*(2.D0*ABz*HRRB(31)+&
                         ABy*(2.D0*ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         ABx*(ABz*HRRB(19)+&
                         ABy*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         HRRB(34))+&
                         2.D0*HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,15|
      DUM=-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         HRRA(51))+&
                         ABx*(-4.D0*HRR(18)+&
                         ABz*(-4.D0*HRR(8)+&
                         2.D0*HRRA(33))+&
                         ABx*(-2.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         HRRA(35))+&
                         2.D0*HRRA(54))+&
                         HRRA(79)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,15_z|
      DUM=-HRR(30)+&
                         ABz*(ABz*HRRB(30)+&
                         2.D0*HRRB(51))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(2.D0*ABz*HRRB(18)+&
                         4.D0*HRRB(33))+&
                         ABx*(-HRR(10)+&
                         ABz*(ABz*HRRB(10)+&
                         2.D0*HRRB(20))+&
                         HRRB(35))+&
                         2.D0*HRRB(54))+&
                         HRRB(79)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(5_x,16|
      DUM=-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRA(37))+&
                         ABy*(-2.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         HRRA(21))+&
                         HRRA(42))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         ABy*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         HRRA(26))+&
                         HRRA(43))+&
                         HRRA(65)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,16_x|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRB(37))+&
                         ABy*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRB(21))+&
                         HRRB(42))+&
                         ABx*(2.D0*ABz*HRRB(22)+&
                         ABy*(2.D0*ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         ABx*(ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         HRRB(27))+&
                         2.D0*HRRB(43))+&
                         HRRB(65)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,16|
      DUM=ABz*HRRA(38)+&
                         ABy*(ABz*HRRA(22)+&
                         HRRA(43))+&
                         ABx*(ABz*HRRA(23)+&
                         ABy*(ABz*HRRA(12)+&
                         HRRA(27))+&
                         HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,16_y|
      DUM=-HRR(26)+&
                         ABz*(-HRR(11)+&
                         HRRB(38))+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(43))+&
                         ABx*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRB(23))+&
                         ABy*(2.D0*ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         2.D0*HRRB(27))+&
                         HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,16|
      DUM=ABz*HRRA(43)+&
                         ABy*(ABz*HRRA(26)+&
                         HRRA(47))+&
                         ABx*(ABz*HRRA(27)+&
                         ABy*(ABz*HRRA(15)+&
                         HRRA(30))+&
                         HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,16_z|
      DUM=-HRR(22)+&
                         ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABy*(-HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         ABx*(-HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABy*(-HRR(5)+&
                         ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(6_x,16|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(38))+&
                         ABy*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(22))+&
                         HRRA(43))+&
                         ABx*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         ABy*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(12))+&
                         HRRA(27))+&
                         HRRA(44))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,16_x|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRB(38))+&
                         ABy*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRB(22))+&
                         HRRB(43))+&
                         ABx*(2.D0*ABz*HRRB(23)+&
                         ABy*(2.D0*ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABx*(ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         HRRB(28))+&
                         2.D0*HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,16|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(39))+&
                         ABy*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         HRRA(44))+&
                         ABx*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(24))+&
                         ABy*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(13))+&
                         HRRA(28))+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,16_y|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRB(39))+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(44))+&
                         ABx*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRB(24))+&
                         ABy*(2.D0*ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         2.D0*HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,16|
      DUM=ABz*HRRA(44)+&
                         ABy*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         ABx*(ABz*HRRA(28)+&
                         ABy*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,16_z|
      DUM=-HRR(23)+&
                         ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABy*(-HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         ABx*(-HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABy*(-HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(7_x,16|
      DUM=ABz*HRRA(39)+&
                         ABy*(ABz*HRRA(23)+&
                         HRRA(44))+&
                         ABx*(ABz*HRRA(24)+&
                         ABy*(ABz*HRRA(13)+&
                         HRRA(28))+&
                         HRRA(45))+&
                         HRRA(67)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,16_x|
      DUM=-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRB(39))+&
                         ABy*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRB(23))+&
                         HRRB(44))+&
                         ABx*(2.D0*ABz*HRRB(24)+&
                         ABy*(2.D0*ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABx*(ABz*HRRB(14)+&
                         ABy*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         HRRB(29))+&
                         2.D0*HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,16|
      DUM=-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRA(40))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         HRRA(45))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         HRRA(25))+&
                         ABy*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         HRRA(29))+&
                         HRRA(46))+&
                         HRRA(68)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,16_y|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRB(40))+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(45))+&
                         ABx*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRB(25))+&
                         ABy*(2.D0*ABz*HRRB(14)+&
                         ABy*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         2.D0*HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,16|
      DUM=ABz*HRRA(45)+&
                         ABy*(ABz*HRRA(28)+&
                         HRRA(49))+&
                         ABx*(ABz*HRRA(29)+&
                         ABy*(ABz*HRRA(17)+&
                         HRRA(32))+&
                         HRRA(50))+&
                         HRRA(73)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,16_z|
      DUM=-HRR(24)+&
                         ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABy*(-HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         ABx*(-HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         ABy*(-HRR(7)+&
                         ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(8_x,16|
      DUM=-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRA(43))+&
                         ABy*(-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(26))+&
                         HRRA(47))+&
                         ABx*(-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         ABy*(-HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(15))+&
                         HRRA(30))+&
                         HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,16_x|
      DUM=-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRB(43))+&
                         ABy*(-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRB(26))+&
                         HRRB(47))+&
                         ABx*(2.D0*ABz*HRRB(27)+&
                         ABy*(2.D0*ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         ABx*(ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         HRRB(31))+&
                         2.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,16|
      DUM=ABz*HRRA(44)+&
                         ABy*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         ABx*(ABz*HRRA(28)+&
                         ABy*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,16_y|
      DUM=-HRR(30)+&
                         ABz*(-HRR(15)+&
                         HRRB(44))+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         ABx*(-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRB(28))+&
                         ABy*(2.D0*ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         2.D0*HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,16|
      DUM=-HRR(27)+&
                         ABz*(-HRR(12)+&
                         HRRA(48))+&
                         ABy*(-HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         HRRA(51))+&
                         ABx*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         ABy*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(18))+&
                         HRRA(33))+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,16_z|
      DUM=-HRR(27)+&
                         ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABy*(-HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         ABx*(-HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         ABy*(-HRR(8)+&
                         ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(9_x,16|
      DUM=ABz*HRRA(44)+&
                         ABy*(ABz*HRRA(27)+&
                         HRRA(48))+&
                         ABx*(ABz*HRRA(28)+&
                         ABy*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,16_x|
      DUM=-HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRB(44))+&
                         ABy*(-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRB(27))+&
                         HRRB(48))+&
                         ABx*(2.D0*ABz*HRRB(28)+&
                         ABy*(2.D0*ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         ABx*(ABz*HRRB(17)+&
                         ABy*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,16|
      DUM=-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRA(45))+&
                         ABy*(-HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         HRRA(49))+&
                         ABx*(-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(29))+&
                         ABy*(-HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(17))+&
                         HRRA(32))+&
                         HRRA(50))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,16_y|
      DUM=-HRR(31)+&
                         ABz*(-HRR(16)+&
                         HRRB(45))+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         ABx*(-HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRB(29))+&
                         ABy*(2.D0*ABz*HRRB(17)+&
                         ABy*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         2.D0*HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,16|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(49))+&
                         ABy*(-HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         HRRA(52))+&
                         ABx*(-HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         ABy*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(19))+&
                         HRRA(34))+&
                         HRRA(53))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,16_z|
      DUM=-HRR(28)+&
                         ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABy*(-HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         ABx*(-HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         ABy*(-HRR(9)+&
                         ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(10_x,16|
      DUM=ABz*HRRA(48)+&
                         ABy*(ABz*HRRA(30)+&
                         HRRA(51))+&
                         ABx*(ABz*HRRA(31)+&
                         ABy*(ABz*HRRA(18)+&
                         HRRA(33))+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,16_x|
      DUM=-HRR(34)+&
                         ABz*(-HRR(19)+&
                         HRRB(48))+&
                         ABy*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRB(30))+&
                         HRRB(51))+&
                         ABx*(2.D0*ABz*HRRB(31)+&
                         ABy*(2.D0*ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         ABx*(ABz*HRRB(19)+&
                         ABy*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         HRRB(34))+&
                         2.D0*HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,16|
      DUM=ABz*HRRA(49)+&
                         ABy*(ABz*HRRA(31)+&
                         HRRA(52))+&
                         ABx*(ABz*HRRA(32)+&
                         ABy*(ABz*HRRA(19)+&
                         HRRA(34))+&
                         HRRA(53))+&
                         HRRA(77)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,16_y|
      DUM=-HRR(33)+&
                         ABz*(-HRR(18)+&
                         HRRB(49))+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         ABx*(-HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRB(32))+&
                         ABy*(2.D0*ABz*HRRB(19)+&
                         ABy*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         2.D0*HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,16|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRA(52))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         HRRA(54))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         ABy*(-2.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         HRRA(35))+&
                         HRRA(55))+&
                         HRRA(80)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,16_z|
      DUM=-HRR(31)+&
                         ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABy*(-HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         ABx*(-HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         ABy*(-HRR(10)+&
                         ABz*(ABz*HRRB(10)+&
                         2.D0*HRRB(20))+&
                         HRRB(35))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(5_x,17|
      DUM=-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRA(38))+&
                         ABy*(-4.D0*HRR(16)+&
                         ABz*(-4.D0*HRR(6)+&
                         2.D0*HRRA(22))+&
                         ABy*(-2.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         HRRA(26))+&
                         2.D0*HRRA(43))+&
                         HRRA(66)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,17_x|
      DUM=ABz*HRRB(38)+&
                         ABy*(2.D0*ABz*HRRB(22)+&
                         ABy*(ABz*HRRB(11)+&
                         HRRB(26))+&
                         2.D0*HRRB(43))+&
                         ABx*(ABz*HRRB(23)+&
                         ABy*(2.D0*ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         2.D0*HRRB(27))+&
                         HRRB(44))+&
                         HRRB(66)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,17|
      DUM=ABz*HRRA(39)+&
                         ABy*(2.D0*ABz*HRRA(23)+&
                         ABy*(ABz*HRRA(12)+&
                         HRRA(27))+&
                         2.D0*HRRA(44))+&
                         HRRA(67)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,17_y|
      DUM=-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         HRRB(39))+&
                         ABy*(-2.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         3.D0*HRRB(23))+&
                         ABy*(3.D0*ABz*HRRB(12)+&
                         ABy*(ABz*HRRB(5)+&
                         HRRB(15))+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(44))+&
                         HRRB(67)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,17|
      DUM=ABz*HRRA(44)+&
                         ABy*(2.D0*ABz*HRRA(27)+&
                         ABy*(ABz*HRRA(15)+&
                         HRRA(30))+&
                         2.D0*HRRA(48))+&
                         HRRA(72)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,17_z|
      DUM=-HRR(23)+&
                         ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABy*(-2.D0*HRR(12)+&
                         ABz*(2.D0*ABz*HRRB(12)+&
                         4.D0*HRRB(27))+&
                         ABy*(-HRR(5)+&
                         ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         HRRB(72)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(6_x,17|
      DUM=-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRA(39))+&
                         ABy*(-2.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         2.D0*HRRA(23))+&
                         ABy*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(12))+&
                         HRRA(27))+&
                         2.D0*HRRA(44))+&
                         HRRA(67)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,17_x|
      DUM=ABz*HRRB(39)+&
                         ABy*(2.D0*ABz*HRRB(23)+&
                         ABy*(ABz*HRRB(12)+&
                         HRRB(27))+&
                         2.D0*HRRB(44))+&
                         ABx*(ABz*HRRB(24)+&
                         ABy*(2.D0*ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         2.D0*HRRB(28))+&
                         HRRB(45))+&
                         HRRB(67)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,17|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(40))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         2.D0*HRRA(24))+&
                         ABy*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(13))+&
                         HRRA(28))+&
                         2.D0*HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,17_y|
      DUM=-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         HRRB(40))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         3.D0*HRRB(24))+&
                         ABy*(3.D0*ABz*HRRB(13)+&
                         ABy*(ABz*HRRB(6)+&
                         HRRB(16))+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(45))+&
                         HRRB(68)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,17|
      DUM=ABz*HRRA(45)+&
                         ABy*(2.D0*ABz*HRRA(28)+&
                         ABy*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         2.D0*HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,17_z|
      DUM=-HRR(24)+&
                         ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABy*(-2.D0*HRR(13)+&
                         ABz*(2.D0*ABz*HRRB(13)+&
                         4.D0*HRRB(28))+&
                         ABy*(-HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         HRRB(73)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(7_x,17|
      DUM=ABz*HRRA(40)+&
                         ABy*(2.D0*ABz*HRRA(24)+&
                         ABy*(ABz*HRRA(13)+&
                         HRRA(28))+&
                         2.D0*HRRA(45))+&
                         HRRA(68)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,17_x|
      DUM=ABz*HRRB(40)+&
                         ABy*(2.D0*ABz*HRRB(24)+&
                         ABy*(ABz*HRRB(13)+&
                         HRRB(28))+&
                         2.D0*HRRB(45))+&
                         ABx*(ABz*HRRB(25)+&
                         ABy*(2.D0*ABz*HRRB(14)+&
                         ABy*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         2.D0*HRRB(29))+&
                         HRRB(46))+&
                         HRRB(68)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,17|
      DUM=-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         HRRA(41))+&
                         ABy*(-4.D0*HRR(17)+&
                         ABz*(-4.D0*HRR(7)+&
                         2.D0*HRRA(25))+&
                         ABy*(-2.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         HRRA(29))+&
                         2.D0*HRRA(46))+&
                         HRRA(69)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,17_y|
      DUM=-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         HRRB(41))+&
                         ABy*(-2.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         3.D0*HRRB(25))+&
                         ABy*(3.D0*ABz*HRRB(14)+&
                         ABy*(ABz*HRRB(7)+&
                         HRRB(17))+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(46))+&
                         HRRB(69)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,17|
      DUM=ABz*HRRA(46)+&
                         ABy*(2.D0*ABz*HRRA(29)+&
                         ABy*(ABz*HRRA(17)+&
                         HRRA(32))+&
                         2.D0*HRRA(50))+&
                         HRRA(74)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,17_z|
      DUM=-HRR(25)+&
                         ABz*(ABz*HRRB(25)+&
                         2.D0*HRRB(46))+&
                         ABy*(-2.D0*HRR(14)+&
                         ABz*(2.D0*ABz*HRRB(14)+&
                         4.D0*HRRB(29))+&
                         ABy*(-HRR(7)+&
                         ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         HRRB(32))+&
                         2.D0*HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(8_x,17|
      DUM=-HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRA(44))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         2.D0*HRRA(27))+&
                         ABy*(-HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(15))+&
                         HRRA(30))+&
                         2.D0*HRRA(48))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,17_x|
      DUM=ABz*HRRB(44)+&
                         ABy*(2.D0*ABz*HRRB(27)+&
                         ABy*(ABz*HRRB(15)+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         ABx*(ABz*HRRB(28)+&
                         ABy*(2.D0*ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         2.D0*HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,17|
      DUM=ABz*HRRA(45)+&
                         ABy*(2.D0*ABz*HRRA(28)+&
                         ABy*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         2.D0*HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,17_y|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         HRRB(45))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         3.D0*HRRB(28))+&
                         ABy*(3.D0*ABz*HRRB(16)+&
                         ABy*(ABz*HRRB(8)+&
                         HRRB(18))+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(49))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,17|
      DUM=-HRR(28)+&
                         ABz*(-HRR(13)+&
                         HRRA(49))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         2.D0*HRRA(31))+&
                         ABy*(-HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(18))+&
                         HRRA(33))+&
                         2.D0*HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,17_z|
      DUM=-HRR(28)+&
                         ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(2.D0*ABz*HRRB(16)+&
                         4.D0*HRRB(31))+&
                         ABy*(-HRR(8)+&
                         ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(9_x,17|
      DUM=ABz*HRRA(45)+&
                         ABy*(2.D0*ABz*HRRA(28)+&
                         ABy*(ABz*HRRA(16)+&
                         HRRA(31))+&
                         2.D0*HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,17_x|
      DUM=ABz*HRRB(45)+&
                         ABy*(2.D0*ABz*HRRB(28)+&
                         ABy*(ABz*HRRB(16)+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         ABx*(ABz*HRRB(29)+&
                         ABy*(2.D0*ABz*HRRB(17)+&
                         ABy*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         2.D0*HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,17|
      DUM=-HRR(32)+&
                         ABz*(-HRR(17)+&
                         HRRA(46))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         2.D0*HRRA(29))+&
                         ABy*(-HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(17))+&
                         HRRA(32))+&
                         2.D0*HRRA(50))+&
                         HRRA(74)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,17_y|
      DUM=-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         HRRB(46))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         3.D0*HRRB(29))+&
                         ABy*(3.D0*ABz*HRRB(17)+&
                         ABy*(ABz*HRRB(9)+&
                         HRRB(19))+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,17|
      DUM=-HRR(29)+&
                         ABz*(-HRR(14)+&
                         HRRA(50))+&
                         ABy*(-2.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         2.D0*HRRA(32))+&
                         ABy*(-HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(19))+&
                         HRRA(34))+&
                         2.D0*HRRA(53))+&
                         HRRA(78)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,17_z|
      DUM=-HRR(29)+&
                         ABz*(ABz*HRRB(29)+&
                         2.D0*HRRB(50))+&
                         ABy*(-2.D0*HRR(17)+&
                         ABz*(2.D0*ABz*HRRB(17)+&
                         4.D0*HRRB(32))+&
                         ABy*(-HRR(9)+&
                         ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         HRRB(34))+&
                         2.D0*HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(10_x,17|
      DUM=ABz*HRRA(49)+&
                         ABy*(2.D0*ABz*HRRA(31)+&
                         ABy*(ABz*HRRA(18)+&
                         HRRA(33))+&
                         2.D0*HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,17_x|
      DUM=ABz*HRRB(49)+&
                         ABy*(2.D0*ABz*HRRB(31)+&
                         ABy*(ABz*HRRB(18)+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         ABx*(ABz*HRRB(32)+&
                         ABy*(2.D0*ABz*HRRB(19)+&
                         ABy*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         2.D0*HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,17|
      DUM=ABz*HRRA(50)+&
                         ABy*(2.D0*ABz*HRRA(32)+&
                         ABy*(ABz*HRRA(19)+&
                         HRRA(34))+&
                         2.D0*HRRA(53))+&
                         HRRA(78)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,17_y|
      DUM=-2.D0*HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         HRRB(50))+&
                         ABy*(-2.D0*HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         3.D0*HRRB(32))+&
                         ABy*(3.D0*ABz*HRRB(19)+&
                         ABy*(ABz*HRRB(10)+&
                         HRRB(20))+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,17|
      DUM=-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         HRRA(53))+&
                         ABy*(-4.D0*HRR(19)+&
                         ABz*(-4.D0*HRR(9)+&
                         2.D0*HRRA(34))+&
                         ABy*(-2.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         HRRA(35))+&
                         2.D0*HRRA(55))+&
                         HRRA(81)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,17_z|
      DUM=-HRR(32)+&
                         ABz*(ABz*HRRB(32)+&
                         2.D0*HRRB(53))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(2.D0*ABz*HRRB(19)+&
                         4.D0*HRRB(34))+&
                         ABy*(-HRR(10)+&
                         ABz*(ABz*HRRB(10)+&
                         2.D0*HRRB(20))+&
                         HRRB(35))+&
                         2.D0*HRRB(55))+&
                         HRRB(81)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(5_x,18|
      DUM=-2.D0*HRR(30)+&
                         ABz*(-4.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         HRRA(21))+&
                         2.D0*HRRA(42))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(-4.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         2.D0*HRRA(26))+&
                         HRRA(47))+&
                         HRRA(70)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,18_x|
      DUM=-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRB(21))+&
                         2.D0*HRRB(42))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(11)+&
                         4.D0*HRRB(26))+&
                         ABx*(ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         2.D0*HRRB(47))+&
                         HRRB(70)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,18|
      DUM=ABz*(ABz*HRRA(22)+&
                         2.D0*HRRA(43))+&
                         ABx*(ABz*(ABz*HRRA(12)+&
                         2.D0*HRRA(27))+&
                         HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,18_y|
      DUM=ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABy*(ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         ABx*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABy*(ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,18|
      DUM=ABz*(ABz*HRRA(26)+&
                         2.D0*HRRA(47))+&
                         ABx*(ABz*(ABz*HRRA(15)+&
                         2.D0*HRRA(30))+&
                         HRRA(51))+&
                         HRRA(75)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,18_z|
      DUM=-2.D0*HRR(26)+&
                         ABz*(-2.D0*HRR(11)+&
                         ABz*(ABz*HRRB(11)+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(47))+&
                         ABx*(-2.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         ABz*(ABz*HRRB(5)+&
                         3.D0*HRRB(15))+&
                         3.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(6_x,18|
      DUM=-HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(22))+&
                         2.D0*HRRA(43))+&
                         ABx*(-HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(12))+&
                         2.D0*HRRA(27))+&
                         HRRA(48))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,18_x|
      DUM=-HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRB(22))+&
                         2.D0*HRRB(43))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(12)+&
                         4.D0*HRRB(27))+&
                         ABx*(ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         2.D0*HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,18|
      DUM=-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(23))+&
                         2.D0*HRRA(44))+&
                         ABx*(-HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(13))+&
                         2.D0*HRRA(28))+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,18_y|
      DUM=ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABy*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         ABx*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABy*(ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,18|
      DUM=ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         ABx*(ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,18_z|
      DUM=-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(48))+&
                         ABx*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(7_x,18|
      DUM=ABz*(ABz*HRRA(23)+&
                         2.D0*HRRA(44))+&
                         ABx*(ABz*(ABz*HRRA(13)+&
                         2.D0*HRRA(28))+&
                         HRRA(49))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,18_x|
      DUM=-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRB(23))+&
                         2.D0*HRRB(44))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(13)+&
                         4.D0*HRRB(28))+&
                         ABx*(ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         HRRB(32))+&
                         2.D0*HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,18|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(24))+&
                         2.D0*HRRA(45))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABz*(-4.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         2.D0*HRRA(29))+&
                         HRRA(50))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,18_y|
      DUM=ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABy*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         ABx*(ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         ABy*(ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,18|
      DUM=ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         ABx*(ABz*(ABz*HRRA(17)+&
                         2.D0*HRRA(32))+&
                         HRRA(53))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,18_z|
      DUM=-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(49))+&
                         ABx*(-2.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         ABz*(ABz*HRRB(7)+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(8_x,18|
      DUM=-HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(26))+&
                         2.D0*HRRA(47))+&
                         ABx*(-HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(15))+&
                         2.D0*HRRA(30))+&
                         HRRA(51))+&
                         HRRA(75)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,18_x|
      DUM=-HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRB(26))+&
                         2.D0*HRRB(47))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(15)+&
                         4.D0*HRRB(30))+&
                         ABx*(ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         2.D0*HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,18|
      DUM=ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         ABx*(ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,18_y|
      DUM=ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABy*(ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         ABx*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         ABy*(ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,18|
      DUM=-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRA(30))+&
                         2.D0*HRRA(51))+&
                         ABx*(-HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(18))+&
                         2.D0*HRRA(33))+&
                         HRRA(54))+&
                         HRRA(79)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,18_z|
      DUM=-2.D0*HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(ABz*HRRB(15)+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(51))+&
                         ABx*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(ABz*HRRB(8)+&
                         3.D0*HRRB(18))+&
                         3.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(79)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(9_x,18|
      DUM=ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         ABx*(ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         HRRA(52))+&
                         HRRA(76)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,18_x|
      DUM=-HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRB(27))+&
                         2.D0*HRRB(48))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(16)+&
                         4.D0*HRRB(31))+&
                         ABx*(ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         HRRB(34))+&
                         2.D0*HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,18|
      DUM=-HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRA(28))+&
                         2.D0*HRRA(49))+&
                         ABx*(-HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(17))+&
                         2.D0*HRRA(32))+&
                         HRRA(53))+&
                         HRRA(77)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,18_y|
      DUM=ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABy*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         ABx*(ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         ABy*(ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,18|
      DUM=-HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         2.D0*HRRA(52))+&
                         ABx*(-HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(19))+&
                         2.D0*HRRA(34))+&
                         HRRA(55))+&
                         HRRA(80)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,18_z|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(52))+&
                         ABx*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(ABz*HRRB(9)+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(10_x,18|
      DUM=ABz*(ABz*HRRA(30)+&
                         2.D0*HRRA(51))+&
                         ABx*(ABz*(ABz*HRRA(18)+&
                         2.D0*HRRA(33))+&
                         HRRA(54))+&
                         HRRA(79)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,18_x|
      DUM=-HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRB(30))+&
                         2.D0*HRRB(51))+&
                         ABx*(ABz*(2.D0*ABz*HRRB(18)+&
                         4.D0*HRRB(33))+&
                         ABx*(ABz*(ABz*HRRB(10)+&
                         2.D0*HRRB(20))+&
                         HRRB(35))+&
                         2.D0*HRRB(54))+&
                         HRRB(79)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,18|
      DUM=ABz*(ABz*HRRA(31)+&
                         2.D0*HRRA(52))+&
                         ABx*(ABz*(ABz*HRRA(19)+&
                         2.D0*HRRA(34))+&
                         HRRA(55))+&
                         HRRA(80)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,18_y|
      DUM=ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABy*(ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         ABx*(ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         ABy*(ABz*(ABz*HRRB(10)+&
                         2.D0*HRRB(20))+&
                         HRRB(35))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,18|
      DUM=-2.D0*HRR(33)+&
                         ABz*(-4.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         HRRA(33))+&
                         2.D0*HRRA(54))+&
                         ABx*(-2.D0*HRR(20)+&
                         ABz*(-4.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         2.D0*HRRA(35))+&
                         HRRA(56))+&
                         HRRA(82)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,18_z|
      DUM=-2.D0*HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(ABz*HRRB(18)+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(54))+&
                         ABx*(-2.D0*HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         ABz*(ABz*HRRB(10)+&
                         3.D0*HRRB(20))+&
                         3.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(82)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(5_x,19|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-4.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         HRRA(22))+&
                         2.D0*HRRA(43))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-4.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         2.D0*HRRA(26))+&
                         HRRA(47))+&
                         HRRA(71)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,19_x|
      DUM=ABz*(ABz*HRRB(22)+&
                         2.D0*HRRB(43))+&
                         ABy*(ABz*(ABz*HRRB(11)+&
                         2.D0*HRRB(26))+&
                         HRRB(47))+&
                         ABx*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         ABy*(ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         HRRB(48))+&
                         HRRB(71)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,19|
      DUM=ABz*(ABz*HRRA(23)+&
                         2.D0*HRRA(44))+&
                         ABy*(ABz*(ABz*HRRA(12)+&
                         2.D0*HRRA(27))+&
                         HRRA(48))+&
                         HRRA(72)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,19_y|
      DUM=-HRR(30)+&
                         ABz*(-2.D0*HRR(15)+&
                         ABz*(-HRR(5)+&
                         HRRB(23))+&
                         2.D0*HRRB(44))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(12)+&
                         4.D0*HRRB(27))+&
                         ABy*(ABz*(ABz*HRRB(5)+&
                         2.D0*HRRB(15))+&
                         HRRB(30))+&
                         2.D0*HRRB(48))+&
                         HRRB(72)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,19|
      DUM=ABz*(ABz*HRRA(27)+&
                         2.D0*HRRA(48))+&
                         ABy*(ABz*(ABz*HRRA(15)+&
                         2.D0*HRRA(30))+&
                         HRRA(51))+&
                         HRRA(76)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,19_z|
      DUM=-2.D0*HRR(27)+&
                         ABz*(-2.D0*HRR(12)+&
                         ABz*(ABz*HRRB(12)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(48))+&
                         ABy*(-2.D0*HRR(15)+&
                         ABz*(-2.D0*HRR(5)+&
                         ABz*(ABz*HRRB(5)+&
                         3.D0*HRRB(15))+&
                         3.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(76)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(6_x,19|
      DUM=-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(23))+&
                         2.D0*HRRA(44))+&
                         ABy*(-HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(12))+&
                         2.D0*HRRA(27))+&
                         HRRA(48))+&
                         HRRA(72)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,19_x|
      DUM=ABz*(ABz*HRRB(23)+&
                         2.D0*HRRB(44))+&
                         ABy*(ABz*(ABz*HRRB(12)+&
                         2.D0*HRRB(27))+&
                         HRRB(48))+&
                         ABx*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         ABy*(ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         HRRB(49))+&
                         HRRB(72)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,19|
      DUM=-HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(24))+&
                         2.D0*HRRA(45))+&
                         ABy*(-HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(13))+&
                         2.D0*HRRA(28))+&
                         HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,19_y|
      DUM=-HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRB(24))+&
                         2.D0*HRRB(45))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(13)+&
                         4.D0*HRRB(28))+&
                         ABy*(ABz*(ABz*HRRB(6)+&
                         2.D0*HRRB(16))+&
                         HRRB(31))+&
                         2.D0*HRRB(49))+&
                         HRRB(73)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,19|
      DUM=ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         ABy*(ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,19_z|
      DUM=-2.D0*HRR(28)+&
                         ABz*(-2.D0*HRR(13)+&
                         ABz*(ABz*HRRB(13)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(49))+&
                         ABy*(-2.D0*HRR(16)+&
                         ABz*(-2.D0*HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(77)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(7_x,19|
      DUM=ABz*(ABz*HRRA(24)+&
                         2.D0*HRRA(45))+&
                         ABy*(ABz*(ABz*HRRA(13)+&
                         2.D0*HRRA(28))+&
                         HRRA(49))+&
                         HRRA(73)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,19_x|
      DUM=ABz*(ABz*HRRB(24)+&
                         2.D0*HRRB(45))+&
                         ABy*(ABz*(ABz*HRRB(13)+&
                         2.D0*HRRB(28))+&
                         HRRB(49))+&
                         ABx*(ABz*(ABz*HRRB(14)+&
                         2.D0*HRRB(29))+&
                         ABy*(ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         HRRB(32))+&
                         HRRB(50))+&
                         HRRB(73)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,19|
      DUM=-2.D0*HRR(32)+&
                         ABz*(-4.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         HRRA(25))+&
                         2.D0*HRRA(46))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-4.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         2.D0*HRRA(29))+&
                         HRRA(50))+&
                         HRRA(74)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,19_y|
      DUM=-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRB(25))+&
                         2.D0*HRRB(46))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(14)+&
                         4.D0*HRRB(29))+&
                         ABy*(ABz*(ABz*HRRB(7)+&
                         2.D0*HRRB(17))+&
                         HRRB(32))+&
                         2.D0*HRRB(50))+&
                         HRRB(74)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,19|
      DUM=ABz*(ABz*HRRA(29)+&
                         2.D0*HRRA(50))+&
                         ABy*(ABz*(ABz*HRRA(17)+&
                         2.D0*HRRA(32))+&
                         HRRA(53))+&
                         HRRA(78)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,19_z|
      DUM=-2.D0*HRR(29)+&
                         ABz*(-2.D0*HRR(14)+&
                         ABz*(ABz*HRRB(14)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(50))+&
                         ABy*(-2.D0*HRR(17)+&
                         ABz*(-2.D0*HRR(7)+&
                         ABz*(ABz*HRRB(7)+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(8_x,19|
      DUM=-HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(27))+&
                         2.D0*HRRA(48))+&
                         ABy*(-HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(15))+&
                         2.D0*HRRA(30))+&
                         HRRA(51))+&
                         HRRA(76)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,19_x|
      DUM=ABz*(ABz*HRRB(27)+&
                         2.D0*HRRB(48))+&
                         ABy*(ABz*(ABz*HRRB(15)+&
                         2.D0*HRRB(30))+&
                         HRRB(51))+&
                         ABx*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         ABy*(ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,19|
      DUM=ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         ABy*(ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,19_y|
      DUM=-HRR(33)+&
                         ABz*(-2.D0*HRR(18)+&
                         ABz*(-HRR(8)+&
                         HRRB(28))+&
                         2.D0*HRRB(49))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(16)+&
                         4.D0*HRRB(31))+&
                         ABy*(ABz*(ABz*HRRB(8)+&
                         2.D0*HRRB(18))+&
                         HRRB(33))+&
                         2.D0*HRRB(52))+&
                         HRRB(77)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,19|
      DUM=-HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(-HRR(6)+&
                         HRRA(31))+&
                         2.D0*HRRA(52))+&
                         ABy*(-HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(18))+&
                         2.D0*HRRA(33))+&
                         HRRA(54))+&
                         HRRA(80)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,19_z|
      DUM=-2.D0*HRR(31)+&
                         ABz*(-2.D0*HRR(16)+&
                         ABz*(ABz*HRRB(16)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(52))+&
                         ABy*(-2.D0*HRR(18)+&
                         ABz*(-2.D0*HRR(8)+&
                         ABz*(ABz*HRRB(8)+&
                         3.D0*HRRB(18))+&
                         3.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(80)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(9_x,19|
      DUM=ABz*(ABz*HRRA(28)+&
                         2.D0*HRRA(49))+&
                         ABy*(ABz*(ABz*HRRA(16)+&
                         2.D0*HRRA(31))+&
                         HRRA(52))+&
                         HRRA(77)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,19_x|
      DUM=ABz*(ABz*HRRB(28)+&
                         2.D0*HRRB(49))+&
                         ABy*(ABz*(ABz*HRRB(16)+&
                         2.D0*HRRB(31))+&
                         HRRB(52))+&
                         ABx*(ABz*(ABz*HRRB(17)+&
                         2.D0*HRRB(32))+&
                         ABy*(ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         HRRB(34))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,19|
      DUM=-HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRA(29))+&
                         2.D0*HRRA(50))+&
                         ABy*(-HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(17))+&
                         2.D0*HRRA(32))+&
                         HRRA(53))+&
                         HRRA(78)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,19_y|
      DUM=-HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(-HRR(9)+&
                         HRRB(29))+&
                         2.D0*HRRB(50))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(17)+&
                         4.D0*HRRB(32))+&
                         ABy*(ABz*(ABz*HRRB(9)+&
                         2.D0*HRRB(19))+&
                         HRRB(34))+&
                         2.D0*HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,19|
      DUM=-HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(-HRR(7)+&
                         HRRA(32))+&
                         2.D0*HRRA(53))+&
                         ABy*(-HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(19))+&
                         2.D0*HRRA(34))+&
                         HRRA(55))+&
                         HRRA(81)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,19_z|
      DUM=-2.D0*HRR(32)+&
                         ABz*(-2.D0*HRR(17)+&
                         ABz*(ABz*HRRB(17)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(53))+&
                         ABy*(-2.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         ABz*(ABz*HRRB(9)+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(81)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(10_x,19|
      DUM=ABz*(ABz*HRRA(31)+&
                         2.D0*HRRA(52))+&
                         ABy*(ABz*(ABz*HRRA(18)+&
                         2.D0*HRRA(33))+&
                         HRRA(54))+&
                         HRRA(80)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,19_x|
      DUM=ABz*(ABz*HRRB(31)+&
                         2.D0*HRRB(52))+&
                         ABy*(ABz*(ABz*HRRB(18)+&
                         2.D0*HRRB(33))+&
                         HRRB(54))+&
                         ABx*(ABz*(ABz*HRRB(19)+&
                         2.D0*HRRB(34))+&
                         ABy*(ABz*(ABz*HRRB(10)+&
                         2.D0*HRRB(20))+&
                         HRRB(35))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,19|
      DUM=ABz*(ABz*HRRA(32)+&
                         2.D0*HRRA(53))+&
                         ABy*(ABz*(ABz*HRRA(19)+&
                         2.D0*HRRA(34))+&
                         HRRA(55))+&
                         HRRA(81)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,19_y|
      DUM=-HRR(35)+&
                         ABz*(-2.D0*HRR(20)+&
                         ABz*(-HRR(10)+&
                         HRRB(32))+&
                         2.D0*HRRB(53))+&
                         ABy*(ABz*(2.D0*ABz*HRRB(19)+&
                         4.D0*HRRB(34))+&
                         ABy*(ABz*(ABz*HRRB(10)+&
                         2.D0*HRRB(20))+&
                         HRRB(35))+&
                         2.D0*HRRB(55))+&
                         HRRB(81)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,19|
      DUM=-2.D0*HRR(34)+&
                         ABz*(-4.D0*HRR(19)+&
                         ABz*(-2.D0*HRR(9)+&
                         HRRA(34))+&
                         2.D0*HRRA(55))+&
                         ABy*(-2.D0*HRR(20)+&
                         ABz*(-4.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         2.D0*HRRA(35))+&
                         HRRA(56))+&
                         HRRA(83)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,19_z|
      DUM=-2.D0*HRR(34)+&
                         ABz*(-2.D0*HRR(19)+&
                         ABz*(ABz*HRRB(19)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(55))+&
                         ABy*(-2.D0*HRR(20)+&
                         ABz*(-2.D0*HRR(10)+&
                         ABz*(ABz*HRRB(10)+&
                         3.D0*HRRB(20))+&
                         3.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(83)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+0)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(5_x,20|
      DUM=-2.D0*HRR(33)+&
                         ABz*(-6.D0*HRR(18)+&
                         ABz*(-6.D0*HRR(8)+&
                         ABz*(-2.D0*HRR(2)+&
                         HRRA(11))+&
                         3.D0*HRRA(26))+&
                         3.D0*HRRA(47))+&
                         HRRA(75)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(5,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(11)+&
                         3.D0*HRRB(26))+&
                         3.D0*HRRB(47))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(5)+&
                         3.D0*HRRB(15))+&
                         3.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(75)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(5_y,20|
      DUM=ABz*(ABz*(ABz*HRRA(12)+&
                         3.D0*HRRA(27))+&
                         3.D0*HRRA(48))+&
                         HRRA(76)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(5,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(12)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(48))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(5)+&
                         3.D0*HRRB(15))+&
                         3.D0*HRRB(30))+&
                         HRRB(51))+&
                         HRRB(76)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(5_z,20|
      DUM=ABz*(ABz*(ABz*HRRA(15)+&
                         3.D0*HRRA(30))+&
                         3.D0*HRRA(51))+&
                         HRRA(79)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(5,20_z|
      DUM=-3.D0*HRR(30)+&
                         ABz*(-6.D0*HRR(15)+&
                         ABz*(-3.D0*HRR(5)+&
                         ABz*(ABz*HRRB(5)+&
                         4.D0*HRRB(15))+&
                         6.D0*HRRB(30))+&
                         4.D0*HRRB(51))+&
                         HRRB(79)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+1)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(6_x,20|
      DUM=-HRR(34)+&
                         ABz*(-3.D0*HRR(19)+&
                         ABz*(-3.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(12))+&
                         3.D0*HRRA(27))+&
                         3.D0*HRRA(48))+&
                         HRRA(76)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(6,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(12)+&
                         3.D0*HRRB(27))+&
                         3.D0*HRRB(48))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(6)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(76)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(6_y,20|
      DUM=-HRR(33)+&
                         ABz*(-3.D0*HRR(18)+&
                         ABz*(-3.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(13))+&
                         3.D0*HRRA(28))+&
                         3.D0*HRRA(49))+&
                         HRRA(77)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(6,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(13)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(49))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(6)+&
                         3.D0*HRRB(16))+&
                         3.D0*HRRB(31))+&
                         HRRB(52))+&
                         HRRB(77)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(6_z,20|
      DUM=ABz*(ABz*(ABz*HRRA(16)+&
                         3.D0*HRRA(31))+&
                         3.D0*HRRA(52))+&
                         HRRA(80)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(6,20_z|
      DUM=-3.D0*HRR(31)+&
                         ABz*(-6.D0*HRR(16)+&
                         ABz*(-3.D0*HRR(6)+&
                         ABz*(ABz*HRRB(6)+&
                         4.D0*HRRB(16))+&
                         6.D0*HRRB(31))+&
                         4.D0*HRRB(52))+&
                         HRRB(80)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+2)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(7_x,20|
      DUM=ABz*(ABz*(ABz*HRRA(13)+&
                         3.D0*HRRA(28))+&
                         3.D0*HRRA(49))+&
                         HRRA(77)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(7,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(13)+&
                         3.D0*HRRB(28))+&
                         3.D0*HRRB(49))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(7)+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(77)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(7_y,20|
      DUM=-2.D0*HRR(34)+&
                         ABz*(-6.D0*HRR(19)+&
                         ABz*(-6.D0*HRR(9)+&
                         ABz*(-2.D0*HRR(3)+&
                         HRRA(14))+&
                         3.D0*HRRA(29))+&
                         3.D0*HRRA(50))+&
                         HRRA(78)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(7,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(14)+&
                         3.D0*HRRB(29))+&
                         3.D0*HRRB(50))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(7)+&
                         3.D0*HRRB(17))+&
                         3.D0*HRRB(32))+&
                         HRRB(53))+&
                         HRRB(78)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(7_z,20|
      DUM=ABz*(ABz*(ABz*HRRA(17)+&
                         3.D0*HRRA(32))+&
                         3.D0*HRRA(53))+&
                         HRRA(81)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(7,20_z|
      DUM=-3.D0*HRR(32)+&
                         ABz*(-6.D0*HRR(17)+&
                         ABz*(-3.D0*HRR(7)+&
                         ABz*(ABz*HRRB(7)+&
                         4.D0*HRRB(17))+&
                         6.D0*HRRB(32))+&
                         4.D0*HRRB(53))+&
                         HRRB(81)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+3)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(8_x,20|
      DUM=-HRR(35)+&
                         ABz*(-3.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(15))+&
                         3.D0*HRRA(30))+&
                         3.D0*HRRA(51))+&
                         HRRA(79)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(8,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(15)+&
                         3.D0*HRRB(30))+&
                         3.D0*HRRB(51))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(8)+&
                         3.D0*HRRB(18))+&
                         3.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(79)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(8_y,20|
      DUM=ABz*(ABz*(ABz*HRRA(16)+&
                         3.D0*HRRA(31))+&
                         3.D0*HRRA(52))+&
                         HRRA(80)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(8,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(16)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(52))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(8)+&
                         3.D0*HRRB(18))+&
                         3.D0*HRRB(33))+&
                         HRRB(54))+&
                         HRRB(80)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(8_z,20|
      DUM=-HRR(33)+&
                         ABz*(-3.D0*HRR(18)+&
                         ABz*(-3.D0*HRR(8)+&
                         ABz*(-HRR(2)+&
                         HRRA(18))+&
                         3.D0*HRRA(33))+&
                         3.D0*HRRA(54))+&
                         HRRA(82)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(8,20_z|
      DUM=-3.D0*HRR(33)+&
                         ABz*(-6.D0*HRR(18)+&
                         ABz*(-3.D0*HRR(8)+&
                         ABz*(ABz*HRRB(8)+&
                         4.D0*HRRB(18))+&
                         6.D0*HRRB(33))+&
                         4.D0*HRRB(54))+&
                         HRRB(82)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+4)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(9_x,20|
      DUM=ABz*(ABz*(ABz*HRRA(16)+&
                         3.D0*HRRA(31))+&
                         3.D0*HRRA(52))+&
                         HRRA(80)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(9,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(16)+&
                         3.D0*HRRB(31))+&
                         3.D0*HRRB(52))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(9)+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(80)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(9_y,20|
      DUM=-HRR(35)+&
                         ABz*(-3.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         ABz*(-HRR(4)+&
                         HRRA(17))+&
                         3.D0*HRRA(32))+&
                         3.D0*HRRA(53))+&
                         HRRA(81)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(9,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(17)+&
                         3.D0*HRRB(32))+&
                         3.D0*HRRB(53))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(9)+&
                         3.D0*HRRB(19))+&
                         3.D0*HRRB(34))+&
                         HRRB(55))+&
                         HRRB(81)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(9_z,20|
      DUM=-HRR(34)+&
                         ABz*(-3.D0*HRR(19)+&
                         ABz*(-3.D0*HRR(9)+&
                         ABz*(-HRR(3)+&
                         HRRA(19))+&
                         3.D0*HRRA(34))+&
                         3.D0*HRRA(55))+&
                         HRRA(83)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(9,20_z|
      DUM=-3.D0*HRR(34)+&
                         ABz*(-6.D0*HRR(19)+&
                         ABz*(-3.D0*HRR(9)+&
                         ABz*(ABz*HRRB(9)+&
                         4.D0*HRRB(19))+&
                         6.D0*HRRB(34))+&
                         4.D0*HRRB(55))+&
                         HRRB(83)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
      OffSet=(OA+5)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(10_x,20|
      DUM=ABz*(ABz*(ABz*HRRA(18)+&
                         3.D0*HRRA(33))+&
                         3.D0*HRRA(54))+&
                         HRRA(82)
      GRADIENT(OffSet,GOA)=DUM+&
                         GRADIENT(OffSet,GOA)
      STRESS(OffSet,1)=DUM*FP(1)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(2)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(3)+&
                         STRESS(OffSet,7)
      !=(10,20_x|
      DUM=ABz*(ABz*(ABz*HRRB(18)+&
                         3.D0*HRRB(33))+&
                         3.D0*HRRB(54))+&
                         ABx*(ABz*(ABz*(ABz*HRRB(10)+&
                         3.D0*HRRB(20))+&
                         3.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(82)
      GRADIENT(OffSet,GOB)=DUM+&
                         GRADIENT(OffSet,GOB)
      STRESS(OffSet,1)=DUM*FP(7)+&
                         STRESS(OffSet,1)
      STRESS(OffSet,4)=DUM*FP(8)+&
                         STRESS(OffSet,4)
      STRESS(OffSet,7)=DUM*FP(9)+&
                         STRESS(OffSet,7)
      !=(10_y,20|
      DUM=ABz*(ABz*(ABz*HRRA(19)+&
                         3.D0*HRRA(34))+&
                         3.D0*HRRA(55))+&
                         HRRA(83)
      GRADIENT(OffSet,1 + GOA)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOA)
      STRESS(OffSet,2)=DUM*FP(1)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(2)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(3)+&
                         STRESS(OffSet,8)
      !=(10,20_y|
      DUM=ABz*(ABz*(ABz*HRRB(19)+&
                         3.D0*HRRB(34))+&
                         3.D0*HRRB(55))+&
                         ABy*(ABz*(ABz*(ABz*HRRB(10)+&
                         3.D0*HRRB(20))+&
                         3.D0*HRRB(35))+&
                         HRRB(56))+&
                         HRRB(83)
      GRADIENT(OffSet,1 + GOB)=DUM+&
                         GRADIENT(OffSet,1+&
                         GOB)
      STRESS(OffSet,2)=DUM*FP(7)+&
                         STRESS(OffSet,2)
      STRESS(OffSet,5)=DUM*FP(8)+&
                         STRESS(OffSet,5)
      STRESS(OffSet,8)=DUM*FP(9)+&
                         STRESS(OffSet,8)
      !=(10_z,20|
      DUM=-2.D0*HRR(35)+&
                         ABz*(-6.D0*HRR(20)+&
                         ABz*(-6.D0*HRR(10)+&
                         ABz*(-2.D0*HRR(4)+&
                         HRRA(20))+&
                         3.D0*HRRA(35))+&
                         3.D0*HRRA(56))+&
                         HRRA(84)
      GRADIENT(OffSet,2 + GOA)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOA)
      STRESS(OffSet,3)=DUM*FP(1)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(2)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(3)+&
                         STRESS(OffSet,9)
      !=(10,20_z|
      DUM=-3.D0*HRR(35)+&
                         ABz*(-6.D0*HRR(20)+&
                         ABz*(-3.D0*HRR(10)+&
                         ABz*(ABz*HRRB(10)+&
                         4.D0*HRRB(20))+&
                         6.D0*HRRB(35))+&
                         4.D0*HRRB(56))+&
                         HRRB(84)
      GRADIENT(OffSet,2 + GOB)=DUM+&
                         GRADIENT(OffSet,2+&
                         GOB)
      STRESS(OffSet,3)=DUM*FP(7)+&
                         STRESS(OffSet,3)
      STRESS(OffSet,6)=DUM*FP(8)+&
                         STRESS(OffSet,6)
      STRESS(OffSet,9)=DUM*FP(9)+&
                         STRESS(OffSet,9)
    END SUBROUTINE BraHRR610ab
    SUBROUTINE BraHRR610cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,Cart,HRR,GRADIENT,FP,STRESS)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT NONE
      INTEGER       :: NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,Cart,CDOffSet,OffSet
      REAL(DOUBLE)  :: HRR(*)
      REAL(DOUBLE)  :: GRADIENT(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9),FP(9),DUM
      OffSet=(OA+0)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(5,11|
      DUM=ABx*(ABx*(ABx*HRR(5)+&
                                3.D0*HRR(11))+&
                                3.D0*HRR(21))+&
                                HRR(36)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(6,11|
      DUM=ABx*(ABx*(ABx*HRR(6)+&
                                3.D0*HRR(12))+&
                                3.D0*HRR(22))+&
                                HRR(37)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(7,11|
      DUM=ABx*(ABx*(ABx*HRR(7)+&
                                3.D0*HRR(13))+&
                                3.D0*HRR(23))+&
                                HRR(38)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(8,11|
      DUM=ABx*(ABx*(ABx*HRR(8)+&
                                3.D0*HRR(15))+&
                                3.D0*HRR(26))+&
                                HRR(42)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(9,11|
      DUM=ABx*(ABx*(ABx*HRR(9)+&
                                3.D0*HRR(16))+&
                                3.D0*HRR(27))+&
                                HRR(43)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+0)*LDB+CDOffSet !=
      !=(10,11|
      DUM=ABx*(ABx*(ABx*HRR(10)+&
                                3.D0*HRR(18))+&
                                3.D0*HRR(30))+&
                                HRR(47)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(5,12|
      DUM=ABy*HRR(21)+&
                                ABx*(2.D0*ABy*HRR(11)+&
                                ABx*(ABy*HRR(5)+&
                                HRR(12))+&
                                2.D0*HRR(22))+&
                                HRR(37)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(6,12|
      DUM=ABy*HRR(22)+&
                                ABx*(2.D0*ABy*HRR(12)+&
                                ABx*(ABy*HRR(6)+&
                                HRR(13))+&
                                2.D0*HRR(23))+&
                                HRR(38)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(7,12|
      DUM=ABy*HRR(23)+&
                                ABx*(2.D0*ABy*HRR(13)+&
                                ABx*(ABy*HRR(7)+&
                                HRR(14))+&
                                2.D0*HRR(24))+&
                                HRR(39)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(8,12|
      DUM=ABy*HRR(26)+&
                                ABx*(2.D0*ABy*HRR(15)+&
                                ABx*(ABy*HRR(8)+&
                                HRR(16))+&
                                2.D0*HRR(27))+&
                                HRR(43)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(9,12|
      DUM=ABy*HRR(27)+&
                                ABx*(2.D0*ABy*HRR(16)+&
                                ABx*(ABy*HRR(9)+&
                                HRR(17))+&
                                2.D0*HRR(28))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+1)*LDB+CDOffSet !=
      !=(10,12|
      DUM=ABy*HRR(30)+&
                                ABx*(2.D0*ABy*HRR(18)+&
                                ABx*(ABy*HRR(10)+&
                                HRR(19))+&
                                2.D0*HRR(31))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(5,13|
      DUM=ABy*(ABy*HRR(11)+&
                                2.D0*HRR(22))+&
                                ABx*(ABy*(ABy*HRR(5)+&
                                2.D0*HRR(12))+&
                                HRR(23))+&
                                HRR(38)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(6,13|
      DUM=ABy*(ABy*HRR(12)+&
                                2.D0*HRR(23))+&
                                ABx*(ABy*(ABy*HRR(6)+&
                                2.D0*HRR(13))+&
                                HRR(24))+&
                                HRR(39)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(7,13|
      DUM=ABy*(ABy*HRR(13)+&
                                2.D0*HRR(24))+&
                                ABx*(ABy*(ABy*HRR(7)+&
                                2.D0*HRR(14))+&
                                HRR(25))+&
                                HRR(40)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(8,13|
      DUM=ABy*(ABy*HRR(15)+&
                                2.D0*HRR(27))+&
                                ABx*(ABy*(ABy*HRR(8)+&
                                2.D0*HRR(16))+&
                                HRR(28))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(9,13|
      DUM=ABy*(ABy*HRR(16)+&
                                2.D0*HRR(28))+&
                                ABx*(ABy*(ABy*HRR(9)+&
                                2.D0*HRR(17))+&
                                HRR(29))+&
                                HRR(45)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+2)*LDB+CDOffSet !=
      !=(10,13|
      DUM=ABy*(ABy*HRR(18)+&
                                2.D0*HRR(31))+&
                                ABx*(ABy*(ABy*HRR(10)+&
                                2.D0*HRR(19))+&
                                HRR(32))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(5,14|
      DUM=ABy*(ABy*(ABy*HRR(5)+&
                                3.D0*HRR(12))+&
                                3.D0*HRR(23))+&
                                HRR(39)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(6,14|
      DUM=ABy*(ABy*(ABy*HRR(6)+&
                                3.D0*HRR(13))+&
                                3.D0*HRR(24))+&
                                HRR(40)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(7,14|
      DUM=ABy*(ABy*(ABy*HRR(7)+&
                                3.D0*HRR(14))+&
                                3.D0*HRR(25))+&
                                HRR(41)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(8,14|
      DUM=ABy*(ABy*(ABy*HRR(8)+&
                                3.D0*HRR(16))+&
                                3.D0*HRR(28))+&
                                HRR(45)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(9,14|
      DUM=ABy*(ABy*(ABy*HRR(9)+&
                                3.D0*HRR(17))+&
                                3.D0*HRR(29))+&
                                HRR(46)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+3)*LDB+CDOffSet !=
      !=(10,14|
      DUM=ABy*(ABy*(ABy*HRR(10)+&
                                3.D0*HRR(19))+&
                                3.D0*HRR(32))+&
                                HRR(50)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(5,15|
      DUM=ABz*HRR(21)+&
                                ABx*(2.D0*ABz*HRR(11)+&
                                ABx*(ABz*HRR(5)+&
                                HRR(15))+&
                                2.D0*HRR(26))+&
                                HRR(42)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(6,15|
      DUM=ABz*HRR(22)+&
                                ABx*(2.D0*ABz*HRR(12)+&
                                ABx*(ABz*HRR(6)+&
                                HRR(16))+&
                                2.D0*HRR(27))+&
                                HRR(43)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(7,15|
      DUM=ABz*HRR(23)+&
                                ABx*(2.D0*ABz*HRR(13)+&
                                ABx*(ABz*HRR(7)+&
                                HRR(17))+&
                                2.D0*HRR(28))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(8,15|
      DUM=ABz*HRR(26)+&
                                ABx*(2.D0*ABz*HRR(15)+&
                                ABx*(ABz*HRR(8)+&
                                HRR(18))+&
                                2.D0*HRR(30))+&
                                HRR(47)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(9,15|
      DUM=ABz*HRR(27)+&
                                ABx*(2.D0*ABz*HRR(16)+&
                                ABx*(ABz*HRR(9)+&
                                HRR(19))+&
                                2.D0*HRR(31))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+4)*LDB+CDOffSet !=
      !=(10,15|
      DUM=ABz*HRR(30)+&
                                ABx*(2.D0*ABz*HRR(18)+&
                                ABx*(ABz*HRR(10)+&
                                HRR(20))+&
                                2.D0*HRR(33))+&
                                HRR(51)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(5,16|
      DUM=ABz*HRR(22)+&
                                ABy*(ABz*HRR(11)+&
                                HRR(26))+&
                                ABx*(ABz*HRR(12)+&
                                ABy*(ABz*HRR(5)+&
                                HRR(15))+&
                                HRR(27))+&
                                HRR(43)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(6,16|
      DUM=ABz*HRR(23)+&
                                ABy*(ABz*HRR(12)+&
                                HRR(27))+&
                                ABx*(ABz*HRR(13)+&
                                ABy*(ABz*HRR(6)+&
                                HRR(16))+&
                                HRR(28))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(7,16|
      DUM=ABz*HRR(24)+&
                                ABy*(ABz*HRR(13)+&
                                HRR(28))+&
                                ABx*(ABz*HRR(14)+&
                                ABy*(ABz*HRR(7)+&
                                HRR(17))+&
                                HRR(29))+&
                                HRR(45)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(8,16|
      DUM=ABz*HRR(27)+&
                                ABy*(ABz*HRR(15)+&
                                HRR(30))+&
                                ABx*(ABz*HRR(16)+&
                                ABy*(ABz*HRR(8)+&
                                HRR(18))+&
                                HRR(31))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(9,16|
      DUM=ABz*HRR(28)+&
                                ABy*(ABz*HRR(16)+&
                                HRR(31))+&
                                ABx*(ABz*HRR(17)+&
                                ABy*(ABz*HRR(9)+&
                                HRR(19))+&
                                HRR(32))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+5)*LDB+CDOffSet !=
      !=(10,16|
      DUM=ABz*HRR(31)+&
                                ABy*(ABz*HRR(18)+&
                                HRR(33))+&
                                ABx*(ABz*HRR(19)+&
                                ABy*(ABz*HRR(10)+&
                                HRR(20))+&
                                HRR(34))+&
                                HRR(52)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(5,17|
      DUM=ABz*HRR(23)+&
                                ABy*(2.D0*ABz*HRR(12)+&
                                ABy*(ABz*HRR(5)+&
                                HRR(15))+&
                                2.D0*HRR(27))+&
                                HRR(44)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(6,17|
      DUM=ABz*HRR(24)+&
                                ABy*(2.D0*ABz*HRR(13)+&
                                ABy*(ABz*HRR(6)+&
                                HRR(16))+&
                                2.D0*HRR(28))+&
                                HRR(45)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(7,17|
      DUM=ABz*HRR(25)+&
                                ABy*(2.D0*ABz*HRR(14)+&
                                ABy*(ABz*HRR(7)+&
                                HRR(17))+&
                                2.D0*HRR(29))+&
                                HRR(46)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(8,17|
      DUM=ABz*HRR(28)+&
                                ABy*(2.D0*ABz*HRR(16)+&
                                ABy*(ABz*HRR(8)+&
                                HRR(18))+&
                                2.D0*HRR(31))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(9,17|
      DUM=ABz*HRR(29)+&
                                ABy*(2.D0*ABz*HRR(17)+&
                                ABy*(ABz*HRR(9)+&
                                HRR(19))+&
                                2.D0*HRR(32))+&
                                HRR(50)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+6)*LDB+CDOffSet !=
      !=(10,17|
      DUM=ABz*HRR(32)+&
                                ABy*(2.D0*ABz*HRR(19)+&
                                ABy*(ABz*HRR(10)+&
                                HRR(20))+&
                                2.D0*HRR(34))+&
                                HRR(53)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(5,18|
      DUM=ABz*(ABz*HRR(11)+&
                                2.D0*HRR(26))+&
                                ABx*(ABz*(ABz*HRR(5)+&
                                2.D0*HRR(15))+&
                                HRR(30))+&
                                HRR(47)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(6,18|
      DUM=ABz*(ABz*HRR(12)+&
                                2.D0*HRR(27))+&
                                ABx*(ABz*(ABz*HRR(6)+&
                                2.D0*HRR(16))+&
                                HRR(31))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(7,18|
      DUM=ABz*(ABz*HRR(13)+&
                                2.D0*HRR(28))+&
                                ABx*(ABz*(ABz*HRR(7)+&
                                2.D0*HRR(17))+&
                                HRR(32))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(8,18|
      DUM=ABz*(ABz*HRR(15)+&
                                2.D0*HRR(30))+&
                                ABx*(ABz*(ABz*HRR(8)+&
                                2.D0*HRR(18))+&
                                HRR(33))+&
                                HRR(51)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(9,18|
      DUM=ABz*(ABz*HRR(16)+&
                                2.D0*HRR(31))+&
                                ABx*(ABz*(ABz*HRR(9)+&
                                2.D0*HRR(19))+&
                                HRR(34))+&
                                HRR(52)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+7)*LDB+CDOffSet !=
      !=(10,18|
      DUM=ABz*(ABz*HRR(18)+&
                                2.D0*HRR(33))+&
                                ABx*(ABz*(ABz*HRR(10)+&
                                2.D0*HRR(20))+&
                                HRR(35))+&
                                HRR(54)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(5,19|
      DUM=ABz*(ABz*HRR(12)+&
                                2.D0*HRR(27))+&
                                ABy*(ABz*(ABz*HRR(5)+&
                                2.D0*HRR(15))+&
                                HRR(30))+&
                                HRR(48)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(6,19|
      DUM=ABz*(ABz*HRR(13)+&
                                2.D0*HRR(28))+&
                                ABy*(ABz*(ABz*HRR(6)+&
                                2.D0*HRR(16))+&
                                HRR(31))+&
                                HRR(49)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(7,19|
      DUM=ABz*(ABz*HRR(14)+&
                                2.D0*HRR(29))+&
                                ABy*(ABz*(ABz*HRR(7)+&
                                2.D0*HRR(17))+&
                                HRR(32))+&
                                HRR(50)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(8,19|
      DUM=ABz*(ABz*HRR(16)+&
                                2.D0*HRR(31))+&
                                ABy*(ABz*(ABz*HRR(8)+&
                                2.D0*HRR(18))+&
                                HRR(33))+&
                                HRR(52)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(9,19|
      DUM=ABz*(ABz*HRR(17)+&
                                2.D0*HRR(32))+&
                                ABy*(ABz*(ABz*HRR(9)+&
                                2.D0*HRR(19))+&
                                HRR(34))+&
                                HRR(53)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+8)*LDB+CDOffSet !=
      !=(10,19|
      DUM=ABz*(ABz*HRR(19)+&
                                2.D0*HRR(34))+&
                                ABy*(ABz*(ABz*HRR(10)+&
                                2.D0*HRR(20))+&
                                HRR(35))+&
                                HRR(55)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+0)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(5,20|
      DUM=ABz*(ABz*(ABz*HRR(5)+&
                                3.D0*HRR(15))+&
                                3.D0*HRR(30))+&
                                HRR(51)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+1)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(6,20|
      DUM=ABz*(ABz*(ABz*HRR(6)+&
                                3.D0*HRR(16))+&
                                3.D0*HRR(31))+&
                                HRR(52)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+2)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(7,20|
      DUM=ABz*(ABz*(ABz*HRR(7)+&
                                3.D0*HRR(17))+&
                                3.D0*HRR(32))+&
                                HRR(53)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+3)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(8,20|
      DUM=ABz*(ABz*(ABz*HRR(8)+&
                                3.D0*HRR(18))+&
                                3.D0*HRR(33))+&
                                HRR(54)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+4)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(9,20|
      DUM=ABz*(ABz*(ABz*HRR(9)+&
                                3.D0*HRR(19))+&
                                3.D0*HRR(34))+&
                                HRR(55)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
      OffSet=(OA+5)*LDA+(OB+9)*LDB+CDOffSet !=
      !=(10,20|
      DUM=ABz*(ABz*(ABz*HRR(10)+&
                                3.D0*HRR(20))+&
                                3.D0*HRR(35))+&
                                HRR(56)
      GRADIENT(OffSet,Cart + GOC)=DUM+&
                                GRADIENT(OffSet,Cart+&
                                GOC)
      STRESS(OffSet,1+Cart)=DUM*FP(4)+&
                                STRESS(OffSet,1+&
                                Cart)
      STRESS(OffSet,4+Cart)=DUM*FP(5)+&
                                STRESS(OffSet,4+&
                                Cart)
      STRESS(OffSet,7+Cart)=DUM*FP(6)+&
                                STRESS(OffSet,7+&
                                Cart)
      GRADIENT(OffSet,Cart + GOD)=-GRADIENT(OffSet,Cart+GOA)&
                                -GRADIENT(OffSet,Cart+GOB)&
                                -GRADIENT(OffSet,Cart+GOC)
    END SUBROUTINE BraHRR610cd
