!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRi0j0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(36,61)
      V(2)=HfxZpE*VRR1(36,62)
      V(3)=HfxZpE*VRR1(36,68)
      V(4)=HfxZpE*VRR1(36,69)
      V(5)=HfxZpE*VRR1(36,74)
      V(6)=HfxZpE*VRR1(36,79)
      V(7)=HfxZpE*VRR1(36,80)
      V(8)=HfxZpE*VRR1(36,81)
      V(9)=HfxZpE*VRR1(36,82)
      V(10)=HfxZpE*VRR1(36,83)
      V(11)=HfxZpE*VRR1(37,60)
      V(12)=HfxZpE*VRR1(37,61)
      V(13)=HfxZpE*VRR1(37,67)
      V(14)=HfxZpE*VRR1(37,68)
      V(15)=2.D0*V(14)
      V(16)=HfxZpE*VRR1(37,73)
      V(17)=2.D0*V(16)
      V(18)=HfxZpE*VRR1(37,74)
      V(19)=HfxZpE*VRR1(37,75)
      V(20)=HfxZpE*VRR1(37,76)
      V(21)=HfxZpE*VRR1(37,77)
      V(22)=HfxZpE*VRR1(37,78)
      V(23)=HfxZpE*VRR1(37,79)
      V(24)=HfxZpE*VRR1(37,80)
      V(25)=HfxZpE*VRR1(37,81)
      V(26)=r1x2E*VRR0(59,38)
      V(27)=r1x2E*ZxZpE*VRR1(59,38)
      V(28)=r1x2E*VRR0(59,39)
      V(29)=HfxZpE*VRR1(38,60)
      V(30)=r1x2E*ZxZpE*VRR1(59,39)
      V(31)=r1x2E*VRR0(59,44)
      V(32)=3.D0*V(31)
      V(33)=r1x2E*ZxZpE*VRR1(59,44)
      V(34)=-3.D0*V(33)
      V(35)=r1x2Z*VRR0(23,96)
      V(36)=3.D0*V(35)
      V(37)=ExZpE*r1x2Z*VRR1(23,96)
      V(38)=-3.D0*V(37)
      V(39)=HfxZpE*VRR1(38,67)
      V(40)=3.D0*V(39)
      V(41)=r1x2E*VRR0(59,47)
      V(42)=r1x2E*ZxZpE*VRR1(59,47)
      V(43)=r1x2E*VRR0(59,48)
      V(44)=3.D0*V(43)
      V(45)=r1x2E*ZxZpE*VRR1(59,48)
      V(46)=-3.D0*V(45)
      V(47)=r1x2Z*VRR0(23,102)
      V(48)=3.D0*V(47)
      V(49)=ExZpE*r1x2Z*VRR1(23,102)
      V(50)=-3.D0*V(49)
      V(51)=HfxZpE*VRR1(38,72)
      V(52)=3.D0*V(51)
      V(53)=r1x2Z*VRR0(23,103)
      V(54)=3.D0*V(53)
      V(55)=ExZpE*r1x2Z*VRR1(23,103)
      V(56)=-3.D0*V(55)
      V(57)=HfxZpE*VRR1(38,73)
      V(58)=r1x2E*VRR0(59,49)
      V(59)=3.D0*V(58)
      V(60)=r1x2E*ZxZpE*VRR1(59,49)
      V(61)=-3.D0*V(60)
      V(62)=r1x2E*VRR0(59,50)
      V(63)=r1x2E*ZxZpE*VRR1(59,50)
      V(64)=r1x2E*VRR0(59,51)
      V(65)=HfxZpE*VRR1(38,75)
      V(66)=r1x2E*ZxZpE*VRR1(59,51)
      V(67)=r1x2Z*VRR0(23,107)
      V(68)=3.D0*V(67)
      V(69)=ExZpE*r1x2Z*VRR1(23,107)
      V(70)=-3.D0*V(69)
      V(71)=HfxZpE*VRR1(38,76)
      V(72)=r1x2Z*VRR0(23,108)
      V(73)=3.D0*V(72)
      V(74)=ExZpE*r1x2Z*VRR1(23,108)
      V(75)=-3.D0*V(74)
      V(76)=HfxZpE*VRR1(38,77)
      V(77)=r1x2Z*VRR0(23,109)
      V(78)=3.D0*V(77)
      V(79)=ExZpE*r1x2Z*VRR1(23,109)
      V(80)=-3.D0*V(79)
      V(81)=HfxZpE*VRR1(38,78)
      V(82)=r1x2E*VRR0(59,53)
      V(83)=r1x2E*ZxZpE*VRR1(59,53)
      V(84)=r1x2E*VRR0(60,38)
      V(85)=r1x2E*ZxZpE*VRR1(60,38)
      V(86)=r1x2E*VRR0(60,39)
      V(87)=HfxZpE*VRR1(39,60)
      V(88)=r1x2E*ZxZpE*VRR1(60,39)
      V(89)=r1x2E*VRR0(60,44)
      V(90)=3.D0*V(89)
      V(91)=HfxZpE*VRR1(39,66)
      V(92)=3.D0*V(91)
      V(93)=r1x2E*ZxZpE*VRR1(60,44)
      V(94)=-3.D0*V(93)
      V(95)=r1x2E*VRR0(60,45)
      V(96)=HfxZpE*VRR1(39,67)
      V(97)=r1x2E*ZxZpE*VRR1(60,45)
      V(98)=r1x2E*VRR0(60,47)
      V(99)=r1x2E*ZxZpE*VRR1(60,47)
      V(100)=r1x2E*VRR0(60,48)
      V(101)=3.D0*V(100)
      V(102)=HfxZpE*VRR1(39,71)
      V(103)=r1x2E*ZxZpE*VRR1(60,48)
      V(104)=-3.D0*V(103)
      V(105)=r1x2E*VRR0(60,49)
      V(106)=HfxZpE*VRR1(39,72)
      V(107)=3.D0*V(106)
      V(108)=r1x2E*ZxZpE*VRR1(60,49)
      V(109)=3.D0*V(105)
      V(110)=-3.D0*V(108)
      V(111)=r1x2E*VRR0(60,50)
      V(112)=r1x2E*ZxZpE*VRR1(60,50)
      V(113)=r1x2E*VRR0(60,51)
      V(114)=HfxZpE*VRR1(39,75)
      V(115)=r1x2E*ZxZpE*VRR1(60,51)
      V(116)=r1x2E*VRR0(60,52)
      V(117)=2.D0*V(116)
      V(118)=HfxZpE*VRR1(39,76)
      V(119)=r1x2E*ZxZpE*VRR1(60,52)
      V(120)=-2.D0*V(119)
      V(121)=r1x2E*VRR0(60,53)
      V(122)=r1x2E*ZxZpE*VRR1(60,53)
      V(123)=r1x2E*VRR0(61,38)
      V(124)=HfxZpE*VRR1(40,59)
      V(125)=r1x2E*ZxZpE*VRR1(61,38)
      V(126)=r1x2E*VRR0(61,39)
      V(127)=HfxZpE*VRR1(40,60)
      V(128)=r1x2E*ZxZpE*VRR1(61,39)
      V(129)=HfxZpE*VRR1(40,65)
      V(130)=2.D0*V(129)
      V(131)=r1x2E*VRR0(61,44)
      V(132)=3.D0*V(131)
      V(133)=HfxZpE*VRR1(40,66)
      V(134)=r1x2E*ZxZpE*VRR1(61,44)
      V(135)=-3.D0*V(134)
      V(136)=r1x2E*VRR0(61,47)
      V(137)=HfxZpE*VRR1(40,70)
      V(138)=r1x2E*ZxZpE*VRR1(61,47)
      V(139)=r1x2E*VRR0(61,48)
      V(140)=3.D0*V(139)
      V(141)=HfxZpE*VRR1(40,71)
      V(142)=2.D0*V(141)
      V(143)=r1x2E*ZxZpE*VRR1(61,48)
      V(144)=-3.D0*V(143)
      V(145)=r1x2E*VRR0(61,49)
      V(146)=3.D0*V(145)
      V(147)=r1x2E*ZxZpE*VRR1(61,49)
      V(148)=-3.D0*V(147)
      V(149)=r1x2E*VRR0(61,50)
      V(150)=r1x2E*ZxZpE*VRR1(61,50)
      V(151)=r1x2E*VRR0(61,51)
      V(152)=HfxZpE*VRR1(40,75)
      V(153)=r1x2E*ZxZpE*VRR1(61,51)
      V(154)=HfxZpE*VRR1(39,77)
      V(155)=r1x2E*VRR0(61,53)
      V(156)=HfxZpE*VRR1(39,78)
      V(157)=r1x2E*ZxZpE*VRR1(61,53)
      V(158)=HfxZpE*VRR1(41,58)
      V(159)=HfxZpE*VRR1(41,59)
      V(160)=HfxZpE*VRR1(41,64)
      V(161)=HfxZpE*VRR1(41,65)
      V(162)=HfxZpE*VRR1(41,70)
      V(163)=HfxZpE*VRR1(40,76)
      V(164)=HfxZpE*VRR1(40,77)
      V(165)=HfxZpE*VRR1(40,78)
      V(166)=HfxZpE*VRR1(40,79)
      V(167)=HfxZpE*VRR1(40,80)
      V(168)=HfxZpE*VRR1(40,81)
      V(169)=HfxZpE*VRR1(41,79)
      V(170)=HfxZpE*VRR1(41,80)
      V(171)=HfxZpE*VRR1(41,81)
      V(172)=HfxZpE*VRR1(41,82)
      V(173)=HfxZpE*VRR1(41,83)
      V(174)=HfxZpE*VRR1(42,60)
      V(175)=HfxZpE*VRR1(42,61)
      V(176)=HfxZpE*VRR1(42,67)
      V(177)=HfxZpE*VRR1(42,68)
      V(178)=HfxZpE*VRR1(42,73)
      V(179)=HfxZpE*VRR1(42,74)
      V(180)=HfxZpE*VRR1(42,75)
      V(181)=HfxZpE*VRR1(42,76)
      V(182)=HfxZpE*VRR1(42,77)
      V(183)=2.D0*V(182)
      V(184)=HfxZpE*VRR1(42,78)
      V(185)=HfxZpE*VRR1(42,79)
      V(186)=HfxZpE*VRR1(42,80)
      V(187)=2.D0*V(186)
      V(188)=HfxZpE*VRR1(42,81)
      V(189)=r1x2E*VRR0(65,38)
      V(190)=r1x2E*ZxZpE*VRR1(65,38)
      V(191)=r1x2E*VRR0(65,39)
      V(192)=HfxZpE*VRR1(43,60)
      V(193)=r1x2E*ZxZpE*VRR1(65,39)
      V(194)=r1x2E*VRR0(65,44)
      V(195)=3.D0*V(194)
      V(196)=r1x2E*ZxZpE*VRR1(65,44)
      V(197)=-3.D0*V(196)
      V(198)=HfxZpE*VRR1(43,67)
      V(199)=r1x2E*VRR0(65,47)
      V(200)=r1x2E*ZxZpE*VRR1(65,47)
      V(201)=r1x2E*VRR0(65,48)
      V(202)=3.D0*V(201)
      V(203)=r1x2E*ZxZpE*VRR1(65,48)
      V(204)=-3.D0*V(203)
      V(205)=HfxZpE*VRR1(43,72)
      V(206)=HfxZpE*VRR1(43,73)
      V(207)=2.D0*V(206)
      V(208)=r1x2E*VRR0(65,49)
      V(209)=3.D0*V(208)
      V(210)=r1x2E*ZxZpE*VRR1(65,49)
      V(211)=-3.D0*V(210)
      V(212)=r1x2E*VRR0(65,50)
      V(213)=r1x2E*ZxZpE*VRR1(65,50)
      V(214)=r1x2E*VRR0(65,51)
      V(215)=HfxZpE*VRR1(43,75)
      V(216)=r1x2E*ZxZpE*VRR1(65,51)
      V(217)=HfxZpE*VRR1(43,76)
      V(218)=HfxZpE*VRR1(43,77)
      V(219)=2.D0*V(218)
      V(220)=HfxZpE*VRR1(43,78)
      V(221)=r1x2E*VRR0(65,53)
      V(222)=r1x2E*ZxZpE*VRR1(65,53)
      V(223)=r1x2E*VRR0(66,38)
      V(224)=r1x2E*ZxZpE*VRR1(66,38)
      V(225)=r1x2E*VRR0(66,39)
      V(226)=HfxZpE*VRR1(44,60)
      V(227)=3.D0*V(226)
      V(228)=r1x2E*ZxZpE*VRR1(66,39)
      V(229)=r1x2E*VRR0(66,44)
      V(230)=3.D0*V(229)
      V(231)=r1x2E*ZxZpE*VRR1(66,44)
      V(232)=-3.D0*V(231)
      V(233)=r1x2E*VRR0(66,45)
      V(234)=HfxZpE*VRR1(44,67)
      V(235)=3.D0*V(234)
      V(236)=r1x2E*ZxZpE*VRR1(66,45)
      V(237)=r1x2E*VRR0(66,47)
      V(238)=r1x2E*ZxZpE*VRR1(66,47)
      V(239)=r1x2E*VRR0(66,48)
      V(240)=3.D0*V(239)
      V(241)=r1x2E*ZxZpE*VRR1(66,48)
      V(242)=-3.D0*V(241)
      V(243)=r1x2E*VRR0(66,49)
      V(244)=HfxZpE*VRR1(44,72)
      V(245)=3.D0*V(244)
      V(246)=r1x2E*ZxZpE*VRR1(66,49)
      V(247)=2.D0*V(205)
      V(248)=3.D0*V(243)
      V(249)=-3.D0*V(246)
      V(250)=r1x2E*VRR0(66,50)
      V(251)=r1x2E*ZxZpE*VRR1(66,50)
      V(252)=r1x2E*VRR0(66,51)
      V(253)=HfxZpE*VRR1(44,75)
      V(254)=r1x2E*ZxZpE*VRR1(66,51)
      V(255)=r1x2E*VRR0(66,52)
      V(256)=2.D0*V(255)
      V(257)=HfxZpE*VRR1(44,76)
      V(258)=r1x2E*ZxZpE*VRR1(66,52)
      V(259)=-2.D0*V(258)
      V(260)=r1x2E*VRR0(66,53)
      V(261)=2.D0*V(220)
      V(262)=r1x2E*ZxZpE*VRR1(66,53)
      V(263)=r1x2E*VRR0(67,38)
      V(264)=r1x2E*ZxZpE*VRR1(67,38)
      V(265)=r1x2E*VRR0(67,39)
      V(266)=HfxZpE*VRR1(45,60)
      V(267)=r1x2E*ZxZpE*VRR1(67,39)
      V(268)=r1x2E*VRR0(67,44)
      V(269)=3.D0*V(268)
      V(270)=HfxZpE*VRR1(45,66)
      V(271)=r1x2E*ZxZpE*VRR1(67,44)
      V(272)=-3.D0*V(271)
      V(273)=r1x2E*VRR0(67,45)
      V(274)=HfxZpE*VRR1(45,67)
      V(275)=r1x2E*ZxZpE*VRR1(67,45)
      V(276)=r1x2E*VRR0(67,47)
      V(277)=r1x2E*ZxZpE*VRR1(67,47)
      V(278)=r1x2E*VRR0(67,48)
      V(279)=3.D0*V(278)
      V(280)=HfxZpE*VRR1(45,71)
      V(281)=2.D0*V(280)
      V(282)=r1x2E*ZxZpE*VRR1(67,48)
      V(283)=-3.D0*V(282)
      V(284)=r1x2E*VRR0(67,49)
      V(285)=HfxZpE*VRR1(45,72)
      V(286)=2.D0*V(285)
      V(287)=r1x2E*ZxZpE*VRR1(67,49)
      V(288)=3.D0*V(284)
      V(289)=-3.D0*V(287)
      V(290)=r1x2E*VRR0(67,50)
      V(291)=r1x2E*ZxZpE*VRR1(67,50)
      V(292)=r1x2E*VRR0(67,51)
      V(293)=HfxZpE*VRR1(45,75)
      V(294)=2.D0*V(293)
      V(295)=r1x2E*ZxZpE*VRR1(67,51)
      V(296)=r1x2E*VRR0(67,52)
      V(297)=2.D0*V(296)
      V(298)=HfxZpE*VRR1(45,76)
      V(299)=2.D0*V(298)
      V(300)=r1x2E*ZxZpE*VRR1(67,52)
      V(301)=-2.D0*V(300)
      V(302)=HfxZpE*VRR1(44,77)
      V(303)=r1x2E*VRR0(67,53)
      V(304)=HfxZpE*VRR1(44,78)
      V(305)=r1x2E*ZxZpE*VRR1(67,53)
      V(306)=r1x2E*VRR0(68,38)
      V(307)=HfxZpE*VRR1(46,59)
      V(308)=r1x2E*ZxZpE*VRR1(68,38)
      V(309)=r1x2E*VRR0(68,39)
      V(310)=HfxZpE*VRR1(46,60)
      V(311)=r1x2E*ZxZpE*VRR1(68,39)
      V(312)=HfxZpE*VRR1(46,65)
      V(313)=r1x2E*VRR0(68,44)
      V(314)=3.D0*V(313)
      V(315)=HfxZpE*VRR1(46,66)
      V(316)=r1x2E*ZxZpE*VRR1(68,44)
      V(317)=-3.D0*V(316)
      V(318)=r1x2E*VRR0(68,47)
      V(319)=HfxZpE*VRR1(46,70)
      V(320)=r1x2E*ZxZpE*VRR1(68,47)
      V(321)=r1x2E*VRR0(68,48)
      V(322)=3.D0*V(321)
      V(323)=HfxZpE*VRR1(46,71)
      V(324)=r1x2E*ZxZpE*VRR1(68,48)
      V(325)=-3.D0*V(324)
      V(326)=r1x2E*VRR0(68,49)
      V(327)=3.D0*V(326)
      V(328)=r1x2E*ZxZpE*VRR1(68,49)
      V(329)=-3.D0*V(328)
      V(330)=r1x2E*VRR0(68,50)
      V(331)=r1x2E*ZxZpE*VRR1(68,50)
      V(332)=r1x2E*VRR0(68,51)
      V(333)=HfxZpE*VRR1(46,75)
      V(334)=r1x2E*ZxZpE*VRR1(68,51)
      V(335)=HfxZpE*VRR1(45,77)
      V(336)=r1x2E*VRR0(68,53)
      V(337)=HfxZpE*VRR1(45,78)
      V(338)=r1x2E*ZxZpE*VRR1(68,53)
      V(339)=HfxZpE*VRR1(46,76)
      V(340)=2.D0*V(339)
      V(341)=HfxZpE*VRR1(46,77)
      V(342)=HfxZpE*VRR1(46,78)
      V(343)=HfxZpE*VRR1(46,79)
      V(344)=HfxZpE*VRR1(46,80)
      V(345)=2.D0*V(344)
      V(346)=HfxZpE*VRR1(46,81)
      V(347)=r1x2E*VRR0(70,38)
      V(348)=r1x2E*ZxZpE*VRR1(70,38)
      V(349)=r1x2E*VRR0(70,39)
      V(350)=HfxZpE*VRR1(47,60)
      V(351)=r1x2E*ZxZpE*VRR1(70,39)
      V(352)=r1x2E*VRR0(70,44)
      V(353)=3.D0*V(352)
      V(354)=r1x2E*ZxZpE*VRR1(70,44)
      V(355)=-3.D0*V(354)
      V(356)=r1x2Z*VRR0(30,96)
      V(357)=3.D0*V(356)
      V(358)=ExZpE*r1x2Z*VRR1(30,96)
      V(359)=-3.D0*V(358)
      V(360)=HfxZpE*VRR1(47,67)
      V(361)=r1x2E*VRR0(70,47)
      V(362)=r1x2E*ZxZpE*VRR1(70,47)
      V(363)=r1x2E*VRR0(70,48)
      V(364)=3.D0*V(363)
      V(365)=r1x2E*ZxZpE*VRR1(70,48)
      V(366)=-3.D0*V(365)
      V(367)=r1x2Z*VRR0(30,102)
      V(368)=3.D0*V(367)
      V(369)=ExZpE*r1x2Z*VRR1(30,102)
      V(370)=-3.D0*V(369)
      V(371)=HfxZpE*VRR1(47,72)
      V(372)=3.D0*V(371)
      V(373)=r1x2Z*VRR0(30,103)
      V(374)=3.D0*V(373)
      V(375)=ExZpE*r1x2Z*VRR1(30,103)
      V(376)=-3.D0*V(375)
      V(377)=HfxZpE*VRR1(47,73)
      V(378)=r1x2E*VRR0(70,49)
      V(379)=3.D0*V(378)
      V(380)=r1x2E*ZxZpE*VRR1(70,49)
      V(381)=-3.D0*V(380)
      V(382)=r1x2E*VRR0(70,50)
      V(383)=r1x2E*ZxZpE*VRR1(70,50)
      V(384)=r1x2E*VRR0(70,51)
      V(385)=HfxZpE*VRR1(47,75)
      V(386)=r1x2E*ZxZpE*VRR1(70,51)
      V(387)=r1x2Z*VRR0(30,107)
      V(388)=3.D0*V(387)
      V(389)=ExZpE*r1x2Z*VRR1(30,107)
      V(390)=-3.D0*V(389)
      V(391)=HfxZpE*VRR1(47,76)
      V(392)=3.D0*V(391)
      V(393)=r1x2Z*VRR0(30,108)
      V(394)=3.D0*V(393)
      V(395)=ExZpE*r1x2Z*VRR1(30,108)
      V(396)=-3.D0*V(395)
      V(397)=HfxZpE*VRR1(47,77)
      V(398)=r1x2Z*VRR0(30,109)
      V(399)=3.D0*V(398)
      V(400)=ExZpE*r1x2Z*VRR1(30,109)
      V(401)=-3.D0*V(400)
      V(402)=HfxZpE*VRR1(47,78)
      V(403)=r1x2E*VRR0(70,53)
      V(404)=r1x2E*ZxZpE*VRR1(70,53)
      V(405)=r1x2E*VRR0(71,38)
      V(406)=r1x2E*ZxZpE*VRR1(71,38)
      V(407)=r1x2E*VRR0(71,39)
      V(408)=HfxZpE*VRR1(48,60)
      V(409)=r1x2E*ZxZpE*VRR1(71,39)
      V(410)=r1x2E*VRR0(71,44)
      V(411)=3.D0*V(410)
      V(412)=r1x2E*ZxZpE*VRR1(71,44)
      V(413)=-3.D0*V(412)
      V(414)=r1x2E*VRR0(71,45)
      V(415)=HfxZpE*VRR1(48,67)
      V(416)=r1x2E*ZxZpE*VRR1(71,45)
      V(417)=r1x2E*VRR0(71,47)
      V(418)=r1x2E*ZxZpE*VRR1(71,47)
      V(419)=r1x2E*VRR0(71,48)
      V(420)=3.D0*V(419)
      V(421)=r1x2E*ZxZpE*VRR1(71,48)
      V(422)=-3.D0*V(421)
      V(423)=r1x2E*VRR0(71,49)
      V(424)=HfxZpE*VRR1(48,72)
      V(425)=3.D0*V(424)
      V(426)=r1x2E*ZxZpE*VRR1(71,49)
      V(427)=3.D0*V(423)
      V(428)=-3.D0*V(426)
      V(429)=r1x2E*VRR0(71,50)
      V(430)=r1x2E*ZxZpE*VRR1(71,50)
      V(431)=r1x2E*VRR0(71,51)
      V(432)=HfxZpE*VRR1(48,75)
      V(433)=3.D0*V(432)
      V(434)=r1x2E*ZxZpE*VRR1(71,51)
      V(435)=r1x2E*VRR0(71,52)
      V(436)=2.D0*V(435)
      V(437)=HfxZpE*VRR1(48,76)
      V(438)=3.D0*V(437)
      V(439)=r1x2E*ZxZpE*VRR1(71,52)
      V(440)=-2.D0*V(439)
      V(441)=r1x2E*VRR0(71,53)
      V(442)=r1x2E*ZxZpE*VRR1(71,53)
      V(443)=r1x2E*VRR0(72,38)
      V(444)=r1x2E*ZxZpE*VRR1(72,38)
      V(445)=r1x2E*VRR0(72,39)
      V(446)=HfxZpE*VRR1(49,60)
      V(447)=r1x2E*ZxZpE*VRR1(72,39)
      V(448)=r1x2E*VRR0(72,44)
      V(449)=3.D0*V(448)
      V(450)=r1x2E*ZxZpE*VRR1(72,44)
      V(451)=-3.D0*V(450)
      V(452)=r1x2E*VRR0(72,45)
      V(453)=HfxZpE*VRR1(49,67)
      V(454)=r1x2E*ZxZpE*VRR1(72,45)
      V(455)=r1x2E*VRR0(72,47)
      V(456)=r1x2E*ZxZpE*VRR1(72,47)
      V(457)=r1x2E*VRR0(72,48)
      V(458)=3.D0*V(457)
      V(459)=r1x2E*ZxZpE*VRR1(72,48)
      V(460)=-3.D0*V(459)
      V(461)=r1x2E*VRR0(72,49)
      V(462)=HfxZpE*VRR1(49,72)
      V(463)=r1x2E*ZxZpE*VRR1(72,49)
      V(464)=3.D0*V(461)
      V(465)=-3.D0*V(463)
      V(466)=r1x2E*VRR0(72,50)
      V(467)=r1x2E*ZxZpE*VRR1(72,50)
      V(468)=r1x2E*VRR0(72,51)
      V(469)=HfxZpE*VRR1(49,75)
      V(470)=r1x2E*ZxZpE*VRR1(72,51)
      V(471)=r1x2E*VRR0(72,52)
      V(472)=2.D0*V(471)
      V(473)=HfxZpE*VRR1(49,76)
      V(474)=r1x2E*ZxZpE*VRR1(72,52)
      V(475)=-2.D0*V(474)
      V(476)=HfxZpE*VRR1(48,77)
      V(477)=r1x2E*VRR0(72,53)
      V(478)=HfxZpE*VRR1(48,78)
      V(479)=r1x2E*ZxZpE*VRR1(72,53)
      V(480)=r1x2E*VRR0(73,38)
      V(481)=r1x2E*ZxZpE*VRR1(73,38)
      V(482)=r1x2E*VRR0(73,39)
      V(483)=HfxZpE*VRR1(50,60)
      V(484)=r1x2E*ZxZpE*VRR1(73,39)
      V(485)=r1x2E*VRR0(73,44)
      V(486)=3.D0*V(485)
      V(487)=HfxZpE*VRR1(50,66)
      V(488)=r1x2E*ZxZpE*VRR1(73,44)
      V(489)=-3.D0*V(488)
      V(490)=r1x2E*VRR0(73,45)
      V(491)=HfxZpE*VRR1(50,67)
      V(492)=r1x2E*ZxZpE*VRR1(73,45)
      V(493)=r1x2E*VRR0(73,47)
      V(494)=r1x2E*ZxZpE*VRR1(73,47)
      V(495)=r1x2E*VRR0(73,48)
      V(496)=3.D0*V(495)
      V(497)=HfxZpE*VRR1(50,71)
      V(498)=r1x2E*ZxZpE*VRR1(73,48)
      V(499)=-3.D0*V(498)
      V(500)=r1x2E*VRR0(73,49)
      V(501)=HfxZpE*VRR1(50,72)
      V(502)=r1x2E*ZxZpE*VRR1(73,49)
      V(503)=3.D0*V(462)
      V(504)=3.D0*V(500)
      V(505)=-3.D0*V(502)
      V(506)=r1x2E*VRR0(73,50)
      V(507)=r1x2E*ZxZpE*VRR1(73,50)
      V(508)=r1x2E*VRR0(73,51)
      V(509)=HfxZpE*VRR1(50,75)
      V(510)=r1x2E*ZxZpE*VRR1(73,51)
      V(511)=r1x2E*VRR0(73,52)
      V(512)=2.D0*V(511)
      V(513)=HfxZpE*VRR1(50,76)
      V(514)=r1x2E*ZxZpE*VRR1(73,52)
      V(515)=-2.D0*V(514)
      V(516)=HfxZpE*VRR1(49,77)
      V(517)=3.D0*V(516)
      V(518)=r1x2E*VRR0(73,53)
      V(519)=HfxZpE*VRR1(49,78)
      V(520)=3.D0*V(519)
      V(521)=r1x2E*ZxZpE*VRR1(73,53)
      V(522)=r1x2E*VRR0(74,38)
      V(523)=r1x2E*ZxZpE*VRR1(74,38)
      V(524)=r1x2E*VRR0(74,39)
      V(525)=r1x2E*ZxZpE*VRR1(74,39)
      V(526)=r1x2E*VRR0(74,44)
      V(527)=3.D0*V(526)
      V(528)=r1x2E*ZxZpE*VRR1(74,44)
      V(529)=-3.D0*V(528)
      V(530)=r1x2Z*VRR0(32,96)
      V(531)=3.D0*V(530)
      V(532)=ExZpE*r1x2Z*VRR1(32,96)
      V(533)=-3.D0*V(532)
      V(534)=r1x2E*VRR0(74,47)
      V(535)=r1x2E*ZxZpE*VRR1(74,47)
      V(536)=r1x2E*VRR0(74,48)
      V(537)=3.D0*V(536)
      V(538)=r1x2E*ZxZpE*VRR1(74,48)
      V(539)=-3.D0*V(538)
      V(540)=r1x2Z*VRR0(32,102)
      V(541)=3.D0*V(540)
      V(542)=ExZpE*r1x2Z*VRR1(32,102)
      V(543)=-3.D0*V(542)
      V(544)=r1x2Z*VRR0(32,103)
      V(545)=3.D0*V(544)
      V(546)=ExZpE*r1x2Z*VRR1(32,103)
      V(547)=-3.D0*V(546)
      V(548)=3.D0*V(501)
      V(549)=r1x2E*VRR0(74,49)
      V(550)=3.D0*V(549)
      V(551)=r1x2E*ZxZpE*VRR1(74,49)
      V(552)=-3.D0*V(551)
      V(553)=r1x2E*VRR0(74,50)
      V(554)=r1x2E*ZxZpE*VRR1(74,50)
      V(555)=r1x2E*VRR0(74,51)
      V(556)=r1x2E*ZxZpE*VRR1(74,51)
      V(557)=r1x2Z*VRR0(32,107)
      V(558)=3.D0*V(557)
      V(559)=ExZpE*r1x2Z*VRR1(32,107)
      V(560)=-3.D0*V(559)
      V(561)=r1x2Z*VRR0(32,108)
      V(562)=3.D0*V(561)
      V(563)=ExZpE*r1x2Z*VRR1(32,108)
      V(564)=-3.D0*V(563)
      V(565)=r1x2Z*VRR0(32,109)
      V(566)=3.D0*V(565)
      V(567)=ExZpE*r1x2Z*VRR1(32,109)
      V(568)=-3.D0*V(567)
      V(569)=HfxZpE*VRR1(50,77)
      V(570)=3.D0*V(569)
      V(571)=r1x2E*VRR0(74,53)
      V(572)=HfxZpE*VRR1(50,78)
      V(573)=r1x2E*ZxZpE*VRR1(74,53)
      V(574)=r1x2E*VRR0(75,38)
      V(575)=r1x2E*ZxZpE*VRR1(75,38)
      V(576)=r1x2E*VRR0(75,39)
      V(577)=HfxZpE*VRR1(51,60)
      V(578)=r1x2E*ZxZpE*VRR1(75,39)
      V(579)=r1x2E*VRR0(75,44)
      V(580)=3.D0*V(579)
      V(581)=HfxZpE*VRR1(51,66)
      V(582)=r1x2E*ZxZpE*VRR1(75,44)
      V(583)=-3.D0*V(582)
      V(584)=r1x2E*VRR0(75,45)
      V(585)=HfxZpE*VRR1(51,67)
      V(586)=r1x2E*ZxZpE*VRR1(75,45)
      V(587)=r1x2E*VRR0(75,47)
      V(588)=r1x2E*ZxZpE*VRR1(75,47)
      V(589)=r1x2E*VRR0(75,48)
      V(590)=3.D0*V(589)
      V(591)=HfxZpE*VRR1(51,71)
      V(592)=3.D0*V(591)
      V(593)=r1x2E*ZxZpE*VRR1(75,48)
      V(594)=-3.D0*V(593)
      V(595)=r1x2E*VRR0(75,49)
      V(596)=HfxZpE*VRR1(51,72)
      V(597)=3.D0*V(596)
      V(598)=r1x2E*ZxZpE*VRR1(75,49)
      V(599)=3.D0*V(595)
      V(600)=-3.D0*V(598)
      V(601)=r1x2E*VRR0(75,50)
      V(602)=r1x2E*ZxZpE*VRR1(75,50)
      V(603)=r1x2E*VRR0(75,51)
      V(604)=HfxZpE*VRR1(51,75)
      V(605)=r1x2E*ZxZpE*VRR1(75,51)
      V(606)=r1x2E*VRR0(75,52)
      V(607)=2.D0*V(606)
      V(608)=HfxZpE*VRR1(51,76)
      V(609)=r1x2E*ZxZpE*VRR1(75,52)
      V(610)=-2.D0*V(609)
      V(611)=r1x2E*VRR0(75,53)
      V(612)=r1x2E*ZxZpE*VRR1(75,53)
      V(613)=r1x2E*VRR0(76,38)
      V(614)=r1x2E*ZxZpE*VRR1(76,38)
      V(615)=r1x2E*VRR0(76,39)
      V(616)=HfxZpE*VRR1(52,60)
      V(617)=2.D0*V(616)
      V(618)=r1x2E*ZxZpE*VRR1(76,39)
      V(619)=r1x2E*VRR0(76,44)
      V(620)=3.D0*V(619)
      V(621)=HfxZpE*VRR1(52,66)
      V(622)=2.D0*V(621)
      V(623)=r1x2E*ZxZpE*VRR1(76,44)
      V(624)=-3.D0*V(623)
      V(625)=r1x2E*VRR0(76,45)
      V(626)=HfxZpE*VRR1(52,67)
      V(627)=2.D0*V(626)
      V(628)=r1x2E*ZxZpE*VRR1(76,45)
      V(629)=r1x2E*VRR0(76,47)
      V(630)=r1x2E*ZxZpE*VRR1(76,47)
      V(631)=r1x2E*VRR0(76,48)
      V(632)=3.D0*V(631)
      V(633)=HfxZpE*VRR1(52,71)
      V(634)=r1x2E*ZxZpE*VRR1(76,48)
      V(635)=-3.D0*V(634)
      V(636)=r1x2E*VRR0(76,49)
      V(637)=HfxZpE*VRR1(52,72)
      V(638)=2.D0*V(637)
      V(639)=r1x2E*ZxZpE*VRR1(76,49)
      V(640)=3.D0*V(636)
      V(641)=HfxZpE*VRR1(51,73)
      V(642)=-3.D0*V(639)
      V(643)=r1x2E*VRR0(76,50)
      V(644)=r1x2E*ZxZpE*VRR1(76,50)
      V(645)=r1x2E*VRR0(76,51)
      V(646)=HfxZpE*VRR1(52,75)
      V(647)=r1x2E*ZxZpE*VRR1(76,51)
      V(648)=r1x2E*VRR0(76,52)
      V(649)=2.D0*V(648)
      V(650)=HfxZpE*VRR1(52,76)
      V(651)=r1x2E*ZxZpE*VRR1(76,52)
      V(652)=-2.D0*V(651)
      V(653)=HfxZpE*VRR1(51,77)
      V(654)=r1x2E*VRR0(76,53)
      V(655)=HfxZpE*VRR1(51,78)
      V(656)=r1x2E*ZxZpE*VRR1(76,53)
      V(657)=r1x2E*VRR0(77,38)
      V(658)=r1x2E*ZxZpE*VRR1(77,38)
      V(659)=r1x2E*VRR0(77,39)
      V(660)=HfxZpE*VRR1(53,60)
      V(661)=r1x2E*ZxZpE*VRR1(77,39)
      V(662)=r1x2E*VRR0(77,44)
      V(663)=3.D0*V(662)
      V(664)=HfxZpE*VRR1(53,66)
      V(665)=r1x2E*ZxZpE*VRR1(77,44)
      V(666)=-3.D0*V(665)
      V(667)=r1x2E*VRR0(77,45)
      V(668)=HfxZpE*VRR1(53,67)
      V(669)=r1x2E*ZxZpE*VRR1(77,45)
      V(670)=r1x2E*VRR0(77,47)
      V(671)=r1x2E*ZxZpE*VRR1(77,47)
      V(672)=r1x2E*VRR0(77,48)
      V(673)=3.D0*V(672)
      V(674)=HfxZpE*VRR1(53,71)
      V(675)=r1x2E*ZxZpE*VRR1(77,48)
      V(676)=-3.D0*V(675)
      V(677)=r1x2E*VRR0(77,49)
      V(678)=HfxZpE*VRR1(53,72)
      V(679)=r1x2E*ZxZpE*VRR1(77,49)
      V(680)=3.D0*V(677)
      V(681)=HfxZpE*VRR1(52,73)
      V(682)=-3.D0*V(679)
      V(683)=r1x2E*VRR0(77,50)
      V(684)=r1x2E*ZxZpE*VRR1(77,50)
      V(685)=r1x2E*VRR0(77,51)
      V(686)=HfxZpE*VRR1(53,75)
      V(687)=r1x2E*ZxZpE*VRR1(77,51)
      V(688)=r1x2E*VRR0(77,52)
      V(689)=2.D0*V(688)
      V(690)=HfxZpE*VRR1(53,76)
      V(691)=r1x2E*ZxZpE*VRR1(77,52)
      V(692)=-2.D0*V(691)
      V(693)=HfxZpE*VRR1(52,77)
      V(694)=r1x2E*VRR0(77,53)
      V(695)=HfxZpE*VRR1(52,78)
      V(696)=r1x2E*ZxZpE*VRR1(77,53)
      V(697)=r1x2E*VRR0(78,38)
      V(698)=r1x2E*ZxZpE*VRR1(78,38)
      V(699)=r1x2E*VRR0(78,39)
      V(700)=r1x2E*ZxZpE*VRR1(78,39)
      V(701)=r1x2E*VRR0(78,44)
      V(702)=3.D0*V(701)
      V(703)=r1x2E*ZxZpE*VRR1(78,44)
      V(704)=-3.D0*V(703)
      V(705)=r1x2E*VRR0(78,45)
      V(706)=r1x2E*ZxZpE*VRR1(78,45)
      V(707)=r1x2E*VRR0(78,47)
      V(708)=r1x2E*ZxZpE*VRR1(78,47)
      V(709)=r1x2E*VRR0(78,48)
      V(710)=3.D0*V(709)
      V(711)=r1x2E*ZxZpE*VRR1(78,48)
      V(712)=-3.D0*V(711)
      V(713)=r1x2E*VRR0(78,49)
      V(714)=r1x2E*ZxZpE*VRR1(78,49)
      V(715)=3.D0*V(678)
      V(716)=3.D0*V(713)
      V(717)=HfxZpE*VRR1(53,73)
      V(718)=3.D0*V(717)
      V(719)=-3.D0*V(714)
      V(720)=r1x2E*VRR0(78,50)
      V(721)=r1x2E*ZxZpE*VRR1(78,50)
      V(722)=r1x2E*VRR0(78,51)
      V(723)=r1x2E*ZxZpE*VRR1(78,51)
      V(724)=r1x2E*VRR0(78,52)
      V(725)=2.D0*V(724)
      V(726)=r1x2E*ZxZpE*VRR1(78,52)
      V(727)=-2.D0*V(726)
      V(728)=HfxZpE*VRR1(53,77)
      V(729)=r1x2E*VRR0(78,53)
      V(730)=HfxZpE*VRR1(53,78)
      V(731)=r1x2E*ZxZpE*VRR1(78,53)
      V(732)=r1x2E*VRR0(79,38)
      V(733)=HfxZpE*VRR1(54,59)
      V(734)=r1x2E*ZxZpE*VRR1(79,38)
      V(735)=r1x2E*VRR0(79,39)
      V(736)=HfxZpE*VRR1(54,60)
      V(737)=r1x2E*ZxZpE*VRR1(79,39)
      V(738)=HfxZpE*VRR1(54,65)
      V(739)=2.D0*V(738)
      V(740)=r1x2E*VRR0(79,44)
      V(741)=3.D0*V(740)
      V(742)=HfxZpE*VRR1(54,66)
      V(743)=2.D0*V(742)
      V(744)=r1x2E*ZxZpE*VRR1(79,44)
      V(745)=-3.D0*V(744)
      V(746)=r1x2E*VRR0(79,47)
      V(747)=HfxZpE*VRR1(54,70)
      V(748)=r1x2E*ZxZpE*VRR1(79,47)
      V(749)=r1x2E*VRR0(79,48)
      V(750)=3.D0*V(749)
      V(751)=HfxZpE*VRR1(54,71)
      V(752)=r1x2E*ZxZpE*VRR1(79,48)
      V(753)=-3.D0*V(752)
      V(754)=r1x2E*VRR0(79,49)
      V(755)=3.D0*V(754)
      V(756)=r1x2E*ZxZpE*VRR1(79,49)
      V(757)=-3.D0*V(756)
      V(758)=r1x2E*VRR0(79,50)
      V(759)=r1x2E*ZxZpE*VRR1(79,50)
      V(760)=r1x2E*VRR0(79,51)
      V(761)=HfxZpE*VRR1(54,75)
      V(762)=r1x2E*ZxZpE*VRR1(79,51)
      V(763)=r1x2E*VRR0(79,53)
      V(764)=r1x2E*ZxZpE*VRR1(79,53)
      V(765)=r1x2E*VRR0(80,38)
      V(766)=HfxZpE*VRR1(55,59)
      V(767)=r1x2E*ZxZpE*VRR1(80,38)
      V(768)=r1x2E*VRR0(80,39)
      V(769)=HfxZpE*VRR1(55,60)
      V(770)=r1x2E*ZxZpE*VRR1(80,39)
      V(771)=HfxZpE*VRR1(54,61)
      V(772)=HfxZpE*VRR1(55,65)
      V(773)=r1x2E*VRR0(80,44)
      V(774)=3.D0*V(773)
      V(775)=HfxZpE*VRR1(55,66)
      V(776)=r1x2E*ZxZpE*VRR1(80,44)
      V(777)=-3.D0*V(776)
      V(778)=HfxZpE*VRR1(54,67)
      V(779)=HfxZpE*VRR1(54,68)
      V(780)=r1x2E*VRR0(80,47)
      V(781)=HfxZpE*VRR1(55,70)
      V(782)=r1x2E*ZxZpE*VRR1(80,47)
      V(783)=r1x2E*VRR0(80,48)
      V(784)=3.D0*V(783)
      V(785)=HfxZpE*VRR1(55,71)
      V(786)=r1x2E*ZxZpE*VRR1(80,48)
      V(787)=-3.D0*V(786)
      V(788)=r1x2E*VRR0(80,49)
      V(789)=3.D0*V(788)
      V(790)=HfxZpE*VRR1(54,73)
      V(791)=r1x2E*ZxZpE*VRR1(80,49)
      V(792)=-3.D0*V(791)
      V(793)=r1x2E*VRR0(80,50)
      V(794)=HfxZpE*VRR1(54,74)
      V(795)=r1x2E*ZxZpE*VRR1(80,50)
      V(796)=r1x2E*VRR0(80,51)
      V(797)=HfxZpE*VRR1(55,75)
      V(798)=r1x2E*ZxZpE*VRR1(80,51)
      V(799)=r1x2E*VRR0(80,53)
      V(800)=HfxZpE*VRR1(54,78)
      V(801)=r1x2E*ZxZpE*VRR1(80,53)
      V(802)=r1x2E*VRR0(81,38)
      V(803)=r1x2E*ZxZpE*VRR1(81,38)
      V(804)=r1x2E*VRR0(81,39)
      V(805)=r1x2E*ZxZpE*VRR1(81,39)
      V(806)=HfxZpE*VRR1(55,61)
      V(807)=r1x2E*VRR0(81,44)
      V(808)=3.D0*V(807)
      V(809)=r1x2E*ZxZpE*VRR1(81,44)
      V(810)=-3.D0*V(809)
      V(811)=HfxZpE*VRR1(55,67)
      V(812)=2.D0*V(811)
      V(813)=HfxZpE*VRR1(55,68)
      V(814)=2.D0*V(813)
      V(815)=r1x2E*VRR0(81,47)
      V(816)=r1x2E*ZxZpE*VRR1(81,47)
      V(817)=r1x2E*VRR0(81,48)
      V(818)=3.D0*V(817)
      V(819)=r1x2E*ZxZpE*VRR1(81,48)
      V(820)=-3.D0*V(819)
      V(821)=r1x2E*VRR0(81,49)
      V(822)=3.D0*V(821)
      V(823)=HfxZpE*VRR1(55,73)
      V(824)=r1x2E*ZxZpE*VRR1(81,49)
      V(825)=-3.D0*V(824)
      V(826)=r1x2E*VRR0(81,50)
      V(827)=HfxZpE*VRR1(55,74)
      V(828)=r1x2E*ZxZpE*VRR1(81,50)
      V(829)=r1x2E*VRR0(81,51)
      V(830)=r1x2E*ZxZpE*VRR1(81,51)
      V(831)=r1x2E*VRR0(81,53)
      V(832)=HfxZpE*VRR1(55,78)
      V(833)=r1x2E*ZxZpE*VRR1(81,53)
      V(834)=HfxZpE*VRR1(56,58)
      V(835)=HfxZpE*VRR1(56,59)
      V(836)=HfxZpE*VRR1(56,64)
      V(837)=HfxZpE*VRR1(56,65)
      V(838)=HfxZpE*VRR1(56,70)
      V(839)=HfxZpE*VRR1(56,61)
      V(840)=HfxZpE*VRR1(56,62)
      V(841)=HfxZpE*VRR1(56,68)
      V(842)=HfxZpE*VRR1(56,69)
      V(843)=HfxZpE*VRR1(56,74)
      VRR0(57,85)=6.D0*r1x2E*VRR0(57,36)+QCx*VRR0(57,57)+6.D0*HfxZpE*VRR1(36,57)-6.D0*r1x2E*ZxZpE*VRR1(57,36)+WQx*VRR1(57,57)
      VRR0(57,86)=5.D0*r1x2E*VRR0(57,37)+QCx*VRR0(57,58)+6.D0*HfxZpE*VRR1(36,58)-5.D0*r1x2E*ZxZpE*VRR1(57,37)+WQx*VRR1(57,58)
      VRR0(57,87)=5.D0*r1x2Z*VRR0(21,87)+PAx*VRR0(36,87)-5.D0*ExZpE*r1x2Z*VRR1(21,87)+5.D0*HfxZpE*VRR1(36,59)+WPx*VRR1(36,87)
      VRR0(57,88)=5.D0*r1x2Z*VRR0(21,88)+PAx*VRR0(36,88)-5.D0*ExZpE*r1x2Z*VRR1(21,88)+4.D0*HfxZpE*VRR1(36,60)+WPx*VRR1(36,88)
      VRR0(57,89)=3.D0*V(1)+5.D0*r1x2Z*VRR0(21,89)+PAx*VRR0(36,89)-5.D0*ExZpE*r1x2Z*VRR1(21,89)+WPx*VRR1(36,89)
      VRR0(57,90)=2.D0*V(2)+5.D0*r1x2Z*VRR0(21,90)+PAx*VRR0(36,90)-5.D0*ExZpE*r1x2Z*VRR1(21,90)+WPx*VRR1(36,90)
      VRR0(57,91)=5.D0*r1x2E*VRR0(57,40)+QCy*VRR0(57,62)-5.D0*r1x2E*ZxZpE*VRR1(57,40)+WQy*VRR1(57,62)
      VRR0(57,92)=6.D0*r1x2E*VRR0(57,41)+QCy*VRR0(57,63)-6.D0*r1x2E*ZxZpE*VRR1(57,41)+WQy*VRR1(57,63)
      VRR0(57,93)=5.D0*r1x2E*VRR0(57,42)+QCx*VRR0(57,64)+6.D0*HfxZpE*VRR1(36,64)-5.D0*r1x2E*ZxZpE*VRR1(57,42)+WQx*VRR1(57,64)
      VRR0(57,94)=5.D0*r1x2Z*VRR0(21,94)+PAx*VRR0(36,94)-5.D0*ExZpE*r1x2Z*VRR1(21,94)+5.D0*HfxZpE*VRR1(36,65)+WPx*VRR1(36,94)
      VRR0(57,95)=5.D0*r1x2Z*VRR0(21,95)+PAx*VRR0(36,95)-5.D0*ExZpE*r1x2Z*VRR1(21,95)+4.D0*HfxZpE*VRR1(36,66)+WPx*VRR1(36,95)
      VRR0(57,96)=5.D0*r1x2Z*VRR0(21,96)+PAx*VRR0(36,96)-5.D0*ExZpE*r1x2Z*VRR1(21,96)+3.D0*HfxZpE*VRR1(36,67)+WPx*VRR1(36,96)
      VRR0(57,97)=2.D0*V(3)+5.D0*r1x2Z*VRR0(21,97)+PAx*VRR0(36,97)-5.D0*ExZpE*r1x2Z*VRR1(21,97)+WPx*VRR1(36,97)
      VRR0(57,98)=V(4)+5.D0*r1x2Z*VRR0(21,98)+PAx*VRR0(36,98)-5.D0*ExZpE*r1x2Z*VRR1(21,98)+WPx*VRR1(36,98)
      VRR0(57,99)=5.D0*r1x2E*VRR0(57,46)+QCy*VRR0(57,69)-5.D0*r1x2E*ZxZpE*VRR1(57,46)+WQy*VRR1(57,69)
      VRR0(57,100)=5.D0*r1x2Z*VRR0(21,100)+PAx*VRR0(36,100)-5.D0*ExZpE*r1x2Z*VRR1(21,100)+5.D0*HfxZpE*VRR1(36,70)+WPx*VRR1(36,100)
      VRR0(57,101)=5.D0*r1x2Z*VRR0(21,101)+PAx*VRR0(36,101)-5.D0*ExZpE*r1x2Z*VRR1(21,101)+4.D0*HfxZpE*VRR1(36,71)+WPx*VRR1(36,101)
      VRR0(57,102)=5.D0*r1x2Z*VRR0(21,102)+PAx*VRR0(36,102)-5.D0*ExZpE*r1x2Z*VRR1(21,102)+3.D0*HfxZpE*VRR1(36,72)+WPx*VRR1(36,102)
      VRR0(57,103)=5.D0*r1x2Z*VRR0(21,103)+PAx*VRR0(36,103)-5.D0*ExZpE*r1x2Z*VRR1(21,103)+2.D0*HfxZpE*VRR1(36,73)+WPx*VRR1(36,103)
      VRR0(57,104)=V(5)+5.D0*r1x2Z*VRR0(21,104)+PAx*VRR0(36,104)-5.D0*ExZpE*r1x2Z*VRR1(21,104)+WPx*VRR1(36,104)
      VRR0(57,105)=5.D0*r1x2Z*VRR0(21,105)+PAx*VRR0(36,105)-5.D0*ExZpE*r1x2Z*VRR1(21,105)+WPx*VRR1(36,105)
      VRR0(57,106)=5.D0*r1x2Z*VRR0(21,106)+PAx*VRR0(36,106)-5.D0*ExZpE*r1x2Z*VRR1(21,106)+4.D0*HfxZpE*VRR1(36,75)+WPx*VRR1(36,106)
      VRR0(57,107)=5.D0*r1x2Z*VRR0(21,107)+PAx*VRR0(36,107)-5.D0*ExZpE*r1x2Z*VRR1(21,107)+3.D0*HfxZpE*VRR1(36,76)+WPx*VRR1(36,107)
      VRR0(57,108)=5.D0*r1x2Z*VRR0(21,108)+PAx*VRR0(36,108)-5.D0*ExZpE*r1x2Z*VRR1(21,108)+2.D0*HfxZpE*VRR1(36,77)+WPx*VRR1(36,108)
      VRR0(57,109)=5.D0*r1x2Z*VRR0(21,109)+PAx*VRR0(36,109)-5.D0*ExZpE*r1x2Z*VRR1(21,109)+HfxZpE*VRR1(36,78)+WPx*VRR1(36,109)
      VRR0(57,110)=5.D0*r1x2Z*VRR0(21,110)+PAx*VRR0(36,110)-5.D0*ExZpE*r1x2Z*VRR1(21,110)+WPx*VRR1(36,110)
      VRR0(57,111)=3.D0*V(6)+5.D0*r1x2Z*VRR0(21,111)+PAx*VRR0(36,111)-5.D0*ExZpE*r1x2Z*VRR1(21,111)+WPx*VRR1(36,111)
      VRR0(57,112)=2.D0*V(7)+5.D0*r1x2Z*VRR0(21,112)+PAx*VRR0(36,112)-5.D0*ExZpE*r1x2Z*VRR1(21,112)+WPx*VRR1(36,112)
      VRR0(57,113)=V(8)+5.D0*r1x2Z*VRR0(21,113)+PAx*VRR0(36,113)-5.D0*ExZpE*r1x2Z*VRR1(21,113)+WPx*VRR1(36,113)
      VRR0(57,114)=5.D0*r1x2Z*VRR0(21,114)+PAx*VRR0(36,114)-5.D0*ExZpE*r1x2Z*VRR1(21,114)+WPx*VRR1(36,114)
      VRR0(57,115)=2.D0*V(9)+5.D0*r1x2Z*VRR0(21,115)+PAx*VRR0(36,115)-5.D0*ExZpE*r1x2Z*VRR1(21,115)+WPx*VRR1(36,115)
      VRR0(57,116)=V(10)+5.D0*r1x2Z*VRR0(21,116)+PAx*VRR0(36,116)-5.D0*ExZpE*r1x2Z*VRR1(21,116)+WPx*VRR1(36,116)
      VRR0(57,117)=5.D0*r1x2Z*VRR0(21,117)+PAx*VRR0(36,117)-5.D0*ExZpE*r1x2Z*VRR1(21,117)+WPx*VRR1(36,117)
      VRR0(57,118)=5.D0*r1x2E*VRR0(57,54)+QCz*VRR0(57,82)-5.D0*r1x2E*ZxZpE*VRR1(57,54)+WQz*VRR1(57,82)
      VRR0(57,119)=5.D0*r1x2E*VRR0(57,55)+QCz*VRR0(57,83)-5.D0*r1x2E*ZxZpE*VRR1(57,55)+WQz*VRR1(57,83)
      VRR0(57,120)=6.D0*r1x2E*VRR0(57,56)+QCz*VRR0(57,84)-6.D0*r1x2E*ZxZpE*VRR1(57,56)+WQz*VRR1(57,84)
      VRR0(58,85)=6.D0*r1x2E*VRR0(58,36)+QCx*VRR0(58,57)+5.D0*HfxZpE*VRR1(37,57)-6.D0*r1x2E*ZxZpE*VRR1(58,36)+WQx*VRR1(58,57)
      VRR0(58,86)=5.D0*r1x2E*VRR0(58,37)+QCx*VRR0(58,58)+5.D0*HfxZpE*VRR1(37,58)-5.D0*r1x2E*ZxZpE*VRR1(58,37)+WQx*VRR1(58,58)
      VRR0(58,87)=4.D0*r1x2E*VRR0(58,38)+QCx*VRR0(58,59)+5.D0*HfxZpE*VRR1(37,59)-4.D0*r1x2E*ZxZpE*VRR1(58,38)+WQx*VRR1(58,59)
      VRR0(58,88)=4.D0*V(11)+4.D0*r1x2Z*VRR0(22,88)+PAx*VRR0(37,88)-4.D0*ExZpE*r1x2Z*VRR1(22,88)+WPx*VRR1(37,88)
      VRR0(58,89)=3.D0*V(12)+4.D0*r1x2Z*VRR0(22,89)+PAx*VRR0(37,89)-4.D0*ExZpE*r1x2Z*VRR1(22,89)+WPx*VRR1(37,89)
      VRR0(58,90)=V(1)+4.D0*r1x2E*VRR0(58,39)+QCy*VRR0(58,61)-4.D0*r1x2E*ZxZpE*VRR1(58,39)+WQy*VRR1(58,61)
      VRR0(58,91)=V(2)+5.D0*r1x2E*VRR0(58,40)+QCy*VRR0(58,62)-5.D0*r1x2E*ZxZpE*VRR1(58,40)+WQy*VRR1(58,62)
      VRR0(58,92)=6.D0*r1x2E*VRR0(58,41)+QCy*VRR0(58,63)+HfxZpE*VRR1(36,63)-6.D0*r1x2E*ZxZpE*VRR1(58,41)+WQy*VRR1(58,63)
      VRR0(58,93)=5.D0*r1x2E*VRR0(58,42)+QCx*VRR0(58,64)+5.D0*HfxZpE*VRR1(37,64)-5.D0*r1x2E*ZxZpE*VRR1(58,42)+WQx*VRR1(58,64)
      VRR0(58,94)=4.D0*r1x2E*VRR0(58,43)+QCx*VRR0(58,65)+5.D0*HfxZpE*VRR1(37,65)-4.D0*r1x2E*ZxZpE*VRR1(58,43)+WQx*VRR1(58,65)
      VRR0(58,95)=4.D0*r1x2Z*VRR0(22,95)+PAx*VRR0(37,95)-4.D0*ExZpE*r1x2Z*VRR1(22,95)+4.D0*HfxZpE*VRR1(37,66)+WPx*VRR1(37,95)
      VRR0(58,96)=3.D0*V(13)+4.D0*r1x2Z*VRR0(22,96)+PAx*VRR0(37,96)-4.D0*ExZpE*r1x2Z*VRR1(22,96)+WPx*VRR1(37,96)
      VRR0(58,97)=V(15)+4.D0*r1x2Z*VRR0(22,97)+PAx*VRR0(37,97)-4.D0*ExZpE*r1x2Z*VRR1(22,97)+WPx*VRR1(37,97)
      VRR0(58,98)=V(3)+4.D0*r1x2E*VRR0(58,45)+QCy*VRR0(58,68)-4.D0*r1x2E*ZxZpE*VRR1(58,45)+WQy*VRR1(58,68)
      VRR0(58,99)=V(4)+5.D0*r1x2E*VRR0(58,46)+QCy*VRR0(58,69)-5.D0*r1x2E*ZxZpE*VRR1(58,46)+WQy*VRR1(58,69)
      VRR0(58,100)=4.D0*r1x2E*VRR0(58,47)+QCx*VRR0(58,70)+5.D0*HfxZpE*VRR1(37,70)-4.D0*r1x2E*ZxZpE*VRR1(58,47)+WQx*VRR1(58,70)
      VRR0(58,101)=4.D0*r1x2Z*VRR0(22,101)+PAx*VRR0(37,101)-4.D0*ExZpE*r1x2Z*VRR1(22,101)+4.D0*HfxZpE*VRR1(37,71)+WPx*VRR1(37,101)
      VRR0(58,102)=4.D0*r1x2Z*VRR0(22,102)+PAx*VRR0(37,102)-4.D0*ExZpE*r1x2Z*VRR1(22,102)+3.D0*HfxZpE*VRR1(37,72)+WPx*VRR1(37,102)
      VRR0(58,103)=V(17)+4.D0*r1x2Z*VRR0(22,103)+PAx*VRR0(37,103)-4.D0*ExZpE*r1x2Z*VRR1(22,103)+WPx*VRR1(37,103)
      VRR0(58,104)=V(18)+4.D0*r1x2Z*VRR0(22,104)+PAx*VRR0(37,104)-4.D0*ExZpE*r1x2Z*VRR1(22,104)+WPx*VRR1(37,104)
      VRR0(58,105)=V(5)+4.D0*r1x2E*VRR0(58,50)+QCy*VRR0(58,74)-4.D0*r1x2E*ZxZpE*VRR1(58,50)+WQy*VRR1(58,74)
      VRR0(58,106)=4.D0*V(19)+4.D0*r1x2Z*VRR0(22,106)+PAx*VRR0(37,106)-4.D0*ExZpE*r1x2Z*VRR1(22,106)+WPx*VRR1(37,106)
      VRR0(58,107)=3.D0*V(20)+4.D0*r1x2Z*VRR0(22,107)+PAx*VRR0(37,107)-4.D0*ExZpE*r1x2Z*VRR1(22,107)+WPx*VRR1(37,107)
      VRR0(58,108)=2.D0*V(21)+4.D0*r1x2Z*VRR0(22,108)+PAx*VRR0(37,108)-4.D0*ExZpE*r1x2Z*VRR1(22,108)+WPx*VRR1(37,108)
      VRR0(58,109)=V(22)+4.D0*r1x2Z*VRR0(22,109)+PAx*VRR0(37,109)-4.D0*ExZpE*r1x2Z*VRR1(22,109)+WPx*VRR1(37,109)
      VRR0(58,110)=4.D0*r1x2Z*VRR0(22,110)+PAx*VRR0(37,110)-4.D0*ExZpE*r1x2Z*VRR1(22,110)+WPx*VRR1(37,110)
      VRR0(58,111)=3.D0*V(23)+4.D0*r1x2Z*VRR0(22,111)+PAx*VRR0(37,111)-4.D0*ExZpE*r1x2Z*VRR1(22,111)+WPx*VRR1(37,111)
      VRR0(58,112)=2.D0*V(24)+4.D0*r1x2Z*VRR0(22,112)+PAx*VRR0(37,112)-4.D0*ExZpE*r1x2Z*VRR1(22,112)+WPx*VRR1(37,112)
      VRR0(58,113)=V(25)+4.D0*r1x2Z*VRR0(22,113)+PAx*VRR0(37,113)-4.D0*ExZpE*r1x2Z*VRR1(22,113)+WPx*VRR1(37,113)
      VRR0(58,114)=4.D0*r1x2Z*VRR0(22,114)+PAx*VRR0(37,114)-4.D0*ExZpE*r1x2Z*VRR1(22,114)+WPx*VRR1(37,114)
      VRR0(58,115)=4.D0*r1x2E*VRR0(58,51)+QCz*VRR0(58,79)-4.D0*r1x2E*ZxZpE*VRR1(58,51)+WQz*VRR1(58,79)
      VRR0(58,116)=4.D0*r1x2E*VRR0(58,52)+QCz*VRR0(58,80)-4.D0*r1x2E*ZxZpE*VRR1(58,52)+WQz*VRR1(58,80)
      VRR0(58,117)=4.D0*r1x2E*VRR0(58,53)+QCz*VRR0(58,81)-4.D0*r1x2E*ZxZpE*VRR1(58,53)+WQz*VRR1(58,81)
      VRR0(58,118)=5.D0*r1x2E*VRR0(58,54)+QCz*VRR0(58,82)-5.D0*r1x2E*ZxZpE*VRR1(58,54)+WQz*VRR1(58,82)
      VRR0(58,119)=5.D0*r1x2E*VRR0(58,55)+QCz*VRR0(58,83)-5.D0*r1x2E*ZxZpE*VRR1(58,55)+WQz*VRR1(58,83)
      VRR0(58,120)=6.D0*r1x2E*VRR0(58,56)+QCz*VRR0(58,84)-6.D0*r1x2E*ZxZpE*VRR1(58,56)+WQz*VRR1(58,84)
      VRR0(59,85)=6.D0*r1x2E*VRR0(59,36)+QCx*VRR0(59,57)+4.D0*HfxZpE*VRR1(38,57)-6.D0*r1x2E*ZxZpE*VRR1(59,36)+WQx*VRR1(59,57)
      VRR0(59,86)=5.D0*r1x2E*VRR0(59,37)+QCx*VRR0(59,58)+4.D0*HfxZpE*VRR1(38,58)-5.D0*r1x2E*ZxZpE*VRR1(59,37)+WQx*VRR1(59,58)
      VRR0(59,87)=4.D0*V(26)-4.D0*V(27)+QCx*VRR0(59,59)+4.D0*HfxZpE*VRR1(38,59)+WQx*VRR1(59,59)
      VRR0(59,88)=3.D0*V(28)+4.D0*V(29)-3.D0*V(30)+QCx*VRR0(59,60)+WQx*VRR1(59,60)
      VRR0(59,89)=2.D0*V(11)+3.D0*V(26)-3.D0*V(27)+QCy*VRR0(59,60)+WQy*VRR1(59,60)
      VRR0(59,90)=2.D0*V(12)+4.D0*V(28)-4.D0*V(30)+QCy*VRR0(59,61)+WQy*VRR1(59,61)
      VRR0(59,91)=5.D0*r1x2E*VRR0(59,40)+QCy*VRR0(59,62)+2.D0*HfxZpE*VRR1(37,62)-5.D0*r1x2E*ZxZpE*VRR1(59,40)+WQy*VRR1(59,62)
      VRR0(59,92)=6.D0*r1x2E*VRR0(59,41)+QCy*VRR0(59,63)+2.D0*HfxZpE*VRR1(37,63)-6.D0*r1x2E*ZxZpE*VRR1(59,41)+WQy*VRR1(59,63)
      VRR0(59,93)=5.D0*r1x2E*VRR0(59,42)+QCx*VRR0(59,64)+4.D0*HfxZpE*VRR1(38,64)-5.D0*r1x2E*ZxZpE*VRR1(59,42)+WQx*VRR1(59,64)
      VRR0(59,94)=4.D0*r1x2E*VRR0(59,43)+QCx*VRR0(59,65)+4.D0*HfxZpE*VRR1(38,65)-4.D0*r1x2E*ZxZpE*VRR1(59,43)+WQx*VRR1(59,65)
      VRR0(59,95)=V(32)+V(34)+QCx*VRR0(59,66)+4.D0*HfxZpE*VRR1(38,66)+WQx*VRR1(59,66)
      VRR0(59,96)=V(36)+V(38)+V(40)+PAx*VRR0(38,96)+WPx*VRR1(38,96)
      VRR0(59,97)=2.D0*V(13)+V(32)+V(34)+QCy*VRR0(59,67)+WQy*VRR1(59,67)
      VRR0(59,98)=V(15)+4.D0*r1x2E*VRR0(59,45)+QCy*VRR0(59,68)-4.D0*r1x2E*ZxZpE*VRR1(59,45)+WQy*VRR1(59,68)
      VRR0(59,99)=5.D0*r1x2E*VRR0(59,46)+QCy*VRR0(59,69)+2.D0*HfxZpE*VRR1(37,69)-5.D0*r1x2E*ZxZpE*VRR1(59,46)+WQy*VRR1(59,69)
      VRR0(59,100)=4.D0*V(41)-4.D0*V(42)+QCx*VRR0(59,70)+4.D0*HfxZpE*VRR1(38,70)+WQx*VRR1(59,70)
      VRR0(59,101)=V(44)+V(46)+QCx*VRR0(59,71)+4.D0*HfxZpE*VRR1(38,71)+WQx*VRR1(59,71)
      VRR0(59,102)=V(48)+V(50)+V(52)+PAx*VRR0(38,102)+WPx*VRR1(38,102)
      VRR0(59,103)=V(54)+V(56)+2.D0*V(57)+PAx*VRR0(38,103)+WPx*VRR1(38,103)
      VRR0(59,104)=V(17)+V(59)+V(61)+QCy*VRR0(59,73)+WQy*VRR1(59,73)
      VRR0(59,105)=2.D0*V(18)+4.D0*V(62)-4.D0*V(63)+QCy*VRR0(59,74)+WQy*VRR1(59,74)
      VRR0(59,106)=3.D0*V(64)+4.D0*V(65)-3.D0*V(66)+QCx*VRR0(59,75)+WQx*VRR1(59,75)
      VRR0(59,107)=V(68)+V(70)+3.D0*V(71)+PAx*VRR0(38,107)+WPx*VRR1(38,107)
      VRR0(59,108)=V(73)+V(75)+2.D0*V(76)+PAx*VRR0(38,108)+WPx*VRR1(38,108)
      VRR0(59,109)=V(78)+V(80)+V(81)+PAx*VRR0(38,109)+WPx*VRR1(38,109)
      VRR0(59,110)=2.D0*V(22)+3.D0*V(82)-3.D0*V(83)+QCy*VRR0(59,78)+WQy*VRR1(59,78)
      VRR0(59,111)=3.D0*V(41)-3.D0*V(42)+QCz*VRR0(59,75)+WQz*VRR1(59,75)
      VRR0(59,112)=V(44)+V(46)+QCz*VRR0(59,76)+WQz*VRR1(59,76)
      VRR0(59,113)=V(59)+V(61)+QCz*VRR0(59,77)+WQz*VRR1(59,77)
      VRR0(59,114)=3.D0*V(62)-3.D0*V(63)+QCz*VRR0(59,78)+WQz*VRR1(59,78)
      VRR0(59,115)=4.D0*V(64)-4.D0*V(66)+QCz*VRR0(59,79)+WQz*VRR1(59,79)
      VRR0(59,116)=4.D0*r1x2E*VRR0(59,52)+QCz*VRR0(59,80)-4.D0*r1x2E*ZxZpE*VRR1(59,52)+WQz*VRR1(59,80)
      VRR0(59,117)=4.D0*V(82)-4.D0*V(83)+QCz*VRR0(59,81)+WQz*VRR1(59,81)
      VRR0(59,118)=5.D0*r1x2E*VRR0(59,54)+QCz*VRR0(59,82)-5.D0*r1x2E*ZxZpE*VRR1(59,54)+WQz*VRR1(59,82)
      VRR0(59,119)=5.D0*r1x2E*VRR0(59,55)+QCz*VRR0(59,83)-5.D0*r1x2E*ZxZpE*VRR1(59,55)+WQz*VRR1(59,83)
      VRR0(59,120)=6.D0*r1x2E*VRR0(59,56)+QCz*VRR0(59,84)-6.D0*r1x2E*ZxZpE*VRR1(59,56)+WQz*VRR1(59,84)
      VRR0(60,85)=6.D0*r1x2E*VRR0(60,36)+QCx*VRR0(60,57)+3.D0*HfxZpE*VRR1(39,57)-6.D0*r1x2E*ZxZpE*VRR1(60,36)+WQx*VRR1(60,57)
      VRR0(60,86)=5.D0*r1x2E*VRR0(60,37)+QCx*VRR0(60,58)+3.D0*HfxZpE*VRR1(39,58)-5.D0*r1x2E*ZxZpE*VRR1(60,37)+WQx*VRR1(60,58)
      VRR0(60,87)=4.D0*V(84)-4.D0*V(85)+QCx*VRR0(60,59)+3.D0*HfxZpE*VRR1(39,59)+WQx*VRR1(60,59)
      VRR0(60,88)=3.D0*V(86)+3.D0*V(87)-3.D0*V(88)+QCx*VRR0(60,60)+WQx*VRR1(60,60)
      VRR0(60,89)=3.D0*V(29)+3.D0*V(84)-3.D0*V(85)+QCy*VRR0(60,60)+WQy*VRR1(60,60)
      VRR0(60,90)=4.D0*V(86)-4.D0*V(88)+QCy*VRR0(60,61)+3.D0*HfxZpE*VRR1(38,61)+WQy*VRR1(60,61)
      VRR0(60,91)=5.D0*r1x2E*VRR0(60,40)+QCy*VRR0(60,62)+3.D0*HfxZpE*VRR1(38,62)-5.D0*r1x2E*ZxZpE*VRR1(60,40)+WQy*VRR1(60,62)
      VRR0(60,92)=6.D0*r1x2E*VRR0(60,41)+QCy*VRR0(60,63)+3.D0*HfxZpE*VRR1(38,63)-6.D0*r1x2E*ZxZpE*VRR1(60,41)+WQy*VRR1(60,63)
      VRR0(60,93)=5.D0*r1x2E*VRR0(60,42)+QCx*VRR0(60,64)+3.D0*HfxZpE*VRR1(39,64)-5.D0*r1x2E*ZxZpE*VRR1(60,42)+WQx*VRR1(60,64)
      VRR0(60,94)=4.D0*r1x2E*VRR0(60,43)+QCx*VRR0(60,65)+3.D0*HfxZpE*VRR1(39,65)-4.D0*r1x2E*ZxZpE*VRR1(60,43)+WQx*VRR1(60,65)
      VRR0(60,95)=V(90)+V(92)+V(94)+QCx*VRR0(60,66)+WQx*VRR1(60,66)
      VRR0(60,96)=2.D0*V(95)+3.D0*V(96)-2.D0*V(97)+QCx*VRR0(60,67)+WQx*VRR1(60,67)
      VRR0(60,97)=V(40)+V(90)+V(94)+QCy*VRR0(60,67)+WQy*VRR1(60,67)
      VRR0(60,98)=4.D0*V(95)-4.D0*V(97)+QCy*VRR0(60,68)+3.D0*HfxZpE*VRR1(38,68)+WQy*VRR1(60,68)
      VRR0(60,99)=5.D0*r1x2E*VRR0(60,46)+QCy*VRR0(60,69)+3.D0*HfxZpE*VRR1(38,69)-5.D0*r1x2E*ZxZpE*VRR1(60,46)+WQy*VRR1(60,69)
      VRR0(60,100)=4.D0*V(98)-4.D0*V(99)+QCx*VRR0(60,70)+3.D0*HfxZpE*VRR1(39,70)+WQx*VRR1(60,70)
      VRR0(60,101)=V(101)+3.D0*V(102)+V(104)+QCx*VRR0(60,71)+WQx*VRR1(60,71)
      VRR0(60,102)=2.D0*V(105)+V(107)-2.D0*V(108)+QCx*VRR0(60,72)+WQx*VRR1(60,72)
      VRR0(60,103)=V(52)+2.D0*V(100)-2.D0*V(103)+QCy*VRR0(60,72)+WQy*VRR1(60,72)
      VRR0(60,104)=3.D0*V(57)+V(109)+V(110)+QCy*VRR0(60,73)+WQy*VRR1(60,73)
      VRR0(60,105)=4.D0*V(111)-4.D0*V(112)+QCy*VRR0(60,74)+3.D0*HfxZpE*VRR1(38,74)+WQy*VRR1(60,74)
      VRR0(60,106)=3.D0*V(113)+3.D0*V(114)-3.D0*V(115)+QCx*VRR0(60,75)+WQx*VRR1(60,75)
      VRR0(60,107)=V(117)+3.D0*V(118)+V(120)+QCx*VRR0(60,76)+WQx*VRR1(60,76)
      VRR0(60,108)=2.D0*V(89)-2.D0*V(93)+QCz*VRR0(60,72)+WQz*VRR1(60,72)
      VRR0(60,109)=3.D0*V(76)+V(117)+V(120)+QCy*VRR0(60,77)+WQy*VRR1(60,77)
      VRR0(60,110)=3.D0*V(81)+3.D0*V(121)-3.D0*V(122)+QCy*VRR0(60,78)+WQy*VRR1(60,78)
      VRR0(60,111)=3.D0*V(98)-3.D0*V(99)+QCz*VRR0(60,75)+WQz*VRR1(60,75)
      VRR0(60,112)=V(101)+V(104)+QCz*VRR0(60,76)+WQz*VRR1(60,76)
      VRR0(60,113)=V(109)+V(110)+QCz*VRR0(60,77)+WQz*VRR1(60,77)
      VRR0(60,114)=3.D0*V(111)-3.D0*V(112)+QCz*VRR0(60,78)+WQz*VRR1(60,78)
      VRR0(60,115)=4.D0*V(113)-4.D0*V(115)+QCz*VRR0(60,79)+WQz*VRR1(60,79)
      VRR0(60,116)=4.D0*V(116)-4.D0*V(119)+QCz*VRR0(60,80)+WQz*VRR1(60,80)
      VRR0(60,117)=4.D0*V(121)-4.D0*V(122)+QCz*VRR0(60,81)+WQz*VRR1(60,81)
      VRR0(60,118)=5.D0*r1x2E*VRR0(60,54)+QCz*VRR0(60,82)-5.D0*r1x2E*ZxZpE*VRR1(60,54)+WQz*VRR1(60,82)
      VRR0(60,119)=5.D0*r1x2E*VRR0(60,55)+QCz*VRR0(60,83)-5.D0*r1x2E*ZxZpE*VRR1(60,55)+WQz*VRR1(60,83)
      VRR0(60,120)=6.D0*r1x2E*VRR0(60,56)+QCz*VRR0(60,84)-6.D0*r1x2E*ZxZpE*VRR1(60,56)+WQz*VRR1(60,84)
      VRR0(61,85)=6.D0*r1x2E*VRR0(61,36)+QCx*VRR0(61,57)+2.D0*HfxZpE*VRR1(40,57)-6.D0*r1x2E*ZxZpE*VRR1(61,36)+WQx*VRR1(61,57)
      VRR0(61,86)=5.D0*r1x2E*VRR0(61,37)+QCx*VRR0(61,58)+2.D0*HfxZpE*VRR1(40,58)-5.D0*r1x2E*ZxZpE*VRR1(61,37)+WQx*VRR1(61,58)
      VRR0(61,87)=4.D0*V(123)+2.D0*V(124)-4.D0*V(125)+QCx*VRR0(61,59)+WQx*VRR1(61,59)
      VRR0(61,88)=3.D0*V(126)+2.D0*V(127)-3.D0*V(128)+QCx*VRR0(61,60)+WQx*VRR1(61,60)
      VRR0(61,89)=4.D0*V(87)+3.D0*V(123)-3.D0*V(125)+QCy*VRR0(61,60)+WQy*VRR1(61,60)
      VRR0(61,90)=4.D0*V(126)-4.D0*V(128)+QCy*VRR0(61,61)+4.D0*HfxZpE*VRR1(39,61)+WQy*VRR1(61,61)
      VRR0(61,91)=5.D0*r1x2E*VRR0(61,40)+QCy*VRR0(61,62)+4.D0*HfxZpE*VRR1(39,62)-5.D0*r1x2E*ZxZpE*VRR1(61,40)+WQy*VRR1(61,62)
      VRR0(61,92)=6.D0*r1x2E*VRR0(61,41)+QCy*VRR0(61,63)+4.D0*HfxZpE*VRR1(39,63)-6.D0*r1x2E*ZxZpE*VRR1(61,41)+WQy*VRR1(61,63)
      VRR0(61,93)=5.D0*r1x2E*VRR0(61,42)+QCx*VRR0(61,64)+2.D0*HfxZpE*VRR1(40,64)-5.D0*r1x2E*ZxZpE*VRR1(61,42)+WQx*VRR1(61,64)
      VRR0(61,94)=V(130)+4.D0*r1x2E*VRR0(61,43)+QCx*VRR0(61,65)-4.D0*r1x2E*ZxZpE*VRR1(61,43)+WQx*VRR1(61,65)
      VRR0(61,95)=V(132)+2.D0*V(133)+V(135)+QCx*VRR0(61,66)+WQx*VRR1(61,66)
      VRR0(61,96)=V(36)+V(38)+V(92)+PAy*VRR0(39,96)+WPy*VRR1(39,96)
      VRR0(61,97)=4.D0*V(96)+V(132)+V(135)+QCy*VRR0(61,67)+WQy*VRR1(61,67)
      VRR0(61,98)=4.D0*r1x2E*VRR0(61,45)+QCy*VRR0(61,68)+4.D0*HfxZpE*VRR1(39,68)-4.D0*r1x2E*ZxZpE*VRR1(61,45)+WQy*VRR1(61,68)
      VRR0(61,99)=5.D0*r1x2E*VRR0(61,46)+QCy*VRR0(61,69)+4.D0*HfxZpE*VRR1(39,69)-5.D0*r1x2E*ZxZpE*VRR1(61,46)+WQy*VRR1(61,69)
      VRR0(61,100)=4.D0*V(136)+2.D0*V(137)-4.D0*V(138)+QCx*VRR0(61,70)+WQx*VRR1(61,70)
      VRR0(61,101)=V(140)+V(142)+V(144)+QCx*VRR0(61,71)+WQx*VRR1(61,71)
      VRR0(61,102)=V(48)+V(50)+2.D0*V(102)+PAy*VRR0(39,102)+WPy*VRR1(39,102)
      VRR0(61,103)=V(54)+V(56)+V(107)+PAy*VRR0(39,103)+WPy*VRR1(39,103)
      VRR0(61,104)=V(146)+V(148)+QCy*VRR0(61,73)+4.D0*HfxZpE*VRR1(39,73)+WQy*VRR1(61,73)
      VRR0(61,105)=4.D0*V(149)-4.D0*V(150)+QCy*VRR0(61,74)+4.D0*HfxZpE*VRR1(39,74)+WQy*VRR1(61,74)
      VRR0(61,106)=3.D0*V(151)+2.D0*V(152)-3.D0*V(153)+QCx*VRR0(61,75)+WQx*VRR1(61,75)
      VRR0(61,107)=V(68)+V(70)+V(114)+PAy*VRR0(39,107)+WPy*VRR1(39,107)
      VRR0(61,108)=V(73)+V(75)+2.D0*V(118)+PAy*VRR0(39,108)+WPy*VRR1(39,108)
      VRR0(61,109)=V(78)+V(80)+3.D0*V(154)+PAy*VRR0(39,109)+WPy*VRR1(39,109)
      VRR0(61,110)=3.D0*V(155)+4.D0*V(156)-3.D0*V(157)+QCy*VRR0(61,78)+WQy*VRR1(61,78)
      VRR0(61,111)=3.D0*V(136)-3.D0*V(138)+QCz*VRR0(61,75)+WQz*VRR1(61,75)
      VRR0(61,112)=V(140)+V(144)+QCz*VRR0(61,76)+WQz*VRR1(61,76)
      VRR0(61,113)=V(146)+V(148)+QCz*VRR0(61,77)+WQz*VRR1(61,77)
      VRR0(61,114)=3.D0*V(149)-3.D0*V(150)+QCz*VRR0(61,78)+WQz*VRR1(61,78)
      VRR0(61,115)=4.D0*V(151)-4.D0*V(153)+QCz*VRR0(61,79)+WQz*VRR1(61,79)
      VRR0(61,116)=4.D0*r1x2E*VRR0(61,52)+QCz*VRR0(61,80)-4.D0*r1x2E*ZxZpE*VRR1(61,52)+WQz*VRR1(61,80)
      VRR0(61,117)=4.D0*V(155)-4.D0*V(157)+QCz*VRR0(61,81)+WQz*VRR1(61,81)
      VRR0(61,118)=5.D0*r1x2E*VRR0(61,54)+QCz*VRR0(61,82)-5.D0*r1x2E*ZxZpE*VRR1(61,54)+WQz*VRR1(61,82)
      VRR0(61,119)=5.D0*r1x2E*VRR0(61,55)+QCz*VRR0(61,83)-5.D0*r1x2E*ZxZpE*VRR1(61,55)+WQz*VRR1(61,83)
      VRR0(61,120)=6.D0*r1x2E*VRR0(61,56)+QCz*VRR0(61,84)-6.D0*r1x2E*ZxZpE*VRR1(61,56)+WQz*VRR1(61,84)
      VRR0(62,85)=6.D0*r1x2E*VRR0(62,36)+QCx*VRR0(62,57)+HfxZpE*VRR1(41,57)-6.D0*r1x2E*ZxZpE*VRR1(62,36)+WQx*VRR1(62,57)
      VRR0(62,86)=V(158)+5.D0*r1x2E*VRR0(62,37)+QCx*VRR0(62,58)-5.D0*r1x2E*ZxZpE*VRR1(62,37)+WQx*VRR1(62,58)
      VRR0(62,87)=V(159)+4.D0*r1x2E*VRR0(62,38)+QCx*VRR0(62,59)-4.D0*r1x2E*ZxZpE*VRR1(62,38)+WQx*VRR1(62,59)
      VRR0(62,88)=3.D0*V(124)+4.D0*r1x2Z*VRR0(24,88)+PAy*VRR0(40,88)-4.D0*ExZpE*r1x2Z*VRR1(24,88)+WPy*VRR1(40,88)
      VRR0(62,89)=4.D0*V(127)+4.D0*r1x2Z*VRR0(24,89)+PAy*VRR0(40,89)-4.D0*ExZpE*r1x2Z*VRR1(24,89)+WPy*VRR1(40,89)
      VRR0(62,90)=4.D0*r1x2E*VRR0(62,39)+QCy*VRR0(62,61)+5.D0*HfxZpE*VRR1(40,61)-4.D0*r1x2E*ZxZpE*VRR1(62,39)+WQy*VRR1(62,61)
      VRR0(62,91)=5.D0*r1x2E*VRR0(62,40)+QCy*VRR0(62,62)+5.D0*HfxZpE*VRR1(40,62)-5.D0*r1x2E*ZxZpE*VRR1(62,40)+WQy*VRR1(62,62)
      VRR0(62,92)=6.D0*r1x2E*VRR0(62,41)+QCy*VRR0(62,63)+5.D0*HfxZpE*VRR1(40,63)-6.D0*r1x2E*ZxZpE*VRR1(62,41)+WQy*VRR1(62,63)
      VRR0(62,93)=V(160)+5.D0*r1x2E*VRR0(62,42)+QCx*VRR0(62,64)-5.D0*r1x2E*ZxZpE*VRR1(62,42)+WQx*VRR1(62,64)
      VRR0(62,94)=V(161)+4.D0*r1x2E*VRR0(62,43)+QCx*VRR0(62,65)-4.D0*r1x2E*ZxZpE*VRR1(62,43)+WQx*VRR1(62,65)
      VRR0(62,95)=V(130)+4.D0*r1x2Z*VRR0(24,95)+PAy*VRR0(40,95)-4.D0*ExZpE*r1x2Z*VRR1(24,95)+WPy*VRR1(40,95)
      VRR0(62,96)=3.D0*V(133)+4.D0*r1x2Z*VRR0(24,96)+PAy*VRR0(40,96)-4.D0*ExZpE*r1x2Z*VRR1(24,96)+WPy*VRR1(40,96)
      VRR0(62,97)=4.D0*r1x2Z*VRR0(24,97)+PAy*VRR0(40,97)-4.D0*ExZpE*r1x2Z*VRR1(24,97)+4.D0*HfxZpE*VRR1(40,67)+WPy*VRR1(40,97)
      VRR0(62,98)=4.D0*r1x2E*VRR0(62,45)+QCy*VRR0(62,68)+5.D0*HfxZpE*VRR1(40,68)-4.D0*r1x2E*ZxZpE*VRR1(62,45)+WQy*VRR1(62,68)
      VRR0(62,99)=5.D0*r1x2E*VRR0(62,46)+QCy*VRR0(62,69)+5.D0*HfxZpE*VRR1(40,69)-5.D0*r1x2E*ZxZpE*VRR1(62,46)+WQy*VRR1(62,69)
      VRR0(62,100)=V(162)+4.D0*r1x2E*VRR0(62,47)+QCx*VRR0(62,70)-4.D0*r1x2E*ZxZpE*VRR1(62,47)+WQx*VRR1(62,70)
      VRR0(62,101)=V(137)+4.D0*r1x2Z*VRR0(24,101)+PAy*VRR0(40,101)-4.D0*ExZpE*r1x2Z*VRR1(24,101)+WPy*VRR1(40,101)
      VRR0(62,102)=V(142)+4.D0*r1x2Z*VRR0(24,102)+PAy*VRR0(40,102)-4.D0*ExZpE*r1x2Z*VRR1(24,102)+WPy*VRR1(40,102)
      VRR0(62,103)=4.D0*r1x2Z*VRR0(24,103)+PAy*VRR0(40,103)-4.D0*ExZpE*r1x2Z*VRR1(24,103)+3.D0*HfxZpE*VRR1(40,72)+WPy*VRR1(40,103)
      VRR0(62,104)=4.D0*r1x2Z*VRR0(24,104)+PAy*VRR0(40,104)-4.D0*ExZpE*r1x2Z*VRR1(24,104)+4.D0*HfxZpE*VRR1(40,73)+WPy*VRR1(40,104)
      VRR0(62,105)=4.D0*r1x2E*VRR0(62,50)+QCy*VRR0(62,74)+5.D0*HfxZpE*VRR1(40,74)-4.D0*r1x2E*ZxZpE*VRR1(62,50)+WQy*VRR1(62,74)
      VRR0(62,106)=4.D0*r1x2Z*VRR0(24,106)+PAy*VRR0(40,106)-4.D0*ExZpE*r1x2Z*VRR1(24,106)+WPy*VRR1(40,106)
      VRR0(62,107)=V(152)+4.D0*r1x2Z*VRR0(24,107)+PAy*VRR0(40,107)-4.D0*ExZpE*r1x2Z*VRR1(24,107)+WPy*VRR1(40,107)
      VRR0(62,108)=2.D0*V(163)+4.D0*r1x2Z*VRR0(24,108)+PAy*VRR0(40,108)-4.D0*ExZpE*r1x2Z*VRR1(24,108)+WPy*VRR1(40,108)
      VRR0(62,109)=3.D0*V(164)+4.D0*r1x2Z*VRR0(24,109)+PAy*VRR0(40,109)-4.D0*ExZpE*r1x2Z*VRR1(24,109)+WPy*VRR1(40,109)
      VRR0(62,110)=4.D0*V(165)+4.D0*r1x2Z*VRR0(24,110)+PAy*VRR0(40,110)-4.D0*ExZpE*r1x2Z*VRR1(24,110)+WPy*VRR1(40,110)
      VRR0(62,111)=4.D0*r1x2Z*VRR0(24,111)+PAy*VRR0(40,111)-4.D0*ExZpE*r1x2Z*VRR1(24,111)+WPy*VRR1(40,111)
      VRR0(62,112)=V(166)+4.D0*r1x2Z*VRR0(24,112)+PAy*VRR0(40,112)-4.D0*ExZpE*r1x2Z*VRR1(24,112)+WPy*VRR1(40,112)
      VRR0(62,113)=2.D0*V(167)+4.D0*r1x2Z*VRR0(24,113)+PAy*VRR0(40,113)-4.D0*ExZpE*r1x2Z*VRR1(24,113)+WPy*VRR1(40,113)
      VRR0(62,114)=3.D0*V(168)+4.D0*r1x2Z*VRR0(24,114)+PAy*VRR0(40,114)-4.D0*ExZpE*r1x2Z*VRR1(24,114)+WPy*VRR1(40,114)
      VRR0(62,115)=4.D0*r1x2E*VRR0(62,51)+QCz*VRR0(62,79)-4.D0*r1x2E*ZxZpE*VRR1(62,51)+WQz*VRR1(62,79)
      VRR0(62,116)=4.D0*r1x2E*VRR0(62,52)+QCz*VRR0(62,80)-4.D0*r1x2E*ZxZpE*VRR1(62,52)+WQz*VRR1(62,80)
      VRR0(62,117)=4.D0*r1x2E*VRR0(62,53)+QCz*VRR0(62,81)-4.D0*r1x2E*ZxZpE*VRR1(62,53)+WQz*VRR1(62,81)
      VRR0(62,118)=5.D0*r1x2E*VRR0(62,54)+QCz*VRR0(62,82)-5.D0*r1x2E*ZxZpE*VRR1(62,54)+WQz*VRR1(62,82)
      VRR0(62,119)=5.D0*r1x2E*VRR0(62,55)+QCz*VRR0(62,83)-5.D0*r1x2E*ZxZpE*VRR1(62,55)+WQz*VRR1(62,83)
      VRR0(62,120)=6.D0*r1x2E*VRR0(62,56)+QCz*VRR0(62,84)-6.D0*r1x2E*ZxZpE*VRR1(62,56)+WQz*VRR1(62,84)
      VRR0(63,85)=6.D0*r1x2E*VRR0(63,36)+QCx*VRR0(63,57)-6.D0*r1x2E*ZxZpE*VRR1(63,36)+WQx*VRR1(63,57)
      VRR0(63,86)=5.D0*r1x2E*VRR0(63,37)+QCx*VRR0(63,58)-5.D0*r1x2E*ZxZpE*VRR1(63,37)+WQx*VRR1(63,58)
      VRR0(63,87)=2.D0*V(158)+5.D0*r1x2Z*VRR0(25,87)+PAy*VRR0(41,87)-5.D0*ExZpE*r1x2Z*VRR1(25,87)+WPy*VRR1(41,87)
      VRR0(63,88)=3.D0*V(159)+5.D0*r1x2Z*VRR0(25,88)+PAy*VRR0(41,88)-5.D0*ExZpE*r1x2Z*VRR1(25,88)+WPy*VRR1(41,88)
      VRR0(63,89)=5.D0*r1x2Z*VRR0(25,89)+PAy*VRR0(41,89)-5.D0*ExZpE*r1x2Z*VRR1(25,89)+4.D0*HfxZpE*VRR1(41,60)+WPy*VRR1(41,89)
      VRR0(63,90)=5.D0*r1x2Z*VRR0(25,90)+PAy*VRR0(41,90)-5.D0*ExZpE*r1x2Z*VRR1(25,90)+5.D0*HfxZpE*VRR1(41,61)+WPy*VRR1(41,90)
      VRR0(63,91)=5.D0*r1x2E*VRR0(63,40)+QCy*VRR0(63,62)+6.D0*HfxZpE*VRR1(41,62)-5.D0*r1x2E*ZxZpE*VRR1(63,40)+WQy*VRR1(63,62)
      VRR0(63,92)=6.D0*r1x2E*VRR0(63,41)+QCy*VRR0(63,63)+6.D0*HfxZpE*VRR1(41,63)-6.D0*r1x2E*ZxZpE*VRR1(63,41)+WQy*VRR1(63,63)
      VRR0(63,93)=5.D0*r1x2E*VRR0(63,42)+QCx*VRR0(63,64)-5.D0*r1x2E*ZxZpE*VRR1(63,42)+WQx*VRR1(63,64)
      VRR0(63,94)=V(160)+5.D0*r1x2Z*VRR0(25,94)+PAy*VRR0(41,94)-5.D0*ExZpE*r1x2Z*VRR1(25,94)+WPy*VRR1(41,94)
      VRR0(63,95)=2.D0*V(161)+5.D0*r1x2Z*VRR0(25,95)+PAy*VRR0(41,95)-5.D0*ExZpE*r1x2Z*VRR1(25,95)+WPy*VRR1(41,95)
      VRR0(63,96)=5.D0*r1x2Z*VRR0(25,96)+PAy*VRR0(41,96)-5.D0*ExZpE*r1x2Z*VRR1(25,96)+3.D0*HfxZpE*VRR1(41,66)+WPy*VRR1(41,96)
      VRR0(63,97)=5.D0*r1x2Z*VRR0(25,97)+PAy*VRR0(41,97)-5.D0*ExZpE*r1x2Z*VRR1(25,97)+4.D0*HfxZpE*VRR1(41,67)+WPy*VRR1(41,97)
      VRR0(63,98)=5.D0*r1x2Z*VRR0(25,98)+PAy*VRR0(41,98)-5.D0*ExZpE*r1x2Z*VRR1(25,98)+5.D0*HfxZpE*VRR1(41,68)+WPy*VRR1(41,98)
      VRR0(63,99)=5.D0*r1x2E*VRR0(63,46)+QCy*VRR0(63,69)+6.D0*HfxZpE*VRR1(41,69)-5.D0*r1x2E*ZxZpE*VRR1(63,46)+WQy*VRR1(63,69)
      VRR0(63,100)=5.D0*r1x2Z*VRR0(25,100)+PAy*VRR0(41,100)-5.D0*ExZpE*r1x2Z*VRR1(25,100)+WPy*VRR1(41,100)
      VRR0(63,101)=V(162)+5.D0*r1x2Z*VRR0(25,101)+PAy*VRR0(41,101)-5.D0*ExZpE*r1x2Z*VRR1(25,101)+WPy*VRR1(41,101)
      VRR0(63,102)=5.D0*r1x2Z*VRR0(25,102)+PAy*VRR0(41,102)-5.D0*ExZpE*r1x2Z*VRR1(25,102)+2.D0*HfxZpE*VRR1(41,71)+WPy*VRR1(41,102)
      VRR0(63,103)=5.D0*r1x2Z*VRR0(25,103)+PAy*VRR0(41,103)-5.D0*ExZpE*r1x2Z*VRR1(25,103)+3.D0*HfxZpE*VRR1(41,72)+WPy*VRR1(41,103)
      VRR0(63,104)=5.D0*r1x2Z*VRR0(25,104)+PAy*VRR0(41,104)-5.D0*ExZpE*r1x2Z*VRR1(25,104)+4.D0*HfxZpE*VRR1(41,73)+WPy*VRR1(41,104)
      VRR0(63,105)=5.D0*r1x2Z*VRR0(25,105)+PAy*VRR0(41,105)-5.D0*ExZpE*r1x2Z*VRR1(25,105)+5.D0*HfxZpE*VRR1(41,74)+WPy*VRR1(41,105)
      VRR0(63,106)=5.D0*r1x2Z*VRR0(25,106)+PAy*VRR0(41,106)-5.D0*ExZpE*r1x2Z*VRR1(25,106)+WPy*VRR1(41,106)
      VRR0(63,107)=5.D0*r1x2Z*VRR0(25,107)+PAy*VRR0(41,107)-5.D0*ExZpE*r1x2Z*VRR1(25,107)+HfxZpE*VRR1(41,75)+WPy*VRR1(41,107)
      VRR0(63,108)=5.D0*r1x2Z*VRR0(25,108)+PAy*VRR0(41,108)-5.D0*ExZpE*r1x2Z*VRR1(25,108)+2.D0*HfxZpE*VRR1(41,76)+WPy*VRR1(41,108)
      VRR0(63,109)=5.D0*r1x2Z*VRR0(25,109)+PAy*VRR0(41,109)-5.D0*ExZpE*r1x2Z*VRR1(25,109)+3.D0*HfxZpE*VRR1(41,77)+WPy*VRR1(41,109)
      VRR0(63,110)=5.D0*r1x2Z*VRR0(25,110)+PAy*VRR0(41,110)-5.D0*ExZpE*r1x2Z*VRR1(25,110)+4.D0*HfxZpE*VRR1(41,78)+WPy*VRR1(41,110)
      VRR0(63,111)=5.D0*r1x2Z*VRR0(25,111)+PAy*VRR0(41,111)-5.D0*ExZpE*r1x2Z*VRR1(25,111)+WPy*VRR1(41,111)
      VRR0(63,112)=V(169)+5.D0*r1x2Z*VRR0(25,112)+PAy*VRR0(41,112)-5.D0*ExZpE*r1x2Z*VRR1(25,112)+WPy*VRR1(41,112)
      VRR0(63,113)=2.D0*V(170)+5.D0*r1x2Z*VRR0(25,113)+PAy*VRR0(41,113)-5.D0*ExZpE*r1x2Z*VRR1(25,113)+WPy*VRR1(41,113)
      VRR0(63,114)=3.D0*V(171)+5.D0*r1x2Z*VRR0(25,114)+PAy*VRR0(41,114)-5.D0*ExZpE*r1x2Z*VRR1(25,114)+WPy*VRR1(41,114)
      VRR0(63,115)=5.D0*r1x2Z*VRR0(25,115)+PAy*VRR0(41,115)-5.D0*ExZpE*r1x2Z*VRR1(25,115)+WPy*VRR1(41,115)
      VRR0(63,116)=V(172)+5.D0*r1x2Z*VRR0(25,116)+PAy*VRR0(41,116)-5.D0*ExZpE*r1x2Z*VRR1(25,116)+WPy*VRR1(41,116)
      VRR0(63,117)=2.D0*V(173)+5.D0*r1x2Z*VRR0(25,117)+PAy*VRR0(41,117)-5.D0*ExZpE*r1x2Z*VRR1(25,117)+WPy*VRR1(41,117)
      VRR0(63,118)=5.D0*r1x2E*VRR0(63,54)+QCz*VRR0(63,82)-5.D0*r1x2E*ZxZpE*VRR1(63,54)+WQz*VRR1(63,82)
      VRR0(63,119)=5.D0*r1x2E*VRR0(63,55)+QCz*VRR0(63,83)-5.D0*r1x2E*ZxZpE*VRR1(63,55)+WQz*VRR1(63,83)
      VRR0(63,120)=6.D0*r1x2E*VRR0(63,56)+QCz*VRR0(63,84)-6.D0*r1x2E*ZxZpE*VRR1(63,56)+WQz*VRR1(63,84)
      VRR0(64,85)=6.D0*r1x2E*VRR0(64,36)+QCx*VRR0(64,57)+5.D0*HfxZpE*VRR1(42,57)-6.D0*r1x2E*ZxZpE*VRR1(64,36)+WQx*VRR1(64,57)
      VRR0(64,86)=5.D0*r1x2E*VRR0(64,37)+QCx*VRR0(64,58)+5.D0*HfxZpE*VRR1(42,58)-5.D0*r1x2E*ZxZpE*VRR1(64,37)+WQx*VRR1(64,58)
      VRR0(64,87)=4.D0*r1x2E*VRR0(64,38)+QCx*VRR0(64,59)+5.D0*HfxZpE*VRR1(42,59)-4.D0*r1x2E*ZxZpE*VRR1(64,38)+WQx*VRR1(64,59)
      VRR0(64,88)=4.D0*V(174)+4.D0*r1x2Z*VRR0(26,88)+PAx*VRR0(42,88)-4.D0*ExZpE*r1x2Z*VRR1(26,88)+WPx*VRR1(42,88)
      VRR0(64,89)=3.D0*V(175)+4.D0*r1x2Z*VRR0(26,89)+PAx*VRR0(42,89)-4.D0*ExZpE*r1x2Z*VRR1(26,89)+WPx*VRR1(42,89)
      VRR0(64,90)=4.D0*r1x2E*VRR0(64,39)+QCy*VRR0(64,61)-4.D0*r1x2E*ZxZpE*VRR1(64,39)+WQy*VRR1(64,61)
      VRR0(64,91)=5.D0*r1x2E*VRR0(64,40)+QCy*VRR0(64,62)-5.D0*r1x2E*ZxZpE*VRR1(64,40)+WQy*VRR1(64,62)
      VRR0(64,92)=6.D0*r1x2E*VRR0(64,41)+QCy*VRR0(64,63)-6.D0*r1x2E*ZxZpE*VRR1(64,41)+WQy*VRR1(64,63)
      VRR0(64,93)=5.D0*r1x2E*VRR0(64,42)+QCx*VRR0(64,64)+5.D0*HfxZpE*VRR1(42,64)-5.D0*r1x2E*ZxZpE*VRR1(64,42)+WQx*VRR1(64,64)
      VRR0(64,94)=4.D0*r1x2E*VRR0(64,43)+QCx*VRR0(64,65)+5.D0*HfxZpE*VRR1(42,65)-4.D0*r1x2E*ZxZpE*VRR1(64,43)+WQx*VRR1(64,65)
      VRR0(64,95)=4.D0*r1x2Z*VRR0(26,95)+PAx*VRR0(42,95)-4.D0*ExZpE*r1x2Z*VRR1(26,95)+4.D0*HfxZpE*VRR1(42,66)+WPx*VRR1(42,95)
      VRR0(64,96)=3.D0*V(176)+4.D0*r1x2Z*VRR0(26,96)+PAx*VRR0(42,96)-4.D0*ExZpE*r1x2Z*VRR1(26,96)+WPx*VRR1(42,96)
      VRR0(64,97)=2.D0*V(177)+4.D0*r1x2Z*VRR0(26,97)+PAx*VRR0(42,97)-4.D0*ExZpE*r1x2Z*VRR1(26,97)+WPx*VRR1(42,97)
      VRR0(64,98)=4.D0*r1x2E*VRR0(64,45)+QCy*VRR0(64,68)-4.D0*r1x2E*ZxZpE*VRR1(64,45)+WQy*VRR1(64,68)
      VRR0(64,99)=5.D0*r1x2E*VRR0(64,46)+QCy*VRR0(64,69)-5.D0*r1x2E*ZxZpE*VRR1(64,46)+WQy*VRR1(64,69)
      VRR0(64,100)=4.D0*r1x2E*VRR0(64,47)+QCx*VRR0(64,70)+5.D0*HfxZpE*VRR1(42,70)-4.D0*r1x2E*ZxZpE*VRR1(64,47)+WQx*VRR1(64,70)
      VRR0(64,101)=4.D0*r1x2Z*VRR0(26,101)+PAx*VRR0(42,101)-4.D0*ExZpE*r1x2Z*VRR1(26,101)+4.D0*HfxZpE*VRR1(42,71)+WPx*VRR1(42,101)
      VRR0(64,102)=4.D0*r1x2Z*VRR0(26,102)+PAx*VRR0(42,102)-4.D0*ExZpE*r1x2Z*VRR1(26,102)+3.D0*HfxZpE*VRR1(42,72)+WPx*VRR1(42,102)
      VRR0(64,103)=2.D0*V(178)+4.D0*r1x2Z*VRR0(26,103)+PAx*VRR0(42,103)-4.D0*ExZpE*r1x2Z*VRR1(26,103)+WPx*VRR1(42,103)
      VRR0(64,104)=V(179)+4.D0*r1x2Z*VRR0(26,104)+PAx*VRR0(42,104)-4.D0*ExZpE*r1x2Z*VRR1(26,104)+WPx*VRR1(42,104)
      VRR0(64,105)=4.D0*r1x2E*VRR0(64,50)+QCy*VRR0(64,74)-4.D0*r1x2E*ZxZpE*VRR1(64,50)+WQy*VRR1(64,74)
      VRR0(64,106)=4.D0*V(180)+4.D0*r1x2Z*VRR0(26,106)+PAx*VRR0(42,106)-4.D0*ExZpE*r1x2Z*VRR1(26,106)+WPx*VRR1(42,106)
      VRR0(64,107)=3.D0*V(181)+4.D0*r1x2Z*VRR0(26,107)+PAx*VRR0(42,107)-4.D0*ExZpE*r1x2Z*VRR1(26,107)+WPx*VRR1(42,107)
      VRR0(64,108)=V(183)+4.D0*r1x2Z*VRR0(26,108)+PAx*VRR0(42,108)-4.D0*ExZpE*r1x2Z*VRR1(26,108)+WPx*VRR1(42,108)
      VRR0(64,109)=V(184)+4.D0*r1x2Z*VRR0(26,109)+PAx*VRR0(42,109)-4.D0*ExZpE*r1x2Z*VRR1(26,109)+WPx*VRR1(42,109)
      VRR0(64,110)=4.D0*r1x2Z*VRR0(26,110)+PAx*VRR0(42,110)-4.D0*ExZpE*r1x2Z*VRR1(26,110)+WPx*VRR1(42,110)
      VRR0(64,111)=3.D0*V(185)+4.D0*r1x2Z*VRR0(26,111)+PAx*VRR0(42,111)-4.D0*ExZpE*r1x2Z*VRR1(26,111)+WPx*VRR1(42,111)
      VRR0(64,112)=V(187)+4.D0*r1x2Z*VRR0(26,112)+PAx*VRR0(42,112)-4.D0*ExZpE*r1x2Z*VRR1(26,112)+WPx*VRR1(42,112)
      VRR0(64,113)=V(188)+4.D0*r1x2Z*VRR0(26,113)+PAx*VRR0(42,113)-4.D0*ExZpE*r1x2Z*VRR1(26,113)+WPx*VRR1(42,113)
      VRR0(64,114)=4.D0*r1x2Z*VRR0(26,114)+PAx*VRR0(42,114)-4.D0*ExZpE*r1x2Z*VRR1(26,114)+WPx*VRR1(42,114)
      VRR0(64,115)=V(6)+4.D0*r1x2E*VRR0(64,51)+QCz*VRR0(64,79)-4.D0*r1x2E*ZxZpE*VRR1(64,51)+WQz*VRR1(64,79)
      VRR0(64,116)=V(7)+4.D0*r1x2E*VRR0(64,52)+QCz*VRR0(64,80)-4.D0*r1x2E*ZxZpE*VRR1(64,52)+WQz*VRR1(64,80)
      VRR0(64,117)=V(8)+4.D0*r1x2E*VRR0(64,53)+QCz*VRR0(64,81)-4.D0*r1x2E*ZxZpE*VRR1(64,53)+WQz*VRR1(64,81)
      VRR0(64,118)=V(9)+5.D0*r1x2E*VRR0(64,54)+QCz*VRR0(64,82)-5.D0*r1x2E*ZxZpE*VRR1(64,54)+WQz*VRR1(64,82)
      VRR0(64,119)=V(10)+5.D0*r1x2E*VRR0(64,55)+QCz*VRR0(64,83)-5.D0*r1x2E*ZxZpE*VRR1(64,55)+WQz*VRR1(64,83)
      VRR0(64,120)=6.D0*r1x2E*VRR0(64,56)+QCz*VRR0(64,84)+HfxZpE*VRR1(36,84)-6.D0*r1x2E*ZxZpE*VRR1(64,56)+WQz*VRR1(64,84)
      VRR0(65,85)=6.D0*r1x2E*VRR0(65,36)+QCx*VRR0(65,57)+4.D0*HfxZpE*VRR1(43,57)-6.D0*r1x2E*ZxZpE*VRR1(65,36)+WQx*VRR1(65,57)
      VRR0(65,86)=5.D0*r1x2E*VRR0(65,37)+QCx*VRR0(65,58)+4.D0*HfxZpE*VRR1(43,58)-5.D0*r1x2E*ZxZpE*VRR1(65,37)+WQx*VRR1(65,58)
      VRR0(65,87)=4.D0*V(189)-4.D0*V(190)+QCx*VRR0(65,59)+4.D0*HfxZpE*VRR1(43,59)+WQx*VRR1(65,59)
      VRR0(65,88)=3.D0*V(191)+4.D0*V(192)-3.D0*V(193)+QCx*VRR0(65,60)+WQx*VRR1(65,60)
      VRR0(65,89)=V(174)+3.D0*V(189)-3.D0*V(190)+QCy*VRR0(65,60)+WQy*VRR1(65,60)
      VRR0(65,90)=V(175)+4.D0*V(191)-4.D0*V(193)+QCy*VRR0(65,61)+WQy*VRR1(65,61)
      VRR0(65,91)=5.D0*r1x2E*VRR0(65,40)+QCy*VRR0(65,62)+HfxZpE*VRR1(42,62)-5.D0*r1x2E*ZxZpE*VRR1(65,40)+WQy*VRR1(65,62)
      VRR0(65,92)=6.D0*r1x2E*VRR0(65,41)+QCy*VRR0(65,63)+HfxZpE*VRR1(42,63)-6.D0*r1x2E*ZxZpE*VRR1(65,41)+WQy*VRR1(65,63)
      VRR0(65,93)=5.D0*r1x2E*VRR0(65,42)+QCx*VRR0(65,64)+4.D0*HfxZpE*VRR1(43,64)-5.D0*r1x2E*ZxZpE*VRR1(65,42)+WQx*VRR1(65,64)
      VRR0(65,94)=4.D0*r1x2E*VRR0(65,43)+QCx*VRR0(65,65)+4.D0*HfxZpE*VRR1(43,65)-4.D0*r1x2E*ZxZpE*VRR1(65,43)+WQx*VRR1(65,65)
      VRR0(65,95)=V(195)+V(197)+QCx*VRR0(65,66)+4.D0*HfxZpE*VRR1(43,66)+WQx*VRR1(65,66)
      VRR0(65,96)=3.D0*V(198)+3.D0*r1x2Z*VRR0(27,96)+PAx*VRR0(43,96)-3.D0*ExZpE*r1x2Z*VRR1(27,96)+WPx*VRR1(43,96)
      VRR0(65,97)=V(176)+V(195)+V(197)+QCy*VRR0(65,67)+WQy*VRR1(65,67)
      VRR0(65,98)=V(177)+4.D0*r1x2E*VRR0(65,45)+QCy*VRR0(65,68)-4.D0*r1x2E*ZxZpE*VRR1(65,45)+WQy*VRR1(65,68)
      VRR0(65,99)=5.D0*r1x2E*VRR0(65,46)+QCy*VRR0(65,69)+HfxZpE*VRR1(42,69)-5.D0*r1x2E*ZxZpE*VRR1(65,46)+WQy*VRR1(65,69)
      VRR0(65,100)=4.D0*V(199)-4.D0*V(200)+QCx*VRR0(65,70)+4.D0*HfxZpE*VRR1(43,70)+WQx*VRR1(65,70)
      VRR0(65,101)=V(202)+V(204)+QCx*VRR0(65,71)+4.D0*HfxZpE*VRR1(43,71)+WQx*VRR1(65,71)
      VRR0(65,102)=3.D0*V(205)+3.D0*r1x2Z*VRR0(27,102)+PAx*VRR0(43,102)-3.D0*ExZpE*r1x2Z*VRR1(27,102)+WPx*VRR1(43,102)
      VRR0(65,103)=V(207)+3.D0*r1x2Z*VRR0(27,103)+PAx*VRR0(43,103)-3.D0*ExZpE*r1x2Z*VRR1(27,103)+WPx*VRR1(43,103)
      VRR0(65,104)=V(178)+V(209)+V(211)+QCy*VRR0(65,73)+WQy*VRR1(65,73)
      VRR0(65,105)=V(179)+4.D0*V(212)-4.D0*V(213)+QCy*VRR0(65,74)+WQy*VRR1(65,74)
      VRR0(65,106)=3.D0*V(214)+4.D0*V(215)-3.D0*V(216)+QCx*VRR0(65,75)+WQx*VRR1(65,75)
      VRR0(65,107)=3.D0*V(217)+3.D0*r1x2Z*VRR0(27,107)+PAx*VRR0(43,107)-3.D0*ExZpE*r1x2Z*VRR1(27,107)+WPx*VRR1(43,107)
      VRR0(65,108)=V(219)+3.D0*r1x2Z*VRR0(27,108)+PAx*VRR0(43,108)-3.D0*ExZpE*r1x2Z*VRR1(27,108)+WPx*VRR1(43,108)
      VRR0(65,109)=V(220)+3.D0*r1x2Z*VRR0(27,109)+PAx*VRR0(43,109)-3.D0*ExZpE*r1x2Z*VRR1(27,109)+WPx*VRR1(43,109)
      VRR0(65,110)=V(184)+3.D0*V(221)-3.D0*V(222)+QCy*VRR0(65,78)+WQy*VRR1(65,78)
      VRR0(65,111)=V(19)+3.D0*V(199)-3.D0*V(200)+QCz*VRR0(65,75)+WQz*VRR1(65,75)
      VRR0(65,112)=V(20)+V(202)+V(204)+QCz*VRR0(65,76)+WQz*VRR1(65,76)
      VRR0(65,113)=V(21)+V(209)+V(211)+QCz*VRR0(65,77)+WQz*VRR1(65,77)
      VRR0(65,114)=V(22)+3.D0*V(212)-3.D0*V(213)+QCz*VRR0(65,78)+WQz*VRR1(65,78)
      VRR0(65,115)=V(23)+4.D0*V(214)-4.D0*V(216)+QCz*VRR0(65,79)+WQz*VRR1(65,79)
      VRR0(65,116)=V(24)+4.D0*r1x2E*VRR0(65,52)+QCz*VRR0(65,80)-4.D0*r1x2E*ZxZpE*VRR1(65,52)+WQz*VRR1(65,80)
      VRR0(65,117)=V(25)+4.D0*V(221)-4.D0*V(222)+QCz*VRR0(65,81)+WQz*VRR1(65,81)
      VRR0(65,118)=5.D0*r1x2E*VRR0(65,54)+QCz*VRR0(65,82)+HfxZpE*VRR1(37,82)-5.D0*r1x2E*ZxZpE*VRR1(65,54)+WQz*VRR1(65,82)
      VRR0(65,119)=5.D0*r1x2E*VRR0(65,55)+QCz*VRR0(65,83)+HfxZpE*VRR1(37,83)-5.D0*r1x2E*ZxZpE*VRR1(65,55)+WQz*VRR1(65,83)
      VRR0(65,120)=6.D0*r1x2E*VRR0(65,56)+QCz*VRR0(65,84)+HfxZpE*VRR1(37,84)-6.D0*r1x2E*ZxZpE*VRR1(65,56)+WQz*VRR1(65,84)
      VRR0(66,85)=6.D0*r1x2E*VRR0(66,36)+QCx*VRR0(66,57)+3.D0*HfxZpE*VRR1(44,57)-6.D0*r1x2E*ZxZpE*VRR1(66,36)+WQx*VRR1(66,57)
      VRR0(66,86)=5.D0*r1x2E*VRR0(66,37)+QCx*VRR0(66,58)+3.D0*HfxZpE*VRR1(44,58)-5.D0*r1x2E*ZxZpE*VRR1(66,37)+WQx*VRR1(66,58)
      VRR0(66,87)=4.D0*V(223)-4.D0*V(224)+QCx*VRR0(66,59)+3.D0*HfxZpE*VRR1(44,59)+WQx*VRR1(66,59)
      VRR0(66,88)=3.D0*V(225)+V(227)-3.D0*V(228)+QCx*VRR0(66,60)+WQx*VRR1(66,60)
      VRR0(66,89)=2.D0*V(192)+3.D0*V(223)-3.D0*V(224)+QCy*VRR0(66,60)+WQy*VRR1(66,60)
      VRR0(66,90)=4.D0*V(225)-4.D0*V(228)+QCy*VRR0(66,61)+2.D0*HfxZpE*VRR1(43,61)+WQy*VRR1(66,61)
      VRR0(66,91)=5.D0*r1x2E*VRR0(66,40)+QCy*VRR0(66,62)+2.D0*HfxZpE*VRR1(43,62)-5.D0*r1x2E*ZxZpE*VRR1(66,40)+WQy*VRR1(66,62)
      VRR0(66,92)=6.D0*r1x2E*VRR0(66,41)+QCy*VRR0(66,63)+2.D0*HfxZpE*VRR1(43,63)-6.D0*r1x2E*ZxZpE*VRR1(66,41)+WQy*VRR1(66,63)
      VRR0(66,93)=5.D0*r1x2E*VRR0(66,42)+QCx*VRR0(66,64)+3.D0*HfxZpE*VRR1(44,64)-5.D0*r1x2E*ZxZpE*VRR1(66,42)+WQx*VRR1(66,64)
      VRR0(66,94)=4.D0*r1x2E*VRR0(66,43)+QCx*VRR0(66,65)+3.D0*HfxZpE*VRR1(44,65)-4.D0*r1x2E*ZxZpE*VRR1(66,43)+WQx*VRR1(66,65)
      VRR0(66,95)=V(230)+V(232)+QCx*VRR0(66,66)+3.D0*HfxZpE*VRR1(44,66)+WQx*VRR1(66,66)
      VRR0(66,96)=2.D0*V(233)+V(235)-2.D0*V(236)+QCx*VRR0(66,67)+WQx*VRR1(66,67)
      VRR0(66,97)=2.D0*V(198)+V(230)+V(232)+QCy*VRR0(66,67)+WQy*VRR1(66,67)
      VRR0(66,98)=4.D0*V(233)-4.D0*V(236)+QCy*VRR0(66,68)+2.D0*HfxZpE*VRR1(43,68)+WQy*VRR1(66,68)
      VRR0(66,99)=5.D0*r1x2E*VRR0(66,46)+QCy*VRR0(66,69)+2.D0*HfxZpE*VRR1(43,69)-5.D0*r1x2E*ZxZpE*VRR1(66,46)+WQy*VRR1(66,69)
      VRR0(66,100)=4.D0*V(237)-4.D0*V(238)+QCx*VRR0(66,70)+3.D0*HfxZpE*VRR1(44,70)+WQx*VRR1(66,70)
      VRR0(66,101)=V(240)+V(242)+QCx*VRR0(66,71)+3.D0*HfxZpE*VRR1(44,71)+WQx*VRR1(66,71)
      VRR0(66,102)=2.D0*V(243)+V(245)-2.D0*V(246)+QCx*VRR0(66,72)+WQx*VRR1(66,72)
      VRR0(66,103)=2.D0*V(239)-2.D0*V(241)+V(247)+QCy*VRR0(66,72)+WQy*VRR1(66,72)
      VRR0(66,104)=V(207)+V(248)+V(249)+QCy*VRR0(66,73)+WQy*VRR1(66,73)
      VRR0(66,105)=4.D0*V(250)-4.D0*V(251)+QCy*VRR0(66,74)+2.D0*HfxZpE*VRR1(43,74)+WQy*VRR1(66,74)
      VRR0(66,106)=3.D0*V(252)+3.D0*V(253)-3.D0*V(254)+QCx*VRR0(66,75)+WQx*VRR1(66,75)
      VRR0(66,107)=V(256)+3.D0*V(257)+V(259)+QCx*VRR0(66,76)+WQx*VRR1(66,76)
      VRR0(66,108)=V(51)+2.D0*V(229)-2.D0*V(231)+QCz*VRR0(66,72)+WQz*VRR1(66,72)
      VRR0(66,109)=V(219)+V(256)+V(259)+QCy*VRR0(66,77)+WQy*VRR1(66,77)
      VRR0(66,110)=3.D0*V(260)+V(261)-3.D0*V(262)+QCy*VRR0(66,78)+WQy*VRR1(66,78)
      VRR0(66,111)=V(65)+3.D0*V(237)-3.D0*V(238)+QCz*VRR0(66,75)+WQz*VRR1(66,75)
      VRR0(66,112)=V(71)+V(240)+V(242)+QCz*VRR0(66,76)+WQz*VRR1(66,76)
      VRR0(66,113)=V(76)+V(248)+V(249)+QCz*VRR0(66,77)+WQz*VRR1(66,77)
      VRR0(66,114)=V(81)+3.D0*V(250)-3.D0*V(251)+QCz*VRR0(66,78)+WQz*VRR1(66,78)
      VRR0(66,115)=4.D0*V(252)-4.D0*V(254)+QCz*VRR0(66,79)+HfxZpE*VRR1(38,79)+WQz*VRR1(66,79)
      VRR0(66,116)=4.D0*V(255)-4.D0*V(258)+QCz*VRR0(66,80)+HfxZpE*VRR1(38,80)+WQz*VRR1(66,80)
      VRR0(66,117)=4.D0*V(260)-4.D0*V(262)+QCz*VRR0(66,81)+HfxZpE*VRR1(38,81)+WQz*VRR1(66,81)
      VRR0(66,118)=5.D0*r1x2E*VRR0(66,54)+QCz*VRR0(66,82)+HfxZpE*VRR1(38,82)-5.D0*r1x2E*ZxZpE*VRR1(66,54)+WQz*VRR1(66,82)
      VRR0(66,119)=5.D0*r1x2E*VRR0(66,55)+QCz*VRR0(66,83)+HfxZpE*VRR1(38,83)-5.D0*r1x2E*ZxZpE*VRR1(66,55)+WQz*VRR1(66,83)
      VRR0(66,120)=6.D0*r1x2E*VRR0(66,56)+QCz*VRR0(66,84)+HfxZpE*VRR1(38,84)-6.D0*r1x2E*ZxZpE*VRR1(66,56)+WQz*VRR1(66,84)
      VRR0(67,85)=6.D0*r1x2E*VRR0(67,36)+QCx*VRR0(67,57)+2.D0*HfxZpE*VRR1(45,57)-6.D0*r1x2E*ZxZpE*VRR1(67,36)+WQx*VRR1(67,57)
      VRR0(67,86)=5.D0*r1x2E*VRR0(67,37)+QCx*VRR0(67,58)+2.D0*HfxZpE*VRR1(45,58)-5.D0*r1x2E*ZxZpE*VRR1(67,37)+WQx*VRR1(67,58)
      VRR0(67,87)=4.D0*V(263)-4.D0*V(264)+QCx*VRR0(67,59)+2.D0*HfxZpE*VRR1(45,59)+WQx*VRR1(67,59)
      VRR0(67,88)=3.D0*V(265)+2.D0*V(266)-3.D0*V(267)+QCx*VRR0(67,60)+WQx*VRR1(67,60)
      VRR0(67,89)=V(227)+3.D0*V(263)-3.D0*V(264)+QCy*VRR0(67,60)+WQy*VRR1(67,60)
      VRR0(67,90)=4.D0*V(265)-4.D0*V(267)+QCy*VRR0(67,61)+3.D0*HfxZpE*VRR1(44,61)+WQy*VRR1(67,61)
      VRR0(67,91)=5.D0*r1x2E*VRR0(67,40)+QCy*VRR0(67,62)+3.D0*HfxZpE*VRR1(44,62)-5.D0*r1x2E*ZxZpE*VRR1(67,40)+WQy*VRR1(67,62)
      VRR0(67,92)=6.D0*r1x2E*VRR0(67,41)+QCy*VRR0(67,63)+3.D0*HfxZpE*VRR1(44,63)-6.D0*r1x2E*ZxZpE*VRR1(67,41)+WQy*VRR1(67,63)
      VRR0(67,93)=5.D0*r1x2E*VRR0(67,42)+QCx*VRR0(67,64)+2.D0*HfxZpE*VRR1(45,64)-5.D0*r1x2E*ZxZpE*VRR1(67,42)+WQx*VRR1(67,64)
      VRR0(67,94)=4.D0*r1x2E*VRR0(67,43)+QCx*VRR0(67,65)+2.D0*HfxZpE*VRR1(45,65)-4.D0*r1x2E*ZxZpE*VRR1(67,43)+WQx*VRR1(67,65)
      VRR0(67,95)=V(269)+2.D0*V(270)+V(272)+QCx*VRR0(67,66)+WQx*VRR1(67,66)
      VRR0(67,96)=2.D0*V(273)+2.D0*V(274)-2.D0*V(275)+QCx*VRR0(67,67)+WQx*VRR1(67,67)
      VRR0(67,97)=V(235)+V(269)+V(272)+QCy*VRR0(67,67)+WQy*VRR1(67,67)
      VRR0(67,98)=4.D0*V(273)-4.D0*V(275)+QCy*VRR0(67,68)+3.D0*HfxZpE*VRR1(44,68)+WQy*VRR1(67,68)
      VRR0(67,99)=5.D0*r1x2E*VRR0(67,46)+QCy*VRR0(67,69)+3.D0*HfxZpE*VRR1(44,69)-5.D0*r1x2E*ZxZpE*VRR1(67,46)+WQy*VRR1(67,69)
      VRR0(67,100)=4.D0*V(276)-4.D0*V(277)+QCx*VRR0(67,70)+2.D0*HfxZpE*VRR1(45,70)+WQx*VRR1(67,70)
      VRR0(67,101)=V(279)+V(281)+V(283)+QCx*VRR0(67,71)+WQx*VRR1(67,71)
      VRR0(67,102)=2.D0*V(284)+V(286)-2.D0*V(287)+QCx*VRR0(67,72)+WQx*VRR1(67,72)
      VRR0(67,103)=V(245)+2.D0*V(278)-2.D0*V(282)+QCy*VRR0(67,72)+WQy*VRR1(67,72)
      VRR0(67,104)=V(288)+V(289)+QCy*VRR0(67,73)+3.D0*HfxZpE*VRR1(44,73)+WQy*VRR1(67,73)
      VRR0(67,105)=4.D0*V(290)-4.D0*V(291)+QCy*VRR0(67,74)+3.D0*HfxZpE*VRR1(44,74)+WQy*VRR1(67,74)
      VRR0(67,106)=3.D0*V(292)+V(294)-3.D0*V(295)+QCx*VRR0(67,75)+WQx*VRR1(67,75)
      VRR0(67,107)=V(297)+V(299)+V(301)+QCx*VRR0(67,76)+WQx*VRR1(67,76)
      VRR0(67,108)=V(106)+2.D0*V(268)-2.D0*V(271)+QCz*VRR0(67,72)+WQz*VRR1(67,72)
      VRR0(67,109)=V(297)+V(301)+3.D0*V(302)+QCy*VRR0(67,77)+WQy*VRR1(67,77)
      VRR0(67,110)=3.D0*V(303)+3.D0*V(304)-3.D0*V(305)+QCy*VRR0(67,78)+WQy*VRR1(67,78)
      VRR0(67,111)=V(114)+3.D0*V(276)-3.D0*V(277)+QCz*VRR0(67,75)+WQz*VRR1(67,75)
      VRR0(67,112)=V(118)+V(279)+V(283)+QCz*VRR0(67,76)+WQz*VRR1(67,76)
      VRR0(67,113)=V(154)+V(288)+V(289)+QCz*VRR0(67,77)+WQz*VRR1(67,77)
      VRR0(67,114)=V(156)+3.D0*V(290)-3.D0*V(291)+QCz*VRR0(67,78)+WQz*VRR1(67,78)
      VRR0(67,115)=4.D0*V(292)-4.D0*V(295)+QCz*VRR0(67,79)+HfxZpE*VRR1(39,79)+WQz*VRR1(67,79)
      VRR0(67,116)=4.D0*V(296)-4.D0*V(300)+QCz*VRR0(67,80)+HfxZpE*VRR1(39,80)+WQz*VRR1(67,80)
      VRR0(67,117)=4.D0*V(303)-4.D0*V(305)+QCz*VRR0(67,81)+HfxZpE*VRR1(39,81)+WQz*VRR1(67,81)
      VRR0(67,118)=5.D0*r1x2E*VRR0(67,54)+QCz*VRR0(67,82)+HfxZpE*VRR1(39,82)-5.D0*r1x2E*ZxZpE*VRR1(67,54)+WQz*VRR1(67,82)
      VRR0(67,119)=5.D0*r1x2E*VRR0(67,55)+QCz*VRR0(67,83)+HfxZpE*VRR1(39,83)-5.D0*r1x2E*ZxZpE*VRR1(67,55)+WQz*VRR1(67,83)
      VRR0(67,120)=6.D0*r1x2E*VRR0(67,56)+QCz*VRR0(67,84)+HfxZpE*VRR1(39,84)-6.D0*r1x2E*ZxZpE*VRR1(67,56)+WQz*VRR1(67,84)
      VRR0(68,85)=6.D0*r1x2E*VRR0(68,36)+QCx*VRR0(68,57)+HfxZpE*VRR1(46,57)-6.D0*r1x2E*ZxZpE*VRR1(68,36)+WQx*VRR1(68,57)
      VRR0(68,86)=5.D0*r1x2E*VRR0(68,37)+QCx*VRR0(68,58)+HfxZpE*VRR1(46,58)-5.D0*r1x2E*ZxZpE*VRR1(68,37)+WQx*VRR1(68,58)
      VRR0(68,87)=4.D0*V(306)+V(307)-4.D0*V(308)+QCx*VRR0(68,59)+WQx*VRR1(68,59)
      VRR0(68,88)=3.D0*V(309)+V(310)-3.D0*V(311)+QCx*VRR0(68,60)+WQx*VRR1(68,60)
      VRR0(68,89)=4.D0*V(266)+3.D0*V(306)-3.D0*V(308)+QCy*VRR0(68,60)+WQy*VRR1(68,60)
      VRR0(68,90)=4.D0*V(309)-4.D0*V(311)+QCy*VRR0(68,61)+4.D0*HfxZpE*VRR1(45,61)+WQy*VRR1(68,61)
      VRR0(68,91)=5.D0*r1x2E*VRR0(68,40)+QCy*VRR0(68,62)+4.D0*HfxZpE*VRR1(45,62)-5.D0*r1x2E*ZxZpE*VRR1(68,40)+WQy*VRR1(68,62)
      VRR0(68,92)=6.D0*r1x2E*VRR0(68,41)+QCy*VRR0(68,63)+4.D0*HfxZpE*VRR1(45,63)-6.D0*r1x2E*ZxZpE*VRR1(68,41)+WQy*VRR1(68,63)
      VRR0(68,93)=5.D0*r1x2E*VRR0(68,42)+QCx*VRR0(68,64)+HfxZpE*VRR1(46,64)-5.D0*r1x2E*ZxZpE*VRR1(68,42)+WQx*VRR1(68,64)
      VRR0(68,94)=V(312)+4.D0*r1x2E*VRR0(68,43)+QCx*VRR0(68,65)-4.D0*r1x2E*ZxZpE*VRR1(68,43)+WQx*VRR1(68,65)
      VRR0(68,95)=V(314)+V(315)+V(317)+QCx*VRR0(68,66)+WQx*VRR1(68,66)
      VRR0(68,96)=3.D0*V(270)+3.D0*r1x2Z*VRR0(28,96)+PAy*VRR0(45,96)-3.D0*ExZpE*r1x2Z*VRR1(28,96)+WPy*VRR1(45,96)
      VRR0(68,97)=4.D0*V(274)+V(314)+V(317)+QCy*VRR0(68,67)+WQy*VRR1(68,67)
      VRR0(68,98)=4.D0*r1x2E*VRR0(68,45)+QCy*VRR0(68,68)+4.D0*HfxZpE*VRR1(45,68)-4.D0*r1x2E*ZxZpE*VRR1(68,45)+WQy*VRR1(68,68)
      VRR0(68,99)=5.D0*r1x2E*VRR0(68,46)+QCy*VRR0(68,69)+4.D0*HfxZpE*VRR1(45,69)-5.D0*r1x2E*ZxZpE*VRR1(68,46)+WQy*VRR1(68,69)
      VRR0(68,100)=4.D0*V(318)+V(319)-4.D0*V(320)+QCx*VRR0(68,70)+WQx*VRR1(68,70)
      VRR0(68,101)=V(322)+V(323)+V(325)+QCx*VRR0(68,71)+WQx*VRR1(68,71)
      VRR0(68,102)=V(281)+3.D0*r1x2Z*VRR0(28,102)+PAy*VRR0(45,102)-3.D0*ExZpE*r1x2Z*VRR1(28,102)+WPy*VRR1(45,102)
      VRR0(68,103)=3.D0*V(285)+3.D0*r1x2Z*VRR0(28,103)+PAy*VRR0(45,103)-3.D0*ExZpE*r1x2Z*VRR1(28,103)+WPy*VRR1(45,103)
      VRR0(68,104)=V(327)+V(329)+QCy*VRR0(68,73)+4.D0*HfxZpE*VRR1(45,73)+WQy*VRR1(68,73)
      VRR0(68,105)=4.D0*V(330)-4.D0*V(331)+QCy*VRR0(68,74)+4.D0*HfxZpE*VRR1(45,74)+WQy*VRR1(68,74)
      VRR0(68,106)=3.D0*V(332)+V(333)-3.D0*V(334)+QCx*VRR0(68,75)+WQx*VRR1(68,75)
      VRR0(68,107)=V(293)+3.D0*r1x2Z*VRR0(28,107)+PAy*VRR0(45,107)-3.D0*ExZpE*r1x2Z*VRR1(28,107)+WPy*VRR1(45,107)
      VRR0(68,108)=V(299)+3.D0*r1x2Z*VRR0(28,108)+PAy*VRR0(45,108)-3.D0*ExZpE*r1x2Z*VRR1(28,108)+WPy*VRR1(45,108)
      VRR0(68,109)=3.D0*V(335)+3.D0*r1x2Z*VRR0(28,109)+PAy*VRR0(45,109)-3.D0*ExZpE*r1x2Z*VRR1(28,109)+WPy*VRR1(45,109)
      VRR0(68,110)=3.D0*V(336)+4.D0*V(337)-3.D0*V(338)+QCy*VRR0(68,78)+WQy*VRR1(68,78)
      VRR0(68,111)=V(152)+3.D0*V(318)-3.D0*V(320)+QCz*VRR0(68,75)+WQz*VRR1(68,75)
      VRR0(68,112)=V(163)+V(322)+V(325)+QCz*VRR0(68,76)+WQz*VRR1(68,76)
      VRR0(68,113)=V(164)+V(327)+V(329)+QCz*VRR0(68,77)+WQz*VRR1(68,77)
      VRR0(68,114)=V(165)+3.D0*V(330)-3.D0*V(331)+QCz*VRR0(68,78)+WQz*VRR1(68,78)
      VRR0(68,115)=V(166)+4.D0*V(332)-4.D0*V(334)+QCz*VRR0(68,79)+WQz*VRR1(68,79)
      VRR0(68,116)=V(167)+4.D0*r1x2E*VRR0(68,52)+QCz*VRR0(68,80)-4.D0*r1x2E*ZxZpE*VRR1(68,52)+WQz*VRR1(68,80)
      VRR0(68,117)=V(168)+4.D0*V(336)-4.D0*V(338)+QCz*VRR0(68,81)+WQz*VRR1(68,81)
      VRR0(68,118)=5.D0*r1x2E*VRR0(68,54)+QCz*VRR0(68,82)+HfxZpE*VRR1(40,82)-5.D0*r1x2E*ZxZpE*VRR1(68,54)+WQz*VRR1(68,82)
      VRR0(68,119)=5.D0*r1x2E*VRR0(68,55)+QCz*VRR0(68,83)+HfxZpE*VRR1(40,83)-5.D0*r1x2E*ZxZpE*VRR1(68,55)+WQz*VRR1(68,83)
      VRR0(68,120)=6.D0*r1x2E*VRR0(68,56)+QCz*VRR0(68,84)+HfxZpE*VRR1(40,84)-6.D0*r1x2E*ZxZpE*VRR1(68,56)+WQz*VRR1(68,84)
      VRR0(69,85)=6.D0*r1x2E*VRR0(69,36)+QCx*VRR0(69,57)-6.D0*r1x2E*ZxZpE*VRR1(69,36)+WQx*VRR1(69,57)
      VRR0(69,86)=5.D0*r1x2E*VRR0(69,37)+QCx*VRR0(69,58)-5.D0*r1x2E*ZxZpE*VRR1(69,37)+WQx*VRR1(69,58)
      VRR0(69,87)=4.D0*r1x2E*VRR0(69,38)+QCx*VRR0(69,59)-4.D0*r1x2E*ZxZpE*VRR1(69,38)+WQx*VRR1(69,59)
      VRR0(69,88)=3.D0*V(307)+4.D0*r1x2Z*VRR0(29,88)+PAy*VRR0(46,88)-4.D0*ExZpE*r1x2Z*VRR1(29,88)+WPy*VRR1(46,88)
      VRR0(69,89)=4.D0*V(310)+4.D0*r1x2Z*VRR0(29,89)+PAy*VRR0(46,89)-4.D0*ExZpE*r1x2Z*VRR1(29,89)+WPy*VRR1(46,89)
      VRR0(69,90)=4.D0*r1x2E*VRR0(69,39)+QCy*VRR0(69,61)+5.D0*HfxZpE*VRR1(46,61)-4.D0*r1x2E*ZxZpE*VRR1(69,39)+WQy*VRR1(69,61)
      VRR0(69,91)=5.D0*r1x2E*VRR0(69,40)+QCy*VRR0(69,62)+5.D0*HfxZpE*VRR1(46,62)-5.D0*r1x2E*ZxZpE*VRR1(69,40)+WQy*VRR1(69,62)
      VRR0(69,92)=6.D0*r1x2E*VRR0(69,41)+QCy*VRR0(69,63)+5.D0*HfxZpE*VRR1(46,63)-6.D0*r1x2E*ZxZpE*VRR1(69,41)+WQy*VRR1(69,63)
      VRR0(69,93)=5.D0*r1x2E*VRR0(69,42)+QCx*VRR0(69,64)-5.D0*r1x2E*ZxZpE*VRR1(69,42)+WQx*VRR1(69,64)
      VRR0(69,94)=4.D0*r1x2E*VRR0(69,43)+QCx*VRR0(69,65)-4.D0*r1x2E*ZxZpE*VRR1(69,43)+WQx*VRR1(69,65)
      VRR0(69,95)=2.D0*V(312)+4.D0*r1x2Z*VRR0(29,95)+PAy*VRR0(46,95)-4.D0*ExZpE*r1x2Z*VRR1(29,95)+WPy*VRR1(46,95)
      VRR0(69,96)=3.D0*V(315)+4.D0*r1x2Z*VRR0(29,96)+PAy*VRR0(46,96)-4.D0*ExZpE*r1x2Z*VRR1(29,96)+WPy*VRR1(46,96)
      VRR0(69,97)=4.D0*r1x2Z*VRR0(29,97)+PAy*VRR0(46,97)-4.D0*ExZpE*r1x2Z*VRR1(29,97)+4.D0*HfxZpE*VRR1(46,67)+WPy*VRR1(46,97)
      VRR0(69,98)=4.D0*r1x2E*VRR0(69,45)+QCy*VRR0(69,68)+5.D0*HfxZpE*VRR1(46,68)-4.D0*r1x2E*ZxZpE*VRR1(69,45)+WQy*VRR1(69,68)
      VRR0(69,99)=5.D0*r1x2E*VRR0(69,46)+QCy*VRR0(69,69)+5.D0*HfxZpE*VRR1(46,69)-5.D0*r1x2E*ZxZpE*VRR1(69,46)+WQy*VRR1(69,69)
      VRR0(69,100)=4.D0*r1x2E*VRR0(69,47)+QCx*VRR0(69,70)-4.D0*r1x2E*ZxZpE*VRR1(69,47)+WQx*VRR1(69,70)
      VRR0(69,101)=V(319)+4.D0*r1x2Z*VRR0(29,101)+PAy*VRR0(46,101)-4.D0*ExZpE*r1x2Z*VRR1(29,101)+WPy*VRR1(46,101)
      VRR0(69,102)=2.D0*V(323)+4.D0*r1x2Z*VRR0(29,102)+PAy*VRR0(46,102)-4.D0*ExZpE*r1x2Z*VRR1(29,102)+WPy*VRR1(46,102)
      VRR0(69,103)=4.D0*r1x2Z*VRR0(29,103)+PAy*VRR0(46,103)-4.D0*ExZpE*r1x2Z*VRR1(29,103)+3.D0*HfxZpE*VRR1(46,72)+WPy*VRR1(46,103)
      VRR0(69,104)=4.D0*r1x2Z*VRR0(29,104)+PAy*VRR0(46,104)-4.D0*ExZpE*r1x2Z*VRR1(29,104)+4.D0*HfxZpE*VRR1(46,73)+WPy*VRR1(46,104)
      VRR0(69,105)=4.D0*r1x2E*VRR0(69,50)+QCy*VRR0(69,74)+5.D0*HfxZpE*VRR1(46,74)-4.D0*r1x2E*ZxZpE*VRR1(69,50)+WQy*VRR1(69,74)
      VRR0(69,106)=4.D0*r1x2Z*VRR0(29,106)+PAy*VRR0(46,106)-4.D0*ExZpE*r1x2Z*VRR1(29,106)+WPy*VRR1(46,106)
      VRR0(69,107)=V(333)+4.D0*r1x2Z*VRR0(29,107)+PAy*VRR0(46,107)-4.D0*ExZpE*r1x2Z*VRR1(29,107)+WPy*VRR1(46,107)
      VRR0(69,108)=V(340)+4.D0*r1x2Z*VRR0(29,108)+PAy*VRR0(46,108)-4.D0*ExZpE*r1x2Z*VRR1(29,108)+WPy*VRR1(46,108)
      VRR0(69,109)=3.D0*V(341)+4.D0*r1x2Z*VRR0(29,109)+PAy*VRR0(46,109)-4.D0*ExZpE*r1x2Z*VRR1(29,109)+WPy*VRR1(46,109)
      VRR0(69,110)=4.D0*V(342)+4.D0*r1x2Z*VRR0(29,110)+PAy*VRR0(46,110)-4.D0*ExZpE*r1x2Z*VRR1(29,110)+WPy*VRR1(46,110)
      VRR0(69,111)=4.D0*r1x2Z*VRR0(29,111)+PAy*VRR0(46,111)-4.D0*ExZpE*r1x2Z*VRR1(29,111)+WPy*VRR1(46,111)
      VRR0(69,112)=V(343)+4.D0*r1x2Z*VRR0(29,112)+PAy*VRR0(46,112)-4.D0*ExZpE*r1x2Z*VRR1(29,112)+WPy*VRR1(46,112)
      VRR0(69,113)=V(345)+4.D0*r1x2Z*VRR0(29,113)+PAy*VRR0(46,113)-4.D0*ExZpE*r1x2Z*VRR1(29,113)+WPy*VRR1(46,113)
      VRR0(69,114)=3.D0*V(346)+4.D0*r1x2Z*VRR0(29,114)+PAy*VRR0(46,114)-4.D0*ExZpE*r1x2Z*VRR1(29,114)+WPy*VRR1(46,114)
      VRR0(69,115)=V(169)+4.D0*r1x2E*VRR0(69,51)+QCz*VRR0(69,79)-4.D0*r1x2E*ZxZpE*VRR1(69,51)+WQz*VRR1(69,79)
      VRR0(69,116)=V(170)+4.D0*r1x2E*VRR0(69,52)+QCz*VRR0(69,80)-4.D0*r1x2E*ZxZpE*VRR1(69,52)+WQz*VRR1(69,80)
      VRR0(69,117)=V(171)+4.D0*r1x2E*VRR0(69,53)+QCz*VRR0(69,81)-4.D0*r1x2E*ZxZpE*VRR1(69,53)+WQz*VRR1(69,81)
      VRR0(69,118)=V(172)+5.D0*r1x2E*VRR0(69,54)+QCz*VRR0(69,82)-5.D0*r1x2E*ZxZpE*VRR1(69,54)+WQz*VRR1(69,82)
      VRR0(69,119)=V(173)+5.D0*r1x2E*VRR0(69,55)+QCz*VRR0(69,83)-5.D0*r1x2E*ZxZpE*VRR1(69,55)+WQz*VRR1(69,83)
      VRR0(69,120)=6.D0*r1x2E*VRR0(69,56)+QCz*VRR0(69,84)+HfxZpE*VRR1(41,84)-6.D0*r1x2E*ZxZpE*VRR1(69,56)+WQz*VRR1(69,84)
      VRR0(70,85)=6.D0*r1x2E*VRR0(70,36)+QCx*VRR0(70,57)+4.D0*HfxZpE*VRR1(47,57)-6.D0*r1x2E*ZxZpE*VRR1(70,36)+WQx*VRR1(70,57)
      VRR0(70,86)=5.D0*r1x2E*VRR0(70,37)+QCx*VRR0(70,58)+4.D0*HfxZpE*VRR1(47,58)-5.D0*r1x2E*ZxZpE*VRR1(70,37)+WQx*VRR1(70,58)
      VRR0(70,87)=4.D0*V(347)-4.D0*V(348)+QCx*VRR0(70,59)+4.D0*HfxZpE*VRR1(47,59)+WQx*VRR1(70,59)
      VRR0(70,88)=3.D0*V(349)+4.D0*V(350)-3.D0*V(351)+QCx*VRR0(70,60)+WQx*VRR1(70,60)
      VRR0(70,89)=3.D0*V(347)-3.D0*V(348)+QCy*VRR0(70,60)+WQy*VRR1(70,60)
      VRR0(70,90)=4.D0*V(349)-4.D0*V(351)+QCy*VRR0(70,61)+WQy*VRR1(70,61)
      VRR0(70,91)=5.D0*r1x2E*VRR0(70,40)+QCy*VRR0(70,62)-5.D0*r1x2E*ZxZpE*VRR1(70,40)+WQy*VRR1(70,62)
      VRR0(70,92)=6.D0*r1x2E*VRR0(70,41)+QCy*VRR0(70,63)-6.D0*r1x2E*ZxZpE*VRR1(70,41)+WQy*VRR1(70,63)
      VRR0(70,93)=5.D0*r1x2E*VRR0(70,42)+QCx*VRR0(70,64)+4.D0*HfxZpE*VRR1(47,64)-5.D0*r1x2E*ZxZpE*VRR1(70,42)+WQx*VRR1(70,64)
      VRR0(70,94)=4.D0*r1x2E*VRR0(70,43)+QCx*VRR0(70,65)+4.D0*HfxZpE*VRR1(47,65)-4.D0*r1x2E*ZxZpE*VRR1(70,43)+WQx*VRR1(70,65)
      VRR0(70,95)=V(353)+V(355)+QCx*VRR0(70,66)+4.D0*HfxZpE*VRR1(47,66)+WQx*VRR1(70,66)
      VRR0(70,96)=V(357)+V(359)+3.D0*V(360)+PAx*VRR0(47,96)+WPx*VRR1(47,96)
      VRR0(70,97)=V(353)+V(355)+QCy*VRR0(70,67)+WQy*VRR1(70,67)
      VRR0(70,98)=4.D0*r1x2E*VRR0(70,45)+QCy*VRR0(70,68)-4.D0*r1x2E*ZxZpE*VRR1(70,45)+WQy*VRR1(70,68)
      VRR0(70,99)=5.D0*r1x2E*VRR0(70,46)+QCy*VRR0(70,69)-5.D0*r1x2E*ZxZpE*VRR1(70,46)+WQy*VRR1(70,69)
      VRR0(70,100)=4.D0*V(361)-4.D0*V(362)+QCx*VRR0(70,70)+4.D0*HfxZpE*VRR1(47,70)+WQx*VRR1(70,70)
      VRR0(70,101)=V(364)+V(366)+QCx*VRR0(70,71)+4.D0*HfxZpE*VRR1(47,71)+WQx*VRR1(70,71)
      VRR0(70,102)=V(368)+V(370)+V(372)+PAx*VRR0(47,102)+WPx*VRR1(47,102)
      VRR0(70,103)=V(374)+V(376)+2.D0*V(377)+PAx*VRR0(47,103)+WPx*VRR1(47,103)
      VRR0(70,104)=V(379)+V(381)+QCy*VRR0(70,73)+WQy*VRR1(70,73)
      VRR0(70,105)=4.D0*V(382)-4.D0*V(383)+QCy*VRR0(70,74)+WQy*VRR1(70,74)
      VRR0(70,106)=3.D0*V(384)+4.D0*V(385)-3.D0*V(386)+QCx*VRR0(70,75)+WQx*VRR1(70,75)
      VRR0(70,107)=V(388)+V(390)+V(392)+PAx*VRR0(47,107)+WPx*VRR1(47,107)
      VRR0(70,108)=V(394)+V(396)+2.D0*V(397)+PAx*VRR0(47,108)+WPx*VRR1(47,108)
      VRR0(70,109)=V(399)+V(401)+V(402)+PAx*VRR0(47,109)+WPx*VRR1(47,109)
      VRR0(70,110)=3.D0*V(403)-3.D0*V(404)+QCy*VRR0(70,78)+WQy*VRR1(70,78)
      VRR0(70,111)=2.D0*V(180)+3.D0*V(361)-3.D0*V(362)+QCz*VRR0(70,75)+WQz*VRR1(70,75)
      VRR0(70,112)=2.D0*V(181)+V(364)+V(366)+QCz*VRR0(70,76)+WQz*VRR1(70,76)
      VRR0(70,113)=V(183)+V(379)+V(381)+QCz*VRR0(70,77)+WQz*VRR1(70,77)
      VRR0(70,114)=2.D0*V(184)+3.D0*V(382)-3.D0*V(383)+QCz*VRR0(70,78)+WQz*VRR1(70,78)
      VRR0(70,115)=2.D0*V(185)+4.D0*V(384)-4.D0*V(386)+QCz*VRR0(70,79)+WQz*VRR1(70,79)
      VRR0(70,116)=V(187)+4.D0*r1x2E*VRR0(70,52)+QCz*VRR0(70,80)-4.D0*r1x2E*ZxZpE*VRR1(70,52)+WQz*VRR1(70,80)
      VRR0(70,117)=2.D0*V(188)+4.D0*V(403)-4.D0*V(404)+QCz*VRR0(70,81)+WQz*VRR1(70,81)
      VRR0(70,118)=5.D0*r1x2E*VRR0(70,54)+QCz*VRR0(70,82)+2.D0*HfxZpE*VRR1(42,82)-5.D0*r1x2E*ZxZpE*VRR1(70,54)+WQz*VRR1(70,82)
      VRR0(70,119)=5.D0*r1x2E*VRR0(70,55)+QCz*VRR0(70,83)+2.D0*HfxZpE*VRR1(42,83)-5.D0*r1x2E*ZxZpE*VRR1(70,55)+WQz*VRR1(70,83)
      VRR0(70,120)=6.D0*r1x2E*VRR0(70,56)+QCz*VRR0(70,84)+2.D0*HfxZpE*VRR1(42,84)-6.D0*r1x2E*ZxZpE*VRR1(70,56)+WQz*VRR1(70,84)
      VRR0(71,85)=6.D0*r1x2E*VRR0(71,36)+QCx*VRR0(71,57)+3.D0*HfxZpE*VRR1(48,57)-6.D0*r1x2E*ZxZpE*VRR1(71,36)+WQx*VRR1(71,57)
      VRR0(71,86)=5.D0*r1x2E*VRR0(71,37)+QCx*VRR0(71,58)+3.D0*HfxZpE*VRR1(48,58)-5.D0*r1x2E*ZxZpE*VRR1(71,37)+WQx*VRR1(71,58)
      VRR0(71,87)=4.D0*V(405)-4.D0*V(406)+QCx*VRR0(71,59)+3.D0*HfxZpE*VRR1(48,59)+WQx*VRR1(71,59)
      VRR0(71,88)=3.D0*V(407)+3.D0*V(408)-3.D0*V(409)+QCx*VRR0(71,60)+WQx*VRR1(71,60)
      VRR0(71,89)=V(350)+3.D0*V(405)-3.D0*V(406)+QCy*VRR0(71,60)+WQy*VRR1(71,60)
      VRR0(71,90)=4.D0*V(407)-4.D0*V(409)+QCy*VRR0(71,61)+HfxZpE*VRR1(47,61)+WQy*VRR1(71,61)
      VRR0(71,91)=5.D0*r1x2E*VRR0(71,40)+QCy*VRR0(71,62)+HfxZpE*VRR1(47,62)-5.D0*r1x2E*ZxZpE*VRR1(71,40)+WQy*VRR1(71,62)
      VRR0(71,92)=6.D0*r1x2E*VRR0(71,41)+QCy*VRR0(71,63)+HfxZpE*VRR1(47,63)-6.D0*r1x2E*ZxZpE*VRR1(71,41)+WQy*VRR1(71,63)
      VRR0(71,93)=5.D0*r1x2E*VRR0(71,42)+QCx*VRR0(71,64)+3.D0*HfxZpE*VRR1(48,64)-5.D0*r1x2E*ZxZpE*VRR1(71,42)+WQx*VRR1(71,64)
      VRR0(71,94)=4.D0*r1x2E*VRR0(71,43)+QCx*VRR0(71,65)+3.D0*HfxZpE*VRR1(48,65)-4.D0*r1x2E*ZxZpE*VRR1(71,43)+WQx*VRR1(71,65)
      VRR0(71,95)=V(411)+V(413)+QCx*VRR0(71,66)+3.D0*HfxZpE*VRR1(48,66)+WQx*VRR1(71,66)
      VRR0(71,96)=2.D0*V(414)+3.D0*V(415)-2.D0*V(416)+QCx*VRR0(71,67)+WQx*VRR1(71,67)
      VRR0(71,97)=V(360)+V(411)+V(413)+QCy*VRR0(71,67)+WQy*VRR1(71,67)
      VRR0(71,98)=4.D0*V(414)-4.D0*V(416)+QCy*VRR0(71,68)+HfxZpE*VRR1(47,68)+WQy*VRR1(71,68)
      VRR0(71,99)=5.D0*r1x2E*VRR0(71,46)+QCy*VRR0(71,69)+HfxZpE*VRR1(47,69)-5.D0*r1x2E*ZxZpE*VRR1(71,46)+WQy*VRR1(71,69)
      VRR0(71,100)=4.D0*V(417)-4.D0*V(418)+QCx*VRR0(71,70)+3.D0*HfxZpE*VRR1(48,70)+WQx*VRR1(71,70)
      VRR0(71,101)=V(420)+V(422)+QCx*VRR0(71,71)+3.D0*HfxZpE*VRR1(48,71)+WQx*VRR1(71,71)
      VRR0(71,102)=2.D0*V(423)+V(425)-2.D0*V(426)+QCx*VRR0(71,72)+WQx*VRR1(71,72)
      VRR0(71,103)=V(371)+2.D0*V(419)-2.D0*V(421)+QCy*VRR0(71,72)+WQy*VRR1(71,72)
      VRR0(71,104)=V(377)+V(427)+V(428)+QCy*VRR0(71,73)+WQy*VRR1(71,73)
      VRR0(71,105)=4.D0*V(429)-4.D0*V(430)+QCy*VRR0(71,74)+HfxZpE*VRR1(47,74)+WQy*VRR1(71,74)
      VRR0(71,106)=3.D0*V(431)+V(433)-3.D0*V(434)+QCx*VRR0(71,75)+WQx*VRR1(71,75)
      VRR0(71,107)=V(436)+V(438)+V(440)+QCx*VRR0(71,76)+WQx*VRR1(71,76)
      VRR0(71,108)=V(247)+2.D0*V(410)-2.D0*V(412)+QCz*VRR0(71,72)+WQz*VRR1(71,72)
      VRR0(71,109)=V(397)+V(436)+V(440)+QCy*VRR0(71,77)+WQy*VRR1(71,77)
      VRR0(71,110)=V(402)+3.D0*V(441)-3.D0*V(442)+QCy*VRR0(71,78)+WQy*VRR1(71,78)
      VRR0(71,111)=2.D0*V(215)+3.D0*V(417)-3.D0*V(418)+QCz*VRR0(71,75)+WQz*VRR1(71,75)
      VRR0(71,112)=2.D0*V(217)+V(420)+V(422)+QCz*VRR0(71,76)+WQz*VRR1(71,76)
      VRR0(71,113)=V(219)+V(427)+V(428)+QCz*VRR0(71,77)+WQz*VRR1(71,77)
      VRR0(71,114)=V(261)+3.D0*V(429)-3.D0*V(430)+QCz*VRR0(71,78)+WQz*VRR1(71,78)
      VRR0(71,115)=4.D0*V(431)-4.D0*V(434)+QCz*VRR0(71,79)+2.D0*HfxZpE*VRR1(43,79)+WQz*VRR1(71,79)
      VRR0(71,116)=4.D0*V(435)-4.D0*V(439)+QCz*VRR0(71,80)+2.D0*HfxZpE*VRR1(43,80)+WQz*VRR1(71,80)
      VRR0(71,117)=4.D0*V(441)-4.D0*V(442)+QCz*VRR0(71,81)+2.D0*HfxZpE*VRR1(43,81)+WQz*VRR1(71,81)
      VRR0(71,118)=5.D0*r1x2E*VRR0(71,54)+QCz*VRR0(71,82)+2.D0*HfxZpE*VRR1(43,82)-5.D0*r1x2E*ZxZpE*VRR1(71,54)+WQz*VRR1(71,82)
      VRR0(71,119)=5.D0*r1x2E*VRR0(71,55)+QCz*VRR0(71,83)+2.D0*HfxZpE*VRR1(43,83)-5.D0*r1x2E*ZxZpE*VRR1(71,55)+WQz*VRR1(71,83)
      VRR0(71,120)=6.D0*r1x2E*VRR0(71,56)+QCz*VRR0(71,84)+2.D0*HfxZpE*VRR1(43,84)-6.D0*r1x2E*ZxZpE*VRR1(71,56)+WQz*VRR1(71,84)
      VRR0(72,85)=6.D0*r1x2E*VRR0(72,36)+QCx*VRR0(72,57)+2.D0*HfxZpE*VRR1(49,57)-6.D0*r1x2E*ZxZpE*VRR1(72,36)+WQx*VRR1(72,57)
      VRR0(72,86)=5.D0*r1x2E*VRR0(72,37)+QCx*VRR0(72,58)+2.D0*HfxZpE*VRR1(49,58)-5.D0*r1x2E*ZxZpE*VRR1(72,37)+WQx*VRR1(72,58)
      VRR0(72,87)=4.D0*V(443)-4.D0*V(444)+QCx*VRR0(72,59)+2.D0*HfxZpE*VRR1(49,59)+WQx*VRR1(72,59)
      VRR0(72,88)=3.D0*V(445)+2.D0*V(446)-3.D0*V(447)+QCx*VRR0(72,60)+WQx*VRR1(72,60)
      VRR0(72,89)=2.D0*V(408)+3.D0*V(443)-3.D0*V(444)+QCy*VRR0(72,60)+WQy*VRR1(72,60)
      VRR0(72,90)=4.D0*V(445)-4.D0*V(447)+QCy*VRR0(72,61)+2.D0*HfxZpE*VRR1(48,61)+WQy*VRR1(72,61)
      VRR0(72,91)=5.D0*r1x2E*VRR0(72,40)+QCy*VRR0(72,62)+2.D0*HfxZpE*VRR1(48,62)-5.D0*r1x2E*ZxZpE*VRR1(72,40)+WQy*VRR1(72,62)
      VRR0(72,92)=6.D0*r1x2E*VRR0(72,41)+QCy*VRR0(72,63)+2.D0*HfxZpE*VRR1(48,63)-6.D0*r1x2E*ZxZpE*VRR1(72,41)+WQy*VRR1(72,63)
      VRR0(72,93)=5.D0*r1x2E*VRR0(72,42)+QCx*VRR0(72,64)+2.D0*HfxZpE*VRR1(49,64)-5.D0*r1x2E*ZxZpE*VRR1(72,42)+WQx*VRR1(72,64)
      VRR0(72,94)=4.D0*r1x2E*VRR0(72,43)+QCx*VRR0(72,65)+2.D0*HfxZpE*VRR1(49,65)-4.D0*r1x2E*ZxZpE*VRR1(72,43)+WQx*VRR1(72,65)
      VRR0(72,95)=V(449)+V(451)+QCx*VRR0(72,66)+2.D0*HfxZpE*VRR1(49,66)+WQx*VRR1(72,66)
      VRR0(72,96)=2.D0*V(452)+2.D0*V(453)-2.D0*V(454)+QCx*VRR0(72,67)+WQx*VRR1(72,67)
      VRR0(72,97)=2.D0*V(415)+V(449)+V(451)+QCy*VRR0(72,67)+WQy*VRR1(72,67)
      VRR0(72,98)=4.D0*V(452)-4.D0*V(454)+QCy*VRR0(72,68)+2.D0*HfxZpE*VRR1(48,68)+WQy*VRR1(72,68)
      VRR0(72,99)=5.D0*r1x2E*VRR0(72,46)+QCy*VRR0(72,69)+2.D0*HfxZpE*VRR1(48,69)-5.D0*r1x2E*ZxZpE*VRR1(72,46)+WQy*VRR1(72,69)
      VRR0(72,100)=4.D0*V(455)-4.D0*V(456)+QCx*VRR0(72,70)+2.D0*HfxZpE*VRR1(49,70)+WQx*VRR1(72,70)
      VRR0(72,101)=V(458)+V(460)+QCx*VRR0(72,71)+2.D0*HfxZpE*VRR1(49,71)+WQx*VRR1(72,71)
      VRR0(72,102)=2.D0*V(461)+2.D0*V(462)-2.D0*V(463)+QCx*VRR0(72,72)+WQx*VRR1(72,72)
      VRR0(72,103)=2.D0*V(424)+2.D0*V(457)-2.D0*V(459)+QCy*VRR0(72,72)+WQy*VRR1(72,72)
      VRR0(72,104)=V(464)+V(465)+QCy*VRR0(72,73)+2.D0*HfxZpE*VRR1(48,73)+WQy*VRR1(72,73)
      VRR0(72,105)=4.D0*V(466)-4.D0*V(467)+QCy*VRR0(72,74)+2.D0*HfxZpE*VRR1(48,74)+WQy*VRR1(72,74)
      VRR0(72,106)=3.D0*V(468)+2.D0*V(469)-3.D0*V(470)+QCx*VRR0(72,75)+WQx*VRR1(72,75)
      VRR0(72,107)=V(472)+2.D0*V(473)+V(475)+QCx*VRR0(72,76)+WQx*VRR1(72,76)
      VRR0(72,108)=2.D0*V(244)+2.D0*V(448)-2.D0*V(450)+QCz*VRR0(72,72)+WQz*VRR1(72,72)
      VRR0(72,109)=V(472)+V(475)+2.D0*V(476)+QCy*VRR0(72,77)+WQy*VRR1(72,77)
      VRR0(72,110)=3.D0*V(477)+2.D0*V(478)-3.D0*V(479)+QCy*VRR0(72,78)+WQy*VRR1(72,78)
      VRR0(72,111)=2.D0*V(253)+3.D0*V(455)-3.D0*V(456)+QCz*VRR0(72,75)+WQz*VRR1(72,75)
      VRR0(72,112)=2.D0*V(257)+V(458)+V(460)+QCz*VRR0(72,76)+WQz*VRR1(72,76)
      VRR0(72,113)=2.D0*V(302)+V(464)+V(465)+QCz*VRR0(72,77)+WQz*VRR1(72,77)
      VRR0(72,114)=2.D0*V(304)+3.D0*V(466)-3.D0*V(467)+QCz*VRR0(72,78)+WQz*VRR1(72,78)
      VRR0(72,115)=4.D0*V(468)-4.D0*V(470)+QCz*VRR0(72,79)+2.D0*HfxZpE*VRR1(44,79)+WQz*VRR1(72,79)
      VRR0(72,116)=4.D0*V(471)-4.D0*V(474)+QCz*VRR0(72,80)+2.D0*HfxZpE*VRR1(44,80)+WQz*VRR1(72,80)
      VRR0(72,117)=4.D0*V(477)-4.D0*V(479)+QCz*VRR0(72,81)+2.D0*HfxZpE*VRR1(44,81)+WQz*VRR1(72,81)
      VRR0(72,118)=5.D0*r1x2E*VRR0(72,54)+QCz*VRR0(72,82)+2.D0*HfxZpE*VRR1(44,82)-5.D0*r1x2E*ZxZpE*VRR1(72,54)+WQz*VRR1(72,82)
      VRR0(72,119)=5.D0*r1x2E*VRR0(72,55)+QCz*VRR0(72,83)+2.D0*HfxZpE*VRR1(44,83)-5.D0*r1x2E*ZxZpE*VRR1(72,55)+WQz*VRR1(72,83)
      VRR0(72,120)=6.D0*r1x2E*VRR0(72,56)+QCz*VRR0(72,84)+2.D0*HfxZpE*VRR1(44,84)-6.D0*r1x2E*ZxZpE*VRR1(72,56)+WQz*VRR1(72,84)
      VRR0(73,85)=6.D0*r1x2E*VRR0(73,36)+QCx*VRR0(73,57)+HfxZpE*VRR1(50,57)-6.D0*r1x2E*ZxZpE*VRR1(73,36)+WQx*VRR1(73,57)
      VRR0(73,86)=5.D0*r1x2E*VRR0(73,37)+QCx*VRR0(73,58)+HfxZpE*VRR1(50,58)-5.D0*r1x2E*ZxZpE*VRR1(73,37)+WQx*VRR1(73,58)
      VRR0(73,87)=4.D0*V(480)-4.D0*V(481)+QCx*VRR0(73,59)+HfxZpE*VRR1(50,59)+WQx*VRR1(73,59)
      VRR0(73,88)=3.D0*V(482)+V(483)-3.D0*V(484)+QCx*VRR0(73,60)+WQx*VRR1(73,60)
      VRR0(73,89)=3.D0*V(446)+3.D0*V(480)-3.D0*V(481)+QCy*VRR0(73,60)+WQy*VRR1(73,60)
      VRR0(73,90)=4.D0*V(482)-4.D0*V(484)+QCy*VRR0(73,61)+3.D0*HfxZpE*VRR1(49,61)+WQy*VRR1(73,61)
      VRR0(73,91)=5.D0*r1x2E*VRR0(73,40)+QCy*VRR0(73,62)+3.D0*HfxZpE*VRR1(49,62)-5.D0*r1x2E*ZxZpE*VRR1(73,40)+WQy*VRR1(73,62)
      VRR0(73,92)=6.D0*r1x2E*VRR0(73,41)+QCy*VRR0(73,63)+3.D0*HfxZpE*VRR1(49,63)-6.D0*r1x2E*ZxZpE*VRR1(73,41)+WQy*VRR1(73,63)
      VRR0(73,93)=5.D0*r1x2E*VRR0(73,42)+QCx*VRR0(73,64)+HfxZpE*VRR1(50,64)-5.D0*r1x2E*ZxZpE*VRR1(73,42)+WQx*VRR1(73,64)
      VRR0(73,94)=4.D0*r1x2E*VRR0(73,43)+QCx*VRR0(73,65)+HfxZpE*VRR1(50,65)-4.D0*r1x2E*ZxZpE*VRR1(73,43)+WQx*VRR1(73,65)
      VRR0(73,95)=V(486)+V(487)+V(489)+QCx*VRR0(73,66)+WQx*VRR1(73,66)
      VRR0(73,96)=2.D0*V(490)+V(491)-2.D0*V(492)+QCx*VRR0(73,67)+WQx*VRR1(73,67)
      VRR0(73,97)=3.D0*V(453)+V(486)+V(489)+QCy*VRR0(73,67)+WQy*VRR1(73,67)
      VRR0(73,98)=4.D0*V(490)-4.D0*V(492)+QCy*VRR0(73,68)+3.D0*HfxZpE*VRR1(49,68)+WQy*VRR1(73,68)
      VRR0(73,99)=5.D0*r1x2E*VRR0(73,46)+QCy*VRR0(73,69)+3.D0*HfxZpE*VRR1(49,69)-5.D0*r1x2E*ZxZpE*VRR1(73,46)+WQy*VRR1(73,69)
      VRR0(73,100)=4.D0*V(493)-4.D0*V(494)+QCx*VRR0(73,70)+HfxZpE*VRR1(50,70)+WQx*VRR1(73,70)
      VRR0(73,101)=V(496)+V(497)+V(499)+QCx*VRR0(73,71)+WQx*VRR1(73,71)
      VRR0(73,102)=2.D0*V(500)+V(501)-2.D0*V(502)+QCx*VRR0(73,72)+WQx*VRR1(73,72)
      VRR0(73,103)=2.D0*V(495)-2.D0*V(498)+V(503)+QCy*VRR0(73,72)+WQy*VRR1(73,72)
      VRR0(73,104)=V(504)+V(505)+QCy*VRR0(73,73)+3.D0*HfxZpE*VRR1(49,73)+WQy*VRR1(73,73)
      VRR0(73,105)=4.D0*V(506)-4.D0*V(507)+QCy*VRR0(73,74)+3.D0*HfxZpE*VRR1(49,74)+WQy*VRR1(73,74)
      VRR0(73,106)=3.D0*V(508)+V(509)-3.D0*V(510)+QCx*VRR0(73,75)+WQx*VRR1(73,75)
      VRR0(73,107)=V(512)+V(513)+V(515)+QCx*VRR0(73,76)+WQx*VRR1(73,76)
      VRR0(73,108)=V(286)+2.D0*V(485)-2.D0*V(488)+QCz*VRR0(73,72)+WQz*VRR1(73,72)
      VRR0(73,109)=V(512)+V(515)+V(517)+QCy*VRR0(73,77)+WQy*VRR1(73,77)
      VRR0(73,110)=3.D0*V(518)+V(520)-3.D0*V(521)+QCy*VRR0(73,78)+WQy*VRR1(73,78)
      VRR0(73,111)=V(294)+3.D0*V(493)-3.D0*V(494)+QCz*VRR0(73,75)+WQz*VRR1(73,75)
      VRR0(73,112)=V(299)+V(496)+V(499)+QCz*VRR0(73,76)+WQz*VRR1(73,76)
      VRR0(73,113)=2.D0*V(335)+V(504)+V(505)+QCz*VRR0(73,77)+WQz*VRR1(73,77)
      VRR0(73,114)=2.D0*V(337)+3.D0*V(506)-3.D0*V(507)+QCz*VRR0(73,78)+WQz*VRR1(73,78)
      VRR0(73,115)=4.D0*V(508)-4.D0*V(510)+QCz*VRR0(73,79)+2.D0*HfxZpE*VRR1(45,79)+WQz*VRR1(73,79)
      VRR0(73,116)=4.D0*V(511)-4.D0*V(514)+QCz*VRR0(73,80)+2.D0*HfxZpE*VRR1(45,80)+WQz*VRR1(73,80)
      VRR0(73,117)=4.D0*V(518)-4.D0*V(521)+QCz*VRR0(73,81)+2.D0*HfxZpE*VRR1(45,81)+WQz*VRR1(73,81)
      VRR0(73,118)=5.D0*r1x2E*VRR0(73,54)+QCz*VRR0(73,82)+2.D0*HfxZpE*VRR1(45,82)-5.D0*r1x2E*ZxZpE*VRR1(73,54)+WQz*VRR1(73,82)
      VRR0(73,119)=5.D0*r1x2E*VRR0(73,55)+QCz*VRR0(73,83)+2.D0*HfxZpE*VRR1(45,83)-5.D0*r1x2E*ZxZpE*VRR1(73,55)+WQz*VRR1(73,83)
      VRR0(73,120)=6.D0*r1x2E*VRR0(73,56)+QCz*VRR0(73,84)+2.D0*HfxZpE*VRR1(45,84)-6.D0*r1x2E*ZxZpE*VRR1(73,56)+WQz*VRR1(73,84)
      VRR0(74,85)=6.D0*r1x2E*VRR0(74,36)+QCx*VRR0(74,57)-6.D0*r1x2E*ZxZpE*VRR1(74,36)+WQx*VRR1(74,57)
      VRR0(74,86)=5.D0*r1x2E*VRR0(74,37)+QCx*VRR0(74,58)-5.D0*r1x2E*ZxZpE*VRR1(74,37)+WQx*VRR1(74,58)
      VRR0(74,87)=4.D0*V(522)-4.D0*V(523)+QCx*VRR0(74,59)+WQx*VRR1(74,59)
      VRR0(74,88)=3.D0*V(524)-3.D0*V(525)+QCx*VRR0(74,60)+WQx*VRR1(74,60)
      VRR0(74,89)=4.D0*V(483)+3.D0*V(522)-3.D0*V(523)+QCy*VRR0(74,60)+WQy*VRR1(74,60)
      VRR0(74,90)=4.D0*V(524)-4.D0*V(525)+QCy*VRR0(74,61)+4.D0*HfxZpE*VRR1(50,61)+WQy*VRR1(74,61)
      VRR0(74,91)=5.D0*r1x2E*VRR0(74,40)+QCy*VRR0(74,62)+4.D0*HfxZpE*VRR1(50,62)-5.D0*r1x2E*ZxZpE*VRR1(74,40)+WQy*VRR1(74,62)
      VRR0(74,92)=6.D0*r1x2E*VRR0(74,41)+QCy*VRR0(74,63)+4.D0*HfxZpE*VRR1(50,63)-6.D0*r1x2E*ZxZpE*VRR1(74,41)+WQy*VRR1(74,63)
      VRR0(74,93)=5.D0*r1x2E*VRR0(74,42)+QCx*VRR0(74,64)-5.D0*r1x2E*ZxZpE*VRR1(74,42)+WQx*VRR1(74,64)
      VRR0(74,94)=4.D0*r1x2E*VRR0(74,43)+QCx*VRR0(74,65)-4.D0*r1x2E*ZxZpE*VRR1(74,43)+WQx*VRR1(74,65)
      VRR0(74,95)=V(527)+V(529)+QCx*VRR0(74,66)+WQx*VRR1(74,66)
      VRR0(74,96)=3.D0*V(487)+V(531)+V(533)+PAy*VRR0(50,96)+WPy*VRR1(50,96)
      VRR0(74,97)=4.D0*V(491)+V(527)+V(529)+QCy*VRR0(74,67)+WQy*VRR1(74,67)
      VRR0(74,98)=4.D0*r1x2E*VRR0(74,45)+QCy*VRR0(74,68)+4.D0*HfxZpE*VRR1(50,68)-4.D0*r1x2E*ZxZpE*VRR1(74,45)+WQy*VRR1(74,68)
      VRR0(74,99)=5.D0*r1x2E*VRR0(74,46)+QCy*VRR0(74,69)+4.D0*HfxZpE*VRR1(50,69)-5.D0*r1x2E*ZxZpE*VRR1(74,46)+WQy*VRR1(74,69)
      VRR0(74,100)=4.D0*V(534)-4.D0*V(535)+QCx*VRR0(74,70)+WQx*VRR1(74,70)
      VRR0(74,101)=V(537)+V(539)+QCx*VRR0(74,71)+WQx*VRR1(74,71)
      VRR0(74,102)=2.D0*V(497)+V(541)+V(543)+PAy*VRR0(50,102)+WPy*VRR1(50,102)
      VRR0(74,103)=V(545)+V(547)+V(548)+PAy*VRR0(50,103)+WPy*VRR1(50,103)
      VRR0(74,104)=V(550)+V(552)+QCy*VRR0(74,73)+4.D0*HfxZpE*VRR1(50,73)+WQy*VRR1(74,73)
      VRR0(74,105)=4.D0*V(553)-4.D0*V(554)+QCy*VRR0(74,74)+4.D0*HfxZpE*VRR1(50,74)+WQy*VRR1(74,74)
      VRR0(74,106)=3.D0*V(555)-3.D0*V(556)+QCx*VRR0(74,75)+WQx*VRR1(74,75)
      VRR0(74,107)=V(509)+V(558)+V(560)+PAy*VRR0(50,107)+WPy*VRR1(50,107)
      VRR0(74,108)=2.D0*V(513)+V(562)+V(564)+PAy*VRR0(50,108)+WPy*VRR1(50,108)
      VRR0(74,109)=V(566)+V(568)+V(570)+PAy*VRR0(50,109)+WPy*VRR1(50,109)
      VRR0(74,110)=3.D0*V(571)+4.D0*V(572)-3.D0*V(573)+QCy*VRR0(74,78)+WQy*VRR1(74,78)
      VRR0(74,111)=2.D0*V(333)+3.D0*V(534)-3.D0*V(535)+QCz*VRR0(74,75)+WQz*VRR1(74,75)
      VRR0(74,112)=V(340)+V(537)+V(539)+QCz*VRR0(74,76)+WQz*VRR1(74,76)
      VRR0(74,113)=2.D0*V(341)+V(550)+V(552)+QCz*VRR0(74,77)+WQz*VRR1(74,77)
      VRR0(74,114)=2.D0*V(342)+3.D0*V(553)-3.D0*V(554)+QCz*VRR0(74,78)+WQz*VRR1(74,78)
      VRR0(74,115)=2.D0*V(343)+4.D0*V(555)-4.D0*V(556)+QCz*VRR0(74,79)+WQz*VRR1(74,79)
      VRR0(74,116)=V(345)+4.D0*r1x2E*VRR0(74,52)+QCz*VRR0(74,80)-4.D0*r1x2E*ZxZpE*VRR1(74,52)+WQz*VRR1(74,80)
      VRR0(74,117)=2.D0*V(346)+4.D0*V(571)-4.D0*V(573)+QCz*VRR0(74,81)+WQz*VRR1(74,81)
      VRR0(74,118)=5.D0*r1x2E*VRR0(74,54)+QCz*VRR0(74,82)+2.D0*HfxZpE*VRR1(46,82)-5.D0*r1x2E*ZxZpE*VRR1(74,54)+WQz*VRR1(74,82)
      VRR0(74,119)=5.D0*r1x2E*VRR0(74,55)+QCz*VRR0(74,83)+2.D0*HfxZpE*VRR1(46,83)-5.D0*r1x2E*ZxZpE*VRR1(74,55)+WQz*VRR1(74,83)
      VRR0(74,120)=6.D0*r1x2E*VRR0(74,56)+QCz*VRR0(74,84)+2.D0*HfxZpE*VRR1(46,84)-6.D0*r1x2E*ZxZpE*VRR1(74,56)+WQz*VRR1(74,84)
      VRR0(75,85)=6.D0*r1x2E*VRR0(75,36)+QCx*VRR0(75,57)+3.D0*HfxZpE*VRR1(51,57)-6.D0*r1x2E*ZxZpE*VRR1(75,36)+WQx*VRR1(75,57)
      VRR0(75,86)=5.D0*r1x2E*VRR0(75,37)+QCx*VRR0(75,58)+3.D0*HfxZpE*VRR1(51,58)-5.D0*r1x2E*ZxZpE*VRR1(75,37)+WQx*VRR1(75,58)
      VRR0(75,87)=4.D0*V(574)-4.D0*V(575)+QCx*VRR0(75,59)+3.D0*HfxZpE*VRR1(51,59)+WQx*VRR1(75,59)
      VRR0(75,88)=3.D0*V(576)+3.D0*V(577)-3.D0*V(578)+QCx*VRR0(75,60)+WQx*VRR1(75,60)
      VRR0(75,89)=3.D0*V(574)-3.D0*V(575)+QCy*VRR0(75,60)+WQy*VRR1(75,60)
      VRR0(75,90)=4.D0*V(576)-4.D0*V(578)+QCy*VRR0(75,61)+WQy*VRR1(75,61)
      VRR0(75,91)=5.D0*r1x2E*VRR0(75,40)+QCy*VRR0(75,62)-5.D0*r1x2E*ZxZpE*VRR1(75,40)+WQy*VRR1(75,62)
      VRR0(75,92)=6.D0*r1x2E*VRR0(75,41)+QCy*VRR0(75,63)-6.D0*r1x2E*ZxZpE*VRR1(75,41)+WQy*VRR1(75,63)
      VRR0(75,93)=5.D0*r1x2E*VRR0(75,42)+QCx*VRR0(75,64)+3.D0*HfxZpE*VRR1(51,64)-5.D0*r1x2E*ZxZpE*VRR1(75,42)+WQx*VRR1(75,64)
      VRR0(75,94)=4.D0*r1x2E*VRR0(75,43)+QCx*VRR0(75,65)+3.D0*HfxZpE*VRR1(51,65)-4.D0*r1x2E*ZxZpE*VRR1(75,43)+WQx*VRR1(75,65)
      VRR0(75,95)=V(580)+3.D0*V(581)+V(583)+QCx*VRR0(75,66)+WQx*VRR1(75,66)
      VRR0(75,96)=2.D0*V(584)+3.D0*V(585)-2.D0*V(586)+QCx*VRR0(75,67)+WQx*VRR1(75,67)
      VRR0(75,97)=V(580)+V(583)+QCy*VRR0(75,67)+WQy*VRR1(75,67)
      VRR0(75,98)=4.D0*V(584)-4.D0*V(586)+QCy*VRR0(75,68)+WQy*VRR1(75,68)
      VRR0(75,99)=5.D0*r1x2E*VRR0(75,46)+QCy*VRR0(75,69)-5.D0*r1x2E*ZxZpE*VRR1(75,46)+WQy*VRR1(75,69)
      VRR0(75,100)=4.D0*V(587)-4.D0*V(588)+QCx*VRR0(75,70)+3.D0*HfxZpE*VRR1(51,70)+WQx*VRR1(75,70)
      VRR0(75,101)=V(590)+V(592)+V(594)+QCx*VRR0(75,71)+WQx*VRR1(75,71)
      VRR0(75,102)=2.D0*V(595)+V(597)-2.D0*V(598)+QCx*VRR0(75,72)+WQx*VRR1(75,72)
      VRR0(75,103)=2.D0*V(589)-2.D0*V(593)+QCy*VRR0(75,72)+WQy*VRR1(75,72)
      VRR0(75,104)=V(599)+V(600)+QCy*VRR0(75,73)+WQy*VRR1(75,73)
      VRR0(75,105)=4.D0*V(601)-4.D0*V(602)+QCy*VRR0(75,74)+WQy*VRR1(75,74)
      VRR0(75,106)=3.D0*V(603)+3.D0*V(604)-3.D0*V(605)+QCx*VRR0(75,75)+WQx*VRR1(75,75)
      VRR0(75,107)=V(607)+3.D0*V(608)+V(610)+QCx*VRR0(75,76)+WQx*VRR1(75,76)
      VRR0(75,108)=V(372)+2.D0*V(579)-2.D0*V(582)+QCz*VRR0(75,72)+WQz*VRR1(75,72)
      VRR0(75,109)=V(607)+V(610)+QCy*VRR0(75,77)+WQy*VRR1(75,77)
      VRR0(75,110)=3.D0*V(611)-3.D0*V(612)+QCy*VRR0(75,78)+WQy*VRR1(75,78)
      VRR0(75,111)=3.D0*V(385)+3.D0*V(587)-3.D0*V(588)+QCz*VRR0(75,75)+WQz*VRR1(75,75)
      VRR0(75,112)=V(392)+V(590)+V(594)+QCz*VRR0(75,76)+WQz*VRR1(75,76)
      VRR0(75,113)=3.D0*V(397)+V(599)+V(600)+QCz*VRR0(75,77)+WQz*VRR1(75,77)
      VRR0(75,114)=3.D0*V(402)+3.D0*V(601)-3.D0*V(602)+QCz*VRR0(75,78)+WQz*VRR1(75,78)
      VRR0(75,115)=4.D0*V(603)-4.D0*V(605)+QCz*VRR0(75,79)+3.D0*HfxZpE*VRR1(47,79)+WQz*VRR1(75,79)
      VRR0(75,116)=4.D0*V(606)-4.D0*V(609)+QCz*VRR0(75,80)+3.D0*HfxZpE*VRR1(47,80)+WQz*VRR1(75,80)
      VRR0(75,117)=4.D0*V(611)-4.D0*V(612)+QCz*VRR0(75,81)+3.D0*HfxZpE*VRR1(47,81)+WQz*VRR1(75,81)
      VRR0(75,118)=5.D0*r1x2E*VRR0(75,54)+QCz*VRR0(75,82)+3.D0*HfxZpE*VRR1(47,82)-5.D0*r1x2E*ZxZpE*VRR1(75,54)+WQz*VRR1(75,82)
      VRR0(75,119)=5.D0*r1x2E*VRR0(75,55)+QCz*VRR0(75,83)+3.D0*HfxZpE*VRR1(47,83)-5.D0*r1x2E*ZxZpE*VRR1(75,55)+WQz*VRR1(75,83)
      VRR0(75,120)=6.D0*r1x2E*VRR0(75,56)+QCz*VRR0(75,84)+3.D0*HfxZpE*VRR1(47,84)-6.D0*r1x2E*ZxZpE*VRR1(75,56)+WQz*VRR1(75,84)
      VRR0(76,85)=6.D0*r1x2E*VRR0(76,36)+QCx*VRR0(76,57)+2.D0*HfxZpE*VRR1(52,57)-6.D0*r1x2E*ZxZpE*VRR1(76,36)+WQx*VRR1(76,57)
      VRR0(76,86)=5.D0*r1x2E*VRR0(76,37)+QCx*VRR0(76,58)+2.D0*HfxZpE*VRR1(52,58)-5.D0*r1x2E*ZxZpE*VRR1(76,37)+WQx*VRR1(76,58)
      VRR0(76,87)=4.D0*V(613)-4.D0*V(614)+QCx*VRR0(76,59)+2.D0*HfxZpE*VRR1(52,59)+WQx*VRR1(76,59)
      VRR0(76,88)=3.D0*V(615)+V(617)-3.D0*V(618)+QCx*VRR0(76,60)+WQx*VRR1(76,60)
      VRR0(76,89)=V(577)+3.D0*V(613)-3.D0*V(614)+QCy*VRR0(76,60)+WQy*VRR1(76,60)
      VRR0(76,90)=4.D0*V(615)-4.D0*V(618)+QCy*VRR0(76,61)+HfxZpE*VRR1(51,61)+WQy*VRR1(76,61)
      VRR0(76,91)=5.D0*r1x2E*VRR0(76,40)+QCy*VRR0(76,62)+HfxZpE*VRR1(51,62)-5.D0*r1x2E*ZxZpE*VRR1(76,40)+WQy*VRR1(76,62)
      VRR0(76,92)=6.D0*r1x2E*VRR0(76,41)+QCy*VRR0(76,63)+HfxZpE*VRR1(51,63)-6.D0*r1x2E*ZxZpE*VRR1(76,41)+WQy*VRR1(76,63)
      VRR0(76,93)=5.D0*r1x2E*VRR0(76,42)+QCx*VRR0(76,64)+2.D0*HfxZpE*VRR1(52,64)-5.D0*r1x2E*ZxZpE*VRR1(76,42)+WQx*VRR1(76,64)
      VRR0(76,94)=4.D0*r1x2E*VRR0(76,43)+QCx*VRR0(76,65)+2.D0*HfxZpE*VRR1(52,65)-4.D0*r1x2E*ZxZpE*VRR1(76,43)+WQx*VRR1(76,65)
      VRR0(76,95)=V(620)+V(622)+V(624)+QCx*VRR0(76,66)+WQx*VRR1(76,66)
      VRR0(76,96)=2.D0*V(625)+V(627)-2.D0*V(628)+QCx*VRR0(76,67)+WQx*VRR1(76,67)
      VRR0(76,97)=V(585)+V(620)+V(624)+QCy*VRR0(76,67)+WQy*VRR1(76,67)
      VRR0(76,98)=4.D0*V(625)-4.D0*V(628)+QCy*VRR0(76,68)+HfxZpE*VRR1(51,68)+WQy*VRR1(76,68)
      VRR0(76,99)=5.D0*r1x2E*VRR0(76,46)+QCy*VRR0(76,69)+HfxZpE*VRR1(51,69)-5.D0*r1x2E*ZxZpE*VRR1(76,46)+WQy*VRR1(76,69)
      VRR0(76,100)=4.D0*V(629)-4.D0*V(630)+QCx*VRR0(76,70)+2.D0*HfxZpE*VRR1(52,70)+WQx*VRR1(76,70)
      VRR0(76,101)=V(632)+2.D0*V(633)+V(635)+QCx*VRR0(76,71)+WQx*VRR1(76,71)
      VRR0(76,102)=2.D0*V(636)+V(638)-2.D0*V(639)+QCx*VRR0(76,72)+WQx*VRR1(76,72)
      VRR0(76,103)=V(596)+2.D0*V(631)-2.D0*V(634)+QCy*VRR0(76,72)+WQy*VRR1(76,72)
      VRR0(76,104)=V(640)+V(641)+V(642)+QCy*VRR0(76,73)+WQy*VRR1(76,73)
      VRR0(76,105)=4.D0*V(643)-4.D0*V(644)+QCy*VRR0(76,74)+HfxZpE*VRR1(51,74)+WQy*VRR1(76,74)
      VRR0(76,106)=3.D0*V(645)+2.D0*V(646)-3.D0*V(647)+QCx*VRR0(76,75)+WQx*VRR1(76,75)
      VRR0(76,107)=V(649)+2.D0*V(650)+V(652)+QCx*VRR0(76,76)+WQx*VRR1(76,76)
      VRR0(76,108)=V(425)+2.D0*V(619)-2.D0*V(623)+QCz*VRR0(76,72)+WQz*VRR1(76,72)
      VRR0(76,109)=V(649)+V(652)+V(653)+QCy*VRR0(76,77)+WQy*VRR1(76,77)
      VRR0(76,110)=3.D0*V(654)+V(655)-3.D0*V(656)+QCy*VRR0(76,78)+WQy*VRR1(76,78)
      VRR0(76,111)=V(433)+3.D0*V(629)-3.D0*V(630)+QCz*VRR0(76,75)+WQz*VRR1(76,75)
      VRR0(76,112)=V(438)+V(632)+V(635)+QCz*VRR0(76,76)+WQz*VRR1(76,76)
      VRR0(76,113)=3.D0*V(476)+V(640)+V(642)+QCz*VRR0(76,77)+WQz*VRR1(76,77)
      VRR0(76,114)=3.D0*V(478)+3.D0*V(643)-3.D0*V(644)+QCz*VRR0(76,78)+WQz*VRR1(76,78)
      VRR0(76,115)=4.D0*V(645)-4.D0*V(647)+QCz*VRR0(76,79)+3.D0*HfxZpE*VRR1(48,79)+WQz*VRR1(76,79)
      VRR0(76,116)=4.D0*V(648)-4.D0*V(651)+QCz*VRR0(76,80)+3.D0*HfxZpE*VRR1(48,80)+WQz*VRR1(76,80)
      VRR0(76,117)=4.D0*V(654)-4.D0*V(656)+QCz*VRR0(76,81)+3.D0*HfxZpE*VRR1(48,81)+WQz*VRR1(76,81)
      VRR0(76,118)=5.D0*r1x2E*VRR0(76,54)+QCz*VRR0(76,82)+3.D0*HfxZpE*VRR1(48,82)-5.D0*r1x2E*ZxZpE*VRR1(76,54)+WQz*VRR1(76,82)
      VRR0(76,119)=5.D0*r1x2E*VRR0(76,55)+QCz*VRR0(76,83)+3.D0*HfxZpE*VRR1(48,83)-5.D0*r1x2E*ZxZpE*VRR1(76,55)+WQz*VRR1(76,83)
      VRR0(76,120)=6.D0*r1x2E*VRR0(76,56)+QCz*VRR0(76,84)+3.D0*HfxZpE*VRR1(48,84)-6.D0*r1x2E*ZxZpE*VRR1(76,56)+WQz*VRR1(76,84)
      VRR0(77,85)=6.D0*r1x2E*VRR0(77,36)+QCx*VRR0(77,57)+HfxZpE*VRR1(53,57)-6.D0*r1x2E*ZxZpE*VRR1(77,36)+WQx*VRR1(77,57)
      VRR0(77,86)=5.D0*r1x2E*VRR0(77,37)+QCx*VRR0(77,58)+HfxZpE*VRR1(53,58)-5.D0*r1x2E*ZxZpE*VRR1(77,37)+WQx*VRR1(77,58)
      VRR0(77,87)=4.D0*V(657)-4.D0*V(658)+QCx*VRR0(77,59)+HfxZpE*VRR1(53,59)+WQx*VRR1(77,59)
      VRR0(77,88)=3.D0*V(659)+V(660)-3.D0*V(661)+QCx*VRR0(77,60)+WQx*VRR1(77,60)
      VRR0(77,89)=V(617)+3.D0*V(657)-3.D0*V(658)+QCy*VRR0(77,60)+WQy*VRR1(77,60)
      VRR0(77,90)=4.D0*V(659)-4.D0*V(661)+QCy*VRR0(77,61)+2.D0*HfxZpE*VRR1(52,61)+WQy*VRR1(77,61)
      VRR0(77,91)=5.D0*r1x2E*VRR0(77,40)+QCy*VRR0(77,62)+2.D0*HfxZpE*VRR1(52,62)-5.D0*r1x2E*ZxZpE*VRR1(77,40)+WQy*VRR1(77,62)
      VRR0(77,92)=6.D0*r1x2E*VRR0(77,41)+QCy*VRR0(77,63)+2.D0*HfxZpE*VRR1(52,63)-6.D0*r1x2E*ZxZpE*VRR1(77,41)+WQy*VRR1(77,63)
      VRR0(77,93)=5.D0*r1x2E*VRR0(77,42)+QCx*VRR0(77,64)+HfxZpE*VRR1(53,64)-5.D0*r1x2E*ZxZpE*VRR1(77,42)+WQx*VRR1(77,64)
      VRR0(77,94)=4.D0*r1x2E*VRR0(77,43)+QCx*VRR0(77,65)+HfxZpE*VRR1(53,65)-4.D0*r1x2E*ZxZpE*VRR1(77,43)+WQx*VRR1(77,65)
      VRR0(77,95)=V(663)+V(664)+V(666)+QCx*VRR0(77,66)+WQx*VRR1(77,66)
      VRR0(77,96)=2.D0*V(667)+V(668)-2.D0*V(669)+QCx*VRR0(77,67)+WQx*VRR1(77,67)
      VRR0(77,97)=V(627)+V(663)+V(666)+QCy*VRR0(77,67)+WQy*VRR1(77,67)
      VRR0(77,98)=4.D0*V(667)-4.D0*V(669)+QCy*VRR0(77,68)+2.D0*HfxZpE*VRR1(52,68)+WQy*VRR1(77,68)
      VRR0(77,99)=5.D0*r1x2E*VRR0(77,46)+QCy*VRR0(77,69)+2.D0*HfxZpE*VRR1(52,69)-5.D0*r1x2E*ZxZpE*VRR1(77,46)+WQy*VRR1(77,69)
      VRR0(77,100)=4.D0*V(670)-4.D0*V(671)+QCx*VRR0(77,70)+HfxZpE*VRR1(53,70)+WQx*VRR1(77,70)
      VRR0(77,101)=V(673)+V(674)+V(676)+QCx*VRR0(77,71)+WQx*VRR1(77,71)
      VRR0(77,102)=2.D0*V(677)+V(678)-2.D0*V(679)+QCx*VRR0(77,72)+WQx*VRR1(77,72)
      VRR0(77,103)=V(638)+2.D0*V(672)-2.D0*V(675)+QCy*VRR0(77,72)+WQy*VRR1(77,72)
      VRR0(77,104)=V(680)+2.D0*V(681)+V(682)+QCy*VRR0(77,73)+WQy*VRR1(77,73)
      VRR0(77,105)=4.D0*V(683)-4.D0*V(684)+QCy*VRR0(77,74)+2.D0*HfxZpE*VRR1(52,74)+WQy*VRR1(77,74)
      VRR0(77,106)=3.D0*V(685)+V(686)-3.D0*V(687)+QCx*VRR0(77,75)+WQx*VRR1(77,75)
      VRR0(77,107)=V(689)+V(690)+V(692)+QCx*VRR0(77,76)+WQx*VRR1(77,76)
      VRR0(77,108)=V(503)+2.D0*V(662)-2.D0*V(665)+QCz*VRR0(77,72)+WQz*VRR1(77,72)
      VRR0(77,109)=V(689)+V(692)+2.D0*V(693)+QCy*VRR0(77,77)+WQy*VRR1(77,77)
      VRR0(77,110)=3.D0*V(694)+2.D0*V(695)-3.D0*V(696)+QCy*VRR0(77,78)+WQy*VRR1(77,78)
      VRR0(77,111)=3.D0*V(469)+3.D0*V(670)-3.D0*V(671)+QCz*VRR0(77,75)+WQz*VRR1(77,75)
      VRR0(77,112)=3.D0*V(473)+V(673)+V(676)+QCz*VRR0(77,76)+WQz*VRR1(77,76)
      VRR0(77,113)=V(517)+V(680)+V(682)+QCz*VRR0(77,77)+WQz*VRR1(77,77)
      VRR0(77,114)=V(520)+3.D0*V(683)-3.D0*V(684)+QCz*VRR0(77,78)+WQz*VRR1(77,78)
      VRR0(77,115)=4.D0*V(685)-4.D0*V(687)+QCz*VRR0(77,79)+3.D0*HfxZpE*VRR1(49,79)+WQz*VRR1(77,79)
      VRR0(77,116)=4.D0*V(688)-4.D0*V(691)+QCz*VRR0(77,80)+3.D0*HfxZpE*VRR1(49,80)+WQz*VRR1(77,80)
      VRR0(77,117)=4.D0*V(694)-4.D0*V(696)+QCz*VRR0(77,81)+3.D0*HfxZpE*VRR1(49,81)+WQz*VRR1(77,81)
      VRR0(77,118)=5.D0*r1x2E*VRR0(77,54)+QCz*VRR0(77,82)+3.D0*HfxZpE*VRR1(49,82)-5.D0*r1x2E*ZxZpE*VRR1(77,54)+WQz*VRR1(77,82)
      VRR0(77,119)=5.D0*r1x2E*VRR0(77,55)+QCz*VRR0(77,83)+3.D0*HfxZpE*VRR1(49,83)-5.D0*r1x2E*ZxZpE*VRR1(77,55)+WQz*VRR1(77,83)
      VRR0(77,120)=6.D0*r1x2E*VRR0(77,56)+QCz*VRR0(77,84)+3.D0*HfxZpE*VRR1(49,84)-6.D0*r1x2E*ZxZpE*VRR1(77,56)+WQz*VRR1(77,84)
      VRR0(78,85)=6.D0*r1x2E*VRR0(78,36)+QCx*VRR0(78,57)-6.D0*r1x2E*ZxZpE*VRR1(78,36)+WQx*VRR1(78,57)
      VRR0(78,86)=5.D0*r1x2E*VRR0(78,37)+QCx*VRR0(78,58)-5.D0*r1x2E*ZxZpE*VRR1(78,37)+WQx*VRR1(78,58)
      VRR0(78,87)=4.D0*V(697)-4.D0*V(698)+QCx*VRR0(78,59)+WQx*VRR1(78,59)
      VRR0(78,88)=3.D0*V(699)-3.D0*V(700)+QCx*VRR0(78,60)+WQx*VRR1(78,60)
      VRR0(78,89)=3.D0*V(660)+3.D0*V(697)-3.D0*V(698)+QCy*VRR0(78,60)+WQy*VRR1(78,60)
      VRR0(78,90)=4.D0*V(699)-4.D0*V(700)+QCy*VRR0(78,61)+3.D0*HfxZpE*VRR1(53,61)+WQy*VRR1(78,61)
      VRR0(78,91)=5.D0*r1x2E*VRR0(78,40)+QCy*VRR0(78,62)+3.D0*HfxZpE*VRR1(53,62)-5.D0*r1x2E*ZxZpE*VRR1(78,40)+WQy*VRR1(78,62)
      VRR0(78,92)=6.D0*r1x2E*VRR0(78,41)+QCy*VRR0(78,63)+3.D0*HfxZpE*VRR1(53,63)-6.D0*r1x2E*ZxZpE*VRR1(78,41)+WQy*VRR1(78,63)
      VRR0(78,93)=5.D0*r1x2E*VRR0(78,42)+QCx*VRR0(78,64)-5.D0*r1x2E*ZxZpE*VRR1(78,42)+WQx*VRR1(78,64)
      VRR0(78,94)=4.D0*r1x2E*VRR0(78,43)+QCx*VRR0(78,65)-4.D0*r1x2E*ZxZpE*VRR1(78,43)+WQx*VRR1(78,65)
      VRR0(78,95)=V(702)+V(704)+QCx*VRR0(78,66)+WQx*VRR1(78,66)
      VRR0(78,96)=2.D0*V(705)-2.D0*V(706)+QCx*VRR0(78,67)+WQx*VRR1(78,67)
      VRR0(78,97)=3.D0*V(668)+V(702)+V(704)+QCy*VRR0(78,67)+WQy*VRR1(78,67)
      VRR0(78,98)=4.D0*V(705)-4.D0*V(706)+QCy*VRR0(78,68)+3.D0*HfxZpE*VRR1(53,68)+WQy*VRR1(78,68)
      VRR0(78,99)=5.D0*r1x2E*VRR0(78,46)+QCy*VRR0(78,69)+3.D0*HfxZpE*VRR1(53,69)-5.D0*r1x2E*ZxZpE*VRR1(78,46)+WQy*VRR1(78,69)
      VRR0(78,100)=4.D0*V(707)-4.D0*V(708)+QCx*VRR0(78,70)+WQx*VRR1(78,70)
      VRR0(78,101)=V(710)+V(712)+QCx*VRR0(78,71)+WQx*VRR1(78,71)
      VRR0(78,102)=2.D0*V(713)-2.D0*V(714)+QCx*VRR0(78,72)+WQx*VRR1(78,72)
      VRR0(78,103)=2.D0*V(709)-2.D0*V(711)+V(715)+QCy*VRR0(78,72)+WQy*VRR1(78,72)
      VRR0(78,104)=V(716)+V(718)+V(719)+QCy*VRR0(78,73)+WQy*VRR1(78,73)
      VRR0(78,105)=4.D0*V(720)-4.D0*V(721)+QCy*VRR0(78,74)+3.D0*HfxZpE*VRR1(53,74)+WQy*VRR1(78,74)
      VRR0(78,106)=3.D0*V(722)-3.D0*V(723)+QCx*VRR0(78,75)+WQx*VRR1(78,75)
      VRR0(78,107)=V(725)+V(727)+QCx*VRR0(78,76)+WQx*VRR1(78,76)
      VRR0(78,108)=V(548)+2.D0*V(701)-2.D0*V(703)+QCz*VRR0(78,72)+WQz*VRR1(78,72)
      VRR0(78,109)=V(725)+V(727)+3.D0*V(728)+QCy*VRR0(78,77)+WQy*VRR1(78,77)
      VRR0(78,110)=3.D0*V(729)+3.D0*V(730)-3.D0*V(731)+QCy*VRR0(78,78)+WQy*VRR1(78,78)
      VRR0(78,111)=3.D0*V(509)+3.D0*V(707)-3.D0*V(708)+QCz*VRR0(78,75)+WQz*VRR1(78,75)
      VRR0(78,112)=3.D0*V(513)+V(710)+V(712)+QCz*VRR0(78,76)+WQz*VRR1(78,76)
      VRR0(78,113)=V(570)+V(716)+V(719)+QCz*VRR0(78,77)+WQz*VRR1(78,77)
      VRR0(78,114)=3.D0*V(572)+3.D0*V(720)-3.D0*V(721)+QCz*VRR0(78,78)+WQz*VRR1(78,78)
      VRR0(78,115)=4.D0*V(722)-4.D0*V(723)+QCz*VRR0(78,79)+3.D0*HfxZpE*VRR1(50,79)+WQz*VRR1(78,79)
      VRR0(78,116)=4.D0*V(724)-4.D0*V(726)+QCz*VRR0(78,80)+3.D0*HfxZpE*VRR1(50,80)+WQz*VRR1(78,80)
      VRR0(78,117)=4.D0*V(729)-4.D0*V(731)+QCz*VRR0(78,81)+3.D0*HfxZpE*VRR1(50,81)+WQz*VRR1(78,81)
      VRR0(78,118)=5.D0*r1x2E*VRR0(78,54)+QCz*VRR0(78,82)+3.D0*HfxZpE*VRR1(50,82)-5.D0*r1x2E*ZxZpE*VRR1(78,54)+WQz*VRR1(78,82)
      VRR0(78,119)=5.D0*r1x2E*VRR0(78,55)+QCz*VRR0(78,83)+3.D0*HfxZpE*VRR1(50,83)-5.D0*r1x2E*ZxZpE*VRR1(78,55)+WQz*VRR1(78,83)
      VRR0(78,120)=6.D0*r1x2E*VRR0(78,56)+QCz*VRR0(78,84)+3.D0*HfxZpE*VRR1(50,84)-6.D0*r1x2E*ZxZpE*VRR1(78,56)+WQz*VRR1(78,84)
      VRR0(79,85)=6.D0*r1x2E*VRR0(79,36)+QCx*VRR0(79,57)+2.D0*HfxZpE*VRR1(54,57)-6.D0*r1x2E*ZxZpE*VRR1(79,36)+WQx*VRR1(79,57)
      VRR0(79,86)=5.D0*r1x2E*VRR0(79,37)+QCx*VRR0(79,58)+2.D0*HfxZpE*VRR1(54,58)-5.D0*r1x2E*ZxZpE*VRR1(79,37)+WQx*VRR1(79,58)
      VRR0(79,87)=4.D0*V(732)+2.D0*V(733)-4.D0*V(734)+QCx*VRR0(79,59)+WQx*VRR1(79,59)
      VRR0(79,88)=3.D0*V(735)+2.D0*V(736)-3.D0*V(737)+QCx*VRR0(79,60)+WQx*VRR1(79,60)
      VRR0(79,89)=3.D0*V(732)-3.D0*V(734)+QCy*VRR0(79,60)+WQy*VRR1(79,60)
      VRR0(79,90)=4.D0*V(735)-4.D0*V(737)+QCy*VRR0(79,61)+WQy*VRR1(79,61)
      VRR0(79,91)=5.D0*r1x2E*VRR0(79,40)+QCy*VRR0(79,62)-5.D0*r1x2E*ZxZpE*VRR1(79,40)+WQy*VRR1(79,62)
      VRR0(79,92)=6.D0*r1x2E*VRR0(79,41)+QCy*VRR0(79,63)-6.D0*r1x2E*ZxZpE*VRR1(79,41)+WQy*VRR1(79,63)
      VRR0(79,93)=5.D0*r1x2E*VRR0(79,42)+QCx*VRR0(79,64)+2.D0*HfxZpE*VRR1(54,64)-5.D0*r1x2E*ZxZpE*VRR1(79,42)+WQx*VRR1(79,64)
      VRR0(79,94)=V(739)+4.D0*r1x2E*VRR0(79,43)+QCx*VRR0(79,65)-4.D0*r1x2E*ZxZpE*VRR1(79,43)+WQx*VRR1(79,65)
      VRR0(79,95)=V(741)+V(743)+V(745)+QCx*VRR0(79,66)+WQx*VRR1(79,66)
      VRR0(79,96)=V(357)+V(359)+V(577)+PAz*VRR0(51,96)+WPz*VRR1(51,96)
      VRR0(79,97)=V(741)+V(745)+QCy*VRR0(79,67)+WQy*VRR1(79,67)
      VRR0(79,98)=4.D0*r1x2E*VRR0(79,45)+QCy*VRR0(79,68)-4.D0*r1x2E*ZxZpE*VRR1(79,45)+WQy*VRR1(79,68)
      VRR0(79,99)=5.D0*r1x2E*VRR0(79,46)+QCy*VRR0(79,69)-5.D0*r1x2E*ZxZpE*VRR1(79,46)+WQy*VRR1(79,69)
      VRR0(79,100)=4.D0*V(746)+2.D0*V(747)-4.D0*V(748)+QCx*VRR0(79,70)+WQx*VRR1(79,70)
      VRR0(79,101)=V(750)+2.D0*V(751)+V(753)+QCx*VRR0(79,71)+WQx*VRR1(79,71)
      VRR0(79,102)=V(368)+V(370)+2.D0*V(581)+PAz*VRR0(51,102)+WPz*VRR1(51,102)
      VRR0(79,103)=V(374)+V(376)+2.D0*V(585)+PAz*VRR0(51,103)+WPz*VRR1(51,103)
      VRR0(79,104)=V(755)+V(757)+QCy*VRR0(79,73)+WQy*VRR1(79,73)
      VRR0(79,105)=4.D0*V(758)-4.D0*V(759)+QCy*VRR0(79,74)+WQy*VRR1(79,74)
      VRR0(79,106)=3.D0*V(760)+2.D0*V(761)-3.D0*V(762)+QCx*VRR0(79,75)+WQx*VRR1(79,75)
      VRR0(79,107)=V(388)+V(390)+V(592)+PAz*VRR0(51,107)+WPz*VRR1(51,107)
      VRR0(79,108)=V(394)+V(396)+V(597)+PAz*VRR0(51,108)+WPz*VRR1(51,108)
      VRR0(79,109)=V(399)+V(401)+3.D0*V(641)+PAz*VRR0(51,109)+WPz*VRR1(51,109)
      VRR0(79,110)=3.D0*V(763)-3.D0*V(764)+QCy*VRR0(79,78)+WQy*VRR1(79,78)
      VRR0(79,111)=4.D0*V(604)+3.D0*V(746)-3.D0*V(748)+QCz*VRR0(79,75)+WQz*VRR1(79,75)
      VRR0(79,112)=4.D0*V(608)+V(750)+V(753)+QCz*VRR0(79,76)+WQz*VRR1(79,76)
      VRR0(79,113)=4.D0*V(653)+V(755)+V(757)+QCz*VRR0(79,77)+WQz*VRR1(79,77)
      VRR0(79,114)=4.D0*V(655)+3.D0*V(758)-3.D0*V(759)+QCz*VRR0(79,78)+WQz*VRR1(79,78)
      VRR0(79,115)=4.D0*V(760)-4.D0*V(762)+QCz*VRR0(79,79)+4.D0*HfxZpE*VRR1(51,79)+WQz*VRR1(79,79)
      VRR0(79,116)=4.D0*r1x2E*VRR0(79,52)+QCz*VRR0(79,80)+4.D0*HfxZpE*VRR1(51,80)-4.D0*r1x2E*ZxZpE*VRR1(79,52)+WQz*VRR1(79,80)
      VRR0(79,117)=4.D0*V(763)-4.D0*V(764)+QCz*VRR0(79,81)+4.D0*HfxZpE*VRR1(51,81)+WQz*VRR1(79,81)
      VRR0(79,118)=5.D0*r1x2E*VRR0(79,54)+QCz*VRR0(79,82)+4.D0*HfxZpE*VRR1(51,82)-5.D0*r1x2E*ZxZpE*VRR1(79,54)+WQz*VRR1(79,82)
      VRR0(79,119)=5.D0*r1x2E*VRR0(79,55)+QCz*VRR0(79,83)+4.D0*HfxZpE*VRR1(51,83)-5.D0*r1x2E*ZxZpE*VRR1(79,55)+WQz*VRR1(79,83)
      VRR0(79,120)=6.D0*r1x2E*VRR0(79,56)+QCz*VRR0(79,84)+4.D0*HfxZpE*VRR1(51,84)-6.D0*r1x2E*ZxZpE*VRR1(79,56)+WQz*VRR1(79,84)
      VRR0(80,85)=6.D0*r1x2E*VRR0(80,36)+QCx*VRR0(80,57)+HfxZpE*VRR1(55,57)-6.D0*r1x2E*ZxZpE*VRR1(80,36)+WQx*VRR1(80,57)
      VRR0(80,86)=5.D0*r1x2E*VRR0(80,37)+QCx*VRR0(80,58)+HfxZpE*VRR1(55,58)-5.D0*r1x2E*ZxZpE*VRR1(80,37)+WQx*VRR1(80,58)
      VRR0(80,87)=4.D0*V(765)+V(766)-4.D0*V(767)+QCx*VRR0(80,59)+WQx*VRR1(80,59)
      VRR0(80,88)=3.D0*V(768)+V(769)-3.D0*V(770)+QCx*VRR0(80,60)+WQx*VRR1(80,60)
      VRR0(80,89)=V(736)+3.D0*V(765)-3.D0*V(767)+QCy*VRR0(80,60)+WQy*VRR1(80,60)
      VRR0(80,90)=4.D0*V(768)-4.D0*V(770)+V(771)+QCy*VRR0(80,61)+WQy*VRR1(80,61)
      VRR0(80,91)=5.D0*r1x2E*VRR0(80,40)+QCy*VRR0(80,62)+HfxZpE*VRR1(54,62)-5.D0*r1x2E*ZxZpE*VRR1(80,40)+WQy*VRR1(80,62)
      VRR0(80,92)=6.D0*r1x2E*VRR0(80,41)+QCy*VRR0(80,63)+HfxZpE*VRR1(54,63)-6.D0*r1x2E*ZxZpE*VRR1(80,41)+WQy*VRR1(80,63)
      VRR0(80,93)=5.D0*r1x2E*VRR0(80,42)+QCx*VRR0(80,64)+HfxZpE*VRR1(55,64)-5.D0*r1x2E*ZxZpE*VRR1(80,42)+WQx*VRR1(80,64)
      VRR0(80,94)=V(772)+4.D0*r1x2E*VRR0(80,43)+QCx*VRR0(80,65)-4.D0*r1x2E*ZxZpE*VRR1(80,43)+WQx*VRR1(80,65)
      VRR0(80,95)=V(774)+V(775)+V(777)+QCx*VRR0(80,66)+WQx*VRR1(80,66)
      VRR0(80,96)=V(616)+3.D0*r1x2Z*VRR0(31,96)+PAz*VRR0(52,96)-3.D0*ExZpE*r1x2Z*VRR1(31,96)+WPz*VRR1(52,96)
      VRR0(80,97)=V(774)+V(777)+V(778)+QCy*VRR0(80,67)+WQy*VRR1(80,67)
      VRR0(80,98)=V(779)+4.D0*r1x2E*VRR0(80,45)+QCy*VRR0(80,68)-4.D0*r1x2E*ZxZpE*VRR1(80,45)+WQy*VRR1(80,68)
      VRR0(80,99)=5.D0*r1x2E*VRR0(80,46)+QCy*VRR0(80,69)+HfxZpE*VRR1(54,69)-5.D0*r1x2E*ZxZpE*VRR1(80,46)+WQy*VRR1(80,69)
      VRR0(80,100)=4.D0*V(780)+V(781)-4.D0*V(782)+QCx*VRR0(80,70)+WQx*VRR1(80,70)
      VRR0(80,101)=V(784)+V(785)+V(787)+QCx*VRR0(80,71)+WQx*VRR1(80,71)
      VRR0(80,102)=V(622)+3.D0*r1x2Z*VRR0(31,102)+PAz*VRR0(52,102)-3.D0*ExZpE*r1x2Z*VRR1(31,102)+WPz*VRR1(52,102)
      VRR0(80,103)=V(627)+3.D0*r1x2Z*VRR0(31,103)+PAz*VRR0(52,103)-3.D0*ExZpE*r1x2Z*VRR1(31,103)+WPz*VRR1(52,103)
      VRR0(80,104)=V(789)+V(790)+V(792)+QCy*VRR0(80,73)+WQy*VRR1(80,73)
      VRR0(80,105)=4.D0*V(793)+V(794)-4.D0*V(795)+QCy*VRR0(80,74)+WQy*VRR1(80,74)
      VRR0(80,106)=3.D0*V(796)+V(797)-3.D0*V(798)+QCx*VRR0(80,75)+WQx*VRR1(80,75)
      VRR0(80,107)=3.D0*V(633)+3.D0*r1x2Z*VRR0(31,107)+PAz*VRR0(52,107)-3.D0*ExZpE*r1x2Z*VRR1(31,107)+WPz*VRR1(52,107)
      VRR0(80,108)=3.D0*V(637)+3.D0*r1x2Z*VRR0(31,108)+PAz*VRR0(52,108)-3.D0*ExZpE*r1x2Z*VRR1(31,108)+WPz*VRR1(52,108)
      VRR0(80,109)=3.D0*V(681)+3.D0*r1x2Z*VRR0(31,109)+PAz*VRR0(52,109)-3.D0*ExZpE*r1x2Z*VRR1(31,109)+WPz*VRR1(52,109)
      VRR0(80,110)=3.D0*V(799)+V(800)-3.D0*V(801)+QCy*VRR0(80,78)+WQy*VRR1(80,78)
      VRR0(80,111)=4.D0*V(646)+3.D0*V(780)-3.D0*V(782)+QCz*VRR0(80,75)+WQz*VRR1(80,75)
      VRR0(80,112)=4.D0*V(650)+V(784)+V(787)+QCz*VRR0(80,76)+WQz*VRR1(80,76)
      VRR0(80,113)=4.D0*V(693)+V(789)+V(792)+QCz*VRR0(80,77)+WQz*VRR1(80,77)
      VRR0(80,114)=4.D0*V(695)+3.D0*V(793)-3.D0*V(795)+QCz*VRR0(80,78)+WQz*VRR1(80,78)
      VRR0(80,115)=4.D0*V(796)-4.D0*V(798)+QCz*VRR0(80,79)+4.D0*HfxZpE*VRR1(52,79)+WQz*VRR1(80,79)
      VRR0(80,116)=4.D0*r1x2E*VRR0(80,52)+QCz*VRR0(80,80)+4.D0*HfxZpE*VRR1(52,80)-4.D0*r1x2E*ZxZpE*VRR1(80,52)+WQz*VRR1(80,80)
      VRR0(80,117)=4.D0*V(799)-4.D0*V(801)+QCz*VRR0(80,81)+4.D0*HfxZpE*VRR1(52,81)+WQz*VRR1(80,81)
      VRR0(80,118)=5.D0*r1x2E*VRR0(80,54)+QCz*VRR0(80,82)+4.D0*HfxZpE*VRR1(52,82)-5.D0*r1x2E*ZxZpE*VRR1(80,54)+WQz*VRR1(80,82)
      VRR0(80,119)=5.D0*r1x2E*VRR0(80,55)+QCz*VRR0(80,83)+4.D0*HfxZpE*VRR1(52,83)-5.D0*r1x2E*ZxZpE*VRR1(80,55)+WQz*VRR1(80,83)
      VRR0(80,120)=6.D0*r1x2E*VRR0(80,56)+QCz*VRR0(80,84)+4.D0*HfxZpE*VRR1(52,84)-6.D0*r1x2E*ZxZpE*VRR1(80,56)+WQz*VRR1(80,84)
      VRR0(81,85)=6.D0*r1x2E*VRR0(81,36)+QCx*VRR0(81,57)-6.D0*r1x2E*ZxZpE*VRR1(81,36)+WQx*VRR1(81,57)
      VRR0(81,86)=5.D0*r1x2E*VRR0(81,37)+QCx*VRR0(81,58)-5.D0*r1x2E*ZxZpE*VRR1(81,37)+WQx*VRR1(81,58)
      VRR0(81,87)=4.D0*V(802)-4.D0*V(803)+QCx*VRR0(81,59)+WQx*VRR1(81,59)
      VRR0(81,88)=3.D0*V(804)-3.D0*V(805)+QCx*VRR0(81,60)+WQx*VRR1(81,60)
      VRR0(81,89)=2.D0*V(769)+3.D0*V(802)-3.D0*V(803)+QCy*VRR0(81,60)+WQy*VRR1(81,60)
      VRR0(81,90)=4.D0*V(804)-4.D0*V(805)+2.D0*V(806)+QCy*VRR0(81,61)+WQy*VRR1(81,61)
      VRR0(81,91)=5.D0*r1x2E*VRR0(81,40)+QCy*VRR0(81,62)+2.D0*HfxZpE*VRR1(55,62)-5.D0*r1x2E*ZxZpE*VRR1(81,40)+WQy*VRR1(81,62)
      VRR0(81,92)=6.D0*r1x2E*VRR0(81,41)+QCy*VRR0(81,63)+2.D0*HfxZpE*VRR1(55,63)-6.D0*r1x2E*ZxZpE*VRR1(81,41)+WQy*VRR1(81,63)
      VRR0(81,93)=5.D0*r1x2E*VRR0(81,42)+QCx*VRR0(81,64)-5.D0*r1x2E*ZxZpE*VRR1(81,42)+WQx*VRR1(81,64)
      VRR0(81,94)=4.D0*r1x2E*VRR0(81,43)+QCx*VRR0(81,65)-4.D0*r1x2E*ZxZpE*VRR1(81,43)+WQx*VRR1(81,65)
      VRR0(81,95)=V(808)+V(810)+QCx*VRR0(81,66)+WQx*VRR1(81,66)
      VRR0(81,96)=V(531)+V(533)+V(660)+PAz*VRR0(53,96)+WPz*VRR1(53,96)
      VRR0(81,97)=V(808)+V(810)+V(812)+QCy*VRR0(81,67)+WQy*VRR1(81,67)
      VRR0(81,98)=V(814)+4.D0*r1x2E*VRR0(81,45)+QCy*VRR0(81,68)-4.D0*r1x2E*ZxZpE*VRR1(81,45)+WQy*VRR1(81,68)
      VRR0(81,99)=5.D0*r1x2E*VRR0(81,46)+QCy*VRR0(81,69)+2.D0*HfxZpE*VRR1(55,69)-5.D0*r1x2E*ZxZpE*VRR1(81,46)+WQy*VRR1(81,69)
      VRR0(81,100)=4.D0*V(815)-4.D0*V(816)+QCx*VRR0(81,70)+WQx*VRR1(81,70)
      VRR0(81,101)=V(818)+V(820)+QCx*VRR0(81,71)+WQx*VRR1(81,71)
      VRR0(81,102)=V(541)+V(543)+2.D0*V(664)+PAz*VRR0(53,102)+WPz*VRR1(53,102)
      VRR0(81,103)=V(545)+V(547)+2.D0*V(668)+PAz*VRR0(53,103)+WPz*VRR1(53,103)
      VRR0(81,104)=V(822)+2.D0*V(823)+V(825)+QCy*VRR0(81,73)+WQy*VRR1(81,73)
      VRR0(81,105)=4.D0*V(826)+2.D0*V(827)-4.D0*V(828)+QCy*VRR0(81,74)+WQy*VRR1(81,74)
      VRR0(81,106)=3.D0*V(829)-3.D0*V(830)+QCx*VRR0(81,75)+WQx*VRR1(81,75)
      VRR0(81,107)=V(558)+V(560)+3.D0*V(674)+PAz*VRR0(53,107)+WPz*VRR1(53,107)
      VRR0(81,108)=V(562)+V(564)+V(715)+PAz*VRR0(53,108)+WPz*VRR1(53,108)
      VRR0(81,109)=V(566)+V(568)+V(718)+PAz*VRR0(53,109)+WPz*VRR1(53,109)
      VRR0(81,110)=3.D0*V(831)+2.D0*V(832)-3.D0*V(833)+QCy*VRR0(81,78)+WQy*VRR1(81,78)
      VRR0(81,111)=4.D0*V(686)+3.D0*V(815)-3.D0*V(816)+QCz*VRR0(81,75)+WQz*VRR1(81,75)
      VRR0(81,112)=4.D0*V(690)+V(818)+V(820)+QCz*VRR0(81,76)+WQz*VRR1(81,76)
      VRR0(81,113)=4.D0*V(728)+V(822)+V(825)+QCz*VRR0(81,77)+WQz*VRR1(81,77)
      VRR0(81,114)=4.D0*V(730)+3.D0*V(826)-3.D0*V(828)+QCz*VRR0(81,78)+WQz*VRR1(81,78)
      VRR0(81,115)=4.D0*V(829)-4.D0*V(830)+QCz*VRR0(81,79)+4.D0*HfxZpE*VRR1(53,79)+WQz*VRR1(81,79)
      VRR0(81,116)=4.D0*r1x2E*VRR0(81,52)+QCz*VRR0(81,80)+4.D0*HfxZpE*VRR1(53,80)-4.D0*r1x2E*ZxZpE*VRR1(81,52)+WQz*VRR1(81,80)
      VRR0(81,117)=4.D0*V(831)-4.D0*V(833)+QCz*VRR0(81,81)+4.D0*HfxZpE*VRR1(53,81)+WQz*VRR1(81,81)
      VRR0(81,118)=5.D0*r1x2E*VRR0(81,54)+QCz*VRR0(81,82)+4.D0*HfxZpE*VRR1(53,82)-5.D0*r1x2E*ZxZpE*VRR1(81,54)+WQz*VRR1(81,82)
      VRR0(81,119)=5.D0*r1x2E*VRR0(81,55)+QCz*VRR0(81,83)+4.D0*HfxZpE*VRR1(53,83)-5.D0*r1x2E*ZxZpE*VRR1(81,55)+WQz*VRR1(81,83)
      VRR0(81,120)=6.D0*r1x2E*VRR0(81,56)+QCz*VRR0(81,84)+4.D0*HfxZpE*VRR1(53,84)-6.D0*r1x2E*ZxZpE*VRR1(81,56)+WQz*VRR1(81,84)
      VRR0(82,85)=6.D0*r1x2E*VRR0(82,36)+QCx*VRR0(82,57)+HfxZpE*VRR1(56,57)-6.D0*r1x2E*ZxZpE*VRR1(82,36)+WQx*VRR1(82,57)
      VRR0(82,86)=V(834)+5.D0*r1x2E*VRR0(82,37)+QCx*VRR0(82,58)-5.D0*r1x2E*ZxZpE*VRR1(82,37)+WQx*VRR1(82,58)
      VRR0(82,87)=V(835)+4.D0*r1x2E*VRR0(82,38)+QCx*VRR0(82,59)-4.D0*r1x2E*ZxZpE*VRR1(82,38)+WQx*VRR1(82,59)
      VRR0(82,88)=4.D0*r1x2Z*VRR0(33,88)+PAz*VRR0(54,88)-4.D0*ExZpE*r1x2Z*VRR1(33,88)+WPz*VRR1(54,88)
      VRR0(82,89)=4.D0*r1x2Z*VRR0(33,89)+PAz*VRR0(54,89)-4.D0*ExZpE*r1x2Z*VRR1(33,89)+WPz*VRR1(54,89)
      VRR0(82,90)=4.D0*r1x2E*VRR0(82,39)+QCy*VRR0(82,61)-4.D0*r1x2E*ZxZpE*VRR1(82,39)+WQy*VRR1(82,61)
      VRR0(82,91)=5.D0*r1x2E*VRR0(82,40)+QCy*VRR0(82,62)-5.D0*r1x2E*ZxZpE*VRR1(82,40)+WQy*VRR1(82,62)
      VRR0(82,92)=6.D0*r1x2E*VRR0(82,41)+QCy*VRR0(82,63)-6.D0*r1x2E*ZxZpE*VRR1(82,41)+WQy*VRR1(82,63)
      VRR0(82,93)=V(836)+5.D0*r1x2E*VRR0(82,42)+QCx*VRR0(82,64)-5.D0*r1x2E*ZxZpE*VRR1(82,42)+WQx*VRR1(82,64)
      VRR0(82,94)=V(837)+4.D0*r1x2E*VRR0(82,43)+QCx*VRR0(82,65)-4.D0*r1x2E*ZxZpE*VRR1(82,43)+WQx*VRR1(82,65)
      VRR0(82,95)=V(733)+4.D0*r1x2Z*VRR0(33,95)+PAz*VRR0(54,95)-4.D0*ExZpE*r1x2Z*VRR1(33,95)+WPz*VRR1(54,95)
      VRR0(82,96)=V(736)+4.D0*r1x2Z*VRR0(33,96)+PAz*VRR0(54,96)-4.D0*ExZpE*r1x2Z*VRR1(33,96)+WPz*VRR1(54,96)
      VRR0(82,97)=V(771)+4.D0*r1x2Z*VRR0(33,97)+PAz*VRR0(54,97)-4.D0*ExZpE*r1x2Z*VRR1(33,97)+WPz*VRR1(54,97)
      VRR0(82,98)=4.D0*r1x2E*VRR0(82,45)+QCy*VRR0(82,68)-4.D0*r1x2E*ZxZpE*VRR1(82,45)+WQy*VRR1(82,68)
      VRR0(82,99)=5.D0*r1x2E*VRR0(82,46)+QCy*VRR0(82,69)-5.D0*r1x2E*ZxZpE*VRR1(82,46)+WQy*VRR1(82,69)
      VRR0(82,100)=V(838)+4.D0*r1x2E*VRR0(82,47)+QCx*VRR0(82,70)-4.D0*r1x2E*ZxZpE*VRR1(82,47)+WQx*VRR1(82,70)
      VRR0(82,101)=V(739)+4.D0*r1x2Z*VRR0(33,101)+PAz*VRR0(54,101)-4.D0*ExZpE*r1x2Z*VRR1(33,101)+WPz*VRR1(54,101)
      VRR0(82,102)=V(743)+4.D0*r1x2Z*VRR0(33,102)+PAz*VRR0(54,102)-4.D0*ExZpE*r1x2Z*VRR1(33,102)+WPz*VRR1(54,102)
      VRR0(82,103)=2.D0*V(778)+4.D0*r1x2Z*VRR0(33,103)+PAz*VRR0(54,103)-4.D0*ExZpE*r1x2Z*VRR1(33,103)+WPz*VRR1(54,103)
      VRR0(82,104)=2.D0*V(779)+4.D0*r1x2Z*VRR0(33,104)+PAz*VRR0(54,104)-4.D0*ExZpE*r1x2Z*VRR1(33,104)+WPz*VRR1(54,104)
      VRR0(82,105)=4.D0*r1x2E*VRR0(82,50)+QCy*VRR0(82,74)-4.D0*r1x2E*ZxZpE*VRR1(82,50)+WQy*VRR1(82,74)
      VRR0(82,106)=3.D0*V(747)+4.D0*r1x2Z*VRR0(33,106)+PAz*VRR0(54,106)-4.D0*ExZpE*r1x2Z*VRR1(33,106)+WPz*VRR1(54,106)
      VRR0(82,107)=3.D0*V(751)+4.D0*r1x2Z*VRR0(33,107)+PAz*VRR0(54,107)-4.D0*ExZpE*r1x2Z*VRR1(33,107)+WPz*VRR1(54,107)
      VRR0(82,108)=4.D0*r1x2Z*VRR0(33,108)+PAz*VRR0(54,108)-4.D0*ExZpE*r1x2Z*VRR1(33,108)+3.D0*HfxZpE*VRR1(54,72)+WPz*VRR1(54,108)
      VRR0(82,109)=3.D0*V(790)+4.D0*r1x2Z*VRR0(33,109)+PAz*VRR0(54,109)-4.D0*ExZpE*r1x2Z*VRR1(33,109)+WPz*VRR1(54,109)
      VRR0(82,110)=3.D0*V(794)+4.D0*r1x2Z*VRR0(33,110)+PAz*VRR0(54,110)-4.D0*ExZpE*r1x2Z*VRR1(33,110)+WPz*VRR1(54,110)
      VRR0(82,111)=4.D0*V(761)+4.D0*r1x2Z*VRR0(33,111)+PAz*VRR0(54,111)-4.D0*ExZpE*r1x2Z*VRR1(33,111)+WPz*VRR1(54,111)
      VRR0(82,112)=4.D0*r1x2Z*VRR0(33,112)+PAz*VRR0(54,112)-4.D0*ExZpE*r1x2Z*VRR1(33,112)+4.D0*HfxZpE*VRR1(54,76)+WPz*VRR1(54,112)
      VRR0(82,113)=4.D0*r1x2Z*VRR0(33,113)+PAz*VRR0(54,113)-4.D0*ExZpE*r1x2Z*VRR1(33,113)+4.D0*HfxZpE*VRR1(54,77)+WPz*VRR1(54,113)
      VRR0(82,114)=4.D0*V(800)+4.D0*r1x2Z*VRR0(33,114)+PAz*VRR0(54,114)-4.D0*ExZpE*r1x2Z*VRR1(33,114)+WPz*VRR1(54,114)
      VRR0(82,115)=4.D0*r1x2E*VRR0(82,51)+QCz*VRR0(82,79)+5.D0*HfxZpE*VRR1(54,79)-4.D0*r1x2E*ZxZpE*VRR1(82,51)+WQz*VRR1(82,79)
      VRR0(82,116)=4.D0*r1x2E*VRR0(82,52)+QCz*VRR0(82,80)+5.D0*HfxZpE*VRR1(54,80)-4.D0*r1x2E*ZxZpE*VRR1(82,52)+WQz*VRR1(82,80)
      VRR0(82,117)=4.D0*r1x2E*VRR0(82,53)+QCz*VRR0(82,81)+5.D0*HfxZpE*VRR1(54,81)-4.D0*r1x2E*ZxZpE*VRR1(82,53)+WQz*VRR1(82,81)
      VRR0(82,118)=5.D0*r1x2E*VRR0(82,54)+QCz*VRR0(82,82)+5.D0*HfxZpE*VRR1(54,82)-5.D0*r1x2E*ZxZpE*VRR1(82,54)+WQz*VRR1(82,82)
      VRR0(82,119)=5.D0*r1x2E*VRR0(82,55)+QCz*VRR0(82,83)+5.D0*HfxZpE*VRR1(54,83)-5.D0*r1x2E*ZxZpE*VRR1(82,55)+WQz*VRR1(82,83)
      VRR0(82,120)=6.D0*r1x2E*VRR0(82,56)+QCz*VRR0(82,84)+5.D0*HfxZpE*VRR1(54,84)-6.D0*r1x2E*ZxZpE*VRR1(82,56)+WQz*VRR1(82,84)
      VRR0(83,85)=6.D0*r1x2E*VRR0(83,36)+QCx*VRR0(83,57)-6.D0*r1x2E*ZxZpE*VRR1(83,36)+WQx*VRR1(83,57)
      VRR0(83,86)=5.D0*r1x2E*VRR0(83,37)+QCx*VRR0(83,58)-5.D0*r1x2E*ZxZpE*VRR1(83,37)+WQx*VRR1(83,58)
      VRR0(83,87)=4.D0*r1x2E*VRR0(83,38)+QCx*VRR0(83,59)-4.D0*r1x2E*ZxZpE*VRR1(83,38)+WQx*VRR1(83,59)
      VRR0(83,88)=4.D0*r1x2Z*VRR0(34,88)+PAz*VRR0(55,88)-4.D0*ExZpE*r1x2Z*VRR1(34,88)+WPz*VRR1(55,88)
      VRR0(83,89)=4.D0*r1x2Z*VRR0(34,89)+PAz*VRR0(55,89)-4.D0*ExZpE*r1x2Z*VRR1(34,89)+WPz*VRR1(55,89)
      VRR0(83,90)=V(839)+4.D0*r1x2E*VRR0(83,39)+QCy*VRR0(83,61)-4.D0*r1x2E*ZxZpE*VRR1(83,39)+WQy*VRR1(83,61)
      VRR0(83,91)=V(840)+5.D0*r1x2E*VRR0(83,40)+QCy*VRR0(83,62)-5.D0*r1x2E*ZxZpE*VRR1(83,40)+WQy*VRR1(83,62)
      VRR0(83,92)=6.D0*r1x2E*VRR0(83,41)+QCy*VRR0(83,63)+HfxZpE*VRR1(56,63)-6.D0*r1x2E*ZxZpE*VRR1(83,41)+WQy*VRR1(83,63)
      VRR0(83,93)=5.D0*r1x2E*VRR0(83,42)+QCx*VRR0(83,64)-5.D0*r1x2E*ZxZpE*VRR1(83,42)+WQx*VRR1(83,64)
      VRR0(83,94)=4.D0*r1x2E*VRR0(83,43)+QCx*VRR0(83,65)-4.D0*r1x2E*ZxZpE*VRR1(83,43)+WQx*VRR1(83,65)
      VRR0(83,95)=V(766)+4.D0*r1x2Z*VRR0(34,95)+PAz*VRR0(55,95)-4.D0*ExZpE*r1x2Z*VRR1(34,95)+WPz*VRR1(55,95)
      VRR0(83,96)=V(769)+4.D0*r1x2Z*VRR0(34,96)+PAz*VRR0(55,96)-4.D0*ExZpE*r1x2Z*VRR1(34,96)+WPz*VRR1(55,96)
      VRR0(83,97)=V(806)+4.D0*r1x2Z*VRR0(34,97)+PAz*VRR0(55,97)-4.D0*ExZpE*r1x2Z*VRR1(34,97)+WPz*VRR1(55,97)
      VRR0(83,98)=V(841)+4.D0*r1x2E*VRR0(83,45)+QCy*VRR0(83,68)-4.D0*r1x2E*ZxZpE*VRR1(83,45)+WQy*VRR1(83,68)
      VRR0(83,99)=V(842)+5.D0*r1x2E*VRR0(83,46)+QCy*VRR0(83,69)-5.D0*r1x2E*ZxZpE*VRR1(83,46)+WQy*VRR1(83,69)
      VRR0(83,100)=4.D0*r1x2E*VRR0(83,47)+QCx*VRR0(83,70)-4.D0*r1x2E*ZxZpE*VRR1(83,47)+WQx*VRR1(83,70)
      VRR0(83,101)=2.D0*V(772)+4.D0*r1x2Z*VRR0(34,101)+PAz*VRR0(55,101)-4.D0*ExZpE*r1x2Z*VRR1(34,101)+WPz*VRR1(55,101)
      VRR0(83,102)=2.D0*V(775)+4.D0*r1x2Z*VRR0(34,102)+PAz*VRR0(55,102)-4.D0*ExZpE*r1x2Z*VRR1(34,102)+WPz*VRR1(55,102)
      VRR0(83,103)=V(812)+4.D0*r1x2Z*VRR0(34,103)+PAz*VRR0(55,103)-4.D0*ExZpE*r1x2Z*VRR1(34,103)+WPz*VRR1(55,103)
      VRR0(83,104)=V(814)+4.D0*r1x2Z*VRR0(34,104)+PAz*VRR0(55,104)-4.D0*ExZpE*r1x2Z*VRR1(34,104)+WPz*VRR1(55,104)
      VRR0(83,105)=V(843)+4.D0*r1x2E*VRR0(83,50)+QCy*VRR0(83,74)-4.D0*r1x2E*ZxZpE*VRR1(83,50)+WQy*VRR1(83,74)
      VRR0(83,106)=3.D0*V(781)+4.D0*r1x2Z*VRR0(34,106)+PAz*VRR0(55,106)-4.D0*ExZpE*r1x2Z*VRR1(34,106)+WPz*VRR1(55,106)
      VRR0(83,107)=3.D0*V(785)+4.D0*r1x2Z*VRR0(34,107)+PAz*VRR0(55,107)-4.D0*ExZpE*r1x2Z*VRR1(34,107)+WPz*VRR1(55,107)
      VRR0(83,108)=4.D0*r1x2Z*VRR0(34,108)+PAz*VRR0(55,108)-4.D0*ExZpE*r1x2Z*VRR1(34,108)+3.D0*HfxZpE*VRR1(55,72)+WPz*VRR1(55,108)
      VRR0(83,109)=3.D0*V(823)+4.D0*r1x2Z*VRR0(34,109)+PAz*VRR0(55,109)-4.D0*ExZpE*r1x2Z*VRR1(34,109)+WPz*VRR1(55,109)
      VRR0(83,110)=3.D0*V(827)+4.D0*r1x2Z*VRR0(34,110)+PAz*VRR0(55,110)-4.D0*ExZpE*r1x2Z*VRR1(34,110)+WPz*VRR1(55,110)
      VRR0(83,111)=4.D0*V(797)+4.D0*r1x2Z*VRR0(34,111)+PAz*VRR0(55,111)-4.D0*ExZpE*r1x2Z*VRR1(34,111)+WPz*VRR1(55,111)
      VRR0(83,112)=4.D0*r1x2Z*VRR0(34,112)+PAz*VRR0(55,112)-4.D0*ExZpE*r1x2Z*VRR1(34,112)+4.D0*HfxZpE*VRR1(55,76)+WPz*VRR1(55,112)
      VRR0(83,113)=4.D0*r1x2Z*VRR0(34,113)+PAz*VRR0(55,113)-4.D0*ExZpE*r1x2Z*VRR1(34,113)+4.D0*HfxZpE*VRR1(55,77)+WPz*VRR1(55,113)
      VRR0(83,114)=4.D0*V(832)+4.D0*r1x2Z*VRR0(34,114)+PAz*VRR0(55,114)-4.D0*ExZpE*r1x2Z*VRR1(34,114)+WPz*VRR1(55,114)
      VRR0(83,115)=4.D0*r1x2E*VRR0(83,51)+QCz*VRR0(83,79)+5.D0*HfxZpE*VRR1(55,79)-4.D0*r1x2E*ZxZpE*VRR1(83,51)+WQz*VRR1(83,79)
      VRR0(83,116)=4.D0*r1x2E*VRR0(83,52)+QCz*VRR0(83,80)+5.D0*HfxZpE*VRR1(55,80)-4.D0*r1x2E*ZxZpE*VRR1(83,52)+WQz*VRR1(83,80)
      VRR0(83,117)=4.D0*r1x2E*VRR0(83,53)+QCz*VRR0(83,81)+5.D0*HfxZpE*VRR1(55,81)-4.D0*r1x2E*ZxZpE*VRR1(83,53)+WQz*VRR1(83,81)
      VRR0(83,118)=5.D0*r1x2E*VRR0(83,54)+QCz*VRR0(83,82)+5.D0*HfxZpE*VRR1(55,82)-5.D0*r1x2E*ZxZpE*VRR1(83,54)+WQz*VRR1(83,82)
      VRR0(83,119)=5.D0*r1x2E*VRR0(83,55)+QCz*VRR0(83,83)+5.D0*HfxZpE*VRR1(55,83)-5.D0*r1x2E*ZxZpE*VRR1(83,55)+WQz*VRR1(83,83)
      VRR0(83,120)=6.D0*r1x2E*VRR0(83,56)+QCz*VRR0(83,84)+5.D0*HfxZpE*VRR1(55,84)-6.D0*r1x2E*ZxZpE*VRR1(83,56)+WQz*VRR1(83,84)
      VRR0(84,85)=6.D0*r1x2E*VRR0(84,36)+QCx*VRR0(84,57)-6.D0*r1x2E*ZxZpE*VRR1(84,36)+WQx*VRR1(84,57)
      VRR0(84,86)=5.D0*r1x2E*VRR0(84,37)+QCx*VRR0(84,58)-5.D0*r1x2E*ZxZpE*VRR1(84,37)+WQx*VRR1(84,58)
      VRR0(84,87)=5.D0*r1x2Z*VRR0(35,87)+PAz*VRR0(56,87)-5.D0*ExZpE*r1x2Z*VRR1(35,87)+WPz*VRR1(56,87)
      VRR0(84,88)=5.D0*r1x2Z*VRR0(35,88)+PAz*VRR0(56,88)-5.D0*ExZpE*r1x2Z*VRR1(35,88)+WPz*VRR1(56,88)
      VRR0(84,89)=5.D0*r1x2Z*VRR0(35,89)+PAz*VRR0(56,89)-5.D0*ExZpE*r1x2Z*VRR1(35,89)+WPz*VRR1(56,89)
      VRR0(84,90)=5.D0*r1x2Z*VRR0(35,90)+PAz*VRR0(56,90)-5.D0*ExZpE*r1x2Z*VRR1(35,90)+WPz*VRR1(56,90)
      VRR0(84,91)=5.D0*r1x2E*VRR0(84,40)+QCy*VRR0(84,62)-5.D0*r1x2E*ZxZpE*VRR1(84,40)+WQy*VRR1(84,62)
      VRR0(84,92)=6.D0*r1x2E*VRR0(84,41)+QCy*VRR0(84,63)-6.D0*r1x2E*ZxZpE*VRR1(84,41)+WQy*VRR1(84,63)
      VRR0(84,93)=5.D0*r1x2E*VRR0(84,42)+QCx*VRR0(84,64)-5.D0*r1x2E*ZxZpE*VRR1(84,42)+WQx*VRR1(84,64)
      VRR0(84,94)=V(834)+5.D0*r1x2Z*VRR0(35,94)+PAz*VRR0(56,94)-5.D0*ExZpE*r1x2Z*VRR1(35,94)+WPz*VRR1(56,94)
      VRR0(84,95)=V(835)+5.D0*r1x2Z*VRR0(35,95)+PAz*VRR0(56,95)-5.D0*ExZpE*r1x2Z*VRR1(35,95)+WPz*VRR1(56,95)
      VRR0(84,96)=5.D0*r1x2Z*VRR0(35,96)+PAz*VRR0(56,96)-5.D0*ExZpE*r1x2Z*VRR1(35,96)+HfxZpE*VRR1(56,60)+WPz*VRR1(56,96)
      VRR0(84,97)=V(839)+5.D0*r1x2Z*VRR0(35,97)+PAz*VRR0(56,97)-5.D0*ExZpE*r1x2Z*VRR1(35,97)+WPz*VRR1(56,97)
      VRR0(84,98)=V(840)+5.D0*r1x2Z*VRR0(35,98)+PAz*VRR0(56,98)-5.D0*ExZpE*r1x2Z*VRR1(35,98)+WPz*VRR1(56,98)
      VRR0(84,99)=5.D0*r1x2E*VRR0(84,46)+QCy*VRR0(84,69)-5.D0*r1x2E*ZxZpE*VRR1(84,46)+WQy*VRR1(84,69)
      VRR0(84,100)=2.D0*V(836)+5.D0*r1x2Z*VRR0(35,100)+PAz*VRR0(56,100)-5.D0*ExZpE*r1x2Z*VRR1(35,100)+WPz*VRR1(56,100)
      VRR0(84,101)=2.D0*V(837)+5.D0*r1x2Z*VRR0(35,101)+PAz*VRR0(56,101)-5.D0*ExZpE*r1x2Z*VRR1(35,101)+WPz*VRR1(56,101)
      VRR0(84,102)=5.D0*r1x2Z*VRR0(35,102)+PAz*VRR0(56,102)-5.D0*ExZpE*r1x2Z*VRR1(35,102)+2.D0*HfxZpE*VRR1(56,66)+WPz*VRR1(56,102)
      VRR0(84,103)=5.D0*r1x2Z*VRR0(35,103)+PAz*VRR0(56,103)-5.D0*ExZpE*r1x2Z*VRR1(35,103)+2.D0*HfxZpE*VRR1(56,67)+WPz*VRR1(56,103)
      VRR0(84,104)=2.D0*V(841)+5.D0*r1x2Z*VRR0(35,104)+PAz*VRR0(56,104)-5.D0*ExZpE*r1x2Z*VRR1(35,104)+WPz*VRR1(56,104)
      VRR0(84,105)=2.D0*V(842)+5.D0*r1x2Z*VRR0(35,105)+PAz*VRR0(56,105)-5.D0*ExZpE*r1x2Z*VRR1(35,105)+WPz*VRR1(56,105)
      VRR0(84,106)=3.D0*V(838)+5.D0*r1x2Z*VRR0(35,106)+PAz*VRR0(56,106)-5.D0*ExZpE*r1x2Z*VRR1(35,106)+WPz*VRR1(56,106)
      VRR0(84,107)=5.D0*r1x2Z*VRR0(35,107)+PAz*VRR0(56,107)-5.D0*ExZpE*r1x2Z*VRR1(35,107)+3.D0*HfxZpE*VRR1(56,71)+WPz*VRR1(56,107)
      VRR0(84,108)=5.D0*r1x2Z*VRR0(35,108)+PAz*VRR0(56,108)-5.D0*ExZpE*r1x2Z*VRR1(35,108)+3.D0*HfxZpE*VRR1(56,72)+WPz*VRR1(56,108)
      VRR0(84,109)=5.D0*r1x2Z*VRR0(35,109)+PAz*VRR0(56,109)-5.D0*ExZpE*r1x2Z*VRR1(35,109)+3.D0*HfxZpE*VRR1(56,73)+WPz*VRR1(56,109)
      VRR0(84,110)=3.D0*V(843)+5.D0*r1x2Z*VRR0(35,110)+PAz*VRR0(56,110)-5.D0*ExZpE*r1x2Z*VRR1(35,110)+WPz*VRR1(56,110)
      VRR0(84,111)=5.D0*r1x2Z*VRR0(35,111)+PAz*VRR0(56,111)-5.D0*ExZpE*r1x2Z*VRR1(35,111)+4.D0*HfxZpE*VRR1(56,75)+WPz*VRR1(56,111)
      VRR0(84,112)=5.D0*r1x2Z*VRR0(35,112)+PAz*VRR0(56,112)-5.D0*ExZpE*r1x2Z*VRR1(35,112)+4.D0*HfxZpE*VRR1(56,76)+WPz*VRR1(56,112)
      VRR0(84,113)=5.D0*r1x2Z*VRR0(35,113)+PAz*VRR0(56,113)-5.D0*ExZpE*r1x2Z*VRR1(35,113)+4.D0*HfxZpE*VRR1(56,77)+WPz*VRR1(56,113)
      VRR0(84,114)=5.D0*r1x2Z*VRR0(35,114)+PAz*VRR0(56,114)-5.D0*ExZpE*r1x2Z*VRR1(35,114)+4.D0*HfxZpE*VRR1(56,78)+WPz*VRR1(56,114)
      VRR0(84,115)=5.D0*r1x2Z*VRR0(35,115)+PAz*VRR0(56,115)-5.D0*ExZpE*r1x2Z*VRR1(35,115)+5.D0*HfxZpE*VRR1(56,79)+WPz*VRR1(56,115)
      VRR0(84,116)=5.D0*r1x2Z*VRR0(35,116)+PAz*VRR0(56,116)-5.D0*ExZpE*r1x2Z*VRR1(35,116)+5.D0*HfxZpE*VRR1(56,80)+WPz*VRR1(56,116)
      VRR0(84,117)=5.D0*r1x2Z*VRR0(35,117)+PAz*VRR0(56,117)-5.D0*ExZpE*r1x2Z*VRR1(35,117)+5.D0*HfxZpE*VRR1(56,81)+WPz*VRR1(56,117)
      VRR0(84,118)=5.D0*r1x2E*VRR0(84,54)+QCz*VRR0(84,82)+6.D0*HfxZpE*VRR1(56,82)-5.D0*r1x2E*ZxZpE*VRR1(84,54)+WQz*VRR1(84,82)
      VRR0(84,119)=5.D0*r1x2E*VRR0(84,55)+QCz*VRR0(84,83)+6.D0*HfxZpE*VRR1(56,83)-5.D0*r1x2E*ZxZpE*VRR1(84,55)+WQz*VRR1(84,83)
      VRR0(84,120)=6.D0*r1x2E*VRR0(84,56)+QCz*VRR0(84,84)+6.D0*HfxZpE*VRR1(56,84)-6.D0*r1x2E*ZxZpE*VRR1(84,56)+WQz*VRR1(84,84)
END SUBROUTINE VRRi0j0
