!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRj0g0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(38,22)
      V(2)=ExZpE*r1x2Z*VRR1(38,22)
      V(3)=r1x2Z*VRR0(38,23)
      V(4)=ExZpE*r1x2Z*VRR1(38,23)
      V(5)=r1x2Z*VRR0(38,24)
      V(6)=ExZpE*r1x2Z*VRR1(38,24)
      V(7)=HfxZpE*VRR1(59,14)
      V(8)=r1x2Z*VRR0(38,26)
      V(9)=ExZpE*r1x2Z*VRR1(38,26)
      V(10)=r1x2Z*VRR0(38,27)
      V(11)=ExZpE*r1x2Z*VRR1(38,27)
      V(12)=r1x2Z*VRR0(38,28)
      V(13)=ExZpE*r1x2Z*VRR1(38,28)
      V(14)=r1x2Z*VRR0(38,29)
      V(15)=ExZpE*r1x2Z*VRR1(38,29)
      V(16)=r1x2Z*VRR0(38,30)
      V(17)=ExZpE*r1x2Z*VRR1(38,30)
      V(18)=r1x2Z*VRR0(38,31)
      V(19)=ExZpE*r1x2Z*VRR1(38,31)
      V(20)=r1x2Z*VRR0(38,32)
      V(21)=ExZpE*r1x2Z*VRR1(38,32)
      V(22)=r1x2Z*VRR0(38,33)
      V(23)=ExZpE*r1x2Z*VRR1(38,33)
      V(24)=HfxZpE*VRR1(59,20)
      V(25)=r1x2Z*VRR0(38,34)
      V(26)=ExZpE*r1x2Z*VRR1(38,34)
      V(27)=HfxZpE*VRR1(60,11)
      V(28)=r1x2Z*VRR0(39,22)
      V(29)=ExZpE*r1x2Z*VRR1(39,22)
      V(30)=HfxZpE*VRR1(60,12)
      V(31)=r1x2Z*VRR0(39,23)
      V(32)=ExZpE*r1x2Z*VRR1(39,23)
      V(33)=HfxZpE*VRR1(60,13)
      V(34)=r1x2Z*VRR0(39,24)
      V(35)=ExZpE*r1x2Z*VRR1(39,24)
      V(36)=HfxZpE*VRR1(60,14)
      V(37)=r1x2Z*VRR0(39,26)
      V(38)=ExZpE*r1x2Z*VRR1(39,26)
      V(39)=HfxZpE*VRR1(60,15)
      V(40)=r1x2Z*VRR0(39,27)
      V(41)=ExZpE*r1x2Z*VRR1(39,27)
      V(42)=HfxZpE*VRR1(60,16)
      V(43)=2.D0*V(42)
      V(44)=r1x2Z*VRR0(39,28)
      V(45)=ExZpE*r1x2Z*VRR1(39,28)
      V(46)=HfxZpE*VRR1(60,17)
      V(47)=r1x2Z*VRR0(39,29)
      V(48)=ExZpE*r1x2Z*VRR1(39,29)
      V(49)=r1x2Z*VRR0(39,30)
      V(50)=ExZpE*r1x2Z*VRR1(39,30)
      V(51)=HfxZpE*VRR1(60,18)
      V(52)=r1x2Z*VRR0(39,31)
      V(53)=ExZpE*r1x2Z*VRR1(39,31)
      V(54)=HfxZpE*VRR1(60,19)
      V(55)=r1x2Z*VRR0(39,32)
      V(56)=ExZpE*r1x2Z*VRR1(39,32)
      V(57)=r1x2Z*VRR0(39,33)
      V(58)=ExZpE*r1x2Z*VRR1(39,33)
      V(59)=HfxZpE*VRR1(60,20)
      V(60)=r1x2Z*VRR0(39,34)
      V(61)=ExZpE*r1x2Z*VRR1(39,34)
      V(62)=HfxZpE*VRR1(61,11)
      V(63)=HfxZpE*VRR1(61,20)
      V(64)=HfxZpE*VRR1(65,14)
      V(65)=HfxZpE*VRR1(65,20)
      V(66)=r1x2Z*VRR0(44,22)
      V(67)=3.D0*V(66)
      V(68)=ExZpE*r1x2Z*VRR1(44,22)
      V(69)=-3.D0*V(68)
      V(70)=r1x2Z*VRR0(44,23)
      V(71)=3.D0*V(70)
      V(72)=ExZpE*r1x2Z*VRR1(44,23)
      V(73)=-3.D0*V(72)
      V(74)=HfxZpE*VRR1(66,13)
      V(75)=r1x2Z*VRR0(44,24)
      V(76)=3.D0*V(75)
      V(77)=ExZpE*r1x2Z*VRR1(44,24)
      V(78)=-3.D0*V(77)
      V(79)=HfxZpE*VRR1(66,14)
      V(80)=r1x2Z*VRR0(44,26)
      V(81)=3.D0*V(80)
      V(82)=ExZpE*r1x2Z*VRR1(44,26)
      V(83)=-3.D0*V(82)
      V(84)=r1x2Z*VRR0(44,27)
      V(85)=3.D0*V(84)
      V(86)=ExZpE*r1x2Z*VRR1(44,27)
      V(87)=-3.D0*V(86)
      V(88)=r1x2Z*VRR0(44,28)
      V(89)=3.D0*V(88)
      V(90)=ExZpE*r1x2Z*VRR1(44,28)
      V(91)=-3.D0*V(90)
      V(92)=HfxZpE*VRR1(66,17)
      V(93)=r1x2Z*VRR0(44,29)
      V(94)=3.D0*V(93)
      V(95)=ExZpE*r1x2Z*VRR1(44,29)
      V(96)=-3.D0*V(95)
      V(97)=r1x2Z*VRR0(44,30)
      V(98)=3.D0*V(97)
      V(99)=ExZpE*r1x2Z*VRR1(44,30)
      V(100)=-3.D0*V(99)
      V(101)=HfxZpE*VRR1(66,18)
      V(102)=2.D0*V(101)
      V(103)=r1x2Z*VRR0(44,31)
      V(104)=3.D0*V(103)
      V(105)=ExZpE*r1x2Z*VRR1(44,31)
      V(106)=-3.D0*V(105)
      V(107)=HfxZpE*VRR1(66,19)
      V(108)=r1x2Z*VRR0(44,32)
      V(109)=3.D0*V(108)
      V(110)=ExZpE*r1x2Z*VRR1(44,32)
      V(111)=-3.D0*V(110)
      V(112)=r1x2Z*VRR0(44,33)
      V(113)=3.D0*V(112)
      V(114)=ExZpE*r1x2Z*VRR1(44,33)
      V(115)=-3.D0*V(114)
      V(116)=HfxZpE*VRR1(66,20)
      V(117)=r1x2Z*VRR0(44,34)
      V(118)=3.D0*V(117)
      V(119)=ExZpE*r1x2Z*VRR1(44,34)
      V(120)=-3.D0*V(119)
      V(121)=HfxZpE*VRR1(67,11)
      V(122)=r1x2E*VRR0(96,6)
      V(123)=2.D0*V(122)
      V(124)=HfxZpE*VRR1(67,12)
      V(125)=r1x2E*ZxZpE*VRR1(96,6)
      V(126)=-2.D0*V(125)
      V(127)=r1x2Z*VRR0(45,23)
      V(128)=ExZpE*r1x2Z*VRR1(45,23)
      V(129)=HfxZpE*VRR1(67,13)
      V(130)=r1x2E*VRR0(96,8)
      V(131)=2.D0*V(130)
      V(132)=HfxZpE*VRR1(67,15)
      V(133)=r1x2E*ZxZpE*VRR1(96,8)
      V(134)=-2.D0*V(133)
      V(135)=r1x2Z*VRR0(45,27)
      V(136)=ExZpE*r1x2Z*VRR1(45,27)
      V(137)=HfxZpE*VRR1(67,16)
      V(138)=2.D0*V(137)
      V(139)=r1x2Z*VRR0(45,28)
      V(140)=ExZpE*r1x2Z*VRR1(45,28)
      V(141)=HfxZpE*VRR1(67,17)
      V(142)=r1x2E*VRR0(96,9)
      V(143)=2.D0*V(142)
      V(144)=r1x2E*ZxZpE*VRR1(96,9)
      V(145)=-2.D0*V(144)
      V(146)=r1x2Z*VRR0(45,30)
      V(147)=ExZpE*r1x2Z*VRR1(45,30)
      V(148)=HfxZpE*VRR1(67,18)
      V(149)=2.D0*V(148)
      V(150)=r1x2Z*VRR0(45,31)
      V(151)=ExZpE*r1x2Z*VRR1(45,31)
      V(152)=HfxZpE*VRR1(67,19)
      V(153)=r1x2Z*VRR0(45,32)
      V(154)=ExZpE*r1x2Z*VRR1(45,32)
      V(155)=HfxZpE*VRR1(68,11)
      V(156)=2.D0*V(152)
      V(157)=HfxZpE*VRR1(67,20)
      V(158)=HfxZpE*VRR1(68,20)
      V(159)=r1x2Z*VRR0(47,22)
      V(160)=ExZpE*r1x2Z*VRR1(47,22)
      V(161)=r1x2Z*VRR0(47,23)
      V(162)=ExZpE*r1x2Z*VRR1(47,23)
      V(163)=r1x2Z*VRR0(47,24)
      V(164)=ExZpE*r1x2Z*VRR1(47,24)
      V(165)=HfxZpE*VRR1(70,14)
      V(166)=r1x2Z*VRR0(47,26)
      V(167)=ExZpE*r1x2Z*VRR1(47,26)
      V(168)=r1x2Z*VRR0(47,27)
      V(169)=ExZpE*r1x2Z*VRR1(47,27)
      V(170)=r1x2Z*VRR0(47,28)
      V(171)=ExZpE*r1x2Z*VRR1(47,28)
      V(172)=r1x2Z*VRR0(47,29)
      V(173)=ExZpE*r1x2Z*VRR1(47,29)
      V(174)=r1x2Z*VRR0(47,30)
      V(175)=ExZpE*r1x2Z*VRR1(47,30)
      V(176)=r1x2Z*VRR0(47,31)
      V(177)=ExZpE*r1x2Z*VRR1(47,31)
      V(178)=r1x2Z*VRR0(47,32)
      V(179)=ExZpE*r1x2Z*VRR1(47,32)
      V(180)=r1x2Z*VRR0(47,33)
      V(181)=ExZpE*r1x2Z*VRR1(47,33)
      V(182)=HfxZpE*VRR1(70,20)
      V(183)=r1x2Z*VRR0(47,34)
      V(184)=ExZpE*r1x2Z*VRR1(47,34)
      V(185)=r1x2Z*VRR0(48,22)
      V(186)=3.D0*V(185)
      V(187)=ExZpE*r1x2Z*VRR1(48,22)
      V(188)=-3.D0*V(187)
      V(189)=r1x2Z*VRR0(48,23)
      V(190)=3.D0*V(189)
      V(191)=ExZpE*r1x2Z*VRR1(48,23)
      V(192)=-3.D0*V(191)
      V(193)=HfxZpE*VRR1(71,13)
      V(194)=2.D0*V(193)
      V(195)=r1x2Z*VRR0(48,24)
      V(196)=3.D0*V(195)
      V(197)=ExZpE*r1x2Z*VRR1(48,24)
      V(198)=-3.D0*V(197)
      V(199)=HfxZpE*VRR1(71,14)
      V(200)=r1x2Z*VRR0(48,26)
      V(201)=3.D0*V(200)
      V(202)=ExZpE*r1x2Z*VRR1(48,26)
      V(203)=-3.D0*V(202)
      V(204)=r1x2Z*VRR0(48,27)
      V(205)=3.D0*V(204)
      V(206)=ExZpE*r1x2Z*VRR1(48,27)
      V(207)=-3.D0*V(206)
      V(208)=r1x2Z*VRR0(48,28)
      V(209)=3.D0*V(208)
      V(210)=ExZpE*r1x2Z*VRR1(48,28)
      V(211)=-3.D0*V(210)
      V(212)=HfxZpE*VRR1(71,17)
      V(213)=r1x2Z*VRR0(48,29)
      V(214)=3.D0*V(213)
      V(215)=ExZpE*r1x2Z*VRR1(48,29)
      V(216)=-3.D0*V(215)
      V(217)=r1x2Z*VRR0(48,30)
      V(218)=3.D0*V(217)
      V(219)=ExZpE*r1x2Z*VRR1(48,30)
      V(220)=-3.D0*V(219)
      V(221)=HfxZpE*VRR1(71,18)
      V(222)=r1x2Z*VRR0(48,31)
      V(223)=3.D0*V(222)
      V(224)=ExZpE*r1x2Z*VRR1(48,31)
      V(225)=-3.D0*V(224)
      V(226)=HfxZpE*VRR1(71,19)
      V(227)=r1x2Z*VRR0(48,32)
      V(228)=3.D0*V(227)
      V(229)=ExZpE*r1x2Z*VRR1(48,32)
      V(230)=-3.D0*V(229)
      V(231)=r1x2Z*VRR0(48,33)
      V(232)=3.D0*V(231)
      V(233)=ExZpE*r1x2Z*VRR1(48,33)
      V(234)=-3.D0*V(233)
      V(235)=HfxZpE*VRR1(71,20)
      V(236)=r1x2Z*VRR0(48,34)
      V(237)=3.D0*V(236)
      V(238)=ExZpE*r1x2Z*VRR1(48,34)
      V(239)=-3.D0*V(238)
      V(240)=r1x2E*VRR0(102,6)
      V(241)=2.D0*V(240)
      V(242)=HfxZpE*VRR1(72,12)
      V(243)=r1x2E*ZxZpE*VRR1(102,6)
      V(244)=-2.D0*V(243)
      V(245)=r1x2Z*VRR0(49,23)
      V(246)=ExZpE*r1x2Z*VRR1(49,23)
      V(247)=HfxZpE*VRR1(72,13)
      V(248)=r1x2E*VRR0(102,8)
      V(249)=2.D0*V(248)
      V(250)=HfxZpE*VRR1(72,15)
      V(251)=r1x2E*ZxZpE*VRR1(102,8)
      V(252)=-2.D0*V(251)
      V(253)=r1x2Z*VRR0(49,27)
      V(254)=ExZpE*r1x2Z*VRR1(49,27)
      V(255)=HfxZpE*VRR1(72,16)
      V(256)=2.D0*V(255)
      V(257)=r1x2Z*VRR0(49,28)
      V(258)=ExZpE*r1x2Z*VRR1(49,28)
      V(259)=HfxZpE*VRR1(72,17)
      V(260)=r1x2E*VRR0(102,9)
      V(261)=2.D0*V(260)
      V(262)=r1x2E*ZxZpE*VRR1(102,9)
      V(263)=-2.D0*V(262)
      V(264)=r1x2Z*VRR0(49,30)
      V(265)=ExZpE*r1x2Z*VRR1(49,30)
      V(266)=HfxZpE*VRR1(72,18)
      V(267)=r1x2Z*VRR0(49,31)
      V(268)=ExZpE*r1x2Z*VRR1(49,31)
      V(269)=HfxZpE*VRR1(72,19)
      V(270)=r1x2Z*VRR0(49,32)
      V(271)=ExZpE*r1x2Z*VRR1(49,32)
      V(272)=HfxZpE*VRR1(73,11)
      V(273)=r1x2E*VRR0(103,6)
      V(274)=2.D0*V(273)
      V(275)=HfxZpE*VRR1(73,12)
      V(276)=2.D0*V(275)
      V(277)=r1x2E*ZxZpE*VRR1(103,6)
      V(278)=-2.D0*V(277)
      V(279)=r1x2E*VRR0(103,8)
      V(280)=2.D0*V(279)
      V(281)=HfxZpE*VRR1(73,15)
      V(282)=r1x2E*ZxZpE*VRR1(103,8)
      V(283)=-2.D0*V(282)
      V(284)=r1x2E*VRR0(103,9)
      V(285)=2.D0*V(284)
      V(286)=r1x2E*ZxZpE*VRR1(103,9)
      V(287)=-2.D0*V(286)
      V(288)=HfxZpE*VRR1(74,11)
      V(289)=r1x2Z*VRR0(49,22)
      V(290)=3.D0*V(289)
      V(291)=ExZpE*r1x2Z*VRR1(49,22)
      V(292)=-3.D0*V(291)
      V(293)=3.D0*V(245)
      V(294)=-3.D0*V(246)
      V(295)=r1x2Z*VRR0(49,24)
      V(296)=3.D0*V(295)
      V(297)=ExZpE*r1x2Z*VRR1(49,24)
      V(298)=-3.D0*V(297)
      V(299)=r1x2Z*VRR0(49,26)
      V(300)=3.D0*V(299)
      V(301)=ExZpE*r1x2Z*VRR1(49,26)
      V(302)=-3.D0*V(301)
      V(303)=3.D0*V(253)
      V(304)=-3.D0*V(254)
      V(305)=3.D0*V(257)
      V(306)=-3.D0*V(258)
      V(307)=r1x2Z*VRR0(49,29)
      V(308)=3.D0*V(307)
      V(309)=ExZpE*r1x2Z*VRR1(49,29)
      V(310)=-3.D0*V(309)
      V(311)=3.D0*V(264)
      V(312)=-3.D0*V(265)
      V(313)=3.D0*V(267)
      V(314)=-3.D0*V(268)
      V(315)=HfxZpE*VRR1(73,18)
      V(316)=3.D0*V(270)
      V(317)=-3.D0*V(271)
      V(318)=HfxZpE*VRR1(73,19)
      V(319)=r1x2Z*VRR0(49,33)
      V(320)=3.D0*V(319)
      V(321)=ExZpE*r1x2Z*VRR1(49,33)
      V(322)=-3.D0*V(321)
      V(323)=r1x2Z*VRR0(49,34)
      V(324)=3.D0*V(323)
      V(325)=ExZpE*r1x2Z*VRR1(49,34)
      V(326)=-3.D0*V(325)
      V(327)=HfxZpE*VRR1(73,20)
      V(328)=r1x2Z*VRR0(50,22)
      V(329)=ExZpE*r1x2Z*VRR1(50,22)
      V(330)=r1x2Z*VRR0(50,23)
      V(331)=ExZpE*r1x2Z*VRR1(50,23)
      V(332)=r1x2Z*VRR0(50,24)
      V(333)=ExZpE*r1x2Z*VRR1(50,24)
      V(334)=r1x2Z*VRR0(50,26)
      V(335)=ExZpE*r1x2Z*VRR1(50,26)
      V(336)=r1x2Z*VRR0(50,27)
      V(337)=ExZpE*r1x2Z*VRR1(50,27)
      V(338)=r1x2Z*VRR0(50,28)
      V(339)=ExZpE*r1x2Z*VRR1(50,28)
      V(340)=r1x2Z*VRR0(50,29)
      V(341)=ExZpE*r1x2Z*VRR1(50,29)
      V(342)=r1x2Z*VRR0(50,30)
      V(343)=ExZpE*r1x2Z*VRR1(50,30)
      V(344)=r1x2Z*VRR0(50,31)
      V(345)=ExZpE*r1x2Z*VRR1(50,31)
      V(346)=r1x2Z*VRR0(50,32)
      V(347)=ExZpE*r1x2Z*VRR1(50,32)
      V(348)=r1x2Z*VRR0(50,33)
      V(349)=ExZpE*r1x2Z*VRR1(50,33)
      V(350)=r1x2Z*VRR0(50,34)
      V(351)=ExZpE*r1x2Z*VRR1(50,34)
      V(352)=HfxZpE*VRR1(74,20)
      V(353)=HfxZpE*VRR1(75,11)
      V(354)=r1x2Z*VRR0(51,22)
      V(355)=ExZpE*r1x2Z*VRR1(51,22)
      V(356)=HfxZpE*VRR1(75,12)
      V(357)=r1x2Z*VRR0(51,23)
      V(358)=ExZpE*r1x2Z*VRR1(51,23)
      V(359)=HfxZpE*VRR1(75,13)
      V(360)=r1x2Z*VRR0(51,24)
      V(361)=ExZpE*r1x2Z*VRR1(51,24)
      V(362)=HfxZpE*VRR1(75,14)
      V(363)=r1x2Z*VRR0(51,26)
      V(364)=ExZpE*r1x2Z*VRR1(51,26)
      V(365)=HfxZpE*VRR1(75,15)
      V(366)=r1x2Z*VRR0(51,27)
      V(367)=ExZpE*r1x2Z*VRR1(51,27)
      V(368)=HfxZpE*VRR1(75,16)
      V(369)=2.D0*V(368)
      V(370)=r1x2Z*VRR0(51,28)
      V(371)=ExZpE*r1x2Z*VRR1(51,28)
      V(372)=HfxZpE*VRR1(75,17)
      V(373)=r1x2Z*VRR0(51,29)
      V(374)=ExZpE*r1x2Z*VRR1(51,29)
      V(375)=r1x2Z*VRR0(51,30)
      V(376)=ExZpE*r1x2Z*VRR1(51,30)
      V(377)=HfxZpE*VRR1(75,18)
      V(378)=r1x2Z*VRR0(51,31)
      V(379)=ExZpE*r1x2Z*VRR1(51,31)
      V(380)=HfxZpE*VRR1(75,19)
      V(381)=r1x2Z*VRR0(51,32)
      V(382)=ExZpE*r1x2Z*VRR1(51,32)
      V(383)=r1x2Z*VRR0(51,33)
      V(384)=ExZpE*r1x2Z*VRR1(51,33)
      V(385)=HfxZpE*VRR1(75,20)
      V(386)=r1x2Z*VRR0(51,34)
      V(387)=ExZpE*r1x2Z*VRR1(51,34)
      V(388)=HfxZpE*VRR1(76,11)
      V(389)=r1x2E*VRR0(107,6)
      V(390)=2.D0*V(389)
      V(391)=HfxZpE*VRR1(76,12)
      V(392)=r1x2E*ZxZpE*VRR1(107,6)
      V(393)=-2.D0*V(392)
      V(394)=r1x2Z*VRR0(52,23)
      V(395)=2.D0*V(394)
      V(396)=ExZpE*r1x2Z*VRR1(52,23)
      V(397)=-2.D0*V(396)
      V(398)=HfxZpE*VRR1(76,13)
      V(399)=2.D0*V(398)
      V(400)=r1x2E*VRR0(107,8)
      V(401)=2.D0*V(400)
      V(402)=HfxZpE*VRR1(76,15)
      V(403)=r1x2E*ZxZpE*VRR1(107,8)
      V(404)=-2.D0*V(403)
      V(405)=r1x2Z*VRR0(52,27)
      V(406)=2.D0*V(405)
      V(407)=ExZpE*r1x2Z*VRR1(52,27)
      V(408)=-2.D0*V(407)
      V(409)=HfxZpE*VRR1(76,16)
      V(410)=2.D0*V(409)
      V(411)=r1x2Z*VRR0(52,28)
      V(412)=2.D0*V(411)
      V(413)=ExZpE*r1x2Z*VRR1(52,28)
      V(414)=-2.D0*V(413)
      V(415)=HfxZpE*VRR1(76,17)
      V(416)=r1x2E*VRR0(107,9)
      V(417)=2.D0*V(416)
      V(418)=r1x2E*ZxZpE*VRR1(107,9)
      V(419)=-2.D0*V(418)
      V(420)=r1x2Z*VRR0(52,30)
      V(421)=2.D0*V(420)
      V(422)=ExZpE*r1x2Z*VRR1(52,30)
      V(423)=-2.D0*V(422)
      V(424)=HfxZpE*VRR1(76,18)
      V(425)=r1x2Z*VRR0(52,31)
      V(426)=2.D0*V(425)
      V(427)=ExZpE*r1x2Z*VRR1(52,31)
      V(428)=-2.D0*V(427)
      V(429)=HfxZpE*VRR1(76,19)
      V(430)=r1x2Z*VRR0(52,32)
      V(431)=2.D0*V(430)
      V(432)=ExZpE*r1x2Z*VRR1(52,32)
      V(433)=-2.D0*V(432)
      V(434)=HfxZpE*VRR1(77,11)
      V(435)=r1x2E*VRR0(108,6)
      V(436)=2.D0*V(435)
      V(437)=HfxZpE*VRR1(77,12)
      V(438)=2.D0*V(437)
      V(439)=r1x2E*ZxZpE*VRR1(108,6)
      V(440)=-2.D0*V(439)
      V(441)=HfxZpE*VRR1(76,14)
      V(442)=r1x2E*VRR0(108,8)
      V(443)=2.D0*V(442)
      V(444)=HfxZpE*VRR1(77,15)
      V(445)=2.D0*V(444)
      V(446)=r1x2E*ZxZpE*VRR1(108,8)
      V(447)=-2.D0*V(446)
      V(448)=r1x2E*VRR0(108,9)
      V(449)=2.D0*V(448)
      V(450)=2.D0*V(415)
      V(451)=r1x2E*ZxZpE*VRR1(108,9)
      V(452)=-2.D0*V(451)
      V(453)=HfxZpE*VRR1(78,11)
      V(454)=r1x2E*VRR0(109,6)
      V(455)=2.D0*V(454)
      V(456)=HfxZpE*VRR1(78,12)
      V(457)=r1x2E*ZxZpE*VRR1(109,6)
      V(458)=-2.D0*V(457)
      V(459)=HfxZpE*VRR1(77,13)
      V(460)=HfxZpE*VRR1(77,14)
      V(461)=r1x2E*VRR0(109,8)
      V(462)=2.D0*V(461)
      V(463)=HfxZpE*VRR1(78,15)
      V(464)=r1x2E*ZxZpE*VRR1(109,8)
      V(465)=-2.D0*V(464)
      V(466)=HfxZpE*VRR1(77,16)
      V(467)=2.D0*V(466)
      V(468)=r1x2E*VRR0(109,9)
      V(469)=2.D0*V(468)
      V(470)=HfxZpE*VRR1(77,17)
      V(471)=r1x2E*ZxZpE*VRR1(109,9)
      V(472)=-2.D0*V(471)
      V(473)=HfxZpE*VRR1(77,18)
      V(474)=HfxZpE*VRR1(77,19)
      V(475)=r1x2Z*VRR0(53,22)
      V(476)=ExZpE*r1x2Z*VRR1(53,22)
      V(477)=r1x2Z*VRR0(53,23)
      V(478)=ExZpE*r1x2Z*VRR1(53,23)
      V(479)=r1x2Z*VRR0(53,24)
      V(480)=ExZpE*r1x2Z*VRR1(53,24)
      V(481)=HfxZpE*VRR1(78,13)
      V(482)=HfxZpE*VRR1(78,14)
      V(483)=r1x2Z*VRR0(53,26)
      V(484)=ExZpE*r1x2Z*VRR1(53,26)
      V(485)=r1x2Z*VRR0(53,27)
      V(486)=ExZpE*r1x2Z*VRR1(53,27)
      V(487)=r1x2Z*VRR0(53,28)
      V(488)=ExZpE*r1x2Z*VRR1(53,28)
      V(489)=HfxZpE*VRR1(78,16)
      V(490)=2.D0*V(489)
      V(491)=r1x2Z*VRR0(53,29)
      V(492)=ExZpE*r1x2Z*VRR1(53,29)
      V(493)=HfxZpE*VRR1(78,17)
      V(494)=r1x2Z*VRR0(53,30)
      V(495)=ExZpE*r1x2Z*VRR1(53,30)
      V(496)=r1x2Z*VRR0(53,31)
      V(497)=ExZpE*r1x2Z*VRR1(53,31)
      V(498)=HfxZpE*VRR1(78,18)
      V(499)=r1x2Z*VRR0(53,32)
      V(500)=ExZpE*r1x2Z*VRR1(53,32)
      V(501)=HfxZpE*VRR1(78,19)
      V(502)=r1x2Z*VRR0(53,33)
      V(503)=ExZpE*r1x2Z*VRR1(53,33)
      V(504)=r1x2Z*VRR0(53,34)
      V(505)=ExZpE*r1x2Z*VRR1(53,34)
      V(506)=HfxZpE*VRR1(78,20)
      V(507)=HfxZpE*VRR1(79,11)
      V(508)=HfxZpE*VRR1(80,11)
      V(509)=HfxZpE*VRR1(79,14)
      V(510)=HfxZpE*VRR1(81,11)
      V(511)=HfxZpE*VRR1(80,14)
      V(512)=HfxZpE*VRR1(81,14)
      VRR0(85,21)=6.D0*r1x2Z*VRR0(36,21)+PAx*VRR0(57,21)-6.D0*ExZpE*r1x2Z*VRR1(36,21)+4.D0*HfxZpE*VRR1(57,11)+WPx*VRR1(57,21)
      VRR0(85,22)=6.D0*r1x2Z*VRR0(36,22)+PAx*VRR0(57,22)-6.D0*ExZpE*r1x2Z*VRR1(36,22)+3.D0*HfxZpE*VRR1(57,12)+WPx*VRR1(57,22)
      VRR0(85,23)=6.D0*r1x2Z*VRR0(36,23)+PAx*VRR0(57,23)-6.D0*ExZpE*r1x2Z*VRR1(36,23)+2.D0*HfxZpE*VRR1(57,13)+WPx*VRR1(57,23)
      VRR0(85,24)=6.D0*r1x2Z*VRR0(36,24)+PAx*VRR0(57,24)-6.D0*ExZpE*r1x2Z*VRR1(36,24)+HfxZpE*VRR1(57,14)+WPx*VRR1(57,24)
      VRR0(85,25)=6.D0*r1x2Z*VRR0(36,25)+PAx*VRR0(57,25)-6.D0*ExZpE*r1x2Z*VRR1(36,25)+WPx*VRR1(57,25)
      VRR0(85,26)=6.D0*r1x2Z*VRR0(36,26)+PAx*VRR0(57,26)-6.D0*ExZpE*r1x2Z*VRR1(36,26)+3.D0*HfxZpE*VRR1(57,15)+WPx*VRR1(57,26)
      VRR0(85,27)=6.D0*r1x2Z*VRR0(36,27)+PAx*VRR0(57,27)-6.D0*ExZpE*r1x2Z*VRR1(36,27)+2.D0*HfxZpE*VRR1(57,16)+WPx*VRR1(57,27)
      VRR0(85,28)=6.D0*r1x2Z*VRR0(36,28)+PAx*VRR0(57,28)-6.D0*ExZpE*r1x2Z*VRR1(36,28)+HfxZpE*VRR1(57,17)+WPx*VRR1(57,28)
      VRR0(85,29)=6.D0*r1x2Z*VRR0(36,29)+PAx*VRR0(57,29)-6.D0*ExZpE*r1x2Z*VRR1(36,29)+WPx*VRR1(57,29)
      VRR0(85,30)=6.D0*r1x2Z*VRR0(36,30)+PAx*VRR0(57,30)-6.D0*ExZpE*r1x2Z*VRR1(36,30)+2.D0*HfxZpE*VRR1(57,18)+WPx*VRR1(57,30)
      VRR0(85,31)=6.D0*r1x2Z*VRR0(36,31)+PAx*VRR0(57,31)-6.D0*ExZpE*r1x2Z*VRR1(36,31)+HfxZpE*VRR1(57,19)+WPx*VRR1(57,31)
      VRR0(85,32)=6.D0*r1x2Z*VRR0(36,32)+PAx*VRR0(57,32)-6.D0*ExZpE*r1x2Z*VRR1(36,32)+WPx*VRR1(57,32)
      VRR0(85,33)=6.D0*r1x2Z*VRR0(36,33)+PAx*VRR0(57,33)-6.D0*ExZpE*r1x2Z*VRR1(36,33)+HfxZpE*VRR1(57,20)+WPx*VRR1(57,33)
      VRR0(85,34)=6.D0*r1x2Z*VRR0(36,34)+PAx*VRR0(57,34)-6.D0*ExZpE*r1x2Z*VRR1(36,34)+WPx*VRR1(57,34)
      VRR0(85,35)=6.D0*r1x2Z*VRR0(36,35)+PAx*VRR0(57,35)-6.D0*ExZpE*r1x2Z*VRR1(36,35)+WPx*VRR1(57,35)
      VRR0(86,21)=5.D0*r1x2Z*VRR0(37,21)+PAx*VRR0(58,21)-5.D0*ExZpE*r1x2Z*VRR1(37,21)+4.D0*HfxZpE*VRR1(58,11)+WPx*VRR1(58,21)
      VRR0(86,22)=5.D0*r1x2Z*VRR0(37,22)+PAx*VRR0(58,22)-5.D0*ExZpE*r1x2Z*VRR1(37,22)+3.D0*HfxZpE*VRR1(58,12)+WPx*VRR1(58,22)
      VRR0(86,23)=5.D0*r1x2Z*VRR0(37,23)+PAx*VRR0(58,23)-5.D0*ExZpE*r1x2Z*VRR1(37,23)+2.D0*HfxZpE*VRR1(58,13)+WPx*VRR1(58,23)
      VRR0(86,24)=5.D0*r1x2Z*VRR0(37,24)+PAx*VRR0(58,24)-5.D0*ExZpE*r1x2Z*VRR1(37,24)+HfxZpE*VRR1(58,14)+WPx*VRR1(58,24)
      VRR0(86,25)=5.D0*r1x2Z*VRR0(37,25)+PAx*VRR0(58,25)-5.D0*ExZpE*r1x2Z*VRR1(37,25)+WPx*VRR1(58,25)
      VRR0(86,26)=5.D0*r1x2Z*VRR0(37,26)+PAx*VRR0(58,26)-5.D0*ExZpE*r1x2Z*VRR1(37,26)+3.D0*HfxZpE*VRR1(58,15)+WPx*VRR1(58,26)
      VRR0(86,27)=5.D0*r1x2Z*VRR0(37,27)+PAx*VRR0(58,27)-5.D0*ExZpE*r1x2Z*VRR1(37,27)+2.D0*HfxZpE*VRR1(58,16)+WPx*VRR1(58,27)
      VRR0(86,28)=5.D0*r1x2Z*VRR0(37,28)+PAx*VRR0(58,28)-5.D0*ExZpE*r1x2Z*VRR1(37,28)+HfxZpE*VRR1(58,17)+WPx*VRR1(58,28)
      VRR0(86,29)=5.D0*r1x2Z*VRR0(37,29)+PAx*VRR0(58,29)-5.D0*ExZpE*r1x2Z*VRR1(37,29)+WPx*VRR1(58,29)
      VRR0(86,30)=5.D0*r1x2Z*VRR0(37,30)+PAx*VRR0(58,30)-5.D0*ExZpE*r1x2Z*VRR1(37,30)+2.D0*HfxZpE*VRR1(58,18)+WPx*VRR1(58,30)
      VRR0(86,31)=5.D0*r1x2Z*VRR0(37,31)+PAx*VRR0(58,31)-5.D0*ExZpE*r1x2Z*VRR1(37,31)+HfxZpE*VRR1(58,19)+WPx*VRR1(58,31)
      VRR0(86,32)=5.D0*r1x2Z*VRR0(37,32)+PAx*VRR0(58,32)-5.D0*ExZpE*r1x2Z*VRR1(37,32)+WPx*VRR1(58,32)
      VRR0(86,33)=5.D0*r1x2Z*VRR0(37,33)+PAx*VRR0(58,33)-5.D0*ExZpE*r1x2Z*VRR1(37,33)+HfxZpE*VRR1(58,20)+WPx*VRR1(58,33)
      VRR0(86,34)=5.D0*r1x2Z*VRR0(37,34)+PAx*VRR0(58,34)-5.D0*ExZpE*r1x2Z*VRR1(37,34)+WPx*VRR1(58,34)
      VRR0(86,35)=5.D0*r1x2Z*VRR0(37,35)+PAx*VRR0(58,35)-5.D0*ExZpE*r1x2Z*VRR1(37,35)+WPx*VRR1(58,35)
      VRR0(87,21)=4.D0*r1x2Z*VRR0(38,21)+PAx*VRR0(59,21)-4.D0*ExZpE*r1x2Z*VRR1(38,21)+4.D0*HfxZpE*VRR1(59,11)+WPx*VRR1(59,21)
      VRR0(87,22)=4.D0*V(1)-4.D0*V(2)+PAx*VRR0(59,22)+3.D0*HfxZpE*VRR1(59,12)+WPx*VRR1(59,22)
      VRR0(87,23)=4.D0*V(3)-4.D0*V(4)+PAx*VRR0(59,23)+2.D0*HfxZpE*VRR1(59,13)+WPx*VRR1(59,23)
      VRR0(87,24)=4.D0*V(5)-4.D0*V(6)+V(7)+PAx*VRR0(59,24)+WPx*VRR1(59,24)
      VRR0(87,25)=4.D0*r1x2Z*VRR0(38,25)+PAx*VRR0(59,25)-4.D0*ExZpE*r1x2Z*VRR1(38,25)+WPx*VRR1(59,25)
      VRR0(87,26)=4.D0*V(8)-4.D0*V(9)+PAx*VRR0(59,26)+3.D0*HfxZpE*VRR1(59,15)+WPx*VRR1(59,26)
      VRR0(87,27)=4.D0*V(10)-4.D0*V(11)+PAx*VRR0(59,27)+2.D0*HfxZpE*VRR1(59,16)+WPx*VRR1(59,27)
      VRR0(87,28)=4.D0*V(12)-4.D0*V(13)+PAx*VRR0(59,28)+HfxZpE*VRR1(59,17)+WPx*VRR1(59,28)
      VRR0(87,29)=4.D0*V(14)-4.D0*V(15)+PAx*VRR0(59,29)+WPx*VRR1(59,29)
      VRR0(87,30)=4.D0*V(16)-4.D0*V(17)+PAx*VRR0(59,30)+2.D0*HfxZpE*VRR1(59,18)+WPx*VRR1(59,30)
      VRR0(87,31)=4.D0*V(18)-4.D0*V(19)+PAx*VRR0(59,31)+HfxZpE*VRR1(59,19)+WPx*VRR1(59,31)
      VRR0(87,32)=4.D0*V(20)-4.D0*V(21)+PAx*VRR0(59,32)+WPx*VRR1(59,32)
      VRR0(87,33)=4.D0*V(22)-4.D0*V(23)+V(24)+PAx*VRR0(59,33)+WPx*VRR1(59,33)
      VRR0(87,34)=4.D0*V(25)-4.D0*V(26)+PAx*VRR0(59,34)+WPx*VRR1(59,34)
      VRR0(87,35)=4.D0*r1x2Z*VRR0(38,35)+PAx*VRR0(59,35)-4.D0*ExZpE*r1x2Z*VRR1(38,35)+WPx*VRR1(59,35)
      VRR0(88,21)=4.D0*V(27)+3.D0*r1x2E*VRR0(88,5)+QCx*VRR0(88,11)-3.D0*r1x2E*ZxZpE*VRR1(88,5)+WQx*VRR1(88,11)
      VRR0(88,22)=3.D0*V(28)-3.D0*V(29)+3.D0*V(30)+PAx*VRR0(60,22)+WPx*VRR1(60,22)
      VRR0(88,23)=3.D0*V(31)-3.D0*V(32)+2.D0*V(33)+PAx*VRR0(60,23)+WPx*VRR1(60,23)
      VRR0(88,24)=3.D0*V(34)-3.D0*V(35)+V(36)+PAx*VRR0(60,24)+WPx*VRR1(60,24)
      VRR0(88,25)=3.D0*V(7)+3.D0*r1x2E*VRR0(88,7)+QCy*VRR0(88,14)-3.D0*r1x2E*ZxZpE*VRR1(88,7)+WQy*VRR1(88,14)
      VRR0(88,26)=3.D0*V(37)-3.D0*V(38)+3.D0*V(39)+PAx*VRR0(60,26)+WPx*VRR1(60,26)
      VRR0(88,27)=3.D0*V(40)-3.D0*V(41)+V(43)+PAx*VRR0(60,27)+WPx*VRR1(60,27)
      VRR0(88,28)=3.D0*V(44)-3.D0*V(45)+V(46)+PAx*VRR0(60,28)+WPx*VRR1(60,28)
      VRR0(88,29)=3.D0*V(47)-3.D0*V(48)+PAx*VRR0(60,29)+WPx*VRR1(60,29)
      VRR0(88,30)=3.D0*V(49)-3.D0*V(50)+2.D0*V(51)+PAx*VRR0(60,30)+WPx*VRR1(60,30)
      VRR0(88,31)=3.D0*V(52)-3.D0*V(53)+V(54)+PAx*VRR0(60,31)+WPx*VRR1(60,31)
      VRR0(88,32)=3.D0*V(55)-3.D0*V(56)+PAx*VRR0(60,32)+WPx*VRR1(60,32)
      VRR0(88,33)=3.D0*V(57)-3.D0*V(58)+V(59)+PAx*VRR0(60,33)+WPx*VRR1(60,33)
      VRR0(88,34)=3.D0*V(60)-3.D0*V(61)+PAx*VRR0(60,34)+WPx*VRR1(60,34)
      VRR0(88,35)=3.D0*r1x2E*VRR0(88,10)+QCz*VRR0(88,20)-3.D0*r1x2E*ZxZpE*VRR1(88,10)+WQz*VRR1(88,20)
      VRR0(89,21)=3.D0*V(62)+3.D0*r1x2E*VRR0(89,5)+QCx*VRR0(89,11)-3.D0*r1x2E*ZxZpE*VRR1(89,5)+WQx*VRR1(89,11)
      VRR0(89,22)=3.D0*V(1)-3.D0*V(2)+V(27)+PAy*VRR0(60,22)+WPy*VRR1(60,22)
      VRR0(89,23)=3.D0*V(3)-3.D0*V(4)+2.D0*V(30)+PAy*VRR0(60,23)+WPy*VRR1(60,23)
      VRR0(89,24)=3.D0*V(5)-3.D0*V(6)+3.D0*V(33)+PAy*VRR0(60,24)+WPy*VRR1(60,24)
      VRR0(89,25)=4.D0*V(36)+3.D0*r1x2E*VRR0(89,7)+QCy*VRR0(89,14)-3.D0*r1x2E*ZxZpE*VRR1(89,7)+WQy*VRR1(89,14)
      VRR0(89,26)=3.D0*V(8)-3.D0*V(9)+PAy*VRR0(60,26)+WPy*VRR1(60,26)
      VRR0(89,27)=3.D0*V(10)-3.D0*V(11)+V(39)+PAy*VRR0(60,27)+WPy*VRR1(60,27)
      VRR0(89,28)=3.D0*V(12)-3.D0*V(13)+V(43)+PAy*VRR0(60,28)+WPy*VRR1(60,28)
      VRR0(89,29)=3.D0*V(14)-3.D0*V(15)+3.D0*V(46)+PAy*VRR0(60,29)+WPy*VRR1(60,29)
      VRR0(89,30)=3.D0*V(16)-3.D0*V(17)+PAy*VRR0(60,30)+WPy*VRR1(60,30)
      VRR0(89,31)=3.D0*V(18)-3.D0*V(19)+V(51)+PAy*VRR0(60,31)+WPy*VRR1(60,31)
      VRR0(89,32)=3.D0*V(20)-3.D0*V(21)+2.D0*V(54)+PAy*VRR0(60,32)+WPy*VRR1(60,32)
      VRR0(89,33)=3.D0*V(22)-3.D0*V(23)+PAy*VRR0(60,33)+WPy*VRR1(60,33)
      VRR0(89,34)=3.D0*V(25)-3.D0*V(26)+V(59)+PAy*VRR0(60,34)+WPy*VRR1(60,34)
      VRR0(89,35)=3.D0*r1x2E*VRR0(89,10)+QCz*VRR0(89,20)-3.D0*r1x2E*ZxZpE*VRR1(89,10)+WQz*VRR1(89,20)
      VRR0(90,21)=4.D0*r1x2Z*VRR0(39,21)+PAy*VRR0(61,21)-4.D0*ExZpE*r1x2Z*VRR1(39,21)+WPy*VRR1(61,21)
      VRR0(90,22)=4.D0*V(28)-4.D0*V(29)+V(62)+PAy*VRR0(61,22)+WPy*VRR1(61,22)
      VRR0(90,23)=4.D0*V(31)-4.D0*V(32)+PAy*VRR0(61,23)+2.D0*HfxZpE*VRR1(61,12)+WPy*VRR1(61,23)
      VRR0(90,24)=4.D0*V(34)-4.D0*V(35)+PAy*VRR0(61,24)+3.D0*HfxZpE*VRR1(61,13)+WPy*VRR1(61,24)
      VRR0(90,25)=4.D0*r1x2Z*VRR0(39,25)+PAy*VRR0(61,25)-4.D0*ExZpE*r1x2Z*VRR1(39,25)+4.D0*HfxZpE*VRR1(61,14)+WPy*VRR1(61,25)
      VRR0(90,26)=4.D0*V(37)-4.D0*V(38)+PAy*VRR0(61,26)+WPy*VRR1(61,26)
      VRR0(90,27)=4.D0*V(40)-4.D0*V(41)+PAy*VRR0(61,27)+HfxZpE*VRR1(61,15)+WPy*VRR1(61,27)
      VRR0(90,28)=4.D0*V(44)-4.D0*V(45)+PAy*VRR0(61,28)+2.D0*HfxZpE*VRR1(61,16)+WPy*VRR1(61,28)
      VRR0(90,29)=4.D0*V(47)-4.D0*V(48)+PAy*VRR0(61,29)+3.D0*HfxZpE*VRR1(61,17)+WPy*VRR1(61,29)
      VRR0(90,30)=4.D0*V(49)-4.D0*V(50)+PAy*VRR0(61,30)+WPy*VRR1(61,30)
      VRR0(90,31)=4.D0*V(52)-4.D0*V(53)+PAy*VRR0(61,31)+HfxZpE*VRR1(61,18)+WPy*VRR1(61,31)
      VRR0(90,32)=4.D0*V(55)-4.D0*V(56)+PAy*VRR0(61,32)+2.D0*HfxZpE*VRR1(61,19)+WPy*VRR1(61,32)
      VRR0(90,33)=4.D0*V(57)-4.D0*V(58)+PAy*VRR0(61,33)+WPy*VRR1(61,33)
      VRR0(90,34)=4.D0*V(60)-4.D0*V(61)+V(63)+PAy*VRR0(61,34)+WPy*VRR1(61,34)
      VRR0(90,35)=4.D0*r1x2Z*VRR0(39,35)+PAy*VRR0(61,35)-4.D0*ExZpE*r1x2Z*VRR1(39,35)+WPy*VRR1(61,35)
      VRR0(91,21)=5.D0*r1x2Z*VRR0(40,21)+PAy*VRR0(62,21)-5.D0*ExZpE*r1x2Z*VRR1(40,21)+WPy*VRR1(62,21)
      VRR0(91,22)=5.D0*r1x2Z*VRR0(40,22)+PAy*VRR0(62,22)-5.D0*ExZpE*r1x2Z*VRR1(40,22)+HfxZpE*VRR1(62,11)+WPy*VRR1(62,22)
      VRR0(91,23)=5.D0*r1x2Z*VRR0(40,23)+PAy*VRR0(62,23)-5.D0*ExZpE*r1x2Z*VRR1(40,23)+2.D0*HfxZpE*VRR1(62,12)+WPy*VRR1(62,23)
      VRR0(91,24)=5.D0*r1x2Z*VRR0(40,24)+PAy*VRR0(62,24)-5.D0*ExZpE*r1x2Z*VRR1(40,24)+3.D0*HfxZpE*VRR1(62,13)+WPy*VRR1(62,24)
      VRR0(91,25)=5.D0*r1x2Z*VRR0(40,25)+PAy*VRR0(62,25)-5.D0*ExZpE*r1x2Z*VRR1(40,25)+4.D0*HfxZpE*VRR1(62,14)+WPy*VRR1(62,25)
      VRR0(91,26)=5.D0*r1x2Z*VRR0(40,26)+PAy*VRR0(62,26)-5.D0*ExZpE*r1x2Z*VRR1(40,26)+WPy*VRR1(62,26)
      VRR0(91,27)=5.D0*r1x2Z*VRR0(40,27)+PAy*VRR0(62,27)-5.D0*ExZpE*r1x2Z*VRR1(40,27)+HfxZpE*VRR1(62,15)+WPy*VRR1(62,27)
      VRR0(91,28)=5.D0*r1x2Z*VRR0(40,28)+PAy*VRR0(62,28)-5.D0*ExZpE*r1x2Z*VRR1(40,28)+2.D0*HfxZpE*VRR1(62,16)+WPy*VRR1(62,28)
      VRR0(91,29)=5.D0*r1x2Z*VRR0(40,29)+PAy*VRR0(62,29)-5.D0*ExZpE*r1x2Z*VRR1(40,29)+3.D0*HfxZpE*VRR1(62,17)+WPy*VRR1(62,29)
      VRR0(91,30)=5.D0*r1x2Z*VRR0(40,30)+PAy*VRR0(62,30)-5.D0*ExZpE*r1x2Z*VRR1(40,30)+WPy*VRR1(62,30)
      VRR0(91,31)=5.D0*r1x2Z*VRR0(40,31)+PAy*VRR0(62,31)-5.D0*ExZpE*r1x2Z*VRR1(40,31)+HfxZpE*VRR1(62,18)+WPy*VRR1(62,31)
      VRR0(91,32)=5.D0*r1x2Z*VRR0(40,32)+PAy*VRR0(62,32)-5.D0*ExZpE*r1x2Z*VRR1(40,32)+2.D0*HfxZpE*VRR1(62,19)+WPy*VRR1(62,32)
      VRR0(91,33)=5.D0*r1x2Z*VRR0(40,33)+PAy*VRR0(62,33)-5.D0*ExZpE*r1x2Z*VRR1(40,33)+WPy*VRR1(62,33)
      VRR0(91,34)=5.D0*r1x2Z*VRR0(40,34)+PAy*VRR0(62,34)-5.D0*ExZpE*r1x2Z*VRR1(40,34)+HfxZpE*VRR1(62,20)+WPy*VRR1(62,34)
      VRR0(91,35)=5.D0*r1x2Z*VRR0(40,35)+PAy*VRR0(62,35)-5.D0*ExZpE*r1x2Z*VRR1(40,35)+WPy*VRR1(62,35)
      VRR0(92,21)=6.D0*r1x2Z*VRR0(41,21)+PAy*VRR0(63,21)-6.D0*ExZpE*r1x2Z*VRR1(41,21)+WPy*VRR1(63,21)
      VRR0(92,22)=6.D0*r1x2Z*VRR0(41,22)+PAy*VRR0(63,22)-6.D0*ExZpE*r1x2Z*VRR1(41,22)+HfxZpE*VRR1(63,11)+WPy*VRR1(63,22)
      VRR0(92,23)=6.D0*r1x2Z*VRR0(41,23)+PAy*VRR0(63,23)-6.D0*ExZpE*r1x2Z*VRR1(41,23)+2.D0*HfxZpE*VRR1(63,12)+WPy*VRR1(63,23)
      VRR0(92,24)=6.D0*r1x2Z*VRR0(41,24)+PAy*VRR0(63,24)-6.D0*ExZpE*r1x2Z*VRR1(41,24)+3.D0*HfxZpE*VRR1(63,13)+WPy*VRR1(63,24)
      VRR0(92,25)=6.D0*r1x2Z*VRR0(41,25)+PAy*VRR0(63,25)-6.D0*ExZpE*r1x2Z*VRR1(41,25)+4.D0*HfxZpE*VRR1(63,14)+WPy*VRR1(63,25)
      VRR0(92,26)=6.D0*r1x2Z*VRR0(41,26)+PAy*VRR0(63,26)-6.D0*ExZpE*r1x2Z*VRR1(41,26)+WPy*VRR1(63,26)
      VRR0(92,27)=6.D0*r1x2Z*VRR0(41,27)+PAy*VRR0(63,27)-6.D0*ExZpE*r1x2Z*VRR1(41,27)+HfxZpE*VRR1(63,15)+WPy*VRR1(63,27)
      VRR0(92,28)=6.D0*r1x2Z*VRR0(41,28)+PAy*VRR0(63,28)-6.D0*ExZpE*r1x2Z*VRR1(41,28)+2.D0*HfxZpE*VRR1(63,16)+WPy*VRR1(63,28)
      VRR0(92,29)=6.D0*r1x2Z*VRR0(41,29)+PAy*VRR0(63,29)-6.D0*ExZpE*r1x2Z*VRR1(41,29)+3.D0*HfxZpE*VRR1(63,17)+WPy*VRR1(63,29)
      VRR0(92,30)=6.D0*r1x2Z*VRR0(41,30)+PAy*VRR0(63,30)-6.D0*ExZpE*r1x2Z*VRR1(41,30)+WPy*VRR1(63,30)
      VRR0(92,31)=6.D0*r1x2Z*VRR0(41,31)+PAy*VRR0(63,31)-6.D0*ExZpE*r1x2Z*VRR1(41,31)+HfxZpE*VRR1(63,18)+WPy*VRR1(63,31)
      VRR0(92,32)=6.D0*r1x2Z*VRR0(41,32)+PAy*VRR0(63,32)-6.D0*ExZpE*r1x2Z*VRR1(41,32)+2.D0*HfxZpE*VRR1(63,19)+WPy*VRR1(63,32)
      VRR0(92,33)=6.D0*r1x2Z*VRR0(41,33)+PAy*VRR0(63,33)-6.D0*ExZpE*r1x2Z*VRR1(41,33)+WPy*VRR1(63,33)
      VRR0(92,34)=6.D0*r1x2Z*VRR0(41,34)+PAy*VRR0(63,34)-6.D0*ExZpE*r1x2Z*VRR1(41,34)+HfxZpE*VRR1(63,20)+WPy*VRR1(63,34)
      VRR0(92,35)=6.D0*r1x2Z*VRR0(41,35)+PAy*VRR0(63,35)-6.D0*ExZpE*r1x2Z*VRR1(41,35)+WPy*VRR1(63,35)
      VRR0(93,21)=5.D0*r1x2Z*VRR0(42,21)+PAx*VRR0(64,21)-5.D0*ExZpE*r1x2Z*VRR1(42,21)+4.D0*HfxZpE*VRR1(64,11)+WPx*VRR1(64,21)
      VRR0(93,22)=5.D0*r1x2Z*VRR0(42,22)+PAx*VRR0(64,22)-5.D0*ExZpE*r1x2Z*VRR1(42,22)+3.D0*HfxZpE*VRR1(64,12)+WPx*VRR1(64,22)
      VRR0(93,23)=5.D0*r1x2Z*VRR0(42,23)+PAx*VRR0(64,23)-5.D0*ExZpE*r1x2Z*VRR1(42,23)+2.D0*HfxZpE*VRR1(64,13)+WPx*VRR1(64,23)
      VRR0(93,24)=5.D0*r1x2Z*VRR0(42,24)+PAx*VRR0(64,24)-5.D0*ExZpE*r1x2Z*VRR1(42,24)+HfxZpE*VRR1(64,14)+WPx*VRR1(64,24)
      VRR0(93,25)=5.D0*r1x2Z*VRR0(42,25)+PAx*VRR0(64,25)-5.D0*ExZpE*r1x2Z*VRR1(42,25)+WPx*VRR1(64,25)
      VRR0(93,26)=5.D0*r1x2Z*VRR0(42,26)+PAx*VRR0(64,26)-5.D0*ExZpE*r1x2Z*VRR1(42,26)+3.D0*HfxZpE*VRR1(64,15)+WPx*VRR1(64,26)
      VRR0(93,27)=5.D0*r1x2Z*VRR0(42,27)+PAx*VRR0(64,27)-5.D0*ExZpE*r1x2Z*VRR1(42,27)+2.D0*HfxZpE*VRR1(64,16)+WPx*VRR1(64,27)
      VRR0(93,28)=5.D0*r1x2Z*VRR0(42,28)+PAx*VRR0(64,28)-5.D0*ExZpE*r1x2Z*VRR1(42,28)+HfxZpE*VRR1(64,17)+WPx*VRR1(64,28)
      VRR0(93,29)=5.D0*r1x2Z*VRR0(42,29)+PAx*VRR0(64,29)-5.D0*ExZpE*r1x2Z*VRR1(42,29)+WPx*VRR1(64,29)
      VRR0(93,30)=5.D0*r1x2Z*VRR0(42,30)+PAx*VRR0(64,30)-5.D0*ExZpE*r1x2Z*VRR1(42,30)+2.D0*HfxZpE*VRR1(64,18)+WPx*VRR1(64,30)
      VRR0(93,31)=5.D0*r1x2Z*VRR0(42,31)+PAx*VRR0(64,31)-5.D0*ExZpE*r1x2Z*VRR1(42,31)+HfxZpE*VRR1(64,19)+WPx*VRR1(64,31)
      VRR0(93,32)=5.D0*r1x2Z*VRR0(42,32)+PAx*VRR0(64,32)-5.D0*ExZpE*r1x2Z*VRR1(42,32)+WPx*VRR1(64,32)
      VRR0(93,33)=5.D0*r1x2Z*VRR0(42,33)+PAx*VRR0(64,33)-5.D0*ExZpE*r1x2Z*VRR1(42,33)+HfxZpE*VRR1(64,20)+WPx*VRR1(64,33)
      VRR0(93,34)=5.D0*r1x2Z*VRR0(42,34)+PAx*VRR0(64,34)-5.D0*ExZpE*r1x2Z*VRR1(42,34)+WPx*VRR1(64,34)
      VRR0(93,35)=5.D0*r1x2Z*VRR0(42,35)+PAx*VRR0(64,35)-5.D0*ExZpE*r1x2Z*VRR1(42,35)+WPx*VRR1(64,35)
      VRR0(94,21)=4.D0*r1x2Z*VRR0(43,21)+PAx*VRR0(65,21)-4.D0*ExZpE*r1x2Z*VRR1(43,21)+4.D0*HfxZpE*VRR1(65,11)+WPx*VRR1(65,21)
      VRR0(94,22)=4.D0*r1x2Z*VRR0(43,22)+PAx*VRR0(65,22)-4.D0*ExZpE*r1x2Z*VRR1(43,22)+3.D0*HfxZpE*VRR1(65,12)+WPx*VRR1(65,22)
      VRR0(94,23)=4.D0*r1x2Z*VRR0(43,23)+PAx*VRR0(65,23)-4.D0*ExZpE*r1x2Z*VRR1(43,23)+2.D0*HfxZpE*VRR1(65,13)+WPx*VRR1(65,23)
      VRR0(94,24)=V(64)+4.D0*r1x2Z*VRR0(43,24)+PAx*VRR0(65,24)-4.D0*ExZpE*r1x2Z*VRR1(43,24)+WPx*VRR1(65,24)
      VRR0(94,25)=4.D0*r1x2Z*VRR0(43,25)+PAx*VRR0(65,25)-4.D0*ExZpE*r1x2Z*VRR1(43,25)+WPx*VRR1(65,25)
      VRR0(94,26)=4.D0*r1x2Z*VRR0(43,26)+PAx*VRR0(65,26)-4.D0*ExZpE*r1x2Z*VRR1(43,26)+3.D0*HfxZpE*VRR1(65,15)+WPx*VRR1(65,26)
      VRR0(94,27)=4.D0*r1x2Z*VRR0(43,27)+PAx*VRR0(65,27)-4.D0*ExZpE*r1x2Z*VRR1(43,27)+2.D0*HfxZpE*VRR1(65,16)+WPx*VRR1(65,27)
      VRR0(94,28)=4.D0*r1x2Z*VRR0(43,28)+PAx*VRR0(65,28)-4.D0*ExZpE*r1x2Z*VRR1(43,28)+HfxZpE*VRR1(65,17)+WPx*VRR1(65,28)
      VRR0(94,29)=4.D0*r1x2Z*VRR0(43,29)+PAx*VRR0(65,29)-4.D0*ExZpE*r1x2Z*VRR1(43,29)+WPx*VRR1(65,29)
      VRR0(94,30)=4.D0*r1x2Z*VRR0(43,30)+PAx*VRR0(65,30)-4.D0*ExZpE*r1x2Z*VRR1(43,30)+2.D0*HfxZpE*VRR1(65,18)+WPx*VRR1(65,30)
      VRR0(94,31)=4.D0*r1x2Z*VRR0(43,31)+PAx*VRR0(65,31)-4.D0*ExZpE*r1x2Z*VRR1(43,31)+HfxZpE*VRR1(65,19)+WPx*VRR1(65,31)
      VRR0(94,32)=4.D0*r1x2Z*VRR0(43,32)+PAx*VRR0(65,32)-4.D0*ExZpE*r1x2Z*VRR1(43,32)+WPx*VRR1(65,32)
      VRR0(94,33)=V(65)+4.D0*r1x2Z*VRR0(43,33)+PAx*VRR0(65,33)-4.D0*ExZpE*r1x2Z*VRR1(43,33)+WPx*VRR1(65,33)
      VRR0(94,34)=4.D0*r1x2Z*VRR0(43,34)+PAx*VRR0(65,34)-4.D0*ExZpE*r1x2Z*VRR1(43,34)+WPx*VRR1(65,34)
      VRR0(94,35)=4.D0*r1x2Z*VRR0(43,35)+PAx*VRR0(65,35)-4.D0*ExZpE*r1x2Z*VRR1(43,35)+WPx*VRR1(65,35)
      VRR0(95,21)=3.D0*r1x2E*VRR0(95,5)+QCx*VRR0(95,11)+4.D0*HfxZpE*VRR1(66,11)-3.D0*r1x2E*ZxZpE*VRR1(95,5)+WQx*VRR1(95,11)
      VRR0(95,22)=V(67)+V(69)+PAx*VRR0(66,22)+3.D0*HfxZpE*VRR1(66,12)+WPx*VRR1(66,22)
      VRR0(95,23)=V(71)+V(73)+2.D0*V(74)+PAx*VRR0(66,23)+WPx*VRR1(66,23)
      VRR0(95,24)=V(76)+V(78)+V(79)+PAx*VRR0(66,24)+WPx*VRR1(66,24)
      VRR0(95,25)=2.D0*V(64)+3.D0*r1x2E*VRR0(95,7)+QCy*VRR0(95,14)-3.D0*r1x2E*ZxZpE*VRR1(95,7)+WQy*VRR1(95,14)
      VRR0(95,26)=V(81)+V(83)+PAx*VRR0(66,26)+3.D0*HfxZpE*VRR1(66,15)+WPx*VRR1(66,26)
      VRR0(95,27)=V(85)+V(87)+PAx*VRR0(66,27)+2.D0*HfxZpE*VRR1(66,16)+WPx*VRR1(66,27)
      VRR0(95,28)=V(89)+V(91)+V(92)+PAx*VRR0(66,28)+WPx*VRR1(66,28)
      VRR0(95,29)=V(94)+V(96)+PAx*VRR0(66,29)+WPx*VRR1(66,29)
      VRR0(95,30)=V(98)+V(100)+V(102)+PAx*VRR0(66,30)+WPx*VRR1(66,30)
      VRR0(95,31)=V(104)+V(106)+V(107)+PAx*VRR0(66,31)+WPx*VRR1(66,31)
      VRR0(95,32)=V(109)+V(111)+PAx*VRR0(66,32)+WPx*VRR1(66,32)
      VRR0(95,33)=V(113)+V(115)+V(116)+PAx*VRR0(66,33)+WPx*VRR1(66,33)
      VRR0(95,34)=V(118)+V(120)+PAx*VRR0(66,34)+WPx*VRR1(66,34)
      VRR0(95,35)=V(24)+3.D0*r1x2E*VRR0(95,10)+QCz*VRR0(95,20)-3.D0*r1x2E*ZxZpE*VRR1(95,10)+WQz*VRR1(95,20)
      VRR0(96,21)=3.D0*V(121)+3.D0*r1x2E*VRR0(96,5)+QCx*VRR0(96,11)-3.D0*r1x2E*ZxZpE*VRR1(96,5)+WQx*VRR1(96,11)
      VRR0(96,22)=V(123)+3.D0*V(124)+V(126)+QCx*VRR0(96,12)+WQx*VRR1(96,12)
      VRR0(96,23)=2.D0*V(127)-2.D0*V(128)+2.D0*V(129)+PAx*VRR0(67,23)+WPx*VRR1(67,23)
      VRR0(96,24)=3.D0*V(74)+V(123)+V(126)+QCy*VRR0(96,13)+WQy*VRR1(96,13)
      VRR0(96,25)=3.D0*V(79)+3.D0*r1x2E*VRR0(96,7)+QCy*VRR0(96,14)-3.D0*r1x2E*ZxZpE*VRR1(96,7)+WQy*VRR1(96,14)
      VRR0(96,26)=V(131)+3.D0*V(132)+V(134)+QCx*VRR0(96,15)+WQx*VRR1(96,15)
      VRR0(96,27)=2.D0*V(135)-2.D0*V(136)+V(138)+PAx*VRR0(67,27)+WPx*VRR1(67,27)
      VRR0(96,28)=2.D0*V(139)-2.D0*V(140)+V(141)+PAx*VRR0(67,28)+WPx*VRR1(67,28)
      VRR0(96,29)=3.D0*V(92)+V(143)+V(145)+QCy*VRR0(96,17)+WQy*VRR1(96,17)
      VRR0(96,30)=2.D0*V(146)-2.D0*V(147)+V(149)+PAx*VRR0(67,30)+WPx*VRR1(67,30)
      VRR0(96,31)=2.D0*V(150)-2.D0*V(151)+V(152)+PAx*VRR0(67,31)+WPx*VRR1(67,31)
      VRR0(96,32)=2.D0*V(153)-2.D0*V(154)+PAx*VRR0(67,32)+WPx*VRR1(67,32)
      VRR0(96,33)=V(51)+V(131)+V(134)+QCz*VRR0(96,18)+WQz*VRR1(96,18)
      VRR0(96,34)=V(54)+V(143)+V(145)+QCz*VRR0(96,19)+WQz*VRR1(96,19)
      VRR0(96,35)=V(59)+3.D0*r1x2E*VRR0(96,10)+QCz*VRR0(96,20)-3.D0*r1x2E*ZxZpE*VRR1(96,10)+WQz*VRR1(96,20)
      VRR0(97,21)=2.D0*V(155)+3.D0*r1x2E*VRR0(97,5)+QCx*VRR0(97,11)-3.D0*r1x2E*ZxZpE*VRR1(97,5)+WQx*VRR1(97,11)
      VRR0(97,22)=V(67)+V(69)+V(121)+PAy*VRR0(67,22)+WPy*VRR1(67,22)
      VRR0(97,23)=V(71)+V(73)+2.D0*V(124)+PAy*VRR0(67,23)+WPy*VRR1(67,23)
      VRR0(97,24)=V(76)+V(78)+3.D0*V(129)+PAy*VRR0(67,24)+WPy*VRR1(67,24)
      VRR0(97,25)=3.D0*r1x2E*VRR0(97,7)+QCy*VRR0(97,14)+4.D0*HfxZpE*VRR1(67,14)-3.D0*r1x2E*ZxZpE*VRR1(97,7)+WQy*VRR1(97,14)
      VRR0(97,26)=V(81)+V(83)+PAy*VRR0(67,26)+WPy*VRR1(67,26)
      VRR0(97,27)=V(85)+V(87)+V(132)+PAy*VRR0(67,27)+WPy*VRR1(67,27)
      VRR0(97,28)=V(89)+V(91)+V(138)+PAy*VRR0(67,28)+WPy*VRR1(67,28)
      VRR0(97,29)=V(94)+V(96)+3.D0*V(141)+PAy*VRR0(67,29)+WPy*VRR1(67,29)
      VRR0(97,30)=V(98)+V(100)+PAy*VRR0(67,30)+WPy*VRR1(67,30)
      VRR0(97,31)=V(104)+V(106)+V(148)+PAy*VRR0(67,31)+WPy*VRR1(67,31)
      VRR0(97,32)=V(109)+V(111)+V(156)+PAy*VRR0(67,32)+WPy*VRR1(67,32)
      VRR0(97,33)=V(113)+V(115)+PAy*VRR0(67,33)+WPy*VRR1(67,33)
      VRR0(97,34)=V(118)+V(120)+V(157)+PAy*VRR0(67,34)+WPy*VRR1(67,34)
      VRR0(97,35)=V(63)+3.D0*r1x2E*VRR0(97,10)+QCz*VRR0(97,20)-3.D0*r1x2E*ZxZpE*VRR1(97,10)+WQz*VRR1(97,20)
      VRR0(98,21)=4.D0*r1x2Z*VRR0(45,21)+PAy*VRR0(68,21)-4.D0*ExZpE*r1x2Z*VRR1(45,21)+WPy*VRR1(68,21)
      VRR0(98,22)=V(155)+4.D0*r1x2Z*VRR0(45,22)+PAy*VRR0(68,22)-4.D0*ExZpE*r1x2Z*VRR1(45,22)+WPy*VRR1(68,22)
      VRR0(98,23)=4.D0*V(127)-4.D0*V(128)+PAy*VRR0(68,23)+2.D0*HfxZpE*VRR1(68,12)+WPy*VRR1(68,23)
      VRR0(98,24)=4.D0*r1x2Z*VRR0(45,24)+PAy*VRR0(68,24)-4.D0*ExZpE*r1x2Z*VRR1(45,24)+3.D0*HfxZpE*VRR1(68,13)+WPy*VRR1(68,24)
      VRR0(98,25)=4.D0*r1x2Z*VRR0(45,25)+PAy*VRR0(68,25)-4.D0*ExZpE*r1x2Z*VRR1(45,25)+4.D0*HfxZpE*VRR1(68,14)+WPy*VRR1(68,25)
      VRR0(98,26)=4.D0*r1x2Z*VRR0(45,26)+PAy*VRR0(68,26)-4.D0*ExZpE*r1x2Z*VRR1(45,26)+WPy*VRR1(68,26)
      VRR0(98,27)=4.D0*V(135)-4.D0*V(136)+PAy*VRR0(68,27)+HfxZpE*VRR1(68,15)+WPy*VRR1(68,27)
      VRR0(98,28)=4.D0*V(139)-4.D0*V(140)+PAy*VRR0(68,28)+2.D0*HfxZpE*VRR1(68,16)+WPy*VRR1(68,28)
      VRR0(98,29)=4.D0*r1x2Z*VRR0(45,29)+PAy*VRR0(68,29)-4.D0*ExZpE*r1x2Z*VRR1(45,29)+3.D0*HfxZpE*VRR1(68,17)+WPy*VRR1(68,29)
      VRR0(98,30)=4.D0*V(146)-4.D0*V(147)+PAy*VRR0(68,30)+WPy*VRR1(68,30)
      VRR0(98,31)=4.D0*V(150)-4.D0*V(151)+PAy*VRR0(68,31)+HfxZpE*VRR1(68,18)+WPy*VRR1(68,31)
      VRR0(98,32)=4.D0*V(153)-4.D0*V(154)+PAy*VRR0(68,32)+2.D0*HfxZpE*VRR1(68,19)+WPy*VRR1(68,32)
      VRR0(98,33)=4.D0*r1x2Z*VRR0(45,33)+PAy*VRR0(68,33)-4.D0*ExZpE*r1x2Z*VRR1(45,33)+WPy*VRR1(68,33)
      VRR0(98,34)=V(158)+4.D0*r1x2Z*VRR0(45,34)+PAy*VRR0(68,34)-4.D0*ExZpE*r1x2Z*VRR1(45,34)+WPy*VRR1(68,34)
      VRR0(98,35)=4.D0*r1x2Z*VRR0(45,35)+PAy*VRR0(68,35)-4.D0*ExZpE*r1x2Z*VRR1(45,35)+WPy*VRR1(68,35)
      VRR0(99,21)=5.D0*r1x2Z*VRR0(46,21)+PAy*VRR0(69,21)-5.D0*ExZpE*r1x2Z*VRR1(46,21)+WPy*VRR1(69,21)
      VRR0(99,22)=5.D0*r1x2Z*VRR0(46,22)+PAy*VRR0(69,22)-5.D0*ExZpE*r1x2Z*VRR1(46,22)+HfxZpE*VRR1(69,11)+WPy*VRR1(69,22)
      VRR0(99,23)=5.D0*r1x2Z*VRR0(46,23)+PAy*VRR0(69,23)-5.D0*ExZpE*r1x2Z*VRR1(46,23)+2.D0*HfxZpE*VRR1(69,12)+WPy*VRR1(69,23)
      VRR0(99,24)=5.D0*r1x2Z*VRR0(46,24)+PAy*VRR0(69,24)-5.D0*ExZpE*r1x2Z*VRR1(46,24)+3.D0*HfxZpE*VRR1(69,13)+WPy*VRR1(69,24)
      VRR0(99,25)=5.D0*r1x2Z*VRR0(46,25)+PAy*VRR0(69,25)-5.D0*ExZpE*r1x2Z*VRR1(46,25)+4.D0*HfxZpE*VRR1(69,14)+WPy*VRR1(69,25)
      VRR0(99,26)=5.D0*r1x2Z*VRR0(46,26)+PAy*VRR0(69,26)-5.D0*ExZpE*r1x2Z*VRR1(46,26)+WPy*VRR1(69,26)
      VRR0(99,27)=5.D0*r1x2Z*VRR0(46,27)+PAy*VRR0(69,27)-5.D0*ExZpE*r1x2Z*VRR1(46,27)+HfxZpE*VRR1(69,15)+WPy*VRR1(69,27)
      VRR0(99,28)=5.D0*r1x2Z*VRR0(46,28)+PAy*VRR0(69,28)-5.D0*ExZpE*r1x2Z*VRR1(46,28)+2.D0*HfxZpE*VRR1(69,16)+WPy*VRR1(69,28)
      VRR0(99,29)=5.D0*r1x2Z*VRR0(46,29)+PAy*VRR0(69,29)-5.D0*ExZpE*r1x2Z*VRR1(46,29)+3.D0*HfxZpE*VRR1(69,17)+WPy*VRR1(69,29)
      VRR0(99,30)=5.D0*r1x2Z*VRR0(46,30)+PAy*VRR0(69,30)-5.D0*ExZpE*r1x2Z*VRR1(46,30)+WPy*VRR1(69,30)
      VRR0(99,31)=5.D0*r1x2Z*VRR0(46,31)+PAy*VRR0(69,31)-5.D0*ExZpE*r1x2Z*VRR1(46,31)+HfxZpE*VRR1(69,18)+WPy*VRR1(69,31)
      VRR0(99,32)=5.D0*r1x2Z*VRR0(46,32)+PAy*VRR0(69,32)-5.D0*ExZpE*r1x2Z*VRR1(46,32)+2.D0*HfxZpE*VRR1(69,19)+WPy*VRR1(69,32)
      VRR0(99,33)=5.D0*r1x2Z*VRR0(46,33)+PAy*VRR0(69,33)-5.D0*ExZpE*r1x2Z*VRR1(46,33)+WPy*VRR1(69,33)
      VRR0(99,34)=5.D0*r1x2Z*VRR0(46,34)+PAy*VRR0(69,34)-5.D0*ExZpE*r1x2Z*VRR1(46,34)+HfxZpE*VRR1(69,20)+WPy*VRR1(69,34)
      VRR0(99,35)=5.D0*r1x2Z*VRR0(46,35)+PAy*VRR0(69,35)-5.D0*ExZpE*r1x2Z*VRR1(46,35)+WPy*VRR1(69,35)
      VRR0(100,21)=4.D0*r1x2Z*VRR0(47,21)+PAx*VRR0(70,21)-4.D0*ExZpE*r1x2Z*VRR1(47,21)+4.D0*HfxZpE*VRR1(70,11)+WPx*VRR1(70,21)
      VRR0(100,22)=4.D0*V(159)-4.D0*V(160)+PAx*VRR0(70,22)+3.D0*HfxZpE*VRR1(70,12)+WPx*VRR1(70,22)
      VRR0(100,23)=4.D0*V(161)-4.D0*V(162)+PAx*VRR0(70,23)+2.D0*HfxZpE*VRR1(70,13)+WPx*VRR1(70,23)
      VRR0(100,24)=4.D0*V(163)-4.D0*V(164)+V(165)+PAx*VRR0(70,24)+WPx*VRR1(70,24)
      VRR0(100,25)=4.D0*r1x2Z*VRR0(47,25)+PAx*VRR0(70,25)-4.D0*ExZpE*r1x2Z*VRR1(47,25)+WPx*VRR1(70,25)
      VRR0(100,26)=4.D0*V(166)-4.D0*V(167)+PAx*VRR0(70,26)+3.D0*HfxZpE*VRR1(70,15)+WPx*VRR1(70,26)
      VRR0(100,27)=4.D0*V(168)-4.D0*V(169)+PAx*VRR0(70,27)+2.D0*HfxZpE*VRR1(70,16)+WPx*VRR1(70,27)
      VRR0(100,28)=4.D0*V(170)-4.D0*V(171)+PAx*VRR0(70,28)+HfxZpE*VRR1(70,17)+WPx*VRR1(70,28)
      VRR0(100,29)=4.D0*V(172)-4.D0*V(173)+PAx*VRR0(70,29)+WPx*VRR1(70,29)
      VRR0(100,30)=4.D0*V(174)-4.D0*V(175)+PAx*VRR0(70,30)+2.D0*HfxZpE*VRR1(70,18)+WPx*VRR1(70,30)
      VRR0(100,31)=4.D0*V(176)-4.D0*V(177)+PAx*VRR0(70,31)+HfxZpE*VRR1(70,19)+WPx*VRR1(70,31)
      VRR0(100,32)=4.D0*V(178)-4.D0*V(179)+PAx*VRR0(70,32)+WPx*VRR1(70,32)
      VRR0(100,33)=4.D0*V(180)-4.D0*V(181)+V(182)+PAx*VRR0(70,33)+WPx*VRR1(70,33)
      VRR0(100,34)=4.D0*V(183)-4.D0*V(184)+PAx*VRR0(70,34)+WPx*VRR1(70,34)
      VRR0(100,35)=4.D0*r1x2Z*VRR0(47,35)+PAx*VRR0(70,35)-4.D0*ExZpE*r1x2Z*VRR1(47,35)+WPx*VRR1(70,35)
      VRR0(101,21)=3.D0*r1x2E*VRR0(101,5)+QCx*VRR0(101,11)+4.D0*HfxZpE*VRR1(71,11)-3.D0*r1x2E*ZxZpE*VRR1(101,5)+WQx*VRR1(101,11)
      VRR0(101,22)=V(186)+V(188)+PAx*VRR0(71,22)+3.D0*HfxZpE*VRR1(71,12)+WPx*VRR1(71,22)
      VRR0(101,23)=V(190)+V(192)+V(194)+PAx*VRR0(71,23)+WPx*VRR1(71,23)
      VRR0(101,24)=V(196)+V(198)+V(199)+PAx*VRR0(71,24)+WPx*VRR1(71,24)
      VRR0(101,25)=V(165)+3.D0*r1x2E*VRR0(101,7)+QCy*VRR0(101,14)-3.D0*r1x2E*ZxZpE*VRR1(101,7)+WQy*VRR1(101,14)
      VRR0(101,26)=V(201)+V(203)+PAx*VRR0(71,26)+3.D0*HfxZpE*VRR1(71,15)+WPx*VRR1(71,26)
      VRR0(101,27)=V(205)+V(207)+PAx*VRR0(71,27)+2.D0*HfxZpE*VRR1(71,16)+WPx*VRR1(71,27)
      VRR0(101,28)=V(209)+V(211)+V(212)+PAx*VRR0(71,28)+WPx*VRR1(71,28)
      VRR0(101,29)=V(214)+V(216)+PAx*VRR0(71,29)+WPx*VRR1(71,29)
      VRR0(101,30)=V(218)+V(220)+2.D0*V(221)+PAx*VRR0(71,30)+WPx*VRR1(71,30)
      VRR0(101,31)=V(223)+V(225)+V(226)+PAx*VRR0(71,31)+WPx*VRR1(71,31)
      VRR0(101,32)=V(228)+V(230)+PAx*VRR0(71,32)+WPx*VRR1(71,32)
      VRR0(101,33)=V(232)+V(234)+V(235)+PAx*VRR0(71,33)+WPx*VRR1(71,33)
      VRR0(101,34)=V(237)+V(239)+PAx*VRR0(71,34)+WPx*VRR1(71,34)
      VRR0(101,35)=2.D0*V(65)+3.D0*r1x2E*VRR0(101,10)+QCz*VRR0(101,20)-3.D0*r1x2E*ZxZpE*VRR1(101,10)+WQz*VRR1(101,20)
      VRR0(102,21)=3.D0*r1x2E*VRR0(102,5)+QCx*VRR0(102,11)+3.D0*HfxZpE*VRR1(72,11)-3.D0*r1x2E*ZxZpE*VRR1(102,5)+WQx*VRR1(102,11)
      VRR0(102,22)=V(241)+3.D0*V(242)+V(244)+QCx*VRR0(102,12)+WQx*VRR1(102,12)
      VRR0(102,23)=2.D0*V(245)-2.D0*V(246)+2.D0*V(247)+PAx*VRR0(72,23)+WPx*VRR1(72,23)
      VRR0(102,24)=V(194)+V(241)+V(244)+QCy*VRR0(102,13)+WQy*VRR1(102,13)
      VRR0(102,25)=2.D0*V(199)+3.D0*r1x2E*VRR0(102,7)+QCy*VRR0(102,14)-3.D0*r1x2E*ZxZpE*VRR1(102,7)+WQy*VRR1(102,14)
      VRR0(102,26)=V(249)+3.D0*V(250)+V(252)+QCx*VRR0(102,15)+WQx*VRR1(102,15)
      VRR0(102,27)=2.D0*V(253)-2.D0*V(254)+V(256)+PAx*VRR0(72,27)+WPx*VRR1(72,27)
      VRR0(102,28)=2.D0*V(257)-2.D0*V(258)+V(259)+PAx*VRR0(72,28)+WPx*VRR1(72,28)
      VRR0(102,29)=2.D0*V(212)+V(261)+V(263)+QCy*VRR0(102,17)+WQy*VRR1(102,17)
      VRR0(102,30)=2.D0*V(264)-2.D0*V(265)+2.D0*V(266)+PAx*VRR0(72,30)+WPx*VRR1(72,30)
      VRR0(102,31)=2.D0*V(267)-2.D0*V(268)+V(269)+PAx*VRR0(72,31)+WPx*VRR1(72,31)
      VRR0(102,32)=2.D0*V(270)-2.D0*V(271)+PAx*VRR0(72,32)+WPx*VRR1(72,32)
      VRR0(102,33)=V(102)+V(249)+V(252)+QCz*VRR0(102,18)+WQz*VRR1(102,18)
      VRR0(102,34)=2.D0*V(107)+V(261)+V(263)+QCz*VRR0(102,19)+WQz*VRR1(102,19)
      VRR0(102,35)=2.D0*V(116)+3.D0*r1x2E*VRR0(102,10)+QCz*VRR0(102,20)-3.D0*r1x2E*ZxZpE*VRR1(102,10)+WQz*VRR1(102,20)
      VRR0(103,21)=2.D0*V(272)+3.D0*r1x2E*VRR0(103,5)+QCx*VRR0(103,11)-3.D0*r1x2E*ZxZpE*VRR1(103,5)+WQx*VRR1(103,11)
      VRR0(103,22)=V(274)+V(276)+V(278)+QCx*VRR0(103,12)+WQx*VRR1(103,12)
      VRR0(103,23)=2.D0*V(189)-2.D0*V(191)+2.D0*V(242)+PAy*VRR0(72,23)+WPy*VRR1(72,23)
      VRR0(103,24)=3.D0*V(247)+V(274)+V(278)+QCy*VRR0(103,13)+WQy*VRR1(103,13)
      VRR0(103,25)=3.D0*r1x2E*VRR0(103,7)+QCy*VRR0(103,14)+3.D0*HfxZpE*VRR1(72,14)-3.D0*r1x2E*ZxZpE*VRR1(103,7)+WQy*VRR1(103,14)
      VRR0(103,26)=V(280)+2.D0*V(281)+V(283)+QCx*VRR0(103,15)+WQx*VRR1(103,15)
      VRR0(103,27)=2.D0*V(204)-2.D0*V(206)+V(250)+PAy*VRR0(72,27)+WPy*VRR1(72,27)
      VRR0(103,28)=2.D0*V(208)-2.D0*V(210)+V(256)+PAy*VRR0(72,28)+WPy*VRR1(72,28)
      VRR0(103,29)=3.D0*V(259)+V(285)+V(287)+QCy*VRR0(103,17)+WQy*VRR1(103,17)
      VRR0(103,30)=2.D0*V(217)-2.D0*V(219)+PAy*VRR0(72,30)+WPy*VRR1(72,30)
      VRR0(103,31)=2.D0*V(222)-2.D0*V(224)+V(266)+PAy*VRR0(72,31)+WPy*VRR1(72,31)
      VRR0(103,32)=2.D0*V(227)-2.D0*V(229)+2.D0*V(269)+PAy*VRR0(72,32)+WPy*VRR1(72,32)
      VRR0(103,33)=V(149)+V(280)+V(283)+QCz*VRR0(103,18)+WQz*VRR1(103,18)
      VRR0(103,34)=V(156)+V(285)+V(287)+QCz*VRR0(103,19)+WQz*VRR1(103,19)
      VRR0(103,35)=2.D0*V(157)+3.D0*r1x2E*VRR0(103,10)+QCz*VRR0(103,20)-3.D0*r1x2E*ZxZpE*VRR1(103,10)+WQz*VRR1(103,20)
      VRR0(104,21)=V(288)+3.D0*r1x2E*VRR0(104,5)+QCx*VRR0(104,11)-3.D0*r1x2E*ZxZpE*VRR1(104,5)+WQx*VRR1(104,11)
      VRR0(104,22)=V(272)+V(290)+V(292)+PAy*VRR0(73,22)+WPy*VRR1(73,22)
      VRR0(104,23)=V(276)+V(293)+V(294)+PAy*VRR0(73,23)+WPy*VRR1(73,23)
      VRR0(104,24)=V(296)+V(298)+PAy*VRR0(73,24)+3.D0*HfxZpE*VRR1(73,13)+WPy*VRR1(73,24)
      VRR0(104,25)=3.D0*r1x2E*VRR0(104,7)+QCy*VRR0(104,14)+4.D0*HfxZpE*VRR1(73,14)-3.D0*r1x2E*ZxZpE*VRR1(104,7)+WQy*VRR1(104,14)
      VRR0(104,26)=V(300)+V(302)+PAy*VRR0(73,26)+WPy*VRR1(73,26)
      VRR0(104,27)=V(281)+V(303)+V(304)+PAy*VRR0(73,27)+WPy*VRR1(73,27)
      VRR0(104,28)=V(305)+V(306)+PAy*VRR0(73,28)+2.D0*HfxZpE*VRR1(73,16)+WPy*VRR1(73,28)
      VRR0(104,29)=V(308)+V(310)+PAy*VRR0(73,29)+3.D0*HfxZpE*VRR1(73,17)+WPy*VRR1(73,29)
      VRR0(104,30)=V(311)+V(312)+PAy*VRR0(73,30)+WPy*VRR1(73,30)
      VRR0(104,31)=V(313)+V(314)+V(315)+PAy*VRR0(73,31)+WPy*VRR1(73,31)
      VRR0(104,32)=V(316)+V(317)+2.D0*V(318)+PAy*VRR0(73,32)+WPy*VRR1(73,32)
      VRR0(104,33)=V(320)+V(322)+PAy*VRR0(73,33)+WPy*VRR1(73,33)
      VRR0(104,34)=V(324)+V(326)+V(327)+PAy*VRR0(73,34)+WPy*VRR1(73,34)
      VRR0(104,35)=2.D0*V(158)+3.D0*r1x2E*VRR0(104,10)+QCz*VRR0(104,20)-3.D0*r1x2E*ZxZpE*VRR1(104,10)+WQz*VRR1(104,20)
      VRR0(105,21)=4.D0*r1x2Z*VRR0(50,21)+PAy*VRR0(74,21)-4.D0*ExZpE*r1x2Z*VRR1(50,21)+WPy*VRR1(74,21)
      VRR0(105,22)=V(288)+4.D0*V(328)-4.D0*V(329)+PAy*VRR0(74,22)+WPy*VRR1(74,22)
      VRR0(105,23)=4.D0*V(330)-4.D0*V(331)+PAy*VRR0(74,23)+2.D0*HfxZpE*VRR1(74,12)+WPy*VRR1(74,23)
      VRR0(105,24)=4.D0*V(332)-4.D0*V(333)+PAy*VRR0(74,24)+3.D0*HfxZpE*VRR1(74,13)+WPy*VRR1(74,24)
      VRR0(105,25)=4.D0*r1x2Z*VRR0(50,25)+PAy*VRR0(74,25)-4.D0*ExZpE*r1x2Z*VRR1(50,25)+4.D0*HfxZpE*VRR1(74,14)+WPy*VRR1(74,25)
      VRR0(105,26)=4.D0*V(334)-4.D0*V(335)+PAy*VRR0(74,26)+WPy*VRR1(74,26)
      VRR0(105,27)=4.D0*V(336)-4.D0*V(337)+PAy*VRR0(74,27)+HfxZpE*VRR1(74,15)+WPy*VRR1(74,27)
      VRR0(105,28)=4.D0*V(338)-4.D0*V(339)+PAy*VRR0(74,28)+2.D0*HfxZpE*VRR1(74,16)+WPy*VRR1(74,28)
      VRR0(105,29)=4.D0*V(340)-4.D0*V(341)+PAy*VRR0(74,29)+3.D0*HfxZpE*VRR1(74,17)+WPy*VRR1(74,29)
      VRR0(105,30)=4.D0*V(342)-4.D0*V(343)+PAy*VRR0(74,30)+WPy*VRR1(74,30)
      VRR0(105,31)=4.D0*V(344)-4.D0*V(345)+PAy*VRR0(74,31)+HfxZpE*VRR1(74,18)+WPy*VRR1(74,31)
      VRR0(105,32)=4.D0*V(346)-4.D0*V(347)+PAy*VRR0(74,32)+2.D0*HfxZpE*VRR1(74,19)+WPy*VRR1(74,32)
      VRR0(105,33)=4.D0*V(348)-4.D0*V(349)+PAy*VRR0(74,33)+WPy*VRR1(74,33)
      VRR0(105,34)=4.D0*V(350)-4.D0*V(351)+V(352)+PAy*VRR0(74,34)+WPy*VRR1(74,34)
      VRR0(105,35)=4.D0*r1x2Z*VRR0(50,35)+PAy*VRR0(74,35)-4.D0*ExZpE*r1x2Z*VRR1(50,35)+WPy*VRR1(74,35)
      VRR0(106,21)=4.D0*V(353)+3.D0*r1x2E*VRR0(106,5)+QCx*VRR0(106,11)-3.D0*r1x2E*ZxZpE*VRR1(106,5)+WQx*VRR1(106,11)
      VRR0(106,22)=3.D0*V(354)-3.D0*V(355)+3.D0*V(356)+PAx*VRR0(75,22)+WPx*VRR1(75,22)
      VRR0(106,23)=3.D0*V(357)-3.D0*V(358)+2.D0*V(359)+PAx*VRR0(75,23)+WPx*VRR1(75,23)
      VRR0(106,24)=3.D0*V(360)-3.D0*V(361)+V(362)+PAx*VRR0(75,24)+WPx*VRR1(75,24)
      VRR0(106,25)=3.D0*r1x2E*VRR0(106,7)+QCy*VRR0(106,14)-3.D0*r1x2E*ZxZpE*VRR1(106,7)+WQy*VRR1(106,14)
      VRR0(106,26)=3.D0*V(363)-3.D0*V(364)+3.D0*V(365)+PAx*VRR0(75,26)+WPx*VRR1(75,26)
      VRR0(106,27)=3.D0*V(366)-3.D0*V(367)+V(369)+PAx*VRR0(75,27)+WPx*VRR1(75,27)
      VRR0(106,28)=3.D0*V(370)-3.D0*V(371)+V(372)+PAx*VRR0(75,28)+WPx*VRR1(75,28)
      VRR0(106,29)=3.D0*V(373)-3.D0*V(374)+PAx*VRR0(75,29)+WPx*VRR1(75,29)
      VRR0(106,30)=3.D0*V(375)-3.D0*V(376)+2.D0*V(377)+PAx*VRR0(75,30)+WPx*VRR1(75,30)
      VRR0(106,31)=3.D0*V(378)-3.D0*V(379)+V(380)+PAx*VRR0(75,31)+WPx*VRR1(75,31)
      VRR0(106,32)=3.D0*V(381)-3.D0*V(382)+PAx*VRR0(75,32)+WPx*VRR1(75,32)
      VRR0(106,33)=3.D0*V(383)-3.D0*V(384)+V(385)+PAx*VRR0(75,33)+WPx*VRR1(75,33)
      VRR0(106,34)=3.D0*V(386)-3.D0*V(387)+PAx*VRR0(75,34)+WPx*VRR1(75,34)
      VRR0(106,35)=3.D0*V(182)+3.D0*r1x2E*VRR0(106,10)+QCz*VRR0(106,20)-3.D0*r1x2E*ZxZpE*VRR1(106,10)+WQz*VRR1(106,20)
      VRR0(107,21)=3.D0*V(388)+3.D0*r1x2E*VRR0(107,5)+QCx*VRR0(107,11)-3.D0*r1x2E*ZxZpE*VRR1(107,5)+WQx*VRR1(107,11)
      VRR0(107,22)=V(390)+3.D0*V(391)+V(393)+QCx*VRR0(107,12)+WQx*VRR1(107,12)
      VRR0(107,23)=V(395)+V(397)+V(399)+PAx*VRR0(76,23)+WPx*VRR1(76,23)
      VRR0(107,24)=V(359)+V(390)+V(393)+QCy*VRR0(107,13)+WQy*VRR1(107,13)
      VRR0(107,25)=V(362)+3.D0*r1x2E*VRR0(107,7)+QCy*VRR0(107,14)-3.D0*r1x2E*ZxZpE*VRR1(107,7)+WQy*VRR1(107,14)
      VRR0(107,26)=V(401)+3.D0*V(402)+V(404)+QCx*VRR0(107,15)+WQx*VRR1(107,15)
      VRR0(107,27)=V(406)+V(408)+V(410)+PAx*VRR0(76,27)+WPx*VRR1(76,27)
      VRR0(107,28)=V(412)+V(414)+V(415)+PAx*VRR0(76,28)+WPx*VRR1(76,28)
      VRR0(107,29)=V(372)+V(417)+V(419)+QCy*VRR0(107,17)+WQy*VRR1(107,17)
      VRR0(107,30)=V(421)+V(423)+2.D0*V(424)+PAx*VRR0(76,30)+WPx*VRR1(76,30)
      VRR0(107,31)=V(426)+V(428)+V(429)+PAx*VRR0(76,31)+WPx*VRR1(76,31)
      VRR0(107,32)=V(431)+V(433)+PAx*VRR0(76,32)+WPx*VRR1(76,32)
      VRR0(107,33)=3.D0*V(221)+V(401)+V(404)+QCz*VRR0(107,18)+WQz*VRR1(107,18)
      VRR0(107,34)=3.D0*V(226)+V(417)+V(419)+QCz*VRR0(107,19)+WQz*VRR1(107,19)
      VRR0(107,35)=3.D0*V(235)+3.D0*r1x2E*VRR0(107,10)+QCz*VRR0(107,20)-3.D0*r1x2E*ZxZpE*VRR1(107,10)+WQz*VRR1(107,20)
      VRR0(108,21)=2.D0*V(434)+3.D0*r1x2E*VRR0(108,5)+QCx*VRR0(108,11)-3.D0*r1x2E*ZxZpE*VRR1(108,5)+WQx*VRR1(108,11)
      VRR0(108,22)=V(436)+V(438)+V(440)+QCx*VRR0(108,12)+WQx*VRR1(108,12)
      VRR0(108,23)=2.D0*V(70)-2.D0*V(72)+PAz*VRR0(72,23)+WPz*VRR1(72,23)
      VRR0(108,24)=V(399)+V(436)+V(440)+QCy*VRR0(108,13)+WQy*VRR1(108,13)
      VRR0(108,25)=2.D0*V(441)+3.D0*r1x2E*VRR0(108,7)+QCy*VRR0(108,14)-3.D0*r1x2E*ZxZpE*VRR1(108,7)+WQy*VRR1(108,14)
      VRR0(108,26)=V(443)+V(445)+V(447)+QCx*VRR0(108,15)+WQx*VRR1(108,15)
      VRR0(108,27)=2.D0*V(84)-2.D0*V(86)+V(242)+PAz*VRR0(72,27)+WPz*VRR1(72,27)
      VRR0(108,28)=2.D0*V(88)-2.D0*V(90)+V(247)+PAz*VRR0(72,28)+WPz*VRR1(72,28)
      VRR0(108,29)=V(449)+V(450)+V(452)+QCy*VRR0(108,17)+WQy*VRR1(108,17)
      VRR0(108,30)=2.D0*V(97)-2.D0*V(99)+2.D0*V(250)+PAz*VRR0(72,30)+WPz*VRR1(72,30)
      VRR0(108,31)=2.D0*V(103)-2.D0*V(105)+V(256)+PAz*VRR0(72,31)+WPz*VRR1(72,31)
      VRR0(108,32)=2.D0*V(108)-2.D0*V(110)+2.D0*V(259)+PAz*VRR0(72,32)+WPz*VRR1(72,32)
      VRR0(108,33)=3.D0*V(266)+V(443)+V(447)+QCz*VRR0(108,18)+WQz*VRR1(108,18)
      VRR0(108,34)=3.D0*V(269)+V(449)+V(452)+QCz*VRR0(108,19)+WQz*VRR1(108,19)
      VRR0(108,35)=3.D0*r1x2E*VRR0(108,10)+QCz*VRR0(108,20)+3.D0*HfxZpE*VRR1(72,20)-3.D0*r1x2E*ZxZpE*VRR1(108,10)+WQz*VRR1(108,20)
      VRR0(109,21)=V(453)+3.D0*r1x2E*VRR0(109,5)+QCx*VRR0(109,11)-3.D0*r1x2E*ZxZpE*VRR1(109,5)+WQx*VRR1(109,11)
      VRR0(109,22)=V(455)+V(456)+V(458)+QCx*VRR0(109,12)+WQx*VRR1(109,12)
      VRR0(109,23)=V(395)+V(397)+V(438)+PAy*VRR0(77,23)+WPy*VRR1(77,23)
      VRR0(109,24)=V(455)+V(458)+3.D0*V(459)+QCy*VRR0(109,13)+WQy*VRR1(109,13)
      VRR0(109,25)=3.D0*V(460)+3.D0*r1x2E*VRR0(109,7)+QCy*VRR0(109,14)-3.D0*r1x2E*ZxZpE*VRR1(109,7)+WQy*VRR1(109,14)
      VRR0(109,26)=V(462)+V(463)+V(465)+QCx*VRR0(109,15)+WQx*VRR1(109,15)
      VRR0(109,27)=V(406)+V(408)+V(444)+PAy*VRR0(77,27)+WPy*VRR1(77,27)
      VRR0(109,28)=V(412)+V(414)+V(467)+PAy*VRR0(77,28)+WPy*VRR1(77,28)
      VRR0(109,29)=V(469)+3.D0*V(470)+V(472)+QCy*VRR0(109,17)+WQy*VRR1(109,17)
      VRR0(109,30)=V(421)+V(423)+PAy*VRR0(77,30)+WPy*VRR1(77,30)
      VRR0(109,31)=V(426)+V(428)+V(473)+PAy*VRR0(77,31)+WPy*VRR1(77,31)
      VRR0(109,32)=V(431)+V(433)+2.D0*V(474)+PAy*VRR0(77,32)+WPy*VRR1(77,32)
      VRR0(109,33)=3.D0*V(315)+V(462)+V(465)+QCz*VRR0(109,18)+WQz*VRR1(109,18)
      VRR0(109,34)=3.D0*V(318)+V(469)+V(472)+QCz*VRR0(109,19)+WQz*VRR1(109,19)
      VRR0(109,35)=3.D0*V(327)+3.D0*r1x2E*VRR0(109,10)+QCz*VRR0(109,20)-3.D0*r1x2E*ZxZpE*VRR1(109,10)+WQz*VRR1(109,20)
      VRR0(110,21)=3.D0*r1x2E*VRR0(110,5)+QCx*VRR0(110,11)-3.D0*r1x2E*ZxZpE*VRR1(110,5)+WQx*VRR1(110,11)
      VRR0(110,22)=V(453)+3.D0*V(475)-3.D0*V(476)+PAy*VRR0(78,22)+WPy*VRR1(78,22)
      VRR0(110,23)=2.D0*V(456)+3.D0*V(477)-3.D0*V(478)+PAy*VRR0(78,23)+WPy*VRR1(78,23)
      VRR0(110,24)=3.D0*V(479)-3.D0*V(480)+3.D0*V(481)+PAy*VRR0(78,24)+WPy*VRR1(78,24)
      VRR0(110,25)=4.D0*V(482)+3.D0*r1x2E*VRR0(110,7)+QCy*VRR0(110,14)-3.D0*r1x2E*ZxZpE*VRR1(110,7)+WQy*VRR1(110,14)
      VRR0(110,26)=3.D0*V(483)-3.D0*V(484)+PAy*VRR0(78,26)+WPy*VRR1(78,26)
      VRR0(110,27)=V(463)+3.D0*V(485)-3.D0*V(486)+PAy*VRR0(78,27)+WPy*VRR1(78,27)
      VRR0(110,28)=3.D0*V(487)-3.D0*V(488)+V(490)+PAy*VRR0(78,28)+WPy*VRR1(78,28)
      VRR0(110,29)=3.D0*V(491)-3.D0*V(492)+3.D0*V(493)+PAy*VRR0(78,29)+WPy*VRR1(78,29)
      VRR0(110,30)=3.D0*V(494)-3.D0*V(495)+PAy*VRR0(78,30)+WPy*VRR1(78,30)
      VRR0(110,31)=3.D0*V(496)-3.D0*V(497)+V(498)+PAy*VRR0(78,31)+WPy*VRR1(78,31)
      VRR0(110,32)=3.D0*V(499)-3.D0*V(500)+2.D0*V(501)+PAy*VRR0(78,32)+WPy*VRR1(78,32)
      VRR0(110,33)=3.D0*V(502)-3.D0*V(503)+PAy*VRR0(78,33)+WPy*VRR1(78,33)
      VRR0(110,34)=3.D0*V(504)-3.D0*V(505)+V(506)+PAy*VRR0(78,34)+WPy*VRR1(78,34)
      VRR0(110,35)=3.D0*V(352)+3.D0*r1x2E*VRR0(110,10)+QCz*VRR0(110,20)-3.D0*r1x2E*ZxZpE*VRR1(110,10)+WQz*VRR1(110,20)
      VRR0(111,21)=3.D0*V(507)+3.D0*r1x2E*VRR0(111,5)+QCx*VRR0(111,11)-3.D0*r1x2E*ZxZpE*VRR1(111,5)+WQx*VRR1(111,11)
      VRR0(111,22)=3.D0*V(159)-3.D0*V(160)+PAz*VRR0(75,22)+WPz*VRR1(75,22)
      VRR0(111,23)=3.D0*V(161)-3.D0*V(162)+PAz*VRR0(75,23)+WPz*VRR1(75,23)
      VRR0(111,24)=3.D0*V(163)-3.D0*V(164)+PAz*VRR0(75,24)+WPz*VRR1(75,24)
      VRR0(111,25)=3.D0*r1x2E*VRR0(111,7)+QCy*VRR0(111,14)-3.D0*r1x2E*ZxZpE*VRR1(111,7)+WQy*VRR1(111,14)
      VRR0(111,26)=3.D0*V(166)-3.D0*V(167)+V(353)+PAz*VRR0(75,26)+WPz*VRR1(75,26)
      VRR0(111,27)=3.D0*V(168)-3.D0*V(169)+V(356)+PAz*VRR0(75,27)+WPz*VRR1(75,27)
      VRR0(111,28)=3.D0*V(170)-3.D0*V(171)+V(359)+PAz*VRR0(75,28)+WPz*VRR1(75,28)
      VRR0(111,29)=3.D0*V(172)-3.D0*V(173)+V(362)+PAz*VRR0(75,29)+WPz*VRR1(75,29)
      VRR0(111,30)=3.D0*V(174)-3.D0*V(175)+2.D0*V(365)+PAz*VRR0(75,30)+WPz*VRR1(75,30)
      VRR0(111,31)=3.D0*V(176)-3.D0*V(177)+V(369)+PAz*VRR0(75,31)+WPz*VRR1(75,31)
      VRR0(111,32)=3.D0*V(178)-3.D0*V(179)+2.D0*V(372)+PAz*VRR0(75,32)+WPz*VRR1(75,32)
      VRR0(111,33)=3.D0*V(180)-3.D0*V(181)+3.D0*V(377)+PAz*VRR0(75,33)+WPz*VRR1(75,33)
      VRR0(111,34)=3.D0*V(183)-3.D0*V(184)+3.D0*V(380)+PAz*VRR0(75,34)+WPz*VRR1(75,34)
      VRR0(111,35)=4.D0*V(385)+3.D0*r1x2E*VRR0(111,10)+QCz*VRR0(111,20)-3.D0*r1x2E*ZxZpE*VRR1(111,10)+WQz*VRR1(111,20)
      VRR0(112,21)=2.D0*V(508)+3.D0*r1x2E*VRR0(112,5)+QCx*VRR0(112,11)-3.D0*r1x2E*ZxZpE*VRR1(112,5)+WQx*VRR1(112,11)
      VRR0(112,22)=V(186)+V(188)+PAz*VRR0(76,22)+WPz*VRR1(76,22)
      VRR0(112,23)=V(190)+V(192)+PAz*VRR0(76,23)+WPz*VRR1(76,23)
      VRR0(112,24)=V(196)+V(198)+PAz*VRR0(76,24)+WPz*VRR1(76,24)
      VRR0(112,25)=V(509)+3.D0*r1x2E*VRR0(112,7)+QCy*VRR0(112,14)-3.D0*r1x2E*ZxZpE*VRR1(112,7)+WQy*VRR1(112,14)
      VRR0(112,26)=V(201)+V(203)+V(388)+PAz*VRR0(76,26)+WPz*VRR1(76,26)
      VRR0(112,27)=V(205)+V(207)+V(391)+PAz*VRR0(76,27)+WPz*VRR1(76,27)
      VRR0(112,28)=V(209)+V(211)+V(398)+PAz*VRR0(76,28)+WPz*VRR1(76,28)
      VRR0(112,29)=V(214)+V(216)+V(441)+PAz*VRR0(76,29)+WPz*VRR1(76,29)
      VRR0(112,30)=V(218)+V(220)+2.D0*V(402)+PAz*VRR0(76,30)+WPz*VRR1(76,30)
      VRR0(112,31)=V(223)+V(225)+V(410)+PAz*VRR0(76,31)+WPz*VRR1(76,31)
      VRR0(112,32)=V(228)+V(230)+V(450)+PAz*VRR0(76,32)+WPz*VRR1(76,32)
      VRR0(112,33)=V(232)+V(234)+3.D0*V(424)+PAz*VRR0(76,33)+WPz*VRR1(76,33)
      VRR0(112,34)=V(237)+V(239)+3.D0*V(429)+PAz*VRR0(76,34)+WPz*VRR1(76,34)
      VRR0(112,35)=3.D0*r1x2E*VRR0(112,10)+QCz*VRR0(112,20)+4.D0*HfxZpE*VRR1(76,20)-3.D0*r1x2E*ZxZpE*VRR1(112,10)+WQz*VRR1(112,20)
      VRR0(113,21)=V(510)+3.D0*r1x2E*VRR0(113,5)+QCx*VRR0(113,11)-3.D0*r1x2E*ZxZpE*VRR1(113,5)+WQx*VRR1(113,11)
      VRR0(113,22)=V(290)+V(292)+PAz*VRR0(77,22)+WPz*VRR1(77,22)
      VRR0(113,23)=V(293)+V(294)+PAz*VRR0(77,23)+WPz*VRR1(77,23)
      VRR0(113,24)=V(296)+V(298)+PAz*VRR0(77,24)+WPz*VRR1(77,24)
      VRR0(113,25)=2.D0*V(511)+3.D0*r1x2E*VRR0(113,7)+QCy*VRR0(113,14)-3.D0*r1x2E*ZxZpE*VRR1(113,7)+WQy*VRR1(113,14)
      VRR0(113,26)=V(300)+V(302)+V(434)+PAz*VRR0(77,26)+WPz*VRR1(77,26)
      VRR0(113,27)=V(303)+V(304)+V(437)+PAz*VRR0(77,27)+WPz*VRR1(77,27)
      VRR0(113,28)=V(305)+V(306)+V(459)+PAz*VRR0(77,28)+WPz*VRR1(77,28)
      VRR0(113,29)=V(308)+V(310)+V(460)+PAz*VRR0(77,29)+WPz*VRR1(77,29)
      VRR0(113,30)=V(311)+V(312)+V(445)+PAz*VRR0(77,30)+WPz*VRR1(77,30)
      VRR0(113,31)=V(313)+V(314)+V(467)+PAz*VRR0(77,31)+WPz*VRR1(77,31)
      VRR0(113,32)=V(316)+V(317)+2.D0*V(470)+PAz*VRR0(77,32)+WPz*VRR1(77,32)
      VRR0(113,33)=V(320)+V(322)+3.D0*V(473)+PAz*VRR0(77,33)+WPz*VRR1(77,33)
      VRR0(113,34)=V(324)+V(326)+3.D0*V(474)+PAz*VRR0(77,34)+WPz*VRR1(77,34)
      VRR0(113,35)=3.D0*r1x2E*VRR0(113,10)+QCz*VRR0(113,20)+4.D0*HfxZpE*VRR1(77,20)-3.D0*r1x2E*ZxZpE*VRR1(113,10)+WQz*VRR1(113,20)
      VRR0(114,21)=3.D0*r1x2E*VRR0(114,5)+QCx*VRR0(114,11)-3.D0*r1x2E*ZxZpE*VRR1(114,5)+WQx*VRR1(114,11)
      VRR0(114,22)=3.D0*V(328)-3.D0*V(329)+PAz*VRR0(78,22)+WPz*VRR1(78,22)
      VRR0(114,23)=3.D0*V(330)-3.D0*V(331)+PAz*VRR0(78,23)+WPz*VRR1(78,23)
      VRR0(114,24)=3.D0*V(332)-3.D0*V(333)+PAz*VRR0(78,24)+WPz*VRR1(78,24)
      VRR0(114,25)=3.D0*V(512)+3.D0*r1x2E*VRR0(114,7)+QCy*VRR0(114,14)-3.D0*r1x2E*ZxZpE*VRR1(114,7)+WQy*VRR1(114,14)
      VRR0(114,26)=3.D0*V(334)-3.D0*V(335)+V(453)+PAz*VRR0(78,26)+WPz*VRR1(78,26)
      VRR0(114,27)=3.D0*V(336)-3.D0*V(337)+V(456)+PAz*VRR0(78,27)+WPz*VRR1(78,27)
      VRR0(114,28)=3.D0*V(338)-3.D0*V(339)+V(481)+PAz*VRR0(78,28)+WPz*VRR1(78,28)
      VRR0(114,29)=3.D0*V(340)-3.D0*V(341)+V(482)+PAz*VRR0(78,29)+WPz*VRR1(78,29)
      VRR0(114,30)=3.D0*V(342)-3.D0*V(343)+2.D0*V(463)+PAz*VRR0(78,30)+WPz*VRR1(78,30)
      VRR0(114,31)=3.D0*V(344)-3.D0*V(345)+V(490)+PAz*VRR0(78,31)+WPz*VRR1(78,31)
      VRR0(114,32)=3.D0*V(346)-3.D0*V(347)+2.D0*V(493)+PAz*VRR0(78,32)+WPz*VRR1(78,32)
      VRR0(114,33)=3.D0*V(348)-3.D0*V(349)+3.D0*V(498)+PAz*VRR0(78,33)+WPz*VRR1(78,33)
      VRR0(114,34)=3.D0*V(350)-3.D0*V(351)+3.D0*V(501)+PAz*VRR0(78,34)+WPz*VRR1(78,34)
      VRR0(114,35)=4.D0*V(506)+3.D0*r1x2E*VRR0(114,10)+QCz*VRR0(114,20)-3.D0*r1x2E*ZxZpE*VRR1(114,10)+WQz*VRR1(114,20)
      VRR0(115,21)=4.D0*r1x2Z*VRR0(51,21)+PAz*VRR0(79,21)-4.D0*ExZpE*r1x2Z*VRR1(51,21)+WPz*VRR1(79,21)
      VRR0(115,22)=4.D0*V(354)-4.D0*V(355)+PAz*VRR0(79,22)+WPz*VRR1(79,22)
      VRR0(115,23)=4.D0*V(357)-4.D0*V(358)+PAz*VRR0(79,23)+WPz*VRR1(79,23)
      VRR0(115,24)=4.D0*V(360)-4.D0*V(361)+PAz*VRR0(79,24)+WPz*VRR1(79,24)
      VRR0(115,25)=4.D0*r1x2Z*VRR0(51,25)+PAz*VRR0(79,25)-4.D0*ExZpE*r1x2Z*VRR1(51,25)+WPz*VRR1(79,25)
      VRR0(115,26)=4.D0*V(363)-4.D0*V(364)+V(507)+PAz*VRR0(79,26)+WPz*VRR1(79,26)
      VRR0(115,27)=4.D0*V(366)-4.D0*V(367)+PAz*VRR0(79,27)+HfxZpE*VRR1(79,12)+WPz*VRR1(79,27)
      VRR0(115,28)=4.D0*V(370)-4.D0*V(371)+PAz*VRR0(79,28)+HfxZpE*VRR1(79,13)+WPz*VRR1(79,28)
      VRR0(115,29)=4.D0*V(373)-4.D0*V(374)+V(509)+PAz*VRR0(79,29)+WPz*VRR1(79,29)
      VRR0(115,30)=4.D0*V(375)-4.D0*V(376)+PAz*VRR0(79,30)+2.D0*HfxZpE*VRR1(79,15)+WPz*VRR1(79,30)
      VRR0(115,31)=4.D0*V(378)-4.D0*V(379)+PAz*VRR0(79,31)+2.D0*HfxZpE*VRR1(79,16)+WPz*VRR1(79,31)
      VRR0(115,32)=4.D0*V(381)-4.D0*V(382)+PAz*VRR0(79,32)+2.D0*HfxZpE*VRR1(79,17)+WPz*VRR1(79,32)
      VRR0(115,33)=4.D0*V(383)-4.D0*V(384)+PAz*VRR0(79,33)+3.D0*HfxZpE*VRR1(79,18)+WPz*VRR1(79,33)
      VRR0(115,34)=4.D0*V(386)-4.D0*V(387)+PAz*VRR0(79,34)+3.D0*HfxZpE*VRR1(79,19)+WPz*VRR1(79,34)
      VRR0(115,35)=4.D0*r1x2Z*VRR0(51,35)+PAz*VRR0(79,35)-4.D0*ExZpE*r1x2Z*VRR1(51,35)+4.D0*HfxZpE*VRR1(79,20)+WPz*VRR1(79,35)
      VRR0(116,21)=4.D0*r1x2Z*VRR0(52,21)+PAz*VRR0(80,21)-4.D0*ExZpE*r1x2Z*VRR1(52,21)+WPz*VRR1(80,21)
      VRR0(116,22)=4.D0*r1x2Z*VRR0(52,22)+PAz*VRR0(80,22)-4.D0*ExZpE*r1x2Z*VRR1(52,22)+WPz*VRR1(80,22)
      VRR0(116,23)=4.D0*V(394)-4.D0*V(396)+PAz*VRR0(80,23)+WPz*VRR1(80,23)
      VRR0(116,24)=4.D0*r1x2Z*VRR0(52,24)+PAz*VRR0(80,24)-4.D0*ExZpE*r1x2Z*VRR1(52,24)+WPz*VRR1(80,24)
      VRR0(116,25)=4.D0*r1x2Z*VRR0(52,25)+PAz*VRR0(80,25)-4.D0*ExZpE*r1x2Z*VRR1(52,25)+WPz*VRR1(80,25)
      VRR0(116,26)=V(508)+4.D0*r1x2Z*VRR0(52,26)+PAz*VRR0(80,26)-4.D0*ExZpE*r1x2Z*VRR1(52,26)+WPz*VRR1(80,26)
      VRR0(116,27)=4.D0*V(405)-4.D0*V(407)+PAz*VRR0(80,27)+HfxZpE*VRR1(80,12)+WPz*VRR1(80,27)
      VRR0(116,28)=4.D0*V(411)-4.D0*V(413)+PAz*VRR0(80,28)+HfxZpE*VRR1(80,13)+WPz*VRR1(80,28)
      VRR0(116,29)=V(511)+4.D0*r1x2Z*VRR0(52,29)+PAz*VRR0(80,29)-4.D0*ExZpE*r1x2Z*VRR1(52,29)+WPz*VRR1(80,29)
      VRR0(116,30)=4.D0*V(420)-4.D0*V(422)+PAz*VRR0(80,30)+2.D0*HfxZpE*VRR1(80,15)+WPz*VRR1(80,30)
      VRR0(116,31)=4.D0*V(425)-4.D0*V(427)+PAz*VRR0(80,31)+2.D0*HfxZpE*VRR1(80,16)+WPz*VRR1(80,31)
      VRR0(116,32)=4.D0*V(430)-4.D0*V(432)+PAz*VRR0(80,32)+2.D0*HfxZpE*VRR1(80,17)+WPz*VRR1(80,32)
      VRR0(116,33)=4.D0*r1x2Z*VRR0(52,33)+PAz*VRR0(80,33)-4.D0*ExZpE*r1x2Z*VRR1(52,33)+3.D0*HfxZpE*VRR1(80,18)+WPz*VRR1(80,33)
      VRR0(116,34)=4.D0*r1x2Z*VRR0(52,34)+PAz*VRR0(80,34)-4.D0*ExZpE*r1x2Z*VRR1(52,34)+3.D0*HfxZpE*VRR1(80,19)+WPz*VRR1(80,34)
      VRR0(116,35)=4.D0*r1x2Z*VRR0(52,35)+PAz*VRR0(80,35)-4.D0*ExZpE*r1x2Z*VRR1(52,35)+4.D0*HfxZpE*VRR1(80,20)+WPz*VRR1(80,35)
      VRR0(117,21)=4.D0*r1x2Z*VRR0(53,21)+PAz*VRR0(81,21)-4.D0*ExZpE*r1x2Z*VRR1(53,21)+WPz*VRR1(81,21)
      VRR0(117,22)=4.D0*V(475)-4.D0*V(476)+PAz*VRR0(81,22)+WPz*VRR1(81,22)
      VRR0(117,23)=4.D0*V(477)-4.D0*V(478)+PAz*VRR0(81,23)+WPz*VRR1(81,23)
      VRR0(117,24)=4.D0*V(479)-4.D0*V(480)+PAz*VRR0(81,24)+WPz*VRR1(81,24)
      VRR0(117,25)=4.D0*r1x2Z*VRR0(53,25)+PAz*VRR0(81,25)-4.D0*ExZpE*r1x2Z*VRR1(53,25)+WPz*VRR1(81,25)
      VRR0(117,26)=4.D0*V(483)-4.D0*V(484)+V(510)+PAz*VRR0(81,26)+WPz*VRR1(81,26)
      VRR0(117,27)=4.D0*V(485)-4.D0*V(486)+PAz*VRR0(81,27)+HfxZpE*VRR1(81,12)+WPz*VRR1(81,27)
      VRR0(117,28)=4.D0*V(487)-4.D0*V(488)+PAz*VRR0(81,28)+HfxZpE*VRR1(81,13)+WPz*VRR1(81,28)
      VRR0(117,29)=4.D0*V(491)-4.D0*V(492)+V(512)+PAz*VRR0(81,29)+WPz*VRR1(81,29)
      VRR0(117,30)=4.D0*V(494)-4.D0*V(495)+PAz*VRR0(81,30)+2.D0*HfxZpE*VRR1(81,15)+WPz*VRR1(81,30)
      VRR0(117,31)=4.D0*V(496)-4.D0*V(497)+PAz*VRR0(81,31)+2.D0*HfxZpE*VRR1(81,16)+WPz*VRR1(81,31)
      VRR0(117,32)=4.D0*V(499)-4.D0*V(500)+PAz*VRR0(81,32)+2.D0*HfxZpE*VRR1(81,17)+WPz*VRR1(81,32)
      VRR0(117,33)=4.D0*V(502)-4.D0*V(503)+PAz*VRR0(81,33)+3.D0*HfxZpE*VRR1(81,18)+WPz*VRR1(81,33)
      VRR0(117,34)=4.D0*V(504)-4.D0*V(505)+PAz*VRR0(81,34)+3.D0*HfxZpE*VRR1(81,19)+WPz*VRR1(81,34)
      VRR0(117,35)=4.D0*r1x2Z*VRR0(53,35)+PAz*VRR0(81,35)-4.D0*ExZpE*r1x2Z*VRR1(53,35)+4.D0*HfxZpE*VRR1(81,20)+WPz*VRR1(81,35)
      VRR0(118,21)=5.D0*r1x2Z*VRR0(54,21)+PAz*VRR0(82,21)-5.D0*ExZpE*r1x2Z*VRR1(54,21)+WPz*VRR1(82,21)
      VRR0(118,22)=5.D0*r1x2Z*VRR0(54,22)+PAz*VRR0(82,22)-5.D0*ExZpE*r1x2Z*VRR1(54,22)+WPz*VRR1(82,22)
      VRR0(118,23)=5.D0*r1x2Z*VRR0(54,23)+PAz*VRR0(82,23)-5.D0*ExZpE*r1x2Z*VRR1(54,23)+WPz*VRR1(82,23)
      VRR0(118,24)=5.D0*r1x2Z*VRR0(54,24)+PAz*VRR0(82,24)-5.D0*ExZpE*r1x2Z*VRR1(54,24)+WPz*VRR1(82,24)
      VRR0(118,25)=5.D0*r1x2Z*VRR0(54,25)+PAz*VRR0(82,25)-5.D0*ExZpE*r1x2Z*VRR1(54,25)+WPz*VRR1(82,25)
      VRR0(118,26)=5.D0*r1x2Z*VRR0(54,26)+PAz*VRR0(82,26)-5.D0*ExZpE*r1x2Z*VRR1(54,26)+HfxZpE*VRR1(82,11)+WPz*VRR1(82,26)
      VRR0(118,27)=5.D0*r1x2Z*VRR0(54,27)+PAz*VRR0(82,27)-5.D0*ExZpE*r1x2Z*VRR1(54,27)+HfxZpE*VRR1(82,12)+WPz*VRR1(82,27)
      VRR0(118,28)=5.D0*r1x2Z*VRR0(54,28)+PAz*VRR0(82,28)-5.D0*ExZpE*r1x2Z*VRR1(54,28)+HfxZpE*VRR1(82,13)+WPz*VRR1(82,28)
      VRR0(118,29)=5.D0*r1x2Z*VRR0(54,29)+PAz*VRR0(82,29)-5.D0*ExZpE*r1x2Z*VRR1(54,29)+HfxZpE*VRR1(82,14)+WPz*VRR1(82,29)
      VRR0(118,30)=5.D0*r1x2Z*VRR0(54,30)+PAz*VRR0(82,30)-5.D0*ExZpE*r1x2Z*VRR1(54,30)+2.D0*HfxZpE*VRR1(82,15)+WPz*VRR1(82,30)
      VRR0(118,31)=5.D0*r1x2Z*VRR0(54,31)+PAz*VRR0(82,31)-5.D0*ExZpE*r1x2Z*VRR1(54,31)+2.D0*HfxZpE*VRR1(82,16)+WPz*VRR1(82,31)
      VRR0(118,32)=5.D0*r1x2Z*VRR0(54,32)+PAz*VRR0(82,32)-5.D0*ExZpE*r1x2Z*VRR1(54,32)+2.D0*HfxZpE*VRR1(82,17)+WPz*VRR1(82,32)
      VRR0(118,33)=5.D0*r1x2Z*VRR0(54,33)+PAz*VRR0(82,33)-5.D0*ExZpE*r1x2Z*VRR1(54,33)+3.D0*HfxZpE*VRR1(82,18)+WPz*VRR1(82,33)
      VRR0(118,34)=5.D0*r1x2Z*VRR0(54,34)+PAz*VRR0(82,34)-5.D0*ExZpE*r1x2Z*VRR1(54,34)+3.D0*HfxZpE*VRR1(82,19)+WPz*VRR1(82,34)
      VRR0(118,35)=5.D0*r1x2Z*VRR0(54,35)+PAz*VRR0(82,35)-5.D0*ExZpE*r1x2Z*VRR1(54,35)+4.D0*HfxZpE*VRR1(82,20)+WPz*VRR1(82,35)
      VRR0(119,21)=5.D0*r1x2Z*VRR0(55,21)+PAz*VRR0(83,21)-5.D0*ExZpE*r1x2Z*VRR1(55,21)+WPz*VRR1(83,21)
      VRR0(119,22)=5.D0*r1x2Z*VRR0(55,22)+PAz*VRR0(83,22)-5.D0*ExZpE*r1x2Z*VRR1(55,22)+WPz*VRR1(83,22)
      VRR0(119,23)=5.D0*r1x2Z*VRR0(55,23)+PAz*VRR0(83,23)-5.D0*ExZpE*r1x2Z*VRR1(55,23)+WPz*VRR1(83,23)
      VRR0(119,24)=5.D0*r1x2Z*VRR0(55,24)+PAz*VRR0(83,24)-5.D0*ExZpE*r1x2Z*VRR1(55,24)+WPz*VRR1(83,24)
      VRR0(119,25)=5.D0*r1x2Z*VRR0(55,25)+PAz*VRR0(83,25)-5.D0*ExZpE*r1x2Z*VRR1(55,25)+WPz*VRR1(83,25)
      VRR0(119,26)=5.D0*r1x2Z*VRR0(55,26)+PAz*VRR0(83,26)-5.D0*ExZpE*r1x2Z*VRR1(55,26)+HfxZpE*VRR1(83,11)+WPz*VRR1(83,26)
      VRR0(119,27)=5.D0*r1x2Z*VRR0(55,27)+PAz*VRR0(83,27)-5.D0*ExZpE*r1x2Z*VRR1(55,27)+HfxZpE*VRR1(83,12)+WPz*VRR1(83,27)
      VRR0(119,28)=5.D0*r1x2Z*VRR0(55,28)+PAz*VRR0(83,28)-5.D0*ExZpE*r1x2Z*VRR1(55,28)+HfxZpE*VRR1(83,13)+WPz*VRR1(83,28)
      VRR0(119,29)=5.D0*r1x2Z*VRR0(55,29)+PAz*VRR0(83,29)-5.D0*ExZpE*r1x2Z*VRR1(55,29)+HfxZpE*VRR1(83,14)+WPz*VRR1(83,29)
      VRR0(119,30)=5.D0*r1x2Z*VRR0(55,30)+PAz*VRR0(83,30)-5.D0*ExZpE*r1x2Z*VRR1(55,30)+2.D0*HfxZpE*VRR1(83,15)+WPz*VRR1(83,30)
      VRR0(119,31)=5.D0*r1x2Z*VRR0(55,31)+PAz*VRR0(83,31)-5.D0*ExZpE*r1x2Z*VRR1(55,31)+2.D0*HfxZpE*VRR1(83,16)+WPz*VRR1(83,31)
      VRR0(119,32)=5.D0*r1x2Z*VRR0(55,32)+PAz*VRR0(83,32)-5.D0*ExZpE*r1x2Z*VRR1(55,32)+2.D0*HfxZpE*VRR1(83,17)+WPz*VRR1(83,32)
      VRR0(119,33)=5.D0*r1x2Z*VRR0(55,33)+PAz*VRR0(83,33)-5.D0*ExZpE*r1x2Z*VRR1(55,33)+3.D0*HfxZpE*VRR1(83,18)+WPz*VRR1(83,33)
      VRR0(119,34)=5.D0*r1x2Z*VRR0(55,34)+PAz*VRR0(83,34)-5.D0*ExZpE*r1x2Z*VRR1(55,34)+3.D0*HfxZpE*VRR1(83,19)+WPz*VRR1(83,34)
      VRR0(119,35)=5.D0*r1x2Z*VRR0(55,35)+PAz*VRR0(83,35)-5.D0*ExZpE*r1x2Z*VRR1(55,35)+4.D0*HfxZpE*VRR1(83,20)+WPz*VRR1(83,35)
      VRR0(120,21)=6.D0*r1x2Z*VRR0(56,21)+PAz*VRR0(84,21)-6.D0*ExZpE*r1x2Z*VRR1(56,21)+WPz*VRR1(84,21)
      VRR0(120,22)=6.D0*r1x2Z*VRR0(56,22)+PAz*VRR0(84,22)-6.D0*ExZpE*r1x2Z*VRR1(56,22)+WPz*VRR1(84,22)
      VRR0(120,23)=6.D0*r1x2Z*VRR0(56,23)+PAz*VRR0(84,23)-6.D0*ExZpE*r1x2Z*VRR1(56,23)+WPz*VRR1(84,23)
      VRR0(120,24)=6.D0*r1x2Z*VRR0(56,24)+PAz*VRR0(84,24)-6.D0*ExZpE*r1x2Z*VRR1(56,24)+WPz*VRR1(84,24)
      VRR0(120,25)=6.D0*r1x2Z*VRR0(56,25)+PAz*VRR0(84,25)-6.D0*ExZpE*r1x2Z*VRR1(56,25)+WPz*VRR1(84,25)
      VRR0(120,26)=6.D0*r1x2Z*VRR0(56,26)+PAz*VRR0(84,26)-6.D0*ExZpE*r1x2Z*VRR1(56,26)+HfxZpE*VRR1(84,11)+WPz*VRR1(84,26)
      VRR0(120,27)=6.D0*r1x2Z*VRR0(56,27)+PAz*VRR0(84,27)-6.D0*ExZpE*r1x2Z*VRR1(56,27)+HfxZpE*VRR1(84,12)+WPz*VRR1(84,27)
      VRR0(120,28)=6.D0*r1x2Z*VRR0(56,28)+PAz*VRR0(84,28)-6.D0*ExZpE*r1x2Z*VRR1(56,28)+HfxZpE*VRR1(84,13)+WPz*VRR1(84,28)
      VRR0(120,29)=6.D0*r1x2Z*VRR0(56,29)+PAz*VRR0(84,29)-6.D0*ExZpE*r1x2Z*VRR1(56,29)+HfxZpE*VRR1(84,14)+WPz*VRR1(84,29)
      VRR0(120,30)=6.D0*r1x2Z*VRR0(56,30)+PAz*VRR0(84,30)-6.D0*ExZpE*r1x2Z*VRR1(56,30)+2.D0*HfxZpE*VRR1(84,15)+WPz*VRR1(84,30)
      VRR0(120,31)=6.D0*r1x2Z*VRR0(56,31)+PAz*VRR0(84,31)-6.D0*ExZpE*r1x2Z*VRR1(56,31)+2.D0*HfxZpE*VRR1(84,16)+WPz*VRR1(84,31)
      VRR0(120,32)=6.D0*r1x2Z*VRR0(56,32)+PAz*VRR0(84,32)-6.D0*ExZpE*r1x2Z*VRR1(56,32)+2.D0*HfxZpE*VRR1(84,17)+WPz*VRR1(84,32)
      VRR0(120,33)=6.D0*r1x2Z*VRR0(56,33)+PAz*VRR0(84,33)-6.D0*ExZpE*r1x2Z*VRR1(56,33)+3.D0*HfxZpE*VRR1(84,18)+WPz*VRR1(84,33)
      VRR0(120,34)=6.D0*r1x2Z*VRR0(56,34)+PAz*VRR0(84,34)-6.D0*ExZpE*r1x2Z*VRR1(56,34)+3.D0*HfxZpE*VRR1(84,19)+WPz*VRR1(84,34)
      VRR0(120,35)=6.D0*r1x2Z*VRR0(56,35)+PAz*VRR0(84,35)-6.D0*ExZpE*r1x2Z*VRR1(56,35)+4.D0*HfxZpE*VRR1(84,20)+WPz*VRR1(84,35)
END SUBROUTINE VRRj0g0
