/*
   (C) 2005 Anand Avati <avati@zresearch.com>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free
   Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301 USA
*/

#include <stdlib.h>
#include <guile/gh.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "freetalk.h"
#include "roster.h"
#include "primitives.h"

SCM ex_message_receive_hook;
SCM ex_message_send_hook;
SCM ex_presence_receive_hook;
SCM ex_subscribe_receive_hook;
SCM ex_disconnect_hook;
SCM ex_command_hook;
SCM ex_login_hook;

int hook_return = 0;

int
get_hook_return (void)
{
  return hook_return;
}

void
set_hook_return (int hook_return_value)
{
  hook_return = hook_return_value;
}

void ft_load (const char *file)
{
  char *path;
  struct stat foo;
  int len;

  /* ladies first */
  if (stat (file, &foo) == 0) {
    gh_load (file);
    return;
  }

  len = strlen (getenv ("HOME")) + 1 + strlen (FT_LOCAL_EXT_DIR) + 1 + strlen (file) + 1;
  path = calloc (len, 1);
  sprintf (path, "%s/%s/%s", getenv ("HOME"), FT_LOCAL_EXT_DIR, file);
  if (stat (path, &foo) == 0) {
    gh_load (path);
    free (path);
    return;
  }
  free (path);

  len = strlen (FT_GLOBAL_EXT_DIR) + 1 + strlen (file) + 1;
  path = calloc (len, 1);
  sprintf (path, "%s/%s", FT_GLOBAL_EXT_DIR, file);
  if (stat (path, &foo) == 0) {
    gh_load (path);
    free (path);
    return;
  }
  free (path);

  fprintf (stderr, "%s: not found\n", file);
}

static void
register_hooks ()
{
  ex_message_receive_hook = scm_create_hook ("ft-message-receive-hook", 3);
  ex_message_send_hook = scm_create_hook ("ft-message-send-hook", 2);
  ex_presence_receive_hook = scm_create_hook ("ft-presence-receive-hook", 5);
  ex_subscribe_receive_hook = scm_create_hook ("ft-subscribe-receive-hook", 1);
  ex_disconnect_hook = scm_create_hook ("ft-disconnect-hook", 1);
  ex_command_hook = scm_create_hook ("ft-command-hook", 2);
  ex_login_hook = scm_create_hook ("ft-login-hook", 1);
}

static void
register_primitives ()
{
  gh_new_procedure ("ft-load", ex_load, 1, 0, 0);

  gh_new_procedure ("ft-get-jid", ex_get_jid, 0, 0, 0);
  gh_new_procedure ("ft-set-jid!", ex_set_jid, 1, 0, 0);

  gh_new_procedure ("ft-get-server", ex_get_server, 0, 0, 0);
  gh_new_procedure ("ft-set-server!", ex_set_server, 1, 0, 0);

  gh_new_procedure ("ft-get-password", ex_get_password, 0, 0, 0);
  gh_new_procedure ("ft-set-password!", ex_set_password, 1, 0, 0);

  gh_new_procedure ("ft-get-sslconn?", ex_get_sslconn, 0, 0, 0);
  gh_new_procedure ("ft-set-sslconn!", ex_set_sslconn, 1, 0, 0);

  gh_new_procedure ("ft-connect", ex_connect, 0, 0, 0);
  gh_new_procedure ("ft-disconnect", ex_disconnect, 0, 0, 0);

  gh_new_procedure ("ft-send-message", ex_send_message, 2, 0, 0);
  gh_new_procedure ("ft-send-message-no-hook", ex_send_message_no_hook, 2, 0, 0);

  gh_new_procedure ("ft-set-daemon", ex_set_daemon, 0, 0, 0);
  gh_new_procedure ("ft-get-daemon", ex_get_daemon, 0, 0, 0);

  gh_new_procedure ("ft-get-port", ex_get_port, 0, 0, 0);
  gh_new_procedure ("ft-set-port!", ex_set_port, 1, 0, 0);

  gh_new_procedure ("ft-get-prompt", ex_get_prompt, 0, 0, 0);
  gh_new_procedure ("ft-set-prompt!", ex_set_prompt, 1, 0, 0);

  gh_new_procedure ("ft-display", ex_display, 1, 0, 0);

  gh_new_procedure ("ft-get-conn-status", ex_get_conn_status, 0, 0, 0);

  gh_new_procedure ("ft-add-buddy!", ex_add_buddy, 1, 0, 0);
  gh_new_procedure ("ft-remove-buddy!", ex_remove_buddy, 1, 0, 0);
  gh_new_procedure ("ft-get-roster-list", ex_get_roster_list, 0, 0, 0);
  gh_new_procedure ("ft-get-roster-status-msg", ex_get_roster_status_msg, 1, 0, 0);
  gh_new_procedure ("ft-get-roster-is-online", ex_get_roster_is_online, 1, 0, 0);
  gh_new_procedure ("ft-roster-lookup", ex_roster_lookup, 1, 0, 0);
  gh_new_procedure ("ft-subscription-allow", ex_subscription_allow, 1, 0, 0);
  gh_new_procedure ("ft-subscription-deny", ex_subscription_deny, 1, 0, 0);
  
  /* Return immediately after the hook procedure returns */
  gh_new_procedure ("ft-hook-return", ex_hook_return, 0, 0, 0);
  /* syntax: (ft-hook-return)
  */

  gh_new_procedure ("ft-get-current-buddy", ex_get_current_buddy, 0, 0, 0);
  gh_new_procedure ("ft-set-current-buddy!", ex_set_current_buddy, 1, 0, 0);

  gh_new_procedure ("ft-get-status-msg", ex_get_status_msg, 0, 0, 0);
  gh_new_procedure ("ft-set-status-msg!", ex_set_status_msg, 1, 0, 0);

  gh_new_procedure ("ft-reset-fs-state!", ex_reset_fs_state, 0, 0, 0);

  gh_new_procedure ("ft-dict-append!", ex_dict_append, 1, 0, 0);
  gh_new_procedure ("ft-dict-prepend!", ex_dict_prepend, 1, 0, 0);
  gh_new_procedure ("ft-dict-insert!", ex_dict_prepend, 1, 0, 0);
  gh_new_procedure ("ft-dict-remove!", ex_dict_remove, 1, 0, 0);

  gh_new_procedure ("ft-version", ex_version, 0, 0, 0);

  gh_new_procedure ("ft-login-blocking", ex_login_blocking, 0, 0, 0);

  gh_new_procedure ("ft-cli-on", ex_cli_on, 0, 0, 0);

  gh_new_procedure ("ft-main-loop", ex_main_loop, 0, 0, 0);

  gh_new_procedure ("ft-load-default-config", ex_load_default_config, 0, 0, 0);

  gh_new_procedure ("ft-get-config-dir", ex_get_config_dir, 0, 0, 0);
}

void
extensions_init (void)
{
  register_hooks ();
  register_primitives ();
}

void
load_default_config (void)
{
  int len;
  char *file;
  struct stat foo;

  len = strlen (getenv ("HOME")) + 1 + strlen (FT_CONFIG_SCM) + 1;
  file = calloc (len, 1);

  sprintf (file, "%s/%s", getenv ("HOME"), FT_CONFIG_SCM);

  if (stat (file, &foo) == 0) {
    gh_load (file);
  }

  free (file);
}
