/*  forward_propagation.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int forward_propagation(int num_neuron, struct neuron ** neuron_array, int num_elem_input, 
								float threshold_level)
{
	int k,l,m;
	double value;
	float con_x, con_y;
	float x_c,y_c;
	for ( k=num_elem_input; k<num_neuron ; k++ )
	{
		value=neuron_array[k]->bias;
		for (l=0; l<neuron_array[k]->num_con; l++)
		{
			con_x=*(neuron_array[k]->con_x+l);
			con_y=*(neuron_array[k]->con_y+l);
			
			for(m=k-1; m+1; m--)
			{
				if( (con_x > neuron_array[m]->x_c - 0.01/num_neuron) &&
								(con_x < neuron_array[m]->x_c + 0.01/num_neuron) &&
								(con_y > neuron_array[m]->y_c - 0.01*neuron_array[k]->range) &&
				    (con_y < neuron_array[m]->y_c + 0.01*neuron_array[k]->range) )
					{	
						break;
					}
			}
//			syslog(LOG_INFO,"neuron=%d connection=%d to neuron=%d",k,l,m);
//			syslog(LOG_INFO,"con_x=%f con_y=%f con_w=%f", *(neuron_array[k]->con_x+l),
//											*(neuron_array[k]->con_y+l),		*(neuron_array[k]->con_w+l));
			value += *(neuron_array[k]->con_w+l)*(neuron_array[m]->value);
		}
		neuron_array[k]->value = threshold(neuron_array[k]->delta_type,value, threshold_level);
	}
	return(1);	
}
