/*  fwrite_neuron_array.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int fwrite_neuron_array(int num_neuron, struct neuron ** neuron_array, 
							const char *filename)
{
	FILE * file_ptr;
	int k,l,num_con;
	
	unlink(filename);
	if( (file_ptr=fopen(filename,"w")) == NULL)
	{
		syslog(LOG_CRIT,"Couldn't open %s: &s",filename,strerror(errno));
		return(-1);
	}
	
	sprintf(char_buffer,"neuron_array\n");
	fputs(char_buffer,file_ptr);
	sprintf(char_buffer,"num_neuron=%d\n",num_neuron);
	fputs(char_buffer,file_ptr);

	for (k=0;k<num_neuron; k++)
	{
		sprintf(char_buffer,"neuron %d\n",k);
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"alpha=%f\n",neuron_array[k]->alpha);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"conv_rate=%f\n",neuron_array[k]->conv_rate);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"bias_corr=%d\n",neuron_array[k]->bias_corr);	
		fputs(char_buffer,file_ptr);
		
		sprintf(char_buffer,"delta_type=%d\n",neuron_array[k]->delta_type);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"momentum=%d\n",neuron_array[k]->momentum);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"x_c=%1.15f\n",neuron_array[k]->x_c);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"y_c=%1.15f\n",neuron_array[k]->y_c);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"range=%1.15f\n",neuron_array[k]->range);	
		fputs(char_buffer,file_ptr);

		num_con=neuron_array[k]->num_con;
		sprintf(char_buffer,"num_con=%d\n",num_con);	
		fputs(char_buffer,file_ptr);
		
		sprintf(char_buffer,"bias=%f\n",neuron_array[k]->bias);	
		fputs(char_buffer,file_ptr);
		
		for (l=0;l<num_con;l++)
		{
		sprintf(char_buffer,"%1.15f:%1.15f:%3.9f:%d\n",*(neuron_array[k]->con_x+l),
					*(neuron_array[k]->con_y+l),*(neuron_array[k]->con_w+l),*(neuron_array[k]->age+l));	
		fputs(char_buffer,file_ptr);
//		syslog(LOG_INFO,char_buffer);
		}
		fputc('\n',file_ptr);
	}
	fclose(file_ptr);
	return 1;
}
