/*  isolate_region.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* remove connections comming between inner an outer regions */
int isolate_region(int num_neuron, struct neuron **neuron_array, int * inner_elem)
{
	int k,l,m;
	int num_con;
	int counter;
	int diff;
	float temp1;
	double temp2;

	int *pathfinder;
	int *age;
	float *con_x;
	float *con_y;
	double *con_w;
	double *delta_con_w;
	
	char char_temp[BUFFSIZE];
	
	if ( !(con_x = (float *)malloc(sizeof(float)) ))
	{
		return(-20);
	}
	if ( !(con_y = (float *)malloc(sizeof(float)) ))
	{
		return(-21);
	}
	if ( !(con_w = (double *)malloc(sizeof(double)) ))
	{
		return(-22);
	}
	if ( !(age = (int *)malloc(sizeof(int)) ))
	{
		return(-23);
	}

	if ( !(delta_con_w = (double *)malloc(sizeof(double)) ))
	{
		return(-24);
	}
	
	if ( !(pathfinder = (int *)malloc(sizeof(int)) ))
	{
		return(-24);
	}
	
	for (k=0; k < num_neuron; k++)
	{
		num_con=neuron_array[k]->num_con;

		if (num_con)
		{
			if ( !(pathfinder = (int *)realloc(pathfinder,num_con*sizeof(int)) ))
			{
				syslog(LOG_CRIT,"Realloc pathfinder fail %d",k);
				return(-31);
			}
			bzero(pathfinder,num_con*sizeof(int));
		}

		if ( !( *(inner_elem+k) ) ) //outter element
		{
			for (l=0; l < num_con; l++)
			{
				for (m=0; m < num_neuron; m++)
				{
					if ( 	( *(inner_elem+m) ) &&
								(neuron_array[m]->x_c == *(neuron_array[k]->con_x+l)) &&
								(neuron_array[m]->y_c == *(neuron_array[k]->con_y+l)) )
					{
//						counter -= 1;
						pathfinder[l] = 1;
						break;
					} 
				}
			}
		}
		else //inner element
		{
			for (l=0; l < num_con; l++)
			{
				for (m=0; m < num_neuron; m++)
				{
					if ( 	( !(*(inner_elem+m)) ) &&
								(neuron_array[m]->x_c == *(neuron_array[k]->con_x+l)) &&
								(neuron_array[m]->y_c == *(neuron_array[k]->con_y+l)) )
					{
//						counter-= 1;
						pathfinder[l] = 1;
						break;
					} 
				}
			}
		}

		counter=num_con;			//required for memory bug
		for (l=0; l<num_con; l++)
		{
			counter -= pathfinder[l];
		}

		diff=num_con-counter;

//Temporary record 
//num_con > 0 => hidden/output layer
//diff > 0  && counter > 0 => number of connections changed but != 0
		if ( (num_con) && (diff) && (counter) ) 
		{
			neuron_array[k]->num_con = counter;
			
			if ( !(con_x = (float *)realloc(con_x,counter*sizeof(float)) ))
			{
				return(-40);
			}
			if ( !(con_y = (float *)realloc(con_y,counter*sizeof(float)) ))
			{
				return(-41);
			}
			if ( !(con_w = (double *)realloc(con_w,counter*sizeof(double)) ))
			{
				return(-42);
			}
			if ( !(age = (int *)realloc(age,counter*sizeof(int)) ))
			{
				return(-43);
			}
			
			if (neuron_array[k]->momentum == 1)
			{
				if ( !(delta_con_w = (double *)realloc(delta_con_w,counter*sizeof(double)) ))
				{
					return(-44);
				}
			}
//			syslog(LOG_INFO,"Realloc of buffer passed");

			l=0;
			
			for (m=0; m < num_con; m++)
			{
				if (!pathfinder[m])
				{
					*(con_x+l)=*(neuron_array[k]->con_x+m);
					*(con_y+l)=*(neuron_array[k]->con_y+m);
					*(con_w+l)=*(neuron_array[k]->con_w+m);
					*(age + l)=*(neuron_array[k]->age + m);
					
					if (neuron_array[k]->momentum == 1)
					{
						*(delta_con_w+l)=*(neuron_array[k]->delta_con_w+m);
					}
//					syslog(LOG_INFO,"neuron=%d l=%d counter=%d",k,l,counter);
					l++;
				}
			}
// Resizing connections 
/************************** Passed ************************/					
//			syslog(LOG_INFO,"Realloc neuron buffers %d",k);
			
			if ( !(neuron_array[k]->con_x = (float *)realloc
						(neuron_array[k]->con_x,counter*sizeof(float)) ))
			{
				return(-50);
			}
			if ( !(neuron_array[k]->con_y = (float *)realloc
						(neuron_array[k]->con_y,counter*sizeof(float)) ))
			{
				return(-51);
			}
			if ( !(neuron_array[k]->con_w = (double *)realloc
						(neuron_array[k]->con_w,counter*sizeof(double)) ))
			{
				return(-52);
			}
			if ( !(neuron_array[k]->age = (int *)realloc
						(neuron_array[k]->age,counter*sizeof(int)) ))
			{
				return(-53);
			}

			if (neuron_array[k]->momentum == 1)
			{
				if ( !(neuron_array[k]->delta_con_w = (double *)realloc
							(neuron_array[k]->delta_con_w,counter*sizeof(double)) ))
				{
					return(-54);
				}
			}
			
//			syslog(LOG_INFO,"Realloc neuron buffers completed");
			
// Restoring values 
			for (l=0; l<counter; l++)
			{
				*(neuron_array[k]->con_x+l)=con_x[l];
				*(neuron_array[k]->con_y+l)=con_y[l];
				*(neuron_array[k]->con_w+l)=con_w[l];
				*(neuron_array[k]->age + l)=age[l];
				if (neuron_array[k]->momentum == 1)
				{
					*(neuron_array[k]->delta_con_w+l)=delta_con_w[l];
				}
			}
//			syslog(LOG_INFO,"neuron=%d counter=%d num_neuron=%d num_con=%d",
//							k,counter,num_neuron,num_con);
		}
		else if ( (num_con) && (!counter) ) //no connections remain
		{
			neuron_array[k]->num_con = 0;
			free(neuron_array[k]->con_x);
			free(neuron_array[k]->con_y);
			free(neuron_array[k]->con_w);
			free(neuron_array[k]->age);
			free(neuron_array[k]->delta_con_w);
			
			neuron_array[k]->con_x = NULL;
			neuron_array[k]->con_y = NULL;
			neuron_array[k]->con_w = NULL;
			neuron_array[k]->age = NULL;
			neuron_array[k]->delta_con_w = NULL;
		}
	}
	free(con_x);
	free(con_y);
	free(con_w);
	free(age);
	free(delta_con_w);
	free(pathfinder);
	
	return(1);
}
