/*  nn.c */
/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*****************************************/
/*argc=4
/*argv=name conf_file neuron_array_init neuron_array_result
/*About mode: 0 = production slave (test mode for ga_client)
/*						1 = training
/*						2 = production
/*****************************************/


int main(int argc, char * argv[])
{
int k,l,m,num_neuron,num_pat;
int num_input, num_output;
int mode;

float * input_buffer;
float * output_buffer;

char char_buffer[BUFFSIZE];
char input_preffix[BUFFSIZE];
char output_preffix[BUFFSIZE];

struct nn_config conf;
struct neuron **test_neuron;

float range;
float Error,max_error;

if (argc < 3)
{
	printf("Incorrect number of parameters\n");
	printf("For train / slave mode use:\n");
	printf("%s config_file neuron_array_init neuron_array_result\n\n",argv[0]);
	printf("For production use:\n");
	printf("%s config_file neuron_array_init\n",argv[0]);

	return(1);
}

openlog("nn",LOG_PID,LOG_LOCAL2);

if (load_nn_config(&conf,argv[1])<0)
{
	syslog(LOG_CRIT,"Error load config file: %s",strerror(errno));
	return(1);
}

num_pat=conf.num_pat;
num_input=conf.num_input;
num_output=conf.num_output;
mode=conf.mode;

if ((argc == 3) && (mode != 2) )
{
	printf("Incorrect number of parameters\nFor production use:\n");
	printf("%s config_file neuron_array_init\n",argv[0]);
	return(1);
}

syslog(LOG_INFO,"num_pat=%d num_input=%d num_output=%d mode=%d",num_pat,num_input,
			num_output,mode);

for (k=0;k<BUFFSIZE;k++)
{
	if (('\n'==conf.input_preffix[k]))
	{
		conf.input_preffix[k]='\0';
	}
	if (('\n'==conf.output_preffix[k]))
	{
		conf.output_preffix[k]='\0';
	}
}

if (! (input_buffer=(float *)calloc(num_input,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc input_buffer");
	return(1);
}

if (! (output_buffer=(float *)calloc(num_output,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc output_buffer");
	return(1);
}

if ( (num_neuron=load_num_neuron(argv[2])) < 1 )
{
	syslog(LOG_CRIT,"Couldn't get number of neurons");
	return(1);
}

if(!( test_neuron=(struct neuron **)calloc(num_neuron,sizeof(struct neuron *)) ))
{
	syslog(LOG_CRIT,"Error calloc test_neuron: %s",strerror(errno));
	return(2);
}
for (k=0; k<num_neuron ;k++)
{
	if(!( test_neuron[k]=(struct neuron *)calloc(1,sizeof(struct neuron)) ))
	{
		syslog(LOG_CRIT,"Error calloc test_neuron[%d]\n: %s",k,strerror(errno));
		return(2);
	}
}

if (load_neuron_array(num_neuron,test_neuron,argv[2]) != 1)
{
	syslog(LOG_CRIT,"Error load_neuron_array");
	return(2);
}
/*
if (verify_connections(num_neuron,test_neuron))
{
	syslog(LOG_INFO,"Some connections lost");
}
*/
sort_neuron_array(num_neuron,test_neuron);

for (k=0; k< num_neuron; k++)
{
	sort_neuron_connections(test_neuron[k]);
}


if (mode == 0)
{
	if( (m=open(argv[3],O_WRONLY, 0)) <0)
	{
		syslog(LOG_CRIT,"Error openning %s: %s",argv[3],strerror(errno));
		return(1);
	}
}

for (k=0; k<num_pat; k++)
{
	sprintf(char_buffer,"%s%d",conf.input_preffix,k);
	
	if (load_input(input_buffer,num_input,char_buffer) < 0)
	{
		syslog(LOG_CRIT,"Error load input %d: %s",k,strerror(errno));
		if (mode == 0)
		{
			close(m);
		}
		return(1);
	}
	
	for (l=0; l<num_input; l++)
	{
		test_neuron[l]->value=input_buffer[l];
//		syslog(LOG_INFO,"input: %d neuron: %d value: %f\n",k,l,test_neuron[l]->value);
	}
	
	sprintf(char_buffer,"%s%d",conf.output_preffix,k);
	if (load_output(output_buffer,num_output,char_buffer) <0)
	{
		syslog(LOG_CRIT,"Error load_output() %d: %s",k,strerror(errno));
		if (mode == 0)
		{
			close(m);
		}

		return(1);
	}
	
	forward_propagation(num_neuron,test_neuron,num_input, conf.threshold_level);
/*	
	for (l=0;l<num_output;l++)
	{
		syslog(LOG_INFO,"Pattern: %d Output: %f Desired: %f\n",k,
				test_neuron[num_neuron-num_output+l-1]->value,output_buffer[l]);
	}
*/
	Error=output_layer_error(num_neuron,test_neuron,num_output,output_buffer, conf.threshold_level);
//	syslog(LOG_INFO,"trainning=%d Pattern=%d Error=%f",trainning,k,Error);
	
	if (mode==1)
	{
		back_propagation(num_neuron,test_neuron,num_input,conf.threshold_level);
		weight_update(num_neuron,test_neuron,num_input);
	}
	else if (mode == 0)
	{
		sprintf(char_buffer,"Error=%f\0",Error);
		writen(m,char_buffer,BUFFSIZE);
	}
	else if (mode == 2) //mode 2 = production
	{	
		for (l=0;l<num_output;l++)
		{
			syslog(LOG_INFO,"Pattern: %d Output[%d]: %f Desired[%d]: %f\n",k,l,
			test_neuron[num_neuron-num_output+l-1]->value,l,output_buffer[l]);
		}
		syslog(LOG_INFO,"Error=%f",Error);
	}
}
if (mode == 1)
{
	syslog(LOG_INFO,"Writting to file %s",argv[3]);
	if(	fwrite_neuron_array(num_neuron,test_neuron,argv[3])< 0)
	{
		syslog(LOG_CRIT,"Error fwrite_neuron_array() %s: %s",argv[3],strerror(errno));
		return(1);
	}
}
else if (mode == 0)
{
	syslog(LOG_INFO,"Writting to descriptor %d %s",m,argv[3]);
	if(	dwrite_neuron_array(num_neuron,test_neuron,m)< 0)
	{
		syslog(LOG_CRIT,"Error dwrite_neuron_array() %s",strerror(errno));
		return(1);
	}
	close(m);
}
syslog(LOG_INFO,"***** Exiting *****");

exit(0);
}
