/*  roulette.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int roulette(int num, float *fitness)
{
	int k;
	double temp;
	float sum_fitness=0;

	for (k = 0; k < num; k++)
	{
		sum_fitness += fitness[k];
	}

	temp = (double) rand_gen(num);
	temp *= sum_fitness;

	sum_fitness = 0;

	for (k = 0; k < num; k++)
	{
		sum_fitness += *(fitness+k);
		if (sum_fitness >= temp)
		{
			return(k);
		}
	}
	return(-1);
}
