/*  sort_neuron_array.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int sort_neuron_array(int num_neuron, struct neuron ** neuron_array)
{
	int k,l,m;
	float max_x, max_y;
	struct neuron ** neuron_array_temp;
	struct neuron neuron_temp;
	
	if (!num_neuron)
	{
//		syslog(LOG_INFO,"No neurons to sort");
		return(2);
	}

	for (k=num_neuron; k ; k--)
	{
		max_x=0;
		max_y=0;
		for (l=0; l<k; l++)
		{
			if (neuron_array[l]->x_c > max_x) 
			{
				max_x = neuron_array[l]->x_c;
				max_y = neuron_array[l]->y_c;
				m = l;
			}
			else if ( (neuron_array[l]->x_c == max_x) && (neuron_array[l]->y_c >= max_y) )
			{
				max_y = neuron_array[l]->y_c;
				m = l;
			}
		}

		memcpy(&neuron_temp,neuron_array[k-1],sizeof(struct neuron));
		memcpy(neuron_array[k-1],neuron_array[m],sizeof(struct neuron));
		memcpy(neuron_array[m],&neuron_temp,sizeof(struct neuron));		
	}
	return(1);	
}
