/*  inner_neuron.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int inner_neuron(int num_neuron, struct neuron ** neuron_array, float **vertice, 
						int *inner_elem)
{
	int k;
	float *coord;
	
	if ( !(coord = (float *)calloc(2,sizeof(float)) ))
	{
		return(-1);
	}

	for (k=num_neuron-1;k+1;k--)
	{
		coord[0]=neuron_array[k]->x_c;
		coord[1]=neuron_array[k]->y_c;
		
		inner_elem[k]=inner(vertice,coord);
	}
	return(1);	
}
