/*  load_nn_config.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int load_nn_config(struct nn_config *conf, const char * filename)
{
	FILE * file_pointer;
	if ((file_pointer=fopen(filename,"r")) == NULL)
	{
		return(-1);
	}
	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);

		if (!strcmp(char_buffer,"num_pat\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->num_pat=atoi(char_buffer);
		}
		else if (!strcmp(char_buffer,"num_input\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->num_input=atoi(char_buffer);
		}
		else if (!strcmp(char_buffer,"num_output\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->num_output=atoi(char_buffer);
		}
		else if (!strcmp(char_buffer,"mode\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->mode=atoi(char_buffer);
		}
		else if (!strcmp(char_buffer,"input_preffix\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			strncpy(conf->input_preffix,char_buffer,BUFFSIZE);
		}
		else if (!strcmp(char_buffer,"output_preffix\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			strncpy(conf->output_preffix,char_buffer,BUFFSIZE);
		}
	}
	fclose(file_pointer);
	return(1);
}
