/*  ga_calloc_client_index.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* index should be a NULL pointer */
/*
mode:
0 = normal, calloc everything;
10 = do not calloc any elements of (base structure) members 
11 = do not calloc elements of members dependant on num_client 
12 = do not calloc elements of members dependant on num_addr
20 = calloc just index
21 = calloc index, addr, offsets and their elements
22 = calloc index, clients and its elements
*/

void * ga_calloc_client_index(int mode, int num_client, int num_addr, 
															struct ga_service_client_index * index)
{
	int k,l;
	ga_errno = 0;
	int client_flag = 0;
	int client_elem_flag = 0;
	int addr_flag = 0;
	int addr_elem_flag = 0;
	
	if (index != NULL)
	{
		syslog(LOG_ERR,"index already allocated, freeing");
		index = ga_free_client_index(0,index);
	}
	
	/* calloc the base structure */
	if (!(index = (struct ga_service_client_index *)calloc
																(1,sizeof(struct ga_service_client_index)) ))
	{
		syslog(LOG_CRIT,"Error calloc index in ga_service_client_index()");
		return(NULL);
	}
	
	/* Set flags, default is zero */
	if (num_addr > 0)
	{
		switch(mode)
		{
			case 0: {addr_flag = 1; addr_elem_flag = 1; break;}
			case 10: {addr_flag = 1; break;}
			case 11: {addr_flag = 1; addr_elem_flag = 1; break;}
			case 12: {addr_flag = 1; break;}
			case 20: {break;}
			case 21: {addr_flag = 1; addr_elem_flag = 1; break;}
			case 22: {break;}
		}
	}

	if (num_client > 0)
	{
		switch(mode)
		{
			case 0: {client_flag = 1; client_elem_flag = 1; break;}
			case 10: {client_flag = 1; break;}
			case 11: {client_flag = 1; break;}
			case 12: {client_flag = 1; client_elem_flag = 1; break;}
			case 20: {break;}
			case 21: {break;}
			case 22: {client_flag = 1; client_elem_flag = 1; break;}
		}
	}
	
//	printf("flags: a = %d %d, c = %d %d\n",addr_flag, addr_elem_flag,client_flag,client_elem_flag);
					
	/* calloc structure members */
	/* Allocate offsets, addr */
	if (addr_flag)
	{
		if (!(index->offsets = (int *)calloc(num_addr,sizeof(int)) ))
		{
			syslog(LOG_CRIT,"Error calloc index->offsets in ga_service_client_index()");
			free(index);
			return(NULL);
		}

		if (!(index->addr = (struct sockaddr_in **)calloc(num_addr,sizeof(struct sockaddr_in *)) ))
		{
			syslog(LOG_CRIT,"Error calloc index->addr in ga_service_client_index()");
			free(index->offsets);
			free(index);
			return(NULL);
		}
		
		if (addr_elem_flag)
		{
			for (k = 0; k< num_addr; k ++)
			{
				if (!(index->addr[k] = (struct sockaddr_in *)calloc(1,sizeof(struct sockaddr_in)) ))
				{
					syslog(LOG_CRIT,"Error calloc index->addr in ga_service_client_index()");
					for (l = 0; l< k; l++)
					{
						free(index->addr[l]);
					}
					free(index->offsets);
					free(index->addr);
					free(index);
					return(NULL);
				}
			}
		}
	}
	else
	{
		index->offsets = NULL;
		index->addr = NULL;
	}

	/* calloc clients */
	if (client_flag)
	{
		if (!(index->clients = (struct ga_service_client_info **)calloc(
																num_client,sizeof(struct ga_service_client_info *)) ))
		{
			syslog(LOG_CRIT,"Error calloc index->clients in ga_service_client_index()");
			if (addr_flag)
			{
				if (addr_elem_flag)
				{
					for (k = 0; k< num_addr; k++)
					{
						free(index->addr[k]);
					}
				}
				free(index->offsets);
				free(index->addr);
			}
			free(index);
			return(NULL);
		}
	
		if (client_elem_flag)
		{
			for (k = 0; k< num_client; k ++)
			{
				if (!(index->clients[k] = (struct ga_service_client_info *)calloc(
															1,sizeof(struct ga_service_client_info)) ))
				{
					syslog(LOG_CRIT,"Error calloc index->clients in ga_service_client_index()");
					if (addr_flag)
					{
						if (addr_elem_flag)
						{
							for (l = 0; l< num_addr; l++)
							{
								free(index->addr[l]);
							}
						}
						free(index->offsets);
						free(index->addr);
					}
					for (l = 0; l< k; l++)
					{
						free(index->clients[l]);
					}
					free(index->clients);
					free(index);
					return(NULL);
				}
				else
				{
					index->clients[k]->ret = NULL;
					index->clients[k]->connptr = NULL;
				}
			}
		}
	}
	else
	{
		index->clients = NULL;
	}
	index->num_addr = num_addr;
	index->num_client = num_client;
	return(index);
}
