/*  ga_free_client_index.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
mode:
0: normal, free everything
10: do not free addr[] or clients[] elements
11: do not free clients[]
12: do not free addr[]
20: do not free addr, offsets or clients pointers
21: do not free clients pointer
22: do not free addr or offsets pointer
*/

/* Asuming everything is allocated */

void * ga_free_client_index(int mode, struct ga_service_client_index * index)
{
	int k;
	int addr_flag = 0;
	int client_flag = 0;
	int addr_elem_flag = 0;
	int client_elem_flag = 0;

	if (index == NULL)
	{
		syslog(LOG_INFO,"index already free");
		return(NULL);
	}

	/* Setup flags */	
	if (index->num_addr > 0)
	{
		switch(mode)
		{
			case 0: {addr_flag = 1; addr_elem_flag = 1; break;}
			case 10: {addr_flag = 1; break;}
			case 11: {addr_flag = 1; addr_elem_flag = 1; break;}
			case 12: {addr_flag = 1; break;}
			case 20: {break;}
			case 21: {addr_flag = 1; addr_elem_flag = 1; break;}
			case 22: {break;}
		}
	}
	if (index->num_client > 0)
	{
		switch(mode)
		{
			case 0: {client_flag = 1; client_elem_flag = 1; break;}
			case 10: {client_flag = 1; break;}
			case 11: {client_flag = 1; break;}
			case 12: {client_flag = 1; client_elem_flag = 1; break;}
			case 20: {break;}
			case 21: {break;}
			case 22: {client_flag = 1; client_elem_flag = 1; break;}
		}
	}	

	/* Free memory */
	if (addr_elem_flag)
	{			
		for (k = 0; k< index->num_addr; k++)
		{
			free(index->addr[k]);
		}
	}
	if (addr_flag)
	{
		free(index->addr);
		free(index->offsets);
	}
	
	if (client_elem_flag)
	{
		for (k = 0; k< index->num_client; k++)
		{
			index->clients[k]->ret = (struct nn_return_f *)nn_free_return_f(index->clients[k]->ret);
			index->clients[k]->pat_index = (struct ga_pat_index *)ga_free_pat_index(index->clients[k]->pat_index);
			free(index->clients[k]);
		}
	}
	if (client_flag)
	{
		free(index->clients);
	}
	
	free(index);
	index = NULL;
	
	return(NULL);
}
