/*  ga_get_num_file.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag-2 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
Gets the number of files with name preffix 
*/

int ga_get_num_file(DIR * in_dir, char preffix[NAME_MAX])
{
int k;
int counter;
int real_counter;
int temp;

struct dirent * dir;

char char_buffer[NAME_MAX];

size_t len;

errno = 0;

rewinddir(in_dir);

/* Check if in_dir is valid */
if (readdir(in_dir) == NULL)
{
	if (errno == EBADF)
	{
		syslog(LOG_CRIT,"Error ga_get_num_file, invalid DIR * : %s",strerror(errno));
		return(-1);
	}
}
rewinddir(in_dir);

/* Get lenght of preffix, not including '\0'*/
len = strlen(preffix);

/* Start the count */
counter = 0;
while ((dir = readdir(in_dir)) != NULL)
{
	if (!(strncmp(dir->d_name, preffix, len)))
	{
//		syslog(LOG_INFO,"dir->d_name: %s, preffix: %s, len = %d", dir->d_name, preffix, len);
		for (k=0 ; k< NAME_MAX - len; k++)
		{
			if ((dir->d_name[len+k] != '_') && (dir->d_name[len+k] != '-') &&
				 (dir->d_name[len+k] != '\0') && (dir->d_name[len+k] != '\n') )
			{
				char_buffer[k] = dir->d_name[len+k];
			}
			else
			{
				char_buffer[k] = '\0';
				break;
			}
		}
		temp = atoi(char_buffer);
		counter = (temp+1 > counter) ? temp+1 : counter;
	}
}

rewinddir(in_dir);

return(counter);
}
