/*  ga_pack_error.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag-2 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Pack error in block->char_vector 

Error:  	e000 e001 e002
					e010 e011 e012
			
					e100 e101 e102
					e110 e111 e112 

Result char_vector:

char_vector[0] ERROR\0
char_vector[1] e000:e001:e002;e010:e011:e012\0
char_vector[2] e100:e101:e102;e110:e111:e112\0
char_vector[3] END_ERROR\0
*/


void * ga_pack_error(struct nn_return_f * ret, struct io_block * block)
{
	int k,l,m;
	struct io_block * temp_block1 = NULL;
	struct io_block * temp_block2 = NULL;
	
	char char_buffer[BUFFSIZE];
	
	/* Calloc temp_block1, temp_block2, block */
	if (!(temp_block1 = (struct io_block *)va_calloc_io_block(0, 0, 0, temp_block1)))
	{
		syslog(LOG_CRIT,"Error va_calloc_io_block(temp_block1) in ga_pack_error [%d]: %s",k,strerror(errno));
		return(NULL);
	}
	if (!(block = (struct io_block *)va_calloc_io_block(0,0,0, block)))
	{
		syslog(LOG_CRIT,"Error va_calloc_io_block(block) in ga_pack_error: %s",strerror(errno));
		temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
		return(NULL);
	}
	
	/* Insert ERROR\0 */
	sprintf(char_buffer,"ERROR\0");
	if (!(block = (struct io_block *)va_insert_io_block(-1,char_buffer,block)))
	{
		syslog(LOG_CRIT,"Error va_insert_io_block(block) in ga_pack_error: %s",strerror(errno));
		temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
		return(NULL);
	}
	
	/* Insert error values */
	for (k = 0; k< ret->num_pat; k++)
	{
		for (l = 0; l< ret->num_output; l++)
		{
			/* Memory reserve for output error elements */
			if (!(temp_block2 = (struct io_block *)va_calloc_io_block(
										ret->num_elem[k], BUFFSIZE,0, temp_block2)))
			{
				syslog(LOG_CRIT,"Error va_calloc_io_block(temp_block2) in ga_pack_error [%d][%d]: %s",k,l,strerror(errno));
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				block = (struct io_block *)va_free_io_block(block);
				return(NULL);
			}
		
			/* Insert error elements */
			for (m = 0; m< ret->num_elem[k]; m++)
			{
				snprintf(temp_block2->char_vector[m], BUFFSIZE, "%1.5f\0", ret->error[k][l][m]);
				temp_block2->char_vector[m][BUFFSIZE-1] = '\0';
			}
			
			/* Pack elements to form output error */			
			if (!(temp_block2 = (struct io_block *)va_pack_io_block(temp_block2, ELEM_SEP)))
			{
				syslog(LOG_CRIT,"Error va_pack_io_block(temp_block2) in ga_pack_error [%d][%d]: %s",k,l,strerror(errno));
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				block = (struct io_block *)va_free_io_block(block);
				return(NULL);
			}
			
			/* Insert temp_block2->pack_vector in  temp_block1->char_vector */
			if (!(temp_block1 = (struct io_block *)va_insert_io_block(
												-1, temp_block2->pack_vector, temp_block1)))
			{
				syslog(LOG_CRIT,"Error va_insert_io_block(temp_block2) in ga_pack_error [%d][%d]: %s",k,l,strerror(errno));
				block = (struct io_block *)va_free_io_block(block);
				temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
				return(NULL);
			}
			
			/* Free elements in temp_block2 */
			if (!(temp_block2 = (struct io_block *)va_delete_io_block(-1, temp_block2)))
			{
				syslog(LOG_CRIT,"Error va_delete_io_block(temp_block2) in ga_pack_error [%d][%d]: %s",k,l,strerror(errno));
				block = (struct io_block *)va_free_io_block(block);
				temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
				return(NULL);
			}
		}
		
		/* Pack temp_block1 to form patterns */
		if (!(temp_block1 = (struct io_block *)va_pack_io_block(temp_block1, BLOCK_SEP)))
		{
			syslog(LOG_CRIT,"Error va_pack_io_block(temp_block1) in ga_pack_error [%d]: %s",k,strerror(errno));
			temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
			block = (struct io_block *)va_free_io_block(block);
			return(NULL);
		}
		
		/* Insert temp_block1->pack_vector in block->char_vector */
		if (!(block = (struct io_block *)va_insert_io_block(
											-1, temp_block1->pack_vector, block)))
		{
			syslog(LOG_CRIT,"Error va_insert_io_block(temp_block1) in ga_pack_error [%d]: %s",k,strerror(errno));
			temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
			temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
			return(NULL);
		}
		
		/* Free elements in temp_block2 */
		if (!(temp_block1 = (struct io_block *)va_delete_io_block(-1, temp_block1)))
		{
			syslog(LOG_CRIT,"Error va_delete_io_block(temp_block1) in ga_pack_error [%d]: %s",k,strerror(errno));
			temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
			temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
			return(NULL);
		}		
	}
	
	/* Insert ERROR\0 */
	sprintf(char_buffer,"END_ERROR\0");
	if (!(block = (struct io_block *)va_insert_io_block(-1,char_buffer,block)))
	{
		syslog(LOG_CRIT,"Error va_insert_io_block(block) in ga_pack_error: %s",strerror(errno));
		temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
		temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
		return(NULL);
	}	

	temp_block1 = (struct io_block *)va_free_io_block(temp_block1);
	temp_block2 = (struct io_block *)va_free_io_block(temp_block2);
	
	return(block);
}
