/*  ga_pat_ga_cat_t.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag-2 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Genetic algorithm for one category.
*/

void * ga_pat_ga_cat_t(void * arg)
{
int k,l,m,n;
int num_pat;
int num_input;
int num_output;
int num_elem_input;
int num_elem_output;
int temp;
int num_stable_var;
int remaining;

int up_corner[2];
int bottom_corner[2];
int parents[2];
int  ** cross_region;

float * fitness;

struct ga_pat_ga_cat_thread_param * param;

param = (struct ga_pat_ga_cat_thread_param *)arg;

num_input = param->cat->pat[0]->num_input;
num_output = param->cat->pat[0]->num_output;
num_elem_input = param->cat->pat[0]->num_elem_input;
num_elem_output = param->cat->pat[0]->num_elem_output;

/* Memory reserve for cross_region */
if (!(cross_region = (int **)malloc(num_input*sizeof(int *))));
{
	syslog(LOG_CRIT, "Error malloc cross_region in ga_pat_ga_cat_t: %s", strerror(errno));
	return(NULL);
}
for (k=0 ; k< num_input; k++)
{
	if (!(cross_region[k] = (int *)calloc(num_elem_input,sizeof(int))));
	{
		syslog(LOG_CRIT, "Error malloc cross_region[%d] in ga_pat_ga_cat_t: %s",k, strerror(errno));
		for (l=0; l< k; l++)
		{
			free(cross_region[l]);
		}
		free(cross_region);
		return(NULL);
	}
}

/* Memory reserve for result_cat */
if (param->result_cat != NULL)
{
	syslog(LOG_ERR,"Error, memory leak, result_cat already allocated");
}
if (param->num_pat >= param->cat->num_stable)
{
	num_pat = param->num_pat;
}
else
{
	syslog(LOG_ERR,"pat_cat = %d with wrong number of patterns",param->cat->pat_cat);
	num_pat = param->cat->num_stable;
}

if (!(param->result_cat = (struct ga_pat_cat *)calloc(1,sizeof(struct ga_pat_cat))))
{
	syslog(LOG_CRIT, "Error calloc result_cat in ga_pat_ga_cat_t: %s", strerror(errno));
	for (l=0; l< num_input; l++)
	{
		free(cross_region[l]);
	}
	free(cross_region);
	return(NULL);
}
if (!(param->result_cat->pat = (struct ga_pattern **)malloc(num_pat*sizeof(struct ga_pattern *))))
{
	syslog(LOG_CRIT, "Error malloc param->result_cat->pat in ga_pat_ga_cat_t: %s", strerror(errno));
	for (l=0; l< num_input; l++)
	{
		free(cross_region[l]);
	}
	free(cross_region);
	free(param->result_cat);
	return(NULL);
}

/* Memory reserve fitness vector */
if (!(fitness = (float *)calloc(param->cat->num_pat, sizeof(float))))
{
	syslog(LOG_CRIT, "Error calloc fitness in ga_pat_ca_cat_t: %s", strerror(errno));
	for (l=0; l< num_input; l++)
	{
		free(cross_region[l]);
	}
	free(cross_region);
	free(param->result_cat);
	free(param->result_cat->pat);
}


for (k=0; k< num_pat; k++)
{
	/* Memory reserve for patterns */
	if (!(param->result_cat->pat[k] = (struct ga_pattern *)calloc(1,sizeof(struct ga_pattern ))))
	{
		syslog(LOG_CRIT, "Error malloc param->result_cat->pat[%d] in ga_pat_ga_cat_t: %s",k, strerror(errno));
		for (l=0; l< k; l++)
		{
			for (m=0; m< num_input; m++)
			{
				free(param->result_cat->pat[l]->in_pattern);
			}
			for (m=0; m< num_output; m++)
			{
				free(param->result_cat->pat[l]->out_pattern);
			}
			free(param->result_cat->pat[l]->in_pattern);
			free(param->result_cat->pat[l]->out_pattern);
			free(param->result_cat->pat[l]);
		}
		for (l=0; l< num_input; l++)
		{
			free(cross_region[l]);
		}
		free(cross_region);
		free(param->result_cat->pat);
		free(param->result_cat);
		free(fitness);
		return(NULL);
	}
	
	/* Memory reserve for in_pattern */
	if (!(param->result_cat->pat[k]->in_pattern = (float **)calloc(num_input,sizeof(float * ))))
	{
		syslog(LOG_CRIT, "Error malloc param->result_cat->pat[%d]->in_pattern in ga_pat_ga_cat_t: %s",k, strerror(errno));
		for (l=0; l< k; l++)
		{
			for (m=0; m< num_input; m++)
			{
				free(param->result_cat->pat[l]->in_pattern);
			}
			for (m=0; m< num_output; m++)
			{
				free(param->result_cat->pat[l]->out_pattern);
			}
			free(param->result_cat->pat[l]->in_pattern);
			free(param->result_cat->pat[l]->out_pattern);
			free(param->result_cat->pat[l]);
		}
		for (l=0; l< num_input; l++)
		{
			free(cross_region[l]);
		}
		free(cross_region);
		free(param->result_cat->pat[k]);
		free(param->result_cat->pat);
		free(param->result_cat);
		free(fitness);
		return(NULL);
	}
	for (l=0; l< num_input; l++)
	{
		if (!(param->result_cat->pat[k]->in_pattern[l] = (float *)calloc(num_elem_input,sizeof(float))))
		{
			syslog(LOG_CRIT, "Error calloc param->result_cat->pat[%d]->in_pattern[%d] in ga_pat_ga_cat_t: %s",k,l, strerror(errno));
			for (m=0; m< l; m++)
			{
				free(param->result_cat->pat[k]->in_pattern[m]);
			}			
			for (m=0; m< k; m++)
			{
				for (m=0; m< num_input; m++)
				{
					free(param->result_cat->pat[m]->in_pattern);
				}
				for (m=0; m< num_output; m++)
				{
					free(param->result_cat->pat[m]->out_pattern);
				}
				free(param->result_cat->pat[m]->in_pattern);
				free(param->result_cat->pat[m]->out_pattern);
				free(param->result_cat->pat[m]);
			}
			for (m=0; m< num_input; m++)
			{
			free(cross_region[m]);
			}
			free(cross_region);
			free(param->result_cat->pat[k]);
			free(param->result_cat->pat);
			free(param->result_cat);
			free(fitness);
			return(NULL);
		}
	}
	
	/* Memory reserve for out_pattern */
	if (!(param->result_cat->pat[k]->out_pattern = (float  **)calloc(num_output,sizeof(float *))))
	{
		syslog(LOG_CRIT, "Error malloc param->result_cat->pat[%d]->out_pattern in ga_pat_ga_cat_t: %s",k, strerror(errno));
		for (l=0; l< k; l++)
		{
			for (m=0; m< num_input; m++)
			{
				free(param->result_cat->pat[l]->in_pattern);
			}
			for (m=0; m< num_output; m++)
			{
				free(param->result_cat->pat[l]->out_pattern);
			}
			free(param->result_cat->pat[l]->in_pattern);
			free(param->result_cat->pat[l]->out_pattern);
			free(param->result_cat->pat[l]);
		}
		for (l=0; l< num_input; l++)
		{
			free(cross_region[l]);
		}
		free(cross_region);
		
		free(param->result_cat->pat[k]->in_pattern);
		free(param->result_cat->pat[k]);
		free(param->result_cat->pat);
		free(fitness);
		free(param->result_cat);
		return(NULL);
	}
	for (l=0; l< num_output; l++)
	{
		if (!(param->result_cat->pat[k]->out_pattern[l] = (float *)calloc(num_elem_output,sizeof(float))))
		{
			syslog(LOG_CRIT, "Error calloc param->result_cat->pat[%d]->out_pattern[%d] in ga_pat_ga_cat_t: %s",k,l, strerror(errno));
			for (m=0; m< l; m++)
			{
				free(param->result_cat->pat[k]->out_pattern[m]);
			}			
			for (m=0; m< num_input; m++)
			{
				free(param->result_cat->pat[k]->in_pattern[m]);
			}			
			for (m=0; m< k; m++)
			{
				for (m=0; m< num_input; m++)
				{
					free(param->result_cat->pat[m]->in_pattern);
				}
				for (m=0; m< num_output; m++)
				{
					free(param->result_cat->pat[m]->out_pattern);
				}
				free(param->result_cat->pat[m]->in_pattern);
				free(param->result_cat->pat[m]->out_pattern);
				free(param->result_cat->pat[m]);
			}
			for (m=0; m< num_input; m++)
			{
				free(cross_region[m]);
			}
			free(cross_region);
			free(param->result_cat->pat[k]);
			free(param->result_cat->pat);
			free(param->result_cat);
			free(fitness);
			return(NULL);
		}
	}

	param->result_cat->pat[k]->num_input = num_input;
	param->result_cat->pat[k]->num_output = num_output;
	param->result_cat->pat[k]->num_elem_input = num_elem_input;
	param->result_cat->pat[k]->num_elem_output = num_elem_output;
}
/* Mutation of num_stable */
num_stable_var = 0;
if (va_toss(param->conf->pat_num_stable_prob, num_pat))
{
	num_stable_var = (int)va_rand_gauss(param->num_pat+1);

	if (num_stable_var + param->cat->num_stable > param->result_cat->num_pat)
	{
		num_stable_var = param->result_cat->num_pat - param->cat->num_stable;
	}
	else if (num_stable_var + param->cat->num_stable < 1)
	{
		num_stable_var = param->cat->num_stable - 1;
	}
}
param->result_cat->num_stable = param->cat->num_stable - num_stable_var;
param->result_cat->num_pat = num_pat;
param->result_cat->group_mode = param->cat->group_mode;
param->result_cat->pat_cat = param->cat->pat_cat;

/* Copy out_pattern */
for (k=0; k < num_pat; k++)
{
	for (l=0; l< num_output; l++)
	{
		for (m=0; m< num_elem_output; m++)
		{
			param->result_cat->pat[k]->out_pattern[l][m] = param->cat->pat[0]->out_pattern[l][m];
		}
	}
}

/* Copy stable patterns based on existing stables */
l = 0;
for (k=0; k < param->cat->num_pat; k++)
{
	if (param->cat->pat[k]->stable)
	{
		for (m=0; m< num_output; m++)
		{
			for (n=0; n< num_elem_output; n++)
			{
				param->result_cat->pat[l]->in_pattern[m][n] = param->cat->pat[k]->in_pattern[m][n];
			}
		}
		param->result_cat->pat[l]->stable = 1;
		l++;
		if ((l >= param->result_cat->num_stable) || (l >= param->cat->num_stable))
		{
			break;
		}
	}
}
remaining = (num_stable_var > 0) ? num_stable_var : 0;
temp = l;

/* Fill the fitness values */
for(k= param->cat->num_pat-1; k+1 ; k--)
{
	fitness[k] = param->cat->pat[k]->fitness;
}

for (k = temp; k< num_pat; k++)
{
	/* Select parents */
	parents[0] = va_roulette(param->cat->num_pat, fitness);
	parents[1] = va_roulette(param->cat->num_pat, fitness);

	/* Set cross_region */
	switch (param->cat->group_mode)
	{
		case 1: // Group by column
		{
			/* Select cut region */
			for (l=0; l< num_elem_input; l++)
			{
				if (va_coin_toss(l+k))
				{
					for (m=0; m< num_input; m++)
					{
						cross_region[m][l] = 1;
					}
				}
				else
				{
					for (m=0; m< num_input; m++)
					{
						cross_region[m][l] = 0;
					}
				}
			}
			break;
		}
		case 2:	//Group by row
		{
			/* Select cut region */
			for (l=0; l< num_input; l++)
			{
				if (va_coin_toss(l+k))
				{
					for (m=0; m< num_elem_input; m++)
					{
						cross_region[l][m] = 1;
					}
				}
				else
				{
					for (m=0; m< num_elem_input; m++)
					{
						cross_region[l][m] = 0;
					}
				}
			}
			break;
		}
		case 3: // No grouping, fragmented cross
		{
			for (l=0; l< num_input; l++)
			{
				for (m=0; m< num_elem_input; m++)
				{
					cross_region[l][m] = va_coin_toss(l+m+k);
				}
			}
			break;
		}
		default: // Whole as one, block crossing
		{
			/* Set corners */
			up_corner[0] = va_dice_toss(k, num_input);
			up_corner[1] = va_dice_toss(up_corner[0]+k, num_elem_input);
			
			bottom_corner[0] = va_dice_toss(up_corner[1], num_input);
			bottom_corner[1] = va_dice_toss(bottom_corner[0], num_elem_input);
			
			up_corner[0] = (up_corner[0] > bottom_corner[0]) ? up_corner[0] : bottom_corner[0];
			up_corner[1] = (up_corner[1] > bottom_corner[1]) ? up_corner[1] : bottom_corner[1];

			for (l=0; l< num_input; l++)
			{
				for (m=0; m< num_elem_input; m++)
				{
					if (((l < up_corner[0]) && (l> bottom_corner[0])) &&
							((m < up_corner[1]) && (m> bottom_corner[1])) )
					{
						cross_region[l][m] = 1;
					}
					else
					{
						cross_region[l][m] = 0;
					}
				}
			}
			break;
		}
	}

	/* Cross */
	for (l= 0; l< num_input; l++)
	{
		for (m=0; m< num_elem_input; m++)
		{
			param->result_cat->pat[k]->in_pattern[m][n] = param->cat->pat[parents[cross_region[l][m]]]->in_pattern[m][n]; 
		}
	}
	
	/* Mark as stable */
	if (remaining > 0)
	{
		param->result_cat->pat[k]->stable = 1;
		remaining--;
	}
	else
	{
		param->result_cat->pat[k]->stable = 0;
		/* Mutation */
		if (va_toss(param->conf->pat_mut_prob, k))
		{
			/* Select number of elements to be mutated, up to half of elements */
			temp = va_dice_toss(k, num_input*num_elem_input / 2);
			
			for (l = temp-1; l+1; l--)
			{
				/* Get coordinates */
				m = va_dice_toss(l+temp, num_input);
				n = va_dice_toss(m+l, num_elem_input);
				
				/* Change value */
				param->result_cat->pat[k]->in_pattern[m][n] += va_rand_gauss(k+m+n) / 
											(4.0 * param->result_cat->pat[k]->in_pattern[m][n]) ;
			}
		}
	}
}

/* Free memory */
for (l=0; l< num_input; l++)
{
	free(cross_region[l]);
}
free(cross_region);
free(fitness);

/* Notify thread caller */
if (pthread_mutex_lock(param->cat_mutex))
{
	syslog(LOG_CRIT,"Error pthread_mutex_lock in ga_pat_ga_cat_t: %s",strerror(errno));
	return(NULL);
}

*(param->num_thread) += 1;
param->ready = 1;

if (pthread_cond_signal(param->cat_cond))
{
	syslog(LOG_CRIT,"Error pthread_cond_signal in ga_pat_ga_cat_t: %s",strerror(errno));
	return(NULL);
}
if (pthread_mutex_unlock(param->cat_mutex))
{
	syslog(LOG_CRIT,"Error pthread_mutex_unlock in ga_pat_ga_cat_t: %s",strerror(errno));
	return(NULL);
}


return(&(param->result_cat));
}
