/*  ga_pat_index2nn_pat.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag-2 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Fills ret[2] with the contents of ga_pat_index 
ret[0]: inputs
ret[1]: outputs
*/

void * ga_pat_index2nn_pat(struct ga_pat_index * pat, struct nn_pattern ** ret)
{
int k,l,m,n,o;
int num_pat;

/* Get num_pat */
num_pat = 0;
for (k=0; k< pat->num_cat; k++)
{
	num_pat += pat->cat[k]->num_pat;
}

/* Memory reserve for ret */
if (ret = (struct nn_pattern **)malloc(2*sizeof(struct nn_pattern *)))
{
	syslog(LOG_CRIT,"Error malloc ret in ga_pat_index2nn_pat: %s", strerror(errno));
	return(NULL);
}
if (ret[0] = (struct nn_pattern *)malloc(sizeof(struct nn_pattern)))
{
	syslog(LOG_CRIT,"Error malloc ret[0] in ga_pat_index2nn_pat: %s", strerror(errno));
	return(NULL);
}
if (ret[1] = (struct nn_pattern *)malloc(sizeof(struct nn_pattern)))
{
	syslog(LOG_CRIT,"Error malloc ret[1] in ga_pat_index2nn_pat: %s", strerror(errno));
	return(NULL);
}

/* Set paramaters for nn_pattern */
ret[0]->num_pat = num_pat;
ret[1]->num_pat = num_pat;

ret[0]->num_input = pat->cat[0]->pat[0]->num_input;
ret[1]->num_input = pat->cat[0]->pat[0]->num_output;

if (ret[0]->num_elem = (int *)malloc(ret[0]->num_input*sizeof(int)))
{
	syslog(LOG_CRIT,"Error malloc ret[0]->num_elem in ga_pat_index2nn_pat: %s", strerror(errno));
	return(NULL);
}
if (ret[1]->num_elem = (int *)malloc(ret[1]->num_input*sizeof(int)))
{
	syslog(LOG_CRIT,"Error malloc ret[1]->num_elem in ga_pat_index2nn_pat: %s", strerror(errno));
	return(NULL);
}

n=0;
for (k=0; k< pat->num_cat; k++)
{
	for (l=0; l< pat->cat[k]->num_pat; l++)
	{
		ret[0]->num_elem[n] = pat->cat[k]->pat[l]->num_elem_input;
		ret[1]->num_elem[n] = pat->cat[k]->pat[l]->num_elem_output;			
		n++;
	}
}

/* Memory reserve for patterns */
if (ret[0]->pattern = (float ***)malloc(ret[0]->num_pat*sizeof(float **)))
{
	syslog(LOG_CRIT,"Error malloc ret[0]->pattern in ga_pat_index2nn_pat: %s", strerror(errno));
	return(NULL);
}
if (ret[1]->pattern = (float ***)malloc(ret[1]->num_pat*sizeof(float **)))
{
	syslog(LOG_CRIT,"Error malloc ret[1]->pattern in ga_pat_index2nn_pat: %s", strerror(errno));
	return(NULL);
}
for (k=0; k< ret[0]->num_pat; k++)
{
	if (ret[0]->pattern[k] = (float **)malloc(ret[0]->num_input*sizeof(float *)))
	{
		syslog(LOG_CRIT,"Error malloc ret[0]->pattern[%d] in ga_pat_index2nn_pat: %s", k,strerror(errno));
		return(NULL);
	}
	if (ret[1]->pattern[k] = (float **)malloc(ret[1]->num_input*sizeof(float *)))
	{
		syslog(LOG_CRIT,"Error malloc ret[1]->pattern[%d] in ga_pat_index2nn_pat: %s", k,strerror(errno));
		return(NULL);
	}
	for (l=0; l< ret[0]->num_input; l++)
	{
		if (ret[0]->pattern[k][l] = (float *)malloc(ret[0]->num_elem[k]*sizeof(float)))
		{
			syslog(LOG_CRIT,"Error malloc ret[0]->pattern[%d][%d] in ga_pat_index2nn_pat: %s", k,l,strerror(errno));
			return(NULL);
		}
	}
	for (l=0; l< ret[1]->num_input; l++)
	{
		if (ret[1]->pattern[k][l] = (float *)malloc(ret[1]->num_elem[k]*sizeof(float)))
		{
			syslog(LOG_CRIT,"Error malloc ret[1]->pattern[%d][%d] in ga_pat_index2nn_pat: %s", k,l,strerror(errno));
			return(NULL);
		}
	}
}

/* Copy values */
o=0;
for (k=0; k< pat->num_cat; k++)
{
	for (l=0; l< pat->cat[k]->num_pat; l++)
	{
		for (m=0; m< pat->cat[k]->pat[l]->num_input; m++)
		{
			for (n=0; n< pat->cat[k]->pat[l]->num_elem_input; n++)
			{
				ret[0]->pattern[o][m][n] = pat->cat[k]->pat[l]->in_pattern[m][n];
			}
		}
		for (m=0; m< pat->cat[k]->pat[l]->num_output; m++)
		{
			for (n=0; n< pat->cat[k]->pat[l]->num_elem_output; n++)
			{
				ret[1]->pattern[o][m][n] = pat->cat[k]->pat[l]->out_pattern[m][n];
			}
		}
		o++;
	}
}
return(ret);
}
