/*  ga_service_provider_t.c */
/*  Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/*  This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Global variables and mutexes from service server*/
#include "ga_service_server_header.h"

void * ga_prov_set_clean_start_block(struct io_block * block, struct ga_server_config * conf)
{
int k,l;
int num_layer;
char temp_buffer[2*BUFFSIZE];
char char_temp[2*BUFFSIZE];

/* Memory reserve for clean block */
if (!(block = (struct io_block *)va_calloc_io_block(0,0,0,block)))
{
	syslog(LOG_CRIT,"Error va_calloc_io_block(block) in ga_service_provider: %s",strerror(errno));
	return(NULL);
}
/* Set dimension value */
sprintf(char_temp,"dimension=%d\0",conf->nn_dimension);
if (!(block = (struct io_block *)va_insert_io_block(-1,char_temp,block)))
{
	syslog(LOG_CRIT,"Error va_insert_io_block(block) inserting %s",char_temp);
	return(NULL);
}
/* Set nn_type value */
sprintf(char_temp,"type=%d\0",conf->nn_type);
if(!(block = (struct io_block *)va_insert_io_block(-1,char_temp,block)))
{
	syslog(LOG_CRIT,"Error va_insert_io_block(block) inserting %s",char_temp);
	return(NULL);
}

/* Set up layers */
num_layer = va_dice_toss(k,conf->max_num_layer-2);
sprintf(temp_buffer, "layers=%d",conf->nn_num_input);
for (l=0; l< num_layer; l++)
{
	sprintf(char_temp,":%d",va_dice_toss(k+l,conf->max_num_neuron-1)+1);				
	strcat(temp_buffer, char_temp);
}
sprintf(char_temp,":%d\0",conf->nn_num_output);
strcat(temp_buffer, char_temp);
if (!(block = (struct io_block *)va_insert_io_block(-1,temp_buffer,block) ))
{
	syslog(LOG_CRIT,"Error va_insert_io_block(block) inserting: %s",temp_buffer);
	return(NULL);
}			
/* Insert NULL */
if (!(block = (struct io_block *)va_insert_io_block(-1,NULL,block) ))
{
	syslog(LOG_CRIT,"Error va_insert_io_block(block) inserting: NULL");
	return(NULL);
}			

return(block);
}
