/*  ga_service_accept_client_t.c */
/*  Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Global variables and mutexes */
#include "ga_service_server_header.h"


/* Adds (if required) or update data about client in global client index */

void * ga_service_accept_client_t(void * arg)
{

struct ga_service_accept_client_param * accept_param = NULL;
struct ga_service_client_info * info = NULL;

int * connptr;
int ret;

accept_param = (struct ga_service_accept_client_param *)arg;
connptr = accept_param->connptr;

syslog(LOG_INFO,"ga_service_accept_client_t %d ready", pthread_self());

/* Get client info */
if (!(info = (struct ga_service_client_info *)ga_service_get_client_info(connptr, info) ))
{
	syslog(LOG_CRIT,"Error getting client info: %s",strerror(errno));
	pthread_exit(NULL);
}

/* Insert / Update client info into client_index */
/* Lock index_mutex */
if ((ret = pthread_mutex_lock(&index_mutex)) != 0)
{
	syslog(LOG_CRIT,"Error pthread_mutex_lock() in ga_service_accept_client(): %d",ret);
	pthread_exit(NULL);
}

/* Insert data into client_index */
if (!(client_index = (struct ga_service_client_index *)ga_insert_client_index(
																info, client_index) ))
{
	syslog(LOG_CRIT,"Error ga_insert_client_index(): %d", strerror(errno));
	pthread_exit(NULL);
}
syslog(LOG_INFO,"client[%d] inserted into index",info->id);

/* Unlock index_mutex */
if ((ret = pthread_mutex_unlock(&index_mutex)) != 0)
{
	syslog(LOG_CRIT,"Error pthread_mutex_lock() in ga_service_accept_client(): %d",ret);
	pthread_exit(NULL);
}

syslog(LOG_INFO,"Exiting ga_service_accept_client_t for client[%d]",info->id);

free(info); // Elements in info should be keep allocated
free(connptr); // freeing connptr allocated in ga_service_listen_t

pthread_exit(client_index);
}
