/*  ga_service_pass_sockfd_t.c */
/*  Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
	Pass socket descriptor, then close it.
*/

void * ga_service_pass_sockfd_t(void * arg)
{
	ssize_t n;
	
	struct ga_service_pass_fd * pass;
	
	pass = (struct ga_service_pass_fd *) arg;
	
	pthread_detach(pthread_self());
	
	/* Pass descriptor */
	if ( (n = va_write_fd(pass->passing_socket_fd[0],"",1, pass->sock_listen)) < 0)
	{
		syslog(LOG_CRIT,"Error passing fd = %d : %s", pass->passing_socket_fd[0], strerror(errno));
		return(-1);
	}
	
	close(pass->passing_socket_fd[0]);
	free(pass->passing_socket_fd);
	return(n);
}

