/*  nn_back_propagation.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Except for output, all deltas should be set to zero by nn_output_layer_error */

int nn_back_propagation(struct neural_net * net, int num_elem_input, float threshold_level)
{
	int k,l,m;
	int num_neuron;
	int type;
	int number;
	int counter;
	
	type = net->type;
	num_neuron = net->num_neuron;
	
	if (type == 0)
	{			
		for (k=num_neuron-1; k > num_elem_input-1; k--)
		{
			counter = 0;
			for(l = 0; l< num_neuron; l++) 
			{
				if ((n_is_above(net->neuron_array[k],net->neuron_array[l], NULL) == 0) && 
						(n_is_connected(net->neuron_array[l],net->neuron_array[k], &number)> 0) )
				{
					net->neuron_array[l]->delta += n_derive(net->neuron_array[k]->delta_type,
																		net->neuron_array[l]->value, threshold_level)
																		*(net->neuron_array[k]->delta)
																		*(net->neuron_array[k]->con[number]->weight);
					counter += 1;
					
					if (m = isinf(net->neuron_array[l]->delta))
					{
						net->neuron_array[l]->delta = m*(SATURATION);
					}
					if (net->neuron_array[l]->delta > SATURATION) //saturation
					{
						net->neuron_array[l]->delta = SATURATION;
					}
					if (net->neuron_array[l]->delta < -SATURATION) //saturation
					{
						net->neuron_array[l]->delta = -SATURATION;
					}
																							
				}
			}
		}
		return(0);
	}
	else if (type == 1)
	{
		for (k= (num_neuron-1); k+1; k--)
		{
			for (l= 0; l< num_neuron; l++)
			{
				if ((n_is_above(net->neuron_array[k],net->neuron_array[l], NULL) == 0) && 
						(n_is_connected(net->neuron_array[l],net->neuron_array[k], &number) >0) &&
						(net->neuron_array[l]->clock) && 
						(net->neuron_array[k]->con[number]->clock) &&
						(!net->neuron_array[k]->con[number]->eoi_flag) )
				{
					net->neuron_array[l]->delta += n_derive(net->neuron_array[k]->delta_type,
																		net->neuron_array[l]->p_value, threshold_level)
																		*(net->neuron_array[k]->delta)
																		*(net->neuron_array[k]->con[number]->weight);

					if (m = isinf(net->neuron_array[l]->delta))
					{
						net->neuron_array[l]->delta = m*(SATURATION);
					}
					if (net->neuron_array[l]->delta > SATURATION) //saturation
					{
						net->neuron_array[l]->delta = SATURATION;
					}
					if (net->neuron_array[l]->delta < -SATURATION) //saturation
					{
						net->neuron_array[l]->delta = -SATURATION;
					}
				}
			}
		}
		return(0);
	}
}
