/*  nn_forward_propagation.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int nn_forward_propagation(struct neural_net * net, int num_elem_input, float threshold_level)
{
	int k,l,m;
	int num_neuron;
	int number;
	int type_mode;
	int counter;
	int out_flag;

	double value;
	double p_value;
	
	type_mode = net->type;
	num_neuron = net->num_neuron;
	out_flag = 0;
	
	if (type_mode == 0) //normal operation
	{
		for ( k=num_elem_input; k< num_neuron ; k++ )
		{
			value = net->neuron_array[k]->bias;
			counter = 0;
			for(l = 0; l< k; l++) 
			{
				if ((n_is_above(net->neuron_array[k],net->neuron_array[l], NULL) == 0) && 
						(n_is_connected(net->neuron_array[l],net->neuron_array[k], &number)> 0) )
				{
					value += (net->neuron_array[k]->con[number]->weight)*
										(net->neuron_array[l]->value);
					counter += 1;
				}
			}
			net->neuron_array[k]->value = n_threshold(net->neuron_array[k]->delta_type,
																	value, threshold_level);
			
			if ( isnan(net->neuron_array[k]->value))
			{
				syslog(LOG_INFO,"net->neuron_array[%d]->value=NAN value=%f delta_type=%d bias=%f",
								k,value,net->neuron_array[k]->delta_type,net->neuron_array[k]->bias);
			}
			
		}
		return(1);	
	}
	else if (type_mode == 1)  //Input drive / direct mode
	{
		for (k= (num_neuron-1); k+1; k--)
		{
			value = net->neuron_array[k]->bias;
			counter = 0;
			for (l= 0; l< k; l++)
			{
				if ((n_is_above(net->neuron_array[k],net->neuron_array[l], NULL) == 0) && 
						(n_is_connected(net->neuron_array[l],net->neuron_array[k], &number)> 0) &&
						(net->neuron_array[l]->clock) )
				{
					/* Check if connected to eoi */
					if (!net->neuron_array[l]->eoi_flag)
					{
						/* Check if fabs(net->neuron_array[l]->value) > 1.0/SATURATION */
						if (fabs(net->neuron_array[l]->value) > (1.0/SATURATION))
						{
							value += (net->neuron_array[k]->con[number]->weight)*
											(net->neuron_array[l]->value);
							net->neuron_array[k]->con[number]->clock += 1;
							counter += 1;
						}
					}
					else //eoi_flag
					{
						net->neuron_array[k]->con[number]->eoi_flag = 1;
					}
					
					if (k == (num_neuron-1))
					{
						out_flag = 1;
					}
				}
			}
			
			/* Check if some propagation had happened */
			if (counter > 0) 
			{
				net->neuron_array[k]->clock += 1;
				
				/* Save previus value */
				net->neuron_array[k]->p_value = net->neuron_array[k]->value;
				
				/* Put new value */
				net->neuron_array[k]->value = n_threshold(net->neuron_array[k]->delta_type,
																		value, threshold_level);
			}
			/* Decay value */
			else
			{
				net->neuron_array[k]->value *= net->neuron_array[k]->decayment;
			}
			
			/* Check if eoi_flag is set in all connections */
			counter = 0;
			for (l= 0 ; l< net->neuron_array[k]->num_con; l++)
			{
				counter += net->neuron_array[k]->con[l]->eoi_flag;
			}
			if (counter == net->neuron_array[k]->num_con)
			{
				net->neuron_array[k]->eoi_flag = 1;
			}
		}
		if (out_flag == 1)
		{
			return(1);
		}
		else
		{
			return(0);			
		}
	}
}
