/*  nn_free_return_f.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * nn_free_return_f(struct nn_return_f * ret)
{
	int k,l;
	
	if (ret == NULL)
	{
		return(NULL);
	}
	
	for (k=0; k< ret->num_pat; k++)
	{
		for (l=0; l< ret->num_output; l++)
		{
			if (ret->error[k][l] != NULL)
			{
				free(ret->error[k][l]);
			}		
		}
		if (ret->error[k] != NULL)
		{
			free(ret->error[k]);
		}
	}
	if (ret->num_elem != NULL)
	{
		free(ret->num_elem);
	}
	if (ret->error != NULL)
	{
		free(ret->error);
	}	
	
	if (ret->net != NULL)
	{
		ret->net = (struct neural_net *)nn_free_neural_net(ret->net);
	}	
	
	free(ret);
	return(NULL);
}
