/*  nn_load_nn_init_config.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"
/*
action = 0:reset
       = 1:nn_init load
       = 2:nn_agr load
*/

int nn_load_nn_init_config(int action, char * char_buffer, struct nn_init_config *conf)
{
	int counter;
	counter = 0;
	if (action == 0) //reset to defaults
	{
		strcpy(conf->init_filename,"default_result\0");
		strcpy(conf->dimension,"3\0");
		strcpy(conf->type,"0\0");
		strcpy(conf->momentum,"rr\0");
		strcpy(conf->alpha,"rr\0");
		strcpy(conf->conv_rate,"rr\0");
		strcpy(conf->bias_corr,"rr\0");
		strcpy(conf->delta_type,"rr\0");
		strcpy(conf->delta_inf,"rr\0");
		strcpy(conf->delta_disp,"rr\0");
		strcpy(conf->bias,"rr\0");
		strcpy(conf->decayment,"rr\0");
		strcpy(conf->layers,"NULL\0");
		strcpy(conf->output_add,"0\0");
		strcpy(conf->input_add,"0\0");
		strcpy(conf->old_init1,"NULL\0");
		strcpy(conf->old_init2,"NULL\0");
		strcpy(conf->mode,"0\0");
		
		syslog(LOG_INFO,"Reseting nn_init_config");
		
		conf->num_param = 0; 
		return(0);
	}
	else if ((action == 1) || (action == 2))// copy a value
	{
		if (!strncmp(char_buffer,"init",4))
		{
			strcpy(conf->init_filename,char_buffer+5);
			syslog(LOG_INFO,"init=%s",conf->init_filename);
		}
		else if (!strncmp(char_buffer,"dimension",9))
		{
			strcpy(conf->dimension,char_buffer+10);
			syslog(LOG_INFO,"dimension=%s",conf->dimension);
		}
		else if (!strncmp(char_buffer,"type",4))
		{
			strcpy(conf->type,char_buffer+5);			//neural net type
			syslog(LOG_INFO,"type=%s",conf->type);
		}
		else if (!strncmp(char_buffer,"momentum",8))
		{
			strcpy(conf->momentum,char_buffer+9);
			syslog(LOG_INFO,"momentum=%s",conf->momentum);
		}
		else if (!strncmp(char_buffer,"alpha",5))
		{
			strcpy(conf->alpha,char_buffer+6);
			syslog(LOG_INFO,"alpha=%s",conf->alpha);
		}
		else if (!strncmp(char_buffer,"conv_rate",9))
		{
			strcpy(conf->conv_rate,char_buffer+10);
			syslog(LOG_INFO,"conv_rate=%s",conf->conv_rate);
		}
		else if (!strncmp(char_buffer,"bias_corr",9))
		{
			strcpy(conf->bias_corr,char_buffer+10);
			syslog(LOG_INFO,"bias_corr=%s",conf->bias_corr);
		}
		else if (!strncmp(char_buffer,"delta_type",10))
		{
			strcpy(conf->delta_type,char_buffer+11);
			syslog(LOG_INFO,"delta_type=%s",conf->delta_type);
		}
		else if (!strncmp(char_buffer,"delta_inf",9))
		{
			strcpy(conf->delta_inf,char_buffer+10);
			syslog(LOG_INFO,"delta_inf=%s",conf->delta_inf);
		}
		else if (!strncmp(char_buffer,"delta_disp",10))
		{
			strcpy(conf->delta_disp,char_buffer+11);
			syslog(LOG_INFO,"delta_disp=%s",conf->delta_disp);
		}
		else if (!strncmp(char_buffer,"bias",4))
		{
			strcpy(conf->bias,char_buffer+5);
			syslog(LOG_INFO,"delta_bias=%s",conf->bias);
		}
		else if (!strncmp(char_buffer,"decayment",9))
		{
			strcpy(conf->decayment,char_buffer+10);
			syslog(LOG_INFO,"decayment=%s",conf->decayment);
		}
		
		if (action == 1) //neural network mode
		{
			if (!strncmp(char_buffer,"layers",6))
			{
				strcpy(conf->layers,char_buffer);		//requires complete buffer to load_vector
				syslog(LOG_INFO,"%s",conf->layers);
			}
		}
		else if (action == 2) //aggregative mode
		{
			if (!strncmp(char_buffer,"output_add",10))
			{
				strcpy(conf->output_add,char_buffer+11);
				syslog(LOG_INFO,"output_add=%s",conf->output_add);
				counter = 10;				// return value for output_add
			}
			if (!strncmp(char_buffer,"input_add",9))
			{
				strcpy(conf->input_add,char_buffer+10);		
				syslog(LOG_INFO,"input_add=%s",conf->input_add);
				counter = 11;				// return value for input_add
			}
			
			else if (!strncmp(char_buffer,"old_init1",9))
			{
				strcpy(conf->old_init1,char_buffer+10);		
				syslog(LOG_INFO,"old_init1=%s",conf->old_init1);
				counter = 20;				// return value for neural network add
			}
			else if (!strncmp(char_buffer,"old_init2",9))
			{
				strcpy(conf->old_init2,char_buffer+10);
				syslog(LOG_INFO,"old_init2=%s",conf->old_init2);
			}
			else if (!strncmp(char_buffer,"mode",4))
			{
				strcpy(conf->mode,char_buffer+5);	
				syslog(LOG_INFO,"mode=%s",conf->mode);
			}
			
		}
		return(counter);
	}
}
