/*  va_delete_io_block.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
if pos >= 0 then delete char_buffer in position "pos"
if pos < 0 remove everything

block->pack_vector is deleted always
*/

void * va_delete_io_block(int pos, struct io_block * block)
{
	int k;
	struct io_block * temp_block = NULL;
	
	if (pos >= block->num)
	{
		return(block);
	}
	else if ( pos >= 0 ) //delete in "pos" position
	{
		if (block->num > 1)
		{
			if (!(temp_block = (struct io_block *)va_calloc_io_block(block->num-1,
										block->buffsize, 0 ,temp_block) ))
			{
				syslog(LOG_CRIT,"Error va_calloc_io_block() in va_insert_io_block()");
				return(block);
			}
		
			for (k = 0; k< temp_block->num ; k++)
			{
				if (k < pos)
				{
					if (block->char_vector[k] != NULL)
					{
						strcpy(temp_block->char_vector[k],block->char_vector[k]);
					}
					else
					{
						free(temp_block->char_vector[k]);
						temp_block->char_vector[k]=NULL;
					}
				}
				else
				{
					if (block->char_vector[k+1] != NULL)
					{
						strcpy(temp_block->char_vector[k],block->char_vector[k+1]);
					}
					else
					{
						free(temp_block->char_vector[k]);
						temp_block->char_vector[k]=NULL;
					}
				}
			}
		}
		else 
		{
			if (!(temp_block = (struct io_block *)va_calloc_io_block(0, block->buffsize, 0, temp_block) ))
			{
				syslog(LOG_CRIT,"Error va_calloc_io_block() in va_insert_io_block()");
				return(block);
			}
		}
	}
	else if (pos < 0) // delete all
	{
		if (!(temp_block = (struct io_block *)va_calloc_io_block(0, 0, 0, temp_block) ))
		{
			syslog(LOG_CRIT,"Error va_calloc_io_block() in va_insert_io_block()");
			return(block);
		}
	}
	
	temp_block->connfd = block->connfd;
	block = (struct io_block *)va_free_io_block(block);
	block = temp_block;
	return(block);
	
}
