/*  aux_prot.h */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* 
preffix convention 

n_ = neuron
nn_ = neural network
ga_ = genetic algorithm
va_ = various

*/

extern int n_copy_neuron(struct neuron * origin, struct neuron * destiny);
extern int n_is_connected(struct neuron * neuron1, struct neuron * neuron2, int * con_match);
extern int n_is_above(struct neuron * neuron1, struct neuron * neuron2, int *not_equal);
extern int n_load_vector(int size, float * vector, char * char_buffer);
extern int n_load_int_vector(int size, int * vector, char * char_buffer);
extern int n_load_num_values_vector(char * char_buffer);
extern int n_load_connection(int dimension, struct connection * con, char * char_buffer);
extern int n_load_nn_config(struct nn_config *conf, const char * filename);
extern int n_load_nn_init_config(int action, char * char_buffer,struct nn_init_config *conf);
extern int n_sort_neuron_connections(struct neuron * neuron1);

extern int nn_back_propagation(struct neural_net * net, int num_elem_input);
extern int nn_dwrite_neural_net(struct neural_net * net, int descriptor);
extern int nn_fwrite_neural_net(struct neural_net * net,	const char *filename);
extern int nn_forward_propagation(struct neural_net * net, int num_elem_input);
extern int nn_load_input(float *input_buffer, int num_elem_input, struct io_connection * con);
extern int nn_load_output(float *output_buffer, int num_elem_output, struct io_connection * con);
extern int nn_sort_neuron_array(struct neural_net * net);
extern int nn_weight_update(struct neural_net * net, int num_elem_input, struct nn_config * conf);
extern int nn_write_neural_net(struct neural_net * net, struct io_connection * con );

extern int ga_client_command_parser(char char_buffer[BUFFSIZE]);
extern int ga_client_load_config(int argc, char * argv[], struct ga_client_config * conf);

extern int va_clean_char_buffer(char * char_buffer);
extern int va_coin_toss(int seed);
extern int va_dice_toss(int seed, int partition);
extern int va_dwrite_io_block(struct io_block * block);
extern int va_io_connect(struct io_connection * con);
extern int va_io_close(struct io_connection * con);

extern float n_derive(int delta_type, float net);

extern float nn_output_layer_error(struct neural_net * net,	int num_elem_output, float *output_buffer);

extern float va_rand_gen(int seed);

extern double n_threshold(int threshold_type, float net);

extern void ga_client_sig_chld_jump(int signo, siginfo_t * siginfo, void * ucontext);

extern void * n_calloc_connection(int dimension, int momentum);
extern void * n_calloc_neuron(int dimension, int momentum, int num_con);
extern void * n_free_neuron(struct neuron * neuron1);

extern void * nn_append_neuron(struct neural_net * parent1, struct neural_net * parent2);
extern void * nn_copy_neural_net(struct neural_net * origin, struct neural_net * destiny);
extern void * nn_dread_neural_net(struct neural_net * net,	int descriptor);
extern void * nn_fread_neural_net(struct neural_net * net,	const char * filename);
extern void * nn_free_neural_net(struct neural_net * target);
extern void * nn_read_neural_net(struct neural_net * net,	struct io_connection * con);

extern void * va_calloc_io_block(int num, struct io_block * block);
extern void * va_delete_io_block(int pos, struct io_block * block);
extern void * va_dread_io_block(struct io_block * block);
extern void * va_free_io_block(struct io_block * block);
extern void * va_insert_io_block(int pos, char char_buffer[BUFFSIZE], struct io_block * block);

extern ssize_t va_readn(int fd, void *vptr, size_t n);
extern ssize_t va_writen(int fd, const void *vptr, size_t n);
