/*  ga_client_command_parser.c */
/* 	Copyright 2004 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
0 = agr
1 = init
2 = train slave - test
3 = just train
4 = just test
100 = not command string
*/

int ga_client_command_parser(char char_buffer[BUFFSIZE])
{
	if(!(strncmp(char_buffer,"COMMAND",7) ))
	{
		return(100);
	}
	if(!(strncmp(char_buffer+8,"0",1) ))
	{
		return(0);
	}
	else if(!(strncmp(char_buffer+8,"1",1) ))
	{
		return(1);
	}
	else if(!(strncmp(char_buffer+8,"2",1) ))
	{
		return(2);
	}
	else if(!(strncmp(char_buffer+8,"3",1) ))
	{
		return(3);
	}
	else if(!(strncmp(char_buffer+8,"4",1) ))
	{
		return(4);
	}
	else
	{
		return(100);
	}
}
