/*  nn.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*****************************************/
/*
argc=4
argv=name conf_file neuron_array_init neuron_array_result

mode:
0 = production slave (test mode for ga_client)
1 = training
2 = production

*/
/*****************************************/


int main(int argc, char * argv[])
{
int k,l,m;
int num_neuron;
int num_pat;
int num_input;
int num_output;
int mode;
int counter;
int connfd;

float * input_buffer;
float * output_buffer;

struct nn_config conf;
struct neural_net * net;

struct io_connection input_con; //socket 
struct io_connection output_con;
struct io_connection init_con;
struct io_connection result_con;

float error,max_error;
float age_inf;

if (argc < 3)
{
	printf("Incorrect number of parameters\n");
	printf("For train / slave mode use:\n");
	printf("%s config_file neuron_array_init neuron_array_result\n\n",argv[0]);
	printf("For production use:\n");
	printf("%s config_file neuron_array_init\n",argv[0]);

	return(1);
}

openlog("nn_exec",LOG_PID,LOG_LOCAL2);

if (nn_load_nn_config(&conf,argv[1])<0)
{
	syslog(LOG_CRIT,"Error load config file: %s",strerror(errno));
	return(1);
}

num_pat=conf.num_pat;
num_input=conf.num_input;
num_output=conf.num_output;
mode = conf.mode;
age_inf = conf.age_inf;

if ((argc == 3) && (mode != 2))
{
	printf("Incorrect number of parameters\nFor production use:\n");
	printf("%s config_file neuron_array_init\n",argv[0]);
	return(1);
}

syslog(LOG_INFO,"num_pat=%d num_input=%d num_output=%d mode=%d age_inf=%f",
				num_pat,num_input,num_output,conf.mode,age_inf);
syslog(LOG_INFO,"input_preffix=%s output_preffix=%s",conf.input_preffix,conf.output_preffix);

/* Setting input and output connection parameters */
input_con.connected = 0; //not connected
input_con.io_flag = 0; //set for reading
input_con.fifo = 0; //input will not come from fifo

output_con.connected= 0;	//not connected
output_con.io_flag = 0; //set for reading
output_con.fifo = 0; //output will not come from fifo

if (conf.input_flag == 1) // input from file
{
	input_con.file = 1;
	input_con.socket = 0;
}
else	// input from socket
{
	input_con.socket = 1;
	input_con.file = 0;
	strcpy(input_con.ip,conf.server_ip_in);
	strcpy(input_con.port,conf.server_port_in);
}
if (conf.output_flag == 1)
{
	output_con.file = 1;
	output_con.socket = 0;
}
else
{
	output_con.socket = 1;
	output_con.file = 0;
	strcpy(output_con.ip,conf.server_ip_out);
	strcpy(output_con.port,conf.server_port_out);
}


/* Set parameters for init  connection */
init_con.connected = 0; //not connected
init_con.io_flag = 0; //set for reading
strcpy(argv[2],init_con.filename);

if (!strncmp(argv[2],"fifo",4) )
{
	init_con.fifo = 1; //read from fifo
	init_con.file = 0; //not file
	init_con.socket = 0; // nor socket
}
else
{
	init_con.fifo = 0; //read not from fifo
	init_con.file = 1; //read from file
	init_con.socket = 0; // not socket
}

/* Set parameters for result connection */
result_con.connected = 0; //not connected
result_con.io_flag = 1; //set for writting
strcpy(argv[3],init_con.filename);

/* in test mode, error is write always via fifo employing this */
if (!strncmp(argv[3],"fifo",4) ) 
{
	init_con.fifo = 1; //write from fifo
	init_con.file = 0; //not file
	init_con.socket = 0; // nor socket
}
else
{
	init_con.fifo = 0; //write not to fifo
	init_con.file = 1; //write to file
	init_con.socket = 0; // not socket
}

if (! (input_buffer=(float *)calloc(num_input,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc input_buffer");
	return(1);
}

if (! (output_buffer=(float *)calloc(num_output,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc output_buffer");
	return(1);
}

net = NULL;
/* Reading neural_net */
if (!(net = (struct neural_net *)nn_read_neural_net(net,&init_con) ))
{
	syslog(LOG_CRIT,"Error in fread_neural_net in nn_exec");
	return(1);
}
num_neuron = net->num_neuron;
va_io_close(&init_con);

/* Sorting neural_net */
nn_sort_neuron_array(net);
for (k=0; k< num_neuron; k++)
{
	n_sort_neuron_connections(net->neuron_array[k]);
	net->neuron_array[k]->clock=0;
	for (l=0; l< net->neuron_array[k]->num_con; l++)
	{
		net->neuron_array[k]->con[l]->clock=0;
	}
}


/* Start reading for type 1 */
counter = 0;
if (net->type == 1)
{
	while(1) // Propagate until get output in the last neuron
	{
		sprintf(input_con.filename,"%s%d",conf.input_preffix,counter);
		input_con.req = counter;
		
		if (nn_load_input(input_buffer,num_input,&input_con) != 0)
		{
			syslog(LOG_CRIT,"Error load_input() %d: %s",counter,strerror(errno));
			return(1);
		}
		counter += 1;

		for (l=0; l<num_input; l++)
		{
			net->neuron_array[l]->value = input_buffer[l];
			net->neuron_array[l]->clock = 1;
		}
		if (nn_forward_propagation(net,num_input) == 1)
		{
			syslog(LOG_INFO,"First output after %d input",counter - 1);
			break;
		}
	}
}		

/* Now everything like always */
for (k=counter; k<num_pat; k++)
{
	sprintf(input_con.filename,"%s%d",conf.input_preffix,k);
	input_con.req = k;	
	if (nn_load_input(input_buffer,num_input,&input_con) != 0)
	{
		syslog(LOG_CRIT,"Error load_input() %d: %s",k,strerror(errno));
		return(1);
	}
	
	for (l=0; l<num_input; l++)
	{
		net->neuron_array[l]->value = input_buffer[l];
	}
	
	sprintf(output_con.filename,"%s%d",conf.output_preffix,(k-counter));
	output_con.req = (k-counter);
	if (nn_load_output(output_buffer,num_output,&output_con) < 0)
	{
		syslog(LOG_CRIT,"Error load_output() %d: %s",(k-counter),strerror(errno));
		return(1);
	}

	nn_forward_propagation(net,num_input);
	error = nn_output_layer_error(net,num_output,output_buffer);
	syslog(LOG_INFO,"pattern=%d error=%f",k,error);
	
	if (mode == 0) // mode 0 = test slave mode
	{
		va_io_connect(&result_con);
		sprintf(char_buffer,"error=%f\0",error);
		if (writen(result_con.connfd,char_buffer,BUFFSIZE) < 1)
		{
			syslog(LOG_CRIT,"Error writting error to result_con.connfd");
			return(1);
		}
	}
	else if (mode == 1) //mode 1 = training
	{
		nn_back_propagation(net,num_input);
		nn_weight_update(net,num_input,&conf);
	}
	else if (mode == 2) //mode 2 = production
	{	
		for (l=0; l<num_output; l++)
		{
			syslog(LOG_INFO,"Pattern: %d Output[%d]: %f Desired[%d]: %f\n",k,l,
			net->neuron_array[num_neuron-num_output+l-1]->value,l,output_buffer[l]);
		}
		syslog(LOG_INFO,"Error=%f",error);
	}
}

if ( nn_write_neural_net(net,&result_con) < 0)
{
	syslog(LOG_CRIT,"Error write_neural_net() %s",strerror(errno));
	return(1);
}
va_io_close(&result_con);
va_io_close(&input_con);
va_io_close(&output_con);

/*
if (mode == 0)
{
	syslog(LOG_INFO,"Writting to descriptor %d %s",connfd,argv[3]);
	if(	nn_dwrite_neural_net(net,connfd)< 0)
	{
		syslog(LOG_CRIT,"Error dwrite_neural_net() %s",strerror(errno));
		return(1);
	}
	close(connfd);
}
else if (mode == 1)
{
	syslog(LOG_INFO,"Writting to file %s",argv[3]);
	if(	nn_fwrite_neural_net(net,argv[3])< 0)
	{
		syslog(LOG_CRIT,"Error fwrite_neural_net() %s: %s",argv[3],strerror(errno));
		return(1);
	}
}
*/

syslog(LOG_INFO,"***** Exiting *****");

exit(0);
}
