/*  my_header.h */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <netdb.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>
#include <fcntl.h>
#include <setjmp.h>

#include "stdlib.h"
#include "stdio.h"
#include "math.h"
#include "strings.h"

#define BUFFSIZE 256
#define LISTENQ 1024
#define FILE_MODE (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)
#define MAX_RETRY 5

#define NUM_TYPE 2
#define MAX_MOMENTUM 2
#define MAX_DELTA_DISP 3
#define MAX_DELTA_INF 2
#define PI 3.141592653589
#define SATURATION 1e21

char char_buffer[BUFFSIZE];
char ** char_vector;

/*
ga_errno:

0 = no error
1 = memory allocation error
*/

int ga_errno;

struct nn_config
{
	int num_pat;
	int num_input;
	int num_output;
	
	int mode; //mode type
	int input_flag; // 1 = file  ; 0 = socket
	int output_flag; // 1 = file  ; 0 = socket
	
	float age_inf;	//age influence
	
	char input_preffix[BUFFSIZE];
	char output_preffix[BUFFSIZE];

	char server_ip_in[BUFFSIZE];
	char server_port_in[BUFFSIZE];
	
	char server_ip_out[BUFFSIZE];
	char server_port_out[BUFFSIZE];
};

/* Configuration structure for nn_init config */
/* Requires storage in char format, since it could be "rr" or the real value */
struct nn_init_config
{
	char init_filename[BUFFSIZE];
	char dimension[BUFFSIZE];
	char type[BUFFSIZE];
	char momentum[BUFFSIZE];
	char alpha[BUFFSIZE];
	char conv_rate[BUFFSIZE];
	char bias_corr[BUFFSIZE];
	char delta_type[BUFFSIZE];
	char delta_inf[BUFFSIZE];
	char delta_disp[BUFFSIZE];
	char bias[BUFFSIZE];
	char decayment[BUFFSIZE];
	char layers[BUFFSIZE];
	char output_add[BUFFSIZE];
	char input_add[BUFFSIZE];
	char old_init1[BUFFSIZE];
	char old_init2[BUFFSIZE];
	char mode[BUFFSIZE];			//0:full network, 1:share output, 2:share input
	int num_param;
};	

/* genetic algorithm server configuration structure */
struct ga_server_config
{	
	int timestamp;
	int time_wait;
	int master;

	char message[BUFFSIZE];

	char ip[BUFFSIZE];
	char init_preffix[BUFFSIZE];
	char result_preffix[BUFFSIZE];
	char ** hosts;
	char ** niches;

	unsigned int remote_server_port;
	unsigned int local_server_port;
	
	int max_local;
	int first_local;
	int last_local;
	int num_hosts;
	int num_niche;

	int poblation;
	int generations;
	int max_neuron_mut;
	int max_num_layer;
	int max_num_neuron;
	int agr;
	int age;
	
	float mut_new_prob;
	float mut_neuron_prob;
	float mut_net_prob;
	float inm_prob;
	float lifespan;
	float base;
	float boost;
	float level;
	
	float prob_alpha;
	float prob_conv_rate;
	float prob_bias_corr;
	float prob_delta_type;
	float prob_momentum;
	float prob_num_con;
	float prob_bias;
};

/* client configuration structure */
struct ga_client_config
{
	int client_id; //client unique number
	int mode;		//0=init, 1=agr, 2=train, 3=test
	
	int idle_flag;
	int exit_flag;
	int ret_flag;
	int last_flag;
	int conn_flag;
	
	int fifo_init;
	int fifo_result;
	
	char server_ip[BUFFSIZE];
	char server_port[BUFFSIZE];
	
	char init_preffix[BUFFSIZE];
	char result_preffix[BUFFSIZE];
};

struct neuron
{
	float conv_rate;	//convergence rate
	float bias;				//bias input
	float decayment;	//memory decayment value (zero if no decayment)
	float delta_disp;
	float delta_inf;

	int clock;			//clock tick
	int block;			//Marker for blocks, non volatile, values same as inner
									//11 = block inner : 12 = block lower : 13 = block upper : 14 = 12 and 13
	int bias_corr;	//just zero or one
	int delta_type;	//less than NUM_TYPE
	int momentum;		//momentum level
	int dimension; 	//neuron dimension space
	int num_con;		//number of conected elements
	int inner;			//0 = not inner : 1 = inner : 2 = lower border : 3 = upper border : 4 = 2 and 3
									//11 = block inner : 12 = block lower : 13 = block upper : 14 = 12 and 13
	float * range;		//range of connection, depends on dimension
	float * x_c;			//coordinate array, depends on dimension
	float * alpha;		//One value per momentum level

	struct connection ** con;
	
	double value;		//network value
	double p_value; //previus value
	double delta;		//error value
};

/* neuron connection */
struct connection
{
	int age;
	int clock;
	float buffer;
	double weight;
	float * con_x;						//Size depends on dimension
	double * delta_weight;  		//Size depends on momentum
};

/* neural net parameters */
struct neural_net
{
	struct neuron ** neuron_array;
	int num_neuron;
	int num_input;
	int num_output;
	int age;
	int dimension;
	int type;				//0 = classic; 1 = input drive
};


/* io connection */
/*
connection mode: 
10 = socket unix read/write
20 = socket inet read/write
30 = fifo read
31 = fifo write
40 = FILE read
41 = FILE write
42 = FILE read/write
*/

struct io_connection
{
	FILE * file_ptr;

	int mode;				//connection mode
	int connected;	//1=already connected, 0=not connected
	int io_flag; 		//0=input, 1=output, 2=both
	int socket; //socket flag
	int fifo;   //fifo flag
	int file;		//file flag
	int local;	//1=socket unix, 0=socket inet

	int connfd;	//socket descriptor
	int number;	//client number
	int req;		//requisition number

	char filename[BUFFSIZE];		
	char ip[BUFFSIZE];
	char port[BUFFSIZE];
	
	struct sockaddr_un cliaddr_un;
	struct sockaddr_in cliaddr_in;
};

struct io_block
{
	int num;
	int connfd;
	char ** char_vector;
};


