/*  n_copy_neuron.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Origin and destiny should have the same size */

int n_copy_neuron(struct neuron * origin, struct neuron * destiny)
{
	int k,l;

	destiny->dimension = 		origin->dimension;
	destiny->conv_rate = 		origin->conv_rate;
	destiny->bias_corr = 		origin->bias_corr;
	destiny->delta_type = 	origin->delta_type;
	destiny->delta_inf = 		origin->delta_inf;
	destiny->delta_disp = 	origin->delta_disp;
	destiny->momentum = 		origin->momentum;
	destiny->num_con = 			origin->num_con;
	destiny->bias =					origin->bias;
	destiny->inner =				origin->inner;
	destiny->block =				origin->block;
	destiny->decayment = 		origin->decayment;
	
	destiny->value =				origin->value;
	destiny->delta =				origin->delta;
	destiny->p_value =			origin->p_value;
	
	for (k=0; k< origin->dimension; k++)
	{
		destiny->x_c[k] = origin->x_c[k];
		destiny->range[k] = origin->range[k];
		for (l=0;l < origin->num_con; l++)
		{
			destiny->con[l]->con_x[k] = origin->con[l]->con_x[k];
		}		
	}
	
	for (k=0; k< origin->momentum; k++)
	{
		destiny->alpha[k] = origin->alpha[k];
		for (l=0;l < origin->num_con; l++)
		{
			destiny->con[l]->delta_weight[k] = origin->con[l]->delta_weight[k];
		}		
	}
		
	for (k=0; k < origin->num_con; k++)
	{
		destiny->con[k]->age = origin->con[k]->age;
		destiny->con[k]->weight = origin->con[k]->weight;
	}
	return(0);
}
