/*  n_is_above.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
0 = neuron1 above neuron2
1 = neuron2 above neuron1
10 = collision

not_equal = number of the first non equal coordinate, no change if below or collision

No tolerance add
*/
int n_is_above(struct neuron * neuron1, struct neuron * neuron2, int *not_equal)
{
	int dimension;
	int equal;
	int k;
	
	dimension = neuron1->dimension;
	
	equal = 0;
	for (k=0; k< dimension; k++)	
	{
		if (neuron1->x_c[k] == neuron2->x_c[k])
		{
			equal += 1;
		}
		if (neuron1->x_c[k] > neuron2->x_c[k])
		{
			if (equal == k)
			{
				if (not_equal != NULL)
				{
					*not_equal = k;
				}
				return(0);
			}
		}
	}

	if (equal == dimension) 
	{
		return(10);
	}
	else 
	{
		return(1); 
	}
}
