/*  nn_forward_propagation.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int nn_forward_propagation(struct neural_net * net, int num_elem_input)
{
	int k,l,m;
	int num_neuron;
	int number;
	int type_mode;
	int counter;
	int out_flag;

	double value;
	double p_value;
	
	type_mode = net->type;
	num_neuron = net->num_neuron;
	out_flag = 0;
	
	if (type_mode == 0) //normal operation
	{
		for ( k=num_elem_input; k< num_neuron ; k++ )
		{
			value = net->neuron_array[k]->bias;
			counter = 0;
			for(l = 0; l< num_neuron; l++) 
			{
				if ((n_is_above(net->neuron_array[k],net->neuron_array[l], NULL) == 0) && 
						(n_is_connected(net->neuron_array[l],net->neuron_array[k], &number)> 0) )
				{
					value += (net->neuron_array[k]->con[number]->weight)*
										(net->neuron_array[l]->value);
					counter += 1;
				}
			}
			net->neuron_array[k]->value = n_threshold(net->neuron_array[k]->delta_type,value);
			
			if ( isnan(net->neuron_array[k]->value))
			{
				syslog(LOG_INFO,"net->neuron_array[%d]->value=NAN value=%f delta_type=%d bias=%f",
								k,value,net->neuron_array[k]->delta_type,net->neuron_array[k]->bias);
			}
			
		}
		return(0);	
	}
	else if (type_mode == 1)
	{
		for (k= (num_neuron-1); k+1; k--)
		{
			value = net->neuron_array[k]->bias;
			counter = 0;
			for (l= 0; l< num_neuron; l++)
			{
				if ((n_is_above(net->neuron_array[k],net->neuron_array[l], NULL) == 0) && 
						(n_is_connected(net->neuron_array[l],net->neuron_array[k], &number)> 0) &&
						(net->neuron_array[l]->clock > 0) )
				{
					value += (net->neuron_array[k]->con[number]->weight)*
										(net->neuron_array[l]->value);
					net->neuron_array[k]->con[number]->clock += 1;
					counter += 1;
					
					if (k == (num_neuron-1))
					{
//						syslog(LOG_INFO,"out_flag set k=%d l=%d clock=%d",k,l,net->neuron_array[l]->clock);
						out_flag = 1;
					}
				}
			}
			if (counter > 0)
			{
				net->neuron_array[k]->clock += 1;
				net->neuron_array[k]->p_value = net->neuron_array[k]->value;
				net->neuron_array[k]->value = n_threshold(net->neuron_array[k]->delta_type,value);
				
				if ( isnan(net->neuron_array[k]->value))
				{
				syslog(LOG_INFO,"net->neuron_array[%d]->value=NAN value=%f delta_type=%d bias=%f",
								k,value,net->neuron_array[k]->delta_type,net->neuron_array[k]->bias);
				}
			}
		}
		if (out_flag == 1)
		{
			return(1);
		}
		else
		{
			return(0);			
		}
	}
}
