/*  va_dwrite_io_block.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
First element should be always NUM, so in case num isn't in block, 
function sent block num+1 first, it doesn't affect block size
*/
int va_dwrite_io_block(struct io_block * block)
{
	int k;
	char char_temp[BUFFSIZE];
	
	/* Write num before anything else in case not contained in char_vector */
	if (!strncmp(block->char_vector[0],"NUM",3))
	{
		sprintf(char_temp,"NUM=%d\0",block->num+1);
		if(writen(block->connfd,block->char_vector[k],BUFFSIZE) < 1)
		{
			syslog(LOG_CRIT,"Error writen() in va_dwrite_io_block %s",strerror(errno));
			return(-1);
		}
	}
	
	/* Write everything else */
	for (k=0; k< block->num ; k++)
	{
		if (block->char_vector[k] != NULL)
		{
			if(writen(block->connfd,block->char_vector[k],BUFFSIZE) < 1)
			{
				syslog(LOG_CRIT,"Error writen() in va_dwrite_io_block %s",strerror(errno));
				return(-1);
			}
		}
		else
		{
			syslog(LOG_INFO,"block->char_vector[%d] = NULL");
			strcpy(char_temp,"NULL\0");
			if(writen(block->connfd,char_temp,BUFFSIZE) < 1)
			{
				syslog(LOG_CRIT,"Error writen() in va_dwrite_io_block %s",strerror(errno));
				return(-1);
			}
		}
	}
	return(0);
}
