/*  sort_neuron_connections.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int sort_neuron_connections(struct neuron * neuron_unit)
{
	int k,l,m;
	int age;
	float max_x, max_y;
	float con_x;
	float con_y;
	double con_w;
	double delta_con_w;
	
	if (!neuron_unit->num_con)
	{
//		syslog(LOG_INFO,"No connections to sort");
		return(2);
	}

	for (k=neuron_unit->num_con; k ; k--)
	{
		max_x=0;
		max_y=0;
		for (l=0; l<k; l++)
		{
			if (*(neuron_unit->con_x+l) > max_x) 
			{
				max_x = *(neuron_unit->con_x+l);
				max_y = *(neuron_unit->con_y+l);
				m = l;
			}
			else if ( (*(neuron_unit->con_x+l) == max_x) && (*(neuron_unit->con_y+l) >= max_y) )
			{
				max_y = *(neuron_unit->con_y+l);
				m = l;
			}
		}

		con_x = *(neuron_unit->con_x + k - 1);
		*(neuron_unit->con_x + k - 1) = *(neuron_unit->con_x + m);
		*(neuron_unit->con_x + m) = con_x;

		con_y = *(neuron_unit->con_y + k - 1);
		*(neuron_unit->con_y + k - 1) = *(neuron_unit->con_y + m);
		*(neuron_unit->con_y + m) = con_y;

		con_w = *(neuron_unit->con_w + k - 1);
		*(neuron_unit->con_w + k - 1) = *(neuron_unit->con_w + m);
		*(neuron_unit->con_w + m) = con_w;
		
		age = *(neuron_unit->age + k - 1);
		*(neuron_unit->age + k - 1) = *(neuron_unit->age + m);
		*(neuron_unit->age + m) = age;
		
		if (neuron_unit->momentum == 1)
		{
			delta_con_w = *(neuron_unit->delta_con_w + k - 1);
			*(neuron_unit->delta_con_w + k - 1) = *(neuron_unit->delta_con_w + m);
			*(neuron_unit->delta_con_w + m) = delta_con_w;
		}
	}
	return(1);	
}
