<?PHP
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Free Web Based Training System                          //
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Plate-forme de tlformation gratuite et en open source //
// ------------------------------------------------------------------------- //
// Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>          //
// ------------------------------------------------------------------------- //
//            Developer : Georges CALDEIRA <gcaldeira@anemalab.org>          //
// ------------------------------------------------------------------------- //
//               Infos on project <http://anemalab.org/>                     //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //

/**
* Page module de la partie Admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaAdmin
*/
	/**
	* include des fichiers + verification de la cnx
	*/
	include_once("anema.inc.php");

	debugf(__FILE__);
	
	/**#@+
    * @access public
	* @ignore
	*/
	define('SUBMENU',	MENU_MODULE);
	define('ACTION',	(isset($HTTP_GET_VARS['action'])?$HTTP_GET_VARS['action']:''))	;
	define('ID',		(isset($HTTP_GET_VARS['id'])?$HTTP_GET_VARS['id']:''))			;
	define('NUMERO',	(isset($HTTP_GET_VARS['numero'])?$HTTP_GET_VARS['numero']:''))	;	
	define('PAGE',		HTTP_ADMIN.$PAGE_ADMIN[SUBMENU]."?connexion=".$gconnexionid)	;
	define('PAGE_DIR',	HTTP_COMMUN."p_filemanager.php?connexion=".$gconnexionid)	;
	define('IMAGE_MODULE',	'<img align="absmiddle" src="'.HTTP_IMAGES.'module.gif" border="0">') ;
	/**#@-*/
	
/**
* Gestion de la page module de l'admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaAdmin
*/
class PageModuleAdmin {
		
	/**
	* Affiche la liste des societes
	* @access	public
	*/
	function liste() { 
		global $TBL, $db, $gconnexionid, $PAGE_ADMIN, $ad_menu, $ClsModule, $color2, $color1, $ad_form, $ad_titre ;
	    GetTitre($ad_menu[1]) 	;

		$ajouter	= PAGE.'&action=add';
		$file		= PAGE_DIR.'&cmd='.CMD_LIST_FORMATION;
		$manager 	= "onClick=\"openWindow('".$file."','filemanager','scrollbars=yes,width=500,height=590')\" ";

		put('<center><a class="student" href="'.$ajouter.'" >'.IMG_ADD.$ad_titre['ajtmodule'].'</a>');
		put('&nbsp;&nbsp;<a class="student" href="#" '.$manager.'>'.IMG_FILE.' '.$ad_titre['managfile'].'</a></center>');						
		BR();

	    $mod = $ClsModule->read();
        for($i=0;$i<$mod['cnt'];$i++)  {
        	SubTitleImage(' '.CSS(Unreplace($mod[$i]['titre'])).' ['.CSS(Unreplace($mod[$i]['code'])).']',IMAGE_MODULE);
            $modif	= PAGE.'&action=modif&id='.$mod[$i]['id'];
			$lmodif	= '<a href="'.$modif.'" >'.IMG_MODIF.'</a>';
			$del	= PAGE.'&action=delete&id='.$mod[$i]['id'];
			$ldel	= '<a href="#" onclick="DeleteItem(\''.$del.'\');" >'.IMG_DEL.'</a>';
			put('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$lmodif.'&nbsp;&nbsp;'.$ldel.'<br>');

        	InitTableau() 	;
            DebutLigne(false) ;
			$modif 	= PAGE.'&action=modif&id='.$mod[$i]['id'];
            TitreTableau($ad_form['chapitre'],40);
            TitreTableau($ad_form['fichier'],30);
            TitreTableau($ad_form['norme'],20);
            TitreTableau($ad_form['type'],10);
            FinLigne() ;

            $detail = $ClsModule->readModule($mod[$i]['id']);  
	        for($j=0;$j<$detail['cnt'];$j++)  {
		        DebutLigne() ;
				//$txt = $detail[$j]['numero'].'&nbsp;-&nbsp;'.Unreplace($detail[$j]['titre']) ;
				ColTableau(CSS($detail[$j]['numero'].' - '.$detail[$j]['titre']));
				ColTableau(CSS($detail[$j]['link']));
				if ( $detail[$j]['numero'] == 0 ) {
					ColTableau('&nbsp;');
					ColTableau('&nbsp;');
				} else {
					ColTableau($ClsModule->norme($detail[$j]['norme']));
					ColTableau($ClsModule->type($detail[$j]['type']));
				}
		        FinLigne() ;
			}
			FermeTableau();
			BR();
        }
        GoTop()	;
     }

	/**
	* Supprime un item de la table
	* @access	public
	*/
	function del() {
		$this->liste() ;
	}

	/**
	* Affiche un formulaire pour modifier une societe
	* @access	public
	*/
     function modif() { 
		global $ad_menu, $ClsModule, $color1, $color2, $color3, $color4a, $ad_texte, $ad_form ;
		$ret = $ClsModule->info(ID);
	    GetTitre($ad_menu[3]) ;
		GoBack() ;
		// Configue generale du module ....
		BeginBorder("90%",$color1);	
        SubTitleImage(CSS(Unreplace($ret['titre'])),IMAGE_MODULE) ;
		BeginFormulaire(PAGE.'&action=modif&id='.ID,'module',$color2);
		AddText($ad_texte['titre'],$ret['titre'],1)	;
		AddText( $ad_texte['codemodule'],Unreplace($ret['code']),3,false,10) ;
		AddListeAuteur($ret['auteur'],false);
		AddTextFile($ad_texte['support'],$ClsModule->Support(ID),2,CMD_FILE_FORMATION,false,'module');
		EndFormulaire('VerifAddModule',$color1)		;
		CloseBorder();
		BR();
		// Lister les chapitres....
        $detail = $ClsModule->readModule(ID);  
        for($j=0;$j<$detail['cnt'];$j++)  {
        	if ( $detail[$j]['numero'] == 0 ) continue ;
        	BeginBorder("90%",$color3);	
        	$numero = $detail[$j]['numero'] ;
        	if ( $detail[$j]['type'] == QUIZZ ) {
        		SubTitleImage(CSS($numero. ' - '.Unreplace($detail[$j]['titre'])),IMG_QUIZZ) ;        	
        	}elseif( $detail[$j]['type'] == DOCUMENT ) {
        		SubTitleImage(CSS($numero. ' - '.Unreplace($detail[$j]['titre'])),IMG_DOC) ;        	
        	}else {
        		SubTitle('&nbsp;'.CSS($numero. ' - '.Unreplace($detail[$j]['titre']))) ;        	
        	}
        	
			$delchap	= PAGE.'&action=deletechapitre&id='.ID.'&numero='.$detail[$j]['numero'];
			$ldelchap	= '<a href="#" onclick="DeleteItem(\''.$delchap.'\');" >'.IMG_DEL.'</a>';
			put('&nbsp;&nbsp;'.$ldelchap);
			$up		= PAGE.'&action=up&id='.ID.'&numero='.$detail[$j]['numero'];
			$up 	= '&nbsp;<a href="'.$up.'" >'.IMG_UP.'</a>';
			$down	= PAGE.'&action=down&id='.ID.'&numero='.$detail[$j]['numero'];
			$down 	= '&nbsp;<a href="'.$down.'" >'.IMG_DOWN.'</a>';
			
			if ( $numero == 1 ) {
				if ( $detail['cnt']  <> 1 ) {
					put($down);
				}
			}elseif ( $numero == ($detail['cnt']-1)) {
				put($up);	
			} else {
				put($down.$up);				
			}

        	$url = PAGE.'&action=modifchapitre&numero='.$detail[$j]['numero'].'&id='.ID ;
			BeginFormulaire($url,'chapitre'.$j,$color2)	;
			ListeNorme($detail[$j]['norme'],true)		;
			ListeTypeChapitre($detail[$j]['type'])		;
			AddText($ad_texte['chapitre'],$detail[$j]['titre'],1)	;
			AddTextFile($ad_texte['fichier'],$detail[$j]['link'],2,CMD_FILE_FORMATION,true,'chapitre'.$j)	;	
			EndFormulaire('VerifChapitre',$color3)	;				        	
			CloseBorder();
		}
		BR();
		// un nouveau chapitre....
		BeginBorder("90%",$color2);	
        SubTitleImage($ad_form['ajtchapitre'],IMG_ADD) ;
		BeginFormulaire(PAGE.'&action=addchapitre&id='.ID,'',$color1)	;				
		ListeNorme(0,true)			;
		ListeTypeChapitre(0)		;
		AddText($ad_texte['chapitre'],'',1)	;
		AddTextFile($ad_texte['fichier'],'',2,CMD_FILE_FORMATION,true)	;	
		EndFormulaire('VerifChapitre',$color1)	;	
		CloseBorder();		
		GoTop();
     }

	/**
	* Affiche un formulaire pour une societe
	* @access	public
	*/
	function add() {
		global $ad_menu, $ad_texte, $ad_titre ;	
	    GetTitre($ad_menu[2]);
		GoBack() ;
		$url = PAGE_DIR.'&cmd='.CMD_LIST_FORMATION ;
		$creation = "onClick=\"openWindow('".$url."','filemanager','scrollbars=yes,width=500,height=590')\" ";
		put('&nbsp;&nbsp;<a class="student" href="#" '.$creation.'>'.IMG_FILE.' '.$ad_titre['managfile'].'</a>');				
		BeginFormulaire(PAGE.'&action=add');				
		AddText($ad_texte['titre'],'',1)		;
		AddText( $ad_texte['codemodule'],'',3,false,10) ;
		AddListeAuteur(AUCUN,false)	;
		AddTextFile($ad_texte['support'],'',2,CMD_FILE_FORMATION,false);
		EndFormulaire('VerifAddModule')	;
		GoTop();
	}

	/**
	* Traitement des variables POST et redirection
	* @access	public
	*/	
	function traite_post() {
		global $HTTP_POST_VARS, $ClsAdmin ;
		if (count($HTTP_POST_VARS) > 0) {
			switch(ACTION) {
			case 'add'	:				
				$titre 	= $HTTP_POST_VARS['text1']	;
				$support= $HTTP_POST_VARS['text2']	;
				$code 	= $HTTP_POST_VARS['text3']	;				
				$aut 	= $HTTP_POST_VARS['LAuteur'];
				$id 	= $ClsAdmin->ajouterUnModule($titre,$code,$aut,$support);
				location(PAGE.'&action=modif&id='.$id)	;
				exit();
				break;
			case 'addchapitre':
				//debug($HTTP_POST_VARS);
    			$norme	= $HTTP_POST_VARS['LNorme']	;
    			$type	= $HTTP_POST_VARS['LType']	;
    			$chap	= $HTTP_POST_VARS['text1']	;
    			$fic	= $HTTP_POST_VARS['text2']	;
				$ClsAdmin->ajouterUnChapitre(ID,$norme,$type,$chap,$fic);
				location(PAGE.'&action=modif&id='.ID)	;
				exit();
				break;				
			case 'modif':	
				$titre 	= $HTTP_POST_VARS['text1']	;
				$support= $HTTP_POST_VARS['text2']	;
				$code 	= $HTTP_POST_VARS['text3']	;	
				$aut 	= $HTTP_POST_VARS['LAuteur'];			
				$ClsAdmin->modifierUnModule(ID,$titre,$code,$aut,$support);
				location(PAGE.'&action=modif&id='.ID);
				exit();
				break;			
			case 'modifchapitre':	
    			$norme	= $HTTP_POST_VARS['LNorme']	;
    			$type	= $HTTP_POST_VARS['LType']	;
    			$chap	= $HTTP_POST_VARS['text1']	;
    			$fic	= $HTTP_POST_VARS['text2']	;    			
    			//debug($HTTP_POST_VARS);
				$ClsAdmin->modifierUnChapitre(ID,NUMERO,$norme,$type,$chap,$fic);
				location(PAGE.'&action=modif&id='.ID);
				exit();
				break;				
			}
		}
	}

	/**
	* Traitement des variables GET et redirection
	* @access	public
	*/		
	function traite_get() {
		global $ClsAdmin ;
		if (is_numeric(ID) ) {
			switch(ACTION) {
			case 'delete':	
				$ClsAdmin->SupprimerUnModule(ID) ;
				location(PAGE.'&action=liste');
				exit();
				break;
			case 'deletechapitre':	
				$ClsAdmin->SupprimerUnChapitre(ID,NUMERO) ;
				location(PAGE.'&action=modif&id='.ID);
				exit();
				break;
			case 'down':	
				$ClsAdmin->augmenterNumeroChapitre(ID,NUMERO) ;
				location(PAGE.'&action=modif&id='.ID);
				exit();
				break;			
			case 'up':	
				$ClsAdmin->diminuerNumeroChapitre(ID,NUMERO) ;
				location(PAGE.'&action=modif&id='.ID);
				exit();
				break;							
			}
		}
	}

} // class 


/**
* Instance de la classe PageModuleAdmin
* @var	object	PageModuleAdmin
*/
$ClsPageAdmin = new PageModuleAdmin ;


	// Affichage de la page
	pageAdmin();

?>